"use strict";
// tslint:disable:no-console
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = async (event, _context = {}) => {
    const authToken = event.authorizationToken;
    console.log(`event.authorizationToken = ${authToken}`);
    if (authToken === 'allow' || authToken === 'deny') {
        return {
            principalId: 'user',
            policyDocument: {
                Version: '2012-10-17',
                Statement: [
                    {
                        Action: 'execute-api:Invoke',
                        Effect: authToken,
                        Resource: event.methodArn
                    }
                ]
            }
        };
    }
    else {
        throw new Error('Unauthorized');
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsNEJBQTRCOztBQUVmLFFBQUEsT0FBTyxHQUFHLEtBQUssRUFBRSxLQUFVLEVBQUUsV0FBZ0IsRUFBRSxFQUFnQixFQUFFO0lBQzVFLE1BQU0sU0FBUyxHQUFXLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQztJQUNuRCxPQUFPLENBQUMsR0FBRyxDQUFDLDhCQUE4QixTQUFTLEVBQUUsQ0FBQyxDQUFDO0lBQ3ZELElBQUksU0FBUyxLQUFLLE9BQU8sSUFBSSxTQUFTLEtBQUssTUFBTSxFQUFFO1FBQ2pELE9BQU87WUFDTCxXQUFXLEVBQUUsTUFBTTtZQUNuQixjQUFjLEVBQUU7Z0JBQ2QsT0FBTyxFQUFFLFlBQVk7Z0JBQ3JCLFNBQVMsRUFBRTtvQkFDVDt3QkFDRSxNQUFNLEVBQUUsb0JBQW9CO3dCQUM1QixNQUFNLEVBQUUsU0FBUzt3QkFDakIsUUFBUSxFQUFFLEtBQUssQ0FBQyxTQUFTO3FCQUMxQjtpQkFDRjthQUNGO1NBQ0YsQ0FBQztLQUNIO1NBQU07UUFDTCxNQUFNLElBQUksS0FBSyxDQUFDLGNBQWMsQ0FBQyxDQUFDO0tBQ2pDO0FBQ0gsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gdHNsaW50OmRpc2FibGU6bm8tY29uc29sZVxuXG5leHBvcnQgY29uc3QgaGFuZGxlciA9IGFzeW5jIChldmVudDogYW55LCBfY29udGV4dDogYW55ID0ge30pOiBQcm9taXNlPGFueT4gPT4ge1xuICBjb25zdCBhdXRoVG9rZW46IHN0cmluZyA9IGV2ZW50LmF1dGhvcml6YXRpb25Ub2tlbjtcbiAgY29uc29sZS5sb2coYGV2ZW50LmF1dGhvcml6YXRpb25Ub2tlbiA9ICR7YXV0aFRva2VufWApO1xuICBpZiAoYXV0aFRva2VuID09PSAnYWxsb3cnIHx8IGF1dGhUb2tlbiA9PT0gJ2RlbnknKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHByaW5jaXBhbElkOiAndXNlcicsXG4gICAgICBwb2xpY3lEb2N1bWVudDoge1xuICAgICAgICBWZXJzaW9uOiAnMjAxMi0xMC0xNycsXG4gICAgICAgIFN0YXRlbWVudDogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIEFjdGlvbjogJ2V4ZWN1dGUtYXBpOkludm9rZScsXG4gICAgICAgICAgICBFZmZlY3Q6IGF1dGhUb2tlbixcbiAgICAgICAgICAgIFJlc291cmNlOiBldmVudC5tZXRob2RBcm5cbiAgICAgICAgICB9XG4gICAgICAgIF1cbiAgICAgIH1cbiAgICB9O1xuICB9IGVsc2Uge1xuICAgIHRocm93IG5ldyBFcnJvcignVW5hdXRob3JpemVkJyk7XG4gIH1cbn07XG4iXX0=