"use strict";
/// !cdk-integ *
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const apig = require("../lib");
class FirstStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.firstLambda = new lambda.Function(this, 'firstLambda', {
            functionName: 'FirstLambda',
            code: lambda.Code.fromInline(`exports.handler = async function(event) {
          return  {
            'headers': { 'Content-Type': 'text/plain' },
            'statusCode': 200
          }
        }`),
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS_10_X,
        });
    }
}
class SecondStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const api = new apig.RestApi(this, 'BooksApi', {
            restApiName: 'SecondRestAPI'
        });
        api.root.addMethod('ANY');
        const booksApi = api.root.addResource('books');
        const lambdaIntegration = new apig.LambdaIntegration(props.lambda);
        booksApi.addMethod('GET', lambdaIntegration);
    }
}
const app = new cdk.App();
const first = new FirstStack(app, 'FirstStack');
new SecondStack(app, 'SecondStack', { lambda: first.firstLambda });
app.synth();
//# sourceMappingURL=data:application/json;base64,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