"""
The script takes checkpoint generated by Pytorch Lightning and saves the checkpoint with a
checkpoint that contains only the weights.
"""

import argparse
from pathlib import Path

import torch


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        "-i", "--input_path", type=Path, help="Path to the weights from Pytorch_lightning.", required=True
    )
    parser.add_argument("-o", "--output_path", type=Path, help="Path to output file.", required=True)
    return parser.parse_args()


def clean_pytorch_lightning_checkpoint(input_path: Path, output_path: Path, key_to_keep: str = "state_dict") -> None:
    """Removes all key value pairs from the checkpoint dict, except one with weights.

    Args:
        input_path: path to the original PyTorch checkpoint.
        output_path: path to the resulting PyTorch checkpoint.
        key_to_keep: key pointing to the weights. Default: "state_dict"
    """
    checkpoint = torch.load(input_path)
    torch.save({key_to_keep: checkpoint[key_to_keep]}, output_path)


if __name__ == "__main__":
    args = parse_args()
    clean_pytorch_lightning_checkpoint(args.input_path, args.output_path)
