<p align="center">
  <a href="https://hotbox.corletti.xyz"><img src="https://github.com/anthonycorletti/hotbox/blob/main/docs/img/logo.png?raw=true" alt="hotbox"></a>
</p>
<p align="center">
    <em>🚀 Run your code 📦 on Firecracker MicroVMs 🔥 in the cloud ☁️</em>
</p>
<p align="center">
<a href="https://github.com/anthonycorletti/hotbox/actions?query=workflow%3Atest" target="_blank">
    <img src="https://github.com/anthonycorletti/hotbox/workflows/test/badge.svg" alt="Test">
</a>
<a href="https://github.com/anthonycorletti/hotbox/actions?query=workflow%3Apublish" target="_blank">
    <img src="https://github.com/anthonycorletti/hotbox/workflows/publish/badge.svg" alt="publish">
</a>
<a href="https://codecov.io/gh/anthonycorletti/hotbox" target="_blank">
    <img src="https://img.shields.io/codecov/c/github/anthonycorletti/hotbox?color=%2334D058" alt="Coverage">
</a>
<a href="https://pypi.org/project/hotbox/" target="_blank">
    <img alt="PyPI" src="https://img.shields.io/pypi/v/hotbox?color=blue">
</a>
</p>

---

**Documentation**: <a href="https://hotbox.corletti.xyz" target="_blank">https://hotbox.corletti.xyz</a>

**Source Code**: <a href="https://github.com/anthonycorletti/hotbox" target="_blank">https://github.com/anthonycorletti/hotbox</a>

---

🚀 Run your code 📦 on Firecracker MicroVMs 🔥 in the cloud ☁️

## 👨‍💻 Who is this for?

- Developers that want to run:
    - Code in the cloud and don't need or want the complexity of orchestrators like Kubernetes
    - Code in a sand-boxed environment
    - Code in a serverless environment
    - CI environments on their own servers

## 💡 What is this for?

- ⚠️ _Not production... yet!_
- Learning about MicroVMs
- Rapid prototyping
- Running your own CI environments
- Running Cron jobs, backend APIs, etc.
- Making your own tiny serverless platform
- ...Anything you can run in a Docker container

## 🎉 Featuring

- Create EC2 instances provisioned to run Firecracker MicroVMs
- Quickly deploy and run your code on Firecracker MicroVMs
- Supports any runtime that can be run in a Docker container
- Set your own CPU and memory limits

## 📝 Requirements

- Python 3.10+
- An AWS Account. Sign up for free [here](https://aws.amazon.com/free/).

## ⚙️ Installation

```sh
pip install hotbox
```

## 🏎️ A Quick Example

[Start running your code on MicroVMs in the cloud here!](https://hotbox.corletti.xyz/get-started/)

## 🫶 How can I help?

- [⭐️ Star hotbox on GitHub! ⭐️](https://github.com/anthonycorletti/hotbox)
- Open an [issue](https://github.com/anthonycorletti/hotbox/issues/new/choose) if you have a question, comment, feature request, or bug report.
- Open a [pull request](https://github.com/anthonycorletti/hotbox/compare) on GitHub. Contributions are encouraged and welcome!

## 📲 Contact

Reach out to Anthony directly on [Twitter](https://twitter.com/anthonycorletti) if you'd like to get in touch.

&nbsp;
