# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['telegram_stats_bot']

package_data = \
{'': ['*']}

install_requires = \
['SQLAlchemy-Utils==0.37.6',
 'appdirs>=1.4.4,<2.0.0',
 'matplotlib>=3.2.1,<4.0.0',
 'numpy>=1.22.0,<2.0.0',
 'pandas>=1.0.4,<2.0.0',
 'psycopg2-binary>=2.9.5,<3.0.0',
 'python-telegram-bot>=13.11,<14.0',
 'seaborn>=0.12,<0.13',
 'single-source>=0.2.0,<0.3.0',
 'sqlalchemy[postgresql_psycopg2binary]>=1.4,<2.0',
 'typer>=0.7.0,<0.8.0']

setup_kwargs = {
    'name': 'telegram-stats-bot',
    'version': '0.7.0',
    'description': 'A logging and statistics bot for Telegram based on python-telegram-bot.',
    'long_description': '==================\ntelegram-stats-bot\n==================\n\n.. image:: https://img.shields.io/pypi/v/telegram-stats-bot?style=flat-square\n   :target: https://pypi.org/project/telegram-stats-bot/\n   :alt: PyPi Package Version\n\n.. image:: https://img.shields.io/pypi/pyversions/telegram-stats-bot?style=flat-square\n   :target: https://pypi.org/project/telegram-stats-bot/\n   :alt: Supported Python versions\n\n.. image:: https://img.shields.io/github/commit-activity/m/mkdryden/telegram-stats-bot?style=flat-square\n   :target: https://github.com/mkdryden/telegram-stats-bot\n   :alt: GitHub Commit Activity\n\n.. image:: https://img.shields.io/pypi/l/telegram-stats-bot?style=flat-square\n   :target: https://www.gnu.org/licenses/gpl-3.0-or-later.html\n   :alt: LGPLv3 License\n\n\nTelegram-stats-bot is a simple bot that lives in your Telegram group, logging messages to a Postgresql database and\nserving statistical tables and plots to users as Telegram messages.\n\n.. image:: examples/chat_example.png\n    :alt: Bot conversation example\n\n-----------------\nTable of contents\n-----------------\n\n- `Introduction`_\n\n- `Basic Requirements`_\n\n- `Installation`_\n\n- `Docker`_\n\n- `Setup`_\n\n- `Importing Data`_\n\n- `Fetching Stats`_\n\n  - `counts`_\n\n  - `count-dist`_\n\n  - `hours`_\n\n  - `days`_\n\n  - `week`_\n\n  - `history`_\n\n  - `titles`_\n\n  - `user`_\n\n  - `corr`_\n\n  - `delta`_\n\n  - `types`_\n\n  - `words`_\n\n  - `random`_\n\n- `License`_\n\n------------\nIntroduction\n------------\n\nThis software is intended to be run on a server, handling updates for a bot user with a single bot per channel\n(multi-channel support could be added at some point if there is interest), using the excellent\n`Python-telegram-bot <https://github.com/python-telegram-bot/python-telegram-bot>`_ library.\n\nThe bot is still in active development but at the moment, it features:\n\n- Message logging to Postgresql database with optional JSON file backup\n\n- Statistics output for users in group as Telegram messages, with optional filtering by date or limiting to the querying\n  user.\n  Some statistics are more useful than others, but they are mainly intended to be fun for users to play with.\n\n  - Tables:\n\n    - Most active users\n\n    - A user\'s message time correlation with other users\n\n    - A user\'s median message time difference with other users\n\n  - Plots:\n\n    - Message activity by hour of day\n\n    - Message activity by day of week\n\n    - Message activity over the week by hour and day\n\n    - Message activity history\n\n------------------\nBasic Requirements\n------------------\n\n- Python 3.8+\n\n- A Telegram bot token with privacy mode disabled (needed to log messages)\n\n  - See `here <https://core.telegram.org/bots#6-botfather>`_ for details\n\n- Postgresql (Tested with 12.3, but there shouldn\'t be anything that won\'t work with 9.4 or up)\n\n  - This can be on a different system than telegram-stats-bot and requires either table creation permissions on a\n    database or database can be pre-initialized following the setup in ``db.py``\n\n------------\nInstallation\n------------\n\nThe easiest way to install or upgrade is with pip:\n\n.. code:: shell\n\n    $ pip install telegram-stats-bot --upgrade\n\nThis works directly from the git repository as well:\n\n.. code:: shell\n\n    $ pip install --upgrade git+https://github.com/mkdryden/telegram-stats-bot\n\nOr you can install an entire venv for development using `poetry <https://python-poetry.org/>`_:\n\n.. code:: shell\n\n    $ git clone https://github.com/mkdryden/telegram-stats-bot.git\n    $ cd telegram-stats-bot\n    $ poetry install\n\n------\nDocker\n------\n\nA Docker image is available under ``mkdryden/telegram-stats-bot`` and a sample ``docker-compose.yml`` is in the root of the repository including database setup.\nBe sure to set the ``TZ``, ``BOT_TOKEN``, and ``CHAT_ID`` environment variable appropriately in your ``docker-run`` command or the ``docker-compose.yml`` file.\n\n-----\nSetup\n-----\nOnce installed, you can run the bot by calling the ``main`` module with a few required arguments:\n\n.. code:: shell\n\n    $ python -m telegram_stats_bot.main BOT_TOKEN CHAT_ID POSTGRESQL_URL\n\n- ``BOT_TOKEN``: Your bot\'s token e.g., ``110201543:AAHdqTcvCH1vGWJxfSeofSAs0K5PALDsaw``\n\n- ``CHAT_ID``: The chat id to monitor (will be a large integer, possibly negative, if unknown, set to 0 and see below)\n\n- ``POSTGRESQL_URL``: Connection information in the form: ``postgresql://USERNAME:PASSWORD@ADDRESS/DB_NAME``\n\n  - if DB_NAME exists, there must not be tables called ``messages_utc``, ``user_events``, or ``user_names``\n    with incorrect columns\n\nTwo optional arguments exist as well:\n\n- ``json-path``: Specifying a path here will log messages to json files in addition to the database.\n  If only a prefix is specified, they will be saved under that prefix in your platform\'s preferred app data directory.\n  This was mostly for development purposes and is not necessary in normal use.\n\n- ``tz``: Specify a tz database time zone string here (e.g., ``America/New_York``) to return statistics queries in this time zone.\n  (Defaults to ``Etc./UTC``)\n\nA complete command might look like:\n\n.. code:: shell\n\n    $ python -m telegram_stats_bot.main --tz="America/Toronto" "110201543:AAHdqTcvCH1vGWJxfSeofSAs0K5PALDsaw" "postgresql://telegram:CoolPassword@localhost/telegram_bot"\n\nOn startup, the bot will attempt to create the database and tables, if they do not already exist.\nIf you do not know the chat\'s id and have set it to 0 as mentioned above, you can send the ``/chatid`` command inside\nthe group, and the bot will reply with it, then restart the bot with the id.\nIf you have forgotten to disable privacy mode, an error will be logged in the terminal.\n\nThe bot will now log all messages in the group, but will only respond to users who have sent a message that has been\nlogged previously (and this list is only updated once an hour, so if you\'re impatient, you can restart the bot after\nyou\'ve sent a message to trigger the update).\nYou can see if messages are being logged correctly by reviewing the terminal output.\nYou should see a line like ``2020-06-04 02:08:39,212 - __main__ - INFO - 8``, whenever a message is logged.\n\n--------------\nImporting Data\n--------------\nData can be imported from JSON dumps from the desktop client.\nHit the three dot button from inside the desired group and select "Export chat history".\nMake sure you select JSON as the output format.\nYou can also limit the date, as desired.\nThe database will be updated and existing messages will remain, so you can use this feature to fill in gaps when the bot was not running.\n\nTo import data, simply call:\n\n.. code:: shell\n\n    $ python -m telegram_stats_bot.json_dump_parser "/some/path/to/dump.json" "postgresql://telegram:CoolPassword@localhost/telegram_bot" --tz="America/Toronto"\n\nWhere the first argument is the path to the json dump, the second is the db connection string, as above, and the optional `tz` argument should be the time zone of the system used to dump the json.\n\nThis can be run without stopping a running bot, though it also attempts to set the user id to user name mapping, so will add an extra entry to every user in the dump (this currently only affects the user stats related to user name changes).\nBefore you run this, make sure your db string is correct or you might accidentally mess up other databases on the same server.\n\n--------------\nFetching Stats\n--------------\nTo fetch stats, simply message the bot, either inside the group being logged, or in a direct message, using the\n``/stats`` command.\n``/stats`` with no arguments prints the table of most active users and other statistics are available through various\nsubcommands.\nAll commands are documented and the built in help can be displayed with ``/stats -h`` or ``stats <subcommand> -h``.\n\nMost commands have optional arguments that change the behaviour of the output.\nNearly all have:\n\n- ``-start`` and ``-end`` followed by a timestamp (e.g., 2019, 2019-01, 2019-01-01, "2019-01-01 14:21") specify the\n  range of data to fetch, otherwise all available data will be used.\n  Either or both options can be given.\n\n- ``-lquery`` followed by a lexical query (using Postgres\'\n  `tsquery syntax <https://www.postgresql.org/docs/12/datatype-textsearch.html#DATATYPE-TSQUERY>`_)\n  limits results to matching messages.\n\n- ``-me`` calculates statistics for the user sending the command, rather than all chat users.\n\nSample outputs of each available subcommand follow.\n\ncounts\n------\n``/stats counts`` returns a list of the most active users in the group.\n\n.. code::\n\n                User  Total Messages  Percent\n          @ACoolUser           42150      7.0\n          @NumberOne           37370      6.2\n   @WinstonChurchill           32668      5.4\n            @AAAAAAA           32134      5.4\n  @WhereAreMyManners           30481      5.1\n  @TheWorstOfTheBest           28705      4.8\n\ncount-dist\n----------\n``/stats count-dist`` returns an ECDF plot of the users in the group by message count.\n\n.. image:: examples/count-dist.png\n   :alt: Example of count-dist plot\n\nhours\n-----\n``/stats hours`` returns a plot of message frequency for the hours of the day.\n\n.. image:: examples/hours.png\n   :alt: Example of hours plot\n\ndays\n----\n``/stats days`` returns a plot of message frequency for the days of the week.\n\n.. image:: examples/days.png\n   :alt: Example of days plot\n\nweek\n----\n``/stats week`` returns a plot of total messages over the data period by day of week and hour of day.\n\n.. image:: examples/week.png\n   :alt: Example of week plot\n\nhistory\n-------\n``/stats history`` returns a plot of messages versus date.\n\n.. image:: examples/history.png\n   :alt: Example of history plot\n\ntitles\n------\n``/stats titles`` returns a plot of group titles over time.\n\n.. image:: examples/titles.png\n   :alt: Example of title history plot\n\nuser\n----\n``/stats user`` returns basic statistics for the user.\n\n.. code-block::\n\n    Messages sent: 16711\n    Average messages per day: 12.31\n    First message was 1357.22 days ago.\n    Usernames on record: 3\n    Average username lifetime: 452.41 days\n\n    joined on 2017-10-01 16:11:08-04:00\n\ncorr\n----\n``/stats corr`` returns a list of users with the highest and lowest message time correlations with the requesting user.\n\n.. code::\n\n    User Correlations for @TheManWhoWasThursday\n    HIGHEST CORRELATION:\n    @MyGoodFriend         0.335\n    @Rawr                 0.302\n    @MangesUnePoutine     0.284\n    @GreenBlood           0.251\n    @TooMuchVacuum        0.235\n\n    LOWEST CORRELATION:\n    @Shiny                0.146\n    @BlueDog              0.142\n    @CoolCat              0.122\n    @EatMe                0.116\n    @JustPassingBy        0.106\n\ndelta\n-----\n``/stats delta`` returns a list of users with the shortest differences in message times with the requesting user.\n\n.. code::\n\n    Median message delays for @KingLeer and:\n    @PolyamorousPasta     00:03:23\n    @AggressiveArgon      00:04:43\n    @AdjectiveNoun        00:08:27\n    @SuperSalad           00:09:05\n    @ABoredProgrammer     00:09:06\n\ntypes\n-----\n``/stats types`` returns a table of messages by type, comparing the requesting user with the full group.\n\n.. code::\n\n Messages by type, @AUser vs group:\n       type  Group Count  Group Percent  User Count  User Percent\n       text     528813.0           88.3     13929.0          83.4\n    sticker      34621.0            5.8      1226.0           7.3\n      photo      25995.0            4.3      1208.0           7.2\n  animation       6983.0            1.2       274.0           1.6\n      video       1325.0            0.2        48.0           0.3\n      voice        475.0            0.1         2.0           0.0\n   location        252.0            0.0         2.0           0.0\n video_note         84.0            0.0         1.0           0.0\n      audio         62.0            0.0         1.0           0.0\n       poll         29.0            0.0         1.0           0.0\n   document          1.0            0.0         1.0           0.0\n      Total     598640.0          100.0     16693.0         100.0\n\nwords\n-----\n``/stats words`` returns a table of the most commonly used lexemes\n\n.. code::\n\n Most frequently used lexemes:\n     Lexeme  Messages  Uses\n       like      1265  1334\n       well       753   765\n     actual       628   645\n       make       600   619\n       yeah       609   609\n       mean       544   553\n      thing       473   490\n     realli       472   482\n     though       467   470\n      peopl       415   445\n      think       425   433\n       know       403   409\n       need       396   408\n       time       371   389\n       want       354   371\n      would       345   366\n       much       345   357\n    probabl       348   356\n       even       331   338\n      stuff       318   332\n\nrandom\n------\n``/stats random`` prints a random message from the database.\n\n----------\nThe Future\n----------\nTelegram-stats-bot is a work in progress.\nNew stats will be added, but no guarantees that the database structure will stay constant if Telegram\'s message\nstructure changes or I need to change something to make a new statistic work.\n\n=======\nLicense\n=======\nTelegram-stats-bot is free software:\nYou can redistribute it and/or modify it under the terms of the\n`GNU General Public License v3.0 or later <https://www.gnu.org/licenses/gpl-3.0.html>`_.\nDerivative works must also be redistributed under the GPL v3 or later.\n',
    'author': 'Michael DM Dryden',
    'author_email': 'mk.dryden@utoronto.ca',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mkdryden/telegram-stats-bot',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
