/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.linalg.Axis$_0$;
import breeze.linalg.Axis$_1$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix;
import breeze.linalg.Matrix$mcF$sp;
import breeze.linalg.MatrixLike$mcF$sp;
import breeze.linalg.View;
import breeze.linalg.View$;
import breeze.linalg.View$Copy$;
import breeze.linalg.View$Prefer$;
import breeze.linalg.View$Require$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.support.CanMapValues;
import breeze.storage.Zero;
import breeze.util.ArrayUtil$;
import breeze.util.ReflectionUtil$;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2$mcVII$sp;

public final class DenseMatrix$mcF$sp
extends DenseMatrix<Object>
implements Matrix$mcF$sp {
    private static final long serialVersionUID = 1L;
    public final float[] data$mcF$sp;

    @Override
    public final float apply(Tuple2<Object, Object> i) {
        return Matrix$mcF$sp.apply$(this, i);
    }

    @Override
    public final float apply$mcF$sp(Tuple2<Object, Object> i) {
        return Matrix$mcF$sp.apply$mcF$sp$(this, i);
    }

    @Override
    public final void update(Tuple2<Object, Object> i, float e) {
        Matrix$mcF$sp.update$(this, i, e);
    }

    @Override
    public final void update$mcF$sp(Tuple2<Object, Object> i, float e) {
        Matrix$mcF$sp.update$mcF$sp$(this, i, e);
    }

    @Override
    public <V2, That> That map(Function1<Object, V2> fn, CanMapValues<DenseMatrix<Object>, Object, V2, That> canMapValues) {
        return (That)MatrixLike$mcF$sp.map$(this, fn, canMapValues);
    }

    @Override
    public <V2, That> That map$mcF$sp(Function1<Object, V2> fn, CanMapValues<DenseMatrix<Object>, Object, V2, That> canMapValues) {
        return (That)MatrixLike$mcF$sp.map$mcF$sp$(this, fn, canMapValues);
    }

    @Override
    public float[] data$mcF$sp() {
        return this.data$mcF$sp;
    }

    public float[] data() {
        return this.data$mcF$sp();
    }

    @Override
    public float apply(int row, int col) {
        return this.apply$mcF$sp(row, col);
    }

    @Override
    public float apply$mcF$sp(int row, int col) {
        if (row < -this.rows() || row >= this.rows()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2$mcII$sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        if (col < -this.cols() || col >= this.cols()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2$mcII$sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        int trueRow = row < 0 ? row + this.rows() : row;
        int trueCol = col < 0 ? col + this.cols() : col;
        return this.data()[this.linearIndex(trueRow, trueCol)];
    }

    @Override
    public void update(int row, int col, float v) {
        this.update$mcF$sp(row, col, v);
    }

    @Override
    public void update$mcF$sp(int row, int col, float v) {
        if (row < -this.rows() || row >= this.rows()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2$mcII$sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        if (col < -this.cols() || col >= this.cols()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2$mcII$sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        int trueRow = row < 0 ? row + this.rows() : row;
        int trueCol = col < 0 ? col + this.cols() : col;
        this.data()[this.linearIndex((int)trueRow, (int)trueCol)] = v;
    }

    public float[] toArray() {
        return this.toArray$mcF$sp();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float[] toArray$mcF$sp() {
        float[] fArray;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (this.isContiguous() && !this.isTranspose()) {
            fArray = (float[])ArrayUtil$.MODULE$.copyOfRange(this.data(), this.offset(), this.offset() + this.size());
        } else {
            void var2_2;
            float[] ret = (float[])man.newArray(this.rows() * this.cols());
            int limit$macro$9 = this.cols();
            for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
                int limit$macro$4 = this.rows();
                for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                    ((JFunction2$mcVII$sp)(i, j) -> {
                        ret$3[i * $this.rows() + j] = this.data()[this.linearIndex(j, i)];
                    }).apply$mcVII$sp(index$macro$7, index$macro$2);
                }
            }
            fArray = var2_2;
        }
        return fArray;
    }

    @Override
    public DenseVector<Object> toDenseVector() {
        return this.toDenseVector$mcF$sp();
    }

    @Override
    public DenseVector<Object> toDenseVector$mcF$sp() {
        return DenseVector$.MODULE$.apply$mFc$sp(this.toArray$mcF$sp());
    }

    @Override
    public DenseVector<Object> flatten(View view) {
        return this.flatten$mcF$sp(view);
    }

    @Override
    public DenseVector<Object> flatten$mcF$sp(View view) {
        DenseVector<Object> denseVector;
        block4: {
            View view2;
            while (true) {
                if (View$Require$.MODULE$.equals(view2 = view)) {
                    if (!this.breeze$linalg$DenseMatrix$$canFlattenView()) {
                        throw new UnsupportedOperationException("Cannot make a view of this matrix.");
                    }
                    denseVector = DenseVector$.MODULE$.create(this.data(), this.offset(), 1, this.rows() * this.cols());
                    break block4;
                }
                if (View$Copy$.MODULE$.equals(view2)) {
                    denseVector = this.toDenseVector$mcF$sp();
                    break block4;
                }
                if (!View$Prefer$.MODULE$.equals(view2)) break;
                view = View$.MODULE$.viewPreferenceFromBoolean(this.breeze$linalg$DenseMatrix$$canFlattenView());
            }
            throw new MatchError(view2);
        }
        return denseVector;
    }

    @Override
    public DenseMatrix<Object> reshape(int rows, int cols, View view) {
        return this.reshape$mcF$sp(rows, cols, view);
    }

    @Override
    public DenseMatrix<Object> reshape$mcF$sp(int rows, int cols, View view) {
        int _cols;
        block5: {
            View view2;
            while (true) {
                int right$macro$2;
                int left$macro$1;
                if ((left$macro$1 = rows * (_cols = cols)) != (right$macro$2 = this_.size())) {
                    throw new IllegalArgumentException(new StringBuilder(67).append("requirement failed: ").append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cannot reshape a (%d,%d) matrix to a (%d,%d) matrix!"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this_.rows()), BoxesRunTime.boxToInteger(this_.cols()), BoxesRunTime.boxToInteger(rows), BoxesRunTime.boxToInteger(_cols)}))).append(": ").append("rows.*(_cols) == DenseMatrix.this.size (").append(left$macro$1).append(" ").append("!=").append(" ").append(right$macro$2).append(")").toString());
                }
                view2 = view;
                if (View$Require$.MODULE$.equals(view2)) {
                    if (!this_.breeze$linalg$DenseMatrix$$canReshapeView()) {
                        throw new UnsupportedOperationException("Cannot make a view of this matrix.");
                    }
                    break block5;
                }
                if (View$Copy$.MODULE$.equals(view2)) {
                    DenseMatrix$mcF$sp result2 = new DenseMatrix$mcF$sp(this_.rows(), this_.cols(), (float[])ArrayUtil$.MODULE$.newArrayLike(this_.data(), this_.size()));
                    result2.$colon$eq(this_, HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM());
                    view = View$Require$.MODULE$;
                    cols = _cols;
                    DenseMatrix$mcF$sp this_ = result2;
                    continue;
                }
                if (!View$Prefer$.MODULE$.equals(view2)) break;
                view = View$.MODULE$.viewPreferenceFromBoolean(this_.breeze$linalg$DenseMatrix$$canReshapeView());
            }
            throw new MatchError(view2);
        }
        DenseMatrix$mcF$sp denseMatrix$mcF$sp = new DenseMatrix$mcF$sp(rows, _cols, this_.data(), this_.offset(), this_.isTranspose() ? cols : rows, this_.isTranspose());
        return denseMatrix$mcF$sp;
    }

    @Override
    public DenseMatrix<Object> repr() {
        return this.repr$mcF$sp();
    }

    @Override
    public DenseMatrix<Object> repr$mcF$sp() {
        return this;
    }

    @Override
    public float valueAt(int i) {
        return this.valueAt$mcF$sp(i);
    }

    @Override
    public float valueAt$mcF$sp(int i) {
        return this.data()[i];
    }

    @Override
    public float valueAt(int row, int col) {
        return this.valueAt$mcF$sp(row, col);
    }

    @Override
    public float valueAt$mcF$sp(int row, int col) {
        return this.apply$mcF$sp(row, col);
    }

    @Override
    public DenseMatrix<Object> toDenseMatrix(ClassTag<Object> cm, Zero<Object> zero) {
        return this.toDenseMatrix$mcF$sp(cm, zero);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> toDenseMatrix$mcF$sp(ClassTag<Object> cm, Zero<Object> zero) {
        void var3_3;
        Matrix result2 = DenseMatrix$.MODULE$.create$mFc$sp(this.rows(), this.cols(), (float[])cm.newArray(this.size()), (Zero)zero);
        ((DenseMatrix)result2).$colon$eq(this, HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM());
        return var3_3;
    }

    @Override
    public DenseMatrix<Object> copy() {
        return this.copy$mcF$sp();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> copy$mcF$sp() {
        void var2_2;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        Matrix result2 = DenseMatrix$.MODULE$.create$mFc$sp(this.rows(), this.cols(), (float[])man.newArray(this.size()), this.breeze$linalg$DenseMatrix$$dontNeedZero());
        ((DenseMatrix)result2).$colon$eq(this, HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM());
        return var2_2;
    }

    @Override
    public DenseMatrix<Object> delete(int row, Axis$_0$ axis) {
        return this.delete$mcF$sp(row, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcF$sp(int row, Axis$_0$ axis) {
        boolean cond$macro$1;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        boolean bl = cond$macro$1 = row >= 0 && row < this.rows();
        if (!cond$macro$1) {
            throw new IllegalArgumentException(new StringBuilder(64).append("requirement failed: ").append(new StringBuilder(28).append("row ").append(row).append(" is not in bounds: [0, ").append(this.rows()).append(")").toString()).append(": ").append("row.>=(0).&&(row.<(DenseMatrix.this.rows))").toString());
        }
        return row == 0 ? this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.rows()), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()).copy$mcF$sp() : (row == this.rows() - 1 ? this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.rows() - 1), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()).copy$mcF$sp() : DenseMatrix$.MODULE$.vertcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), row), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()), this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(row + 1), this.rows()), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())}), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero()));
    }

    @Override
    public DenseMatrix<Object> delete(int col, Axis$_1$ axis) {
        return this.delete$mcF$sp(col, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcF$sp(int col, Axis$_1$ axis) {
        boolean cond$macro$1;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        boolean bl = cond$macro$1 = col >= 0 && col < this.cols();
        if (!cond$macro$1) {
            throw new IllegalArgumentException(new StringBuilder(64).append("requirement failed: ").append(new StringBuilder(28).append("col ").append(col).append(" is not in bounds: [0, ").append(this.cols()).append(")").toString()).append(": ").append("col.>=(0).&&(col.<(DenseMatrix.this.cols))").toString());
        }
        return col == 0 ? this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.cols()), HasOps$.MODULE$.canSliceCols()).copy$mcF$sp() : (col == this.cols() - 1 ? this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.cols() - 1), HasOps$.MODULE$.canSliceCols()).copy$mcF$sp() : DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), col), HasOps$.MODULE$.canSliceCols()), this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(col + 1), this.cols()), HasOps$.MODULE$.canSliceCols())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero()));
    }

    @Override
    public DenseMatrix<Object> delete(Seq<Object> rows, Axis$_0$ axis) {
        return this.delete$mcF$sp(rows, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcF$sp(Seq<Object> rows, Axis$_0$ axis) {
        DenseMatrix<Object> denseMatrix;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (rows.isEmpty()) {
            denseMatrix = this.copy$mcF$sp();
        } else if (rows.size() == 1) {
            denseMatrix = this.delete$mcF$sp(BoxesRunTime.unboxToInt(rows.apply(false)), axis);
        } else {
            boolean cond$macro$1;
            Seq sorted = (Seq)rows.sorted(Ordering$Int$.MODULE$);
            boolean bl = cond$macro$1 = BoxesRunTime.unboxToInt(sorted.head()) >= 0 && BoxesRunTime.unboxToInt(sorted.last()) < this.rows();
            if (!cond$macro$1) {
                throw new IllegalArgumentException(new StringBuilder(68).append("requirement failed: ").append(new StringBuilder(29).append("row ").append(rows).append(" are not in bounds: [0, ").append(this.rows()).append(")").toString()).append(": ").append("sorted.head.>=(0).&&(sorted.last.<(this.rows))").toString());
            }
            IntRef last = IntRef.create(0);
            Builder matrices = breeze.collection.compat.package$.MODULE$.arraySeqBuilder(ClassTag$.MODULE$.apply(DenseMatrix.class));
            sorted.foreach(index -> {
                boolean cond$macro$2;
                boolean bl = cond$macro$2 = index >= last$5.elem;
                if (!cond$macro$2) {
                    throw new AssertionError((Object)"assertion failed: index.>=(last)");
                }
                Object object = index != last$5.elem ? matrices.$plus$eq(this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last$5.elem), index), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())) : BoxedUnit.UNIT;
                last$5.elem = index + 1;
            });
            Object object = last.elem != this.rows() ? matrices.$plus$eq(this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last.elem), this.rows()), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())) : BoxedUnit.UNIT;
            denseMatrix = DenseMatrix$.MODULE$.vertcat(matrices.result(), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero());
        }
        return denseMatrix;
    }

    @Override
    public DenseMatrix<Object> delete(Seq<Object> cols, Axis$_1$ axis) {
        return this.delete$mcF$sp(cols, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcF$sp(Seq<Object> cols, Axis$_1$ axis) {
        DenseMatrix<Object> denseMatrix;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (cols.isEmpty()) {
            denseMatrix = this.copy$mcF$sp();
        } else if (cols.size() == 1) {
            denseMatrix = this.delete$mcF$sp(BoxesRunTime.unboxToInt(cols.apply(false)), axis);
        } else {
            boolean cond$macro$1;
            Seq sorted = (Seq)cols.sorted(Ordering$Int$.MODULE$);
            boolean bl = cond$macro$1 = BoxesRunTime.unboxToInt(sorted.head()) >= 0 && BoxesRunTime.unboxToInt(sorted.last()) < this.cols();
            if (!cond$macro$1) {
                throw new IllegalArgumentException(new StringBuilder(68).append("requirement failed: ").append(new StringBuilder(29).append("col ").append(cols).append(" are not in bounds: [0, ").append(this.cols()).append(")").toString()).append(": ").append("sorted.head.>=(0).&&(sorted.last.<(this.cols))").toString());
            }
            IntRef last = IntRef.create(0);
            Builder matrices = breeze.collection.compat.package$.MODULE$.arraySeqBuilder(ClassTag$.MODULE$.apply(DenseMatrix.class));
            sorted.foreach(index -> {
                boolean cond$macro$2;
                boolean bl = cond$macro$2 = index >= last$6.elem;
                if (!cond$macro$2) {
                    throw new AssertionError((Object)"assertion failed: index.>=(last)");
                }
                Object object = index != last$6.elem ? matrices.$plus$eq(this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last$6.elem), index), HasOps$.MODULE$.canSliceCols())) : BoxedUnit.UNIT;
                last$6.elem = index + 1;
            });
            Object object = last.elem != this.cols() ? matrices.$plus$eq(this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last.elem), this.cols()), HasOps$.MODULE$.canSliceCols())) : BoxedUnit.UNIT;
            denseMatrix = DenseMatrix$.MODULE$.horzcat(matrices.result(), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero());
        }
        return denseMatrix;
    }

    @Override
    public boolean overlaps(DenseMatrix<Object> other) {
        return this.overlaps$mcF$sp(other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean overlaps$mcF$sp(DenseMatrix<Object> other) {
        if (this.data() != other.data$mcF$sp()) return false;
        int astart = this.offset();
        int aend = this.offset() + this.breeze$linalg$DenseMatrix$$footprint();
        int bstart = other.offset();
        int bend = other.offset() + other.breeze$linalg$DenseMatrix$$footprint();
        if (package$.MODULE$.Range().apply(astart, aend).contains(bstart)) return true;
        if (package$.MODULE$.Range().apply(astart, aend).contains(bend)) return true;
        if (package$.MODULE$.Range().apply(bstart, bend).contains(astart)) return true;
        if (!package$.MODULE$.Range().apply(bstart, bend).contains(aend)) return false;
        return true;
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public DenseMatrix$mcF$sp(int rows, int cols, float[] data$mcF$sp, int offset, int majorStride, boolean isTranspose) {
        this.data$mcF$sp = data$mcF$sp;
        super(rows, cols, null, offset, majorStride, isTranspose);
        if (isTranspose && scala.math.package$.MODULE$.abs(majorStride) < cols && majorStride != 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(61).append("MajorStride == ").append(majorStride).append(" is smaller than cols == ").append(cols).append(", which is impossible").toString());
        }
        if (!isTranspose && scala.math.package$.MODULE$.abs(majorStride) < rows && majorStride != 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(61).append("MajorStride == ").append(majorStride).append(" is smaller than rows == ").append(rows).append(", which is impossible").toString());
        }
        if (rows < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(38).append("Rows must be larger than zero. It was ").append(rows).toString());
        }
        if (cols < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(38).append("Cols must be larger than zero. It was ").append(cols).toString());
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(40).append("Offset must be larger than zero. It was ").append(offset).toString());
        }
        if (majorStride > 0) {
            if (ScalaRunTime$.MODULE$.array_length(this.data()) < this.linearIndex(rows - 1, cols - 1)) {
                throw new IndexOutOfBoundsException(new StringBuilder(57).append("Storage array has size ").append(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.genericArrayOps(this.data()))).append(" but indices can grow as large as ").append(this.linearIndex(rows - 1, cols - 1)).toString());
            }
        } else if (majorStride < 0) {
            if (ScalaRunTime$.MODULE$.array_length(this.data()) < this.linearIndex(rows - 1, 0)) {
                throw new IndexOutOfBoundsException(new StringBuilder(57).append("Storage array has size ").append(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.genericArrayOps(this.data()))).append(" but indices can grow as large as ").append(this.linearIndex(rows - 1, cols - 1)).toString());
            }
            if (this.linearIndex(0, cols - 1) < 0) {
                throw new IndexOutOfBoundsException(new StringBuilder(84).append("Storage array has negative stride ").append(majorStride).append(" and offset ").append(offset).append(" which can result in negative indices.").toString());
            }
        }
        DenseMatrix$.MODULE$.breeze$linalg$DenseMatrix$$init();
    }

    public DenseMatrix$mcF$sp(int rows, int cols, ClassTag<Object> man) {
        this(rows, cols, (float[])man.newArray(rows * cols), 0, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix$mcF$sp(int rows, int cols, float[] data$mcF$sp, int offset) {
        this(rows, cols, data$mcF$sp, offset, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix$mcF$sp(int rows, int cols, float[] data$mcF$sp) {
        this(rows, cols, data$mcF$sp, 0, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix$mcF$sp(int rows, float[] data$mcF$sp, int offset) {
        int left$macro$1 = data$mcF$sp.length % rows;
        boolean right$macro$2 = false;
        if (left$macro$1 != 0) {
            throw new AssertionError((Object)new StringBuilder(60).append("assertion failed: ").append("data.length.%(rows) == 0 (").append(left$macro$1).append(" ").append("!=").append(" ").append(0).append(")").toString());
        }
        this(rows, data$mcF$sp.length / rows, data$mcF$sp, offset);
    }
}

