/*
 * Decompiled with CFR 0.152.
 */
package io.citrine.lolo.trees.splits;

import io.citrine.lolo.trees.impurity.VarianceCalculator;
import io.citrine.lolo.trees.splits.BoltzmannSplitter;
import io.citrine.lolo.trees.splits.CategoricalSplit;
import io.citrine.lolo.trees.splits.RealSplit;
import io.citrine.lolo.trees.splits.Splitter$;
import io.citrine.random.Random;
import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.BitSet;
import scala.math.Numeric$DoubleIsFractional$;
import scala.math.Ordering$DeprecatedDoubleOrdering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class BoltzmannSplitter$
implements Serializable {
    public static final BoltzmannSplitter$ MODULE$ = new BoltzmannSplitter$();

    public Option<BoltzmannSplitter.SplitterResult> getBestRealSplit(Seq<Tuple3<Vector<Object>, Object, Object>> data, VarianceCalculator calculator, int index, int minCount, double beta, Random rng) {
        Object object = new Object();
        try {
            Seq thinData = (Seq)((SeqOps)data.map((Function1<Tuple3, Tuple3> & Serializable)dat -> new Tuple3(BoxesRunTime.boxToDouble(BoxesRunTime.unboxToDouble(((SeqOps)dat._1()).apply(index))), dat._2(), dat._3()))).sortBy((Function1<Tuple3, Object> & Serializable)x$4 -> BoxesRunTime.boxToDouble(BoltzmannSplitter$.$anonfun$getBestRealSplit$2(x$4)), Ordering$DeprecatedDoubleOrdering$.MODULE$);
            calculator.reset();
            Seq possibleSplits = (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), data.size() - minCount).flatMap((Function1<Object, IterableOnce> & Serializable)j -> BoltzmannSplitter$.$anonfun$getBestRealSplit$3(calculator, thinData, minCount, beta, rng, BoxesRunTime.unboxToInt(j)));
            if (possibleSplits.isEmpty()) {
                return None$.MODULE$;
            }
            double base = BoxesRunTime.unboxToDouble(((IterableOnceOps)possibleSplits.map((Function1<Tuple3, Object> & Serializable)x$5 -> BoxesRunTime.boxToDouble(BoltzmannSplitter$.$anonfun$getBestRealSplit$4(x$5)))).max(Ordering$DeprecatedDoubleOrdering$.MODULE$));
            double totalScore = BoxesRunTime.unboxToDouble(((IterableOnceOps)possibleSplits.map((Function1<Tuple3, Object> & Serializable)x0$1 -> BoxesRunTime.boxToDouble(BoltzmannSplitter$.$anonfun$getBestRealSplit$5(base, x0$1)))).sum(Numeric$DoubleIsFractional$.MODULE$));
            double draw = rng.nextDouble() * totalScore;
            DoubleRef cumSum = DoubleRef.create(0.0);
            possibleSplits.foreach((Function1<Tuple3, Object> & Serializable)x0$2 -> {
                BoltzmannSplitter$.$anonfun$getBestRealSplit$6(cumSum, base, draw, object, index, totalScore, x0$2);
                return BoxedUnit.UNIT;
            });
            throw new RuntimeException(new StringBuilder(42).append("Draw was beyond all the probabilities: ").append(draw).append(" > ").append(cumSum.elem).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Option)ex.value();
        }
    }

    public Option<BoltzmannSplitter.SplitterResult> getBestCategoricalSplit(Seq<Tuple3<Vector<Object>, Object, Object>> data, VarianceCalculator calculator, int index, int minCount, double beta, Random rng) {
        Object object = new Object();
        try {
            Seq thinData = (Seq)data.map((Function1<Tuple3, Tuple3> & Serializable)dat -> new Tuple3(BoxesRunTime.boxToCharacter(BoxesRunTime.unboxToChar(((SeqOps)dat._1()).apply(index))), dat._2(), dat._3()));
            double totalWeight = BoxesRunTime.unboxToDouble(((IterableOnceOps)thinData.map((Function1<Tuple3, Object> & Serializable)x$6 -> BoxesRunTime.boxToDouble(BoltzmannSplitter$.$anonfun$getBestCategoricalSplit$2(x$6)))).sum(Numeric$DoubleIsFractional$.MODULE$));
            Map groupedData = thinData.groupBy((Function1<Tuple3, Object> & Serializable)x$7 -> BoxesRunTime.boxToCharacter(BoltzmannSplitter$.$anonfun$getBestCategoricalSplit$3(x$7))).view().mapValues((Function1<Seq, Tuple3> & Serializable)g -> new Tuple3<Object, Object, Integer>(((IterableOnceOps)g.map((Function1<Tuple3, Object> & Serializable)v -> BoxesRunTime.boxToDouble(BoltzmannSplitter$.$anonfun$getBestCategoricalSplit$5(v)))).sum(Numeric$DoubleIsFractional$.MODULE$), ((IterableOnceOps)g.map((Function1<Tuple3, Object> & Serializable)x$8 -> BoxesRunTime.boxToDouble(BoltzmannSplitter$.$anonfun$getBestCategoricalSplit$6(x$8)))).sum(Numeric$DoubleIsFractional$.MODULE$), BoxesRunTime.boxToInteger(g.size()))).toMap($less$colon$less$.MODULE$.refl());
            double nonTrivial = BoxesRunTime.unboxToDouble(((IterableOnceOps)((IterableOps)groupedData.filter((Function1<Tuple2, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(BoltzmannSplitter$.$anonfun$getBestCategoricalSplit$7(x$9)))).map((Function1<Tuple2, Object> & Serializable)x$10 -> BoxesRunTime.boxToDouble(BoltzmannSplitter$.$anonfun$getBestCategoricalSplit$8(x$10)))).sum(Numeric$DoubleIsFractional$.MODULE$));
            if (nonTrivial / totalWeight < 0.5) {
                return None$.MODULE$;
            }
            Map categoryAverages = groupedData.view().mapValues((Function1<Tuple3, Object> & Serializable)p -> BoxesRunTime.boxToDouble(BoltzmannSplitter$.$anonfun$getBestCategoricalSplit$9(p))).toMap($less$colon$less$.MODULE$.refl());
            Seq orderedNames = (Seq)((IterableOps)categoryAverages.toSeq().sortBy((Function1<Tuple2, Object> & Serializable)x$11 -> BoxesRunTime.boxToDouble(x$11._2$mcD$sp()), Ordering$DeprecatedDoubleOrdering$.MODULE$)).map((Function1<Tuple2, Object> & Serializable)x$12 -> BoxesRunTime.boxToCharacter(x$12._1$mcC$sp()));
            IntRef leftNum = IntRef.create(0);
            calculator.reset();
            Seq possibleSplits = (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), orderedNames.size() - 1).flatMap((Function1<Object, IterableOnce> & Serializable)j -> BoltzmannSplitter$.$anonfun$getBestCategoricalSplit$12(groupedData, orderedNames, calculator, leftNum, minCount, thinData, beta, BoxesRunTime.unboxToInt(j)));
            if (possibleSplits.isEmpty()) {
                return None$.MODULE$;
            }
            double base = BoxesRunTime.unboxToDouble(((IterableOnceOps)possibleSplits.map((Function1<Tuple3, Object> & Serializable)x$14 -> BoxesRunTime.boxToDouble(BoltzmannSplitter$.$anonfun$getBestCategoricalSplit$14(x$14)))).max(Ordering$DeprecatedDoubleOrdering$.MODULE$));
            double totalScore = BoxesRunTime.unboxToDouble(((IterableOnceOps)possibleSplits.map((Function1<Tuple3, Object> & Serializable)x0$1 -> BoxesRunTime.boxToDouble(BoltzmannSplitter$.$anonfun$getBestCategoricalSplit$15(base, x0$1)))).sum(Numeric$DoubleIsFractional$.MODULE$));
            double draw = rng.nextDouble() * totalScore;
            DoubleRef cumSum = DoubleRef.create(0.0);
            possibleSplits.foreach((Function1<Tuple3, Object> & Serializable)x0$2 -> {
                BoltzmannSplitter$.$anonfun$getBestCategoricalSplit$16(cumSum, base, draw, object, index, totalScore, x0$2);
                return BoxedUnit.UNIT;
            });
            throw new RuntimeException(new StringBuilder(42).append("Draw was beyond all the probabilities: ").append(draw).append(" > ").append(cumSum.elem).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Option)ex.value();
        }
    }

    public BoltzmannSplitter apply(double temperature) {
        return new BoltzmannSplitter(temperature);
    }

    public Option<Object> unapply(BoltzmannSplitter x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Double>(BoxesRunTime.boxToDouble(x$0.temperature()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BoltzmannSplitter$.class);
    }

    public static final /* synthetic */ double $anonfun$getBestRealSplit$2(Tuple3 x$4) {
        return BoxesRunTime.unboxToDouble(x$4._1());
    }

    public static final /* synthetic */ IterableOnce $anonfun$getBestRealSplit$3(VarianceCalculator calculator$2, Seq thinData$1, int minCount$1, double beta$2, Random rng$2, int j) {
        Option option;
        double totalVariance = calculator$2.add(BoxesRunTime.unboxToDouble(((Tuple3)thinData$1.apply(j))._2()), BoxesRunTime.unboxToDouble(((Tuple3)thinData$1.apply(j))._3()));
        double left = BoxesRunTime.unboxToDouble(((Tuple3)thinData$1.apply(j + 1))._1());
        double right = BoxesRunTime.unboxToDouble(((Tuple3)thinData$1.apply(j))._1());
        if (j + 1 >= minCount$1 && Splitter$.MODULE$.isDifferent(left, right)) {
            double score = -totalVariance * beta$2;
            double pivot = (left - right) * rng$2.nextDouble() + right;
            option = new Some<Tuple3<Double, Double, Double>>(new Tuple3<Double, Double, Double>(BoxesRunTime.boxToDouble(score), BoxesRunTime.boxToDouble(pivot), BoxesRunTime.boxToDouble(totalVariance)));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public static final /* synthetic */ double $anonfun$getBestRealSplit$4(Tuple3 x$5) {
        return BoxesRunTime.unboxToDouble(x$5._1());
    }

    public static final /* synthetic */ double $anonfun$getBestRealSplit$5(double base$1, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        double s = BoxesRunTime.unboxToDouble(tuple3._1());
        double d = Math.exp(s - base$1);
        return d;
    }

    public static final /* synthetic */ void $anonfun$getBestRealSplit$6(DoubleRef cumSum$2, double base$1, double draw$2, Object nonLocalReturnKey2$1, int index$1, double totalScore$1, Tuple3 x0$2) {
        Tuple3 tuple3 = x0$2;
        if (tuple3 != null) {
            double score = BoxesRunTime.unboxToDouble(tuple3._1());
            double pivot = BoxesRunTime.unboxToDouble(tuple3._2());
            double variance2 = BoxesRunTime.unboxToDouble(tuple3._3());
            cumSum$2.elem += Math.exp(score - base$1);
            if (draw$2 < cumSum$2.elem) {
                throw new NonLocalReturnControl<Some<BoltzmannSplitter.SplitterResult>>(nonLocalReturnKey2$1, new Some<BoltzmannSplitter.SplitterResult>(new BoltzmannSplitter.SplitterResult(new RealSplit(index$1, pivot), variance2, totalScore$1, base$1)));
            }
        } else {
            throw new MatchError(tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$getBestCategoricalSplit$2(Tuple3 x$6) {
        return BoxesRunTime.unboxToDouble(x$6._3());
    }

    public static final /* synthetic */ char $anonfun$getBestCategoricalSplit$3(Tuple3 x$7) {
        return BoxesRunTime.unboxToChar(x$7._1());
    }

    public static final /* synthetic */ double $anonfun$getBestCategoricalSplit$5(Tuple3 v) {
        return BoxesRunTime.unboxToDouble(v._2()) * BoxesRunTime.unboxToDouble(v._3());
    }

    public static final /* synthetic */ double $anonfun$getBestCategoricalSplit$6(Tuple3 x$8) {
        return BoxesRunTime.unboxToDouble(x$8._3());
    }

    public static final /* synthetic */ boolean $anonfun$getBestCategoricalSplit$7(Tuple2 x$9) {
        return BoxesRunTime.unboxToInt(((Tuple3)x$9._2())._3()) > 1;
    }

    public static final /* synthetic */ double $anonfun$getBestCategoricalSplit$8(Tuple2 x$10) {
        return BoxesRunTime.unboxToDouble(((Tuple3)x$10._2())._2());
    }

    public static final /* synthetic */ double $anonfun$getBestCategoricalSplit$9(Tuple3 p) {
        return BoxesRunTime.unboxToDouble(p._1()) / BoxesRunTime.unboxToDouble(p._2());
    }

    public static final /* synthetic */ IterableOnce $anonfun$getBestCategoricalSplit$12(Map groupedData$1, Seq orderedNames$1, VarianceCalculator calculator$3, IntRef leftNum$1, int minCount$2, Seq thinData$2, double beta$3, int j) {
        Option option;
        Tuple3 dat = (Tuple3)groupedData$1.apply(orderedNames$1.apply(j));
        double totalVariance = calculator$3.add(BoxesRunTime.unboxToDouble(dat._1()) / BoxesRunTime.unboxToDouble(dat._2()), BoxesRunTime.unboxToDouble(dat._2()));
        leftNum$1.elem += BoxesRunTime.unboxToInt(dat._3());
        if (leftNum$1.elem >= minCount$2 && thinData$2.size() - leftNum$1.elem >= minCount$2) {
            double score = -totalVariance * beta$3;
            BitSet includeSet = (BitSet)new BitSet().$plus$plus((IterableOnce)((IterableOps)orderedNames$1.slice(0, j + 1)).map((Function1<Object, Object> & Serializable)x$13 -> BoxesRunTime.boxToInteger(BoxesRunTime.unboxToChar(x$13))));
            option = new Some<Tuple3<Double, BitSet, Double>>(new Tuple3<Double, BitSet, Double>(BoxesRunTime.boxToDouble(score), includeSet, BoxesRunTime.boxToDouble(totalVariance)));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public static final /* synthetic */ double $anonfun$getBestCategoricalSplit$14(Tuple3 x$14) {
        return BoxesRunTime.unboxToDouble(x$14._1());
    }

    public static final /* synthetic */ double $anonfun$getBestCategoricalSplit$15(double base$2, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        double s = BoxesRunTime.unboxToDouble(tuple3._1());
        double d = Math.exp(s - base$2);
        return d;
    }

    public static final /* synthetic */ void $anonfun$getBestCategoricalSplit$16(DoubleRef cumSum$3, double base$2, double draw$3, Object nonLocalReturnKey3$1, int index$2, double totalScore$2, Tuple3 x0$2) {
        Tuple3 tuple3 = x0$2;
        if (tuple3 != null) {
            double score = BoxesRunTime.unboxToDouble(tuple3._1());
            BitSet includeSet = (BitSet)tuple3._2();
            double variance2 = BoxesRunTime.unboxToDouble(tuple3._3());
            cumSum$3.elem += Math.exp(score - base$2);
            if (draw$3 < cumSum$3.elem) {
                throw new NonLocalReturnControl<Some<BoltzmannSplitter.SplitterResult>>(nonLocalReturnKey3$1, new Some<BoltzmannSplitter.SplitterResult>(new BoltzmannSplitter.SplitterResult(new CategoricalSplit(index$2, includeSet), variance2, totalScore$2, base$2)));
            }
        } else {
            throw new MatchError(tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private BoltzmannSplitter$() {
    }
}

