/*
 * Decompiled with CFR 0.152.
 */
package io.citrine.lolo.util;

import io.citrine.lolo.MultiTaskModelPredictionResult;
import io.citrine.lolo.PredictionResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class LoloPyDataLoader$ {
    public static final LoloPyDataLoader$ MODULE$ = new LoloPyDataLoader$();

    public Seq<Vector<Object>> getFeatureArray(byte[] input, Integer numAttributes, boolean bigEndian) {
        ByteOrder ordering = bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ByteBuffer buffer = ByteBuffer.wrap(input).order(ordering);
        int nDigits = input.length / 8;
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nDigits).map(x -> buffer.getDouble(x * 8)).grouped(Predef$.MODULE$.Integer2int(numAttributes)).map((Function1<IndexedSeq, Vector> & Serializable)x$1 -> x$1.toVector()).toVector();
    }

    public Seq<Object> get1DArray(byte[] input, boolean getDouble, boolean bigEndian) {
        Vector<Object> vector;
        ByteOrder ordering = bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ByteBuffer buffer = ByteBuffer.wrap(input).order(ordering);
        if (getDouble) {
            int nDigits = input.length / 8;
            vector = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nDigits).map(x -> buffer.getDouble(x * 8)).toVector();
        } else {
            int nDigits = input.length / 4;
            vector = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nDigits).map(x -> buffer.getInt(x * 4)).toVector();
        }
        return vector;
    }

    public Seq<Tuple2<Vector<Object>, Object>> zipTrainingData(Seq<Vector<Object>> X, Seq<Object> y) {
        return (Seq)X.zip(y);
    }

    public byte[] getRegressionExpected(PredictionResult<Object> predictionResult) {
        Seq<Object> predResults = predictionResult.getExpected();
        return this.send1DArray(predResults);
    }

    public byte[] getMultiRegressionExpected(MultiTaskModelPredictionResult predictionResult) {
        Seq predResults = (Seq)predictionResult.getExpected().flatten(Predef$.MODULE$.$conforms());
        return this.send1DArray(predResults);
    }

    public byte[] getImportanceScores(PredictionResult<Object> predictionResult) {
        return this.send1DArray((Seq)((IterableOps)predictionResult.getImportanceScores().get()).flatten(Predef$.MODULE$.$conforms()));
    }

    public byte[] getRegressionUncertainty(PredictionResult<Object> predictionResult) {
        Seq<Object> predResults = predictionResult.getUncertainty(predictionResult.getUncertainty$default$1()).get();
        return this.send1DArray(predResults);
    }

    public byte[] getMultiRegressionUncertainty(MultiTaskModelPredictionResult predictionResult) {
        Seq uncertaintyResults = (Seq)predictionResult.getUncertainty(predictionResult.getUncertainty$default$1()).get().flatten(Predef$.MODULE$.$conforms());
        return this.send1DArray(uncertaintyResults);
    }

    public byte[] getRegressionCorrelation(MultiTaskModelPredictionResult predictionResult, int i, int j) {
        Seq<Object> correlationResults = predictionResult.getUncertaintyCorrelation(i, j, predictionResult.getUncertaintyCorrelation$default$3()).get();
        return this.send1DArray(correlationResults);
    }

    public byte[] send1DArray(Seq<Object> data) {
        ByteBuffer buffer = ByteBuffer.allocate(data.length() * 8).order(ByteOrder.nativeOrder());
        data.foreach((Function1<Object, ByteBuffer> & Serializable)x$1 -> buffer.putDouble(BoxesRunTime.unboxToDouble(x$1)));
        return buffer.array();
    }

    public byte[] getClassifierExpected(PredictionResult<Object> predictionResult) {
        Seq<Object> expect = predictionResult.getExpected();
        ByteBuffer buffer = ByteBuffer.allocate(expect.length() * 4).order(ByteOrder.nativeOrder());
        expect.foreach((Function1<Object, ByteBuffer> & Serializable)x$1 -> buffer.putInt(BoxesRunTime.unboxToInt(x$1)));
        return buffer.array();
    }

    public byte[] getClassifierProbabilities(PredictionResult<Object> predictionResult, int nClasses) {
        Range classes = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nClasses);
        Seq probs = (Seq)predictionResult.getUncertainty(predictionResult.getUncertainty$default$1()).get().map((Function1<Map, IndexedSeq> & Serializable)x -> classes.map(i -> BoxesRunTime.unboxToDouble(x.getOrElse(BoxesRunTime.boxToInteger(i), () -> 0.0))));
        ByteBuffer buffer = ByteBuffer.allocate(nClasses * probs.length() * 8).order(ByteOrder.nativeOrder());
        ((IterableOnceOps)probs.flatten(Predef$.MODULE$.$conforms())).foreach((Function1<Object, ByteBuffer> & Serializable)x$1 -> buffer.putDouble(BoxesRunTime.unboxToDouble(x$1)));
        return buffer.array();
    }

    public byte[] serializeObject(Object obj, int compressLevel) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DeflaterOutputStream compressedStream = new DeflaterOutputStream((OutputStream)stream, new Deflater(compressLevel));
        ObjectOutputStream oos = new ObjectOutputStream(compressedStream);
        oos.writeObject(obj);
        oos.close();
        compressedStream.close();
        return stream.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public Object deserializeObject(byte[] bytes) {
        void var3_3;
        ObjectInputStream stream = new ObjectInputStream(new InflaterInputStream(new ByteArrayInputStream(bytes)));
        Object obj = stream.readObject();
        stream.close();
        return var3_3;
    }

    public PredictionResult<Object> makeRegressionPredictionResult(Seq<Object> expected, Seq<Object> uncertainty2) {
        return new PredictionResult<Object>(expected, uncertainty2){
            private final Seq expected$1;
            private final Seq uncertainty$1;

            public Option<Seq<Seq<Object>>> getImportanceScores() {
                return PredictionResult.getImportanceScores$(this);
            }

            public Option<Seq<Seq<Object>>> getInfluenceScores(Seq<Object> actuals) {
                return PredictionResult.getInfluenceScores$(this, actuals);
            }

            public Option<Seq<Vector<Object>>> getGradient() {
                return PredictionResult.getGradient$(this);
            }

            public Seq<Object> getExpected() {
                return this.expected$1;
            }

            public Option<Seq<Object>> getUncertainty(boolean includeNoise) {
                return new Some<Seq<Object>>(this.uncertainty$1);
            }

            public boolean getUncertainty$default$1() {
                return true;
            }
            {
                this.expected$1 = expected$1;
                this.uncertainty$1 = uncertainty$1;
                PredictionResult.$init$(this);
            }
        };
    }

    private LoloPyDataLoader$() {
    }
}

