/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Graphics2D;
import org.knowm.xchart.DialChartBuilder;
import org.knowm.xchart.DialSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_Pie;
import org.knowm.xchart.internal.chartpart.Plot_Dial;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyle;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyleCycler;
import org.knowm.xchart.style.DialStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.Theme;

public class DialChart
extends Chart<DialStyler, DialSeries> {
    public DialChart(int width, int height) {
        super(width, height, new DialStyler());
        this.plot = new Plot_Dial<DialStyler, DialSeries>(this);
        this.legend = new Legend_Pie<DialStyler, DialSeries>(this);
    }

    public DialChart(int width, int height, Theme theme) {
        this(width, height);
        ((DialStyler)this.styler).setTheme(theme);
    }

    public DialChart(int width, int height, Styler.ChartTheme chartTheme) {
        this(width, height, chartTheme.newInstance(chartTheme));
    }

    public DialChart(DialChartBuilder chartBuilder) {
        this(chartBuilder.width, chartBuilder.height, chartBuilder.chartTheme);
        this.setTitle(chartBuilder.title);
    }

    public DialSeries addSeries(String seriesName, double value2) {
        return this.addSeries(seriesName, value2, null);
    }

    public DialSeries addSeries(String seriesName, double value2, String annotation) {
        this.sanityCheck(seriesName, value2);
        DialSeries series = new DialSeries(seriesName, value2, annotation);
        this.seriesMap.put(seriesName, series);
        return series;
    }

    private void sanityCheck(String seriesName, double value2) {
        if (this.seriesMap.keySet().contains(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series!!!");
        }
        if (value2 < 0.0 || value2 > 1.0) {
            throw new IllegalArgumentException("Value must be in [0, 1] range!!!");
        }
    }

    @Override
    public void paint(Graphics2D g, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.setSeriesStyles();
        this.paintBackground(g);
        this.plot.paint(g);
        this.chartTitle.paint(g);
        this.legend.paint(g);
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((DialStyler)this.getStyler()).getSeriesColors(), ((DialStyler)this.getStyler()).getSeriesMarkers(), ((DialStyler)this.getStyler()).getSeriesLines());
        for (DialSeries series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() == null) {
                series.setFillColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getMarker() == null) {
                series.setMarker(seriesColorMarkerLineStyle.getMarker());
            }
            if (series.getMarkerColor() != null) continue;
            series.setMarkerColor(seriesColorMarkerLineStyle.getColor());
        }
    }
}

