/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_;
import org.knowm.xchart.internal.chartpart.NumberFormatter;
import org.knowm.xchart.internal.chartpart.StringFormatter;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.AxesChartStyler;

class AxisTickCalculator_Override
extends AxisTickCalculator_ {
    public AxisTickCalculator_Override(Axis.Direction axisDirection, double workingSpace, double minValue, double maxValue, AxesChartStyler styler, Map<Double, Object> labelOverrideMap) {
        super(axisDirection, workingSpace, minValue, maxValue, styler);
        this.axisFormat = new NumberFormatter(styler, axisDirection, minValue, maxValue);
        this.calculate(labelOverrideMap);
    }

    public AxisTickCalculator_Override(Axis.Direction axisDirection, double workingSpace, AxesChartStyler styler, Map<Double, Object> markMap, Series.DataType axisType, int categoryCount) {
        super(axisDirection, workingSpace, Double.NaN, Double.NaN, styler);
        if (axisType == Series.DataType.String) {
            this.axisFormat = new StringFormatter();
        } else if (axisType == Series.DataType.Number) {
            this.axisFormat = new NumberFormatter(styler, axisDirection, this.minValue, this.maxValue);
        } else if (axisType == Series.DataType.Date) {
            if (styler.getDatePattern() == null) {
                throw new RuntimeException("You need to set the Date Formatting Pattern!!!");
            }
            SimpleDateFormat simpleDateformat = new SimpleDateFormat(styler.getDatePattern(), styler.getLocale());
            simpleDateformat.setTimeZone(styler.getTimezone());
            this.axisFormat = simpleDateformat;
        }
        this.calculateForCategory(markMap, categoryCount);
    }

    private void calculate(Map<Double, Object> labelOverrideMap) {
        if (this.minValue == this.maxValue) {
            String label = labelOverrideMap.isEmpty() ? " " : labelOverrideMap.values().iterator().next().toString();
            this.tickLabels.add(label);
            this.tickLocations.add(this.workingSpace / 2.0);
            return;
        }
        double tickSpace = this.styler.getPlotContentSize() * this.workingSpace;
        if (tickSpace < (double)this.styler.getXAxisTickMarkSpacingHint()) {
            return;
        }
        double margin = Utils.getTickStartOffset(this.workingSpace, tickSpace);
        for (Map.Entry<Double, Object> entry : labelOverrideMap.entrySet()) {
            Object value2 = entry.getValue();
            String tickLabel = value2 == null ? " " : value2.toString();
            this.tickLabels.add(tickLabel);
            double tickLabelPosition = margin + (entry.getKey() - this.minValue) / (this.maxValue - this.minValue) * tickSpace;
            this.tickLocations.add(tickLabelPosition);
        }
    }

    private void calculateForCategory(Map<Double, Object> locationLabelMap, int categoryCount) {
        double tickSpace = this.styler.getPlotContentSize() * this.workingSpace;
        double margin = Utils.getTickStartOffset(this.workingSpace, tickSpace);
        double gridStep = tickSpace / (double)categoryCount;
        double firstPosition = gridStep / 2.0;
        for (Map.Entry<Double, Object> entry : locationLabelMap.entrySet()) {
            Object value2 = entry.getValue();
            String tickLabel = value2 == null ? " " : value2.toString();
            this.tickLabels.add(tickLabel);
            double tickLabelPosition = margin + firstPosition + gridStep * entry.getKey();
            this.tickLocations.add(tickLabelPosition);
        }
    }
}

