/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.style.AxesChartStyler;

class NumberFormatter
extends Format {
    private final AxesChartStyler styler;
    private final Axis.Direction axisDirection;
    private final double min;
    private final double max;
    private final NumberFormat numberFormat;

    public NumberFormatter(AxesChartStyler styler, Axis.Direction axisDirection, double min2, double max2) {
        this.styler = styler;
        this.axisDirection = axisDirection;
        this.min = min2;
        this.max = max2;
        this.numberFormat = NumberFormat.getNumberInstance(styler.getLocale());
    }

    private String getFormatPattern(double value2) {
        if (BigDecimal.valueOf(value2).compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        double difference = this.max - this.min;
        int placeOfDifference = difference == 0.0 ? 0 : (int)Math.floor(Math.log(difference) / Math.log(10.0));
        int placeOfValue = value2 == 0.0 ? 0 : (int)Math.floor(Math.log(value2) / Math.log(10.0));
        if (placeOfDifference <= 4 && placeOfDifference >= -4) {
            return this.getNormalDecimalPatternPositive(placeOfValue, placeOfDifference);
        }
        return "0.###############E0";
    }

    private String getNormalDecimalPatternPositive(int placeOfValue, int placeOfDifference) {
        int maxNumPlaces = 15;
        StringBuilder sb = new StringBuilder();
        for (int i = maxNumPlaces - 1; i >= -1 * maxNumPlaces; --i) {
            if (i >= 0 && i < placeOfValue) {
                sb.append("0");
            } else if (i < 0 && i > placeOfValue) {
                sb.append("0");
            } else {
                sb.append("#");
            }
            if (i % 3 == 0 && i > 0) {
                sb.append(",");
            }
            if (i != 0) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        Number number = (Number)obj;
        String decimalPattern = this.axisDirection == Axis.Direction.X && this.styler.getXAxisDecimalPattern() != null ? this.styler.getXAxisDecimalPattern() : (this.axisDirection == Axis.Direction.Y && this.styler.getYAxisDecimalPattern() != null ? this.styler.getYAxisDecimalPattern() : (this.styler.getDecimalPattern() != null ? this.styler.getDecimalPattern() : this.getFormatPattern(number.doubleValue())));
        DecimalFormat normalFormat = (DecimalFormat)this.numberFormat;
        normalFormat.applyPattern(decimalPattern);
        toAppendTo.append(normalFormat.format(number));
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }
}

