/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.Map;
import org.knowm.xchart.BubbleSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.BubbleStyler;
import org.knowm.xchart.style.Styler;

public class PlotContent_Bubble<ST extends BubbleStyler, S extends BubbleSeries>
extends PlotContent_<ST, S> {
    private final ST stylerBubble;

    PlotContent_Bubble(Chart<ST, S> chart) {
        super(chart);
        this.stylerBubble = (BubbleStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g) {
        double xTickSpace = ((Styler)this.stylerBubble).getPlotContentSize() * this.getBounds().getWidth();
        double xLeftMargin = Utils.getTickStartOffset((int)this.getBounds().getWidth(), xTickSpace);
        double yTickSpace = ((Styler)this.stylerBubble).getPlotContentSize() * this.getBounds().getHeight();
        double yTopMargin = Utils.getTickStartOffset((int)this.getBounds().getHeight(), yTickSpace);
        double xMin = this.chart.getXAxis().getMin();
        double xMax = this.chart.getXAxis().getMax();
        if (((AxesChartStyler)this.stylerBubble).isXAxisLogarithmic()) {
            xMin = Math.log10(xMin);
            xMax = Math.log10(xMax);
        }
        Map map = this.chart.getSeriesMap();
        for (BubbleSeries series : map.values()) {
            if (!series.isEnabled()) continue;
            double yMin = this.chart.getYAxis(series.getYAxisGroup()).getMin();
            double yMax = this.chart.getYAxis(series.getYAxisGroup()).getMax();
            if (((AxesChartStyler)this.stylerBubble).isYAxisLogarithmic()) {
                yMin = Math.log10(yMin);
                yMax = Math.log10(yMax);
            }
            for (int i = 0; i < series.getXData().length; ++i) {
                double x = series.getXData()[i];
                if (((AxesChartStyler)this.stylerBubble).isXAxisLogarithmic()) {
                    x = Math.log10(x);
                }
                if (Double.isNaN(series.getYData()[i])) continue;
                double yOrig = series.getYData()[i];
                double y = ((AxesChartStyler)this.stylerBubble).isYAxisLogarithmic() ? Math.log10(yOrig) : yOrig;
                double xTransform = xLeftMargin + (x - xMin) / (xMax - xMin) * xTickSpace;
                double yTransform = this.getBounds().getHeight() - (yTopMargin + (y - yMin) / (yMax - yMin) * yTickSpace);
                if (Math.abs(xMax - xMin) / 5.0 == 0.0) {
                    xTransform = this.getBounds().getWidth() / 2.0;
                }
                if (Math.abs(yMax - yMin) / 5.0 == 0.0) {
                    yTransform = this.getBounds().getHeight() / 2.0;
                }
                double xOffset = this.getBounds().getX() + xTransform;
                double yOffset = this.getBounds().getY() + yTransform;
                if (series.getExtraValues() == null) continue;
                double bubbleSize = series.getExtraValues()[i];
                Ellipse2D.Double bubble = new Ellipse2D.Double(xOffset - bubbleSize / 2.0, yOffset - bubbleSize / 2.0, bubbleSize, bubbleSize);
                g.setColor(series.getFillColor());
                g.fill(bubble);
                g.setColor(series.getLineColor());
                g.setStroke(series.getLineStyle());
                g.draw(bubble);
                this.chart.toolTips.addData(bubble, xOffset, yOffset, 0.0, this.chart.getXAxisFormat().format(x), this.chart.getYAxisFormat().format(yOrig));
            }
        }
    }
}

