/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import org.knowm.xchart.DialSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.internal.chartpart.PlotContent_Pie;
import org.knowm.xchart.style.DialStyler;
import org.knowm.xchart.style.Styler;

public class PlotContent_Dial<ST extends DialStyler, S extends DialSeries>
extends PlotContent_<ST, S> {
    private final ST styler;
    private final NumberFormat df = DecimalFormat.getPercentInstance();

    PlotContent_Dial(Chart<ST, S> chart) {
        super(chart);
        this.styler = (DialStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g) {
        double pieFillPercentage = ((Styler)this.styler).getPlotContentSize();
        double halfBorderPercentage = (1.0 - pieFillPercentage) / 2.0;
        double boundsWidth = this.getBounds().getWidth();
        double boundsHeight = this.getBounds().getHeight();
        double min2 = Math.min(boundsWidth, boundsHeight);
        double width = ((DialStyler)this.styler).isCircular() ? min2 : boundsWidth;
        double height = ((DialStyler)this.styler).isCircular() ? min2 : boundsHeight;
        Rectangle2D.Double pieBounds = new Rectangle2D.Double(this.getBounds().getX() + boundsWidth / 2.0 - width / 2.0 + halfBorderPercentage * width, this.getBounds().getY() + boundsHeight / 2.0 - height / 2.0 + halfBorderPercentage * height, width * pieFillPercentage, height * pieFillPercentage);
        boolean axisTickLabelsVisible = ((DialStyler)this.styler).isAxisTickLabelsVisible();
        double arcAngle = ((DialStyler)this.styler).getArcAngle();
        double donutThickness = ((DialStyler)this.styler).getDonutThickness();
        int axisTitlePadding = ((DialStyler)this.styler).getAxisTitlePadding();
        double[] axisTickValues = ((DialStyler)this.styler).getAxisTickValues();
        int markCount = axisTickValues.length;
        String[] axisTickLabels = ((DialStyler)this.styler).getAxisTickLabels();
        double[] fromArr = new double[]{((DialStyler)this.styler).getNormalFrom(), ((DialStyler)this.styler).getGreenFrom(), ((DialStyler)this.styler).getRedFrom()};
        double[] toArr = new double[]{((DialStyler)this.styler).getNormalTo(), ((DialStyler)this.styler).getGreenTo(), ((DialStyler)this.styler).getRedTo()};
        Color[] donutColorArr = new Color[]{((DialStyler)this.styler).getNormalColor(), ((DialStyler)this.styler).getGreenColor(), ((DialStyler)this.styler).getRedColor()};
        double dountStartAngle = arcAngle / 2.0 + 90.0;
        for (int i = 0; i < donutColorArr.length; ++i) {
            double to = toArr[i];
            double from = fromArr[i];
            if (to <= from || to < 0.0 || from < 0.0) continue;
            double totalAngle = (to - from) * arcAngle;
            double startAngle = dountStartAngle - from * arcAngle - totalAngle;
            Shape donutSlice = PlotContent_Pie.getDonutSliceShape(pieBounds, donutThickness, startAngle, totalAngle);
            g.setColor(donutColorArr[i]);
            g.fill(donutSlice);
            g.draw(donutSlice);
        }
        double xDiameter = ((RectangularShape)pieBounds).getWidth() / 2.0;
        double yDiameter = ((RectangularShape)pieBounds).getHeight() / 2.0;
        double xCenter = ((RectangularShape)pieBounds).getX() + xDiameter;
        double yCenter = ((RectangularShape)pieBounds).getY() + yDiameter;
        if (markCount > 0 && ((DialStyler)this.styler).isAxisTicksMarksVisible()) {
            g.setColor(((DialStyler)this.styler).getAxisTickMarksColor());
            g.setStroke(((DialStyler)this.styler).getAxisTickMarksStroke());
            for (int i = 0; i < markCount; ++i) {
                double xc;
                double angle = -axisTickValues[i] * arcAngle + arcAngle / 2.0 + 90.0;
                double radians = Math.toRadians(angle);
                double cos = Math.cos(radians);
                double sin = Math.sin(radians);
                double xOffset = xCenter + cos * xDiameter;
                double yOffset = yCenter - sin * yDiameter;
                double xOffset2 = xCenter + cos * xDiameter * (1.0 - donutThickness);
                double yOffset2 = yCenter - sin * yDiameter * (1.0 - donutThickness);
                Line2D.Double line = new Line2D.Double(xOffset2, yOffset2, xOffset, yOffset);
                g.setColor(((DialStyler)this.styler).getAxisTickMarksColor());
                g.setStroke(((DialStyler)this.styler).getAxisTickMarksStroke());
                g.draw(line);
                if (!axisTickLabelsVisible) continue;
                String annotation = axisTickLabels[i];
                TextLayout textLayout = new TextLayout(annotation, ((DialStyler)this.styler).getAxisTitleFont(), new FontRenderContext(null, true, false));
                Shape shape = textLayout.getOutline(null);
                Rectangle2D annotationBounds = shape.getBounds2D();
                double annotationWidth = annotationBounds.getWidth();
                double annotationHeight = annotationBounds.getHeight();
                double yc = 0.0;
                if (axisTickValues[i] < 0.49) {
                    xc = 0.0;
                } else if (axisTickValues[i] > 0.51) {
                    xc = -annotationWidth;
                } else {
                    xc = -annotationWidth / 2.0;
                    yc = annotationHeight / 2.0;
                }
                xOffset2 = xCenter + cos * (xDiameter - (double)axisTitlePadding) * (1.0 - donutThickness);
                yOffset2 = yCenter - sin * (yDiameter - (double)axisTitlePadding) * (1.0 - donutThickness);
                double tx = xOffset2 + xc;
                double ty = yOffset2 + yc + annotationHeight / 2.0;
                g.setColor(((Styler)this.styler).getChartFontColor());
                g.setFont(((Styler)this.styler).getAnnotationsFont());
                AffineTransform orig = g.getTransform();
                AffineTransform at = new AffineTransform();
                at.translate(tx, ty);
                g.transform(at);
                g.fill(shape);
                g.setTransform(orig);
            }
        }
        Map map = this.chart.getSeriesMap();
        for (DialSeries series : map.values()) {
            double[][] angleValues;
            if (!series.isEnabled()) continue;
            if (((DialStyler)this.styler).isAxisTitleVisible()) {
                TextLayout textLayout = new TextLayout(series.getName(), ((DialStyler)this.styler).getAxisTitleFont(), new FontRenderContext(null, true, false));
                Shape shape = textLayout.getOutline(null);
                Rectangle2D annotationBounds = shape.getBounds2D();
                double annotationWidth = annotationBounds.getWidth();
                double annotationHeight = annotationBounds.getHeight();
                double tx = xCenter - annotationWidth / 2.0;
                double ty = yCenter - yDiameter / 2.0 + annotationHeight / 2.0;
                g.setColor(((Styler)this.styler).getChartFontColor());
                g.setFont(((DialStyler)this.styler).getAxisTitleFont());
                AffineTransform orig = g.getTransform();
                AffineTransform at = new AffineTransform();
                at.translate(tx, ty);
                g.transform(at);
                g.fill(shape);
                g.setTransform(orig);
            }
            double value2 = series.getValue();
            if (((Styler)this.styler).hasAnnotations().booleanValue()) {
                String annotation = series.getAnnotation();
                if (annotation == null) {
                    if (((Styler)this.styler).getDecimalPattern() != null) {
                        DecimalFormat df = new DecimalFormat(((Styler)this.styler).getDecimalPattern());
                        annotation = df.format(value2);
                    } else {
                        annotation = this.df.format(value2);
                    }
                }
                if (!annotation.isEmpty()) {
                    TextLayout textLayout = new TextLayout(annotation, ((Styler)this.styler).getAnnotationsFont(), new FontRenderContext(null, true, false));
                    Shape shape = textLayout.getOutline(null);
                    Rectangle2D annotationBounds = shape.getBounds2D();
                    double annotationWidth = annotationBounds.getWidth();
                    double annotationHeight = annotationBounds.getHeight();
                    double tx = xCenter - annotationWidth / 2.0;
                    double ty = yCenter + yDiameter / 2.0 - annotationHeight / 2.0;
                    g.setColor(((Styler)this.styler).getChartFontColor());
                    g.setFont(((DialStyler)this.styler).getAxisTitleFont());
                    AffineTransform orig = g.getTransform();
                    AffineTransform at = new AffineTransform();
                    at.translate(tx, ty);
                    g.transform(at);
                    g.fill(shape);
                    g.setTransform(orig);
                }
            }
            double angle = -value2 * arcAngle + arcAngle / 2.0 + 90.0;
            double radians = Math.toRadians(angle);
            double arrowLengthPercentage = ((DialStyler)this.styler).getArrowLengthPercentage();
            double arrowArcAngle = ((DialStyler)this.styler).getArrowArcAngle();
            double arrowArcPercentage = ((DialStyler)this.styler).getArrowArcPercentage();
            double xOffset = xCenter + Math.cos(radians) * (xDiameter * arrowLengthPercentage);
            double yOffset = yCenter - Math.sin(radians) * (yDiameter * arrowLengthPercentage);
            Path2D.Double path = new Path2D.Double();
            if (((Styler)this.styler).isToolTipsEnabled()) {
                String annotation = series.getAnnotation();
                if (annotation == null) {
                    if (((Styler)this.styler).getDecimalPattern() != null) {
                        DecimalFormat df = new DecimalFormat(((Styler)this.styler).getDecimalPattern());
                        annotation = df.format(value2);
                    } else {
                        annotation = this.df.format(value2);
                    }
                }
                this.chart.toolTips.addData(path, xOffset, yOffset + 10.0, 0.0, annotation);
            }
            path.moveTo(xCenter, yCenter);
            for (double[] ds : angleValues = new double[][]{{-arrowArcAngle, arrowArcPercentage}, {0.0, 1.0}, {arrowArcAngle, arrowArcPercentage}}) {
                radians = Math.toRadians(angle - ds[0]);
                double diameterPerct = arrowLengthPercentage * ds[1];
                xOffset = xCenter + Math.cos(radians) * (xDiameter * diameterPerct);
                yOffset = yCenter - Math.sin(radians) * (yDiameter * diameterPerct);
                path.lineTo(xOffset, yOffset);
            }
            path.closePath();
            g.setColor(series.getFillColor());
            g.fill(path);
            g.setColor(series.getLineColor());
            g.draw(path);
        }
    }
}

