/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import com.sun.xml.internal.ws.encoding.soap.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import sun.misc.Cleaner;

public class ObjectLargeArray
extends LargeArray {
    private static final long serialVersionUID = -4096759496772248522L;
    private Object[] data;
    private ShortLargeArray objectLengths;
    private int maxObjectLength;
    private long size;
    private byte[] byteArray;

    public ObjectLargeArray(long length) {
        this(length, 1024);
    }

    public ObjectLargeArray(long length, int maxObjectLength) {
        this(length, maxObjectLength, true);
    }

    public ObjectLargeArray(long length, int maxObjectLength, boolean zeroNativeMemory) {
        this.type = LargeArrayType.OBJECT;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value.");
        }
        if (maxObjectLength <= 0) {
            throw new IllegalArgumentException(maxObjectLength + " is not a positive int value.");
        }
        this.length = length;
        this.size = length * (long)maxObjectLength;
        this.maxObjectLength = maxObjectLength;
        if (length > (long)ObjectLargeArray.getMaxSizeOf32bitArray()) {
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.size * this.sizeof);
            if (zeroNativeMemory) {
                this.zeroNativeMemory(this.size);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.size, this.sizeof));
            MemoryCounter.increaseCounter(this.size * this.sizeof);
            this.objectLengths = new ShortLargeArray(length);
            this.byteArray = new byte[maxObjectLength];
        } else {
            this.data = new Object[(int)length];
        }
    }

    public ObjectLargeArray(long length, Object constantValue) {
        this.type = LargeArrayType.OBJECT;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.isConstant = true;
        this.data = new Object[]{constantValue};
    }

    public ObjectLargeArray(Object[] data) {
        this.type = LargeArrayType.OBJECT;
        this.sizeof = 1L;
        this.length = data.length;
        this.data = data;
    }

    @Override
    public ObjectLargeArray clone() {
        if (this.isConstant) {
            return new ObjectLargeArray(this.length, this.get(0L));
        }
        ObjectLargeArray v = new ObjectLargeArray(this.length, FastMath.max(1, this.maxObjectLength), false);
        LargeArrayUtils.arraycopy(this, 0L, v, 0L, this.length);
        return v;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            boolean res;
            ObjectLargeArray la = (ObjectLargeArray)o;
            boolean bl = res = this.maxObjectLength == la.maxObjectLength && this.data == la.data;
            if (this.objectLengths != null && la.objectLengths != null) {
                return res && this.objectLengths.equals(la.objectLengths);
            }
            if (this.objectLengths == la.objectLengths) {
                return res;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash2 = 29 * super.hashCode() + (this.data != null ? this.data.hashCode() : 0);
        hash2 = 29 * hash2 + (this.maxObjectLength ^ this.maxObjectLength >>> 16);
        return 29 * hash2 + (this.objectLengths != null ? this.objectLengths.hashCode() : 0);
    }

    @Override
    public final Object get(long i) {
        if (this.ptr != 0L) {
            int objLen = this.objectLengths.getShort(i);
            if (objLen < 0) {
                return null;
            }
            long offset = this.sizeof * i * (long)this.maxObjectLength;
            for (int j = 0; j < objLen; ++j) {
                this.byteArray[j] = LargeArrayUtils.UNSAFE.getByte(this.ptr + offset + this.sizeof * (long)j);
            }
            return ObjectLargeArray.fromByteArray(this.byteArray);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public final Object getFromNative(long i) {
        int objLen = this.objectLengths.getShort(i);
        if (objLen < 0) {
            return null;
        }
        long offset = this.sizeof * i * (long)this.maxObjectLength;
        for (int j = 0; j < objLen; ++j) {
            this.byteArray[j] = LargeArrayUtils.UNSAFE.getByte(this.ptr + offset + this.sizeof * (long)j);
        }
        return ObjectLargeArray.fromByteArray(this.byteArray);
    }

    @Override
    public final boolean getBoolean(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final byte getByte(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final short getUnsignedByte(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final short getShort(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final int getInt(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final long getLong(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final float getFloat(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final double getDouble(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public final Object[] getData() {
        return this.data;
    }

    @Override
    public final boolean[] getBooleanData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final byte[] getByteData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final short[] getShortData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final short[] getShortData(short[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final int[] getIntData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final int[] getIntData(int[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final long[] getLongData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final long[] getLongData(long[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final float[] getFloatData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final double[] getDoubleData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setToNative(long i, Object value2) {
        if (value2 == null) {
            this.objectLengths.setShort(i, (short)-1);
        } else {
            byte[] ba = ObjectLargeArray.toByteArray(value2);
            if (ba.length > this.maxObjectLength) {
                throw new IllegalArgumentException("Object  " + value2 + " is too long.");
            }
            int objLen = ba.length;
            if (objLen > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Object  " + value2 + " is too long.");
            }
            this.objectLengths.setShort(i, (short)objLen);
            long offset = this.sizeof * i * (long)this.maxObjectLength;
            for (int j = 0; j < objLen; ++j) {
                LargeArrayUtils.UNSAFE.putByte(this.ptr + offset + this.sizeof * (long)j, ba[j]);
            }
        }
    }

    @Override
    public final void set(long i, Object o) {
        if (o == null) {
            if (this.ptr != 0L) {
                this.objectLengths.setShort(i, (short)-1);
            } else {
                if (this.isConstant) {
                    throw new IllegalAccessError("Constant arrays cannot be modified.");
                }
                this.data[(int)i] = null;
            }
        } else if (this.ptr != 0L) {
            byte[] ba = ObjectLargeArray.toByteArray(o);
            if (ba.length > this.maxObjectLength) {
                throw new IllegalArgumentException("Object  " + o + " is too long.");
            }
            int objLen = ba.length;
            if (objLen > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Object  " + o + " is too long.");
            }
            this.objectLengths.setShort(i, (short)objLen);
            long offset = this.sizeof * i * (long)this.maxObjectLength;
            for (int j = 0; j < objLen; ++j) {
                LargeArrayUtils.UNSAFE.putByte(this.ptr + offset + this.sizeof * (long)j, ba[j]);
            }
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = o;
        }
    }

    @Override
    public final void set_safe(long i, Object value2) {
        if (i < 0L || i >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(i));
        }
        this.set(i, value2);
    }

    @Override
    public final void setBoolean(long i, boolean value2) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setByte(long i, byte value2) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setUnsignedByte(long i, short value2) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setShort(long i, short value2) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setInt(long i, int value2) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setLong(long i, long value2) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setFloat(long i, float value2) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setDouble(long i, double value2) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    private static byte[] toByteArray(Object obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
        }
        catch (Exception ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    private static Object fromByteArray(byte[] objectData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        ObjectInputStream ois = null;
        try {
            Object obj;
            ois = new ObjectInputStream(bais);
            Object object = obj = ois.readObject();
            return object;
        }
        catch (Exception ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public int getMaxObjectLength() {
        return this.maxObjectLength;
    }
}

