/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.AdditiveCommutativeMonoid;
import algebra.ring.AdditiveCommutativeSemigroup;
import algebra.ring.AdditiveMonoid;
import algebra.ring.AdditiveSemigroup;
import algebra.ring.MultiplicativeSemigroup;
import algebra.ring.Ring;
import algebra.ring.Semiring;
import cats.kernel.CommutativeMonoid;
import cats.kernel.Eq;
import cats.kernel.Order;
import cats.kernel.Semigroup;
import java.io.Serializable;
import scala.Double$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;
import spire.math.Above$;
import spire.math.All$;
import spire.math.Below$;
import spire.math.Bounded$;
import spire.math.Empty$;
import spire.math.Interval;
import spire.math.Point$;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.interval.Bound;
import spire.math.interval.Closed;
import spire.math.interval.EmptyBound;
import spire.math.interval.Open;
import spire.math.interval.Unbound;

public final class Interval$
implements Serializable {
    public static final Interval$ MODULE$ = new Interval$();
    private static final Regex NullRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^ *\\( *\u00d8 *\\) *$"));
    private static final Regex SingleRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^ *\\[ *([^,]+) *\\] *$"));
    private static final Regex PairRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^ *(\\[|\\() *(.+?) *, *(.+?) *(\\]|\\)) *$"));

    public <A> Interval<A> withFlags(A lower, A upper, int flags, Order<A> evidence$2) {
        return evidence$2.lt(lower, upper) ? Bounded$.MODULE$.apply(lower, upper, flags) : (evidence$2.eqv(lower, upper) && flags == 0 ? Point$.MODULE$.apply(lower) : this.empty(evidence$2));
    }

    public <A> Interval<A> empty(Order<A> evidence$3) {
        return Empty$.MODULE$.apply();
    }

    public <A> Interval<A> point(A a, Order<A> evidence$4) {
        return Point$.MODULE$.apply(a);
    }

    public <A> Interval<A> zero(Order<A> evidence$5, Semiring<A> r) {
        return Point$.MODULE$.apply(r.zero());
    }

    public <A> Interval<A> all(Order<A> evidence$6) {
        return All$.MODULE$.apply();
    }

    public <A> Interval<A> apply(A lower, A upper, Order<A> evidence$7) {
        return this.closed(lower, upper, evidence$7);
    }

    public Interval<Rational> errorBounds(double d) {
        Interval<Rational> interval;
        if (d == Double.POSITIVE_INFINITY) {
            interval = this.above(Rational$.MODULE$.apply((double)Double.MAX_VALUE), (Order)((Object)Rational$.MODULE$.RationalAlgebra()));
        } else if (d == Double.NEGATIVE_INFINITY) {
            interval = this.below(Rational$.MODULE$.apply(Double$.MODULE$.MinValue()), (Order)((Object)Rational$.MODULE$.RationalAlgebra()));
        } else if (Double.isNaN(d)) {
            interval = this.empty((Order)((Object)Rational$.MODULE$.RationalAlgebra()));
        } else {
            Rational n0 = Rational$.MODULE$.apply(Math.nextAfter(d, -1.0));
            Rational n1 = Rational$.MODULE$.apply(d);
            Rational n2 = Rational$.MODULE$.apply(Math.nextUp(d));
            interval = this.apply(n1.$minus(n0).$div(Rational$.MODULE$.apply(2)).$plus(n0), n2.$minus(n1).$div(Rational$.MODULE$.apply(2)).$plus(n1), (Order)((Object)Rational$.MODULE$.RationalAlgebra()));
        }
        return interval;
    }

    public final int closedLowerFlags() {
        return 0;
    }

    public final int openLowerFlags() {
        return 1;
    }

    public final int closedUpperFlags() {
        return 0;
    }

    public final int openUpperFlags() {
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A> Interval<A> fromOrderedBounds(Bound<A> lower, Bound<A> upper, Order<A> evidence$8) {
        Bound<A> bound;
        Bound<A> bound2;
        Tuple2<Bound<A>, Bound<A>> tuple2 = new Tuple2<Bound<A>, Bound<A>>(lower, upper);
        if (tuple2 != null) {
            Bound<A> bound3 = tuple2._1();
            Bound<A> bound4 = tuple2._2();
            if (bound3 instanceof EmptyBound && bound4 instanceof EmptyBound) {
                return this.empty(evidence$8);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound5 = tuple2._1();
            Bound<A> bound6 = tuple2._2();
            if (bound5 instanceof Closed) {
                Closed closed = (Closed)bound5;
                Object x = closed.a();
                if (bound6 instanceof Closed) {
                    Closed closed2 = (Closed)bound6;
                    Object y = closed2.a();
                    return Bounded$.MODULE$.apply(x, y, this.closedLowerFlags() | this.closedUpperFlags());
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound7 = tuple2._1();
            Bound<A> bound8 = tuple2._2();
            if (bound7 instanceof Open) {
                Open open = (Open)bound7;
                Object x = open.a();
                if (bound8 instanceof Open) {
                    Open open2 = (Open)bound8;
                    Object y = open2.a();
                    return Bounded$.MODULE$.apply(x, y, this.openLowerFlags() | this.openUpperFlags());
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound9 = tuple2._1();
            Bound<A> bound10 = tuple2._2();
            if (bound9 instanceof Unbound && bound10 instanceof Open) {
                Open open = (Open)bound10;
                Object y = open.a();
                return this.below(y, evidence$8);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound11 = tuple2._1();
            Bound<A> bound12 = tuple2._2();
            if (bound11 instanceof Open) {
                Open open = (Open)bound11;
                Object x = open.a();
                if (bound12 instanceof Unbound) {
                    return this.above(x, evidence$8);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound13 = tuple2._1();
            Bound<A> bound14 = tuple2._2();
            if (bound13 instanceof Unbound && bound14 instanceof Closed) {
                Closed closed = (Closed)bound14;
                Object y = closed.a();
                return this.atOrBelow(y, evidence$8);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound15 = tuple2._1();
            Bound<A> bound16 = tuple2._2();
            if (bound15 instanceof Closed) {
                Closed closed = (Closed)bound15;
                Object x = closed.a();
                if (bound16 instanceof Unbound) {
                    return this.atOrAbove(x, evidence$8);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound17 = tuple2._1();
            Bound<A> bound18 = tuple2._2();
            if (bound17 instanceof Closed) {
                Closed closed = (Closed)bound17;
                Object x = closed.a();
                if (bound18 instanceof Open) {
                    Open open = (Open)bound18;
                    Object y = open.a();
                    return Bounded$.MODULE$.apply(x, y, this.closedLowerFlags() | this.openUpperFlags());
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound19 = tuple2._1();
            Bound<A> bound20 = tuple2._2();
            if (bound19 instanceof Open) {
                Open open = (Open)bound19;
                Object x = open.a();
                if (bound20 instanceof Closed) {
                    Closed closed = (Closed)bound20;
                    Object y = closed.a();
                    return Bounded$.MODULE$.apply(x, y, this.openLowerFlags() | this.closedUpperFlags());
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound21 = tuple2._1();
            Bound<A> bound22 = tuple2._2();
            if (bound21 instanceof Unbound && bound22 instanceof Unbound) {
                return this.all(evidence$8);
            }
        }
        boolean bl = tuple2 != null && (bound2 = tuple2._1()) instanceof EmptyBound ? true : tuple2 != null && (bound = tuple2._2()) instanceof EmptyBound;
        if (!bl) throw new MatchError(tuple2);
        throw new IllegalArgumentException("invalid empty bound");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A> Interval<A> fromBounds(Bound<A> lower, Bound<A> upper, Order<A> evidence$9) {
        Bound<A> bound;
        Bound<A> bound2;
        Tuple2<Bound<A>, Bound<A>> tuple2 = new Tuple2<Bound<A>, Bound<A>>(lower, upper);
        if (tuple2 != null) {
            Bound<A> bound3 = tuple2._1();
            Bound<A> bound4 = tuple2._2();
            if (bound3 instanceof EmptyBound && bound4 instanceof EmptyBound) {
                return this.empty(evidence$9);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound5 = tuple2._1();
            Bound<A> bound6 = tuple2._2();
            if (bound5 instanceof Closed) {
                Closed closed = (Closed)bound5;
                Object x = closed.a();
                if (bound6 instanceof Closed) {
                    Closed closed2 = (Closed)bound6;
                    Object y = closed2.a();
                    return this.closed(x, y, evidence$9);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound7 = tuple2._1();
            Bound<A> bound8 = tuple2._2();
            if (bound7 instanceof Open) {
                Open open = (Open)bound7;
                Object x = open.a();
                if (bound8 instanceof Open) {
                    Open open2 = (Open)bound8;
                    Object y = open2.a();
                    return this.open(x, y, evidence$9);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound9 = tuple2._1();
            Bound<A> bound10 = tuple2._2();
            if (bound9 instanceof Unbound && bound10 instanceof Open) {
                Open open = (Open)bound10;
                Object y = open.a();
                return this.below(y, evidence$9);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound11 = tuple2._1();
            Bound<A> bound12 = tuple2._2();
            if (bound11 instanceof Open) {
                Open open = (Open)bound11;
                Object x = open.a();
                if (bound12 instanceof Unbound) {
                    return this.above(x, evidence$9);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound13 = tuple2._1();
            Bound<A> bound14 = tuple2._2();
            if (bound13 instanceof Unbound && bound14 instanceof Closed) {
                Closed closed = (Closed)bound14;
                Object y = closed.a();
                return this.atOrBelow(y, evidence$9);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound15 = tuple2._1();
            Bound<A> bound16 = tuple2._2();
            if (bound15 instanceof Closed) {
                Closed closed = (Closed)bound15;
                Object x = closed.a();
                if (bound16 instanceof Unbound) {
                    return this.atOrAbove(x, evidence$9);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound17 = tuple2._1();
            Bound<A> bound18 = tuple2._2();
            if (bound17 instanceof Closed) {
                Closed closed = (Closed)bound17;
                Object x = closed.a();
                if (bound18 instanceof Open) {
                    Open open = (Open)bound18;
                    Object y = open.a();
                    return this.openUpper(x, y, evidence$9);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound19 = tuple2._1();
            Bound<A> bound20 = tuple2._2();
            if (bound19 instanceof Open) {
                Open open = (Open)bound19;
                Object x = open.a();
                if (bound20 instanceof Closed) {
                    Closed closed = (Closed)bound20;
                    Object y = closed.a();
                    return this.openLower(x, y, evidence$9);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound21 = tuple2._1();
            Bound<A> bound22 = tuple2._2();
            if (bound21 instanceof Unbound && bound22 instanceof Unbound) {
                return this.all(evidence$9);
            }
        }
        boolean bl = tuple2 != null && (bound2 = tuple2._1()) instanceof EmptyBound ? true : tuple2 != null && (bound = tuple2._2()) instanceof EmptyBound;
        if (!bl) throw new MatchError(tuple2);
        throw new IllegalArgumentException("invalid empty bound");
    }

    public <A> Interval<A> closed(A lower, A upper, Order<A> evidence$10) {
        int c = evidence$10.compare(lower, upper);
        return c < 0 ? Bounded$.MODULE$.apply(lower, upper, 0) : (c == 0 ? Point$.MODULE$.apply(lower) : this.empty(evidence$10));
    }

    public <A> Interval<A> open(A lower, A upper, Order<A> evidence$11) {
        return evidence$11.lt(lower, upper) ? Bounded$.MODULE$.apply(lower, upper, 3) : this.empty(evidence$11);
    }

    public <A> Interval<A> openLower(A lower, A upper, Order<A> evidence$12) {
        return evidence$12.lt(lower, upper) ? Bounded$.MODULE$.apply(lower, upper, 1) : this.empty(evidence$12);
    }

    public <A> Interval<A> openUpper(A lower, A upper, Order<A> evidence$13) {
        return evidence$13.lt(lower, upper) ? Bounded$.MODULE$.apply(lower, upper, 2) : this.empty(evidence$13);
    }

    public <A> Interval<A> above(A a, Order<A> evidence$14) {
        return Above$.MODULE$.apply(a, 1);
    }

    public <A> Interval<A> below(A a, Order<A> evidence$15) {
        return Below$.MODULE$.apply(a, 2);
    }

    public <A> Interval<A> atOrAbove(A a, Order<A> evidence$16) {
        return Above$.MODULE$.apply(a, 0);
    }

    public <A> Interval<A> atOrBelow(A a, Order<A> evidence$17) {
        return Below$.MODULE$.apply(a, 0);
    }

    private Regex NullRe() {
        return NullRe;
    }

    private Regex SingleRe() {
        return SingleRe;
    }

    private Regex PairRe() {
        return PairRe;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Interval<Rational> apply(String s) {
        block3: {
            block5: {
                block7: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block6: {
                                                    block4: {
                                                        block2: {
                                                            var4_2 = s;
                                                            if (var4_2 == null || (var5_3 = this.NullRe().unapplySeq(var4_2)).isEmpty() || var5_3.get() == null || var5_3.get().lengthCompare(0) != 0) break block2;
                                                            var2_4 /* !! */  = this.empty((Order)Rational$.MODULE$.RationalAlgebra());
                                                            break block3;
                                                        }
                                                        if (var4_2 == null || (var6_5 = this.SingleRe().unapplySeq(var4_2)).isEmpty() || var6_5.get() == null || var6_5.get().lengthCompare(1) != 0) break block4;
                                                        x = (String)((LinearSeqOps)var6_5.get()).apply(0);
                                                        var2_4 /* !! */  = this.point(Rational$.MODULE$.apply(x), (Order)Rational$.MODULE$.RationalAlgebra());
                                                        break block3;
                                                    }
                                                    if (var4_2 == null || (var8_7 = this.PairRe().unapplySeq(var4_2)).isEmpty() || var8_7.get() == null || var8_7.get().lengthCompare(4) != 0) break block5;
                                                    left = (String)((LinearSeqOps)var8_7.get()).apply(0);
                                                    var13_12 = new Tuple4<String, String, String, String>(left, x = (String)((LinearSeqOps)var8_7.get()).apply(1), y = (String)((LinearSeqOps)var8_7.get()).apply(2), right = (String)((LinearSeqOps)var8_7.get()).apply(3));
                                                    if (var13_12 == null) break block6;
                                                    var14_13 = var13_12._1();
                                                    var15_14 = var13_12._2();
                                                    var16_15 = var13_12._3();
                                                    var17_16 = var13_12._4();
                                                    if (!"(".equals(var14_13) || !"-\u221e".equals(var15_14) || !"\u221e".equals(var16_15) || !")".equals(var17_16)) break block6;
                                                    var3_17 /* !! */  = this.all((Order)Rational$.MODULE$.RationalAlgebra());
                                                    break block7;
                                                }
                                                if (var13_12 == null) break block8;
                                                var18_18 = var13_12._1();
                                                var19_19 = var13_12._2();
                                                y = var13_12._3();
                                                var21_21 = var13_12._4();
                                                if (!"(".equals(var18_18) || !"-\u221e".equals(var19_19) || !")".equals(var21_21)) break block8;
                                                var3_17 /* !! */  = this.below(Rational$.MODULE$.apply(y), (Order)Rational$.MODULE$.RationalAlgebra());
                                                break block7;
                                            }
                                            if (var13_12 == null) break block9;
                                            var22_22 = var13_12._1();
                                            var23_23 = var13_12._2();
                                            y = var13_12._3();
                                            var25_25 = var13_12._4();
                                            if (!"(".equals(var22_22) || !"-\u221e".equals(var23_23) || !"]".equals(var25_25)) break block9;
                                            var3_17 /* !! */  = this.atOrBelow(Rational$.MODULE$.apply(y), (Order)Rational$.MODULE$.RationalAlgebra());
                                            break block7;
                                        }
                                        if (var13_12 == null) break block10;
                                        var26_26 = var13_12._1();
                                        x = var13_12._2();
                                        var28_28 = var13_12._3();
                                        var29_29 = var13_12._4();
                                        if (!"(".equals(var26_26) || !"\u221e".equals(var28_28) || !")".equals(var29_29)) break block10;
                                        var3_17 /* !! */  = this.above(Rational$.MODULE$.apply(x), (Order)Rational$.MODULE$.RationalAlgebra());
                                        break block7;
                                    }
                                    if (var13_12 == null) break block11;
                                    var30_30 = var13_12._1();
                                    x = var13_12._2();
                                    var32_32 = var13_12._3();
                                    var33_33 = var13_12._4();
                                    if (!"[".equals(var30_30) || !"\u221e".equals(var32_32) || !")".equals(var33_33)) break block11;
                                    var3_17 /* !! */  = this.atOrAbove(Rational$.MODULE$.apply(x), (Order)Rational$.MODULE$.RationalAlgebra());
                                    break block7;
                                }
                                if (var13_12 == null) break block12;
                                var34_34 = var13_12._1();
                                x = var13_12._2();
                                y = var13_12._3();
                                var37_37 = var13_12._4();
                                if (!"[".equals(var34_34) || !"]".equals(var37_37)) break block12;
                                var3_17 /* !! */  = this.closed(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), (Order)Rational$.MODULE$.RationalAlgebra());
                                break block7;
                            }
                            if (var13_12 == null) break block13;
                            var38_38 = var13_12._1();
                            x = var13_12._2();
                            y = var13_12._3();
                            var41_41 = var13_12._4();
                            if (!"(".equals(var38_38) || !")".equals(var41_41)) break block13;
                            var3_17 /* !! */  = this.open(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), (Order)Rational$.MODULE$.RationalAlgebra());
                            break block7;
                        }
                        if (var13_12 == null) break block14;
                        var42_42 = var13_12._1();
                        x = var13_12._2();
                        y = var13_12._3();
                        var45_45 = var13_12._4();
                        if (!"[".equals(var42_42) || !")".equals(var45_45)) break block14;
                        var3_17 /* !! */  = this.openUpper(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), (Order)Rational$.MODULE$.RationalAlgebra());
                        break block7;
                    }
                    if (var13_12 == null) ** GOTO lbl-1000
                    var46_46 = var13_12._1();
                    x = var13_12._2();
                    y = var13_12._3();
                    var49_49 = var13_12._4();
                    if ("(".equals(var46_46) && "]".equals(var49_49)) {
                        var3_17 /* !! */  = this.openLower(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), (Order)Rational$.MODULE$.RationalAlgebra());
                    } else lbl-1000:
                    // 2 sources

                    {
                        throw new NumberFormatException(new StringBuilder(12).append("Impossible: ").append(s).toString());
                    }
                }
                var2_4 /* !! */  = var3_17 /* !! */ ;
                break block3;
            }
            throw new NumberFormatException(new StringBuilder(18).append("For input string: ").append(s).toString());
        }
        return var2_4 /* !! */ ;
    }

    public <A> Eq<Interval<A>> eq(Eq<A> evidence$18) {
        return new Eq<Interval<A>>(){

            public boolean eqv$mcZ$sp(boolean x, boolean y) {
                return Eq.eqv$mcZ$sp$(this, x, y);
            }

            public boolean eqv$mcB$sp(byte x, byte y) {
                return Eq.eqv$mcB$sp$(this, x, y);
            }

            public boolean eqv$mcC$sp(char x, char y) {
                return Eq.eqv$mcC$sp$(this, x, y);
            }

            public boolean eqv$mcD$sp(double x, double y) {
                return Eq.eqv$mcD$sp$(this, x, y);
            }

            public boolean eqv$mcF$sp(float x, float y) {
                return Eq.eqv$mcF$sp$(this, x, y);
            }

            public boolean eqv$mcI$sp(int x, int y) {
                return Eq.eqv$mcI$sp$(this, x, y);
            }

            public boolean eqv$mcJ$sp(long x, long y) {
                return Eq.eqv$mcJ$sp$(this, x, y);
            }

            public boolean eqv$mcS$sp(short x, short y) {
                return Eq.eqv$mcS$sp$(this, x, y);
            }

            public boolean eqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Eq.eqv$mcV$sp$(this, x, y);
            }

            public boolean neqv(Object x, Object y) {
                return Eq.neqv$(this, x, y);
            }

            public boolean neqv$mcZ$sp(boolean x, boolean y) {
                return Eq.neqv$mcZ$sp$(this, x, y);
            }

            public boolean neqv$mcB$sp(byte x, byte y) {
                return Eq.neqv$mcB$sp$(this, x, y);
            }

            public boolean neqv$mcC$sp(char x, char y) {
                return Eq.neqv$mcC$sp$(this, x, y);
            }

            public boolean neqv$mcD$sp(double x, double y) {
                return Eq.neqv$mcD$sp$(this, x, y);
            }

            public boolean neqv$mcF$sp(float x, float y) {
                return Eq.neqv$mcF$sp$(this, x, y);
            }

            public boolean neqv$mcI$sp(int x, int y) {
                return Eq.neqv$mcI$sp$(this, x, y);
            }

            public boolean neqv$mcJ$sp(long x, long y) {
                return Eq.neqv$mcJ$sp$(this, x, y);
            }

            public boolean neqv$mcS$sp(short x, short y) {
                return Eq.neqv$mcS$sp$(this, x, y);
            }

            public boolean neqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Eq.neqv$mcV$sp$(this, x, y);
            }

            public boolean eqv(Interval<A> x, Interval<A> y) {
                Interval<A> interval = x;
                Interval<A> interval2 = y;
                return !(interval != null ? !interval.equals(interval2) : interval2 != null);
            }
            {
                Eq.$init$(this);
            }
        };
    }

    public <A> Semiring<Interval<A>> semiring(Ring<A> ev, Order<A> o) {
        return new Semiring<Interval<A>>(ev, o){
            private final Ring ev$4;
            private final Order o$6;

            public Semigroup<Interval<A>> multiplicative() {
                return MultiplicativeSemigroup.multiplicative$(this);
            }

            public Semigroup<Object> multiplicative$mcD$sp() {
                return MultiplicativeSemigroup.multiplicative$mcD$sp$(this);
            }

            public Semigroup<Object> multiplicative$mcF$sp() {
                return MultiplicativeSemigroup.multiplicative$mcF$sp$(this);
            }

            public Semigroup<Object> multiplicative$mcI$sp() {
                return MultiplicativeSemigroup.multiplicative$mcI$sp$(this);
            }

            public Semigroup<Object> multiplicative$mcJ$sp() {
                return MultiplicativeSemigroup.multiplicative$mcJ$sp$(this);
            }

            public double times$mcD$sp(double x, double y) {
                return MultiplicativeSemigroup.times$mcD$sp$(this, x, y);
            }

            public float times$mcF$sp(float x, float y) {
                return MultiplicativeSemigroup.times$mcF$sp$(this, x, y);
            }

            public int times$mcI$sp(int x, int y) {
                return MultiplicativeSemigroup.times$mcI$sp$(this, x, y);
            }

            public long times$mcJ$sp(long x, long y) {
                return MultiplicativeSemigroup.times$mcJ$sp$(this, x, y);
            }

            public double pow$mcD$sp(double a, int n) {
                return MultiplicativeSemigroup.pow$mcD$sp$(this, a, n);
            }

            public float pow$mcF$sp(float a, int n) {
                return MultiplicativeSemigroup.pow$mcF$sp$(this, a, n);
            }

            public int pow$mcI$sp(int a, int n) {
                return MultiplicativeSemigroup.pow$mcI$sp$(this, a, n);
            }

            public long pow$mcJ$sp(long a, int n) {
                return MultiplicativeSemigroup.pow$mcJ$sp$(this, a, n);
            }

            public Object positivePow(Object a, int n) {
                return MultiplicativeSemigroup.positivePow$(this, a, n);
            }

            public double positivePow$mcD$sp(double a, int n) {
                return MultiplicativeSemigroup.positivePow$mcD$sp$(this, a, n);
            }

            public float positivePow$mcF$sp(float a, int n) {
                return MultiplicativeSemigroup.positivePow$mcF$sp$(this, a, n);
            }

            public int positivePow$mcI$sp(int a, int n) {
                return MultiplicativeSemigroup.positivePow$mcI$sp$(this, a, n);
            }

            public long positivePow$mcJ$sp(long a, int n) {
                return MultiplicativeSemigroup.positivePow$mcJ$sp$(this, a, n);
            }

            public Option<Interval<A>> tryProduct(IterableOnce<Interval<A>> as) {
                return MultiplicativeSemigroup.tryProduct$(this, as);
            }

            public CommutativeMonoid<Interval<A>> additive() {
                return AdditiveCommutativeMonoid.additive$(this);
            }

            public CommutativeMonoid<Object> additive$mcD$sp() {
                return AdditiveCommutativeMonoid.additive$mcD$sp$(this);
            }

            public CommutativeMonoid<Object> additive$mcF$sp() {
                return AdditiveCommutativeMonoid.additive$mcF$sp$(this);
            }

            public CommutativeMonoid<Object> additive$mcI$sp() {
                return AdditiveCommutativeMonoid.additive$mcI$sp$(this);
            }

            public CommutativeMonoid<Object> additive$mcJ$sp() {
                return AdditiveCommutativeMonoid.additive$mcJ$sp$(this);
            }

            public double zero$mcD$sp() {
                return AdditiveMonoid.zero$mcD$sp$(this);
            }

            public float zero$mcF$sp() {
                return AdditiveMonoid.zero$mcF$sp$(this);
            }

            public int zero$mcI$sp() {
                return AdditiveMonoid.zero$mcI$sp$(this);
            }

            public long zero$mcJ$sp() {
                return AdditiveMonoid.zero$mcJ$sp$(this);
            }

            public boolean isZero(Object a, Eq ev) {
                return AdditiveMonoid.isZero$(this, a, ev);
            }

            public boolean isZero$mcD$sp(double a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcD$sp$(this, a, ev);
            }

            public boolean isZero$mcF$sp(float a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcF$sp$(this, a, ev);
            }

            public boolean isZero$mcI$sp(int a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcI$sp$(this, a, ev);
            }

            public boolean isZero$mcJ$sp(long a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcJ$sp$(this, a, ev);
            }

            public Object sumN(Object a, int n) {
                return AdditiveMonoid.sumN$(this, a, n);
            }

            public double sumN$mcD$sp(double a, int n) {
                return AdditiveMonoid.sumN$mcD$sp$(this, a, n);
            }

            public float sumN$mcF$sp(float a, int n) {
                return AdditiveMonoid.sumN$mcF$sp$(this, a, n);
            }

            public int sumN$mcI$sp(int a, int n) {
                return AdditiveMonoid.sumN$mcI$sp$(this, a, n);
            }

            public long sumN$mcJ$sp(long a, int n) {
                return AdditiveMonoid.sumN$mcJ$sp$(this, a, n);
            }

            public Object sum(IterableOnce as) {
                return AdditiveMonoid.sum$(this, as);
            }

            public double sum$mcD$sp(IterableOnce<Object> as) {
                return AdditiveMonoid.sum$mcD$sp$(this, as);
            }

            public float sum$mcF$sp(IterableOnce<Object> as) {
                return AdditiveMonoid.sum$mcF$sp$(this, as);
            }

            public int sum$mcI$sp(IterableOnce<Object> as) {
                return AdditiveMonoid.sum$mcI$sp$(this, as);
            }

            public long sum$mcJ$sp(IterableOnce<Object> as) {
                return AdditiveMonoid.sum$mcJ$sp$(this, as);
            }

            public Option<Interval<A>> trySum(IterableOnce<Interval<A>> as) {
                return AdditiveMonoid.trySum$(this, as);
            }

            public double plus$mcD$sp(double x, double y) {
                return AdditiveSemigroup.plus$mcD$sp$(this, x, y);
            }

            public float plus$mcF$sp(float x, float y) {
                return AdditiveSemigroup.plus$mcF$sp$(this, x, y);
            }

            public int plus$mcI$sp(int x, int y) {
                return AdditiveSemigroup.plus$mcI$sp$(this, x, y);
            }

            public long plus$mcJ$sp(long x, long y) {
                return AdditiveSemigroup.plus$mcJ$sp$(this, x, y);
            }

            public Object positiveSumN(Object a, int n) {
                return AdditiveSemigroup.positiveSumN$(this, a, n);
            }

            public double positiveSumN$mcD$sp(double a, int n) {
                return AdditiveSemigroup.positiveSumN$mcD$sp$(this, a, n);
            }

            public float positiveSumN$mcF$sp(float a, int n) {
                return AdditiveSemigroup.positiveSumN$mcF$sp$(this, a, n);
            }

            public int positiveSumN$mcI$sp(int a, int n) {
                return AdditiveSemigroup.positiveSumN$mcI$sp$(this, a, n);
            }

            public long positiveSumN$mcJ$sp(long a, int n) {
                return AdditiveSemigroup.positiveSumN$mcJ$sp$(this, a, n);
            }

            public Interval<A> zero() {
                return Interval$.MODULE$.point(this.ev$4.zero(), this.o$6);
            }

            public Interval<A> plus(Interval<A> x, Interval<A> y) {
                return x.$plus(y, this.o$6, this.ev$4);
            }

            public Interval<A> times(Interval<A> x, Interval<A> y) {
                return x.$times(y, (Order<Interval<A>>)this.o$6, (Semiring<Interval<A>>)this.ev$4);
            }

            public Interval<A> pow(Interval<A> x, int k) {
                return x.pow(k, this.o$6, this.ev$4);
            }
            {
                this.ev$4 = ev$4;
                this.o$6 = o$6;
                AdditiveSemigroup.$init$(this);
                AdditiveMonoid.$init$(this);
                AdditiveCommutativeSemigroup.$init$(this);
                AdditiveCommutativeMonoid.$init$(this);
                MultiplicativeSemigroup.$init$(this);
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Interval$.class);
    }

    private Interval$() {
    }
}

