/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.CommutativeRig;
import java.io.Serializable;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import spire.math.Natural;
import spire.math.NaturalInstances;
import spire.math.NumberTag;
import spire.math.UInt;
import spire.math.UInt$;

public final class Natural$
implements NaturalInstances,
Serializable {
    public static final Natural$ MODULE$ = new Natural$();
    private static final int denom;
    private static final Natural ten18;
    private static final Natural zero;
    private static final Natural one;
    private static CommutativeRig<Natural> NaturalAlgebra;
    private static NumberTag<Natural> NaturalTag;

    static {
        NaturalInstances.$init$(MODULE$);
        denom = UInt$.MODULE$.apply(1000000000);
        ten18 = MODULE$.apply(1000000000000000000L);
        zero = MODULE$.apply(0L);
        one = MODULE$.apply(1L);
    }

    @Override
    public final CommutativeRig<Natural> NaturalAlgebra() {
        return NaturalAlgebra;
    }

    @Override
    public final NumberTag<Natural> NaturalTag() {
        return NaturalTag;
    }

    @Override
    public final void spire$math$NaturalInstances$_setter_$NaturalAlgebra_$eq(CommutativeRig<Natural> x$1) {
        NaturalAlgebra = x$1;
    }

    @Override
    public final void spire$math$NaturalInstances$_setter_$NaturalTag_$eq(NumberTag<Natural> x$1) {
        NaturalTag = x$1;
    }

    public final int denom() {
        return denom;
    }

    public BigInt naturalToBigInt(Natural n) {
        return n.toBigInt();
    }

    public Natural apply(Seq<UInt> us) {
        if (us.isEmpty()) {
            throw new IllegalArgumentException("invalid arguments");
        }
        return ((IterableOnceOps)us.tail()).foldLeft(new Natural.End(((UInt)us.head()).signed()), (Function2<Natural, Object, Natural.Digit> & Serializable)(n, u) -> Natural$.$anonfun$apply$1(n, ((UInt)u).signed()));
    }

    public Natural apply(long n) {
        return (n & 0xFFFFFFFFL) == n ? new Natural.End(UInt$.MODULE$.apply((int)n)) : new Natural.Digit(UInt$.MODULE$.apply((int)n), new Natural.End(UInt$.MODULE$.apply((int)(n >> 32))));
    }

    public Natural apply(BigInt n) {
        if (n.$less(BigInt$.MODULE$.int2bigInt(0))) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("negative numbers not allowed: %s"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{n})));
        }
        return n.$less(BigInt$.MODULE$.long2bigInt(0xFFFFFFFFL)) ? new Natural.End(UInt$.MODULE$.apply(n.toLong())) : new Natural.Digit(UInt$.MODULE$.apply(n.$amp(BigInt$.MODULE$.long2bigInt(0xFFFFFFFFL)).toLong()), this.apply(n.$greater$greater(32)));
    }

    private Natural ten18() {
        return ten18;
    }

    public Natural apply(String s) {
        return this.parse$1(this.apply(0L), s, this.apply(1L));
    }

    public Natural zero() {
        return zero;
    }

    public Natural one() {
        return one;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Natural$.class);
    }

    public static final /* synthetic */ Natural.Digit $anonfun$apply$1(Natural n, int u) {
        return new Natural.Digit(u, n);
    }

    private final Natural parse$1(Natural sofar, String s, Natural m) {
        while (s.length() > 18) {
            String p = s.substring(s.length() - 18, s.length());
            String r = s.substring(0, s.length() - 18);
            Natural natural = this.apply(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(p))).$times(m).$plus(sofar);
            m = m.$times(this.ten18());
            s = r;
            sofar = natural;
        }
        return this.apply(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s))).$times(m).$plus(sofar);
    }

    private Natural$() {
    }
}

