# -*- coding: utf-8 -*-
#

from setuptools import setup
import os


long_description = """
owmeta-core
===========

owmeta-core is a platform for sharing relational data over the internet.
"""


for line in open('owmeta_core/__init__.py'):
    if line.startswith("__version__"):
        version = line.split("=")[1].strip()[1:-1]

package_data_excludes = ['.*', '*.bkp', '~*']


def excludes(base):
    res = []
    for x in package_data_excludes:
        res.append(os.path.join(base, x))
    return res


setup(
    name='owmeta-core',
    zip_safe=False,
    setup_requires=['pytest-runner'],
    tests_require=[
        'pytest>=3.4.0',
        'pytest-cov>=2.5.1',
        'discover==0.4.0',
        'pytest-parallel'
    ],
    install_requires=[
        'bibtexparser~=1.1.0',
        'BTrees>=4.0.8',
        'gitpython>=2.1.1',
        'libneuroml',
        'persistent>=4.0.8',
        'Pint',
        'pow-store-zodb>=0.0.11',
        'rdflib>=4.1.2',
        'requests',
        'six~=1.10',
        'tqdm~=4.23',
        'termcolor~=1.1.0',
        'transaction>=1.4.4',
        'wrapt~=1.11.1',
        'zc.lockfile',
        'zodb>=4.1.0',
        'pyyaml',
    ],
    extras_require={
        # SQL source support
        'mysql_source_mysql_connector': [
            'rdflib-sqlalchemy~=0.4.0',
            'mysql-connector-python'],
        'mysql_source_mysqlclient': [
            'rdflib-sqlalchemy~=0.4.0',
            'mysqlclient'],
        'postgres_source_psycopg': [
            'rdflib-sqlalchemy~=0.4.0',
            'psycopg2'],
        'postgres_source_pg8000': [
            'rdflib-sqlalchemy~=0.4.0',
            'pg8000'],
        # Need 1.5.3 for host key file support
        'sftp': 'paramiko>=1.5.3'
    },
    version=version,
    packages=['owmeta_core',
              'owmeta_core.data_trans',
              'owmeta_core.commands',
              'owmeta_core.bundle',
              'owmeta_core.bundle.loaders',
              ],
    author='OpenWorm.org authors and contributors',
    author_email='info@openworm.org',
    description='owmeta-core is a platform for sharing relational data over the internet.',
    long_description=long_description,
    license='MIT',
    url='https://owmeta-core.readthedocs.io/en/latest/',
    download_url='https://github.com/openworm/owmeta-core/archive/master.zip',
    entry_points={
        'console_scripts': ['owm = owmeta_core.cli:main'],
        'rdf.plugins.store': [
            'agg = owmeta_core.agg_store:AggregateStore',
            'owmeta_core_bds = owmeta_core.bundle_dependency_store:BundleDependencyStore',
        ],
        'owmeta_core.commands': [
            'bundle.remote.add.sftp = owmeta_core.bundle.loaders.sftp:sftp_remote [sftp]',
            'bundle.remote.update.sftp = owmeta_core.bundle.loaders.sftp:sftp_remote [sftp]',
            'bundle.remote.add.https = owmeta_core.bundle.loaders.http:https_remote',
            'bundle.remote.update.https = owmeta_core.bundle.loaders.http:https_remote',
        ],
        'owmeta_core.loaders': [
            'http_uploader = owmeta_core.bundle.loaders.http:HTTPBundleUploader',
            'http_loader = owmeta_core.bundle.loaders.http:HTTPBundleLoader',
            'sftp_uploader = owmeta_core.bundle.loaders.sftp:DumbSFTPUploader [sftp]',
        ]
    },
    package_data={'owmeta_core': ['default.conf']},
    classifiers=[
        'Intended Audience :: Science/Research',
        'License :: OSI Approved :: BSD License',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Topic :: Scientific/Engineering'
    ]
)
