"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDynamicReferenceService = exports.CfnDynamicReference = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const intrinsic_1 = require("./private/intrinsic");
/**
 * References a dynamically retrieved value.
 *
 * This is a Construct so that subclasses will (eventually) be able to attach
 * metadata to themselves without having to change call signatures.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html
 * @stability stable
 */
class CfnDynamicReference extends intrinsic_1.Intrinsic {
    /**
     * @stability stable
     */
    constructor(service, key) {
        super('{{resolve:' + service + ':' + key + '}}');
    }
}
exports.CfnDynamicReference = CfnDynamicReference;
_a = JSII_RTTI_SYMBOL_1;
CfnDynamicReference[_a] = { fqn: "@aws-cdk/core.CfnDynamicReference", version: "1.107.0" };
/**
 * The service to retrieve the dynamic reference from.
 *
 * @stability stable
 */
var CfnDynamicReferenceService;
(function (CfnDynamicReferenceService) {
    CfnDynamicReferenceService["SSM"] = "ssm";
    CfnDynamicReferenceService["SSM_SECURE"] = "ssm-secure";
    CfnDynamicReferenceService["SECRETS_MANAGER"] = "secretsmanager";
})(CfnDynamicReferenceService = exports.CfnDynamicReferenceService || (exports.CfnDynamicReferenceService = {}));
//# sourceMappingURL=data:application/json;base64,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