default_scope = 'mmedit'
save_dir = './work_dirs'

default_hooks = dict(
    timer=dict(type='IterTimerHook'),
    logger=dict(type='LoggerHook', interval=100),
    param_scheduler=dict(type='ParamSchedulerHook'),
    checkpoint=dict(
        type='CheckpointHook',
        interval=5000,
        out_dir=save_dir,
        by_epoch=False,
        max_keep_ckpts=10,
        save_best='PSNR',
        rule='greater',
    ),
    sampler_seed=dict(type='DistSamplerSeedHook'),
)

env_cfg = dict(
    cudnn_benchmark=False,
    mp_cfg=dict(mp_start_method='fork', opencv_num_threads=4),
    dist_cfg=dict(backend='nccl'),
)

log_level = 'INFO'
log_processor = dict(type='LogProcessor', window_size=100, by_epoch=False)

load_from = None
resume = False

# vis_backends = [dict(type='LocalVisBackend')]
# visualizer = dict(
#     type='ConcatImageVisualizer',
#     vis_backends=vis_backends,
#     fn_key='gt_path',
#     img_keys=['gt_img', 'input', 'pred_img'],
#     bgr2rgb=True)
# custom_hooks = [dict(type='BasicVisualizationHook', interval=1)]
