# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from legit_api_client.models.closing_reason import ClosingReason
from legit_api_client.models.issue_status import IssueStatus
from legit_api_client.models.issue_type import IssueType
from legit_api_client.models.origin_type import OriginType
from legit_api_client.models.severity import Severity
from typing import Optional, Set
from typing_extensions import Self

class BasicIssue(BaseModel):
    """
    BasicIssue
    """ # noqa: E501
    issue_type: Optional[IssueType] = Field(default=None, description="The type of the issue", alias="issueType")
    severity: Optional[Severity] = Field(default=None, description="Severity level of the issue")
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the issue")
    score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Risk score of the issue (0-100)")
    status: Optional[IssueStatus] = Field(default=None, description="Current status of the issue")
    detected_at: Optional[datetime] = Field(default=None, description="Timestamp when the issue was first detected by legit, in ISO 8601 format", alias="detectedAt")
    last_closed_at: Optional[datetime] = Field(default=None, description="Timestamp when the issue was last closed (if applicable), in ISO 8601 format", alias="lastClosedAt")
    closing_reason: Optional[ClosingReason] = Field(default=None, description="Reason why the issue was closed (if applicable)", alias="closingReason")
    origin_type: Optional[OriginType] = Field(default=None, description="Type of asset where the issue was found", alias="originType")
    origin_id: Optional[StrictStr] = Field(default=None, description="Identifier of the asset where the issue was found", alias="originId")
    policy_name: Optional[StrictStr] = Field(default=None, description="Name of the policy that detected this issue", alias="policyName")
    __properties: ClassVar[List[str]] = ["issueType", "severity", "id", "score", "status", "detectedAt", "lastClosedAt", "closingReason", "originType", "originId", "policyName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BasicIssue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if score (nullable) is None
        # and model_fields_set contains the field
        if self.score is None and "score" in self.model_fields_set:
            _dict['score'] = None

        # set to None if detected_at (nullable) is None
        # and model_fields_set contains the field
        if self.detected_at is None and "detected_at" in self.model_fields_set:
            _dict['detectedAt'] = None

        # set to None if last_closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_closed_at is None and "last_closed_at" in self.model_fields_set:
            _dict['lastClosedAt'] = None

        # set to None if closing_reason (nullable) is None
        # and model_fields_set contains the field
        if self.closing_reason is None and "closing_reason" in self.model_fields_set:
            _dict['closingReason'] = None

        # set to None if origin_id (nullable) is None
        # and model_fields_set contains the field
        if self.origin_id is None and "origin_id" in self.model_fields_set:
            _dict['originId'] = None

        # set to None if policy_name (nullable) is None
        # and model_fields_set contains the field
        if self.policy_name is None and "policy_name" in self.model_fields_set:
            _dict['policyName'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BasicIssue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "issueType": obj.get("issueType"),
            "severity": obj.get("severity"),
            "id": obj.get("id"),
            "score": obj.get("score"),
            "status": obj.get("status"),
            "detectedAt": obj.get("detectedAt"),
            "lastClosedAt": obj.get("lastClosedAt"),
            "closingReason": obj.get("closingReason"),
            "originType": obj.get("originType"),
            "originId": obj.get("originId"),
            "policyName": obj.get("policyName")
        })
        return _obj


