# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from legit_api_client.models.correlated_cloud_instance import CorrelatedCloudInstance
from legit_api_client.models.correlated_repository_dto import CorrelatedRepositoryDto
from typing import Optional, Set
from typing_extensions import Self

class ContainerImageDto(BaseModel):
    """
    ContainerImageDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    integration_ids: Optional[List[StrictStr]] = Field(default=None, alias="integrationIds")
    correlated_repositories: Optional[List[CorrelatedRepositoryDto]] = Field(default=None, alias="correlatedRepositories")
    correlated_cloud_instances: Optional[List[CorrelatedCloudInstance]] = Field(default=None, alias="correlatedCloudInstances")
    __properties: ClassVar[List[str]] = ["id", "name", "integrationIds", "correlatedRepositories", "correlatedCloudInstances"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContainerImageDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in correlated_repositories (list)
        _items = []
        if self.correlated_repositories:
            for _item_correlated_repositories in self.correlated_repositories:
                if _item_correlated_repositories:
                    _items.append(_item_correlated_repositories.to_dict())
            _dict['correlatedRepositories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in correlated_cloud_instances (list)
        _items = []
        if self.correlated_cloud_instances:
            for _item_correlated_cloud_instances in self.correlated_cloud_instances:
                if _item_correlated_cloud_instances:
                    _items.append(_item_correlated_cloud_instances.to_dict())
            _dict['correlatedCloudInstances'] = _items
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if integration_ids (nullable) is None
        # and model_fields_set contains the field
        if self.integration_ids is None and "integration_ids" in self.model_fields_set:
            _dict['integrationIds'] = None

        # set to None if correlated_repositories (nullable) is None
        # and model_fields_set contains the field
        if self.correlated_repositories is None and "correlated_repositories" in self.model_fields_set:
            _dict['correlatedRepositories'] = None

        # set to None if correlated_cloud_instances (nullable) is None
        # and model_fields_set contains the field
        if self.correlated_cloud_instances is None and "correlated_cloud_instances" in self.model_fields_set:
            _dict['correlatedCloudInstances'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContainerImageDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "integrationIds": obj.get("integrationIds"),
            "correlatedRepositories": [CorrelatedRepositoryDto.from_dict(_item) for _item in obj["correlatedRepositories"]] if obj.get("correlatedRepositories") is not None else None,
            "correlatedCloudInstances": [CorrelatedCloudInstance.from_dict(_item) for _item in obj["correlatedCloudInstances"]] if obj.get("correlatedCloudInstances") is not None else None
        })
        return _obj


