# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from legit_api_client.models.customer_facing_dependency_license import CustomerFacingDependencyLicense
from legit_api_client.models.dependency_declaration import DependencyDeclaration
from legit_api_client.models.package_source import PackageSource
from legit_api_client.models.programming_language import ProgrammingLanguage
from typing import Optional, Set
from typing_extensions import Self

class CustomerFacingDependencyDto(BaseModel):
    """
    CustomerFacingDependencyDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    version: Optional[StrictStr] = None
    language: Optional[ProgrammingLanguage] = None
    licenses: Optional[List[CustomerFacingDependencyLicense]] = None
    source_scanners: Optional[List[PackageSource]] = Field(default=None, alias="sourceScanners")
    declaration_type: Optional[DependencyDeclaration] = Field(default=None, alias="declarationType")
    __properties: ClassVar[List[str]] = ["id", "name", "version", "language", "licenses", "sourceScanners", "declarationType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomerFacingDependencyDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in licenses (list)
        _items = []
        if self.licenses:
            for _item_licenses in self.licenses:
                if _item_licenses:
                    _items.append(_item_licenses.to_dict())
            _dict['licenses'] = _items
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if licenses (nullable) is None
        # and model_fields_set contains the field
        if self.licenses is None and "licenses" in self.model_fields_set:
            _dict['licenses'] = None

        # set to None if source_scanners (nullable) is None
        # and model_fields_set contains the field
        if self.source_scanners is None and "source_scanners" in self.model_fields_set:
            _dict['sourceScanners'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomerFacingDependencyDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "version": obj.get("version"),
            "language": obj.get("language"),
            "licenses": [CustomerFacingDependencyLicense.from_dict(_item) for _item in obj["licenses"]] if obj.get("licenses") is not None else None,
            "sourceScanners": obj.get("sourceScanners"),
            "declarationType": obj.get("declarationType")
        })
        return _obj


