# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from legit_api_client.models.closing_reason import ClosingReason
from legit_api_client.models.dast_data_dto import DastDataDto
from legit_api_client.models.dependency_vulnerability_data_dto import DependencyVulnerabilityDataDto
from legit_api_client.models.issue_closing_location_dto import IssueClosingLocationDto
from legit_api_client.models.issue_status import IssueStatus
from legit_api_client.models.issue_type import IssueType
from legit_api_client.models.origin_type import OriginType
from legit_api_client.models.product_unit_issue_dto import ProductUnitIssueDto
from legit_api_client.models.secrets_data_dto import SecretsDataDto
from legit_api_client.models.severity import Severity
from legit_api_client.models.snoozed_type import SnoozedType
from legit_api_client.models.source_dto import SourceDto
from typing import Optional, Set
from typing_extensions import Self

class CustomerFacingIssueDto(BaseModel):
    """
    CustomerFacingIssueDto
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the issue")
    title: Optional[StrictStr] = Field(default=None, description="The title/name of the issue")
    detected_at: Optional[datetime] = Field(default=None, description="Timestamp when the issue was first detected by legit, in ISO 8601 format", alias="detectedAt")
    last_closed_at: Optional[datetime] = Field(default=None, description="Timestamp when the issue was last closed (if applicable), in ISO 8601 format", alias="lastClosedAt")
    last_action_time: Optional[datetime] = Field(default=None, description="Timestamp of the last action performed on this issue (if applicable), in ISO 8601 format", alias="lastActionTime")
    status: Optional[IssueStatus] = Field(default=None, description="Current status of the issue")
    issue_type: Optional[IssueType] = Field(default=None, description="The type of the issue", alias="issueType")
    severity: Optional[Severity] = Field(default=None, description="Severity level of the issue")
    policy_severity: Optional[Severity] = Field(default=None, description="Severity level of the policy the issue originated from", alias="policySeverity")
    closing_reason: Optional[ClosingReason] = Field(default=None, description="Reason why the issue was closed (if applicable)", alias="closingReason")
    closing_location: Optional[IssueClosingLocationDto] = Field(default=None, description="Location where the issue was closed (if applicable)", alias="closingLocation")
    status_changed_note: Optional[StrictStr] = Field(default=None, description="Note added when the status was last changed", alias="statusChangedNote")
    snoozed_type: Optional[SnoozedType] = Field(default=None, description="Type of snooze applied to the issue (if applicable)", alias="snoozedType")
    snoozed_until: Optional[datetime] = Field(default=None, description="Date and time until which the issue is snoozed (if applicable), in ISO 8601 format", alias="snoozedUntil")
    score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Risk score of the issue (0-100)")
    secrets_data_dto: Optional[SecretsDataDto] = Field(default=None, description="Data specific to issues of type secret. Will be null for other issue types", alias="secretsDataDto")
    dependency_vulnerability_data_dto: Optional[DependencyVulnerabilityDataDto] = Field(default=None, description="Data specific to issues of type SCA or ContainerScanning. Will be null for other issue types", alias="dependencyVulnerabilityDataDto")
    dast_data_dto: Optional[DastDataDto] = Field(default=None, description="Data specific to issues of type DAST. Will be null for other issue types", alias="dastDataDto")
    origin_id: Optional[StrictStr] = Field(default=None, description="Identifier of the asset where the issue was found", alias="originId")
    origin_type: Optional[OriginType] = Field(default=None, description="Type of asset where the issue was found", alias="originType")
    origin_link: Optional[StrictStr] = Field(default=None, description="Direct link to fetch the asset in Legit API", alias="originLink")
    action_id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the action the issue belongs to", alias="actionId")
    policy_name: Optional[StrictStr] = Field(default=None, description="Name of the policy that detected this issue", alias="policyName")
    assigned_user_id: Optional[StrictStr] = Field(default=None, description="ID of the user assigned to handle this issue (if applicable)", alias="assignedUserId")
    sources: Optional[List[SourceDto]] = Field(default=None, description="The sources the issue originated from")
    product_units: Optional[List[ProductUnitIssueDto]] = Field(default=None, alias="productUnits")
    __properties: ClassVar[List[str]] = ["id", "title", "detectedAt", "lastClosedAt", "lastActionTime", "status", "issueType", "severity", "policySeverity", "closingReason", "closingLocation", "statusChangedNote", "snoozedType", "snoozedUntil", "score", "secretsDataDto", "dependencyVulnerabilityDataDto", "dastDataDto", "originId", "originType", "originLink", "actionId", "policyName", "assignedUserId", "sources", "productUnits"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomerFacingIssueDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of secrets_data_dto
        if self.secrets_data_dto:
            _dict['secretsDataDto'] = self.secrets_data_dto.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dependency_vulnerability_data_dto
        if self.dependency_vulnerability_data_dto:
            _dict['dependencyVulnerabilityDataDto'] = self.dependency_vulnerability_data_dto.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dast_data_dto
        if self.dast_data_dto:
            _dict['dastDataDto'] = self.dast_data_dto.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sources (list)
        _items = []
        if self.sources:
            for _item_sources in self.sources:
                if _item_sources:
                    _items.append(_item_sources.to_dict())
            _dict['sources'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in product_units (list)
        _items = []
        if self.product_units:
            for _item_product_units in self.product_units:
                if _item_product_units:
                    _items.append(_item_product_units.to_dict())
            _dict['productUnits'] = _items
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if last_closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_closed_at is None and "last_closed_at" in self.model_fields_set:
            _dict['lastClosedAt'] = None

        # set to None if last_action_time (nullable) is None
        # and model_fields_set contains the field
        if self.last_action_time is None and "last_action_time" in self.model_fields_set:
            _dict['lastActionTime'] = None

        # set to None if closing_reason (nullable) is None
        # and model_fields_set contains the field
        if self.closing_reason is None and "closing_reason" in self.model_fields_set:
            _dict['closingReason'] = None

        # set to None if closing_location (nullable) is None
        # and model_fields_set contains the field
        if self.closing_location is None and "closing_location" in self.model_fields_set:
            _dict['closingLocation'] = None

        # set to None if status_changed_note (nullable) is None
        # and model_fields_set contains the field
        if self.status_changed_note is None and "status_changed_note" in self.model_fields_set:
            _dict['statusChangedNote'] = None

        # set to None if snoozed_type (nullable) is None
        # and model_fields_set contains the field
        if self.snoozed_type is None and "snoozed_type" in self.model_fields_set:
            _dict['snoozedType'] = None

        # set to None if snoozed_until (nullable) is None
        # and model_fields_set contains the field
        if self.snoozed_until is None and "snoozed_until" in self.model_fields_set:
            _dict['snoozedUntil'] = None

        # set to None if score (nullable) is None
        # and model_fields_set contains the field
        if self.score is None and "score" in self.model_fields_set:
            _dict['score'] = None

        # set to None if secrets_data_dto (nullable) is None
        # and model_fields_set contains the field
        if self.secrets_data_dto is None and "secrets_data_dto" in self.model_fields_set:
            _dict['secretsDataDto'] = None

        # set to None if dependency_vulnerability_data_dto (nullable) is None
        # and model_fields_set contains the field
        if self.dependency_vulnerability_data_dto is None and "dependency_vulnerability_data_dto" in self.model_fields_set:
            _dict['dependencyVulnerabilityDataDto'] = None

        # set to None if dast_data_dto (nullable) is None
        # and model_fields_set contains the field
        if self.dast_data_dto is None and "dast_data_dto" in self.model_fields_set:
            _dict['dastDataDto'] = None

        # set to None if origin_id (nullable) is None
        # and model_fields_set contains the field
        if self.origin_id is None and "origin_id" in self.model_fields_set:
            _dict['originId'] = None

        # set to None if origin_link (nullable) is None
        # and model_fields_set contains the field
        if self.origin_link is None and "origin_link" in self.model_fields_set:
            _dict['originLink'] = None

        # set to None if action_id (nullable) is None
        # and model_fields_set contains the field
        if self.action_id is None and "action_id" in self.model_fields_set:
            _dict['actionId'] = None

        # set to None if policy_name (nullable) is None
        # and model_fields_set contains the field
        if self.policy_name is None and "policy_name" in self.model_fields_set:
            _dict['policyName'] = None

        # set to None if assigned_user_id (nullable) is None
        # and model_fields_set contains the field
        if self.assigned_user_id is None and "assigned_user_id" in self.model_fields_set:
            _dict['assignedUserId'] = None

        # set to None if sources (nullable) is None
        # and model_fields_set contains the field
        if self.sources is None and "sources" in self.model_fields_set:
            _dict['sources'] = None

        # set to None if product_units (nullable) is None
        # and model_fields_set contains the field
        if self.product_units is None and "product_units" in self.model_fields_set:
            _dict['productUnits'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomerFacingIssueDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "detectedAt": obj.get("detectedAt"),
            "lastClosedAt": obj.get("lastClosedAt"),
            "lastActionTime": obj.get("lastActionTime"),
            "status": obj.get("status"),
            "issueType": obj.get("issueType"),
            "severity": obj.get("severity"),
            "policySeverity": obj.get("policySeverity"),
            "closingReason": obj.get("closingReason"),
            "closingLocation": obj.get("closingLocation"),
            "statusChangedNote": obj.get("statusChangedNote"),
            "snoozedType": obj.get("snoozedType"),
            "snoozedUntil": obj.get("snoozedUntil"),
            "score": obj.get("score"),
            "secretsDataDto": SecretsDataDto.from_dict(obj["secretsDataDto"]) if obj.get("secretsDataDto") is not None else None,
            "dependencyVulnerabilityDataDto": DependencyVulnerabilityDataDto.from_dict(obj["dependencyVulnerabilityDataDto"]) if obj.get("dependencyVulnerabilityDataDto") is not None else None,
            "dastDataDto": DastDataDto.from_dict(obj["dastDataDto"]) if obj.get("dastDataDto") is not None else None,
            "originId": obj.get("originId"),
            "originType": obj.get("originType"),
            "originLink": obj.get("originLink"),
            "actionId": obj.get("actionId"),
            "policyName": obj.get("policyName"),
            "assignedUserId": obj.get("assignedUserId"),
            "sources": [SourceDto.from_dict(_item) for _item in obj["sources"]] if obj.get("sources") is not None else None,
            "productUnits": [ProductUnitIssueDto.from_dict(_item) for _item in obj["productUnits"]] if obj.get("productUnits") is not None else None
        })
        return _obj


