# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from legit_api_client.models.customer_facing_issue_action_dto import CustomerFacingIssueActionDto
from typing import Optional, Set
from typing_extensions import Self

class CustomerFacingIssueToActionHistoryDto(BaseModel):
    """
    CustomerFacingIssueToActionHistoryDto
    """ # noqa: E501
    issue_id: Optional[StrictStr] = Field(default=None, description="The id of the issue the action history belongs to", alias="issueId")
    actions: Optional[List[CustomerFacingIssueActionDto]] = Field(default=None, description="The last 100 actions that were performed on the issue. could be an empty list")
    __properties: ClassVar[List[str]] = ["issueId", "actions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomerFacingIssueToActionHistoryDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in actions (list)
        _items = []
        if self.actions:
            for _item_actions in self.actions:
                if _item_actions:
                    _items.append(_item_actions.to_dict())
            _dict['actions'] = _items
        # set to None if issue_id (nullable) is None
        # and model_fields_set contains the field
        if self.issue_id is None and "issue_id" in self.model_fields_set:
            _dict['issueId'] = None

        # set to None if actions (nullable) is None
        # and model_fields_set contains the field
        if self.actions is None and "actions" in self.model_fields_set:
            _dict['actions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomerFacingIssueToActionHistoryDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "issueId": obj.get("issueId"),
            "actions": [CustomerFacingIssueActionDto.from_dict(_item) for _item in obj["actions"]] if obj.get("actions") is not None else None
        })
        return _obj


