# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from legit_api_client.models.cve_severity import CveSeverity
from legit_api_client.models.vulnerability_type import VulnerabilityType
from typing import Optional, Set
from typing_extensions import Self

class CustomerFacingIssueVulnerabilityDto(BaseModel):
    """
    CustomerFacingIssueVulnerabilityDto
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The vulnerability id (for CVE's its the CVE-id)")
    type: Optional[VulnerabilityType] = Field(default=None, description="The type of vulnerability (e.g., CVE)")
    description: Optional[StrictStr] = Field(default=None, description="Detailed description of the vulnerability")
    epss_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="EPSS (Exploit Prediction Scoring System) score indicating the probability of exploitation (0.0 - 1.0)", alias="epssScore")
    epss_percentile: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="EPSS percentile ranking compared to all vulnerabilities (0.0 - 100.0)", alias="epssPercentile")
    severity: Optional[CveSeverity] = Field(default=None, description="The severity level of the vulnerability (e.g., Critical, High, Medium, Low)")
    cvss_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="CVSS (Common Vulnerability Scoring System) base score (0.0 - 10.0)", alias="cvssScore")
    has_cisa_exploited: Optional[StrictBool] = Field(default=None, description="Indicates whether this vulnerability has been exploited in the wild according to CISA's Known Exploited Vulnerabilities catalog", alias="hasCisaExploited")
    vulnerability_url: Optional[StrictStr] = Field(default=None, description="URL to the official vulnerability details or advisory page", alias="vulnerabilityUrl")
    __properties: ClassVar[List[str]] = ["id", "type", "description", "epssScore", "epssPercentile", "severity", "cvssScore", "hasCisaExploited", "vulnerabilityUrl"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomerFacingIssueVulnerabilityDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if epss_score (nullable) is None
        # and model_fields_set contains the field
        if self.epss_score is None and "epss_score" in self.model_fields_set:
            _dict['epssScore'] = None

        # set to None if epss_percentile (nullable) is None
        # and model_fields_set contains the field
        if self.epss_percentile is None and "epss_percentile" in self.model_fields_set:
            _dict['epssPercentile'] = None

        # set to None if cvss_score (nullable) is None
        # and model_fields_set contains the field
        if self.cvss_score is None and "cvss_score" in self.model_fields_set:
            _dict['cvssScore'] = None

        # set to None if vulnerability_url (nullable) is None
        # and model_fields_set contains the field
        if self.vulnerability_url is None and "vulnerability_url" in self.model_fields_set:
            _dict['vulnerabilityUrl'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomerFacingIssueVulnerabilityDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "description": obj.get("description"),
            "epssScore": obj.get("epssScore"),
            "epssPercentile": obj.get("epssPercentile"),
            "severity": obj.get("severity"),
            "cvssScore": obj.get("cvssScore"),
            "hasCisaExploited": obj.get("hasCisaExploited"),
            "vulnerabilityUrl": obj.get("vulnerabilityUrl")
        })
        return _obj


