# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from legit_api_client.models.legit_score_category_dto import LegitScoreCategoryDto
from legit_api_client.models.legit_score_grade import LegitScoreGrade
from typing import Optional, Set
from typing_extensions import Self

class LegitScoreDto(BaseModel):
    """
    LegitScoreDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    score: Optional[Union[StrictFloat, StrictInt]] = None
    max_points: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxPoints")
    gained_points: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="gainedPoints")
    categories: Optional[List[LegitScoreCategoryDto]] = None
    grade: Optional[LegitScoreGrade] = None
    score_out_of100: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="scoreOutOf100")
    __properties: ClassVar[List[str]] = ["id", "score", "maxPoints", "gainedPoints", "categories", "grade", "scoreOutOf100"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LegitScoreDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "grade",
            "score_out_of100",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in categories (list)
        _items = []
        if self.categories:
            for _item_categories in self.categories:
                if _item_categories:
                    _items.append(_item_categories.to_dict())
            _dict['categories'] = _items
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if categories (nullable) is None
        # and model_fields_set contains the field
        if self.categories is None and "categories" in self.model_fields_set:
            _dict['categories'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LegitScoreDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "score": obj.get("score"),
            "maxPoints": obj.get("maxPoints"),
            "gainedPoints": obj.get("gainedPoints"),
            "categories": [LegitScoreCategoryDto.from_dict(_item) for _item in obj["categories"]] if obj.get("categories") is not None else None,
            "grade": obj.get("grade"),
            "scoreOutOf100": obj.get("scoreOutOf100")
        })
        return _obj


