# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from legit_api_client.models.business_impact import BusinessImpact
from legit_api_client.models.patch_security_champion_id_dto import PatchSecurityChampionIdDto
from legit_api_client.models.product_unit_environment import ProductUnitEnvironment
from legit_api_client.models.product_unit_type import ProductUnitType
from legit_api_client.models.repository_directory import RepositoryDirectory
from typing import Optional, Set
from typing_extensions import Self

class PatchProductUnitDto(BaseModel):
    """
    PatchProductUnitDto
    """ # noqa: E501
    name: Optional[Annotated[str, Field(strict=True)]] = None
    description: Optional[StrictStr] = None
    workspace_id: Optional[StrictStr] = Field(default=None, alias="workspaceId")
    type: Optional[ProductUnitType] = None
    environment: Optional[ProductUnitEnvironment] = None
    business_impact: Optional[BusinessImpact] = Field(default=None, alias="businessImpact")
    attach_repository_ids: Optional[List[StrictStr]] = Field(default=None, alias="attachRepositoryIds")
    attach_repository_group_ids: Optional[List[StrictStr]] = Field(default=None, alias="attachRepositoryGroupIds")
    attach_integration_ids: Optional[List[StrictStr]] = Field(default=None, alias="attachIntegrationIds")
    attach_nested_product_unit_ids: Optional[List[StrictStr]] = Field(default=None, alias="attachNestedProductUnitIds")
    attach_repository_name_substrings: Optional[List[StrictStr]] = Field(default=None, alias="attachRepositoryNameSubstrings")
    attach_repository_directories: Optional[List[RepositoryDirectory]] = Field(default=None, alias="attachRepositoryDirectories")
    detach_repository_ids: Optional[List[StrictStr]] = Field(default=None, alias="detachRepositoryIds")
    detach_repository_group_ids: Optional[List[StrictStr]] = Field(default=None, alias="detachRepositoryGroupIds")
    detach_integration_ids: Optional[List[StrictStr]] = Field(default=None, alias="detachIntegrationIds")
    detach_nested_product_unit_ids: Optional[List[StrictStr]] = Field(default=None, alias="detachNestedProductUnitIds")
    detach_repository_name_substrings: Optional[List[StrictStr]] = Field(default=None, alias="detachRepositoryNameSubstrings")
    detach_repository_directories: Optional[List[RepositoryDirectory]] = Field(default=None, alias="detachRepositoryDirectories")
    patch_security_champion_id: Optional[PatchSecurityChampionIdDto] = Field(default=None, alias="patchSecurityChampionId")
    __properties: ClassVar[List[str]] = ["name", "description", "workspaceId", "type", "environment", "businessImpact", "attachRepositoryIds", "attachRepositoryGroupIds", "attachIntegrationIds", "attachNestedProductUnitIds", "attachRepositoryNameSubstrings", "attachRepositoryDirectories", "detachRepositoryIds", "detachRepositoryGroupIds", "detachIntegrationIds", "detachNestedProductUnitIds", "detachRepositoryNameSubstrings", "detachRepositoryDirectories", "patchSecurityChampionId"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[\w\s!@#$%\^&*()={}:;<>+\'-\/]{1,60}$", value):
            raise ValueError(r"must validate the regular expression /^[\w\s!@#$%\^&*()={}:;<>+'-\/]{1,60}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PatchProductUnitDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attach_repository_directories (list)
        _items = []
        if self.attach_repository_directories:
            for _item_attach_repository_directories in self.attach_repository_directories:
                if _item_attach_repository_directories:
                    _items.append(_item_attach_repository_directories.to_dict())
            _dict['attachRepositoryDirectories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in detach_repository_directories (list)
        _items = []
        if self.detach_repository_directories:
            for _item_detach_repository_directories in self.detach_repository_directories:
                if _item_detach_repository_directories:
                    _items.append(_item_detach_repository_directories.to_dict())
            _dict['detachRepositoryDirectories'] = _items
        # override the default output from pydantic by calling `to_dict()` of patch_security_champion_id
        if self.patch_security_champion_id:
            _dict['patchSecurityChampionId'] = self.patch_security_champion_id.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if workspace_id (nullable) is None
        # and model_fields_set contains the field
        if self.workspace_id is None and "workspace_id" in self.model_fields_set:
            _dict['workspaceId'] = None

        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if environment (nullable) is None
        # and model_fields_set contains the field
        if self.environment is None and "environment" in self.model_fields_set:
            _dict['environment'] = None

        # set to None if business_impact (nullable) is None
        # and model_fields_set contains the field
        if self.business_impact is None and "business_impact" in self.model_fields_set:
            _dict['businessImpact'] = None

        # set to None if attach_repository_ids (nullable) is None
        # and model_fields_set contains the field
        if self.attach_repository_ids is None and "attach_repository_ids" in self.model_fields_set:
            _dict['attachRepositoryIds'] = None

        # set to None if attach_repository_group_ids (nullable) is None
        # and model_fields_set contains the field
        if self.attach_repository_group_ids is None and "attach_repository_group_ids" in self.model_fields_set:
            _dict['attachRepositoryGroupIds'] = None

        # set to None if attach_integration_ids (nullable) is None
        # and model_fields_set contains the field
        if self.attach_integration_ids is None and "attach_integration_ids" in self.model_fields_set:
            _dict['attachIntegrationIds'] = None

        # set to None if attach_nested_product_unit_ids (nullable) is None
        # and model_fields_set contains the field
        if self.attach_nested_product_unit_ids is None and "attach_nested_product_unit_ids" in self.model_fields_set:
            _dict['attachNestedProductUnitIds'] = None

        # set to None if attach_repository_name_substrings (nullable) is None
        # and model_fields_set contains the field
        if self.attach_repository_name_substrings is None and "attach_repository_name_substrings" in self.model_fields_set:
            _dict['attachRepositoryNameSubstrings'] = None

        # set to None if attach_repository_directories (nullable) is None
        # and model_fields_set contains the field
        if self.attach_repository_directories is None and "attach_repository_directories" in self.model_fields_set:
            _dict['attachRepositoryDirectories'] = None

        # set to None if detach_repository_ids (nullable) is None
        # and model_fields_set contains the field
        if self.detach_repository_ids is None and "detach_repository_ids" in self.model_fields_set:
            _dict['detachRepositoryIds'] = None

        # set to None if detach_repository_group_ids (nullable) is None
        # and model_fields_set contains the field
        if self.detach_repository_group_ids is None and "detach_repository_group_ids" in self.model_fields_set:
            _dict['detachRepositoryGroupIds'] = None

        # set to None if detach_integration_ids (nullable) is None
        # and model_fields_set contains the field
        if self.detach_integration_ids is None and "detach_integration_ids" in self.model_fields_set:
            _dict['detachIntegrationIds'] = None

        # set to None if detach_nested_product_unit_ids (nullable) is None
        # and model_fields_set contains the field
        if self.detach_nested_product_unit_ids is None and "detach_nested_product_unit_ids" in self.model_fields_set:
            _dict['detachNestedProductUnitIds'] = None

        # set to None if detach_repository_name_substrings (nullable) is None
        # and model_fields_set contains the field
        if self.detach_repository_name_substrings is None and "detach_repository_name_substrings" in self.model_fields_set:
            _dict['detachRepositoryNameSubstrings'] = None

        # set to None if detach_repository_directories (nullable) is None
        # and model_fields_set contains the field
        if self.detach_repository_directories is None and "detach_repository_directories" in self.model_fields_set:
            _dict['detachRepositoryDirectories'] = None

        # set to None if patch_security_champion_id (nullable) is None
        # and model_fields_set contains the field
        if self.patch_security_champion_id is None and "patch_security_champion_id" in self.model_fields_set:
            _dict['patchSecurityChampionId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PatchProductUnitDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "workspaceId": obj.get("workspaceId"),
            "type": obj.get("type"),
            "environment": obj.get("environment"),
            "businessImpact": obj.get("businessImpact"),
            "attachRepositoryIds": obj.get("attachRepositoryIds"),
            "attachRepositoryGroupIds": obj.get("attachRepositoryGroupIds"),
            "attachIntegrationIds": obj.get("attachIntegrationIds"),
            "attachNestedProductUnitIds": obj.get("attachNestedProductUnitIds"),
            "attachRepositoryNameSubstrings": obj.get("attachRepositoryNameSubstrings"),
            "attachRepositoryDirectories": [RepositoryDirectory.from_dict(_item) for _item in obj["attachRepositoryDirectories"]] if obj.get("attachRepositoryDirectories") is not None else None,
            "detachRepositoryIds": obj.get("detachRepositoryIds"),
            "detachRepositoryGroupIds": obj.get("detachRepositoryGroupIds"),
            "detachIntegrationIds": obj.get("detachIntegrationIds"),
            "detachNestedProductUnitIds": obj.get("detachNestedProductUnitIds"),
            "detachRepositoryNameSubstrings": obj.get("detachRepositoryNameSubstrings"),
            "detachRepositoryDirectories": [RepositoryDirectory.from_dict(_item) for _item in obj["detachRepositoryDirectories"]] if obj.get("detachRepositoryDirectories") is not None else None,
            "patchSecurityChampionId": PatchSecurityChampionIdDto.from_dict(obj["patchSecurityChampionId"]) if obj.get("patchSecurityChampionId") is not None else None
        })
        return _obj


