# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from legit_api_client.models.collaborator_dto import CollaboratorDto
from legit_api_client.models.product_unit_name_dto import ProductUnitNameDto
from legit_api_client.models.repository_group_dto import RepositoryGroupDto
from legit_api_client.models.repository_visibility import RepositoryVisibility
from legit_api_client.models.tag_dto import TagDto
from typing import Optional, Set
from typing_extensions import Self

class RepositoryDto(BaseModel):
    """
    RepositoryDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    visibility: Optional[RepositoryVisibility] = None
    is_active: Optional[StrictBool] = Field(default=None, alias="isActive")
    is_archived: Optional[StrictBool] = Field(default=None, alias="isArchived")
    owner: Optional[CollaboratorDto] = None
    tags: Optional[List[TagDto]] = None
    product_units: Optional[List[ProductUnitNameDto]] = Field(default=None, alias="productUnits")
    issues_count: Optional[StrictInt] = Field(default=None, alias="issuesCount")
    lines_count: Optional[StrictInt] = Field(default=None, alias="linesCount")
    score: Optional[Union[StrictFloat, StrictInt]] = None
    score_out_of100: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="scoreOutOf100")
    group: Optional[RepositoryGroupDto] = None
    __properties: ClassVar[List[str]] = ["id", "name", "url", "visibility", "isActive", "isArchived", "owner", "tags", "productUnits", "issuesCount", "linesCount", "score", "scoreOutOf100", "group"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "score_out_of100",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in product_units (list)
        _items = []
        if self.product_units:
            for _item_product_units in self.product_units:
                if _item_product_units:
                    _items.append(_item_product_units.to_dict())
            _dict['productUnits'] = _items
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if visibility (nullable) is None
        # and model_fields_set contains the field
        if self.visibility is None and "visibility" in self.model_fields_set:
            _dict['visibility'] = None

        # set to None if is_active (nullable) is None
        # and model_fields_set contains the field
        if self.is_active is None and "is_active" in self.model_fields_set:
            _dict['isActive'] = None

        # set to None if owner (nullable) is None
        # and model_fields_set contains the field
        if self.owner is None and "owner" in self.model_fields_set:
            _dict['owner'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if product_units (nullable) is None
        # and model_fields_set contains the field
        if self.product_units is None and "product_units" in self.model_fields_set:
            _dict['productUnits'] = None

        # set to None if lines_count (nullable) is None
        # and model_fields_set contains the field
        if self.lines_count is None and "lines_count" in self.model_fields_set:
            _dict['linesCount'] = None

        # set to None if score (nullable) is None
        # and model_fields_set contains the field
        if self.score is None and "score" in self.model_fields_set:
            _dict['score'] = None

        # set to None if score_out_of100 (nullable) is None
        # and model_fields_set contains the field
        if self.score_out_of100 is None and "score_out_of100" in self.model_fields_set:
            _dict['scoreOutOf100'] = None

        # set to None if group (nullable) is None
        # and model_fields_set contains the field
        if self.group is None and "group" in self.model_fields_set:
            _dict['group'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "url": obj.get("url"),
            "visibility": obj.get("visibility"),
            "isActive": obj.get("isActive"),
            "isArchived": obj.get("isArchived"),
            "owner": CollaboratorDto.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "tags": [TagDto.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "productUnits": [ProductUnitNameDto.from_dict(_item) for _item in obj["productUnits"]] if obj.get("productUnits") is not None else None,
            "issuesCount": obj.get("issuesCount"),
            "linesCount": obj.get("linesCount"),
            "score": obj.get("score"),
            "scoreOutOf100": obj.get("scoreOutOf100"),
            "group": RepositoryGroupDto.from_dict(obj["group"]) if obj.get("group") is not None else None
        })
        return _obj


