# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from legit_api_client.models.ai_secret_validation_result import AiSecretValidationResult
from legit_api_client.models.secret_issue_validity_status import SecretIssueValidityStatus
from typing import Optional, Set
from typing_extensions import Self

class SecretsDataDto(BaseModel):
    """
    SecretsDataDto
    """ # noqa: E501
    ai_validation_result: Optional[AiSecretValidationResult] = Field(default=None, description="AI validation result for the secret", alias="aiValidationResult")
    validity_status: Optional[SecretIssueValidityStatus] = Field(default=None, description="Status of the secret validity", alias="validityStatus")
    validity_check_time: Optional[datetime] = Field(default=None, description="Timestamp when the validity was last checked", alias="validityCheckTime")
    verified_validation_url: Optional[StrictStr] = Field(default=None, description="URL used to verify the validity of the secret", alias="verifiedValidationUrl")
    __properties: ClassVar[List[str]] = ["aiValidationResult", "validityStatus", "validityCheckTime", "verifiedValidationUrl"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecretsDataDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if ai_validation_result (nullable) is None
        # and model_fields_set contains the field
        if self.ai_validation_result is None and "ai_validation_result" in self.model_fields_set:
            _dict['aiValidationResult'] = None

        # set to None if validity_check_time (nullable) is None
        # and model_fields_set contains the field
        if self.validity_check_time is None and "validity_check_time" in self.model_fields_set:
            _dict['validityCheckTime'] = None

        # set to None if verified_validation_url (nullable) is None
        # and model_fields_set contains the field
        if self.verified_validation_url is None and "verified_validation_url" in self.model_fields_set:
            _dict['verifiedValidationUrl'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecretsDataDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aiValidationResult": obj.get("aiValidationResult"),
            "validityStatus": obj.get("validityStatus"),
            "validityCheckTime": obj.get("validityCheckTime"),
            "verifiedValidationUrl": obj.get("verifiedValidationUrl")
        })
        return _obj


