"""Changes associated with version Honeybee schema version 1.40.1."""


def version_1_40_1(model_dict):
    """Implement changes in a Model dict to make it compatible with version 1.40.1."""
    if 'energy' in model_dict['properties']:
        if 'hvacs' in model_dict['properties']['energy']:
            for hvac in model_dict['properties']['energy']['hvacs']:
                if hvac['type'] != 'IdealAirSystemAbridged':  # it's detailed
                    hvac['vintage'] = VINTAGE_MAPPER[hvac['vintage']]
                    hvac['equipment_type'] = EQUIPMENT_MAPPER[hvac['equipment_type']]
    return model_dict


# dictionary to map between old and new vintages
VINTAGE_MAPPER = {
    '90.1-2013': 'ASHRAE_2013',
    '90.1-2010': 'ASHRAE_2010',
    '90.1-2007': 'ASHRAE_2007',
    '90.1-2004': 'ASHRAE_2004',
    'DOE Ref 1980-2004': 'DOE_Ref_1980_2004',
    'DOE Ref Pre-1980': 'DOE_Ref_Pre_1980'
}

# dictionary to map between the old and new HVAC equipment enumerations
EQUIPMENT_MAPPER = {
    'VAV chiller with gas boiler reheat': 'VAV_Chiller_Boiler',
    'VAV chiller with central air source heat pump reheat': 'VAV_Chiller_ASHP',
    'VAV chiller with district hot water reheat': 'VAV_Chiller_DHW',
    'VAV chiller with PFP boxes': 'VAV_Chiller_PFP',
    'VAV chiller with gas coil reheat': 'VAV_Chiller_GasCoil',
    'VAV air-cooled chiller with gas boiler reheat': 'VAV_ACChiller_Boiler',
    'VAV air-cooled chiller with central air source heat pump reheat': 'VAV_ACChiller_ASHP',
    'VAV air-cooled chiller with district hot water reheat': 'VAV_ACChiller_DHW',
    'VAV air-cooled chiller with PFP boxes': 'VAV_ACChiller_PFP',
    'VAV air-cooled chiller with gas coil reheat': 'VAV_ACChiller_GasCoil',
    'VAV district chilled water with gas boiler reheat': 'VAV_DCW_Boiler',
    'VAV district chilled water with central air source heat pump reheat': 'VAV_DCW_ASHP',
    'VAV district chilled water with district hot water reheat': 'VAV_DCW_DHW',
    'VAV district chilled water with PFP boxes': 'VAV_DCW_PFP',
    'VAV district chilled water with gas coil reheat': 'VAV_DCW_GasCoil',
    'PVAV with gas boiler reheat': 'PVAV_Boiler',
    'PVAV with central air source heat pump reheat': 'PVAV_ASHP',
    'PVAV with district hot water reheat': 'PVAV_DHW',
    'PVAV with PFP boxes': 'PVAV_PFP',
    'PVAV with gas heat with electric reheat': 'PVAV_BoilerElectricReheat',
    'PSZ-AC with baseboard electric': 'PSZAC_ElectricBaseboard',
    'PSZ-AC with baseboard gas boiler': 'PSZAC_BoilerBaseboard',
    'PSZ-AC with baseboard district hot water': 'PSZAC_DHWBaseboard',
    'PSZ-AC with gas unit heaters': 'PSZAC_GasHeaters',
    'PSZ-AC with electric coil': 'PSZAC_ElectricCoil',
    'PSZ-AC with gas coil': 'PSZAC_GasCoil',
    'PSZ-AC with gas boiler': 'PSZAC_Boiler',
    'PSZ-AC with central air source heat pump': 'PSZAC_ASHP',
    'PSZ-AC with district hot water': 'PSZAC_DHW',
    'PSZ-AC with no heat': 'PSZAC',
    'PSZ-AC district chilled water with baseboard electric': 'PSZAC_DCW_ElectricBaseboard',
    'PSZ-AC district chilled water with baseboard gas boiler': 'PSZAC_DCW_BoilerBaseboard',
    'PSZ-AC district chilled water with gas unit heaters': 'PSZAC_DCW_GasHeaters',
    'PSZ-AC district chilled water with electric coil': 'PSZAC_DCW_ElectricCoil',
    'PSZ-AC district chilled water with gas coil': 'PSZAC_DCW_GasCoil',
    'PSZ-AC district chilled water with gas boiler': 'PSZAC_DCW_Boiler',
    'PSZ-AC district chilled water with central air source heat pump': 'PSZAC_DCW_ASHP',
    'PSZ-AC district chilled water with district hot water': 'PSZAC_DCW_DHW',
    'PSZ-AC district chilled water with no heat': 'PSZAC_DCW',
    'PSZ-HP': 'PSZHP',
    'PTAC with baseboard electric': 'PTAC_ElectricBaseboard',
    'PTAC with baseboard gas boiler': 'PTAC_BoilerBaseboard',
    'PTAC with baseboard district hot water': 'PTAC_DHWBaseboard',
    'PTAC with gas unit heaters': 'PTAC_GasHeaters',
    'PTAC with electric coil': 'PTAC_ElectricCoil',
    'PTAC with gas coil': 'PTAC_GasCoil',
    'PTAC with gas boiler': 'PTAC_Boiler',
    'PTAC with central air source heat pump': 'PTAC_ASHP',
    'PTAC with district hot water': 'PTAC_DHW',
    'PTAC with no heat': 'PTAC',
    'PTHP': 'PTHP',
    'Forced air furnace': 'Furnace',
    'DOAS with fan coil chiller with boiler': 'DOAS_FCU_Chiller_Boiler',
    'DOAS with fan coil chiller with central air source heat pump': 'DOAS_FCU_Chiller_ASHP',
    'DOAS with fan coil chiller with district hot water': 'DOAS_FCU_Chiller_DHW',
    'DOAS with fan coil chiller with baseboard electric': 'DOAS_FCU_Chiller_ElectricBaseboard',
    'DOAS with fan coil chiller with gas unit heaters': 'DOAS_FCU_Chiller_GasHeaters',
    'DOAS with fan coil chiller with no heat': 'DOAS_FCU_Chiller',
    'DOAS with fan coil air-cooled chiller with boiler': 'DOAS_FCU_ACChiller_Boiler',
    'DOAS with fan coil air-cooled chiller with central air source heat pump': 'DOAS_FCU_ACChiller_ASHP',
    'DOAS with fan coil air-cooled chiller with district hot water': 'DOAS_FCU_ACChiller_DHW',
    'DOAS with fan coil air-cooled chiller with baseboard electric': 'DOAS_FCU_ACChiller_ElectricBaseboard',
    'DOAS with fan coil air-cooled chiller with gas unit heaters': 'DOAS_FCU_ACChiller_GasHeaters',
    'DOAS with fan coil air-cooled chiller with no heat': 'DOAS_FCU_ACChiller',
    'DOAS with fan coil district chilled water with boiler': 'DOAS_FCU_DCW_Boiler',
    'DOAS with fan coil district chilled water with central air source heat pump': 'DOAS_FCU_DCW_ASHP',
    'DOAS with fan coil district chilled water with district hot water': 'DOAS_FCU_DCW_DHW',
    'DOAS with fan coil district chilled water with baseboard electric': 'DOAS_FCU_DCW_ElectricBaseboard',
    'DOAS with fan coil district chilled water with gas unit heaters': 'DOAS_FCU_DCW_GasHeaters',
    'DOAS with fan coil district chilled water with no heat': 'DOAS_FCU_DCW',
    'DOAS with VRF': 'DOAS_VRF',
    'DOAS with water source heat pumps fluid cooler with boiler': 'DOAS_WSHP_FluidCooler_Boiler',
    'DOAS with water source heat pumps cooling tower with boiler': 'DOAS_WSHP_CoolingTower_Boiler',
    'DOAS with water source heat pumps with ground source heat pump': 'DOAS_WSHP_GSHP',
    'DOAS with water source heat pumps district chilled water with district hot water': 'DOAS_WSHP_DCW_DHW',
    'Baseboard electric': 'ElectricBaseboard',
    'Baseboard gas boiler': 'BoilerBaseboard',
    'Baseboard central air source heat pump': 'ASHPBaseboard',
    'Baseboard district hot water': 'DHWBaseboard',
    'Direct evap coolers with baseboard electric': 'EvapCoolers_ElectricBaseboard',
    'Direct evap coolers with baseboard gas boiler': 'EvapCoolers_BoilerBaseboard',
    'Direct evap coolers with baseboard central air source heat pump': 'EvapCoolers_ASHPBaseboard',
    'Direct evap coolers with baseboard district hot water': 'EvapCoolers_DHWBaseboard',
    'Direct evap coolers with forced air furnace': 'EvapCoolers_Furnace',
    'Direct evap coolers with gas unit heaters': 'EvapCoolers_UnitHeaters',
    'Direct evap coolers with no heat': 'EvapCoolers',
    'Fan coil chiller with boiler': 'FCU_Chiller_Boiler',
    'Fan coil chiller with central air source heat pump': 'FCU_Chiller_ASHP',
    'Fan coil chiller with district hot water': 'FCU_Chiller_DHW',
    'Fan coil chiller with baseboard electric': 'FCU_Chiller_ElectricBaseboard',
    'Fan coil chiller with gas unit heaters': 'FCU_Chiller_GasHeaters',
    'Fan coil chiller with no heat': 'FCU_Chiller',
    'Fan coil air-cooled chiller with boiler': 'FCU_ACChiller_Boiler',
    'Fan coil air-cooled chiller with central air source heat pump': 'FCU_ACChiller_ASHP',
    'Fan coil air-cooled chiller with district hot water': 'FCU_ACChiller_DHW',
    'Fan coil air-cooled chiller with baseboard electric': 'FCU_ACChiller_ElectricBaseboard',
    'Fan coil air-cooled chiller with gas unit heaters': 'FCU_ACChiller_GasHeaters',
    'Fan coil air-cooled chiller with no heat': 'FCU_ACChiller',
    'Fan coil district chilled water with boiler': 'FCU_DCW_Boiler',
    'Fan coil district chilled water with central air source heat pump': 'FCU_DCW_ASHP',
    'Fan coil district chilled water with district hot water': 'FCU_DCW_DHW',
    'Fan coil district chilled water with baseboard electric': 'FCU_DCW_ElectricBaseboard',
    'Fan coil district chilled water with gas unit heaters': 'FCU_DCW_GasHeaters',
    'Fan coil district chilled water with no heat': 'FCU_DCW',
    'Gas unit heaters': 'GasHeaters',
    'Residential AC with baseboard electric': 'ResidentialAC_ElectricBaseboard',
    'Residential AC with baseboard gas boiler': 'ResidentialAC_BoilerBaseboard',
    'Residential AC with baseboard central air source heat pump': 'ResidentialAC_ASHPBaseboard',
    'Residential AC with baseboard district hot water': 'ResidentialAC_DHWBaseboard',
    'Residential AC with residential forced air furnace': 'ResidentialAC_ResidentialFurnace',
    'Residential AC with no heat': 'ResidentialAC',
    'Residential heat pump': 'ResidentialHP',
    'Residential heat pump with no cooling': 'ResidentialHPNoCool',
    'Residential forced air furnace': 'ResidentialFurnace',
    'VRF': 'VRF',
    'Water source heat pumps fluid cooler with boiler': 'WSHP_FluidCooler_Boiler',
    'Water source heat pumps cooling tower with boiler': 'WSHP_CoolingTower_Boiler',
    'Water source heat pumps with ground source heat pump': 'WSHP_GSHP',
    'Water source heat pumps district chilled water with district hot water': 'WSHP_DCW_DHW',
    'Window AC with baseboard electric': 'WindowAC_ElectricBaseboard',
    'Window AC with baseboard gas boiler': 'WindowAC_BoilerBaseboard',
    'Window AC with baseboard central air source heat pump': 'WindowAC_ASHPBaseboard',
    'Window AC with baseboard district hot water': 'WindowAC_DHWBaseboard',
    'Window AC with forced air furnace': 'WindowAC_Furnace',
    'Window AC with unit heaters': 'WindowAC_GasHeaters',
    'Window AC with no heat': 'WindowAC'
}
