# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables


class PipelineScheduleVariable(pulumi.CustomResource):
    key: pulumi.Output[str]
    """
    Name of the variable.
    """
    pipeline_schedule_id: pulumi.Output[float]
    """
    The id of the pipeline schedule.
    """
    project: pulumi.Output[str]
    """
    The id of the project to add the schedule to.
    """
    value: pulumi.Output[str]
    """
    Value of the variable.
    """
    def __init__(__self__, resource_name, opts=None, key=None, pipeline_schedule_id=None, project=None, value=None, __props__=None, __name__=None, __opts__=None):
        """
        This resource allows you to create and manage variables for pipeline schedules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example_pipeline_schedule = gitlab.PipelineSchedule("examplePipelineSchedule",
            project="12345",
            description="Used to schedule builds",
            ref="master",
            cron="0 1 * * *")
        example_pipeline_schedule_variable = gitlab.PipelineScheduleVariable("examplePipelineScheduleVariable",
            project=gitlab_pipeline_schedule["project"],
            pipeline_schedule_id=gitlab_pipeline_schedule["id"],
            key="EXAMPLE_KEY",
            value="example")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: Name of the variable.
        :param pulumi.Input[float] pipeline_schedule_id: The id of the pipeline schedule.
        :param pulumi.Input[str] project: The id of the project to add the schedule to.
        :param pulumi.Input[str] value: Value of the variable.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if key is None:
                raise TypeError("Missing required property 'key'")
            __props__['key'] = key
            if pipeline_schedule_id is None:
                raise TypeError("Missing required property 'pipeline_schedule_id'")
            __props__['pipeline_schedule_id'] = pipeline_schedule_id
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if value is None:
                raise TypeError("Missing required property 'value'")
            __props__['value'] = value
        super(PipelineScheduleVariable, __self__).__init__(
            'gitlab:index/pipelineScheduleVariable:PipelineScheduleVariable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, key=None, pipeline_schedule_id=None, project=None, value=None):
        """
        Get an existing PipelineScheduleVariable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: Name of the variable.
        :param pulumi.Input[float] pipeline_schedule_id: The id of the pipeline schedule.
        :param pulumi.Input[str] project: The id of the project to add the schedule to.
        :param pulumi.Input[str] value: Value of the variable.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["key"] = key
        __props__["pipeline_schedule_id"] = pipeline_schedule_id
        __props__["project"] = project
        __props__["value"] = value
        return PipelineScheduleVariable(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
