# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['confprint']

package_data = \
{'': ['*']}

install_requires = \
['click==7.1.2']

entry_points = \
{'console_scripts': ['vinc = vinc:cli']}

setup_kwargs = {
    'name': 'confprint',
    'version': '0.4.5',
    'description': 'Python printer configurations.',
    'long_description': '<!-- ---\njupyter:\n  jupytext:\n    formats: ipynb,md\n    text_representation:\n      extension: .md\n      format_name: markdown\n      format_version: \'1.3\'\n      jupytext_version: 1.13.0\n  kernelspec:\n    display_name: Python 3 (ipykernel)\n    language: python\n    name: python3\n--- -->\n\n<!-- #region tags=[] -->\n# ConfPrint <!-- omit in toc -->\n[![GitHub License](https://img.shields.io/github/license/lewiuberg/confprint?color=blue)](LICENSE)\n![Python](https://img.shields.io/pypi/pyversions/confprint.svg?color=blue)\n[![PyPI](https://img.shields.io/pypi/v/confprint.svg?color=blue)](https://pypi.org/project/confprint/)\n[![Downloads](https://pepy.tech/badge/confprint)](https://pepy.tech/project/confprint)\n[![Codecov code coverage](https://img.shields.io/codecov/c/github/lewiuberg/confprint?color=blue)](https://app.codecov.io/gh/lewiuberg/confprint)\n![Github Contributors](https://img.shields.io/github/contributors/lewiuberg/confprint?color=blue)\n![GitHub search hit counter](https://img.shields.io/github/search/lewiuberg/confprint/confprint?label=confprint%20searches)\n[![GitHub issues](https://img.shields.io/github/issues-raw/lewiuberg/confprint)](https://github.com/lewiuberg/confprint/issues)\n![GitHub last commit](https://img.shields.io/github/last-commit/lewiuberg/confprint)\n\n[![CICD](https://github.com/lewiuberg/confprint/actions/workflows/cicd.yml/badge.svg)](https://github.com/lewiuberg/confprint/actions/workflows/cicd.yml)\n\nCopyright 2021 [Lewi Lie Uberg](https://uberg.me/)\\\n_Released under the MIT license_\n\n**ConfPrint** provides a simple way to make predefined printer configurations.\n\n## Contents <!-- omit in toc -->\n\n- [Citation](#citation)\n  - [APA](#apa)\n  - [BibTex](#bibtex)\n- [Prerequisites](#prerequisites)\n- [Installation](#installation)\n  - [Using pip](#using-pip)\n  - [Using Poetry](#using-poetry)\n- [Usage](#usage)\n  - [prefix_printer](#prefix_printer)\n- [Authors](#authors)\n- [License](#license)\n- [Acknowledgments](#acknowledgments)\n\n## Citation\n\nPlease see [CITATION.cff](CITATION.cff) for the full citation information.\n\n### APA\n\n```apa\nLie Uberg, L., & Hjelle, G. A. (2022). confprint (Version 0.4.5) [Computer software]. https://github.com/lewiuberg/confprint\n```\n\n### BibTex\n\n```BibTex\n@software{Lie_Uberg_confprint_2022,\nauthor = {Lie Uberg, Lewi and Hjelle, Geir Arne},\nlicense = {MIT},\nmonth = {10},\ntitle = {{confprint}},\nurl = {https://github.com/lewiuberg/confprint},\nversion = {0.4.5},\nyear = {2022}\n}\n```\n\n## Prerequisites\n\n[Click](https://pypi.org/project/click/)\n\nPlease see [pyproject.toml](pyproject.toml) for the full citation information.\n\n## Installation\n\n### Using pip\n\n```bash\npython -m pip install confprint\n```\n\n### Using Poetry\n\n```bash\npoetry add confprint\n```\n\n## Usage\n\n### prefix_printer\n<!-- #endregion -->\n\n```python\nfrom confprint import prefix_printer\n\np_test1 = prefix_printer(prefix="test1")\np_test1("Please read all the lines to understand the usage.\\n")\n\np_test2 = prefix_printer(prefix="test2", whitespace=4)\np_test2("use whitespace to indent the output.\\n")\n\np_test3 = prefix_printer(prefix="test3", upper=False)\np_test3("unaltered text, a.k.a .upper() not applied to the string.\\n")\n\np_test4 = prefix_printer(prefix="test4", stderr=True)\np_test4("using sys.stderr.write as the print function\\n")\n\np_test5 = prefix_printer(prefix="test5", click=True)\np_test5("using click.echo as the print function\\n")\n\np_test6 = prefix_printer(prefix="test6", frame_left="( ", frame_right=" )")\np_test6("using custom frame characters\\n")\n\np_test7 = prefix_printer(prefix="test7", counter_start=0)\np_test7("By defining a \'counter_start\',")\np_test7("a counter number will be appended")\np_test7("to the prefix.\\n")\n\np_test8 = prefix_printer(prefix="test8", counter_start=1)\np_test8("Different prefix printers can have different counters.")\np_test7("As you see in this example,")\np_test8("they have do not interfere with each other.\\n")\n\np_test9 = prefix_printer(prefix="test9", counter_start=10, global_counter=True)\np_test9("Global counters can also be set.")\np_test9("However, if any prefix printers has already been defined,")\np_test8("you have to set global_redefine to True.")\np_test7("But as you can see here,")\np_test7("global counters still doesn\'t interfere with local counters.\\n")\n\np_test10 = prefix_printer(prefix="test10", global_counter=True)\np_test10("New prefix_printers will pick up the last global count, which can")\np_test10("be handy with different prefixes should be used with sequential counting.\\n")\n\np_test1(\n    """With new lines in strings the text is converted\nto multiline, then all but the first are\nindented to line up with the rest.\\n"""\n)\n\np_test1(\n    "The next example wil not be ending with a `:`, "\n    "since it has no input.\\nAnd as you can see, this is also a multiline text.\\n"\n)\n\np_done = prefix_printer(prefix="done")\np_done()\n\nprint() # adding a blank line.\np_bonus = prefix_printer(prefix="bonus")\nvariable_name = "Using a \'f-string\' with an added \'=\' can be handy when debugging."\np_bonus(f"{variable_name = } ")\n```\n\n```\n[TEST1]:  Please read all the lines to understand the usage.\n          \n[TEST2]:     use whitespace to indent the output.\n             \n[test3]:  unaltered text, a.k.a .upper() not applied to the string.\n          \n[TEST4]:  using sys.stderr.write as the print function\n          \n[TEST5]:  using click.echo as the print function\n          \n( TEST6 ):  using custom frame characters\n            \n[TEST7:0]: By defining a \'counter_start\',\n[TEST7:1]: a counter number will be appended\n[TEST7:2]:  to the prefix.\n            \n[TEST8:1]: Different prefix printers can have different counters.\n[TEST7:3]: As you see in this example,\n[TEST8:2]:  they have do not interfere with each other.\n            \n[TEST9:10]: Global counters can also be set.\n[TEST9:11]: However, if any prefix printers has already been defined,\n[TEST8:3]: you have to set global_redefine to True.\n[TEST7:4]: But as you can see here,\n[TEST7:5]:  global counters still doesn\'t interfere with local counters.\n            \n[TEST10:12]: New prefix_printers will pick up the last global count, which can\n[TEST10:13]:  be handy with different prefixes should be used with sequential counting.\n              \n[TEST1]:  With new lines in strings the text is converted\n          to multiline, then all but the first are\n          indented to line up with the rest.\n          \n[TEST1]:  The next example wil not be ending with a `:`, since it has no input.\n          And as you can see, this is also a multiline text.\n          \n[DONE]\n\n[BONUS]: variable_name = "Using a \'f-string\' with an added \'=\' can be handy when debugging." \n```\n\n\n## Authors\n\n- **[Lewi Lie Uberg](https://github.com/lewiuberg)** - [uberg.me](https://uberg.me/)\n\n## License\n\nThis project is licensed under the MIT License - see the [LICENSE](https://github.com/lewiuberg/confprint/blob/main/LICENSE) file for details\n\n## Acknowledgments\n\n- [Geir Arne Hjelle](https://github.com/gahjelle), for his presentation on \'Introduction to Decorators\' given at [PyCon 21](https://www.youtube.com/watch?v=VWZAh1QrqRE&amp;t=17m0s)\n',
    'author': 'Lewi Lie Uberg',
    'author_email': 'lewi@uberg.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/lewiuberg/confprint',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
