import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageBucketObjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the containing bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#bucket StorageBucketObject#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Cache-Control directive to specify caching behavior of object data.
     *
     * If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#cache_control StorageBucketObject#cache_control}
     *
     * @stability stable
     */
    readonly cacheControl?: string;
    /**
     * Data as string to be uploaded.
     *
     * Must be defined if source is not. Note: The content field is marked as sensitive. To view the raw contents of the object, please define an output.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#content StorageBucketObject#content}
     *
     * @stability stable
     */
    readonly content?: string;
    /**
     * Content-Disposition of the object data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#content_disposition StorageBucketObject#content_disposition}
     *
     * @stability stable
     */
    readonly contentDisposition?: string;
    /**
     * Content-Encoding of the object data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#content_encoding StorageBucketObject#content_encoding}
     *
     * @stability stable
     */
    readonly contentEncoding?: string;
    /**
     * Content-Language of the object data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#content_language StorageBucketObject#content_language}
     *
     * @stability stable
     */
    readonly contentLanguage?: string;
    /**
     * Content-Type of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#content_type StorageBucketObject#content_type}
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#detect_md5hash StorageBucketObject#detect_md5hash}.
     *
     * @stability stable
     */
    readonly detectMd5Hash?: string;
    /**
     * Whether an object is under event-based hold.
     *
     * Event-based hold is a way to retain objects until an event occurs, which is signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects will be subject to bucket-level retention (if any).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#event_based_hold StorageBucketObject#event_based_hold}
     *
     * @stability stable
     */
    readonly eventBasedHold?: boolean | cdktf.IResolvable;
    /**
     * Resource name of the Cloud KMS key that will be used to encrypt the object.
     *
     * Overrides the object metadata's kmsKeyName value, if any.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#kms_key_name StorageBucketObject#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName?: string;
    /**
     * User-provided metadata, in key/value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#metadata StorageBucketObject#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The name of the object. If you're interpolating the name of this object, see output_name instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#name StorageBucketObject#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * A path to the data you want to upload. Must be defined if content is not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#source StorageBucketObject#source}
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * The StorageClass of the new bucket object.
     *
     * Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE. If not provided, this defaults to the bucket's default storage class or to a standard class.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#storage_class StorageBucketObject#storage_class}
     *
     * @stability stable
     */
    readonly storageClass?: string;
    /**
     * Whether an object is under temporary hold.
     *
     * While this flag is set to true, the object is protected against deletion and overwrites.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#temporary_hold StorageBucketObject#temporary_hold}
     *
     * @stability stable
     */
    readonly temporaryHold?: boolean | cdktf.IResolvable;
    /**
     * customer_encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#customer_encryption StorageBucketObject#customer_encryption}
     *
     * @stability stable
     */
    readonly customerEncryption?: StorageBucketObjectCustomerEncryption;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#timeouts StorageBucketObject#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageBucketObjectTimeouts;
}
/**
 * @stability stable
 */
export interface StorageBucketObjectCustomerEncryption {
    /**
     * The encryption algorithm. Default: AES256.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#encryption_algorithm StorageBucketObject#encryption_algorithm}
     *
     * @stability stable
     */
    readonly encryptionAlgorithm?: string;
    /**
     * Base64 encoded customer supplied encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#encryption_key StorageBucketObject#encryption_key}
     *
     * @stability stable
     */
    readonly encryptionKey: string;
}
/**
 * @stability stable
 */
export declare class StorageBucketObjectCustomerEncryptionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _encryptionAlgorithm?;
    /**
     * @stability stable
     */
    get encryptionAlgorithm(): string | undefined;
    /**
     * @stability stable
     */
    set encryptionAlgorithm(value: string | undefined);
    /**
     * @stability stable
     */
    resetEncryptionAlgorithm(): void;
    /**
     * @stability stable
     */
    get encryptionAlgorithmInput(): string | undefined;
    private _encryptionKey?;
    /**
     * @stability stable
     */
    get encryptionKey(): string;
    /**
     * @stability stable
     */
    set encryptionKey(value: string);
    /**
     * @stability stable
     */
    get encryptionKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageBucketObjectTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#create StorageBucketObject#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#delete StorageBucketObject#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#update StorageBucketObject#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class StorageBucketObjectTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html google_storage_bucket_object}.
 *
 * @stability stable
 */
export declare class StorageBucketObject extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html google_storage_bucket_object} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageBucketObjectConfig);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _cacheControl?;
    /**
     * @stability stable
     */
    get cacheControl(): string | undefined;
    /**
     * @stability stable
     */
    set cacheControl(value: string | undefined);
    /**
     * @stability stable
     */
    resetCacheControl(): void;
    /**
     * @stability stable
     */
    get cacheControlInput(): string | undefined;
    private _content?;
    /**
     * @stability stable
     */
    get content(): string | undefined;
    /**
     * @stability stable
     */
    set content(value: string | undefined);
    /**
     * @stability stable
     */
    resetContent(): void;
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _contentDisposition?;
    /**
     * @stability stable
     */
    get contentDisposition(): string | undefined;
    /**
     * @stability stable
     */
    set contentDisposition(value: string | undefined);
    /**
     * @stability stable
     */
    resetContentDisposition(): void;
    /**
     * @stability stable
     */
    get contentDispositionInput(): string | undefined;
    private _contentEncoding?;
    /**
     * @stability stable
     */
    get contentEncoding(): string | undefined;
    /**
     * @stability stable
     */
    set contentEncoding(value: string | undefined);
    /**
     * @stability stable
     */
    resetContentEncoding(): void;
    /**
     * @stability stable
     */
    get contentEncodingInput(): string | undefined;
    private _contentLanguage?;
    /**
     * @stability stable
     */
    get contentLanguage(): string | undefined;
    /**
     * @stability stable
     */
    set contentLanguage(value: string | undefined);
    /**
     * @stability stable
     */
    resetContentLanguage(): void;
    /**
     * @stability stable
     */
    get contentLanguageInput(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string | undefined;
    /**
     * @stability stable
     */
    set contentType(value: string | undefined);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get crc32C(): string;
    private _detectMd5Hash?;
    /**
     * @stability stable
     */
    get detectMd5Hash(): string | undefined;
    /**
     * @stability stable
     */
    set detectMd5Hash(value: string | undefined);
    /**
     * @stability stable
     */
    resetDetectMd5Hash(): void;
    /**
     * @stability stable
     */
    get detectMd5HashInput(): string | undefined;
    private _eventBasedHold?;
    /**
     * @stability stable
     */
    get eventBasedHold(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set eventBasedHold(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEventBasedHold(): void;
    /**
     * @stability stable
     */
    get eventBasedHoldInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string | undefined;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsKeyName(): void;
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get md5Hash(): string;
    /**
     * @stability stable
     */
    get mediaLink(): string;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outputName(): string;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string | undefined;
    /**
     * @stability stable
     */
    set source(value: string | undefined);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _storageClass?;
    /**
     * @stability stable
     */
    get storageClass(): string | undefined;
    /**
     * @stability stable
     */
    set storageClass(value: string | undefined);
    /**
     * @stability stable
     */
    resetStorageClass(): void;
    /**
     * @stability stable
     */
    get storageClassInput(): string | undefined;
    private _temporaryHold?;
    /**
     * @stability stable
     */
    get temporaryHold(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set temporaryHold(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTemporaryHold(): void;
    /**
     * @stability stable
     */
    get temporaryHoldInput(): boolean | cdktf.IResolvable | undefined;
    private _customerEncryption?;
    private __customerEncryptionOutput;
    /**
     * @stability stable
     */
    get customerEncryption(): StorageBucketObjectCustomerEncryptionOutputReference;
    /**
     * @stability stable
     */
    putCustomerEncryption(value: StorageBucketObjectCustomerEncryption | undefined): void;
    /**
     * @stability stable
     */
    resetCustomerEncryption(): void;
    /**
     * @stability stable
     */
    get customerEncryptionInput(): StorageBucketObjectCustomerEncryption | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): StorageBucketObjectTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageBucketObjectTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageBucketObjectTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
