# Generated by Django 2.2.5 on 2020-06-23 06:17

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("core", "0002_auto_20200623_1317"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Initiative",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("number", models.TextField(verbose_name="Регистрационный номер")),
                (
                    "creation_date_time",
                    models.DateTimeField(verbose_name="Дата создания"),
                ),
                ("email", models.TextField(verbose_name="Электронная почта")),
                (
                    "duration_month",
                    models.PositiveIntegerField(
                        verbose_name="Продолжительность голосования"
                    ),
                ),
                (
                    "votes_threshold",
                    models.PositiveIntegerField(
                        verbose_name="Требуемое количество голосов"
                    ),
                ),
                ("title", models.TextField(verbose_name="Заголовок")),
                ("description", models.TextField(verbose_name="Описание")),
                ("expectations", models.TextField(verbose_name="Ожидаемый результат")),
                (
                    "state",
                    models.TextField(
                        choices=[
                            ("PREMODERATION", "Модерирование"),
                            ("CHANGES_APPROVAL", "Согласование изменений"),
                            ("MODERATION", "Экспертная оценка"),
                            ("REJECTED", "Отклонена"),
                            ("VOTES_COLLECTION", "Сбор голосов"),
                            (
                                "REJECTED_VOTES_THRESHOLD",
                                "Порог голосования не пройден",
                            ),
                            ("CONSIDERATION", "На рассмотрении"),
                            ("IN_PROGRESS", "Принято решение"),
                            ("ACCOMPLISHED", "Реализовано"),
                        ],
                        verbose_name="Статус",
                    ),
                ),
                (
                    "moderation_begin_date",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="Дата начала модерации"
                    ),
                ),
                (
                    "votes_collection_begin_date",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="Дата начала сбора голосов"
                    ),
                ),
            ],
            options={
                "verbose_name": "Инициатива",
                "verbose_name_plural": "Инициативы",
            },
        ),
        migrations.CreateModel(
            name="InitiativeFile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("file", models.FileField(upload_to="", verbose_name="Файл")),
                (
                    "type",
                    models.TextField(
                        choices=[("IMAGE", "Изображение"), ("DOCUMENT", "Документ")],
                        verbose_name="Тип файла",
                    ),
                ),
                (
                    "order",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="Порядок"
                    ),
                ),
            ],
            options={
                "verbose_name": "Файл",
                "verbose_name_plural": "Файлы",
            },
        ),
        migrations.CreateModel(
            name="InitiativeRejectReason",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("text", models.TextField(verbose_name="Текст")),
            ],
            options={
                "verbose_name": "Причина отказа",
                "verbose_name_plural": "Причины отказа",
            },
        ),
        migrations.CreateModel(
            name="InitiativeStateChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "new_state",
                    models.TextField(
                        choices=[
                            ("PREMODERATION", "Модерирование"),
                            ("CHANGES_APPROVAL", "Согласование изменений"),
                            ("MODERATION", "Экспертная оценка"),
                            ("REJECTED", "Отклонена"),
                            ("VOTES_COLLECTION", "Сбор голосов"),
                            (
                                "REJECTED_VOTES_THRESHOLD",
                                "Порог голосования не пройден",
                            ),
                            ("CONSIDERATION", "На рассмотрении"),
                            ("IN_PROGRESS", "Принято решение"),
                            ("ACCOMPLISHED", "Реализовано"),
                        ],
                        verbose_name="Новый статус",
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(verbose_name="Дата-время изменения"),
                ),
                (
                    "initiative",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="initiatives.Initiative",
                        verbose_name="Инициатива",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Пользователь",
                    ),
                ),
            ],
            options={
                "verbose_name": "Изменение состояния инициативы",
                "verbose_name_plural": "Изменения состояния инициатив",
            },
        ),
        migrations.CreateModel(
            name="InitiativeOperatorCommunication",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("timestamp", models.DateTimeField(verbose_name="Дата-время")),
                (
                    "type",
                    models.TextField(
                        choices=[
                            ("SYSTEM_NOTIFICATION", "Сообщение системы"),
                            ("PREMODERATE_REQUEST", "Запрос модератора"),
                            ("PREMODERATE_RESPONSE", "Ответ на запрос модератора"),
                            (
                                "PREMODERATE_CHANGES_REQUEST",
                                "Запрос модератора на изменение инициативы",
                            ),
                            (
                                "PREMODERATE_CHANGES_RESPONSE",
                                "Ответ пользователя на изменение инициативы",
                            ),
                            (
                                "PREMODERATE_REJECT",
                                "Инициатива отклонена по решению модератора",
                            ),
                            ("MODERATE_REQUEST", "Запрос оператора"),
                            ("MODERATE_RESPONSE", "Ответ на запрос оператора"),
                            (
                                "MODERATE_REJECT",
                                "Инициатива отклонена по решению оператора",
                            ),
                            (
                                "IN_PROGRESS_NOTIFICATION",
                                "Решение о реализации инициативы",
                            ),
                            (
                                "ACCOMPLISHED_NOTIFICATION",
                                "Результаты реализации инициативы",
                            ),
                        ],
                        verbose_name="Тип",
                    ),
                ),
                ("text", models.TextField(blank=True, null=True, verbose_name="Текст")),
                (
                    "title",
                    models.TextField(blank=True, null=True, verbose_name="Заголовок"),
                ),
                (
                    "description",
                    models.TextField(blank=True, null=True, verbose_name="Описание"),
                ),
                (
                    "expectations",
                    models.TextField(
                        blank=True, null=True, verbose_name="Ожидаемый результат"
                    ),
                ),
                (
                    "decision",
                    models.TextField(
                        blank=True,
                        choices=[("APPROVE", "Одобрить"), ("REJECT", "Отклонить")],
                        null=True,
                        verbose_name="Решение",
                    ),
                ),
                (
                    "state",
                    models.TextField(
                        blank=True,
                        choices=[
                            ("MODERATION_REQUIRED", "Требует модерации"),
                            ("APPROVED", "Одобрено"),
                            ("REJECTED", "Отклонено"),
                        ],
                        null=True,
                        verbose_name="Состояние",
                    ),
                ),
                (
                    "files",
                    models.ManyToManyField(
                        blank=True,
                        to="initiatives.InitiativeFile",
                        verbose_name="Файлы",
                    ),
                ),
                (
                    "initiative",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="initiative_operator_communication",
                        to="initiatives.Initiative",
                        verbose_name="Инициатива",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Отправитель",
                    ),
                ),
            ],
            options={
                "verbose_name": "Коммуникация c пользователем",
                "verbose_name_plural": "Коммуникация c пользователем",
            },
        ),
        migrations.CreateModel(
            name="InitiativeCategory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField(verbose_name="Наименование")),
                (
                    "color",
                    models.CharField(
                        blank=True,
                        default="#000000",
                        max_length=7,
                        null=True,
                        verbose_name="Цвет html",
                    ),
                ),
                (
                    "image",
                    models.ImageField(
                        blank=True, null=True, upload_to="", verbose_name="Изображение"
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="initiatives.InitiativeCategory",
                        verbose_name="Родительская категория",
                    ),
                ),
            ],
            options={
                "verbose_name": "Тематическая категория",
                "verbose_name_plural": "Тематические категории",
            },
        ),
        migrations.CreateModel(
            name="InitiativeAcceptingSettings",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "duration_month",
                    models.PositiveIntegerField(
                        verbose_name="Продолжительность голосования"
                    ),
                ),
                (
                    "votes_threshold",
                    models.PositiveIntegerField(
                        verbose_name="Пороговое значение количества голосов"
                    ),
                ),
                ("active", models.BooleanField(verbose_name="Активен")),
                (
                    "category",
                    models.ManyToManyField(
                        related_name="initiative_accepting_settings",
                        to="initiatives.InitiativeCategory",
                        verbose_name="Категория",
                    ),
                ),
                (
                    "department",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.Department",
                        verbose_name="Ведомство",
                    ),
                ),
                (
                    "locality",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.Locality",
                        verbose_name="Муниципальное образование",
                    ),
                ),
            ],
            options={
                "verbose_name": "Параметр приема инициативы",
                "verbose_name_plural": "Параметры приема инициатив",
            },
        ),
        migrations.AddField(
            model_name="initiative",
            name="category",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="initiatives.InitiativeCategory",
                verbose_name="Категория",
            ),
        ),
        migrations.AddField(
            model_name="initiative",
            name="files",
            field=models.ManyToManyField(
                to="initiatives.InitiativeFile", verbose_name="Файлы"
            ),
        ),
        migrations.AddField(
            model_name="initiative",
            name="locality",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="core.Locality",
                verbose_name="Муниципальное образование",
            ),
        ),
        migrations.AddField(
            model_name="initiative",
            name="settings",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="initiatives.InitiativeAcceptingSettings",
            ),
        ),
        migrations.AddField(
            model_name="initiative",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
                verbose_name="Заявитель",
            ),
        ),
        migrations.CreateModel(
            name="UserInitiativeApprove",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(auto_now_add=True, verbose_name="Дата-время"),
                ),
                (
                    "initiative",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_initiative_approve",
                        to="initiatives.Initiative",
                        verbose_name="Инициатива",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Пользователь",
                    ),
                ),
            ],
            options={
                "verbose_name": "Одобрение пользователем",
                "verbose_name_plural": "Одобрения пользователей",
                "unique_together": {("user", "initiative")},
            },
        ),
    ]
