import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ReplicationSlotConfig extends cdktf.TerraformMetaArguments {
    /**
     * Sets the database to add the replication slot to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/replication_slot.html#database ReplicationSlot#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/replication_slot.html#name ReplicationSlot#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Sets the output plugin to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/replication_slot.html#plugin ReplicationSlot#plugin}
     *
     * @stability stable
     */
    readonly plugin: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/replication_slot.html postgresql_replication_slot}.
 *
 * @stability stable
 */
export declare class ReplicationSlot extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/replication_slot.html postgresql_replication_slot} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ReplicationSlotConfig);
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    resetDatabase(): void;
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _plugin?;
    /**
     * @stability stable
     */
    get plugin(): string;
    /**
     * @stability stable
     */
    set plugin(value: string);
    /**
     * @stability stable
     */
    get pluginInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
