# -*- coding: utf-8 -*-

"""
why aiohttp over httpx?
    - Our module is fully using asynchronous which is aiohttp spesialization
    - has more mature asyncio support than httpx
    - aiohttp is more suitable for applications that require high concurrency and low latency, such as web scraping or real-time data processing.

references:
    - https://github.com/encode/httpx/issues/3215#issuecomment-2157885121
    - https://github.com/encode/httpx/discussions/3100
    - https://brightdata.com/blog/web-data/requests-vs-httpx-vs-aiohttp


"""

# built ins
import asyncio

# installed
import aiohttp
from aiohttp.helpers import BasicAuth

# user defined formula
from streaming_helper.restful_api.deribit import end_point_params_template as end_point_deribit
from streaming_helper.restful_api.telegram import (
    end_point_params_template as telegram_end_point,
)


async def get_connected(
    connection_url: str,
    endpoint: str = None,
    client_id: str = None,
    client_secret: str = None,
    params: str = None,
) -> None:


    async with aiohttp.ClientSession() as session:

        
        from loguru import logger as log

        log.debug(f"connection_url {connection_url} endpoint {endpoint}")
        log.debug(f"client_id {client_id} client_secret {client_secret} params {params}")   
        
        if client_id:

            if "telegram" in connection_url:

                response = await telegram_response(
                    session,
                    connection_url,
                    endpoint,
                    client_id,
                    client_secret,
                    params,
                )

            if "deribit" in connection_url:

                response: dict = await deribit_response(
                    connection_url,
                    endpoint,
                    client_id,
                    client_secret,
                    params,
                )
                
                log.info(f"response {response}")

        else:

            async with session.get(connection_url + endpoint) as response:

                # RESToverHTTP Response Content
                response: dict = await response.json()

        return response


async def telegram_response(
    session: object,
    connection_url: str,
    endpoint: str = None,
    client_id: str = None,
    client_secret: str = None,
    params: str = None,
) -> None:
    """ """
    endpoint = telegram_end_point.message_end_point(client_id, client_secret, params)

    connection_endpoint = connection_url + endpoint

    async with session.get(connection_endpoint) as response:

        # RESToverHTTP Response Content
        return await response.json()


async def deribit_response(
    connection_url,
    endpoint: str = None,
    client_id: str = None,
    client_secret: str = None,
    params: str = None,
) -> None:
    
    from loguru import logger as log

    payload: dict = end_point_deribit.get_json_payload(
        endpoint,
        params,
    )   
    
    async with aiohttp.ClientSession() as session:
            
        async with session.post(
            connection_url+endpoint,
            auth=BasicAuth(client_id, client_secret),
            json=payload,
        ) as response:

            # RESToverHTTP Status Code
            status_code: int = response.status
    
        log.warning(f"payload {payload} params {params} status_code {status_code} response {response}")
    
        # RESToverHTTP Response Content
        return await response.json()


async def private_connection(
    connection_url: str,
    endpoint: str,
    client_id: str ,
    client_secret: str,
    params: str,
) -> None:

    payload: dict = end_point_deribit.get_json_payload(
        endpoint,
        params,
    )   

    from loguru import logger as log

    async with aiohttp.ClientSession() as session:
        async with session.post(
            connection_url + endpoint,
            auth=BasicAuth(client_id, client_secret),
            json=payload,
        ) as response:

         
            # RESToverHTTP Status Code
            status_code: int = response.status
            
            log.error(f"payload {payload} endpoint {endpoint} params {params} status_code {status_code}  response {response}")
            log.debug(f"client_id {client_id} client_secret {client_secret} connection_endpoint {connection_url + endpoint} ")

            # RESToverHTTP Response Content
            response= await response.json()

        return response
