include(CheckCXXCompilerFlag)

function(DetectCXXStandard OUTPUT_VAR)
  if(NOT MSVC)
    set(CXX_STANDARD20_FLAG "-std=c++20")
    set(CXX_STANDARD17_FLAG "-std=c++17")
    set(CXX_STANDARD14_FLAG "-std=c++14")
    set(CXX_STANDARD11_FLAG "-std=c++11")
  elseif(MSVC)
    set(CXX_STANDARD20_FLAG "/std:c++20")
    set(CXX_STANDARD17_FLAG "/std:c++17")
    set(CXX_STANDARD14_FLAG "/std:c++14")
  endif()

  # TODO use VERSION_GREATER_EQUAL in cmake 3.7+
  check_cxx_compiler_flag(${CXX_STANDARD20_FLAG} HAS_CXX20_FLAG)
  if (HAS_CXX20_FLAG AND ((${CMAKE_VERSION} VERSION_EQUAL "3.12.0") OR (${CMAKE_VERSION} VERSION_GREATER "3.12.0")))
    set(${OUTPUT_VAR} 20 PARENT_SCOPE)
    return()
  endif()

  check_cxx_compiler_flag(${CXX_STANDARD17_FLAG} HAS_CXX17_FLAG)
  if (HAS_CXX17_FLAG AND ((${CMAKE_VERSION} VERSION_EQUAL "3.8.0") OR (${CMAKE_VERSION} VERSION_GREATER "3.8.0")))
    set(${OUTPUT_VAR} 17 PARENT_SCOPE)
    return()
  endif()

  check_cxx_compiler_flag(${CXX_STANDARD14_FLAG} HAS_CXX14_FLAG)
  if (HAS_CXX14_FLAG)
    set(${OUTPUT_VAR} 14 PARENT_SCOPE)
    return()
  endif()

  set(${OUTPUT_VAR} 11 PARENT_SCOPE)
endfunction()
