"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
const copy_1 = require("./copy");
const fingerprint_1 = require("./fingerprint");
__export(require("./options"));
/**
 * File system utilities.
 */
class FileSystem {
    /**
     * Copies an entire directory structure.
     * @param srcDir Source directory
     * @param destDir Destination directory
     * @param options options
     * @param rootDir Root directory to calculate exclusions from
     */
    static copyDirectory(srcDir, destDir, options = {}, rootDir) {
        return copy_1.copyDirectory(srcDir, destDir, options, rootDir);
    }
    /**
     * Produces fingerprint based on the contents of a single file or an entire directory tree.
     *
     * The fingerprint will also include:
     * 1. An extra string if defined in `options.extra`.
     * 2. The set of exclude patterns, if defined in `options.exclude`
     * 3. The symlink follow mode value.
     *
     * @param fileOrDirectory The directory or file to fingerprint
     * @param options Fingerprinting options
     */
    static fingerprint(fileOrDirectory, options = {}) {
        return fingerprint_1.fingerprint(fileOrDirectory, options);
    }
}
exports.FileSystem = FileSystem;
//# sourceMappingURL=data:application/json;base64,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