"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const construct_compat_1 = require("../construct-compat");
const custom_resource_provider_1 = require("../custom-resource-provider");
/**
 * A custom resource provider for CFN utilities such as `CfnJson`.
 */
class CfnUtilsProvider extends construct_compat_1.Construct {
    static getOrCreate(scope) {
        return custom_resource_provider_1.CustomResourceProvider.getOrCreate(scope, 'AWSCDKCfnUtilsProvider', {
            runtime: custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_12,
            codeDirectory: `${__dirname}/cfn-utils-provider`,
        });
    }
}
exports.CfnUtilsProvider = CfnUtilsProvider;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLXV0aWxzLXByb3ZpZGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY2ZuLXV0aWxzLXByb3ZpZGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsMERBQWdEO0FBQ2hELDBFQUFvRztBQUVwRzs7R0FFRztBQUNILE1BQWEsZ0JBQWlCLFNBQVEsNEJBQVM7SUFDdEMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxLQUFnQjtRQUN4QyxPQUFPLGlEQUFzQixDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsd0JBQXdCLEVBQUU7WUFDekUsT0FBTyxFQUFFLHdEQUE2QixDQUFDLFNBQVM7WUFDaEQsYUFBYSxFQUFFLEdBQUcsU0FBUyxxQkFBcUI7U0FDakQsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBUEQsNENBT0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICcuLi9jb25zdHJ1Y3QtY29tcGF0JztcbmltcG9ydCB7IEN1c3RvbVJlc291cmNlUHJvdmlkZXIsIEN1c3RvbVJlc291cmNlUHJvdmlkZXJSdW50aW1lIH0gZnJvbSAnLi4vY3VzdG9tLXJlc291cmNlLXByb3ZpZGVyJztcblxuLyoqXG4gKiBBIGN1c3RvbSByZXNvdXJjZSBwcm92aWRlciBmb3IgQ0ZOIHV0aWxpdGllcyBzdWNoIGFzIGBDZm5Kc29uYC5cbiAqL1xuZXhwb3J0IGNsYXNzIENmblV0aWxzUHJvdmlkZXIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgc3RhdGljIGdldE9yQ3JlYXRlKHNjb3BlOiBDb25zdHJ1Y3QpIHtcbiAgICByZXR1cm4gQ3VzdG9tUmVzb3VyY2VQcm92aWRlci5nZXRPckNyZWF0ZShzY29wZSwgJ0FXU0NES0NmblV0aWxzUHJvdmlkZXInLCB7XG4gICAgICBydW50aW1lOiBDdXN0b21SZXNvdXJjZVByb3ZpZGVyUnVudGltZS5OT0RFSlNfMTIsXG4gICAgICBjb2RlRGlyZWN0b3J5OiBgJHtfX2Rpcm5hbWV9L2Nmbi11dGlscy1wcm92aWRlcmAsXG4gICAgfSk7XG4gIH1cbn0iXX0=