"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Parses the value of "Value" and reflects it back as attribute.
 */
async function handler(event) {
    // dispatch based on resource type
    if (event.ResourceType === "Custom::AWSCDKCfnJson" /* CFN_JSON */) {
        return cfnJsonHandler(event);
    }
    throw new Error(`unexpected resource type "${event.ResourceType}`);
}
exports.handler = handler;
function cfnJsonHandler(event) {
    return {
        Data: {
            Value: JSON.parse(event.ResourceProperties.Value),
        },
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUVBOztHQUVHO0FBQ0ksS0FBSyxVQUFVLE9BQU8sQ0FBQyxLQUFrRDtJQUU5RSxrQ0FBa0M7SUFDbEMsSUFBSSxLQUFLLENBQUMsWUFBWSwyQ0FBa0MsRUFBRTtRQUN4RCxPQUFPLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUM5QjtJQUVELE1BQU0sSUFBSSxLQUFLLENBQUMsNkJBQTZCLEtBQUssQ0FBQyxZQUFZLEVBQUUsQ0FBQyxDQUFDO0FBQ3JFLENBQUM7QUFSRCwwQkFRQztBQUVELFNBQVMsY0FBYyxDQUFDLEtBQWtEO0lBQ3hFLE9BQU87UUFDTCxJQUFJLEVBQUU7WUFDSixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDO1NBQ2xEO0tBQ0YsQ0FBQztBQUNKLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDZm5VdGlsc1Jlc291cmNlVHlwZSB9IGZyb20gJy4vY29uc3RzJztcblxuLyoqXG4gKiBQYXJzZXMgdGhlIHZhbHVlIG9mIFwiVmFsdWVcIiBhbmQgcmVmbGVjdHMgaXQgYmFjayBhcyBhdHRyaWJ1dGUuXG4gKi9cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBoYW5kbGVyKGV2ZW50OiBBV1NMYW1iZGEuQ2xvdWRGb3JtYXRpb25DdXN0b21SZXNvdXJjZUV2ZW50KSB7XG5cbiAgLy8gZGlzcGF0Y2ggYmFzZWQgb24gcmVzb3VyY2UgdHlwZVxuICBpZiAoZXZlbnQuUmVzb3VyY2VUeXBlID09PSBDZm5VdGlsc1Jlc291cmNlVHlwZS5DRk5fSlNPTikge1xuICAgIHJldHVybiBjZm5Kc29uSGFuZGxlcihldmVudCk7XG4gIH1cblxuICB0aHJvdyBuZXcgRXJyb3IoYHVuZXhwZWN0ZWQgcmVzb3VyY2UgdHlwZSBcIiR7ZXZlbnQuUmVzb3VyY2VUeXBlfWApO1xufVxuXG5mdW5jdGlvbiBjZm5Kc29uSGFuZGxlcihldmVudDogQVdTTGFtYmRhLkNsb3VkRm9ybWF0aW9uQ3VzdG9tUmVzb3VyY2VFdmVudCkge1xuICByZXR1cm4ge1xuICAgIERhdGE6IHtcbiAgICAgIFZhbHVlOiBKU09OLnBhcnNlKGV2ZW50LlJlc291cmNlUHJvcGVydGllcy5WYWx1ZSksXG4gICAgfSxcbiAgfTtcbn1cbiJdfQ==