"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RemovalPolicy;
(function (RemovalPolicy) {
    /**
     * This is the default removal policy. It means that when the resource is
     * removed from the app, it will be physically destroyed.
     */
    RemovalPolicy["DESTROY"] = "destroy";
    /**
     * This uses the 'Retain' DeletionPolicy, which will cause the resource to be retained
     * in the account, but orphaned from the stack.
     */
    RemovalPolicy["RETAIN"] = "retain";
    /**
     * This retention policy deletes the resource,
     * but saves a snapshot of its data before deleting,
     * so that it can be re-created later.
     * Only available for some stateful resources,
     * like databases, EFS volumes, etc.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options
     */
    RemovalPolicy["SNAPSHOT"] = "snapshot";
})(RemovalPolicy = exports.RemovalPolicy || (exports.RemovalPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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