"use strict";
const fs = require("fs");
const os = require("os");
const path = require("path");
const runtime_info_1 = require("../lib/private/runtime-info");
module.exports = {
    'version reporting includes @aws-solutions-konstruk libraries'(test) {
        const pkgdir = fs.mkdtempSync(path.join(os.tmpdir(), 'runtime-info-konstruk-fixture'));
        const mockVersion = '1.2.3';
        fs.writeFileSync(path.join(pkgdir, 'index.js'), 'module.exports = \'this is foo\';');
        fs.writeFileSync(path.join(pkgdir, 'package.json'), JSON.stringify({
            name: '@aws-solutions-konstruk/foo',
            version: mockVersion,
        }));
        // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
        require(pkgdir);
        const runtimeInfo = runtime_info_1.collectRuntimeInformation();
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        const version = require('../package.json').version;
        test.deepEqual(runtimeInfo.libraries, {
            '@aws-cdk/core': version,
            '@aws-cdk/cx-api': version,
            '@aws-cdk/cloud-assembly-schema': version,
            '@aws-cdk/cdk-assets-schema': version,
            '@aws-solutions-konstruk/foo': mockVersion,
            'jsii-runtime': `node.js/${process.version}`,
        });
        test.done();
    },
    'version reporting finds no version with no associated package.json'(test) {
        const pkgdir = fs.mkdtempSync(path.join(os.tmpdir(), 'runtime-info-find-npm-package-fixture'));
        const mockVersion = '1.2.3';
        fs.writeFileSync(path.join(pkgdir, 'index.js'), 'module.exports = \'this is bar\';');
        fs.mkdirSync(path.join(pkgdir, 'bar'));
        fs.writeFileSync(path.join(pkgdir, 'bar', 'package.json'), JSON.stringify({
            name: '@aws-solutions-konstruk/bar',
            version: mockVersion,
        }));
        // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
        require(pkgdir);
        const cwd = process.cwd();
        // Switch to `bar` where the package.json is, then resolve version.  Fails when module.resolve
        // is passed an empty string in the paths array.
        process.chdir(path.join(pkgdir, 'bar'));
        const runtimeInfo = runtime_info_1.collectRuntimeInformation();
        process.chdir(cwd);
        test.equal(runtimeInfo.libraries['@aws-solutions-konstruk/bar'], undefined);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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