"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Kaniko = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const ec2 = require("@aws-cdk/aws-ec2");
const ecr = require("@aws-cdk/aws-ecr");
const ecs = require("@aws-cdk/aws-ecs");
const cdk = require("@aws-cdk/core");
const cdk_fargate_run_task_1 = require("cdk-fargate-run-task");
/**
 * @stability stable
 */
class Kaniko extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        const vpc = getOrCreateVpc(this);
        this.cluster = new ecs.Cluster(this, 'Cluster', { vpc });
        this.destinationRepository = (_b = props.destinationRepository) !== null && _b !== void 0 ? _b : this._createDestinationRepository();
        const executorImage = ecs.ContainerImage.fromAsset(path.join(__dirname, '../docker.d'));
        this.task = new ecs.FargateTaskDefinition(this, 'BuildImageTask', {
            cpu: 512,
            memoryLimitMiB: 1024,
        });
        this.task.addContainer('kaniko', {
            image: executorImage,
            command: [
                '--context', props.context,
                '--context-sub-path',
                (_c = props.contextSubPath) !== null && _c !== void 0 ? _c : './',
                '--dockerfile',
                (_d = props.dockerfile) !== null && _d !== void 0 ? _d : 'Dockerfile',
                '--destination', this.destinationRepository.repositoryUri,
                '--force',
            ],
            logging: new ecs.AwsLogDriver({ streamPrefix: 'kaniko' }),
        });
        this.destinationRepository.grantPullPush(this.task.taskRole);
        new cdk.CfnOutput(this, 'Repository', {
            value: this.destinationRepository.repositoryName,
        });
    }
    _createDestinationRepository() {
        return new ecr.Repository(this, 'Repo', {
            removalPolicy: cdk.RemovalPolicy.DESTROY,
        });
    }
    /**
     * Build the image with kaniko.
     *
     * @param schedule The schedule to repeatedly build the image.
     * @stability stable
     */
    buildImage(id, schedule) {
        // run it just once
        new cdk_fargate_run_task_1.RunTask(this, `BuildImage${id}`, {
            task: this.task,
            cluster: this.cluster,
            schedule,
        });
    }
}
exports.Kaniko = Kaniko;
_a = JSII_RTTI_SYMBOL_1;
Kaniko[_a] = { fqn: "cdk-kaniko.Kaniko", version: "0.1.3" };
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1'
        || process.env.CDK_USE_DEFAULT_VPC === '1' ? ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,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