## Introduction


This is the starting point of a RUINS data app.

### The RUINS Project

RUINS stands for "Risk, Uncertainty and Insurance under Climate Change. Coastal Land Management on the German North Sea" -- a BMBF/FONA funded research project on uncertainty of climate change adaptation at the German coast of the North Sea. 

We seek to investigate how different perceptions about uncertainty relate to data and projections about climate change. Furthermore, we extend the data analysis with model projections of exemplary management options in different sectors. These examples are intended to unveil different aspects of uncertainty, which are inherent to the topic of future projections and present decisions.

### From data and models to decisions under uncertainty

This online app consists of four main sections, which are arranged as chapters build on top of each other:

#### 1. Weather Data Explorer
In this chapter we provide visualisations to explore changes in observed weather data. As classic starting point, the local implication of global warming can be explored. We provide further topics like weather indices and drought indices to investigate how climate change manifests itself in different variables, at different stations and with different temporal aggregation.

As a brief outlook into future projections based on climate models (see next chapter), we also include an aggregated version for the respective weather variables and indices.



#### 2. Climate Projections Explorer
In this chapter we detail the view on climate model projections. If you are new to the topic, please see [CarbonBrief](https://www.carbonbrief.org/qa-how-do-climate-models-work) for an excellent introduction about climate models. 

In general, climate models project the state dynamics of the atmosphere under different development paths of the concentration of climate relevant gasses like CO<sub>2</sub>. These paths are called RCPs (Relative Concentration Pathways) termed as added warming potential. We provide the most commonly used RCPs 4.5 and 8.5. For more details about the meaning of the RCPs please see a [Nature Comment](https://www.nature.com/articles/d41586-020-00177-3).

A further important clarification has to be made about the scale the climate models operate on. GCMs (Global Climate Models) commonly operate at grids which cover approx. 120 km x 120 km in central Europe. Hence, the whole North Sea and the German coast fall in one single grid of such models. To provide more spatial details, RCMs (Regional Climate Models) are used to further process output from GCMs at a much finer grid of approx. 11 km x 11 km. The climate model data in this app has been calculated in a daily timestep.

We adhere the investigation to the same topics we introduced in chapter 1. Our focus here is to find out how different models and different RCPs lead to different projections.



#### 3. Uncertainty Explorer
This chapter introduces concepts and effects of uncertainty. As a first step, we give some general examples aiming at decision making under uncertainty. 

While the first chapters presented the data and model projections in an "as is" manner, this chapter provides more insight into different ways how an interpretation of uncertain predictions may depend on the setting of the decision taking. 

On the one hand, a decision can be founded on very different references. Supply related questions often refer to the mean of a set of possible outcomes. Issues related to extreme events likely orientate on the minimum or maximum. In some cases, there is a minimum (or maximum) threshold which defines problematic events. Hence, the decision reference has to be selected here.

On the other hand, there might be a different tolerance to uncertainty as a matter of the setting or as a more subjective perception. The subjective attitude towards uncertainty has an effect on the filtering restrictions within the set of possible outcomes, too. 



#### 4. Management Explorer
So far, we only explored the observed and projected data without studying possible impacts in more detail. This fourth chapter includes exemplary management models to project the provision of ecosystem services for the region under study. These projections are based on the data and uncertainty setting in sections 1, 2 and 3.


### Topical story lines

Since a plethora of topics related to changes in climate, weather and possible adaptation exists, we suggest several topics reoccurring in each chapter. These topics can be used as story lines guiding through the app.

---

The public data for this app originates from the German Weather Service (DWD) and the Earth System Grid Federation (ESGF). The funding by the German Ministry of Education and Research (BMBF) in the programme Research for Sustainable Development (FONA) is gratefully acknowledged.


