import { Duration, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IEventBus } from './event-bus';
import { EventPattern } from './event-pattern';
/**
 * The event archive base properties.
 *
 * @stability stable
 */
export interface BaseArchiveProps {
    /**
     * The name of the archive.
     *
     * @default - Automatically generated
     * @stability stable
     */
    readonly archiveName?: string;
    /**
     * A description for the archive.
     *
     * @default - none
     * @stability stable
     */
    readonly description?: string;
    /**
     * An event pattern to use to filter events sent to the archive.
     *
     * @stability stable
     */
    readonly eventPattern: EventPattern;
    /**
     * The number of days to retain events for.
     *
     * Default value is 0. If set to 0, events are retained indefinitely.
     *
     * @default - Infinite
     * @stability stable
     */
    readonly retention?: Duration;
}
/**
 * The event archive properties.
 *
 * @stability stable
 */
export interface ArchiveProps extends BaseArchiveProps {
    /**
     * The event source associated with the archive.
     *
     * @stability stable
     */
    readonly sourceEventBus: IEventBus;
}
/**
 * Define an EventBridge Archive.
 *
 * @stability stable
 * @resource AWS::Events::Archive
 */
export declare class Archive extends Resource {
    /**
     * The archive name.
     *
     * @stability stable
     * @attribute true
     */
    readonly archiveName: string;
    /**
     * The ARN of the archive created.
     *
     * @stability stable
     * @attribute true
     */
    readonly archiveArn: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ArchiveProps);
}
