# Kognic IO Client

Python 3 library providing access to Kognic IO

To install with pip run `pip install kognic-io`

# Documentation & Getting Started Guide

Documentation about how to use the library can be found [here](https://docs.kognic.com/)

# Changelog

All notable changes to this project will be documented in this file.

## [2.9.1] – 2025-08-29
- Add `created_at` field on `ReviewMember` model

## [2.9.0] - 2025-08-15

- `client_filename` now defaults to `None` in the Resource model.
- Improved support for scenes with multiple pre-annotations. 
    - When a pre-annotation is created we now return an object with a UUID, so multiple pre-annotations can be tracked.
    - Two new methods for creating request inputs from a scene are now supported
      - `client.input.create_from_scene` creates an input from a scene, optionally using one of its pre-annotations.
      - `client.input.create_from_pre_annotation` creates an input using a specific pre-annotation and its scene.
      - Both of these methods also support creating the request input in a specific request if its UUID is known.
    - N.b. the behavior of `client.<scene type>.create` remains unchanged: These always use the latest pre-annotation for the scene, if it has any.
- It is now possible to fetch pre-annotations with their OpenLabel content (so-called 'resolved' pre-annotations) via `client.pre_annotation.get_with_content`. 

In conjunction with this release, the backend behavior has changed to allow Inputs to be created from Lidar and Camera
Sequence scenes in requests that are configured for Aggregated Lidar and Camera Sequences. This allows a single Lidar 
and Camera Sequence scene to be annotated in two+ requests, both with and without aggregation. Contact Kognic support to
use this feature as it requires additional configuration at the request level. No code changes are required.

## [2.8.0] - 2025-05-28

- Adds wait_for_scene_job_status that allows you to choose which status you are waiting for.
- Adds corrected and resolved to review model.

## [2.7.0] - 2025-05-05

- Adds methods for making an indexed scene available and making an available scene indexed
- Adds methods for working with pre-annotations

## [2.6.0] - 2025-04-22

- Dropped support for end-of-life Python 3.7 and 3.8
- Improve handling & memory requirements for local image/pointcloud files larger than 2 GiB
- The `UploadableData` type was expanded to include `Generator[bytes, Any, None]` and `AsyncGenerator[bytes, Any]`
    - This is the return the type for `FileData` callbacks, and the type of data provided directly via `FileData.data`.
    - This allows image and pointcloud file bytes to be streamed from their source.
- Adds indexed as a scene status
- Adds alias for rotationQuaternion


## [2.5.1] - 2025-03-19

- Bug fixes in new scene model

## [2.5.0] - 2025-03-19

- New scene model without input types. You specify the data that you have and it will handle the rest.
- Workspace is returned in the scene query response.

## [2.4.0] - 2024-11-06

- Enable specifying workspaces
  - Added field for workspace ID for write operations to `KognicIOClient` constructor. A value is inferred if it's left blank.
  - Added a `workspace` resource to the client
  - Added ability to list workspaces with `client.workspace.get_workspaces`

## [2.3.1] - 2024-10-24

- Add optional default values to optional parameters in:
  - `AddFeedbackItem`
  - `ReviewMember`
  - `Review`

## [2.3.0] - 2024-06-19

- Added new resource for reviews with the following methods
  - `get_review`: Get a review by its uuid
  - `create_review`: Create a review
  - `get_error_types`: Get all error types

## [2.2.0] - 2024-06-17

- Add support for AVIF images
- Add scenes to `kognicutil`. Can be used to list scenes with `kognicutil scenes uuid1 uuid2`

## [2.1.2] - 2024-02-27

- Bump dependency on `kognic-base-clients` to `2.3.4`

## [2.1.1] - 2024-02-21

- add `max_connection` parameter in resource clients to allow for more control over the number of network connections

## [2.1.0] - 2024-01-30

- add API client to order-execution-api, including kognic-io client parameter to override order_execution_api_host

## [2.0.1] - 2023-11-22

- Default values on `Optional` fields to handle pydantic v2.0.0
- Adds scene_external_id to the pydantic input model

## [2.0.0] - 2023-11-17

- Bumped pydantic to v2. No breaking changes in the kognic-io interface, but if you are using pydantic directly you may need to update your code.

## [1.8.0] - 2023-10-31

### Added

- Utilities for custom camera calibrations
  - `kognic.io.tools.calibration.validation` for validating custom camera calibrations
  - `kognic.io.tools.calibration.compilation` for compiling custom camera calibrations to WebAssembly

## [1.7.0] - 2023-10-18

### Added

- Method to query request inputs, use it with `client.input.query_inputs(...)`
- `create_from_scene(...)` now returns created inputs
- New `Input` model representing a scene in a request
- Modelling for `CustomCameraCalibration` using WebAssembly

### Deprecated

- The method `get_inputs_with_uuids` (use `get_scenes_by_uuids` instead)
- The method `get_inputs` (use `query_inputs` instead)
- The old `kognic.io.model.input.input_entry.Input` model along with `kognic.io.model.input.input_entry.InputStatus`

## [1.6.0] - 2023-10-06

### Added

- Method to get scenes by uuids, use it with `client.scene.get_scenes_by_uuids([...])`
- Method to get an annotation by input uuid `client.annotation.get_annotation_for_input(input_uuid)`
- Method to get all annotations for a scene `client.annotation.get_annotations_for_scene(scene_uuid)`
- Method to invalidate scenes `client.scene.invalidate_scenes([scene_uuid, ...], reason)`
- Method to delete an input `client.input.delete_input(input_uuid)`

### Changed

- Renamed `input_type` field on `Input` to `scene_type`
- Renamed `input_uuid` to `scene_uuid` on the following methods
  - `client.annotation.get_annotation`
  - `client.input.invalidate_inputs`
  - `client.input.add_annotation_type`
  - `client.input.remove_annotation_types`
  - `client.input.get_inputs_by_uuids`
- Renamed `input_uuid` parameter in `get_annotation` to `scene_uuid`

### Deprecated

- The method `invalidate_inputs` (use `invalidate_scenes` instead)
- The method `remove_annotation_types` (use `delete_input` instead)
- `input_type` on the `Input` model (use `scene_type` instead)
- `input_uuid` parameter in favour of `scene_uuid` on the following methods
  - `client.annotation.get_annotation`
  - `client.input.invalidate_inputs`
  - `client.input.add_annotation_type`
  - `client.input.remove_annotation_types`
  - `client.input.get_inputs_by_uuids`

## [1.5.0] - 2023-09-29

### Added

- Support for asynchronous callbacks in `FileData`

## [1.4.0] - 2023-09-22

### Added

- Added missing `FileData.Format.WEBP` to enable use of WebP for `FileData` images (which were already supported for `InputModel.Image`)
- Support for new camera model named custom.

### Changed

- Renamed `lidar_and_cameras` attribute to `lidars_and_cameras` on `KognicIOClient`
- Renamed `uuid` field on `Input` to `scene_uuid`
- Renamed `input_uuid` field on `Annotation` to `scene_uuid`
- Renamed response from `create` method from `CreateInputResponse` to `CreateSceneResponse`. Also renamed `input_uuid` field to `scene_uuid` in the response.
- Renamed `InvalidatedReasonInput` to `InvalidatedReasonScene`
- Moved all scene models (for example `LidarsAndCameras`) from `kognic.io.model.input` to `kognic.io.model.scene`

### Deprecated (will be removed in a future release)

- `lidar_and_cameras` attribute on `KognicIOClient`
- `uuid` field on `Input`
- `input_uuid` field on `Annotation`
- `CreateInputResponse` response from `create` method along with its `input_uuid` field
- `InvalidatedReasonInput`
- Scene models in `kognic.io.model.input`

## [1.3.0] - 2023-08-08

### Changed

- Validate that all required local image and pointcloud files exist before beginning to create scenes.
  - Validation errors will be raised for missing or empty files.
  - `Image` and `PointCloud` `filename` must refer to a file that exists & contain data unless a callback or raw bytes are provided.
    (i.e. there is no validation any time `FileData` are used)
- Support for new camera model named Principal Point Fisheye model.

## [1.2.2] - 2023-07-05

### Changed

- Pin pydantic version to <2
- Remove dependency on `Pillow`

## [1.2.1] - 2023-05-19

### Added

- Add optional attribute max_altitude_angle to fused cylindrical camera model

## [1.2.0] - 2023-05-09

### Added

- Support for new camera model named Cylindrical model.

### Bugfix

- Fixed bug where the calibration types were not used coherently across different calibration models. This resulted in check such as `if calibration.calibration_type == CalibrationType.PINHOLE` to fail in some cases.

## [1.1.9] - 2023-04-12

### Added

- Wrapper function `create_inputs` that allows creation of multiple inputs (with or without a pre-annotation) with a single call. This is useful since it contains wait-logic for the scene to be ready before creating inputs.

## [1.1.8] - 2023-03-17

### Added

- Support for custom lens projection coefficients for Principal Point Distortion model.

## [1.1.6] - 2023-03-14

### Added

- Support for new camera model named Fused Cylindrical model.

### Changed

- Fixed bug where files intended to be uploaded using data from a callback or in-memory blob would sometimes be incorrectly handled if their callback or blob could be coerced to `False`.

## [1.1.5] - 2023-01-20

### Added

- Support for the new input type `aggregated_lidars_and_cameras_sequence`. This new input type is a sequence of cameras
  and point clouds, but the point clouds are aggregated over time. More information can be found [here](https://docs.kognic.com/api-guide/aggregated-lidars-and-cameras-sequence).
- New parameter `include_content` in `get_project_annotations` that lets you choose whether to fetch the annotation content
  or not

## [1.1.4] - 2022-12-02

### Changed

- Bumped dependency on `kognic-base-clients` to `1.0.3` which introduces retry when uploads fail for TCP or SSL timeout reasons.

## [1.1.2] - 2022-11-25

### Changed

- Fixed issue with parsing of custom metadata fields

## [1.1.1] - 2022-11-11

### Added

- The raw bytes for each scene resource (`Image`, `PointCloud`) may now be provided in different ways:
  - read from a local file, as before (no changes are needed to continue using this behaviour)
  - passed directly when creating the resource
  - loaded progressively during the upload via a callback

Refer to [the updated documentation](https://docs.kognic.com/api-guide/overview#Z4lH6)
for details about how to use the new API features.

### Changed

- `metadata` is once again an optional attribute on model classes that use it (`CamerasSequence` among others)

## [1.0.2] - 2022-11-01

### Changed

- Bumped dependency on `kognic-base-clients` to `1.0.1`
- Added pagination to the `get_inputs` method to prevent timeouts

### Bugfix

- Metadata should default to an empty dict

## [1.0.1] - 2022-10-18

- Updated readme

## [1.0.0] - 2022-10-18

This is a major release with breaking changes and refactorings.
Please refer to our Annotell-2-Kognic migration guide for details.

### Changed

- Annotell becomes Kognic
- Bumped minimum python version from 3.6 to 3.7
- Packaging changes
- Remaining `@dataclass`es in our model packages are now pydantic models with better validation

### Removed

- Deprecated calibration models
- Deprecated `get_annotations` method

---

# Changelog (before rebranding)

## [1.3.1] - 2022-09-13

### Bugfix

- Changed naming in PrincipalPointDistortionCalibration

## [1.3.0] - 2022-09-09

### Changed

- Added PrincipalPointDistortionCalibration

## [1.2.6] - 2022-08-19

### Bugfix

- Fixed error when using deprecated calibration model `annotell.input_api.model.calibration.sensors.LidarCalibration`
  - We encourage updating to use the newer, typed calibration models in `annotell.input_api.model.calibration.{camera, lidar}.*`,
    [refer to the calibration documentation for details](https://docs.kognic.com/api-guide/data-requirements#hH913).

## [1.2.5] - 2022-08-18

### Changed

- Changed from `internalId` to `sceneUuid` on initialize input

### Bugfix

- Fixed error when using deprecated calibration model `annotell.input_api.model.calibration.sensors.CameraCalibration`
  - We encourage updating to use the newer, typed calibration models in `annotell.input_api.model.calibration.{camera, lidar}.*`,
    [refer to the calibration documentation for details](https://docs.kognic.com/api-guide/data-requirements#hH913).

## [1.2.4] - 2022-07-06

### Bugfix

- Fix bug where not specifying feature flags led to a runtime error.

## [1.2.3] - 2022-06-23

### Added

- Feature flags can be specified when creating inputs. This can be used to disable motion compensation.

## [1.2.2] - 2022-06-20

### Added

- Ability to specify field of view on LIDAR sensor calibrations.

## [1.2.1] - 2022-06-08

### Added

- Ability to create inputs from a scene
- Ability to create pre-annotations (limited support)

## [1.2.0] - 2022-05-05

### Changed

- `annotell-base-clients` is now a dependency for `annotell-input-api`, used for http requests and file uploads
- The generator produced by `client.annotation.get_project_annotations` will now reliably iterate projects with thousands of annotations

### Added

- Include `annotation_types` in `Input`
- Method to remove annotation types from an input: `remove_annotation_types`

## [1.1.5] - 2022-03-29

### Bugfix

- Added 'archived' as ProjectBatchStatus

## [1.1.4] - 2022-02-17

### Added

- MetaDataContainer added with reserved keyword `region`.
- Added ImageMetaData for shutter start and end times, used for high accuracy multi-sensor projections

## [1.1.3] - 2022-01-05

### Bugfix

- Fixed download of annotations

## [1.1.2] - 2021-12-03

### Changed

- Refactor of `file_resource_client.py`, split upload and download into separate classes.

### Added

- New parameter `timeout` to `InputApiClient`, which decides what the timeout in seconds is for calls to Annotell API:s and Google Cloud Storage.
- Retries when a `ConnectionError` is raised during uploading/downloading of resources to/from Google Cloud Storage.
- New input status `Pending`. An input will have this status if the input has been validated, but the server is waiting for the associated data to
  be uploaded. When all data is uploaded the status of the input will change to `Processing`.

## [1.1.1] - 2021-11-11

### Changed

- Fixed import statement to work with python < 3.9

## [1.1.0] - 2021-11-03

### Added

- Two new methods has been added for downloading annotations: `client.annotation.get_annotation` and `client.annotation.get_project_annotations`. These two methods will serve annotations
  in the OpenLABEL format. With this change the previous method for fetching annotations,
  `client.annotation.get_annotations` has become deprecated.

- Stricter typing for the calibrations, specifically the camera calibrations. Each of the supported camera calibration models now have their own class in `annotell.input_api.model.calibration.camera`. Documentation regarding use can be found here: [Documentation](https://annotell.github.io/annotell-python/docs/input-api/calibration)
- Field of View support for camera calibrations
- New Parameter Xi for Fisheye camera calibration model

### Changed

- Two constructor arguments in `InputApiClient` and `FileResourceClient` have been renamed from `max_upload_retry_attemps`, `max_upload_retry_wait_time`
  to `max_retry_attempts`, `max_retry_wait_time` respectively.

- The old camera calibration class will be deprecated in favour of the new classes

## [1.0.8] - 2021-09-07

### Added

- A new method has been added, `get_inputs_with_uuids`, which can fetch inputs using only the `input_uuid`.
- `annoutil` has a new flag when fetching inputs, `annoutil inputs --uuids <comma_separated_uuids>`.
- `lidars` and `lidars_sequence` inputs now available through the client.
- A new method has been added, `add_annotation_type`, which adds additional annotation types to be performed for an input.

### Changed

- `client.calibration.get_calibration()` now properly deserializes calibration into `SensorCalibrationEntry` instead of keeping it as a dict.

## [1.0.7] - 2021-06-11

### Added

- `created` timestamp when querying `get_inputs`
- Method `get_annotation_types`

### Changed

- `input_list_id` replaced with `annotation_types` for all createable resources (`Cameras`, `CamerasSeq`, `LidarsAndCameras`, `LidarsAndCamerasSeq`).

## [1.0.6] - 2021-05-28

### Added

- `calibration_id` now available for created inputs via the `client.input.get_inputs` method.
- It is now possible to create your project batches on your own using the
  `client.project.create_batch` method. Please contact Annotell's Professional Services
  before using. More information available in the [documentation](https://annotell.github.io/annotell-python/).

## [1.0.5] - 2021-05-06

### Changed

- Changed the height/width in the unity calibration created in the examples to match the image/videos.
- Added new field in the Input class, view_link. If the Input was successfully created it will contain an URL to view the input in the Annotell app.

### Bugfixes

- Fixed issue where `invalidate_inputs` did not properly discard response content.

## [1.0.4] - 2021-04-26

### Added

- Added support for providing metadata in the form of a flat KV-pair both on an input-level for all input types, as well as on a frame-level for all sequential input types.

### Changed

- Made SensorSpecification Optional for all input types

### Removed

- Removed sensor_settings from SensorSpecification. The pixel dimensions are now
  automatically inferred from videos and images.

## [1.0.3] - 2021-04-14

### Added

- Added an example for download_annotations
- Added check so that `input_list_id` and `project` is not used simultaneously when creating inputs

### Changed

- Made client and file_client internal
- Fixed bug where client sometimes didn't raise exception when http calls return error codes
- Bugfix where annoutil didn't work due to missing import
- Clarified examples with different images/videos for different sensors and frames.

### Removed

- Removed unnecessary parameters `frame_id` and `relative_timestamp` from `lidars_and_cameras`

## [1.0.1] - 2021-04-06

- Use backport of `dataclasses` to support python 3.6.

## [1.0.0] - 2021-03-23

- New major release of client. Reworked to be more internally consistent between input types, and use of project and batch identifiers across methods. See [docs](https://annotell.github.io/annotell-python/) for more info.
- `client.lidar_and_cameras.create` replaces `client.create_inputs_point_cloud_with_images`
- `client.cameras.create` replaces `client.upload_and_create_images_input_job`
- `client.annotations.get_annotations` replaces `client.download_annotations`

## [0.4.4] - 2021-03-02

- Remove unused dependency on annotell-cloud-storage

## [0.4.3] - 2021-02-16

- Fixed import bug in annoutil CLI tool.

## [0.4.2] - 2021-02-02

### Changed

- Changed url for the `get_calibration_data` method. Does not affect
  usage of the method in any way.

## [0.4.1] - 2021-01-29

### Changed

- Removed unused property `deadline` from project

## [0.4.0] - 2021-01-28

### Changed

- Renamed method `upload_and_create_images_input_job` to `create_inputs_images`.
- Renamed method `list_projects` to `get_projects`.
- Renamed method `list_project_batches` to `get_project_batches`.
- Changed behaviour of method `download_annotations`. The previously optional argumnet `request_id` has been removed. Additionally, the return
  signature is changed to return a list of annotations for each input, instead of a dict as before.
- Behaviour of `get_inputs` has changed. It now receives `project` (identifier, not numerical id anymore), as well as three optional parameters `batch`, `external_ids` and `include_invalidated`. Returns all inputs belonging to the project, with the option of filtering on batch, external ID and whether or not including invalidated inputs. The returned list of classes had additional fields describing which batch each input belongs to, as well as their status (`created`, `processing`, `failed`, `invalidated`).
- Changed name of argument `input_ids` to `input_internal_ids` for method `invalidate_inputs`.
- Use backport of `dataclasses` to support python 3.6.
- Add missing dependency on `python-dateutil`.

### Removed

- Methods `count_inputs_for_external_ids`, `get_internal_ids_for_external_ids`, `mend_input_data`, `remove_inputs_from_input_list`, `list_input_lists`, `publish_batch`, `get_requests_for_request_ids`, `get_requests_for_input_lists`, `get_input_status`, `get_input_jobs_status`, `get_requests_for_project_id`, `get_datas_for_inputs_by_internal_ids` and `get_datas_for_inputs_by_external_ids` have all been removed.

## [0.3.12] - 2021-01-13

### Changed

- Removed getting started documentation from `README.md` and instead link to new docs.

## [0.3.11] - 2020-12-14

### Changed

- Deserialization bugfix in models for `InputBatch` and `InputBatch`.

## [0.3.10] - 2020-12-01

### Added

- Minor fix in annoutil

## [0.3.9] - 2020-11-26

### Added

- Bump of required python version to >=3.7
- New explicit models for `lidar` and `camera calibration` added.
- `publish_batch` which accepts project identifier and batch identifier and marks the batch as ready for annotation.

### Changed

- Deprecation warning for the old `lidar` and `camera calibration` models. No other change in functionality.

## [0.3.8] - 2020-11-13

### Added

- `get_inputs` which accepts a project ID or project identifier (external ID) and returns inputs connected to the project. `invalidated` filter parameter to optionally filter only invalidated inputs. Also exposed in annoutil as `annoutil projects 1 --invalidated`.

### Changed

- `invalidate_inputs` now accepts annotell `internal_ids (UUID)` instead of Annotell specific input ids.

## [0.3.7] - 2020-11-06

### Changed

- bug fix related to oauth session

## [0.3.6] - 2020-11-02

### Changed

- SLAM - add cuboid timespans, `dynamic_objects` not includes both `cuboids` and `cuboid_timespans`

## [0.3.5] - 2020-10-19

### Added

- Add support for `project` and `batch` identifiers for input request.
  Specifying project and batch adds input to specified batch.
  When only sending project, inputs are added to the latest open batch for the project.

### Deprecated

- `input_list_id` will be removed in the 0.4.x version

## [0.3.4] - 2020-09-10

### Changed

- SLAM - add required `sub_sequence_id` and optional `settings`

## [0.3.3] - 2020-09-10

### Changed

- SLAM - add required `sequence_id`

## [0.3.2] - 2020-09-01

### Changed

- SLAM - startTs and endTs not optional in Slam request

## [0.3.1] - 2020-07-16

### Changed

- If the upload of point clouds or images crashes and returns status code 429, 408 or 5xx the script will
  retry the upload before crashing. The default settings may be changed when initializing the `InputApiClient`
  by specifying values to the `max_upload_retry_attempts` and `max_upload_retry_wait_time` parameters.

## [0.3.0] - 2020-07-03

### Changed

- The method `create_inputs_point_cloud_with_images` in `InputApiClient` now takes an extra parameter: `dryrun: bool`.
  If set to `True` all the validation checks will be run but no inputJob will be created, and
  if it is set to `False` an inputJob will be created if the validation checks all pass.

### Bugfixes

- Fixed bug where the uploading of .csv files to GCS crashed if run on some windows machines.

## [0.2.9] - 2020-07-02

### Added

- New public method in `InputApiClient`: `count_inputs_for_external_ids`.

## [0.2.8] - 2020-06-30

### Added

- Docstrings for all public methods in the `InputApiClient` class

## [0.2.7] - 2020-06-29

### Added

- Require time specification to be send when posting slam requests

## [0.2.6] - 2020-06-26

### Changed

- Removed `CalibrationSpec` from `CalibratedSceneMetaData` and `SlamMetaData`. Updated
  so that `create_calibration_data` in `InputApiClient` only takes a `CalibrationSpec`
  as parameter.

## [0.2.5] - 2020-06-22

### Bugfixes

- Fixed issue where a path including a "~" would not expand correctly.

## [0.2.4] - 2020-06-17

### Changed

- Changed pointcloud_with_images model. Images and point clouds are now represented as `Image` and `PointCloud` containing filename and source. Consequently, `images_to_source` is removed from `SourceSpecification`.

### Added

- create Image inputs via `create_images_input_job`
- It's now possible to invalidate erroneous inputs via `invalidate_inputs`
- Support for removing specific inputs via `remove_inputs_from_input_list`
- SLAM support (not generally available)

### Bugfixes

- Fixed issue where annoutils would not deserialize datas correctly when querying datas by internalId

## [0.2.3] - 2020-04-21

### Changed

- Changed how timestamps are represented when receiving responses.

## [0.2.2] - 2020-04-17

### Added

- Methods `get_datas_for_inputs_by_internal_ids` and `get_datas_for_inputs_by_external_ids` can be used to get which `Data` are part of an `Input`, useful in order to check which images, lidar-files have been uploaded. Both are also available in the CLI via :

```console
$ annoutil inputs --get-datas <internal_ids>
$ annoutil inputs-externalid --get-datas <external_ids>
```

- Support has been added for `Kannala` camera types. Whenever adding calibration for `Kannala` undistortion coefficients must also be added.
- Calibration is now represented as a class and is no longer just a dictionary, making it easier to understand how the Annotell format is structured and used.

## [0.2.0] - 2020-04-16

### Changed

- Change constructor to disable legacy api token support and only accept an `auth` parameter

## [0.1.5] - 2020-04-07

### Added

- Method `get_input_jobs_status` now accepts lists of internal_ids and external_ids as arguments.
