# Generated by Django 3.1.4 on 2020-12-15 16:13

import ckeditor.fields
import django.contrib.sites.managers
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='Item',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('short_name', models.CharField(max_length=255, unique=True, verbose_name='Kurzname')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('notice', ckeditor.fields.RichTextField(blank=True, help_text='Shown below the item', verbose_name='Notice')),
                ('price', models.FloatField(validators=[django.core.validators.MinValueValidator(0.0)])),
                ('max_count', models.IntegerField(default=0, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Maximum count of items')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Item',
                'verbose_name_plural': 'Items',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('full_name', models.CharField(max_length=255, verbose_name='First and last name')),
                ('email', models.EmailField(max_length=254, verbose_name='E-Mail-Adresse')),
                ('in_progress', models.BooleanField(default=True, verbose_name='In progress')),
                ('confirmed', models.BooleanField(default=False, verbose_name='Confirmed')),
                ('confirm_key', models.TextField(blank=True, verbose_name='Confirm key')),
                ('paid', models.BooleanField(default=False, verbose_name='Paid')),
                ('sent', models.BooleanField(default=False, verbose_name='Versandt')),
                ('shipping_full_name', models.CharField(blank=True, max_length=255, verbose_name='First and last name')),
                ('second_address_row', models.CharField(blank=True, max_length=255, verbose_name='Second address row')),
                ('street', models.CharField(blank=True, max_length=255, verbose_name='Street and housenumber')),
                ('plz', models.CharField(blank=True, max_length=255, verbose_name='PLZ')),
                ('place', models.CharField(blank=True, max_length=255, verbose_name='Ort')),
            ],
            options={
                'verbose_name': 'Reihenfolge',
                'verbose_name_plural': 'Orders',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='ProcessingOption',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('short_name', models.CharField(max_length=255, unique=True, verbose_name='Kurzname')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('notice', ckeditor.fields.RichTextField(blank=True, help_text='Shown below the option', verbose_name='Notice')),
                ('email_notice', ckeditor.fields.RichTextField(blank=True, help_text='Shown in the confirmation email', verbose_name='Email notice')),
                ('address_necessary', models.BooleanField(default=False, verbose_name='Adress necessary')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='ProcessingOptionPrice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('min_count', models.IntegerField(validators=[django.core.validators.MinValueValidator(0)], verbose_name='Min count of items')),
                ('max_count', models.IntegerField(validators=[django.core.validators.MinValueValidator(0)], verbose_name='Max count of items')),
                ('price', models.FloatField(validators=[django.core.validators.MinValueValidator(0.0)])),
                ('option', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='prices', to='order.processingoption', verbose_name='Processing option')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='OrderItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('count', models.IntegerField(verbose_name='Anzahl')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='order.item', verbose_name='Item')),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='order.order', verbose_name='Reihenfolge')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='OrderForm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('title', models.CharField(max_length=255, verbose_name='Form title')),
                ('help_text', ckeditor.fields.RichTextField(blank=True, help_text="Shown in the form's footer", verbose_name='Help text')),
                ('from_email', models.EmailField(max_length=254, verbose_name='From email address')),
                ('from_name', models.CharField(max_length=255, verbose_name='From name')),
                ('available_items', models.ManyToManyField(related_name='forms', to='order.Item', verbose_name='Available items')),
                ('available_processing_options', models.ManyToManyField(related_name='forms', to='order.ProcessingOption', verbose_name='Available processing options')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Order form',
                'verbose_name_plural': 'Order forms',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AddField(
            model_name='order',
            name='form',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='orders', to='order.orderform', verbose_name='Order form'),
        ),
        migrations.AddField(
            model_name='order',
            name='processing_option',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='order.processingoption', verbose_name='Selected processing option'),
        ),
        migrations.AddField(
            model_name='order',
            name='site',
            field=models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site'),
        ),
    ]
