~Version
#MNEM .UNIT                VALUE  : DESCRIPTION                    
 VERS .                      3.0  : CWLS LOG ASCII STANDARD - VERSION 3.0 
 WRAP .                       NO  : ONE LINE PER DEPTH STEP        
 DLM  .                    COMMA  : DELIMITING CHARACTER (SPACE TAB OR COMMA) 

~Well
#MNEM .UNIT                                    VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 STRT  .F                                       580.0  : START DEPTH                    {F}
 STOP  .F                                      5252.0  : END DEPTH                      {F}
 STEP  .F                                         0.5  : STEP LENGTH                    {F}
 NULL  .                                      -999.25  : NULL VALUE                     {F}
 COMP  .                                  BEREXCO LLC  : Company                        {S}
 WELL  .                          Wellington KGS 1-32  : Well Name                      {S}
 FLD   .                                   WELLINGTON  : Field                          {S}
 SEC   .                                           32  : Section                        {I}
 TOWN  .                                          31S  : Township (e.g. 42S)            {S}
 RANG  .                                           1W  : Range  (e.g. 25E)              {S}
 LOC   .                            T31S R1W, Sec. 32  : Location (Sec Town Range)      {S}
 LOC1  .                                  NE SW NE NE  : Location 1 (quarter calls)     {S}
 LOC2  .          955 South, 877 West, from NE corner  : Location 2 (footages)          {S}
 COUN  .                                       SUMNER  : County                         {S}
 STAT  .                                       Kansas  : State                          {S}
 CTRY  .                                           US  : Country                        {S}
 PROV  .                                               : Province                       {S}
 SRVC  .                                  Halliburton  : Service Company                {S}
 LIC   .                                               : License Number                 {S}
 DATE  .                                   02/21/2011  : Completion Date                {DD/MM/YYYY}
 API   .                                 15-191-22591  : API-Number                     {S}
 UWI   .                                               : Unique Well ID Number          {S}
 LATI  .DEG                                   37.3153  : Latitude                       {F}
 LONG  .DEG                                  -97.4424  : Longitude                      {F}
 GDAT  .                                        NAD27  : Geodetic Datum                 {S}
 X     .                                    638021.23  : X or East-West coordinate      {F}
 Y     .                                   4130799.98  : Y or North South coordinate    {F}
 HZCS  .                                          UTM  : Horizontal Co-ordinate System  {S}
 UTM   .                                         14.0  : UTM Location                   {F}
 STUS  .                                               : Well Status                    {S}

~Parameter
#MNEM .UNIT                               VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 PDAT  .                                      GL  : Permanent Data                 {S}
 APD   .F                                   13.0  : Above Permanent Data           {F}
 DREF  .                                      KB  : Depth Reference (KB,DF,CB)     {S}
 EREF  .F                                 1272.0  : Elevation of Depth Reference   {F}
 RUN   .                                       1  : Run Number                     {F}
 TDL   .F                                 5240.0  : Total Depth Logger             {F}
 TDD   .F                                 5240.0  : Total Depth Driller            {F}
 CSGL  .F                                  607.0  : Casing Bottom Logger           {F}
 CSGD  .F                                  607.0  : Casing Bottom Driller          {F}
 CSGS  .IN                                 9.625  : Casing Size                    {F}
 CSGW  .LB                                        : Casing Weight                  {F}
 BS    .in                                 7.875  : Bit Size                       {F}
 MUD   .                         Water Based Mud  : Mud type                       {S}
 MUDS  .                               Flow Line  : Mud Source                     {S}
 MUDD  .ppg                             9.000001  : Mud Density                    {F}
 MUDV  .s/qt                                48.0  : Mud Viscosity (Funnel)         {F}
 FL    .cptm                                 9.2  : Fluid Loss                     {F}
 PH    .                                    10.0  : PH                             {F}
 RM    .OHM-M                               0.65  : Resistivity of Mud             {F}
 RMT   .degF                                58.0  : Temperature of Mud             {F}
 RMF   .OHM-M                               0.55  : Resistivity. of Mud Filtrate   {F}
 RMFT  .degF                                58.0  : Temperature of Mud Filtrate    {F}
 RMC   .OHM-M                               0.75  : Resistivity of Mud Cake        {F}
 RMCT  .DEG-F                               58.0  : Temperature of Mud Cake        {F}
 TMAX  .DEG-F                              125.0  : Maximum Recorded Temp.         {F}
 TIMC  .DATE                                      : Date/Time Circulation Stopped  {D/M/YYY}
 TIML  .DATE                          02/09/2011  : Date/Time Logger Tagged Bottom {DD/MM/YYYY}
 UNIT  .                                10546696  : Logging Unit Number            {F}
 BASE  .                             Liberal, KS  : Home Base of Logging Unit      {S}
 ENG   .                                 J. Bosh  : Recording Engineer             {S}
 WIT   .          L. Watney, KCrisler, G.Koralegedara  : Witnessed By                   {S}

~Curve
#MNEM .UNIT               VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 DEPT  .F         00 000 000 000  : Depth                          
 TENS  .lbs       00 000 000 000  : Tension                        
 RXRT  .NONE      00 000 000 000  : RXRT                           
 RXO   .ohmm      00 000 000 000  : RXO                            
 RT90  .ohmm      00 000 000 000  : 90in Resistivity 2ft Res       
 RT60  .ohmm      00 000 000 000  : 60in Resistivity 2ft Res       
 RT30  .ohmm      00 000 000 000  : 30in Resistivity 2ft Res       
 RT20  .ohmm      00 000 000 000  : 20in Resistivity 2ft Res       
 RT10  .ohmm      00 000 000 000  : 10in Resistivity 2ft Res       
 RT    .ohmm      00 000 000 000  : RT                             
 RMUD  .ohmm      00 000 000 000  : RMUD                           
 RHOB  .g/cc      00 000 000 000  : Density                        
 QN    .NONE      00 000 000 000  : NearQuality                    
 QF    .NONE      00 000 000 000  : FarQuality                     
 PE    .          00 000 000 000  : Pe                             
 NPHS  .%         00 000 000 000  : Neutron Porosity Sand          
 NPHL  .%         00 000 000 000  : Neu Por Lime                   
 NPHI  .%         00 000 000 000  : Neutron Porosity               
 NPHD  .%         00 000 000 000  : Neutron Porosity Dolo          
 DRHO  .g/cc      00 000 000 000  : DensityCorr                    
 DPHS  .%         00 000 000 000  : DenPhiSand                     
 DPHI  .%         00 000 000 000  : DensityPorosity                
 DPHD  .%         00 000 000 000  : DenPhiDolo                     
 DLIM  .%         00 000 000 000  : DenPhiLime                     
 CT90  .mmo/m     00 000 000 000  : 90in Conductivity 2ft Res      
 CALI  .in        00 000 000 000  : Caliper                        
 MINV  .ohmm      00 000 000 000  : MicrologLateral                
 MNOR  .ohmm      00 000 000 000  : MicrologNormal                 
 GR    .api       00 000 000 000  : Gamma API                      
 GRTO  .api       00 000 000 000  : GammaTotal                     
 GRTC  .api       00 000 000 000  : GammaKT                        
 POTA  .%         00 000 000 000  : Potassium                      
 URAN  .ppm       00 000 000 000  : Uranium                        
 THOR  .ppm       00 000 000 000  : Thorium                        
 TURT  .NONE      00 000 000 000  : RatioThorUran                  
 UKRT  .NONE      00 000 000 000  : RatioUranPota                  
 TKRT  .NONE      00 000 000 000  : RatioThorPota                  
 NOIS  .cps       00 000 000 000  : SpectralNoise                  

~IQ_Brine_Parameter
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS .                 YES  : Profile Web App Saved Data Indicator {S}
 B_SRS .                      : Source                         {S}
 B_DT  .                      : Recovery Date                  {D/M/YYY}
 B_TP  .F             3664.0  : Top Depth                      {F}
 B_BS  .F             4575.0  : Base Depth                     {F}
 B_FM  .                      : Primary Formation              {S}
 B_AC  .                      : Analyzing Company              {S}
 B_AD  .                      : Analysis Date                  {D/M/YYY}

~IQ_Brine_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 TOP   .ft                    : Depth Top                      {F}
 BASE  .ft                    : Depth Base                     {F}
 Li    .mg/l                  : Lithium                        {F}
 Na    .mg/l                  : Sodium                         {F}
 K     .mg/l                  : Potassium                      {F}
 Be    .mg/l                  : Beryllium                      {F}
 Mg    .mg/l                  : Magnesium                      {F}
 Ca    .mg/l                  : Calcium                        {F}
 Sr    .mg/l                  : Strontium                      {F}
 Ba    .mg/l                  : Barium                         {F}
 Cr    .mg/l                  : Chromium (III)                 {F}
 Mn    .mg/l                  : Manganese (IV)                 {F}
 Fe    .mg/l                  : Iron (III) ferric              {F}
 Co    .mg/l                  : Cobalt (III) cobaltic          {F}
 Ni    .mg/l                  : Nickel (III)                   {F}
 Cu    .mg/l                  : Copper (II) cupric             {F}
 Ag    .mg/l                  : Silver                         {F}
 Zn    .mg/l                  : Zinc                           {F}
 Al    .mg/l                  : Aluminum                       {F}
 Pb    .mg/l                  : Lead (IV)                      {F}
 F     .mg/l                  : Floride                        {F}
 Cl    .mg/l                  : Chloride                       {F}
 Br    .mg/l                  : Bromide                        {F}
 CO3   .mg/l                  : Carbonate                      {F}
 P     .mg/l                  : Phosphide                      {F}
 Se    .mg/l                  : Selenide                       {F}
 SO4   .mg/l                  : Sulfate                        {F}

~IQ_Brine_Data | IQ_Brine_Definition 
# TOP BASE Li Na K Be Mg Ca Sr Ba Cr Mn Fe Co Ni Cu Ag Zn Al Pb F Cl Br CO3 P Se SO4
 3664.0,3690.0,3.9,58000.0,702.0,0.0020,1890.0,11300.0,417.0,0.73,0.02,0.89,0.29,0.0060,0.014,0.092,0.04,1.78,0.1,0.18,10.0,119000.0,464.0,42.0,0.02,0.02,703.0
 4175.0,4190.0,13.9,31500.0,834.0,0.0020,880.0,5030.0,158.0,0.43,0.02,1.1,0.05,0.0040,0.0050,0.0060,0.022,0.032,0.1,0.01,10.0,65800.0,120.0,124.0,0.03,0.02,1060.0
 4280.0,4390.0,4.43,17400.0,424.0,0.0020,460.0,2150.0,71.3,0.18,0.02,0.59,0.07,0.0020,0.0050,0.0040,0.012,0.0050,0.1,0.01,3.0,32000.0,75.9,180.0,0.14,0.02,1610.0
 4465.0,4575.0,3.17,15900.0,347.0,0.0020,347.0,1500.0,55.4,0.28,0.02,1.17,0.09,0.0020,0.0050,0.0040,0.011,0.0050,0.1,0.01,2.0,30500.0,79.7,192.0,0.02,0.02,873.0

~Tops_Parameter
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS .                      : Profile Web App Saved Data Indicator {S}
 TOPS  .                      : Formation Source               {S}
 TOPDR .                      : Tops Depth Reference           {S}

~Tops_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 TOPT  .F                     : Top Depth                      {F}
 TOPB  .F                     : Base Depth                     {F}
 RANK  .                      : Rank of Unit, i.e. (FORMATION, SYSTEM, etc) {S}
 LVL   .                      : Level of Confidence (GOLD, SILVER, COPPER...) {S}
 TOPN  .                      : Stratigraphic Unit Name        {S}
 TOPA  .                      : Alternate Name                 {S}
 EON   .                      : EON Age                        {S}
 ERA   .                      : ERA Age                        {S}
 SYS   .                      : System                         {S}
 SER   .                      : Series                         {S}
 SSYS  .                      : Subsystem                      {S}
 SSER  .                      : Subseries                      {S}
 STG   .                      : Stage                          {S}
 GRP   .                      : Group                          {S}
 SGRP  .                      : Subgroup                       {S}
 FORM  .                      : Formation                      {S}

~Tops_Data | Tops_Definition 
# TOPT TOPB RANK LVL TOPN TOPA EON ERA SYS SER SSYS SSER STG GRP SGRP FORM
 2406.0,0.0,"MEMBER","Poor","Heebner Shale","-999.25","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Shawnee","-999.25","Oread Limestone"
 2680.0,0.0,"MEMBER","Poor","Iatan Limestone","-999.25","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Virgilian","Douglas","-999.25","Stranger"
 2691.0,2691.0,"BED","Poor","Stalnaker Sandstone","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25"
 3041.0,0.0,"GROUP","Poor","Lansing","-999.25","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Missourian","Lansing","-999.25","-999.25"
 3168.0,0.0,"MEMBER","Poor","Stark Shale","-999.25","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Upper","Missourian","Kansas City","Bronson","Dennis Limestone"
 3284.0,3284.0,"BED","Poor","BKC","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25"
 3450.0,0.0,"FORMATION","Poor","Pawnee Limestone","-999.25","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Middle","Desmoinesian","Marmaton","-999.25","Pawnee Limestone"
 3490.0,3490.0,"BED","Poor","FTSC","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25"
 3504.0,0.0,"GROUP","Poor","Cherokee","-999.25","Phanerozoic","Paleozoic","Carboniferous","-999.25","Pennsylvanian","Middle","Desmoinesian","Cherokee","-999.25","-999.25"
 3658.0,0.0,"SUBSYSTEM","Poor","Mississippian","-999.25","Phanerozoic","Paleozoic","Carboniferous","-999.25","Mississippian","-999.25","-999.25","-999.25","-999.25","-999.25"
 4054.0,4054.0,"STAGE","Poor","Kinderhookian","Kinderhookian","Phanerozoic","Paleozoic","Carboniferous","-999.25","Mississippian","Lower","Kinderhookian","-999.25","-999.25","-999.25"
 4065.3,4065.9,"FORMATION","Poor","Chattanooga Shale","-999.25","Phanerozoic","Paleozoic","Devonian","-999.25","-999.25","-999.25","Kinderhookian","-999.25","-999.25","Chattanooga Shale"
 4065.9,4099.6,"MEMBER","Poor","Simpson Sandstone","-999.25","Phanerozoic","Paleozoic","Ordovician","Middle","-999.25","-999.25","-999.25","Simpson","-999.25","-999.25"
 4099.6,4165.8,"MEMBER","Poor","Simpson Shale","-999.25","Phanerozoic","Paleozoic","Ordovician","Middle","-999.25","-999.25","-999.25","Simpson","-999.25","-999.25"
 4165.8,5128.0,"GROUP","Poor","Arbuckle","Arbuckle","Phanerozoic","Paleozoic","Ordovician","Lower","-999.25","-999.25","-999.25","Arbuckle","-999.25","-999.25"
 5128.0,5163.7,"FORMATION","Poor","Lamotte (Reagan) Sandstone","-999.25","Phanerozoic","Paleozoic","Cambrian","Upper","-999.25","-999.25","-999.25","Unkown","-999.25","Lamotte (Reagan) Sandstone"
 5163.7,5247.5,"BED","Poor","Granite","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25","-999.25"

~Test_Parameter[1]
#MNEM  .UNIT                                  VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 ID     .                                      DST 1  : DST ID                         {S}
 FORM   .                                       miss  : Formation                      {S}
 STRT   .FT                                   3664.0  : Interval Depth From            {F}
 STOP   .FT                                   3690.0  : Interval Depth To              {F}
 DEV    .                                         NO  : Deviated                       {S}
 WHIP   .FT                                           : Wipstock                       {F}
 SERL   .                                       6773  : Serial Number                  {F}
 READ   .                                     Inside  : Reading (Inside/Outside)       {S}
 PRES   .PSI                                   414.1  : Pressure                       {F}
 DEPT   .FT                                   3665.0  : At Depth                       {F}
 CMMNT  .             IF Weak blow, Slow increases 4", ISI No blow, FF Weak blow, BOB in 37 min FSI No blow  : Test Comments                  {S}
 HOLE   .IN                                     7.88  : Hole Diameter                  {F}
 COND   .                                       Poor  : Hole Condition                 {S}
 CAP    .PSI                                  8000.0  : Capacity                       {F}
 STIM   .DATE                             01/09/2011  : Start Date/Time                {DD/MM/YYYY}
 ETIM   .DATE                             01/10/2011  : End Date/Time Logger           {DD/MM/YYYY}
 TIMC   .DATE                                         : Last Calibration               {D/M/YYY}
 TIMON  .DATE                                         : Time on Bottom                 {D/M/YYY}
 TIMOF  .DATE                                         : Time off Bottom                {D/M/YYY}
 TYPE   .                   Conventional Bottom Hole  : Test Type                      {S}
 UNIT   .                                         34  : Logging Unit Number            {F}
 LGGR   .                          Trilobite Testing  : DST Logging Company            {S}
 ENG    .                                Esak Hadley  : Recording Engineer             {S}
 MUD    .                                   Gel Chem  : Mud type                       {S}
 MUDD   .GM/CC                                   9.0  : Mud Density                    {F}
 MUDV   .SEC/Qt                                 47.0  : Mud Viscosity (Funnel)         {F}
 FL     .CI                                     5.97  : Fluid Loss                     {F}
 RM     .OHM-M                                        : Resistivity of Mud             {F}
 MSAL   .PPM                                  3000.0  : Mud Salinity                   {F}
 CAKE   .IN                                      0.2  : Filter Cake                    {F}
 CSHT   .                                             : Cusion Type                    {S}
 CSHL   .FT                                           : Cusion Length                  {F}
 CSHV   .BBL                                          : Cusion Volume                  {F}
 GCSHT  .                                             : GAS Cusion Type                {S}
 GCSHP  .PSI                                          : GAS Cusion Length              {F}
 OAPI   .DEG API                                      : Oil API                        {F}
 WSAL   .PPM                                 85000.0  : Water Salinity                 {F}
 SLOPE  .PSI/CYCLE                               0.0  : Horner Plot Slope              {F}
 FLOW   . STB/DAY                                     : Flow Rate                      {F}
 THICK  .FT                                     10.0  : Vertical Thickness of Continuous Porosity {F}
 VIS    .CP                                      0.1  : Viscosity                      {F}
 FPRES  .PSI                                   414.1  : Formation Pressure             {F}
 FTEMP  .DEG F                                 116.0  : Formation Temperature          {F}
 BETA   .RB/STB                                  1.0  : Formation Volume Factor        {F}
 Z      .                                             : Gas Deviation Factor           {F}
 KHU    .MD-FT/CP                            100.024  : Transmissibility (Kh/u)        {F}
 KH     .MD-FT                                10.002  : Permeability Thickness (Kh)    {F}
 PERM   .MD                                      1.0  : Effective Permeability (K)     {F}
 PIS    .PSI                                          : Initial Static Reservoir Pressure {F}
 PWF    .PSI                                   414.1  : Bottom Hole Flowing Pressure   {F}
 TIMEF  .MIN                                    91.0  : Flow Time                      {F}
 RADIS  .FT                                    0.657  : Well Bore Radius               {F}
 DRAIN  .FT                                   2140.0  : Drainage Radius                {F}
 PHI    .PU                                           : Porosity                       {F}
 COMPS  .vol/vol/psi                          1.0E-5  : Compressibilities              {F}
 GRAV   .                                             : Specific Gravity of Gas (air=1) {F}
 PWFC   .PSI                                          : Flowing Pressure Corrected for Turbulence {F}
 DR     .                                      2.133  : Damage Ratio                   {F}
 S      .                                      4.588  : Skin Factor                    {F}
 DELPS  .PSI                                 641.436  : Pressure Drop due to Skin      {F}
 DELPT  .PSI                                          : Pressure Drop due to Turbulence {F}
 PI     .STB/DAY/PSI                           0.059  : Productive Index               {F}
 RI     .FT                                   65.154  : Radius of Investigation        {F}
 QS     .STB/DAY                              39.283  : Settled Production Rate        {F}
 AOF    .MCF/DAY                                      : Absolute Open Flow             {F}
 ELP1   .                                         11  : Exclude Points Data Points Below Shut In 1 {F}
 EUP1   .                                         33  : Exclude Points Data Points Above Shut In 1 {F}
 M1     .PSI/CYCLE                          -198.931  : Shut In 1 Slope                {F}
 P1     .PSI                                1079.982  : Shut In 1 Intercept            {F}
 ELP2   .                                         12  : Exclude Points Data Points Below Shut In 2 {F}
 EUP2   .                                         28  : Exclude Points Data Points Above Shut In 2 {F}
 M2     .PSI/CYCLE                          -160.698  : Shut In 2 Slope                {F}
 P2     .PSI                                1079.921  : Shut In 2 Intercept            {F}
 RECTL  .FT                                    800.0  : Recovery Total Length          {F}
 RECTV  .BBL                                   6.247  : Recovery Total Volume          {F}
 RECC   .                      RW ,14 @47F=85000 ppm  : Recovery Comments              {S}
 TYPE_D .                                      FLUID  : Type of DST Test, FLUID or GAS {F}
 CNT_R  .                                          3  : Total number of Recovery Pressure Data {F}
 CNT_G  .                                          1  : Total number of Gas Rates Data {F}
 CNT_1  .                                         33  : Total number of Shut In 1 Pressure-Temperature-Time Data {F}
 CNT_2  .                                         36  : Total number of Shut In 2 Pressure-Temperature-Time Data {F}

~Test_Definition[1]
#MNEM    .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 _T_TYPE  .                      : Type of Data                   {S}
 _T_ID    .                      : Period                         {S}
 _T_TIME  .MIN                   : Time                           {F}
 _T_PRES  .PSI                   : Pressure                       {F}
 _T_TEMP  .DEG F                 : Temperature                    {F}
 _T_RATE  .MCF/DAY               : Gas Rate                       {F}
 _T_CHOKE .IN                    : Choke                          {F}
 _T_LEN   .FT                    : Length                         {F}
 _T_VOL   .BBL                   : Volume                         {F}
 _T_DESC  .                      : Description                    {S}

~Test_Data[1] | Test_Definition[1] 
# _T_TYPE _T_ID _T_TIME _T_PRES _T_TEMP _T_RATE _T_CHOKE _T_LEN _T_VOL _T_DESC
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,55.0,0.27,"MCW 40%m 60%w"
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,190.0,0.934,"MCW 25%m 75%w"
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,555.0,5.043,"MCW 10%m 90%w"
 "Gas Rates","0",0.0,0.0,-999.25,0.0,0.0,-999.25,-999.25,"Gas Rates"
 "Summary","-999.25",0.0,1916.58,106.15,-999.25,-999.25,-999.25,-999.25,"Initial Hydrostatic"
 "Summary","-999.25",12.0,68.92,110.06,-999.25,-999.25,-999.25,-999.25,"Open to Flow 1"
 "Summary","-999.25",44.0,239.67,115.88,-999.25,-999.25,-999.25,-999.25,"Shut-in 1"
 "Summary","-999.25",348.0,1049.42,116.7,-999.25,-999.25,-999.25,-999.25,"End Shut-in 1"
 "Summary","-999.25",109.0,257.73,114.46,-999.25,-999.25,-999.25,-999.25,"Open to Flow 2"
 "Summary","-999.25",168.0,414.1,117.63,-999.25,-999.25,-999.25,-999.25,"Shut-in 2"
 "Summary","-999.25",348.0,1049.42,116.7,-999.25,-999.25,-999.25,-999.25,"End Shut-in 2"
 "Summary","-999.25",357.0,1804.33,114.39,-999.25,-999.25,-999.25,-999.25,"Final Hydrostatic"
 "Shut In 1","-999.25",0.0,239.67,115.88,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",2.0,722.7959259259254,115.65693282636248,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",4.0,907.7656626506024,115.43386565272496,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",6.0,932.1897590361446,115.21079847908746,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",8.0,948.448129298487,114.99545454545455,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",10.0,958.6709628610729,114.91280991735537,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",12.0,968.893796423659,114.8301652892562,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",14.0,979.1166299862449,114.74752066115703,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",16.0,986.8782315112541,114.7,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",18.0,994.482733118971,114.7,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",20.0,1002.087234726688,114.7,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",22.0,1005.5413583815028,114.7,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",24.0,1008.1454046242775,114.7,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",26.0,1010.749450867052,114.7,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",28.0,1013.3534971098267,114.7,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",30.0,1015.9575433526012,114.7,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",32.0,1018.5615895953757,114.7,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",34.0,1021.1656358381504,114.7,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",36.0,1023.7696820809249,114.70046407700241,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",38.0,1026.3737283236994,114.7107768992781,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",40.0,1028.9777745664742,114.7210897215538,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",42.0,1031.0561924686194,114.73140254382949,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",44.0,1032.4921757322177,114.7417153661052,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",46.0,1033.928158995816,114.75202818838089,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",48.0,1035.3641422594142,114.76234101065658,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",50.0,1036.8001255230126,114.77265383293228,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",52.0,1038.2361087866109,114.78296665520797,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",54.0,1039.6720920502091,114.79327947748367,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",56.0,1041.1080753138076,114.80359229975936,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",58.0,1042.5440585774058,114.81390512203507,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",60.0,1043.980041841004,114.82421794431076,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",62.0,1045.4160251046026,114.83453076658645,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",64.0,1046.8520083682008,114.84484358886215,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 2","-999.25",0.0,414.1,117.63,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",5.0,880.3144871794872,117.4272972972973,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",10.0,920.4683975903615,117.22459459459459,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",15.0,942.8599638554217,117.08251290877797,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",20.0,959.9761849710983,117.00506024096386,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",25.0,972.9017349397591,116.92760757314974,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",30.0,984.0631865106676,116.85015490533563,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",35.0,989.8752993805919,116.77270223752151,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",40.0,995.6874122505162,116.6952495697074,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",45.0,1001.1307820607858,116.66130247763249,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",50.0,1005.5136582653818,116.64839814177564,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",55.0,1009.8965344699777,116.63549380591878,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",60.0,1014.2794106745738,116.62258947006194,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",65.0,1018.6622868791698,116.6096851342051,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",70.0,1023.0451630837657,116.59678079834825,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",75.0,1025.2443035479632,116.58387646249139,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",80.0,1027.0938436268068,116.57097212663454,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",85.0,1028.9433837056504,116.5580677907777,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",90.0,1030.792923784494,116.54516345492085,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",95.0,1032.6424638633378,116.53225911906401,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",100.0,1034.4920039421813,116.52056074766355,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",105.0,1036.341544021025,116.53177570093457,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",110.0,1038.1910840998685,116.54299065420561,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",115.0,1040.0406241787123,116.55420560747663,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",120.0,1041.049222309505,116.56542056074767,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",125.0,1041.7467871170463,116.57663551401869,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",130.0,1042.4443519245876,116.58785046728971,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",135.0,1043.1419167321287,116.59906542056075,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",140.0,1043.83948153967,116.61028037383177,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",145.0,1044.5370463472113,116.6214953271028,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",150.0,1045.2346111547527,116.63271028037383,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",155.0,1045.9321759622937,116.64392523364486,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",160.0,1046.629740769835,116.65514018691589,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",165.0,1047.3273055773764,116.66635514018692,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",170.0,1048.0248703849177,116.67757009345794,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",175.0,1048.7224351924588,116.68878504672898,-999.25,-999.25,-999.25,-999.25,"Shut In 2"

~Test_Parameter[2]
#MNEM  .UNIT                                  VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 ID     .                                      DST 4  : DST ID                         {S}
 FORM   .                                   ARBUCKLE  : Formation                      {S}
 STRT   .FT                                   4574.0  : Interval Depth From            {F}
 STOP   .FT                                   4190.0  : Interval Depth To              {F}
 DEV    .                                         NO  : Deviated                       {S}
 WHIP   .FT                                           : Wipstock                       {F}
 SERL   .                                       6799  : Serial Number                  {F}
 READ   .                                    Outside  : Reading (Inside/Outside)       {S}
 PRES   .PSI                                  218.56  : Pressure                       {F}
 DEPT   .FT                                   4176.0  : At Depth                       {F}
 CMMNT  .             IF Fair blow, built to 5" in bucket, ISI Bled off, no blow back, FF Fair blow, built to BOB in 50 minutes, FSI Bled off, no blow back,  : Test Comments                  {S}
 HOLE   .IN                                     7.88  : Hole Diameter                  {F}
 COND   .                                       Good  : Hole Condition                 {S}
 CAP    .PSI                                  8000.0  : Capacity                       {F}
 STIM   .DATE                             01/24/2011  : Start Date/Time                {DD/MM/YYYY}
 ETIM   .DATE                             01/25/2011  : End Date/Time Logger           {DD/MM/YYYY}
 TIMC   .DATE                                         : Last Calibration               {D/M/YYY}
 TIMON  .DATE                                         : Time on Bottom                 {D/M/YYY}
 TIMOF  .DATE                                         : Time off Bottom                {D/M/YYY}
 TYPE   .                      Conventional Straddle  : Test Type                      {S}
 UNIT   .                                         34  : Logging Unit Number            {F}
 LGGR   .                          Trilobite Testing  : DST Logging Company            {S}
 ENG    .                           Jake Fahrenbruch  : Recording Engineer             {S}
 MUD    .                                   Gel Chem  : Mud type                       {S}
 MUDD   .GM/CC                                   9.0  : Mud Density                    {F}
 MUDV   .SEC/Qt                                 47.0  : Mud Viscosity (Funnel)         {F}
 FL     .CI                                     5.96  : Fluid Loss                     {F}
 RM     .OHM-M                                        : Resistivity of Mud             {F}
 MSAL   .PPM                                  3000.0  : Mud Salinity                   {F}
 CAKE   .IN                                      0.2  : Filter Cake                    {F}
 CSHT   .                                             : Cusion Type                    {S}
 CSHL   .FT                                           : Cusion Length                  {F}
 CSHV   .BBL                                          : Cusion Volume                  {F}
 GCSHT  .                                             : GAS Cusion Type                {S}
 GCSHP  .PSI                                          : GAS Cusion Length              {F}
 OAPI   .DEG API                                      : Oil API                        {F}
 WSAL   .PPM                                 44000.0  : Water Salinity                 {F}
 SLOPE  .PSI/CYCLE                               0.0  : Horner Plot Slope              {F}
 FLOW   . STB/DAY                                     : Flow Rate                      {F}
 THICK  .FT                                     10.0  : Vertical Thickness of Continuous Porosity {F}
 VIS    .CP                                      0.1  : Viscosity                      {F}
 FPRES  .PSI                                  218.56  : Formation Pressure             {F}
 FTEMP  .DEG F                                 115.0  : Formation Temperature          {F}
 BETA   .RB/STB                                  1.0  : Formation Volume Factor        {F}
 Z      .                                             : Gas Deviation Factor           {F}
 KHU    .MD-FT/CP                             51.771  : Transmissibility (Kh/u)        {F}
 KH     .MD-FT                                 5.177  : Permeability Thickness (Kh)    {F}
 PERM   .MD                                    0.518  : Effective Permeability (K)     {F}
 PIS    .PSI                                          : Initial Static Reservoir Pressure {F}
 PWF    .PSI                                  218.56  : Bottom Hole Flowing Pressure   {F}
 TIMEF  .MIN                                    90.0  : Flow Time                      {F}
 RADIS  .FT                                    0.657  : Well Bore Radius               {F}
 DRAIN  .FT                                   2140.0  : Drainage Radius                {F}
 PHI    .PU                                           : Porosity                       {F}
 COMPS  .vol/vol/psi                          1.0E-5  : Compressibilities              {F}
 GRAV   .                                             : Specific Gravity of Gas (air=1) {F}
 PWFC   .PSI                                          : Flowing Pressure Corrected for Turbulence {F}
 DR     .                                      7.072  : Damage Ratio                   {F}
 S      .                                     15.871  : Skin Factor                    {F}
 DELPS  .PSI                                1536.225  : Pressure Drop due to Skin      {F}
 DELPT  .PSI                                          : Pressure Drop due to Turbulence {F}
 PI     .STB/DAY/PSI                           0.016  : Productive Index               {F}
 RI     .FT                                   46.634  : Radius of Investigation        {F}
 QS     .STB/DAY                              24.301  : Settled Production Rate        {F}
 AOF    .MCF/DAY                                      : Absolute Open Flow             {F}
 ELP1   .                                         10  : Exclude Points Data Points Below Shut In 1 {F}
 EUP1   .                                         30  : Exclude Points Data Points Above Shut In 1 {F}
 M1     .PSI/CYCLE                          -133.242  : Shut In 1 Slope                {F}
 P1     .PSI                                1737.514  : Shut In 1 Intercept            {F}
 ELP2   .                                         12  : Exclude Points Data Points Below Shut In 2 {F}
 EUP2   .                                         37  : Exclude Points Data Points Above Shut In 2 {F}
 M2     .PSI/CYCLE                          -111.258  : Shut In 2 Slope                {F}
 P2     .PSI                                1737.348  : Shut In 2 Intercept            {F}
 RECTL  .FT                                    450.0  : Recovery Total Length          {F}
 RECTV  .BBL                                   2.214  : Recovery Total Volume          {F}
 RECC   .             very fine silty black dolomite in water  : Recovery Comments              {S}
 TYPE_D .                                      FLUID  : Type of DST Test, FLUID or GAS {F}
 CNT_R  .                                          4  : Total number of Recovery Pressure Data {F}
 CNT_G  .                                          1  : Total number of Gas Rates Data {F}
 CNT_1  .                                         30  : Total number of Shut In 1 Pressure-Temperature-Time Data {F}
 CNT_2  .                                         37  : Total number of Shut In 2 Pressure-Temperature-Time Data {F}

~Test_Definition[2]
#MNEM    .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 _T_TYPE  .                      : Type of Data                   {S}
 _T_ID    .                      : Period                         {S}
 _T_TIME  .MIN                   : Time                           {F}
 _T_PRES  .PSI                   : Pressure                       {F}
 _T_TEMP  .DEG F                 : Temperature                    {F}
 _T_RATE  .MCF/DAY               : Gas Rate                       {F}
 _T_CHOKE .IN                    : Choke                          {F}
 _T_LEN   .FT                    : Length                         {F}
 _T_VOL   .BBL                   : Volume                         {F}
 _T_DESC  .                      : Description                    {S}

~Test_Data[2] | Test_Definition[2] 
# _T_TYPE _T_ID _T_TIME _T_PRES _T_TEMP _T_RATE _T_CHOKE _T_LEN _T_VOL _T_DESC
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,90.0,0.443,"MCW 30%m 70%w"
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,90.0,0.443,"dolomite cut water 25%d 75%w"
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,270.0,1.328,"slightly dolomite cut water 5d% 95%w"
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,0.0,0.0,"rw=.19ohm@62degF=44000ppm"
 "Gas Rates","0",0.0,0.0,-999.25,0.0,0.0,-999.25,-999.25,"Gas Rates"
 "Summary","-999.25",0.0,1897.31,104.26,-999.25,-999.25,-999.25,-999.25,"Initial Hydrostatic"
 "Summary","-999.25",4.0,17.98,103.9,-999.25,-999.25,-999.25,-999.25,"Open to Flow 1"
 "Summary","-999.25",35.0,90.32,108.6,-999.25,-999.25,-999.25,-999.25,"Shut-in 1"
 "Summary","-999.25",339.0,1718.15,116.62,-999.25,-999.25,-999.25,-999.25,"End Shut-in 1"
 "Summary","-999.25",95.0,93.72,112.98,-999.25,-999.25,-999.25,-999.25,"Open to Flow 2"
 "Summary","-999.25",154.0,218.56,112.57,-999.25,-999.25,-999.25,-999.25,"Shut-in 2"
 "Summary","-999.25",339.0,1718.15,116.62,-999.25,-999.25,-999.25,-999.25,"End Shut-in 2"
 "Summary","-999.25",341.0,1894.78,115.84,-999.25,-999.25,-999.25,-999.25,"Final Hydrostatic"
 "Shut In 1","-999.25",0.0,90.32,108.6,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",2.0,1247.5359999999998,109.19999999999999,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",4.0,1586.9314285714286,109.54502868068833,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",6.0,1614.2986781609195,109.80506692160611,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",8.0,1634.5905733944953,110.22573065902579,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",10.0,1645.6318577981651,111.67558739255014,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",12.0,1656.673142201835,112.6468085106383,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",14.0,1664.6978080229228,112.86939443535188,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",16.0,1672.580329512894,113.09198036006546,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",18.0,1680.4628510028654,113.24,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",20.0,1685.5960100286534,113.24,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",22.0,1687.565924068768,113.24,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",24.0,1689.5358381088827,113.24,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",26.0,1691.505752148997,113.24,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",28.0,1693.4756661891117,113.24,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",30.0,1695.4455802292264,113.2448404616429,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",32.0,1697.415494269341,113.26588594704684,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",34.0,1699.1468960573477,113.28693143245077,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",36.0,1700.6250322580645,113.30797691785472,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",38.0,1702.1031684587815,113.32902240325865,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",40.0,1703.5813046594983,113.3500678886626,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",42.0,1705.059440860215,113.37111337406652,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",44.0,1706.5375770609319,113.39215885947047,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",46.0,1708.0157132616487,113.4132043448744,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",48.0,1709.1982362728786,113.43424983027835,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",50.0,1710.0967387687188,113.45529531568228,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",52.0,1710.9952412645591,113.47634080108621,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",54.0,1711.8937437603995,113.49738628649015,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",56.0,1712.7922462562397,113.51843177189409,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",58.0,1713.69074875208,113.53947725729803,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 2","-999.25",0.0,218.56,112.57,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",5.0,1548.6023782234959,113.08777434312209,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",10.0,1609.3745419847328,113.92009174311926,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",15.0,1639.8743587069864,114.48647935779816,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",20.0,1650.6303545359751,114.9446178343949,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",25.0,1660.387994269341,115.10703821656051,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",30.0,1668.5971633237823,115.26945859872612,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",35.0,1675.199574119574,115.43187898089172,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",40.0,1678.0169369369369,115.53725634725635,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",45.0,1680.8342997542998,115.63963144963145,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",50.0,1684.149181494662,115.74200655200654,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",55.0,1687.5477580071174,115.84438165438165,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",60.0,1690.946334519573,115.94173845677099,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",65.0,1694.3449110320284,115.96807871087698,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",70.0,1697.743487544484,115.99441896498296,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",75.0,1699.6713065781535,116.02075921908893,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",80.0,1701.2268286059143,116.04709947319492,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",85.0,1702.7823506336754,116.0734397273009,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",90.0,1704.3378726614364,116.09977998140688,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",95.0,1705.8933946891973,116.13485427615862,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",100.0,1707.4489167169584,116.17546583850931,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",105.0,1708.8415983321752,116.21607740086002,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",110.0,1709.439235580264,116.2566889632107,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",115.0,1710.0368728283531,116.2973005255614,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",120.0,1710.634510076442,116.33791208791209,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",125.0,1711.232147324531,116.37852365026278,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",130.0,1711.82978457262,116.41913521261347,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",135.0,1712.417332437104,116.453984375,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",140.0,1712.9905991933936,116.4705859375,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",145.0,1713.563865949683,116.4871875,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",150.0,1714.1371327059728,116.5037890625,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",155.0,1714.7103994622623,116.520390625,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",160.0,1715.283666218552,116.5369921875,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",165.0,1715.8569329748416,116.55359375,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",170.0,1716.4301997311313,116.5701953125,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",175.0,1717.0034664874208,116.586796875,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",180.0,1717.5767332437106,116.6033984375,-999.25,-999.25,-999.25,-999.25,"Shut In 2"

~Test_Parameter[3]
#MNEM  .UNIT                                  VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 ID     .                                      DST 2  : DST ID                         {S}
 FORM   .                                   Arbuckle  : Formation                      {S}
 STRT   .FT                                   4465.0  : Interval Depth From            {F}
 STOP   .FT                                   4575.0  : Interval Depth To              {F}
 DEV    .                                         NO  : Deviated                       {S}
 WHIP   .FT                                           : Wipstock                       {F}
 SERL   .                                       6799  : Serial Number                  {F}
 READ   .                                     Inside  : Reading (Inside/Outside)       {S}
 PRES   .PSI                                 1867.05  : Pressure                       {F}
 DEPT   .FT                                   4466.0  : At Depth                       {F}
 CMMNT  .             IF Strong blow, BOB in 20 seconds, ISI Bled off, no blow back, FF Weak blow built to 1" in 10 minutes, died to a weak surface blow, FSI Bled off, no blow back,  : Test Comments                  {S}
 HOLE   .IN                                     7.88  : Hole Diameter                  {F}
 COND   .                                       Good  : Hole Condition                 {S}
 CAP    .PSI                                  8000.0  : Capacity                       {F}
 STIM   .DATE                             01/22/2011  : Start Date/Time                {DD/MM/YYYY}
 ETIM   .DATE                             01/23/2011  : End Date/Time Logger           {DD/MM/YYYY}
 TIMC   .DATE                                         : Last Calibration               {D/M/YYY}
 TIMON  .DATE                                         : Time on Bottom                 {D/M/YYY}
 TIMOF  .DATE                                         : Time off Bottom                {D/M/YYY}
 TYPE   .                   Conventional Bottom Hole  : Test Type                      {S}
 UNIT   .                                         43  : Logging Unit Number            {F}
 LGGR   .                     Trilobite Testing, Inc  : DST Logging Company            {S}
 ENG    .                           Jake Fahrenbruch  : Recording Engineer             {S}
 MUD    .                                   Gel Chem  : Mud type                       {S}
 MUDD   .GM/CC                                   9.0  : Mud Density                    {F}
 MUDV   .SEC/Qt                                 45.0  : Mud Viscosity (Funnel)         {F}
 FL     .CI                                     7.98  : Fluid Loss                     {F}
 RM     .OHM-M                                        : Resistivity of Mud             {F}
 MSAL   .PPM                                  5000.0  : Mud Salinity                   {F}
 CAKE   .IN                                      0.2  : Filter Cake                    {F}
 CSHT   .                                             : Cusion Type                    {S}
 CSHL   .FT                                           : Cusion Length                  {F}
 CSHV   .BBL                                          : Cusion Volume                  {F}
 GCSHT  .                                             : GAS Cusion Type                {S}
 GCSHP  .PSI                                          : GAS Cusion Length              {F}
 OAPI   .DEG API                                      : Oil API                        {F}
 WSAL   .PPM                                 71000.0  : Water Salinity                 {F}
 SLOPE  .PSI/CYCLE                               0.0  : Horner Plot Slope              {F}
 FLOW   . STB/DAY                                     : Flow Rate                      {F}
 THICK  .FT                                    100.0  : Vertical Thickness of Continuous Porosity {F}
 VIS    .CP                                      0.1  : Viscosity                      {F}
 FPRES  .PSI                                 1867.05  : Formation Pressure             {F}
 FTEMP  .DEG F                                 123.0  : Formation Temperature          {F}
 BETA   .RB/STB                                  1.0  : Formation Volume Factor        {F}
 Z      .                                             : Gas Deviation Factor           {F}
 KHU    .MD-FT/CP                          12903.096  : Transmissibility (Kh/u)        {F}
 KH     .MD-FT                               1290.31  : Permeability Thickness (Kh)    {F}
 PERM   .MD                                   12.903  : Effective Permeability (K)     {F}
 PIS    .PSI                                          : Initial Static Reservoir Pressure {F}
 PWF    .PSI                                 1867.05  : Bottom Hole Flowing Pressure   {F}
 TIMEF  .MIN                                    62.0  : Flow Time                      {F}
 RADIS  .FT                                    0.657  : Well Bore Radius               {F}
 DRAIN  .FT                                   2140.0  : Drainage Radius                {F}
 PHI    .PU                                           : Porosity                       {F}
 COMPS  .vol/vol/psi                          1.0E-5  : Compressibilities              {F}
 GRAV   .                                             : Specific Gravity of Gas (air=1) {F}
 PWFC   .PSI                                          : Flowing Pressure Corrected for Turbulence {F}
 DR     .                                      0.076  : Damage Ratio                   {F}
 S      .                                      -1.13  : Skin Factor                    {F}
 DELPS  .PSI                                  -14.31  : Pressure Drop due to Skin      {F}
 DELPT  .PSI                                          : Pressure Drop due to Turbulence {F}
 PI     .STB/DAY/PSI                          14.714  : Productive Index               {F}
 RI     .FT                                   193.18  : Radius of Investigation        {F}
 QS     .STB/DAY                              26.088  : Settled Production Rate        {F}
 AOF    .MCF/DAY                                      : Absolute Open Flow             {F}
 ELP1   .                                         56  : Exclude Points Data Points Below Shut In 1 {F}
 EUP1   .                                         60  : Exclude Points Data Points Above Shut In 1 {F}
 M1     .PSI/CYCLE                            -5.293  : Shut In 1 Slope                {F}
 P1     .PSI                                1868.002  : Shut In 1 Intercept            {F}
 ELP2   .                                        180  : Exclude Points Data Points Below Shut In 2 {F}
 EUP2   .                                        189  : Exclude Points Data Points Above Shut In 2 {F}
 M2     .PSI/CYCLE                           -14.556  : Shut In 2 Slope                {F}
 P2     .PSI                                1868.823  : Shut In 2 Intercept            {F}
 RECTL  .FT                                   3900.0  : Recovery Total Length          {F}
 RECTV  .BBL                                  49.733  : Recovery Total Volume          {F}
 RECC   .                                             : Recovery Comments              {S}
 TYPE_D .                                      FLUID  : Type of DST Test, FLUID or GAS {F}
 CNT_R  .                                          4  : Total number of Recovery Pressure Data {F}
 CNT_G  .                                          1  : Total number of Gas Rates Data {F}
 CNT_1  .                                         60  : Total number of Shut In 1 Pressure-Temperature-Time Data {F}
 CNT_2  .                                        189  : Total number of Shut In 2 Pressure-Temperature-Time Data {F}

~Test_Definition[3]
#MNEM    .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 _T_TYPE  .                      : Type of Data                   {S}
 _T_ID    .                      : Period                         {S}
 _T_TIME  .MIN                   : Time                           {F}
 _T_PRES  .PSI                   : Pressure                       {F}
 _T_TEMP  .DEG F                 : Temperature                    {F}
 _T_RATE  .MCF/DAY               : Gas Rate                       {F}
 _T_CHOKE .IN                    : Choke                          {F}
 _T_LEN   .FT                    : Length                         {F}
 _T_VOL   .BBL                   : Volume                         {F}
 _T_DESC  .                      : Description                    {S}

~Test_Data[3] | Test_Definition[3] 
# _T_TYPE _T_ID _T_TIME _T_PRES _T_TEMP _T_RATE _T_CHOKE _T_LEN _T_VOL _T_DESC
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,3270.0,40.896,"slightly sulfur? cut water 2%s 98%w"
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,450.0,6.312,"sulfur? & water 50%s 50%w"
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,180.0,2.525,"drilling mud 100%m"
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,0.0,0.0,"rw=.11ohm@73degF=71000ppm"
 "Gas Rates","0",0.0,0.0,-999.25,0.0,0.0,-999.25,-999.25,"Gas Rates"
 "Summary","-999.25",0.0,2053.87,113.85,-999.25,-999.25,-999.25,-999.25,"Initial Hydrostatic"
 "Summary","-999.25",4.0,1504.39,121.16,-999.25,-999.25,-999.25,-999.25,"Open to Flow 1"
 "Summary","-999.25",36.0,1867.74,126.2,-999.25,-999.25,-999.25,-999.25,"Shut-in 1"
 "Summary","-999.25",96.0,1867.02,124.36,-999.25,-999.25,-999.25,-999.25,"End Shut-in 1"
 "Summary","-999.25",96.0,1867.03,124.35,-999.25,-999.25,-999.25,-999.25,"Open to Flow 2"
 "Summary","-999.25",126.0,1867.05,123.92,-999.25,-999.25,-999.25,-999.25,"Shut-in 2"
 "Summary","-999.25",315.0,1867.03,123.13,-999.25,-999.25,-999.25,-999.25,"End Shut-in 2"
 "Summary","-999.25",316.0,2031.74,123.08,-999.25,-999.25,-999.25,-999.25,"Final Hydrostatic"
 "Shut In 1","-999.25",0.0,1867.74,126.2,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",1.0,1867.9502040816326,126.16326530612245,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",2.0,1868.1604081632654,126.1265306122449,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",3.0,1868.370612244898,126.08979591836734,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",4.0,1868.5808163265306,126.0530612244898,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",5.0,1868.7910204081631,126.01632653061225,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",6.0,1869.001224489796,125.9795918367347,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",7.0,1869.2114285714285,125.94285714285714,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",8.0,1869.4216326530611,125.90612244897959,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",9.0,1869.631836734694,125.86938775510204,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",10.0,1869.8420408163265,125.83265306122449,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",11.0,1870.052244897959,125.79591836734694,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",12.0,1870.2624489795917,125.75918367346938,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",13.0,1870.4726530612245,125.72244897959183,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",14.0,1870.682857142857,125.68571428571428,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",15.0,1870.7700864138262,125.6487048192771,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",16.0,1870.5703744599134,125.61105421686747,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",17.0,1870.3706625060008,125.57340361445783,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",18.0,1870.1709505520882,125.53575301204819,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",19.0,1869.9712385981757,125.49810240963855,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",20.0,1869.771526644263,125.4604518072289,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",21.0,1869.5718146903505,125.42280120481928,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",22.0,1869.372102736438,125.38515060240964,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",23.0,1869.172390782525,125.3475,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",24.0,1868.9726788286125,125.30984939759036,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",25.0,1868.7729668747,125.27219879518071,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",26.0,1868.5732549207873,125.23454819277109,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",27.0,1868.3735429668748,125.19689759036144,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",28.0,1868.1738310129622,125.1592469879518,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",29.0,1867.9741190590494,125.12159638554216,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",30.0,1867.7744071051368,125.08394578313252,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",31.0,1867.5746951512242,125.0462951807229,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",32.0,1867.3749831973116,125.00864457831325,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",33.0,1867.175271243399,124.97099397590361,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",34.0,1866.9755592894865,124.93334337349397,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",35.0,1866.7758473355739,124.90176516942473,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",36.0,1866.6767225173683,124.88009456264776,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",37.0,1866.6910257458112,124.85842395587076,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",38.0,1866.7053289742541,124.83675334909377,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",39.0,1866.7196322026973,124.81508274231678,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",40.0,1866.7339354311403,124.7934121355398,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",41.0,1866.7482386595832,124.7717415287628,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",42.0,1866.7625418880261,124.75007092198581,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",43.0,1866.7768451164693,124.72840031520883,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",44.0,1866.7911483449122,124.70672970843184,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",45.0,1866.8054515733552,124.68505910165484,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",46.0,1866.8197548017981,124.66338849487785,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",47.0,1866.834058030241,124.64171788810087,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",48.0,1866.8483612586842,124.62004728132388,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",49.0,1866.8626644871272,124.59837667454688,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",50.0,1866.8769677155701,124.57670606776989,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",51.0,1866.891270944013,124.55503546099291,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",52.0,1866.905574172456,124.53336485421592,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",53.0,1866.9198774008992,124.51169424743892,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",54.0,1866.934180629342,124.49002364066193,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",55.0,1866.948483857785,124.46835303388495,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",56.0,1866.962787086228,124.44668242710796,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",57.0,1866.977090314671,124.42501182033097,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",58.0,1866.991393543114,124.40334121355397,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",59.0,1867.005696771557,124.38167060677699,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 2","-999.25",0.0,1867.05,123.92,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",1.0,1867.0337606837606,123.90138202649482,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",2.0,1867.0175213675213,123.88276405298961,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",3.0,1867.001282051282,123.86414607948443,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",4.0,1866.9850427350427,123.84552810597924,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",5.0,1866.9688034188034,123.82691013247404,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",6.0,1866.952564102564,123.80829215896885,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",7.0,1866.9363247863248,123.78967418546367,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",8.0,1866.9200854700855,123.77105621195847,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",9.0,1866.9038461538462,123.75243823845328,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",10.0,1866.8876068376069,123.7338202649481,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",11.0,1866.8713675213676,123.71520229144289,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",12.0,1866.8551282051283,123.6965843179377,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",13.0,1866.838888888889,123.67796634443252,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",14.0,1866.8226495726497,123.65934837092732,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",15.0,1866.8064102564103,123.64073039742213,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",16.0,1866.790170940171,123.62211242391695,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",17.0,1866.7739316239317,123.60349445041174,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",18.0,1866.7576923076924,123.58487647690656,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",19.0,1866.7414529914531,123.56625850340137,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",20.0,1866.7252136752138,123.54764052989617,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",21.0,1866.7089743589745,123.52902255639098,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",22.0,1866.6927350427352,123.5104045828858,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",23.0,1866.676495726496,123.4917866093806,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",24.0,1866.67,123.47316863587541,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",25.0,1866.67,123.45455066237021,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",26.0,1866.67,123.43593268886502,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",27.0,1866.67,123.41731471535984,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",28.0,1866.67,123.39928340517243,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",29.0,1866.67,123.3890463362069,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",30.0,1866.67,123.37880926724138,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",31.0,1866.67,123.36857219827587,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",32.0,1866.67,123.35833512931035,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",33.0,1866.67,123.34809806034484,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",34.0,1866.67,123.33786099137932,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",35.0,1866.67,123.32762392241379,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",36.0,1866.67,123.31738685344828,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",37.0,1866.67,123.30714978448276,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",38.0,1866.67,123.29691271551725,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",39.0,1866.67,123.28667564655173,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",40.0,1866.67,123.2764385775862,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",41.0,1866.67,123.2662015086207,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",42.0,1866.67,123.25596443965517,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",43.0,1866.67,123.24572737068965,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",44.0,1866.67,123.23549030172414,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",45.0,1866.67,123.22525323275862,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",46.0,1866.67,123.21501616379311,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",47.0,1866.67,123.20477909482759,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",48.0,1866.67,123.19454202586206,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",49.0,1866.67,123.18430495689655,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",50.0,1866.67,123.17406788793103,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",51.0,1866.67,123.16383081896552,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",52.0,1866.67,123.15359375,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",53.0,1866.67,123.14335668103448,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",54.0,1866.67,123.13311961206897,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",55.0,1866.67,123.12288254310344,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",56.0,1866.67,123.11264547413793,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",57.0,1866.67,123.10240840517241,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",58.0,1866.67,123.09217133620689,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",59.0,1866.67,123.08193426724138,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",60.0,1866.67,123.07169719827586,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",61.0,1866.67,123.06146012931035,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",62.0,1866.67,123.05122306034482,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",63.0,1866.67,123.0409859913793,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",64.0,1866.67,123.03074892241379,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",65.0,1866.67,123.02051185344827,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",66.0,1866.6654850584669,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",67.0,1866.5751862278044,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",68.0,1866.4848873971416,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",69.0,1866.3945885664791,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",70.0,1866.3042897358164,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",71.0,1866.2139909051539,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",72.0,1866.1236920744911,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",73.0,1866.0333932438286,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",74.0,1865.943094413166,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",75.0,1865.8527955825034,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",76.0,1865.7624967518407,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",77.0,1865.6721979211782,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",78.0,1865.5818990905154,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",79.0,1865.4916002598527,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",80.0,1865.4013014291902,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",81.0,1865.3110025985275,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",82.0,1865.220703767865,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",83.0,1865.1304049372022,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",84.0,1865.0401061065397,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",85.0,1864.949807275877,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",86.0,1864.8595084452145,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",87.0,1864.7692096145518,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",88.0,1864.6789107838893,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",89.0,1864.5886119532265,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",90.0,1864.498313122564,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",91.0,1864.4080142919013,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",92.0,1864.3177154612385,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",93.0,1864.227416630576,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",94.0,1864.1371177999133,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",95.0,1864.0468189692508,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",96.0,1863.956520138588,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",97.0,1863.8662213079256,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",98.0,1863.7759224772628,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",99.0,1863.6856236466003,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",100.0,1863.5953248159376,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",101.0,1863.505025985275,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",102.0,1863.4147271546124,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",103.0,1863.3244283239499,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",104.0,1863.2341294932871,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",105.0,1863.1438306626246,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",106.0,1863.053531831962,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",107.0,1862.9632330012992,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",108.0,1862.8729341706367,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",109.0,1862.782635339974,123.02,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",110.0,1862.6923365093114,123.01695664181165,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",111.0,1862.6020376786487,123.0117094725214,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",112.0,1862.5117388479862,123.00646230323115,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",113.0,1862.6027442650807,123.0012151339409,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",114.0,1862.7208411214954,122.99596796465065,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",115.0,1862.8389379779098,122.99072079536039,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",116.0,1862.9570348343245,122.98547362607015,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",117.0,1863.0751316907392,122.98022645677989,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",118.0,1863.1932285471537,122.97497928748965,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",119.0,1863.3113254035684,122.96973211819939,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",120.0,1863.429422259983,122.96448494890913,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",121.0,1863.5475191163976,122.95923777961889,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",122.0,1863.6656159728122,122.95399061032863,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",123.0,1863.783712829227,122.94874344103839,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",124.0,1863.9018096856414,122.94349627174813,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",125.0,1864.019906542056,122.93824910245789,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",126.0,1864.1380033984708,122.93300193316763,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",127.0,1864.2561002548853,122.92775476387737,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",128.0,1864.3741971113,122.92250759458713,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",129.0,1864.4922939677147,122.91726042529687,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",130.0,1864.6103908241291,122.91201325600663,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",131.0,1864.7284876805438,122.90676608671637,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",132.0,1864.8465845369585,122.90151891742612,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",133.0,1864.964681393373,122.89627174813587,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",134.0,1865.0827782497877,122.89102457884562,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",135.0,1865.2008751062021,122.88577740955537,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",136.0,1865.3189719626168,122.88053024026512,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",137.0,1865.4370688190315,122.87528307097487,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",138.0,1865.555165675446,122.87003590168462,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",139.0,1865.6732625318607,122.86478873239436,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",140.0,1865.7913593882754,122.85954156310412,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",141.0,1865.9094562446899,122.85429439381386,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",142.0,1866.0275531011046,122.84904722452362,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",143.0,1866.1456499575193,122.84380005523336,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",144.0,1866.2637468139337,122.8385528859431,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",145.0,1866.3818436703484,122.83330571665286,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",146.0,1866.499940526763,122.83255937283836,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",147.0,1866.6180373831776,122.83947659672585,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",148.0,1866.6748508180945,122.84639382061333,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",149.0,1866.6835129932629,122.8533110445008,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",150.0,1866.6921751684313,122.86022826838828,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",151.0,1866.7008373435997,122.86714549227577,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",152.0,1866.709499518768,122.87406271616324,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",153.0,1866.7181616939365,122.88097994005072,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",154.0,1866.726823869105,122.8878971639382,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",155.0,1866.7354860442733,122.89481438782569,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",156.0,1866.7441482194417,122.90173161171316,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",157.0,1866.7528103946102,122.90864883560064,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",158.0,1866.7614725697788,122.91556605948813,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",159.0,1866.7701347449472,122.9224832833756,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",160.0,1866.7787969201156,122.92940050726308,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",161.0,1866.787459095284,122.93631773115057,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",162.0,1866.7961212704524,122.94323495503804,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",163.0,1866.8047834456208,122.95015217892552,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",164.0,1866.8134456207893,122.957069402813,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",165.0,1866.8221077959577,122.96398662670047,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",166.0,1866.830769971126,122.97090385058796,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",167.0,1866.8394321462945,122.97782107447544,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",168.0,1866.848094321463,122.98473829836293,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",169.0,1866.8567564966313,122.9916555222504,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",170.0,1866.8654186717997,122.99857274613788,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",171.0,1866.8740808469684,123.00548997002537,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",172.0,1866.8827430221368,123.01240719391284,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",173.0,1866.8914051973052,123.01932441780032,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",174.0,1866.9000673724736,123.0262416416878,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",175.0,1866.908729547642,123.03315886557527,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",176.0,1866.9173917228104,123.04007608946276,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",177.0,1866.9260538979788,123.04699331335024,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",178.0,1866.9347160731472,123.05391053723771,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",179.0,1866.9433782483156,123.0608277611252,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",180.0,1866.952040423484,123.06774498501268,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",181.0,1866.9607025986525,123.07466220890015,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",182.0,1866.9693647738209,123.08157943278763,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",183.0,1866.9780269489895,123.08849665667512,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",184.0,1866.986689124158,123.0954138805626,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",185.0,1866.9953512993263,123.10233110445007,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",186.0,1867.0040134744947,123.10924832833756,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",187.0,1867.0126756496632,123.11616555222504,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",188.0,1867.0213378248316,123.12308277611251,-999.25,-999.25,-999.25,-999.25,"Shut In 2"

~Test_Parameter[4]
#MNEM  .UNIT                                  VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 ID     .                                      DST 3  : DST ID                         {S}
 FORM   .                                   Arbuckle  : Formation                      {S}
 STRT   .FT                                   4280.0  : Interval Depth From            {F}
 STOP   .FT                                   4390.0  : Interval Depth To              {F}
 DEV    .                                         NO  : Deviated                       {S}
 WHIP   .FT                                           : Wipstock                       {F}
 SERL   .                                       6799  : Serial Number                  {F}
 READ   .                                     Inside  : Reading (Inside/Outside)       {S}
 PRES   .PSI                                 1784.25  : Pressure                       {F}
 DEPT   .FT                                   4281.0  : At Depth                       {F}
 CMMNT  .             IF Strong blow, BOB 20 seconds, ISI Bled off, no blow back FF Fair blow, built to 4", died off FSI No blow back  : Test Comments                  {S}
 HOLE   .IN                                     7.88  : Hole Diameter                  {F}
 COND   .                                       Good  : Hole Condition                 {S}
 CAP    .PSI                                  8000.0  : Capacity                       {F}
 STIM   .DATE                             01/23/2011  : Start Date/Time                {DD/MM/YYYY}
 ETIM   .DATE                             01/24/2011  : End Date/Time Logger           {DD/MM/YYYY}
 TIMC   .DATE                                         : Last Calibration               {D/M/YYY}
 TIMON  .DATE                                         : Time on Bottom                 {D/M/YYY}
 TIMOF  .DATE                                         : Time off Bottom                {D/M/YYY}
 TYPE   .                      Conventional Straddle  : Test Type                      {S}
 UNIT   .                                         43  : Logging Unit Number            {F}
 LGGR   .                    Trilobite Testing, Inc.  : DST Logging Company            {S}
 ENG    .                           Jake Fahrenbruch  : Recording Engineer             {S}
 MUD    .                                   Gel Chem  : Mud type                       {S}
 MUDD   .GM/CC                                   9.0  : Mud Density                    {F}
 MUDV   .SEC/Qt                                 47.0  : Mud Viscosity (Funnel)         {F}
 FL     .CI                                   1537.0  : Fluid Loss                     {F}
 RM     .OHM-M                                        : Resistivity of Mud             {F}
 MSAL   .PPM                                  9000.0  : Mud Salinity                   {F}
 CAKE   .IN                                      0.2  : Filter Cake                    {F}
 CSHT   .                                             : Cusion Type                    {S}
 CSHL   .FT                                           : Cusion Length                  {F}
 CSHV   .BBL                                          : Cusion Volume                  {F}
 GCSHT  .                                             : GAS Cusion Type                {S}
 GCSHP  .PSI                                          : GAS Cusion Length              {F}
 OAPI   .DEG API                                      : Oil API                        {F}
 WSAL   .PPM                                 30000.0  : Water Salinity                 {F}
 SLOPE  .PSI/CYCLE                           -39.389  : Horner Plot Slope              {F}
 FLOW   . STB/DAY                                     : Flow Rate                      {F}
 THICK  .FT                                    100.0  : Vertical Thickness of Continuous Porosity {F}
 VIS    .CP                                      0.1  : Viscosity                      {F}
 FPRES  .PSI                                 1784.25  : Formation Pressure             {F}
 FTEMP  .DEG F                                 120.0  : Formation Temperature          {F}
 BETA   .RB/STB                                  1.0  : Formation Volume Factor        {F}
 Z      .                                             : Gas Deviation Factor           {F}
 KHU    .MD-FT/CP                           5160.545  : Transmissibility (Kh/u)        {F}
 KH     .MD-FT                               516.055  : Permeability Thickness (Kh)    {F}
 PERM   .MD                                    5.161  : Effective Permeability (K)     {F}
 PIS    .PSI                                1788.319  : Initial Static Reservoir Pressure {F}
 PWF    .PSI                                 1784.25  : Bottom Hole Flowing Pressure   {F}
 TIMEF  .MIN                                    59.0  : Flow Time                      {F}
 RADIS  .FT                                    0.657  : Well Bore Radius               {F}
 DRAIN  .FT                                   2140.0  : Drainage Radius                {F}
 PHI    .PU                                           : Porosity                       {F}
 COMPS  .vol/vol/psi                          1.0E-5  : Compressibilities              {F}
 GRAV   .                                             : Specific Gravity of Gas (air=1) {F}
 PWFC   .PSI                                          : Flowing Pressure Corrected for Turbulence {F}
 DR     .                                      0.061  : Damage Ratio                   {F}
 S      .                                     -0.668  : Skin Factor                    {F}
 DELPS  .PSI                                 -22.891  : Pressure Drop due to Skin      {F}
 DELPT  .PSI                                          : Pressure Drop due to Turbulence {F}
 PI     .STB/DAY/PSI                           5.477  : Productive Index               {F}
 RI     .FT                                  119.183  : Radius of Investigation        {F}
 QS     .STB/DAY                              22.286  : Settled Production Rate        {F}
 AOF    .MCF/DAY                                      : Absolute Open Flow             {F}
 ELP1   .                                         20  : Exclude Points Data Points Below Shut In 1 {F}
 EUP1   .                                         38  : Exclude Points Data Points Above Shut In 1 {F}
 M1     .PSI/CYCLE                              0.14  : Shut In 1 Slope                {F}
 P1     .PSI                                1785.662  : Shut In 1 Intercept            {F}
 ELP2   .                                        160  : Exclude Points Data Points Below Shut In 2 {F}
 EUP2   .                                        178  : Exclude Points Data Points Above Shut In 2 {F}
 M2     .PSI/CYCLE                           -39.389  : Shut In 2 Slope                {F}
 P2     .PSI                                1788.319  : Shut In 2 Intercept            {F}
 RECTL  .FT                                   4006.0  : Recovery Total Length          {F}
 RECTV  .BBL                                   51.22  : Recovery Total Volume          {F}
 RECC   .                                             : Recovery Comments              {S}
 TYPE_D .                                      FLUID  : Type of DST Test, FLUID or GAS {F}
 CNT_R  .                                          4  : Total number of Recovery Pressure Data {F}
 CNT_G  .                                          1  : Total number of Gas Rates Data {F}
 CNT_1  .                                         62  : Total number of Shut In 1 Pressure-Temperature-Time Data {F}
 CNT_2  .                                        178  : Total number of Shut In 2 Pressure-Temperature-Time Data {F}

~Test_Definition[4]
#MNEM    .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 _T_TYPE  .                      : Type of Data                   {S}
 _T_ID    .                      : Period                         {S}
 _T_TIME  .MIN                   : Time                           {F}
 _T_PRES  .PSI                   : Pressure                       {F}
 _T_TEMP  .DEG F                 : Temperature                    {F}
 _T_RATE  .MCF/DAY               : Gas Rate                       {F}
 _T_CHOKE .IN                    : Choke                          {F}
 _T_LEN   .FT                    : Length                         {F}
 _T_VOL   .BBL                   : Volume                         {F}
 _T_DESC  .                      : Description                    {S}

~Test_Data[4] | Test_Definition[4] 
# _T_TYPE _T_ID _T_TIME _T_PRES _T_TEMP _T_RATE _T_CHOKE _T_LEN _T_VOL _T_DESC
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,3286.0,41.12,"s sulfur c w (5%s 95%w)"
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,360.0,5.05,"sulfur c w (20%s 80%w)"
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,360.0,5.05,"w c sulfur (20%w 80%s)"
 "Recovery","-999.25",-999.25,-999.25,-999.25,-999.25,-999.25,0.0,0.0,"rw=.22ohm@75degF=30000ppm"
 "Gas Rates","0",0.0,0.0,-999.25,0.0,0.0,-999.25,-999.25,"Gas Rates"
 "Summary","-999.25",0.0,2010.18,104.3,-999.25,-999.25,-999.25,-999.25,"Initial Hydrostatic"
 "Summary","-999.25",1.0,1069.39,102.01,-999.25,-999.25,-999.25,-999.25,"Open to Flow 1"
 "Summary","-999.25",30.0,1782.3,115.38,-999.25,-999.25,-999.25,-999.25,"Shut-in 1"
 "Summary","-999.25",92.0,1784.63,118.57,-999.25,-999.25,-999.25,-999.25,"End Shut-in 1"
 "Summary","-999.25",92.0,1781.44,118.58,-999.25,-999.25,-999.25,-999.25,"Open to Flow 2"
 "Summary","-999.25",122.0,1784.25,119.11,-999.25,-999.25,-999.25,-999.25,"Shut-in 2"
 "Summary","-999.25",300.0,1783.43,120.14,-999.25,-999.25,-999.25,-999.25,"End Shut-in 2"
 "Summary","-999.25",302.0,1969.63,120.18,-999.25,-999.25,-999.25,-999.25,"Final Hydrostatic"
 "Shut In 1","-999.25",0.0,1782.3,115.38,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",1.0,1782.5239001969796,115.49691884456671,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",2.0,1782.7478003939593,115.61383768913342,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",3.0,1782.971700590939,115.73075653370013,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",4.0,1783.1956007879185,115.84767537826686,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",5.0,1783.4195009848981,115.96459422283357,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",6.0,1783.6434011818778,116.08151306740028,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",7.0,1783.8673013788575,116.19843191196699,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",8.0,1784.0912015758372,116.28297832233743,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",9.0,1784.315101772817,116.35555136663525,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",10.0,1784.5390019697966,116.42812441093308,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",11.0,1784.762902166776,116.50069745523092,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",12.0,1784.9868023637557,116.57327049952875,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",13.0,1785.2107025607354,116.64584354382659,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",14.0,1785.434602757715,116.71841658812441,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",15.0,1785.6585029546948,116.79098963242224,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",16.0,1785.71,116.86356267672008,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",17.0,1785.71,116.9361357210179,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",18.0,1785.71,117.00491525423729,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",19.0,1785.71,117.04587570621469,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",20.0,1785.71,117.08683615819209,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",21.0,1785.71,117.1277966101695,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",22.0,1785.71,117.1687570621469,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",23.0,1785.71,117.20971751412429,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",24.0,1785.71,117.25067796610169,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",25.0,1785.71,117.29163841807909,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",26.0,1785.71,117.3325988700565,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",27.0,1785.71,117.3735593220339,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",28.0,1785.71,117.4145197740113,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",29.0,1785.71,117.4554802259887,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",30.0,1785.71,117.4964406779661,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",31.0,1785.71,117.5374011299435,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",32.0,1785.71,117.5783615819209,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",33.0,1785.71,117.61638297872341,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",34.0,1785.71,117.65428191489362,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",35.0,1785.71,117.69218085106382,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",36.0,1785.6928311884935,117.73007978723405,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",37.0,1785.6519530658593,117.76797872340425,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",38.0,1785.6110749432248,117.80587765957446,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",39.0,1785.5701968205906,117.84377659574469,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",40.0,1785.5293186979561,117.8816755319149,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",41.0,1785.4884405753219,117.9195744680851,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",42.0,1785.4475624526874,117.95747340425532,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",43.0,1785.406684330053,117.99537234042553,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",44.0,1785.3658062074187,118.03327127659576,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",45.0,1785.3249280847842,118.07117021276596,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",46.0,1785.28404996215,118.10906914893617,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",47.0,1785.2431718395155,118.1469680851064,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",48.0,1785.2022937168813,118.1758981233244,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",49.0,1785.1614155942468,118.20404825737266,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",50.0,1785.1205374716126,118.23219839142091,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",51.0,1785.079659348978,118.26034852546917,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",52.0,1785.0387812263439,118.28849865951743,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",53.0,1784.9979031037094,118.31664879356569,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",54.0,1784.957024981075,118.34479892761394,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",55.0,1784.9161468584407,118.3729490616622,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",56.0,1784.8752687358062,118.40109919571046,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",57.0,1784.834390613172,118.4292493297587,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",58.0,1784.7935124905375,118.45739946380696,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",59.0,1784.7526343679033,118.48554959785523,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",60.0,1784.7117562452688,118.51369973190349,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 1","-999.25",61.0,1784.6708781226346,118.54184986595173,-999.25,-999.25,-999.25,-999.25,"Shut In 1"
 "Shut In 2","-999.25",0.0,1784.25,119.11,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",1.0,1784.1594858797973,119.1106968641115,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",2.0,1784.0689717595944,119.11139372822299,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",3.0,1783.9784576393918,119.1120905923345,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",4.0,1783.887943519189,119.112787456446,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",5.0,1783.7974293989862,119.11348432055749,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",6.0,1783.7069152787835,119.114181184669,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",7.0,1783.6164011585806,119.11487804878048,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",8.0,1783.525887038378,119.11557491289199,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",9.0,1783.4353729181753,119.11627177700349,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",10.0,1783.3448587979724,119.11696864111498,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",11.0,1783.2543446777697,119.11766550522648,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",12.0,1783.163830557567,119.11836236933799,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",13.0,1783.0733164373642,119.11905923344948,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",14.0,1782.9828023171615,119.11975609756098,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",15.0,1782.8922881969588,119.12436395759718,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",16.0,1782.801774076756,119.1310777385159,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",17.0,1782.7112599565532,119.13779151943463,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",18.0,1782.6207458363506,119.14450530035336,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",19.0,1782.5302317161477,119.15121908127209,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",20.0,1782.439717595945,119.15793286219082,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",21.0,1782.3492034757421,119.16464664310955,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",22.0,1782.2586893555394,119.17136042402828,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",23.0,1782.1681752353368,119.178074204947,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",24.0,1782.0776611151339,119.18478798586573,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",25.0,1781.9871469949312,119.19150176678446,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",26.0,1781.8966328747285,119.19821554770319,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",27.0,1781.8061187545256,119.20492932862192,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",28.0,1781.7905060565276,119.21164310954065,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",29.0,1781.8971009421266,119.21835689045936,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",30.0,1782.0036958277256,119.22507067137809,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",31.0,1782.1102907133243,119.23178445229682,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",32.0,1782.2168855989232,119.23849823321555,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",33.0,1782.3234804845222,119.24521201413428,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",34.0,1782.4300753701211,119.25192579505301,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",35.0,1782.53667025572,119.25863957597173,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",36.0,1782.643265141319,119.26535335689046,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",37.0,1782.749860026918,119.27206713780919,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",38.0,1782.856454912517,119.27878091872792,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",39.0,1782.9630497981157,119.28549469964665,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",40.0,1783.0696446837146,119.29220848056538,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",41.0,1783.1762395693136,119.29892226148411,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",42.0,1783.2828344549125,119.30563604240282,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",43.0,1783.3894293405115,119.31334086912837,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",44.0,1783.4960242261104,119.32288620949511,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",45.0,1783.6026191117094,119.33243154986185,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",46.0,1783.7092139973083,119.3419768902286,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",47.0,1783.815808882907,119.35152223059534,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",48.0,1783.922403768506,119.36106757096208,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",49.0,1784.028998654105,119.37061291132882,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",50.0,1784.135593539704,119.38015825169556,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",51.0,1784.2421884253029,119.3897035920623,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",52.0,1784.3487833109018,119.39924893242905,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",53.0,1784.4553781965008,119.40879427279579,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",54.0,1784.5619730820997,119.41833961316252,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",55.0,1784.6685679676984,119.42788495352926,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",56.0,1784.7751628532974,119.437430293896,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",57.0,1784.8817577388963,119.44697563426274,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",58.0,1784.9883526244953,119.45652097462948,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",59.0,1785.0949475100942,119.46606631499623,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",60.0,1785.2015423956932,119.47561165536297,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",61.0,1785.3081372812921,119.48515699572971,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",62.0,1785.414732166891,119.49470233609645,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",63.0,1785.52132705249,119.5042476764632,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",64.0,1785.6279219380888,119.51379301682994,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",65.0,1785.6916148566816,119.52333835719668,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",66.0,1785.6116794509487,119.53288369756342,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",67.0,1785.531744045216,119.54242903793016,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",68.0,1785.4518086394833,119.5519743782969,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",69.0,1785.3718732337506,119.56151971866365,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",70.0,1785.2919378280178,119.57106505903039,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",71.0,1785.212002422285,119.58061039939713,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",72.0,1785.1320670165524,119.59015573976387,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",73.0,1785.0521316108195,119.59970108013061,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",74.0,1784.972196205087,119.60924642049736,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",75.0,1784.892260799354,119.6187917608641,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",76.0,1784.8123253936214,119.62833710123084,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",77.0,1784.7323899878886,119.63788244159758,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",78.0,1784.6524545821558,119.64742778196432,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",79.0,1784.5725191764232,119.65697312233107,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",80.0,1784.4925837706903,119.66651846269781,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",81.0,1784.4126483649577,119.67606380306455,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",82.0,1784.3327129592249,119.6856091434313,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",83.0,1784.2527775534923,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",84.0,1784.1728421477594,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",85.0,1784.0929067420266,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",86.0,1784.012971336294,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",87.0,1783.9330359305611,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",88.0,1783.8531005248285,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",89.0,1783.7731651190957,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",90.0,1783.693229713363,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",91.0,1783.6132943076302,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",92.0,1783.5333589018974,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",93.0,1783.4534234961648,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",94.0,1783.373488090432,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",95.0,1783.2935526846993,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",96.0,1783.2136172789665,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",97.0,1783.1336818732339,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",98.0,1783.053746467501,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",99.0,1782.9738110617682,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",100.0,1782.8938756560356,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",101.0,1782.8139402503027,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",102.0,1782.73400484457,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",103.0,1782.6540694388373,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",104.0,1782.5741340331047,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",105.0,1782.4941986273718,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",106.0,1782.414263221639,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",107.0,1782.3343278159064,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",108.0,1782.2543924101735,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",109.0,1782.174457004441,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",110.0,1782.094521598708,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",111.0,1782.0145861929755,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",112.0,1781.9346507872426,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",113.0,1781.85471538151,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",114.0,1781.7747799757772,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",115.0,1781.7682006594441,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",116.0,1781.7945784267547,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",117.0,1781.820956194065,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",118.0,1781.8473339613754,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",119.0,1781.8737117286857,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",120.0,1781.9000894959963,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",121.0,1781.9264672633067,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",122.0,1781.952845030617,119.69,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",123.0,1781.9792227979274,119.69589449129732,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",124.0,1782.005600565238,119.7039691369101,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",125.0,1782.0319783325483,119.71204378252287,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",126.0,1782.0583560998587,119.72011842813565,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",127.0,1782.084733867169,119.72819307374843,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",128.0,1782.1111116344796,119.73626771936121,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",129.0,1782.13748940179,119.74434236497397,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",130.0,1782.1638671691003,119.75241701058675,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",131.0,1782.1902449364109,119.76049165619953,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",132.0,1782.2166227037212,119.76856630181231,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",133.0,1782.2430004710316,119.77664094742508,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",134.0,1782.269378238342,119.78471559303786,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",135.0,1782.2957560056525,119.79279023865064,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",136.0,1782.3221337729628,119.8008648842634,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",137.0,1782.3485115402732,119.80893952987618,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",138.0,1782.3748893075835,119.81701417548896,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",139.0,1782.4012670748941,119.82508882110174,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",140.0,1782.4276448422045,119.83316346671451,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",141.0,1782.4540226095148,119.84123811232729,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",142.0,1782.4804003768252,119.84931275794007,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",143.0,1782.5067781441358,119.85738740355285,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",144.0,1782.533155911446,119.86546204916561,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",145.0,1782.5595336787565,119.8735366947784,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",146.0,1782.585911446067,119.88161134039117,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",147.0,1782.6122892133774,119.88968598600394,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",148.0,1782.6386669806877,119.89776063161672,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",149.0,1782.665044747998,119.9058352772295,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",150.0,1782.6914225153087,119.91390992284228,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",151.0,1782.717800282619,119.92198456845504,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",152.0,1782.7441780499294,119.93005921406782,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",153.0,1782.7705558172397,119.9381338596806,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",154.0,1782.7969335845503,119.94620850529338,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",155.0,1782.8233113518606,119.95428315090615,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",156.0,1782.849689119171,119.96235779651893,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",157.0,1782.8760668864813,119.97043244213171,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",158.0,1782.902444653792,119.97850708774448,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",159.0,1782.9288224211023,119.98658173335726,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",160.0,1782.9552001884126,119.99465637897003,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",161.0,1782.981577955723,120.00273102458281,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",162.0,1783.0079557230335,120.01080567019558,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",163.0,1783.034333490344,120.01888031580836,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",164.0,1783.0607112576542,120.02695496142114,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",165.0,1783.0870890249648,120.03502960703392,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",166.0,1783.1134667922752,120.04310425264669,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",167.0,1783.1398445595855,120.05117889825947,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",168.0,1783.1662223268959,120.05925354387225,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",169.0,1783.1926000942065,120.06732818948501,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",170.0,1783.2189778615168,120.07540283509779,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",171.0,1783.2453556288272,120.08347748071057,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",172.0,1783.2717333961375,120.09155212632335,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",173.0,1783.298111163448,120.09962677193612,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",174.0,1783.3244889307584,120.1077014175489,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",175.0,1783.3508666980688,120.11577606316168,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",176.0,1783.3772444653791,120.12385070877446,-999.25,-999.25,-999.25,-999.25,"Shut In 2"
 "Shut In 2","-999.25",177.0,1783.4036222326897,120.13192535438722,-999.25,-999.25,-999.25,-999.25,"Shut In 2"

~IQ_Control_Parameter
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                      : Profile Web App Saved Data Indicator {S}
 IQSTRT  .F              580.0  : Starting Display Depth         {F}
 IQSTOP  .F             5252.0  : Ending Display Depth           {F}
 IQSCLE  .FT/IN            100  : Plot Scale Feet/Inch           {F}
 IQGRP   .                 LAS  : LAS, ROCK or HORIZON           {S}
 IQORDR  .             DEFAULT  : DEFAULT or MODIFIED            {S}
 IQSHMIN .API              0.0  : Gamma Ray Minimum Value (Default) {F}
 IQSHLY  .API             60.0  : Gamma Ray Shaly Value (Default) {F}
 IQSH    .API             70.0  : Gamma Ray Shale Value (Default) {F}
 IQSHHOT .API            100.0  : Gamma Ray Hot Shale Value (Default) {F}
 IQSHMAX .API            150.0  : Gamma Ray Maximum Value (Default) {F}
 IQTHN   .                NPHI  : Thin Porosity Track Curve Mnemonic {S}
 IQOHM   .                      : Conductivity Image Track Curve Mnemonic {S}
 IQOHM_L .MMHO/M                : Conductivity Image Track Minimum Value {F}
 IQOHM_U .MMHO/M                : Conductivity Image Track Maximum Value {F}
 IQPHI   .                      : Porosity Image Track Curve Mnemonic {S}
 IQPHI_L .PU                    : Porosity Image Track Minimum Value {F}
 IQPHI_U .PU                    : Porosity Image Track Maximum Value {F}
 GRNL    .%                0.0  : % GR Count Lower Limit         {F}
 GRNU    .%              100.0  : % GR Count Upper Limit         {F}
 GRL     .API              0.0  : GR (API) Lower Limit           {F}
 GRU     .API            150.0  : GR (API) Upper Limit           {F}
 NEUTL   .%                0.0  : % Neutron Count Upper PHI Limit {F}
 NEUTU   .%              100.0  : % Neutron Count Lower PHI Limit {F}
 NPHIL   .PU              0.01  : Neutron Porosity Lower Limit   {F}
 NPHIU   .PU               0.4  : Neutron Porosity Upper Limit   {F}

~IQ_Control_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQ_SRC  .                      : Data Source (LAS, TOPS, ROCK)  {S}
 IQ_TYPE .                      : Type of Track Data             {S}
 IQ_DESC .                      : Track Description              {S}

~IQ_Control_Data | IQ_Control_Definition 
# IQ_SRC IQ_TYPE IQ_DESC
 "LAS","LITH","Lithology - Gamma Ray"
 "LAS","LAS","LAS - Reference - GR,SP,CAL Logs"
 "LAS","LAS","LAS - Litho-Density - NPHI,RHOB,PE Logs"
 "LAS","LITH","Colorlith - Rhomaa-Umaa Track"
 "LAS","ROCK","Lithology - Rhomaa-Umaa Track"
 "LAS","PHI","Thin Porosity Track"
 "TOPS","STRAT","Horizons - Stratigraphic Units"

~IQ_Geo_Report_Parameter
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                 YES  : Profile Web App Saved Data Indicator {S}
 GEOSTRT .F                0.0  : Starting Display Depth         {F}
 GEOSTOP .F                0.0  : Ending Display Depth           {F}
 GEOSRC  .                      : Source                         {S}
 GEOREF  .                      : Depth Reference                {S}

~IQ_Geo_Report_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 GEOTOP  .F                     : Remarks/Comments/Notes Top Depth {F}
 GEOBASE .F                     : Remarks/Comments/Notes Bottom Depth {F}
 GEOBED  .F                     : Bed Thickness                  {F}
 GEODES  .                      : DESCRIPTION                    {S}

~IQ_Geo_Report_Data | IQ_Geo_Report_Definition 
# GEOTOP GEOBASE GEOBED GEODES
 2340.0,2344.0,4.0,"2340; 2344; Sh, gy, drk gy, frm "
 2344.0,2352.0,8.0,"2344; 2352; LS, tan-buff, f-crypto xln, hard, dns, few pcs of drk frs, chrt. "
 2352.0,2362.0,10.0,"2352; 2362; LS, tan, fxln,scrt foss, scrtd vuggy por, ns "
 2362.0,2374.0,12.0,"2362; 2374; Sh, grn, gy drk gy, grn, silty, pyritic, gy silty, scrtd foss "
 2374.0,2380.0,6.0,"2374; 2380; LS, buff, fxln,hrd dns, with LS, wht-tan,fxln, chlky-sub chalky, dns "
 2380.0,2394.0,14.0,"2380; 2394; Sh, grn, lt gn, gy, lt grn, soft, sticky, strngers of gy siltstone "
 2394.0,2406.0,12.0,"2394; 2406; LS, tan, f-med xln, scrtd foss, sub chalky, hrd with LS, buff, fxln, hrd, dns "
 2406.0,2406.0,-999.25,"2406; Heebner Shale "
 2406.0,2418.0,12.0,"2406; 2418; Sh, blk, carb, firm, pyritic "
 2418.0,2422.0,4.0,"2418; 2422; LS, buff, f-med xln, foss, hrd, dns, ns "
 2422.0,2434.0,12.0,"2422; 2434; SS, wht-clr, f grn, rndd-sub rndd, calc cement, tight, some clr ss with int xln, & vuggy poro, ns, sringers of Siltstone, gy, with LS, wht, fxln, soft, chalky "
 2434.0,2450.0,16.0,"2434; 2450; LS, wht-tan,fxln,foss,pp & vuggy poro, ns, LS, wht, fxln, hrd, dns, styolite, stringers of pyrite "
 2450.0,2462.0,12.0,"2450; 2462; Sh, grn, gy, grn, silty, pyritic "
 2462.0,2466.0,4.0,"2462; 2466; LS, tan, fxln, hrd, sctrd vuggy poro, ns "
 2466.0,2474.0,8.0,"2466; 2474; Sh, grn, gy, with Siltstone grn "
 2474.0,2478.0,4.0,"2474; 2478; LS, buff, f-crypt xln, hrd, dns "
 2478.0,2488.0,10.0,"2478; 2488; Sh, gy-drk gy, frm "
 2488.0,2502.0,14.0,"2488; 2502; LS, wht-tan, f-med xln, v foss, partly oolit, intxln, omoldic and vuggy poro, ns "
 2502.0,2520.0,18.0,"2502; 2520; Sh, gy, drk gy, sctrd red, some stringers of grn-gy siltstone "
 2520.0,2540.0,20.0,"2520; 2540; Sh, gy, grn, and lt grn, intrbdd with Ls, tan, f-med xln, foss, pp & vuggy pror, ns "
 2540.0,2558.0,18.0,"2540; 2558; Sh, gy, drk gy, frm, stringers of lt grn-clr, vf grn SS with calc cement, tight "
 2558.0,2562.0,4.0,"2558; 2562; LS, tan-buff, fxln,foss, hrd, dns,some drk fresh, chrt "
 2562.0,2580.0,18.0,"2562; 2580; Sh, drk gy, gy, intr bdd with some grn, siltstone "
 2580.0,2590.0,10.0,"2580; 2590; Sh, grn, gy sctrd red, with clr-lt grn siltstone, pyritic "
 2590.0,2610.0,20.0,"2590; 2610; Sh, gy, scrtd grn with some intrbdd siltstone "
 2610.0,2650.0,40.0,"2610; 2650; Sh, gy, drk gy and scrtd grn and red, some pcs of blk sh, gy Sh, with thin lyrs of blk sh, pyritic, few pcs of LS, wht, f-med xln, foss, chalky, ns "
 2650.0,2678.0,28.0,"2650; 2678; Sh, g, drk gy, AA, some lt grn siltstone "
 2680.0,2680.0,-999.25,"2680; Iatan Limestone "
 2678.0,2684.0,6.0,"2678; 2684; LS, buff-brwn, f-med xln, foss, hrd, dns, ns "
 2684.0,2686.0,2.0,"2684; 2686; sh "
 2686.0,2688.0,2.0,"2686; 2688; LS, tan, fxln, hrd, dns with gy "
 2688.0,2691.0,3.0,"2688; 2691; Sh "
 2691.0,2691.0,-999.25,"2691; Stalnaker Sandstone "
 2691.0,2696.0,5.0,"2691; 2696; SS, wht, clr, lt grn, f grn, calc cement, tight "
 2696.0,2704.0,8.0,"2696; 2704; Sh, grn gy, few pcs of blk, hrd, frm "
 2704.0,2730.0,26.0,"2704; 2730; SS, wht-clr, f-med grain, sub rndd-ang, poorly srtd, int xln & vuggy poro, partl glauc, some with wht calc cement, tight, ns "
 2730.0,2746.0,16.0,"2730; 2746; SS, wht-clr, f-med grn, ang-sub rndd, int xln and vuggy poro, Sh, grn, lt grn, soft "
 2746.0,2750.0,4.0,"2746; 2750; LS, tan, fxln, hrd, dns, sctrd foss, ns "
 2750.0,2778.0,28.0,"2750; 2778; SS, clr-lt grn, f grn, poorly srtd, tight, with some stringrs of gy sh, SS, clr, med grn, well srtd, sub rndd-ang, int xln & vugy poro, ns "
 2778.0,2780.0,2.0,"2778; 2780; LS, wht, fxln, hrd, dns, sctrd foss, sub chalky "
 2780.0,2808.0,28.0,"2780; 2808; SS, clr, med grn, rndd-sub rndd, well srtd, int xln poro, partly glauc, ns "
 2808.0,2816.0,8.0,"2808; 2816; SS, clr-wht, f grn, prly srtd, with gy sh strngrs, tight "
 2816.0,2824.0,8.0,"2816; 2824; SS, clr, med grn, rndd-sub rndd, well srtd, int xln poro, partly glauc, ns "
 2824.0,2850.0,26.0,"2824; 2850; Sh, lt gy, silty, Siltstone, lt grn "
 2850.0,2866.0,16.0,"2850; 2866; Sh, gy, pyritic "
 2866.0,2868.0,2.0,"2866; 2868; LS, buff, f-med xln, hrd, dns "
 2868.0,2920.0,52.0,"2868; 2920; Sh, gy, pyritic, partly silty "
 2920.0,2930.0,10.0,"2920; 2930; Sh, gy, LS, tan, fxln, scrtd pp poro, ns "
 2930.0,2950.0,20.0,"2930; 2950; Sh, gy, pyritic "
 2950.0,3014.0,64.0,"2950; 3014; Sh, drk gy, gy, argl, pyritic, few pcs of grn and red Sh, Siltstone, lt gy-clr, stringrs of blk sh "
 3014.0,3041.0,27.0,"3014; 3041; Sh, blk, carb "
 3041.0,3041.0,-999.25,"3041; Lansing KC "
 3041.0,3054.0,13.0,"3041; 3054; LS< LS, tan, sucro-med xln, foss, pp & vuggy poro, ns, LS, wht, f xln, soft chalky "
 3054.0,3070.0,16.0,"3054; 3070; LS, tan-buff, f xln, hrd, dns, scrtd foss, ns, pcs of drk fresh chrt "
 3070.0,3090.0,20.0,"3070; 3090; LS, off wht-tan sucro-med xln, foss, partly oolit, vuggy and pp poro, partly chalky, ns "
 3090.0,3098.0,8.0,"3090; 3098; LS, wht, f-crypto xln, hrd, dns, with fresh lt chrt "
 3098.0,3110.0,12.0,"3098; 3110; LS, tan, mix xln, foss, vuggy, int xln and intra xln poro, ns "
 3110.0,3120.0,10.0,"3110; 3120; LS, wht-tan, crypto xln, hrd, sctrd foss, sctrd vuggy poro, dns, ns "
 3120.0,3136.0,16.0,"3120; 3136; LS, tan, off wht, sucro-f xln, foss, vuggy & pp poro, sub chalky - chalky, ns "
 3136.0,3146.0,10.0,"3136; 3146; LS, tan-wht, f-crypto xln, hrd, dns, mostly fress, wht-lt tan chert "
 3146.0,3152.0,6.0,"3146; 3152; LS, brwn-buff, sucro-f xln, foss, vuggy poro, ns "
 3152.0,3160.0,8.0,"3152; 3160; LS, tan, f-crypto xln, hrd, dns "
 3160.0,3168.0,8.0,"3160; 3168; LS, tan, sucro-f xln, pp & scrtd vuggy poro, ns "
 3168.0,3168.0,-999.25,"3168; Stark Shale "
 3168.0,3172.0,4.0,"3168; 3172; Sh, gy, drk gy, pyritic "
 3172.0,3186.0,14.0,"3172; 3186; LS, tan-buff, f-med xln, hrd, dns, sctrd vuggy poro, LS, wht-tan, fxln, sub chalky, ns "
 3186.0,3196.0,10.0,"3186; 3196; LS, tan, f-med xln, foss, oolit, ( packstone ), tight, no visi poro, ns "
 3196.0,3208.0,12.0,"3196; 3208; LS, tan-buff, f xln, hrd, dns, partly cherty, some fresh, lt, chrt "
 3208.0,3212.0,4.0,"3208; 3212; Sh, blk, carb, pyritic "
 3212.0,3216.0,4.0,"3212; 3216; SS, clr-wht, f grn, sub rndd-angular, prly srtd, calc cement, tight, ns "
 3216.0,3226.0,10.0,"3216; 3226; LS, buff, f-med xln, scrtd foss, hrd, dns "
 3226.0,3236.0,10.0,"3226; 3236; LS, tan, sucro, foss, pp poro, ns "
 3236.0,3250.0,14.0,"3236; 3250; LS, tan, buff, f-med xln, scrtd foss, scrtd vuggy poro, hrd, dns, ns "
 3250.0,3284.0,34.0,"3250; 3284; LS, buff, f-crypto xln, hrd, dns, few fractured, some stylolite, few pcs of wht chalky LS "
 3284.0,3284.0,-999.25,"3284; BKC "
 3284.0,3290.0,6.0,"3284; 3290; Sh, grn, gy drk gy, mostly blk carb, pyritic "
 3290.0,3292.0,2.0,"3290; 3292; LS, tan, f-med xln, hrd, dns "
 3292.0,3302.0,10.0,"3292; 3302; Sh, gy, drk gy, pyritic "
 3302.0,3304.0,2.0,"3302; 3304; LS, tan, med xln, hrd, dns "
 3304.0,3312.0,8.0,"3304; 3312; Sh, blk, carb,pyritic "
 3312.0,3326.0,14.0,"3312; 3326; LS, tan, f xln, scrtd foss, hrd, dns "
 3326.0,3348.0,22.0,"3326; 3348; Sh, grn-lt grn, with lt grn siltstone "
 3348.0,3350.0,2.0,"3348; 3350; LS, lt grn-lt tan, f-crypto xln, hrd, dns "
 3350.0,3366.0,16.0,"3350; 3366; Sh, grn, gy, and some drk gy, grn, silty "
 3366.0,3380.0,14.0,"3366; 3380; LS, tan,sucro-f xln, pp & scrtd vuggy poro, ns, LS, tan-lt grn, f-crypto xln, hrd, dns "
 3380.0,3384.0,4.0,"3380; 3384; Sh, blk, carb, pyritic, sh, grn, gy, lt grn, silty "
 3384.0,3392.0,8.0,"3384; 3392; LS, tan-buff, f-med xln, scrtd foss, sctrd vuggy poro, ns, LS, tan, f-crypto xln, hrd, dns "
 3392.0,3404.0,12.0,"3392; 3404; Sh, gy, drk gy, pyritic, with gy-grn siltstone "
 3404.0,3420.0,16.0,"3404; 3420; LS, buff-drk gy, f-crypto xln, hrd, dns "
 3420.0,3440.0,20.0,"3420; 3440; LS, tan, sucro-med xln, foss, pp & scrtd vuggy poro, ns LS, buff, crypto-f xln hrd, dns, cherty "
 3440.0,3450.0,10.0,"3440; 3450; Sh, gy, drk gy, blk "
 3450.0,3450.0,-999.25,"3450; Pawnee Limestone "
 3450.0,3464.0,14.0,"3450; 3464; LS, tan sucro-f xln, foss, vuggy and pp poro, ns "
 3464.0,3480.0,16.0,"3464; 3480; LS, tan-buff, f-crypto xln, hrd, dns, partly cherty, with fresh lt & crk chert "
 3480.0,3490.0,10.0,"3480; 3490; Sh, blk, crb, gy & drk gy, pyritic some clr-lt grn siltstone "
 3490.0,3490.0,-999.25,"3490; FTSC "
 3490.0,3504.0,14.0,"3490; 3504; LS, tan-buff, f-crypto xln, hrd, dns, LS, tan sucro-f xln, scrtd vuggy & pp poro, ns "
 3504.0,3504.0,-999.25,"3504; Cherokee "
 3504.0,3508.0,4.0,"3504; 3508; Sh, blk, carb "
 3508.0,3518.0,10.0,"3508; 3518; LS, buff, f-med xln, foss, oolit, ( packstone ) hrd, dns, no visi poro "
 3518.0,3526.0,8.0,"3518; 3526; Sh, grn, gy, drk gy "
 3526.0,3530.0,4.0,"3526; 3530; LS, buff, f-crypto xln, hrd, dns "
 3530.0,3540.0,10.0,"3530.0; 3540.0; LS, tan sucro-med xln, foss, vuggy & pp poro, ns "
 3540.0,3600.0,60.0,"3540; 3600; Core 1 "
 3540.0,3542.3,2.300000000000182,"3540.0; 3542.3; grayish black; N2; argillaceous limestone; very argillaceous; slight to moderately silty; scattered fine skeletal debris in wackestone fabric; considerably mottled; grayish black N2 and grayish orange 10YR7/4; bioturbated; gradational contact "
 3542.3,3545.3,3.0,"3542.3; 3545.3; grayish black; N2; calcareous shale; very firm; zones of bivalves and brachiopods; sharp contact "
 3545.3,3554.7,9.399999999999636,"3545.3; 3554.7; grayish black; N2; firm; varying amounts of calcareous material; cm-thick layers; calcareous layers are olive gray 5Y4/1; gradational contacts several cm-thick; contain horizontal lenticular bedding with darker shale at 3643.7-43.5, 3650.7; 3649.3-3649.5, 3647-3647.3; cm to several cm-thick skeletal (crinoid, bivalves, brachiopods) lags at 3650.7-3650.5, 3647.3-3647.5, 3646-3646.3; slightly water reactive but firm; sharp contact "
 3554.7,3555.0,0.3000000000001819,"3554.7; 3555.0; grayish black; N2; bioclastic wackestone; sharp contact "
 3555.0,3563.1,8.099999999999909,"3555.0; 3563.1; greenish black; 5GY 2/1; mottled with olive gray 5Y4/1; blocky; mudstone; soft; clotted; cm-size and smaller granular structures; sharp contact "
 3563.1,3563.5,0.40000000000009095,"3563.1; 3563.5; medium dark gray; N4; shale; with grayish orange 10YR 7/4 lithoclasts and thin bed; carbonate is skeletal slightly sandy wackestone to packstone; sharp contact "
 3563.5,3573.0,9.5,"3563.5; 3573.0; dark gray; N3; grades upward to dark greenish gray 5G4/1; calcareous shale; bottom 6 is soft and water reactive; less water reactive up to 3571.5; moderately firm above 3571.5; sharp contact "
 3573.0,3575.5,2.5,"3573.0; 3575.5; medium dark gray; N4; shale; very soft; flakey; bottom 4 water reactive; dusky red 5R 3/4 and moderate yellowish brown 10YR5/4; 10% mottling;  sharp contact "
 3575.5,3580.0,4.5,"3575.5; 3580.0; greenish black; 5GY2/1; shale; soft; claystone; dusky red 5R3/4 mottles at bottom 6; silty faintly laminated greenish black 5GY2/1 shale which grades upward to olive gray 5Y4/1; top 4 has dark 10YR6/6 mottles; sharp contact "
 3580.0,3580.5,0.5,"3580.0; 3580.5; dark greenish gray; 5G4/1; argillaceous skeletal wackestone; sharp contact "
 3580.5,3582.9,2.400000000000091,"3580.5; 3582.9; grayish black; N2; shale; ranges to greenish black 5G2/1; soft to moderately firm; firming upwards; sharp contact "
 3582.9,3585.0,2.099999999999909,"3582.9; 3585.0; olive gray; 5Y4/1; very argillaceous skeletal lime wackestone; firm; very sharp contact "
 3585.0,3590.0,5.0,"3585.0; 3590.0; medium dark gray; N4; shale; very soft; flakey; top inch is dark grayish black N2 chert; sharp contact "
 3590.0,3593.2,3.199999999999818,"3590.0; 3593.2; dusky yellow green; 5GY5/2; shale; limestone interclasts of skeletal wackestone to packstone; clasts are pinkish gray 5YR8/1; moderately soft ; intervals range from firm to soft water reactive; blocky mudstone; sharp contact "
 3593.2,3595.2,2.0,"3593.2; 3595.2; olive gray; 5Y4/1; shale; light olive gray 5Y6/1 lithoclasts of skeletal wackestone; moderately firm; sharp contact "
 3595.2,3599.3,4.100000000000364,"3595.2; 3599.3; medium dark gray; N4; shale;  soft; water reactive; sharp contact contact "
 3599.3,3602.0,2.699999999999818,"3599.3; 3602.0; brownish gray 5YR4/1; shale; moderately firm; autoclastic breccia appearance; clasts varying from brownish gray 5YR4/1 to dusky red 5R3/4; more dominantly red above 3600; flecks of gleyed material at sharp contact; vertical mottling "
 3600.0,3660.85,60.84999999999991,"3600; 3660.85; Core 2 "
 3602.0,3607.5,5.5,"3602.0; 3607.5; brownish gray 5YR4/1; grades up to medium dark gray N4; shale; indistinct bedding; moderately firm; water reactive; gradational contact "
 3607.5,3610.1,2.599999999999909,"3607.5; 3610.1; olive black; 5Y2/1; olive gray 5Y4/1; mottled; grayish red purple 5RP4/2; very fine silty sandstone; thin wispy wavy bedding; low angle cross stratification; wavy; mm-size beds; alternating colors; small scale ripple cross laminations; upper 6 has mottled brecciated and disrupted fabric;  upper 4 inches are light olive gray 5Y6/1; gradational contact "
 3610.1,3613.4,3.300000000000182,"3610.1; 3613.4; dark reddish brown 10R3/4; greenish gray 5GY6/1; alternating bedding; shale; slightly firmer; more silt grading upwards towards silty shale; 50/50 uniformly bedded; heterolithic bedding with ripple laminations; (tidal); gradational contact "
 3613.4,3618.9,5.5,"3613.4; 3618.9; dark reddish brown 10R3/4; greenish gray 5GY6/1; 50/50 variegated color; shale; variegated; blocky; silty mudstone; ped structures; gradational contact "
 3618.9,3620.4,1.5,"3618.9; 3620.4; 5GY5/2; dusky yellow green; shale; blocky mudstone; water reactive; soft; gradational contact "
 3620.4,3622.3,1.900000000000091,"3620.4; 3622.3; dusky red 10YR2/2; shale; soft; variegated; dusky red 10YR2/2 with dark yellowish orange 10YR6/6; blocky mudstone; distinct patches partially; clotted with dark yellowish orange 10YR6/6; gradational contact "
 3622.3,3623.0,0.6999999999998181,"3622.3; 3623.0; autoclastic breccia; lime mudstone; sharp contact "
 3623.0,3624.8,1.800000000000182,"3623.0; 3624.8; 5GY5/2; dusky yellow green; shale; soft; grades to dark green 5GY4/1; sharp contact "
 3624.8,3625.5,0.6999999999998181,"3624.8; 3625.5; very pale orange; 10YR8/2; autoclastic breccia; lime mudstone; 5GY5/2 dusky yellow green matrix between clasts; sharp contact "
 3625.5,3627.0,1.5,"3625.5; 3627.0; grayish black; N2; shale; soft; sharp contact "
 3627.0,3627.2,0.1999999999998181,"3627.0; 3627.2; greenish gray 5GY6/1; shale; lithoclasts of the limestone below 3627.2-3627; sharp contact "
 3627.2,3628.4,1.2000000000002728,"3627.2; 3628.4; yellowish gray; 5Y8/1; interclastic skeletal packstone to grainstone; lithoclastic; limestone; 3628-3628.2 shale bed; sharp contact "
 3628.4,3630.9,2.5,"3628.4; 3630.9; greenish gray 5GY 6/1; shale; moderately firm; poorly bedded; sharp contact "
 3630.9,3637.2,6.299999999999727,"3630.9; 3637.2; dark gray; N3; very soft; water reactive; occasional cm-size clasts of carbonate to 3636.5; grades up to a medium dark gray N4 soft shale at 3632.5; 3632.5-3630.9 is a moderately firm medium dark gray N4 shale mottled from brownish gray 5YR4/1 to greenish gray 5GY6/1;  gradational contact "
 3637.2,3637.8,0.6000000000003638,"3637.2; 3637.8; dusky yellow green; 5GY5/2; basal clasts; cm-size clasts incorporated in green shale; gradational contact "
 3637.8,3639.2,1.3999999999996362,"3637.8; 3639.2; 5Y6/1; light olive gray; variegated; pale yellow orange 10YR8/2; bioturnbated; mottled; argillaceous mix; subaerial surface; grades up to calcareous silty packstone; bioclasts; clasts from underlying unit; sharp contact "
 3639.2,3645.0,5.800000000000182,"3639.2; 3645.0; 5GY4/1; dark greenish gray; very soft; blocky; mudstone; variegated;  brownish gray 5YR4/1; gradational contact "
 3645.0,3646.7,1.699999999999818,"3645.0; 3646.7; softer; N3; dark gray; shale; gradational contact "
 3646.7,3648.7,2.0,"3646.7; 3648.7; 5GY4/1; dark greenish gray; shale; blocky; mottled; very dusky red 10R2/2; slight to non-calcareous; moderately firm; gradational contact "
 3648.7,3650.0,1.300000000000182,"3648.7; 3650.0; 5GY6/1; greenish gray; mudstone; blocky; variegated; gradational contact "
 3650.0,3651.0,1.0,"3650.0; 3651.0; 5GY6/1; greenish gray; mudstone; laminated; blocky; moderately firm; variegated; mottled; dark greenish gray 5YR4/1; gradational contact "
 3651.0,3653.7,2.699999999999818,"3651.0; 3653.7; greenish gray 5GY6/;1 shale; very soft; blocky; gradational contact "
 3652.0,3812.0,160.0,"3652.0; 3812.0; Core 5 "
 3653.7,3657.7,4.0,"3653.7; 3657.7;  N2; grayish black; soft; fissile; water reactive; claystone; variegated; alternates with medium dark gray; N4; mottled; gradational contact "
 3657.7,3658.3,0.6000000000003638,"3657.7; 3658.3; 10YR6/2; light brownish gray; conglomerate; isolated chert clasts; calcareous siltstone matrix; sharp contact "
 3658.0,3658.0,-999.25,"3658.0; Mississippian "
 3658.3,3662.1,3.799999999999727,"3658.3; 3662.1; grayish yellow green; 5GY7/2; massive; chert; several-cm- sized brick like rectangular chert with corroded edges in matrix; chert; peloidal crinoidal peloid packstone to grainstone; autoclastic breccia; chert is rimmed with 10YR6/2; light brownish gray and grades out to N3 dark gray; matrix is mortar-like silt sized quartz and chert grains; 3660-3658.6 grades up from incipient to autoclastic breccia; sharp contact "
 3662.1,3662.2,0.09999999999990905,"3662.1; 3662.2; grayish yellow green; 5GY7/2; shale; thinly bedded with chert;  opaque very pale orange 10YR8/2 chert; module of pelleted silicified wackestone to packstone; bioclasts within chert; sharp contact "
 3662.2,3664.2,2.0,"3662.2; 3664.2; 10YR6/2; pale yellowish brown; siliceous autoclastic breccia; tripolite; nodules and lenses of porcelain gray-green chert in a matrix of tripolitic chert; oil stained; incipient autoclastic breccia; subvertical fractures common; tripolitic chert is incipient autoclastic breccia; matrix is a more broadly distributed tripolite in which autoclasts have formed; oil staining in tripolites; sharp contact "
 3664.0,3690.0,26.0,"3664.0; 3690.0; DST #1MSSP. "
 3664.2,3665.0,0.8000000000001819,"3664.2; 3665.0; 10YR6/2; pale yellowish brown; massive; chert; multi-cm chert clasts infilled with grayish yellow green 5GY7/2; chert clasts are corroded; autoclastic breccia; bed of grayish yellow green 5GY7/2 shale at "
 3665.0,3667.0,2.0,"3665.0; 3667.0; 10YR6/2; pale yellowish brown;  massive chert; composed of cm-size clasts and fine breccia clasts all silicified together; scattered cavities subhorizontal lenses of grayish yellow green 5GY7/2 shale; few fractures; clasts of oil stained tripolite giving a brown mottled appearance; shale laminae increase upwards; sharp contact "
 3667.0,3691.0,24.0,"3667.0; 3691.0; 10YR6/2; pale yellowish brown; chert breccia; matrix is microporous chert (tripolite); brecciated chert clasts; gray nonporous porcelain chert clasts angular infilled with tripolite; massive; fresh chert surrounded by interclast porosity; same chert seen in nodules below; interclast porosity; coarse breccia;  pore space/vugs in chert bands; (cave fill?); very porous and permeable; fractures; tripolite looks dissolved; preserving more porcelain chert; 3668-3667.4 is infilled between chert with grayish yellow green 5GY7/2 clay; 3667.4-3667 is breccia with cm-size chert clasts partially silicified less connected porosity a brickwork with grayish yellow green 5GY7/2 shale fill; sharp contact "
 3691.0,3698.4,7.400000000000091,"3691.0; 3698.4; 10YR6/2; pale yellowish brown; matrix is fine microporous dolomite/chert (tripolite); alternating cm-size bedding with darker bands with increased gray banded chert; irregular complex bands; pore space/vugs in chert bands; fractures concentrated in the chert bands; lenticular dolomite has associated vuggy porosity; tripolite is uniformly porous and oil stained; discontinuous chert nodules; gradational contact "
 3692.4,3752.0,59.59999999999991,"3692.4; 3752.0; Core 4 "
 3698.4,3707.0,8.599999999999909,"3698.4; 3707.0; 10YR6/2; pale yellowish brown; silt sized dolomite; microcrystallized chert tripolite; oil stained; microcrystalline porosity increasing upward;  massive; scattered vugs; pinpoint to sum-cm vugs; no body fossils or skeletal debris; no black chert or chert nodules; gradational contact "
 3707.0,3722.6,15.599999999999909,"3707.0; 3722.6; 5Y4/1; olive gray; argillaceous lime mudstone; uniform; wispy shale laminations; indistinct cm-scale bedding; bioturbation; sub-cm mottling; "
 3722.6,3740.2,17.59999999999991,"3722.6; 3740.2; 5Y4/1; olive gray; micritic lime mudstone; bioturbated; thinly bedded; laminated; mottled; few cm-thick beds of crinoidal packstone; intervals with scattered crinoids; wispy shale beds; rare chert; isolated bands of black chert of 3732.3 to 3732.4 and 3728.2-3728.7; gradational contact "
 3740.2,3740.5,0.3000000000001819,"3740.2; 3740.5; 5Y4/1; olive gray; crinoidal packstone with sharp contacts above and below "
 3740.5,3795.3,54.80000000000018,"3740.5; 3795.3; 5Y4/1; olive gray; micritic lime mudstone; nodular to laminated; wacke limestone; dense; horizontal to subhorizontal bedding; wispy shale laminations scattered; scattered intervals with crinoids but crinoids are infrequent; argillaceous content is low; chert starts at scattered light gray chert nodules; areas with occasional black chert following bedding; increase of dark shale laminations and chert above 3791; mudstone cm beds lenticular beds of lime mud that are microlaminated and pencil-point burrows; chert also crosscuts bedding; lighter beds substantially decrease after 3777; sharp contact "
 3795.3,3798.0,2.699999999999818,"3795.3; 3798.0; 5Y4/1; olive gray; medium grained crinoidal packstone to grainstone; comminuted fossil fragments; scattered mud clasts at bottom; scattered to abundant irregular chert nodules replacing dolomite; articulated brachiopods; wackestone matrix; crinoidal; sharp contact "
 3798.0,3805.5,7.5,"3798.0; 3805.5; 5Y4/1; olive gray; moderately argillaceous silty fine peloidal dolomite; becomes cm-scale rhythmically bedded alternating light and dark; lighter layers are microlaminated ; increasing chert nodules above 3805; irregular nodules from cm to multi-cm in size; irregular cm-relief abrupt contact "
 3805.5,3815.0,9.5,"3805.5; 3815.0; 5Y4/1; olive gray; moderately argillaceous silty fine peloidal dolomite; mm laminated; alternating lighter and darker beds; pencil-point horizontal occasional elongated burrows; dark shale beds alternating with olive gray beds; "
 3812.0,3872.55,60.55000000000018,"3812.0; 3872.55; Core 6 "
 3815.0,3844.0,29.0,"3815.0; 3844.0; 5Y4/1; olive gray; moderately argillaceous silty fine peloidal dolomite; laminated; wavy bedding distinguished by shales; 3848.7-3851 more abundant shale with lenses of cleaner dolomite; scattered to increasingly abundant dolomite nodules cm-size increasing upward; milky translucent chert in filled vugs;  gradational contact "
 3844.0,3849.0,5.0,"3844.0; 3849.0; 5Y4/1; olive gray; moderately argillaceous silty fine peloidal limestone; laminated; wavy bedding distinguished by shales; 3848.7-3851 more abundant shale with lenses of cleaner dolomite; scattered to increasingly abundant dolomite nodules cm-size increasing upward; milky translucent chert in filled vugs;  gradational contact "
 3849.0,3857.0,8.0,"3849.0; 3857.0; 5Y4/1; dark gray; moderately argillaceous silty fine peloidal dolomite; laminated; wavy bedding distinguished by shales; 3848.7-3851 more abundant shale with lenses of cleaner dolomite; scattered to increasingly abundant dolomite nodules cm-size increasing upward; milky translucent chert in filled vugs;  gradational contact "
 3857.0,3869.0,12.0,"3857.0; 3869.0; 5Y4/1; dark gray; moderately argillaceous silty fine peloidal limestone; laminated; wavy bedding distinguished by shales; 3848.7-3851 more abundant shale with lenses of cleaner dolomite; scattered to increasingly abundant dolomite nodules cm-size increasing upward; milky translucent chert in filled vugs;  gradational contact "
 3869.0,3871.5,2.5,"3869.0; 3871.5; 5Y4/1; dark gray; silty slightly argillaceous peloidal limestone; laminated; silty argilaceous silty dolomite; 20% silt; wispy shale laminations; thin wavy bedded; some discontinuities; packstone beds limited to subhorizontal lenses and vertical burrowing 3868.3-3869; finger sized discontinuous vertical burrowing filled with packstone; sharp contact "
 3871.5,3884.7,13.199999999999818,"3871.5; 3884.7; 10YR7/4; grayish orange; silty slightly argillaceous peloidal limestone; laminated; scattered gray shale wisps; rare nodule; scattered cm-thick beds of medium peloidal (skeletal?) dolomitic packstone at 3882.5-3882.5, 3880.3-3880.4, 3879.3-3879.4, 3871.4-3871.5 with sharp contacts; gradational contact "
 3872.55,3929.75,57.19999999999982,"3872.55; 3929.75; Core 7 "
 3884.7,3891.0,6.300000000000182,"3884.7; 3891.0; 5Y4/1; dark gray; slightly argillaceous limestone; interparticle porosity; nodules of dolomite; compaction around nodules; occasional horizontal pencil-sized burrow; occasional discontinuity surface; dolomite nodules with draping and disturbed or rotated bedding; occasional dark shale laminae sub-mm-size; finely wispy laminated mm to cm bedded; INTERBEDDED with  5Y 4/1; dark gray; medium grained peloidal (skeletal? spiculitic?) dolomitic packstone; silty; sharp contact; at 3986.1-3886.2, 3885.8-3885.9, 3885.5-3885.1, 3884.7-3884.4. "
 3891.0,3891.4,0.40000000000009095,"3891.0; 3891.4; 5Y5/1; gray; medium peloidal dolomitic packstone; medium sized peloids (skeletal?); rounded peloids; poorly sorted; thin laminations of shale; low angle sharp contact (erosional?) "
 3891.4,3905.8,14.400000000000091,"3891.4; 3905.8; olive gray  5Y4/1; argillaceous dolomitic siltstone; laminated mm-scale; scattered nodular bedding; occasional cm-size nodules of dolomite; pinpoint porosity lining laminae; interparticle porosity; increasing amounts of coarse crystalline; cm-size nodules are anhedral dolomite filled with clear translucent bluish chert; very sharp contact "
 3905.8,3906.0,0.1999999999998181,"3905.8; 3906.0; medium dark gray; N4; medium peloidal silty dolomitic packstone; few silica sub-cm; cm-bedded;  sharp contact "
 3906.0,3907.0,1.0,"3906.0; 3907.0; olive gray  5Y4/1; distinct lenticular bedding; scattered coarse dolomite nodules; sharp contact "
 3907.0,3907.2,0.1999999999998181,"3907.0; 3907.2; olive gray  5Y4/1; medium peloidal silty packstone; carbonate; laminated with bioclastic?; medium peloidal silty packstone; sharp contact "
 3907.2,3913.9,6.700000000000273,"3907.2; 3913.9; olive gray  5Y4/1;  argillaceous dolomitic siltstone; distinct lenticular bedding; alternating olive gray  5Y4/1 and medium dark gray; wispy shale laminations; few vague dolomitic silt nodules; sharp contact "
 3913.9,3914.2,0.29999999999972715,"3913.9; 3914.2; N2; grayish black; shale; 30% shale in thin mm-size beds; gradational contact "
 3914.2,3920.6,6.400000000000091,"3914.2; 3920.6; olive gray;  5Y4/1;  argillaceous dolomitic siltstone; distinct lenticular bedding; alternating olive gray  5Y4/1 and medium dark gray; wispy shale laminations; dolomitic silt nodules; gradational contact "
 3920.6,3920.8,0.20000000000027285,"3920.6; 3920.8; N2; grayish black; shale; 30% shale in thin mm-size beds; gradational contact "
 3920.8,3926.0,5.199999999999818,"3920.8; 3926.0; olive gray;  5Y4/1;  argillaceous dolomitic siltstone; distinct lenticular bedding; alternating olive gray  5Y4/1 and medium dark gray; wispy shale laminations; dolomitic silt nodules; 3922  bryozoan and dark black flecks;  gradational contact "
 3926.0,3927.0,1.0,"3926.0; 3927.0; N2; grayish black; shale; 30% shale in thin mm-size beds; sharp contact "
 3927.0,3939.0,12.0,"3927.0; 3939.0; olive gray;  5Y 4/1;  argillaceous dolomitic siltstone; 50% silt; wispy shale laminations; indistinct bedding; faint discontinuous laminations; gradational contact "
 3929.75,3990.0,60.25,"3929.75; 3990.0; Core 8 "
 3939.0,3975.6,36.59999999999991,"3939.0; 3975.6; N4; medium dark gray; very argillaceous dolomitic siltstone; faintly laminated irregular; 30% silt; 3972-3973 cm-sized irregular calcareous nodules/coarse calcite; faint lenticular bedding alternating olive gray  5Y 4/1 and medium dark gray; increasing quartz silt and dolomite mud as you go up the unit; scattered black shale seams; wispy laminations; indistinctly bedded; slight mottling; dolomite nodules from 3942.2-3946; more frequent black shale laminations from 3942-3941; dolomite replacement crystal at 3940; gradational contact "
 3975.6,3993.0,17.40000000000009,"3975.6; 3993.0; 5GY3/1; very dark greenish gray; shale; tight; dolomitic; around 20% silt; scattered black shale laminae; uniform; (potential caprock); scattered pyrite; 3983 starts increasing silt;  gradational contact "
 3990.0,4020.0,30.0,"3990.0; 4020.0; Core 9 "
 3993.0,4014.0,21.0,"3993.0; 4014.0; 5Y2/1; olive black; shale; dolomitic; tight; around 10% silt; uniform; alternating laminations; 4010.2-4000.3 more silt; (potential caprock); gradational contact "
 4014.0,4032.0,18.0,"4014.0; 4032.0; 10Y3/1; very dark greenish gray; silty dolomitic shale; tight; uniform; 10% silt; fewer clearly defined nodules; wavy bedded; indistinct bedding; bedding with mm-scale laminations; some alternating light and dark lenticular bedding; (potential caprock); gradational contact "
 4020.0,4079.6,59.59999999999991,"4020.0; 4079.6; Core 10 "
 4032.0,4041.0,9.0,"4032.0; 4041.0; 5Y4/1; olive gray; shale; dark; faintly laminated irregular; lenses of silty dolomite; lenses have sub-cm vugs; scattered sub-cm scale fractures; sharp contact; "
 4041.0,4047.0,6.0,"4041.0; 4047.0; 5Y4/1; olive gray; irregular lenses of silty dolomite forming nodules; matrix 5GY2/1 greenish black silt to shale; mottled; lenticular dolomite; micritic; silty; vertical fractures and vugs in the nodules; scattered fine fractures; micro-pinpoint porosity around the silt in the nodules; poor porosity; sharp contact "
 4047.0,4050.5,3.5,"4047.0; 4050.5; 5Y4/1; olive gray; nodular; silt; dolomitic silt in a mudstone; discontinuous lenses; wispy dark shale laminations; mottled; gradational contact "
 4050.5,4059.6,9.099999999999909,"4050.5; 4059.6; 5Y4/1; olive gray; silty shale; lenticular silt beds; increasing amount of black wispy shale 4052.5 to 4050.5; gradational contact "
 4059.6,4059.7,0.09999999999990905,"4059.6; 4059.7; 5Y2/1; olive black; shale; sharp contact "
 4059.7,4059.8,0.1000000000003638,"4059.7; 4059.8; 5Y6/1; light olive gray; siltstone; sharp contact "
 4059.8,4065.3,5.5,"4059.8; 4065.3; 5Y4/1; dark olive gray; shale; with quartz silt; dolomitic; slightly water reactive; indistinct subhorizontal bedding; occasional crinoid; sharp contact   4065.3 Chattanooga Shale "
 4065.3,4065.9,0.599999999999909,"4065.3; 4065.9; N2; grayish black; Chattanooga shale; uniform; massive; shale; at 4065.5 becomes sandy shale with sand size black flecks (erosion surface?); sharp contact; "
 4065.9,4065.9,-999.25,"4065.9; Simpson Sandstone "
 4065.9,4099.6,33.70000000000027,"4065.9; 4099.6; 5Y8/1; yellowish gray; sandstone; fine-grained quartz; lot of carbonate; porosity is good 4098 to 4099.6; bioturbated; some shale laminations but dominantly sand; coarser towards the top; common chert (quartzite) beds above 4084 with carbonate cement; patches of porosity; mottled; hydrocarbon odor; patchy hydrocarbon staining; 4069 to 4065.9 clean 10YR8/2 very pale orange sand with faint low-angle crossbedding; sharp contact "
 4079.6,4138.8,59.20000000000027,"4079.6; 4138.8; Core 11 "
 4199.6,4199.6,-999.25,"4199.6; Simpson Shale "
 4099.6,4100.3,0.6999999999998181,"4099.6; 4100.3; N5; medium gray; shale;  massive; claystone; sharp contact "
 4100.3,4106.3,6.0,"4100.3; 4106.3; 5Y8/1; yellowish gray; sandstone; lithoclasts; 4104 to 4102.3 is 60% cm-size lithoclasts of sand in matrix of dark clasts and sand; black matrix of sand and dark clasts; sharp contact "
 4106.3,4109.3,3.0,"4106.3; 4109.3; N5; medium gray; shale;  massive; claystone; sharp contact "
 4109.3,4112.7,3.399999999999636,"4109.3; 4112.7; 5Y8/1; yellowish gray; basal lag of cm-size sand with dark lithoclasts; thin beds of mottled shale;  interclastic interval; bioturbated; lithoclasts; sandy shale; sharp contact "
 4112.7,4117.7,5.0,"4112.7; 4117.7; N5; medium gray; shale; waxy; claystone; sharp contact "
 4117.7,4123.5,5.800000000000182,"4117.7; 4123.5; 5Y8/1; yellowish gray; heavily bioturbated; sandstone; pencil size vertical and horizontal burrows; cm-size circular burrows; sharp contact "
 4123.5,4128.8,5.300000000000182,"4123.5; 4128.8; N4; medium dark gray; massive; sand; oil stained; not vuggy; interparticle porosity; calcareous; hard; dissolution of cement; subhorizontal bedding with faint bioturbation; sharp contact "
 4128.8,4131.3,2.5,"4128.8; 4131.3; 5Y8/1; yellowish gray; heavily bioturbated; sandstone; fine-grained quartz; ranges 60% sand; burrows; some vertical pencil sized burrows; sharp contact "
 4131.3,4135.7,4.399999999999636,"4131.3; 4135.7; N5; medium gray; shale; intervals of silt; faint evidence of bioturbated; some sandier beds; sharp contact "
 4135.7,4136.1,0.4000000000005457,"4135.7; 4136.1; 5Y8/1; yellowish gray; heavily bioturbated; sandstone; fine-grained quartz; ranges from 50%/50% up to 60% sand; sharp contact "
 4136.1,4136.5,0.3999999999996362,"4136.1; 4136.5; N4; medium dark gray; shale; flakes; claystone; sharp contact "
 4136.5,4142.4,5.899999999999636,"4136.5; 4142.4; 5Y8/1; yellowish gray; heavily bioturbated; sandstone; fine-grained quartz; ranges from 50%/50% up to 60% sand; sharp contact "
 4138.8,4185.1,46.30000000000018,"4138.8; 4185.1; Core 12 "
 4142.4,4143.5,1.1000000000003638,"4142.4; 4143.5; 10BG3/1; very dark greenish gray; shale; waxy; claystone; transitional contact "
 4143.5,4144.1,0.6000000000003638,"4143.5; 4144.1; 5Y8/1; yellowish gray; interbedded shale and sandstone; laminated sand and shale; heterolithic; mm-thick shale laminae; 50% sand and 50% shales; cm beds with mm laminations; sharp contact "
 4144.1,4144.4,0.2999999999992724,"4144.1; 4144.4; 5B5/1; medium bluish gray; shale; claystone;  sharp boundary "
 4144.4,4151.8,7.400000000000546,"4144.4; 4151.8; 5Y8/1; yellowish gray; sandstone; fine to medium grained quartz sand; cm-bedded wavy bedded; thinly laminated; mm shale laminae; numerous reactivation surfaces; common ripple cross stratification; above 46 becomes increasingly shaly with alternating thin mm-thick shale and sand; some vertical pencil sized burrows; sharp contact "
 4151.8,4153.3,1.5,"4151.8; 4153.3; 5Y8/1; yellowish gray; sandstone; medium grained; 60% sand; heterolithic; well sorted; heavily bioturbated; cm rounded burrows; pencil type burrows; thin shale 5B5/1; medium bluish gray at 4152-4151.8; sharp contact "
 4153.3,4154.0,0.6999999999998181,"4153.3; 4154.0; 5B5/1; medium bluish gray; shale; claystone;  sharp boundary "
 4154.0,4154.3,0.3000000000001819,"4154.0; 4154.3; 5Y8/1; yellowish gray ; sandstone lag; filled with basal sandy 0 .2 sand with brown lithoclasts (darkened to phosphate?); sharp contact "
 4154.3,4157.0,2.699999999999818,"4154.3; 4157.0; 5Y8/1; yellowish gray; sandstone; medium grained; well sorted; ranging from bioturbated at base to 4155.7, 20% shale ( 5B5/1; medium bluish gray); 4155.7 to 4154 is mainly sandstone; irregular mulitple cm-relief; sharp boundary "
 4157.0,4158.1,1.1000000000003638,"4157.0; 4158.1; 5B5/1; medium bluish gray; predominately shale; 20% sand; heterolithic; bioturbated; sharp boundary "
 4158.1,4161.8,3.699999999999818,"4158.1; 4161.8; 5B5/1; medium bluish gray; claystone;  intermixed with multi-cm thick sands; horizontal bedded; sand is mm-bedded; 4158.1 to 4159 is 40% sand and 60% shale (5B 5/1; medium bluish gray) heavily heterolithic bioturbated; distinct beds of sand up to 4157.1; 4158.1 has a sharp surface overlain by a couple inches of sand with darkened lithoclasts; sharp contact "
 4161.8,4165.8,4.0,"4161.8; 4165.8; 5Y8/1; yellowish gray; sandstone; fine grain quartz; rounded; frosted grains; 30% silt to shale; interbedded with 5GY5/2; dusky yellow green; heterolithic; heavily bioturbated; burrows are cm size; irregular mm size traces; occasional cm-size beds of sand subhorizontal; horizontal laminations; microlaminations in the thin preserved beds of sand; abrupt contact "
 4165.8,4165.8,-999.25,"4165.8; Arbuckle "
 4165.8,4179.3,13.5,"4165.8; 4179.3; 5YR4/1; brownish gray; micritic mottled dark clasts in lighter grainstone and peloidal matrix; 4177.7 medium bluish gray 5B 5/1 claystone layer; lenses of sheet cracks filled with quart silt; 4174.6 to 4173.4 olive colored mixed with clasts and grades into a brown dolomudstone with floating darkened micritic clasts and darker brown angular clasts (cave fill, collapsed breccia); quartz sand; frosted quartz grains; brown dolomudstone goes to the top of the Arbuckle at 4165.8; unit with clasts from incipient autoclastic brecciation at 4169 to 4173; sharp irregular contact "
 4179.3,4209.0,29.699999999999818,"4179.3; 4209.0; 5YR4/1; brownish gray; medium to coarse peloidal grainstone and packstone; some bioturbation; poorly bedded in lower portion of unit; pinpoint vugs; locally tight when more argillaceous 4199; 4195 has a autoclastic incipient brecciation; around 4193 cm to several cm sets of fining upward packstone grainstone; 4193 argilliceous 1/4 thick bed;  4194 occasional cm vugs and around clasts; thinly bedded medium peloidal grainstone and packstone; with medium bluish gray 5B 5/1 claystone @4179.3; another shale seam at 4190.2; incipient autoclastic breccia at 4190.5; N8; very light gray uniform dolomitic mudstone at 4190; dolomicrite at 4189; 4187 oolitic grainstone with oomoldic porosity and vuggy irregular fine pinpoint vugs; another mud layers 4185.7 to 4185.8 with incipient autoclastic brecciation in the lower part of the oolite 4185 to 4187; another shale at 4187; another shale seam at 4183.2; fine peloidal wackestone from 4183.2 to 4180.8; 4180.8 to 4179.3 medium to coarse grained peloidal grainstone and packstone with highly disturbed bedding with large clasts and high angle contacts with lots of debris with scattered pinpoing to cm-scale and larger vugs; sharp angular contact; upper contact of shale is irregular and has broken clasts "
 4185.1,4243.35,58.25,"4185.1; 4243.35; Core 13 "
 4209.0,4223.0,14.0,"4209.0; 4223.0; 5YR4/1; brownish gray; medium peloidal grainstone and packstone; varying beds; more argillaceous; interparticle porosity; moderate porosity; pinpoint vugs; sharp contact over basal lithoclastic lag with darkedened grains with some silicification; tight argillaceous zone around 4213.2 "
 4223.0,4224.0,1.0,"4223.0; 4224.0; N8; very light gray; very fine argillaceous dolomitic wackestone; bundle of silty beds and medium bluish gray 5B5/1 claystone at 4223.3; sharp contact "
 4224.0,4238.3,14.300000000000182,"4224.0; 4238.3; 5YR4/1; brownish gray; medium peloidal grainstone and packstone; varying beds; more argillaceous; tight; pinpoint vugs; interparticle porosity; enhanced interparticle cm-size subparallel to bedding; some sub-cm size vugs scattered throghout;4232.5 to 4233 has couplets with vugs developed along boudaries with vugs filled with white chalky substance cementing around peloids (maybe anhydrite?); (tidal); 4224-4226 is partially silicified and incipient autoclastic brecciation of the grainstone packstone; sharp contact "
 4238.3,4239.4,1.0999999999994543,"4238.3; 4239.4; 5YR4/1; brownish gray; sharp contact medium peloidal grainstone alternating; poorly sorted wackestone; gradational contact "
 4239.4,4244.5,5.100000000000364,"4239.4; 4244.5; 5Y6/1; light olive gray ; medium peloidal grainstone alternating with muddier intervals at cm-scale (bundles);  horizontal beds; intervals with fist size vugs lined with dolomite; solution vugs along bedding planes; discontinuities between beds; finer grained intervals with mud are tight; sharp contact with bluish green shale interbedded with tight argillaceous peloidal mudstone "
 4243.35,4264.0,20.649999999999636,"4243.35; 4264.0; Core 14 "
 4244.5,4245.5,1.0,"4244.5; 4245.5; 5Y6/1; light olive gray; micritic argillaceous dolomudstone; bands of medium grained pellet packstone; sharp contact "
 4245.5,4248.2,2.699999999999818,"4245.5; 4248.2; 5YR4/1; brownish gray; medium-grained peloidal grainstone to packstone; disrupted autoclastic brecciation; clasts are subhorizontal cm-thick bundles; loose grains supporting interstiticies; porous; interparticle porosity and pinpoint vugs mm to cm-size; small discontinuous solution enhanced vertical fractures; good porosity; sharp contact "
 4248.2,4250.0,1.800000000000182,"4248.2; 4250.0; 5YR4/1; brownish gray; poorly sorted argillaceous medium-size peloidal dolomite;  with medium bluish gray 5B 5/1 claystone with slickensides; autoclastic brecciation at top 5 with some solution enhancement around clasts with silty matrix; sharp contact "
 4250.0,4258.6,8.600000000000364,"4250.0; 4258.6; 5YR4/1; brownish gray; medium to coarse peloidal argillaceous dolomite; cm-size beds; variable grain sizes; small scale pinpoint vugs; scattered vugs; occasional (@4252.8) larger cavities cm-size with baroque dolomite lining cavities; scattered partial fractures; oblique 4253 fracture; upper few inches has silification and coarser grained going through autoclastic incipient brecciation has solution enhancement; sharp contact "
 4258.6,4262.2,3.5999999999994543,"4258.6; 4262.2; 5Y6/1; light olive gray; silt-size peloidal argillaceous dolomite; 4259.2 to 4259.5 medium bluish gray 5B 5/1 claystone with slickensides; sharp contact "
 4262.2,4269.2,7.0,"4262.2; 4269.2; 5Y6/1; light olive gray; medium to coarse peloidal grainstone to packstone; occasional vug; low angle cross stratification; autoclastic brecciation; mottled 5B 5/1 medium bluish gray chert silicification of oomoldic peloidal grainstonesome areas are more dolomitic; blotchy silicification;  enhanced solutino around clasts; small discontinuous solution enhanced vertical fractures; 4269.5 there is a sharp boundary with nearly vertical relief highly irregular contact with decreasing ooids upward; sharp contact (photo) "
 4267.0,4293.0,26.0,"4267.0; 4293.0; Core 15 "
 4269.3,4270.5,1.199999999999818,"4269.3; 4270.5; 5Y6/1; light olive gray; dolomudstone; silt-size peloidal; packstone; "
 4270.5,4275.9,5.399999999999636,"4270.5; 4275.9; 5Y6/1; light olive gray; fine to medium pelleted peloidal packstone to grainstone; disrupted bedding; autoclastic incipient brecciation; dense; scattered cm-size irregular vugs; discontinuous vertical fractures mostly confined to bedding but some cross cutting; solution enhancement along fractures; coarse dolomite lining fractures and vugs; sharp boundary "
 4275.9,4277.8,1.9000000000005457,"4275.9; 4277.8; 5Y6/1; light olive gray; dense; medium-grained peloidal packstone; crossbedded coarse packstone with large cm-size lithoclasts; vugs; angular bedding; moderately porous; 6-thick bed of N7 light gray uniform color dolomudstone/dolomicrite  4275.6 to 4275.9; "
 4277.8,4281.0,3.199999999999818,"4277.8; 4281.0; 5YR4/1; brownish gray; medium-grained pelleted packstone to grainstone; pinpoint molds and enhanced intercrystalline porosity; vuggy; mm to cm-size vugs; fair porosity; uniform; sharp contact "
 4281.0,4294.0,13.0,"4281.0; 4294.0; NO RECOVERY (DST 4 conducted 4280-4290 interval) "
 4281.0,4294.0,13.0,"4281.0; 4294.0; Dolo, lt brown, fxln, oolitic, vuggy and oomoldic poro, ns "
 4294.0,4354.0,60.0,"4294.0; 4354.0; Core 16 "
 4294.0,4295.7,1.699999999999818,"4294.0; 4295.7; 5YR4/1; brownish gray; pelleted packstone to grainstone; pinpoint molds and enhanced intercrystalline porosity; fair porosity; sharp contact "
 4295.7,4308.2,12.5,"4295.7; 4308.2; 5YR4/1; brownish gray; medium to coarse grain peloidal packstone and grainstone; intervals of oomoldic porosity; fair porosity; bioturbated; mottled texture; 4307-438.2 has vuggy porosity from solution vugs with sub-cm size that may be conductive; fining upward to the top; occasional reactivation surface; sharp contact "
 4308.2,4312.0,3.800000000000182,"4308.2; 4312.0; 5YR4/1; brownish gray; argillaceous silty dolomitic mudstone; mottled; bioturbated; some laminations; wispy shale; gradational with dolomite; good aquitard-ish; no porosity; sharp contact "
 4312.0,4315.3,3.300000000000182,"4312.0; 4315.3; 5YR4/1; brownish gray; fine to medium grained packstone and dolomitic mudstone; scattered argillaceous seams; bioturbation cm-size circular burrows; moldic grains or oomolds?; porosity is poor; sharp contact "
 4315.3,4330.3,15.0,"4315.3; 4330.3; 5YR4/1; brownish gray; fine to coarse poorly sorted peloidal packstone; scattered argillaceous seams; some muddier intervals with higher dispersed clay; poor porosity; few scattered molds; some wavy bedding to wispy laminated beds of shale cm-thick; occasional discontinuity; more argillaceous as you go up; fining upward succession; sharp contact "
 4330.3,4334.0,3.699999999999818,"4330.3; 4334.0; 5Y6/1; light olive gray; medium grained packstone to grainstone; reactivation surfaces abundant; low-angle bedding to indistinct bedding; cm-beds alternating with muddier to more grainstone facies including crinoids; upper portion has oolite molds; interparticle permeability; fair porosity; sharp contact "
 4334.0,4362.2,28.199999999999818,"4334.0; 4362.2; 5Y6/1; light olive gray; packstone; mm-size laminations; shale wisps; small bioturbation with rounded horizontal burrow traces; bioturbation scattered between 4351.6-4355.6; basically no porosity; could be aquitard-ish or baffle; no fractures seen; increasingly arillaceous from 4348 to 4334 5Y 5YR 4/1; brownish gray; discontinuity surfaces with shaly dolomite cm's-thick; sharp irregular contact "
 4354.0,4414.4,60.399999999999636,"4354.0; 4414.4; Core 17 "
 4362.2,4365.5,3.300000000000182,"4362.2; 4365.5; 5Y6/1; light olive gray; argillaceous laminated; tight; soft sediment deformation at 4364.5 of dolomite into more argillaceous material;43 65-4363.7 is more argillaceous gray and brown; sub-cm laminations of dolomite and clay drapes; argillaceous silt sized dolomite up to upper contact; 4363.7-4362.2 is a fine to medium packstone to grainstone with muddy birdseye with pinpoint interparticle porosity and small mm-size vugs; sharp contact "
 4365.5,4367.2,1.699999999999818,"4365.5; 4367.2; 5Y6/1; light olive gray; coarser packstone to grainstone peloid? crinoid? coated grain; wavy bedded with mud chip conglomerate at base from reworking of bottom lithology; occasional darkened lithoclast within the grainstone; pinpoint interparticle porosity abundant; coated grains; small vug sub-cm to cm-scale; no fractures; good porosity; good flow unit; sharp boundary "
 4367.2,4374.8,7.600000000000364,"4367.2; 4374.8; 5Y6/1; light olive gray; faintly mm-laminated silt 80% silty dolomite 10% thin mm-scale shale drapes; grades up to more argilliceous 4370.5; scattered reactivation surfaces 4371.4; above 70.5 grades to a buff fine silty dolomite; sharp contact "
 4374.8,4376.8,2.0,"4374.8; 4376.8; 5Y6/1; light olive gray; faintly cm-laminated fine-grained dolomitic packstone; clay laminae; irregular laminations with shale concentrations as birdseye;  tight; clay filled vugs but may still have porosity; sharp contact "
 4376.8,4377.8,1.0,"4376.8; 4377.8; 5YR4/1; brownish gray; muddy pelleted packstone; common broken fossil debris?; shale seam at cm-thick at top; sharp contact "
 4377.8,4380.0,2.199999999999818,"4377.8; 4380.0; 5YR4/1; brownish gray; medium pelleted packstone; coarse grainstone ; vugs; indistinct bedding; very porous; matrix porosity; ideal injection zone; scattered bioclasts; crinoids; sharp contact "
 4380.0,4381.5,1.5,"4380.0; 4381.5; 5Y6/1; light olive gray; finegrained argillaceous packstone; finely laminated; dense; 4380 flat truncation surface; sharp contact "
 4381.5,4392.3,10.800000000000182,"4381.5; 4392.3; 5Y6/1; light olive gray; medium grained sandy packstone; tight; low-angle cross stratification; lenticular wavy bedding; medium laminations of packstone and grainstone with shale clay drapes; clay varies from clay rick gradational to clay top; occasional discontinuities 4383 with skeletal lag with crinoid and bivalve; skeletal lag  reactivation surface at 4388.9 and 86.8 in darker shale;  4388.1 looks stromatolitic 1 wide on a reactivation surface and below has 6 of autoclastic breccia with sharp angular clasts infilled with coarse dolomite cement (the cement has vugs); sharp contact "
 4392.3,4393.9,1.5999999999994543,"4392.3; 4393.9; 5Y6/1; light olive gray; muddy micritic dolomite; laminated; distinct even sub-cm laminations slightly irregular; occasional vertical and horizontal burrows;  reactivation at 4393 about 3 inches vertical relief and has a very scoured boundary; no vugs; tight; clasts of angular lithoclasts or grainstone and packstone; edges of lithoclasts are darkened borings; sharp boundary "
 4393.9,4394.1,0.2000000000007276,"4393.9; 4394.1; N2; grayish black; claystone; sharp boundary "
 4394.1,4395.7,1.5999999999994543,"4394.1; 4395.7; 5B5/1; medium bluish gray; reworked autoclastic breccia; argillaceous mix with grain and packstone; clasts have rims of alteration or discoloration; infill greenish gray silty micritic dolomite contains crinoids bryozoa scattered; flooding surface and part of transgression followed by deepening; sharp contact "
 4395.7,4431.6,35.900000000000546,"4395.7; 4431.6; 5YR4/1; brownish gray; peloidal packstone; cross stratified laminations highlighted by packstones and shales (macrotidal); steeply dipping bedding ~45 degrees at 4431 to 4428.7; 27-12grades rapidly up to a dolomitic medium grained peloidal packstone; increased shale as you go up; mud drape and cm lenses of grainstone; 4404 to 4395.7 is even coarser with reactivation surfaces and mud drapes; lithoclasts present and are darkened at 4396 and 4396 and 4398; sharp boundary "
 4414.4,4463.75,49.350000000000364,"4414.4; 4463.75; Core 18 "
 4431.6,4432.0,0.3999999999996362,"4431.6; 4432.0; 4N medium dark gray; shale; dolomitic mudstone lenses; sharp contact "
 4432.0,4442.5,10.5,"4432.0; 4442.5; 5YR4/1; brownish gray; micritic dolomite interbedded with more agilliceous zones; no substantial porosity; becomes cleaner upward; tight; sharp boundary "
 4442.5,4460.5,18.0,"4442.5; 4460.5; 5Y6/1; light olive gray; peloidal medium sized packstone; no bedding; some pinpoint vugs but no apparent fractures; grades up to a cross-bedded grainstone with reactivation surfaces; argillaceous seams and laminations; pinpoint porosity in moulds and interparticle porosity; moderate to fair porosity; around 4445.2 has larger bugs and large vertical fracture and incipient brecciation; sharp boundary "
 4460.5,4463.2,2.699999999999818,"4460.5; 4463.2; 5Y6/1; light olive gray; peloidal sandy packstone; argillaceous; no bedding; some occasional bedding and lenses in patches; surface with clasts at 4461 with sharp irregular boundary with dark rounded clasts "
 4463.2,4470.3,7.100000000000364,"4463.2; 4470.3; 5YR4/1; brownish gray; argillaceous micritic dolomite; dense; no bedding; gray black chert associated; scattered vugs; 5N grayish black mud at 4466; sharp contact "
 4463.75,4521.0,57.25,"4463.75; 4521.0; Core 19 "
 4465.0,4575.0,110.0,"4465.0; 4575.0; DST #2Arbuckle "
 4470.3,4473.3,3.0,"4470.3; 4473.3; 5YR4/1; brownish gray; incipient autoclastic breccia; peloidal packstone to micritic dolomite; scattered larger vugs and small discontinuous fractures; less matrix porosity; moderate porosity; sharp boundary "
 4473.3,4479.4,6.099999999999454,"4473.3; 4479.4; 5YR4/1; brownish gray; silty to medium crystalline dolomite or dolomitized grains that look crystalline; good matrix porosity; moderate pinpoint vugs; good porosity (flow unit!); small discontinuous fractures ~1 dissolution enhanced; alternating laminated bedding up to nondescript bedding; uniform composition; dolomite; disrupted bedding; incipient brecciation; occasional pinpoint vugs; moulds; interpartical vugs; small discontinuous fractures scattered abundant small and dissolution enhanced; sharp contact "
 4479.4,4480.0,0.6000000000003638,"4479.4; 4480.0; 5N grayish black shale; laminated lenses; small white flecks; sharp contact "
 4480.0,4488.0,8.0,"4480.0; 4488.0; 5Y6/1; light olive gray; argillaceous micritic dolomite; dense; few vugs; two directions of fracture with cement; sharp contact "
 4488.0,4493.2,5.199999999999818,"4488.0; 4493.2; 5YR4/1; brownish gray; disrupted bedding and autoclastic breccia; small scattered pinpoing vugs; long open fractures with dolospar lining;  silicification dark 5N grayish black chert replacement; greatly diminishing porosity and vugs; sharp contact "
 4493.2,4507.0,13.800000000000182,"4493.2; 4507.0; 5YR4/1; brownish gray; matrix porosity; finely crystalline dolomite; abundant pinpoint vugs; occasional fissures and partial small discontinuous vertical fractures dissolution enhanced, vuggy from 4504 to 4502; large natural fracture at 4500 to 4497; poor to moderate porosity; sharp boundary "
 4507.0,4509.0,2.0,"4507.0; 4509.0; 5Y6/1; light olive gray; argillaceous micritic dolomite; tight; mottled; disrupted bedding; irregular surfaces; scattered vugs; poor porosity; sharp boundary "
 4509.0,4514.0,5.0,"4509.0; 4514.0; 5Y6/1; light olive gray; argillaceous micritic dolomite; tight; laminated; no vugs or apparent fractures; some faint argillageous bands anastomozing; beautiful mud; solution voids rounded dark gray chert cm-size at 4510 to 4511; and at 4511.5 reactivation surface with disruption feature overlain with rounded clast of dolomite mud and darker argillaceous dolomite; sharp boundary with desiccation feature? (see photo) "
 4514.0,4521.0,7.0,"4514.0; 4521.0; N2 2; grayish black; argillaceous micritic dolomite; tidal bundles; tight; varved continuous to lenticular with some disrupted and offset clay laminae; no vugs or apparent fractures; wavy/algal/cryptoalgal discontinuity surface covered by 5708 with gray black shale bed cm-thick grades into a silty dolomite and wavy to laminated bedding and intervals of bioturbation up to laminated; more bioturbated as you go up the section; 4514-4515 is an incipient brecciations with indistinct clasts;  sharp boundary "
 4521.0,4575.5,54.5,"4521.0; 4575.5; Core 20 "
 4521.0,4522.0,1.0,"4521.0; 4522.0; 5B5/1; medium bluish gray; autoclastic breccia with vugs; very irregular cm-size angular to rounded and mixed clasts of dolomite from light brown to gray; matrix of dolomite with no porosity; moderate porosity; sharp contact "
 4522.0,4528.0,6.0,"4522.0; 4528.0; 5Y6/1; light olive gray; argillaceous micritic dolomite; tight; wavy and wispy clay laminae; occasional vugs; no apparent fractures; "
 4528.0,4529.0,1.0,"4528.0; 4529.0; 5B5/1; medium bluish gray; massive chert; fractures; few scattered vugs; low porosity; grades to dolomite clasts mixed with chert and porosity along boundaries between clasts; gradational contact "
 4529.0,4530.0,1.0,"4529.0; 4530.0; 5Y6/1; light olive gray; argillaceous micritic dolomite; tight; wavy and wispy clay laminae; no vugs; few tight vertical fractures; sharp contact "
 4530.0,4530.2,0.1999999999998181,"4530.0; 4530.2;  N2 2; grayish black shale; claystone; no vugs or fractures; a several-centimeter-size coated grain and oolitic clast embedded in shale; sharp contact "
 4530.2,4532.0,1.800000000000182,"4530.2; 4532.0; 5Y6/1; light olive gray; silt to very file peloidal packstone; dolomitic; cm-thick planar cross stratification at 30 degree; tight cemented; no porosity; no vugs; no fractures; sharp contact parall to cross-stratification "
 4532.0,4542.0,10.0,"4532.0; 4542.0; 5Y6/1; light olive gray; argillaceous micritic dolomite; tight; wavy and wispy clay laminae; nodular scattered lenticular chert cm-sized at 4541; truncation surface at 4540; sharp contact "
 4542.0,4564.0,22.0,"4542.0; 4564.0; 5YR4/1; brownish gray; dense; slightly argillaceous micritic dolomite; tight matrix with discontinuous vertical fractures; several splayed fractures up to 6 inches; scattered 1-cm vugs; no clasts; 4543.2 to 4542 is autoclastic breccia with vugs; very sharp boundary "
 4564.0,4565.0,1.0,"4564.0; 4565.0; 5YR4/1; brownish gray; brecciated micritic dolomite; discontinuous vertical fracture; scattered vugs; solution enhancement along brecciated boundaries; fair to poor porosity; sharp contact "
 4565.0,4566.2,1.199999999999818,"4565.0; 4566.2; 5YR4/1; brownish gray; dense; argillaceous micritic dolomite; tight; no vugs; no clasts; sharp boundary "
 4566.2,4575.8,9.600000000000364,"4566.2; 4575.8; 10YR6/2; pale yellowish brown; finely crystalline micritic dolomite;  large cm's-big vugs/cavities lined; autoclastic breccia; tight to moderate porosity; gets more clay towards the bottom; interbedded with argillaceous dolomite and clean light brown breccia; clast have halos of color change; discontinuous fractures and dissolution enhanced vugs around clasts; moderate porosity; sharp contact "
 4575.5,4585.4,9.899999999999636,"4575.5; 4585.4; Core 21 "
 4575.8,4579.0,3.199999999999818,"4575.8; 4579.0; 5Y6/1; light olive gray; argillageous micritic dolomite; tight; very few occasional vugs; massive; mottling along wavy disruptive bedding; 4575.5-4575 solution cavity filled with dark gray argilliceous dolomite and clasts of micritic host rock; sharp contact "
 4579.0,4585.0,6.0,"4579.0; 4585.0; 5Y6/1; light olive gray; argillageous micritic dolomite; tight; very few occasional vugs; massive; mottling along wavy disruptive bedding; abundant small incipient brecciation and disrupted bedding with <1cm clasts  at 4579; tidal flat; sharp contact "
 4585.0,4588.2,3.199999999999818,"4585.0; 4588.2; 10YR6/2; pale yellowish brown; silty dolomite;  large cm's-big vugs/cavities lined with megaquartz and lipid dolomite crystals around 4588; tight to moderate porosity; top boundary has incipient brecciation; sharp boundary "
 4585.4,4594.4,9.0,"4585.4; 4594.4; Core 22 "
 4588.2,4595.2,7.0,"4588.2; 4595.2; 5B5/1; light bluish gray; dispersed argillaceous micritic dolomite; incipient brecciation of tightly fitted clasts; occasional shale wisps; scattered vugs cm-sized; large cavity at 4593.75 with subvertical exposed clasts dolomite; vertical unconnected fractures with solution enhancement; tight; sharp boundary "
 4595.4,4603.6,8.200000000000728,"4595.4; 4603.6; Core 23 "
 4595.2,4597.55,2.350000000000364,"4595.2; 4597.55; 5Y6/1; light olive gray; brecciated micritic dolomite; discontinuous vertical fractures and vugs; solution enhancement along brecciated boundaries; fair porosity; sharp contact on spin out "
 4597.55,4601.5,3.949999999999818,"4597.55; 4601.5; 5Y6/1; light olive gray; argillaceous laminae in a fine micritic dolomite; very few vugs;  areas of silicified chert above 4695 in breccia fabric; mottled with darker gray to brown along bedding; tight; sharp contact "
 4601.5,4610.8,9.300000000000182,"4601.5; 4610.8; 5Y6/1; light olive gray; moderate brecciation of fine micritic dolomite; scattered vugs; discontinuous vertical fractures solution enhanced; some brecciation in intervals with cm-size clasts with according variation in clasts and vugs; 4602.5-4601.6 has significant brecciation; partially silicified solution vugs and partial fractures; sharp contact "
 4603.6,4625.3,21.699999999999818,"4603.6; 4625.3; Core 24 "
 4610.8,4611.0,0.1999999999998181,"4610.8; 4611.0; 5Y6/1; light olive gray; laminated dark argillageous micritic dolomite; tight; no vugs; no clasts; partial fractures truncate at bottom; no flow; sharp contact "
 4611.0,4616.5,5.5,"4611.0; 4616.5 ; 5Y6/1; light olive gray; finely crystalline micritic dolomite; uniform; occasional wisps of shale; brecciated 4613.3 to 4612 with discontinuous vugs and clast boundaries  solution enlarged; sharp contact "
 4616.5,4619.0,2.5,"4616.5; 4619.0; 5Y6/1; light olive gray; peloidal dolomite packstone; laminated; wavy mm laminated bedding; some large cm-size vugs and partial discontinuous fractures significantly solution enlarged; sharp contact with autoclastic brecciation from 4616.5 to 4617 "
 4619.0,4623.5,4.5,"4619.0; 4623.5; 5Y6/1; light olive gray; finely crystalline micritic dolomite; few dark gray silica nodules; chert nodule with gastropod; scattered vugs; long vertical fractures with dolomite partial filling; sharp contact "
 4623.5,4626.0,2.5,"4623.5; 4626.0; 5Y6/1; light olive gray; finely crystalline micritic dolomite; varying alternating light and dark mottling; moderately porous; subvertical fractures;  intervals of brecciation with large vugs and silicified clasts; sharp contact "
 4625.3,4657.0,31.699999999999818,"4625.3; 4657.0; Core 25 "
 4626.0,4628.0,2.0,"4626.0; 4628.0; 5GY4/1; dark greenish gray; finely crystalline; argilliceous micritic dolomite; tight; occasional vug and stylolite; no solution enhancement; sharp contact "
 4628.0,4643.0,15.0,"4628.0; 4643.0; 5Y6/1; light olive gray; finely crystalline micritic dolomite; varying alternating light and dark mottling; moderately porous; intervals of brecciation with large vugs and silicified clasts (4643-4641, 4638.7-4631.5); partial irregular vertical fractures scattered solution enhanced;  sharp contact "
 4643.0,4644.0,1.0,"4643.0; 4644.0; 5Y6/1; light olive gray; dense light brown greenish brown tight micritic dolomite with faint laminations with shale; sharp contact "
 4644.0,4656.0,12.0,"4644.0; 4656.0; 5Y6/1; light olive gray; finely crystalline micritic dolomite; varying alternating light and dark mottling; large discontinuous vugs from 4652-4653 in a brecciated zone; subhorizontal vugs along bedding from 4646-4649 cm's apart; 4645-4646 brecciated zone with discontinuous vugs; sharp contact "
 4656.0,4680.0,24.0,"4656.0; 4680.0; NO RECOVERY "
 4656.0,4660.0,4.0,"4656.0; 4660.0; Dolo, tan, f-med xln, hrd, vuggy poro, fractured, fresh euthedral dolo cryst in frac planes and vuggs, stylolites & thin lays of gy sh "
 4660.0,4668.0,8.0,"4660.0; 4668.0; Dolo, tan, f-med xln, AA, some fresh wht chert "
 4668.0,4680.0,12.0,"4668.0; 4680.0; Dolo, wht-tan, f-med xln, hrd, dns, oolitic, ( packstone ), no visi poro, pcs of fresh, wht & drk chert "
 4680.0,4688.0,8.0,"4680.0; 4688.0; Core 26 "
 4680.0,4685.5,5.5,"4680.0; 4685.5; 5Y6/1; light olive gray; finely crystalline micritic dolomite; common bedding plane solution enhanced vugs; subhorizontal laminations; 4680to 4682.5 brecciated with cm-size vugs and discontinuous vertical fractures in brecciated zone; good to moderate porosity; sharp contact "
 4685.5,4687.95,2.449999999999818,"4685.5; 4687.95; 5Y6/1; light olive gray; finely crystalline micritic dolomite; brecciated; clasts extensively silicified with porcelain mottled gray to dark gray chert; common solution enhanced vugs; moderate porosity; broken core due to drilling; sharp contact "
 4687.95,4726.5,38.55000000000018,"4687.95; 4726.5; NO RECOVERY "
 4687.95,4714.0,26.050000000000182,"4687.95; 4714.0; Dolo, wht-tan, f-med xln, hrd, dns, oolitic, ( packstone ), no visi poro, abnd fresh, wht & drk chert, sm opaq oolt, sm tranl, sharp vit "
 4714.0,4726.5,12.5,"4714.0; 4726.5; Dolo, wht-tan, sucro-med xln, unif, int xln poro, scrtd vuggy poro, ns "
 4726.5,4728.0,1.5,"4726.5; 4728.0; 5GY4/1; dark greenish gray; finely crystalline; argilliceous micritic dolomite; tight; sharp contact "
 4727.0,4748.9,21.899999999999636,"4727.0; 4748.9; Core 27 "
 4728.0,4732.5,4.5,"4728.0; 4732.5; 5Y6/1; light olive gray; finely crystalline; micritic dolomite; has porosity, breccia; with solution enhanced boundaries around the clasts; early solution enhanced pipes with small clasts of carbonate infilling; at the top breccia clasts fill by cement with cm-scale vugs filled with druzy quartz with local solution enhancement of the quart, locally high porosity; overall low porosity; sharp contact "
 4732.5,4734.0,1.5,"4732.5; 4734.0; 5G2/1; greenish black to dark greenish gray 5GY4/1; dense very finely crystalline dolomite; laminated; thin mm-scale laminated bedding; bedding slightly disrupted at the top; sharp contact "
 4734.0,4739.0,5.0,"4734.0; 4739.0; 5Y 6/1; light olive gray; finely crystalline; micritic dolomite; grading upwards to slightly darker micritic dolomite with disruption of bedding from 4735-4735.5; partial discontinuous subvertical fractures; poor porosity; sharp contact "
 4739.0,4742.0,3.0,"4739.0; 4742.0; 10YR4/2; dark yellowish brown; dolomitic breccia with cm-big dolomite clasts; extremely vuggy; large vugs; looks like concrete aggregate; associated solution enhanced features with cm-size vugs with evident briny fluids with baroque dolomite crystals; discontinuous solution enhanced fractures sub-vertical; extremely porous and permeable; (Flow unit!); sharp contact "
 4742.0,4743.7,1.699999999999818,"4742.0; 4743.7; 10YR4/2; dark yellowish brown; micritic dolomite; finely crystalline; 10YR 4/2 very pale orange;  micritic dolomite clasts; sharp; inter-formational conglomerate; disruptive bedding; 4743 to 4742.3 is a dark gray dolomitic shale bed; sharp contact "
 4743.7,4745.7,2.0,"4743.7; 4745.7; 5Y6/1; light olive gray; shaly dolomite; faintly horizontally laminated; tight; partial healed fractures; no vugs; sharp contact "
 4745.7,4746.5,0.8000000000001819,"4745.7; 4746.5; 10YR4/2; dark yellowish brown; oolitic band from 4746.5 to 4746.3; sharp contact with dark yellowish brown; lithoclastic with oolites grainstone; sharp contact "
 4746.5,4747.5,1.0,"4746.5; 4747.5; 10BG5/1; greenish gray; argillaceous dolomitic  shale; laminated mm to cm; wavy bedded; very tight; partial discontinuous vertical fractures; flooding surface; sharp irregular contact "
 4747.5,4749.3,1.800000000000182,"4747.5; 4749.3; 10YR4/2; dark yellowish brown; clasts of chert in light brown micritic dolomite matrix; angular fragments; discontinuous angular fractures; tight; scattered pinpoint vugs "
 4749.0,4799.75,50.75,"4749.0; 4799.75; Core 28 "
 4749.3,4750.0,0.6999999999998181,"4749.3; 4750.0; 10YR4/2; dark yellowish brown; micritic dolomite; finely crystalline; discontinuous wavy bedding; sharp contact "
 4750.0,4751.0,1.0,"4750.0;  4751.0; 10BG5/1; greenish gray; micritic dolomite; abundant vugs; several  discontinuous fracture with solution along fracture; salt staining; sharp contact "
 4751.0,4751.5,0.5,"4751.0; 4751.5; 10YR6/2; light yellowish brown; medium grained oolite; estimated 10% intergranular porosity; sharp contact "
 4751.5,4753.0,1.5,"4751.5; 4753.0; 10YR6/2; light yellowish brown; finely crystalline; micritic dolomite; mottled with light blue gray fine; anastamosing shale laminae; tight; sharp irregular contact "
 4753.0,4756.0,3.0,"4753.0; 4756.0; 5B5/1; medium bluish gray; finely crystalline dolomite; micritic; mottled; abundant mm to cm irregular vugs; discontinuous angular fractures with partial cement; sharp contact4 "
 4756.0,4757.0,1.0,"4756.0; 4757.0; 10YR6/2; light yellowish brown; micritic dolomite; horizontal laminations and wisps of 5B 5/1 medium bluish gray shale; cryptoalgal; sheet cracks and curved upturned mudcracks; very sharp irregular contact with 1 bluish gray shale "
 4757.0,4758.3,1.300000000000182,"4757.0; 4758.3; 10YR6/2; light yellowish brown; breccia with large clasts; clasts are angular and fitted; some boundaries are highlighted by solution enhanced margins; sylolites are 5B5/1 bluish green; chert lens at 4758; bluish green stylolite at sharp irregular contact "
 4758.3,4760.6,2.300000000000182,"4758.3; 4760.6; 10YR7/2; light gray; dense; finely crystalline micritic dolomite; sharp contact "
 4760.6,4761.0,0.3999999999996362,"4760.6; 4761.0; 5N medium gray; chert; micritic; faint wispy horizontal lenses; fine speckled lighter gray "
 4761.0,4771.0,10.0,"4761.0; 4771.0; 10YR6/2; light yellowish brown; medium crystalline dolomite; medium to course peloids; faint laminations of dark gray argillacious; scattered irregular vugs; some low angle lamintions and wavy bedded enhanced by stylolites; 5B5/1 medium blueish green;  inclined bedding; disrupted laminated bedding at 64-65; brecciation at 4764.5 to 4766.7; wavy bedding ; sharp contact sylolite enhanced irregular contact "
 4771.0,4774.0,3.0,"4771.0; 4774.0; 5B5/1; medium bluish gray; finely crystalline dolomite; micritic;  alternating beds of packstone with mouldic pores; centimeters-thick lenses of darker gray and brown; thin stratiform vugs of mm-size within these various lenses; disrupted; cm-thick intervals with rounded micritic clasts; common vertical fractures that are bedding constrained; 4773 to 4772.7 is a cm-size angular breccia with pinkish coarse dolomite clasts in gray micrite with scattered discontinuous fractures which are dissolution enhanced open; 5B5/1 medium bluish gray stylolitic contact "
 4774.0,4775.6,1.6000000000003638,"4774.0; 4775.6; 10YR7/2; light gray; dense; finely crystalline micritic dolomite; subhorizontal mm scale bedding; distinguished by alternations with mud and fine pellet mudstone; distinct irregular fractures limited to bedding; sharp contact "
 4775.6,4778.7,3.0999999999994543,"4775.6; 4778.7; 5GY6/1; greenish gray; medium crystalline dolomitic mudstone; scattered mm to cm sub-horizontal vugs; disrupted crinkly bedding disrupted with cm relief; crypto-algal structure; sharp irregular contact with brecciation and clay stylolite "
 4778.7,4779.0,0.3000000000001819,"4778.7; 4779.0; 5GY6/1; greenish gray; argillaceous dolomitic mudstone; finely crystalline; dense; sharp boundary "
 4779.0,4779.5,0.5,"4779.0; 4779.5; 5GY6/1; greenish gray; dolomitic mudstone; finely crystalline; dense; creamy brown; autoclastic breccia clasts are angular but fitted; sharp boundary "
 4779.5,4781.0,1.5,"4779.5; 4781.0; 5GY6/1; greenish gray; argillaceous mudstone; increased gamma ray on log; dense,  non-porous, occasional mm sub-horizontal; poorly bedded at mm-to-cm-scale; disrupted crinkly bedding; sharp irregular stylolitic contact "
 4781.0,4783.0,2.0,"4781.0; 4783.0; 10YR6/2; light yellowish brown; medium crystalline dolomitic mudstone; scattered mm to cm sub-horizontal vugs; disrupted crinkly bedding for 6 inches with disrupted with cm relief; algal structure; gradational contact "
 4783.0,4785.0,2.0,"4783.0; 4785.0;  10YR6/2; light yellowish brown; finely crystalline muddy dolomite; dense,  non-porous, occasional mm sub-horizontal; poorly bedded at mm-to-cm-scale; top has clasts a cm below contact with cm-size rounded clasts of dolomitic mudstone; thin greenish gray mudstone layer at sharp contact "
 4785.0,4788.0,3.0,"4785.0; 4788.0; 10YR6/2; light yellowish brown; medium crystalline dolomitic mudstone; common mm to cm sub-horizontal vugs dissolution enhanced and inter-crystalline porosity; micritic; irregular bedded at mm-to-cm-scale; disrupted crinkly bedding disrupted with cm relief; algal structure; greenish gray stylolite coating at sharp contact "
 4788.0,4790.2,2.199999999999818,"4788.0; 4790.2; 5GY6/1; greenish gray; peloidal packstone; distinctly bedded; mm-to-cm-scale alternating laminated low-angle bedding; some beds separated by shale seams; occasional fine peloid molds in some intervals; sharp horizontal contact "
 4790.2,4792.2,2.0,"4790.2; 4792.20; 5GY6/1; greenish gray; poorly bedded; many small pin-point vugs (peloidal packstone); few faint sub-horizontal cm-thick discontinuous greenish shale carbon, large vug partially filled with interlocking dolomite, sharp horizontal contact "
 4792.2,4793.5,1.300000000000182,"4792.2; 4793.5; 5Y6/1; light olive gray; very finely crystalline dolomite; micritic; muddy lithology that has been dolomitized; @ 4793' large (fist-sized) vug filled with cm-size baroque dolomite rhombs; cm relief at contact with greenish gray stylolite coating at sharp irregular contact "
 4793.5,4795.0,1.5,"4793.5; 4795.0; 10YR6/2; light yellowish brown; finely crystalline peloidal packstone dolomite; cm-scale faint inclined bedding; intermediate with many small pin-point vugs (peloidal packstone); sharp contact "
 4795.0,4797.8,2.800000000000182,"4795.0; 4797.8; 10YR6/2; light yellowish brown; finely crystalline dolomite; micritic;  centimeters-thick lenses of darker gray and brown; thin stratiform vugs of mm-size within these various lenses (fenistrate vugs, solution enhanced); common vertical fractures that are bedding constrained; vugs partially filled with clear rhombs; stylolitic contact "
 4797.8,4798.3,0.5,"4797.8; 4798.30; 5Y6/1; light olive gray; very finely crystalline dolomite; micritic; scattered pyrite; muddy lithology that has been dolomitized; gray wispy shale; common small discontinuous vertical fractures; tight; occasional horizontal vug 0.1 x 1.5; top irregular sharp stylolitic contact "
 4799.75,4819.9,20.149999999999636,"4799.75; 4819.9; Core 29 "
 4800.1,4801.3,1.199999999999818,"4800.1; 4801.3; 10YR7/2; light gray; grained pellet packstone dolomitic; dominated by pinpoint vugs to cm-size dominant; cm-sized and through-going vugs; very few small vugs; vugs are filled with baroque dolomite; sharp contact "
 4801.3,4807.0,5.699999999999818,"4801.3; 4807.0; 10YR7/2; light gray; packstone; dense; isolated large subvertical cavernous fist sized vugs at 4807.4, 4806.5, 4806.,7 4805.4; very few small vugs; vugs are filled with druzy quartz; sharp contact "
 4807.0,4808.4,1.3999999999996362,"4807.0; 4808.4; 10YR 7/2; light gray; micritic dolomitic mudstone; pyrite clusters mm-sized; fossil fragments (crinoids?); sharp contact "
 4808.4,4816.0,7.600000000000364,"4808.4; 4816.0; 10YR7/2; light gray; packstone; dense; has bedding with vugs cm-sized subhorizontal along bedding and occasional discontinuous vertical fracture; darkened grains and darkened clasts;  early cavities are filled with the darkened clasts and fine debris (crinoid and skeletal debris?); sharp contacts "
 4816.0,4818.6,2.600000000000364,"4816.0; 4818.6; 10YR7/2; light gray; micritic dolomitic mudstone; clean; dense; indistinct bedding; high angle to horizontal bedding; bedding alternates; sharp contacts; "
 4900.0,4900.0,-999.25,"4818.6 4900.0; NO RECOVERY "
 4818.6,4830.0,11.399999999999636,"4818.6; 4830.0; Dolo, tan, f-med xln, with lots of up hole sh from tripping in-out "
 4830.0,4850.0,20.0,"4830.0; 4850.0; Dolo, tan, f-med xln, hrd, dns, scrtd vuggy poro, fract, lots of uphole, blk & grn sh "
 4850.0,4864.0,14.0,"4850.0; 4864.0; Dolo, lt crm, f xln, oolitic, fractured, qrtz filling, rexln, qrtz & euhedral dolo, (fracture filling), ns "
 4864.0,4884.0,20.0,"4864.0; 4884.0; Dolo, wht-crm, vf xln, hrd, fractured, scrtd qrts grains, med-coarse grain, clr, fractured,ns "
 4884.0,4900.0,16.0,"4884.0; 4900.0; Dolo, tan-lt tan, f-med xln, soft, scrtd vuggy poro., few well rndd qrtz grains, fair-gd poro, ns "
 4900.0,4959.0,59.0,"4900.0; 4959.0; Core 30 "
 4900.0,4900.7,0.6999999999998181,"4900.0; 4900.7; 10YR7/2; light gray; tight; argillaceous wackestone; wispy shale laminae sub horizontal;  sharp boundary "
 4900.7,4902.0,1.300000000000182,"4900.7; 4902.0;  10YR7/2; light gray; grained pellet packstone dolomitic; dominated by pinpoint vugs to cm-size dominant; packstone alternating with more argillaceous sub horizontal cm-scaled bedding; poor to fair porosity; occasional short discontinuous fractures solution enhanced; sharp contact "
 4902.0,4902.4,0.3999999999996362,"4902.0; 4902.4; 10YR7/2; light gray; tight; argillaceous wackestone; wispy shale laminae sub horizontal;  sharp boundary "
 4902.4,4903.3,0.9000000000005457,"4902.4; 4903.3; 10YR7/2; light gray; grained pellet packstone dolomitic; dominated by pinpoint vugs to cm-size dominant; packstone alternating with more argillaceous sub horizontal cm-scaled bedding; fracture through core at 4903.1; poor to fair porosity; sharp contact "
 4903.3,4903.4,0.0999999999994543,"4903.3; 4903.4; 10YR7/2; light gray; tight; argillaceous wackestone; indistinct bedding; sharp boundary "
 4903.4,4907.0,3.600000000000364,"4903.4; 4907.0; 10YR7/2; light gray; medium- grained pellet packstone dolomitic; pinpoint vugs to cm-size dominant; cm-bedded; packstone alternating with more argilliceous subhorizontal cm-scaled bedding; reactivation surfaces with cross-stratification; pinpoint vugs along bedding; porosity is fair to poor; sharp contact "
 4907.0,4908.6,1.6000000000003638,"4907.0; 4908.6; 5Y6/1; light olive gray; sandy dolomite; quartz sand mixed with carbonate mud; dolomite cement; tight; many wisps of clay; siliciclastic mix; gradational contact "
 4908.6,4909.3,0.6999999999998181,"4908.6; 4909.3; 5Y6/1; light olive gray; porcelain chert; displacing fabric; autoclastic breccia; replacment; pinpoint vugs; mottled; abruptly sharp irregular contact "
 4909.3,4913.8,4.5,"4909.3; 4913.8; 10YR7/2; light gray; medium- grained pellet packstone dolomitic; low angle cross bedding to horizontal;  more argillaceous interbeds; pinpoint and cm vugs but overall poor porosity; "
 4913.8,4923.0,9.199999999999818,"4913.8; 4923.0; 10YR7/2; light gray; medium wackstone to packstone dolomitic; strings of pinpoint vugs following bedding; scattered cm-size vugs; poor to fair porosity; subhorizontal bedding; 4923 to 4921 has significant irregular large vugs crosscutting the core regular to subhorizontal; no visible autoclasts; scattered vertical fractures (solution enhanced?); above 4918.5 has pinpoint and scattered cm-size vugs subhorizontal;  4918-4918.5 has large irregular vug in addition to others and also has some discontinuous vertical fractures; sharp contact "
 4923.0,4924.3,1.300000000000182,"4923.0; 4924.3; 10YR7/2; light gray; more argillaceous; fine wackstone dolomitic; tight; isolated cm-size vug; sharp contact "
 4924.3,4928.0,3.699999999999818,"4924.3; 4928.0; 10YR7/2; light gray; medium wackstone to packstone dolomitic; cm-size low angle bedding; alternating beds of coarser and finer; strings of pinpoint vugs following bedding; scattered cm-size vugs; poor to fair porosity; subhorizontal bedding; occassional large vug at 4926.4; sharp contact "
 4928.0,4928.3,0.3000000000001819,"4928.0; 4928.3; 10YR7/2; light gray; more argillaceous; fine wackstone dolomitic; tight; isolated cm vugs; sharp contact "
 4928.3,4929.8,1.5,"4928.3; 4929.8; 10YR7/2; light gray; medium to fine wackstone to packstone dolomitic; cm-size low angle bedding; alternating beds of coarser and finer; strings of pinpoint vugs following bedding; scattered cm-size vugs; poor to fair porosity; sharp contact "
 4929.8,4931.2,1.3999999999996362,"4929.8; 4931.2; 10YR7/2; light gray; fine argillaceous wackstone; low angle bedding; cm-size bedding with shaly boundaries; fewer vugs; sharp contact "
 4931.2,4932.3,1.1000000000003638,"4931.2; 4932.3; 10YR7/2; light gray; ; medium to fine wackstone to packstone dolomitic; more vuggy; sharp contact "
 4932.3,4934.3,2.0,"4932.3; 4934.3; 10YR7/2; light gray; medium to fine wackstone to packstone dolomitic; wispy shales; cm-size bedding horizontal; scattered vugs; sub-cm beads of vugs following bedding; sharp contact "
 4934.3,4936.5,2.199999999999818,"4934.3; 4936.5; 10YR7/2; light gray ; medium to coarse-grained peloidal packstone; multi-cm sized vugs; cm-size vugs along bedding; fracture cross cutting core at 45 with significant solution enhancement;  sharp contact "
 4936.5,4938.3,1.800000000000182,"4936.5; 4938.3; 10YR7/2; light gray; fine-grained wackestone; more argillaceous; tight; wispy shale laminations; "
 4938.3,4942.2,3.899999999999636,"4938.3; 4942.2; 10YR7/2; light gray; alternating cm-thick bedding, undulating bedding; medium-grained packstone interbedding with more micritic; "
 4942.2,4943.3,1.1000000000003638,"4942.2; 4943.3; 5Y6/1; light olive gray; more argillaceous; less porous; wackestone; dispersed argillaceous; slight incipient brecciation "
 4944.3,4950.5,6.199999999999818,"4944.3; 4950.5; 10YR7/2; light gray; medium to coarse-grained peloid packstone; cm-size bedding; cross to planar bedding; pinpoint vugs; enhanced interpartical porosity; up to cm-scale vugs; irregular and subhorizontal vugs tied to bedding; 4946.5-4945 is all pinpoint and enhanced interparticle vugs; 4949-4946.9 is particularly large cm-sized vugs; large vug at 4948.5; sharp contact "
 4950.5,4952.2,1.699999999999818,"4950.5; 4952.2; 10YR7/2; light gray; tight; low-angle cross stratification; medium-grained peloidal packstone with scattered argillaceous seams; sharp contact "
 4953.4,4954.5,1.1000000000003638,"4953.4; 4954.5; 10YR7/2; light gray; vertical irregular fracture cross cuts core; significant solution enhancement along cm-size vugs extending along and intercepting fracture; scattered sub-cm vugs up to cm-size; cm-scale interbedding dipping slightly; vugs limited to more peloid rich intervals; "
 4954.5,4955.7,1.199999999999818,"4954.5; 4955.7; 10YR7/2; light gray; cross stratification; cm-bedding; high angle truncation; no brecciation; more argillaceous 54.7-55 argillaceous with limited vugs; 4955-4954.7 poor porosity scattered vugs; sharp contact "
 4955.7,4956.6,0.9000000000005457,"4955.7; 4956.6; 10YR7/2; light gray; nodular packstone; diminished vugs; more argillaceous; tight "
 4959.0,4986.5,27.5,"4959.0; 4986.5; core 31 "
 4956.6,4959.3,2.699999999999818,"4956.6; 4959.3; 5Y6/1; light olive gray; medium grained peloidal packstone; alternating units with finer more argillaceous units; more uniform; cm-size and pinpoint vugs; less vugs more evenly distributed in bands related to bedding; pinpoint and interparticle porespace; 4959 has a large vug lined by medium crystals of baroque dolomite; good porosity; "
 4964.0,4967.3,3.300000000000182,"4964.0; 4967.3; 5Y6/1; light olive gray; medium grained dolomitic packstone;  is more argillaceous which limits extent of solution cavities; scattered subvertical fractures; 4964 is more argillaceous and no vugs with angular cross stratification and packstone intervals; 4963.3 large vug cross cuts core; incipient brecciation from 4965.7 to 4967.2; incipient brecciation from 4964.2 to 4963.3; 4959.7 to 4960.3 solution vug and brecciation with solution enhancement around clasts discontinuous subvertical fractures; 4959 to 4959.3 argillaceous and no vugs; gradational contact "
 4967.3,4969.8,2.5,"4967.3; 4969.8; 5Y6/1; light olive gray; medium grained packstone dolomite; less vugs than below; more intact; more argillaceous than below; argillaceous seams; less solution activity; vugs are irregular cm-size subhorizontal; 4968.5 is a vertical pipe cm-sized vug; gradational contact "
 4969.8,4979.3,9.5,"4969.8; 4979.3; 5Y6/1; light olive gray; with blue gray clasts of darker medium grained wackestone to packstone dolomite; cm-size alternating bedding; overall pinpoint vugs; some incipient brecciation; gradational contact "
 4979.3,4986.5,7.199999999999818,"4979.3; 4986.5; 5Y6/1; light olive gray; autoclastic breccia; recrystallized cavities; mottled; light gray coarse dolomite with gray matrix fill of irregular vugs; extensively solution altered; baroque dolomite lines cavities and fills cavities; very high permeability (flow unit); many discontinuous oblique subvertical fractures; decreased argillaceous content; gradational contact "
 4986.5,4997.7,11.199999999999818,"4986.5; 4997.7; 5Y6/1; light olive gray; argillaceous finely crystalline dolomite; silty; tight; small sub-cm vugs; 4995 to 4996 has subhorizontal to irregular vugs cm-sized open; autoclastic brecciation of a dolomitic mudstone; appears that the clasts are being selectively dissolved?; subhorizontal solution vugs crosscut the core at 4993, 4993.5, 4993.7,4992; several-cm size vug cuts across core at 4991 and 4989.1; 4989.5 to 4988.5 argillaceous micritic dolomite with cm-size vugs with chalky white filling; 4988.5 to 4986.5 incipient autoclastic brecciation with disruptive subhorizontal vugs with pelleted packstone on reactivated surfaces and gradational contact; "
 4986.5,4998.0,11.5,"4986.5; 4998.0; Core 32 "
 4997.7,5049.7,52.0,"4997.7; 5049.7; NO RECOVERY "
 4997.7,5030.0,32.30000000000018,"4997.7; 5030.0; Dolo. f-crs xln, hrd, dns, fractured, intervals of 1 thick fresh wht chert, fracture filled f grain qrtz xln and thin lyrs of qrtz, & euhedral dolo, ns "
 5030.0,5049.7,19.699999999999818,"5030.0; 5049.7; Dolo, off wht-lt tan, f-crs xln, hrd, dns, fresh, euhedrel dolo xln & some clr well rndd qrtz grains, vuggy poro, fractured, thin lyrs of lt grn sh "
 5049.7,5052.9,3.199999999999818,"5049.7; 5052.9; 5Y6/1; light olive gray; argillaceous finely crystalline dolomite; silty; tight; small sub-cm vugs; soft chalky white material and quart along a subhorizontal solution zone at 5050 smaller vugs lined with quartz "
 5050.0,5083.25,33.25,"5050.0; 5083.25; Core 33 "
 5052.9,5057.0,4.100000000000364,"5052.9; 5057.0; 5Y4/1; olive gray; very finely argillaceous crystalline dolomite; massive; vuggy; extensive dissolution around clasts and filling with coarse dolomite and coarse dogtooth calcite; darkened clasts in a autoclastic breccia; sharp boundary "
 5057.0,5058.0,1.0,"5057.0; 5058.0; 5Y4/1; olive gray; extensive dissolution with what appear to be clasts of autoclastic breccia; crinkly thin ablated laminations; vugs and silicified area looks stromatolitic; sharp contact "
 5058.0,5080.0,22.0,"5058.0; 5080.0; 5Y4/1; olive gray; solid argillaceous finely crystalline micritic dolomite; stylolites; occasional cm-bedded with shale; contact at 5075.6 is transitional with clasts from below being incorporated into overlying packstone; 5074 to 5075 packstone has a moderate amount of vugs and pinpoint and interparticle porosity resulting in fair porosity; 5073.8 to 5073.5 is more of a pelleted packstone with vugs subhorizontal with good porosity; 5072-5072.6 subhorizontal vugs in mottled micritic dolomite; 5070.25 scattered vugs subhorizontal cuts through core and lined with fine to crystalline pink saddle dolomite;  scattered vugs to 5069 following subparallel bedding; 5067-5067.8 is vuggy subparallel to bedding including inclined bedding and has some darker and lighter bands; incipient autoclastic brecciation 5067.5 to 5066.5; vugs moderately abundant at 5066.7-5066.8 and have some white fine grained material partially occluding them; 5056-5058 have varying amounts of brecciation in intervals of incipient brecciation alternating with vuggy cleaner dolomite subhorizontal vugs with some vugs cutting through the entire core with filling between clasts of micritic dolomite; intervals with more shale have fewer vugs; sharp boundary "
 5080.0,5083.25,3.25,"5080.0; 5083.25; N8; very light gray; tightly cemented; sandy dolomite; massive; tight; grades up to argillaceous dolomite with gray wispy shale laminations up to 5080; 80-80.5 is an autoclastic breccia with large vugs and cm-sized coarse dolomite fill; very low porosity other than vugged area; sharp contact "
 5083.25,5092.0,8.75,"5083.25; 5092.0; 5Y4/1; olive gray; medium sand scattered with medium sized dolomitic peloid packstone; massively bedded; shaly wispy laminations every 5 cm or so; uniform and clean; subhorizontal vugs abundant; at 5085 is vuggy cm-sized vertical and horizontal and lined with dolomite and at 5084 is vuggy cm-sized vug filled with euhedral clear quartz; appears these zones are less argillaceous; sharp boundary "
 5084.0,5144.0,60.0,"5084.0; 5144.0; Core 34 "
 5092.0,5098.7,6.699999999999818,"5092.0; 5098.7; 5Y4/1; olive gray; medium peloidal dolomite packstone; wackestone; clean; uniform; indistinct bedding; occasional shale lens; scattered subhorizontal oriented cm-size vugs; dolomite lining the vugs; baroque dolomite; poor to fair porosity; top foot is incipient autoclastic breccia with substantial dissolution along fragment boundaries and dolomite crystals lining the vugs at 5092; sharp contact "
 5098.7,5100.8,2.100000000000364,"5098.7; 5100.8; 5Y4/1; olive gray; dolomite cemented sandstone; poorly sorted; dark gray matrix of dolomitic mud; increasing mud dolostone to wackestone as you go upwards; scattered shaly argillaceous intervals; discontinuous; cleaner sand at the bottom has numerous sub-cm vugs; subvertical discontinuous fractures; moderate porosity from 5097-5098.5; gradational contact "
 5100.8,5101.3,0.5,"5100.8; 5101.3; 5Y4/1; olive gray; incipient autoclastic breccia; silicified; cm-size vugs; disrupted bedding; vugs formed in spaces around clast edges; selective silicification of clasts; sharp contact "
 5101.3,5103.2,1.8999999999996362,"5101.3; 5103.2; 5B7/1; light bluish gray; dolomitic mudstone; scattered vugs sub-cm-scale and subparallel to bedding; few vertical fractures discontinuous; poor porosity; sharp contact "
 5103.2,5112.5,9.300000000000182,"5103.2; 5112.5; 5Y4/1; olive gray; fine pelleted dolomite; interparticle porosity; pinpoint vugs; poor porosity;; micritic dolomite; bioturbated; muddier upwards; silty peloid dolomite argillaceous matrix; 5108.8 has irregular twisting nodules along subhorizontal beds; voids filled with dolomite; mottled with anastamozing clay; gradational contact "
 5112.5,5116.0,3.5,"5112.5; 5116.0; N3; dark gray; silty gray dolomite; no bedding; massive dolomite with no shale laminations; irregular vugs cm-sized; discontinuous vertical fractures with no dissolution enhancement; moderate porosity; gradational contact "
 5116.0,5119.0,3.0,"5116.0; 5119.0; N3; dark gray peloidal packstone; scattered vugs; pinpoint interparticle to cm size vugs subhorizontal following faint cm-scale bedding following peloidal; solution dissolution; some vugs are mostly occluded with coarse dolomite larger ones being rimmed; gradational contact "
 5119.0,5128.0,9.0,"5119.0; 5128.0; N3; dark gray; fine to medium wackestone to packstone grainstone; possible bivalves; occasional/sparse  vug filled with dolomite; tight; no fractures; gradational contact "
 5128.0,5143.4,15.399999999999636,"5128.0; 5143.4; 5Y4/1; olive gray; sandstone with micritic dolomite matrix; frosted grains; medium grade; rounded; increasing amounts of dolomite mud towards the top; bivalves; bioturbated; sm-scale mottling; scattered black lithoclasts; patchy vugs filled with pink dolomite; porous towards the bottom couple feet; gradational contact; boundary "
 5140.0,5140.0,-999.25,"5140.0; Lamotte (Reagan) Sandstone "
 5140.0,5179.0,39.0,"5140.0; 5179.0; Core 35 "
 5143.4,5147.7,4.300000000000182,"5143.4; 5147.7; 5Y4/1; olive gray; argillaceous fine-grained peloid wackestone;  some stratification, clay seams horizontal; cm-size bedding and variations in color; sharp contact "
 5147.8,5149.7,1.8999999999996362,"5147.8; 5149.7; olive gray; 5Y4/1; fine to medium packstone; microporosity; some interparticle porespace; some small vugs; scattered; bioturbated; sharp boundary "
 5149.7,5154.0,4.300000000000182,"5149.7; 5154.0; greenish gray 5G6/1; fine argillaceous wackestone packestone; grades up to poorly sorted medium to fine grained bioclastic wackestone to packstone; cm-size alternating beds; wispy dispersed argillaceous clay; sharp boundary "
 5154.0,5163.7,9.699999999999818,"5154.0; 5163.7; 5Y6/1; light olive gray; fine to medium wackestone to mudstone and peloidal grainstone; cm-size alternating beds of fine pellet and coarser pellet; beds are moderately inclined; tight; partial discontinuous fractures with no solution enhancement; no vugs; gradational contact to skeletal packstone to wackestone cm-thick beds with shaly clay rich intervals and darkened shell fragments (brachiopods?); grading upwards to coarse grained packstone with blackened carbonate grains peppered with small white bivalve fragments; cm-scale bedded from fine to coarse distinguished by changes in grain-size; no porosity "
 5163.7,5163.7,-999.25,"5163.7; Granite "
 5163.7,5165.8,2.100000000000364,"5163.7; 5165.8; very light gray N8 and dark gray N3; granite; lot of quartz and muscovite in place; more degraded; in situ weathered but a lot more clay; degraded orthoclase; sharp boundary "
 5165.8,5173.0,7.199999999999818,"5165.8; 5173.0; 5YR7/2 grayish orange pink mixed with N3 dark gray; granite; weathered; patches of orthoclase and alteration around it; top of C horizon; sharp boundary "
 5173.0,5178.75,5.75,"5173.0; 5178.75; 5R5/4; moderate red; granite; epidote dark yellowish green 10GY4/4 along natural fractures; unweathered;  sharp boundary "
 5178.75,5200.0,21.25,"5178.75; 5200.0; Granite, pink, feldspar, med-crs xln, wht, plagioclase feldspar, med-crs xln hrd, dns, mica, biotite, some muscovite "
 5200.0,5238.0,38.0,"5200.0; 5238.0; Granite, pink, feldspar, med-crs xln, wht, plagioclase feldspar, med-crs xln hrd, dns, mica, biotite, some muscovite "

~IQ_Las_Parameter
#MNEM    .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 DEPT    .F           SELECTED  : Depth                          
 TENS    .LB                    : Tension                        
 RXRT    .RATIO                 : Rxo/Rt ratio                   
 RXO     .RATIO                 : Rxo/Rt ratio                   
 AHT90   .OHM-M       SELECTED  : Array Induction Resistivity-90 
 AHT60   .OHM-M       SELECTED  : Array Induction Resistivity-60 
 AHT30   .OHM-M       SELECTED  : Array Induction Resistivity-30 
 AHT20   .OHM-M       SELECTED  : Array Induction Resistivity-20 
 AHT10   .OHM-M       SELECTED  : Array Induction Resistivity-10 
 RT      .OHM-M       SELECTED  : Deep Resistivity               
 RMUD    .ohmm                  : RMUD                           
 RHOB    .GM/CC       SELECTED  : Bulk Density                   
 QN      .NONE                  : NearQuality                    
 QF      .NONE                  : FarQuality                     
 PE      .BARNS/E     SELECTED  : Photoelectric factor           
 NPHS    .PU                    : Neutron porosity               
 NPHL    .%                     : Neu Por Lime                   
 NPHI    .PU          SELECTED  : Neutron porosity               
 NPHD    .PU                    : Neutron porosity               
 DRHO    .GM/CC       SELECTED  : Bulk Density Correction        
 DPHS    .PU                    : Density porosity               
 DPHI    .PU                    : Density porosity               
 DPHD    .PU                    : Density porosity               
 DLIM    .%                     : DenPhiLime                     
 CT90    .mmo/m                 : 90in Conductivity 2ft Res      
 CALI    .IN          SELECTED  : Caliper                        
 MINV    .OHM-M       SELECTED  : Micro Inverse Resistivity      
 MNOR    .OHM-M       SELECTED  : Micro Normal Resistivity       
 GR      .API         SELECTED  : Gamma Ray                      
 GRTO    .API                   : Gamma Ray                      
 GRTC    .api                   : GammaKT                        
 POTA    .%           SELECTED  : Potassium Concentration        
 URAN    .PPM         SELECTED  : Uranium Concentration          
 THOR    .PPM         SELECTED  : Thorium Concentration          
 TURT    .NONE                  : RatioThorUran                  
 UKRT    .NONE                  : RatioUranPota                  
 TKRT    .NONE                  : RatioThorPota                  
 NOIS    .cps                   : SpectralNoise                  

~ASCII
# DEPT TENS RXRT RXO RT90 RT60 RT30 RT20 RT10 RT RMUD RHOB QN QF PE NPHS NPHL NPHI NPHD DRHO DPHS DPHI DPHD DLIM CT90 CALI MINV MNOR GR GRTO GRTC POTA URAN THOR TURT UKRT TKRT NOIS
 580.0000,1805.8065,-0.3677,2.4798,87.9060,54.6849,27.6935,14.6555,6.7422,87.9060,0.2535,2.2575,0.1663,-0.4282,7.6823,36.5449,31.7902,31.7902,29.1336,-0.1974,23.7881,26.4622,32.7542,26.4622,11.3758,4.5000,0.3179,0.1996,35.7831,27.6872,12.7333,0.4200,2.3883,2.1893,0.9167,5.6859,5.2120,0.0000
 580.5000,1801.3383,-0.3677,2.6072,99.1564,58.9579,29.2923,14.8604,6.9036,99.1564,0.2535,2.2306,-0.2244,-0.1238,7.6123,38.2083,33.5168,33.5168,30.7200,-0.2133,25.4192,28.0361,34.1934,28.0361,10.0851,4.5000,0.3171,0.1999,39.3911,30.4092,14.0487,0.4635,2.6093,2.4152,0.9256,5.6297,5.2110,0.0000
 581.0000,1811.3805,-0.3677,3.1475,141.0627,78.1609,37.6383,18.1430,8.6243,141.0627,0.2535,2.2028,-0.2051,0.1057,7.5007,39.8988,35.2864,35.2864,32.3404,-0.2289,27.1055,29.6632,35.6813,29.6632,7.0890,4.5000,0.3165,0.1990,42.3487,32.9018,14.9807,0.4979,2.8406,2.5578,0.9004,5.7047,5.1366,1.6000
 581.5000,1828.4485,-0.3677,3.9566,244.2260,123.3665,56.7806,25.6677,12.5092,244.2260,0.2535,2.1726,0.1235,0.3942,7.3829,40.0667,35.4631,35.4631,32.5019,-0.2452,28.9318,31.4254,37.2928,31.4254,4.0946,4.5000,0.3164,0.2005,46.1798,34.1232,15.3487,0.5098,2.9517,2.6223,0.8884,5.7896,5.1434,1.6000
 582.0000,1836.9476,-0.3677,4.9928,545.4106,229.6292,96.4031,38.2942,18.5034,545.4106,0.2535,2.1381,0.0335,0.2252,7.3340,40.1290,35.5286,35.5286,32.5617,-0.2617,31.0258,33.4459,39.1404,33.4459,1.8335,4.5000,0.3168,0.2026,48.1221,33.7650,14.9483,0.4923,2.9456,2.5737,0.8737,5.9828,5.2275,1.6000
 582.5000,1791.1577,-0.3677,7.1161,996.3033,403.0415,162.6398,63.5472,25.2190,996.3033,0.2535,2.1135,-0.2969,-0.1665,7.3258,40.2188,35.6231,35.6231,32.6481,-0.2751,32.5145,34.8824,40.4539,34.8824,1.0037,4.5000,0.3172,0.2044,46.0611,31.7446,13.9158,0.4540,2.7889,2.4166,0.8665,6.1434,5.3234,0.0000
 583.0000,1809.7227,-0.3677,8.1323,1183.6014,476.3665,190.2838,74.1174,25.8351,1183.6014,0.2535,2.0981,-0.1464,-0.2162,7.2656,41.5473,37.0266,37.0266,33.9286,-0.2871,33.4513,35.7863,41.2805,35.7863,0.8449,4.5000,0.3176,0.2063,42.9376,29.1660,12.5818,0.4054,2.5986,2.2090,0.8501,6.4101,5.4492,1.0000
 583.5000,1824.4176,-0.3677,4.8618,1064.2986,342.7133,133.0200,48.5241,16.8107,1064.2986,0.2535,2.0904,0.2479,-0.1798,7.3437,42.7398,38.2943,38.2943,35.0824,-0.2977,33.9129,36.2318,41.6879,36.2318,0.9396,4.5000,0.3176,0.2073,40.9034,27.0818,11.5674,0.3707,2.4270,2.0405,0.8407,6.5475,5.5047,0.0000
 584.0000,1839.9539,-0.3677,2.7082,863.3383,215.6626,82.7477,28.9685,10.4530,863.3383,0.2535,2.0916,0.2973,-0.2827,7.6153,42.2529,37.7758,37.7758,34.6108,-0.3064,33.8397,36.1611,41.6233,36.1611,1.1583,4.5000,0.3181,0.2086,39.3741,26.4083,11.1278,0.3535,2.3872,1.9778,0.8285,6.7535,5.5952,0.0000
 584.5000,1836.7058,-0.3677,1.7874,713.3790,145.2916,55.6680,19.2474,7.2081,713.3790,0.2535,2.0932,-0.0116,-0.2490,7.8786,40.6532,36.0810,36.0810,33.0662,-0.3190,33.7425,36.0673,41.5375,36.0673,1.4018,4.5000,0.3186,0.2104,38.6069,26.6744,11.2561,0.3593,2.4053,1.9925,0.8284,6.6952,5.5461,0.0000
 585.0000,1825.8224,-0.3677,1.2474,597.0483,103.5130,39.7177,13.7390,5.2063,597.0483,0.2535,2.0975,-0.1924,0.2722,7.9863,40.4806,35.8989,35.8989,32.9000,-0.3326,33.4872,35.8209,41.3122,35.8209,1.6749,4.5000,0.3186,0.2110,37.8289,27.3734,11.6216,0.3790,2.4636,2.0186,0.8194,6.4994,5.3254,2.0000
 585.5000,1845.2162,-0.3677,0.8776,452.3264,74.4842,28.7834,10.0623,3.8209,452.3264,0.2535,2.1009,0.1827,0.4920,7.9454,38.0694,33.3721,33.3721,30.5872,-0.3408,33.2785,35.6195,41.1280,35.6196,2.2108,4.5000,0.3191,0.2122,37.1615,28.3510,12.1753,0.4063,2.5366,2.0711,0.8165,6.2429,5.0972,1.6000
 586.0000,1847.1057,-0.3677,0.6393,368.2639,57.4046,22.1147,7.7080,2.8930,368.2639,0.2535,2.0867,0.6148,0.3369,7.9960,38.4997,33.8207,33.8207,30.9987,-0.3493,34.1424,36.4532,41.8904,36.4532,2.7154,4.5000,0.3195,0.2138,36.8466,28.6819,12.2643,0.4205,2.5659,2.0330,0.7923,6.1020,4.8349,1.6000
 586.5000,1867.5354,-0.3677,0.4727,329.6379,48.8466,18.6842,6.4900,2.3872,329.6379,0.2535,2.0601,0.4026,0.3198,8.1104,39.5759,34.9472,34.9472,32.0302,-0.3609,35.7529,38.0072,43.3114,38.0072,3.0336,4.5000,0.3195,0.2143,35.9365,28.6711,12.3042,0.4389,2.5543,1.9588,0.7669,5.8197,4.4631,1.6000
 587.0000,1858.7483,-0.3677,0.3955,322.1204,45.2736,17.1718,5.9658,2.1450,322.1204,0.2535,2.0339,-0.2005,0.0088,7.9841,41.7453,37.2366,37.2366,34.1200,-0.3731,37.3377,39.5363,44.7097,39.5363,3.1044,4.5000,0.3195,0.2147,35.4913,28.2892,12.3394,0.4479,2.4783,1.9277,0.7778,5.5333,4.3040,0.8000
 587.5000,1851.4008,-0.3677,0.3582,324.9902,43.5909,16.4092,5.7192,2.0185,324.9902,0.2535,2.0052,-0.3714,-0.5384,7.7884,43.6192,39.2338,39.2338,35.9358,-0.3861,39.0771,41.2147,46.2445,41.2147,3.0770,4.5000,0.3194,0.2158,34.6910,28.3623,12.8853,0.4737,2.4056,1.9845,0.8249,5.0782,4.1892,1.0000
 588.0000,1869.6205,-0.3677,0.3156,321.4405,41.3343,15.4659,5.4113,1.8678,321.4405,0.2535,1.9824,-0.0658,-0.5942,7.9193,44.6542,40.3447,40.3447,36.9431,-0.4000,40.4617,42.5508,47.4662,42.5508,3.1110,4.5000,0.3193,0.2166,34.4519,29.3595,14.0253,0.5046,2.3976,2.2123,0.9227,4.7513,4.3840,2.0000
 588.5000,1861.1787,-0.3677,0.2646,307.6968,38.5135,14.3566,5.0506,1.6951,307.6968,0.2535,1.9724,0.0171,-0.2418,8.3277,47.8521,43.7932,43.7932,40.1365,-0.4144,41.0652,43.1330,47.9987,43.1330,3.2500,4.5000,0.3190,0.2172,37.9020,30.1600,14.9411,0.5260,2.3921,2.4117,1.0082,4.5480,4.5853,3.2000
 589.0000,1883.0031,-0.3677,0.2286,309.7895,37.0636,13.7388,4.8570,1.5781,309.7895,0.2535,1.9678,-0.0664,-0.0994,8.6699,44.8884,40.5969,40.5969,37.1715,-0.4254,41.3478,43.4057,48.2480,43.4057,3.2280,4.5000,0.3183,0.2178,42.4361,32.1514,16.1926,0.5565,2.5220,2.6782,1.0619,4.5323,4.8129,0.0000
 589.5000,1866.1543,-0.3677,0.2205,331.4252,37.4247,13.7739,4.8903,1.5493,331.4252,0.2535,1.9664,-0.0126,0.2135,8.7085,44.3341,40.0006,40.0006,36.6313,-0.4287,41.4305,43.4856,48.3210,43.4856,3.0173,4.5000,0.3176,0.2179,44.1554,33.4349,16.7334,0.5721,2.6373,2.7814,1.0546,4.6097,4.8616,3.2000
 590.0000,1876.2775,-0.3677,0.2269,354.7941,38.5431,14.0601,5.0026,1.5652,354.7941,0.2535,1.9616,0.1300,0.3335,8.6212,42.9605,38.5297,38.5297,35.2964,-0.4293,41.7185,43.7634,48.5751,43.7634,2.8185,4.5000,0.3173,0.2185,44.0903,34.0511,16.9233,0.5814,2.6980,2.7997,1.0377,4.6403,4.8153,1.0000
 590.5000,1872.0048,-0.3677,0.2216,332.6653,38.9655,14.0979,5.0129,1.5827,332.6653,0.2535,1.9530,0.4097,-0.1629,8.6923,41.6136,37.0969,37.0969,33.9927,-0.4320,42.2403,44.2670,49.0356,44.2670,3.0060,4.5000,0.3161,0.2195,44.7969,33.8928,16.9400,0.5849,2.6664,2.7887,1.0459,4.5587,4.7678,1.0000
 591.0000,1851.1477,-0.3677,0.1971,310.3109,38.7599,13.8678,4.8962,1.5443,310.3109,0.2535,1.9489,0.5701,-0.2331,8.8044,43.7393,39.3625,39.3625,36.0526,-0.4356,42.4884,44.5064,49.2545,44.5064,3.2226,4.5000,0.3157,0.2191,45.6275,33.3205,16.9490,0.5883,2.5856,2.7757,1.0735,4.3952,4.7183,1.0000
 591.5000,1850.8025,-0.3677,0.2133,308.2825,39.1462,13.8224,4.8208,1.5080,308.2825,0.2535,1.9431,0.2165,-0.0023,8.7517,45.6847,41.4556,41.4556,37.9517,-0.4388,42.8428,44.8483,49.5672,44.8483,3.2438,4.5000,0.3171,0.2204,47.3780,33.4995,17.4929,0.6121,2.5419,2.8411,1.1177,4.1524,4.6412,0.8000
 592.0000,1838.1342,-0.3677,0.1962,314.2571,39.9004,13.8983,4.7949,1.4857,314.2571,0.2535,1.9294,-0.4314,0.0562,8.5387,46.1809,41.9908,41.9908,38.4444,-0.4425,43.6704,45.6468,50.2974,45.6468,3.1821,4.5000,0.3172,0.2221,47.2335,33.6189,17.8079,0.6310,2.5258,2.8550,1.1304,4.0028,4.5246,0.8000
 592.5000,1852.0115,-0.3677,0.1746,343.4177,41.3319,14.2070,4.8497,1.4809,343.4177,0.2535,1.9134,-0.6177,0.3272,8.2471,45.5883,41.3516,41.3516,37.8566,-0.4481,44.6396,46.5821,51.1526,46.5821,2.9119,4.5000,0.3173,0.2230,45.7292,33.2604,17.8971,0.6386,2.4634,2.8483,1.1563,3.8575,4.4603,0.0000
 593.0000,1833.4927,-0.3677,0.1637,391.9002,44.1207,14.9904,5.1067,1.5215,391.9002,0.2535,1.8991,-0.2564,0.4504,8.0020,45.2956,41.0360,41.0360,37.5691,-0.4557,45.5088,47.4208,51.9195,47.4208,2.5517,4.5000,0.3174,0.2229,44.3481,31.9077,17.3023,0.6168,2.3538,2.7562,1.1710,3.8161,4.4684,2.4000
 593.5000,1852.2994,-0.3677,0.1613,570.4072,48.8857,16.4624,5.6466,1.6195,570.4072,0.2535,1.8877,0.1319,0.1380,7.9790,45.4982,41.2545,41.2545,37.7679,-0.4629,46.1979,48.0856,52.5275,48.0857,1.7531,4.5000,0.3175,0.2232,41.0425,30.0633,16.3563,0.5824,2.2256,2.6089,1.1722,3.8216,4.4798,0.8000
 594.0000,1861.1675,-0.3677,0.1722,1012.4303,57.0695,19.0912,6.7113,1.8652,1012.4303,0.2535,1.8839,0.3222,-0.2593,8.1731,41.7823,37.2758,37.2758,34.1557,-0.4666,46.4292,48.3089,52.7317,48.3089,0.9877,4.5000,0.3164,0.2237,38.5640,29.0946,15.7864,0.5622,2.1786,2.5176,1.1556,3.8753,4.4783,0.8000
 594.5000,1842.2224,-0.3677,0.2048,1738.2188,69.4839,23.1515,8.4210,2.3761,1738.2188,0.2535,1.8857,-0.0143,-0.4876,8.3006,40.0001,35.3929,35.3929,32.4378,-0.4685,46.3219,48.2054,52.6370,48.2054,0.5753,4.5000,0.3161,0.2234,41.3227,29.4884,15.9094,0.5690,2.2367,2.5256,1.1292,3.9309,4.4387,1.6000
 595.0000,1874.0078,-0.3677,0.2362,1772.2617,83.7138,27.8825,10.2351,2.9183,1772.2617,0.2535,1.8873,-0.5158,-0.1826,8.1915,38.6796,34.0086,34.0086,31.1709,-0.4700,46.2253,48.1121,52.5517,48.1121,0.5643,4.5000,0.3158,0.2237,45.6364,30.9921,16.6344,0.6007,2.3705,2.6135,1.1025,3.9464,4.3510,0.0000
 595.5000,1866.9482,-0.3677,0.3035,1835.4924,107.7514,35.8884,13.3553,3.8724,1835.4924,0.2535,1.8835,-0.2070,0.1185,8.0111,39.9920,35.3845,35.3845,32.4300,-0.4716,46.4551,48.3339,52.7545,48.3339,0.5448,4.5000,0.3161,0.2246,46.4385,32.6764,17.7064,0.6385,2.4735,2.7862,1.1264,3.8741,4.3640,0.0000
 596.0000,1853.5895,-0.3677,0.5071,1880.5190,159.4105,53.1343,20.3431,6.1165,1880.5190,0.2535,1.8699,0.3668,-0.0290,8.0387,39.1512,34.5020,34.5020,31.6228,-0.4744,47.2785,49.1284,53.4810,49.1284,0.5318,4.5000,0.3164,0.2258,47.1416,33.3682,18.3228,0.6614,2.4892,2.8800,1.1570,3.7635,4.3544,0.0000
 596.5000,1815.7689,-0.3677,1.2483,1947.6954,250.6152,83.8763,33.7447,10.9799,1947.8284,0.2535,1.8551,0.3413,-0.1107,8.4105,39.8836,35.2705,35.2705,32.3258,-0.4793,48.1780,49.9963,54.2747,49.9963,0.5134,4.5000,0.3165,0.2259,47.6947,32.6883,18.2976,0.6540,2.3949,2.9066,1.2136,3.6618,4.4441,0.0000
 597.0000,1833.5736,-0.3677,2.9716,1955.0607,362.0154,122.3826,52.4309,19.7906,1955.2072,0.2535,1.8456,0.1443,-0.0553,8.9121,40.2680,35.6749,35.6749,32.6954,-0.4862,48.7530,50.5511,54.7821,50.5511,0.5115,4.5000,0.3162,0.2261,44.2821,31.1286,17.8373,0.6267,2.2350,2.8852,1.2909,3.5665,4.6041,2.0000
 597.5000,1821.7915,-0.3677,5.6297,1952.0442,436.1229,149.0511,66.1564,28.2882,1952.2000,0.2535,1.8398,-0.0282,0.0650,9.0940,38.8784,34.2164,34.2164,31.3613,-0.4924,49.1040,50.8898,55.0917,50.8898,0.5123,4.5000,0.3160,0.2255,40.3172,29.7079,17.3918,0.6025,2.0959,2.8535,1.3615,3.4786,4.7360,0.0000
 598.0000,1756.4919,-0.3677,7.6836,1945.2888,461.9061,158.7050,71.3296,32.6915,1945.4508,0.2535,1.8375,-0.1863,0.1068,8.8537,36.0443,31.2736,31.2736,28.6578,-0.4950,49.2445,51.0254,55.2158,51.0254,0.5141,4.5000,0.3156,0.2251,38.4070,28.2526,16.7563,0.5741,1.9645,2.7798,1.4150,3.4222,4.8425,1.0000
 598.5000,1720.0300,-0.3677,22.3483,1951.1324,547.2297,190.5468,88.8529,45.3349,1951.2999,0.2535,1.8337,-0.0929,0.1982,8.4860,35.3988,30.6093,30.6093,28.0454,-0.4946,49.4726,51.2455,55.4170,51.2455,0.5125,4.5000,0.3156,0.2252,38.1911,27.6946,16.5649,0.5647,1.9023,2.7612,1.4515,3.3685,4.8895,2.0000
 599.0000,1716.0577,-0.3677,101.4280,1996.5718,768.8342,277.1731,145.8170,101.4280,1996.7487,0.2535,1.8281,-0.0511,0.2015,8.1862,35.4282,30.6395,30.6395,28.0733,-0.4942,49.8098,51.5709,55.7146,51.5709,0.5009,4.5000,0.3159,0.2257,38.9771,27.9429,16.7072,0.5648,1.9098,2.8078,1.4702,3.3817,4.9718,0.0000
 599.5000,1794.5891,-0.3677,140.6871,2000.0000,898.9937,335.1820,188.5403,140.6871,2000.0000,0.2535,1.8246,-0.1167,-0.0619,8.0813,36.9998,32.2610,32.2610,29.5667,-0.4931,50.0268,51.7803,55.9060,51.7803,0.5000,4.5000,0.3154,0.2256,38.6381,28.3479,16.9709,0.5685,1.9303,2.8766,1.4903,3.3953,5.0600,0.0000
 600.0000,1833.9875,-0.3677,67.5427,1999.0848,746.1724,267.3349,138.8056,89.5084,1999.2559,0.2535,1.8261,-0.0940,-0.4057,8.1343,35.6453,30.8627,30.8627,28.2791,-0.4891,49.9331,51.6898,55.8233,51.6898,0.5002,4.5000,0.3151,0.2253,37.6567,29.3784,17.5817,0.5783,2.0056,3.0309,1.5112,3.4682,5.2412,1.6000
 600.5000,1851.9305,-0.3677,20.6279,1994.1814,569.8979,197.2920,93.7496,47.5785,1994.3440,0.2535,1.8352,-0.0932,-0.4564,8.1156,35.6958,30.9146,30.9146,28.3270,-0.4839,49.3790,51.1552,55.3344,51.1552,0.5015,4.5000,0.3164,0.2257,38.5819,29.8701,17.8692,0.5750,2.0560,3.1406,1.5275,3.5754,5.4616,0.0000
 601.0000,1864.9216,-0.3677,10.3345,1993.6344,502.4715,172.1031,79.5369,39.4298,1993.7866,0.2535,1.8448,-0.0366,0.0042,8.1019,37.2976,32.5697,32.5697,29.8504,-0.4796,48.8004,50.5968,54.8238,50.5968,0.5016,4.5000,0.3157,0.2256,39.9568,30.8132,18.1983,0.5719,2.1724,3.2637,1.5024,3.7985,5.7068,1.0000
 601.5000,1872.3962,-0.3677,44.5010,1992.7894,500.5230,171.4146,79.8228,44.5010,1992.9286,0.2535,1.8470,-0.0182,0.2421,8.1601,37.8754,33.1701,33.1701,30.4019,-0.4745,48.6675,50.4686,54.7066,50.4686,0.5018,4.5000,0.3156,0.2252,41.1898,31.3649,18.1594,0.5558,2.2897,3.3271,1.4531,4.1194,5.9859,0.0000
 602.0000,1884.9723,-0.3677,53.4048,1994.5940,514.5499,176.5263,83.8103,53.4048,1994.5940,0.2535,1.8369,-0.1416,-0.3313,7.8761,40.4614,35.8787,35.8787,32.8816,-0.4696,49.2789,51.0585,55.2460,51.0585,0.5014,4.5000,0.3171,0.2252,43.9680,32.5889,18.5063,0.5612,2.4459,3.4154,1.3963,4.3581,6.0854,0.5000
 602.5000,1866.9370,-0.3677,31.1384,1988.8331,400.5550,135.4844,60.1460,31.1384,1988.8331,0.2535,1.8170,-0.0506,-0.3484,7.0423,44.4038,40.0755,40.0755,36.6992,-0.4688,50.4829,52.2203,56.3084,52.2203,0.5028,4.5000,0.3158,0.2243,45.8506,35.0463,19.5690,0.5945,2.6931,3.6068,1.3393,4.5304,6.0674,2.0000
 603.0000,1896.6385,-0.3677,0.6063,1975.7516,220.4809,73.5696,29.0238,9.2694,1975.7516,0.2535,1.8078,0.2697,0.6053,6.2399,45.2492,40.9858,40.9858,37.5236,-0.4616,51.0430,52.7608,56.8026,52.7608,0.5061,4.5000,0.3143,0.2236,48.9991,38.5648,21.3608,0.6638,2.9897,3.8665,1.2933,4.5042,5.8252,2.0000
 603.5000,1879.2140,-0.3677,0.1983,1943.0320,113.6487,37.8506,13.9026,4.0071,1943.0320,0.2535,1.8170,0.4073,0.5562,6.0655,45.0951,40.8196,40.8196,37.3731,-0.4378,50.4852,52.2225,56.3104,52.2225,0.5147,4.5000,0.3139,0.2222,55.5540,43.9688,24.2403,0.7814,3.4156,4.2541,1.2455,4.3711,5.4441,0.0000
 604.0000,1894.2194,-0.3677,0.1111,1913.1918,70.6434,23.5362,8.4064,2.3351,1913.1918,0.2535,1.8226,0.1549,-0.0445,6.3065,46.6742,42.5229,42.5229,38.9389,-0.4129,50.1476,51.8968,56.0126,51.8968,0.5227,4.5000,0.3127,0.2216,63.4615,48.4814,26.7070,0.8784,3.7639,4.6043,1.2233,4.2852,5.2419,1.6000
 604.5000,1891.6630,-0.3677,0.1450,1889.1217,72.3874,24.1336,6.4071,1.6887,1889.1217,0.2535,1.8351,-0.3154,-0.2374,6.5264,47.3061,43.2043,43.2043,39.5786,-0.3936,49.3874,51.1633,55.3418,51.1633,0.5293,4.5000,0.3127,0.2218,67.6780,51.5098,28.6378,0.9519,3.9615,4.8895,1.2343,4.1617,5.1366,0.8000
 605.0000,1888.4958,-0.3677,0.4045,1836.4167,228.7576,77.1648,27.3453,8.2145,1836.4167,0.2535,1.8802,-0.2230,-0.0719,6.6901,46.5572,42.3967,42.3967,38.8212,-0.3751,46.6527,48.5245,52.9288,48.5245,0.5445,4.5000,0.3125,0.2211,66.6056,51.3160,28.8742,0.9518,3.9134,4.9676,1.2694,4.1115,5.2191,0.8000
 605.5000,1897.2144,-0.3677,0.3500,481.0494,330.7695,213.1028,160.7139,109.4579,481.0494,0.2535,1.9146,0.7134,0.0923,6.7930,46.5717,42.4123,42.4123,38.8358,-0.3881,44.5708,46.5156,51.0918,46.5156,2.0788,4.5000,0.3132,0.2252,64.7034,49.7302,28.5299,0.9349,3.7235,4.9348,1.3253,3.9829,5.2787,0.0000
 606.0000,1894.8076,-0.3677,0.3212,77.0040,50.4924,33.0337,28.8240,29.2998,77.0040,0.2535,1.9078,1.8233,-0.4125,6.7041,46.3164,42.1370,42.1370,38.5798,-0.3941,44.9816,46.9120,51.4543,46.9120,12.9863,4.5000,0.3151,0.2326,62.5069,49.6177,29.1415,0.9588,3.6138,5.0221,1.3897,3.7690,5.2377,0.0000
 606.5000,1923.9445,-0.3677,0.3471,12.1983,7.9626,5.2343,4.6574,4.3251,22.6971,0.2535,1.8852,2.4437,-0.1999,5.6655,47.9997,43.9524,43.9524,40.2881,-0.2719,46.3497,48.2321,52.6615,48.2322,81.9787,4.5000,0.3140,0.2469,65.3182,48.2181,28.7779,0.9539,3.4313,4.9262,1.4357,3.5972,5.1644,0.0000
 607.0000,1925.6832,-0.3677,0.5449,1.9788,1.3904,0.9821,1.0321,1.0703,2.1401,0.2535,1.8087,1.8079,0.6115,3.7777,49.4712,45.5392,45.5392,41.8151,-0.0670,50.9895,52.7092,56.7555,52.7092,505.3642,4.5000,0.3183,0.3405,72.3352,47.3605,28.5237,0.9623,3.3143,4.8027,1.4491,3.4442,4.9908,0.0000
 607.5000,1907.9595,-0.2055,0.5921,0.7428,0.6120,0.4925,0.5395,0.5825,0.7647,0.2535,1.7496,0.1713,0.8458,2.8181,45.9645,41.7574,41.7574,38.2289,0.0752,54.5697,56.1637,59.9144,56.1637,1346.2468,4.5000,0.7602,0.7845,74.7486,47.9790,28.9092,0.9898,3.3537,4.7988,1.4309,3.3883,4.8482,1.6000
 608.0000,1899.8169,-0.1146,0.6985,0.7872,0.6791,0.5638,0.6300,0.7135,0.8111,0.2535,1.9583,-0.7718,0.5628,3.1922,43.9349,39.5721,39.5721,36.2428,0.1816,41.9225,43.9603,48.7552,43.9603,1270.2925,10.6624,1.6872,1.1923,76.0753,51.1863,30.7158,1.0678,3.5905,5.0223,1.3988,3.3626,4.7036,6.0000
 608.5000,1905.9789,-0.0378,1.0503,1.0636,0.9428,0.7900,0.8805,1.0759,1.1054,0.2535,2.3205,-0.5212,-0.4352,3.8726,40.6375,36.0645,36.0645,33.0512,0.2536,19.9715,22.7795,29.3866,22.7795,940.1649,11.5559,2.0473,1.4954,76.3617,56.6802,34.0240,1.2066,3.9605,5.4499,1.3761,3.2822,4.5166,3.0000
 609.0000,1912.6921,-0.0585,1.5343,1.5767,1.4261,1.2019,1.3122,1.5784,1.6597,0.2535,2.5000,-0.2312,-0.6715,4.0523,36.1174,31.3490,31.3490,28.7273,0.1991,9.0908,12.2806,19.7860,12.2806,634.2323,11.8522,2.8921,1.7837,72.4708,59.2064,35.8221,1.2944,4.0855,5.6239,1.3766,3.1562,4.3447,1.0000
 609.5000,1883.2448,-0.1991,1.7679,2.1744,2.0179,1.7499,1.7949,1.8130,2.2671,0.2535,2.5194,-0.2599,0.0061,3.7329,34.7429,29.9365,29.9365,27.4243,0.1003,7.9148,11.1459,18.7484,11.1459,459.8993,12.2835,2.1678,1.7485,71.9186,62.3396,38.1364,1.4023,4.2290,5.8721,1.3885,3.0157,4.1874,0.0000
 610.0000,1907.3488,-0.2432,1.8128,2.4314,2.3109,2.0714,2.0094,1.8527,2.4391,0.2535,2.5055,-0.0738,0.3690,3.4503,34.2083,29.3899,29.3899,26.9191,0.0575,8.7597,11.9611,19.4938,11.9611,411.2921,12.2753,2.2871,1.9961,72.5476,65.2945,40.3734,1.5031,4.3576,6.1288,1.4065,2.8991,4.0775,2.4000
 610.5000,1864.1849,-0.2595,1.7134,2.3389,2.2524,2.0621,1.9323,1.7557,2.3451,0.2535,2.4825,0.2828,0.4946,3.2889,35.5826,30.7981,30.7981,28.2196,0.0476,10.1518,13.3043,20.7221,13.3043,427.5501,12.2665,2.4397,1.7504,74.9297,67.5193,42.1414,1.5941,4.4216,6.2778,1.4198,2.7738,3.9382,0.0000
 611.0000,1868.7793,-0.2076,1.6341,2.1105,2.0586,1.9288,1.7809,1.6696,2.1154,0.2535,2.4661,0.2879,0.2128,3.1649,36.7108,31.9618,31.9618,29.2915,0.0472,11.1467,14.2643,21.6000,14.2644,473.8143,12.5512,2.2385,1.5215,81.5230,70.0557,44.7444,1.7181,4.4110,6.5440,1.4836,2.5673,3.8088,1.6000
 611.5000,1845.4243,-0.1538,1.6087,1.9545,1.9229,1.8358,1.6927,1.6310,1.9585,0.2535,2.4671,-0.1193,0.1475,3.1271,37.3884,32.6640,32.6640,29.9371,0.0501,11.0868,14.2066,21.5472,14.2066,511.6411,12.5036,2.1440,1.3647,86.0964,70.3276,46.2181,1.8017,4.1934,6.6317,1.5815,2.3275,3.6808,0.8000
 612.0000,1892.9766,-0.1105,1.5972,1.8422,1.8262,1.7738,1.6528,1.6148,1.8455,0.2535,2.4762,-0.3698,0.2194,3.1618,38.3546,33.6693,33.6693,30.8599,0.0532,10.5307,13.6700,21.0565,13.6700,542.8331,12.5923,1.9494,1.4856,85.3166,70.1602,47.3708,1.8655,3.9742,6.7077,1.6878,2.1304,3.5957,0.8000
 612.5000,1886.8843,-0.0754,1.5793,1.7450,1.7371,1.7087,1.6166,1.5822,1.7459,0.2535,2.4601,-0.1733,-0.0894,3.1350,40.4329,35.8487,35.8487,32.8541,0.0560,11.5105,14.6153,21.9210,14.6153,573.0790,12.6649,1.7699,1.4727,83.4957,70.5505,48.9019,1.9298,3.7939,6.9054,1.8202,1.9660,3.5784,0.0000
 613.0000,1867.4780,-0.0565,1.5683,1.6919,1.6892,1.6759,1.6130,1.5705,1.6919,0.2535,2.4472,0.2035,-0.2503,3.0541,40.9845,36.4309,36.4309,33.3856,0.0635,12.2934,15.3708,22.6118,15.3708,591.0588,12.6354,1.8712,1.3327,86.0429,68.3984,48.3345,1.9136,3.5269,6.7956,1.9268,1.8430,3.5511,0.0000
 613.5000,1881.7592,-0.0552,1.5903,1.7128,1.7107,1.7051,1.6682,1.6020,1.7128,0.2535,2.4761,0.3813,-0.0234,3.0275,39.4768,34.8433,34.8433,31.9352,0.0762,10.5405,13.6794,21.0651,13.6794,583.8477,12.6246,1.7363,1.2889,84.2826,64.4728,46.4402,1.8355,3.1921,6.5443,2.0501,1.7391,3.5654,0.8000
 614.0000,1873.2363,-0.0424,1.6580,1.7558,1.7541,1.7516,1.7352,1.6627,1.7558,0.2535,2.5173,0.2816,0.2147,3.0263,37.5867,32.8699,32.8699,30.1262,0.0926,8.0415,11.2681,18.8601,11.2681,569.5399,12.4910,1.8152,1.8376,72.2032,57.8661,42.3128,1.6752,2.7554,5.9491,2.1591,1.6448,3.5513,0.8000
 614.5000,1877.6473,-0.0471,1.6961,1.8073,1.8038,1.8009,1.7773,1.6980,1.8073,0.2535,2.5319,0.2497,0.2733,2.9850,36.1744,31.4077,31.4077,28.7814,0.1148,7.1554,10.4130,18.0782,10.4131,553.3202,12.2853,2.7741,2.4100,60.6351,52.2076,38.5944,1.5383,2.4141,5.3773,2.2274,1.5693,3.4955,2.0000
 615.0000,1889.1752,-0.0458,1.7004,1.8089,1.8063,1.8030,1.7747,1.7017,1.8089,0.2535,2.5314,0.4956,0.3577,2.9795,33.4977,28.6657,28.6657,26.2487,0.1166,7.1860,10.4426,18.1053,10.4426,552.8137,11.5413,1.2489,1.2920,58.5625,49.6047,37.0266,1.4823,2.2273,5.1282,2.3025,1.5026,3.4597,2.0000
 615.5000,1855.6735,-0.0419,1.7040,1.8033,1.8011,1.7969,1.7657,1.7049,1.8033,0.2535,2.5583,0.3399,0.0403,3.1018,30.9439,26.0856,26.0856,23.8522,0.0888,5.5587,8.8725,16.6695,8.8725,554.5330,10.7904,2.4757,1.6868,61.0169,51.5675,38.6769,1.5663,2.2708,5.2714,2.3214,1.4498,3.3654,0.0000
 616.0000,1872.7639,-0.0281,1.6560,1.7206,1.7220,1.7196,1.6977,1.6566,1.7206,0.2535,2.5778,-0.3245,0.0211,3.1730,30.6569,25.7979,25.7979,23.5841,0.0598,4.3773,7.7324,15.6270,7.7325,581.1816,10.5143,2.8157,1.9909,67.2926,55.7411,42.0849,1.7191,2.4102,5.6661,2.3509,1.4020,3.2960,0.0000
 616.5000,1853.0597,-0.0106,1.5657,1.5887,1.5929,1.5923,1.5839,1.5659,1.5887,0.2535,2.5584,-0.5189,0.6459,3.0822,33.6850,28.8564,28.8564,26.4253,0.0392,5.5507,8.8647,16.6624,8.8647,629.4563,10.4375,2.7517,2.0337,75.3401,59.8787,45.1973,1.8617,2.5955,6.0116,2.3161,1.3942,3.2290,0.8000
 617.0000,1864.3683,0.0093,1.4997,1.4805,1.4884,1.4913,1.4895,1.4997,1.4805,0.2535,2.5414,-0.3989,0.2683,2.9707,32.3615,27.5134,27.5134,25.1800,0.0267,6.5789,9.8568,17.5696,9.8568,675.4459,10.4768,2.9278,1.8504,76.1172,61.4271,46.3747,1.9218,2.6656,6.1131,2.2933,1.3870,3.1809,0.8000
 617.5000,1848.1190,0.0244,1.4473,1.3988,1.4089,1.4138,1.4225,1.4470,1.3988,0.2535,2.5253,-0.2037,-0.1971,2.9236,31.9623,27.1103,27.1103,24.8056,0.0210,7.5561,10.7997,18.4319,10.7998,714.9137,10.3913,2.5867,1.5998,74.2579,60.2020,45.4853,1.8966,2.5894,5.9408,2.2943,1.3653,3.1324,0.0000
 618.0000,1872.6841,0.0355,1.3999,1.3320,1.3443,1.3516,1.3685,1.3994,1.3320,0.2535,2.5083,0.3115,0.2222,2.9420,32.9474,28.1067,28.1067,25.7306,0.0172,8.5883,11.7957,19.3426,11.7958,750.7595,10.4247,2.6161,1.5079,75.5204,57.3430,43.4830,1.8298,2.4161,5.6000,2.3177,1.3204,3.0604,0.0000
 618.5000,1888.7838,0.0391,1.3897,1.3155,1.3293,1.3381,1.3600,1.3885,1.3155,0.2535,2.5133,0.5420,0.0431,2.9739,32.5758,27.7303,27.7303,25.3814,0.0164,8.2822,11.5004,19.0725,11.5004,760.1959,10.3940,2.6191,1.5983,70.7150,55.4212,42.2445,1.7946,2.2878,5.3604,2.3430,1.2749,2.9870,0.0000
 619.0000,1868.2034,0.0400,1.4228,1.3451,1.3611,1.3719,1.3987,1.4216,1.3451,0.2535,2.5263,0.2710,-0.3999,2.9773,32.4830,27.6364,27.6364,25.2942,0.0255,7.4941,10.7399,18.3772,10.7399,743.4300,10.3788,3.0992,1.9370,67.1944,60.2177,46.0204,1.9699,2.4634,5.7688,2.3418,1.2506,2.9285,6.4000
 619.5000,1896.8455,0.0406,1.4769,1.3951,1.4124,1.4245,1.4554,1.4759,1.3951,0.2535,2.5099,-0.1210,-0.4208,2.9591,32.0797,27.2287,27.2287,24.9156,0.0417,8.4898,11.7006,19.2557,11.7006,716.8022,10.4650,3.6913,2.1741,83.2378,70.8073,54.1507,2.3334,2.9111,6.7142,2.3064,1.2475,2.8774,3.0000
 620.0000,1855.3169,0.0467,1.5003,1.4049,1.4217,1.4342,1.4688,1.4993,1.4049,0.2535,2.4527,-0.4159,-0.4251,2.9077,34.4510,29.6378,29.6378,27.1483,0.0433,11.9550,15.0443,22.3132,15.0443,711.8183,10.4840,2.7930,1.7774,107.3377,81.3671,62.2097,2.6829,3.3695,7.7029,2.2860,1.2559,2.8711,2.0000
 620.5000,1825.4073,0.0538,1.4367,1.3315,1.3449,1.3554,1.3890,1.4353,1.3315,0.2535,2.4115,-0.2381,-0.3571,2.8495,35.2385,30.4446,30.4446,27.8934,0.0303,14.4566,17.4581,24.5205,17.4581,751.0046,10.6086,2.1841,1.3775,114.1977,83.2278,63.5144,2.7510,3.4886,7.8083,2.2383,1.2681,2.8384,2.0000
 621.0000,1806.4510,0.0577,1.3802,1.2720,1.2819,1.2901,1.3213,1.3785,1.2720,0.2535,2.4318,0.3699,0.2509,2.8683,36.9930,32.2539,32.2539,29.5602,0.0225,13.2262,16.2709,23.4349,16.2709,786.1395,10.6117,1.8955,1.1639,99.4382,75.5730,57.4376,2.4926,3.2222,7.0386,2.1844,1.2927,2.8238,1.0000
 621.5000,1859.8314,0.0535,1.4562,1.3501,1.3569,1.3632,1.3924,1.4542,1.3501,0.2535,2.4792,0.5998,0.8149,2.9579,35.7149,30.9343,30.9343,28.3451,0.0215,10.3528,13.4983,20.8995,13.4983,740.6732,10.5855,2.0145,1.4052,80.8833,65.5156,49.2911,2.1486,2.8588,5.9952,2.0971,1.3306,2.7904,5.0000
 622.0000,1893.5985,0.0396,1.6369,1.5485,1.5507,1.5541,1.5779,1.6362,1.5485,0.2535,2.5167,0.1982,0.3891,2.9994,32.0410,27.1897,27.1897,24.8793,0.0201,8.0785,11.3038,18.8928,11.3038,645.8013,10.5756,2.6180,1.7213,71.0219,59.4328,44.3380,1.9342,2.6423,5.3854,2.0382,1.3661,2.7843,1.6000
 622.5000,1869.0334,0.0140,1.8108,1.7760,1.7686,1.7654,1.7783,1.8131,1.7760,0.2535,2.5420,-0.2098,0.1093,2.9533,29.7707,24.9123,24.9123,22.7578,0.0208,6.5483,9.8273,17.5426,9.8273,563.0678,10.4832,3.2053,1.9854,69.4187,57.6216,42.3513,1.8605,2.6362,5.0827,1.9280,1.4170,2.7319,3.2000
 623.0000,1878.1658,-0.0194,1.9845,2.0379,2.0165,2.0027,1.9896,1.9920,2.0379,0.2535,2.5620,-0.3843,0.1989,2.8858,28.7945,23.9417,23.9417,21.8503,0.0258,5.3325,8.6542,16.4699,8.6542,490.7098,10.4460,3.4863,2.0915,69.8621,56.1798,41.0145,1.8073,2.6061,4.8962,1.8787,1.4420,2.7092,0.8000
 623.5000,1846.4253,-0.0591,2.2465,2.4317,2.3899,2.3606,2.3081,2.2647,2.4317,0.2535,2.5828,-0.3174,0.0217,2.8816,25.7015,20.9010,20.9010,18.9943,0.0302,4.0743,7.4401,15.3597,7.4401,411.2424,10.3501,3.8827,2.3013,67.2506,52.8960,38.1030,1.6853,2.5155,4.5186,1.7963,1.4926,2.6812,0.0000
 624.0000,1875.6780,-0.0986,2.5524,2.9055,2.8369,2.7864,2.6825,2.5883,2.9056,0.2535,2.5929,0.1050,0.1145,2.9597,23.3399,18.6153,18.6153,16.8334,0.0328,3.4599,6.8473,14.8176,6.8473,344.1749,10.3173,3.6295,2.2573,61.7360,49.7360,35.3614,1.5646,2.4377,4.1908,1.7191,1.5581,2.6785,3.0000
 624.5000,1879.7201,-0.1254,2.6414,3.1081,3.0166,2.9471,2.8015,2.6881,3.1083,0.2535,2.5851,0.2952,0.0504,3.0122,23.6139,18.8789,18.8789,17.0832,0.0359,3.9337,7.3044,15.2356,7.3044,321.7362,10.3679,2.9492,2.0903,58.6794,47.6708,33.7555,1.4862,2.3628,4.0352,1.7078,1.5898,2.7151,2.0000
 625.0000,1872.6718,-0.1353,2.5545,3.0417,2.9374,2.8561,2.6910,2.5982,3.0419,0.2535,2.5697,-0.2046,-0.4627,2.9265,26.2190,21.4061,21.4061,19.4701,0.0347,4.8681,8.2061,16.0601,8.2061,328.7623,10.2881,2.7579,2.0352,58.7275,45.7154,32.2172,1.4095,2.2908,3.8939,1.6998,1.6252,2.7625,0.0000
 625.5000,1859.6470,-0.1362,2.4310,2.8980,2.7880,2.7003,2.5303,2.4643,2.8982,0.2535,2.5536,-0.6972,-0.5159,2.7322,27.6320,22.7927,22.7927,20.7735,0.0282,5.8396,9.1435,16.9173,9.1435,345.0647,10.2695,3.1602,1.9218,56.3704,44.3311,31.2417,1.3538,2.2304,3.8377,1.7207,1.6475,2.8347,2.0000
 626.0000,1873.3173,-0.1410,2.3864,2.8611,2.7454,2.6508,2.4768,2.4197,2.8613,0.2535,2.5379,-0.5868,-0.0489,2.5930,26.7322,21.9084,21.9084,19.9428,0.0225,6.7968,10.0670,17.7618,10.0670,349.5171,10.1613,3.0455,1.9964,52.0504,43.1543,30.3450,1.3048,2.1754,3.7757,1.7356,1.6672,2.8936,5.0000
 626.5000,1868.5498,-0.1496,2.4172,2.9281,2.8060,2.7033,2.5241,2.4619,2.9283,0.2535,2.5223,-0.0764,0.5019,2.5638,25.9594,21.1526,21.1526,19.2313,0.0181,7.7366,10.9739,18.5911,10.9739,341.5230,9.9752,3.4470,2.1366,51.5186,43.6536,30.6802,1.3053,2.1914,3.8836,1.7722,1.6789,2.9753,3.0000
 627.0000,1859.7504,-0.1528,2.4883,3.0254,2.8987,2.7888,2.6073,2.5355,3.0257,0.2535,2.5076,0.3197,0.8636,2.5745,25.2656,20.4768,20.4768,18.5941,0.0146,8.6320,11.8379,19.3812,11.8379,330.5302,9.9784,3.5933,2.2666,56.4632,46.5642,33.0062,1.3883,2.2892,4.2535,1.8581,1.6488,3.0637,1.0000
 627.5000,1870.3347,-0.1516,2.5955,3.1515,3.0220,2.9060,2.7242,2.6437,3.1518,0.2535,2.5037,0.2301,0.1460,2.5885,25.7656,20.9636,20.9636,19.0532,0.0132,8.8682,12.0658,19.5896,12.0658,317.3077,9.9403,3.6327,2.3291,62.7781,48.8130,35.0992,1.4627,2.3272,4.5881,1.9715,1.5910,3.1367,1.0000
 628.0000,1866.5918,-0.1468,2.6645,3.2167,3.0895,2.9720,2.7951,2.7119,3.2170,0.2535,2.5119,-0.1180,-0.5358,2.6131,24.8286,20.0526,20.0526,18.1936,0.0143,8.3704,11.5854,19.1503,11.5855,310.8762,9.9608,4.0291,2.4528,65.7732,48.6276,35.3112,1.4615,2.2754,4.6634,2.0495,1.5569,3.1909,2.4000
 628.5000,1877.8542,-0.1401,2.7684,3.3158,3.1921,3.0743,2.8997,2.8128,3.3160,0.2535,2.5154,-0.1433,-0.1815,2.6594,24.5456,19.7784,19.7784,17.9345,0.0173,8.1582,11.3807,18.9631,11.3807,301.5868,9.9057,3.9681,2.3930,60.6520,46.7606,34.1321,1.4036,2.1718,4.5509,2.0954,1.5473,3.2423,4.8000
 629.0000,1915.0652,-0.1332,2.8720,3.4114,3.2933,3.1778,3.0034,2.9102,3.4116,0.2535,2.5172,0.2904,-0.0874,2.7521,23.5654,18.8322,18.8322,17.0390,0.0203,8.0484,11.2748,18.8662,11.2748,293.1341,9.8000,4.0594,2.5686,55.4015,45.7376,32.9768,1.3525,2.1734,4.4141,2.0309,1.6070,3.2638,1.0000
 629.5000,1919.5448,-0.1246,2.9912,3.5165,3.4053,3.2942,3.1179,3.0186,3.5165,0.2535,2.5284,0.4859,-0.2335,2.9205,22.9029,18.1958,18.1958,16.4354,0.0235,7.3690,10.6192,18.2667,10.6192,284.3750,9.7541,4.9622,2.8654,57.3197,46.0561,32.7565,1.3357,2.2426,4.4211,1.9714,1.6790,3.3099,1.0000
 630.0000,1880.9178,-0.1148,3.0177,3.5054,3.4057,3.3045,3.1327,3.0399,3.5054,0.2535,2.5388,0.2085,-0.2214,3.0838,22.6465,17.9501,17.9501,16.2022,0.0247,6.7397,10.0120,17.7115,10.0120,285.2740,9.7334,4.9461,2.8561,61.0160,48.2379,34.0422,1.3822,2.3684,4.6227,1.9518,1.7134,3.3444,1.0000
 630.5000,1980.6864,-0.1055,2.9314,3.3661,3.2809,3.1940,3.0345,2.9615,3.3661,0.2535,2.5379,-0.1071,0.0308,3.1277,22.9099,18.2025,18.2025,16.4418,0.0207,6.7945,10.0649,17.7598,10.0649,297.0760,9.7103,4.3315,2.5892,65.8035,50.4393,35.6821,1.4411,2.4518,4.8820,1.9912,1.7013,3.3876,0.0000
 631.0000,2019.6136,-0.0931,2.9123,3.2927,3.2189,3.1440,2.9950,2.9429,3.2927,0.2535,2.5332,-0.2639,0.3847,3.0980,23.9054,19.1598,19.1598,17.3493,0.0146,7.0800,10.3403,18.0117,10.3403,303.7025,9.6936,4.6238,2.7706,72.2532,51.7935,37.2617,1.4941,2.4143,5.1494,2.1329,1.6159,3.4465,6.0000
 631.5000,1967.8348,-0.0803,2.8932,3.2184,3.1544,3.0905,2.9526,2.9191,3.2184,0.2535,2.5335,-0.2373,0.5830,3.1236,23.6458,18.9096,18.9096,17.1123,0.0102,7.0623,10.3233,17.9962,10.3233,310.7087,9.6774,4.1163,2.4322,73.1569,52.3876,38.3630,1.5339,2.3368,5.3225,2.2777,1.5235,3.4700,1.0000
 632.0000,2042.7842,-0.0704,2.9910,3.2852,3.2264,3.1695,3.0356,3.0112,3.2852,0.2535,2.5337,-0.2117,0.5017,3.1742,23.0210,18.3091,18.3091,16.5429,0.0073,7.0465,10.3080,17.9822,10.3080,304.3918,9.6802,4.8069,2.8957,65.0407,50.0963,37.1197,1.4854,2.1825,5.1439,2.3569,1.4693,3.4629,6.0000
 632.5000,2006.0354,-0.0630,3.1046,3.3776,3.3219,3.2704,3.1392,3.1207,3.3776,0.2535,2.5306,-0.0325,-0.0405,3.1537,22.1003,17.4281,17.4281,15.7061,0.0066,7.2386,10.4933,18.1517,10.4933,296.0703,9.5675,4.6967,2.7844,58.5946,46.9100,34.9463,1.4048,2.0366,4.8127,2.3631,1.4498,3.4259,1.0000
 633.0000,1988.5985,-0.0582,3.2014,3.4614,3.4077,3.3603,3.2308,3.2136,3.4614,0.2535,2.5298,0.4686,-0.4143,3.1586,21.9523,17.2869,17.2869,15.5718,0.0081,7.2852,10.5384,18.1928,10.5384,288.9012,9.5259,4.6005,2.8203,59.5519,44.4784,33.1583,1.3330,1.9484,4.5661,2.3435,1.4617,3.4255,3.0000
 633.5000,2021.6403,-0.0586,3.4545,3.7370,3.6812,3.6341,3.4957,3.4629,3.7370,0.2535,2.5396,0.6531,-0.2314,3.3394,21.3480,16.7118,16.7118,15.0242,0.0120,6.6895,9.9635,17.6672,9.9635,267.5945,9.5073,5.1550,3.3579,60.1301,41.7744,31.3248,1.2554,1.8038,4.3321,2.4016,1.4369,3.4508,2.4000
 634.0000,1985.7317,-0.0638,3.9146,4.2635,4.2013,4.1507,3.9910,3.9218,4.2635,0.2535,2.5616,0.1827,-0.1970,3.6366,19.5996,15.0594,15.0594,13.4464,0.0190,5.3596,8.6803,16.4938,8.6803,234.5479,9.5028,7.2149,4.0276,53.2718,38.8478,29.4410,1.1704,1.6348,4.1167,2.5182,1.3968,3.5174,1.6000
 634.5000,1988.6682,-0.0662,4.0927,4.4712,4.4073,4.3572,4.1926,4.1021,4.4712,0.2535,2.5819,-0.1086,-0.3530,3.7788,18.7246,14.2390,14.2390,12.6603,0.0260,4.1255,7.4895,15.4048,7.4895,223.6551,9.5112,7.2810,4.3535,44.5078,37.0512,28.3977,1.1222,1.5022,4.0024,2.6643,1.3386,3.5665,3.2000
 635.0000,1895.7635,-0.0602,3.7914,4.1102,4.0528,4.0091,3.8656,3.7998,4.1102,0.2535,2.5865,0.1298,-0.0935,3.6307,19.2788,14.7581,14.7581,13.1579,0.0299,3.8512,7.2248,15.1628,7.2248,243.2986,9.5222,7.8031,4.7310,43.9056,38.5965,29.7238,1.1717,1.5448,4.2031,2.7209,1.3184,3.5871,2.0000
 635.5000,1868.4227,-0.0504,3.4125,3.6523,3.6025,3.5652,3.4463,3.4173,3.6523,0.2535,2.5787,0.1672,-0.1817,3.4063,20.6843,16.0824,16.0824,14.4241,0.0304,4.3230,7.6800,15.5791,7.6800,273.7991,9.5707,5.4729,3.3479,51.8675,43.2448,33.2227,1.3194,1.7467,4.6515,2.6630,1.3238,3.5253,1.0000
 636.0000,1908.4319,-0.0451,3.2425,3.4461,3.3995,3.3645,3.2586,3.2453,3.4461,0.2535,2.5736,-0.0659,-0.2603,3.3184,21.5706,16.9234,16.9234,15.2258,0.0284,4.6288,7.9752,15.8490,7.9752,290.1858,9.5385,4.5082,3.3764,59.4368,46.9039,35.6693,1.4235,1.9522,4.9612,2.5414,1.3714,3.4852,1.0000
 636.5000,1964.2415,-0.0476,3.2911,3.5092,3.4614,3.4246,3.3172,3.2945,3.5092,0.2535,2.5704,-0.1265,0.1294,3.4234,21.9470,17.2818,17.2818,15.5670,0.0247,4.8227,8.1622,16.0200,8.1623,284.9653,9.5340,5.0091,3.4868,63.6890,48.3723,36.3626,1.4592,2.0854,5.0198,2.4072,1.4291,3.4402,0.0000
 637.0000,1993.2175,-0.0549,3.4698,3.7356,3.6836,3.6422,3.5248,3.4758,3.7356,0.2535,2.5688,-0.0613,-0.1834,3.6151,21.1455,16.5195,16.5195,14.8410,0.0212,4.9195,8.2557,16.1054,8.2557,267.6911,9.5032,5.8609,3.5742,62.3811,48.5904,36.1801,1.4574,2.1566,4.9683,2.3037,1.4798,3.4090,0.0000
 637.5000,1968.4568,-0.0620,3.5731,3.8821,3.8262,3.7803,3.6540,3.5818,3.8821,0.2535,2.5821,0.1004,-0.4278,3.7210,19.8848,15.3277,15.3277,13.7031,0.0206,4.1151,7.4794,15.3956,7.4795,257.5898,9.5223,5.7669,3.5653,60.1640,48.3979,35.4265,1.4278,2.2389,4.8614,2.1714,1.5681,3.4050,1.0000
 638.0000,1986.7214,-0.0665,3.6091,3.9444,3.8850,3.8351,3.7034,3.6203,3.9444,0.2535,2.5934,0.3174,0.0782,3.7624,19.5715,15.0330,15.0330,13.4211,0.0184,3.4283,6.8167,14.7896,6.8168,253.5228,9.5334,5.7011,3.4628,62.5872,48.5736,35.0465,1.4168,2.3255,4.7886,2.0591,1.6414,3.3799,0.0000
 638.5000,1986.3076,-0.0690,3.6369,3.9876,3.9241,3.8705,3.7355,3.6499,3.9876,0.2535,2.5923,0.2581,0.3729,3.7910,19.5949,15.0550,15.0550,13.4422,0.0137,3.4974,6.8834,14.8506,6.8834,250.7788,9.5389,5.8096,3.4103,64.0049,48.6190,34.6821,1.3919,2.3867,4.7871,2.0058,1.7147,3.4393,5.6000
 639.0000,2019.1874,-0.0702,3.6673,4.0270,3.9587,3.9014,3.7644,3.6820,4.0270,0.2535,2.5950,-0.0335,0.4643,3.8061,19.7260,15.1783,15.1783,13.5602,0.0135,3.3313,6.7231,14.7040,6.7231,248.3248,9.5559,6.1586,3.5058,63.3955,48.8127,34.7103,1.3763,2.4033,4.8703,2.0265,1.7462,3.5387,3.2000
 639.5000,2007.9924,-0.0703,3.6459,4.0041,3.9314,3.8716,3.7350,3.6590,4.0041,0.2535,2.5988,-0.0875,0.2457,3.8519,19.6712,15.1268,15.1268,13.5109,0.0154,3.1011,6.5011,14.5010,6.5011,249.7410,9.5738,5.6565,3.2474,64.5866,49.5279,35.2485,1.3854,2.4240,5.0039,2.0643,1.7497,3.6119,2.4000
 640.0000,2007.1410,-0.0723,3.6170,3.9827,3.9049,3.8426,3.7049,3.6289,3.9827,0.2535,2.6013,0.0636,-0.1380,3.9407,19.8836,15.3267,15.3267,13.7021,0.0157,2.9509,6.3561,14.3684,6.3561,251.0843,9.5528,5.4938,3.1542,66.2657,49.9326,35.2815,1.3782,2.4672,5.0489,2.0465,1.7901,3.6634,0.8000
 640.5000,2009.7783,-0.0784,3.6758,4.0795,3.9936,3.9272,3.7814,3.6908,4.0795,0.2535,2.6040,-0.0159,0.0843,3.9702,20.4850,15.8940,15.8940,14.2442,0.0158,2.7855,6.1965,14.2225,6.1965,245.1293,9.5565,5.7033,3.3338,64.9773,50.1987,34.8670,1.3628,2.5528,4.9857,1.9530,1.8732,3.6583,3.0000
 641.0000,1988.7480,-0.0884,3.8209,4.2947,4.1977,4.1253,3.9638,3.8438,4.2947,0.2535,2.6004,-0.2446,0.1765,3.9110,19.5611,15.0232,15.0232,13.4118,0.0149,3.0080,6.4112,14.4188,6.4112,232.8461,9.5411,6.0866,3.4544,63.9594,50.2698,33.6229,1.3272,2.7185,4.7462,1.7459,2.0483,3.5762,2.0000
 641.5000,2001.1982,-0.1005,4.0364,4.6060,4.4953,4.4159,4.2326,4.0714,4.6060,0.2535,2.5971,-0.2795,-0.4180,3.8741,19.0319,14.5266,14.5266,12.9361,0.0129,3.2069,6.6031,14.5943,6.6032,217.1104,9.5403,7.1484,4.0121,63.8844,50.4885,32.0106,1.2711,2.9769,4.4829,1.5059,2.3420,3.5269,2.0000
 642.0000,1983.3699,-0.1103,4.2462,4.9047,4.7812,4.6960,4.4920,4.2927,4.9047,0.2535,2.6016,0.0353,-0.6759,3.8821,17.7914,13.3689,13.3689,11.8247,0.0119,2.9335,6.3393,14.3531,6.3393,203.8868,9.5180,7.2315,4.3557,63.1368,50.0178,29.7509,1.1900,3.2045,4.1255,1.2874,2.6930,3.4670,2.0000
 642.5000,1997.0055,-0.1121,4.2923,4.9691,4.8404,4.7557,4.5454,4.3392,4.9691,0.2535,2.6059,0.4543,-0.3159,3.9268,17.6744,13.2602,13.2602,11.7202,0.0119,2.6716,6.0867,14.1220,6.0867,201.2424,9.5462,8.4035,4.8996,63.0841,50.1316,27.7850,1.1108,3.4786,3.8554,1.1083,3.1316,3.4708,3.0000
 643.0000,2009.5129,-0.1054,4.1106,4.7195,4.5966,4.5197,4.3220,4.1473,4.7195,0.2535,2.6075,0.4253,-0.1610,4.0198,18.2298,13.7771,13.7771,12.2170,0.0125,2.5733,5.9917,14.0352,5.9918,211.8872,9.5291,7.4383,4.3847,65.0576,50.1242,26.3784,1.0544,3.6437,3.6612,1.0048,3.4558,3.4724,2.4000
 643.5000,1970.9209,-0.0963,3.9094,4.4377,4.3245,4.2576,4.0756,3.9353,4.4377,0.2535,2.6086,-0.1001,0.0613,4.0430,18.6220,14.1431,14.1431,12.5684,0.0127,2.5096,5.9303,13.9791,5.9304,225.3414,9.5415,6.5245,3.7620,67.4362,50.8442,25.4185,1.0099,3.8552,3.5570,0.9226,3.8175,3.5222,0.0000
 644.0000,1955.1429,-0.0915,3.8714,4.3683,4.2621,4.2032,4.0270,3.8943,4.3683,0.2535,2.6039,-0.4784,0.5401,3.9442,18.4935,14.0231,14.0231,12.4532,0.0112,2.7969,6.2075,14.2325,6.2075,228.9225,9.5738,6.2676,3.6161,68.1553,50.0179,23.8278,0.9437,3.9314,3.3485,0.8517,4.1659,3.5482,4.0000
 644.5000,1969.0090,-0.0920,3.9926,4.5080,4.4071,4.3549,4.1769,4.0220,4.5080,0.2535,2.5957,-0.3046,0.6097,3.9456,17.6277,13.2168,13.2168,11.6785,0.0093,3.2885,6.6818,14.6663,6.6819,221.8303,9.5515,7.2106,4.1627,63.7256,46.8574,21.3010,0.8414,3.8060,3.0038,0.7892,4.5232,3.5698,2.4000
 645.0000,1990.9828,-0.0908,4.0820,4.6018,4.5112,4.4681,4.2965,4.1155,4.6018,0.2535,2.5848,0.1016,0.1339,4.1065,16.5550,12.2238,12.2238,10.7219,0.0069,3.9534,7.3234,15.2530,7.3234,217.3052,9.5760,9.2906,5.1887,53.6706,41.8861,18.1871,0.7189,3.5013,2.5626,0.7319,4.8705,3.5647,7.2000
 645.5000,1981.2623,-0.0799,3.8713,4.3045,4.2342,4.2050,4.0651,3.8932,4.3045,0.2535,2.5662,0.2665,-0.6567,4.2303,15.8553,11.5797,11.5797,10.0999,0.0042,5.0818,8.4122,16.2486,8.4122,232.3163,9.5407,8.6948,4.6818,46.1468,38.3425,16.2723,0.6373,3.2316,2.3208,0.7182,5.0709,3.6417,4.8000
 646.0000,1958.2178,-0.0620,3.5823,3.8923,3.8437,3.8279,3.7315,3.5935,3.8923,0.2535,2.5508,0.0853,-0.6988,4.3041,15.6176,11.3615,11.3615,9.8890,0.0064,6.0112,9.3090,17.0687,9.3090,256.9204,9.5660,7.4505,4.0404,48.0213,41.9791,17.3646,0.6750,3.5767,2.5005,0.6991,5.2985,3.7042,2.0000
 646.5000,1994.0813,-0.0397,3.4587,3.6497,3.6198,3.6154,3.5743,3.4628,3.6497,0.2535,2.5507,-0.0920,0.2735,4.3304,16.1349,11.8368,11.8368,10.3483,0.0111,6.0201,9.3176,17.0765,9.3176,273.9940,9.5135,8.3837,4.6877,61.3961,52.1790,21.1845,0.8093,4.4839,3.1179,0.6954,5.5402,3.8524,4.0000
 647.0000,1983.7849,-0.0141,3.3902,3.4564,3.4436,3.4496,3.4283,3.3861,3.4564,0.2535,2.5538,0.0742,0.5046,4.2872,16.0221,11.7330,11.7330,10.2481,0.0081,5.8305,9.1346,16.9092,9.1347,289.3172,9.4747,9.3062,4.6839,83.6678,64.4246,25.4551,0.9611,5.6200,3.8005,0.6762,5.8474,3.9543,0.0000
 647.5000,2000.8069,0.0212,3.1149,3.0243,3.0263,3.0398,3.0755,3.0906,3.0243,0.2535,2.5382,0.4046,-0.1646,4.3333,16.3868,12.0687,12.0687,10.5723,0.0018,6.7787,10.0496,17.7459,10.0496,330.6541,9.5077,9.5440,4.9869,99.3954,72.3720,27.5218,1.0288,6.4550,4.1579,0.6441,6.2740,4.0413,4.0000
 648.0000,1955.4545,0.0563,2.7929,2.5792,2.5891,2.6057,2.6753,2.7522,2.5792,0.2535,2.5212,0.3548,-0.4954,4.4948,16.9429,12.5822,12.5822,11.0674,0.0047,7.8057,11.0405,18.6520,11.0405,387.7097,9.5428,9.8358,5.5120,98.2650,73.8403,27.0381,1.0024,6.7305,4.1246,0.6128,6.7146,4.1148,0.0000
 648.5000,1987.0330,0.0804,2.6538,2.3659,2.3805,2.4004,2.4913,2.6289,2.3659,0.2535,2.5276,-0.0980,-0.2409,4.6153,17.0776,12.7067,12.7067,11.1874,0.0119,7.4183,10.6668,18.3103,10.6668,422.6785,9.5740,8.6566,4.2479,90.8696,70.6442,24.9608,0.9166,6.5493,3.8492,0.5877,7.1452,4.1994,1.6000
 649.0000,1953.5188,0.1061,2.7173,2.3311,2.3504,2.3754,2.4876,2.6952,2.3311,0.2535,2.5351,-0.2977,-0.0989,4.5650,17.6300,13.2189,13.2189,11.6805,0.0158,6.9645,10.2289,17.9099,10.2289,428.9731,9.6242,9.5524,5.5049,88.6927,64.5468,21.8018,0.8025,6.1238,3.3533,0.5476,7.6313,4.1788,0.8000
 649.5000,1915.1000,0.1311,2.8469,2.3510,2.3743,2.4056,2.5383,2.8087,2.3510,0.2535,2.5164,-0.2478,-0.1768,4.4255,19.3675,14.8413,14.8413,13.2377,0.0193,8.0985,11.3231,18.9104,11.3231,425.3581,9.7221,11.5671,7.4954,82.2742,55.7219,18.0186,0.6589,5.3948,2.7920,0.5175,8.1881,4.2377,1.6000
 650.0000,1844.4098,0.1527,3.0475,2.4334,2.4609,2.5010,2.6594,2.9788,2.4334,0.2535,2.4776,-0.3830,-0.0842,4.3894,20.4214,15.8339,15.8339,14.1869,0.0203,10.4461,13.5884,20.9819,13.5884,410.9560,9.7838,8.9409,6.6462,63.2340,44.4207,13.9426,0.5101,4.3536,2.1591,0.4959,8.5349,4.2328,1.6000
 650.5000,1875.1595,0.1824,3.5546,2.7085,2.7443,2.8032,3.0144,3.4044,2.7081,0.2535,2.4522,-0.3627,0.1198,4.3776,20.5304,15.9369,15.9369,14.2852,0.0162,11.9899,15.0779,22.3440,15.0779,369.2147,9.8384,7.2161,5.8674,42.7654,32.5793,9.9483,0.3683,3.2255,1.5200,0.4713,8.7581,4.1273,0.8000
 651.0000,1977.2551,0.2264,4.5551,3.2332,3.2861,3.3859,3.7020,4.2153,3.2311,0.2535,2.4575,-0.0634,0.5426,4.3183,18.6837,14.2008,14.2008,12.6237,0.0131,11.6676,14.7669,22.0596,14.7670,309.2926,9.8487,9.0440,7.3036,29.3450,23.4787,6.9764,0.2580,2.3495,1.0675,0.4543,9.1082,4.1382,0.0000
 651.5000,1990.0842,0.2676,5.6546,3.7509,3.8255,3.9867,4.4314,5.0571,3.7446,0.2535,2.4746,0.1991,0.2024,4.3214,16.7775,12.4292,12.4292,10.9200,0.0148,10.6329,13.7685,21.1466,13.7685,266.6028,9.8493,10.6669,9.2499,24.4674,17.9082,5.1416,0.1907,1.8148,0.7839,0.4319,9.5163,4.1104,3.0000
 652.0000,2004.3080,0.2917,6.2766,4.0007,4.0932,4.3143,4.8397,5.4956,3.9890,0.2535,2.4903,0.4609,-0.4370,4.4521,16.0269,11.7374,11.7374,10.2523,0.0172,9.6777,12.8469,20.3038,12.8469,249.9540,9.8536,9.9902,7.6500,23.5779,15.6259,4.3474,0.1610,1.6007,0.6640,0.4148,9.9430,4.1247,1.0000
 652.5000,1996.0157,0.3298,7.1653,4.2808,4.4012,4.7086,5.3411,6.0661,4.2627,0.2535,2.5155,0.4404,-0.2538,4.6410,14.8845,10.6907,10.6907,9.2396,0.0177,8.1499,11.3727,18.9558,11.3727,233.6013,9.8557,9.8297,7.8063,22.4315,15.6616,4.2741,0.1579,1.6116,0.6546,0.4062,10.2062,4.1456,2.0000
 653.0000,1971.2313,0.4187,9.5698,4.8828,5.0677,5.5594,6.4783,7.4455,4.8545,0.2535,2.5474,-0.0106,0.2535,4.6716,13.7672,9.6743,9.6743,8.2531,0.0124,6.2201,9.5106,17.2530,9.5106,204.7990,9.8424,14.8393,13.7485,20.7434,16.5068,4.4082,0.1641,1.7030,0.6694,0.3931,10.3795,4.0798,0.0000
 653.5000,1973.7303,0.5090,12.6975,5.4770,5.7571,6.5173,7.8991,9.2543,5.4391,0.2535,2.5763,-0.1984,0.5159,4.5627,12.5560,8.5809,8.5809,7.1883,0.0040,4.4646,7.8167,15.7041,7.8167,182.5831,9.8371,19.8138,18.1606,21.3992,18.4289,4.8526,0.1808,1.9056,0.7359,0.3862,10.5398,4.0704,0.0000
 654.0000,1979.7766,0.5151,12.7366,5.4306,5.7625,6.6517,8.2854,9.8738,5.3926,0.2535,2.6030,0.0186,0.0623,4.5458,12.5487,8.5743,8.5743,7.1819,0.0103,2.8502,6.2589,14.2796,6.2589,184.1427,9.8427,19.6589,15.5558,26.0350,22.2347,5.7565,0.2165,2.3152,0.8637,0.3730,10.6959,3.9899,2.4000
 654.5000,2004.4575,0.5102,10.8362,4.6590,4.9482,5.6813,7.0411,8.4286,4.6310,0.2535,2.5975,-0.0209,-0.3746,4.5500,14.2302,10.0947,10.0947,8.6615,0.0244,3.1843,6.5813,14.5744,6.5814,214.6361,9.8410,15.2262,12.1565,35.6332,30.2188,7.6776,0.2894,3.1791,1.1484,0.3612,10.9838,3.9675,1.0000
 655.0000,1954.2218,0.5099,8.7543,3.7614,3.9793,4.4929,5.4601,6.5164,3.7433,0.2535,2.5387,-0.2254,-0.4740,4.4242,17.2824,12.8964,12.8964,11.3701,0.0261,6.7478,10.0198,17.7187,10.0199,265.8596,9.8611,10.4289,7.4823,51.3723,42.0994,10.7320,0.4060,4.4477,1.5988,0.3595,10.9563,3.9384,4.0000
 655.5000,2002.0046,0.5088,7.2878,3.1351,3.3061,3.6831,4.4155,5.2684,3.1229,0.2535,2.4690,-0.0679,-0.4318,4.2913,20.2653,15.6865,15.6865,14.0460,0.0223,10.9686,14.0925,21.4429,14.0925,318.9682,9.8939,6.9758,5.5215,68.8896,54.1648,13.9243,0.5259,5.7390,2.0783,0.3621,10.9136,3.9522,4.0000
 656.0000,2000.3569,0.5029,6.3594,2.7641,2.9101,3.2149,3.8309,4.5841,2.7559,0.2535,2.4297,0.3767,-0.1277,4.2576,21.9283,17.2640,17.2640,15.5500,0.0251,13.3503,16.3906,23.5444,16.3906,361.7806,9.9140,6.6505,5.1208,82.6623,66.2939,17.4209,0.6542,7.0017,2.6179,0.3739,10.7028,4.0017,2.0000
 656.5000,1966.8901,0.4903,5.6911,2.5312,2.6616,2.9220,3.4673,4.1577,2.5259,0.2535,2.4182,0.7321,-0.0201,4.2646,23.7144,18.9757,18.9757,17.1750,0.0335,14.0471,17.0629,24.1592,17.0630,395.0638,9.9436,5.6774,4.9191,92.9448,75.5738,20.5949,0.7746,7.9191,3.0892,0.3901,10.2238,3.9882,0.0000
 657.0000,1972.0490,0.4687,5.1240,2.3718,2.4898,2.7170,3.2063,3.8439,2.3688,0.2535,2.4151,0.6095,0.1125,4.2594,23.8405,19.0972,19.0972,17.2900,0.0429,14.2337,17.2430,24.3239,17.2431,421.6125,9.9435,5.8855,4.7029,103.9045,81.8147,22.9414,0.8658,8.5121,3.4272,0.4026,9.8320,3.9587,4.0000
 657.5000,1952.3447,0.4395,4.6626,2.2776,2.3861,2.5893,3.0353,3.6363,2.2760,0.2535,2.4017,0.2188,0.3838,4.2448,23.1562,18.4388,18.4388,16.6660,0.0456,15.0493,18.0300,25.0435,18.0300,439.0577,9.9282,5.6534,4.3854,111.0804,83.3533,24.2169,0.9269,8.5718,3.5563,0.4149,9.2482,3.8369,3.0000
 658.0000,1985.5698,0.4171,4.4425,2.2605,2.3637,2.5533,2.9732,3.5630,2.2600,0.2535,2.3903,-0.0090,0.0699,4.2218,23.2266,18.5064,18.5064,16.7301,0.0431,15.7411,18.6975,25.6539,18.6975,442.3863,9.8697,5.8939,4.5509,108.4047,79.0016,24.0691,0.9380,7.9633,3.4548,0.4338,8.4896,3.6831,0.0000
 658.5000,1963.1360,0.4030,4.3667,2.2796,2.3775,2.5552,2.9461,3.5098,2.2796,0.2535,2.3973,-0.1861,-0.3635,4.1987,22.5680,17.8750,17.8750,16.1308,0.0380,15.3177,18.2890,25.2804,18.2891,438.6771,9.8307,6.0071,4.8215,98.6192,72.2411,23.2285,0.9199,7.1210,3.2649,0.4585,7.7415,3.5494,3.2000
 659.0000,2015.0868,0.3820,4.2883,2.3253,2.4168,2.5824,2.9358,3.4416,2.3253,0.2535,2.4206,-0.3066,-0.1188,4.1427,20.6936,16.0912,16.0912,14.4325,0.0301,13.9042,16.9251,24.0331,16.9251,430.0571,9.8011,6.6907,5.2953,88.6712,65.6801,22.1974,0.8901,6.3365,3.0672,0.4841,7.1185,3.4458,1.6000
 659.5000,2009.2599,0.3335,4.0132,2.3722,2.4546,2.6042,2.9032,3.3098,2.3722,0.2535,2.4584,-0.2013,0.3711,4.0323,18.3775,13.9148,13.9148,12.3492,0.0242,11.6113,14.7127,22.0100,14.7127,421.5525,9.7694,7.3572,6.1532,83.6661,61.6121,21.6072,0.8756,5.8402,2.9422,0.5038,6.6698,3.3602,1.6000
 660.0000,1986.3525,0.2590,3.5534,2.3873,2.4566,2.5839,2.8113,3.0948,2.3873,0.2535,2.4937,0.1918,0.4276,4.0120,17.5709,13.1640,13.1640,11.6277,0.0192,9.4740,12.6503,20.1241,12.6503,418.8850,9.7535,9.5424,7.2438,82.1440,58.1488,21.0172,0.8566,5.4435,2.8387,0.5215,6.3547,3.3138,2.0000
 660.5000,1951.6654,0.1852,3.1389,2.3807,2.4354,2.5385,2.6946,2.8727,2.3807,0.2535,2.5248,0.4385,0.1952,4.0883,17.8751,13.4468,13.4468,11.8996,0.0179,7.5889,10.8313,18.4608,10.8314,420.0422,9.7181,9.0195,6.1855,79.8243,57.8117,21.6557,0.8805,5.3228,2.9348,0.5514,6.0449,3.3330,1.0000
 661.0000,1949.1776,0.1250,2.8275,2.3568,2.3971,2.4768,2.5739,2.6794,2.3568,0.2535,2.5464,0.0756,-0.0132,4.0209,18.6555,14.1745,14.1745,12.5985,0.0138,6.2787,9.5671,17.3047,9.5672,424.3015,9.6901,6.7704,3.8653,76.3920,59.4477,23.0946,0.9349,5.3914,3.1495,0.5842,5.7667,3.3687,2.0000
 661.5000,1990.3384,0.0784,2.5680,2.2959,2.3225,2.3799,2.4345,2.4983,2.2959,0.2535,2.5523,-0.3482,-0.2104,3.7956,20.2145,15.6386,15.6386,14.0002,0.0070,5.9206,9.2217,16.9888,9.2217,435.5582,9.6622,5.5255,3.0385,76.3965,62.6571,25.5272,1.0256,5.5512,3.5182,0.6338,5.4127,3.4304,0.0000
 662.0000,1942.2563,0.0479,2.3562,2.2025,2.2173,2.2554,2.2851,2.3333,2.2025,0.2535,2.5500,-0.2940,-0.0468,3.6483,21.7058,17.0520,17.0520,15.3483,0.0077,6.0618,9.3578,17.1133,9.3579,454.0374,9.6293,5.2178,2.8523,81.5748,67.0586,29.0431,1.1539,5.7277,4.0642,0.7096,4.9638,3.5222,4.0000
 662.5000,1884.5922,0.0325,2.1964,2.0986,2.1041,2.1273,2.1454,2.1948,2.0986,0.2535,2.5402,-0.0613,0.1471,3.5282,23.8449,19.1014,19.1014,17.2940,0.0123,6.6525,9.9278,17.6345,9.9278,476.5149,9.6071,4.5989,2.4637,92.9439,71.0706,32.8062,1.2889,5.8178,4.6595,0.8009,4.5137,3.6150,0.0000
 663.0000,1841.9108,0.0246,2.0573,1.9879,1.9863,1.9981,2.0110,2.0624,1.9879,0.2535,2.5340,0.0460,0.0653,3.3309,26.2704,21.4564,21.4564,19.5175,0.0171,7.0306,10.2927,17.9682,10.2927,503.0334,9.6360,3.2133,1.8064,102.5528,72.4598,35.7018,1.3896,5.6589,5.1329,0.9070,4.0723,3.6938,3.0000
 663.5000,1928.4938,0.0177,2.0404,1.9909,1.9818,1.9858,1.9948,2.0416,1.9909,0.2535,2.5360,0.1641,-0.0770,3.2576,27.1278,22.2967,22.2967,20.3078,0.0203,6.9072,10.1736,17.8593,10.1736,502.2791,9.6801,2.9933,1.6999,97.9768,71.0620,37.0967,1.4317,5.3047,5.3914,1.0164,3.7052,3.7658,1.0000
 664.0000,1972.6023,0.0016,2.1027,2.0981,2.0800,2.0763,2.0786,2.1020,2.0981,0.2535,2.5466,0.1018,-0.3799,3.3853,24.7550,19.9812,19.9812,18.1261,0.0231,6.2643,9.5532,17.2920,9.5532,476.6322,9.6432,3.4758,2.0272,85.6485,66.3618,36.2883,1.4032,4.7576,5.2609,1.1058,3.3905,3.7492,2.0000
 664.5000,1980.1455,-0.0098,2.2102,2.2402,2.2115,2.1994,2.1904,2.2111,2.2402,0.2535,2.5549,-0.2011,-0.1837,3.5206,23.3297,18.6055,18.6055,16.8241,0.0239,5.7615,9.0681,16.8483,9.0681,446.3822,9.6597,3.6750,2.0684,78.0488,60.4385,34.3577,1.3347,4.1599,4.9520,1.1904,3.1168,3.7103,1.0000
 665.0000,1986.3188,-0.0292,2.3023,2.3956,2.3553,2.3350,2.3096,2.3061,2.3956,0.2535,2.5477,-0.2020,0.2268,3.5338,23.5804,18.8467,18.8467,17.0527,0.0186,6.1974,9.4887,17.2330,9.4887,417.4366,9.6867,3.2741,1.9841,75.0796,55.6548,32.8356,1.2863,3.6640,4.6815,1.2777,2.8484,3.6394,1.0000
 665.5000,1955.5005,-0.0508,2.4731,2.6482,2.5935,2.5645,2.5162,2.4830,2.6482,0.2535,2.5390,-0.1024,-0.1158,3.5338,22.7984,18.0957,18.0957,16.3404,0.0106,6.7270,9.9998,17.7003,9.9998,377.6193,9.7152,4.4872,2.5297,71.5920,52.9206,32.3971,1.2784,3.3260,4.5752,1.3756,2.6017,3.5789,0.8000
 666.0000,1961.2352,-0.0707,2.5940,2.8504,2.7817,2.7455,2.6718,2.6101,2.8504,0.2535,2.5405,-0.2937,-0.1158,3.5655,21.8654,17.2040,17.2040,15.4930,0.0043,6.6337,9.9097,17.6180,9.9097,350.8230,9.7152,4.7238,2.6917,66.5895,50.8574,32.1729,1.2857,3.0660,4.4667,1.4569,2.3847,3.4741,3.2000
 666.5000,1979.3976,-0.0866,2.6559,2.9783,2.8974,2.8561,2.7592,2.6770,2.9783,0.2535,2.5442,-0.3577,0.3343,3.5531,21.4362,16.7956,16.7956,15.1041,-0.0010,6.4135,9.6972,17.4236,9.6972,335.7589,9.7165,4.7796,2.9984,60.1729,49.2140,32.0681,1.3010,2.8442,4.3600,1.5329,2.1862,3.3514,4.0000
 667.0000,1965.5078,-0.0989,2.7144,3.0913,2.9997,2.9547,2.8373,2.7413,3.0913,0.2535,2.5434,-0.1578,0.0450,3.5293,21.1655,16.5385,16.5385,14.8591,-0.0041,6.4617,9.7437,17.4662,9.7437,323.4906,9.7193,4.9353,3.1159,56.7683,47.3901,31.7967,1.3145,2.6095,4.2065,1.6120,1.9851,3.2000,3.0000
 667.5000,1984.1077,-0.1062,2.7288,3.1362,3.0377,2.9909,2.8600,2.7561,3.1362,0.2535,2.5419,-0.0804,-0.2393,3.5438,21.0070,16.3881,16.3881,14.7157,-0.0047,6.5498,9.8288,17.5440,9.8288,318.8533,9.7143,4.6108,2.9955,57.5427,46.1405,31.8633,1.3424,2.4091,4.0962,1.7003,1.7947,3.0515,2.0000
 668.0000,1948.6816,-0.1099,2.6951,3.1117,3.0108,2.9640,2.8271,2.7206,3.1117,0.2535,2.5423,-0.1161,0.0562,3.5885,20.7827,16.1756,16.1756,14.5130,-0.0038,6.5300,9.8097,17.5265,9.8097,321.3664,9.7254,5.2216,3.2950,57.3527,46.1932,32.6442,1.3978,2.3050,4.0897,1.7743,1.6490,2.9258,3.0000
 668.5000,1987.5852,-0.1092,2.5584,2.9513,2.8553,2.8109,2.6792,2.5803,2.9513,0.2535,2.5364,-0.0181,0.2573,3.5504,20.8937,16.2807,16.2807,14.6133,-0.0018,6.8871,10.1542,17.8415,10.1542,338.8310,9.7583,5.1848,3.0677,60.1961,46.7909,34.0116,1.4663,2.2134,4.2136,1.9037,1.5095,2.8736,4.0000
 669.0000,1944.3168,-0.1099,2.4854,2.8695,2.7785,2.7359,2.6085,2.5061,2.8695,0.2535,2.5288,0.0920,0.0712,3.4195,21.7765,17.1194,17.1194,15.4124,-0.0002,7.3483,10.5992,18.2485,10.5993,348.4964,9.7488,3.9695,2.2904,62.1982,45.1984,33.9391,1.4636,1.9907,4.2030,2.1113,1.3602,2.8717,2.0000
 669.5000,1973.3165,-0.1205,2.7345,3.1985,3.1030,3.0567,2.9154,2.7654,3.1985,0.2535,2.5449,0.0511,-0.0380,3.5019,21.3685,16.7312,16.7312,15.0428,0.0036,6.3696,9.6548,17.3849,9.6548,312.6460,9.7543,4.4259,2.9705,54.8751,42.9983,33.1979,1.4280,1.7802,4.1283,2.3190,1.2467,2.8910,1.0000
 670.0000,1834.3451,-0.1254,3.0122,3.5443,3.4489,3.4004,3.2520,3.0551,3.5443,0.2535,2.5812,-0.0352,-0.0944,3.7482,18.6623,14.1808,14.1808,12.6045,0.0092,4.1715,7.5339,15.4455,7.5339,282.1404,9.7437,8.2760,5.1813,49.1133,43.6595,34.4865,1.4773,1.7169,4.3178,2.5150,1.1622,2.9229,1.0000
 670.5000,1854.4993,-0.1014,2.5501,2.9135,2.8469,2.8112,2.7081,2.5755,2.9135,0.2535,2.5867,-0.0186,-0.2425,3.6646,18.8183,14.3267,14.3267,12.7445,0.0120,3.8342,7.2084,15.1478,7.2084,343.2293,9.7802,7.7543,4.4414,56.5354,48.7016,39.1009,1.6724,1.8346,4.9076,2.6750,1.0970,2.9345,2.0000
 671.0000,1912.6123,-0.0621,1.9461,2.1148,2.0766,2.0546,2.0012,1.9547,2.1148,0.2535,2.5475,0.0801,-0.1103,3.2599,23.2091,18.4896,18.4896,16.7142,0.0129,6.2108,9.5017,17.2448,9.5017,472.8517,9.7965,4.6899,2.7021,72.7144,56.6614,46.0831,1.9602,2.0518,5.8352,2.8439,1.0467,2.9768,1.6000
 671.5000,1901.5331,-0.0270,1.6368,1.6981,1.6762,1.6620,1.6387,1.6396,1.6981,0.2535,2.5139,0.1309,-0.0765,2.9857,28.2788,23.4310,23.4310,21.3721,0.0143,8.2457,11.4652,19.0403,11.4652,588.9096,9.8787,3.5008,1.9521,85.7993,63.5925,52.2317,2.2163,2.2080,6.6397,3.0071,0.9963,2.9959,1.6000
 672.0000,1965.5192,-0.0026,1.4689,1.4743,1.4635,1.4547,1.4487,1.4695,1.4743,0.2535,2.5039,0.0839,-0.2144,2.9911,31.5467,26.6915,26.6915,24.4162,0.0147,8.8540,12.0521,19.5770,12.0521,678.2976,9.9257,2.4443,1.4430,91.9420,67.7430,55.8257,2.3617,2.3124,7.1300,3.0833,0.9791,3.0190,4.8000
 672.5000,1940.8854,0.0081,1.3994,1.3838,1.3800,1.3740,1.3769,1.3994,1.3838,0.2535,2.5040,0.0577,-0.1458,3.0919,31.8295,26.9764,26.9764,24.6811,0.0138,8.8501,12.0483,19.5736,12.0484,722.6489,9.9800,2.2697,1.3726,93.3642,69.5034,57.2916,2.4353,2.3722,7.2623,3.0613,0.9741,2.9820,2.0000
 673.0000,1939.2850,0.0159,1.3784,1.3484,1.3498,1.3460,1.3534,1.3784,1.3484,0.2535,2.5110,0.0383,-0.1731,3.1862,31.4777,26.6220,26.6220,24.3515,0.0151,8.4237,11.6369,19.1973,11.6369,741.6469,9.9497,2.3790,1.4447,92.5451,70.7204,58.2954,2.4929,2.4088,7.3188,3.0383,0.9663,2.9359,2.0000
 673.5000,1914.9043,0.0177,1.3569,1.3240,1.3290,1.3270,1.3361,1.3569,1.3240,0.2535,2.5075,-0.0378,-0.1937,3.2994,31.5756,26.7206,26.7206,24.4432,0.0159,8.6388,11.8444,19.3871,11.8444,755.2914,9.9597,2.4032,1.4319,94.4758,73.3451,60.8937,2.6247,2.4328,7.5468,3.1021,0.9269,2.8753,7.0000
 674.0000,1924.8768,0.0188,1.3497,1.3148,1.3228,1.3220,1.3306,1.3497,1.3148,0.2535,2.4944,-0.0449,0.1186,3.3337,30.8111,25.9525,25.9525,23.7281,0.0143,9.4304,12.6083,20.0857,12.6083,760.5504,9.9939,2.4881,1.4001,98.4916,76.6012,64.3164,2.7869,2.4182,7.9017,3.2676,0.8677,2.8353,2.0000
 674.5000,1942.1642,0.0210,1.3458,1.3070,1.3170,1.3174,1.3245,1.3458,1.3070,0.2535,2.4796,-0.0879,0.2309,3.1962,30.8678,26.0093,26.0093,23.7811,0.0112,10.3277,13.4741,20.8774,13.4741,765.1279,10.0144,2.6815,1.4892,100.1154,79.9992,67.6611,2.9415,2.4545,8.2664,3.3678,0.8344,2.8102,1.0000
 675.0000,1930.4058,0.0233,1.3132,1.2711,1.2820,1.2833,1.2928,1.3132,1.2711,0.2535,2.4624,-0.2838,0.2764,3.0297,30.6258,25.7668,25.7668,23.5551,0.0090,11.3678,14.4777,21.7951,14.4777,786.7103,10.0472,2.0590,1.2023,101.0174,80.6183,68.4758,2.9846,2.4422,8.3297,3.4108,0.8183,2.7909,2.0000
 675.5000,1962.3296,0.0241,1.3238,1.2801,1.2916,1.2935,1.3027,1.3238,1.2801,0.2535,2.4640,-0.3838,0.3022,2.9424,30.4965,25.6373,25.6373,23.4344,0.0085,11.2717,14.3850,21.7103,14.3850,781.2142,10.0601,2.4652,1.4243,100.1734,76.1635,64.7830,2.8326,2.2822,7.8378,3.4343,0.8057,2.7670,1.0000
 676.0000,1944.9275,0.0232,1.3242,1.2821,1.2935,1.2958,1.3037,1.3242,1.2821,0.2535,2.4779,-0.0032,-0.0872,2.8820,31.4695,26.6138,26.6138,24.3438,0.0063,10.4322,13.5749,20.9696,13.5750,779.9864,10.0818,2.4493,1.3994,91.6271,69.4199,59.5078,2.5965,2.0020,7.2257,3.6092,0.7711,2.7829,0.0000
 676.5000,1976.5758,0.0201,1.3036,1.2676,1.2781,1.2805,1.2861,1.3036,1.2676,0.2535,2.4887,0.4562,-0.1620,2.8510,32.1925,27.3427,27.3427,25.0215,0.0053,9.7746,12.9404,20.3893,12.9404,788.8657,10.0815,1.8727,1.2353,81.6756,65.2292,56.2059,2.4491,1.8193,6.8401,3.7597,0.7428,2.7929,2.0000
 677.0000,1995.6469,0.0147,1.3436,1.3165,1.3263,1.3287,1.3315,1.3436,1.3165,0.2535,2.5031,0.2739,-0.1720,2.8806,29.7812,24.9227,24.9227,22.7676,0.0089,8.9041,12.1005,19.6213,12.1005,759.6116,10.1039,2.6139,1.5641,83.0032,67.6552,58.5934,2.5421,1.8428,7.1834,3.8982,0.7249,2.8258,1.0000
 677.5000,1961.8921,0.0097,1.4031,1.3844,1.3931,1.3954,1.3959,1.4031,1.3844,0.2535,2.5042,-0.1205,-0.2354,2.9449,30.5558,25.6967,25.6967,23.4898,0.0137,8.8379,12.0365,19.5628,12.0366,722.3597,10.0935,3.2424,1.7712,94.4053,76.8827,66.6979,2.8754,2.0877,8.2636,3.9583,0.7260,2.8738,0.8000
 678.0000,1966.6022,0.0078,1.3878,1.3729,1.3793,1.3813,1.3809,1.3878,1.3729,0.2535,2.4809,-0.0652,0.3166,2.9809,32.2758,27.4268,27.4268,25.0996,0.0164,10.2509,13.4000,20.8096,13.4000,728.3635,10.1195,2.7576,1.4547,109.3121,87.2314,75.9502,3.2407,2.3488,9.5695,4.0742,0.7248,2.9529,0.8000
 678.5000,1959.3008,0.0079,1.3594,1.3446,1.3485,1.3500,1.3492,1.3594,1.3446,0.2535,2.4619,0.2535,0.0626,2.9805,34.1829,29.3640,29.3640,26.8950,0.0166,11.4014,14.5101,21.8248,14.5101,743.7181,10.1891,2.0886,1.3299,122.2212,93.4079,81.1850,3.4330,2.5363,10.3764,4.0911,0.7388,3.0226,0.8000
 679.0000,1980.7562,0.0086,1.4002,1.3837,1.3853,1.3865,1.3844,1.4002,1.3837,0.2535,2.4682,0.1929,-0.8530,3.0087,34.2793,29.4624,29.4624,26.9861,0.0178,11.0195,14.1416,21.4878,14.1417,722.7244,10.1418,2.8537,1.5387,125.5526,94.5437,81.6457,3.4339,2.6364,10.5235,3.9917,0.7678,3.0646,3.0000
 679.5000,1957.3776,0.0063,1.4175,1.4053,1.4044,1.4052,1.4005,1.4175,1.4053,0.2535,2.4773,-0.2485,-0.4943,3.0580,32.8564,28.0145,28.0145,25.6451,0.0212,10.4690,13.6104,21.0020,13.6104,711.6064,10.1346,2.2896,1.2928,119.6445,92.1528,78.4111,3.2969,2.7200,10.1112,3.7173,0.8250,3.0669,2.0000
 680.0000,1947.9799,-0.0003,1.4339,1.4344,1.4309,1.4314,1.4242,1.4339,1.4344,0.2535,2.4864,-0.2887,0.3839,3.0770,34.4912,29.6790,29.6790,27.1863,0.0258,9.9158,13.0767,20.5140,13.0767,697.1507,10.1474,2.1588,1.3171,107.7829,87.5151,73.0772,3.0976,2.7593,9.3047,3.3722,0.8908,3.0038,1.0000
 680.5000,1943.4767,-0.0030,1.5276,1.5340,1.5278,1.5278,1.5278,1.5278,1.5340,0.2535,2.5061,0.0272,0.3711,3.0562,31.9182,27.0658,27.0658,24.7642,0.0259,8.7228,11.9255,19.4613,11.9255,651.8956,10.1866,2.8273,1.6253,97.5360,84.0311,68.9709,2.9468,2.8061,8.6715,3.0903,0.9522,2.9427,3.0000
 681.0000,1924.9004,-0.0165,1.5939,1.6304,1.6217,1.6211,1.6183,1.5942,1.6304,0.2535,2.5085,0.0738,-0.0642,2.9935,29.9174,25.0585,25.0585,22.8944,0.0199,8.5772,11.7850,19.3328,11.7850,613.3643,10.2517,3.0424,1.7709,98.7030,82.6167,66.9316,2.8900,2.8770,8.2714,2.8750,0.9955,2.8621,0.0000
 681.5000,1946.6786,-0.0274,1.5973,1.6581,1.6479,1.6468,1.6399,1.5976,1.6581,0.2535,2.4959,-0.1260,-0.2444,2.9387,31.1758,26.3185,26.3185,24.0690,0.0167,9.3366,12.5178,20.0029,12.5178,603.1150,10.2889,2.7109,1.6066,107.0423,83.3034,66.6882,2.9084,3.0209,8.1041,2.6827,1.0387,2.7865,2.0000
 682.0000,1931.3156,-0.0354,1.6347,1.7150,1.7040,1.7024,1.6915,1.6350,1.7150,0.2535,2.4939,-0.4260,-0.1662,2.9218,30.7972,25.9385,25.9385,23.7151,0.0160,9.4589,12.6358,20.1108,12.6358,583.1069,10.3191,2.6699,1.6308,108.3833,84.8627,67.3935,2.9645,3.1695,8.0695,2.5459,1.0692,2.7220,2.0000
 682.5000,1984.7296,-0.0425,1.7089,1.8100,1.7990,1.7969,1.7811,1.7094,1.8100,0.2535,2.4937,-0.5334,0.3496,2.8734,29.3260,24.4695,24.4695,22.3441,0.0128,9.4726,12.6490,20.1229,12.6490,552.4919,10.3698,3.6671,2.0382,103.3549,85.2584,67.7458,3.0000,3.1806,8.0169,2.5206,1.0602,2.6723,2.0000
 683.0000,1937.7070,-0.0463,1.6894,1.7983,1.7893,1.7868,1.7659,1.6898,1.7983,0.2535,2.4873,-0.2004,0.4705,2.8055,29.1948,24.3390,24.3390,22.2221,0.0116,9.8635,13.0262,20.4678,13.0262,556.0898,10.3889,2.9612,1.7796,101.2065,86.3824,69.1049,3.0565,3.1773,8.1951,2.5793,1.0395,2.6812,3.0000
 683.5000,1914.2700,-0.0409,1.6316,1.7244,1.7187,1.7162,1.6931,1.6319,1.7244,0.2535,2.4882,0.1765,-0.2448,2.8274,30.3050,25.4457,25.4457,23.2557,0.0153,9.8085,12.9731,20.4192,12.9731,579.9216,10.4305,2.8855,1.6481,106.3455,89.5076,71.8003,3.1673,3.2966,8.5547,2.5950,1.0408,2.7010,3.2000
 684.0000,1895.6252,-0.0252,1.5557,1.6100,1.6084,1.6059,1.5900,1.5558,1.6100,0.2535,2.4900,0.2753,-0.6496,2.9523,31.2498,26.3928,26.3928,24.1382,0.0194,9.7000,12.8684,20.3235,12.8684,621.1096,10.4897,2.7823,1.6137,115.2701,92.9779,74.3664,3.2639,3.4851,8.9391,2.5650,1.0678,2.7388,5.6000
 684.5000,1939.6989,-0.0029,1.4689,1.4748,1.4766,1.4743,1.4747,1.4686,1.4748,0.2535,2.4803,0.2275,-0.4100,3.0147,33.2764,28.4407,28.4407,26.0403,0.0239,10.2852,13.4330,20.8398,13.4331,678.0712,10.5217,2.7188,1.5540,119.3697,94.2808,75.1756,3.2721,3.6003,9.1658,2.5459,1.1003,2.8012,1.6000
 685.0000,1970.1956,0.0176,1.3579,1.3252,1.3292,1.3272,1.3403,1.3570,1.3252,0.2535,2.4733,0.1828,-0.1261,2.9345,33.3026,28.4674,28.4674,26.0649,0.0287,10.7118,13.8447,21.2163,13.8447,754.6073,10.4648,1.9972,1.3697,115.6395,87.2858,69.1506,2.9890,3.4042,8.5301,2.5058,1.1389,2.8538,2.0000
 685.5000,1975.2745,0.0339,1.2829,1.2234,1.2286,1.2266,1.2438,1.2819,1.2234,0.2535,2.4694,0.1620,0.1961,2.8789,33.6341,28.8045,28.8045,26.3773,0.0234,10.9476,14.0723,21.4244,14.0723,817.3992,10.4083,2.4153,1.3564,98.4853,74.8607,58.9349,2.5327,2.9910,7.3402,2.4541,1.1810,2.8982,0.0000
 686.0000,2042.5199,0.0434,1.2294,1.1566,1.1623,1.1600,1.1778,1.2289,1.1566,0.2535,2.4694,0.1612,0.5890,2.8938,34.2223,29.4042,29.4042,26.9322,0.0130,10.9444,14.0691,21.4215,14.0691,864.5700,10.3412,1.8392,1.1944,73.1748,60.8508,47.2966,2.0322,2.5323,5.8922,2.3268,1.2461,2.8994,1.0000
 686.5000,2006.3571,0.0497,1.2885,1.2013,1.2073,1.2044,1.2249,1.2873,1.2013,0.2535,2.4890,0.0623,0.2679,2.8917,33.1260,28.2880,28.2880,25.8987,0.0123,9.7575,12.9239,20.3742,12.9239,832.4181,10.2593,2.4705,1.5989,56.8771,50.7749,38.8639,1.6713,2.2094,4.8349,2.1883,1.3220,2.8930,3.0000
 687.0000,2000.5302,0.0541,1.3675,1.2669,1.2723,1.2686,1.2930,1.3659,1.2669,0.2535,2.5052,-0.1874,-0.4384,2.8434,31.7911,26.9376,26.9376,24.6450,0.0130,8.7742,11.9751,19.5066,11.9751,789.3074,10.2324,2.3438,1.4526,54.4531,49.9080,37.5217,1.6185,2.2745,4.6448,2.0421,1.4054,2.8699,9.0000
 687.5000,1990.2338,0.0579,1.4539,1.3395,1.3426,1.3380,1.3669,1.4519,1.3395,0.2535,2.4912,-0.3159,-0.2004,2.6942,30.5447,25.6855,25.6855,23.4793,0.0096,9.6225,12.7936,20.2551,12.7936,746.5314,10.2312,2.2885,1.4364,64.7757,56.7209,42.0812,1.8163,2.6609,5.2037,1.9556,1.4651,2.8650,3.0000
 688.0000,1996.7524,0.0620,1.6040,1.4689,1.4666,1.4608,1.4958,1.6015,1.4689,0.2535,2.4637,-0.2281,0.7723,2.5150,28.4598,23.6101,23.6101,21.5399,0.0126,11.2910,14.4036,21.7273,14.4036,680.7829,10.2875,2.4069,1.5069,81.1421,64.1263,47.0995,2.0312,3.0560,5.8320,1.9084,1.5045,2.8712,2.0000
 688.5000,1983.2900,0.0622,1.8522,1.6958,1.6771,1.6679,1.7158,1.8488,1.6958,0.2535,2.4644,-0.1310,0.7699,2.5486,26.6790,21.8563,21.8563,19.8937,0.0207,11.2482,14.3622,21.6895,14.3623,589.6874,10.3087,2.3257,1.5232,88.1145,64.8994,46.8885,2.0399,3.1834,5.7215,1.7973,1.5606,2.8048,5.0000
 689.0000,1974.8134,0.0486,2.7962,2.6111,2.5477,2.5258,2.6035,2.7910,2.6111,0.2535,2.5640,0.1108,-0.0277,3.0120,22.2024,17.5255,17.5255,15.7987,0.0278,5.2095,8.5355,16.3613,8.5355,382.9810,10.1127,2.3414,2.0617,74.9449,53.9341,38.0185,1.6680,2.7706,4.5731,1.6506,1.6611,2.7417,1.6000
 689.5000,1984.0729,-0.0212,6.4230,6.6120,6.3021,6.2101,6.3197,6.4155,6.6119,0.2535,2.7541,0.4081,0.0960,3.8435,9.9999,6.3016,6.3016,4.9569,0.0229,-6.3108,-2.5806,6.1964,-2.5806,151.2401,9.9219,13.5912,18.1664,44.2973,35.8446,24.5534,1.0808,1.9416,2.9364,1.5123,1.7965,2.7168,1.6000
 690.0000,1975.7919,-0.0866,28.1776,31.5996,29.9351,29.4388,29.2305,28.2981,31.5977,0.2535,2.9032,0.3846,0.5412,4.5732,3.1053,0.3486,0.3486,-0.9544,0.0073,-15.3482,-11.3010,-1.7779,-11.3009,31.6459,9.7329,24.5950,36.1133,18.3809,19.3800,13.0079,0.5697,1.0908,1.5693,1.4387,1.9146,2.7546,0.8000
 690.5000,1981.8966,-0.1422,145.7370,174.8610,166.5676,163.7791,160.6296,150.8035,175.0050,0.2535,2.9593,0.1078,0.2435,4.9226,1.1550,-1.2828,-1.2828,-2.5976,0.0080,-18.7483,-14.5817,-4.7779,-14.5816,5.7188,9.6312,29.6041,41.0672,9.1244,9.8751,6.5602,0.2830,0.5661,0.8122,1.4346,2.0008,2.8703,2.4000
 691.0000,1960.7742,-0.2695,171.1141,236.3183,221.4390,216.1300,203.5695,176.8221,236.6217,0.2535,2.9784,-0.1518,-0.3319,5.0497,0.6348,-1.7140,-1.7140,-3.0337,0.0193,-19.9010,-15.6940,-5.7950,-15.6940,4.2316,9.5942,33.9410,50.4734,7.6309,6.7579,4.5285,0.1921,0.3817,0.5760,1.1521,1.9870,2.9989,0.0000
 691.5000,1978.5912,-0.2661,525.7299,721.2761,683.5040,659.9249,613.9776,570.9084,724.4413,0.2535,2.9856,-0.0582,-0.3149,5.0679,0.6674,-1.6871,-1.6871,-3.0064,0.0179,-20.3391,-16.1167,-6.1816,-16.1167,1.3864,9.5456,33.1003,49.0873,7.7754,6.3190,4.2875,0.1785,0.3499,0.5612,1.1224,1.9597,3.1433,3.0000
 692.0000,1982.9561,-0.2391,801.8586,1065.0145,1032.6563,1005.4231,949.9054,893.8543,1074.1599,0.2535,2.9810,0.1322,0.1726,5.0304,0.7270,-1.6377,-1.6377,-2.9565,0.0116,-20.0602,-15.8476,-5.9355,-15.8476,0.9390,9.5186,30.9146,47.0111,8.4169,6.4815,4.4703,0.1828,0.3502,0.6009,1.2018,1.9158,3.2868,4.0000
 692.5000,1979.7080,-0.2860,445.0923,622.7061,580.7252,556.6946,525.7961,471.4913,625.9074,0.2535,2.9711,0.0273,0.3148,4.9792,0.8824,-1.5090,-1.5090,-2.8263,0.0082,-19.4584,-15.2669,-5.4044,-15.2668,1.6059,9.5633,27.1876,42.6320,9.1030,7.3162,5.0821,0.2056,0.3931,0.6935,1.3871,1.9113,3.3725,3.0000
 693.0000,1906.0936,-0.1655,160.9610,198.4190,183.0510,176.2979,173.1382,163.8203,198.6653,0.2535,2.9613,-0.0973,0.0460,4.8888,1.1357,-1.2989,-1.2989,-2.6139,0.0086,-18.8657,-14.6950,-4.8815,-14.6950,5.0398,9.5088,28.7848,42.5140,10.0148,9.2571,6.4058,0.2568,0.5030,0.8858,1.7609,1.9591,3.4498,1.0000
 693.5000,1826.7209,-0.1701,207.0072,256.4508,222.7691,192.4544,209.8155,211.4893,256.8453,0.2535,2.9463,-0.1808,-0.5091,4.7302,2.0311,-0.5529,-0.5529,-1.8611,0.0081,-17.9559,-13.8171,-4.0788,-13.8171,3.8994,9.4517,26.5433,40.7784,12.1561,12.5075,8.5285,0.3404,0.6960,1.1864,1.7047,2.0447,3.4856,5.0000
 694.0000,1832.7672,-0.0656,73.0718,79.7352,67.5614,59.3749,66.6994,73.4482,79.7709,0.2535,2.9050,-0.2411,-0.8198,4.4857,3.9475,1.0603,1.0603,-0.2409,-0.0023,-15.4555,-11.4044,-1.8725,-11.4044,12.5415,9.3500,30.1239,43.2489,19.2793,19.0616,12.6697,0.5057,1.0955,1.7623,1.6087,2.1663,3.4850,4.0000
 694.5000,1904.3088,0.0014,20.2144,20.1727,18.3462,17.4576,18.6336,20.2329,20.1748,0.2535,2.8271,-0.0787,-0.3191,4.2376,7.9601,4.5106,4.5106,3.1916,-0.0057,-10.7343,-6.8489,2.2933,-6.8488,49.5718,9.2643,37.4604,43.1349,34.3047,31.0071,20.1069,0.8122,1.8379,2.7508,1.4967,2.2627,3.3868,1.0000
 695.0000,1981.7009,0.0296,5.6221,5.3945,5.1256,5.0176,5.2153,5.6072,5.3946,0.2535,2.7131,0.1389,0.2571,4.0054,14.4335,10.2796,10.2796,8.8409,0.0080,-3.8241,-0.1812,8.3905,-0.1812,185.3750,9.2918,24.5346,14.8753,58.7258,46.0013,29.5965,1.2028,2.7457,4.0150,1.4623,2.2829,3.3382,0.0000
 695.5000,2012.3573,0.0418,2.8296,2.6680,2.6009,2.5781,2.6494,2.8155,2.6680,0.2535,2.6130,0.1972,0.1653,3.7146,20.9491,16.3332,16.3332,14.6634,0.0249,2.2438,5.6738,13.7445,5.6738,374.8180,9.3200,6.7850,2.6684,81.9736,57.0794,36.4179,1.4890,3.4467,4.8976,1.4210,2.3148,3.2893,4.0000
 696.0000,1984.7982,0.0529,2.2416,2.0802,2.0565,2.0502,2.0923,2.2257,2.0801,0.2535,2.5936,0.0992,-0.0697,3.4853,27.7436,22.9027,22.9027,20.8767,0.0341,3.4175,6.8064,14.7802,6.8064,480.7340,9.4581,3.3287,2.2577,82.6623,60.9021,39.0011,1.5779,3.6626,5.3242,1.4537,2.3212,3.3743,3.2000
 696.5000,2008.8561,0.0604,2.0884,1.9174,1.9147,1.9188,1.9496,2.0700,1.9171,0.2535,2.5956,-0.0192,-0.2477,3.3291,28.2740,23.4263,23.4263,21.3677,0.0298,3.2987,6.6918,14.6754,6.6918,521.5336,9.5603,3.2206,2.2166,68.4364,58.2251,37.3744,1.4956,3.4950,5.1806,1.4823,2.3369,3.4640,3.2000
 697.0000,1966.9475,0.0814,2.0459,1.8214,1.8340,1.8472,1.9046,2.0243,1.8210,0.2535,2.5610,0.1778,-0.3527,3.1968,28.8834,24.0298,24.0298,21.9328,0.0196,5.3949,8.7144,16.5249,8.7144,549.0371,9.5787,2.9149,1.9412,62.9547,53.2433,34.3268,1.3574,3.1831,4.8352,1.5190,2.3451,3.5622,7.0000
 697.5000,1960.9822,0.0918,2.0571,1.8032,1.8292,1.8525,1.9183,2.0343,1.8028,0.2535,2.5529,0.3566,-0.0417,3.2544,26.0451,21.2362,21.2362,19.3101,0.0147,5.8830,9.1853,16.9556,9.1853,554.5756,9.6053,2.6418,1.7734,65.2709,48.8923,31.3974,1.2342,2.9309,4.4574,1.5208,2.3747,3.6115,1.0000
 698.0000,1960.1758,0.1166,2.4341,2.0557,2.1064,2.1525,2.2466,2.3767,2.0552,0.2535,2.6316,0.0003,0.4845,3.5642,21.4754,16.8328,16.8328,15.1396,0.0195,1.1126,4.5823,12.7464,4.5823,486.4460,9.5122,2.6544,2.3663,60.9009,43.3469,27.3693,1.0731,2.6496,3.8986,1.4714,2.4691,3.6331,3.0000
 698.5000,1975.8156,0.2037,3.7440,2.7570,2.8742,2.9886,3.1794,3.3951,2.7561,0.2535,2.7380,-0.4030,0.4753,3.9471,16.3663,12.0498,12.0498,10.5540,0.0236,-5.3334,-1.6376,7.0587,-1.6375,362.7172,9.4030,11.7126,12.0289,48.4959,37.2535,23.1040,0.9046,2.3278,3.2969,1.4163,2.5731,3.6443,3.0000
 699.0000,1982.2183,0.2378,3.9136,2.7251,2.8622,3.0053,3.2213,3.4801,2.7242,0.2535,2.7320,-0.3103,-0.2660,3.9514,15.9131,11.6328,11.6328,10.1513,0.0225,-4.9700,-1.2869,7.3794,-1.2869,366.9654,9.2754,11.9905,10.6243,41.9454,32.1817,19.7236,0.7740,2.0342,2.8062,1.3795,2.6280,3.6254,4.0000
 699.5000,1956.0764,0.2068,2.9811,2.1840,2.2838,2.3924,2.5516,2.7860,2.1835,0.2535,2.6168,-0.0125,-0.5569,3.4905,22.7219,18.0224,18.0224,16.2708,0.0272,2.0105,5.4487,13.5387,5.4487,457.8685,9.3024,6.6512,3.6770,38.7175,27.4271,16.7580,0.6614,1.7318,2.3663,1.3664,2.6183,3.5775,4.0000
 700.0000,1975.8503,0.2071,2.6677,1.9536,2.0408,2.1401,2.2869,2.5341,1.9532,0.2535,2.5157,0.0838,-0.1623,3.0820,25.1942,20.4074,20.4074,18.5286,0.0296,8.1383,11.3615,18.9455,11.3615,511.8768,9.3422,5.5973,3.1296,33.3590,23.8985,14.5807,0.5799,1.5002,2.0381,1.3586,2.5871,3.5148,5.6000
 700.5000,1964.1493,0.2456,2.9643,2.0376,2.1386,2.2593,2.4403,2.7568,2.0369,0.2535,2.4991,-0.0077,0.1818,3.0551,25.4209,20.6279,20.6279,18.7367,0.0291,9.1464,12.3342,19.8350,12.3342,490.7783,9.2938,5.6953,3.7579,28.8124,20.4391,12.4580,0.4949,1.2738,1.7438,1.3690,2.5736,3.5231,5.6000
 701.0000,1992.2155,0.3273,4.0365,2.4157,2.5638,2.7528,3.0400,3.5264,2.4122,0.2535,2.5558,-0.1481,-0.3914,3.3812,22.4771,17.7880,17.7880,16.0482,0.0233,5.7081,9.0166,16.8012,9.0166,413.9551,9.2167,9.6338,6.2117,24.9885,19.2274,11.3303,0.4449,1.2484,1.6109,1.2904,2.8061,3.6209,1.0000
 701.5000,1957.0436,0.3394,4.1222,2.4190,2.5662,2.7567,3.0398,3.4994,2.4116,0.2535,2.5621,-0.1098,-0.4533,3.3871,22.1014,17.4291,17.4291,15.7071,0.0143,5.3295,8.6513,16.4672,8.6513,413.3984,9.2371,8.4588,5.3925,25.0456,20.8940,11.8741,0.4596,1.4180,1.7199,1.2129,3.0855,3.7424,3.0000
 702.0000,1947.3342,0.2967,3.6355,2.3021,2.4314,2.5979,2.8326,3.2025,2.2910,0.2535,2.5648,-0.2399,-0.1953,3.2522,22.9058,18.1986,18.1986,16.4381,0.0090,5.1646,8.4922,16.3217,8.4922,434.3928,9.2283,7.1409,4.4211,28.6875,24.5781,13.3005,0.5111,1.7549,1.9440,1.1078,3.4337,3.8038,4.0000
 702.5000,1949.1202,0.2256,2.9559,2.1100,2.2142,2.3456,2.5137,2.7753,2.0997,0.2535,2.5372,-0.4264,-0.3624,3.1353,25.2969,20.5072,20.5072,18.6228,0.0038,6.8389,10.1077,17.7991,10.1077,473.9310,9.2524,10.1657,5.4158,35.4289,28.1366,14.4895,0.5528,2.0898,2.1365,1.0223,3.7804,3.8648,3.0000
 703.0000,1966.3030,0.1758,2.5914,2.0049,2.0954,2.2068,2.3290,2.5225,1.9951,0.2535,2.4934,-0.2866,0.0008,3.0541,27.8226,22.9806,22.9806,20.9498,-0.0001,9.4890,12.6648,20.1373,12.6648,498.7766,9.2934,6.5416,3.9441,41.7206,30.3885,14.9611,0.5663,2.3304,2.2274,0.9558,4.1151,3.9333,7.2000
 703.5000,1984.6250,0.1658,2.6210,2.0609,2.1545,2.2670,2.3656,2.5312,2.0503,0.2535,2.4889,0.1722,0.0683,3.0566,27.9977,23.1534,23.1534,21.1118,0.0052,9.7659,12.9320,20.3817,12.9320,485.2327,9.3335,4.3842,2.5019,41.6082,29.8899,13.9889,0.5242,2.3747,2.1079,0.8877,4.5302,4.0213,3.2000
 704.0000,1944.2133,0.1667,2.8015,2.2009,2.3085,2.4348,2.5159,2.6683,2.1884,0.2535,2.5059,0.2702,-0.5903,3.1523,26.6481,21.8261,21.8261,19.8653,0.0132,8.7340,11.9363,19.4711,11.9363,454.3533,9.3399,4.1347,2.4836,35.8634,28.0833,12.5858,0.4690,2.3063,1.9089,0.8277,4.9174,4.0701,5.6000
 704.5000,2000.1276,0.1541,2.7815,2.2341,2.3491,2.4807,2.5387,2.6666,2.2164,0.2535,2.5275,-0.0598,-0.4701,3.2403,24.6408,19.8706,19.8706,18.0216,0.0124,7.4262,10.6744,18.3173,10.6744,447.6093,9.3118,5.4679,3.2077,33.5749,27.0300,11.7605,0.4356,2.2646,1.7964,0.7933,5.1994,4.1244,4.8000
 705.0000,1963.2158,0.1354,2.5537,2.1175,2.2277,2.3506,2.3893,2.4894,2.0950,0.2535,2.5548,-0.1461,-0.0907,3.2644,24.4578,19.6934,19.6934,17.8541,0.0064,5.7703,9.0766,16.8561,9.0766,472.2450,9.3144,6.1489,3.2846,35.6385,27.1131,11.6942,0.4319,2.2880,1.7921,0.7832,5.2976,4.1493,1.6000
 705.5000,1951.9072,0.1268,2.3060,1.9400,2.0406,2.1505,2.1817,2.2641,1.9170,0.2535,2.5590,-0.1431,-0.0720,3.2507,25.9459,21.1394,21.1394,19.2189,0.0028,5.5136,8.8289,16.6296,8.8289,515.4723,9.2976,5.4167,2.8109,37.8699,29.1824,12.5806,0.4636,2.4661,1.9328,0.7837,5.3194,4.1690,4.8000
 706.0000,1949.4656,0.1325,2.1576,1.7980,1.8931,1.9959,2.0305,2.1052,1.7779,0.2535,2.5354,-0.2259,-0.0715,3.1851,27.3567,22.5217,22.5217,20.5191,0.0013,6.9478,10.2128,17.8951,10.2128,556.1678,9.2883,4.6359,2.6154,40.7133,31.1387,13.2898,0.4918,2.6607,2.0318,0.7636,5.4098,4.1311,4.8000
 706.5000,1971.3809,0.1483,2.0800,1.6890,1.7814,1.8810,1.9273,1.9997,1.6726,0.2535,2.5191,-0.0223,-0.0894,3.0928,28.6142,23.7630,23.7630,21.6831,0.0021,7.9316,11.1620,18.7631,11.1620,592.0557,9.3163,3.9796,2.6147,42.0757,33.8192,14.3230,0.5329,2.9161,2.1764,0.7463,5.4722,4.0841,0.0000
 707.0000,1997.0752,0.1710,2.0348,1.5915,1.6812,1.7780,1.8423,1.9230,1.5788,0.2535,2.5232,0.1794,0.3046,3.0712,27.9397,23.0961,23.0961,21.0581,0.0050,7.6856,10.9247,18.5461,10.9247,628.3329,9.3837,4.6431,2.5687,43.0303,36.1380,15.1065,0.5637,3.1538,2.2875,0.7253,5.5948,4.0581,3.0000
 707.5000,1956.3058,0.1942,1.9595,1.4750,1.5581,1.6479,1.7311,1.8341,1.4648,0.2541,2.5246,0.0858,0.4366,3.0650,27.7596,22.9184,22.9184,20.8915,0.0037,7.5971,10.8393,18.4680,10.8393,677.9812,9.3987,3.7724,2.0796,47.8375,37.8080,15.7888,0.5924,3.3087,2.3757,0.7180,5.5857,4.0107,1.0000
 708.0000,1919.7405,0.2116,1.8603,1.3605,1.4356,1.5169,1.6149,1.7497,1.3520,0.2545,2.5002,0.0650,0.0678,2.9989,29.0922,24.2371,24.2371,22.1268,0.0006,9.0816,12.2717,19.7779,12.2718,735.0153,9.3709,4.2941,1.9559,51.1100,36.8876,15.7345,0.5872,3.1953,2.3821,0.7455,5.4413,4.0565,2.0000
 708.5000,1912.3705,0.2397,1.8903,1.3194,1.3932,1.4736,1.5915,1.7690,1.3116,0.2530,2.4493,0.3329,-0.0717,2.9722,30.5302,25.6711,25.6711,23.4659,0.0101,12.1646,15.2466,22.4982,15.2466,757.9102,9.3256,3.9707,2.3172,47.7143,33.5205,14.7101,0.5410,2.8607,2.2648,0.7917,5.2874,4.1861,7.0000
 709.0000,1908.5702,0.2980,2.1499,1.3597,1.4401,1.5291,1.6783,1.9170,1.3518,0.2539,2.4160,0.5033,-0.2308,2.9784,28.0243,23.1796,23.1796,21.1365,0.0337,14.1830,17.1941,24.2791,17.1941,735.4597,9.2486,4.4974,2.8448,40.3074,28.0547,12.6970,0.4588,2.3518,1.9939,0.8479,5.1262,4.3463,4.0000
 709.5000,1902.8344,0.3702,2.5488,1.4189,1.5069,1.6060,1.7867,2.0864,1.4117,0.2539,2.4309,0.1824,-0.2970,2.8859,26.1969,21.3845,21.3845,19.4497,0.0493,13.2778,16.3207,23.4804,16.3207,704.7653,9.1354,5.2566,3.6219,32.3865,23.6561,10.9760,0.3875,1.9563,1.7668,0.9031,5.0485,4.5594,8.0000
 710.0000,1845.4705,0.3742,2.5711,1.4180,1.5043,1.6025,1.7902,2.1076,1.4139,0.2552,2.4612,-0.3640,-0.2206,2.7950,25.4898,20.6949,20.6949,18.7999,0.0472,11.4414,14.5487,21.8600,14.5487,705.2115,9.0321,7.7862,4.7191,29.2817,22.2878,10.4892,0.3602,1.8397,1.7363,0.9438,5.1072,4.8202,1.0000
 710.5000,1815.8375,0.3264,2.2109,1.3244,1.3964,1.4787,1.6392,1.9128,1.3232,0.2554,2.4696,-0.5450,-0.3613,2.8223,27.0067,22.1777,22.1777,20.1960,0.0385,10.9354,14.0604,21.4136,14.0604,755.0731,9.1156,5.3895,3.6604,31.5211,24.3386,11.4355,0.3843,2.0357,1.9327,0.9494,5.2967,5.0288,3.0000
 711.0000,1788.7970,0.3157,2.0972,1.2789,1.3419,1.4148,1.5588,1.8091,1.2789,0.2542,2.4541,-0.2814,-0.0615,2.8359,29.3925,24.5357,24.5357,22.4059,0.0301,11.8708,14.9630,22.2389,14.9630,781.9394,9.1557,4.6860,2.9877,35.7983,28.7110,13.4871,0.4506,2.4246,2.2921,0.9453,5.3805,5.0863,2.4000
 711.5000,1894.9335,0.3189,2.1460,1.3014,1.3615,1.4324,1.5743,1.8265,1.3014,0.2550,2.4275,-0.1144,0.4394,2.7792,29.9941,25.1352,25.1352,22.9659,0.0269,13.4878,16.5233,23.6657,16.5233,768.4235,9.1868,4.6161,2.6297,41.1576,32.7937,15.5961,0.5252,2.7489,2.6311,0.9571,5.2341,5.0097,2.4000
 712.0000,1940.3557,0.3277,2.3449,1.4002,1.4630,1.5394,1.6947,1.9760,1.4002,0.2549,2.4009,-0.2951,0.3631,2.7604,30.1956,25.3364,25.3364,23.1537,0.0282,15.0962,18.0752,25.0848,18.0752,714.1790,9.1748,5.0417,2.6757,46.1271,34.0940,16.2938,0.5462,2.8382,2.7607,0.9727,5.1965,5.0544,1.6000
 712.5000,1968.6749,0.3433,2.7310,1.5867,1.6580,1.7484,1.9373,2.2883,1.5867,0.2543,2.4138,-0.2594,-0.0080,2.8498,30.3370,25.4777,25.4777,23.2855,0.0308,14.3181,17.3244,24.3983,17.3244,630.2501,9.1268,4.9722,2.6227,44.5114,31.5940,15.2298,0.5114,2.6035,2.5762,0.9895,5.0910,5.0377,1.6000
 713.0000,1958.7711,0.3597,3.1607,1.7836,1.8616,1.9648,2.1910,2.6323,1.7836,0.2542,2.4694,0.2203,-0.3558,2.9708,25.2081,20.4210,20.4210,18.5414,0.0348,10.9446,14.0693,21.4217,14.0694,560.6664,9.1123,7.9272,5.6836,35.8277,27.4445,13.2817,0.4427,2.2587,2.2624,1.0017,5.1026,5.1110,2.4000
 713.5000,1940.6436,0.3601,3.2867,1.8536,1.9243,2.0225,2.2522,2.7320,1.8536,0.2535,2.4997,0.3281,-0.1710,2.9193,22.8288,18.1248,18.1248,16.3680,0.0372,9.1111,12.3002,19.8039,12.3002,539.5023,9.1696,9.2668,6.4163,27.4661,22.3613,11.0760,0.3717,1.8121,1.8745,1.0345,4.8748,5.0428,2.0000
 714.0000,1960.1522,0.3522,3.3205,1.8989,1.9594,2.0486,2.2758,2.7936,1.8989,0.2544,2.4929,0.0000,0.1473,2.7025,22.6633,17.9663,17.9663,16.2175,0.0349,9.5188,12.6936,20.1636,12.6936,526.6287,9.0787,9.5350,6.5001,22.5349,18.6998,9.4285,0.3255,1.4896,1.5526,1.0423,4.5761,4.7695,0.0000
 714.5000,1972.0265,0.3127,2.9855,1.8298,1.8738,1.9436,2.1392,2.6156,1.8298,0.2538,2.4738,-0.0660,-0.0886,2.5528,21.9956,17.3281,17.3281,15.6110,0.0301,10.6792,13.8132,21.1875,13.8133,546.4958,9.0043,12.8433,6.6031,21.6829,16.9081,8.6637,0.3083,1.3273,1.3832,1.0420,4.3057,4.4867,0.8000
 715.0000,2006.5529,0.2751,2.5332,1.6564,1.6827,1.7294,1.8747,2.2445,1.6564,0.2547,2.4426,0.0788,-0.1029,2.5217,24.3351,19.5747,19.5747,17.7419,0.0271,12.5710,15.6386,22.8567,15.6386,603.7219,9.0071,10.5790,5.2697,24.4023,16.7022,8.6941,0.3190,1.2931,1.3423,1.0380,4.0536,4.2077,0.0000
 715.5000,1987.3085,0.2448,2.2988,1.5816,1.5971,1.6307,1.7458,2.0494,1.5816,0.2539,2.4234,0.1199,0.3282,2.5354,26.3975,21.5807,21.5807,19.6345,0.0245,13.7309,16.7579,23.8802,16.7579,632.2531,9.0695,7.0453,4.3554,27.2332,18.4345,9.8326,0.3656,1.3967,1.4950,1.0703,3.8201,4.0888,0.0000
 716.0000,1979.3279,0.2090,2.3401,1.7080,1.7167,1.7457,1.8534,2.1438,1.7080,0.2564,2.4352,0.0762,0.3579,2.5880,27.0536,22.2238,22.2238,20.2392,0.0177,13.0161,16.0682,23.2495,16.0682,585.4702,9.1399,6.5154,3.6162,29.2897,20.2828,11.2069,0.4249,1.4777,1.6650,1.1268,3.4775,3.9184,1.6000
 716.5000,1989.6580,0.1787,2.9082,2.2288,2.2288,2.2618,2.3914,2.7405,2.2288,0.2543,2.4711,0.1284,0.1031,2.6914,26.2376,21.4243,21.4243,19.4872,0.0005,10.8443,13.9725,21.3332,13.9725,448.6772,9.1788,6.6573,5.3323,30.3380,21.0082,12.1035,0.4663,1.4584,1.7632,1.2090,3.1274,3.7810,0.0000
 717.0000,1957.4698,0.1515,4.2703,3.4163,3.3891,3.4335,3.6141,4.0773,3.4163,0.2539,2.5214,0.1811,-0.0012,2.8737,23.8967,19.1514,19.1514,17.3413,-0.0213,7.7933,11.0286,18.6411,11.0286,292.7185,9.1999,18.0095,14.3066,27.9327,21.6421,12.9910,0.5099,1.4229,1.8477,1.2986,2.7903,3.6234,0.0000
 717.5000,1983.9806,0.0808,4.8679,4.3366,4.2644,4.2950,4.4313,4.7329,4.3366,0.2545,2.5715,0.0370,-0.3608,3.0889,22.5455,17.8535,17.8535,16.1104,-0.0215,4.7602,8.1020,15.9649,8.1020,230.5961,9.1804,24.7330,23.1857,25.7486,24.7271,15.2426,0.6068,1.5665,2.1277,1.3582,2.5816,3.5064,0.0000
 718.0000,1957.1010,0.0282,3.3077,3.1801,3.1361,3.1383,3.1569,3.2480,3.1801,0.2562,2.5887,-0.0992,-0.3256,3.1637,23.1169,18.4010,18.4010,16.6302,-0.0043,3.7147,7.0931,15.0424,7.0931,314.4604,9.1528,21.4073,15.8133,31.9886,30.2274,19.1016,0.7654,1.8455,2.6426,1.4319,2.4110,3.4524,0.0000
 718.5000,1982.9437,-0.0048,2.2008,2.2153,2.1877,2.1851,2.1828,2.1856,2.2153,0.2569,2.5554,-0.0122,0.3518,3.0180,23.5733,18.8398,18.8398,17.0462,0.0044,5.7312,9.0389,16.8216,9.0389,451.4132,9.2075,9.2917,4.1815,48.2381,37.2508,23.9142,0.9626,2.2228,3.2881,1.4793,2.3092,3.4160,1.6000
 719.0000,1953.1624,0.0030,1.8055,1.7981,1.7760,1.7724,1.7649,1.8074,1.7981,0.2565,2.5223,0.2803,0.6887,2.8190,25.7552,20.9535,20.9535,19.0437,0.0076,7.7368,10.9741,18.5913,10.9741,556.1402,9.2670,3.0571,1.7371,58.7204,43.4867,28.1486,1.1320,2.5822,3.8753,1.5007,2.2812,3.4235,1.6000
 719.5000,1938.9735,0.0040,1.8571,1.8467,1.8230,1.8178,1.8023,1.8600,1.8467,0.2563,2.5387,0.4764,0.5227,2.7887,26.6771,21.8545,21.8545,19.8921,0.0148,6.7475,10.0195,17.7184,10.0195,541.4976,9.3708,2.8790,1.8070,61.3069,48.1713,31.5051,1.2649,2.8342,4.3470,1.5338,2.2406,3.4365,4.0000
 720.0000,1959.6809,-0.0130,2.0628,2.0999,2.0705,2.0626,2.0316,2.0645,2.0999,0.2573,2.5746,0.2987,-0.0894,2.8911,25.9416,21.1352,21.1352,19.2149,0.0223,4.5707,7.9191,15.7977,7.9191,476.2210,9.3855,3.5557,2.1291,66.9036,53.6579,35.7727,1.4216,3.0803,5.0055,1.6250,2.1668,3.5211,3.2000
 720.5000,1969.3430,-0.0392,2.2330,2.3546,2.3226,2.3116,2.2618,2.2353,2.3546,0.2562,2.5965,0.1184,-0.1987,2.9508,24.0438,19.2934,19.2934,17.4757,0.0264,3.2416,6.6366,14.6249,6.6366,424.7025,9.4381,3.7760,2.2567,71.7955,56.8495,38.6918,1.5292,3.1449,5.4539,1.7342,2.0566,3.5666,0.0000
 721.0000,1971.2775,-0.0636,2.3979,2.6110,2.5772,2.5629,2.4959,2.4031,2.6110,0.2572,2.6088,0.2527,0.1557,2.9327,22.9406,18.2320,18.2320,16.4698,0.0274,2.4989,5.9200,13.9696,5.9200,382.9998,9.4513,3.8666,2.4235,76.1253,59.2456,41.1870,1.6244,3.1237,5.8219,1.8638,1.9230,3.5841,1.0000
 721.5000,1949.5229,-0.0762,2.5498,2.8217,2.7877,2.7705,2.6927,2.5574,2.8217,0.2563,2.6107,0.3620,-0.0976,2.9016,22.1722,17.4967,17.4967,15.7713,0.0267,2.3822,5.8074,13.8666,5.8074,354.4007,9.3911,5.0097,2.9095,78.1309,57.4804,40.7313,1.5966,2.9079,5.8040,1.9960,1.8213,3.6353,4.0000
 722.0000,1944.1334,-0.0710,2.4834,2.7299,2.7003,2.6830,2.6121,2.4904,2.7299,0.2566,2.6026,0.0470,-0.1752,2.8831,22.3765,17.6918,17.6918,15.9568,0.0245,2.8698,6.2778,14.2968,6.2778,366.3092,9.3890,4.5755,2.8337,74.5122,56.0758,40.5370,1.5811,2.7204,5.8136,2.1370,1.7206,3.6769,4.0000
 722.5000,1940.4019,-0.0516,2.3349,2.5029,2.4791,2.4633,2.4129,2.3394,2.5029,0.2561,2.5908,-0.4799,0.2528,2.8481,23.2533,18.5321,18.5321,16.7545,0.0199,3.5866,6.9695,14.9293,6.9695,399.5373,9.4049,5.3689,3.0132,70.8792,54.4415,39.8870,1.5524,2.5816,5.7361,2.2220,1.6629,3.6949,0.0000
 723.0000,1957.4698,-0.0264,2.1839,2.2639,2.2452,2.2313,2.2067,2.1855,2.2639,0.2570,2.5710,-0.6465,0.5287,2.7762,23.8337,19.0906,19.0906,17.2838,0.0156,4.7887,8.1294,15.9900,8.1294,441.7144,9.4449,4.2788,2.3086,69.0582,52.8778,39.1669,1.5238,2.4645,5.6354,2.2866,1.6173,3.6982,1.0000
 723.5000,1941.7379,-0.0046,2.0169,2.0296,2.0150,2.0033,2.0013,2.0161,2.0296,0.2571,2.5516,-0.3246,0.3246,2.7109,24.9283,20.1492,20.1492,18.2849,0.0145,5.9635,9.2630,17.0266,9.2631,492.7092,9.4673,3.1500,1.8590,67.0731,52.4683,39.2081,1.5286,2.4079,5.6264,2.3366,1.5753,3.6808,0.0000
 724.0000,1962.2722,0.0083,1.9538,1.9314,1.9183,1.9075,1.9191,1.9526,1.9314,0.2576,2.5458,0.0227,-0.3384,2.7347,25.7411,20.9397,20.9397,19.0307,0.0139,6.3129,9.6001,17.3349,9.6001,517.7714,9.4980,2.8683,1.7225,67.0445,53.5886,40.2478,1.5588,2.4425,5.8243,2.3845,1.5669,3.7363,3.0000
 724.5000,1959.7844,0.0129,2.0151,1.9794,1.9644,1.9529,1.9733,2.0150,1.9794,0.2571,2.5461,-0.1746,-0.4683,2.8144,26.0284,21.2199,21.2199,19.2948,0.0118,6.2980,9.5858,17.3218,9.5858,505.2158,9.5039,3.1041,1.8403,71.6375,57.4438,43.4565,1.6684,2.5788,6.3585,2.4657,1.5457,3.8111,0.0000
 725.0000,1937.4653,0.0138,2.1509,2.1102,2.0896,2.0758,2.1026,2.1510,2.1102,0.2570,2.5446,-0.6024,0.2253,2.8543,26.6025,21.7814,21.7814,19.8233,0.0070,6.3865,9.6711,17.3998,9.6711,473.8925,9.4954,3.7701,2.2098,80.6852,62.0087,47.5023,1.8024,2.6996,7.0516,2.6121,1.4978,3.9124,2.0000
 725.5000,1966.4751,0.0136,2.2675,2.2251,2.1959,2.1792,2.2092,2.2678,2.2251,0.2565,2.5402,-0.5424,0.4837,2.8425,27.1642,22.3324,22.3324,20.3413,0.0027,6.6534,9.9287,17.6353,9.9287,449.4211,9.4808,3.6766,2.1015,86.3301,65.1482,50.5887,1.9036,2.7280,7.5853,2.7805,1.4331,3.9847,2.0000
 726.0000,2005.4135,0.0132,2.3476,2.3051,2.2652,2.2458,2.2744,2.3485,2.3051,0.2562,2.5363,-0.1250,0.2165,2.7890,27.3818,22.5463,22.5463,20.5423,0.0062,6.8916,10.1586,17.8456,10.1586,433.8272,9.5029,3.7806,2.1722,87.8540,68.1122,53.4216,1.9913,2.7679,8.0998,2.9263,1.3900,4.0677,1.0000
 726.5000,2008.0846,0.0105,2.4792,2.4435,2.3888,2.3652,2.3885,2.4806,2.4435,0.2573,2.5323,0.2301,-0.0410,2.7648,27.5423,22.7043,22.7043,20.6905,0.0118,7.1347,10.3931,18.0600,10.3931,409.2422,9.4692,3.4631,1.9495,90.9588,69.9941,55.8275,2.0509,2.7048,8.6069,3.1821,1.3188,4.1966,2.0000
 727.0000,2029.1261,-0.0206,2.6447,2.7201,2.6430,2.6130,2.6196,2.6467,2.7201,0.2561,2.5537,0.2165,-0.0587,2.8892,25.2700,20.4812,20.4812,18.5982,0.0166,5.8350,9.1391,16.9133,9.1391,367.6345,9.4817,3.7321,2.0638,93.2455,68.0503,54.9485,2.0013,2.5328,8.5537,3.3772,1.2656,4.2740,1.0000
 727.5000,1988.9325,-0.0401,3.7762,3.9867,3.8424,3.7905,3.7279,3.7874,3.9867,0.2577,2.6673,-0.1700,0.0886,3.2816,18.1279,13.6821,13.6821,12.1258,0.0268,-1.0514,2.4943,10.8370,2.4943,250.8326,9.5065,3.2523,2.2533,86.7745,58.1423,47.6535,1.7181,2.0802,7.5013,3.6060,1.2108,4.3661,2.0000
 728.0000,1940.0677,-0.1677,7.8115,9.6655,9.1715,8.9765,8.4406,7.9228,9.6655,0.2567,2.8306,-0.4450,0.0492,3.9227,7.9630,4.5130,4.5130,3.1940,0.0271,-10.9472,-7.0543,2.1054,-7.0543,103.4609,9.5915,17.0893,16.8501,61.1980,40.9651,34.0007,1.2242,1.4207,5.3599,3.7728,1.1605,4.3782,1.0000
 728.5000,1843.3740,-0.3716,30.5024,46.4735,43.8549,42.7242,39.3965,33.1883,46.5204,0.2577,2.9247,-0.2323,0.1414,4.4277,2.7832,0.0776,0.0776,-1.2267,0.0157,-16.6459,-12.5531,-2.9228,-12.5530,21.5176,9.6427,32.5832,38.1264,30.2408,24.2870,20.3285,0.7345,0.8308,3.1926,3.8429,1.1311,4.3467,0.0000
 729.0000,1822.5405,-1.0218,121.4397,263.4137,249.7059,242.2970,223.3479,184.2996,265.0675,0.2576,2.9459,0.2548,-0.0996,4.6262,1.3311,-1.1365,-1.1365,-2.4498,0.0147,-17.9307,-13.7928,-4.0565,-13.7928,3.7963,9.6847,45.0140,49.1060,14.6007,13.2299,11.1523,0.4077,0.4427,1.7290,3.4580,1.0860,4.2413,1.6000
 729.5000,1918.0714,-0.7330,88.4528,172.0343,162.2043,157.1476,143.6619,117.3317,172.7864,0.2560,2.9485,0.4884,-0.2526,4.8004,1.1614,-1.2775,-1.2775,-2.5923,0.0166,-18.0884,-13.9450,-4.1957,-13.9450,5.8128,9.7102,44.1400,53.7058,10.9962,9.5059,8.0077,0.2962,0.3200,1.2248,2.4496,1.0802,4.1346,0.8000
 730.0000,1971.5653,-0.4512,42.3894,69.0154,65.0657,63.1456,57.9539,47.8756,69.1418,0.2565,2.9509,0.3149,0.0987,4.9824,1.9137,-0.6510,-0.6510,-1.9599,0.0149,-18.2393,-14.0906,-4.3288,-14.0905,14.4895,9.7465,37.0587,44.5341,10.7375,10.4071,8.7191,0.3273,0.3566,1.3113,2.6226,1.0897,4.0071,0.0000
 730.5000,2015.7549,-0.2645,12.3716,17.0122,16.0729,15.6336,14.5601,12.7671,17.0201,0.2573,2.9198,-0.0433,-0.2231,4.9377,4.1667,1.2463,1.2463,-0.0548,0.0132,-16.3509,-12.2685,-2.6626,-12.2684,58.7812,9.7477,44.5171,52.0163,14.3821,16.2068,13.5455,0.5140,0.5593,2.0107,3.5949,1.0882,3.9121,1.6000
 731.0000,1989.4286,-0.1396,5.2483,6.2817,5.9718,5.8220,5.5833,5.2967,6.2828,0.2565,2.8099,-0.3241,-0.7437,4.4515,8.7547,5.2053,5.2053,3.8776,0.0088,-9.6919,-5.8430,3.2130,-5.8430,159.1922,9.8409,43.9600,36.9526,27.8658,28.8049,24.0143,0.9171,1.0100,3.5369,3.5017,1.1014,3.8567,3.2000
 731.5000,1975.9426,-0.0597,2.9845,3.2328,3.0985,3.0282,2.9946,2.9942,3.2331,0.2560,2.6521,-0.5160,-0.5700,3.6378,15.4484,11.2064,11.2064,9.7389,0.0027,-0.1256,3.3875,11.6539,3.3876,309.3305,9.9729,15.0801,5.5118,54.0953,47.1829,39.2590,1.5077,1.6887,5.7421,3.4003,1.1201,3.8086,0.8000
 732.0000,1917.8870,-0.0114,2.2317,2.2667,2.1982,2.1594,2.1791,2.2344,2.2669,0.2562,2.5293,-0.4727,-0.0095,3.0207,22.0120,17.3438,17.3438,15.6259,-0.0011,7.3146,10.5667,18.2188,10.5667,441.1666,10.0571,4.1420,2.3915,82.7203,65.2888,54.2455,2.0932,2.3707,7.8868,3.3268,1.1326,3.7678,0.8000
 732.5000,1973.6268,0.0147,1.8991,1.8608,1.8230,1.7971,1.8325,1.8989,1.8608,0.2581,2.4781,0.1742,0.3038,2.9224,26.6189,21.7974,21.7974,19.8384,-0.0012,10.4195,13.5627,20.9584,13.5627,537.4145,10.1257,2.9476,1.6919,101.5143,77.8877,64.5395,2.4909,2.8858,9.3809,3.2507,1.1585,3.7660,3.2000
 733.0000,1975.3781,0.0275,1.8465,1.7768,1.7527,1.7310,1.7768,1.8454,1.7769,0.2581,2.4728,0.7544,0.1879,3.1719,29.5150,24.6575,24.6575,22.5198,0.0016,10.7379,13.8699,21.2393,13.8699,562.8057,10.1493,3.3850,1.8646,106.1118,82.6786,68.2093,2.6322,3.1063,9.9160,3.1922,1.1801,3.7672,0.8000
 733.5000,1998.3303,0.0349,1.8376,1.7499,1.7355,1.7156,1.7670,1.8367,1.7500,0.2562,2.4758,0.5232,-0.2172,3.2873,29.4612,24.6040,24.6040,22.4698,0.0107,10.5569,13.6952,21.0796,13.6952,571.4661,10.1676,4.4346,2.2476,104.2114,84.3728,69.0518,2.6558,3.2337,10.0809,3.1175,1.2176,3.7958,0.8000
 734.0000,2004.5149,0.0387,1.7864,1.6919,1.6836,1.6667,1.7170,1.7862,1.6919,0.2566,2.4741,0.1618,-0.5052,3.0837,28.9201,24.0663,24.0663,21.9670,0.0210,10.6628,13.7974,21.1731,13.7974,591.0459,10.3186,2.7920,1.6775,107.3948,85.0581,68.4757,2.6272,3.3989,10.0272,2.9502,1.2937,3.8166,0.8000
 734.5000,1963.1123,0.0391,1.8392,1.7409,1.7355,1.7203,1.7689,1.8391,1.7409,0.2567,2.4781,0.1627,-0.2456,2.8647,30.0381,25.1791,25.1791,23.0069,0.0269,10.4176,13.5608,20.9567,13.5608,574.4119,10.4361,2.2713,1.7240,109.4789,83.8171,65.9011,2.5326,3.5624,9.6303,2.7033,1.4066,3.8025,5.0000
 735.0000,1962.0304,0.0347,1.9792,1.8855,1.8805,1.8662,1.9107,1.9792,1.8855,0.2582,2.4914,0.3311,0.3476,2.9085,28.4364,23.5869,23.5869,21.5182,0.0336,9.6119,12.7834,20.2458,12.7835,530.3728,10.4828,2.9620,1.9437,104.9234,78.1141,59.8027,2.3063,3.5475,8.7009,2.4527,1.5381,3.7726,1.0000
 735.5000,1926.8698,0.0231,2.1503,2.0820,2.0753,2.0618,2.0927,2.1504,2.0820,0.2571,2.5227,0.5060,0.7033,3.3320,25.2760,20.4870,20.4870,18.6037,0.0453,7.7168,10.9548,18.5736,10.9548,480.2960,10.4734,2.2382,1.4842,90.5671,67.4682,50.3454,1.9411,3.2579,7.3275,2.2491,1.6784,3.7749,1.0000
 736.0000,1983.6466,-0.0063,2.4029,2.4238,2.4115,2.3979,2.3986,2.4033,2.4238,0.2569,2.5627,0.4237,0.1932,3.9150,20.6934,16.0911,16.0911,14.4324,0.0459,5.2914,8.6145,16.4336,8.6145,412.5727,10.4314,1.1643,1.3856,69.4151,54.0073,39.2341,1.5133,2.7574,5.7074,2.0699,1.8221,3.7716,0.0000
 736.5000,2028.6650,-0.0269,3.0684,3.1828,3.1599,3.1451,3.0896,3.0703,3.1828,0.2580,2.5818,0.1119,-0.3621,4.2886,17.3554,12.9640,12.9640,11.4353,0.0296,4.1352,7.4989,15.4134,7.4989,314.1876,10.2841,3.2566,2.7985,50.6969,40.9352,28.8093,1.1114,2.2136,4.1898,1.8927,1.9917,3.7698,4.0000
 737.0000,2095.1511,-0.0568,4.0384,4.3583,4.3189,4.3025,4.1971,4.0437,4.3583,0.2564,2.5863,-0.2485,0.0544,4.5172,15.0805,10.8697,10.8697,9.4130,0.0152,3.8630,7.2362,15.1732,7.2362,229.4487,10.0620,8.4641,4.9685,36.0177,30.6980,20.8597,0.8014,1.7569,3.0493,1.7356,2.1922,3.8048,1.0000
 737.5000,2065.4722,-0.0654,4.2766,4.6673,4.6196,4.6057,4.5302,4.2833,4.6673,0.2559,2.5910,-0.6336,0.4162,4.7621,13.3944,9.3369,9.3369,7.9249,0.0073,3.5754,6.9587,14.9194,6.9587,214.2585,10.0083,14.4911,7.7489,30.0820,27.1401,17.7534,0.6801,1.6405,2.6047,1.5878,2.4121,3.8299,0.0000
 738.0000,2079.7756,-0.0416,3.5712,3.7780,3.7389,3.7309,3.7040,3.5748,3.7780,0.2573,2.5904,-0.7945,-0.0954,4.7410,14.1682,10.0383,10.0383,8.6067,0.0013,3.6102,6.9923,14.9502,6.9923,264.6872,10.0550,10.5046,6.4293,37.7441,31.1914,19.4863,0.7418,2.0004,2.8813,1.4403,2.6968,3.8842,0.0000
 738.5000,2100.7363,-0.0275,2.8445,2.9529,2.9250,2.9206,2.9087,2.8457,2.9529,0.2570,2.5734,-0.5408,-0.2428,4.2334,16.9719,12.6089,12.6089,11.0932,-0.0041,4.6451,7.9908,15.8633,7.9908,338.6487,10.1072,7.5963,4.1695,52.2235,42.1674,25.0875,0.9443,2.8580,3.7603,1.3157,3.0266,3.9821,1.0000
 739.0000,2046.5045,-0.0330,2.3893,2.4989,2.4800,2.4769,2.4604,2.3893,2.4989,0.2561,2.5444,-0.1380,-0.0031,3.6421,20.6481,16.0482,16.0482,14.3914,-0.0079,6.3992,9.6834,17.4110,9.6834,400.1785,10.1040,5.6666,2.9596,69.0814,55.2275,31.2046,1.1636,3.9332,4.7288,1.2023,3.3801,4.0638,0.0000
 739.5000,2080.6282,-0.0221,2.2103,2.2781,2.2669,2.2639,2.2352,2.2102,2.2781,0.2557,2.5264,0.0074,0.0212,3.3280,23.1705,18.4525,18.4525,16.6790,-0.0092,7.4891,10.7351,18.3727,10.7351,438.9606,10.1459,4.4524,2.4402,82.3840,64.9681,35.1027,1.2848,4.8105,5.4344,1.1297,3.7442,4.2298,1.0000
 740.0000,2075.4346,-0.0086,2.1387,2.1642,2.1602,2.1567,2.1457,2.1385,2.1642,0.2571,2.5235,-0.2384,0.3444,3.2091,23.8039,19.0620,19.0620,17.2566,-0.0113,7.6664,10.9061,18.5291,10.9061,462.0668,10.2189,4.5595,2.5037,85.3960,69.3988,35.7923,1.2723,5.3500,5.7203,1.0692,4.2050,4.4960,2.4000
 740.5000,2077.1968,0.0087,2.0780,2.0532,2.0555,2.0516,2.0682,2.0776,2.0532,0.2553,2.5293,-0.3440,0.3983,3.1525,23.8448,19.1014,19.1014,17.2940,-0.0086,7.3146,10.5668,18.2188,10.5668,487.0487,10.2596,4.3725,2.4616,84.0345,69.2528,34.1819,1.1813,5.5462,5.6229,1.0138,4.6949,4.7598,1.6000
 741.0000,2106.4023,0.0307,1.9862,1.9027,1.9089,1.9049,1.9357,1.9855,1.9027,0.2573,2.5256,0.0667,-0.2286,3.1572,26.6224,21.8008,21.8008,19.8416,-0.0019,7.5397,10.7839,18.4174,10.7839,525.5764,10.3394,4.1554,2.5758,84.9374,67.7343,31.8454,1.0664,5.6494,5.4009,0.9560,5.2978,5.0647,0.8000
 741.5000,2071.6106,0.0482,1.7905,1.6729,1.6805,1.6769,1.7014,1.7899,1.6729,0.2572,2.4960,0.3804,-0.7382,3.2662,28.8620,24.0086,24.0086,21.9130,0.0011,9.3328,12.5141,19.9995,12.5141,597.7542,10.4017,4.7750,3.1471,83.0228,65.6122,29.7164,0.9662,5.6330,5.1770,0.9191,5.8303,5.3583,0.0000
 742.0000,2113.3359,0.0389,1.5908,1.5063,1.5135,1.5106,1.5257,1.5903,1.5063,0.2555,2.4725,0.2969,-0.3756,3.3709,31.0893,26.2316,26.2316,23.9881,0.0070,10.7562,13.8875,21.2554,13.8875,663.8673,10.4485,5.6001,3.4099,75.9450,61.3182,27.2573,0.8679,5.3192,4.8356,0.9091,6.1289,5.5718,0.0000
 742.5000,2079.5002,0.0323,1.5913,1.5211,1.5281,1.5249,1.5393,1.5906,1.5211,0.2562,2.4703,0.2669,0.1855,3.4253,30.7427,25.8839,25.8839,23.6642,0.0125,10.8931,14.0197,21.3763,14.0197,657.4232,10.4907,3.4994,2.1597,68.5176,56.3711,24.8964,0.7859,4.8915,4.4493,0.9096,6.2244,5.6617,5.0000
 743.0000,2078.9580,0.0436,1.8433,1.7336,1.7402,1.7359,1.7569,1.8424,1.7336,0.2564,2.4781,0.3686,0.3271,3.5537,27.7813,22.9398,22.9398,20.9116,0.0089,10.4161,13.5594,20.9554,13.5594,576.8449,10.5429,4.0699,3.0160,64.6963,53.1885,23.2079,0.7281,4.6314,4.1686,0.9001,6.3608,5.7252,1.0000
 743.5000,2078.9705,0.0562,2.2852,2.1105,2.1137,2.1073,2.1450,2.2841,2.1105,0.2554,2.5041,0.4060,0.3019,3.7549,24.1304,19.3769,19.3769,17.5548,0.0027,8.8412,12.0398,19.5658,12.0398,473.8238,10.5516,4.7927,3.5249,70.6196,54.2206,23.3811,0.7316,4.7486,4.2089,0.8864,6.4906,5.7530,1.0000
 744.0000,2060.1750,0.0443,2.7810,2.6131,2.6041,2.5950,2.6523,2.7797,2.6131,0.2564,2.5234,0.3911,0.4054,3.9427,22.8919,18.1852,18.1852,16.4254,0.0009,7.6751,10.9145,18.5368,10.9145,382.6899,10.5697,4.8837,3.1794,79.1177,56.0293,23.7164,0.7338,4.9614,4.3087,0.8684,6.7613,5.8718,1.0000
 744.5000,2055.5684,0.0155,3.3988,3.3265,3.2905,3.2778,3.3298,3.3978,3.3265,0.2573,2.5117,0.0599,0.1851,4.0869,23.7344,18.9950,18.9950,17.1932,0.0066,8.3847,11.5992,19.1629,11.5993,300.6118,10.5885,6.4355,3.8463,74.1830,53.8418,22.5481,0.6837,4.8032,4.1627,0.8666,7.0255,6.0886,1.0000
 745.0000,2030.5195,-0.0180,4.2738,4.3805,4.3025,4.2881,4.2808,4.2724,4.3805,0.2564,2.4833,-0.5646,-0.3961,4.1722,24.3540,19.5930,19.5930,17.7592,0.0145,10.1014,13.2557,20.6777,13.2557,228.2841,10.6323,8.7339,7.3407,58.4039,45.5556,18.9508,0.5526,4.0791,3.6031,0.8833,7.3821,6.5207,3.0000
 745.5000,2050.3623,-0.0460,5.4748,5.8255,5.6766,5.6610,5.5687,5.4730,5.8255,0.2560,2.4355,-0.5395,-0.3275,4.2274,26.4022,21.5853,21.5853,19.6388,0.0137,12.9985,16.0511,23.2339,16.0511,171.6603,10.7260,13.6194,11.9703,43.0981,35.1621,14.6404,0.4120,3.1281,2.8544,0.9125,7.5932,6.9290,0.0000
 746.0000,2023.3566,-0.0623,8.2819,9.0027,8.7043,8.6872,8.5782,8.2833,9.0027,0.2579,2.3799,0.0481,-0.2209,4.2420,27.1032,22.2725,22.2725,20.2850,0.0143,16.3690,19.3034,26.2080,19.3035,111.0780,10.8634,10.6721,9.7216,31.6557,25.9535,10.8709,0.2951,2.2822,2.1705,0.9510,7.7327,7.3542,2.4000
 746.5000,2047.0231,-0.0309,13.1199,13.6833,13.1316,13.1284,13.1285,13.1286,13.6833,0.2558,2.3440,0.0423,-0.5584,4.2136,29.4287,24.5716,24.5716,22.4396,0.0188,18.5475,21.4055,28.1302,21.4055,73.0816,10.9218,8.7912,9.6574,24.1134,20.6016,8.5810,0.2271,1.8047,1.7410,0.9647,7.9457,7.6656,2.4000
 747.0000,2017.4711,-0.0602,18.2661,19.8021,18.8681,18.9035,18.7545,18.2801,19.8021,0.2561,2.3371,-0.3099,-0.3261,4.2702,32.6757,27.8314,27.8314,25.4752,0.0143,18.9644,21.8078,28.4980,21.8078,50.4997,10.9255,9.6528,10.6228,21.4795,18.1256,7.4756,0.1966,1.5953,1.5226,0.9545,8.1133,7.7441,3.2000
 747.5000,2004.3304,-0.0454,23.9795,25.4947,24.1516,24.2527,23.6108,23.9995,25.4947,0.2562,2.3634,-0.2759,0.2056,4.5568,34.3449,29.5294,29.5294,27.0480,0.0110,17.3703,20.2695,27.0914,20.2695,39.2238,10.9396,12.7544,11.3397,22.9141,17.3203,6.9614,0.1815,1.5520,1.4255,0.9184,8.5507,7.8533,3.0000
 748.0000,2033.0996,-0.0187,24.9449,25.5893,23.9912,24.2889,23.9403,24.9650,25.5893,0.2563,2.3840,-0.1518,0.0926,5.0911,32.0177,27.1662,27.1662,24.8575,0.0128,16.1229,19.0660,25.9908,19.0660,39.0789,10.9663,12.7870,11.0976,23.8304,17.3974,6.9017,0.1781,1.5783,1.4219,0.9009,8.8598,7.9818,1.0000
 748.5000,2009.7198,0.0246,19.9693,19.2964,17.8560,18.2380,18.8942,19.9818,19.2964,0.2552,2.3576,-0.0345,-0.0526,5.6357,32.0985,27.2477,27.2477,24.9332,0.0097,17.7209,20.6079,27.4008,20.6079,51.8231,11.0179,13.7273,13.4232,22.4199,17.6157,6.8730,0.1778,1.6151,1.4140,0.8755,9.0841,7.9533,1.0000
 749.0000,2065.2539,0.0342,10.5970,10.1016,9.4901,9.6186,10.0664,10.5985,10.1016,0.2572,2.3073,0.2993,-0.0427,5.9323,34.6531,29.8446,29.8446,27.3393,0.0067,20.7722,23.5521,30.0931,23.5521,98.9938,11.0297,14.8837,12.9022,20.5025,17.3115,6.7637,0.1749,1.5876,1.3917,0.8766,9.0747,7.9547,0.0000
 749.5000,2052.9197,0.0321,6.1559,5.8854,5.6302,5.6801,5.9005,6.1561,5.8854,0.2569,2.2645,0.5018,-0.0699,5.9114,35.6281,30.8449,30.8449,28.2627,0.0123,23.3648,26.0538,32.3807,26.0538,169.9114,10.9885,11.1206,9.3584,20.4338,16.9274,6.6136,0.1702,1.5498,1.3646,0.8805,9.1031,8.0156,2.0000
 750.0000,2091.0168,0.0261,4.9873,4.8087,4.6253,4.6582,4.8230,4.9873,4.8087,0.2555,2.2404,0.1621,0.1230,5.6331,33.9683,29.1450,29.1450,26.6924,0.0217,24.8239,27.4616,33.6681,27.4616,207.9574,10.8898,7.6118,6.0331,22.8740,17.3838,6.8102,0.1761,1.5827,1.4017,0.8856,8.9900,7.9617,1.0000
 750.5000,2077.9099,0.0129,4.9591,4.8711,4.6781,4.7075,4.8664,4.9591,4.8711,0.2558,2.2541,-0.3968,0.4832,5.3647,31.9346,27.0823,27.0823,24.7795,0.0268,23.9914,26.6583,32.9336,26.6583,205.2929,10.8633,4.8501,4.5089,25.2882,17.7405,6.9751,0.1811,1.5932,1.4320,0.8988,8.7981,7.9075,1.0000
 751.0000,2027.3176,-0.0032,5.6858,5.7110,5.4652,5.4952,5.6700,5.6858,5.7110,0.2556,2.2863,-0.4407,0.8039,5.3963,30.1677,25.3085,25.3085,23.1277,0.0250,22.0425,24.7779,31.2140,24.7779,175.0992,10.8518,3.7949,4.0436,26.1590,18.5255,7.2851,0.1906,1.6445,1.4886,0.9052,8.6274,7.8091,3.0000
 751.5000,2041.7708,-0.0127,6.0569,6.1636,5.9058,5.9265,6.0606,6.0569,6.1636,0.2547,2.2849,-0.0597,0.4941,5.5824,32.0197,27.1682,27.1682,24.8594,0.0146,22.1280,24.8603,31.2894,24.8603,162.2432,10.9094,7.3880,7.5272,25.3320,18.3145,7.1873,0.1843,1.6177,1.4863,0.9188,8.7759,8.0631,2.4000
 752.0000,2067.2234,-0.0100,5.3521,5.4262,5.2256,5.2323,5.2606,5.3521,5.4262,0.2563,2.2706,0.0465,-0.1837,5.6564,35.4359,30.6473,30.6473,28.0805,0.0080,22.9937,25.6956,32.0532,25.6957,184.2914,10.9407,8.2080,7.7580,23.8830,18.0612,6.9413,0.1777,1.6123,1.4370,0.8913,9.0743,8.0880,0.8000
 752.5000,2103.5120,-0.0246,4.6344,4.7923,4.6375,4.6358,4.6350,4.6344,4.7923,0.2567,2.2603,0.0460,-0.5995,5.5668,34.1594,29.3400,29.3400,26.8729,0.0147,23.6158,26.2960,32.6022,26.2960,208.6659,10.8192,2.5119,2.9683,22.4547,18.4780,6.9249,0.1772,1.6786,1.4341,0.8543,9.4746,8.0943,0.8000
 753.0000,2062.3748,0.0090,4.4903,4.4350,4.3062,4.2996,4.3318,4.4903,4.4350,0.2563,2.2365,0.1688,-0.3719,5.3157,33.1766,28.3394,28.3394,25.9463,0.0263,25.0626,27.6920,33.8788,27.6920,225.4811,10.5730,1.4129,2.0054,23.2880,19.8840,7.3947,0.1943,1.8210,1.5069,0.8275,9.3702,7.7542,2.0000
 753.5000,2077.3577,0.0249,4.2095,4.0661,3.9633,3.9546,4.0085,4.2095,4.0661,0.2563,2.2530,0.1463,0.1583,5.1251,32.4638,27.6170,27.6170,25.2762,0.0424,24.0583,26.7229,32.9926,26.7229,245.9352,10.4920,1.3858,1.9504,27.2252,21.6436,8.1519,0.2154,1.9807,1.6557,0.8359,9.1954,7.6867,0.0000
 754.0000,2096.5334,0.0328,3.6724,3.5077,3.4369,3.4293,3.4763,3.6723,3.5077,0.2566,2.3187,0.0568,-0.0348,5.1854,29.7788,24.9203,24.9203,22.7653,0.0631,20.0769,22.8812,29.4796,22.8812,285.0842,10.4099,1.3126,1.8389,31.2044,23.4054,8.9009,0.2373,2.1355,1.7980,0.8419,9.0004,7.5777,1.0000
 754.5000,2106.2988,0.0292,2.8413,2.7277,2.6899,2.6852,2.7137,2.8411,2.7277,0.2562,2.3393,0.0522,-0.2121,5.2819,28.3768,23.5280,23.5280,21.4630,0.0794,18.8313,21.6793,28.3805,21.6793,366.6149,10.3834,1.2666,1.7679,32.1670,23.7896,9.1490,0.2443,2.1693,1.8463,0.8511,8.8814,7.5589,0.0000
 755.0000,2088.6787,0.0195,2.1350,2.0779,2.0597,2.0571,2.0725,2.1348,2.0779,0.2564,2.2982,0.0650,0.0018,5.1995,31.0300,26.1720,26.1720,23.9327,0.0876,21.3223,24.0830,30.5785,24.0830,481.2541,10.3589,1.3102,1.7897,28.1477,22.5492,8.5780,0.2301,2.0673,1.7257,0.8348,8.9827,7.4985,0.0000
 755.5000,2074.5134,0.0169,1.7977,1.7560,1.7454,1.7435,1.7549,1.7975,1.7560,0.2559,2.2671,-0.0329,-0.1272,5.0233,32.9088,28.0676,28.0676,25.6943,0.0909,23.2064,25.9009,32.2409,25.9009,569.4785,10.4556,1.2697,1.6809,24.4014,21.6147,8.1866,0.2235,1.9918,1.6286,0.8176,8.9107,7.2858,0.8000
 756.0000,2089.4614,0.0312,1.7364,1.6622,1.6541,1.6521,1.6670,1.7362,1.6622,0.2563,2.2645,-0.1140,-0.3255,4.8714,32.2037,27.3540,27.3540,25.0320,0.0930,23.3657,26.0547,32.3815,26.0547,601.6132,10.4227,1.1262,1.4507,24.1079,20.9572,8.0894,0.2228,1.9190,1.5998,0.8337,8.6112,7.1790,1.6000
 756.5000,2059.9680,0.0420,1.7790,1.6770,1.6691,1.6665,1.6890,1.7788,1.6770,0.2560,2.2810,-0.2492,-0.2953,4.7805,31.9153,27.0629,27.0629,24.7615,0.0945,22.3646,25.0886,31.4981,25.0886,596.2930,10.3838,1.0496,1.3847,26.0118,21.6706,8.5106,0.2341,1.9815,1.6849,0.8503,8.4653,7.1983,1.6000
 757.0000,2068.0410,0.0385,1.8125,1.7171,1.7080,1.7044,1.7297,1.8123,1.7171,0.2555,2.3054,-0.3449,-0.0967,4.7592,30.9158,26.0574,26.0574,23.8259,0.0956,20.8835,23.6595,30.1913,23.6595,582.3929,10.3782,1.1348,1.4961,29.6671,22.7120,9.0333,0.2520,2.0673,1.7716,0.8570,8.2040,7.0305,0.0000
 757.5000,2026.7418,0.0291,1.8323,1.7594,1.7480,1.7431,1.7630,1.8322,1.7594,0.2551,2.2903,-0.0012,0.0149,4.7013,31.8078,26.9545,26.9545,24.6608,0.0957,21.8007,24.5445,31.0006,24.5445,568.3849,10.3734,1.1714,1.4350,30.1587,22.2758,9.0702,0.2599,1.9934,1.7462,0.8760,7.6698,6.7185,6.0000
 758.0000,2004.2157,0.0151,2.0226,1.9807,1.9644,1.9571,1.9673,2.0225,1.9807,0.2553,2.2339,0.3249,-0.0435,4.4914,34.6570,29.8486,29.8486,27.3431,0.0912,25.2190,27.8429,34.0168,27.8429,504.8793,10.3722,1.1406,1.3199,27.5160,21.0375,8.6635,0.2527,1.8588,1.6470,0.8861,7.3569,6.5188,3.0000
 758.5000,1975.4241,-0.0012,2.4711,2.4753,2.4495,2.4377,2.4307,2.4710,2.4753,0.2555,2.1841,0.2144,-0.1451,4.2091,36.7296,31.9812,31.9812,29.3094,0.0847,28.2391,30.7570,36.6816,30.7571,403.9892,10.3793,1.2029,1.5747,26.1430,19.5761,8.1090,0.2362,1.7158,1.5431,0.8993,7.2651,6.5337,0.0000
 759.0000,1876.9905,-0.0150,2.7566,2.8137,2.7831,2.7706,2.7457,2.7565,2.8137,0.2568,2.1581,0.0134,-0.1297,3.9831,37.9502,33.2479,33.2479,30.4733,0.0805,29.8095,32.2723,38.0672,32.2723,355.4064,10.3947,1.4014,1.9230,25.3382,19.2038,7.9817,0.2266,1.6767,1.5467,0.9225,7.3995,6.8260,0.0000
 759.5000,1880.8717,-0.0171,2.5077,2.5671,2.5389,2.5285,2.5030,2.5076,2.5671,0.2540,2.1563,-0.0217,-0.1748,3.8796,38.8839,34.2222,34.2222,31.3666,0.0787,29.9240,32.3828,38.1682,32.3828,389.5432,10.3978,1.4052,1.9109,24.8885,19.7944,8.0397,0.2237,1.7619,1.5796,0.8966,7.8772,7.0626,5.6000
 760.0000,1942.0259,-0.0087,2.1029,2.1282,2.1059,2.0988,2.0824,2.1029,2.1282,0.2553,2.1661,0.0335,-0.0413,3.8934,37.8679,33.1623,33.1623,30.3947,0.0794,29.3273,31.8070,37.6417,31.8070,469.8778,10.4460,1.4535,1.9340,25.4970,20.4750,8.1385,0.2195,1.8637,1.6319,0.8756,8.4909,7.4350,1.6000
 760.5000,2004.1809,0.0010,1.7607,1.7582,1.7420,1.7378,1.7323,1.7607,1.7582,0.2554,2.1681,0.0379,0.4563,3.9903,36.0700,31.3001,31.3001,28.6822,0.0823,29.2086,31.6925,37.5370,31.6925,568.7507,10.4237,1.3218,1.7011,25.4105,21.1431,8.2739,0.2237,1.9535,1.6565,0.8480,8.7334,7.4058,2.4000
 761.0000,2046.1244,0.0015,1.5047,1.5016,1.4903,1.4879,1.4896,1.5047,1.5016,0.2560,2.1729,-0.0605,0.2608,4.1127,37.4360,32.7134,32.7134,29.9825,0.0866,28.9147,31.4089,37.2777,31.4089,665.9600,10.3867,1.1401,1.4970,25.4212,21.8518,8.5212,0.2322,2.0359,1.6972,0.8336,8.7667,7.3083,0.0000
 761.5000,2035.5413,0.0139,1.3842,1.3576,1.3496,1.3482,1.3541,1.3842,1.3576,0.2564,2.1898,-0.1220,0.0083,4.0893,37.1931,32.4613,32.4613,29.7508,0.0917,27.8894,30.4195,36.3730,30.4195,736.5674,10.3372,1.0716,1.3627,25.9886,22.5859,8.9012,0.2489,2.0874,1.7430,0.8350,8.3872,7.0031,5.0000
 762.0000,1996.7299,0.0170,1.3171,1.2864,1.2808,1.2800,1.2875,1.3171,1.2864,0.2545,2.2040,0.0852,-0.0461,3.9685,35.9106,31.1358,31.1358,28.5309,0.0976,27.0329,29.5932,35.6173,29.5932,777.3849,10.3234,0.9778,1.2333,28.2084,22.9013,9.0396,0.2540,2.1024,1.7642,0.8391,8.2772,6.9455,1.0000
 762.5000,2013.1636,0.0171,1.2847,1.2546,1.2513,1.2510,1.2572,1.2847,1.2546,0.2558,2.2051,0.3851,-0.5211,3.9835,36.0488,31.2782,31.2782,28.6621,0.1031,26.9653,29.5279,35.5576,29.5279,797.0573,10.1609,0.9567,1.1736,30.1302,22.8271,8.9404,0.2492,2.0958,1.7543,0.8371,8.4097,7.0395,0.0000
 763.0000,2009.6738,0.0117,1.2569,1.2367,1.2356,1.2357,1.2379,1.2569,1.2367,0.2550,2.1962,0.3489,-0.3134,4.1047,36.2838,31.5206,31.5206,28.8854,0.1060,27.5058,30.0494,36.0345,30.0494,808.6065,9.9843,0.9708,1.1051,28.6884,22.0755,8.6276,0.2382,2.0211,1.7037,0.8430,8.4845,7.1522,0.0000
 763.5000,2023.3790,0.0155,1.2563,1.2295,1.2308,1.2318,1.2392,1.2562,1.2295,0.2564,2.1942,-0.0048,0.3425,4.1762,37.1425,32.4088,32.4088,29.7026,0.1058,27.6222,30.1618,36.1372,30.1618,813.3620,9.8122,0.9771,1.0945,27.7846,21.8825,8.4763,0.2306,2.0019,1.6903,0.8444,8.6825,7.3313,3.0000
 764.0000,2026.9611,0.0142,1.2718,1.2470,1.2513,1.2540,1.2604,1.2709,1.2470,0.2554,2.1993,-0.3103,0.3476,4.1729,36.5427,31.7880,31.7880,29.1315,0.1012,27.3122,29.8626,35.8637,29.8626,801.9459,9.7349,1.0135,1.1307,29.8357,22.0776,8.4724,0.2284,2.0233,1.6995,0.8400,8.8598,7.4420,4.0000
 764.5000,2046.1356,0.0125,1.2967,1.2744,1.2828,1.2884,1.2943,1.2973,1.2744,0.2551,2.1880,-0.2566,0.1777,4.1999,36.5038,31.7478,31.7478,29.0946,0.0939,27.9970,30.5234,36.4679,30.5234,784.6852,9.7291,1.0960,1.1378,30.6378,22.1533,8.4500,0.2245,2.0332,1.7106,0.8414,9.0579,7.6211,5.0000
 765.0000,1992.6754,0.0137,1.3190,1.2942,1.3079,1.3179,1.3254,1.3233,1.2942,0.2558,2.1619,0.0985,0.3528,4.3839,37.6294,32.9142,32.9142,30.1669,0.0878,29.5798,32.0507,37.8645,32.0507,772.6910,9.8014,1.2056,1.3153,29.5699,22.4807,8.4856,0.2262,2.0759,1.7139,0.8256,9.1757,7.5755,5.6000
 765.5000,2008.5109,0.0236,1.3130,1.2704,1.2896,1.3049,1.3184,1.3191,1.2704,0.2553,2.1434,0.2400,0.0793,4.6209,38.4663,33.7859,33.7859,30.9667,0.0843,30.7027,33.1341,38.8553,33.1341,787.1292,9.8829,1.3541,1.3781,28.9007,22.4215,8.3884,0.2240,2.0813,1.6927,0.8133,9.2928,7.5576,1.6000
 766.0000,1976.4487,0.0490,1.2605,1.1764,1.1991,1.2187,1.2415,1.2552,1.1764,0.2551,2.1347,-0.0626,-0.2672,4.5922,37.8425,33.1358,33.1358,30.3704,0.0833,31.2286,33.6416,39.3193,33.6416,850.0215,9.8712,1.3052,1.4147,28.3146,21.9299,7.9173,0.2093,2.0729,1.6077,0.7756,9.9047,7.6816,1.6000
 766.5000,2008.1655,0.0891,1.1901,1.0473,1.0711,1.0928,1.1251,1.1578,1.0473,0.2564,2.1388,-0.2410,0.0779,4.3344,38.3301,33.6438,33.6438,30.8364,0.0844,30.9811,33.4028,39.1010,33.4028,954.8307,9.9100,1.3382,1.6322,27.9282,21.8013,7.6155,0.1984,2.0905,1.5602,0.7463,10.5368,7.8640,2.0000
 767.0000,1977.2776,0.1219,1.1023,0.9232,0.9465,0.9690,1.0094,1.0612,0.9232,0.2567,2.1658,-0.0125,0.2560,4.2358,37.4920,32.7715,32.7715,30.0359,0.0878,29.3478,31.8268,37.6598,31.8269,1083.2458,9.9796,1.3625,1.6459,28.2655,21.9167,7.4761,0.1870,2.1168,1.5685,0.7410,11.3192,8.3872,1.0000
 767.5000,1928.7930,0.1346,1.0143,0.8331,0.8560,0.8792,0.9270,0.9970,0.8331,0.2558,2.1948,0.0606,-0.0526,4.2972,36.1909,31.4247,31.4247,28.7971,0.0942,27.5908,30.1315,36.1096,30.1315,1200.3344,9.9738,1.2780,1.4969,28.3556,22.2569,7.3726,0.1749,2.1798,1.5920,0.7304,12.4649,9.1039,2.0000
 768.0000,1875.7017,0.1531,0.9922,0.7918,0.8159,0.8415,0.8980,0.9885,0.7918,0.2557,2.2033,-0.1945,-0.2380,4.2939,36.9152,32.1733,32.1733,29.4861,0.0973,27.0723,29.6311,35.6520,29.6311,1262.9054,9.9250,1.2677,1.5244,28.8757,23.4201,7.5804,0.1733,2.3189,1.6678,0.7192,13.3815,9.6243,2.0000
 768.5000,1945.0197,0.2091,1.1150,0.8136,0.8424,0.8744,0.9478,1.0693,0.8136,0.2539,2.2094,-0.4679,0.0029,4.2683,37.4810,32.7601,32.7601,30.0254,0.0944,26.7033,29.2751,35.3265,29.2752,1229.0393,9.9523,1.3326,1.6162,29.3299,24.5216,7.6296,0.1701,2.4767,1.6989,0.6859,14.5576,9.9858,3.0000
 769.0000,1970.3451,0.2988,1.3951,0.8759,0.9125,0.9556,1.0559,1.2249,0.8759,0.2547,2.2273,-0.5913,0.2452,4.2413,36.6178,31.8657,31.8657,29.2030,0.0900,25.6206,28.2304,34.3711,28.2304,1141.6605,9.9937,1.4402,1.6892,29.4423,25.4201,7.8436,0.1775,2.5791,1.7342,0.6724,14.5286,9.7688,1.0000
 769.5000,1963.7230,0.3919,1.7706,0.9430,0.9884,1.0451,1.1771,1.4050,0.9430,0.2544,2.2400,-0.3870,0.3336,4.1240,36.0771,31.3074,31.3074,28.6890,0.0823,24.8506,27.4874,33.6917,27.4874,1060.3971,10.0399,1.5290,1.8075,30.8555,25.5666,7.9889,0.1845,2.5708,1.7488,0.6803,13.9344,9.4792,0.0000
 770.0000,1988.3342,0.4768,2.2046,1.0039,1.0575,1.1287,1.2931,1.5860,1.0039,0.2557,2.2443,0.1187,0.4685,3.9936,33.1672,28.3299,28.3299,25.9375,0.0727,24.5880,27.2340,33.4600,27.2340,996.1183,10.0461,1.5908,1.8590,32.4570,25.0906,8.1918,0.1928,2.4571,1.7760,0.7228,12.7439,9.2114,1.0000
 770.5000,1979.4886,0.5567,2.7185,1.0623,1.1235,1.2100,1.4068,1.7717,1.0623,0.2560,2.2591,0.5455,0.3213,3.9887,33.3053,28.4702,28.4702,26.0675,0.0646,23.6905,26.3681,32.6681,26.3681,941.3218,10.0265,1.7035,1.9132,32.9352,24.5665,8.1949,0.1893,2.3612,1.7934,0.7596,12.4699,9.4716,0.0000
 771.0000,1991.8230,0.6345,3.3394,1.1198,1.1877,1.2896,1.5175,1.9559,1.1198,0.2557,2.3005,0.5032,0.0278,4.0658,32.5078,27.6614,27.6614,25.3174,0.0590,21.1844,23.9499,30.4568,23.9499,892.9778,9.9968,1.8286,2.0985,33.3688,24.9050,8.2254,0.1817,2.4031,1.8395,0.7655,13.2222,10.1213,0.0000
 771.5000,1999.7474,0.7157,4.1705,1.1873,1.2620,1.3807,1.6421,2.1623,1.1873,0.2554,2.3542,0.1527,0.0265,4.1175,30.3566,25.4973,25.4973,23.3038,0.0530,17.9253,20.8051,27.5812,20.8051,842.2495,10.0085,2.6815,2.6890,34.2057,25.8263,8.2134,0.1763,2.5461,1.8614,0.7311,14.4416,10.5578,1.6000
 772.0000,1987.5166,0.7617,4.7994,1.2433,1.3217,1.4531,1.7385,2.3194,1.2433,0.2550,2.3803,-0.1256,-0.0146,4.1733,29.4709,24.6136,24.6136,22.4788,0.0371,16.3471,19.2823,26.1886,19.2823,804.3253,10.0785,4.3248,3.4835,35.7233,27.0537,8.2388,0.1778,2.7311,1.8627,0.6821,15.3616,10.4774,0.0000
 772.5000,1993.1714,0.7474,4.7657,1.2714,1.3483,1.4827,1.7716,2.3641,1.2714,0.2559,2.3725,-0.4679,-0.0694,4.2304,29.2351,24.3791,24.3791,22.2596,0.0142,16.8183,19.7370,26.6044,19.7370,786.5522,10.1455,4.8155,3.5392,36.0855,28.4191,8.3752,0.1805,2.9229,1.8948,0.6482,16.1955,10.4985,1.6000
 773.0000,1962.6748,0.7225,4.6274,1.2992,1.3729,1.5066,1.7938,2.3846,1.2992,0.2559,2.3591,-0.6197,0.1206,4.1914,29.3515,24.4949,24.4949,22.3678,-0.0006,17.6299,20.5201,27.3205,20.5201,769.7154,10.1967,4.9643,3.6340,35.5672,29.1611,8.4404,0.1877,3.0288,1.8817,0.6213,16.1331,10.0232,0.0000
 773.5000,1955.4882,0.7351,4.8855,1.3367,1.4068,1.5382,1.8236,2.4105,1.3367,0.2555,2.3575,-0.2246,0.0007,4.1005,29.2816,24.4253,24.4253,22.3028,-0.0031,17.7248,20.6117,27.4043,20.6117,748.0951,10.2410,4.6125,3.2420,37.3605,30.4921,8.8473,0.2033,3.1814,1.9416,0.6103,15.6494,9.5509,0.0000
 774.0000,1942.3250,0.7630,5.3755,1.3888,1.4553,1.5836,1.8686,2.4540,1.3888,0.2552,2.3716,0.0811,-0.5056,4.0689,29.1334,24.2780,24.2780,22.1651,-0.0001,16.8757,19.7923,26.6550,19.7923,720.0635,10.2773,4.9503,3.5864,41.3120,31.2405,9.0639,0.2127,3.2792,1.9683,0.6002,15.4200,9.2556,0.0000
 774.5000,1980.2152,0.7146,5.0071,1.4287,1.4890,1.6083,1.8814,2.4404,1.4287,0.2572,2.3839,0.0010,-0.4989,4.1056,29.1892,24.3335,24.3335,22.2169,0.0051,16.1267,19.0696,25.9941,19.0696,699.9374,10.2624,5.9683,4.2356,41.8384,31.5771,9.3714,0.2311,3.2941,1.9818,0.6016,14.2546,8.5760,1.6000
 775.0000,1937.6261,0.5954,3.9363,1.4262,1.4763,1.5773,1.8178,2.3068,1.4262,0.2556,2.3791,-0.0856,-0.1039,4.1184,28.6966,23.8447,23.8447,21.7595,0.0134,16.4162,19.3489,26.2496,19.3489,701.1538,10.2554,6.3089,4.7241,40.5010,32.3744,9.7805,0.2450,3.3518,2.0501,0.6117,13.6797,8.3672,0.8000
 775.5000,1905.0229,0.4521,2.9194,1.3920,1.4306,1.5099,1.7080,2.1095,1.3920,0.2552,2.3760,-0.0830,0.2940,3.9804,29.9108,25.0520,25.0520,22.8883,0.0220,16.6073,19.5333,26.4182,19.5333,718.3663,10.1360,5.9067,3.9086,43.4274,33.7172,10.2710,0.2576,3.4787,2.1517,0.6185,13.5054,8.3535,0.0000
 776.0000,1901.9930,0.3221,2.2508,1.3573,1.3857,1.4460,1.6055,1.9277,1.3573,0.2560,2.3942,0.0142,0.6492,3.7511,30.2995,25.4403,25.4403,23.2506,0.0237,15.5052,18.4699,25.4457,18.4699,736.7399,10.1209,4.7836,3.4774,48.8233,37.2310,11.4216,0.2883,3.8327,2.3840,0.6220,13.2957,8.2701,1.6000
 776.5000,1903.9973,0.2159,1.8397,1.3277,1.3474,1.3920,1.5177,1.7670,1.3277,0.2559,2.4220,0.0905,0.3877,3.6336,28.1535,23.3071,23.3071,21.2560,0.0160,13.8171,16.8411,23.9563,16.8411,753.1917,10.0091,4.4690,3.4097,51.3215,41.3197,12.9906,0.3358,4.2157,2.6738,0.6343,12.5543,7.9626,0.8000
 777.0000,1893.0104,0.1600,1.6875,1.3321,1.3451,1.3783,1.4786,1.6709,1.3321,0.2553,2.4444,-0.0399,-0.0798,3.6647,27.2525,22.4192,22.4192,20.4228,0.0067,12.4593,15.5309,22.7582,15.5309,750.6740,9.9506,5.0524,3.5074,52.4108,44.2498,14.1992,0.3847,4.4806,2.8388,0.6336,11.6470,7.3793,0.0000
 777.5000,1880.2273,0.1521,1.7693,1.4143,1.4218,1.4478,1.5328,1.6887,1.4143,0.2551,2.4650,-0.1538,-0.2914,3.7662,25.9426,21.1362,21.1362,19.2159,0.0050,11.2144,14.3297,21.6598,14.3297,707.0784,9.8538,5.5436,3.5047,56.1902,46.6765,15.4111,0.4406,4.6596,2.9718,0.6378,10.5759,6.7451,0.0000
 778.0000,1908.3970,0.1302,1.9281,1.5944,1.5958,1.6168,1.6919,1.8221,1.5944,0.2555,2.4827,-0.1999,-0.1107,3.8751,25.5720,20.7750,20.7750,18.8754,0.0096,10.1411,13.2940,20.7127,13.2940,627.2083,9.7713,5.8539,3.4575,63.1930,49.2260,16.4840,0.4922,4.8715,3.0791,0.6321,9.8965,6.2552,2.0000
 778.5000,1860.6951,0.0849,2.0607,1.8248,1.8173,1.8319,1.8933,1.9948,1.8248,0.2555,2.4958,-0.2232,0.4040,3.8993,25.3194,20.5291,20.5291,18.6435,0.0123,9.3478,12.5286,20.0128,12.5286,548.0000,9.7335,5.7062,3.1595,67.6878,52.0448,18.1706,0.5609,5.0416,3.3075,0.6561,8.9891,5.8973,1.0000
 779.0000,1821.9873,0.0448,2.1656,2.0332,2.0143,2.0199,2.0580,2.1306,2.0332,0.2557,2.5081,0.1635,0.3851,3.9037,23.4117,18.6843,18.6843,16.8988,0.0127,8.5999,11.8069,19.3528,11.8069,491.8329,9.7346,5.4910,3.0364,70.1360,54.8065,20.1599,0.6337,5.1649,3.6155,0.7000,8.1508,5.7057,3.0000
 779.5000,1868.2271,0.0157,2.2545,2.2061,2.1752,2.1710,2.1898,2.2350,2.2061,0.2549,2.5166,0.5713,0.0445,4.0302,22.5499,17.8576,17.8576,16.1144,0.0129,8.0855,11.3106,18.8990,11.3106,453.2983,9.6690,5.4063,2.9373,72.5806,56.1091,21.6788,0.6879,5.1591,3.8573,0.7477,7.5001,5.6075,1.0000
 780.0000,1895.7860,-0.0068,2.3824,2.4049,2.3607,2.3473,2.3428,2.3730,2.4049,0.2555,2.5217,0.2692,0.0079,4.1448,21.5574,16.9108,16.9108,15.2138,0.0097,7.7766,11.0125,18.6264,11.0125,415.8103,9.5287,5.5513,2.9168,73.8636,55.0470,21.9447,0.6997,4.9921,3.8883,0.7789,7.1342,5.5567,1.0000
 780.5000,1889.0830,-0.0219,2.5900,2.6686,2.6082,2.5850,2.5575,2.5878,2.6686,0.2550,2.5325,-0.3145,-0.0846,4.0955,20.4865,15.8954,15.8954,14.2455,0.0055,7.1202,10.3791,18.0472,10.3791,374.7311,9.4031,5.4640,2.9706,74.0286,52.7971,21.4584,0.6915,4.7622,3.7677,0.7912,6.8870,5.4488,1.0000
 781.0000,1878.4537,-0.0338,2.7951,2.9264,2.8489,2.8164,2.7676,2.7964,2.9264,0.2552,2.5463,-0.3904,-0.2212,4.0336,19.0383,14.5327,14.5327,12.9419,0.0061,6.2855,9.5738,17.3108,9.5738,341.7123,9.3351,6.2964,3.4488,69.0074,49.3239,20.6533,0.6660,4.3756,3.6241,0.8283,6.5698,5.4415,0.0000
 781.5000,1889.8668,-0.0428,2.9808,3.1584,3.0636,3.0222,2.9554,2.9841,3.1584,0.2570,2.5548,0.0657,-0.0094,4.0828,18.1889,13.7390,13.7390,12.1804,0.0090,5.7678,9.0742,16.8539,9.0742,316.6141,9.2894,6.2618,3.1233,62.9467,46.0159,19.9801,0.6493,3.9763,3.4821,0.8757,6.1237,5.3625,0.0000
 782.0000,1914.8583,-0.0497,3.1293,3.3458,3.2350,3.1859,3.1053,3.1343,3.3458,0.2550,2.5596,0.4223,0.2746,4.1556,17.5230,13.1196,13.1196,11.5850,0.0118,5.4804,8.7969,16.6003,8.7969,298.8810,9.2190,7.0375,4.0268,60.8581,43.3145,19.6885,0.6392,3.6043,3.4343,0.9528,5.6385,5.3726,1.0000
 782.5000,1906.9225,-0.0556,3.2965,3.5519,3.4244,3.3676,3.2747,3.3044,3.5519,0.2540,2.5650,0.3787,-0.0497,4.2257,16.9992,12.6342,12.6342,11.1175,0.0131,5.1542,8.4821,16.3125,8.4821,281.5413,9.1688,8.2409,4.1836,57.7542,41.9427,19.7201,0.6387,3.3810,3.4472,1.0196,5.2937,5.3973,0.0000
 783.0000,1918.4280,-0.0612,3.4520,3.7469,3.6035,3.5398,3.4365,3.4639,3.7469,0.2553,2.5766,0.1113,-0.7265,4.2838,16.5226,12.1939,12.1939,10.6930,0.0131,4.4492,7.8018,15.6904,7.8018,266.8843,9.1238,5.9236,3.5104,52.5286,40.5705,19.8079,0.6396,3.1586,3.4716,1.0991,4.9382,5.4275,1.0000
 783.5000,1921.4803,-0.0686,3.6102,3.9562,3.7966,3.7259,3.6119,3.6279,3.9562,0.2553,2.5861,-0.1999,-0.7351,4.3045,16.1287,11.8311,11.8311,10.3428,0.0138,3.8742,7.2470,15.1831,7.2470,252.7668,9.1106,6.9312,3.7916,51.2064,40.2000,20.0055,0.6397,3.0739,3.5362,1.1504,4.8053,5.5281,0.0000
 784.0000,1953.7032,-0.0768,3.6910,4.0880,3.9163,3.8411,3.7194,3.7133,4.0880,0.2558,2.5868,-0.3127,-0.2153,4.3235,16.4957,12.1691,12.1691,10.6691,0.0141,3.8321,7.2064,15.1460,7.2064,244.6161,9.0910,6.4455,3.9697,54.2889,40.5031,20.5225,0.6601,3.0353,3.6090,1.1890,4.5979,5.4671,0.8000
 784.5000,1942.7051,-0.0837,3.6732,4.1040,3.9261,3.8497,3.7255,3.6961,4.1040,0.2560,2.5840,-0.1338,0.3531,4.2250,17.2536,12.8697,12.8697,11.3444,0.0146,3.9997,7.3681,15.2938,7.3681,243.6654,9.1228,6.4654,3.8291,57.6703,41.6389,21.5510,0.6920,3.0527,3.7956,1.2434,4.4112,5.4848,0.8000
 785.0000,1966.7743,-0.0879,3.6183,4.0645,3.8834,3.8075,3.6841,3.6381,4.0645,0.2558,2.5773,0.1346,0.7409,4.0201,17.7751,13.3538,13.3538,11.8102,0.0145,4.4043,7.7585,15.6508,7.7585,246.0351,9.1247,6.2632,3.9674,57.5302,41.6888,22.1828,0.7146,2.9735,3.8960,1.3102,4.1610,5.4519,0.0000
 785.5000,1937.4766,-0.0920,3.6418,4.1120,3.9240,3.8470,3.7222,3.6619,4.1120,0.2559,2.5742,0.3243,0.4520,4.0019,17.6367,13.2252,13.2252,11.6865,0.0126,4.5969,7.9444,15.8208,7.9444,243.1899,9.1207,6.2913,4.0206,53.9365,40.1819,22.2769,0.7173,2.7540,3.9140,1.4212,3.8392,5.4564,0.0000
 786.0000,1963.0662,-0.0977,3.7344,4.2427,4.0434,3.9638,3.8351,3.7618,4.2470,0.2557,2.5793,0.2372,-0.0729,4.1361,16.9075,12.5494,12.5494,11.0359,0.0118,4.2865,7.6448,15.5469,7.6448,235.7011,9.1269,7.6812,4.4368,49.4006,38.2439,21.8046,0.6967,2.5531,3.8567,1.5106,3.6646,5.5355,0.8000
 786.5000,1971.0020,-0.1011,3.7672,4.2969,4.0889,4.0078,3.8786,3.7979,4.3021,0.2541,2.5797,0.0644,-0.2532,4.1434,17.1826,12.8040,12.8040,11.2811,0.0116,4.2579,7.6172,15.5217,7.6173,232.7282,9.1439,7.5377,4.0594,49.2132,37.1478,21.3612,0.6759,2.4682,3.8097,1.5435,3.6517,5.6363,0.0000
 787.0000,1966.6708,-0.1059,3.8021,4.3626,4.1443,4.0607,3.9281,3.8372,4.3683,0.2548,2.5721,0.2716,-0.2562,4.0778,17.4120,13.0166,13.0166,11.4858,0.0114,4.7193,8.0625,15.9288,8.0625,229.2218,9.1695,8.0447,4.1537,53.9293,37.6985,21.7157,0.6779,2.5115,3.9167,1.5595,3.7049,5.7778,0.0000
 787.5000,1969.8964,-0.1163,3.8937,4.5249,4.2901,4.2011,4.0567,3.9396,4.5314,0.2560,2.5754,0.2661,-0.1315,4.0967,17.4146,13.0190,13.0190,11.4882,0.0132,4.5217,7.8718,15.7544,7.8718,220.9975,9.2009,8.2196,4.4873,55.2712,37.9042,21.7759,0.6713,2.5507,3.9677,1.5555,3.7996,5.9102,0.0000
 788.0000,1951.3887,-0.1350,4.0943,4.8664,4.6041,4.5050,4.3355,4.1659,4.8740,0.2542,2.5961,-0.2564,-0.0910,4.1631,15.8437,11.5691,11.5691,10.0897,0.0164,3.2691,6.6632,14.6492,6.6632,205.4916,9.2366,7.1869,3.9777,51.4053,36.8125,21.2230,0.6509,2.4829,3.8827,1.5638,3.8143,5.9648,4.0000
 788.5000,1997.8354,-0.1608,4.3831,5.3706,5.0709,4.9570,4.7495,4.4988,5.3799,0.2564,2.6099,-0.3923,-0.0200,4.2527,15.1261,10.9114,10.9114,9.4534,0.0182,2.4278,5.8514,13.9069,5.8514,186.2002,9.2612,7.2499,4.2785,45.6721,35.4021,20.4101,0.6274,2.4012,3.7276,1.5524,3.8275,5.9418,2.4000
 789.0000,1976.3914,-0.1841,4.5889,5.7756,5.4443,5.3172,5.0723,4.7428,5.7863,0.2547,2.6079,0.0347,0.2390,4.3748,14.9253,10.7280,10.7280,9.2757,0.0201,2.5538,5.9729,14.0180,5.9730,173.1424,9.3192,9.4593,5.4033,43.1517,36.4847,20.7616,0.6434,2.5187,3.7669,1.4956,3.9146,5.8546,0.0000
 789.5000,1978.5215,-0.1908,4.5158,5.7267,5.3926,5.2634,5.0055,4.6570,5.7369,0.2551,2.6008,0.4396,0.1211,4.3789,15.1386,10.9229,10.9229,9.4645,0.0297,2.9812,6.3853,14.3951,6.3853,174.6197,9.3433,9.8560,5.0138,50.5042,41.0602,22.9255,0.7166,2.8952,4.1303,1.4266,4.0400,5.7634,1.6000
 790.0000,1959.6921,-0.1877,4.2558,5.3794,5.0648,4.9425,4.6913,4.3702,5.3879,0.2541,2.6000,0.4760,-0.0713,4.1803,16.8209,12.4694,12.4694,10.9587,0.0430,3.0296,6.4320,14.4378,6.4320,185.8957,9.5086,6.2373,4.1311,64.0950,47.1248,25.7195,0.8078,3.4091,4.6156,1.3539,4.2203,5.7139,0.0000
 790.5000,1966.1534,-0.1897,4.1347,5.2388,4.9373,4.8195,4.5660,4.2456,5.2464,0.2550,2.6137,0.1120,0.2024,4.0652,18.4924,14.0220,14.0220,12.4522,0.0434,2.2027,5.6341,13.7082,5.6342,190.8830,9.6627,5.9871,3.6417,72.2844,51.3826,27.2893,0.8557,3.8282,4.9037,1.2810,4.4736,5.7305,0.0000
 791.0000,1965.4392,-0.1948,4.2101,5.3682,5.0710,4.9551,4.6863,4.3258,5.3727,0.2561,2.6237,-0.1718,0.0118,4.1492,18.0144,13.5764,13.5764,12.0242,0.0332,1.5931,5.0460,13.1704,5.0460,186.2821,9.7957,8.5836,5.0114,70.6793,52.3435,27.0939,0.8547,3.9969,4.8446,1.2121,4.6765,5.6683,0.0000
 791.5000,1936.8658,-0.1960,4.1673,5.3254,5.0498,4.9445,4.6758,4.2880,5.3254,0.2550,2.6132,-0.0405,-0.3821,4.1693,17.3449,12.9544,12.9544,11.4259,0.0299,2.2332,5.6636,13.7351,5.6636,187.7803,9.8923,8.9184,5.0647,69.1028,52.3489,26.4559,0.8482,4.0751,4.6656,1.1449,4.8044,5.5005,1.0000
 792.0000,1949.7534,-0.1856,3.9897,5.0390,4.8044,4.7198,4.4754,4.0899,5.0390,0.2557,2.5951,0.0626,-0.0851,4.1098,18.1958,13.7454,13.7454,12.1866,0.0326,3.3281,6.7201,14.7013,6.7201,198.4540,10.0063,8.0348,4.4086,70.6677,52.7665,25.8204,0.8404,4.2158,4.4938,1.0660,5.0162,5.3470,2.0000
 792.5000,1939.3187,-0.1680,3.8793,4.8014,4.6104,4.5509,4.3435,3.9679,4.8014,0.2546,2.5849,-0.1287,0.0717,4.0647,19.0109,14.5070,14.5070,12.9173,0.0315,3.9447,7.3151,15.2453,7.3151,208.2707,10.0920,8.6537,4.6313,70.1592,54.7294,25.9019,0.8556,4.4932,4.4485,0.9900,5.2513,5.1991,4.0000
 793.0000,1928.3779,-0.1373,3.7471,4.4733,4.3319,4.3031,4.1593,3.8213,4.4733,0.2553,2.5769,-0.3675,0.0635,3.9653,19.2965,14.7747,14.7747,13.1738,0.0254,4.4305,7.7838,15.6739,7.7838,223.5490,10.1698,7.0372,4.0701,70.5196,55.5306,25.8093,0.8595,4.6396,4.3999,0.9483,5.3983,5.1194,0.0000
 793.5000,1940.5739,-0.0617,3.7584,4.0821,3.9910,3.9960,3.9619,3.8329,4.0821,0.2556,2.5734,-0.2551,-0.0881,3.9397,19.1801,14.6655,14.6655,13.0692,0.0192,4.6400,7.9860,15.8588,7.9860,244.9721,10.2125,7.0062,4.0799,69.5953,53.4551,24.3960,0.8216,4.5389,4.1152,0.9066,5.5244,5.0086,0.0000
 794.0000,1930.6475,-0.0330,3.2790,3.4295,3.3869,3.4245,3.4021,3.2887,3.4295,0.2549,2.5766,0.1690,-0.0585,4.1238,19.1443,14.6320,14.6320,13.0371,0.0170,4.4465,7.7992,15.6881,7.7992,291.5898,10.2713,7.4283,4.4371,64.1672,48.9026,22.0455,0.7501,4.1960,3.6825,0.8776,5.5940,4.9094,2.0000
 794.5000,1950.9850,0.0401,2.7825,2.6302,2.6251,2.6758,2.7230,2.7146,2.6302,0.2547,2.5623,0.1911,0.1578,4.2712,19.7055,15.1590,15.1590,13.5417,0.0158,5.3169,8.6391,16.4560,8.6391,380.1991,10.3259,7.1960,4.8831,57.7640,45.9451,20.2878,0.6936,4.0017,3.3733,0.8430,5.7697,4.8637,0.0000
 795.0000,1913.5907,0.1056,2.3881,2.0502,2.0634,2.1136,2.1920,2.2706,2.0502,0.2545,2.5311,-0.1911,-0.1259,4.1039,21.9862,17.3192,17.3192,15.6025,0.0112,7.2059,10.4618,18.1228,10.4618,487.7569,10.3926,6.2561,3.3157,55.2810,45.1417,19.3402,0.6585,4.0126,3.2284,0.8046,6.0934,4.9026,2.0000
 795.5000,1888.7614,0.1433,2.1495,1.7419,1.7636,1.8155,1.9116,2.0391,1.7419,0.2547,2.5083,-0.1801,-0.1819,3.7910,23.3394,18.6149,18.6149,16.8330,0.0080,8.5872,11.7946,19.3416,11.7946,574.0978,10.4266,5.4626,2.9786,56.1571,45.3818,18.8527,0.6453,4.1057,3.1308,0.7625,6.3621,4.8513,4.0000
 796.0000,1934.4130,0.1684,2.1304,1.6596,1.6902,1.7525,1.8755,2.0513,1.6596,0.2550,2.5006,0.2784,-0.0452,3.7460,23.3045,18.5813,18.5813,16.8011,0.0130,9.0575,12.2484,19.7566,12.2484,602.5619,10.4630,7.0387,4.0231,55.9948,45.5249,18.2208,0.6344,4.2040,2.9753,0.7077,6.6271,4.6902,0.8000
 796.5000,1995.6704,0.2143,2.3638,1.7104,1.7535,1.8366,2.0033,2.2450,1.7104,0.2543,2.4969,0.3898,-0.1383,3.9933,23.3981,18.6712,18.6712,16.8864,0.0225,9.2792,12.4624,19.9523,12.4624,584.6531,10.5134,7.9842,5.1868,55.6513,43.1021,16.8449,0.5961,4.0234,2.7048,0.6723,6.7494,4.5374,3.2000
 797.0000,2014.0161,0.3068,2.9379,1.8194,1.8783,1.9916,2.2184,2.5487,1.8194,0.2554,2.4784,-0.0427,-0.2170,4.2419,23.4862,18.7560,18.7560,16.9667,0.0262,10.4004,13.5442,20.9415,13.5442,549.6444,10.5659,7.8287,5.2079,52.6339,39.7360,15.1659,0.5510,3.7433,2.3674,0.6324,6.7938,4.2965,0.8000
 797.5000,2016.5039,0.4201,3.8018,1.9236,1.9984,2.1459,2.4378,2.8734,1.9236,0.2551,2.4446,-0.2718,-0.0823,4.3333,23.3450,18.6202,18.6202,16.8380,0.0277,12.4481,15.5201,22.7483,15.5201,519.8686,10.6292,6.6943,5.1479,47.4039,36.7880,13.9407,0.5079,3.4643,2.1696,0.6263,6.8214,4.2720,2.0000
 798.0000,2034.7000,0.5161,4.7051,1.9885,2.0753,2.2526,2.5992,3.1421,1.9885,0.2546,2.4141,0.1193,0.0303,4.3083,23.4086,18.6813,18.6813,16.8960,0.0436,14.2955,17.3027,24.3784,17.3027,502.8897,10.6442,5.7493,4.7323,43.0348,32.9308,12.2273,0.4464,3.1247,1.8981,0.6075,6.9991,4.2517,1.0000
 798.5000,2011.4012,0.5768,5.3250,2.0009,2.0927,2.2876,2.6649,3.2891,2.0009,0.2547,2.3927,0.4826,-0.0527,4.3141,23.6325,18.8968,18.8968,17.1002,0.0731,15.5941,18.5557,25.5242,18.5557,499.7773,10.5826,4.6299,3.8897,38.4614,29.8344,10.7790,0.3852,2.8650,1.7132,0.5980,7.4386,4.4480,0.0000
 799.0000,2061.3030,0.5953,5.4601,1.9787,2.0697,2.2701,2.6561,3.3241,1.9787,0.2565,2.3806,0.2638,0.0663,4.3489,24.3128,19.5532,19.5532,17.7215,0.0998,16.3269,19.2628,26.1708,19.2628,505.3700,10.5641,3.2799,3.2251,33.8827,27.4169,9.6358,0.3254,2.6814,1.6212,0.6046,8.2404,4.9824,2.0000
 799.5000,2033.4797,0.5736,5.1174,1.9351,2.0209,2.2162,2.5946,3.2696,1.9351,0.2535,2.3772,-0.0386,0.0243,4.3007,23.7128,18.9741,18.9741,17.1734,0.1181,16.5345,19.4631,26.3539,19.4631,516.7729,10.5907,2.9632,2.9622,30.4398,25.3534,8.6679,0.2760,2.5201,1.5378,0.6102,9.1317,5.5726,0.0000
 800.0000,2012.1390,0.5543,4.7713,1.8732,1.9509,2.1320,2.4890,3.1345,1.8732,0.2548,2.3782,-0.0643,-0.2791,4.2149,24.4954,19.7298,19.7298,17.8885,0.1275,16.4750,19.4057,26.3015,19.4057,533.8354,10.6167,2.6211,2.7643,30.0079,25.5195,8.5642,0.2581,2.5729,1.5885,0.6174,9.9685,6.1546,1.0000
 800.5000,2007.4290,0.5288,4.3905,1.8108,1.8796,2.0427,2.3734,2.9704,1.8108,0.2550,2.3811,-0.0718,-0.3605,4.1610,24.0656,19.3144,19.3144,17.4956,0.1283,16.2948,19.2318,26.1424,19.2318,552.2432,10.6291,2.5619,2.7999,34.2851,26.9675,8.9604,0.2615,2.7322,1.7028,0.6232,10.4503,6.5128,2.0000
 801.0000,2030.0820,0.4880,3.8936,1.7358,1.7947,1.9354,2.2308,2.7569,1.7358,0.2549,2.3825,-0.1736,-0.3369,4.1361,24.2345,19.4776,19.4776,17.6500,0.1267,16.2144,19.1543,26.0716,19.1543,576.1001,10.6357,3.1426,3.4652,40.8017,29.7017,9.7292,0.2766,3.0283,1.8835,0.6220,10.9483,6.8093,2.0000
 801.5000,2062.7087,0.4154,3.1218,1.5929,1.6384,1.7463,1.9814,2.3902,1.5929,0.2552,2.3797,-0.2328,0.1029,4.1361,24.3402,19.5797,19.5797,17.7466,0.1267,16.3788,19.3129,26.2166,19.3129,627.7841,10.6688,2.8999,3.2493,42.6556,31.4122,10.1905,0.2841,3.2229,1.9996,0.6204,11.3462,7.0395,2.0000
 802.0000,2046.6654,0.3266,2.3395,1.3998,1.4315,1.5053,1.6732,1.9607,1.3998,0.2560,2.3712,-0.0430,0.3465,4.1451,25.1200,20.3354,20.3354,18.4607,0.1320,16.8949,19.8108,26.6719,19.8108,714.3931,10.5848,1.7270,2.1205,39.1243,31.0543,10.2129,0.2772,3.1878,2.0394,0.6397,11.4990,7.3563,1.0000
 802.5000,2068.1555,0.2426,1.7450,1.2050,1.2258,1.2731,1.3863,1.5817,1.2050,0.2558,2.3545,0.3102,-0.2948,4.1948,26.2772,21.4631,21.4631,19.5237,0.1412,17.9095,20.7899,27.5672,20.7899,829.8552,10.5697,1.4039,1.7906,34.3645,29.2746,9.9015,0.2648,2.9932,1.9959,0.6668,11.3026,7.5368,4.0000
 803.0000,2069.8257,0.1731,1.3440,1.0393,1.0526,1.0822,1.1575,1.2914,1.0393,0.2562,2.3398,0.3622,-0.5667,4.3052,27.1555,22.3239,22.3239,20.3333,0.1550,18.8019,21.6509,28.3546,21.6509,962.2148,10.6207,1.4357,1.8765,30.4531,26.8871,9.2178,0.2463,2.7517,1.8591,0.6756,11.1709,7.5471,1.6000
 803.5000,2035.2073,0.1249,1.1133,0.9281,0.9368,0.9560,1.0083,1.1059,0.9281,0.2547,2.3297,-0.0999,-0.1340,4.3242,28.8997,24.0460,24.0460,21.9480,0.1703,19.4123,22.2400,28.8932,22.2400,1077.4608,10.7036,1.4762,1.7462,30.1186,25.8452,8.9564,0.2415,2.6316,1.7961,0.6825,10.8966,7.4372,2.4000
 804.0000,2026.1199,0.0979,1.0310,0.8955,0.9015,0.9155,0.9558,1.0348,0.8955,0.2558,2.3074,-0.4906,0.1605,4.1097,29.7812,24.9228,24.9228,22.7676,0.1711,20.7609,23.5412,30.0831,23.5412,1116.7561,10.7277,1.3878,1.4321,32.0966,25.6624,9.0205,0.2429,2.5918,1.8105,0.6986,10.6698,7.4535,0.0000
 804.5000,2033.2144,0.0805,1.0614,0.9461,0.9506,0.9620,0.9958,1.0599,0.9461,0.2552,2.2878,-0.3352,0.0558,3.8643,30.1529,25.2938,25.2938,23.1139,0.1654,21.9521,24.6906,31.1342,24.6906,1056.9453,10.7519,1.2541,1.2883,33.0646,25.9222,9.0712,0.2408,2.6178,1.8371,0.7018,10.8707,7.6287,4.0000
 805.0000,2060.2437,0.0671,1.2481,1.1346,1.1376,1.1488,1.1801,1.2277,1.1346,0.2554,2.2911,-0.1507,-0.3600,3.8266,29.4947,24.6374,24.6374,22.5010,0.1679,21.7489,24.4945,30.9549,24.4945,881.3347,10.7435,1.2010,1.4639,33.1904,25.2076,8.8671,0.2323,2.5417,1.8104,0.7123,10.9411,7.7933,2.0000
 805.5000,2024.9109,0.0318,1.3425,1.2841,1.2840,1.2927,1.3136,1.3316,1.2841,0.2553,2.2978,-0.1939,-0.3123,3.7913,29.7613,24.9029,24.9029,22.7491,0.1722,21.3447,24.1045,30.5982,24.1045,778.7303,10.7167,1.3810,1.8149,31.4345,23.3021,8.0053,0.2092,2.3780,1.6368,0.6883,11.3649,7.8222,1.0000
 806.0000,2055.5447,0.0060,1.2646,1.2541,1.2509,1.2553,1.2627,1.2641,1.2541,0.2546,2.2924,-0.1837,0.1251,3.5627,30.1942,25.3350,25.3350,23.1524,0.1756,21.6732,24.4215,30.8881,24.4215,797.3632,10.7246,1.3446,1.6547,28.4930,21.6992,7.3484,0.1923,2.2287,1.5013,0.6736,11.5886,7.8062,3.0000
 806.5000,2052.5046,0.0022,1.1754,1.1718,1.1671,1.1689,1.1703,1.1738,1.1718,0.2544,2.2805,0.0027,0.1365,3.3282,31.1638,26.3064,26.3064,24.0578,0.1797,22.3946,25.1175,31.5246,25.1175,853.3715,10.7466,1.2093,1.4511,26.2634,20.3329,6.9248,0.1833,2.0754,1.4049,0.6769,11.3219,7.6642,2.0000
 807.0000,2035.0341,0.0037,1.0993,1.0937,1.0883,1.0890,1.0897,1.0982,1.0937,0.2550,2.2693,0.3998,0.0573,3.2455,30.8029,25.9442,25.9442,23.7204,0.1820,23.0748,25.7740,32.1249,25.7740,914.3163,10.7576,1.2280,1.4435,25.3409,20.4233,7.1375,0.1872,2.0508,1.4563,0.7101,10.9557,7.7800,2.0000
 807.5000,2019.9814,0.0111,1.0565,1.0404,1.0347,1.0352,1.0378,1.0563,1.0404,0.2552,2.2665,0.5416,0.2656,3.2221,30.6173,25.7583,25.7583,23.5472,0.1844,23.2417,25.9349,32.2720,25.9349,961.1465,10.7659,1.2793,1.3830,25.4961,21.1386,7.5698,0.1997,2.1009,1.5388,0.7325,10.5182,7.7042,2.4000
 808.0000,2017.6904,0.0193,1.0613,1.0332,1.0273,1.0279,1.0335,1.0607,1.0332,0.2542,2.2720,-0.0145,0.2521,3.1440,30.4199,25.5606,25.5606,23.3629,0.1880,22.9078,25.6127,31.9774,25.6127,967.9103,10.7571,1.2298,1.3448,28.0523,23.8228,8.5066,0.2229,2.3653,1.7366,0.7342,10.6115,7.7911,0.8000
 808.5000,2054.6934,0.0272,1.0989,1.0579,1.0519,1.0529,1.0623,1.0981,1.0579,0.2548,2.2845,-0.3559,-0.1501,3.0751,29.6576,24.7995,24.7995,22.6525,0.1902,22.1537,24.8851,31.3121,24.8852,945.2380,10.7063,1.2379,1.4666,31.8360,27.5169,9.8413,0.2578,2.7317,2.0093,0.7355,10.5945,7.7928,1.6000
 809.0000,2022.0890,0.0362,1.1305,1.0746,1.0687,1.0704,1.0841,1.1285,1.0746,0.2548,2.3035,0.0524,-0.3933,3.0852,27.7590,22.9179,22.9179,20.8910,0.1901,21.0023,23.7741,30.2961,23.7741,930.5573,10.6534,1.3460,1.5896,38.1706,31.4553,11.1870,0.3009,3.1054,2.2472,0.7236,10.3219,7.4694,1.6000
 809.5000,2045.3990,0.0458,1.1332,1.0624,1.0572,1.0599,1.0779,1.1304,1.0624,0.2543,2.3144,0.1447,-0.1564,3.1270,27.4739,22.6370,22.6370,20.6274,0.1853,20.3410,23.1360,29.7126,23.1360,941.2394,10.6568,1.3168,1.5603,42.9135,33.7548,11.9618,0.3350,3.3077,2.3396,0.7073,9.8730,6.9833,0.0000
 810.0000,1991.6509,0.0550,1.1261,1.0418,1.0378,1.0416,1.0636,1.1231,1.0418,0.2549,2.3083,-0.2086,-0.1072,3.1072,27.2720,22.4383,22.4383,20.4408,0.1768,20.7113,23.4933,30.0393,23.4933,959.8599,10.6353,1.2733,1.5136,43.0009,33.9643,11.7975,0.3458,3.3300,2.2343,0.6710,9.6288,6.4607,2.0000
 810.5000,1971.8768,0.0640,1.1327,1.0344,1.0316,1.0369,1.0627,1.1280,1.0344,0.2556,2.2959,-0.1433,-0.0950,2.8901,28.6274,23.7760,23.7760,21.6953,0.1699,21.4590,24.2148,30.6991,24.2148,966.7100,10.6028,1.2068,1.4880,44.5016,32.6017,11.1039,0.3358,3.1875,2.0542,0.6445,9.4930,6.1178,1.0000
 811.0000,2051.3643,0.0707,1.1615,1.0503,1.0487,1.0562,1.0860,1.1563,1.0503,0.2544,2.2900,0.1275,0.4421,2.5678,29.1048,24.2496,24.2496,22.1385,0.1661,21.8185,24.5617,31.0163,24.5617,952.1298,10.6013,1.2551,1.4567,40.3752,30.5114,10.2068,0.3131,2.9893,1.8669,0.6245,9.5461,5.9618,2.0000
 811.5000,2039.9174,0.0758,1.1972,1.0745,1.0744,1.0846,1.1186,1.1937,1.0745,0.2532,2.2949,-0.0109,0.2445,2.5101,29.5940,24.7362,24.7362,22.5933,0.1640,21.5226,24.2761,30.7552,24.2762,930.6654,10.6346,1.2568,1.4554,33.4741,28.0893,9.2896,0.2858,2.7515,1.6952,0.6161,9.6258,5.9303,1.0000
 812.0000,2035.1836,0.0853,1.2144,1.0747,1.0764,1.0890,1.1265,1.2066,1.0747,0.2543,2.3039,-0.2879,-0.3283,2.7786,28.3110,23.4629,23.4629,21.4020,0.1640,20.9746,23.7474,30.2717,23.7474,930.4819,10.6353,1.4305,1.5867,31.3908,26.5673,8.6896,0.2670,2.6058,1.5873,0.6092,9.7583,5.9443,2.0000
 812.5000,1993.2513,0.0965,1.1570,1.0069,1.0099,1.0230,1.0604,1.1426,1.0069,0.2550,2.3054,-0.3809,-0.3601,3.0549,28.3115,23.4633,23.4633,21.4024,0.1646,20.8818,23.6579,30.1898,23.6579,993.1571,10.6371,1.4986,1.7015,30.7886,25.9162,8.2933,0.2510,2.5578,1.5334,0.5995,10.1918,6.1100,0.0000
 813.0000,2034.8608,0.1041,1.0600,0.9121,0.9158,0.9279,0.9630,1.0449,0.9121,0.2554,2.2951,-0.2930,-0.0213,3.1727,28.7748,23.9222,23.9222,21.8321,0.1632,21.5099,24.2639,30.7440,24.2639,1096.3687,10.6394,1.4688,1.5252,31.8530,26.0471,8.3498,0.2415,2.5555,1.5968,0.6249,10.5812,6.6118,2.0000
 813.5000,2043.6603,0.1136,1.0419,0.8837,0.8882,0.9003,0.9372,1.0262,0.8837,0.2542,2.2837,0.0627,0.5695,3.2235,30.0231,25.1641,25.1641,22.9929,0.1612,22.1973,24.9272,31.3506,24.9272,1131.5846,10.6221,1.2931,1.2965,34.3511,27.4502,8.8844,0.2505,2.6668,1.7296,0.6486,10.6445,6.9038,1.6000
 814.0000,2044.6848,0.1242,1.1040,0.9214,0.9272,0.9405,0.9833,1.0869,0.9214,0.2538,2.2875,0.0992,0.5577,3.2721,29.6307,24.7727,24.7727,22.6275,0.1585,21.9701,24.7080,31.1501,24.7080,1085.3047,10.5623,1.3309,1.3979,37.3212,29.4942,9.8687,0.2763,2.8096,1.9308,0.6872,10.1700,6.9890,4.8000
 814.5000,2070.4016,0.1344,1.2060,0.9908,0.9985,1.0132,1.0635,1.1824,0.9908,0.2552,2.2949,-0.4184,0.1128,3.2613,27.6164,22.7773,22.7773,20.7591,0.1465,21.5219,24.2755,30.7546,24.2755,1009.2426,10.4675,1.2847,1.4695,42.5093,32.1593,10.9888,0.3065,3.0216,2.1553,0.7133,9.8585,7.0322,1.6000
 815.0000,2049.1418,0.1370,1.2635,1.0339,1.0433,1.0580,1.1115,1.2341,1.0339,0.2546,2.2947,-0.5480,-0.1812,3.1232,26.8710,22.0445,22.0445,20.0708,0.1271,21.5350,24.2881,30.7661,24.2881,967.1904,10.3640,1.1594,1.4614,46.4233,32.7450,11.2974,0.3160,3.0493,2.2114,0.7252,9.6482,6.9972,2.0000
 815.5000,2083.8987,0.1251,1.1714,0.9763,0.9858,0.9973,1.0432,1.1464,0.9763,0.2544,2.2967,-0.1485,-0.4556,2.9428,27.0655,22.2355,22.2355,20.2502,0.1195,21.4131,24.1705,30.6586,24.1705,1024.2650,10.3263,1.3293,1.5782,42.5209,31.6154,10.8546,0.3007,2.9369,2.1389,0.7283,9.7680,7.1141,4.0000
 816.0000,2037.3834,0.1058,0.9898,0.8495,0.8578,0.8651,0.8985,0.9745,0.8495,0.2548,2.2961,0.1995,-0.4256,2.9583,27.0607,22.2308,22.2308,20.2458,0.1269,21.4487,24.2049,30.6901,24.2049,1177.2198,10.3324,1.3696,1.6028,37.4524,29.0683,9.9748,0.2777,2.6892,1.9588,0.7284,9.6832,7.0530,3.0000
 816.5000,2052.3777,0.0900,0.8439,0.7416,0.7490,0.7536,0.7779,0.8351,0.7416,0.2528,2.2883,0.3138,-0.0453,3.1167,28.5061,23.6559,23.6559,21.5828,0.1367,21.9225,24.6621,31.1081,24.6621,1348.4083,10.3498,1.2408,1.3619,36.6565,27.1568,9.1231,0.2550,2.5245,1.7868,0.7078,9.8992,7.0064,4.0000
 817.0000,2056.8809,0.0796,0.7557,0.6745,0.6815,0.6847,0.7035,0.7502,0.6745,0.2546,2.2767,0.3184,0.0795,3.1976,29.9931,25.1342,25.1342,22.9650,0.1415,22.6231,25.3380,31.7262,25.3380,1482.6545,10.3738,1.1909,1.2797,36.0008,26.8990,8.7714,0.2458,2.5453,1.7148,0.6737,10.3538,6.9755,6.0000
 817.5000,2055.5222,0.0726,0.6919,0.6239,0.6308,0.6331,0.6480,0.6881,0.6239,0.2540,2.2605,0.3724,-0.2068,3.2644,31.4542,26.5984,26.5984,24.3295,0.1405,23.6039,26.2844,32.5917,26.2845,1602.8380,10.4111,1.0740,1.1446,34.6072,26.2532,8.1407,0.2246,2.5491,1.6082,0.6309,11.3478,7.1592,3.2000
 818.0000,2031.0381,0.0688,0.6547,0.5937,0.6008,0.6025,0.6150,0.6516,0.5937,0.2548,2.2511,0.2332,-0.4075,3.2919,32.1108,27.2602,27.2602,24.9448,0.1403,24.1740,26.8346,33.0947,26.8346,1684.3146,10.4132,0.9774,0.9209,32.2054,26.1955,7.6817,0.2087,2.6075,1.5329,0.5879,12.4926,7.3444,4.0000
 818.5000,2014.1196,0.0672,0.6385,0.5803,0.5878,0.5892,0.6002,0.6354,0.5803,0.2541,2.2558,-0.1600,-0.1077,3.1692,31.9143,27.0618,27.0618,24.7605,0.1415,23.8898,26.5603,32.8439,26.5603,1723.2981,10.3797,0.9930,0.8486,31.7575,25.3057,7.1538,0.1914,2.5563,1.4419,0.5640,13.3578,7.5343,0.0000
 819.0000,2060.1289,0.0668,0.6333,0.5760,0.5839,0.5853,0.5957,0.6306,0.5760,0.2543,2.2631,-0.3978,0.4789,3.1371,32.7738,27.9308,27.9308,25.5675,0.1408,23.4476,26.1337,32.4538,26.1337,1736.1781,10.3453,1.0883,0.9988,32.3838,24.1865,6.7024,0.1792,2.4546,1.3512,0.5505,13.6947,7.5383,1.6000
 819.5000,2022.6188,0.0691,0.6413,0.5813,0.5897,0.5912,0.6022,0.6386,0.5813,0.2559,2.2743,-0.3344,0.3198,3.3346,31.7218,26.8678,26.8678,24.5801,0.1414,22.7676,25.4775,31.8537,25.4775,1720.3698,10.2928,1.0730,0.9727,28.8008,22.6705,6.4211,0.1725,2.2854,1.2909,0.5649,13.2521,7.4857,0.8000
 820.0000,2017.8052,0.0749,0.6501,0.5843,0.5930,0.5948,0.6074,0.6469,0.5843,0.2541,2.2874,-0.0827,-0.2941,3.5150,31.7719,26.9183,26.9183,24.6271,0.1416,21.9783,24.7159,31.1573,24.7159,1711.5762,10.2562,1.1518,1.0419,23.7073,21.2916,6.2566,0.1643,2.1239,1.2757,0.6007,12.9289,7.7658,0.8000
 820.5000,1963.4003,0.0834,0.6559,0.5821,0.5909,0.5932,0.6080,0.6521,0.5821,0.2539,2.2833,0.0936,-0.2744,3.5477,30.9471,26.0889,26.0889,23.8552,0.1326,22.2226,24.9516,31.3729,24.9516,1717.8900,10.2194,1.1538,0.9738,23.5770,20.6859,6.3830,0.1696,2.0398,1.2917,0.6333,12.0234,7.6142,1.6000
 821.0000,1914.5006,0.0994,0.7167,0.6211,0.6307,0.6340,0.6532,0.7083,0.6211,0.2543,2.2781,0.0107,-0.1865,3.4373,30.1809,25.3217,25.3217,23.1400,0.1165,22.5415,25.2593,31.6542,25.2593,1610.1395,10.1823,1.0392,0.9069,26.0136,21.2815,6.8640,0.1827,2.0710,1.3878,0.6701,11.3356,7.5961,2.0000
 821.5000,1893.6436,0.1238,0.8387,0.7004,0.7122,0.7175,0.7446,0.8189,0.7004,0.2544,2.2889,-0.0694,-0.2214,3.2266,29.8583,24.9996,24.9996,22.8394,0.0973,21.8863,24.6271,31.0761,24.6271,1427.7957,10.0352,1.1376,1.1651,27.7114,21.5897,7.1644,0.1915,2.0895,1.4446,0.6914,10.9103,7.5431,4.0000
 822.0000,1875.7703,0.1440,0.9216,0.7460,0.7587,0.7661,0.8007,0.8921,0.7460,0.2535,2.2941,-0.0418,0.0445,3.1850,28.7493,23.8969,23.8969,21.8084,0.0792,21.5710,24.3229,30.7980,24.3229,1340.5381,9.8785,1.3916,1.6038,29.2175,22.1731,7.5668,0.1982,2.1270,1.5451,0.7264,10.7319,7.7958,2.0000
 822.5000,1925.1771,0.1501,0.9105,0.7300,0.7415,0.7501,0.7870,0.8817,0.7300,0.2545,2.2835,0.0540,0.2402,3.4169,29.1854,24.3297,24.3297,22.2134,0.0731,22.2120,24.9413,31.3635,24.9414,1369.8538,9.8528,1.3263,1.4640,29.3656,22.2796,7.9674,0.2035,2.0980,1.6516,0.7872,10.3095,8.1157,0.0000
 823.0000,1906.9923,0.1627,0.9534,0.7494,0.7607,0.7715,0.8136,0.9183,0.7494,0.2551,2.2776,0.2589,0.0950,3.5792,29.6534,24.7954,24.7954,22.6486,0.0749,22.5722,25.2890,31.6814,25.2890,1334.3271,9.8131,1.2947,1.3211,28.7250,21.7381,7.9153,0.2074,2.0307,1.6161,0.7958,9.7927,7.7932,0.0000
 823.5000,1986.0533,0.1936,1.1202,0.8383,0.8516,0.8674,0.9226,1.0561,0.8383,0.2543,2.2945,0.3994,-0.2262,3.5071,28.0599,23.2147,23.2147,21.1694,0.0779,21.5433,24.2961,30.7735,24.2961,1192.9363,9.7208,1.2870,1.4984,28.7874,21.4550,8.0303,0.2126,1.9771,1.6290,0.8240,9.2990,7.6619,3.0000
 824.0000,2009.5826,0.2318,1.3292,0.9346,0.9505,0.9730,1.0448,1.2119,0.9346,0.2546,2.3183,0.2979,-0.4105,3.3899,27.6123,22.7733,22.7733,20.7553,0.0805,20.1044,22.9077,29.5039,22.9077,1070.0114,9.6237,1.6250,1.9884,27.1413,20.9948,7.7492,0.2011,1.9525,1.5915,0.8151,9.7116,7.9160,2.4000
 824.5000,2011.7128,0.2499,1.3969,0.9530,0.9694,0.9960,1.0746,1.2522,0.9530,0.2538,2.3266,-0.0965,-0.1660,3.2999,27.5522,22.7141,22.7141,20.6997,0.0799,19.6024,22.4234,29.0610,22.4234,1049.3671,9.5884,1.8173,1.9987,25.0268,20.3286,7.1398,0.1806,1.9395,1.4883,0.7673,10.7383,8.2399,0.0000
 825.0000,1989.4049,0.2586,1.3900,0.9346,0.9509,0.9798,1.0604,1.2401,0.9346,0.2541,2.3217,-0.5027,0.5176,3.2445,26.4792,21.6607,21.6607,19.7097,0.0782,19.8978,22.7084,29.3216,22.7084,1069.9683,9.5824,1.4666,1.6947,25.9511,20.2489,6.9037,0.1705,1.9697,1.4586,0.7405,11.5506,8.5538,0.0000
 825.5000,1975.6085,0.2718,1.4064,0.9247,0.9418,0.9735,1.0587,1.2474,0.9247,0.2552,2.3075,-0.5855,0.5914,3.2141,25.6695,20.8699,20.8699,18.9649,0.0726,20.7558,23.5363,30.0786,23.5363,1081.4391,9.5223,1.4001,1.6657,26.6649,19.8802,6.5783,0.1660,1.9647,1.3732,0.6989,11.8355,8.2721,0.0000
 826.0000,2001.5896,0.2988,1.4950,0.9387,0.9581,0.9946,1.0902,1.3004,0.9387,0.2552,2.2938,-0.3173,-0.0189,3.1857,26.3982,21.5814,21.5814,19.6351,0.0627,21.5901,24.3413,30.8148,24.3413,1065.3585,9.4875,1.3579,1.6351,24.1114,19.4256,6.4745,0.1638,1.9230,1.3496,0.7018,11.7404,8.2395,1.6000
 826.5000,2005.4821,0.3534,1.6915,0.9654,0.9884,1.0313,1.1421,1.3842,0.9654,0.2546,2.2984,0.1598,-0.2726,3.2325,26.5268,21.7072,21.7072,19.7535,0.0519,21.3091,24.0702,30.5669,24.0702,1035.8885,9.4083,1.7457,1.9372,21.8489,19.1009,6.4488,0.1570,1.8785,1.3733,0.7311,11.9642,8.7467,0.8000
 827.0000,2004.0538,0.4118,1.9049,0.9784,1.0053,1.0539,1.1787,1.4486,0.9784,0.2550,2.3130,0.4609,-0.2192,3.2696,24.8691,20.0919,20.0919,18.2307,0.0397,20.4260,23.2181,29.7877,23.2181,1022.0416,9.3729,1.9498,2.2677,22.1611,18.7409,6.3761,0.1518,1.8245,1.3742,0.7532,12.0202,9.0534,0.8000
 827.5000,1997.6274,0.4650,2.1087,0.9817,1.0123,1.0660,1.2034,1.4982,0.9817,0.2539,2.3242,0.3946,-0.1944,3.2141,24.3507,19.5898,19.5898,17.7562,0.0335,19.7449,22.5609,29.1867,22.5609,1018.6437,9.3706,2.0188,2.4119,24.5343,19.4582,6.5430,0.1570,1.8824,1.4044,0.7461,11.9917,8.9466,0.0000
 828.0000,1990.4070,0.5089,2.2787,0.9763,1.0103,1.0682,1.2159,1.5321,0.9763,0.2533,2.3428,0.2405,0.0221,3.1753,24.3998,19.6373,19.6373,17.8011,0.0358,18.6154,21.4710,28.1900,21.4710,1024.2551,9.3391,2.1662,2.4507,25.7174,20.2616,6.7856,0.1667,1.9468,1.4378,0.7385,11.6756,8.6230,0.0000
 828.5000,2012.3696,0.5314,2.3389,0.9599,0.9963,1.0565,1.2101,1.5396,0.9599,0.2540,2.3550,0.1470,0.4039,3.2021,23.5530,18.8203,18.8203,17.0277,0.0364,17.8794,20.7608,27.5406,20.7608,1041.8230,9.3170,2.6772,2.6391,26.7158,21.3915,7.2150,0.1805,2.0471,1.5134,0.7393,11.3397,8.3837,0.0000
 829.0000,1998.2954,0.4931,2.0769,0.9170,0.9531,1.0114,1.1597,1.4759,0.9170,0.2531,2.3344,-0.0924,0.0019,3.2124,24.8866,20.1089,20.1089,18.2468,0.0330,19.1253,21.9630,28.6400,21.9630,1090.4662,9.2802,2.5745,2.5058,28.4582,21.6123,7.3917,0.1906,2.0677,1.5238,0.7369,10.8495,7.9954,1.0000
 829.5000,2011.6892,0.4955,2.0213,0.8883,0.9243,0.9815,1.1265,1.4335,0.8883,0.2546,2.3081,-0.3707,-0.2473,3.2368,26.3133,21.4983,21.4983,19.5569,0.0327,20.7230,23.5046,30.0497,23.5046,1125.7107,9.2835,2.4296,2.4687,28.5902,22.4447,7.8365,0.2045,2.1392,1.6039,0.7498,10.4618,7.8438,0.0000
 830.0000,1990.6488,0.5203,2.1236,0.8903,0.9278,0.9871,1.1366,1.4517,0.8903,0.2556,2.3023,-0.2120,0.2431,3.4253,26.4366,21.6190,21.6190,19.6705,0.0358,21.0756,23.8449,30.3609,23.8449,1123.2255,9.2844,2.4560,2.5777,27.8997,22.4715,7.7354,0.2103,2.1608,1.5432,0.7142,10.2759,7.3386,1.0000
 830.5000,2014.9608,0.5406,2.2455,0.9053,0.9444,1.0067,1.1624,1.4868,0.9053,0.2545,2.3025,0.2422,0.2569,3.5809,25.7551,20.9533,20.9533,19.0436,0.0361,21.0598,23.8296,30.3468,23.8296,1104.6403,9.2902,2.5635,2.5842,28.2584,22.1148,7.4470,0.2041,2.1405,1.4777,0.6904,10.4870,7.2398,1.0000
 831.0000,1977.0245,0.5577,2.4076,0.9391,0.9805,1.0472,1.2129,1.5537,0.9391,0.2545,2.3027,0.3115,-0.0821,3.5185,25.1218,20.3371,20.3371,18.4623,0.0369,21.0497,23.8199,30.3380,23.8199,1064.8652,9.2856,3.9496,3.0804,28.8392,21.3474,7.0848,0.1998,2.0735,1.3791,0.6651,10.3771,6.9020,1.0000
 831.5000,1980.3986,0.5731,2.6534,1.0043,1.0494,1.1243,1.3084,1.6852,1.0043,0.2537,2.3110,-0.0382,-0.0985,3.5137,24.5876,19.8191,19.8191,17.9729,0.0405,20.5432,23.3312,29.8911,23.3312,995.7083,9.3026,4.5039,3.0659,27.6775,20.7651,6.8233,0.1963,2.0171,1.3101,0.6495,10.2774,6.6749,2.0000
 832.0000,1981.4130,0.5786,2.9068,1.0884,1.1373,1.2218,1.4275,1.8486,1.0884,0.2540,2.3304,-0.1739,0.3482,3.5099,23.5230,18.7914,18.7914,17.0003,0.0408,19.3707,22.1998,28.8565,22.1998,918.7543,9.2866,3.7526,3.3279,26.8514,20.9033,6.8629,0.1986,2.0275,1.3119,0.6471,10.2078,6.6050,2.0000
 832.5000,1960.4525,0.5686,3.0505,1.1648,1.2147,1.3052,1.5235,1.9678,1.1648,0.2537,2.3420,0.0113,0.6177,3.2779,22.6567,17.9599,17.9599,16.2115,0.0373,18.6650,21.5189,28.2338,21.5189,858.4828,9.2553,4.3420,3.6023,27.9024,21.3116,6.9777,0.2067,2.0697,1.3113,0.6336,10.0134,6.3443,1.0000
 833.0000,1958.2065,0.5489,3.1556,1.2519,1.3010,1.3967,1.6244,2.0870,1.2519,0.2545,2.3419,0.2302,0.3198,3.2321,23.5061,18.7751,18.7751,16.9849,0.0364,18.6729,21.5265,28.2408,21.5265,798.7751,9.1525,5.2651,3.8252,30.3131,21.5413,7.0519,0.2084,2.0930,1.3277,0.6343,10.0443,6.3715,1.6000
 833.5000,1943.7871,0.5225,3.2403,1.3527,1.3992,1.4990,1.7325,2.2054,1.3527,0.2539,2.3519,0.2601,-0.1269,3.5041,23.5893,18.8552,18.8552,17.0608,0.0393,18.0689,20.9437,27.7078,20.9437,739.2440,9.1347,4.4868,3.6521,32.9709,23.5136,7.7024,0.2284,2.2920,1.4463,0.6310,10.0344,6.3321,1.6000
 834.0000,1959.9801,0.4849,3.3264,1.4917,1.5349,1.6407,1.8828,2.3707,1.4917,0.2535,2.3713,0.0294,-0.1216,3.6298,22.6112,17.9163,17.9163,16.1701,0.0343,16.8905,19.8066,26.6681,19.8066,670.3655,9.0807,4.0356,3.3689,36.7235,26.4518,8.6966,0.2537,2.5772,1.6528,0.6413,10.1578,6.5146,1.6000
 834.5000,1948.7401,0.4250,3.3603,1.6849,1.7235,1.8386,2.0941,2.6047,1.6849,0.2533,2.4000,-0.0489,-0.1405,3.4469,20.2517,15.6736,15.6736,14.0337,0.0227,15.1529,18.1300,25.1349,18.1300,593.5057,8.9906,6.1280,4.9918,39.1252,29.6004,9.8597,0.2846,2.8718,1.8883,0.6575,10.0900,6.6344,0.8000
 835.0000,1936.2101,0.3615,3.3405,1.8792,1.9086,2.0271,2.2807,2.7819,1.8792,0.2549,2.4386,0.0070,-0.5609,3.2064,18.3513,13.8904,13.8904,12.3258,0.0175,12.8105,15.8698,23.0681,15.8698,532.1437,8.9986,10.0390,6.5355,38.4374,31.4634,10.5272,0.3030,3.0439,2.0204,0.6638,10.0468,6.6688,0.0000
 835.5000,1947.3691,0.3129,3.3098,2.0281,2.0435,2.1544,2.3827,2.8305,2.0281,0.2545,2.4571,-0.0403,-0.1844,3.1656,17.9420,13.5090,13.5090,11.9594,0.0159,11.6916,14.7902,22.0809,14.7902,493.0771,9.0554,9.1216,6.0151,36.5111,29.8152,10.0939,0.2874,2.8660,1.9522,0.6812,9.9739,6.7939,0.8000
 836.0000,1948.7166,0.2403,3.2446,2.2492,2.2490,2.3558,2.5707,2.9910,2.2492,0.2545,2.4486,0.0671,0.6077,3.2195,17.5634,13.1571,13.1571,11.6210,0.0148,12.2049,15.2854,22.5337,15.2854,444.6111,8.9696,8.9949,6.0973,30.5879,26.5056,9.1615,0.2607,2.5252,1.7724,0.7019,9.6865,6.7989,1.6000
 836.5000,1954.9821,0.1701,3.2029,2.4885,2.4705,2.5701,2.7728,3.1607,2.4885,0.2562,2.4546,0.2238,0.5244,3.2827,15.9378,11.6555,11.6555,10.1732,0.0172,11.8404,14.9337,22.2121,14.9338,401.8435,8.9273,10.1256,8.3868,24.6601,23.6957,8.5103,0.2467,2.2125,1.6251,0.7345,8.9693,6.5881,1.6000
 837.0000,1911.7485,0.1720,3.4034,2.6361,2.6029,2.6857,2.8688,3.2057,2.6361,0.2554,2.4833,0.0504,0.1469,3.3713,14.7868,10.6016,10.6016,9.1532,0.0189,10.1061,13.2602,20.6818,13.2602,379.3424,8.9542,10.7547,7.4018,25.3114,22.0960,8.2496,0.2458,2.0233,1.5437,0.7630,8.2327,6.2813,1.6000
 837.5000,1924.5552,0.1552,3.3330,2.6509,2.6082,2.6688,2.8301,3.1200,2.6509,0.2534,2.4961,-0.2126,-0.0166,3.3451,14.7409,10.5597,10.5597,9.1126,0.0175,9.3301,12.5115,19.9971,12.5115,377.2286,8.9227,9.5098,7.7898,29.1648,22.9405,8.9557,0.2736,2.0504,1.6436,0.8016,7.4944,6.0076,0.8000
 838.0000,1946.2748,0.1317,3.1492,2.5979,2.5512,2.5925,2.7362,3.0121,2.5979,0.2548,2.4894,-0.2154,-0.3048,3.3174,15.4705,11.2267,11.2267,9.7586,0.0174,9.7332,12.9005,20.3528,12.9005,384.9193,8.9286,9.7380,8.4682,31.3275,24.7234,9.9087,0.3056,2.1766,1.8050,0.8292,7.1233,5.9069,1.6000
 838.5000,1952.4595,0.1153,2.9076,2.4597,2.4148,2.4408,2.5578,2.8370,2.4597,0.2534,2.4817,-0.1394,-0.4109,3.4442,15.7310,11.4656,11.4656,9.9896,0.0176,10.2017,13.3525,20.7662,13.3526,406.5530,8.9643,10.0099,6.7325,34.1798,26.3666,10.8112,0.3380,2.2946,1.9477,0.8488,6.7897,5.7632,1.6000
 839.0000,1948.7052,0.0941,2.6555,2.3193,2.2781,2.2941,2.3748,2.6304,2.3193,0.2552,2.4686,-0.0457,-0.1034,3.6859,16.8174,12.4661,12.4661,10.9555,0.0145,10.9964,14.1194,21.4674,14.1194,431.1707,9.0278,10.5668,6.3207,38.2821,27.9006,11.8401,0.3713,2.3775,2.1275,0.8949,6.4030,5.7297,3.2000
 839.5000,1951.9072,0.0394,2.3730,2.2453,2.2065,2.2166,2.2597,2.3652,2.2453,0.2544,2.4535,0.0350,0.0729,3.9999,18.4725,14.0035,14.0035,12.4344,0.0121,11.9075,14.9984,22.2713,14.9984,445.3769,9.0952,8.8140,5.2399,39.5740,27.3305,11.9409,0.3753,2.2846,2.1417,0.9374,6.0876,5.7067,4.0000
 840.0000,1966.6371,0.0007,2.2259,2.2238,2.1859,2.1921,2.2074,2.2183,2.2238,0.2548,2.4378,0.0179,0.1220,4.0254,18.2469,13.7930,13.7930,12.2323,0.0124,12.8594,15.9170,23.1112,15.9170,449.6828,9.1552,7.4190,4.8282,33.4687,25.0440,11.3573,0.3601,2.0367,2.0221,0.9928,5.6563,5.6158,0.0000
 840.5000,1969.9874,-0.0077,2.2625,2.2866,2.2469,2.2500,2.2528,2.2547,2.2866,0.2546,2.4244,-0.0047,0.0964,3.6117,16.9064,12.5484,12.5484,11.0349,0.0118,13.6734,16.7024,23.8295,16.7024,437.3318,9.1818,7.6064,4.9617,25.5613,22.8165,10.7476,0.3434,1.7980,1.9010,1.0572,5.2358,5.5354,0.8000
 841.0000,1969.7693,-0.0122,2.5084,2.5509,2.5015,2.5019,2.5022,2.5024,2.5509,0.2539,2.4451,-0.1164,0.0359,3.4133,15.2004,10.9794,10.9794,9.5192,0.0084,12.4203,15.4933,22.7238,15.4933,392.0162,9.1963,8.3362,5.1763,25.6995,24.7203,12.0641,0.3902,1.8850,2.1115,1.1202,4.8313,5.4118,0.8000
 841.5000,1964.6790,-0.0035,3.1464,3.1615,3.0882,3.0847,3.0987,3.1452,3.1615,0.2543,2.5122,-0.1447,-0.1451,3.7651,13.5576,9.4845,9.4845,8.0685,0.0063,8.3488,11.5646,19.1313,11.5646,316.3041,9.2127,10.8402,7.2870,36.9483,32.7256,16.4711,0.5386,2.4219,2.8549,1.1788,4.4967,5.3007,3.2000
 842.0000,1968.6176,-0.0123,4.1336,4.2036,4.0974,4.0867,4.1233,4.1382,4.2036,0.2545,2.5862,0.0230,-0.3031,4.1555,12.1256,8.1944,8.1944,6.8111,0.0093,3.8689,7.2419,15.1784,7.2419,237.8903,9.2413,9.6869,6.4060,56.3284,41.5104,21.4044,0.7080,2.9980,3.6716,1.2247,4.2345,5.1857,1.6000
 842.5000,1985.0288,-0.0540,4.8514,5.2167,5.0882,5.0761,5.0151,4.8592,5.2167,0.2541,2.6197,0.0447,0.2141,4.2373,12.2603,8.3153,8.3153,6.9291,0.0088,1.8375,5.2818,13.3860,5.2818,191.6922,9.2129,8.2419,5.4118,65.7821,46.4781,24.4169,0.8152,3.2995,4.1525,1.2585,4.0475,5.0939,2.4000
 843.0000,1974.1915,-0.0724,4.9049,5.4019,5.2668,5.2554,5.1666,4.9135,5.4019,0.2549,2.6163,-0.0544,0.5227,4.1450,13.1606,9.1257,9.1257,7.7193,0.0024,2.0427,5.4798,13.5671,5.4798,185.1216,9.2418,14.8385,8.5800,59.5840,49.1678,26.3794,0.8980,3.4156,4.4042,1.2895,3.8035,4.9045,0.0000
 843.5000,1992.4337,-0.0526,4.0885,4.3882,4.2800,4.2745,4.2451,4.0931,4.3882,0.2532,2.6015,-0.0725,0.2447,3.9496,15.2241,11.0010,11.0010,9.5402,0.0032,2.9375,6.3432,14.3566,6.3432,227.8856,9.2745,12.0838,6.2899,62.0510,51.9000,28.2788,0.9745,3.5495,4.6651,1.3143,3.6423,4.7871,1.6000
 844.0000,1962.0990,-0.0179,3.3958,3.4799,3.3976,3.3972,3.3971,3.3970,3.4799,0.2538,2.5833,0.0553,0.1170,3.7317,19.7022,15.1559,15.1559,13.5387,0.0096,4.0440,7.4109,15.3329,7.4109,287.3605,9.3344,4.6555,2.6360,76.1137,57.0136,31.6217,1.0998,3.8389,5.1688,1.3464,3.4905,4.6997,0.0000
 844.5000,1972.3717,-0.0312,2.9893,3.1189,3.0494,3.0519,3.0378,2.9892,3.1189,0.2539,2.5675,0.2860,0.1732,3.6466,22.4907,17.8010,17.8010,16.0605,0.0101,5.0014,8.3347,16.1777,8.3347,320.6255,9.4370,4.4734,2.4559,83.4751,61.9114,34.8402,1.2262,4.1307,5.6261,1.3620,3.3686,4.5881,0.0000
 845.0000,1959.5314,-0.0251,2.9127,3.0143,2.9517,2.9552,2.9231,2.9124,3.0143,0.2528,2.5585,0.2260,0.3182,3.6007,22.3444,17.6611,17.6611,15.9276,0.0072,5.5461,8.8602,16.6583,8.8602,331.7538,9.4698,4.0900,2.4070,84.6171,63.9411,36.5033,1.2927,4.2282,5.8570,1.3852,3.2708,4.5309,0.0000
 845.5000,1964.0334,-0.0263,2.9531,3.0609,3.0017,3.0043,2.9785,2.9530,3.0609,0.2528,2.5538,-0.2217,0.1631,3.4958,22.6636,17.9665,17.9665,16.2177,0.0058,5.8276,9.1318,16.9067,9.1319,326.6960,9.4574,4.4085,2.5289,82.4107,63.3216,36.6163,1.3147,4.1393,5.7896,1.3987,3.1484,4.4036,1.6000
 846.0000,1971.4967,-0.0134,3.1336,3.1918,3.1338,3.1341,3.1344,3.1345,3.1918,0.2545,2.5536,-0.4426,-0.2495,3.4177,23.2412,18.5205,18.5205,16.7435,0.0056,5.8438,9.1475,16.9210,9.1475,313.3003,9.5301,4.6654,2.7370,79.3354,62.7323,36.6764,1.3372,4.0381,5.7028,1.4122,3.0199,4.2648,2.4000
 846.5000,1973.7653,-0.0404,3.1412,3.3178,3.2605,3.2572,3.2251,3.1423,3.3178,0.2527,2.5562,-0.1380,-0.5425,3.4009,22.8926,18.1859,18.1859,16.4260,0.0061,5.6860,8.9952,16.7817,8.9952,301.4008,9.5608,4.3773,2.6093,79.0240,61.1212,35.9489,1.3251,3.8877,5.5212,1.4202,2.9339,4.1667,0.8000
 847.0000,1995.1284,-0.0458,3.1948,3.3986,3.3420,3.3344,3.2793,3.1967,3.3986,0.2547,2.5610,0.1315,-0.3820,3.4104,23.0887,18.3740,18.3740,16.6046,0.0076,5.3940,8.7135,16.5241,8.7135,294.2403,9.5843,4.0223,2.4911,80.4015,59.7727,35.0163,1.3047,3.8202,5.3117,1.3904,2.9281,4.0713,0.8000
 847.5000,1963.2158,-0.0474,3.1835,3.3934,3.3381,3.3265,3.2638,3.1851,3.3934,0.2542,2.5654,-0.0486,0.2591,3.4551,22.4075,17.7215,17.7215,15.9850,0.0095,5.1288,8.4576,16.2901,8.4576,294.6904,9.6368,4.3159,2.6165,81.4534,58.7461,34.2280,1.2765,3.7852,5.1867,1.3703,2.9654,4.0634,4.0000
 848.0000,1979.4313,-0.0473,3.1532,3.3609,3.3065,3.2914,3.2245,3.1545,3.3609,0.2540,2.5666,-0.1682,0.2736,3.5206,21.5323,16.8869,16.8869,15.1911,0.0101,5.0565,8.3879,16.2263,8.3879,297.5411,9.6569,4.4237,2.7295,78.7412,57.9397,33.5782,1.2541,3.7680,5.0794,1.3480,3.0046,4.0503,0.8000
 848.5000,1961.2352,-0.0464,3.1365,3.3392,3.2845,3.2664,3.1965,3.1375,3.3392,0.2538,2.5732,0.1271,-0.2355,3.5779,21.3483,16.7120,16.7120,15.0244,0.0102,4.6549,8.0003,15.8720,8.0004,299.4770,9.6739,5.1487,2.9430,75.3562,58.9811,34.5694,1.2871,3.7838,5.2482,1.3870,2.9397,4.0775,0.8000
 849.0000,1975.7582,-0.0441,3.1231,3.3149,3.2590,3.2386,3.1669,3.1239,3.3149,0.2538,2.5753,0.2651,0.0580,3.6178,21.8065,17.1480,17.1480,15.4396,0.0099,4.5253,7.8752,15.7576,7.8752,301.6660,9.6759,4.8580,2.7357,76.3287,60.5558,35.8136,1.3301,3.8268,5.4532,1.4250,2.8772,4.0999,2.4000
 849.5000,1993.7473,-0.0408,3.1052,3.2813,3.2232,3.2008,3.1288,3.1052,3.2813,0.2551,2.5650,0.0154,0.6451,3.5976,22.4784,17.7893,17.7893,16.0494,0.0086,5.1523,8.4803,16.3109,8.4803,304.7552,9.6871,4.8377,2.7354,79.1105,61.9498,36.8369,1.3747,3.8734,5.5774,1.4399,2.8176,4.0571,0.8000
 850.0000,1934.9888,-0.0383,3.1052,3.2706,3.2086,3.1841,3.1116,3.1051,3.2706,0.2547,2.5576,-0.1534,0.5749,3.5658,22.0757,17.4046,17.4046,15.6837,0.0066,5.6030,8.9151,16.7085,8.9152,305.7502,9.6635,4.8421,2.7626,80.4533,62.2319,37.0686,1.3983,3.8679,5.5419,1.4328,2.7663,3.9634,0.8000
 850.5000,1851.4008,-0.0387,3.1296,3.2980,3.2300,3.2028,3.1274,3.1306,3.2980,0.2548,2.5581,-0.0390,0.0480,3.5653,21.6979,17.0445,17.0445,15.3411,0.0047,5.5679,8.8813,16.6775,8.8813,303.2151,9.6560,4.6035,2.5754,79.1881,61.9760,36.9354,1.4098,3.8412,5.4433,1.4171,2.7246,3.8610,0.0000
 851.0000,1833.5151,-0.0433,3.1764,3.3679,3.2919,3.2612,3.1777,3.1792,3.3679,0.2551,2.5604,0.0563,-0.5095,3.5290,21.8236,17.1643,17.1643,15.4551,0.0034,5.4295,8.7477,16.5554,8.7477,296.9204,9.6964,4.6507,2.6460,78.6511,62.6119,37.8041,1.4551,3.8235,5.5139,1.4421,2.6277,3.7895,0.8000
 851.5000,1915.4915,-0.0541,3.2199,3.4629,3.3772,3.3423,3.2439,3.2255,3.4629,0.2538,2.5569,-0.0942,-0.4393,3.4676,21.7009,17.0474,17.0474,15.3438,-0.0002,5.6418,8.9526,16.7428,8.9527,288.7772,9.7266,4.6776,2.7455,82.1038,62.0249,38.1165,1.4706,3.7058,5.5428,1.4957,2.5199,3.7690,0.8000
 852.0000,1939.0894,-0.0762,3.4206,3.7854,3.6837,3.6417,3.5129,3.4401,3.7854,0.2543,2.5543,-0.2355,0.0415,3.4658,20.3219,15.7399,15.7399,14.0971,-0.0043,5.7990,9.1042,16.8814,9.1043,264.1703,9.7602,5.1419,3.0542,79.9590,59.4155,37.0672,1.4299,3.4872,5.3911,1.5460,2.4387,3.7702,0.0000
 852.5000,1952.3784,-0.1112,3.8911,4.5000,4.3709,4.3169,4.1345,3.9440,4.5000,0.2534,2.5708,-0.0563,0.1916,3.6187,17.3721,12.9796,12.9796,11.4502,-0.0032,4.8006,8.1409,16.0005,8.1409,222.2220,9.7255,6.2861,4.0034,71.3030,53.5303,33.9139,1.3128,3.0715,4.9108,1.5989,2.3395,3.7406,0.0000
 853.0000,1963.1472,-0.1451,4.5406,5.4712,5.3076,5.2388,4.9900,4.6372,5.4712,0.2543,2.5971,0.1937,0.2958,3.8350,15.3390,11.1062,11.1062,9.6420,-0.0048,3.2078,6.6040,14.5951,6.6040,182.7752,9.7215,13.4786,6.9935,62.1161,49.0306,31.5163,1.2224,2.7568,4.5524,1.6513,2.2552,3.7241,1.6000
 853.5000,1965.8993,-0.1529,4.4527,5.4149,5.2511,5.1829,4.9271,4.5374,5.4149,0.2552,2.5965,0.2085,0.3908,3.8317,14.4491,10.2938,10.2938,8.8547,-0.0129,3.2438,6.6388,14.6269,6.6388,184.6744,9.7113,14.4787,6.3494,58.6267,47.3355,30.8514,1.1971,2.6179,4.4543,1.7014,2.1870,3.7210,0.0000
 854.0000,1947.3005,-0.1401,3.7962,4.5467,4.4117,4.3570,4.1468,3.8474,4.5467,0.2548,2.5706,0.2438,0.0009,3.6738,16.7203,12.3764,12.3764,10.8691,-0.0144,4.8125,8.1524,16.0110,8.1524,219.9381,9.7601,5.4821,3.1112,64.2743,48.7362,32.1315,1.2527,2.6542,4.6109,1.7372,2.1189,3.6808,0.0000
 854.5000,1959.5651,-0.1250,3.4146,4.0161,3.9023,3.8570,3.6814,3.4521,4.0161,0.2539,2.5620,0.4419,-0.2199,3.6237,19.0280,14.5230,14.5230,12.9327,-0.0046,5.3339,8.6555,16.4711,8.6556,248.9988,9.7907,5.9147,3.0018,70.2029,51.1966,34.0964,1.3313,2.7524,4.8833,1.7742,2.0675,3.6681,1.6000
 855.0000,1972.9937,-0.1103,3.1801,3.6735,3.5764,3.5380,3.3898,3.2105,3.6735,0.2536,2.5668,0.4869,-0.0334,3.6136,20.2869,15.7069,15.7069,14.0655,0.0045,5.0422,8.3740,16.2137,8.3740,272.2235,9.8524,6.2116,2.9436,71.9953,52.9117,35.8024,1.3926,2.7854,5.1526,1.8498,2.0001,3.6998,0.0000
 855.5000,1987.3209,-0.0935,2.9040,3.2851,3.2057,3.1735,3.0548,2.9255,3.2851,0.2548,2.5610,0.1336,-0.1132,3.5574,21.2675,16.6352,16.6352,14.9513,0.0082,5.3942,8.7137,16.5243,8.7137,304.4025,9.9189,4.8831,2.6436,73.9849,54.8277,37.7484,1.4643,2.8196,5.4520,1.9336,1.9256,3.7234,0.8000
 856.0000,1988.8865,-0.0773,2.6602,2.9482,2.8837,2.8558,2.7638,2.6746,2.9482,0.2551,2.5551,-0.1929,-0.3532,3.5218,22.7223,18.0227,18.0227,16.2711,0.0129,5.7540,9.0609,16.8418,9.0609,339.1942,9.9952,4.7883,2.6408,77.0139,58.1292,40.6168,1.5725,2.9422,5.8804,1.9987,1.8710,3.7394,1.6000
 856.5000,1945.5730,-0.0641,2.4718,2.6931,2.6401,2.6146,2.5447,2.4811,2.6931,0.2539,2.5507,-0.1969,-0.4374,3.4670,24.1856,19.4303,19.4303,17.6052,0.0162,6.0190,9.3166,17.0756,9.3166,371.3185,10.0200,4.4351,2.3528,79.4478,61.3448,43.5323,1.6872,3.0458,6.2941,2.0665,1.8053,3.7305,0.0000
 857.0000,1957.5497,-0.0549,2.3323,2.5109,2.4663,2.4417,2.3891,2.3380,2.5109,0.2532,2.5425,-0.2253,-0.2101,3.3485,25.1038,20.3196,20.3196,18.4457,0.0147,6.5164,9.7965,17.5145,9.7966,398.2637,10.0277,3.9052,2.3739,79.2515,63.8839,46.0440,1.7839,3.0953,6.6602,2.1517,1.7351,3.7335,0.8000
 857.5000,2046.1019,-0.0489,2.2354,2.3877,2.3492,2.3245,2.2849,2.2390,2.3877,0.2535,2.5328,-0.1487,0.1100,3.2506,26.3002,21.4855,21.4855,19.5448,0.0131,7.1018,10.3614,18.0310,10.3614,418.8093,10.0500,4.4870,2.3966,80.9270,66.1013,48.4833,1.8763,3.1049,7.0230,2.2619,1.6548,3.7430,0.0000
 858.0000,2057.7793,-0.0442,2.1305,2.2617,2.2282,2.2034,2.1735,2.1326,2.2617,0.2543,2.5143,0.0838,0.1406,3.2499,26.8114,21.9861,21.9861,20.0158,0.0138,8.2222,11.4425,19.0196,11.4425,442.1484,10.0780,3.3118,1.7667,87.8852,67.8277,50.7979,1.9706,3.0582,7.3360,2.3988,1.5519,3.7227,0.8000
 858.5000,2092.8130,-0.0426,2.0223,2.1423,2.1129,2.0883,2.0639,2.0234,2.1423,0.2539,2.4976,-0.0555,-0.0180,3.3455,28.6699,23.8181,23.8181,21.7347,0.0155,9.2387,12.4233,19.9165,12.4233,466.7979,10.0976,2.3664,1.7209,93.2134,70.7519,53.8365,2.1073,3.0975,7.6855,2.4812,1.4699,3.6470,0.8000
 859.0000,2073.2808,-0.0453,2.0188,2.1462,2.1187,2.0935,2.0698,2.0199,2.1462,0.2544,2.5076,-0.3219,-0.1978,3.4666,29.3544,24.4977,24.4977,22.3704,0.0179,8.6285,11.8345,19.3781,11.8345,465.9444,10.1322,2.6473,1.7287,93.8406,71.4350,54.9609,2.1716,3.0716,7.7496,2.5230,1.4144,3.5685,1.0000
 859.5000,2088.6787,-0.0467,2.0390,2.1716,2.1455,2.1202,2.0968,2.0400,2.1716,0.2531,2.5259,-0.1036,0.0711,3.5338,29.5141,24.6567,24.6567,22.5190,0.0180,7.5196,10.7645,18.3996,10.7645,460.4949,10.1363,2.6538,1.9295,90.7411,71.4702,55.5859,2.2207,2.9996,7.7222,2.5744,1.3507,3.4774,1.0000
 860.0000,2098.3296,-0.0411,1.9510,2.0626,2.0395,2.0165,1.9975,1.9516,2.0626,0.2548,2.5198,0.0948,0.6796,3.5145,28.5593,23.7086,23.7086,21.6321,0.0165,7.8895,11.1214,18.7260,11.1214,484.8206,10.1303,3.2452,2.0080,88.6034,70.8251,55.7172,2.2440,2.8906,7.6545,2.6481,1.2881,3.4111,1.0000
 860.5000,2099.3889,-0.0286,1.8308,1.9036,1.8838,1.8642,1.8520,1.8312,1.9036,0.2534,2.4975,-0.1440,0.3963,3.3899,30.6706,25.8116,25.8116,23.5969,0.0158,9.2395,12.4241,19.9172,12.4241,525.3163,10.1581,2.4816,1.5323,90.2808,69.7176,55.8286,2.2533,2.7289,7.6470,2.8023,1.2110,3.3936,0.0000
 861.0000,2132.9368,-0.0142,1.7277,1.7616,1.7445,1.7284,1.7221,1.7279,1.7616,0.2540,2.4835,-0.3414,-0.5232,3.1843,31.8344,26.9813,26.9813,24.6856,0.0148,10.0884,13.2431,20.6662,13.2432,567.6505,10.1705,2.2630,1.6949,88.5276,66.2934,53.8557,2.1893,2.5073,7.3027,2.9125,1.1453,3.3356,1.0000
 861.5000,2049.9370,-0.0065,1.6117,1.6261,1.6114,1.5989,1.5940,1.6116,1.6261,0.2545,2.4836,-0.3358,-0.6102,2.9944,31.6851,26.8308,26.8308,24.5457,0.0136,10.0832,13.2382,20.6616,13.2382,614.9702,10.2016,2.0843,1.5283,78.8500,60.9144,49.9477,2.0524,2.2638,6.6688,2.9459,1.1030,3.2493,0.0000
 862.0000,2056.6963,-0.0106,1.6065,1.6301,1.6157,1.6041,1.5947,1.6064,1.6301,0.2538,2.4904,-0.1431,-0.2065,2.8996,30.8848,26.0263,26.0263,23.7969,0.0113,9.6697,12.8392,20.2968,12.8392,613.4702,10.1967,2.3034,1.5054,68.9672,58.0914,48.0081,2.0051,2.1272,6.2559,2.9409,1.0609,3.1200,0.8000
 862.5000,2077.5884,-0.0244,1.7193,1.7774,1.7620,1.7505,1.7301,1.7196,1.7774,0.2531,2.5070,0.1220,-0.0441,2.9059,28.8241,23.9710,23.9710,21.8778,0.0091,8.6638,11.8686,19.4093,11.8686,562.6278,10.2072,2.9450,1.8750,68.0581,59.3458,49.2503,2.0871,2.1594,6.2748,2.9059,1.0346,3.0064,1.6000
 863.0000,2090.9583,-0.0404,1.8210,1.9233,1.9074,1.8964,1.8634,1.8218,1.9233,0.2538,2.5235,0.0675,0.2171,2.9933,27.5400,22.7021,22.7021,20.6884,0.0055,7.6657,10.9055,18.5285,10.9055,519.9387,10.2134,3.4462,2.0620,73.5700,63.7697,53.2049,2.2801,2.2912,6.6582,2.9060,1.0049,2.9202,1.6000
 863.5000,2084.4746,-0.0501,1.8568,1.9865,1.9715,1.9619,1.9214,1.8579,1.9865,0.2537,2.5252,-0.1132,0.3275,3.1072,27.1654,22.3336,22.3336,20.3424,0.0005,7.5646,10.8079,18.4393,10.8079,503.4068,10.2187,3.1754,2.0616,81.0189,64.7252,54.2026,2.3466,2.2927,6.6701,2.9093,0.9770,2.8424,0.0000
 864.0000,2059.9331,-0.0487,1.8208,1.9443,1.9320,1.9247,1.8856,1.8217,1.9443,0.2539,2.5210,0.0511,0.1078,3.1974,28.3833,23.5344,23.5344,21.4690,-0.0001,7.8200,11.0544,18.6647,11.0544,514.3138,10.2103,3.1561,2.1263,82.4072,62.0642,52.0932,2.2738,2.1755,6.3227,2.9063,0.9568,2.7806,0.0000
 864.5000,2094.9780,-0.0386,1.7237,1.8161,1.8076,1.8031,1.7723,1.7242,1.8161,0.2542,2.5141,0.3045,-0.3370,3.2605,28.8698,24.0163,24.0163,21.9202,0.0001,8.2352,11.4550,19.0311,11.4550,550.6252,10.1985,2.6268,1.7958,76.5437,59.5208,50.1286,2.2129,2.0579,5.9663,2.8992,0.9299,2.6961,0.0000
 865.0000,2062.7427,-0.0251,1.6682,1.7263,1.7219,1.7196,1.6993,1.6686,1.7263,0.2548,2.5103,0.1458,-0.6244,3.3288,29.4410,24.5839,24.5839,22.4510,-0.0006,8.4669,11.6785,19.2355,11.6785,579.2705,10.1659,2.5855,1.9739,74.7129,60.3155,50.8805,2.2686,2.0501,5.9492,2.9019,0.9037,2.6224,1.0000
 865.5000,2073.1423,-0.0093,1.6392,1.6603,1.6599,1.6597,1.6555,1.6396,1.6603,0.2538,2.5046,-0.0262,-0.2517,3.4482,30.3166,25.4573,25.4573,23.2665,-0.0003,8.8135,12.0131,19.5414,12.0131,602.3013,10.1365,3.0940,1.9982,78.8821,64.3686,54.3745,2.4448,2.1430,6.2610,2.9216,0.8766,2.5610,2.0000
 866.0000,2060.2559,0.0074,1.5535,1.5377,1.5405,1.5416,1.5431,1.5536,1.5377,0.2533,2.4801,0.2119,0.3020,3.5951,32.2621,27.4130,27.4130,25.0868,-0.0011,10.3000,13.4473,20.8529,13.4474,650.3193,10.0738,2.5634,1.5210,87.1724,70.4206,59.5235,2.6873,2.2924,6.8018,2.9671,0.8531,2.5311,2.0000
 866.5000,2095.2896,0.0213,1.4461,1.4039,1.4088,1.4104,1.4215,1.4460,1.4039,0.2542,2.4389,0.1924,0.6969,3.6671,34.2752,29.4582,29.4582,26.9822,-0.0039,12.7961,15.8558,23.0553,15.8558,712.3148,10.0502,2.1592,1.3612,98.0464,75.5404,63.7475,2.8814,2.4387,7.2683,2.9804,0.8464,2.5225,4.0000
 867.0000,2095.4617,0.0295,1.4081,1.3511,1.3576,1.3595,1.3754,1.4081,1.3511,0.2536,2.4041,-0.1998,0.7397,3.6122,36.4912,31.7348,31.7348,29.0826,-0.0069,14.9012,17.8871,24.9128,17.8872,740.1127,10.0341,2.0901,1.2462,105.1884,78.9195,66.5234,3.0042,2.5461,7.5974,2.9840,0.8475,2.5290,3.0000
 867.5000,2089.7493,0.0334,1.4418,1.3759,1.3839,1.3858,1.4038,1.4418,1.3759,0.2535,2.4060,-0.2905,0.0612,3.5339,36.7827,32.0362,32.0362,29.3599,-0.0074,14.7869,17.7768,24.8120,17.7768,726.7906,9.9874,1.9278,1.2350,106.8478,81.0849,68.2666,3.0791,2.6365,7.8146,2.9641,0.8563,2.5380,1.0000
 868.0000,2069.2151,0.0357,1.5193,1.4452,1.4546,1.4564,1.4732,1.5193,1.4452,0.2541,2.4361,-0.0962,-0.6018,3.5022,33.9781,29.1550,29.1550,26.7017,-0.0065,12.9662,16.0200,23.2055,16.0200,691.9323,9.9452,2.6656,1.7438,105.6898,81.7842,68.6992,3.1040,2.6920,7.8384,2.9117,0.8673,2.5252,0.0000
 868.5000,2075.2388,0.0329,1.5257,1.4571,1.4664,1.4677,1.4764,1.5253,1.4571,0.2542,2.4578,0.0336,-0.6257,3.4528,33.3814,28.5475,28.5475,26.1392,-0.0047,11.6463,14.7464,22.0409,14.7464,686.2977,9.9421,2.9315,1.6893,105.3534,83.1971,69.8434,3.1544,2.7390,7.9750,2.9116,0.8683,2.5282,2.0000
 869.0000,2098.8018,0.0046,1.3887,1.3799,1.3872,1.3878,1.3884,1.3888,1.3799,0.2538,2.4534,0.0566,-0.1201,3.3819,35.0823,30.2844,30.2844,27.7455,-0.0010,11.9178,15.0084,22.2804,15.0084,724.6973,9.9542,2.1388,1.3234,105.6577,84.4873,70.7541,3.1877,2.7919,8.1165,2.9071,0.8759,2.5462,4.0000
 869.5000,2058.9885,0.0025,1.3577,1.3530,1.3579,1.3578,1.3577,1.3577,1.3530,0.2533,2.4404,0.1750,0.4266,3.3527,35.9984,31.2263,31.2263,28.6143,0.0032,12.7017,15.7648,22.9721,15.7648,739.0887,10.0038,1.7210,1.3138,102.6055,83.6851,69.1763,3.1140,2.8835,7.9479,2.7563,0.9260,2.5524,2.0000
 870.0000,2077.6682,0.0007,1.4325,1.4311,1.4327,1.4317,1.4321,1.4323,1.4311,0.2539,2.4473,0.3613,0.4922,3.3950,33.5672,28.7364,28.7364,26.3142,0.0081,12.2875,15.3651,22.6066,15.3651,698.7486,10.0017,2.1048,1.3253,98.8529,80.3221,65.1818,2.9146,2.9465,7.5817,2.5732,1.0109,2.6013,1.0000
 870.5000,2081.3538,0.0355,1.6634,1.5826,1.5783,1.5755,1.5927,1.6628,1.5826,0.2541,2.4715,0.3545,0.2498,3.4947,30.4384,25.5792,25.5792,23.3801,0.0127,10.8182,13.9474,21.3102,13.9474,631.8630,9.8798,2.2697,1.3169,93.9914,71.2570,56.0989,2.5142,2.8634,6.4982,2.2694,1.1389,2.5846,3.0000
 871.0000,2089.7146,0.0607,2.2160,2.0335,2.0145,2.0068,2.0538,2.2147,2.0334,0.2542,2.5094,0.1590,0.2501,3.7345,26.5504,21.7303,21.7303,19.7753,0.0182,8.5185,11.7283,19.2810,11.7283,491.7721,9.8348,2.7840,2.1784,78.5583,57.0668,43.2089,1.9299,2.5375,5.0364,1.9848,1.3149,2.6097,0.0000
 871.5000,2088.4717,0.0691,3.8881,3.5247,3.4448,3.4144,3.5313,3.8840,3.5244,0.2543,2.5525,-0.0480,0.4792,4.1239,19.4464,14.9154,14.9154,13.3086,0.0247,5.9112,9.2125,16.9805,9.2126,283.7086,9.7786,31.6709,26.5094,52.2163,40.1870,29.2796,1.3001,1.9393,3.4492,1.7786,1.4917,2.6531,1.0000
 872.0000,2062.7314,0.0552,5.8356,5.3983,5.2009,5.1258,5.2926,5.8280,5.3976,0.2528,2.5689,-0.0710,0.1097,4.3717,14.3346,10.1896,10.1896,8.7536,0.0238,4.9167,8.2529,16.1029,8.2529,185.2418,9.7608,25.8135,19.4861,28.7865,26.7359,18.7575,0.8231,1.3809,2.2561,1.6338,1.6777,2.7410,3.0000
 872.5000,2092.6396,0.0122,5.8145,5.7176,5.4915,5.4182,5.5008,5.8097,5.7167,0.2534,2.5673,-0.0703,-0.1739,4.3477,12.7552,8.7602,8.7602,7.3632,0.0126,5.0132,8.3460,16.1881,8.3461,174.8998,9.7757,16.4515,12.4469,20.6605,20.6499,14.2382,0.6135,1.0944,1.7661,1.6138,1.7838,2.8787,3.0000
 873.0000,2119.6003,-0.0353,5.4059,5.6718,5.4366,5.3608,5.3827,5.4046,5.6710,0.2525,2.5734,-0.1799,0.0626,4.2326,12.2335,8.2912,8.2912,6.9057,-0.0011,4.6437,7.9896,15.8621,7.9896,176.3098,9.7897,13.5634,9.4285,25.8485,21.4457,14.5466,0.6193,1.1642,1.8398,1.5803,1.8798,2.9706,2.0000
 873.5000,2080.5474,-0.0465,5.6439,6.0098,5.7378,5.6481,5.6202,5.6458,6.0090,0.2547,2.5842,-0.0616,-0.4491,4.2023,11.9444,8.0320,8.0320,6.6525,-0.0103,3.9905,7.3592,15.2857,7.3593,166.3938,9.7929,12.8435,8.3508,32.3954,25.0199,16.7422,0.7105,1.3807,2.1285,1.5415,1.9434,2.9959,1.0000
 874.0000,2106.1382,-0.0258,6.3611,6.5896,6.2647,6.1528,6.0689,6.3749,6.5887,0.2552,2.5913,0.0582,-0.9240,4.2982,11.3095,7.4646,7.4646,6.0975,-0.0115,3.5570,6.9409,14.9032,6.9409,151.7539,9.8014,13.1980,8.2154,34.4546,29.0280,19.2519,0.8102,1.6170,2.4798,1.5336,1.9959,3.0610,4.0000
 874.5000,2084.4060,-0.0425,6.9697,7.3826,7.0001,6.8591,6.7054,6.9926,7.3818,0.2542,2.5953,-0.1967,-0.4964,4.3584,10.6162,6.8476,6.8476,5.4929,-0.0104,3.3162,6.7086,14.6908,6.7087,135.4539,9.8077,11.7530,7.6290,40.3038,34.4134,22.6380,0.9389,1.9361,2.9810,1.5397,2.0620,3.1749,2.0000
 875.0000,2124.1958,-0.0681,7.5097,8.2243,7.7967,7.6392,7.4123,7.5395,8.2243,0.2528,2.6025,-0.4121,-0.1030,4.2724,10.4912,6.7367,6.7367,5.3842,-0.0119,2.8780,6.2858,14.3041,6.2858,121.5909,9.8376,11.6910,8.0940,51.8354,41.7344,27.1757,1.1065,2.3969,3.6764,1.5338,2.1661,3.3224,5.0000
 875.5000,2098.4329,-0.0920,8.0584,9.0983,8.6404,8.4600,8.1972,8.0963,9.0983,0.2527,2.6120,-0.2328,0.4680,4.1961,10.3778,6.6362,6.6362,5.2855,-0.0110,2.3017,5.7297,13.7956,5.7297,109.9107,9.8436,12.2223,8.4311,63.1662,48.3852,31.4745,1.2572,2.7943,4.3736,1.5652,2.2226,3.4788,0.0000
 876.0000,2114.9250,-0.1032,7.7521,8.8758,8.4717,8.3055,8.0455,7.7894,8.8758,0.2537,2.6218,0.2655,0.6144,4.2120,10.3483,6.6100,6.6100,5.2598,-0.0101,1.7107,5.1595,13.2742,5.1595,112.6659,9.8517,13.8326,9.5072,68.0376,53.6452,34.7676,1.3725,3.1313,4.9082,1.5674,2.2815,3.5761,5.0000
 876.5000,2100.3911,-0.0865,5.4779,6.1418,5.9031,5.7994,5.6616,5.4951,6.1418,0.2533,2.6203,0.5865,0.1274,4.1396,11.9650,8.0505,8.0505,6.6706,-0.0122,1.8021,5.2477,13.3548,5.2477,162.8194,9.8745,16.9324,11.2985,70.2868,58.8815,38.5935,1.5082,3.4010,5.5210,1.6234,2.2549,3.6606,7.0000
 877.0000,2097.7424,-0.0522,3.5252,3.7817,3.6652,3.6111,3.5643,3.5306,3.7817,0.2538,2.5922,0.2302,-0.0257,3.7925,16.3088,11.9969,11.9969,10.5029,-0.0090,3.5029,6.8887,14.8555,6.8887,264.4337,9.9041,14.9431,7.8810,79.1346,64.9288,42.8508,1.6671,3.7386,6.1654,1.6491,2.2425,3.6982,2.0000
 877.5000,2096.5671,-0.0181,2.5832,2.6479,2.5916,2.5642,2.5617,2.5846,2.6479,0.2537,2.5475,-0.2608,-0.4210,3.3130,22.6164,17.9213,17.9213,16.1748,-0.0022,6.2098,9.5007,17.2440,9.5007,377.6516,9.9724,5.1037,2.7332,92.8967,71.8698,47.8900,1.8731,4.1096,6.8436,1.6653,2.1940,3.6537,0.0000
 878.0000,2098.1338,0.0081,2.2278,2.2030,2.1784,2.1628,2.1800,2.2275,2.2030,0.2552,2.5157,-0.3530,-0.5560,3.0223,26.4602,21.6420,21.6420,19.6922,-0.0006,8.1393,11.3625,18.9464,11.3625,453.9352,10.0830,3.2380,1.8446,104.6986,76.2219,51.2251,2.0198,4.3201,7.2429,1.6765,2.1389,3.5859,2.0000
 878.5000,2103.4546,0.0245,2.1265,2.0552,2.0490,2.0402,2.0691,2.1255,2.0552,0.2546,2.5070,-0.1984,0.2035,2.9441,28.6994,23.8474,23.8474,21.7621,-0.0009,8.6672,11.8718,19.4122,11.8719,486.5758,10.1051,3.3512,1.8688,107.6874,77.4194,52.3001,2.0717,4.3574,7.3498,1.6868,2.1033,3.5478,0.0000
 879.0000,2086.6858,0.0350,2.0899,1.9899,1.9958,1.9915,2.0233,2.0884,1.9899,0.2528,2.5063,0.2534,0.4718,2.9591,28.6652,23.8135,23.8135,21.7304,0.0029,8.7081,11.9113,19.4483,11.9114,502.5400,10.0642,3.2440,1.7388,99.9664,77.3084,52.2657,2.0769,4.3521,7.3139,1.6805,2.0955,3.5216,3.0000
 879.5000,2087.5957,0.0056,1.9314,1.9164,1.9304,1.9299,1.9296,1.9294,1.9164,0.2531,2.5102,0.4722,-0.3357,3.0356,29.3151,24.4587,24.4587,22.3340,0.0067,8.4739,11.6854,19.2417,11.6854,521.8015,10.0534,3.0712,1.7418,94.0101,78.2840,52.9290,2.1049,4.4075,7.3987,1.6786,2.0939,3.5150,0.0000
 880.0000,2084.8896,0.0450,1.9650,1.8446,1.8636,1.8661,1.8856,1.9630,1.8446,0.2522,2.5168,0.0877,-0.5121,3.1139,29.6278,24.7699,24.7699,22.6248,0.0076,8.0757,11.3011,18.8903,11.3011,542.1277,10.0388,3.0003,1.6788,96.9508,79.5202,53.8840,2.1550,4.4400,7.4749,1.6835,2.0603,3.4686,1.0000
 880.5000,2036.2892,0.0519,1.9549,1.8167,1.8390,1.8434,1.8776,1.9529,1.8167,0.2524,2.5121,-0.1629,0.2641,3.1407,30.1790,25.3198,25.3198,23.1382,0.0069,8.3561,11.5717,19.1378,11.5717,550.4521,10.0268,2.7133,1.5275,100.9835,79.8010,54.2623,2.1810,4.4062,7.4755,1.6966,2.0202,3.4275,1.0000
 881.0000,2084.7625,0.0547,1.9845,1.8370,1.8615,1.8674,1.9077,1.9825,1.8370,0.2530,2.5040,-0.2821,0.2429,3.0920,30.2079,25.3487,25.3487,23.1652,0.0041,8.8492,12.0475,19.5729,12.0475,544.3751,10.0072,2.8136,1.6290,101.3885,79.4866,54.4578,2.2002,4.2905,7.4487,1.7361,1.9500,3.3854,6.0000
 881.5000,2074.3401,0.0544,2.0646,1.9120,1.9380,1.9452,1.9877,2.0626,1.9120,0.2523,2.5085,-0.3949,-0.1823,3.0106,29.2829,24.4266,24.4266,22.3040,0.0010,8.5769,11.7847,19.3325,11.7847,523.0170,9.9813,2.9386,1.6588,99.9084,79.4948,54.5988,2.2178,4.2556,7.4116,1.7416,1.9188,3.3419,3.0000
 882.0000,2103.6267,0.0505,2.1763,2.0268,2.0531,2.0611,2.1013,2.1742,2.0268,0.2539,2.5191,-0.0999,-0.1154,2.9969,29.2134,24.3575,24.3575,22.2394,-0.0009,7.9335,11.1639,18.7648,11.1639,493.3984,9.9327,3.2965,1.8225,98.8440,79.3780,54.4625,2.2250,4.2488,7.3328,1.7259,1.9096,3.2957,0.0000
 882.5000,2071.4038,0.0428,2.2961,2.1619,2.1863,2.1945,2.2260,2.2938,2.1619,0.2532,2.5278,0.1763,0.1415,3.0576,28.1729,23.3264,23.3264,21.2740,-0.0022,7.4091,10.6579,18.3021,10.6579,462.5608,9.8905,3.2410,1.7426,99.8450,79.4305,54.1564,2.2166,4.2974,7.2720,1.6922,1.9387,3.2807,3.0000
 883.0000,2072.4058,0.0310,2.4594,2.3550,2.3754,2.3828,2.3989,2.4574,2.3550,0.2537,2.5364,0.0325,0.3639,3.1530,25.9495,21.1430,21.1430,19.2223,-0.0021,6.8861,10.1533,17.8407,10.1533,424.6218,9.8796,3.4299,2.0243,101.8462,77.8402,52.5128,2.1456,4.2866,7.0691,1.6491,1.9979,3.2947,6.0000
 883.5000,1939.3424,0.0149,2.6797,2.6249,2.6379,2.6432,2.6356,2.6787,2.6249,0.2540,2.5544,-0.1377,0.0173,3.2725,24.2891,19.5303,19.5303,17.6999,0.0017,5.7930,9.0985,16.8762,9.0985,380.9611,9.8846,4.1406,2.4813,97.6039,74.7555,49.8722,2.0277,4.1923,6.7609,1.6127,2.0675,3.3342,0.8000
 884.0000,1964.8049,-0.0029,2.9496,2.9614,2.9611,2.9619,2.9560,2.9505,2.9614,0.2532,2.5788,-0.0109,-0.3025,3.4068,22.2754,17.5952,17.5952,15.8650,0.0047,4.3135,7.6709,15.5707,7.6709,337.6726,9.8613,4.7198,2.7546,89.0424,70.4182,46.3905,1.8690,4.0300,6.3704,1.5807,2.1563,3.4085,0.8000
 884.5000,2019.5090,-0.0234,3.2306,3.3352,3.3158,3.3095,3.2569,3.2340,3.3352,0.2551,2.5919,0.1616,-0.0727,3.5592,20.0334,15.4677,15.4677,13.8370,0.0043,3.5204,6.9057,14.8709,6.9057,299.8344,9.8476,5.5229,3.2193,85.5673,66.1178,42.7420,1.7202,3.9076,5.8778,1.5042,2.2716,3.4169,3.2000
 885.0000,2079.5801,-0.0435,3.5801,3.7968,3.7536,3.7374,3.6420,3.5872,3.7968,0.2535,2.5986,0.0946,0.0140,3.7084,18.3683,13.9062,13.9062,12.3410,0.0044,3.1169,6.5163,14.5149,6.5163,263.3795,9.8312,6.1392,3.7486,82.2154,63.3887,40.0477,1.6090,3.8741,5.5206,1.4250,2.4078,3.4311,2.4000
 885.5000,2087.4460,-0.0630,4.1660,4.5324,4.4575,4.4269,4.2817,4.1804,4.5324,0.2542,2.6046,-0.0152,-0.0115,3.8378,16.8595,12.5050,12.5050,10.9930,0.0032,2.7503,6.1625,14.1914,6.1625,220.6360,9.8537,7.4889,4.4950,78.1719,61.3821,37.8797,1.5374,3.8606,5.1481,1.3335,2.5111,3.3486,1.6000
 886.0000,2056.6040,-0.0780,4.7028,5.2162,5.1071,5.0595,4.8684,4.7272,5.2162,0.2534,2.6040,-0.0751,0.0955,3.9171,16.1433,11.8445,11.8445,10.3557,-0.0002,2.7853,6.1963,14.2223,6.1963,191.7096,9.8482,8.7901,5.4467,75.6881,59.3478,35.7509,1.4688,3.8291,4.7745,1.2469,2.6070,3.2507,2.4000
 886.5000,2081.1816,-0.0833,4.6575,5.2008,5.0738,5.0152,4.8151,4.6823,5.2008,0.2536,2.6032,-0.1617,0.0835,3.8710,16.1436,11.8447,11.8447,10.3560,-0.0019,2.8382,6.2473,14.2690,6.2474,192.2765,9.8496,8.6127,4.9937,72.2094,57.2499,33.7359,1.3958,3.7794,4.4590,1.1798,2.7077,3.1946,1.0000
 887.0000,2050.5005,-0.0806,4.3036,4.7893,4.6603,4.5977,4.4185,4.3215,4.7893,0.2522,2.5989,-0.1373,-0.2022,3.7428,17.0853,12.7138,12.7138,11.1943,-0.0026,3.0977,6.4978,14.4980,6.4978,208.7997,9.8377,6.9137,4.2410,71.5448,55.4117,31.9889,1.3267,3.7298,4.2126,1.1295,2.8113,3.1752,0.0000
 887.5000,2052.5732,-0.0755,4.0348,4.4610,4.3341,4.2689,4.1161,4.0476,4.4610,0.2538,2.5884,0.0593,-0.1933,3.6531,18.0429,13.6029,13.6029,12.0497,-0.0035,3.7307,7.1086,15.0565,7.1086,224.1644,9.8242,6.7918,4.1308,74.9137,56.3180,31.7827,1.3143,3.8701,4.2038,1.0862,2.9446,3.1984,3.0000
 888.0000,2063.7446,-0.0698,3.8709,4.2488,4.1251,4.0575,3.9298,3.8814,4.2488,0.2528,2.5855,0.1637,-0.0126,3.6417,18.4231,13.9574,13.9574,12.3901,-0.0008,3.9072,7.2789,15.2122,7.2789,235.3616,9.7996,6.4320,3.9209,78.5021,59.7468,33.0191,1.3610,4.1661,4.3886,1.0534,3.0611,3.2246,0.0000
 888.5000,2075.1353,-0.0632,3.7351,4.0649,3.9465,3.8777,3.7739,3.7436,4.0649,0.2535,2.5879,0.0146,-0.0744,3.6884,18.9120,14.4144,14.4144,12.8286,0.0050,3.7640,7.1407,15.0859,7.1407,246.0084,9.7799,6.6056,3.9267,80.0723,63.6924,34.7076,1.4216,4.4629,4.6558,1.0432,3.1394,3.2752,5.0000
 889.0000,2098.0415,-0.0567,3.6134,3.8993,3.7874,3.7183,3.6350,3.6196,3.8993,0.2533,2.5827,-0.0897,-0.1054,3.7042,20.4903,15.8990,15.8990,14.2490,0.0096,4.0797,7.4453,15.3644,7.4453,256.4567,9.7601,6.0406,3.4367,84.3816,66.3765,35.5336,1.4545,4.7079,4.7708,1.0134,3.2367,3.2800,1.0000
 889.5000,2065.2305,-0.0532,3.5638,3.8284,3.7211,3.6509,3.5796,3.5687,3.8284,0.2530,2.5756,0.1638,-0.2937,3.6570,21.8381,17.1780,17.1780,15.4682,0.0132,4.5088,7.8594,15.7431,7.8594,261.2091,9.7883,5.3747,3.0552,86.3087,66.7067,35.2896,1.4458,4.7617,4.7321,0.9938,3.2936,3.2731,1.0000
 890.0000,2080.3865,-0.0546,3.5921,3.8655,3.7598,3.6876,3.6190,3.5980,3.8655,0.2525,2.5767,0.5433,-0.2770,3.6650,21.5537,16.9073,16.9073,15.2104,0.0147,4.4410,7.7939,15.6832,7.7939,258.6973,9.7875,5.8676,3.2571,82.0333,64.8304,33.8855,1.3939,4.6843,4.5169,0.9643,3.3605,3.2404,0.0000
 890.5000,2048.5425,-0.0588,3.7109,4.0152,3.9076,3.8326,3.7587,3.7184,4.0152,0.2534,2.5770,0.3845,0.2472,3.7374,20.7354,16.1308,16.1308,14.4703,0.0124,4.4221,7.7757,15.6665,7.7757,249.0530,9.7961,6.2708,3.3723,78.3397,62.0337,31.9664,1.3062,4.5472,4.3029,0.9463,3.4813,3.2943,2.4000
 891.0000,2075.1118,-0.0632,3.8356,4.1740,4.0638,3.9878,3.9047,3.8441,4.1740,0.2541,2.5698,-0.2040,0.5365,3.7811,21.0522,16.4310,16.4310,14.7566,0.0088,4.8623,8.2005,16.0550,8.2005,239.5789,9.8161,6.1666,3.4014,76.1949,59.7074,30.3134,1.2176,4.4427,4.1802,0.9409,3.6488,3.4332,6.4000
 891.5000,2085.3733,-0.0678,3.9859,4.3636,4.2494,4.1742,4.0779,3.9959,4.3636,0.2529,2.5697,-0.4346,0.4726,3.7968,20.1948,15.6200,15.6200,13.9825,0.0050,4.8677,8.2057,16.0597,8.2057,229.1670,9.8263,6.3645,3.4759,71.6188,57.3792,28.6766,1.1211,4.3361,4.1004,0.9456,3.8678,3.6575,2.4000
 892.0000,2045.4564,-0.0706,4.1619,4.5730,4.4533,4.3813,4.2707,4.1741,4.5730,0.2528,2.5827,-0.2041,0.3658,3.8230,19.0628,14.5556,14.5556,12.9639,0.0019,4.0779,7.4435,15.3628,7.4435,218.6763,9.8422,6.9833,4.1067,66.8643,56.5774,27.5641,1.0474,4.3649,4.0844,0.9357,4.1672,3.8994,0.8000
 892.5000,2089.4614,-0.0676,4.1897,4.5854,4.4643,4.4011,4.2852,4.2022,4.5854,0.2538,2.5907,0.0299,0.0274,3.8345,18.5532,14.0788,14.0788,12.5067,0.0023,3.5917,6.9744,14.9338,6.9744,218.0846,9.8638,7.0482,4.3284,67.1766,57.6897,27.3798,1.0127,4.5375,4.1886,0.9231,4.4805,4.1359,0.8000
 893.0000,2093.8149,-0.0624,4.1048,4.4627,4.3425,4.2908,4.1759,4.1167,4.4627,0.2526,2.5887,0.1278,-0.5112,3.7906,18.9911,14.4884,14.4884,12.8996,0.0045,3.7155,7.0939,15.0431,7.0939,224.0796,9.8971,5.7427,3.4273,71.7446,58.2976,26.6310,0.9683,4.7183,4.1536,0.8803,4.8730,4.2897,4.8000
 893.5000,2104.2148,-0.0644,4.2581,4.6412,4.5120,4.4677,4.3427,4.2716,4.6412,0.2533,2.5954,0.0644,-0.7963,3.7951,19.1464,14.6339,14.6339,13.0390,0.0075,3.3084,6.7011,14.6839,6.7011,215.4594,9.9098,5.9737,3.7401,72.8366,58.2418,25.3733,0.9161,4.8738,3.9877,0.8182,5.3200,4.3527,3.2000
 894.0000,2075.7112,-0.0740,4.7329,5.2229,5.0702,5.0278,4.8800,4.7501,5.2229,0.2535,2.6117,-0.1156,-0.5724,3.9396,17.9042,13.4738,13.4738,11.9256,0.0109,2.3186,5.7460,13.8105,5.7460,191.4657,9.9328,7.9195,5.8273,69.5712,57.3833,24.1527,0.8705,4.9160,3.8033,0.7737,5.6472,4.3690,0.8000
 894.5000,2065.8872,-0.0819,5.2657,5.8700,5.6882,5.6451,5.4789,5.2884,5.8700,0.2535,2.6164,-0.0574,0.1312,4.0517,15.4831,11.2382,11.2382,9.7697,0.0101,2.0394,5.4766,13.5642,5.4766,170.3583,9.9349,10.7123,8.0860,67.5611,56.8293,23.1732,0.8325,4.9741,3.6618,0.7362,5.9748,4.3985,0.8000
 895.0000,2079.6499,-0.0822,5.5328,6.1700,5.9667,5.9205,5.7533,5.5636,6.1700,0.2530,2.6109,0.0754,0.6247,4.0462,14.2510,10.1136,10.1136,8.6798,0.0051,2.3712,5.7968,13.8570,5.7968,162.0734,9.9484,8.9652,6.4802,71.3315,57.7978,23.7119,0.8358,5.0364,3.8234,0.7591,6.0262,4.5747,0.8000
 895.5000,2081.6416,-0.0802,5.8548,6.5126,6.2847,6.2282,6.0607,5.9071,6.5126,0.2531,2.6102,-0.2647,0.2869,4.1167,14.1063,9.9821,9.9821,8.5521,0.0012,2.4101,5.8343,13.8913,5.8343,153.5485,9.9995,9.8677,7.1762,75.2920,58.5377,24.6339,0.8457,5.0198,4.0789,0.8125,5.9354,4.8228,0.8000
 896.0000,2087.7114,-0.0765,6.1978,6.8617,6.6086,6.5344,6.3544,6.2437,6.8617,0.2540,2.6050,-0.7067,0.0640,4.2426,13.4559,9.3925,9.3925,7.9790,-0.0028,2.7290,6.1420,14.1726,6.1420,145.7366,9.9757,12.0584,9.5802,75.9058,59.1390,25.6379,0.8584,4.9809,4.3485,0.8730,5.8023,5.0657,4.0000
 896.5000,2057.0190,-0.0804,6.7211,7.4775,7.1909,7.0877,6.8543,6.7505,7.4775,0.2541,2.5912,-0.3608,0.0169,4.2920,13.3293,9.2781,9.2781,7.8676,-0.0073,3.5631,6.9468,14.9086,6.9469,133.7349,9.9697,15.7964,13.7016,77.7044,59.7554,26.7812,0.8849,4.9299,4.5986,0.9328,5.5713,5.1969,2.4000
 897.0000,2077.8525,-0.1058,7.1847,8.2529,7.9327,7.7941,7.4590,7.2712,8.2529,0.2550,2.5823,0.3554,-0.2665,4.3313,13.2554,9.2113,9.2113,7.8026,-0.0038,4.1007,7.4656,15.3830,7.4656,121.1702,9.9515,16.3038,14.8157,77.5760,60.5730,27.9445,0.9109,4.9124,4.8573,0.9888,5.3931,5.3326,0.0000
 897.5000,2062.5132,-0.1487,6.5852,7.9688,7.6656,7.5107,7.1052,6.7178,7.9688,0.2546,2.5798,0.4210,-0.4095,4.3950,12.6914,8.7027,8.7027,7.3071,0.0061,4.2516,7.6112,15.5161,7.6112,125.4887,9.9758,13.8923,14.0092,76.7605,61.2885,29.2362,0.9565,4.8638,5.0650,1.0414,5.0849,5.2951,2.4000
 898.0000,2065.3574,-0.1960,4.7874,6.1183,5.8987,5.7692,5.4033,4.8973,6.1183,0.2545,2.5800,-0.0087,-0.5007,4.4314,13.5712,9.4969,9.4969,8.0805,0.0126,4.2422,7.6021,15.5078,7.6021,163.4437,9.9605,12.3081,12.3081,78.4467,62.4663,31.0177,1.0067,4.8050,5.4123,1.1264,4.7733,5.3766,1.6000
 898.5000,2070.5400,-0.2179,3.5441,4.6403,4.4905,4.3905,4.0980,3.6258,4.6403,0.2542,2.5334,-0.3884,-0.6116,4.2716,17.8993,13.4693,13.4693,11.9212,0.0175,7.0649,10.3258,17.9984,10.3258,215.5016,9.8721,8.7039,7.6681,79.0249,62.6021,32.1231,1.0437,4.7015,5.5997,1.1911,4.5047,5.3654,0.8000
 899.0000,2051.9863,-0.1951,2.5339,3.2348,3.1467,3.0804,2.8867,2.5887,3.2348,0.2546,2.3267,-0.5576,-0.4191,3.7450,25.9970,21.1893,21.1893,19.2659,0.0442,19.5967,22.4179,29.0559,22.4179,309.1338,9.8304,4.4322,3.2926,80.6701,61.8125,32.8007,1.0684,4.5160,5.7049,1.2633,4.2268,5.3395,0.0000
 899.5000,2070.4016,-0.1553,1.6562,2.0198,1.9754,1.9376,1.8281,1.6856,2.0198,0.2556,2.0769,-0.4404,0.1653,3.2522,35.9728,31.1998,31.1998,28.5899,0.1206,34.7321,37.0222,42.4107,37.0222,495.0962,10.0037,0.7768,0.6345,81.8406,60.2670,32.7322,1.0624,4.3201,5.7110,1.3219,4.0663,5.3755,3.2000
 900.0000,2060.2896,-0.1319,1.4878,1.7645,1.7350,1.7057,1.6176,1.5102,1.7645,0.2560,2.0733,-0.3500,0.2560,3.3085,41.1269,36.5815,36.5815,33.5229,0.2064,34.9485,37.2310,42.6016,37.2310,566.7306,10.8490,0.5249,0.7327,76.9853,59.6470,33.3387,1.0789,4.1651,5.8318,1.4002,3.8604,5.4052,0.0000
 900.5000,2112.8748,-0.1290,1.6033,1.8948,1.8721,1.8445,1.7538,1.6266,1.8948,0.2544,2.2354,-0.4485,-0.0120,3.5218,43.6498,39.2665,39.2665,35.9656,0.2200,25.1256,27.7527,33.9343,27.7527,527.7496,11.5571,0.8280,0.8574,73.1257,59.9364,34.8507,1.1199,4.0144,6.1341,1.5280,3.5846,5.4773,0.8000
 901.0000,2104.3184,-0.1306,1.6514,1.9554,1.9396,1.9148,1.8247,1.6745,1.9554,0.2540,2.2937,-0.3108,0.0936,3.3668,42.5083,38.0476,38.0476,34.8581,0.1637,21.5925,24.3437,30.8169,24.3437,511.3970,11.4929,0.8160,0.9138,75.9004,60.5978,36.8449,1.1912,3.8580,6.4507,1.6721,3.2387,5.4153,1.6000
 901.5000,2104.8831,-0.1250,1.5836,1.8626,1.8531,1.8328,1.7524,1.6017,1.8626,0.2544,2.2294,0.0793,0.0251,3.0986,41.1844,36.6423,36.6423,33.5783,0.1132,25.4912,28.1055,34.2569,28.1055,536.8756,12.0753,0.9295,0.8763,77.1299,61.7166,39.3438,1.2956,3.7019,6.7765,1.8305,2.8574,5.2305,1.6000
 902.0000,2093.3662,-0.1185,1.5384,1.7951,1.7894,1.7725,1.7024,1.5611,1.7951,0.2550,2.1549,0.2370,-0.2602,2.9914,43.6874,39.3068,39.3068,36.0021,0.1016,30.0076,32.4635,38.2420,32.4635,557.0792,12.4390,0.7345,0.7925,76.1779,61.3968,40.6437,1.3795,3.4817,6.8053,1.9546,2.5239,4.9332,2.4000
 902.5000,2096.6133,-0.1035,1.5631,1.7904,1.7867,1.7718,1.7107,1.5830,1.7904,0.2553,2.1200,0.1715,-0.0671,2.8951,44.1165,39.7669,39.7669,36.4195,0.0974,32.1202,34.5019,40.1061,34.5019,558.5457,12.3704,0.7063,0.7960,75.0573,60.7809,41.8371,1.4570,3.2328,6.8296,2.1126,2.2188,4.6875,3.2000
 903.0000,2086.2832,-0.0803,1.6682,1.8557,1.8523,1.8381,1.7866,1.6804,1.8557,0.2551,2.1069,0.3152,0.1617,2.8344,42.3525,37.8817,37.8817,34.7072,0.1031,32.9145,35.2684,40.8069,35.2684,538.8924,12.1296,0.9931,0.8389,72.9749,60.0607,42.7489,1.5157,2.9988,6.8507,2.2845,1.9786,4.5199,1.6000
 903.5000,2056.5815,-0.0532,1.7510,1.8807,1.8766,1.8623,1.8242,1.7562,1.8807,0.2562,2.1206,0.5766,0.3832,2.8707,39.3159,34.6746,34.6746,31.7808,0.1280,32.0823,34.4654,40.0726,34.4654,531.7034,12.0962,0.7787,0.8742,72.7474,61.1850,45.2459,1.6172,2.8341,7.1889,2.5366,1.7524,4.4452,1.0000
 904.0000,2107.4507,-0.0360,1.7126,1.7981,1.7924,1.7779,1.7513,1.7189,1.7981,0.2546,2.2167,0.5801,0.6288,2.8931,37.0731,32.3369,32.3369,29.6365,0.1195,26.2589,28.8463,34.9343,28.8463,556.1367,11.8434,0.6451,0.9297,74.1375,62.4982,47.6630,1.7025,2.7181,7.5783,2.7881,1.5965,4.4512,3.0000
 904.5000,2090.3489,-0.0309,1.7656,1.8412,1.8329,1.8163,1.7914,1.7674,1.8412,0.2549,2.3696,0.2395,0.1555,2.9159,34.4783,29.6658,29.6658,27.1741,0.0686,16.9955,19.9079,26.7607,19.9079,543.1257,10.9200,1.2530,1.2219,75.7381,62.5242,48.8979,1.7478,2.5586,7.7691,3.0364,1.4639,4.4451,0.0000
 905.0000,2101.0815,-0.0375,1.8289,1.9242,1.9126,1.8934,1.8639,1.8301,1.9242,0.2545,2.4638,-0.1385,-0.2889,2.9158,32.1953,27.3455,27.3455,25.0240,0.0307,11.2825,14.3954,21.7199,14.3954,519.6977,10.2703,1.5894,1.3636,76.8890,62.8425,50.1307,1.7959,2.4364,7.9456,3.2612,1.3566,4.4242,4.0000
 905.5000,2102.7754,-0.0459,1.8572,1.9760,1.9615,1.9402,1.9056,1.8589,1.9760,0.2550,2.4744,-0.2078,-0.2198,2.8916,30.6311,25.7720,25.7720,23.5600,0.0361,10.6411,13.7765,21.1539,13.7765,506.0844,10.1424,2.3102,1.6617,79.3559,63.9895,51.1712,1.8448,2.4513,8.0555,3.2863,1.3287,4.3666,3.0000
 906.0000,2078.5442,-0.0501,1.7965,1.9219,1.9062,1.8850,1.8504,1.7973,1.9219,0.2557,2.4540,-0.2011,-0.1404,2.9053,31.9503,27.0982,27.0982,24.7943,0.0647,11.8810,14.9728,22.2479,14.9729,520.3162,10.1448,1.8477,1.2713,84.9383,65.8455,52.2532,1.8975,2.5703,8.1610,3.1752,1.3546,4.3010,5.0000
 906.5000,2053.8521,-0.0484,1.7200,1.8360,1.8201,1.8007,1.7721,1.7204,1.8360,0.2548,2.4069,-0.4083,-0.1369,2.9148,33.8019,28.9754,28.9754,26.5355,0.0770,14.7359,17.7277,24.7670,17.7277,544.6712,10.3498,0.8091,0.9764,87.1331,69.0237,53.5360,1.9630,2.8627,8.2715,2.8894,1.4583,4.2137,1.6000
 907.0000,1983.8198,-0.0358,1.6199,1.7005,1.6856,1.6695,1.6541,1.6201,1.7005,0.2542,2.3279,-0.4565,0.1309,2.9069,34.9873,30.1869,30.1869,27.6555,0.0935,19.5213,22.3451,28.9894,22.3451,588.0662,10.6851,0.6572,0.8072,86.9154,72.7874,54.9180,2.0337,3.2188,8.3902,2.6066,1.5828,4.1256,2.4000
 907.5000,1977.6577,-0.0129,1.4714,1.4976,1.4848,1.4740,1.4749,1.4719,1.4976,0.2549,2.2427,-0.0419,0.7147,2.8271,36.6071,31.8545,31.8545,29.1928,0.1222,24.6873,27.3298,33.5476,27.3298,667.7242,11.4143,0.5955,0.6994,90.6162,78.2726,56.7567,2.1206,3.7431,8.5819,2.2927,1.7652,4.0470,3.0000
 908.0000,1986.8373,0.0112,1.4916,1.4686,1.4570,1.4501,1.4643,1.4927,1.4686,0.2554,2.2095,0.4992,0.7995,2.6617,35.6561,30.8738,30.8738,28.2894,0.1061,26.6941,29.2662,35.3183,29.2663,680.9299,11.5076,0.6056,0.7301,94.0244,79.6485,54.6589,2.0655,4.1953,8.1538,1.9436,2.0311,3.9475,1.0000
 908.5000,2031.2799,0.0341,1.6312,1.5551,1.5426,1.5382,1.5640,1.6317,1.5551,0.2544,2.2832,0.7289,0.3627,2.6252,33.1564,28.3188,28.3188,25.9273,0.0625,22.2304,24.9592,31.3798,24.9592,643.0503,10.5958,1.2081,1.0733,92.8547,75.6319,48.9055,1.8625,4.3536,7.2271,1.6600,2.3374,3.8802,1.0000
 909.0000,2028.7224,-0.0046,1.6540,1.6645,1.6503,1.6491,1.6519,1.6539,1.6645,0.2556,2.4105,0.5728,0.1524,2.9448,29.9050,25.0462,25.0462,22.8828,0.0448,14.5177,17.5170,24.5744,17.5171,600.7714,10.3275,1.4658,1.4887,84.7750,66.1765,40.2783,1.5338,4.1291,5.9531,1.4417,2.6921,3.8813,4.0000
 909.5000,2064.3555,0.0094,2.1150,2.0875,2.0644,2.0685,2.0855,2.1039,2.0875,0.2539,2.4968,0.2160,0.1965,3.5934,25.4307,20.6374,20.6374,18.7456,0.0491,9.2875,12.4704,19.9595,12.4704,479.0414,10.1677,2.8586,2.4823,66.9473,52.2993,30.2074,1.1556,3.4735,4.4394,1.2781,3.0058,3.8416,2.0000
 910.0000,2070.7817,0.0787,3.3352,2.9805,2.9337,2.9542,3.0476,3.2579,2.9805,0.2561,2.5161,-0.0294,0.0621,4.1915,20.0214,15.4565,15.4565,13.8262,0.0554,8.1133,11.3373,18.9235,11.3374,335.5181,9.9078,7.7661,5.4699,45.3893,38.2675,21.0674,0.8063,2.6736,3.0946,1.1574,3.3160,3.8381,1.0000
 910.5000,2067.2920,0.1276,4.0853,3.3916,3.3327,3.3770,3.5549,3.9148,3.3916,0.2549,2.5046,-0.0046,-0.1557,4.4326,17.8485,13.4220,13.4220,11.8759,0.0528,8.8143,12.0138,19.5421,12.0138,294.8459,9.7064,8.0933,5.4325,33.1716,29.6524,15.3115,0.5898,2.2077,2.2310,1.0106,3.7431,3.7826,3.0000
 911.0000,2122.4333,0.1602,4.2686,3.3686,3.3141,3.3764,3.6076,4.0370,3.3686,0.2537,2.5043,-0.0500,-0.3728,4.3701,17.0698,12.6995,12.6995,11.1805,0.0421,8.8301,12.0290,19.5559,12.0290,296.8565,9.6597,7.7847,6.5559,34.7597,29.0945,13.8606,0.5412,2.3228,1.9853,0.8547,4.2923,3.6686,0.0000
 911.5000,2098.6174,0.1826,4.3835,3.3387,3.2906,3.3698,3.6440,4.0989,3.3387,0.2549,2.5111,-0.2549,-0.6568,4.1342,16.4244,12.1033,12.1033,10.6056,0.0325,8.4209,11.6342,19.1949,11.6342,299.5162,9.6294,9.7128,8.6702,43.9761,35.0605,15.1959,0.5965,2.9967,2.1614,0.7213,5.0240,3.6236,3.0000
 912.0000,2112.6106,0.1937,4.1941,3.1380,3.1024,3.1867,3.4701,3.9589,3.1380,0.2537,2.5057,-0.1922,-0.4223,3.7491,16.0308,11.7410,11.7410,10.2558,0.0287,8.7446,11.9465,19.4805,11.9465,318.6728,9.5349,8.0203,7.4761,57.0074,44.9989,17.7657,0.6931,4.0831,2.5469,0.6238,5.8907,3.6743,0.0000
 912.5000,2112.8635,0.2133,3.8821,2.8135,2.7926,2.8700,3.1303,3.6555,2.8135,0.2548,2.4930,0.0267,-0.0591,3.2794,15.9278,11.6463,11.6463,10.1643,0.0276,9.5178,12.6926,20.1628,12.6927,355.4316,9.4691,12.2998,9.0641,73.1453,56.0631,20.2712,0.7691,5.3594,3.0096,0.5616,6.9687,3.9133,0.0000
 913.0000,2098.2148,0.2324,3.5587,2.4994,2.4917,2.5589,2.7872,3.3197,2.4994,0.2552,2.4811,-0.0340,0.1165,3.0063,16.7804,12.4319,12.4319,10.9226,0.0277,10.2367,13.3863,20.7971,13.3863,400.0887,9.4600,6.2447,4.7871,87.7023,65.5485,21.3608,0.7899,6.6010,3.2685,0.4952,8.3564,4.1377,2.0000
 913.5000,2106.6790,0.2465,3.4609,2.3745,2.3788,2.4444,2.6656,3.2108,2.3745,0.2553,2.4722,0.1025,0.4210,3.1484,17.9802,13.5446,13.5446,11.9936,0.0265,10.7731,13.9039,21.2704,13.9039,421.1432,9.4525,5.5741,5.1679,94.0672,71.2042,20.8815,0.7501,7.4754,3.3001,0.4415,9.9659,4.3995,4.0000
 914.0000,2061.2568,0.2557,3.2930,2.2247,2.2415,2.3033,2.5115,3.0419,2.2247,0.2551,2.4756,0.5501,0.4532,3.5011,18.3589,13.8975,13.8975,12.3326,0.0286,10.5721,13.7099,21.0930,13.7099,449.4937,9.4158,7.1560,5.0723,92.8958,71.9091,18.6946,0.6521,7.8379,3.0468,0.3887,12.0197,4.6724,0.0000
 914.5000,2086.1223,0.2375,2.5761,1.7943,1.8150,1.8579,2.0082,2.3949,1.7943,0.2539,2.4881,0.5085,0.0863,3.7883,18.3807,13.9178,13.9178,12.3522,0.0399,9.8098,12.9744,20.4204,12.9744,557.3220,9.3802,8.4936,5.9153,89.5947,69.2676,16.0768,0.5474,7.7817,2.6835,0.3448,14.2150,4.9019,2.0000
 915.0000,2040.4235,0.2022,1.8170,1.3409,1.3580,1.3836,1.4778,1.7122,1.3409,0.2558,2.4717,0.0194,-0.4147,3.9650,18.8063,14.3154,14.3154,12.7337,0.0486,10.8088,13.9383,21.3019,13.9383,745.7616,9.3008,6.8757,3.5820,84.4744,64.9763,13.7703,0.4537,7.4615,2.3704,0.3177,16.4445,5.2241,4.0000
 915.5000,2045.9749,0.1830,1.4637,1.1141,1.1295,1.1484,1.2196,1.3919,1.1141,0.2550,2.4255,-0.3826,-0.3563,3.9651,21.0017,16.3831,16.3831,14.7110,0.0488,13.6074,16.6387,23.7712,16.6387,897.5804,9.2250,3.3326,2.0153,79.1409,60.9895,12.2589,0.3967,7.0825,2.1445,0.3028,17.8531,5.4056,4.0000
 916.0000,2073.6833,0.1788,1.3521,1.0361,1.0519,1.0694,1.1348,1.2906,1.0361,0.2554,2.3991,-0.4717,0.1194,3.8387,21.7863,17.1286,17.1286,15.4212,0.0506,15.2078,18.1829,25.1833,18.1829,965.1889,9.2086,3.6066,1.9633,76.4866,56.7244,11.5453,0.3715,6.5491,2.0296,0.3099,17.6272,5.4627,2.0000
 916.5000,2049.0732,0.1805,1.3419,1.0255,1.0427,1.0608,1.1271,1.2817,1.0255,0.2537,2.3909,-0.3443,0.1706,3.6925,21.7490,17.0932,17.0932,15.3874,0.0528,15.7005,18.6583,25.6180,18.6583,975.1619,9.2311,3.3744,2.0498,70.9925,52.7536,11.5040,0.3587,5.9676,2.0767,0.3480,16.6354,5.7892,2.0000
 917.0000,2038.2697,0.1845,1.3952,1.0593,1.0785,1.0985,1.1697,1.3296,1.0593,0.2551,2.3808,-0.2305,0.2564,3.5311,21.7817,17.1243,17.1243,15.4170,0.0534,16.3126,19.2490,26.1582,19.2490,943.9952,9.2285,3.6489,2.6165,62.9967,49.8377,11.6373,0.3454,5.5220,2.1836,0.3954,15.9854,6.3211,1.0000
 917.5000,2019.3483,0.1863,1.4853,1.1246,1.1457,1.1688,1.2470,1.4118,1.1246,0.2570,2.3821,-0.0425,0.5580,3.5241,21.7999,17.1417,17.1417,15.4336,0.0565,16.2391,19.1781,26.0933,19.1781,889.2127,9.2345,3.6298,2.5821,61.9912,48.5354,11.9675,0.3387,5.2873,2.3242,0.4396,15.6118,6.8625,2.4000
 918.0000,2075.6301,0.1952,1.7405,1.2991,1.3248,1.3559,1.4546,1.6472,1.2991,0.2546,2.3977,0.1227,0.2679,3.6469,20.4943,15.9028,15.9028,14.2526,0.0559,15.2925,18.2647,25.2581,18.2647,769.7375,9.2840,4.1614,2.7406,67.5495,48.1717,12.4081,0.3415,5.1793,2.4554,0.4741,15.1659,7.1899,3.0000
 918.5000,2040.8271,0.2171,2.2915,1.6505,1.6855,1.7355,1.8825,2.1592,1.6505,0.2542,2.4114,0.1543,-0.2440,3.4903,19.4747,14.9420,14.9420,13.3341,0.0473,14.4627,17.4640,24.5259,17.4640,605.8640,9.3414,5.8889,4.2393,66.3130,44.5776,11.9623,0.3311,4.7275,2.3583,0.4988,14.2777,7.1224,4.0000
 919.0000,2074.0984,0.2304,2.8535,2.0110,2.0499,2.1221,2.3195,2.6958,2.0110,0.2532,2.4117,0.1994,-0.2716,3.0630,18.5440,14.0703,14.0703,12.4985,0.0343,14.4395,17.4416,24.5054,17.4416,497.2730,9.3071,7.2998,6.4924,53.2361,38.6764,10.7505,0.3078,4.0513,2.0711,0.5112,13.1635,6.7294,1.0000
 919.5000,2073.3032,0.2197,3.0660,2.1989,2.2267,2.3074,2.5130,2.9185,2.1989,0.2548,2.4100,-0.0110,-0.1855,2.8251,17.9969,13.5601,13.5601,12.0085,0.0248,14.5455,17.5439,24.5989,17.5439,454.7677,9.2660,6.7338,4.4255,42.8091,33.1627,9.5156,0.2761,3.4323,1.8155,0.5290,12.4297,6.5748,3.0000
 920.0000,2073.7183,0.1960,3.0954,2.3075,2.3160,2.3955,2.5821,2.9640,2.3075,0.2550,2.4156,-0.3638,-0.0347,2.7506,18.1716,13.7228,13.7228,12.1649,0.0223,14.2038,17.2141,24.2974,17.2141,433.3749,9.2845,5.8957,4.3666,41.8928,31.5252,9.5361,0.2793,3.1855,1.8070,0.5673,11.4035,6.4688,1.0000
 920.5000,2132.7063,0.1655,3.1003,2.4263,2.4118,2.4861,2.6442,2.9768,2.4263,0.2552,2.4257,-0.2582,0.2796,2.6572,18.3328,13.8731,13.8731,12.3092,0.0212,13.5941,16.6258,23.7595,16.6258,412.1448,9.3486,6.3696,4.6707,46.4439,34.4425,11.3787,0.3417,3.3246,2.1164,0.6366,9.7299,6.1940,0.0000
 921.0000,2028.6312,0.1334,3.1189,2.5662,2.5270,2.5912,2.7140,2.9814,2.5662,0.2547,2.4627,0.1386,0.3319,2.8641,18.6100,14.1319,14.1319,12.5576,0.0235,11.3492,14.4597,21.7787,14.4597,389.6823,9.3878,6.6955,4.9113,53.3369,38.4850,14.4201,0.4423,3.4575,2.6383,0.7631,7.8179,5.9656,0.0000
 921.5000,2049.7751,0.0936,3.1826,2.7821,2.7149,2.7646,2.8488,3.0533,2.7821,0.2542,2.5301,0.4060,0.3790,3.3809,18.1127,13.6679,13.6679,12.1121,0.0282,7.2651,10.5190,18.1751,10.5190,359.4402,9.4447,6.9150,4.2989,59.1915,41.0066,17.4159,0.5571,3.3912,3.0775,0.9075,6.0875,5.5244,0.0000
 922.0000,2054.8655,0.0262,3.3080,3.1892,3.0832,3.1113,3.1452,3.2788,3.1892,0.2553,2.5819,0.3034,0.4767,3.7803,17.8683,13.4404,13.4404,11.8935,0.0265,4.1275,7.4914,15.4066,7.4915,313.5562,9.4989,6.1014,3.8945,58.1075,40.5708,19.2281,0.6356,3.0932,3.3001,1.0669,4.8662,5.1917,3.2000
 922.5000,2113.7039,-0.0516,3.7870,4.0592,3.8876,3.8764,3.8244,3.8781,4.0592,0.2544,2.5911,-0.0995,0.3712,3.9556,16.9431,12.5823,12.5823,11.0675,0.0204,3.5710,6.9545,14.9156,6.9545,246.3509,9.5971,8.6870,5.3576,52.1084,38.4381,19.7707,0.6748,2.7293,3.2923,1.2063,4.0444,4.8786,4.8000
 923.0000,2113.5430,-0.1193,4.1397,4.8350,4.5950,4.5350,4.3638,4.2267,4.8350,0.2555,2.5695,-0.1481,0.1940,3.9723,15.8455,11.5707,11.5707,10.0912,0.0164,4.8813,8.2188,16.0717,8.2188,206.8267,9.6155,9.3786,6.6041,47.9481,36.4603,19.9101,0.7062,2.4289,3.1893,1.3130,3.4394,4.5161,2.4000
 923.5000,2061.1770,-0.2220,4.2022,5.5200,5.2118,5.0936,4.7802,4.3708,5.5267,0.2535,2.5575,0.0571,-0.1564,3.9572,15.3873,11.1504,11.1504,9.6848,0.0189,5.6089,8.9208,16.7137,8.9208,181.1584,9.6105,9.9984,7.2519,46.6892,35.4425,20.4004,0.7483,2.2236,3.1504,1.4168,2.9714,4.2099,1.6000
 924.0000,2071.7141,-0.3262,3.9194,5.7119,5.3702,5.2046,4.7822,4.1147,5.7323,0.2538,2.5769,-0.0871,-0.6558,4.0400,14.9976,10.7940,10.7940,9.3396,0.0197,4.4330,7.7863,15.6762,7.7863,175.0738,9.6323,9.5470,6.4520,47.0773,36.1456,21.7364,0.8205,2.1466,3.2471,1.5127,2.6164,3.9577,0.8000
 924.5000,2043.5906,-0.3793,3.1666,4.8466,4.5511,4.3864,3.9867,3.3213,4.8625,0.2542,2.5756,-0.2861,-1.0283,4.1185,17.7116,13.2948,13.2948,11.7535,0.0151,4.5110,7.8615,15.7450,7.8615,206.3291,9.6567,8.8063,5.5311,48.5619,39.2061,24.2661,0.9253,2.2476,3.5805,1.5931,2.4290,3.8695,2.0000
 925.0000,2074.6394,-0.3341,2.2870,3.3618,3.1633,3.0431,2.7795,2.3792,3.3699,0.2530,2.4581,-0.2695,-0.8998,3.9557,23.2331,18.5127,18.5127,16.7361,0.0405,11.6317,14.7323,22.0280,14.7323,297.4582,9.7128,8.1664,3.7369,55.5844,45.7574,28.7925,1.1041,2.5623,4.2193,1.6467,2.3208,3.8216,2.0000
 925.5000,2050.2935,-0.2315,1.4897,1.9766,1.8675,1.7982,1.6683,1.5259,1.9794,0.2547,2.2746,-0.1698,0.0085,3.5675,29.7367,24.8784,24.8784,22.7262,0.1056,22.7520,25.4624,31.8400,25.4624,505.9297,9.8901,1.7698,0.7208,67.4443,54.1816,34.2082,1.3130,3.0225,5.0069,1.6566,2.3020,3.8134,3.0000
 926.0000,2057.6523,-0.1456,1.4805,1.7826,1.6985,1.6422,1.5576,1.5047,1.7849,0.2552,2.3116,0.1572,1.1379,3.3581,34.8393,30.0353,30.0353,27.5155,0.1046,20.5121,23.3011,29.8636,23.3012,560.9906,10.2991,0.5001,0.5618,80.7468,65.2394,40.7116,1.5629,3.7395,5.9571,1.5930,2.3926,3.8115,2.4000
 926.5000,2059.3225,-0.1391,1.7938,2.1425,2.0538,1.9935,1.9068,1.8399,2.1459,0.2541,2.4554,0.1372,0.2316,3.4422,30.7240,25.8651,25.8651,23.6467,0.0384,11.7913,14.8864,22.1688,14.8864,466.7383,10.0000,1.9435,1.1981,87.2205,67.9444,41.4054,1.5954,4.0662,6.0310,1.4832,2.5487,3.7803,0.8000
 927.0000,2018.4271,-0.1234,1.8645,2.1852,2.1073,2.0548,1.9790,1.9056,2.1886,0.2556,2.5126,0.0400,-0.2773,3.4780,29.7496,24.8912,24.8912,22.7381,0.0072,8.3272,11.5437,19.1122,11.5438,457.6303,9.9139,2.3908,1.5491,90.4521,68.8581,41.1723,1.5963,4.2590,5.9502,1.3971,2.6681,3.7275,2.4000
 927.5000,2063.4805,-0.0944,1.8515,2.0937,2.0310,1.9906,1.9323,1.8762,2.0967,0.2539,2.5233,0.0371,0.3153,3.5570,29.6515,24.7935,24.7935,22.6468,0.0146,7.6786,10.9179,18.5399,10.9179,477.6189,9.8788,2.2527,1.4354,89.6553,69.9863,41.4089,1.6102,4.4014,5.9621,1.3546,2.7335,3.7028,3.0000
 928.0000,2069.0542,-0.0596,1.8210,1.9699,1.9219,1.8940,1.8559,1.8367,1.9724,0.2544,2.5235,0.0066,0.1628,3.6200,29.9280,25.0692,25.0692,22.9043,0.0280,7.6663,10.9061,18.5291,10.9061,507.6378,9.8598,2.2937,1.4145,88.0244,68.4345,40.4998,1.5700,4.3041,5.8541,1.3601,2.7415,3.7287,8.0000
 928.5000,2086.6858,-0.0204,1.8487,1.8995,1.8647,1.8483,1.8311,1.8558,1.9009,0.2543,2.5125,0.1064,-0.4845,3.5766,29.4444,24.5872,24.5872,22.4541,0.0386,8.3349,11.5512,19.1190,11.5512,526.4546,9.7895,2.4026,1.4576,83.4921,63.4751,37.5739,1.4390,3.9946,5.5147,1.3805,2.7760,3.8324,3.0000
 929.0000,2061.5796,-0.0093,2.0458,2.0721,2.0435,2.0351,2.0365,2.0376,2.0721,0.2548,2.4950,0.2905,-0.0615,3.4968,27.4576,22.6209,22.6209,20.6123,0.0469,9.3923,12.5715,20.0520,12.5715,482.5978,9.6406,2.4198,1.9087,72.0640,52.5406,31.1058,1.1729,3.3165,4.6526,1.4029,2.8277,3.9669,3.0000
 929.5000,2091.7300,0.0311,2.5747,2.4652,2.4402,2.4422,2.4661,2.5783,2.4652,0.2539,2.4765,0.1632,0.6165,3.3119,23.5875,18.8535,18.8535,17.0591,0.0456,10.5165,13.6563,21.0440,13.6563,405.6422,9.4388,7.4680,3.5412,52.9542,40.0489,23.6333,0.8835,2.5457,3.5711,1.4028,2.8814,4.0420,4.0000
 930.0000,2088.5864,0.0782,2.7854,2.4912,2.4812,2.5011,2.5747,2.7928,2.4912,0.2541,2.4555,-0.2042,0.6083,2.9613,19.3379,14.8136,14.8136,13.2111,0.0364,11.7894,14.8845,22.1671,14.8845,401.4077,9.2988,8.6504,3.8579,37.3319,30.9750,18.2021,0.6812,1.9956,2.7469,1.3765,2.9296,4.0324,1.0000
 930.5000,2062.4546,0.1109,2.4605,2.0954,2.1061,2.1330,2.2213,2.4474,2.0954,0.2555,2.4465,-0.4316,0.2287,2.7384,19.2240,14.7067,14.7067,13.1087,0.0327,12.3313,15.4074,22.6453,15.4074,477.2273,9.2713,5.5204,3.3360,34.9623,28.1165,16.3453,0.6111,1.8553,2.4696,1.3311,3.0361,4.0414,1.0000
 931.0000,2047.2075,0.1314,2.0064,1.6561,1.6764,1.7009,1.7820,1.9774,1.6561,0.2540,2.4349,-0.4298,-0.3200,2.8549,19.9145,15.3557,15.3557,13.7299,0.0322,13.0389,16.0901,23.2696,16.0901,603.8336,9.3014,5.6771,3.7798,38.5997,28.6959,16.1712,0.6088,1.9793,2.4231,1.2243,3.2509,3.9800,3.0000
 931.5000,2060.4854,0.1383,1.5284,1.2482,1.2683,1.2863,1.3483,1.4942,1.2482,0.2551,2.3981,-0.1774,-0.6164,3.1216,20.4007,15.8144,15.8144,14.1682,0.0336,15.2697,18.2427,25.2379,18.2427,801.1422,9.2274,5.8086,3.0071,38.5462,28.6632,15.3709,0.5733,2.0996,2.3289,1.1092,3.6624,4.0624,3.0000
 932.0000,2052.5046,0.1385,1.1848,0.9672,0.9846,0.9977,1.0445,1.1531,0.9672,0.2542,2.3714,0.2951,-0.4089,3.2446,21.7890,17.1312,17.1312,15.4237,0.0463,16.8827,19.7991,26.6612,19.7991,1033.9552,9.2044,3.3228,1.6868,36.5923,26.8123,13.4240,0.4975,2.0884,2.0490,0.9811,4.1979,4.1187,5.0000
 932.5000,2050.2126,0.1421,1.0316,0.8375,0.8546,0.8660,0.9077,1.0021,0.8375,0.2546,2.3678,0.4463,-0.1610,3.2188,22.6217,17.9264,17.9264,16.1797,0.0621,17.1046,20.0132,26.8570,20.0132,1194.0784,9.2571,4.2528,1.6135,34.3119,24.5906,11.4761,0.4194,2.0234,1.7797,0.8795,4.8245,4.2433,6.0000
 933.0000,2080.5361,0.1472,0.9655,0.7776,0.7959,0.8068,0.8477,0.9369,0.7776,0.2546,2.3575,0.2410,-0.1341,3.2267,23.7015,18.9633,18.9633,17.1631,0.0667,17.7294,20.6161,27.4083,20.6161,1285.9926,9.2798,2.7703,1.4462,30.7181,23.0905,10.0212,0.3549,1.9990,1.6081,0.8045,5.6333,4.5317,2.0000
 933.5000,1997.4092,0.1484,0.8978,0.7218,0.7403,0.7507,0.7895,0.8708,0.7218,0.2534,2.3467,0.1501,-0.1525,3.3113,24.8404,20.0641,20.0641,18.2044,0.0708,18.3817,21.2455,27.9838,21.2455,1385.4165,9.2813,3.4776,1.5993,27.5027,22.1703,8.8617,0.2961,2.0311,1.5058,0.7413,6.8585,5.0846,3.0000
 934.0000,1932.2941,0.1466,0.8227,0.6633,0.6809,0.6904,0.7257,0.7979,0.6633,0.2553,2.3384,-0.0104,-0.1035,3.4389,26.3896,21.5730,21.5730,19.6272,0.0801,18.8833,21.7295,28.4265,21.7295,1507.7172,9.3083,3.2214,1.6868,26.1644,21.2163,7.5039,0.2281,2.0942,1.3827,0.6602,9.1823,6.0626,0.0000
 934.5000,1959.3694,0.1474,0.7984,0.6429,0.6611,0.6706,0.7055,0.7747,0.6429,0.2538,2.3227,-0.3108,0.1856,3.5013,26.8336,22.0078,22.0078,20.0363,0.0819,19.8344,22.6472,29.2656,22.6472,1555.5227,9.3252,2.1036,1.3749,24.9358,20.2561,6.2547,0.1702,2.1377,1.2468,0.5832,12.5565,7.3231,1.0000
 935.0000,2049.5220,0.1514,0.8417,0.6734,0.6949,0.7061,0.7449,0.8173,0.6734,0.2543,2.3130,-0.4305,0.4352,3.4597,27.1096,22.2787,22.2787,20.2909,0.0793,20.4249,23.2170,29.7866,23.2170,1484.9133,9.3145,1.7597,1.4846,25.4087,19.5674,5.4345,0.1386,2.1545,1.1276,0.5233,15.5463,8.1360,3.0000
 935.5000,2066.4395,0.1526,0.8835,0.7056,0.7303,0.7434,0.7858,0.8582,0.7056,0.2538,2.3112,-0.2655,0.5294,3.4609,26.5850,21.7642,21.7642,19.8071,0.0804,20.5315,23.3198,29.8807,23.3198,1417.1708,9.3556,1.8307,1.6405,26.9522,19.4028,5.0297,0.1287,2.1916,1.0413,0.4752,17.0244,8.0893,1.0000
 936.0000,2044.0167,0.1460,0.8621,0.6956,0.7203,0.7336,0.7740,0.8378,0.6956,0.2538,2.3102,0.0285,0.3239,3.5370,27.2524,22.4191,22.4191,20.4228,0.0832,20.5931,23.3793,29.9351,23.3793,1437.6198,9.3469,1.7118,1.5873,26.3018,19.5051,4.9696,0.1321,2.2144,1.0056,0.4541,16.7632,7.6128,1.0000
 936.5000,2045.6183,0.1392,0.8324,0.6788,0.7026,0.7158,0.7532,0.8094,0.6788,0.2553,2.3184,0.1121,-0.2310,3.6095,27.3985,22.5628,22.5628,20.5577,0.0869,20.0971,22.9007,29.4974,22.9007,1473.2673,9.3427,1.6101,1.4681,25.2311,19.5524,4.9595,0.1338,2.2211,0.9943,0.4477,16.6022,7.4322,1.0000
 937.0000,2038.8804,0.1363,0.8441,0.6914,0.7162,0.7303,0.7679,0.8217,0.6914,0.2539,2.3375,-0.0933,-0.4256,3.5968,27.0282,22.1988,22.1988,20.2158,0.0934,18.9414,21.7855,28.4777,21.7855,1446.2473,9.3557,1.3979,1.3502,25.0955,20.6440,5.3638,0.1491,2.3252,1.0547,0.4536,15.5993,7.0757,1.0000
 937.5000,2009.7323,0.1380,0.8953,0.7314,0.7588,0.7750,0.8153,0.8707,0.7314,0.2538,2.3511,-0.1351,-0.3102,3.4999,26.7371,21.9133,21.9133,19.9474,0.1018,18.1134,20.9866,27.7471,20.9866,1367.2731,9.3549,1.4310,1.2318,26.6194,22.0729,5.8992,0.1704,2.4588,1.1295,0.4594,14.4332,6.6302,6.0000
 938.0000,1989.2778,0.1399,0.9404,0.7660,0.7954,0.8133,0.8562,0.9143,0.7660,0.2549,2.3600,0.1497,0.0092,3.4571,26.2728,21.4587,21.4587,19.5196,0.1085,17.5735,20.4657,27.2708,20.4657,1305.4424,9.3894,1.8827,1.7540,28.4644,22.8473,6.3017,0.1912,2.5215,1.1629,0.4612,13.1898,6.0832,3.0000
 938.5000,2081.3997,0.1340,0.8828,0.7258,0.7511,0.7669,0.8056,0.8609,0.7258,0.2536,2.3653,0.2822,0.2399,3.4905,27.0485,22.2188,22.2188,20.2346,0.1167,17.2535,20.1568,26.9883,20.1568,1377.7983,9.4421,4.0024,2.2601,29.0292,21.9838,6.4421,0.2063,2.3727,1.1370,0.4792,11.4990,5.5105,1.0000
 939.0000,2039.9635,0.1297,0.8076,0.6684,0.6889,0.7019,0.7362,0.7888,0.6684,0.2553,2.3537,0.0142,-0.0122,3.5268,28.1050,23.2593,23.2593,21.2112,0.1283,17.9588,20.8374,27.6107,20.8374,1496.1315,9.4559,2.2135,1.4918,27.1734,20.0352,6.2501,0.2106,2.0918,1.0539,0.5038,9.9340,5.0050,4.0000
 939.5000,2001.4749,0.1308,0.7965,0.6580,0.6767,0.6886,0.7226,0.7777,0.6580,0.2558,2.3344,-0.1212,-0.1612,3.5767,28.4923,23.6422,23.6422,21.5700,0.1329,19.1265,21.9641,28.6410,21.9642,1519.7469,9.3957,1.4173,1.2548,24.6218,19.0267,6.3273,0.2199,1.9230,1.0350,0.5382,8.7448,4.7067,1.0000
 940.0000,2004.8715,0.1334,0.8390,0.6904,0.7088,0.7209,0.7576,0.8190,0.6904,0.2555,2.3278,0.0598,-0.0655,3.5965,28.1824,23.3358,23.3358,21.2829,0.1287,19.5300,22.3535,28.9971,22.3535,1448.4811,9.3958,1.4659,1.2255,25.2749,18.9674,6.5043,0.2304,1.8760,1.0434,0.5562,8.1430,4.5291,1.0000
 940.5000,2013.0490,0.1355,0.9156,0.7510,0.7698,0.7824,0.8233,0.8945,0.7510,0.2553,2.3337,-0.1251,0.1909,3.4741,26.1149,21.3045,21.3045,19.3744,0.1216,19.1671,22.0033,28.6768,22.0033,1331.5908,9.4387,2.2664,1.6522,27.0485,19.2941,6.6832,0.2381,1.8920,1.0656,0.5632,7.9462,4.4753,1.0000
 941.0000,2028.4344,0.1343,0.9640,0.7921,0.8095,0.8215,0.8635,0.9425,0.7921,0.2557,2.3360,-0.4299,0.2892,3.2292,24.5134,19.7473,19.7473,17.9050,0.1033,19.0297,21.8708,28.5556,21.8708,1262.3909,9.4200,3.0454,1.8378,25.8164,19.0403,6.6604,0.2342,1.8560,1.0765,0.5800,7.9246,4.5963,6.0000
 941.5000,2104.0068,0.1308,1.0142,0.8378,0.8526,0.8637,0.9052,0.9920,0.8378,0.2553,2.3289,-0.1926,-0.1271,2.9888,24.1653,19.4106,19.4106,17.5867,0.0703,19.4600,22.2859,28.9353,22.2859,1193.5974,9.3359,3.2686,1.8321,23.9696,18.2165,6.4974,0.2284,1.7535,1.0504,0.5991,7.6766,4.5987,1.0000
 942.0000,2083.0239,0.1252,1.1276,0.9395,0.9519,0.9628,1.0061,1.1037,0.9395,0.2565,2.3272,0.1344,-0.0928,2.9443,23.5947,18.8604,18.8604,17.0657,0.0422,19.5626,22.3849,29.0258,22.3850,1064.3433,9.2606,3.2840,1.8950,25.2240,18.7867,6.8806,0.2452,1.7786,1.0969,0.6167,7.2550,4.4744,3.0000
 942.5000,2121.0400,0.1170,1.3998,1.1811,1.1903,1.2028,1.2540,1.3732,1.1811,0.2550,2.3453,0.1337,0.2231,3.1537,22.9694,18.2595,18.2595,16.4959,0.0322,18.4662,21.3271,28.0584,21.3271,846.6850,9.2512,3.0037,1.6294,29.8393,22.9240,8.5868,0.3073,2.1407,1.3625,0.6365,6.9662,4.4337,2.0000
 943.0000,2083.6570,0.1013,1.9535,1.6879,1.6861,1.7021,1.7698,1.9249,1.6879,0.2564,2.3999,0.0072,0.0220,3.3470,20.6970,16.0944,16.0944,14.4356,0.0311,15.1562,18.1332,25.1378,18.1332,592.4536,9.2778,3.2916,2.1318,38.1394,31.6768,12.2212,0.4342,2.9085,1.9543,0.6719,6.6984,4.5008,1.6000
 943.5000,2104.1453,0.0680,2.7485,2.4953,2.4570,2.4735,2.5514,2.7235,2.4953,0.2582,2.4876,-0.1861,-0.2495,3.4035,18.9729,14.4714,14.4714,12.8832,0.0295,9.8411,13.0046,20.4480,13.0046,400.7493,9.3213,7.0966,4.6896,53.5528,43.4857,17.3113,0.6125,3.9225,2.7804,0.7088,6.4044,4.5395,0.0000
 944.0000,2079.5925,0.0164,3.1982,3.1241,3.0435,3.0453,3.0655,3.1747,3.1262,0.2574,2.5402,-0.3103,-0.2206,3.4590,19.5686,15.0303,15.0303,13.4185,0.0262,6.6537,9.9290,17.6356,9.9290,320.0932,9.3975,7.8887,4.5292,70.9925,52.6095,22.0181,0.7828,4.5984,3.5184,0.7651,5.8744,4.4947,1.6000
 944.5000,2103.5693,-0.0152,3.4960,3.5622,3.4481,3.4339,3.4402,3.4745,3.5696,0.2569,2.5279,-0.1531,0.1454,3.4738,19.1824,14.6677,14.6677,13.0713,0.0250,7.3970,10.6463,18.2915,10.6463,280.7281,9.4327,5.1798,2.9094,77.3422,52.9788,23.5499,0.8516,4.4347,3.6952,0.8332,5.2078,4.3394,0.8000
 945.0000,2105.4463,-0.0247,4.4276,4.5577,4.3680,4.3261,4.2863,4.4193,4.5795,0.2564,2.5255,0.0441,0.6084,3.4625,16.4339,12.1121,12.1121,10.6141,0.0264,7.5440,10.7881,18.4212,10.7881,219.4074,9.3359,5.4203,3.6185,64.4197,45.0844,21.2122,0.7734,3.6214,3.2980,0.9107,4.6823,4.2642,4.0000
 945.5000,2108.3953,-0.0723,6.7025,7.3078,6.9244,6.8227,6.6657,6.7413,7.3800,0.2565,2.5682,0.1181,0.4062,3.5305,12.5733,8.5965,8.5965,7.2035,0.0261,4.9596,8.2944,16.1408,8.2944,136.8395,9.2794,10.0784,7.1366,42.5896,34.5936,17.0928,0.6200,2.6731,2.6730,1.0000,4.3116,4.3116,2.4000
 946.0000,2097.4546,-0.1297,9.0152,10.5057,9.8629,9.6597,9.3730,9.0640,10.6634,0.2572,2.6038,0.2165,-0.5795,3.5315,10.2125,6.4897,6.4897,5.1417,0.0296,2.7981,6.2086,14.2336,6.2087,95.1868,9.1908,13.2551,10.8534,30.1444,28.6700,14.7612,0.5278,2.1359,2.3445,1.0976,4.0468,4.4419,4.0000
 946.5000,2072.4519,-0.1643,8.6688,10.5206,9.8376,9.5985,9.2578,8.6780,10.6840,0.2586,2.6072,0.4872,-0.7202,3.5312,10.1790,6.4601,6.4601,5.1126,0.0418,2.5919,6.0097,14.0516,6.0097,95.0516,9.2526,17.5151,12.5609,32.3223,29.9009,15.8612,0.5598,2.1723,2.5540,1.1757,3.8806,4.5624,1.6000
 947.0000,2109.3975,-0.1684,6.4072,7.8430,7.2996,7.0942,6.8573,6.4291,7.9348,0.2584,2.5975,0.7726,-0.1479,3.6884,11.9999,8.0817,8.0817,6.7011,0.0528,3.1796,6.5768,14.5703,6.5768,127.5016,9.3297,12.6251,7.4974,44.3651,36.3751,19.8256,0.6953,2.5735,3.2131,1.2485,3.7010,4.6209,0.8000
 947.5000,2126.9368,-0.1587,4.7744,5.7958,5.3836,5.2179,5.0670,4.8136,5.8456,0.2587,2.5975,0.5054,0.0079,3.7584,15.3311,11.0990,11.0990,9.6350,0.0543,3.1840,6.5810,14.5741,6.5811,172.5378,9.3686,8.1376,4.8715,57.2786,43.3077,24.1708,0.8462,2.9906,3.9248,1.3124,3.5343,4.6384,0.0000
 948.0000,2126.4070,-0.1457,3.9421,4.7212,4.3888,4.2485,4.1436,3.9834,4.7535,0.2597,2.6070,-0.1830,0.3417,3.6905,18.6136,14.1352,14.1352,12.5608,0.0427,2.6080,6.0252,14.0658,6.0252,211.8085,9.5313,6.6381,3.6026,64.3305,48.1230,27.4463,0.9602,3.2394,4.4596,1.3767,3.3737,4.6445,3.2000
 948.5000,2112.9670,-0.1335,3.5250,4.1646,3.8836,3.7596,3.6767,3.5622,4.1887,0.2584,2.6007,-0.3615,0.4601,3.6527,19.1060,14.5960,14.5960,13.0027,0.0220,2.9887,6.3926,14.4018,6.3926,240.1183,9.6568,6.5231,3.4337,65.3913,49.9645,29.1775,1.0326,3.2623,4.6849,1.4360,3.1594,4.5371,2.4000
 949.0000,2058.7703,-0.1239,3.2878,3.8439,3.6029,3.4919,3.4183,3.3211,3.8619,0.2586,2.5897,-0.1353,0.2841,3.6362,19.1207,14.6098,14.6098,13.0159,0.0082,3.6564,7.0369,14.9909,7.0369,260.1525,9.7608,4.8230,2.8938,64.6044,49.2716,29.5691,1.0577,3.1026,4.6942,1.5130,2.9333,4.4381,2.4000
 949.5000,2044.8805,-0.1177,3.1732,3.6870,3.4779,3.3772,3.3043,3.2029,3.6988,0.2587,2.5890,-0.0602,0.3741,3.6336,18.8855,14.3895,14.3895,12.8047,0.0055,3.6997,7.0787,15.0292,7.0787,271.2202,9.7054,4.4076,2.7645,62.9494,48.5574,30.0319,1.0808,2.9409,4.7369,1.6107,2.7211,4.3829,8.8000
 950.0000,2035.2073,-0.1114,3.1102,3.5918,3.4120,3.3213,3.2470,3.1375,3.5974,0.2593,2.5843,0.0299,0.1201,3.6592,18.6568,14.1756,14.1756,12.5996,0.0058,3.9842,7.3531,15.2801,7.3531,278.4113,9.7043,4.7706,3.0264,59.8847,48.4553,30.7346,1.1127,2.8397,4.8162,1.6961,2.5521,4.3284,1.0000
 950.5000,2129.8967,-0.1037,3.0233,3.4632,3.3135,3.2338,3.1600,3.0513,3.4640,0.2586,2.5814,-0.0548,-0.4597,3.6533,19.0653,14.5579,14.5579,12.9662,0.0080,4.1570,7.5199,15.4327,7.5199,288.7463,9.7257,4.6445,2.8512,58.0299,48.4860,31.5623,1.1369,2.7393,4.9731,1.8155,2.4094,4.3742,2.0000
 951.0000,2075.9070,-0.0957,2.8882,3.2760,3.1560,3.0880,3.0158,2.9128,3.2760,0.2590,2.5854,-0.2430,-0.2635,3.6186,20.4553,15.8659,15.8659,14.2174,0.0115,3.9151,7.2865,15.2192,7.2865,305.2463,9.7283,3.9182,2.5225,59.3967,49.1334,32.5047,1.1617,2.7126,5.1650,1.9041,2.3349,4.4459,2.0000
 951.5000,2093.4001,-0.0886,2.8216,3.1722,3.0753,3.0161,2.9411,2.8459,3.1722,0.2595,2.5837,-0.1864,0.1252,3.6135,22.6844,17.9865,17.9865,16.2367,0.0153,4.0182,7.3859,15.3101,7.3859,315.2392,9.7460,3.6044,2.4472,60.9018,50.4480,33.9081,1.1982,2.7230,5.4530,2.0026,2.2726,4.5511,2.0000
 952.0000,2114.8677,-0.0776,2.7009,2.9941,2.9192,2.8692,2.7903,2.7246,2.9941,0.2607,2.5637,-0.1225,-0.0231,3.5111,24.3434,19.5828,19.5828,17.7495,0.0182,5.2304,8.5556,16.3797,8.5556,333.9857,9.8322,3.2967,2.2012,65.0264,53.7650,36.7856,1.2819,2.8391,6.0007,2.1136,2.2147,4.6810,4.0000
 952.5000,2071.4958,-0.0707,2.4639,2.7074,2.6528,2.6122,2.5264,2.4884,2.7074,0.2601,2.5385,-0.0522,0.1028,3.3285,26.0942,21.2842,21.2842,19.3553,0.0144,6.7569,10.0286,17.7267,10.0286,369.3550,10.0550,1.1797,1.4424,71.8838,57.1459,39.9125,1.3799,2.9343,6.5633,2.2368,2.1265,4.7565,4.0000
 953.0000,2044.4542,-0.0793,2.3961,2.6621,2.6195,2.5835,2.4772,2.4185,2.6621,0.2606,2.5373,-0.0957,-0.1072,3.3008,25.9110,21.1054,21.1054,19.1868,0.0086,6.8303,10.0994,17.7915,10.0995,375.6433,10.0964,1.7586,1.7226,74.5479,58.4184,41.5601,1.4295,2.9114,6.8689,2.3593,2.0366,4.8050,6.0000
 953.5000,2057.7446,-0.1053,2.4050,2.7611,2.7266,2.6931,2.5639,2.4255,2.7611,0.2619,2.5392,-0.3080,-0.6219,3.3392,25.8597,21.0553,21.0553,19.1397,0.0021,6.7175,9.9905,17.6919,9.9905,362.1719,10.0205,2.9016,1.7407,72.9803,57.6761,41.8537,1.4351,2.7831,6.9388,2.4932,1.9393,4.8350,0.0000
 954.0000,2079.4080,-0.1351,2.1911,2.6086,2.5840,2.5559,2.4342,2.2109,2.6086,0.2610,2.4893,-0.4367,-0.7001,3.2944,29.6950,24.8369,24.8369,22.6874,-0.0036,9.7404,12.9074,20.3592,12.9074,383.3456,10.1476,2.0007,1.5588,71.9070,55.0530,40.5508,1.3869,2.5857,6.7394,2.6064,1.8643,4.8592,1.0000
 954.5000,2052.7578,-0.1395,1.9404,2.3224,2.3068,2.2856,2.1924,1.9603,2.3224,0.2611,2.2901,-0.4888,-0.5571,3.0229,34.4120,29.5980,29.5980,27.1114,0.0081,21.8117,24.5551,31.0103,24.5551,430.5801,10.2117,2.8186,1.6174,71.8347,52.4316,38.7203,1.3185,2.4670,6.4626,2.6196,1.8710,4.9013,0.0000
 955.0000,2059.4148,-0.1220,1.6304,1.9107,1.9023,1.8884,1.8268,1.6507,1.9107,0.2598,2.0104,-0.4038,-0.0525,2.5744,41.2467,36.7082,36.7082,33.6384,0.0479,38.7631,40.9117,45.9674,40.9117,523.3642,10.3358,1.5117,0.8615,69.3767,50.3540,37.2089,1.2616,2.3698,6.2366,2.6317,1.8785,4.9436,3.0000
 955.5000,2076.7246,-0.1029,1.6050,1.8369,1.8321,1.8218,1.7739,1.6256,1.8369,0.2614,1.9327,-0.2284,0.4413,2.4967,43.5031,39.1095,39.1095,35.8230,0.0971,43.4747,45.4581,50.1248,45.4581,544.3822,11.3335,0.4789,0.7040,64.9274,50.0695,36.7514,1.2477,2.3825,6.1518,2.5821,1.9094,4.9303,1.0000
 956.0000,2067.5911,-0.0876,1.8983,2.1314,2.1279,2.1187,2.0706,1.9179,2.1314,0.2621,2.0883,-0.0101,0.5245,2.8209,40.8423,36.2807,36.2807,33.2485,0.1190,34.0422,36.3565,41.8019,36.3565,469.1674,11.8226,0.7820,0.8631,60.8376,49.7617,36.4190,1.2455,2.3797,6.0532,2.5436,1.9107,4.8601,1.0000
 956.5000,2008.4647,-0.0750,2.2757,2.5145,2.5110,2.5019,2.4460,2.2886,2.5145,0.2619,2.2960,0.1779,0.2887,3.1533,38.7362,34.0678,34.0678,31.2251,0.1091,21.4543,24.2103,30.6950,24.2103,397.6903,11.4063,0.9864,0.9287,58.9345,48.5717,35.4997,1.2178,2.3318,5.8824,2.5227,1.9147,4.8303,0.8000
 957.0000,1984.2573,-0.0611,2.5137,2.7279,2.7232,2.7133,2.6488,2.5170,2.7279,0.2610,2.4384,0.1942,0.0308,3.3603,34.6558,29.8474,29.8474,27.3420,0.0802,12.8239,15.8827,23.0799,15.8827,366.5785,11.3872,1.1500,1.1353,61.6566,47.7210,34.9385,1.2025,2.2913,5.7703,2.5183,1.9054,4.7984,6.0000
 957.5000,2047.4954,-0.0489,2.5660,2.7408,2.7336,2.7222,2.6584,2.5661,2.7408,0.2617,2.4931,0.1993,0.1315,3.4229,31.5463,26.6910,26.6910,24.4157,0.0506,9.5082,12.6833,20.1542,12.6833,364.8542,11.3587,1.4647,1.4101,65.2816,47.6836,34.9100,1.1990,2.2993,5.7779,2.5129,1.9177,4.8191,1.6000
 958.0000,2058.6084,-0.0400,2.5641,2.7068,2.6963,2.6822,2.6274,2.5643,2.7068,0.2617,2.5053,0.0261,0.0945,3.4380,31.3699,26.5136,26.5136,24.2506,0.0399,8.7700,11.9711,19.5030,11.9711,369.4369,11.3503,1.8535,1.6409,64.6071,48.1522,35.4050,1.2128,2.3067,5.8744,2.5466,1.9019,4.8435,0.8000
 958.5000,2081.8833,-0.0330,2.5590,2.6761,2.6620,2.6442,2.5993,2.5592,2.6761,0.2625,2.4934,-0.2873,-0.2218,3.4407,31.8947,27.0421,27.0421,24.7422,0.0433,9.4917,12.6674,20.1397,12.6674,373.6763,11.3875,1.6699,1.4336,63.4838,49.3254,36.2613,1.2405,2.3677,6.0244,2.5443,1.9087,4.8564,0.0000
 959.0000,2095.9912,-0.0288,2.5077,2.6080,2.5909,2.5691,2.5310,2.5093,2.6080,0.2609,2.4693,-0.1721,0.0412,3.4016,32.6248,27.7798,27.7798,25.4273,0.0512,10.9494,14.0740,21.4260,14.0740,383.4368,11.7469,1.1821,1.3038,65.4029,51.8015,38.1449,1.2939,2.4876,6.3896,2.5686,1.9226,4.9385,0.0000
 959.5000,2135.4932,-0.0290,2.4501,2.5487,2.5292,2.5036,2.4662,2.4522,2.5487,0.2613,2.4329,0.1798,0.3801,3.3563,33.3196,28.4847,28.4847,26.0810,0.0591,13.1599,16.2069,23.3764,16.2069,392.3633,11.8162,0.9720,1.2121,67.9198,52.0462,38.2296,1.2859,2.5221,6.4551,2.5594,1.9614,5.0200,0.0000
 960.0000,2077.2195,-0.0335,2.4206,2.5332,2.5123,2.4828,2.4406,2.4223,2.5332,0.2620,2.3859,0.3140,-0.1320,3.4140,32.5971,27.7519,27.7519,25.4014,0.0912,16.0038,18.9510,25.8857,18.9510,394.7633,11.8044,1.1892,1.1843,69.3312,52.4263,38.3074,1.2698,2.5668,6.5568,2.5545,2.0214,5.1636,0.0000
 960.5000,2056.4084,-0.0417,2.4013,2.5407,2.5196,2.4870,2.4369,2.4028,2.5407,0.2625,2.3603,0.2513,-0.7406,3.5499,33.8463,29.0206,29.0206,26.5773,0.1405,17.5576,20.4503,27.2567,20.4503,393.5962,11.9579,1.1085,1.3101,67.9492,51.2135,37.3764,1.2307,2.5188,6.4364,2.5553,2.0467,5.2299,0.0000
 961.0000,2084.7625,-0.0529,2.3952,2.5718,2.5520,2.5173,2.4592,2.3968,2.5718,0.2626,2.3508,0.0234,-0.5978,3.5423,35.0323,30.2330,30.2330,27.6981,0.1351,18.1309,21.0035,27.7626,21.0035,388.8300,12.1962,1.0022,1.1715,67.3648,53.1638,38.9175,1.2793,2.5986,6.7119,2.5829,2.0313,5.2466,1.6000
 961.5000,2087.0198,-0.0611,2.4147,2.6207,2.6033,2.5681,2.5071,2.4167,2.6207,0.2618,2.3388,-0.5081,-0.1296,3.4041,37.0355,32.2979,32.2979,29.6007,0.0921,18.8582,21.7052,28.4043,21.7053,381.5782,12.3044,1.1860,1.0115,67.1445,55.8810,41.0174,1.3544,2.7209,7.0452,2.5893,2.0090,5.2018,0.0000
 962.0000,2076.4131,-0.0582,2.2954,2.4818,2.4688,2.4372,2.3885,2.2969,2.4818,0.2614,2.2954,-0.9250,-0.2106,3.2986,39.1341,34.4840,34.4840,31.6064,0.0891,21.4892,24.2440,30.7258,24.2440,402.9301,12.8113,0.8762,0.9077,64.3162,57.2906,42.0571,1.3962,2.7911,7.1880,2.5753,1.9991,5.1481,0.0000
 962.5000,2041.3794,-0.0454,2.1145,2.2482,2.2394,2.2135,2.1874,2.1154,2.2482,0.2614,2.1925,-0.5810,-0.6666,3.2841,42.8302,38.3906,38.3906,35.1700,0.1338,27.7272,30.2631,36.2299,30.2631,444.7982,13.3056,0.5699,0.8853,63.8496,57.1802,42.0996,1.3958,2.7623,7.2037,2.6078,1.9790,5.1609,0.8000
 963.0000,2055.6033,-0.0155,1.9319,1.9732,1.9674,1.9474,1.9454,1.9328,1.9732,0.2622,2.0532,0.0818,-0.7708,3.2555,43.1971,38.7823,38.7823,35.5259,0.1780,36.1673,38.4071,43.6771,38.4071,506.7799,13.9637,0.5354,0.9092,67.1998,57.8240,42.7425,1.4129,2.7650,7.3335,2.6523,1.9569,5.1903,0.0000
 963.5000,2062.3748,-0.0085,1.9158,1.9383,1.9336,1.9189,1.9366,1.9168,1.9383,0.2608,1.9099,0.5123,-0.1503,3.0482,42.5645,38.1075,38.1075,34.9126,0.1775,44.8540,46.7889,51.3417,46.7889,515.9065,14.3246,0.5695,0.8948,70.4813,58.6597,43.6792,1.4335,2.7494,7.5433,2.7437,1.9179,5.2622,0.0000
 964.0000,2090.5669,0.0199,2.1706,2.1114,2.1036,2.0882,2.1287,2.1713,2.1114,0.2611,1.8691,0.7378,1.1010,2.9723,39.5323,34.9015,34.9015,31.9884,0.1616,47.3284,49.1765,53.5250,49.1765,473.6249,13.9887,0.4655,0.7265,71.5858,59.3385,44.0888,1.4488,2.7734,7.6052,2.7422,1.9143,5.2494,1.0000
 964.5000,2083.8301,0.0448,2.4231,2.2751,2.2611,2.2436,2.3010,2.4233,2.2751,0.2622,2.0410,0.6152,1.5257,3.3099,36.6440,31.8927,31.8927,29.2279,0.1589,36.9088,39.1225,44.3312,39.1225,439.5466,12.0270,0.6812,0.8091,68.4738,53.6449,40.0188,1.3192,2.4702,6.8832,2.7865,1.8725,5.2177,0.0000
 965.0000,2072.2439,0.0487,2.8953,2.7033,2.6730,2.6466,2.7190,2.8948,2.7033,0.2621,2.3249,0.1701,0.8795,3.7678,29.3207,24.4642,24.4642,22.3391,0.1295,19.7013,22.5188,29.1482,22.5188,369.9130,11.0891,0.9338,1.2059,59.1692,44.3051,33.1500,1.0835,2.0275,5.7458,2.8339,1.8713,5.3032,3.2000
 965.5000,2012.4033,0.0394,4.8819,4.6194,4.5121,4.4323,4.5640,4.8807,4.6194,0.2624,2.5428,-0.0788,0.5330,4.1570,19.8906,15.3332,15.3332,13.7083,0.0810,6.4997,9.7804,17.4997,9.7804,216.4762,10.4802,2.4319,2.0570,44.4953,35.0841,26.4572,0.8508,1.5912,4.6517,2.9234,1.8702,5.4674,3.2000
 966.0000,1961.0745,0.0098,8.2068,8.0970,7.7931,7.5896,7.7546,8.2055,8.0961,0.2601,2.6326,0.0008,0.4967,4.4397,14.9292,10.7315,10.7315,9.2791,0.0539,1.0526,4.5245,12.6935,4.5245,123.5018,9.9544,4.3817,3.4138,32.2473,27.3294,20.7212,0.6505,1.2379,3.7185,3.0039,1.9031,5.7166,1.6000
 966.5000,2049.5332,-0.0209,9.4728,9.7544,9.3948,9.1469,9.1930,9.4716,9.7475,0.2609,2.6484,0.0601,-0.0280,4.5949,13.9548,9.8446,9.8446,8.4185,0.0394,0.0945,3.6000,11.8481,3.6000,102.5183,9.8765,4.4169,3.6459,27.6695,23.8978,18.1520,0.5583,1.0877,3.3122,3.0451,1.9484,5.9330,0.8000
 967.0000,2109.8237,-0.0375,7.8220,8.2357,7.9322,7.7621,7.7725,7.8117,8.2295,0.2620,2.6566,-0.0086,-0.8163,4.6677,14.2350,10.0991,10.0991,8.6657,0.0267,-0.3985,3.1242,11.4130,3.1242,121.4221,9.8688,4.3374,4.4798,29.1157,22.9449,17.2976,0.5287,1.0621,3.1721,2.9866,2.0091,6.0004,0.0000
 967.5000,2114.3145,-0.0074,6.9208,6.9986,6.7292,6.6051,6.6538,6.9093,6.9915,0.2610,2.6526,-0.1961,-0.5307,4.5349,14.7027,10.5249,10.5249,9.0788,0.0177,-0.1568,3.3575,11.6263,3.3575,142.8849,9.9016,6.3924,3.4798,32.4008,24.1719,18.0182,0.5524,1.1419,3.2962,2.8865,2.0673,5.9673,3.2000
 968.0000,2137.2791,0.0243,6.4981,6.2900,6.0420,5.9372,6.0599,6.4883,6.2818,0.2628,2.6280,-0.1994,0.2923,4.2522,15.2218,10.9990,10.9990,9.5382,0.0114,1.3349,4.7969,12.9426,4.7969,158.9834,9.9516,3.2827,2.1544,32.5650,24.2552,17.7574,0.5546,1.1868,3.2002,2.6965,2.1401,5.7707,2.0000
 968.5000,2150.6841,0.0554,6.4398,5.9634,5.7215,5.6279,5.8308,6.4249,5.9546,0.2624,2.6071,0.1058,0.4153,4.0807,14.7491,10.5671,10.5671,9.1198,0.0071,2.6018,6.0192,14.0604,6.0192,167.6887,9.9651,4.4041,2.5388,29.5815,22.9853,16.5057,0.5227,1.1624,2.9405,2.5298,2.2240,5.6261,3.0000
 969.0000,2157.9395,0.0801,6.5621,5.8626,5.6217,5.5373,5.8015,6.5476,5.8526,0.2632,2.6012,0.2492,-0.0302,4.1055,14.0280,9.9109,9.9109,8.4830,0.0055,2.9557,6.3608,14.3727,6.3608,170.5741,9.9460,5.3581,3.5367,26.0984,20.8747,14.4641,0.4648,1.1131,2.5447,2.2863,2.3948,5.4752,1.0000
 969.5000,2123.2285,0.0933,7.0334,6.1643,5.9003,5.8126,6.1256,7.0193,6.1506,0.2631,2.6017,0.0544,-0.6398,4.2616,13.7545,9.6629,9.6629,8.2420,0.0081,2.9282,6.3342,14.3484,6.3342,162.2255,9.9397,8.0916,6.1611,24.0909,18.7611,12.2804,0.4019,1.0802,2.1261,1.9682,2.6880,5.2907,7.0000
 970.0000,2105.0549,0.0858,7.7445,6.8676,6.5509,6.4475,6.7997,7.7265,6.8482,0.2631,2.6005,-0.1503,-0.7581,4.3586,13.6689,9.5853,9.5853,8.1665,0.0124,3.0010,6.4045,14.4126,6.4045,145.6118,9.9902,11.2587,8.2176,24.8011,17.6114,10.8598,0.3678,1.0894,1.8213,1.6719,2.9620,4.9521,0.0000
 970.5000,2147.1257,0.0705,8.3680,7.5938,7.2247,7.1023,7.4850,8.3478,7.5694,0.2628,2.6022,0.0753,-0.3623,4.3752,13.1053,9.0758,9.0758,7.6707,0.0184,2.8974,6.3045,14.3212,6.3045,131.6859,9.9703,10.0952,7.8090,24.4335,17.0752,9.9348,0.3493,1.1239,1.6051,1.4281,3.2172,4.5945,2.0000
 971.0000,2117.0789,0.0652,9.6374,8.8186,8.3549,8.1947,8.6649,9.6082,8.7859,0.2623,2.6062,0.5403,0.2977,4.4639,13.0729,9.0465,9.0465,7.6422,0.0240,2.6533,6.0690,14.1058,6.0690,113.3963,9.9728,11.2849,9.6165,20.5248,17.6280,9.9561,0.3604,1.1957,1.5596,1.3043,3.3180,4.3277,2.0000
 971.5000,2109.9844,0.0788,11.6845,10.4825,9.8874,9.6673,10.3095,11.6338,10.4412,0.2616,2.6048,0.5995,0.3167,4.6809,12.0107,8.0914,8.0914,6.7105,0.0238,2.7421,6.1546,14.1842,6.1546,95.3970,9.9447,14.4546,13.5321,20.3482,19.9597,11.0314,0.4109,1.3800,1.6732,1.2125,3.3587,4.0723,4.0000
 972.0000,2117.8616,0.1073,11.9633,10.2784,9.7590,9.5492,10.1935,11.9172,10.2434,0.2631,2.6112,0.2724,-0.1467,5.0012,11.1813,7.3503,7.3503,5.9856,0.0217,2.3543,5.7804,13.8420,5.7804,97.2911,9.9473,16.0556,14.0612,27.5339,24.3932,13.3649,0.5045,1.6950,1.9954,1.1772,3.3599,3.9553,4.0000
 972.5000,2140.3540,0.0746,9.1409,8.2388,7.9282,7.7942,8.1394,9.1282,8.2183,0.2618,2.6279,-0.0152,0.4590,5.2366,11.0798,7.2599,7.2599,5.8971,0.0182,1.3412,4.8028,12.9481,4.8029,121.3769,9.8877,14.7247,12.3462,35.7679,31.4506,17.0375,0.6580,2.2050,2.4732,1.1216,3.3513,3.7588,6.0000
 973.0000,2104.3296,0.0343,6.1049,5.8264,5.6761,5.6161,5.7221,6.1008,5.8187,0.2610,2.6231,-0.1679,0.7312,5.0201,11.9800,8.0639,8.0639,6.6837,0.0116,1.6314,5.0829,13.2042,5.0829,171.6320,9.8051,13.8029,10.6942,45.5927,44.0740,23.8085,0.9329,3.0923,3.3925,1.0971,3.3149,3.6367,5.0000
 973.5000,2084.2441,0.0102,4.0204,3.9669,3.9015,3.8741,3.8955,4.0194,3.9641,0.2615,2.5968,-0.2870,0.0399,4.2896,13.9016,9.7962,9.7962,8.3715,0.0092,3.2249,6.6205,14.6102,6.6205,252.0876,9.7277,9.5932,5.8893,68.3231,61.9775,33.6425,1.3289,4.3477,4.7431,1.0909,3.2718,3.5693,2.0000
 974.0000,2095.8877,-0.0115,3.1098,3.1607,3.1269,3.1103,3.1084,3.1096,3.1593,0.2625,2.5825,-0.2333,-0.1960,3.6636,17.4443,13.0466,13.0466,11.5147,0.0125,4.0931,7.4583,15.3763,7.4583,316.3813,9.7092,4.2412,2.6947,104.3319,83.3632,45.8125,1.8021,5.8028,6.4942,1.1191,3.2200,3.6036,3.2000
 974.5000,2093.2043,0.0003,2.9654,2.9649,2.9458,2.9331,2.9224,2.9651,2.9642,0.2612,2.5863,-0.0299,0.1038,3.5398,19.3932,14.8655,14.8655,13.2608,0.0149,3.8577,7.2311,15.1685,7.2311,337.2829,9.7011,4.5966,3.0050,134.7609,99.4834,55.1930,2.1572,6.8827,7.8898,1.1463,3.1905,3.6574,0.8000
 975.0000,2144.4185,0.0010,2.8222,2.8187,2.8134,2.8041,2.7940,2.8222,2.8184,0.2608,2.5864,-0.1523,0.3788,3.5551,20.1355,15.5640,15.5640,13.9290,0.0137,3.8559,7.2294,15.1670,7.2294,354.7792,9.6995,4.9703,2.9862,143.2751,107.2052,59.5295,2.3218,7.4125,8.5333,1.1512,3.1926,3.6753,0.0000
 975.5000,2110.3994,0.0057,2.6543,2.6333,2.6382,2.6321,2.6291,2.6543,2.6333,0.2616,2.5776,-0.3013,-0.1307,3.4358,21.9512,17.2858,17.2858,15.5708,0.0109,4.3871,7.7420,15.6357,7.7420,379.7486,9.6928,3.3835,2.3715,139.1407,108.0178,59.9214,2.3565,7.4688,8.4970,1.1377,3.1694,3.6057,1.6000
 976.0000,2138.1194,0.0138,2.5422,2.4939,2.5045,2.5005,2.5066,2.5422,2.4939,0.2621,2.5723,-0.0513,-0.8181,3.3087,23.1152,18.3995,18.3995,16.6287,0.0089,4.7103,8.0538,15.9208,8.0538,400.9708,9.6864,3.6935,2.1699,134.7092,104.3067,57.9572,2.3069,7.2025,8.0875,1.1229,3.1222,3.5058,1.6000
 976.5000,2091.6265,0.0213,2.4330,2.3621,2.3759,2.3733,2.3862,2.4330,2.3621,0.2616,2.5612,0.0328,-0.3791,3.2627,23.6597,18.9230,18.9230,17.1250,0.0076,5.3821,8.7020,16.5136,8.7021,423.3593,9.7335,3.0534,2.0087,126.8963,100.2917,55.8932,2.2605,6.9171,7.6298,1.1030,3.0600,3.3753,1.6000
 977.0000,1998.4338,0.0254,2.3920,2.3088,2.3245,2.3222,2.3386,2.3920,2.3088,0.2611,2.5429,-0.1252,0.2437,3.2637,24.3555,19.5945,19.5945,17.7606,0.0059,6.4916,9.7725,17.4925,9.7726,433.1246,9.6395,2.9794,1.9243,119.3876,95.7896,54.0542,2.2080,6.5337,7.2750,1.1135,2.9591,3.2949,4.8000
 977.5000,2073.5911,0.0263,2.4082,2.3214,2.3380,2.3352,2.3526,2.4082,2.3214,0.2615,2.5363,-0.1017,0.1787,3.2821,24.0184,19.2688,19.2688,17.4525,0.0044,6.8909,10.1579,17.8449,10.1579,430.7814,9.6160,3.0815,1.8767,115.6886,89.8475,51.4122,2.1053,6.0308,6.8946,1.1432,2.8646,3.2749,2.4000
 978.0000,2164.7920,0.0234,2.4245,2.3467,2.3628,2.3588,2.3733,2.4245,2.3467,0.2613,2.5478,-0.0580,0.2802,3.2885,23.9544,19.2071,19.2071,17.3941,0.0054,6.1910,9.4825,17.2273,9.4825,426.1276,9.6163,3.0098,2.0548,108.1942,85.5676,49.6567,2.0309,5.6489,6.6710,1.1809,2.7814,3.2847,3.2000
 978.5000,2203.9026,0.0148,2.4685,2.4183,2.4329,2.4267,2.4325,2.4685,2.4183,0.2622,2.5620,-0.1189,0.2044,3.3217,23.2567,18.5354,18.5354,16.7576,0.0074,5.3342,8.6558,16.4714,8.6558,413.5062,9.6439,2.8209,1.8595,98.7137,79.2751,46.3937,1.8875,5.1733,6.2797,1.2139,2.7408,3.3269,0.0000
 979.0000,2133.9502,0.0034,2.6187,2.6064,2.6188,2.6095,2.6012,2.6187,2.6064,0.2615,2.5707,-0.0578,-0.0427,3.4499,21.5279,16.8827,16.8827,15.1871,0.0083,4.8089,8.1489,16.0079,8.1489,383.6713,9.6365,3.1741,2.2337,91.4816,73.3324,43.1774,1.7553,4.7520,5.8511,1.2313,2.7072,3.3334,1.6000
 979.5000,2161.1526,-0.0077,2.7561,2.7855,2.7930,2.7806,2.7568,2.7561,2.7855,0.2623,2.5781,0.0874,0.0686,3.5683,20.1481,15.5759,15.5759,13.9404,0.0093,4.3606,7.7163,15.6123,7.7163,359.0009,9.6525,3.8761,2.6213,84.6234,68.8195,41.0360,1.6663,4.4054,5.5698,1.2643,2.6437,3.3425,4.0000
 980.0000,2158.1125,-0.0127,2.7647,2.8133,2.8143,2.7995,2.7655,2.7647,2.8133,0.2613,2.5794,0.0921,0.1353,3.5723,20.3598,15.7757,15.7757,14.1313,0.0095,4.2790,7.6376,15.5403,7.6376,355.4593,9.6430,3.6648,2.3578,81.0921,64.8376,39.2149,1.5917,4.0990,5.3261,1.2994,2.5753,3.3463,0.8000
 980.5000,2137.4399,-0.0121,2.7587,2.8048,2.7988,2.7822,2.7439,2.7587,2.8048,0.2617,2.5743,0.0677,0.2636,3.5688,21.6143,16.9649,16.9649,15.2654,0.0075,4.5906,7.9383,15.8152,7.9383,356.5274,9.6341,3.9012,2.4705,81.4204,63.7089,39.4704,1.5942,3.9297,5.3979,1.3736,2.4649,3.3859,0.0000
 981.0000,2150.9373,-0.0086,2.7229,2.7555,2.7422,2.7243,2.6876,2.7229,2.7555,0.2615,2.5715,0.1923,0.1689,3.6039,21.9221,17.2581,17.2581,15.5444,0.0057,4.7567,8.0985,15.9618,8.0985,362.9140,9.5835,3.7538,2.3372,83.3458,63.1911,40.1749,1.6127,3.7906,5.5417,1.4620,2.3505,3.4364,1.0000
 981.5000,2209.7532,-0.0054,2.7496,2.7700,2.7491,2.7296,2.6952,2.7494,2.7700,0.2616,2.5728,0.2674,0.0732,3.6053,22.5133,17.8226,17.8226,16.0811,0.0051,4.6779,8.0225,15.8923,8.0225,361.0124,9.5869,3.0814,2.4302,83.7428,63.1650,40.9284,1.6342,3.6994,5.6868,1.5372,2.2637,3.4798,2.0000
 982.0000,2204.1218,-0.0036,2.8051,2.8189,2.7899,2.7681,2.7347,2.8050,2.8189,0.2630,2.5693,0.1945,0.1329,3.6011,22.1821,17.5062,17.5062,15.7803,0.0051,4.8935,8.2306,16.0825,8.2306,354.7513,9.5902,3.9092,2.4014,80.8744,63.3982,41.5918,1.6557,3.6729,5.8029,1.5799,2.2184,3.5048,4.0000
 982.5000,2125.7849,-0.0060,2.8135,2.8369,2.8005,2.7766,2.7411,2.8136,2.8369,0.2616,2.5672,0.0536,-0.2067,3.6437,22.0325,17.3634,17.3634,15.6445,0.0074,5.0156,8.3484,16.1903,8.3484,352.5014,9.5927,3.2939,2.2441,77.9971,61.1945,40.4404,1.6039,3.5299,5.6707,1.6065,2.2009,3.5357,2.0000
 983.0000,2110.7786,-0.0194,2.9588,3.0381,2.9911,2.9615,2.9112,2.9601,3.0381,0.2605,2.5808,-0.0720,-0.0896,3.7321,20.9698,16.3529,16.3529,14.6821,0.0078,4.1955,7.5571,15.4666,7.5571,329.1507,9.5938,3.0156,2.1497,73.5602,56.7595,37.9166,1.5034,3.2393,5.3186,1.6419,2.1546,3.5377,1.0000
 983.5000,2120.6721,-0.0467,3.5785,3.8111,3.7423,3.7002,3.6073,3.5865,3.8111,0.2604,2.6021,0.0621,0.3927,3.8859,17.4801,13.0797,13.0797,11.5466,0.0032,2.9025,6.3094,14.3257,6.3095,262.3932,9.5779,3.6442,2.6408,64.0084,50.2584,33.9663,1.3450,2.8273,4.7729,1.6882,2.1021,3.5487,3.0000
 984.0000,2105.6545,-0.0742,4.3378,4.7883,4.6945,4.6386,4.4936,4.3571,4.7883,0.2625,2.6206,0.2499,0.1277,4.0862,15.2999,11.0704,11.0704,9.6073,0.0018,1.7848,5.2309,13.3395,5.2309,208.8422,9.5569,5.3147,3.9537,56.9271,45.7599,31.3186,1.2377,2.5231,4.4122,1.7487,2.0384,3.5647,1.0000
 984.5000,2022.1239,-0.0813,4.2390,4.7218,4.6262,4.5710,4.4180,4.2566,4.7218,0.2623,2.6275,0.0253,-0.5243,4.1559,14.8300,10.6410,10.6410,9.1914,0.0042,1.3630,4.8240,12.9674,4.8240,211.7843,9.5685,9.9140,6.2997,57.8907,46.6108,32.4412,1.2733,2.4981,4.6122,1.8463,1.9619,3.6223,2.0000
 985.0000,2076.7705,-0.0666,3.5114,3.8381,3.7620,3.7198,3.6046,3.5186,3.8381,0.2627,2.6106,-0.2017,-0.6440,3.9567,16.4132,12.0930,12.0930,10.5957,0.0038,2.3849,5.8100,13.8691,5.8100,260.5426,9.5998,7.1583,4.4497,66.0301,50.8336,36.0756,1.4053,2.6408,5.1796,1.9613,1.8793,3.6859,5.0000
 985.5000,2139.7207,-0.0469,3.0058,3.2020,3.1425,3.1111,3.0300,3.0079,3.2020,0.2637,2.5839,-0.0550,-0.0448,3.6912,20.2310,15.6541,15.6541,14.0151,0.0016,4.0036,7.3719,15.2973,7.3719,312.3041,9.6750,3.6030,2.2105,75.2563,55.3239,39.9638,1.5515,2.7880,5.7627,2.0670,1.7970,3.7143,2.0000
 986.0000,2140.7341,-0.0335,2.7833,2.9126,2.8640,2.8395,2.7797,2.7840,2.9126,0.2617,2.5687,-0.0467,0.5416,3.5851,21.4297,16.7894,16.7894,15.0981,0.0007,4.9260,8.2619,16.1111,8.2619,343.3351,9.7357,2.6424,2.0190,80.6415,57.5467,42.0588,1.6265,2.8277,6.0945,2.1553,1.7385,3.7469,3.0000
 986.5000,2134.4797,-0.0273,2.7342,2.8376,2.7967,2.7766,2.7277,2.7349,2.8376,0.2611,2.5620,-0.1498,0.5537,3.5492,21.7007,17.0472,17.0472,15.3436,0.0007,5.3347,8.6563,16.4718,8.6563,352.4100,9.7405,2.7953,2.1773,80.4122,57.9490,42.5290,1.6388,2.8074,6.1907,2.2052,1.7130,3.7775,0.0000
 987.0000,2094.7361,-0.0250,2.7125,2.8064,2.7729,2.7565,2.7146,2.7134,2.8064,0.2611,2.5575,-0.0229,0.3686,3.5074,21.9826,17.3157,17.3157,15.5992,0.0012,5.6081,8.9201,16.7130,8.9201,356.3231,9.7407,2.6180,2.4012,78.4664,59.1238,43.5206,1.6623,2.8292,6.4049,2.2638,1.7020,3.8530,1.6000
 987.5000,2101.8418,-0.0222,2.6747,2.7571,2.7313,2.7182,2.6830,2.6753,2.7571,0.2615,2.5539,0.0563,0.3465,3.4909,22.1201,17.4470,17.4470,15.7240,0.0016,5.8237,9.1281,16.9032,9.1281,362.6940,9.6673,3.1548,2.5084,79.3398,61.6830,45.3830,1.7213,2.9494,6.7365,2.2840,1.7134,3.9135,0.8000
 988.0000,2112.1956,-0.0165,2.6081,2.6676,2.6493,2.6393,2.6121,2.6082,2.6676,0.2603,2.5523,0.1037,0.2553,3.5085,22.7121,18.0130,18.0130,16.2619,0.0031,5.9191,9.2202,16.9875,9.2202,374.8694,9.6614,2.9274,2.2790,81.2223,64.5251,47.4037,1.7916,3.0965,7.0668,2.2822,1.7284,3.9445,1.6000
 988.5000,2111.4128,-0.0091,2.5273,2.5590,2.5476,2.5403,2.5216,2.5273,2.5590,0.2618,2.5540,0.3167,-0.0938,3.5357,23.8835,19.1387,19.1387,17.3293,0.0068,5.8153,9.1200,16.8959,9.1201,390.7740,9.6816,2.7863,2.1509,83.2030,66.0347,48.2809,1.8293,3.2039,7.1760,2.2398,1.7515,3.9229,0.8000
 989.0000,2119.0247,-0.0017,2.4688,2.4746,2.4690,2.4639,2.4530,2.4688,2.4746,0.2633,2.5566,0.4339,-0.2137,3.5041,24.3312,19.5710,19.5710,17.7384,0.0099,5.6607,8.9708,16.7594,8.9708,404.0998,9.6855,2.6921,1.9271,84.6296,65.9809,48.0870,1.8354,3.2456,7.0834,2.1825,1.7684,3.8594,1.6000
 989.5000,2069.0891,0.0046,2.4104,2.3951,2.3941,2.3908,2.3866,2.4104,2.3951,0.2619,2.5583,0.4115,-0.4782,3.4771,24.8176,20.0419,20.0419,18.1835,0.0113,5.5557,8.8695,16.6668,8.8695,417.5254,9.6682,3.2725,1.9383,86.0589,65.3498,47.7984,1.8254,3.2236,7.0357,2.1825,1.7659,3.8542,1.6000
 990.0000,2097.0283,0.0044,2.3556,2.3412,2.3435,2.3416,2.3426,2.3556,2.3412,0.2619,2.5547,0.2363,-1.0610,3.5067,25.8048,21.0018,21.0018,19.0893,0.0117,5.7736,9.0798,16.8590,9.0798,427.1284,9.7116,2.9826,2.0394,88.6445,65.6104,48.5523,1.8521,3.1899,7.1567,2.2436,1.7223,3.8641,1.6000
 990.5000,2094.2761,0.0123,2.3683,2.3282,2.3326,2.3316,2.3364,2.3683,2.3282,0.2612,2.5476,-0.1627,-0.4744,3.4956,25.5660,20.7691,20.7691,18.8699,0.0104,6.2045,9.4955,17.2392,9.4955,429.5190,9.7189,3.1887,2.0703,87.9914,66.2876,49.9170,1.8897,3.1220,7.4267,2.3788,1.6521,3.9301,2.4000
 991.0000,2120.7756,0.0141,2.3655,2.3196,2.3253,2.3249,2.3311,2.3655,2.3196,0.2608,2.5419,-0.2022,0.5886,3.4395,25.5544,20.7578,20.7578,18.8592,0.0075,6.5536,9.8324,17.5473,9.8324,431.1083,9.7305,3.1655,2.0289,84.2620,67.4436,51.4539,1.9279,3.0879,7.7500,2.5098,1.6017,4.0199,0.8000
 991.5000,2111.7007,0.0124,2.3537,2.3137,2.3196,2.3197,2.3231,2.3537,2.3137,0.2613,2.5363,0.2039,0.5265,3.4140,25.7387,20.9373,20.9373,19.0285,0.0045,6.8931,10.1600,17.8468,10.1600,432.2093,9.7141,3.0779,2.0464,83.6009,68.6586,52.8785,1.9697,3.0710,8.0197,2.6114,1.5592,4.0717,0.0000
 992.0000,2104.9290,0.0132,2.3786,2.3355,2.3408,2.3412,2.3469,2.3786,2.3355,0.2624,2.5337,0.2289,0.1246,3.4143,25.9379,21.1316,21.1316,19.2116,0.0022,7.0489,10.3104,17.9843,10.3104,428.1823,9.7247,3.1522,2.0607,85.9340,68.4048,52.9182,1.9588,3.0274,8.0841,2.6703,1.5455,4.1270,1.6000
 992.5000,2153.3564,0.0114,2.4097,2.3717,2.3754,2.3759,2.3798,2.4097,2.3717,0.2619,2.5323,-0.1841,0.0833,3.4179,25.4134,20.6206,20.6206,18.7298,0.0006,7.1348,10.3932,18.0601,10.3932,421.6317,9.7338,3.4042,2.1089,87.1857,67.0915,52.0797,1.9180,2.9493,8.0024,2.7133,1.5377,4.1722,0.8000
 993.0000,2086.9736,0.0071,2.4189,2.3952,2.3959,2.3963,2.3981,2.4189,2.3952,0.2616,2.5345,-0.3749,-0.0673,3.4533,24.8305,20.0545,20.0545,18.1954,0.0007,6.9976,10.2608,17.9391,10.2608,417.4947,9.7264,3.6250,2.4280,87.2910,66.1622,51.3513,1.8853,2.9066,7.9183,2.7242,1.5417,4.2000,0.0000
 993.5000,2100.0681,-0.0011,2.3941,2.3977,2.3935,2.3930,2.3936,2.3940,2.3977,0.2610,2.5364,-0.2374,-0.2870,3.4761,24.9340,20.1548,20.1548,18.2902,0.0013,6.8821,10.1493,17.8371,10.1494,417.0725,9.7190,3.7968,2.1561,87.4061,65.4258,50.4669,1.8518,2.9122,7.7869,2.6739,1.5727,4.2051,1.6000
 994.0000,2106.7825,-0.0042,2.3908,2.4046,2.3940,2.3915,2.3902,2.3900,2.4046,0.2618,2.5292,-0.1369,-0.2169,3.4273,26.3590,21.5430,21.5430,19.5989,0.0010,7.3239,10.5757,18.2269,10.5757,415.8713,9.7216,3.2026,1.9033,86.6067,65.6842,49.9082,1.8389,3.0122,7.6647,2.5445,1.6381,4.1681,0.0000
 994.5000,2133.0527,0.0039,2.4768,2.4635,2.4441,2.4378,2.4313,2.4764,2.4635,0.2621,2.5303,-0.2501,0.0000,3.3429,25.7686,20.9664,20.9664,19.0559,0.0008,7.2515,10.5059,18.1631,10.5059,405.9343,9.7368,3.1841,1.8747,86.4060,65.2137,48.7983,1.8080,3.0691,7.4466,2.4263,1.6975,4.1186,0.0000
 995.0000,2142.3457,-0.0011,2.6233,2.6274,2.5951,2.5818,2.5628,2.6269,2.6274,0.2612,2.5468,-0.2409,0.4002,3.3695,25.2169,20.4295,20.4295,18.5494,-0.0005,6.2567,9.5459,17.2853,9.5459,380.6032,9.7496,3.0997,1.9556,83.3966,60.9452,44.9285,1.6854,2.9300,6.7577,2.3064,1.7384,4.0095,0.8000
 995.5000,2131.9470,-0.0246,2.8262,2.9227,2.8712,2.8455,2.8003,2.8456,2.9227,0.2619,2.5598,0.1169,0.5828,3.5417,21.5393,16.8936,16.8936,15.1974,-0.0032,5.4649,8.7819,16.5867,8.7819,342.1548,9.7073,3.0997,2.4697,75.3794,55.1515,40.5272,1.5243,2.6538,6.0767,2.2898,1.7410,3.9865,0.0000
 996.0000,2143.6008,-0.0646,3.0234,3.2964,3.2215,3.1780,3.0867,3.0782,3.2964,0.2627,2.5742,0.3801,0.0242,3.7756,18.2187,13.7667,13.7667,12.2070,-0.0033,4.5931,7.9407,15.8174,7.9407,303.3624,9.6147,3.5028,2.0348,63.8924,47.6913,35.0796,1.3218,2.2873,5.2487,2.2947,1.7305,3.9710,1.6000
 996.5000,2058.8625,-0.1188,3.7992,4.4348,4.3091,4.2266,4.0302,3.9091,4.4348,0.2610,2.6008,0.3086,-0.4970,3.9872,15.5307,11.2818,11.2818,9.8119,0.0008,2.9811,6.3852,14.3951,6.3852,225.4870,9.5704,14.8785,9.1950,53.2691,42.3809,31.3195,1.1778,2.0201,4.6968,2.3250,1.7151,3.9876,0.0000
 997.0000,1982.9437,-0.1433,4.4746,5.3801,5.2037,5.0756,4.7547,4.4857,5.3801,0.2609,2.6205,0.2139,-0.6485,4.0179,13.6000,9.5229,9.5229,8.1059,0.0034,1.7860,5.2321,13.3406,5.2321,185.8692,9.5703,14.9087,8.7912,50.6354,41.0441,30.5941,1.1489,1.9158,4.5959,2.3990,1.6675,4.0003,2.4000
 997.5000,1982.8065,-0.2038,4.0021,5.1590,4.9730,4.8248,4.4442,4.0764,5.1590,0.2623,2.6190,0.0094,-0.4521,3.9708,15.2415,11.0170,11.0170,9.5556,0.0014,1.8809,5.3237,13.4243,5.3237,193.8360,9.5663,3.1821,2.6860,53.3583,44.3446,33.2861,1.2598,2.0233,4.9535,2.4483,1.6060,3.9319,2.0000
 998.0000,2007.6932,-0.2721,3.3405,4.6318,4.4576,4.3056,3.9138,3.4737,4.6318,0.2609,2.5891,-0.4047,0.0289,3.8869,17.4371,13.0398,13.0398,11.5082,0.0025,3.6921,7.0713,15.0225,7.0713,215.8988,9.5540,13.7076,6.6936,61.5558,50.5069,38.2580,1.4515,2.2381,5.6768,2.5364,1.5419,3.9109,0.0000
 998.5000,2052.1245,-0.3242,2.7090,3.9547,3.8078,3.6664,3.3057,2.8599,3.9547,0.2608,2.5174,-0.5363,-0.4154,3.7236,23.7539,19.0137,19.0137,17.2109,0.0255,8.0366,11.2634,18.8558,11.2634,252.8624,9.6694,5.9036,1.6773,74.1473,57.2115,43.9320,1.6608,2.4476,6.5472,2.6749,1.4738,3.9422,6.0000
 999.0000,2095.5076,-0.3242,2.7090,3.9547,3.8078,3.6664,3.3057,2.8599,3.9547,0.2608,2.3791,-0.4211,-1.1094,3.6017,32.2122,27.3626,27.3626,25.0400,0.0826,16.4182,19.3508,26.2513,19.3509,252.8624,9.8243,2.6432,1.3573,80.0893,61.0852,47.4190,1.7857,2.5502,7.0998,2.7840,1.4281,3.9760,8.0000
 999.5000,2141.7822,-0.3359,1.7894,2.6412,2.5545,2.4548,2.2079,1.9067,2.6412,0.2632,2.2139,-0.3946,-0.2306,3.4854,39.0807,34.4282,34.4282,31.5552,0.1443,26.4296,29.0110,35.0850,29.0110,378.6105,10.0940,1.4820,0.7618,78.1621,62.0652,48.6936,1.8197,2.5013,7.3569,2.9412,1.3746,4.0429,3.2000
 1000.0000,2117.4128,-0.2989,1.3808,1.9667,1.9166,1.8427,1.6651,1.4586,1.9667,0.2615,2.1406,-0.4153,0.5489,3.3737,41.8147,37.3102,37.3102,34.1870,0.1553,30.8743,33.2998,39.0067,33.2998,508.4569,11.0298,0.7034,0.7228,77.8963,63.0082,49.8696,1.8720,2.4505,7.4948,3.0585,1.3090,4.0036,4.0000
 1000.5000,2149.3367,-0.2780,1.4347,2.0014,1.9621,1.8889,1.7148,1.5053,2.0014,0.2615,2.1527,-0.2179,0.1854,3.2949,43.8237,39.4529,39.4529,36.1346,0.1282,30.1372,32.5885,38.3563,32.5885,499.6592,11.6956,0.9082,0.8050,78.9598,64.2150,51.0394,1.9274,2.4384,7.6163,3.1235,1.2651,3.9516,1.6000
 1001.0000,2125.9233,-0.2615,1.5042,2.0631,2.0345,1.9627,1.7927,1.5736,2.0631,0.2604,2.1672,0.3180,0.2172,3.2532,40.7529,36.1862,36.1862,33.1623,0.1130,29.2635,31.7455,37.5854,31.7455,484.7103,11.7289,0.7110,0.8861,78.9651,65.2236,51.7685,1.9697,2.4646,7.6548,3.1059,1.2512,3.8862,4.0000
 1001.5000,2119.7163,-0.2392,1.5300,2.0499,2.0331,1.9668,1.8125,1.5977,2.0499,0.2603,2.1752,0.6453,0.1299,3.2446,40.9776,36.4236,36.4236,33.3789,0.1023,28.7776,31.2766,37.1567,31.2766,487.8242,11.5125,0.8807,0.8718,78.6216,65.0950,51.6564,1.9746,2.4524,7.5949,3.0970,1.2420,3.8463,3.2000
 1002.0000,2115.2131,-0.2020,1.5405,1.9820,1.9761,1.9183,1.7911,1.6037,1.9820,0.2625,2.1782,0.5540,-0.2764,3.2248,41.2656,36.7282,36.7282,33.6567,0.0839,28.5943,31.0998,36.9950,31.0998,504.5353,11.6758,0.5939,0.8434,77.6777,65.5311,52.0526,1.9957,2.4482,7.6249,3.1145,1.2267,3.8206,4.0000
 1002.5000,2147.2405,-0.1549,1.4833,1.8082,1.8110,1.7649,1.6775,1.5445,1.8082,0.2619,2.1882,0.3916,0.0250,3.2425,40.2826,35.6903,35.6903,32.7095,0.0650,27.9901,30.5168,36.4619,30.5168,553.0314,12.3352,0.7785,0.8703,75.9986,66.6518,53.0514,2.0437,2.4559,7.7252,3.1455,1.2017,3.7800,4.0000
 1003.0000,2153.1831,-0.0966,1.5384,1.7471,1.7557,1.7178,1.6666,1.5880,1.7471,0.2619,2.2137,0.2541,0.6425,3.2736,38.8058,34.1405,34.1405,31.2917,0.0463,26.4452,29.0261,35.0987,29.0261,572.3691,13.1067,0.8263,0.8128,73.6102,69.5463,55.4515,2.1424,2.5344,8.0453,3.1745,1.1830,3.7553,2.4000
 1003.5000,2129.4470,-0.0422,1.7474,1.8500,1.8625,1.8292,1.8096,1.7829,1.8500,0.2621,2.2679,0.0245,0.5918,3.3432,35.5138,30.7275,30.7275,28.1544,0.0371,23.1576,25.8538,32.1978,25.8538,540.5494,13.5426,0.4754,0.8418,75.0975,72.5820,58.2544,2.2499,2.5764,8.4555,3.2819,1.1451,3.7582,4.0000
 1004.0000,2133.4204,-0.0013,2.0065,2.0099,2.0234,1.9938,2.0033,2.0310,2.0099,0.2611,2.3612,-0.4631,0.2685,3.5446,33.8639,29.0386,29.0386,26.5939,0.0426,17.5020,20.3966,27.2076,20.3966,497.5307,13.5858,0.5103,0.7305,79.4826,73.1235,59.2052,2.2719,2.5140,8.6633,3.4460,1.1066,3.8132,0.8000
 1004.5000,2114.5449,0.0272,2.2381,2.1546,2.1665,2.1400,2.1716,2.2534,2.1546,0.2611,2.4315,-0.6886,0.2162,3.6260,30.8125,25.9538,25.9538,23.7294,0.0590,13.2399,16.2841,23.4470,16.2841,464.1282,12.0885,0.7557,0.7252,82.9113,68.7341,55.9434,2.1346,2.3182,8.2437,3.5561,1.0860,3.8620,2.4000
 1005.0000,2133.2820,0.0401,2.4680,2.3327,2.3387,2.3124,2.3555,2.4752,2.3327,0.2613,2.4651,-0.1104,0.0331,3.5920,28.4436,23.5941,23.5941,21.5249,0.0727,11.2053,14.3209,21.6517,14.3209,428.6795,10.3713,0.8729,0.8779,81.9495,59.5468,48.1629,1.8297,2.0542,7.1350,3.4734,1.1227,3.8995,3.2000
 1005.5000,2145.6165,0.0339,3.0019,2.8626,2.8542,2.8182,2.8651,3.0039,2.8626,0.2613,2.5156,0.3469,0.0083,3.7879,23.8618,19.1178,19.1178,17.3095,0.0595,8.1485,11.3713,18.9545,11.3713,349.3275,10.1491,2.0827,1.7535,69.6265,49.0977,38.5928,1.4676,1.8508,5.7106,3.0855,1.2611,3.8912,1.6000
 1006.0000,2162.5122,0.0065,4.3998,4.3602,4.3051,4.2308,4.2641,4.4024,4.3602,0.2612,2.5817,0.1954,0.1736,4.1251,17.5100,13.1075,13.1075,11.5733,0.0301,4.1417,7.5051,15.4191,7.5051,229.3479,9.7933,2.9808,3.5713,49.0410,37.5043,27.9910,1.0677,1.6002,4.1263,2.5786,1.4987,3.8646,2.4000
 1006.5000,2149.4976,-0.0309,6.9606,7.2595,7.1048,6.9636,6.9000,6.9708,7.2595,0.2615,2.6394,0.1377,0.2118,4.4844,13.0788,9.0518,9.0518,7.6474,0.0226,0.6404,4.1267,12.3297,4.1267,137.7497,9.6055,9.4433,6.9703,33.2689,29.0951,20.2672,0.7687,1.4198,3.0083,2.1189,1.8469,3.9134,2.0000
 1007.0000,2133.8816,-0.0587,8.7233,9.4384,9.1604,8.9640,8.7825,8.7406,9.4384,0.2623,2.6768,0.0731,0.0946,4.8080,12.4233,8.4616,8.4616,7.0720,0.0333,-1.6229,1.9428,10.3327,1.9428,105.9502,9.3853,13.3599,9.1635,27.4866,25.7380,16.6509,0.6299,1.4132,2.4792,1.7544,2.2433,3.9357,3.0000
 1007.5000,2142.5078,-0.0685,9.0305,9.8949,9.5121,9.2762,9.0113,9.0512,9.8949,0.2607,2.6791,-0.0951,-0.0585,4.8235,12.6717,8.6850,8.6850,7.2899,0.0311,-1.7624,1.8082,10.2097,1.8082,101.0620,9.3889,9.8549,7.4561,27.5178,25.3388,15.1969,0.5710,1.5370,2.2814,1.4844,2.6918,3.9955,2.0000
 1008.0000,2113.9805,-0.0693,9.1824,10.0716,9.5987,9.3310,9.0363,9.2023,10.0716,0.2610,2.6600,-0.0873,0.0855,4.6050,12.0506,8.1272,8.1272,6.7455,0.0194,-0.6031,2.9268,11.2325,2.9268,99.2893,9.3938,9.4758,7.5565,29.3888,24.1896,13.4179,0.4995,1.6066,2.0364,1.2675,3.2163,4.0768,2.0000
 1008.5000,2118.4612,-0.0695,10.0339,11.0082,10.4098,10.0874,9.7714,10.0562,11.0082,0.2614,2.6517,-0.2197,0.2908,4.4772,10.3966,6.6528,6.6528,5.3018,0.0123,-0.1036,3.4088,11.6733,3.4088,90.8412,9.3171,13.0667,11.1660,28.2084,21.6489,11.0364,0.4104,1.5613,1.6771,1.0742,3.8043,4.0865,1.0000
 1009.0000,2116.3997,-0.0657,11.6445,12.7129,11.9360,11.5194,11.2073,11.6714,12.7129,0.2610,2.6558,-0.3602,0.1899,4.4855,8.9165,5.3473,5.3473,4.0176,0.0075,-0.3502,3.1709,11.4557,3.1709,78.6605,9.2684,16.6878,14.5848,25.1669,19.8529,9.2982,0.3472,1.5324,1.4061,0.9176,4.4136,4.0498,3.0000
 1009.5000,2065.1157,-0.0573,13.0361,14.0773,13.1321,12.6071,12.4040,13.0555,14.0773,0.2612,2.6571,-0.2333,-0.0608,4.5404,8.3303,4.8337,4.8337,3.5109,0.0025,-0.4278,3.0959,11.3872,3.0959,71.0361,9.2069,20.3243,17.0056,25.8013,21.8006,9.3313,0.3540,1.7923,1.3846,0.7725,5.0625,3.9109,2.0000
 1010.0000,2075.1006,-0.0850,11.6611,13.0503,12.1636,11.6922,11.6874,11.6859,13.0503,0.2621,2.6512,-0.1015,-0.3189,4.5523,8.4701,4.9560,4.9560,3.6317,0.0001,-0.0729,3.4384,11.7004,3.4385,76.6265,9.2106,17.1643,14.0145,31.9948,28.5869,11.4060,0.4383,2.4547,1.6660,0.6787,5.6002,3.8007,4.0000
 1010.5000,2122.0657,-0.0376,11.5348,12.1374,11.3278,10.9033,11.0268,11.5606,12.1374,0.2599,2.6433,0.1068,-0.2085,4.4979,8.8059,5.2502,5.2502,3.9219,0.0029,0.4079,3.9023,12.1246,3.9023,82.3903,9.1884,13.5344,11.0175,45.0128,41.5327,15.4930,0.5978,3.7033,2.2515,0.6080,6.1951,3.7664,4.0000
 1011.0000,2164.6077,-0.0217,11.7128,12.0654,11.2704,10.8379,11.0258,11.7402,12.0654,0.2610,2.6403,0.3212,0.0389,4.4819,9.1616,5.5625,5.5625,4.2297,0.0080,0.5867,4.0748,12.2823,4.0749,82.8818,9.1574,13.0418,11.0533,70.6918,58.2587,20.5014,0.7937,5.3551,2.9668,0.5540,6.7470,3.7379,4.0000
 1011.5000,2136.7258,-0.0364,11.6738,12.2642,11.5026,11.0506,11.2199,11.6992,12.2642,0.2610,2.6384,0.3153,-0.1343,4.5136,8.8649,5.3019,5.3019,3.9729,0.0110,0.7060,4.1900,12.3877,4.1900,81.5383,9.0931,13.6518,11.4141,98.8431,71.4060,24.4432,0.9545,6.6622,3.4982,0.5251,6.9797,3.6649,0.0000
 1012.0000,2146.9648,-0.0660,11.5212,12.5830,11.8841,11.4597,11.5373,11.5452,12.5830,0.2613,2.6424,0.2238,-0.1596,4.5274,8.1814,4.7037,4.7037,3.3824,0.0120,0.4617,3.9543,12.1721,3.9543,79.4723,9.0234,17.3227,16.7845,106.4731,78.7246,27.0222,1.0708,7.3617,3.7932,0.5153,6.8747,3.5423,0.8000
 1012.5000,2153.1831,-0.0667,10.4491,11.4223,10.8928,10.5596,10.5492,10.4674,11.4223,0.2613,2.6548,-0.0480,-0.1521,4.5002,8.4207,4.9128,4.9128,3.5890,0.0122,-0.2909,3.2280,11.5080,3.2281,87.5483,8.9774,23.4264,21.0315,103.0676,82.2585,28.5614,1.1436,7.6936,3.9535,0.5139,6.7276,3.4571,2.4000
 1013.0000,2151.6863,-0.0578,7.7899,8.4175,8.1008,7.8874,7.8673,7.7965,8.4175,0.2616,2.6481,-0.1883,-0.3671,4.3811,10.4410,6.6922,6.6922,5.3405,0.0116,0.1164,3.6211,11.8674,3.6211,118.7995,9.0159,16.5166,12.6783,109.8715,84.5618,30.0446,1.2084,7.8516,4.1333,0.5264,6.4977,3.4206,1.6000
 1013.5000,2175.4797,-0.0337,5.5214,5.7796,5.6139,5.4926,5.4834,5.5241,5.7796,0.2607,2.6229,0.1004,-0.4256,4.2217,13.6768,9.5925,9.5925,8.1735,0.0106,1.6413,5.0925,13.2129,5.0925,173.0236,9.0430,8.0754,5.6872,122.2310,91.2617,32.6411,1.3161,8.4721,4.4748,0.5282,6.4373,3.4001,1.6000
 1014.0000,2148.8645,-0.0203,4.2225,4.3414,4.2564,4.1868,4.1828,4.2233,4.3414,0.2613,2.6129,0.3228,-0.3852,4.1047,16.6487,12.3103,12.3103,10.8053,0.0104,2.2501,5.6799,13.7500,5.6799,230.3390,9.0711,6.3858,3.9237,130.7264,96.9959,35.0361,1.4071,8.9775,4.8296,0.5380,6.3802,3.4324,0.0000
 1014.5000,2164.9766,-0.0181,3.6210,3.7118,3.6675,3.6224,3.6213,3.6210,3.7118,0.2606,2.6126,0.4839,-0.1566,4.0022,18.7505,14.2633,14.2633,12.6836,0.0093,2.2653,5.6946,13.7635,5.6946,269.4113,9.1109,5.6501,3.4787,138.6580,102.6498,36.9504,1.4816,9.5356,5.1046,0.5353,6.4360,3.4453,4.8000
 1015.0000,2133.5015,-0.0059,3.4394,3.4672,3.4457,3.4134,3.4166,3.4391,3.4672,0.2615,2.6014,0.5471,0.3600,3.9736,19.9672,15.4054,15.4054,13.7773,0.0090,2.9425,6.3480,14.3610,6.3480,288.4180,9.1535,5.4249,3.6372,147.3854,106.0595,37.8725,1.5229,9.9144,5.2113,0.5256,6.5100,3.4219,1.6000
 1015.5000,2135.8733,0.0107,3.3851,3.3353,3.3278,3.3054,3.3150,3.3849,3.3353,0.2617,2.5906,0.0736,0.6932,3.9896,20.8135,16.2047,16.2047,14.5408,0.0116,3.5992,6.9816,14.9404,6.9816,299.8216,9.1907,5.1769,3.2671,144.9506,104.3578,37.2916,1.5059,9.7649,5.1016,0.5224,6.4845,3.3878,3.2000
 1016.0000,2113.2664,0.0211,3.3594,3.2622,3.2619,3.2471,3.2635,3.3594,3.2622,0.2622,2.5876,-0.4819,0.1167,3.8824,21.9984,17.3308,17.3308,15.6136,0.0139,3.7824,7.1584,15.1021,7.1584,306.5434,9.1949,4.7064,2.8273,129.8744,96.8544,35.2381,1.4262,8.9782,4.8053,0.5352,6.2952,3.3693,1.0000
 1016.5000,2101.5652,0.0272,3.4365,3.3084,3.3092,3.2994,3.3214,3.4364,3.3084,0.2630,2.5869,-0.4337,-0.8358,3.6864,21.9147,17.2510,17.2510,15.5377,0.0116,3.8259,7.2004,15.1405,7.2005,302.2613,9.1990,4.9664,3.0326,112.9754,84.9778,32.0712,1.2989,7.7292,4.3694,0.5653,5.9508,3.3640,1.0000
 1017.0000,2106.7825,0.0278,3.5930,3.4560,3.4518,3.4441,3.4678,3.5929,3.4560,0.2622,2.5880,-0.1825,-0.6534,3.5461,21.1626,16.5357,16.5357,14.8565,0.0104,3.7575,7.1344,15.0801,7.1344,289.3539,9.2063,4.7665,2.9354,100.0877,72.8357,28.9215,1.1635,6.4445,3.9775,0.6172,5.5391,3.4187,1.0000
 1017.5000,2133.7319,0.0150,3.8522,3.7726,3.7567,3.7484,3.7628,3.8529,3.7726,0.2619,2.5747,-0.1608,0.0330,3.5924,19.7638,15.2138,15.2138,13.5942,0.0206,4.5622,7.9109,15.7902,7.9109,265.0699,9.2674,4.2951,2.9016,88.7194,61.6280,25.7455,1.0356,5.3096,3.5411,0.6669,5.1270,3.4193,2.0000
 1018.0000,2162.4314,0.0045,4.6756,4.6469,4.6059,4.5916,4.5715,4.6820,4.6469,0.2616,2.5505,-0.0452,0.0082,3.6823,15.5050,11.2583,11.2583,9.7891,0.0376,6.0298,9.3269,17.0851,9.3270,215.1963,9.1888,6.4844,5.3042,69.9040,49.3698,21.7031,0.8729,4.1343,2.9855,0.7221,4.7362,3.4201,0.0000
 1018.5000,2122.7214,-0.0296,6.4532,6.7182,6.6198,6.5877,6.4693,6.4856,6.7182,0.2611,2.5551,0.0171,-0.0498,3.5110,11.0983,7.2763,7.2763,5.9132,0.0502,5.7517,9.0586,16.8397,9.0586,148.8492,8.9129,12.2320,9.4411,46.6393,37.7541,17.5125,0.7061,3.0530,2.4006,0.7863,4.3234,3.3996,4.0000
 1019.0000,2138.9370,-0.0735,9.2463,10.1963,9.9972,9.9310,9.6369,9.3486,10.1963,0.2619,2.6007,-0.1095,0.0716,3.4474,9.1677,5.5679,5.5679,4.2350,0.0551,2.9881,6.3920,14.4012,6.3920,98.0750,8.7577,8.7879,9.4052,34.0781,30.2796,14.5067,0.5864,2.4052,1.9817,0.8239,4.1016,3.3794,4.0000
 1019.5000,2137.4287,-0.1089,11.7062,13.4991,13.1749,13.0625,12.5656,11.8906,13.4991,0.2619,2.6504,0.1151,0.1692,3.8721,8.5531,5.0286,5.0286,3.7033,0.0488,-0.0260,3.4837,11.7418,3.4837,74.0792,8.8589,13.6283,9.7843,33.6088,28.2834,13.9806,0.5621,2.2018,1.9244,0.8740,3.9174,3.4238,0.8000
 1020.0000,2076.1487,-0.1307,11.6506,13.7974,13.4166,13.2782,12.6930,11.8257,13.7974,0.2614,2.6667,0.3872,0.1021,4.3522,8.6839,5.1433,5.1433,3.8164,0.0343,-1.0110,2.5332,10.8726,2.5332,72.4777,8.9078,16.3644,11.7618,36.4228,29.7526,15.1387,0.6054,2.2725,2.0991,0.9237,3.7538,3.4674,0.8000
 1020.5000,2018.1616,-0.1336,8.5422,10.1523,9.8476,9.7314,9.2693,8.6260,10.1523,0.2618,2.6663,-0.0310,-0.1172,4.4845,9.7131,6.0482,6.0482,4.7078,0.0245,-0.9868,2.5565,10.8940,2.5566,98.4995,8.9643,18.1555,11.0183,40.5554,32.7584,17.2230,0.6842,2.4441,2.4099,0.9860,3.5724,3.5225,0.8000
 1021.0000,2043.0845,-0.1222,6.4127,7.5171,7.2794,7.1807,6.8406,6.4572,7.5171,0.2615,2.6636,-0.6014,0.0434,4.3632,10.8946,7.0950,7.0950,5.7355,0.0200,-0.8260,2.7118,11.0359,2.7118,133.0306,9.0522,12.2226,7.7124,47.0532,37.5415,20.5733,0.8144,2.7038,2.8921,1.0696,3.3199,3.5511,2.4000
 1021.5000,2123.9766,-0.1002,5.3156,6.0633,5.8692,5.7818,5.5387,5.3462,6.0633,0.2617,2.6448,-0.4987,0.2863,4.2093,12.2159,8.2754,8.2754,6.8902,0.0155,0.3130,3.8108,12.0409,3.8108,164.9257,9.2041,12.2899,7.3595,57.7051,45.6121,25.7406,1.0140,3.2036,3.6420,1.1368,3.1594,3.5917,2.4000
 1022.0000,2093.2043,-0.0763,4.4349,4.9085,4.7537,4.6783,4.5193,4.4553,4.9085,0.2614,2.6167,-0.0482,0.2264,4.0311,14.6268,10.4556,10.4556,9.0117,0.0105,2.0204,5.4583,13.5474,5.4583,203.7281,9.2218,7.9206,4.5879,72.7305,54.7516,31.5713,1.2286,3.7751,4.5385,1.2022,3.0727,3.6940,0.8000
 1022.5000,2146.4575,-0.0603,3.8766,4.2030,4.0750,4.0074,3.9015,3.8911,4.2030,0.2613,2.5952,0.1654,0.1154,3.8410,17.1135,12.7400,12.7400,11.2195,0.0071,3.3213,6.7136,14.6953,6.7136,237.9227,9.2678,5.3469,3.0930,84.1193,60.5420,35.7058,1.3712,4.0830,5.2198,1.2784,2.9777,3.8068,0.0000
 1023.0000,2139.8928,-0.0556,3.6327,3.9146,3.8005,3.7356,3.6506,3.6456,3.9146,0.2622,2.5878,0.1114,0.0068,3.7658,18.6206,14.1418,14.1418,12.5671,0.0076,3.7692,7.1457,15.0905,7.1458,255.4563,9.2822,5.3100,3.1769,83.1852,60.7383,36.0308,1.3725,4.0669,5.3205,1.3082,2.9632,3.8766,1.0000
 1023.5000,2097.8684,-0.0595,3.5602,3.8560,3.7491,3.6843,3.5993,3.5743,3.8560,0.2613,2.5903,-0.1285,-0.1441,3.7858,18.9018,14.4048,14.4048,12.8194,0.0078,3.6180,6.9998,14.9570,6.9998,259.3366,9.3117,5.6381,3.3649,76.4009,56.9890,34.1248,1.3035,3.7613,5.0219,1.3352,2.8856,3.8527,3.0000
 1024.0000,2139.1563,-0.0668,3.5180,3.8463,3.7453,3.6813,3.5872,3.5329,3.8463,0.2630,2.5953,-0.1822,-0.3148,3.8367,18.4542,13.9864,13.9864,12.4180,0.0070,3.3133,6.7058,14.6882,6.7058,259.9890,9.3319,5.7739,3.4891,74.3489,53.0292,32.3621,1.2587,3.3993,4.6556,1.3696,2.7007,3.6989,4.0000
 1024.5000,2137.2668,-0.0731,3.4662,3.8205,3.7259,3.6645,3.5579,3.4796,3.8205,0.2611,2.5988,0.1545,-0.0161,3.8697,18.8213,14.3295,14.3295,12.7472,0.0079,3.1031,6.5029,14.5027,6.5029,261.7450,9.3191,5.9984,3.5384,74.5862,51.4228,32.2094,1.2880,3.1630,4.4664,1.4121,2.4557,3.4677,1.6000
 1025.0000,2263.1099,-0.0774,3.3318,3.6928,3.6072,3.5514,3.4357,3.3451,3.6928,0.2610,2.5965,0.3207,0.4980,3.8249,19.5191,14.9837,14.9837,13.3740,0.0082,3.2413,6.6364,14.6247,6.6364,270.7976,9.3535,5.8897,3.2924,72.2201,52.1903,33.9771,1.3928,3.0273,4.5495,1.5028,2.1735,3.2664,4.0000
 1025.5000,2206.1023,-0.0816,3.1720,3.5343,3.4584,3.4096,3.2881,3.1857,3.5343,0.2599,2.5954,-0.0679,0.3944,3.8701,20.5392,15.9453,15.9453,14.2932,0.0067,3.3102,6.7029,14.6855,6.7029,282.9406,9.4181,5.0969,2.8866,70.9309,54.0411,36.5519,1.5220,2.9456,4.7821,1.6235,1.9353,3.1420,3.2000
 1026.0000,2221.1089,-0.0864,3.0634,3.4345,3.3672,3.3253,3.2000,3.0769,3.4345,0.2619,2.6014,-0.4811,0.2872,4.0948,21.5620,16.9152,16.9152,15.2180,0.0033,2.9454,6.3508,14.3635,6.3508,291.1660,9.4781,5.0825,2.9895,68.7611,55.8067,39.3746,1.6579,2.8259,5.0643,1.7921,1.7045,3.0546,4.8000
 1026.5000,2167.7634,-0.0894,2.9416,3.3103,3.2527,3.2184,3.0968,2.9547,3.3103,0.2618,2.5973,-0.2128,0.2324,4.1222,21.5242,16.8793,16.8793,15.1838,-0.0012,3.1947,6.5913,14.5835,6.5914,302.0866,9.5145,5.5317,3.1900,66.4958,56.9561,41.6898,1.7649,2.6921,5.3167,1.9749,1.5253,3.0124,0.8000
 1027.0000,2070.9202,-0.0876,2.7644,3.1040,3.0580,3.0322,2.9247,2.7758,3.1040,0.2615,2.5833,0.2420,-0.1442,3.8799,21.7295,17.0746,17.0746,15.3698,-0.0004,4.0419,7.4088,15.3310,7.4088,322.1650,9.5960,4.9173,2.7313,68.7388,56.5070,42.6629,1.8264,2.4999,5.3445,2.1379,1.3687,2.9262,1.6000
 1027.5000,2127.5823,-0.0788,2.6157,2.9045,2.8700,2.8525,2.7654,2.6257,2.9045,0.2628,2.5788,0.1847,-0.4736,3.7666,22.7190,18.0196,18.0196,16.2681,0.0070,4.3164,7.6737,15.5733,7.6737,344.2971,9.6301,4.8739,2.8752,69.6426,55.6245,42.9892,1.8602,2.3288,5.2917,2.2723,1.2519,2.8448,4.0000
 1028.0000,2132.5342,-0.0594,2.4069,2.6064,2.5842,2.5748,2.5158,2.4145,2.6064,0.2617,2.5689,0.0127,-0.8147,3.7812,22.7949,18.0923,18.0923,16.3372,0.0141,4.9175,8.2537,16.1037,8.2538,383.6663,9.6715,6.2523,3.0928,70.3920,56.7326,44.8662,1.9636,2.2428,5.4171,2.4153,1.1422,2.7587,0.8000
 1028.5000,2142.8530,-0.0330,2.0841,2.1795,2.1685,2.1661,2.1415,2.0878,2.1795,0.2616,2.5332,0.0143,-0.3647,3.7010,25.6395,20.8407,20.8407,18.9373,0.0153,7.0811,10.3414,18.0127,10.3414,458.8246,9.7777,3.1660,2.1081,75.7211,58.7883,47.3117,2.0967,2.2220,5.5891,2.5153,1.0598,2.6657,1.6000
 1029.0000,2105.3892,-0.0102,1.8844,1.9109,1.9081,1.9102,1.8935,1.8862,1.9109,0.2622,2.5034,0.0421,0.6261,3.6078,29.8575,24.9989,24.9989,22.8387,0.0136,8.8831,12.0802,19.6027,12.0802,523.3162,9.8790,2.3492,1.8252,79.8787,60.9882,49.8513,2.2380,2.2166,5.7526,2.5952,0.9905,2.5705,6.4000
 1029.5000,2128.4224,0.0064,1.7844,1.7688,1.7718,1.7769,1.7743,1.7853,1.7688,0.2616,2.5019,0.0603,0.1719,3.5462,31.2581,26.4012,26.4012,24.1460,0.0171,8.9758,12.1696,19.6845,12.1696,565.3542,9.9180,2.6971,2.0827,78.2746,63.0095,52.4874,2.3856,2.1571,5.9179,2.7435,0.9042,2.4807,0.0000
 1030.0000,2124.0923,0.0185,1.6636,1.6212,1.6278,1.6345,1.6426,1.6637,1.6212,0.2621,2.4801,0.0297,-0.3857,3.4057,32.8049,27.9623,27.9623,25.5966,0.0186,10.2953,13.4428,20.8488,13.4428,616.8239,10.0033,2.8963,1.9072,80.5309,66.6865,56.2947,2.5801,2.1854,6.2454,2.8578,0.8470,2.4206,4.0000
 1030.5000,2128.3301,0.0261,1.5503,1.4950,1.5038,1.5116,1.5256,1.5502,1.4950,0.2618,2.4386,-0.1032,0.0532,3.2750,36.0833,31.3137,31.3137,28.6948,0.0175,12.8127,15.8719,23.0700,15.8719,668.9146,10.0588,2.4247,1.4809,90.1219,71.1723,61.0390,2.7987,2.2022,6.7661,3.0724,0.7869,2.4176,2.0000
 1031.0000,2064.4587,0.0287,1.5380,1.4776,1.4890,1.4981,1.5158,1.5376,1.4776,0.2602,2.4354,-0.3174,0.2176,3.3491,36.3481,31.5870,31.5870,28.9465,0.0201,13.0082,16.0606,23.2426,16.0606,676.7676,10.1336,1.9371,1.4334,95.5536,73.5286,63.9479,2.9323,2.1724,7.0877,3.2627,0.7409,2.4171,0.0000
 1031.5000,2076.2522,0.0291,1.5701,1.5074,1.5215,1.5323,1.5530,1.5696,1.5074,0.2604,2.4542,-0.3390,0.2747,3.5387,36.5597,31.8055,31.8055,29.1477,0.0158,11.8651,14.9575,22.2339,14.9575,663.3741,10.1898,2.7009,1.8041,90.9187,71.8406,63.1745,2.8988,2.0330,6.9924,3.4394,0.7013,2.4121,0.0000
 1032.0000,2122.7214,0.0311,1.5611,1.4947,1.5104,1.5222,1.5454,1.5606,1.4947,0.2608,2.4619,-0.0764,-0.0187,3.6291,34.5880,29.7780,29.7780,27.2778,0.0065,11.3983,14.5071,21.8220,14.5071,669.0220,10.2540,2.2836,1.5873,85.4112,68.4695,60.6495,2.8027,1.8713,6.6191,3.5371,0.6677,2.3617,0.8000
 1032.5000,2137.7852,0.0359,1.5388,1.4632,1.4794,1.4918,1.5176,1.5383,1.4632,0.2610,2.4619,0.0031,-0.3524,3.6060,35.9603,31.1869,31.1869,28.5780,0.0016,11.4019,14.5106,21.8252,14.5106,683.4418,10.2852,2.3209,1.6976,85.2568,68.1157,60.6502,2.8247,1.8047,6.5150,3.6100,0.6389,2.3064,1.6000
 1033.0000,2162.8003,0.0432,1.5076,1.4188,1.4347,1.4470,1.4755,1.5067,1.4188,0.2615,2.4379,-0.1236,-0.1292,3.5012,35.1609,30.3650,30.3650,27.8200,-0.0029,12.8544,15.9121,23.1068,15.9121,704.8133,10.2430,2.7935,1.7753,89.7776,72.8073,65.1834,3.0499,1.8727,6.9354,3.7034,0.6140,2.2740,1.6000
 1033.5000,2149.3940,0.0496,1.4208,1.3249,1.3389,1.3501,1.3790,1.4190,1.3249,0.2621,2.3930,-0.0441,-0.0248,3.3344,36.7613,32.0141,32.0141,29.3396,-0.0061,15.5783,18.5405,25.5103,18.5405,754.7820,10.2453,2.3456,1.5915,98.7093,77.9771,70.4507,3.2896,1.9263,7.5280,3.9080,0.5856,2.2885,0.8000
 1034.0000,2144.3386,0.0525,1.3822,1.2834,1.2961,1.3065,1.3352,1.3803,1.2834,0.2608,2.3738,-0.0177,-0.0961,3.2218,38.5513,33.8746,33.8746,31.0481,-0.0040,16.7391,19.6606,26.5345,19.6606,779.1515,10.2512,2.1769,1.2993,104.2319,81.9728,74.7067,3.4617,1.9516,8.1090,4.1551,0.5638,2.3425,1.6000
 1034.5000,2132.2688,0.0519,1.4324,1.3312,1.3433,1.3536,1.3831,1.4308,1.3312,0.2615,2.3922,-0.2249,-0.3722,3.2166,37.2014,32.4699,32.4699,29.7588,-0.0002,15.6272,18.5876,25.5534,18.5876,751.1761,10.2370,2.3518,1.4282,104.0196,82.0104,75.0716,3.4360,1.9353,8.3505,4.3149,0.5632,2.4303,1.0000
 1035.0000,2123.1938,0.0475,1.5260,1.4272,1.4387,1.4487,1.4780,1.5246,1.4272,0.2613,2.4156,-0.2178,-0.5933,3.1803,36.1838,31.4174,31.4174,28.7903,-0.0004,14.2046,17.2150,24.2982,17.2150,700.6593,10.2302,2.4662,1.4188,103.5351,80.3418,73.4350,3.3109,1.9375,8.4069,4.3391,0.5852,2.5392,0.0000
 1035.5000,2169.1343,0.0388,1.6284,1.5421,1.5519,1.5609,1.5876,1.6273,1.5421,0.2620,2.4387,-0.1943,-0.2948,2.9966,33.7686,28.9415,28.9415,26.5041,-0.0010,12.8070,15.8664,23.0650,15.8664,648.4591,10.2359,2.8380,1.7393,101.1896,77.7878,70.5498,3.1423,1.9694,8.2592,4.1938,0.6267,2.6284,0.0000
 1036.0000,2146.3306,0.0278,1.7560,1.6892,1.6960,1.7028,1.7254,1.7552,1.6892,0.2612,2.4693,-0.3485,0.1890,2.7679,28.8878,24.0342,24.0342,21.9370,0.0024,10.9535,14.0780,21.4296,14.0780,592.0071,10.2375,3.5232,2.0919,97.9652,75.6168,68.0635,3.0055,1.9894,8.0918,4.0675,0.6619,2.6924,4.8000
 1036.5000,2153.5520,0.0176,1.8414,1.7969,1.7989,1.8019,1.8184,1.8408,1.7969,0.2604,2.4857,-0.0624,0.6207,2.7623,27.5260,22.6882,22.6882,20.6755,0.0024,9.9604,13.1197,20.5533,13.1197,556.5018,10.2673,3.2422,2.1005,95.0236,74.1853,66.1725,2.9144,2.0480,7.9030,3.8588,0.7027,2.7117,1.6000
 1037.0000,2140.9299,0.0091,1.9024,1.8786,1.8742,1.8720,1.8829,1.9020,1.8786,0.2625,2.4898,0.3571,0.5795,3.0019,27.9286,23.0851,23.0851,21.0479,-0.0005,9.7077,12.8759,20.3303,12.8759,532.2998,10.2985,2.8794,1.8424,91.2434,71.3717,63.1865,2.7748,2.0621,7.5848,3.6781,0.7432,2.7335,2.4000
 1037.5000,2143.1296,0.0006,1.9608,1.9592,1.9475,1.9395,1.9441,1.9607,1.9592,0.2622,2.4979,0.2912,-0.0431,3.1899,27.8071,22.9652,22.9652,20.9354,0.0019,9.2164,12.4018,19.8968,12.4018,510.4088,10.3164,2.7283,1.7188,85.1596,67.7292,59.5860,2.5951,2.0327,7.2551,3.5691,0.7833,2.7957,4.0000
 1038.0000,2133.3979,-0.0093,2.0245,2.0505,2.0310,2.0164,2.0136,2.0245,2.0505,0.2616,2.5074,0.0469,-0.0510,3.2952,28.0560,23.2109,23.2109,21.1658,0.0045,8.6411,11.8467,19.3892,11.8467,487.6800,10.2691,2.1695,1.7666,78.5297,61.9524,53.8787,2.3293,1.9613,6.6419,3.3864,0.8420,2.8514,2.0000
 1038.5000,2096.6707,-0.0191,2.1501,2.2071,2.1783,2.1558,2.1454,2.1501,2.2071,0.2622,2.5257,-0.1303,0.5023,3.4602,26.8324,22.0067,22.0067,20.0352,0.0013,7.5345,10.7789,18.4128,10.7789,453.0832,10.2341,2.2404,2.2068,70.7516,56.4591,48.2493,2.0634,1.9012,6.0550,3.1848,0.9214,2.9345,2.0000
 1039.0000,2105.6084,-0.0239,2.2677,2.3428,2.3041,2.2735,2.2589,2.2677,2.3428,0.2610,2.5366,-0.2070,0.6338,3.5661,26.8687,22.0423,22.0423,20.0687,-0.0060,6.8713,10.1389,17.8276,10.1389,426.8433,10.1527,3.7638,2.7408,66.9223,55.0327,45.8939,1.9314,1.9963,5.9078,2.9593,1.0336,3.0589,1.0000
 1039.5000,2100.7476,-0.0202,2.3283,2.3933,2.3457,2.3083,2.2968,2.3283,2.3933,0.2604,2.5222,-0.1701,0.1320,3.4935,27.0014,22.1725,22.1725,20.1911,-0.0083,7.7429,10.9800,18.5967,10.9800,417.8390,10.1761,4.3333,2.8540,70.5268,56.7885,45.9815,1.9019,2.2264,6.0761,2.7291,1.1706,3.1947,4.0000
 1040.0000,2119.5667,-0.0293,2.2864,2.3794,2.3249,2.2833,2.2812,2.2864,2.3794,0.2616,2.5044,-0.0625,-0.5632,3.3155,27.2235,22.3906,22.3906,20.3960,0.0005,8.8250,12.0241,19.5515,12.0241,420.2743,10.1916,2.7211,2.1514,77.8525,60.7595,47.7440,1.9367,2.5549,6.4898,2.5401,1.3192,3.3509,4.0000
 1040.5000,2173.6714,-0.0131,2.3442,2.3868,2.3263,2.2811,2.2903,2.3442,2.3868,0.2625,2.4980,-0.0002,-0.5601,3.1781,28.4441,23.5946,23.5946,21.5254,0.0113,9.2100,12.3956,19.8911,12.3956,418.9743,10.2194,2.2293,1.6859,84.6956,62.2158,47.2420,1.8886,2.8180,6.5534,2.3256,1.4921,3.4700,5.0000
 1041.0000,2146.6184,-0.0002,2.4670,2.4675,2.3994,2.3498,2.3696,2.4670,2.4675,0.2612,2.4984,-0.0488,-0.1278,3.2165,27.0347,22.2052,22.2052,20.2218,0.0161,9.1898,12.3761,19.8733,12.3761,405.2676,10.2285,2.6123,1.8894,80.7629,58.8374,43.1420,1.7187,2.8496,6.0131,2.1101,1.6580,3.4987,1.0000
 1041.5000,2145.3171,0.0053,2.7686,2.7483,2.6640,2.6049,2.6363,2.7686,2.7483,0.2604,2.5123,-0.0577,0.1291,3.4505,23.3052,18.5819,18.5819,16.8017,0.0190,8.3453,11.5613,19.1282,11.5613,363.8557,10.2025,2.4732,2.1129,68.6897,52.0500,36.7521,1.4597,2.7078,5.1434,1.8995,1.8550,3.5235,6.0000
 1042.0000,2136.6572,-0.0209,3.8162,3.9266,3.7649,3.6586,3.7289,3.8162,3.9266,0.2614,2.5505,0.1206,0.1966,3.7873,18.7334,14.2472,14.2472,12.6682,0.0244,6.0331,9.3302,17.0880,9.3302,254.6751,9.9713,3.1429,2.5467,57.3937,43.1740,29.5266,1.1642,2.3847,4.1725,1.7497,2.0483,3.5838,3.0000
 1042.5000,2200.6667,-0.0301,7.2128,7.5142,7.0358,6.7455,7.0085,7.2128,7.5142,0.2610,2.6015,0.4111,0.1064,4.1166,13.3056,9.2566,9.2566,7.8468,0.0294,2.9398,6.3454,14.3586,6.3454,133.0815,9.7748,6.3061,4.8928,47.1103,37.0077,24.7401,0.9630,2.1328,3.5554,1.6670,2.2147,3.6920,0.0000
 1043.0000,2181.4102,-0.0178,13.3368,13.6652,12.4586,11.7856,12.6461,13.3368,13.6652,0.2600,2.6473,0.3467,0.0690,4.3178,10.9286,7.1253,7.1253,5.7652,0.0328,0.1614,3.6645,11.9071,3.6645,73.1787,9.6545,16.6247,14.1267,41.4512,35.7675,23.5771,0.9057,2.1109,3.4452,1.6321,2.3306,3.8037,0.8000
 1043.5000,2163.1680,0.0058,15.6721,15.5462,14.1959,13.4838,14.6828,15.6721,15.5462,0.2604,2.6700,-0.2935,0.0903,4.3309,9.9998,6.3015,6.3015,4.9568,0.0344,-1.2123,2.3390,10.6950,2.3390,64.3245,9.6445,24.5027,18.8197,46.0897,40.8301,26.5513,1.0186,2.4516,3.8864,1.5853,2.4069,3.8155,0.0000
 1044.0000,2161.4404,0.0078,10.8756,10.7581,10.0972,9.7518,10.3801,10.8756,10.7581,0.2623,2.6680,-0.7770,-0.0641,4.2250,9.9753,6.2798,6.2798,4.9355,0.0299,-1.0931,2.4540,10.8002,2.4540,92.9529,9.6719,14.9811,9.3701,60.4682,50.8302,32.3928,1.2572,3.1198,4.6728,1.4978,2.4816,3.7170,0.0000
 1044.5000,2166.9346,0.0009,9.1169,9.1055,8.6011,8.3462,8.7799,9.1169,9.1055,0.2610,2.6638,-0.4725,-0.2028,4.1598,11.0135,7.2008,7.2008,5.8392,0.0223,-0.8392,2.6990,11.0243,2.6990,109.8237,9.6964,9.1168,7.2280,77.2628,59.6865,37.3822,1.4801,3.7067,5.2534,1.4173,2.5043,3.5492,0.8000
 1045.0000,2206.8965,-0.0119,8.9988,9.1464,8.6065,8.3446,8.7122,8.9988,9.1464,0.2603,2.6551,0.1936,-0.2642,4.1888,11.6287,7.7496,7.7496,6.3764,0.0161,-0.3115,3.2082,11.4898,3.2082,109.3321,9.7166,16.4449,10.4949,85.2042,64.9331,39.7217,1.6081,4.1193,5.4146,1.3144,2.5616,3.3671,0.8000
 1045.5000,2173.6826,-0.0189,6.8336,7.0121,6.6701,6.5064,6.6726,6.8336,7.0121,0.2609,2.6372,0.4175,-0.1833,4.0945,12.8580,8.8528,8.8528,7.4534,0.0115,0.7733,4.2549,12.4470,4.2549,142.6116,9.7706,11.4291,7.9225,83.0799,64.7633,38.7550,1.5921,4.1876,5.1730,1.2353,2.6302,3.2491,0.8000
 1046.0000,2208.1987,-0.0205,4.8832,5.0219,4.8358,4.7468,4.8023,4.8832,5.0219,0.2620,2.6181,-0.0265,0.4807,3.8834,15.4521,11.2098,11.2098,9.7422,0.0068,1.9305,5.3716,13.4681,5.3716,199.1279,9.8425,7.8181,5.0158,78.1184,61.9686,36.4437,1.5102,4.0567,4.8028,1.1839,2.6863,3.1803,4.0000
 1046.5000,2165.4600,-0.0282,3.9914,4.1474,4.0216,3.9610,3.9761,3.9914,4.1474,0.2617,2.6043,-0.5158,0.4346,3.7853,16.7902,12.4410,12.4410,10.9313,0.0021,2.7700,6.1816,14.2088,6.1816,241.1149,9.9285,6.4509,4.3335,73.7511,59.7017,34.2117,1.4201,4.0086,4.4972,1.1219,2.8228,3.1669,4.0000
 1047.0000,2128.1345,-0.0302,3.6352,3.7874,3.6906,3.6432,3.6383,3.6352,3.7874,0.2617,2.6050,-0.4964,-0.4426,3.7520,17.7295,13.3114,13.3114,11.7695,0.0002,2.7246,6.1378,14.1688,6.1378,264.0363,9.9906,5.8264,3.8204,70.7641,59.9780,33.6213,1.3873,4.1047,4.4587,1.0862,2.9587,3.2139,4.8000
 1047.5000,2034.4346,-0.0079,3.5632,3.6020,3.5265,3.4883,3.4713,3.5632,3.6020,0.2615,2.6053,-0.1998,-0.2023,3.6921,18.8396,14.3466,14.3466,12.7636,-0.0006,2.7113,6.1250,14.1570,6.1250,277.6265,10.0372,5.6347,3.7559,71.4074,60.3666,32.8091,1.3544,4.2759,4.3480,1.0169,3.1570,3.2102,4.8000
 1048.0000,2097.5928,-0.0084,3.4439,3.4837,3.4278,3.3975,3.3725,3.4439,3.4837,0.2610,2.5959,0.0923,0.3871,3.6422,20.1422,15.5703,15.5703,13.9351,0.0012,3.2790,6.6727,14.6579,6.6727,287.0532,10.0564,5.2438,3.4125,74.1392,60.7818,32.2583,1.3281,4.4050,4.2920,0.9743,3.3167,3.2316,1.0000
 1048.5000,2205.5952,-0.0095,3.3976,3.4421,3.4025,3.3785,3.3470,3.3976,3.4421,0.2620,2.5881,0.2971,0.4418,3.6161,20.1210,15.5503,15.5503,13.9159,0.0050,3.7530,7.1301,15.0762,7.1301,290.5185,10.0812,5.2047,3.6744,75.5935,60.4980,31.5876,1.2965,4.4691,4.2219,0.9447,3.4471,3.2564,0.0000
 1049.0000,2139.3633,-0.0081,3.3938,3.4320,3.4057,3.3875,3.3509,3.3938,3.4320,0.2599,2.5774,0.2517,0.4746,3.6140,19.6874,15.1419,15.1419,13.5254,0.0052,4.4021,7.7564,15.6489,7.7564,291.3763,10.0999,5.4143,3.7169,77.7598,59.0871,30.4540,1.2457,4.4261,4.0903,0.9241,3.5530,3.2835,0.0000
 1049.5000,2175.4336,-0.0046,3.3891,3.4106,3.3944,3.3821,3.3435,3.3891,3.4106,0.2612,2.5697,-0.0635,0.1186,3.6440,19.9730,15.4108,15.4108,13.7825,0.0033,4.8664,8.2044,16.0585,8.2044,293.2019,10.0657,5.4049,3.5546,77.9409,59.5214,30.3483,1.2384,4.5124,4.0906,0.9065,3.6438,3.3032,1.6000
 1050.0000,2156.6270,0.0014,3.3598,3.3534,3.3437,3.3368,3.3016,3.3598,3.3534,0.2603,2.5755,-0.3237,-0.5691,3.6831,19.3007,14.7787,14.7787,13.1776,0.0031,4.5172,7.8674,15.7504,7.8674,298.2031,10.0451,5.7461,3.8425,78.0577,59.9946,30.2526,1.2376,4.6036,4.0629,0.8825,3.7198,3.2829,2.4000
 1050.5000,2209.0625,0.0090,3.2977,3.2568,3.2496,3.2465,3.2199,3.2977,3.2568,0.2605,2.5740,-0.2085,-0.7010,3.6954,19.5323,14.9962,14.9962,13.3859,0.0029,4.6069,7.9540,15.8296,7.9540,307.0540,10.0110,4.8041,3.2022,84.0319,62.6524,31.3019,1.2824,4.8563,4.1950,0.8638,3.7869,3.2712,0.8000
 1051.0000,2197.8337,0.0137,3.3159,3.2535,3.2440,3.2423,3.2227,3.3159,3.2535,0.2608,2.5598,0.0664,-0.1806,3.6804,20.5460,15.9517,15.9517,14.2993,0.0024,5.4654,8.7824,16.5871,8.7824,307.3636,9.9946,5.3659,3.1863,89.8382,67.4224,33.9280,1.3716,5.2221,4.6343,0.8874,3.8074,3.3789,1.6000
 1051.5000,2189.1040,0.0131,3.4468,3.3849,3.3684,3.3655,3.3459,3.4468,3.3849,0.2634,2.5543,0.1665,0.1691,3.6737,20.5275,15.9342,15.9342,14.2826,0.0039,5.8029,9.1080,16.8849,9.1080,295.4282,9.9902,6.4189,3.0720,92.3622,71.0400,36.3838,1.4470,5.4469,5.0828,0.9331,3.7643,3.5126,0.8000
 1052.0000,2204.3513,0.0109,3.6651,3.6101,3.5816,3.5743,3.5481,3.6652,3.6101,0.2609,2.5590,0.0395,-0.0857,3.6969,18.6205,14.1417,14.1417,12.5670,0.0053,5.5133,8.8286,16.6293,8.8286,277.0011,10.0094,3.2716,2.5129,93.3071,72.0521,37.7857,1.4768,5.4229,5.4018,0.9961,3.6721,3.6578,1.6000
 1052.5000,2157.6750,-0.0030,4.2960,4.3135,4.2594,4.2418,4.1890,4.2968,4.3135,0.2608,2.5725,-0.0066,-0.0476,3.8030,15.7412,11.4749,11.4749,9.9986,0.0054,4.6940,8.0381,15.9065,8.0381,231.8290,9.9470,4.1124,3.4317,88.8720,69.1625,36.6878,1.4151,5.1568,5.3341,1.0344,3.6442,3.7695,4.0000
 1053.0000,2163.0645,-0.0283,5.3461,5.5563,5.4601,5.4232,5.3180,5.3483,5.5563,0.2614,2.5954,0.2726,0.2978,3.9887,12.6215,8.6398,8.6398,7.2458,0.0073,3.3115,6.7041,14.6866,6.7041,179.9750,9.8537,17.6581,15.7481,83.4002,65.4862,34.6922,1.3342,4.8835,5.0627,1.0367,3.6604,3.7947,1.6000
 1053.5000,2112.9097,-0.0454,6.1211,6.5082,6.3686,6.3120,6.1655,6.1248,6.5082,0.2610,2.6069,0.4993,0.1746,4.1180,10.6167,6.8481,6.8481,5.4934,0.0093,2.6094,6.0266,14.0671,6.0266,153.6530,9.7966,22.6756,15.6628,81.5337,61.8062,32.3658,1.2405,4.6583,4.7430,1.0182,3.7551,3.8235,3.2000
 1054.0000,2210.2715,-0.0545,6.9874,7.5180,7.3285,7.2503,7.0646,6.9931,7.5180,0.2598,2.6070,0.2887,-0.0641,4.2763,10.4041,6.6594,6.6594,5.3083,0.0080,2.6090,6.0262,14.0668,6.0262,133.0145,9.8029,5.6600,5.6717,76.4580,57.0894,29.4853,1.1282,4.3641,4.3301,0.9922,3.8683,3.8381,6.4000
 1054.5000,2190.7854,-0.0578,8.1474,8.8039,8.5545,8.4484,8.2255,8.1567,8.8039,0.2620,2.6150,-0.0559,-0.1061,4.5410,9.4667,5.8310,5.8310,4.4941,0.0056,2.1234,5.5576,13.6383,5.5576,113.5855,9.7830,14.5787,11.6082,66.2425,52.6049,26.9948,1.0273,4.0610,3.9908,0.9827,3.9531,3.8848,2.4000
 1055.0000,2171.8054,-0.0359,6.6215,6.9515,6.7416,6.6602,6.5202,6.6255,6.9515,0.2605,2.6233,0.0347,0.0452,4.6175,9.5455,5.9004,5.9004,4.5624,0.0068,1.6210,5.0729,13.1950,5.0729,143.8539,9.8049,18.5250,16.5052,60.3674,50.3103,25.8746,0.9718,3.8916,3.8865,0.9987,4.0048,3.9994,2.4000
 1055.5000,2197.4299,-0.0094,4.6998,4.7609,4.6218,4.5746,4.5391,4.7006,4.7609,0.2611,2.6128,0.2819,0.1082,4.3874,12.3906,8.4323,8.4323,7.0433,0.0107,2.2542,5.6838,13.7537,5.6838,210.0450,9.8757,21.7165,17.1068,63.0895,52.9514,27.6757,1.0311,4.0573,4.1965,1.0343,3.9351,4.0700,2.0000
 1056.0000,2158.6074,-0.0240,3.5076,3.6241,3.5333,3.5038,3.5059,3.5074,3.6241,0.2618,2.5826,0.2089,-0.0939,4.0328,16.8504,12.4966,12.4966,10.9849,0.0140,4.0871,7.4525,15.3710,7.4525,275.9276,9.9206,6.9305,3.6130,73.4567,58.2334,31.0751,1.1509,4.4102,4.7441,1.0757,3.8318,4.1219,2.0000
 1056.5000,2115.9958,-0.0179,3.3799,3.4637,3.3783,3.3514,3.3629,3.3795,3.4637,0.2610,2.5536,-0.0034,-0.1802,3.7876,19.7328,15.1847,15.1847,13.5663,0.0167,5.8420,9.1457,16.9194,9.1457,288.7111,9.9808,3.0422,2.5629,83.4314,60.9877,33.3022,1.2236,4.5444,5.1306,1.1290,3.7139,4.1930,3.0000
 1057.0000,2021.5706,-0.0290,4.3171,4.4905,4.3599,4.3181,4.3177,4.3175,4.4905,0.2609,2.5651,-0.0790,-0.0314,3.9635,18.4528,13.9851,13.9851,12.4167,0.0215,5.1443,8.4725,16.3038,8.4725,222.6919,10.0500,3.1853,2.5054,81.0992,56.7992,31.2636,1.1443,4.2194,4.8373,1.1464,3.6872,4.2271,1.0000
 1057.5000,2126.8794,-0.0140,7.8816,8.0343,7.7464,7.6357,7.5279,7.8875,8.0343,0.2617,2.6082,0.1037,0.0193,4.6732,13.2090,9.1693,9.1693,7.7618,0.0248,2.5320,5.9519,13.9988,5.9519,124.4671,10.1196,11.8834,10.4048,66.8822,48.9103,27.3598,0.9896,3.5808,4.2893,1.1979,3.6183,4.3342,2.0000
 1058.0000,2207.0933,-0.0525,11.4930,12.3337,11.9569,11.8169,11.5521,11.5083,12.3337,0.2619,2.6242,0.1120,-0.1437,5.3054,9.6314,5.9761,5.9761,4.6369,0.0136,1.5626,5.0165,13.1434,5.0165,81.0788,10.2304,26.5772,27.2564,53.0934,41.2828,23.7992,0.8572,2.9197,3.7486,1.2839,3.4063,4.3733,7.0000
 1058.5000,2224.1714,-0.0639,9.4865,10.3335,10.0715,9.9740,9.7405,9.4957,10.3335,0.2603,2.6229,-0.2645,-0.2351,5.3117,9.8454,6.1650,6.1650,4.8227,0.0005,1.6454,5.0964,13.2165,5.0964,96.7727,10.2564,27.6055,27.2240,46.9283,37.2857,22.3316,0.8070,2.5178,3.5045,1.3919,3.1199,4.3425,2.0000
 1059.0000,2205.7446,-0.0448,6.3562,6.7524,6.6082,6.5556,6.4325,6.3598,6.7524,0.2626,2.6392,-0.4388,0.1464,5.0958,12.1153,8.1851,8.1851,6.8021,-0.0011,0.6550,4.1408,12.3426,4.1408,148.0952,10.2529,17.9461,13.0066,46.6821,38.4593,24.1751,0.8803,2.4351,3.7622,1.5450,2.7662,4.2737,6.4000
 1059.5000,2156.6157,-0.0119,3.9178,3.9824,3.9153,3.8927,3.8593,3.9183,3.9824,0.2616,2.6356,-0.2634,0.4333,4.7576,15.7050,11.4417,11.4417,9.9665,-0.0053,0.8736,4.3517,12.5355,4.3517,251.1038,10.2880,10.4995,8.7530,52.7927,42.8324,28.1055,1.0254,2.5418,4.3647,1.7172,2.4789,4.2567,2.4000
 1060.0000,2200.5859,0.0046,2.6879,2.6710,2.6429,2.6353,2.6418,2.6876,2.6710,0.2621,2.5971,-0.1393,0.0464,4.0408,20.6068,16.0092,16.0092,14.3542,-0.0087,3.2064,6.6027,14.5939,6.6027,374.3921,10.3374,8.2046,5.5231,61.7155,48.0800,32.8706,1.1969,2.6687,5.1157,1.9169,2.2297,4.2742,0.0000
 1060.5000,2188.1707,0.0284,2.1982,2.1126,2.1010,2.0995,2.1161,2.1979,2.1126,0.2600,2.5703,-0.2815,-0.4546,3.3429,25.5240,20.7282,20.7282,18.8313,0.0004,4.8275,8.1669,16.0243,8.1669,473.3585,10.4382,4.0509,2.4972,68.5425,55.1249,39.1150,1.4169,2.8682,6.1223,2.1345,2.0243,4.3208,0.8000
 1061.0000,2215.7644,0.0344,2.0007,1.9067,1.9040,1.9053,1.9214,2.0004,1.9067,0.2612,2.5681,-0.2651,-0.2062,3.0373,28.8600,24.0066,24.0066,21.9112,0.0106,4.9624,8.2970,16.1432,8.2970,524.4739,10.5175,2.4879,2.0301,76.7516,62.9240,46.0990,1.6770,3.0736,7.1821,2.3367,1.8328,4.2828,1.0000
 1061.5000,2161.8318,0.0422,1.9643,1.8511,1.8540,1.8572,1.8832,1.9641,1.8511,0.2608,2.5665,0.0776,0.2895,3.0656,29.4133,24.5564,24.5564,22.4253,0.0132,5.0627,8.3939,16.2318,8.3939,540.2053,10.5440,3.2124,2.0175,89.5304,71.6513,53.4785,1.9709,3.3652,8.2108,2.4399,1.7075,4.1660,2.0000
 1062.0000,2105.5161,0.0410,1.9442,1.8354,1.8425,1.8472,1.8765,1.9440,1.8354,0.2612,2.5544,0.0699,-0.1866,3.1864,29.8934,25.0347,25.0347,22.8721,0.0144,5.7931,9.0985,16.8762,9.0986,544.8308,10.5711,3.3570,2.0177,102.5885,80.1258,60.5690,2.2640,3.6447,9.1486,2.5102,1.6098,4.0409,7.0000
 1062.5000,2080.2830,0.0379,1.9303,1.8303,1.8405,1.8466,1.8763,1.9301,1.8303,0.2614,2.5433,-0.2225,-0.6312,3.1992,29.4385,24.5814,24.5814,22.4487,0.0151,6.4665,9.7484,17.4705,9.7484,546.3732,10.6083,3.2323,1.9245,111.3124,86.0344,65.3939,2.4843,3.8290,9.6880,2.5302,1.5413,3.8997,1.6000
 1063.0000,2112.5520,0.0347,1.9081,1.8177,1.8302,1.8375,1.8652,1.9080,1.8177,0.2618,2.5424,-0.2011,-0.1257,3.1523,29.0177,24.1631,24.1631,22.0576,0.0107,6.5229,9.8028,17.5202,9.8028,550.1524,10.6296,3.0078,1.7580,112.6167,88.0631,67.5180,2.5865,3.8034,9.9007,2.6031,1.4705,3.8279,3.2000
 1063.5000,2176.0320,0.0318,1.8909,1.8086,1.8225,1.8310,1.8553,1.8908,1.8086,0.2606,2.5468,-0.0045,0.3255,3.1896,28.5530,23.7024,23.7024,21.6263,0.0084,6.2528,9.5422,17.2819,9.5422,552.9231,10.6564,2.8520,1.7559,105.7754,87.3687,67.4085,2.6009,3.6820,9.7964,2.6606,1.4157,3.7666,2.4000
 1064.0000,2136.0691,0.0297,1.8987,1.8214,1.8364,1.8463,1.8665,1.8985,1.8214,0.2617,2.5496,0.0643,0.4912,3.2941,27.7364,22.8955,22.8955,20.8700,0.0115,6.0876,9.3827,17.1361,9.3827,549.0155,10.6273,3.1983,1.9025,99.3249,84.7061,65.7262,2.5405,3.4961,9.5303,2.7260,1.3761,3.7513,2.4000
 1064.5000,2112.2642,0.0279,1.8837,1.8118,1.8269,1.8379,1.8535,1.8837,1.8118,0.2613,2.5492,-0.0131,0.6888,3.3034,27.6375,22.7981,22.7981,20.7786,0.0143,6.1068,9.4013,17.1531,9.4013,551.9461,10.6259,2.8267,1.9360,99.9869,80.5331,62.9136,2.4157,3.2607,9.1988,2.8211,1.3498,3.8079,3.0000
 1065.0000,2125.1406,0.0263,1.8689,1.8016,1.8163,1.8282,1.8399,1.8689,1.8016,0.2611,2.5481,-0.0604,0.5191,3.2429,28.7856,23.9328,23.9328,21.8421,0.0148,6.1751,9.4672,17.2133,9.4672,555.0559,10.6449,2.6601,1.8191,100.0841,77.4840,60.5946,2.3138,3.1296,8.9210,2.8505,1.3526,3.8556,0.8000
 1065.5000,2054.2097,0.0249,1.8466,1.7835,1.7972,1.8094,1.8184,1.8466,1.7835,0.2601,2.5459,0.1104,0.1956,3.2650,28.5672,23.7164,23.7164,21.6395,0.0140,6.3112,9.5986,17.3334,9.5986,560.6906,10.6317,3.0085,1.7240,95.5072,75.4850,59.0298,2.2439,3.0444,8.7386,2.8704,1.3567,3.8944,2.4000
 1066.0000,2065.0347,0.0241,1.8322,1.7717,1.7841,1.7960,1.8041,1.8322,1.7717,0.2607,2.5396,0.2780,0.4306,3.3313,27.8469,23.0045,23.0045,20.9722,0.0141,6.6931,9.9670,17.6703,9.9670,564.4251,10.6219,2.9463,1.7256,93.4409,75.1190,58.8223,2.2318,3.0011,8.7277,2.9081,1.3447,3.9105,4.0000
 1066.5000,2121.0974,0.0238,1.8388,1.7787,1.7895,1.8008,1.8095,1.8388,1.7787,0.2604,2.5319,0.2933,0.3702,3.3883,27.9633,23.1194,23.1194,21.0800,0.0150,7.1583,10.4159,18.0809,10.4159,562.1986,10.6171,2.9532,1.6979,95.2110,76.2272,59.7239,2.2682,3.0234,8.8511,2.9275,1.3330,3.9022,4.8000
 1067.0000,2192.4780,0.0236,1.8406,1.7810,1.7897,1.7996,1.8098,1.8406,1.7810,0.2610,2.5301,0.2559,-0.3280,3.4278,27.6859,22.8458,22.8458,20.8233,0.0151,7.2677,10.5215,18.1774,10.5215,561.4905,10.6164,2.8520,1.8342,94.8452,76.7563,60.6673,2.3064,2.9648,8.9798,3.0288,1.2855,3.8934,4.0000
 1067.5000,2099.5498,0.0228,1.8377,1.7802,1.7864,1.7943,1.8063,1.8377,1.7802,0.2616,2.5281,-0.0486,-0.3943,3.4339,26.9650,22.1368,22.1368,20.1575,0.0135,7.3878,10.6373,18.2833,10.6373,561.7348,10.5983,2.7781,1.7945,94.1662,77.1700,61.6520,2.3610,2.8825,9.0443,3.1377,1.2209,3.8308,2.4000
 1068.0000,2116.0532,0.0211,1.8541,1.8004,1.8038,1.8094,1.8226,1.8541,1.8004,0.2607,2.5207,-0.5004,-0.0340,3.4624,27.4883,22.6512,22.6512,20.6407,0.0095,7.8392,11.0729,18.6816,11.0729,555.4185,10.5918,2.8508,1.7214,92.3310,76.9589,61.8776,2.3838,2.8159,9.0100,3.1997,1.1813,3.7797,2.4000
 1068.5000,2191.8911,0.0187,1.8841,1.8358,1.8356,1.8385,1.8521,1.8841,1.8358,0.2611,2.5155,-0.5468,0.2155,3.5172,26.5853,21.7645,21.7645,19.8074,0.0053,8.1513,11.3740,18.9570,11.3740,544.7214,10.5839,2.8980,1.7439,89.5679,74.9888,60.4817,2.3400,2.7310,8.7596,3.2074,1.1671,3.7434,4.8000
 1069.0000,2182.0781,0.0083,1.8896,1.8681,1.8632,1.8630,1.8657,1.8896,1.8681,0.2622,2.5167,-0.2221,0.5103,3.5374,26.6156,21.7942,21.7942,19.8354,0.0022,8.0807,11.3059,18.8947,11.3059,535.2936,10.5572,2.9351,1.9788,88.3795,73.1035,58.7663,2.2832,2.6746,8.4655,3.1651,1.1714,3.7077,5.0000
 1069.5000,2147.0684,0.0138,1.9476,1.9106,1.8997,1.8959,1.9091,1.9476,1.9106,0.2609,2.5212,0.1117,0.2917,3.5368,27.0287,22.1993,22.1993,20.2162,-0.0001,7.8048,11.0397,18.6513,11.0397,523.4061,10.5286,2.9862,1.9225,86.5139,70.3113,56.2134,2.1872,2.6194,8.0828,3.0858,1.1976,3.6955,1.0000
 1070.0000,2151.2488,0.0126,2.0063,1.9714,1.9530,1.9449,1.9589,2.0063,1.9714,0.2610,2.5245,0.2468,-0.1902,3.5284,27.2186,22.3858,22.3858,20.3915,-0.0005,7.6080,10.8498,18.4776,10.8498,507.2455,10.4951,2.9893,1.8658,84.0434,68.9991,54.8861,2.1493,2.6195,7.8267,2.9879,1.2188,3.6415,1.0000
 1070.5000,2195.7139,0.0132,2.0804,2.0426,2.0147,2.0015,2.0180,2.0804,2.0426,0.2608,2.5249,0.0914,-0.2842,3.4869,27.3201,22.4856,22.4856,20.4853,0.0013,7.5799,10.8227,18.4528,10.8227,489.5784,10.4739,3.0440,1.8369,84.1862,68.9433,54.2024,2.1331,2.7143,7.6790,2.8291,1.2724,3.5999,4.0000
 1071.0000,2144.0620,0.0162,2.1596,2.1116,2.0726,2.0535,2.0749,2.1596,2.1116,0.2611,2.5245,-0.2042,-0.3931,3.4131,27.7101,22.8696,22.8696,20.8457,0.0043,7.6075,10.8494,18.4772,10.8494,473.5722,10.4785,2.8903,1.8484,87.0724,69.1639,53.6929,2.1310,2.8195,7.5216,2.6677,1.3231,3.5296,6.0000
 1071.5000,2147.3562,0.0211,2.2480,2.1831,2.1320,2.1065,2.1343,2.2480,2.1831,0.2613,2.5248,-0.3003,-0.4471,3.3376,26.5986,21.7775,21.7775,19.8197,0.0090,7.5878,10.8303,18.4598,10.8303,458.0708,10.4918,2.5512,1.8380,87.4811,68.3528,52.2214,2.0787,2.8899,7.2864,2.5213,1.3902,3.5052,0.0000
 1072.0000,2152.7805,-0.0117,2.3248,2.3624,2.2948,2.2603,2.2972,2.3248,2.3624,0.2631,2.5280,0.1803,-0.1576,3.3903,23.9568,19.2094,19.2094,17.3962,0.0144,7.3965,10.6457,18.2910,10.6457,423.3011,10.5219,2.1395,1.7250,82.7980,64.0441,48.3856,1.9186,2.7699,6.7863,2.4500,1.4437,3.5370,0.8000
 1072.5000,2143.2905,-0.0223,3.2127,3.3118,3.1589,3.0865,3.1596,3.2131,3.3118,0.2620,2.5419,0.8939,0.3479,3.6502,20.6896,16.0875,16.0875,14.4289,0.0207,6.5489,9.8279,17.5431,9.8279,301.9467,10.3981,2.3716,2.7941,72.5547,54.5802,40.6146,1.5976,2.4479,5.7578,2.3521,1.5323,3.6041,2.4000
 1073.0000,2141.7937,-0.0388,6.6917,7.0528,6.4463,6.1779,6.4711,6.6951,7.0528,0.2629,2.5762,1.0068,0.4752,3.9463,14.9708,10.7695,10.7695,9.3159,0.0290,4.4753,7.8270,15.7134,7.8270,141.7878,10.0681,6.9380,8.7517,56.8156,43.4787,32.0705,1.2538,2.0067,4.5828,2.2838,1.6004,3.6550,3.2000
 1073.5000,2100.3101,-0.0683,16.4731,18.0452,15.4093,14.2908,15.5045,16.5023,18.0452,0.2640,2.6218,0.5723,0.2344,4.1565,10.3785,6.6368,6.6368,5.2861,0.0347,1.7071,5.1560,13.2710,5.1560,55.4165,9.8067,26.7703,24.1146,42.5227,35.2097,25.5714,0.9967,1.7013,3.6687,2.1564,1.7070,3.6810,2.4000
 1074.0000,2133.5935,-0.0693,18.6388,20.4431,17.4905,16.2233,17.5710,18.6784,20.4431,0.2634,2.6519,0.1295,-0.0579,4.3114,9.2967,5.6813,5.6813,4.3467,0.0323,-0.1135,3.3992,11.6645,3.3992,48.9162,9.6238,31.9019,27.4958,39.2305,34.0991,24.4416,0.9535,1.7153,3.5026,2.0419,1.7990,3.6735,1.0000
 1074.5000,2118.9673,-0.0397,8.8458,9.3345,8.5706,8.2246,8.5811,8.8531,9.3345,0.2653,2.6502,-0.0853,-0.2461,4.3148,11.6901,7.8045,7.8045,6.4301,0.0253,-0.0103,3.4988,11.7556,3.4989,107.1289,9.6804,13.3210,10.1609,47.3262,39.0167,27.5321,1.0822,2.0456,3.9066,1.9098,1.8901,3.6098,2.0000
 1075.0000,2135.1716,-0.0319,4.6893,4.8973,4.6250,4.5029,4.6075,4.6903,4.8973,0.2668,2.6276,-0.1441,0.0579,4.1394,15.5763,11.3237,11.3237,9.8524,0.0196,1.3546,4.8158,12.9599,4.8158,204.1950,9.7502,7.8587,5.5562,60.1604,47.4410,33.1568,1.3085,2.5614,4.6801,1.8271,1.9575,3.5766,2.0000
 1075.5000,2146.6533,-0.0281,3.1417,3.2642,3.1209,3.0596,3.1034,3.1417,3.2642,0.2677,2.5981,-0.2468,0.2218,3.8846,18.2507,13.7965,13.7965,12.2357,0.0159,3.1465,6.5449,14.5410,6.5449,306.3506,9.8185,5.6698,3.3697,70.3430,55.1534,38.1788,1.5226,3.0556,5.3134,1.7389,2.0068,3.4897,0.0000
 1076.0000,2150.3738,-0.0294,2.7197,2.8307,2.7188,2.6743,2.6999,2.7197,2.8307,0.2684,2.5749,-0.3158,0.1503,3.6742,19.4142,14.8852,14.8852,13.2797,0.0122,4.5495,7.8986,15.7790,7.8986,353.2693,9.8665,3.0518,2.3444,76.1360,58.7301,40.2232,1.6154,3.3419,5.5447,1.6592,2.0688,3.4324,7.0000
 1076.5000,2140.3191,-0.0342,2.9958,3.1383,3.0131,2.9679,2.9842,2.9958,3.1383,0.2712,2.5722,-0.2178,-0.1062,3.6482,19.2314,14.7137,14.7137,13.1154,0.0080,4.7163,8.0596,15.9262,8.0596,318.6420,9.8659,4.5858,2.8919,76.2145,58.5738,39.7084,1.5944,3.4223,5.4753,1.5999,2.1465,3.4341,1.0000
 1077.0000,2154.4844,-0.0389,3.5088,3.6984,3.5543,3.5085,3.5088,3.5091,3.6984,0.2734,2.5791,-0.1180,-0.2251,3.7567,17.2405,12.8576,12.8576,11.3328,0.0040,4.2948,7.6529,15.5542,7.6529,270.3857,9.8649,4.7359,2.5338,70.6784,54.7850,36.5068,1.4617,3.3167,5.0534,1.5236,2.2690,3.4572,0.0000
 1077.5000,2186.4893,-0.0354,3.5628,3.7380,3.6240,3.5942,3.5773,3.5661,3.7380,0.2746,2.5770,-0.2159,0.0976,3.9140,17.7948,13.3720,13.3720,11.8278,0.0009,4.4254,7.7789,15.6695,7.7789,267.5224,9.8885,10.0010,6.8684,63.5034,51.5219,33.7537,1.3467,3.2033,4.6947,1.4656,2.3786,3.4860,1.0000
 1078.0000,2134.2156,-0.0148,2.7591,2.8154,2.7738,2.7686,2.7614,2.7601,2.8154,0.2750,2.5579,-0.2329,0.1049,3.9553,18.4672,13.9985,13.9985,12.4296,-0.0033,5.5800,8.8930,16.6882,8.8930,355.1927,9.9156,14.5169,8.4737,61.8984,51.9230,33.7969,1.3421,3.2533,4.7310,1.4542,2.4240,3.5250,0.0000
 1078.5000,2171.6333,0.0245,1.8427,1.7808,1.7772,1.7818,1.7894,1.8366,1.7808,0.2749,2.5334,0.1076,-0.0127,3.6893,22.2053,17.5283,17.5283,15.8014,-0.0078,7.0654,10.3262,17.9989,10.3263,561.5442,9.9532,5.4184,2.6143,70.1360,55.0454,35.5433,1.4167,3.4719,4.9507,1.4259,2.4508,3.4946,4.0000
 1079.0000,2171.2073,0.0467,1.4398,1.3482,1.3574,1.3649,1.3822,1.4294,1.3482,0.2759,2.5277,0.3373,-0.1264,3.3442,28.9744,24.1202,24.1202,22.0174,-0.0051,7.4149,10.6634,18.3072,10.6635,741.7498,10.0166,2.3838,1.4250,77.3021,58.1685,37.3167,1.4989,3.6834,5.1428,1.3962,2.4574,3.4310,1.0000
 1079.5000,2180.0515,0.0619,1.2797,1.1722,1.1880,1.1971,1.2238,1.2662,1.1722,0.2763,2.5262,0.0364,-0.4143,3.1536,31.7328,26.8789,26.8789,24.5905,0.0015,7.5022,10.7478,18.3843,10.7478,853.1097,10.0432,2.4884,1.5332,79.6771,60.3999,38.2683,1.5492,3.8888,5.2168,1.3415,2.5102,3.3674,0.0000
 1080.0000,2121.8926,0.0790,1.1226,1.0028,1.0208,1.0299,1.0622,1.1059,1.0028,0.2753,2.5029,-0.3870,-0.4603,3.0223,32.7820,27.9391,27.9391,25.5751,0.0032,8.9138,12.1097,19.6298,12.1098,997.1661,10.0729,2.2958,1.5177,78.4869,56.7495,35.1283,1.4255,3.7634,4.7727,1.2682,2.6402,3.3482,3.2000
 1080.5000,2103.4434,0.0976,0.9822,0.8535,0.8709,0.8793,0.9130,0.9625,0.8535,0.2753,2.4692,-0.3276,0.0742,2.9257,32.7975,27.9548,27.9548,25.5897,0.0032,10.9570,14.0813,21.4326,14.0813,1171.6775,10.1427,2.0414,1.4025,68.0777,50.8952,30.8181,1.2545,3.4616,4.1682,1.2041,2.7592,3.3224,2.4000
 1081.0000,2168.1660,0.1156,0.8893,0.7520,0.7686,0.7764,0.8098,0.8661,0.7520,0.2760,2.4451,0.0915,0.4662,2.9092,32.5766,27.7311,27.7311,25.3821,0.0070,12.4164,15.4895,22.7204,15.4895,1329.7355,10.1486,1.5043,1.2348,54.7841,42.4694,24.9905,1.0200,2.9771,3.3670,1.1310,2.9186,3.3009,3.2000
 1081.5000,2120.6262,0.1310,0.8786,0.7256,0.7429,0.7511,0.7867,0.8534,0.7256,0.2761,2.4407,0.3610,0.2460,2.9299,33.0544,28.2154,28.2154,25.8314,0.0128,12.6852,15.7489,22.9575,15.7489,1378.2292,10.1506,1.6832,1.2622,43.8226,34.2711,19.3432,0.7894,2.5133,2.6067,1.0372,3.1837,3.3021,0.0000
 1082.0000,2060.7507,0.1443,0.9532,0.7712,0.7916,0.8015,0.8436,0.9289,0.7712,0.2754,2.4402,0.2061,0.0970,2.9895,33.5921,28.7618,28.7618,26.3377,0.0182,12.7161,15.7787,22.9848,15.7787,1296.6439,10.0337,2.2083,1.7091,35.4673,27.8697,14.8708,0.6043,2.1666,2.0165,0.9307,3.5856,3.3372,3.2000
 1082.5000,2093.7341,0.1557,0.9868,0.7843,0.8057,0.8167,0.8623,0.9603,0.7843,0.2760,2.4138,-0.1618,-0.1205,3.1351,32.0474,27.1962,27.1962,24.8854,0.0270,14.3131,17.3197,24.3939,17.3197,1274.9951,9.8681,2.9697,2.4865,28.7767,22.7550,11.4224,0.4640,1.8724,1.5496,0.8276,4.0355,3.3398,2.0000
 1083.0000,2146.9648,0.1567,0.9382,0.7445,0.7632,0.7735,0.8157,0.9120,0.7445,0.2766,2.3744,-0.2332,-0.4349,3.3163,31.4564,26.6006,26.6006,24.3316,0.0420,16.7052,19.6278,26.5046,19.6278,1343.1604,9.7311,2.8035,2.4336,25.2579,20.2185,9.5483,0.3861,1.7472,1.3038,0.7462,4.5253,3.3769,1.0000
 1083.5000,2125.0596,0.1606,0.9730,0.7674,0.7856,0.7969,0.8403,0.9425,0.7674,0.2759,2.3756,-0.0297,-0.3573,3.4033,31.1119,26.2543,26.2543,24.0093,0.0592,16.6294,19.5546,26.4377,19.5546,1303.1771,9.5679,1.7450,1.7502,26.0377,19.3418,8.6023,0.3468,1.7443,1.1796,0.6763,5.0298,3.4015,3.0000
 1084.0000,2095.4963,0.1678,1.1305,0.8815,0.9025,0.9173,0.9686,1.0917,0.8815,0.2766,2.4173,0.0793,0.1342,3.3777,29.2986,24.4422,24.4422,22.3186,0.0653,14.1035,17.1174,24.2089,17.1174,1134.4441,9.5528,2.5845,2.3646,28.7589,19.7037,8.2866,0.3328,1.8329,1.1424,0.6233,5.5080,3.4329,0.0000
 1084.5000,2160.3699,0.1673,1.3406,1.0461,1.0702,1.0903,1.1489,1.2936,1.0461,0.2761,2.4443,0.0444,0.7382,3.2819,27.5736,22.7352,22.7352,20.7195,0.0579,12.4664,15.5377,22.7644,15.5377,955.9144,9.5584,3.7158,2.7615,30.7172,21.4020,8.4434,0.3272,2.0555,1.2203,0.5937,6.2819,3.7294,6.0000
 1085.0000,2167.3259,0.1613,1.7554,1.3829,1.4143,1.4474,1.5173,1.7033,1.3829,0.2754,2.4804,0.0495,0.5344,3.1118,24.0136,19.2642,19.2642,17.4481,0.0526,10.2812,13.4292,20.8363,13.4292,723.1210,9.5564,3.6332,2.2777,33.7792,25.0085,9.2962,0.3501,2.4679,1.3916,0.5639,7.0487,3.9746,2.4000
 1085.5000,2200.0562,0.1461,2.7971,2.2568,2.3116,2.3931,2.4833,2.7630,2.2568,0.2756,2.5797,-0.0081,-0.2174,2.9785,18.6572,14.1760,14.1760,12.6000,0.0461,4.2617,7.6210,15.5251,7.6210,443.1001,9.5311,9.7459,10.3821,39.3768,29.7549,10.5382,0.3773,2.9876,1.6703,0.5591,7.9174,4.4266,3.2000
 1086.0000,2124.9324,0.0625,4.0850,3.7386,3.8149,4.0007,4.0382,4.1115,3.7386,0.2755,2.6891,-0.1027,-0.2788,2.9926,14.9816,10.7794,10.7794,9.3255,0.0325,-2.3704,1.2215,9.6732,1.2216,267.4783,9.4787,28.7196,32.6324,46.6330,34.7630,11.9413,0.4104,3.5224,1.9740,0.5604,8.5818,4.8094,0.8000
 1086.5000,2062.1555,0.0513,4.1199,3.8320,3.8405,3.9699,3.9093,4.1067,3.8320,0.2748,2.7224,-0.0673,0.0206,3.0402,14.9369,10.7386,10.7386,9.2860,0.0289,-4.3893,-0.7265,7.8918,-0.7265,260.9608,9.5788,31.0545,26.5735,52.7124,39.2424,13.3620,0.4534,3.9621,2.2369,0.5646,8.7395,4.9341,2.0000
 1087.0000,2145.4792,0.0338,2.6377,2.5156,2.5081,2.5502,2.5101,2.6034,2.5156,0.2749,2.6730,-0.1328,0.1228,3.0200,18.0125,13.5746,13.5746,12.0225,0.0387,-1.3941,2.1636,10.5346,2.1636,397.5134,9.6174,14.3759,8.4222,57.9567,43.1224,14.9199,0.5025,4.3137,2.5153,0.5831,8.5840,5.0052,8.0000
 1087.5000,2137.7964,0.0249,1.7418,1.6823,1.6745,1.6910,1.6756,1.7326,1.6823,0.2757,2.5996,-0.2040,0.2552,2.9753,22.0269,17.3580,17.3580,15.6394,0.0494,3.0565,6.4580,14.4616,6.4580,594.4174,9.6603,6.4518,3.1963,63.4874,46.3341,16.2867,0.5588,4.5976,2.6972,0.5867,8.2280,4.8270,4.0000
 1088.0000,2082.5166,0.0033,1.3693,1.3631,1.3557,1.3642,1.3618,1.3682,1.3631,0.2769,2.5561,0.0016,-0.0038,2.9576,25.7376,20.9363,20.9363,19.0275,0.0499,5.6918,9.0008,16.7869,9.0008,733.6250,9.7395,3.5392,1.8150,64.0289,47.7584,17.1283,0.6065,4.7107,2.7472,0.5832,7.7671,4.5297,2.0000
 1088.5000,2149.4976,0.0275,1.3127,1.2632,1.2559,1.2599,1.2681,1.3124,1.2632,0.2752,2.5351,0.1639,-0.6175,2.9659,27.3305,22.4958,22.4958,20.4948,0.0339,6.9664,10.2307,17.9115,10.2307,791.6121,9.8810,3.2676,1.7469,60.1559,46.9519,17.2665,0.6249,4.5958,2.7053,0.5886,7.3544,4.3290,2.0000
 1089.0000,2183.7832,0.0308,1.2791,1.2252,1.2187,1.2195,1.2293,1.2788,1.2252,0.2763,2.5172,0.0417,-0.5291,2.9464,27.8116,22.9697,22.9697,20.9395,0.0166,8.0472,11.2736,18.8651,11.2736,816.1881,10.0214,3.2561,1.7039,55.9412,46.0311,17.6703,0.6523,4.4150,2.7081,0.6134,6.7688,4.1519,3.0000
 1089.5000,2075.6875,0.0417,1.2441,1.1733,1.1679,1.1658,1.1827,1.2437,1.1733,0.2765,2.5051,-0.0945,-0.0858,2.9069,27.7984,22.9566,22.9566,20.9273,0.0096,8.7793,11.9800,19.5112,11.9800,852.3008,10.0958,3.2457,1.6968,56.4079,45.8310,18.5236,0.6867,4.2773,2.8251,0.6605,6.2291,4.1142,2.4000
 1090.0000,2156.2930,0.0458,1.1978,1.1230,1.1183,1.1141,1.1366,1.1973,1.1230,0.2764,2.4817,-0.1825,0.1537,2.8487,28.1486,23.3024,23.3024,21.2515,0.0054,10.2007,13.3515,20.7653,13.3515,890.4565,10.0872,2.6077,1.3367,61.0571,46.5097,19.8425,0.7415,4.1929,2.9982,0.7151,5.6549,4.0436,0.0000
 1090.5000,2192.9155,0.0425,1.2133,1.1429,1.1380,1.1316,1.1563,1.2129,1.1429,0.2747,2.4610,-0.0217,0.2171,2.8100,28.2084,23.3615,23.3615,21.3069,0.0011,11.4551,14.5619,21.8721,14.5619,874.9915,10.1459,2.0159,1.1845,63.6596,47.6448,21.5338,0.8064,4.1168,3.2454,0.7883,5.1050,4.0245,4.0000
 1091.0000,2199.3994,0.0303,1.4009,1.3428,1.3358,1.3255,1.3522,1.4007,1.3428,0.2744,2.4864,0.4018,-0.0590,2.8987,26.8963,22.0693,22.0693,20.0941,0.0012,9.9147,13.0756,20.5130,13.0756,744.7311,10.1670,2.7618,1.5543,63.4374,48.5878,23.1916,0.8708,4.0186,3.4842,0.8670,4.6147,4.0011,1.6000
 1091.5000,2122.7676,0.0069,1.6750,1.6590,1.6471,1.6310,1.6524,1.6752,1.6590,0.2755,2.5345,0.4205,-0.0803,3.0509,24.8894,20.1115,20.1115,18.2492,0.0039,6.9992,10.2624,17.9405,10.2624,602.7552,10.1987,3.6895,2.0044,63.9442,50.6892,25.6690,0.9622,3.9826,3.8642,0.9703,4.1389,4.0158,3.0000
 1092.0000,2132.8569,-0.0187,1.9543,2.0049,1.9877,1.9680,1.9692,1.9552,2.0049,0.2756,2.5638,0.2156,0.2707,3.1897,24.1774,19.4224,19.4224,17.5978,0.0054,5.2223,8.5478,16.3726,8.5478,498.7664,10.2118,3.9480,2.2625,68.4863,54.3839,29.1814,1.0963,4.0482,4.3814,1.0823,3.6925,3.9965,2.0000
 1092.5000,2141.6440,-0.0405,2.1731,2.2955,2.2715,2.2499,2.2239,2.1746,2.2955,0.2760,2.5803,0.3226,0.2914,3.3267,24.4873,19.7220,19.7220,17.8812,0.0082,4.2214,7.5820,15.4895,7.5821,435.6381,10.2372,4.5785,2.5376,74.6335,59.4403,33.5261,1.2689,4.2052,4.9893,1.1865,3.3140,3.9319,3.0000
 1093.0000,2053.6675,-0.0515,2.2638,2.4264,2.3963,2.3759,2.3258,2.2656,2.4264,0.2766,2.5906,0.3233,0.0629,3.3949,25.0928,20.3089,20.3089,18.4356,0.0113,3.5983,6.9808,14.9397,6.9809,412.1269,10.2930,4.3323,2.4470,81.1367,63.9067,37.5718,1.4286,4.3134,5.5604,1.2891,3.0194,3.8923,3.0000
 1093.5000,2088.6326,-0.0536,2.3001,2.4718,2.4364,2.4189,2.3547,2.3020,2.4718,0.2754,2.5887,0.0631,0.1657,3.3835,26.5757,21.7551,21.7551,19.7986,0.0118,3.7179,7.0963,15.0452,7.0963,404.5558,10.3393,3.8446,2.2974,85.5513,67.5473,41.0579,1.5661,4.3753,6.0525,1.3833,2.7937,3.8646,0.8000
 1094.0000,2145.7434,-0.0513,2.3223,2.4883,2.4480,2.4336,2.3652,2.3244,2.4883,0.2748,2.5780,-0.2184,0.0834,3.3700,26.2001,21.3876,21.3876,19.4527,0.0121,4.3643,7.7199,15.6155,7.7199,401.8873,10.3788,3.5078,2.1371,85.0329,68.9045,43.2032,1.6398,4.2769,6.4076,1.4982,2.6082,3.9077,5.6000
 1094.5000,2071.2878,-0.0487,2.3609,2.5211,2.4760,2.4638,2.3964,2.3631,2.5211,0.2765,2.5677,-0.3878,-0.0954,3.3557,26.5809,21.7602,21.7602,19.8034,0.0137,4.9852,8.3190,16.1634,8.3190,396.6510,10.4322,3.5757,2.0341,82.5696,68.3547,44.0807,1.6802,4.0797,6.5037,1.5942,2.4280,3.8707,7.2000
 1095.0000,1980.3300,-0.0483,2.4259,2.5892,2.5388,2.5272,2.4601,2.4283,2.5892,0.2749,2.5649,-0.1347,0.0873,3.3252,25.7296,20.9284,20.9284,19.0201,0.0128,5.1595,8.4872,16.3172,8.4872,386.2202,10.4665,3.3560,2.0163,82.0583,66.2260,43.8939,1.6796,3.7886,6.4457,1.7013,2.2557,3.8377,2.4000
 1095.5000,2016.8840,-0.0512,2.5236,2.7035,2.6471,2.6343,2.5634,2.5262,2.7035,0.2759,2.5740,0.1846,-0.0684,3.3627,24.9242,20.1453,20.1453,18.2812,0.0104,4.6039,7.9511,15.8270,7.9511,369.8957,10.4397,3.3438,2.1175,82.6249,64.5539,43.7165,1.6901,3.5821,6.3372,1.7691,2.1194,3.7495,0.0000
 1096.0000,2113.2898,-0.0549,2.6812,2.8865,2.8231,2.8070,2.7295,2.6834,2.8865,0.2756,2.5856,0.0700,0.0969,3.4689,24.5925,19.8238,19.8238,17.9774,0.0086,3.9048,7.2766,15.2101,7.2766,346.4440,10.4933,4.1702,2.4831,81.7220,63.5397,43.6230,1.7000,3.4574,6.2597,1.8105,2.0338,3.6822,2.4000
 1096.5000,2086.3057,-0.0551,2.7560,2.9679,2.9006,2.8807,2.8024,2.7578,2.9679,0.2749,2.5870,-0.0546,0.3203,3.5119,23.5501,18.8175,18.8175,17.0250,0.0068,3.8202,7.1949,15.1355,7.1949,336.9433,10.4321,4.4841,2.6027,79.7012,63.5067,43.7452,1.7115,3.4442,6.2451,1.8132,2.0123,3.6488,2.0000
 1097.0000,2013.9587,-0.0505,2.7243,2.9161,2.8494,2.8264,2.7549,2.7260,2.9161,0.2758,2.5842,0.1954,-0.1774,3.5234,23.3534,18.6283,18.6283,16.8457,0.0072,3.9874,7.3563,15.2830,7.3563,342.9208,10.4353,3.6410,2.4449,79.6574,63.1302,43.1039,1.6982,3.4892,6.0980,1.7477,2.0547,3.5909,2.0000
 1097.5000,2102.7405,-0.0438,2.6993,2.8637,2.7989,2.7734,2.7108,2.7010,2.8637,0.2752,2.5855,0.4656,-0.1596,3.6052,23.5593,18.8264,18.8264,17.0334,0.0100,3.9113,7.2828,15.2158,7.2828,349.2006,10.4410,3.5301,2.5276,79.2390,60.8311,41.1562,1.6284,3.4037,5.7893,1.7009,2.0902,3.5552,0.0000
 1098.0000,2153.9434,-0.0381,2.7647,2.9112,2.8476,2.8193,2.7623,2.7659,2.9112,0.2751,2.5897,0.3176,0.1862,3.6522,24.6827,19.9112,19.9112,18.0600,0.0121,3.6528,7.0334,14.9878,7.0334,343.5029,10.4340,3.5461,2.3078,76.7221,59.4655,39.8162,1.5799,3.3824,5.5796,1.6496,2.1409,3.5317,2.0000
 1098.5000,2139.8816,-0.0347,2.8655,3.0037,2.9415,2.9110,2.8564,2.8668,3.0037,0.2749,2.5944,-0.0450,0.2250,3.5546,24.0688,19.3174,19.3174,17.4985,0.0133,3.3684,6.7590,14.7369,6.7590,332.9241,10.4239,3.8649,2.4281,75.9977,58.0172,38.7137,1.5310,3.3014,5.4495,1.6507,2.1564,3.5596,0.0000
 1099.0000,2152.6309,-0.0321,2.8832,3.0117,2.9537,2.9231,2.8720,2.8843,3.0117,0.2757,2.5984,-0.0458,0.3954,3.4534,22.7648,18.0634,18.0634,16.3098,0.0145,3.1292,6.5281,14.5257,6.5281,332.0409,10.4230,4.2150,2.5446,74.1705,58.4292,39.0350,1.5271,3.3097,5.5732,1.6839,2.1673,3.6495,0.0000
 1099.5000,2210.5022,-0.0281,2.7893,2.8979,2.8467,2.8184,2.7740,2.7896,2.8979,0.2763,2.5972,0.2466,0.5051,3.4738,23.7422,19.0025,19.0025,17.2003,0.0139,3.1981,6.5946,14.5865,6.5946,345.0807,10.4370,4.0901,2.5959,73.3639,59.4551,39.5889,1.5300,3.3820,5.7414,1.6976,2.2104,3.7525,0.8000
 1100.0000,2164.8381,-0.0215,2.6496,2.7287,2.6848,2.6598,2.6245,2.6497,2.7287,0.2746,2.5869,0.2084,-0.1635,3.5077,23.3658,18.6402,18.6402,16.8570,0.0108,3.8268,7.2013,15.1413,7.2013,366.4815,10.4448,4.1752,2.5744,76.3483,62.2706,41.1222,1.5785,3.5795,6.0150,1.6804,2.2677,3.8106,1.0000
 1100.5000,2190.1287,-0.0131,2.5576,2.6041,2.5659,2.5446,2.5174,2.5576,2.6041,0.2745,2.5773,0.0175,-0.7935,3.4473,24.3177,19.5579,19.5579,17.7260,0.0087,4.4031,7.7573,15.6498,7.7574,384.0135,10.4651,3.7230,2.3018,82.8890,64.6309,42.0821,1.6127,3.7973,6.1678,1.6242,2.3546,3.8244,2.0000
 1101.0000,2186.5129,-0.0054,2.5472,2.5663,2.5314,2.5125,2.4910,2.5472,2.5663,0.2749,2.5749,-0.0385,-0.2224,3.3641,24.9427,20.1633,20.1633,18.2981,0.0077,4.5494,7.8985,15.7788,7.8985,389.6602,10.4633,3.7918,2.3000,90.1023,67.8102,42.9434,1.6488,4.1491,6.2794,1.5134,2.5165,3.8085,0.0000
 1101.5000,2182.1130,-0.0001,2.5727,2.5730,2.5393,2.5217,2.5031,2.5727,2.5730,0.2755,2.5688,-0.2787,0.5704,3.3421,25.5167,20.7211,20.7211,18.8246,0.0067,4.9235,8.2595,16.1090,8.2595,388.6498,10.4699,3.6996,2.1604,92.0726,70.5464,43.1079,1.6667,4.5186,6.2485,1.3828,2.7111,3.7490,5.0000
 1102.0000,2189.5181,0.0024,2.6017,2.5933,2.5593,2.5425,2.5236,2.6017,2.5933,0.2754,2.5601,-0.3167,0.6445,3.3823,24.3256,19.5656,19.5656,17.7333,0.0067,5.4489,8.7665,16.5726,8.7665,385.6151,10.4752,3.0649,2.2288,90.9374,69.2671,40.3744,1.5738,4.6708,5.7918,1.2400,2.9679,3.6802,3.2000
 1102.5000,2162.0737,0.0017,2.7954,2.7889,2.7504,2.7318,2.7060,2.7954,2.7889,0.2762,2.5607,0.1852,0.1897,3.5467,21.2638,16.6318,16.6318,14.9480,0.0076,5.4111,8.7300,16.5392,8.7300,358.5656,10.4122,3.4172,2.2572,83.7842,63.8934,35.7019,1.3895,4.4870,5.1317,1.1437,3.2293,3.6933,2.4000
 1103.0000,2175.2842,-0.0021,3.4559,3.4658,3.4093,3.3822,3.3364,3.4559,3.4658,0.2762,2.5763,0.5408,-0.2036,3.8826,17.5113,13.1087,13.1087,11.5745,0.0096,4.4693,7.8212,15.7082,7.8212,288.5377,10.2752,5.5548,3.6969,68.4531,53.2861,28.4616,1.1113,3.9008,4.0740,1.0444,3.5102,3.6661,2.0000
 1103.5000,2179.7063,-0.0013,4.3449,4.3527,4.2707,4.2305,4.1626,4.3442,4.3527,0.2745,2.5975,0.2651,-0.1949,4.2285,14.3273,10.1830,10.1830,8.7471,0.0119,3.1824,6.5795,14.5727,6.5795,229.7415,10.2288,7.4159,4.8075,52.3261,42.5201,21.6076,0.8421,3.2598,3.1005,0.9511,3.8711,3.6820,2.0000
 1104.0000,2140.1123,0.0027,4.6425,4.6250,4.5306,4.4874,4.4348,4.6407,4.6250,0.2748,2.5963,-0.2423,0.0444,4.3368,13.2199,9.1792,9.1792,7.7714,0.0137,3.2568,6.6512,14.6383,6.6512,216.2179,10.1295,7.3484,4.6612,42.4692,35.5468,17.2339,0.6695,2.8335,2.4828,0.8762,4.2320,3.7082,0.8000
 1104.5000,2130.1150,-0.0236,4.3206,4.4619,4.3741,4.3350,4.3255,4.3190,4.4619,0.2765,2.5787,-0.3390,0.2164,4.2137,13.4889,9.4223,9.4223,8.0080,0.0156,4.3227,7.6798,15.5788,7.6798,224.1173,10.0370,7.0799,4.4901,41.6153,33.2281,15.3274,0.5929,2.7487,2.2205,0.8078,4.6363,3.7453,3.2000
 1105.0000,2133.9041,-0.0027,4.2543,4.2703,4.1888,4.1536,4.1949,4.2529,4.2703,0.2748,2.5758,-0.0512,0.0614,4.1065,14.2908,10.1497,10.1497,8.7149,0.0188,4.4991,7.8500,15.7345,7.8500,234.1772,9.9626,6.9510,4.4528,44.1625,33.2209,14.6417,0.5594,2.8246,2.1540,0.7626,5.0492,3.8504,1.0000
 1105.5000,2062.8123,0.0316,4.2291,4.0461,3.9719,3.9408,4.0286,4.2278,4.0461,0.2756,2.5751,0.0931,-0.3371,4.1624,15.4897,11.2442,11.2442,9.7755,0.0212,4.5418,7.8912,15.7722,7.8912,247.1510,9.9573,7.6073,5.0340,42.9902,33.9236,14.1310,0.5347,2.9826,2.1037,0.7053,5.5784,3.9347,0.0000
 1106.0000,2046.4236,0.0503,3.9067,3.6393,3.5787,3.5536,3.6585,3.9051,3.6393,0.2763,2.5595,-0.0175,-0.5308,4.2747,15.8611,11.5850,11.5850,10.1051,0.0186,5.4827,8.7991,16.6024,8.7991,274.7758,9.9906,9.3878,5.9050,41.6037,33.7746,13.2305,0.4964,3.0640,1.9895,0.6493,6.1721,4.0077,0.0000
 1106.5000,2074.3975,0.0523,3.4843,3.2364,3.1892,3.1705,3.2658,3.4826,3.2364,0.2758,2.5426,-0.1021,-0.3093,4.3033,15.4711,11.2272,11.2272,9.7591,0.0141,6.5065,9.7870,17.5058,9.7870,308.9826,9.9934,9.1725,6.0031,42.7101,34.1189,12.5204,0.4683,3.1957,1.8896,0.5913,6.8236,4.0347,0.8000
 1107.0000,2063.4805,0.0471,3.2177,3.0110,2.9718,2.9563,3.0396,3.2161,3.0110,0.2764,2.5370,-0.1745,0.0927,4.2556,15.0903,10.8787,10.8787,9.4217,0.0105,6.8480,10.1164,17.8070,10.1165,332.1154,9.9740,8.6033,5.6648,44.0010,36.5749,12.8710,0.4790,3.4769,1.9539,0.5620,7.2581,4.0788,1.0000
 1107.5000,2143.9585,0.0410,3.0867,2.9138,2.8786,2.8648,2.9391,3.0850,2.9138,0.2761,2.5307,-0.3310,0.3473,4.1678,15.6749,11.4141,11.4141,9.9398,0.0051,7.2308,10.4859,18.1448,10.4859,343.1894,9.9607,8.5179,5.0238,48.8492,41.3917,14.5383,0.5400,3.9194,2.2124,0.5645,7.2586,4.0973,1.0000
 1108.0000,2151.8818,0.0343,3.0626,2.9189,2.8843,2.8713,2.9397,3.0608,2.9189,0.2763,2.5170,-0.1452,0.2263,4.1290,15.3709,11.1355,11.1355,9.6703,0.0023,8.0629,11.2888,18.8790,11.2888,342.5904,9.9768,6.3363,4.1699,58.3876,48.5544,17.7013,0.6546,4.5028,2.7073,0.6012,6.8791,4.1360,2.4000
 1108.5000,2164.1475,0.0208,3.3109,3.2164,3.1740,3.1597,3.2283,3.3093,3.2164,0.2768,2.5293,0.4139,-0.0335,4.3393,15.0139,10.8089,10.8089,9.3540,0.0092,7.3142,10.5663,18.2184,10.5663,310.9035,10.0032,5.3008,3.7648,68.2838,54.8182,21.5164,0.7896,4.8554,3.3196,0.6837,6.1494,4.2044,0.0000
 1109.0000,2158.7109,0.0080,3.8509,3.8085,3.7476,3.7302,3.7988,3.8500,3.8085,0.2756,2.5823,0.4863,-0.2172,4.9072,13.7909,9.6959,9.6959,8.2740,0.0111,4.1035,7.4683,15.3854,7.4683,262.5694,10.0184,7.5160,4.2287,75.0056,58.9524,24.8389,0.9032,4.9941,3.8714,0.7752,5.5291,4.2861,2.4000
 1109.5000,2133.5239,0.0014,4.4043,4.3957,4.3122,4.2925,4.3576,4.4045,4.3957,0.2757,2.6266,-0.1446,-0.2554,5.4193,12.7408,8.7472,8.7472,7.3505,-0.0107,1.4196,4.8786,13.0173,4.8786,227.4931,10.0250,7.3762,4.3669,77.6607,57.2751,25.6580,0.9118,4.6541,4.0999,0.8809,5.1044,4.4966,0.0000
 1110.0000,2174.7195,0.0017,4.5390,4.5284,4.4358,4.4178,4.4883,4.5392,4.5284,0.2748,2.6132,-0.5317,-0.0695,5.2372,13.0535,9.0290,9.0290,7.6251,-0.0321,2.2331,5.6635,13.7350,5.6635,220.8268,10.0629,11.3935,7.5335,69.7095,51.0311,24.0637,0.8449,4.0126,3.8937,0.9704,4.7492,4.6084,4.0000
 1110.5000,2220.7512,0.0133,4.3496,4.2700,4.1817,4.1661,4.2566,4.3493,4.2700,0.2758,2.5630,-0.2847,0.2235,4.6286,13.5649,9.4912,9.4912,8.0750,-0.0220,5.2750,8.5987,16.4191,8.5987,234.1916,10.0496,12.4761,8.6301,52.7302,43.3217,21.4238,0.7378,3.3038,3.5348,1.0699,4.4778,4.7910,1.6000
 1111.0000,2197.5920,0.0281,4.1086,3.9507,3.8677,3.8536,3.9305,4.1091,3.9507,0.2750,2.5288,-0.0934,0.0574,4.2904,13.7238,9.6350,9.6350,8.2149,-0.0021,7.3444,10.5954,18.2450,10.5955,253.1200,10.0333,10.1747,6.6935,43.7138,37.1203,19.0058,0.6495,2.7762,3.1599,1.1382,4.2746,4.8653,4.0000
 1111.5000,2178.1172,-0.0113,3.9637,4.0257,3.9301,3.9101,3.9367,3.9725,4.0257,0.2757,2.5357,-0.1771,-0.3315,4.2856,13.2882,9.2409,9.2409,7.8315,0.0019,6.9285,10.1942,17.8781,10.1942,248.4022,10.0408,9.6293,6.0370,44.6265,34.6145,18.6456,0.6359,2.4880,3.1058,1.2483,3.9123,4.8837,2.4000
 1112.0000,2152.8953,-0.0009,4.2472,4.2524,4.1358,4.1036,4.0571,4.2420,4.2524,0.2761,2.5687,-0.1740,-0.0974,4.3307,12.6154,8.6343,8.6343,7.2404,-0.0019,4.9257,8.2616,16.1109,8.2616,235.1619,10.0161,12.1394,8.3894,46.0754,36.6706,20.8403,0.7098,2.5115,3.4762,1.3841,3.5384,4.8975,4.8000
 1112.5000,2222.3291,-0.0350,3.8113,3.9965,3.8841,3.8442,3.7407,3.8351,3.9965,0.2757,2.5862,0.0864,0.3122,4.1309,13.4081,9.3493,9.3493,7.9369,-0.0058,3.8685,7.2416,15.1781,7.2416,250.2201,10.0725,11.5474,6.8430,53.2727,42.7766,25.7750,0.8833,2.7452,4.2736,1.5567,3.1080,4.8384,0.0000
 1113.0000,2200.9773,-0.0830,3.1369,3.5017,3.3991,3.3540,3.2235,3.2176,3.5017,0.2747,2.5768,0.3387,0.4866,3.7962,15.8958,11.6169,11.6169,10.1359,-0.0025,4.4352,7.7883,15.6781,7.7883,285.5782,10.0669,4.9839,2.9419,67.3880,49.2195,31.4484,1.0872,2.9251,5.1690,1.7671,2.6905,4.7544,1.0000
 1113.5000,2208.6362,-0.1266,2.9262,3.4482,3.3439,3.2869,3.1126,3.0103,3.4482,0.2744,2.5661,0.1331,0.1206,3.6611,19.0559,14.5491,14.5491,12.9577,0.0100,5.0842,8.4145,16.2507,8.4145,290.0068,10.0759,3.8404,2.4630,72.5342,52.8778,35.4647,1.2431,2.8991,5.7485,1.9829,2.3322,4.6244,0.8000
 1114.0000,2157.1218,-0.1745,2.9608,3.6924,3.5811,3.5078,3.2781,3.0406,3.6924,0.2748,2.5667,-0.2737,-0.4488,3.7230,19.8144,15.2615,15.2615,13.6397,0.0313,5.0458,8.3775,16.2169,8.3775,270.8266,9.9716,4.7701,3.7861,68.4176,52.5255,36.9231,1.3217,2.6315,5.8543,2.2247,1.9910,4.4293,1.6000
 1114.5000,2117.6311,-0.2207,2.8462,3.7381,3.6306,3.5461,3.2821,2.9312,3.7381,0.2749,2.5705,-0.3225,-0.5501,3.8015,20.3762,15.7912,15.7912,14.1461,0.0650,4.8184,8.1581,16.0162,8.1581,267.5121,9.9482,3.7015,2.5955,65.0496,50.6914,37.4911,1.3699,2.2823,5.8122,2.5467,1.6660,4.2428,3.0000
 1115.0000,2070.5513,-0.2523,2.5479,3.4610,3.3707,3.2865,3.0254,2.6322,3.4610,0.2758,2.5286,-0.0562,-0.7610,3.6705,25.7670,20.9649,20.9649,19.0545,0.0798,7.3573,10.6079,18.2564,10.6079,288.9377,10.3413,1.0012,1.3132,64.8408,51.2167,39.8021,1.4735,2.0618,6.0794,2.9486,1.3992,4.1257,0.0000
 1115.5000,2012.2200,-0.2564,2.2846,3.1167,3.0480,2.9702,2.7316,2.3642,3.1167,0.2749,2.3906,0.1330,-1.0092,3.4348,31.1339,26.2764,26.2764,24.0298,0.0847,15.7237,18.6807,25.6385,18.6807,320.8490,10.3523,2.1596,1.0865,66.1791,53.5539,43.4958,1.6280,1.9269,6.5597,3.4043,1.1836,4.0294,0.8000
 1116.0000,2055.4524,-0.2273,1.6431,2.1735,2.1361,2.0830,1.9222,1.6889,2.1735,0.2753,2.2096,-0.0647,-0.7946,3.3936,37.1821,32.4499,32.4499,29.7404,0.1363,26.6921,29.2643,35.3166,29.2643,460.0811,10.4466,0.9378,0.7389,69.6042,56.3939,47.5252,1.7848,1.8139,7.1387,3.9357,1.0163,3.9997,1.6000
 1116.5000,2110.5491,-0.1898,1.3209,1.6763,1.6560,1.6170,1.5023,1.3471,1.6763,0.2755,2.1066,-0.5011,-0.5170,3.4627,40.7027,36.1332,36.1332,33.1139,0.1934,32.9321,35.2854,40.8225,35.2854,596.5480,11.3991,0.7404,0.7882,73.1730,59.4949,51.3358,1.9307,1.7786,7.6980,4.3281,0.9212,3.9872,2.0000
 1117.0000,2171.3916,-0.1569,1.2411,1.5163,1.5048,1.4719,1.3804,1.2599,1.5163,0.2757,2.0983,-0.5767,-0.2693,3.4373,43.2790,38.8699,38.8699,35.6054,0.1911,33.4342,35.7698,41.2654,35.7698,659.4993,12.1351,0.7385,0.7754,74.1098,60.9295,53.5763,2.0161,1.7201,8.0285,4.6673,0.8532,3.9822,1.6000
 1117.5000,2166.0247,-0.1299,1.2413,1.4686,1.4630,1.4336,1.3597,1.2589,1.4686,0.2753,2.0898,-0.1019,0.2698,3.2455,42.7622,38.3181,38.3181,35.1041,0.1482,33.9506,36.2681,41.7211,36.2681,680.9050,12.7177,0.6099,0.6778,73.6842,60.6742,54.1068,2.0253,1.6475,8.1590,4.9525,0.8134,4.0285,1.6000
 1118.0000,2184.4626,-0.1095,1.3329,1.5382,1.5364,1.5081,1.4479,1.3559,1.5382,0.2740,2.0802,0.3015,0.7906,3.0297,43.0808,38.6580,38.6580,35.4130,0.0987,34.5322,36.8293,42.2343,36.8293,650.1223,12.7939,0.7196,0.7424,70.6365,58.2592,52.3787,1.9541,1.5484,7.9292,5.1210,0.7924,4.0576,1.0000
 1118.5000,2187.6982,-0.0849,1.4711,1.6461,1.6466,1.6188,1.5740,1.4929,1.6461,0.2761,2.1254,0.1835,0.9395,3.0523,41.3288,36.7952,36.7952,33.7177,0.0672,31.7945,34.1876,39.8186,34.1876,607.5089,12.4966,0.8942,0.7557,65.2298,56.8413,51.2844,1.9114,1.5089,7.7726,5.1513,0.7894,4.0665,4.0000
 1119.0000,2194.2629,-0.0552,1.6008,1.7241,1.7248,1.6981,1.6722,1.6150,1.7241,0.2766,2.1903,-0.0810,0.6615,3.2306,39.8724,35.2587,35.2587,32.3151,0.0703,27.8608,30.3920,36.3478,30.3920,580.0168,12.3787,0.7180,0.7341,63.1983,55.2020,49.7233,1.8590,1.4841,7.5087,5.0593,0.7984,4.0391,2.4000
 1119.5000,2218.5862,-0.0288,1.6866,1.7541,1.7526,1.7273,1.7198,1.6970,1.7541,0.2752,2.2419,-0.0041,0.2739,3.3163,38.0042,33.3041,33.3041,30.5249,0.0807,24.7307,27.3717,33.5859,27.3718,570.1085,12.3550,0.6851,0.7672,65.8829,54.2736,48.6197,1.8413,1.4980,7.2300,4.8265,0.8135,3.9265,1.6000
 1120.0000,2231.8303,-0.0089,1.8294,1.8520,1.8456,1.8206,1.8256,1.8365,1.8520,0.2751,2.3133,0.2646,-0.1280,3.4010,34.6507,29.8421,29.8421,27.3371,0.0702,20.4036,23.1964,29.7679,23.1964,539.9612,11.8641,0.9597,0.8409,69.4936,53.4714,47.7309,1.8304,1.4945,6.9898,4.6771,0.8165,3.8186,1.6000
 1120.5000,2210.0984,0.0018,2.0219,2.0170,2.0021,1.9755,1.9855,2.0262,2.0170,0.2742,2.4127,0.2474,-0.3790,3.5977,30.2906,25.4314,25.4314,23.2423,0.0518,14.3794,17.3836,24.4524,17.3837,495.7883,11.5100,1.1523,1.0290,70.2663,53.3012,47.4553,1.8350,1.4914,6.8775,4.6116,0.8127,3.7479,3.0000
 1121.0000,2177.6797,-0.0113,2.1422,2.1756,2.1499,2.1220,2.1249,2.1445,2.1756,0.2751,2.4920,-0.1211,-0.0060,3.7423,27.5758,22.7373,22.7373,20.7215,0.0354,9.5781,12.7508,20.2160,12.7508,459.6475,11.2757,1.2053,1.3076,68.3025,52.1804,46.5656,1.8104,1.4261,6.7024,4.6997,0.7878,3.7022,1.0000
 1121.5000,2181.8140,-0.0079,2.5176,2.5450,2.5020,2.4685,2.4475,2.5201,2.5450,0.2758,2.5378,-0.4205,0.6743,3.7731,22.5241,17.8330,17.8330,16.0909,0.0212,6.7998,10.0700,17.7645,10.0700,392.9265,10.7465,2.2699,1.8263,62.5622,48.7255,43.9241,1.7042,1.2582,6.3386,5.0377,0.7383,3.7194,0.8000
 1122.0000,2201.9331,-0.0290,3.5164,3.6580,3.5758,3.5240,3.4280,3.5242,3.6580,0.2747,2.5817,-0.1176,0.6053,3.8957,17.6296,13.2186,13.2186,11.6802,0.0172,4.1409,7.5043,15.4184,7.5043,273.3720,10.4266,3.3366,3.0369,51.0476,41.3285,37.3620,1.4467,1.0495,5.4053,5.1506,0.7254,3.7363,2.4000
 1122.5000,2198.8933,-0.0668,5.6037,6.1268,5.9620,5.8710,5.6090,5.6343,6.1268,0.2762,2.6307,0.3728,-0.1065,4.2113,12.5184,8.5471,8.5471,7.1553,0.0214,1.1683,4.6361,12.7956,4.6361,163.2186,10.2455,7.8970,6.2245,38.1626,32.9763,29.6756,1.1408,0.8641,4.3327,5.0144,0.7574,3.7980,0.0000
 1123.0000,2217.5269,-0.0998,7.5144,8.5679,8.3318,8.2169,7.8149,7.5794,8.5679,0.2750,2.6649,0.1303,-0.2190,4.4236,10.3236,6.5881,6.5881,5.2383,0.0253,-0.9003,2.6400,10.9703,2.6401,116.7142,10.0447,12.6518,8.6242,31.3096,29.8741,26.5022,1.0115,0.8480,3.9038,4.6036,0.8383,3.8592,1.6000
 1123.5000,2212.9314,-0.0948,4.7370,5.3673,5.2207,5.1588,4.9171,4.7513,5.3673,0.2754,2.6624,-0.3593,-0.2545,4.2158,13.0217,9.0003,9.0003,7.5972,0.0277,-0.7496,2.7854,11.1032,2.7854,186.3140,9.9215,10.9838,6.0791,39.3688,33.0737,28.7926,1.0953,1.0296,4.2587,4.1364,0.9400,3.8883,0.0000
 1124.0000,2196.1287,-0.0650,3.0131,3.2867,3.2045,3.1754,3.0539,3.0110,3.2867,0.2746,2.5924,-0.1265,-0.2529,3.7555,20.9181,16.3038,16.3038,14.6354,0.0336,3.4899,6.8762,14.8440,6.8762,304.2521,10.0139,4.0347,2.4658,57.6230,41.4124,35.9200,1.3505,1.3334,5.3883,4.0410,0.9873,3.9899,4.0000
 1124.5000,2146.9761,-0.0218,2.4963,2.5717,2.5188,2.5049,2.4464,2.4847,2.5717,0.2743,2.4895,0.3567,0.2149,3.4511,28.7998,23.9470,23.9470,21.8553,0.0588,9.7259,12.8934,20.3463,12.8934,388.8520,10.1370,1.9858,1.4520,70.1681,48.3028,41.9287,1.5604,1.5753,6.3657,4.0409,1.0096,4.0796,0.0000
 1125.0000,2192.8469,0.0124,2.0739,2.0385,2.0142,2.0108,1.9952,2.0565,2.0385,0.2755,2.4580,0.2926,0.3712,3.4327,30.0364,25.1773,25.1773,23.0053,0.0763,11.6366,14.7371,22.0323,14.7371,490.5468,10.2937,0.6055,0.8411,69.3571,47.8291,41.5437,1.5333,1.5759,6.3676,4.0405,1.0278,4.1528,4.0000
 1125.5000,2170.5852,0.0267,2.6160,2.5201,2.5000,2.5046,2.5193,2.6000,2.5201,0.2757,2.5203,0.1486,0.2057,3.6717,22.4535,17.7654,17.7654,16.0268,0.0491,7.8622,11.0951,18.7020,11.0951,396.8120,10.1746,1.9266,2.5429,58.1896,41.5657,35.6866,1.3158,1.4173,5.4761,3.8636,1.0771,4.1616,2.4000
 1126.0000,2164.5615,0.0755,3.8552,3.4617,3.4614,3.4905,3.5876,3.8650,3.4617,0.2746,2.5967,0.3686,-0.2686,4.0454,17.0674,12.6973,12.6973,11.1784,0.0165,3.2295,6.6250,14.6143,6.6250,288.8715,9.9817,7.2970,5.9229,43.6924,33.2934,28.2895,1.0491,1.1584,4.3123,3.7226,1.1042,4.1103,3.0000
 1126.5000,2185.0608,0.1086,3.1310,2.6757,2.7056,2.7382,2.8549,3.1203,2.6757,0.2761,2.6079,0.4520,-0.4340,4.1011,16.8771,12.5213,12.5213,11.0087,0.0052,2.5498,5.9691,14.0145,5.9691,373.7313,9.9447,9.6781,5.6330,34.5554,27.7741,23.5525,0.8775,0.9604,3.5713,3.7187,1.0945,4.0700,4.0000
 1127.0000,2166.4971,0.1092,1.8883,1.6123,1.6338,1.6514,1.7183,1.8630,1.6123,0.2765,2.5600,0.0952,0.1907,3.6493,21.0190,16.3995,16.3995,14.7266,0.0015,5.4547,8.7721,16.5777,8.7721,620.2500,9.9247,6.7866,3.4412,34.2262,27.0709,22.9622,0.8577,0.9195,3.4712,3.7751,1.0721,4.0471,0.8000
 1127.5000,2177.6672,0.1094,1.3438,1.1470,1.1631,1.1750,1.2217,1.3218,1.1470,0.2744,2.5048,-0.3628,0.4818,3.1707,27.1216,22.2906,22.2906,20.3020,0.0045,8.8002,12.0002,19.5296,12.0002,871.8377,9.9358,3.1330,1.6655,38.8710,30.4761,25.8644,0.9690,1.0197,3.8961,3.8209,1.0523,4.0206,0.0000
 1128.0000,2141.8508,0.1116,1.1360,0.9665,0.9816,0.9923,1.0331,1.1164,0.9665,0.2753,2.4633,-0.4627,0.2987,3.0200,29.8408,24.9822,24.9822,22.8231,0.0076,11.3134,14.4252,21.7471,14.4252,1034.7046,9.9988,2.0526,1.1295,45.2697,38.1301,32.2614,1.2166,1.2704,4.8220,3.7957,1.0442,3.9634,3.0000
 1128.5000,2209.0625,0.1161,1.2412,1.0487,1.0690,1.0829,1.1324,1.2204,1.0487,0.2751,2.4542,-0.2880,-0.0718,3.0476,28.0349,23.1901,23.1901,21.1463,0.0087,11.8642,14.9567,22.2331,14.9567,953.5382,9.9855,2.4075,1.4429,56.6184,47.9417,40.1528,1.5212,1.6479,5.9683,3.6217,1.0833,3.9233,4.8000
 1129.0000,2162.1199,0.1270,1.6729,1.3901,1.4274,1.4528,1.5329,1.6427,1.3901,0.2759,2.4848,-0.2342,-0.3510,3.0173,24.7793,20.0048,20.0048,18.1485,0.0128,10.0148,13.1722,20.6013,13.1722,719.3820,9.8420,3.8399,2.3127,72.8206,57.7977,48.0626,1.8274,2.0331,7.1131,3.4987,1.1125,3.8924,0.8000
 1129.5000,2153.9895,0.1376,2.1264,1.7383,1.7983,1.8402,1.9597,2.0810,1.7383,0.2753,2.5196,-0.2424,-0.1671,2.9545,23.0607,18.3471,18.3471,16.5790,0.0162,7.9055,11.1368,18.7401,11.1369,575.2634,9.6960,6.0906,2.5949,86.3908,67.0806,55.3203,2.1044,2.4378,8.1822,3.3563,1.1584,3.8881,2.0000
 1130.0000,2143.2556,0.1248,2.0150,1.6801,1.7350,1.7745,1.8795,1.9737,1.6801,0.2758,2.5257,-0.0467,-0.1331,3.0315,24.2826,19.5240,19.5240,17.6939,0.0169,7.5314,10.7759,18.4101,10.7759,595.2194,9.7179,4.1310,2.0433,96.9258,74.7677,60.9715,2.3168,2.8108,9.0302,3.2126,1.2132,3.8976,0.8000
 1130.5000,2172.2205,0.1167,1.7957,1.5159,1.5580,1.5899,1.6728,1.7617,1.5159,0.2749,2.5066,0.2266,-0.1462,3.1573,27.8868,23.0438,23.0438,21.0091,0.0148,8.6888,11.8927,19.4313,11.8927,659.6860,9.7964,2.7181,1.8633,107.1592,78.7633,63.1205,2.3865,3.1028,9.4052,3.0313,1.3001,3.9410,1.6000
 1131.0000,2174.9500,0.1170,1.6897,1.4256,1.4593,1.4867,1.5594,1.6575,1.4256,0.2751,2.4841,0.2548,0.0557,3.1899,29.4108,24.5538,24.5538,22.4229,0.0094,10.0549,13.2108,20.6366,13.2108,701.4570,9.8935,2.5692,1.7342,104.4211,76.3817,59.2799,2.2303,3.2574,8.8852,2.7277,1.4605,3.9839,4.0000
 1131.5000,2073.9375,0.1199,1.7260,1.4500,1.4800,1.5072,1.5787,1.6921,1.4500,0.2754,2.4785,0.1949,-0.0679,3.2200,27.2148,22.3821,22.3821,20.3880,0.0055,10.3955,13.5395,20.9372,13.5395,689.6345,9.9043,2.3279,1.6058,83.7633,65.5183,48.6463,1.8153,3.0934,7.3623,2.3800,1.7041,4.0557,0.0000
 1132.0000,2112.1494,0.1197,1.9251,1.6177,1.6470,1.6775,1.7550,1.8891,1.6177,0.2747,2.5113,0.1190,-0.4267,3.3265,25.6821,20.8822,20.8822,18.9765,0.0062,8.4054,11.6193,19.1812,11.6193,618.1738,9.8913,1.9365,1.7779,59.7313,52.3508,36.9997,1.3765,2.7176,5.6196,2.0679,1.9743,4.0826,1.0000
 1132.5000,2119.4744,0.1193,2.3813,2.0024,2.0336,2.0741,2.1707,2.3406,2.0024,0.2741,2.5685,-0.2464,-0.0894,3.4325,21.6086,16.9595,16.9595,15.2602,0.0037,4.9382,8.2737,16.1219,8.2737,499.4030,9.8755,4.5886,2.7150,47.6920,44.1780,29.9541,1.1161,2.4471,4.5413,1.8557,2.1926,4.0689,0.8000
 1133.0000,2091.4543,0.1163,3.0307,2.5600,2.5871,2.6410,2.7615,2.9829,2.5600,0.2752,2.6023,-0.4274,0.7075,3.4505,18.1086,13.6641,13.6641,12.1085,-0.0014,2.8928,6.3001,14.3172,6.3001,390.6237,9.8469,5.4466,3.1400,50.9289,42.5271,27.7812,1.0387,2.4763,4.1949,1.6940,2.3840,4.0386,0.0000
 1133.5000,1979.4200,0.1091,3.8892,3.3215,3.3273,3.3952,3.5419,3.8327,3.3215,0.2742,2.6102,0.0733,0.7321,3.5143,17.1132,12.7397,12.7397,11.2192,0.0000,2.4144,5.8385,13.8951,5.8385,301.0646,9.8190,5.1552,3.8188,57.8050,43.3282,27.5509,1.0309,2.6062,4.1563,1.5948,2.5281,4.0317,4.8000
 1134.0000,1975.8156,0.1001,5.0696,4.3886,4.3429,4.4223,4.6021,5.0058,4.3885,0.2751,2.6213,0.4237,0.0628,3.7242,13.8025,9.7064,9.7064,8.2843,0.0054,1.7410,5.1886,13.3008,5.1886,227.8635,9.7881,10.6622,5.7903,55.9341,42.3500,26.3359,0.9770,2.6173,4.0132,1.5333,2.6790,4.1078,3.0000
 1134.5000,2061.6606,0.0877,6.2058,5.4722,5.3531,5.4215,5.6178,6.1426,5.4721,0.2741,2.6316,-0.0338,-0.3450,3.9305,11.1378,7.3115,7.3115,5.9476,0.0092,1.1182,4.5877,12.7513,4.5877,182.7419,9.7270,6.6203,4.3880,51.9656,39.3057,23.7808,0.8731,2.5108,3.6669,1.4604,2.8757,4.1997,2.4000
 1135.0000,2047.9093,0.0693,8.4804,7.6849,7.4202,7.4608,7.6901,8.4445,7.6847,0.2733,2.6380,-0.4264,-0.1520,4.1214,9.2646,5.6531,5.6531,4.3190,0.0087,0.7254,4.2087,12.4048,4.2087,130.1257,9.6655,9.9099,7.9486,49.9652,39.2726,22.9003,0.8330,2.6211,3.5679,1.3612,3.1465,4.2832,6.4000
 1135.5000,2109.2590,0.0145,12.1619,11.9198,11.3036,11.2578,11.5035,12.2300,11.9194,0.2750,2.6554,-0.2466,0.0914,4.3189,7.1561,3.8115,3.8115,2.4995,0.0073,-0.3272,3.1930,11.4760,3.1930,83.8940,9.5855,18.0896,15.9973,52.9481,45.1515,25.2087,0.9079,3.1596,3.9705,1.2566,3.4800,4.3731,0.0000
 1136.0000,2183.0803,0.0266,13.6564,13.1588,12.4057,12.2474,12.6308,13.7400,13.1582,0.2758,2.6738,-0.0044,-0.0219,4.3904,6.6256,3.3523,3.3523,2.0440,0.0101,-1.4423,2.1171,10.4921,2.1171,75.9950,9.5272,24.1220,20.4599,67.0020,56.9186,30.3626,1.0772,4.1847,4.8601,1.1614,3.8849,4.5120,3.2000
 1136.5000,2187.5486,0.0072,11.8073,11.6902,11.0781,10.9091,11.1705,11.8050,11.6898,0.2748,2.6758,0.1537,0.0198,4.3635,7.8196,4.3881,4.3881,3.0704,0.0130,-1.5660,1.9977,10.3830,1.9978,85.5415,9.5071,21.7003,16.3461,87.9370,70.5672,35.5140,1.2502,5.4836,5.7306,1.0451,4.3860,4.5836,1.6000
 1137.0000,2176.0444,-0.0066,9.1492,9.2328,8.7812,8.6450,8.8122,9.1395,9.2325,0.2749,2.6624,0.1387,0.2628,4.3222,10.7490,6.9656,6.9656,5.6087,0.0123,-0.7501,2.7849,11.1028,2.7849,108.3099,9.5362,22.0023,12.3122,106.4294,82.3321,39.1917,1.3700,6.7017,6.3704,0.9506,4.8919,4.6500,0.0000
 1137.5000,2168.5586,-0.0148,6.8050,6.9448,6.6345,6.5401,6.6450,6.8040,6.9447,0.2751,2.6468,-0.0454,0.0229,4.1751,14.0813,9.9594,9.9594,8.5300,0.0112,0.1954,3.6973,11.9371,3.6973,143.9919,9.5865,14.4332,8.2149,117.4551,89.8734,40.4227,1.4099,7.6189,6.5853,0.8643,5.4040,4.6709,0.0000
 1138.0000,2198.2937,-0.0196,5.6196,5.7720,5.5322,5.4585,5.5366,5.6196,5.7719,0.2742,2.6350,-0.0177,-0.0010,3.9244,16.2181,11.9133,11.9133,10.4222,0.0127,0.9109,4.3877,12.5685,4.3877,173.2507,9.6198,9.6785,6.2510,121.7885,92.0937,39.7201,1.3793,8.0051,6.4996,0.8119,5.8038,4.7123,0.0000
 1138.5000,2172.8650,-0.0200,5.2728,5.4187,5.2081,5.1400,5.2131,5.2728,5.4187,0.2750,2.6228,0.1418,0.3503,3.7688,17.1232,12.7489,12.7489,11.2281,0.0137,1.6460,5.0970,13.2170,5.0970,184.5474,9.6165,8.6777,5.4528,120.2512,93.0911,39.1042,1.3410,8.2016,6.4791,0.7900,6.1162,4.8316,2.4000
 1139.0000,2227.6724,-0.0147,5.1460,5.2506,5.0676,5.0042,5.0781,5.1460,5.2506,0.2746,2.6164,0.2071,0.1560,3.7850,17.4540,13.0555,13.0555,11.5233,0.0126,2.0372,5.4745,13.5622,5.4745,190.4534,9.6274,7.5850,5.3249,118.6256,90.7224,37.1811,1.2487,8.0841,6.2854,0.7775,6.4740,5.0336,3.2000
 1139.5000,2189.2188,-0.0069,5.0618,5.1104,4.9579,4.9022,4.9754,5.0618,5.1104,0.2747,2.6188,0.3295,0.0142,3.9544,17.4753,13.0753,13.0753,11.5423,0.0125,1.8908,5.3332,13.4330,5.3332,195.6811,9.6636,6.9903,4.8137,116.0847,87.1008,34.7073,1.1471,7.8637,5.9552,0.7573,6.8554,5.1916,0.0000
 1140.0000,2176.8271,-0.0002,5.1283,5.1294,5.0019,4.9537,5.0261,5.1283,5.1294,0.2758,2.6274,0.4579,-0.0539,4.2346,16.9697,12.6069,12.6069,11.0913,0.0120,1.3713,4.8320,12.9747,4.8320,194.9559,9.6838,6.6304,4.5104,107.6678,81.6266,31.3819,1.0216,7.5036,5.4586,0.7275,7.3451,5.3433,1.0000
 1140.5000,2137.1409,0.0049,5.4285,5.3915,5.2815,5.2401,5.3128,5.4285,5.3915,0.2745,2.6349,0.1941,-0.2014,4.3684,15.8783,11.6008,11.6008,10.1203,0.0098,0.9169,4.3935,12.5737,4.3935,185.4776,9.7033,6.5104,4.5954,98.6513,74.2855,27.4528,0.8898,6.9731,4.7936,0.6874,7.8367,5.3873,5.6000
 1141.0000,2144.9832,0.0089,5.9511,5.8785,5.7805,5.7483,5.8208,5.9511,5.8785,0.2740,2.6341,-0.2672,0.1150,4.3179,14.9224,10.7253,10.7253,9.2731,0.0101,0.9608,4.4359,12.6125,4.4359,170.1127,9.6978,6.6845,5.3930,89.2538,67.1309,24.2480,0.7946,6.3785,4.1930,0.6574,8.0277,5.2770,2.4000
 1141.5000,2141.1941,0.0154,6.2433,6.1115,6.0349,6.0223,6.0849,6.2433,6.1115,0.2755,2.6374,-0.4311,-0.0704,4.3799,13.6727,9.5887,9.5887,8.1699,0.0126,0.7631,4.2451,12.4381,4.2451,163.6268,9.6683,10.4861,7.5340,79.2845,59.8130,21.5038,0.7155,5.7004,3.6669,0.6433,7.9670,5.1249,1.0000
 1142.0000,2133.0291,0.0252,5.6486,5.4536,5.4111,5.4198,5.4668,5.6486,5.4536,0.2743,2.6376,-0.4594,-0.4231,4.4925,12.4431,8.4794,8.4794,7.0894,0.0143,0.7519,4.2342,12.4281,4.2342,183.3651,9.6321,10.3962,7.3399,70.7552,52.4584,18.9558,0.6436,4.9804,3.1715,0.6368,7.7387,4.9279,1.0000
 1142.5000,2114.6260,0.0309,4.7027,4.5036,4.4836,4.5009,4.5348,4.7027,4.5036,0.2757,2.6163,-0.4719,0.1597,4.4723,12.9080,8.8978,8.8978,7.4973,0.0128,2.0453,5.4823,13.5694,5.4823,222.0435,9.6169,11.1798,7.1576,64.1735,47.4072,17.1245,0.5855,4.5003,2.8455,0.6323,7.6861,4.8599,0.8000
 1143.0000,2094.3672,0.0284,3.9423,3.7888,3.7766,3.7932,3.8157,3.9423,3.7888,0.2744,2.5785,-0.3101,0.6082,4.4597,13.8888,9.7847,9.7847,8.3603,0.0097,4.3362,7.6929,15.5908,7.6929,263.9356,9.6501,11.2008,7.0410,59.8258,43.8156,15.6558,0.5356,4.1817,2.6001,0.6218,7.8078,4.8547,0.8000
 1143.5000,2103.0857,0.0174,3.5849,3.4992,3.4848,3.4975,3.5105,3.5849,3.4992,0.2743,2.5375,-0.0173,0.1480,4.4851,15.1303,10.9153,10.9153,9.4571,0.0076,6.8174,10.0869,17.7800,10.0870,285.7760,9.6626,8.6511,4.7767,57.3991,42.9594,15.2768,0.5214,4.1062,2.5432,0.6193,7.8760,4.8780,0.0000
 1144.0000,2122.6990,-0.0036,3.5716,3.5884,3.5619,3.5644,3.5667,3.5684,3.5893,0.2744,2.5207,0.2479,-0.3233,4.4170,15.5994,11.3448,11.3448,9.8729,0.0041,7.8380,11.0718,18.6806,11.0718,278.6720,9.6620,7.3627,5.1621,59.2352,44.3786,15.7314,0.5352,4.2398,2.6265,0.6195,7.9212,4.9071,0.0000
 1144.5000,2160.1741,-0.0012,3.8997,3.9045,3.8528,3.8322,3.8183,3.8979,3.9060,0.2750,2.5329,0.3602,0.0038,4.3096,16.2145,11.9100,11.9100,10.4191,0.0008,7.0966,10.3563,18.0264,10.3564,256.1177,9.6767,9.9719,6.5856,63.5409,46.2240,16.8258,0.5743,4.3518,2.8007,0.6436,7.5777,4.8769,2.0000
 1145.0000,2192.2937,-0.0176,4.1492,4.2482,4.1575,4.0969,4.0563,4.1990,4.2501,0.2738,2.5425,0.2136,0.0801,4.2746,16.5702,12.2378,12.2378,10.7354,-0.0007,6.5143,9.7945,17.5126,9.7945,235.3947,9.6733,9.3267,6.0368,63.6087,47.2309,18.0231,0.6110,4.3401,3.0198,0.6958,7.1036,4.9427,4.8000
 1145.5000,2147.8398,-0.0749,4.3345,4.7860,4.6377,4.5128,4.4149,4.5706,4.7885,0.2755,2.5421,-0.1251,-0.2934,4.2663,16.1268,11.8292,11.8292,10.3410,-0.0056,6.5368,9.8161,17.5324,9.8162,208.9444,9.6266,10.0146,7.4044,58.7838,44.8524,18.2634,0.6113,3.9897,3.0973,0.7763,6.5268,5.0669,2.4000
 1146.0000,2158.6648,-0.1709,4.7588,5.9062,5.6605,5.4262,5.1800,5.2907,5.9102,0.2748,2.5445,-0.3681,-0.1718,4.2011,14.8750,10.6821,10.6821,9.2312,-0.0137,6.3925,9.6770,17.4052,9.6770,169.3142,9.6194,12.1326,9.0182,50.7398,40.3781,17.5675,0.5848,3.4574,2.9942,0.8660,5.9116,5.1196,3.0000
 1146.5000,2140.2505,-0.1745,5.8044,7.2326,6.8629,6.4818,5.9875,5.8761,7.2388,0.2750,2.5536,-0.4249,-0.1458,4.1397,13.0058,8.9859,8.9859,7.5832,-0.0168,5.8406,9.1444,16.9182,9.1445,138.2619,9.6287,14.3596,9.6976,44.9316,37.4964,17.4426,0.5766,3.0642,2.9922,0.9765,5.3141,5.1891,2.4000
 1147.0000,2146.3306,-0.3788,5.3060,8.1365,7.6555,7.1249,6.2924,5.8137,8.1443,0.2754,2.5698,-0.3999,-0.3329,4.1502,13.1652,9.1299,9.1299,7.7234,-0.0129,4.8617,8.1999,16.0544,8.1999,122.9025,9.6444,12.3147,9.5687,47.2513,40.4587,19.8302,0.6512,3.1841,3.4223,1.0748,4.8895,5.2553,0.0000
 1147.5000,2165.5984,-0.7112,4.4980,8.6812,8.1266,7.4714,6.3080,5.3432,8.6898,0.2747,2.5836,-0.2706,-0.1966,4.1462,14.4472,10.2920,10.2920,8.8530,-0.0043,4.0244,7.3920,15.3157,7.3920,115.1909,9.6871,13.0968,9.6181,61.7655,50.4496,25.8667,0.8368,3.8428,4.5240,1.1773,4.5921,5.4061,1.0000
 1148.0000,2144.9146,-1.2871,3.6807,8.5100,7.9635,7.2640,5.9554,4.5715,8.5179,0.2743,2.5785,-0.1208,-0.0696,4.0439,17.3835,12.9901,12.9901,11.4603,0.0052,4.3348,7.6915,15.5895,7.6915,117.5083,9.7110,9.1061,6.1148,83.3449,62.7689,33.4509,1.0767,4.6510,5.8764,1.2635,4.3196,5.4577,0.0000
 1148.5000,2183.3220,-1.8558,3.0634,7.6405,7.1876,6.5423,5.3166,3.8533,7.6465,0.2742,2.5472,-0.1547,-0.6225,3.8339,23.2391,18.5184,18.5184,16.7415,0.0084,6.2284,9.5186,17.2603,9.5186,130.8810,9.7375,8.8360,5.0352,94.3152,72.9384,39.8895,1.2881,5.3174,6.9878,1.3142,4.1280,5.4248,1.6000
 1149.0000,2160.1279,-1.3036,1.8426,4.2739,4.0661,3.7173,3.0412,2.2294,4.2756,0.2746,2.3776,-0.3340,-1.5649,3.3536,30.0527,25.1937,25.1937,23.0205,0.0124,16.5083,19.4379,26.3309,19.4379,233.9769,9.7959,6.5908,3.0744,94.8211,75.4872,42.0140,1.3758,5.4469,7.2693,1.3346,3.9590,5.2836,1.6000
 1149.5000,2177.8406,-0.8581,0.9795,2.0227,1.9469,1.7927,1.4868,1.1408,2.0227,0.2746,2.0129,-0.6492,-1.3036,2.6262,41.2952,36.7595,36.7595,33.6852,0.0413,38.6128,40.7668,45.8348,40.7668,494.3768,10.0314,1.3752,0.5632,92.5933,73.4035,41.6757,1.3894,5.2161,7.0940,1.3600,3.7543,5.1059,1.0000
 1150.0000,2124.7605,-0.6335,0.7297,1.3502,1.3154,1.2220,1.0345,0.8399,1.3502,0.2759,1.7409,-0.6347,0.0464,2.2130,47.0309,42.9076,42.9076,39.2992,0.0924,55.0962,56.6718,60.3790,56.6718,740.6119,11.5851,0.2979,0.4144,87.2991,71.8306,42.2098,1.4279,4.9258,7.0867,1.4387,3.4497,4.9631,0.0000
 1150.5000,2173.3945,-0.4469,0.7341,1.1932,1.1804,1.1109,0.9757,0.8469,1.1932,0.2749,1.8465,0.5571,0.9716,2.6003,43.4659,39.0697,39.0697,35.7869,0.1344,48.6958,50.4960,54.7316,50.4960,838.0756,13.0820,0.3155,0.4114,83.2913,66.9765,42.3538,1.4441,4.1795,7.0572,1.6885,2.8943,4.8871,0.0000
 1151.0000,2177.7258,-0.3726,0.9986,1.5243,1.5187,1.4398,1.2942,1.1500,1.5243,0.2744,2.1361,0.5148,1.0671,3.1825,36.4262,31.6676,31.6676,29.0207,0.1159,31.1442,33.5602,39.2449,33.5602,656.0278,12.2931,0.2700,0.3957,74.0741,58.4033,38.6150,1.3171,3.3990,6.4317,1.8922,2.5807,4.8832,1.0000
 1151.5000,2179.5566,-0.2857,1.7292,2.4309,2.4319,2.3186,2.1211,1.9020,2.4309,0.2746,2.4451,0.1357,0.8383,3.7617,28.0467,23.2017,23.2017,21.1572,0.0705,12.4207,15.4937,22.7242,15.4937,411.3631,11.4369,0.4900,0.5787,58.4626,47.2787,32.0937,1.0958,2.6263,5.3403,2.0334,2.3967,4.8735,2.4000
 1152.0000,2168.9961,-0.1895,2.6992,3.4244,3.4326,3.2877,3.0501,2.7619,3.4244,0.2753,2.5905,0.1761,0.3968,4.0065,22.0901,17.4183,17.4183,15.6968,0.0286,3.6060,6.9883,14.9465,6.9883,292.0196,10.1163,1.8549,1.5510,44.6720,36.2839,25.0240,0.8579,1.9525,4.1475,2.1242,2.2760,4.8348,1.6000
 1152.5000,2208.9468,-0.1467,2.9665,3.5811,3.5905,3.4529,3.2458,3.0081,3.5811,0.2750,2.5900,0.0708,0.1006,3.8169,21.3513,16.7149,16.7149,15.0272,0.0062,3.6348,7.0160,14.9719,7.0160,279.2426,9.9711,3.0389,2.4097,36.8448,29.7439,20.9137,0.7213,1.5465,3.4458,2.2282,2.1441,4.7774,1.6000
 1153.0000,2196.9700,-0.1140,2.9499,3.4231,3.4274,3.3080,3.1442,3.0111,3.4231,0.2762,2.5680,-0.1503,-0.1024,3.5851,22.3928,17.7075,17.7075,15.9717,-0.0009,4.9672,8.3017,16.1475,8.3017,292.1310,9.9253,4.6658,2.7975,34.1959,27.7340,20.0165,0.6894,1.3810,3.3022,2.3911,2.0031,4.7896,1.0000
 1153.5000,2161.9590,-0.0866,3.0452,3.4149,3.4096,3.3011,3.1573,3.1094,3.4149,0.2754,2.5754,-0.0480,-0.0123,3.6125,22.3857,17.7007,17.7007,15.9652,0.0020,4.5191,7.8692,15.7521,7.8693,292.8381,9.8313,4.6253,2.8728,36.0954,29.2523,21.3311,0.7334,1.4417,3.5252,2.4451,1.9658,4.8066,0.8000
 1154.0000,2159.0112,-0.0702,3.3459,3.6744,3.6538,3.5465,3.3951,3.4017,3.6744,0.2750,2.5931,0.0296,0.1052,3.7788,22.6846,17.9866,17.9866,16.2368,0.0064,3.4486,6.8364,14.8076,6.8364,272.1500,9.7002,4.6488,3.2713,43.2989,33.6602,24.2746,0.8339,1.7183,4.0149,2.3365,2.0605,4.8143,0.8000
 1154.5000,2153.7129,-0.0643,3.8068,4.1489,4.1040,3.9902,3.8101,3.8469,4.1489,0.2736,2.6131,-0.1181,-0.1842,3.8637,21.6895,17.0365,17.0365,15.3335,0.0076,2.2380,5.6682,13.7394,5.6682,241.0305,9.6135,5.9524,4.0022,51.5088,37.4188,25.6497,0.8835,2.0856,4.2316,2.0289,2.3607,4.7898,3.0000
 1155.0000,2136.6909,-0.0682,4.3535,4.7688,4.6876,4.5609,4.3410,4.3854,4.7688,0.2756,2.6236,-0.0725,-0.2331,3.7772,20.1391,15.5674,15.5674,13.9323,0.0045,1.5980,5.0507,13.1747,5.0507,209.6979,9.5208,7.7567,5.0124,55.1463,39.6152,25.2332,0.8760,2.4391,4.1302,1.6933,2.7844,4.7149,3.0000
 1155.5000,2123.6660,-0.0783,5.0093,5.5581,5.4263,5.2783,5.0149,5.0421,5.5581,0.2747,2.6245,0.0945,0.1901,3.7414,17.6109,13.2012,13.2012,11.6635,0.0033,1.5472,5.0017,13.1299,5.0017,179.9168,9.4866,7.4173,5.0587,56.2758,38.6269,22.7124,0.7960,2.5866,3.6820,1.4235,3.2496,4.6258,2.4000
 1156.0000,2126.1650,-0.0929,5.8208,6.5796,6.3798,6.1982,5.8912,5.8647,6.5796,0.2748,2.6284,0.1158,0.4281,3.8871,14.7178,10.5386,10.5386,9.0922,0.0053,1.3096,4.7724,12.9202,4.7724,151.9860,9.4395,7.1165,4.2952,53.9436,36.1914,19.6948,0.6871,2.6020,3.2077,1.2328,3.7870,4.6685,1.6000
 1156.5000,2130.5300,-0.1092,6.6138,7.6295,7.3500,7.1269,6.7964,6.6743,7.6295,0.2744,2.6367,0.2404,0.2957,4.0936,12.5755,8.5984,8.5984,7.2054,0.0055,0.8046,4.2851,12.4746,4.2851,131.0699,9.4037,9.8297,6.1938,46.8150,33.2511,16.9521,0.5907,2.5293,2.7645,1.0930,4.2822,4.6802,0.0000
 1157.0000,2128.5259,-0.1219,7.6525,8.9664,8.5887,8.3087,7.9637,7.7418,8.9664,0.2756,2.6481,0.1631,0.1799,4.2635,11.2769,7.4355,7.4355,6.0691,0.0070,0.1164,3.6210,11.8674,3.6211,111.5278,9.3797,14.5794,10.0772,39.1966,30.7237,14.9350,0.5196,2.4250,2.4391,1.0058,4.6669,4.6941,1.0000
 1157.5000,2141.2515,-0.1227,7.9984,9.3814,8.9452,8.6347,8.3366,8.0967,9.3814,0.2746,2.6576,-0.2112,-0.0812,4.2795,10.3926,6.6493,6.6493,5.2983,0.0101,-0.4604,3.0646,11.3585,3.0646,106.5938,9.4004,16.1927,10.0893,37.0928,30.6329,14.4210,0.5071,2.4723,2.3296,0.9423,4.8750,4.5937,0.8000
 1158.0000,2144.7065,-0.1161,7.7108,8.9707,8.5266,8.2172,7.9971,7.7980,8.9707,0.2747,2.6632,-0.1183,-0.2047,4.2191,10.3867,6.6440,6.6440,5.2932,0.0126,-0.8006,2.7362,11.0583,2.7363,111.4735,9.3954,12.8174,8.4037,42.0909,35.5000,16.4583,0.5882,2.8894,2.6140,0.9047,4.9121,4.4440,2.4000
 1158.5000,2170.1353,-0.1098,7.7681,8.9680,8.5098,8.1937,8.0232,7.8574,8.9680,0.2745,2.6545,0.1995,-0.0517,4.2245,10.4693,6.7172,6.7172,5.3650,0.0136,-0.2752,3.2432,11.5219,3.2432,111.5074,9.3625,12.4945,10.0497,56.2705,47.2179,21.7265,0.7804,3.8586,3.4323,0.8895,4.9447,4.3984,0.0000
 1159.0000,2118.8064,-0.1014,7.3627,8.4111,7.9805,7.6854,7.5618,7.4388,8.4111,0.2750,2.6426,0.0384,0.0320,4.1998,10.5699,6.8066,6.8066,5.4527,0.0141,0.4479,3.9409,12.1599,3.9409,118.8899,9.3754,11.8732,7.9759,82.4705,59.1037,27.4034,0.9853,4.7902,4.3245,0.9028,4.8619,4.3892,0.0000
 1159.5000,2034.3311,-0.0962,7.0248,7.9735,7.5744,7.3028,7.2019,7.0861,7.9735,0.2746,2.6470,-0.1442,0.3494,4.2094,10.8007,7.0115,7.0115,5.6537,0.0153,0.1802,3.6826,11.9237,3.6826,125.4161,9.4015,11.2551,7.6958,99.4480,64.2323,30.0810,1.0744,5.1608,4.7807,0.9263,4.8033,4.4495,0.8000
 1160.0000,2013.9127,-0.0952,7.0479,7.9895,7.6055,7.3449,7.2432,7.1086,7.9895,0.2742,2.6533,0.2635,0.5499,4.3168,10.2702,6.5408,6.5408,5.1918,0.0163,-0.2003,3.3155,11.5880,3.3155,125.1650,9.3814,15.9092,10.2934,86.8199,60.0196,27.9076,0.9921,4.8595,4.4576,0.9173,4.8983,4.4932,0.0000
 1160.5000,2030.1046,-0.0930,6.6981,7.5720,7.2292,6.9990,6.8952,6.7464,7.5720,0.2757,2.6520,0.6340,-0.1560,4.3695,10.3090,6.5752,6.5752,5.2256,0.0172,-0.1228,3.3903,11.6563,3.3903,132.0653,9.2871,14.2674,9.4600,65.9704,50.3187,23.0177,0.8147,4.1373,3.6935,0.8927,5.0785,4.5337,4.0000
 1161.0000,2139.1450,-0.0924,6.4375,7.2716,6.9650,6.7623,6.6485,6.4768,7.2716,0.2764,2.6560,0.2761,-0.8742,4.3979,10.4813,6.7279,6.7279,5.3755,0.0188,-0.3619,3.1595,11.4453,3.1595,137.5208,9.2628,11.4965,7.5482,54.1131,42.1687,18.6265,0.6618,3.5771,2.9766,0.8321,5.4048,4.4974,1.6000
 1161.5000,2140.5610,-0.0909,6.4368,7.2575,6.9746,6.7920,6.6636,6.4746,7.2575,0.2742,2.6648,-0.2424,-0.5399,4.4195,10.1553,6.4391,6.4391,5.0920,0.0199,-0.8978,2.6424,10.9725,2.6424,137.7882,9.2900,11.2970,7.6673,48.8260,37.9906,16.4419,0.5815,3.2845,2.6403,0.8039,5.6480,4.5402,2.4000
 1162.0000,2142.0005,-0.0846,6.2197,6.9575,6.7076,6.5520,6.4202,6.2498,6.9575,0.2744,2.6638,-0.4636,0.0731,4.3503,10.0830,6.3751,6.3751,5.0291,0.0189,-0.8338,2.7042,11.0290,2.7042,143.7296,9.3133,12.1509,7.8415,49.8083,36.2830,15.5433,0.5495,3.1655,2.4972,0.7889,5.7607,4.5445,5.6000
 1162.5000,2049.7290,-0.0776,5.8761,6.5145,6.2980,6.1695,6.0414,5.8976,6.5145,0.2741,2.6576,-0.4277,0.1833,4.3215,10.6154,6.8469,6.8469,5.4923,0.0169,-0.4621,3.0629,11.3570,3.0629,153.5038,9.3278,9.1597,5.7839,50.7326,35.1361,15.0367,0.5287,3.0732,2.4294,0.7905,5.8126,4.5951,1.6000
 1163.0000,2010.1349,-0.0736,5.9212,6.5304,6.3277,6.2145,6.0831,5.9470,6.5304,0.2753,2.6540,-0.1472,0.1770,4.4619,10.6482,6.8760,6.8760,5.5208,0.0146,-0.2440,3.2733,11.5494,3.2733,153.1301,9.3518,10.2467,6.5062,48.4816,34.2699,14.5611,0.5052,3.0180,2.3849,0.7902,5.9742,4.7209,4.0000
 1163.5000,2128.0535,-0.0691,6.0433,6.6272,6.4321,6.3303,6.1975,6.0700,6.6272,0.2750,2.6529,0.0633,0.4297,4.6280,10.1936,6.4730,6.4730,5.1253,0.0117,-0.1748,3.3401,11.6105,3.3401,150.8940,9.3681,10.0543,6.7931,46.5911,33.7934,14.3956,0.4954,2.9754,2.3771,0.7989,6.0064,4.7986,6.4000
 1164.0000,2131.6355,-0.0657,6.1806,6.7478,6.5560,6.4629,6.3295,6.2046,6.7478,0.2739,2.6516,-0.0105,0.3998,4.6116,9.7512,6.0819,6.0819,4.7409,0.0096,-0.0941,3.4180,11.6817,3.4180,148.1959,9.3753,9.1937,6.0516,45.6570,34.1814,15.0338,0.5142,2.9559,2.4973,0.8449,5.7484,4.8567,0.8000
 1164.5000,2114.0840,-0.0645,6.4387,7.0186,6.8220,6.7326,6.5960,6.4574,7.0186,0.2738,2.6477,-0.3354,-0.0749,4.4223,9.6992,6.0360,6.0360,4.6958,0.0069,0.1412,3.6450,11.8893,3.6450,142.4794,9.3761,11.1858,8.7183,45.5990,35.7881,16.6844,0.5647,2.9812,2.7999,0.9392,5.2795,4.9583,3.2000
 1165.0000,2127.8240,-0.0637,6.7201,7.3182,7.1128,7.0243,6.8870,6.7334,7.3182,0.2744,2.6509,-0.4448,-0.3340,4.3213,9.3103,5.6933,5.6933,4.3585,0.0031,-0.0550,3.4557,11.7162,3.4557,136.6462,9.3384,11.7307,8.5019,46.4233,38.2102,19.0763,0.6418,3.0331,3.2194,1.0614,4.7259,5.0163,1.0000
 1165.5000,2182.8733,-0.0604,7.0813,7.6779,7.4590,7.3687,7.2368,7.0896,7.6779,0.2749,2.6551,-0.1594,-0.0835,4.4799,9.3875,5.7613,5.7613,4.4255,0.0012,-0.3103,3.2094,11.4909,3.2094,130.2446,9.3078,13.9178,9.4964,48.2184,39.6597,20.6543,0.6952,3.0478,3.4844,1.1433,4.3842,5.0123,0.8000
 1166.0000,2126.5227,-0.0533,7.1203,7.6494,7.4263,7.3371,7.2265,7.1290,7.6494,0.2768,2.6485,0.0444,0.0216,4.6478,9.2509,5.6410,5.6410,4.3071,-0.0000,0.0904,3.5959,11.8444,3.5959,130.7285,9.2946,12.3499,8.3781,51.2528,40.7230,21.4562,0.7253,3.1112,3.6047,1.1586,4.2894,4.9697,3.2000
 1166.5000,2099.0662,-0.0454,7.1240,7.5741,7.3473,7.2589,7.1725,7.1329,7.5741,0.2741,2.6443,0.1000,0.0420,4.6778,9.3679,5.7440,5.7440,4.4084,-0.0009,0.3481,3.8446,12.0718,3.8447,132.0285,9.2923,11.2603,7.8496,54.2586,40.7312,21.3520,0.7317,3.1146,3.5404,1.1367,4.2569,4.8388,4.0000
 1167.0000,2136.1499,-0.0395,7.2766,7.6766,7.4399,7.3490,7.2802,7.2838,7.6766,0.2746,2.6506,-0.0357,0.3020,4.7732,9.4746,5.8380,5.8380,4.5010,-0.0010,-0.0345,3.4755,11.7343,3.4755,130.2655,9.2985,11.4748,7.9545,56.1866,40.6065,21.1920,0.7296,3.0994,3.4976,1.1285,4.2481,4.7938,1.6000
 1167.5000,2132.8906,-0.0371,7.4358,7.8189,7.5718,7.4783,7.4180,7.4409,7.8189,0.2751,2.6581,-0.0904,0.1550,4.8080,9.2286,5.6215,5.6215,4.2878,-0.0032,-0.4896,3.0363,11.3327,3.0363,127.8955,9.2954,11.1756,7.8036,55.5513,40.2732,20.9547,0.7237,3.0668,3.4477,1.1242,4.2377,4.7639,4.8000
 1168.0000,2114.7407,-0.0370,7.8229,8.2255,7.9589,7.8597,7.7945,7.8232,8.2255,0.2754,2.6656,0.1975,-0.2722,4.6767,8.9717,5.3956,5.3956,4.0653,-0.0044,-0.9425,2.5993,10.9331,2.5993,121.5737,9.3202,10.1503,7.5216,52.3627,39.2207,20.5133,0.6984,2.9582,3.4226,1.1570,4.2356,4.9004,0.8000
 1168.5000,2046.0322,-0.0360,8.2429,8.6547,8.3669,8.2612,8.1845,8.2411,8.6547,0.2744,2.6639,0.1433,-0.2795,4.5437,9.1534,5.5553,5.5553,4.2226,-0.0032,-0.8425,2.6958,11.0213,2.6959,115.5447,9.3210,13.5526,9.4956,51.1314,39.1901,20.4013,0.6823,2.9654,3.4622,1.1675,4.3460,5.0741,3.0000
 1169.0000,2070.8628,-0.0317,7.8850,8.2323,7.9597,7.8627,7.7857,7.8850,8.2323,0.2749,2.6529,-0.2183,0.1007,4.3949,9.4252,5.7944,5.7944,4.4581,-0.0028,-0.1740,3.3409,11.6112,3.3409,121.4730,9.3241,12.2864,7.8973,52.3573,38.7669,20.2834,0.6706,2.9177,3.4793,1.1925,4.3510,5.1885,0.0000
 1169.5000,2069.1689,-0.0282,7.7992,8.1043,7.8348,7.7407,7.6545,7.7990,8.1043,0.2741,2.6510,-0.3282,0.2673,4.3032,9.9884,6.2914,6.2914,4.9469,-0.0006,-0.0622,3.4488,11.7098,3.4488,123.3917,9.3443,15.7771,10.2188,52.2966,40.7321,21.6165,0.7155,3.0096,3.7038,1.2307,4.2061,5.1762,4.8000
 1170.0000,2010.3418,-0.0260,7.9013,8.1867,7.9104,7.8135,7.7103,7.9011,8.1867,0.2752,2.6508,-0.4371,0.3590,4.3392,10.1440,6.4290,6.4290,5.0821,0.0019,-0.0486,3.4619,11.7218,3.4619,122.1495,9.3756,17.7115,9.5848,53.2513,42.1046,23.1577,0.7754,2.9953,3.9260,1.3107,3.8631,5.0634,0.0000
 1170.5000,2033.4336,-0.0273,7.4170,7.6980,7.4456,7.3566,7.2455,7.4208,7.6980,0.2747,2.6510,-0.4282,0.3684,4.5546,10.6699,6.8953,6.8953,5.5398,0.0027,-0.0632,3.4478,11.7090,3.4478,129.9040,9.4478,9.2478,6.0694,56.0358,42.6035,24.5653,0.8200,2.8690,4.1764,1.4557,3.4987,5.0929,2.0000
 1171.0000,2114.4529,-0.0341,7.1917,7.5319,7.2884,7.1994,7.0664,7.1981,7.5319,0.2752,2.6614,-0.0298,0.0470,4.8688,10.9611,7.1542,7.1542,5.7935,0.0040,-0.6926,2.8404,11.1535,2.8404,132.7688,9.5146,10.5178,7.5081,57.5204,43.6117,26.3749,0.8729,2.7733,4.5196,1.6297,3.1770,5.1775,1.6000
 1171.5000,2111.9651,-0.0414,6.7982,7.1894,6.9671,6.8812,6.7298,6.8049,7.1894,0.2741,2.6628,0.1908,-0.2114,4.8236,10.7641,6.9790,6.9790,5.6218,0.0036,-0.7752,2.7608,11.0807,2.7608,139.0928,9.5094,10.4682,7.9942,57.8416,43.7648,27.7863,0.9133,2.6046,4.7916,1.8397,2.8519,5.2466,3.2000
 1172.0000,2065.1270,-0.0490,6.6187,7.0702,6.8658,6.7815,6.6017,6.6250,7.0702,0.2743,2.6505,0.1200,-0.4238,4.4994,10.9244,7.1215,7.1215,5.7615,0.0046,-0.0281,3.4817,11.7399,3.4817,141.4391,9.5357,9.6177,5.9089,57.3429,44.0096,29.0991,0.9544,2.4754,5.0276,2.0310,2.5936,5.2677,2.4000
 1172.5000,2304.6506,-0.0585,7.0481,7.6235,7.4216,7.3322,7.1011,7.0563,7.6235,0.2746,2.6503,0.0179,-0.4788,4.3719,10.3138,6.5794,6.5794,5.2298,0.0112,-0.0194,3.4901,11.7476,3.4901,131.1738,9.5579,10.5298,7.1756,54.8340,42.2642,29.0148,0.9551,2.2450,4.9966,2.2257,2.3505,5.2315,3.0000
 1173.0000,2242.8062,-0.0649,7.4879,8.1672,7.9826,7.8957,7.6217,7.4988,8.1672,0.2746,2.6655,-0.3145,-0.0606,4.3859,9.2971,5.6817,5.6817,4.3471,0.0140,-0.9416,2.6002,10.9339,2.6002,122.4415,9.5143,14.5473,9.1090,51.7631,39.0019,27.4732,0.9143,1.9783,4.6840,2.3677,2.1637,5.1230,4.8000
 1173.5000,2115.3738,-0.0631,6.3494,6.9086,6.7853,6.7246,6.5063,6.3578,6.9086,0.2754,2.6747,-0.5573,-0.0181,4.3456,10.3244,6.5888,6.5888,5.2390,0.0097,-1.4950,2.0662,10.4456,2.0662,144.7479,9.5201,13.8085,9.2957,49.3551,38.1975,27.5633,0.9277,1.8443,4.6500,2.5213,1.9880,5.0123,2.4000
 1174.0000,2114.1648,-0.0521,4.2951,4.6070,4.5498,4.5214,4.4033,4.2986,4.6070,0.2750,2.6561,-0.4623,-0.5270,4.1669,13.3406,9.2883,9.2883,7.8776,0.0052,-0.3714,3.1504,11.4370,3.1504,217.0588,9.5907,22.8181,12.1132,52.0049,43.7761,32.2339,1.0969,2.0070,5.3810,2.6810,1.8297,4.9055,6.0000
 1174.5000,2138.7524,-0.0322,3.0659,3.2031,3.1814,3.1712,3.1193,3.0673,3.2031,0.2753,2.5993,-0.4007,-0.6759,3.8452,18.5323,14.0593,14.0593,12.4880,0.0226,3.0729,6.4738,14.4761,6.4738,312.1932,9.6339,12.5984,6.2513,67.5906,54.6500,41.1128,1.4132,2.3577,6.7960,2.8825,1.6683,4.8089,1.0000
 1175.0000,2175.9521,-0.0054,2.3439,2.3613,2.3581,2.3575,2.3482,2.3442,2.3613,0.2749,2.5180,-0.2381,-0.1353,3.6174,26.5691,21.7486,21.7486,19.7924,0.0988,7.9993,11.2274,18.8229,11.2274,423.5024,9.7400,2.9840,1.6944,86.2525,66.2853,50.8012,1.7543,2.7033,8.3593,3.0922,1.5410,4.7651,0.8000
 1175.5000,2097.1091,0.0144,1.8807,1.8436,1.8478,1.8506,1.8598,1.8805,1.8436,0.2756,2.4438,0.2438,0.5489,3.6296,33.4523,28.6196,28.6196,26.2060,0.1949,12.4952,15.5655,22.7899,15.5655,542.4210,10.0325,1.5069,1.1051,94.5882,73.8317,57.2943,1.9810,2.9064,9.4158,3.2397,1.4671,4.7529,2.4000
 1176.0000,2088.6899,0.0236,1.8331,1.7738,1.7823,1.7873,1.8047,1.8329,1.7738,0.2751,2.4271,0.6879,0.5318,3.7301,32.6988,27.8548,27.8548,25.4969,0.2175,13.5086,16.5434,23.6841,16.5434,563.7465,10.2559,1.0219,1.0282,94.1451,76.5071,60.2341,2.0749,2.9145,9.9361,3.4092,1.4047,4.7888,0.8000
 1176.5000,2141.3325,0.0242,1.9684,1.9030,1.9165,1.9242,1.9456,1.9683,1.9030,0.2754,2.4885,0.6358,0.2224,3.7962,30.2583,25.3991,25.3991,23.2122,0.1619,9.7907,12.9560,20.4036,12.9560,525.4995,9.9012,2.1910,1.5498,90.8155,73.4311,59.0181,2.0232,2.6593,9.7819,3.6784,1.3144,4.8349,1.0000
 1177.0000,2145.1216,0.0192,2.0985,2.0433,2.0625,2.0727,2.0927,2.0985,2.0433,0.2742,2.5554,0.1708,0.0695,3.7755,27.1618,22.3301,22.3301,20.3391,0.0803,5.7340,9.0415,16.8241,9.0416,489.3982,9.8893,3.7363,2.1283,87.0189,70.9240,57.8105,1.9824,2.4896,9.5787,3.8475,1.2558,4.8318,0.0000
 1177.5000,2070.3555,0.0134,2.1308,2.0915,2.1144,2.1264,2.1399,2.1308,2.0915,0.2747,2.5649,-0.1147,0.0833,3.6258,26.7825,21.9577,21.9577,19.9891,0.0188,5.1572,8.4850,16.3152,8.4850,478.1252,9.9015,3.8723,2.1444,87.9593,70.1301,58.1442,1.9921,2.3576,9.6425,4.0900,1.1835,4.8404,0.8000
 1178.0000,2107.8081,0.0097,2.0791,2.0513,2.0754,2.0881,2.0961,2.0791,2.0513,0.2744,2.5392,-0.2396,0.1349,3.4692,27.1730,22.3410,22.3410,20.3494,0.0015,6.7133,9.9865,17.6882,9.9865,487.4915,9.9518,3.0455,1.9106,96.2495,70.6980,59.4841,2.0451,2.2806,9.8310,4.3108,1.1152,4.8072,0.0000
 1178.5000,2180.9614,0.0095,2.0534,2.0266,2.0516,2.0652,2.0720,2.0534,2.0266,0.2741,2.5132,-0.5074,-0.0378,3.4357,28.0762,23.2308,23.2308,21.1845,0.0173,8.2882,11.5062,19.0779,11.5062,493.4272,10.0201,2.4844,1.9037,102.2236,73.0003,62.0001,2.1411,2.2903,10.2016,4.4544,1.0697,4.7646,1.0000
 1179.0000,2153.4250,0.0135,1.9811,1.9443,1.9687,1.9826,1.9930,1.9811,1.9443,0.2741,2.5061,-0.6031,-0.3807,3.4681,30.7674,25.9087,25.9087,23.6873,0.0594,8.7204,11.9231,19.4591,11.9232,514.3242,10.1148,2.6820,1.4696,102.4743,75.0509,64.2506,2.2216,2.2860,10.5590,4.6191,1.0290,4.7529,2.4000
 1179.5000,2142.2771,0.0198,1.8626,1.8120,1.8341,1.8472,1.8636,1.8626,1.8120,0.2738,2.5079,-0.3681,-0.6385,3.4643,31.9891,27.1373,27.1373,24.8307,0.1007,8.6132,11.8198,19.3646,11.8198,551.8858,10.5295,1.3563,1.2932,103.3237,76.5826,65.4316,2.2663,2.3722,10.7345,4.5251,1.0467,4.7366,0.0000
 1180.0000,2132.4644,0.0257,1.8016,1.7381,1.7588,1.7711,1.7939,1.8016,1.7381,0.2744,2.4988,0.0111,-0.1283,3.4322,33.4998,28.6679,28.6679,26.2507,0.1078,9.1636,12.3508,19.8502,12.3508,575.3416,10.8291,1.4769,1.3477,103.8563,77.0274,65.2542,2.2507,2.4829,10.7503,4.3297,1.1032,4.7764,2.4000
 1180.5000,2156.5571,0.0300,1.7534,1.6814,1.7005,1.7119,1.7397,1.7534,1.6814,0.2752,2.4896,0.3153,0.7393,3.4484,34.9792,30.1786,30.1786,27.6479,0.1044,9.7230,12.8906,20.3438,12.8906,594.7496,11.0299,1.4331,1.2847,99.1259,77.1749,64.6721,2.2247,2.6056,10.6826,4.0998,1.1712,4.8018,0.0000
 1181.0000,2128.8262,0.0321,1.7336,1.6573,1.6752,1.6854,1.7164,1.7336,1.6573,0.2757,2.4900,0.4155,0.6548,3.5317,34.3635,29.5484,29.5484,27.0656,0.1078,9.6944,12.8630,20.3186,12.8630,603.3781,10.9095,0.9616,1.0029,95.9319,76.4007,63.3045,2.1820,2.6918,10.4359,3.8770,1.2336,4.7827,3.0000
 1181.5000,2106.6790,0.0325,1.7737,1.6949,1.7120,1.7212,1.7546,1.7737,1.6949,0.2742,2.4972,0.2945,-0.1018,3.6039,34.3114,29.4952,29.4952,27.0164,0.1011,9.2607,12.4445,19.9359,12.4445,590.0206,10.6909,1.1646,1.1130,98.1187,75.9005,62.2196,2.1491,2.7611,10.2357,3.7071,1.2848,4.7627,0.0000
 1182.0000,2130.0688,0.0308,1.8027,1.7268,1.7424,1.7503,1.7838,1.8027,1.7268,0.2759,2.5027,-0.0044,-0.4501,3.5822,33.3394,28.5048,28.5048,26.0996,0.0830,8.9262,12.1217,19.6407,12.1218,579.1104,10.6880,1.3126,1.2869,98.0196,76.8261,62.4055,2.1594,2.8715,10.2479,3.5688,1.3297,4.7456,2.4000
 1182.5000,2143.8428,0.0270,1.8561,1.7873,1.8011,1.8074,1.8404,1.8561,1.7873,0.2749,2.5035,-0.1351,-0.4834,3.5130,32.7069,27.8630,27.8630,25.5046,0.0702,8.8804,12.0776,19.6003,12.0776,559.4921,10.5798,1.3309,1.2844,99.2615,76.4899,61.2552,2.1257,2.9615,10.0302,3.3869,1.3932,4.7185,0.8000
 1183.0000,2147.1606,0.0226,1.9041,1.8450,1.8557,1.8602,1.8911,1.9041,1.8450,0.2749,2.5107,-0.0628,-0.3519,3.5902,32.7378,27.8944,27.8944,25.5336,0.0923,8.4424,11.6549,19.2139,11.6550,541.9990,10.4428,1.3411,1.1395,102.1995,76.5339,60.7188,2.1060,3.0394,9.9475,3.2728,1.4432,4.7234,3.0000
 1183.5000,2139.9502,0.0219,1.8862,1.8296,1.8356,1.8378,1.8598,1.8862,1.8296,0.2749,2.4997,-0.1636,0.0310,3.7507,33.6182,28.7884,28.7884,26.3623,0.1379,9.1113,12.3004,19.8041,12.3004,546.5602,10.5621,0.8609,0.9997,101.9042,77.4703,60.9077,2.1191,3.1515,9.9472,3.1563,1.4872,4.6940,4.8000
 1184.0000,2176.7698,-0.0000,1.7992,1.7992,1.7998,1.7995,1.7993,1.7991,1.7992,0.2744,2.4320,-0.1687,0.3367,3.7566,34.0200,29.1977,29.1977,26.7412,0.1687,13.2104,16.2556,23.4209,16.2557,555.7975,10.6056,1.0370,0.8703,102.2834,77.7391,60.4889,2.1195,3.2644,9.8081,3.0045,1.5402,4.6276,3.2000
 1184.5000,2160.7961,0.0320,1.9966,1.9092,1.9028,1.8993,1.9269,1.9966,1.9092,0.2754,2.3817,0.1787,0.4537,3.7544,31.9901,27.1383,27.1383,24.8316,0.1814,16.2632,19.2013,26.1145,19.2013,523.7852,10.9022,0.7418,0.8918,99.1465,75.0843,57.9779,2.0441,3.2264,9.3413,2.8952,1.5784,4.5700,1.0000
 1185.0000,2073.3032,0.0217,2.3597,2.2894,2.2697,2.2597,2.2885,2.3601,2.2894,0.2750,2.4531,0.3920,0.6970,3.9763,26.3911,21.5745,21.5745,19.6286,0.1580,11.9327,15.0228,22.2936,15.0228,436.7936,10.4637,0.9856,1.1126,83.1450,64.8517,49.4970,1.7618,2.8718,7.8956,2.7493,1.6301,4.4816,1.6000
 1185.5000,2039.4102,-0.0091,3.6266,3.6722,3.6124,3.5790,3.5855,3.6291,3.6722,0.2755,2.5813,0.2823,0.8724,4.2413,18.4600,13.9918,13.9918,12.4232,0.0894,4.1657,7.5283,15.4403,7.5283,272.3150,9.9591,9.9530,4.7545,60.0346,51.5886,39.1405,1.4047,2.3276,6.1887,2.6588,1.6570,4.4056,3.2000
 1186.0000,2034.1241,-0.0398,4.8305,5.0977,4.9951,4.9405,4.8812,4.8361,5.0977,0.2747,2.6457,0.0844,0.6368,4.2777,14.7317,10.5513,10.5513,9.1044,0.0302,0.2616,3.7612,11.9956,3.7612,196.1682,9.7789,13.9324,7.9011,48.1042,41.4628,31.3624,1.1345,1.8877,4.9163,2.6044,1.6638,4.3332,4.0000
 1186.5000,2121.8115,-0.0533,4.5846,4.9252,4.8049,4.7444,4.6455,4.5892,4.9252,0.2753,2.6475,0.0704,0.2475,4.1541,15.4979,11.2518,11.2518,9.7829,0.0122,0.1493,3.6528,11.8964,3.6528,203.0367,9.7909,9.1201,5.6927,50.1054,37.8611,28.4113,1.0362,1.7535,4.4137,2.5170,1.6923,4.2594,1.0000
 1187.0000,2158.9526,-0.0557,4.0627,4.3780,4.2547,4.1956,4.0872,4.0657,4.3780,0.2754,2.6331,0.3247,-0.0328,4.0610,17.3352,12.9454,12.9454,11.4173,0.0081,1.0263,4.4991,12.6703,4.4991,228.4148,9.8286,7.2402,4.2337,55.5835,39.3905,29.1376,1.0715,1.8799,4.4848,2.3857,1.7545,4.1856,0.0000
 1187.5000,2194.4822,-0.0530,3.6934,3.9665,3.8442,3.7884,3.6837,3.6954,3.9665,0.2754,2.6221,0.2819,-0.1381,4.0127,18.4369,13.9702,13.9702,12.4025,0.0051,1.6884,5.1379,13.2545,5.1380,252.1124,9.7869,6.9826,3.9348,59.8223,42.0875,30.3455,1.1235,2.1117,4.6349,2.1948,1.8797,4.1256,0.8000
 1188.0000,2168.3618,-0.0474,3.4275,3.6539,3.5359,3.4850,3.3922,3.4290,3.6539,0.2739,2.6119,-0.0821,-0.1781,3.9069,19.5563,15.0187,15.0187,13.4075,0.0046,2.3097,5.7375,13.8027,5.7375,273.6782,9.7941,5.2542,3.0412,62.3623,45.1214,31.2595,1.1680,2.4364,4.7236,1.9388,2.0859,4.0442,0.0000
 1188.5000,2147.0796,-0.0426,3.3195,3.5161,3.4006,3.3529,3.2697,3.3209,3.5161,0.2744,2.6032,-0.2009,-0.3194,3.7946,19.5112,14.9763,14.9763,13.3669,0.0041,2.8384,6.2476,14.2692,6.2476,284.4057,9.8013,4.3990,2.8063,63.6069,46.9537,31.5994,1.1906,2.6522,4.7283,1.7828,2.2277,3.9714,0.8000
 1189.0000,2154.0930,-0.0409,3.4321,3.6273,3.5079,3.4596,3.3776,3.4336,3.6273,0.2754,2.6052,-0.2466,-0.3241,3.7883,18.9951,14.4921,14.4921,12.9031,0.0054,2.7154,6.1289,14.1606,6.1289,275.6874,9.8102,4.7374,2.8788,63.2063,48.4212,31.9329,1.2247,2.7986,4.6759,1.6708,2.2852,3.8180,2.0000
 1189.5000,2158.6997,-0.0407,3.6758,3.8837,3.7575,3.7060,3.6217,3.6774,3.8837,0.2744,2.6131,-0.3655,-0.2153,3.8646,18.5810,14.1048,14.1048,12.5316,0.0078,2.2339,5.6643,13.7358,5.6643,257.4845,9.8026,4.9356,2.9846,62.7611,48.6222,32.1086,1.2363,2.7717,4.6783,1.6879,2.2419,3.7840,2.4000
 1190.0000,2218.0679,-0.0371,3.8828,4.0831,3.9549,3.9009,3.8200,3.8837,4.0831,0.2745,2.6179,-0.4583,-0.1661,3.9064,17.5053,13.1032,13.1032,11.5691,0.0095,1.9468,5.3872,13.4824,5.3872,244.9099,9.8094,5.9111,3.7628,63.1457,48.8422,32.6188,1.2602,2.7027,4.7329,1.7512,2.1447,3.7558,1.6000
 1190.5000,2165.3105,-0.0290,3.9226,4.0806,3.9610,3.9076,3.8383,3.9230,4.0806,0.2744,2.6090,-0.3015,0.5958,3.8447,17.4008,13.0062,13.0062,11.4758,0.0105,2.4841,5.9056,13.9565,5.9057,245.0621,9.8771,5.2212,3.5081,65.9757,51.2810,34.7803,1.3397,2.7387,5.0651,1.8494,2.0442,3.7807,0.8000
 1191.0000,2109.2017,-0.0238,4.0732,4.2075,4.0933,4.0376,3.9706,4.0733,4.2075,0.2754,2.6009,0.0748,1.0479,3.8634,17.8108,13.3869,13.3869,11.8421,0.0118,2.9734,6.3778,14.3883,6.3779,237.6721,9.7910,4.3602,2.9175,70.1119,54.0640,36.9799,1.4311,2.8235,5.3539,1.8962,1.9729,3.7410,0.0000
 1191.5000,2180.6736,-0.0234,4.4073,4.5500,4.4378,4.3770,4.2949,4.4074,4.5500,0.2748,2.6163,0.0287,-0.1782,4.0310,17.0777,12.7068,12.7068,11.1875,0.0133,2.0432,5.4803,13.5675,5.4803,219.7805,9.7117,6.0051,5.1175,71.8106,56.5930,39.0398,1.5285,2.8970,5.5683,1.9221,1.8953,3.6430,2.4000
 1192.0000,2190.5200,-0.0207,4.3986,4.5249,4.4320,4.3762,4.2841,4.3987,4.5249,0.2752,2.6301,-0.2112,-0.8678,4.0918,16.0980,11.8028,11.8028,10.3155,0.0144,1.2059,4.6723,12.8287,4.6723,220.9971,9.6592,9.7999,5.7851,73.7681,56.8181,39.1984,1.5596,2.8846,5.4726,1.8972,1.8495,3.5089,4.8000
 1192.5000,2135.8159,-0.0194,4.2387,4.3526,4.2836,4.2372,4.1392,4.2387,4.3526,0.2743,2.6360,-0.0950,-0.0468,4.0805,16.3416,12.0271,12.0271,10.5320,0.0196,0.8478,4.3268,12.5128,4.3268,229.7473,9.6802,5.3312,3.3609,72.7590,54.3878,37.6027,1.5110,2.7273,5.1796,1.8991,1.8050,3.4280,4.8000
 1193.0000,2053.1614,-0.0277,4.0098,4.1638,4.1184,4.0830,3.9875,4.0098,4.1638,0.2756,2.6512,-0.0395,0.1377,4.2072,16.0669,11.7742,11.7742,10.2879,0.0261,-0.0701,3.4411,11.7028,3.4411,240.1681,9.6710,6.1433,4.1382,65.9141,52.2680,36.0012,1.4542,2.6187,4.9229,1.8799,1.8007,3.3853,0.0000
 1193.5000,2152.5725,-0.0359,3.2768,3.4401,3.4226,3.4050,3.3366,3.2768,3.4401,0.2752,2.6409,-0.2940,-0.3700,4.2447,17.9635,13.5290,13.5290,11.9787,0.0266,0.5493,4.0387,12.2493,4.0388,290.6882,9.6949,10.0354,6.2302,63.7916,54.6905,37.4218,1.5180,2.7531,5.0867,1.8476,1.8136,3.3509,1.0000
 1194.0000,2123.9766,-0.0258,2.5139,2.6039,2.6036,2.5992,2.5692,2.5139,2.6039,0.2752,2.5668,-0.4903,-0.6370,3.9478,24.0329,19.2828,19.2828,17.4657,0.0391,5.0449,8.3767,16.2161,8.3767,384.0388,9.7710,8.5774,3.9610,76.3992,62.1295,42.2909,1.7043,3.1590,5.8018,1.8366,1.8535,3.4042,0.8000
 1194.5000,2101.8530,0.0004,1.8391,1.8382,1.8423,1.8441,1.8435,1.8391,1.8382,0.2739,2.4415,-0.3321,-0.4764,3.5702,33.0052,28.1654,28.1654,25.7850,0.0932,12.6382,15.7035,22.9160,15.7035,544.0117,9.8190,2.5653,1.2607,94.8407,71.4389,48.0167,1.9211,3.7176,6.6535,1.7897,1.9351,3.4633,0.8000
 1195.0000,2178.7852,0.0218,1.5696,1.5226,1.5272,1.5305,1.5412,1.5696,1.5226,0.2761,2.3332,0.0029,0.1729,3.4087,36.1205,31.3522,31.3522,28.7302,0.1597,19.1987,22.0338,28.7047,22.0338,656.7618,10.2635,0.6668,0.6999,103.4031,75.5844,50.0766,1.9806,4.0516,7.0476,1.7395,2.0456,3.5583,1.0000
 1195.5000,2221.7881,0.0326,1.7767,1.6975,1.7027,1.7077,1.7250,1.7767,1.6975,0.2757,2.3356,0.0691,0.4666,3.4380,31.7882,26.9347,26.9347,24.6423,0.1608,19.0544,21.8946,28.5774,21.8946,589.0871,10.7583,0.4784,0.7278,97.4174,71.4808,46.6798,1.8252,3.9466,6.6695,1.6899,2.1623,3.6541,3.2000
 1196.0000,2169.5596,0.0278,2.4876,2.3927,2.3969,2.4051,2.4246,2.4879,2.3927,0.2738,2.4609,0.0476,0.4290,3.6475,22.8375,18.1331,18.1331,16.3759,0.1006,11.4617,14.5683,21.8780,14.5683,417.9307,10.1484,2.5351,1.7860,80.6933,58.6845,37.9272,1.4782,3.2918,5.4416,1.6531,2.2270,3.6813,3.2000
 1196.5000,2155.0950,0.0024,3.7503,3.7380,3.7248,3.7336,3.7247,3.7556,3.7380,0.2757,2.5867,0.3077,0.4105,3.9808,15.4663,11.2228,11.2228,9.7548,0.0505,3.8353,7.2094,15.1487,7.2095,267.5238,9.7364,9.0398,5.5725,60.2862,46.7451,30.3718,1.1735,2.6049,4.4060,1.6914,2.2197,3.7545,3.2000
 1197.0000,2202.6013,-0.0271,4.7782,4.9577,4.9082,4.9010,4.8420,4.8024,4.9578,0.2756,2.6313,0.4463,0.2258,4.1836,13.5713,9.4969,9.4969,8.0806,0.0326,1.1330,4.6020,12.7644,4.6020,201.7065,9.6500,9.7947,5.9890,48.1390,39.9328,26.2582,1.0059,2.1898,3.8504,1.7583,2.1769,3.8277,1.0000
 1197.5000,2213.0237,-0.0460,5.1188,5.4463,5.3511,5.3196,5.2001,5.1786,5.4464,0.2748,2.6319,0.1573,0.1487,4.1088,13.1880,9.1504,9.1504,7.7433,0.0259,1.0961,4.5664,12.7318,4.5664,183.6112,9.5891,7.2068,4.5881,47.1407,36.2815,24.3795,0.9229,1.9210,3.6273,1.8883,2.0815,3.9304,0.0000
 1198.0000,2199.0315,-0.0680,5.4376,5.9539,5.8004,5.7343,5.5437,5.5609,5.9541,0.2755,2.6288,-0.0016,0.1614,3.9784,12.2864,8.3387,8.3387,6.9520,0.0176,1.2828,4.7465,12.8966,4.7465,167.9575,9.6101,6.2317,4.5454,49.5121,34.9123,23.9203,0.9007,1.8025,3.5816,1.9870,2.0011,3.9762,0.8000
 1198.5000,2149.1636,-0.0827,6.1003,6.8064,6.5732,6.4534,6.1511,6.1346,6.8067,0.2755,2.6367,0.2272,0.0383,4.1074,11.6937,7.8076,7.8076,6.4332,0.0132,0.8048,4.2853,12.4748,4.2853,146.9203,9.5757,6.9868,5.7126,47.7286,34.7932,24.2277,0.9114,1.7610,3.6319,2.0624,1.9321,3.9849,2.0000
 1199.0000,2149.3940,-0.0858,6.0195,6.7428,6.4659,6.3070,5.9196,5.8162,6.7431,0.2753,2.6364,0.2018,0.0421,4.2397,11.5071,7.6409,7.6409,6.2701,0.0124,0.8265,4.3062,12.4939,4.3062,148.3060,9.5475,13.9009,7.6022,47.6760,37.9885,26.7627,0.9976,1.9115,4.0557,2.1218,1.9161,4.0656,2.0000
 1199.5000,2158.8606,-0.2005,4.2833,5.5014,5.2421,5.0772,4.6813,4.5343,5.5015,0.2748,2.6082,-0.1311,0.0606,4.0138,12.7831,8.7853,8.7853,7.3877,0.0097,2.5320,5.9519,13.9988,5.9519,181.7725,9.5856,8.4143,4.7561,60.9527,44.3741,31.3327,1.1614,2.2682,4.7788,2.1068,1.9529,4.1145,3.0000
 1200.0000,2173.2451,-0.2964,3.3486,4.7577,4.5132,4.3419,3.9231,3.6725,4.7578,0.2732,2.5852,-0.1185,-0.0246,3.7352,15.2341,11.0102,11.0102,9.5490,0.0067,3.9301,7.3010,15.2324,7.3010,210.1855,9.6200,4.0475,2.7532,74.9422,49.6832,35.0391,1.2999,2.5871,5.3392,2.0638,1.9903,4.1075,4.8000
 1200.5000,2233.5691,-0.4130,3.0619,4.8406,4.5815,4.3827,3.8881,3.3823,4.8407,0.2747,2.5900,0.0418,-0.2028,3.7988,17.7209,13.3033,13.3033,11.7617,0.0068,3.6386,7.0197,14.9753,7.0197,206.5876,9.6605,3.7449,2.7767,74.9476,51.7666,36.2283,1.3516,2.7591,5.4844,1.9878,2.0414,4.0578,1.6000
 1201.0000,2198.2825,-0.5325,3.0072,5.2123,4.9354,4.7037,4.1290,3.3278,5.2125,0.2751,2.5794,-0.0734,-0.7191,4.0394,20.4082,15.8214,15.8214,14.1749,0.0147,4.2797,7.6383,15.5409,7.6383,191.8531,9.7479,4.8897,3.1979,68.9922,50.7880,35.2824,1.3436,2.7687,5.2116,1.8823,2.0607,3.8789,1.6000
 1201.5000,2163.4446,-0.5784,2.4856,4.4441,4.2229,4.0210,3.5219,2.7658,4.4442,0.2755,2.4505,-0.1588,-1.1958,3.9709,25.2674,20.4786,20.4786,18.5958,0.0466,12.0928,15.1772,22.4348,15.1772,225.0167,9.7518,8.3034,3.8205,67.7515,49.6924,34.4261,1.3287,2.7393,5.0009,1.8256,2.0616,3.7636,0.0000
 1202.0000,2134.6880,-0.5413,1.4587,2.5441,2.4312,2.3191,2.0382,1.6265,2.5441,0.2749,2.1669,-0.3137,-1.0728,3.5086,34.9140,30.1118,30.1118,27.5862,0.1040,29.2816,31.7630,37.6014,31.7630,393.0725,9.8807,3.4384,1.2996,67.7764,50.4083,34.8244,1.3498,2.8184,5.0321,1.7855,2.0881,3.7281,0.0000
 1202.5000,2146.4463,-0.4610,1.1297,1.8570,1.7872,1.7105,1.5135,1.2441,1.8570,0.2753,1.9299,-0.5585,-0.0746,3.0959,45.5442,41.3040,41.3040,37.8131,0.1535,43.6414,45.6189,50.2718,45.6189,538.4945,11.1335,0.3933,0.5581,64.5723,52.4609,36.3897,1.4003,2.9435,5.3065,1.8028,2.1021,3.7897,3.2000
 1203.0000,2154.1965,-0.3931,1.1696,1.8177,1.7629,1.6943,1.5127,1.2681,1.8177,0.2751,1.9433,-0.3990,0.8294,3.0658,46.0498,41.8494,41.8494,38.3137,0.1717,42.8277,44.8337,49.5538,44.8337,550.1382,11.9779,0.5819,0.6103,64.0191,53.6214,37.5950,1.4381,2.9793,5.5227,1.8537,2.0717,3.8403,0.8000
 1203.5000,2073.8218,-0.3605,1.4149,2.1364,2.0875,2.0155,1.8172,1.5340,2.1364,0.2750,2.0860,-0.1085,0.5616,3.1849,41.4838,36.9593,36.9593,33.8673,0.1455,34.1802,36.4896,41.9237,36.4896,468.0764,11.6714,0.6955,0.6180,65.2468,52.2234,37.2858,1.4197,2.8315,5.5085,1.9454,1.9944,3.8800,0.0000
 1204.0000,2085.6960,-0.3227,1.5447,2.2516,2.2155,2.1495,1.9598,1.6668,2.2516,0.2752,2.1683,0.1532,-0.0625,3.1615,40.6298,36.0564,36.0564,33.0438,0.0882,29.1960,31.6804,37.5259,31.6804,444.1317,11.4722,0.6620,0.7553,65.4645,52.1211,38.1077,1.4457,2.7131,5.6549,2.0843,1.8767,3.9115,4.8000
 1204.5000,2096.7751,-0.2385,1.5790,2.1140,2.0929,2.0408,1.8870,1.6378,2.1140,0.2751,2.1806,0.4622,-0.2249,3.1961,38.8219,34.1573,34.1573,31.3072,0.0557,28.4494,30.9599,36.8671,30.9599,473.0423,11.6286,0.7410,0.8416,66.1372,52.6068,39.3903,1.4996,2.6155,5.8206,2.2254,1.7441,3.8814,2.4000
 1205.0000,2150.7764,-0.1886,1.4206,1.8005,1.7917,1.7559,1.6539,1.4914,1.8005,0.2750,2.1669,0.2876,0.0261,3.3243,39.5432,34.9129,34.9129,31.9989,0.0603,29.2791,31.7605,37.5992,31.7605,555.4038,11.7488,0.7143,0.7618,67.1088,55.6387,42.6813,1.6325,2.6296,6.2708,2.3847,1.6108,3.8413,2.4000
 1205.5000,2144.8572,-0.1238,1.3216,1.5521,1.5507,1.5269,1.4700,1.3874,1.5521,0.2754,2.1698,-0.0965,0.3541,3.3446,40.8188,36.2558,36.2558,33.2258,0.0644,29.1055,31.5930,37.4460,31.5930,644.2747,12.1879,0.7088,0.7336,70.9167,61.6110,48.2413,1.8564,2.7729,7.0343,2.5368,1.4937,3.7892,4.0000
 1206.0000,2109.3850,-0.0538,1.4277,1.5346,1.5374,1.5199,1.4934,1.4636,1.5346,0.2753,2.2377,0.1278,0.6201,3.4280,38.8074,34.1423,34.1423,31.2934,0.0686,24.9904,27.6223,33.8151,27.6223,651.6171,12.4426,0.5555,0.7427,76.6945,67.2228,53.6701,2.0714,2.8772,7.7972,2.7100,1.3890,3.7643,2.0000
 1206.5000,2109.6267,-0.0152,1.5681,1.6010,1.6061,1.5931,1.5875,1.5912,1.6010,0.2738,2.3635,0.5164,0.9394,3.6564,34.4254,29.6117,29.6117,27.1241,0.0843,17.3653,20.2648,27.0871,20.2648,624.5964,12.0175,0.6736,0.7736,82.4339,71.4292,57.3332,2.2306,3.0105,8.2446,2.7386,1.3497,3.6962,6.4000
 1207.0000,2155.6135,0.0023,1.6974,1.6920,1.6979,1.6885,1.6934,1.7090,1.6920,0.2766,2.4654,0.4183,0.6115,3.7235,31.7297,26.8758,26.8758,24.5875,0.0748,11.1878,14.3040,21.6363,14.3040,591.0244,10.7479,1.2145,1.0855,86.2802,70.6545,56.6412,2.2132,2.9822,8.1000,2.7161,1.3475,3.6600,4.8000
 1207.5000,2168.5923,0.0061,1.8459,1.8304,1.8365,1.8301,1.8369,1.8479,1.8304,0.2750,2.5123,0.0917,-0.2299,3.5910,28.5019,23.6518,23.6518,21.5789,0.0373,8.3429,11.5590,19.1261,11.5590,546.3365,9.9843,2.3901,1.9082,86.4916,69.2748,55.3273,2.1756,2.9516,7.8467,2.6585,1.3567,3.6066,4.0000
 1208.0000,2145.4443,0.0033,1.9425,1.9337,1.9386,1.9356,1.9382,1.9423,1.9337,0.2748,2.5312,-0.2539,-0.4264,3.4115,28.5399,23.6894,23.6894,21.6142,0.0112,7.2014,10.4575,18.1189,10.4575,517.1506,9.9244,3.1901,2.6200,86.5407,69.4772,55.4550,2.1934,2.9501,7.8040,2.6454,1.3449,3.5579,0.8000
 1208.5000,2165.1260,0.0014,1.9556,1.9517,1.9544,1.9551,1.9508,1.9556,1.9517,0.2758,2.5305,-0.5106,-0.1498,3.2989,28.2148,23.3677,23.3677,21.3128,0.0006,7.2428,10.4974,18.1554,10.4974,512.3868,9.9010,3.3886,2.2814,83.7365,67.4960,54.3054,2.1464,2.7777,7.6495,2.7539,1.2941,3.5638,4.8000
 1209.0000,2147.4946,0.0004,1.9728,1.9716,1.9722,1.9765,1.9648,1.9728,1.9716,0.2744,2.5340,-0.4182,-0.2009,3.3910,26.9075,22.0803,22.0803,20.1044,0.0035,7.0275,10.2896,17.9654,10.2897,507.1945,9.8757,4.0040,2.9157,80.0116,66.3288,53.5135,2.1164,2.6718,7.5319,2.8190,1.2624,3.5588,3.2000
 1209.5000,2132.8794,-0.0007,1.9944,1.9963,1.9950,2.0030,1.9851,1.9940,1.9963,0.2757,2.5436,-0.1274,-0.3763,3.5182,26.2128,21.4001,21.4001,19.4645,0.0144,6.4459,9.7285,17.4522,9.7285,500.9233,9.8910,4.3056,2.7570,81.2215,64.8447,52.2336,2.0716,2.5878,7.3244,2.8303,1.2492,3.5356,0.0000
 1210.0000,2216.0759,-0.0005,2.0528,2.0544,2.0518,2.0634,2.0426,2.0518,2.0544,0.2760,2.5406,-0.1296,-0.0997,3.5076,27.0102,22.1812,22.1812,20.1992,0.0155,6.6305,9.9066,17.6151,9.9066,486.7694,9.9500,2.0483,1.8217,81.8576,64.9729,51.8975,2.0581,2.6179,7.2779,2.7801,1.2720,3.5362,0.8000
 1210.5000,2222.7778,0.0077,2.1993,2.1761,2.1729,2.1886,2.1714,2.1942,2.1761,0.2745,2.5232,-0.2546,0.1695,3.4453,27.2513,22.4180,22.4180,20.4217,0.0146,7.6865,10.9255,18.5469,10.9255,459.5425,9.9607,2.1955,1.8984,80.5193,63.7694,50.3900,1.9970,2.6132,7.0730,2.7066,1.3086,3.5419,2.4000
 1211.0000,2259.1250,0.0069,2.1966,2.1758,2.1734,2.1918,2.1905,2.1905,2.1758,0.2748,2.4878,0.0733,0.3025,3.3431,26.9424,22.1146,22.1146,20.1367,0.0302,9.8310,12.9948,20.4391,12.9948,459.6023,9.9407,4.9426,2.6201,77.2860,59.8281,46.7547,1.8355,2.4885,6.6450,2.6703,1.3558,3.6202,1.6000
 1211.5000,2196.4404,0.0418,2.0783,1.9598,1.9597,1.9759,1.9929,2.0730,1.9598,0.2743,2.4631,0.4083,0.7428,3.2683,27.6207,22.7815,22.7815,20.7631,0.0521,11.3252,14.4366,21.7575,14.4366,510.2498,9.9934,3.1017,1.8204,68.7834,51.7053,39.8080,1.5415,2.2025,5.7589,2.6147,1.4288,3.7359,1.6000
 1212.0000,2188.5969,0.0697,2.4054,2.1782,2.1815,2.2020,2.2451,2.3894,2.1782,0.2753,2.4857,0.2524,0.5357,3.4649,24.7308,19.9578,19.9578,18.1040,0.0515,9.9606,13.1199,20.5535,13.1199,459.0960,9.9628,1.3141,1.1070,55.0294,40.5897,30.3170,1.1631,1.8376,4.4373,2.4147,1.5799,3.8149,1.0000
 1212.5000,2150.6616,0.0973,2.9154,2.5345,2.5452,2.5728,2.6565,2.8929,2.5345,0.2754,2.5381,-0.0375,-0.1249,3.8641,19.8991,15.3412,15.3412,13.7160,0.0290,6.7806,10.0514,17.7475,10.0514,394.5573,9.9374,6.7329,4.1606,39.5829,30.4651,21.9140,0.8380,1.4753,3.2204,2.1829,1.7605,3.8430,1.0000
 1213.0000,2174.4890,0.1099,2.8745,2.4518,2.4692,2.4947,2.5928,2.8502,2.4518,0.2750,2.5683,-0.0904,0.0252,4.0949,18.3729,13.9105,13.9105,12.3452,0.0126,4.9515,8.2866,16.1337,8.2866,407.8630,9.9286,10.2352,6.5887,29.5717,23.1292,15.9007,0.6104,1.2095,2.3255,1.9227,1.9815,3.8096,2.4000
 1213.5000,2207.9570,0.1040,2.3764,2.0452,2.0628,2.0807,2.1602,2.3562,2.0452,0.2752,2.5416,0.2067,-0.1012,4.1063,20.4348,15.8466,15.8466,14.1989,0.0104,6.5679,9.8462,17.5599,9.8463,488.9482,9.9169,9.4784,5.7257,27.8176,21.7510,14.3321,0.5511,1.2084,2.0920,1.7312,2.1929,3.7963,4.0000
 1214.0000,2178.0137,0.0912,1.8768,1.6464,1.6612,1.6729,1.7311,1.8629,1.6464,0.2755,2.4641,0.3885,-0.5125,4.1220,24.8442,20.0677,20.0677,18.2079,0.0199,11.2667,14.3801,21.7059,14.3801,607.3976,9.8671,6.7742,4.2716,30.8894,25.5729,16.0649,0.6179,1.5125,2.3437,1.5495,2.4477,3.7928,2.0000
 1214.5000,2167.1987,0.0844,1.5953,1.4138,1.4268,1.4355,1.4822,1.5850,1.4138,0.2766,2.3803,0.0385,-0.1208,4.0080,28.1434,23.2972,23.2972,21.2467,0.0421,16.3447,19.2800,26.1865,19.2800,707.3063,9.8762,4.4673,3.1605,40.7785,32.4389,19.3628,0.7423,2.0414,2.8365,1.3895,2.7500,3.8211,7.0000
 1215.0000,2177.4490,0.0773,1.2402,1.1107,1.1199,1.1255,1.1582,1.2337,1.1107,0.2753,2.3594,-0.4340,0.1960,3.5919,30.9710,26.1128,26.1128,23.8775,0.0592,17.6150,20.5057,27.3073,20.5057,900.3190,9.9097,2.0886,1.3473,53.2664,39.1599,22.2937,0.8570,2.5875,3.2552,1.2580,3.0194,3.7986,2.4000
 1215.5000,2160.1628,0.0754,1.2705,1.1409,1.1501,1.1558,1.1887,1.2630,1.1409,0.2741,2.4190,-0.5884,-0.0701,3.2409,30.4496,25.5904,25.5904,23.3906,0.0482,14.0002,17.0177,24.1178,17.0177,876.5317,9.9473,1.2208,0.7855,57.7586,45.5455,25.0334,0.9601,3.1125,3.6656,1.1777,3.2420,3.8181,2.4000
 1216.0000,2124.7144,0.0725,1.5812,1.4260,1.4379,1.4455,1.4879,1.5719,1.4260,0.2747,2.4942,-0.4551,-0.0832,3.1984,27.2921,22.4581,22.4581,20.4594,0.0208,9.4409,12.6184,20.0949,12.6184,701.2513,9.9338,2.5203,1.4249,61.5835,54.4198,29.5378,1.1328,3.7476,4.3255,1.1542,3.3083,3.8185,1.0000
 1216.5000,2128.5259,0.0632,1.9603,1.7922,1.8057,1.8158,1.8690,1.9517,1.7922,0.2753,2.5367,-0.1874,0.6435,3.2737,24.0867,19.3348,19.3348,17.5149,0.0078,6.8693,10.1370,17.8258,10.1370,557.9629,9.8754,4.0605,2.4278,76.9791,63.7943,34.8278,1.3437,4.3420,5.0623,1.1659,3.2315,3.7676,1.0000
 1217.0000,2178.9685,0.0521,2.2594,2.0993,2.1079,2.1194,2.1721,2.2517,2.0993,0.2747,2.5519,0.1996,0.7517,3.3598,22.8848,18.1785,18.1785,16.4190,0.0112,5.9481,9.2482,17.0130,9.2482,476.3548,9.8247,5.4612,3.4282,93.3044,70.6714,39.0077,1.5049,4.7369,5.6704,1.1971,3.1476,3.7679,0.8000
 1217.5000,2126.4878,0.0441,2.3600,2.2180,2.2149,2.2254,2.2624,2.3527,2.2180,0.2753,2.5559,0.4808,0.0572,3.4862,22.2718,17.5918,17.5918,15.8617,0.0191,5.7050,9.0136,16.7986,9.0136,450.8629,9.6862,5.6421,3.1474,96.6555,70.3232,39.8831,1.5332,4.5601,5.8238,1.2771,2.9742,3.7984,1.6000
 1218.0000,2028.0891,0.0316,2.7542,2.6352,2.6148,2.6265,2.6463,2.7479,2.6352,0.2768,2.5649,0.2717,-0.0524,3.6613,20.6266,16.0279,16.0279,14.3721,0.0208,5.1558,8.4836,16.3139,8.4837,379.4744,9.6244,4.3621,2.6296,86.2445,64.2811,37.4628,1.4332,4.0591,5.5037,1.3559,2.8321,3.8401,2.4000
 1218.5000,1961.8459,0.0003,4.0812,4.0795,4.0072,4.0239,4.0041,4.0796,4.0795,0.2748,2.5866,0.0290,-0.2316,3.9014,16.5783,12.2453,12.2453,10.7426,0.0075,3.8409,7.2149,15.1537,7.2149,245.1254,9.5580,9.0981,6.1510,75.7550,57.1024,33.9631,1.2942,3.5414,5.0142,1.4159,2.7363,3.8743,1.0000
 1219.0000,2081.1355,0.0035,6.4047,6.3740,6.2041,6.2224,6.1040,6.4143,6.3740,0.2747,2.6165,0.1335,-0.4096,4.1518,13.8776,9.7744,9.7744,8.3504,-0.0002,2.0297,5.4673,13.5556,5.4673,156.8861,9.5594,12.0893,8.4496,71.1575,52.7742,31.9048,1.2180,3.2251,4.6999,1.4573,2.6479,3.8587,0.0000
 1219.5000,2097.2351,-0.0202,7.6328,7.8458,7.6177,7.6082,7.5915,7.6414,7.8458,0.2737,2.6362,0.0896,0.2335,4.2938,13.4283,9.3675,9.3675,7.9547,0.0066,0.8370,4.3164,12.5032,4.3164,127.4561,9.5578,10.0640,7.7853,67.6084,51.5511,31.5123,1.2052,3.1238,4.6320,1.4828,2.5920,3.8435,2.4000
 1220.0000,2123.0791,-0.0358,6.6528,6.9836,6.7432,6.7152,6.5440,6.6472,6.9836,0.2740,2.6366,-0.0089,0.7570,4.2900,14.3494,10.2031,10.2031,8.7666,0.0102,0.8135,4.2937,12.4825,4.2937,143.1931,9.5699,10.2167,6.9109,66.7921,53.2050,32.8980,1.2529,3.1828,4.8610,1.5272,2.5404,3.8799,0.0000
 1220.5000,2143.4177,-0.0455,4.8834,5.1925,4.9942,4.9559,4.8086,4.8923,5.1925,0.2738,2.6237,0.0660,0.1266,4.1419,16.8615,12.5069,12.5069,10.9948,0.0092,1.5919,5.0448,13.1693,5.0448,192.5872,9.6182,7.7764,5.1845,72.2237,58.2100,36.5836,1.3898,3.4146,5.4218,1.5878,2.4568,3.9010,0.0000
 1221.0000,2163.4795,-0.0633,3.6594,3.9831,3.8183,3.7720,3.6661,3.7115,3.9831,0.2753,2.6066,-0.0682,-0.9128,3.8764,20.2492,15.6713,15.6713,14.0315,0.0098,2.6280,6.0445,14.0835,6.0446,251.0621,9.6675,5.2902,3.6291,81.1331,64.1302,40.9597,1.5479,3.7002,6.1092,1.6510,2.3904,3.9467,0.0000
 1221.5000,2138.6602,-0.0909,3.0189,3.4037,3.2535,3.1966,3.1009,3.1086,3.4037,0.2759,2.5939,-0.2733,-0.4876,3.6334,24.5358,19.7689,19.7689,17.9255,0.0102,3.3970,6.7866,14.7621,6.7866,293.7955,9.7007,4.1938,2.8352,88.2778,69.9227,45.4073,1.7102,3.9617,6.8004,1.7165,2.3165,3.9764,4.0000
 1222.0000,2144.2229,-0.1226,2.6847,3.1484,3.0038,2.9345,2.8253,2.7966,3.1484,0.2765,2.5803,-0.1034,0.5903,3.4730,26.2988,21.4841,21.4841,19.5436,0.0088,4.2216,7.5822,15.4896,7.5822,317.6253,9.6983,4.1583,2.5460,93.9361,74.3676,49.2663,1.8532,4.1130,7.3898,1.7967,2.2194,3.9876,4.0000
 1222.5000,2245.0059,-0.1558,2.4730,3.0177,2.8780,2.7977,2.6605,2.5822,3.0177,0.2760,2.5623,0.2304,0.3140,3.3525,27.4372,22.6008,22.6008,20.5934,0.0037,5.3171,8.6393,16.4563,8.6393,331.3744,9.7309,3.0740,2.1916,98.3854,77.0971,52.0808,1.9650,4.1423,7.7840,1.8791,2.1081,3.9613,0.8000
 1223.0000,2235.0088,-0.2001,2.3932,3.0725,2.9334,2.8413,2.6590,2.4890,3.0725,0.2748,2.5489,0.3072,-0.1494,3.3470,28.2975,23.4495,23.4495,21.3895,0.0018,6.1266,9.4204,17.1705,9.4204,325.4671,9.8110,2.7999,1.9249,102.2370,78.2314,53.9860,2.0419,4.0664,8.0448,1.9784,1.9914,3.9398,1.6000
 1223.5000,2178.2095,-0.2606,2.3742,3.2532,3.1133,3.0104,2.7749,2.4636,3.2532,0.2751,2.5456,0.0267,-0.3084,3.4825,29.8422,24.9836,24.9836,22.8244,0.0134,6.3284,9.6151,17.3486,9.6151,307.3928,9.8417,1.9589,1.7798,102.3155,77.1633,54.1722,2.0629,3.8970,8.0065,2.0546,1.8891,3.8812,0.8000
 1224.0000,2154.3235,-0.3091,2.0806,2.9934,2.8748,2.7810,2.5434,2.1629,2.9934,0.2762,2.5052,-0.3355,-1.2960,3.5757,34.0202,29.1979,29.1979,26.7414,0.0378,8.7748,11.9756,19.5071,11.9757,334.0682,9.8091,1.8245,1.2248,100.3518,75.3120,53.5625,2.0433,3.7267,7.8995,2.1197,1.8239,3.8661,4.0000
 1224.5000,2169.2029,-0.3097,1.7337,2.4958,2.4069,2.3342,2.1399,1.8060,2.4958,0.2753,2.3065,-0.6356,-1.4070,3.3190,38.2755,33.5868,33.5868,30.7842,0.0804,20.8179,23.5962,30.1334,23.5962,400.6738,9.8506,0.8296,0.6434,98.8806,74.0116,53.3540,2.0365,3.5753,7.8634,2.1994,1.7556,3.8613,2.0000
 1225.0000,2242.4023,-0.2703,1.3910,1.9250,1.8640,1.8146,1.6811,1.4543,1.9250,0.2765,2.0934,-0.7601,-0.0036,2.9393,41.8627,37.3612,37.3612,34.2334,0.1753,33.7336,36.0588,41.5297,36.0588,519.4731,10.7716,0.3027,0.5493,95.9792,75.5657,55.1149,2.0984,3.5796,8.1480,2.2762,1.7059,3.8829,2.0000
 1225.5000,2077.1509,-0.2121,1.2677,1.6494,1.6019,1.5657,1.4725,1.3272,1.6494,0.2763,2.1165,-0.1997,0.8122,2.9831,42.1618,37.6789,37.6789,34.5227,0.2996,32.3335,34.7078,40.2943,34.7078,606.2789,12.9258,1.0544,1.0986,94.2787,79.9934,58.6558,2.2162,3.7653,8.7527,2.3246,1.6990,3.9495,2.4000
 1226.0000,2154.3696,-0.1513,1.5337,1.8616,1.8106,1.7755,1.6979,1.6015,1.8616,0.2753,2.1870,0.5208,0.8247,3.1622,38.1845,33.4920,33.4920,30.6972,0.3260,28.0622,30.5863,36.5255,30.5863,537.1643,13.5413,1.1015,0.9564,94.9558,80.9314,59.0141,2.2145,3.8921,8.8784,2.2812,1.7575,4.0092,2.4000
 1226.5000,2124.1733,-0.1022,1.8905,2.1620,2.1024,2.0661,2.0035,1.9646,2.1620,0.2768,2.2366,0.5914,0.9539,3.1578,33.3182,28.4832,28.4832,26.0796,0.2292,25.0544,27.6840,33.8715,27.6841,462.5280,12.5969,0.4346,0.6272,94.7952,78.3747,56.0980,2.0887,3.9549,8.5179,2.1538,1.8935,4.0781,0.8000
 1227.0000,2126.0505,-0.0759,2.3875,2.6410,2.5639,2.5223,2.4638,2.4565,2.6410,0.2743,2.4134,0.3362,0.8836,3.3187,27.8878,23.0449,23.0449,21.0101,0.1220,14.3418,17.3473,24.4192,17.3473,378.6449,10.8652,1.2652,1.0924,91.9697,69.5879,48.6347,1.7984,3.7057,7.4435,2.0086,2.0606,4.1389,5.0000
 1227.5000,2093.5271,-0.0686,3.6962,4.0506,3.9234,3.8601,3.7728,3.7317,4.0506,0.2757,2.5828,0.0598,0.3452,3.7715,20.3525,15.7688,15.7688,14.1247,0.0698,4.0725,7.4384,15.3581,7.4384,246.8761,9.5370,1.9884,2.0854,82.6418,58.4485,40.0851,1.4785,3.2321,6.1528,1.9037,2.1860,4.1615,1.6000
 1228.0000,2205.3882,-0.0748,6.1706,6.8174,6.5870,6.4740,6.3105,6.1215,6.8168,0.2754,2.6574,-0.0407,-0.0682,4.3138,14.5330,10.3702,10.3702,8.9288,0.0560,-0.4497,3.0749,11.3679,3.0749,146.6827,9.2221,2.3797,3.2978,62.6541,46.3853,30.9953,1.1446,2.6773,4.7512,1.7746,2.3391,4.1510,0.8000
 1228.5000,2148.6575,-0.0839,9.3763,10.4806,10.1047,9.9293,9.6822,9.3379,10.4790,0.2749,2.6925,0.1363,0.0113,4.7538,9.3533,5.7311,5.7311,4.3958,0.0503,-2.5768,1.0224,9.4910,1.0224,95.4143,8.9882,7.4647,9.1599,41.9437,35.4712,23.2656,0.8592,2.0967,3.5659,1.7007,2.4401,4.1500,3.2000
 1229.0000,2074.8237,-0.0440,8.1482,8.6487,8.3381,8.2099,8.0670,8.1770,8.6476,0.2760,2.6935,0.1155,0.0208,4.9166,8.4206,4.9127,4.9127,3.5889,0.0442,-2.6348,0.9664,9.4399,0.9664,115.6242,9.0161,11.7990,10.9519,33.6276,27.7113,17.6857,0.6547,1.6989,2.7033,1.5912,2.5949,4.1290,1.0000
 1229.5000,2119.7388,-0.0350,5.0753,5.3225,5.1174,5.0444,5.0619,5.0857,5.3220,0.2763,2.6574,-0.1157,-0.1365,4.8304,10.2328,6.5077,6.5077,5.1593,0.0372,-0.4499,3.0747,11.3677,3.0747,187.8823,9.0248,12.4482,11.3485,33.4607,23.5460,14.6403,0.5388,1.4896,2.2527,1.5122,2.7645,4.1806,6.0000
 1230.0000,2141.9893,0.0316,3.5184,3.3666,3.2735,3.2442,3.3012,3.5181,3.3664,0.2748,2.6006,-0.0997,-0.1345,4.7117,13.1868,9.1493,9.1493,7.7423,0.0348,2.9910,6.3948,14.4038,6.3948,297.0367,9.0310,11.5497,8.7416,31.5220,19.9990,12.1663,0.4484,1.2960,1.8690,1.4421,2.8902,4.1681,3.0000
 1230.5000,2107.6924,0.0552,2.5277,2.3379,2.2925,2.2804,2.3328,2.5215,2.3378,0.2757,2.5403,-0.0546,-0.3291,4.5853,15.2241,11.0011,11.0011,9.5402,0.0358,6.6496,9.9250,17.6320,9.9250,427.7347,9.0003,6.0611,3.9675,26.1822,17.0311,10.0295,0.3694,1.1486,1.5418,1.3423,3.1089,4.1732,0.0000
 1231.0000,2072.8545,0.0353,1.9567,1.8622,1.8388,1.8352,1.8610,1.9480,1.8622,0.2753,2.4914,0.0264,-0.0030,4.4189,17.1529,12.7764,12.7764,11.2546,0.0313,9.6144,12.7858,20.2480,12.7858,536.9882,8.9727,4.6782,2.6373,20.8612,14.7604,8.2619,0.3060,1.0490,1.2623,1.2032,3.4285,4.1253,0.8000
 1231.5000,2138.3848,0.0013,1.6098,1.6070,1.5974,1.5984,1.5993,1.5999,1.6069,0.2762,2.4651,0.1447,0.5560,4.3628,18.4539,13.9861,13.9861,12.4177,0.0291,11.2042,14.3198,21.6508,14.3198,622.2935,8.9477,4.7563,3.0007,19.1196,14.2816,7.5553,0.2815,1.0731,1.1465,1.0684,3.8126,4.0735,7.2000
 1232.0000,2179.0496,0.0718,1.5426,1.3928,1.3935,1.3975,1.4261,1.5317,1.3927,0.2750,2.4476,-0.1366,-0.0031,4.3928,20.2956,15.7151,15.7151,14.0733,0.0350,12.2671,15.3454,22.5886,15.3454,718.0036,8.9532,4.8918,3.0807,20.7363,14.9488,7.3465,0.2751,1.1905,1.1082,0.9309,4.3279,4.0288,2.0000
 1232.5000,2110.2949,0.0833,1.3459,1.1946,1.2018,1.2075,1.2403,1.3333,1.1946,0.2747,2.4224,-0.2197,-0.5973,4.3626,21.9747,17.3082,17.3082,15.5921,0.0429,13.7954,16.8201,23.9371,16.8201,837.0807,8.9480,4.3104,2.7746,21.3118,15.4501,7.0508,0.2556,1.2975,1.1035,0.8505,5.0768,4.3178,4.0000
 1233.0000,2095.0815,0.0894,1.2113,1.0655,1.0766,1.0836,1.1162,1.1965,1.0655,0.2752,2.3975,0.2650,-0.5076,4.3276,23.4789,18.7490,18.7490,16.9601,0.0538,15.3046,18.2764,25.2688,18.2764,938.5568,8.9469,2.5951,1.9868,20.3901,15.2156,6.4119,0.2182,1.3448,1.0709,0.7964,6.1628,4.9079,3.2000
 1233.5000,2146.4924,0.0972,1.1684,1.0158,1.0310,1.0398,1.0741,1.1505,1.0158,0.2742,2.3870,0.4147,-0.6135,4.3167,24.3512,19.5903,19.5903,17.7566,0.0671,15.9364,18.8860,25.8262,18.8860,984.4190,8.9232,1.8976,1.6911,18.5005,14.2905,5.5866,0.1726,1.3185,1.0161,0.7707,7.6370,5.8854,2.4000
 1234.0000,2209.7644,0.1040,1.1764,1.0124,1.0324,1.0443,1.0818,1.1565,1.0124,0.2736,2.3956,0.0873,-0.4330,4.2783,24.2158,19.4595,19.4595,17.6329,0.0773,15.4200,18.3877,25.3706,18.3878,987.7043,8.9215,1.6075,1.5576,17.1550,13.7877,5.1493,0.1427,1.3000,1.0147,0.7806,9.1128,7.1131,2.0000
 1234.5000,2196.5549,0.1095,1.2334,1.0526,1.0796,1.0963,1.1401,1.2156,1.0526,0.2752,2.4163,0.0387,0.1182,4.2790,23.1420,18.4252,18.4252,16.6531,0.0843,14.1646,17.1763,24.2629,17.1763,950.0176,8.9049,2.0162,1.8616,17.8367,13.9134,5.0583,0.1304,1.3281,1.0429,0.7852,10.1843,7.9971,2.4000
 1235.0000,2190.6235,0.1133,1.2467,1.0579,1.0908,1.1124,1.1605,1.2321,1.0579,0.2756,2.4297,0.1340,0.3273,4.3233,23.2856,18.5632,18.5632,16.7839,0.0878,13.3525,16.3927,23.5463,16.3928,945.2643,8.9060,2.1393,1.9122,18.9234,14.0654,5.1223,0.1212,1.3381,1.1077,0.8278,11.0426,9.1413,4.8000
 1235.5000,2204.0061,0.1200,1.2047,1.0119,1.0471,1.0719,1.1212,1.1873,1.0119,0.2759,2.4239,-0.0962,0.2716,4.3077,24.0442,19.2938,19.2938,17.4761,0.0876,13.7039,16.7318,23.8563,16.7318,988.2147,8.9014,2.4498,2.0356,18.8431,14.0537,5.0220,0.1095,1.3521,1.1302,0.8359,12.3498,10.3232,0.8000
 1236.0000,2191.0037,0.1320,1.1457,0.9447,0.9799,1.0064,1.0559,1.1205,0.9447,0.2767,2.4134,-0.2763,-0.1712,4.2449,24.8654,20.0883,20.0883,18.2273,0.0846,14.3369,17.3426,24.4149,17.3426,1058.5055,8.9172,2.4128,1.9809,18.7931,14.1887,4.8935,0.1030,1.3789,1.1189,0.8115,13.3903,10.8657,0.8000
 1236.5000,2191.6604,0.1490,1.0594,0.8509,0.8829,0.9085,0.9557,1.0204,0.8509,0.2750,2.4013,-0.2340,-0.3901,4.1743,24.5612,19.7935,19.7935,17.9488,0.0803,15.0698,18.0498,25.0616,18.0498,1175.1714,8.9139,2.1572,1.8543,19.6059,14.3045,4.8508,0.0981,1.3941,1.1282,0.8092,13.9410,11.2817,2.0000
 1237.0000,2127.5125,0.1639,0.9674,0.7590,0.7870,0.8105,0.8555,0.9218,0.7590,0.2751,2.3762,-0.2124,0.0364,4.0820,25.3768,20.5850,20.5850,18.6962,0.0752,16.5942,19.5207,26.4066,19.5207,1317.5497,8.9113,2.1825,1.7320,20.5677,15.2219,5.0671,0.1000,1.4907,1.1899,0.7982,14.8997,11.8929,2.0000
 1237.5000,2161.4404,0.1697,0.9093,0.7069,0.7331,0.7562,0.8022,0.8743,0.7069,0.2756,2.3516,-0.0511,0.3902,3.9978,26.0313,21.2228,21.2228,19.2974,0.0707,18.0837,20.9580,27.7209,20.9580,1414.5674,8.9026,1.4164,1.2754,21.0013,16.8537,5.5033,0.1096,1.6587,1.2877,0.7763,15.1290,11.7450,0.0000
 1238.0000,2106.7600,0.1798,0.8985,0.6875,0.7134,0.7372,0.7869,0.8671,0.6875,0.2762,2.3395,0.1058,0.4581,3.9587,26.1558,21.3444,21.3444,19.4120,0.0686,18.8153,21.6639,28.3664,21.6639,1454.6194,8.7630,1.0444,1.1604,22.7883,18.6456,6.0516,0.1211,1.8450,1.4135,0.7661,15.2391,11.6747,0.8000
 1238.5000,2094.9207,0.1956,0.9289,0.6928,0.7198,0.7456,0.8010,0.8904,0.6928,0.2754,2.3323,-0.0356,0.0410,3.9148,26.2107,21.3980,21.3980,19.4625,0.0666,19.2565,22.0896,28.7557,22.0896,1443.3358,8.8794,1.1464,1.1559,26.6310,21.5604,7.1476,0.1588,2.1126,1.5945,0.7548,13.3022,10.0400,0.0000
 1239.0000,2146.6072,0.2308,1.0869,0.7654,0.7984,0.8315,0.9027,1.0124,0.7654,0.2760,2.3351,-0.1147,-0.3629,3.8029,26.9566,22.1286,22.1286,20.1498,0.0660,19.0827,21.9218,28.6023,21.9219,1306.5535,8.9150,1.2869,1.0641,30.5557,24.4200,8.3676,0.2120,2.3621,1.7428,0.7378,11.1412,8.2203,1.6000
 1239.5000,2173.0730,0.3019,1.5045,0.9397,0.9888,1.0406,1.1540,1.3149,0.9397,0.2748,2.3541,0.0714,-0.0677,3.6842,26.1490,21.3377,21.3377,19.4057,0.0682,17.9335,20.8130,27.5883,20.8130,1064.2175,8.9649,1.9967,1.8482,34.5974,27.0021,9.5329,0.2649,2.5768,1.8748,0.7276,9.7287,7.0784,1.6000
 1240.0000,2165.4253,0.3614,1.9555,1.1002,1.1648,1.2368,1.3972,1.6205,1.1002,0.2756,2.3769,0.0616,-0.0230,3.6946,25.0128,20.2313,20.2313,18.3623,0.0705,16.5515,19.4795,26.3690,19.4795,908.9449,8.9877,3.3560,2.9311,37.4048,28.5601,10.1212,0.2979,2.7277,1.9114,0.7007,9.1562,6.4161,2.0000
 1240.5000,2130.9675,0.3544,1.9629,1.1181,1.1803,1.2525,1.4154,1.6494,1.1181,0.2749,2.3945,-0.3180,-0.1372,3.8357,24.8913,20.1134,20.1134,18.2510,0.0728,15.4820,18.4475,25.4252,18.4475,894.3523,9.0066,4.5879,3.3018,38.4134,28.9261,10.1087,0.3032,2.7856,1.8820,0.6756,9.1868,6.2066,3.0000
 1241.0000,2184.7156,0.3119,1.6838,1.0336,1.0817,1.1395,1.2714,1.4769,1.0336,0.2746,2.4049,-0.5125,-0.0485,3.9361,24.2404,19.4832,19.4832,17.6553,0.0752,14.8547,17.8422,24.8718,17.8422,967.5008,9.0327,5.1002,3.3226,38.1085,28.4184,9.7925,0.2908,2.7515,1.8373,0.6677,9.4631,6.3190,4.8000
 1241.5000,2146.2969,0.2858,1.4866,0.9546,0.9905,1.0359,1.1404,1.3177,0.9546,0.2760,2.4034,-0.2804,0.0714,3.9182,24.8321,20.0560,20.0560,18.1968,0.0780,14.9434,17.9278,24.9500,17.9278,1047.6121,9.0577,4.2488,2.3243,37.6264,28.8408,9.8916,0.2913,2.7936,1.8674,0.6684,9.5911,6.4110,1.6000
 1242.0000,2149.3132,0.2861,1.4923,0.9576,0.9883,1.0295,1.1250,1.2966,0.9576,0.2756,2.3969,0.1481,0.4872,3.9255,24.9248,20.1459,20.1459,18.2817,0.0813,15.3396,18.3102,25.2997,18.3102,1044.2317,9.0735,3.3086,1.7320,38.9700,28.5405,9.8773,0.2938,2.7477,1.8506,0.6735,9.3513,6.2980,0.8000
 1242.5000,2173.7410,0.2705,1.5824,1.0428,1.0718,1.1150,1.2133,1.3896,1.0428,0.2755,2.4046,0.3833,0.3683,4.0216,23.9462,19.1992,19.1992,17.3865,0.0873,14.8702,17.8572,24.8854,17.8572,958.9778,9.0994,3.5304,1.8888,38.2054,29.5587,10.5709,0.3176,2.7989,1.9654,0.7022,8.8114,6.1873,0.0000
 1243.0000,2151.7212,0.2423,1.7481,1.2079,1.2364,1.2858,1.3938,1.5727,1.2079,0.2751,2.4297,0.2087,-0.3101,4.0936,24.8313,20.0552,20.0552,18.1961,0.0913,13.3502,16.3905,23.5443,16.3906,827.9022,9.1198,3.3268,1.8774,37.2784,34.4957,12.9019,0.3989,3.1970,2.3456,0.7337,8.0144,5.8799,4.0000
 1243.5000,2140.3652,0.2083,2.0307,1.4837,1.5107,1.5718,1.6972,1.8805,1.4837,0.2756,2.4622,0.1267,-0.5979,4.0077,24.2206,19.4641,19.4641,17.6373,0.0841,11.3798,14.4893,21.8057,14.4893,673.9943,9.1815,3.9124,2.8340,50.5997,47.0057,18.5628,0.5854,4.2291,3.3203,0.7851,7.2243,5.6719,0.0000
 1244.0000,2037.0258,0.1725,2.3308,1.8041,1.8220,1.8921,2.0250,2.2036,1.8041,0.2761,2.5058,0.2384,-0.4262,3.7115,22.4507,17.7628,17.7628,16.0242,0.0726,8.7398,11.9419,19.4763,11.9419,554.2903,9.2410,4.1115,2.4392,81.1626,60.6936,25.2360,0.8082,5.2975,4.4552,0.8410,6.5545,5.5124,0.0000
 1244.5000,2117.5513,0.1311,2.5794,2.1299,2.1273,2.1985,2.3172,2.4703,2.1299,0.2764,2.5702,0.1883,-0.2046,3.5259,22.3423,17.6592,17.6592,15.9258,0.0660,4.8385,8.1775,16.0340,8.1775,469.5029,9.3311,2.0548,1.8103,96.8767,66.4434,28.8458,0.9473,5.6430,4.9811,0.8827,5.9568,5.2581,4.0000
 1245.0000,2171.4490,0.0761,3.1576,2.8329,2.7913,2.8759,2.9853,3.0957,2.8329,0.2742,2.6323,0.2011,-0.0209,3.7288,16.4794,12.1540,12.1540,10.6546,0.0521,1.0723,4.5434,12.7109,4.5435,352.9907,9.3190,7.8249,5.1889,82.9452,63.9322,28.6436,0.9739,5.3044,4.7886,0.9028,5.4467,4.9171,4.0000
 1245.5000,2188.4124,0.0058,3.8224,3.7920,3.6951,3.7846,3.8433,3.8333,3.7920,0.2750,2.6593,0.1984,0.3396,3.9480,13.2072,9.1677,9.1677,7.7602,0.0261,-0.5655,2.9631,11.2657,2.9631,263.7120,9.3151,9.3319,6.0630,70.6936,57.2433,26.2598,0.9241,4.6729,4.2419,0.9078,5.0568,4.5904,2.0000
 1246.0000,2185.3950,-0.0509,4.2150,4.5137,4.3759,4.4220,4.3957,4.2730,4.5137,0.2758,2.6581,-0.0264,0.5727,3.9306,13.4824,9.4165,9.4165,8.0023,0.0096,-0.4898,3.0362,11.3326,3.0362,221.5476,9.3010,8.4326,5.3198,71.2352,55.1944,25.9116,0.9456,4.4092,4.0253,0.9129,4.6628,4.2568,4.0000
 1246.5000,2177.5874,-0.0441,4.5920,4.8715,4.6879,4.6864,4.6849,4.6839,4.8742,0.2760,2.6457,0.0303,0.4734,3.9324,14.0677,9.9470,9.9470,8.5180,0.0041,0.2584,3.7581,11.9927,3.7581,205.2741,9.3322,8.3902,5.7585,71.3886,55.8346,27.5311,1.0283,4.2829,4.1650,0.9725,4.1651,4.0504,4.8000
 1247.0000,2196.1523,-0.1116,4.3480,5.0170,4.7930,4.7586,4.6522,4.4006,5.0308,0.2744,2.6313,0.2083,0.4219,3.9953,14.9012,10.7059,10.7059,9.2543,0.0031,1.1355,4.6044,12.7666,4.6044,199.3214,9.3490,10.4713,6.9054,69.5248,56.4597,29.4729,1.1105,4.1063,4.4126,1.0746,3.6975,3.9734,0.8000
 1247.5000,2199.5725,-0.1187,4.1452,4.8223,4.5802,4.5182,4.4080,4.1769,4.8378,0.2745,2.6170,0.0083,0.3492,3.9437,15.0924,10.8807,10.8807,9.4236,0.0089,1.9974,5.4360,13.5271,5.4360,207.3682,9.3395,9.1560,5.4067,69.2509,56.1755,30.9270,1.1711,3.8651,4.6027,1.1909,3.3002,3.9301,1.0000
 1248.0000,2270.4224,-0.1263,3.8539,4.5252,4.2800,4.1977,4.0950,3.8979,4.5397,0.2762,2.6068,-0.1212,0.0868,3.8304,15.9325,11.6506,11.6506,10.1684,0.0115,2.6155,6.0325,14.0725,6.0325,220.9828,9.2402,7.0564,4.4375,70.9729,56.4228,32.4062,1.2373,3.6954,4.7749,1.2921,2.9868,3.8592,6.0000
 1248.5000,2115.9958,-0.1357,3.6615,4.3487,4.1035,4.0049,3.9018,3.7216,4.3626,0.2748,2.6029,0.0148,-0.1878,3.7639,16.6243,12.2877,12.2877,10.7835,0.0088,2.8530,6.2616,14.2820,6.2616,229.9531,9.2365,6.7965,4.2558,75.5819,57.0052,33.5644,1.2934,3.6156,4.8890,1.3522,2.7954,3.7799,0.8000
 1249.0000,2067.6609,-0.1442,3.4874,4.1845,3.9474,3.8392,3.7261,3.5506,4.1977,0.2762,2.6026,0.1426,-0.3681,3.7311,17.5288,13.1250,13.1250,11.5901,0.0063,2.8747,6.2826,14.3012,6.2826,238.9755,9.2048,6.4467,3.8847,79.7743,57.0899,34.3798,1.3308,3.5208,4.9795,1.4143,2.6457,3.7418,2.4000
 1249.5000,2091.6614,-0.1569,3.3270,4.0529,3.8298,3.7186,3.5857,3.3905,4.0653,0.2740,2.6031,0.1692,-0.0549,3.7124,18.3648,13.9029,13.9029,12.3379,0.0030,2.8417,6.2507,14.2720,6.2507,246.7350,9.2074,6.2379,3.7317,80.1684,56.9345,35.1559,1.3561,3.3887,5.1142,1.5092,2.4988,3.7711,2.4000
 1250.0000,2203.1536,-0.1782,3.1675,3.9555,3.7511,3.6431,3.4847,3.2275,3.9671,0.2753,2.5995,-0.0872,0.1707,3.6917,18.6462,14.1657,14.1657,12.5901,0.0031,3.0603,6.4617,14.4650,6.4617,252.8127,9.2024,6.4457,3.8306,80.7145,56.8622,35.9401,1.3771,3.2690,5.2721,1.6127,2.3738,3.8283,2.0000
 1250.5000,2185.4185,-0.1984,2.9899,3.8208,3.6417,3.5440,3.3683,3.0423,3.8313,0.2748,2.5926,-0.5108,-0.6095,3.6611,19.9562,15.3950,15.3950,13.7674,0.0096,3.4771,6.8639,14.8327,6.8639,261.7223,9.2023,6.0094,3.5560,80.6318,56.8013,36.8051,1.4056,3.1371,5.4211,1.7281,2.2318,3.8567,5.6000
 1251.0000,2120.4417,-0.1870,2.8035,3.5381,3.3928,3.3136,3.1528,2.8469,3.5466,0.2747,2.5041,-0.5300,-1.0594,3.4744,23.5973,18.8629,18.8629,17.0681,0.0202,8.8418,12.0403,19.5663,12.0403,282.6373,9.2051,5.2626,4.2618,77.4966,58.8886,38.9916,1.4996,3.1469,5.6933,1.8092,2.0984,3.7965,1.6000
 1251.5000,2126.8445,-0.1253,2.1134,2.4829,2.3970,2.3520,2.2595,2.1289,2.4867,0.2763,2.3241,-0.0794,-0.2884,3.0784,25.1363,20.3512,20.3512,18.4756,0.0437,19.7517,22.5675,29.1927,22.5675,402.7496,9.2173,4.9589,3.1778,79.1230,62.5653,42.0283,1.6359,3.2685,6.0441,1.8492,1.9979,3.6946,4.0000
 1252.0000,2141.9780,-0.0684,1.5884,1.7393,1.6891,1.6645,1.6136,1.5907,1.7402,0.2765,2.2923,0.1842,0.7577,3.0344,27.7514,22.9103,22.9103,20.8839,0.0597,21.6815,24.4295,30.8955,24.4295,574.9420,9.2866,0.8325,0.7516,86.6942,63.3604,43.1557,1.7050,3.2442,6.0870,1.8763,1.9028,3.5701,1.6000
 1252.5000,2119.4856,-0.0526,1.9994,2.1459,2.0956,2.0729,2.0195,2.0120,2.1459,0.2757,2.4560,0.0134,0.6965,3.5906,24.8722,20.0949,20.0949,18.2335,0.0406,11.7589,14.8550,22.1402,14.8551,466.0034,9.3576,4.1686,2.7818,84.5502,63.0691,43.3382,1.7324,3.1876,6.0167,1.8875,1.8400,3.4730,3.2000
 1253.0000,2068.2366,-0.0498,2.4916,2.6644,2.6143,2.5938,2.5303,2.5107,2.6644,0.2758,2.5546,-0.0471,-0.0172,3.9232,20.8928,16.2799,16.2799,14.6125,0.0121,5.7788,9.0848,16.8636,9.0848,375.3241,9.2989,7.7544,4.3966,78.3879,60.9758,42.0284,1.6962,3.0697,5.7582,1.8758,1.8097,3.3947,1.6000
 1253.5000,2109.9497,-0.0391,2.4846,2.6197,2.5824,2.5693,2.5149,2.4944,2.6197,0.2766,2.5318,0.2227,0.2443,3.7149,20.4036,15.8170,15.8170,14.1707,0.0071,7.1661,10.4234,18.0877,10.4234,381.7202,9.3317,3.5101,2.2636,81.7229,56.2498,38.7832,1.5733,2.8249,5.2752,1.8674,1.7955,3.3528,0.0000
 1254.0000,2116.2612,-0.0283,2.6254,2.7283,2.7026,2.6965,2.6535,2.6281,2.7283,0.2772,2.5251,0.3983,0.3577,3.6784,21.0788,16.4562,16.4562,14.7806,0.0171,7.5689,10.8121,18.4432,10.8121,366.5338,9.2866,2.3627,2.6576,79.3657,48.8669,33.5953,1.3692,2.4695,4.5396,1.8382,1.8037,3.3155,1.0000
 1254.5000,2045.8016,-0.0251,3.4492,3.5693,3.5522,3.5551,3.5226,3.4630,3.5693,0.2759,2.5629,0.3488,-0.2569,4.0185,15.7840,11.5142,11.5142,10.0366,0.0179,5.2780,8.6016,16.4218,8.6016,280.1707,9.1632,5.7692,5.5977,60.2550,37.9745,25.9798,1.0643,1.9305,3.4845,1.8049,1.8139,3.2739,1.6000
 1255.0000,1995.5547,-0.0097,3.9401,3.9926,3.9977,4.0192,3.9958,3.9699,3.9926,0.2758,2.5861,0.3047,-0.2425,4.3250,12.4994,8.5300,8.5300,7.1387,0.0095,3.8746,7.2474,15.1835,7.2474,250.4607,9.1001,10.2909,8.4511,38.2411,26.7735,18.1136,0.7421,1.3915,2.4294,1.7458,1.8752,3.2738,0.0000
 1255.5000,2038.5239,0.0452,3.0278,2.8411,2.8763,2.9153,2.9556,3.0272,2.8411,0.2763,2.5734,0.1485,-0.1814,4.4559,13.4876,9.4212,9.4212,8.0070,0.0087,4.6437,7.9895,15.8621,7.9896,351.9786,9.1339,14.6321,13.4996,25.3909,22.0940,14.7229,0.6007,1.1765,1.9864,1.6884,1.9586,3.3068,0.8000
 1256.0000,2119.0596,0.0768,1.8548,1.6622,1.6857,1.7071,1.7504,1.8327,1.6622,0.2751,2.5337,-0.1860,-0.5358,4.3194,17.4445,13.0468,13.0468,11.5149,0.0175,7.0504,10.3118,17.9856,10.3118,601.6077,9.1425,13.8982,10.8874,23.9794,22.7809,14.8471,0.6001,1.2519,2.0302,1.6217,2.0863,3.3833,0.0000
 1256.5000,2069.7336,0.0927,1.2119,1.0608,1.0756,1.0882,1.1205,1.1880,1.0608,0.2752,2.4807,-0.3085,-0.1751,3.8113,22.8766,18.1706,18.1706,16.4115,0.0263,10.2628,13.4115,20.8201,13.4115,942.6747,9.1332,5.7870,2.7113,31.7870,26.4914,16.5493,0.6619,1.5445,2.2958,1.4864,2.3333,3.4683,0.0000
 1257.0000,2102.7979,0.1067,1.0115,0.8670,0.8808,0.8922,0.9233,0.9870,0.8670,0.2738,2.4542,-0.1654,0.1799,3.3411,27.9126,23.0693,23.0693,21.0330,0.0368,11.8661,14.9585,22.2348,14.9586,1153.3901,9.1562,2.6331,1.1704,39.9969,30.9135,18.0025,0.7217,1.9700,2.4893,1.2636,2.7295,3.4491,0.0000
 1257.5000,2158.3308,0.1245,1.1209,0.9350,0.9542,0.9702,1.0123,1.0896,0.9350,0.2761,2.4538,0.0110,-0.0595,3.3357,26.8817,22.0551,22.0551,20.0807,0.0504,11.8886,14.9802,22.2546,14.9802,1069.5144,9.1925,3.3521,1.6532,43.4916,32.1919,17.2916,0.6972,2.2526,2.3721,1.0531,3.2307,3.4023,0.0000
 1258.0000,2195.1965,0.1479,1.3507,1.0867,1.1164,1.1419,1.2040,1.3029,1.0867,0.2757,2.4372,0.1240,0.0471,3.6898,24.7876,20.0129,20.0129,18.1561,0.0596,12.8970,15.9532,23.1444,15.9532,920.1823,9.1017,4.6542,2.4283,39.8006,29.6412,14.4913,0.5815,2.2730,2.0012,0.8804,3.9086,3.4412,0.0000
 1258.5000,2184.7156,0.1833,1.5301,1.1641,1.2027,1.2375,1.3173,1.4356,1.1641,0.2746,2.4176,0.0700,0.0408,4.0810,22.9421,18.2334,18.2334,16.4711,0.0640,14.0839,17.0985,24.1917,17.0985,859.0294,9.0209,4.2847,2.7212,31.1838,25.7250,11.7028,0.4596,2.0967,1.6638,0.7935,4.5622,3.6204,0.0000
 1259.0000,2162.2581,0.2107,1.5749,1.1463,1.1875,1.2270,1.3137,1.4463,1.1463,0.2757,2.4223,-0.1240,-0.2834,4.2382,21.3884,16.7501,16.7501,15.0608,0.0589,13.7971,16.8218,23.9386,16.8218,872.3472,8.9759,3.9959,2.9851,26.4445,23.1507,9.8335,0.3714,1.9813,1.4680,0.7409,5.3346,3.9525,1.0000
 1259.5000,2199.2036,0.2267,1.5603,1.1063,1.1477,1.1900,1.2809,1.4310,1.1063,0.2766,2.4283,-0.1651,-0.2267,4.1676,20.4476,15.8586,15.8586,14.2104,0.0419,13.4363,16.4736,23.6203,16.4737,903.9149,8.9448,3.4130,2.3772,29.7376,24.4181,9.7546,0.3586,2.1678,1.5027,0.6932,6.0444,4.1900,0.0000
 1260.0000,2184.1396,0.2444,1.5824,1.0896,1.1322,1.1787,1.2776,1.4528,1.0896,0.2753,2.4246,-0.0507,0.1849,4.1094,20.4039,15.8174,15.8174,14.1710,0.0265,13.6597,16.6892,23.8174,16.6892,917.7956,8.9343,2.8088,2.1612,39.9469,29.7549,11.2291,0.4086,2.7213,1.7502,0.6432,6.6608,4.2839,0.8000
 1260.5000,2147.3101,0.2982,1.8216,1.1449,1.1941,1.2516,1.3733,1.5995,1.1449,0.2748,2.4182,-0.0259,0.6692,4.1108,20.4878,15.8967,15.8967,14.2468,0.0157,14.0501,17.0659,24.1619,17.0659,873.4502,8.9205,4.3976,2.6383,52.5563,36.6601,13.4891,0.4895,3.3931,2.1086,0.6214,6.9318,4.3076,0.0000
 1261.0000,2181.7104,0.3922,2.3447,1.2482,1.3084,1.3833,1.5429,1.8479,1.2482,0.2754,2.4144,-0.0518,0.3864,4.0774,20.4472,15.8583,15.8583,14.2101,0.0084,14.2785,17.2863,24.3634,17.2863,801.1774,8.9808,5.7581,3.8465,61.9992,40.6512,15.0435,0.5261,3.7471,2.4455,0.6526,7.1222,4.6481,1.6000
 1261.5000,2178.5771,0.4506,2.7285,1.3047,1.3711,1.4581,1.6453,2.0081,1.3047,0.2758,2.4158,-0.1930,-0.2517,4.0195,20.8391,16.2290,16.2290,14.5640,0.0070,14.1961,17.2068,24.2907,17.2068,766.4871,9.0199,6.5368,4.6134,60.6386,41.0206,15.6041,0.5287,3.7297,2.6175,0.7018,7.0546,4.9508,0.0000
 1262.0000,2159.0112,0.4365,2.5965,1.2745,1.3371,1.4218,1.6072,1.9656,1.2745,0.2759,2.4081,-0.4196,-0.3401,3.9502,21.7950,17.1370,17.1370,15.4291,0.0075,14.6636,17.6579,24.7032,17.6579,784.6376,9.0289,5.8035,3.8788,51.8612,36.9298,14.6109,0.4742,3.2804,2.5497,0.7773,6.9178,5.3769,0.0000
 1262.5000,2104.7209,0.3991,2.3189,1.2191,1.2747,1.3511,1.5227,1.8510,1.2191,0.2759,2.3974,-0.2533,-0.1863,3.9239,22.2041,17.5271,17.5271,15.8002,0.0124,15.3112,18.2827,25.2746,18.2828,820.2493,9.0197,4.9061,3.0822,42.1703,31.8433,12.8415,0.4085,2.7913,2.2801,0.8169,6.8327,5.5814,0.0000
 1263.0000,2133.7656,0.3643,2.1201,1.1867,1.2367,1.3062,1.4670,1.7686,1.1867,0.2754,2.3978,0.2514,-0.0457,4.0061,21.1606,16.5338,16.5338,14.8546,0.0215,15.2871,18.2595,25.2533,18.2595,842.6973,9.0359,4.5983,2.6977,35.2906,28.2027,11.4954,0.3663,2.4494,2.0383,0.8322,6.6872,5.5648,3.0000
 1263.5000,2085.3958,0.3556,2.1159,1.2027,1.2507,1.3177,1.4776,1.7695,1.2027,0.2765,2.4125,0.3053,-0.3009,4.0750,21.6613,17.0097,17.0097,15.3079,0.0297,14.3937,17.3974,24.4650,17.3974,831.4326,9.0463,4.8022,3.0843,32.6631,25.8202,10.6817,0.3485,2.2137,1.8555,0.8382,6.3525,5.3248,0.0000
 1264.0000,2017.6669,0.3498,2.1439,1.2314,1.2774,1.3416,1.4993,1.7786,1.2314,0.2755,2.4255,-0.0530,-0.5887,4.0115,21.5597,16.9129,16.9129,15.2159,0.0353,13.6069,16.6383,23.7708,16.6383,812.1080,9.0838,7.0389,4.7197,32.4847,25.3765,10.6233,0.3557,2.1604,1.8022,0.8342,6.0741,5.0669,1.6000
 1264.5000,2082.3557,0.3255,2.0773,1.2453,1.2875,1.3460,1.4937,1.7478,1.2453,0.2760,2.4152,-0.0483,-0.0556,3.9529,22.4108,17.7246,17.7246,15.9880,0.0361,14.2329,17.2422,24.3231,17.2422,803.0082,9.1120,4.6672,3.2366,33.8113,25.3878,10.6463,0.3656,2.1619,1.7624,0.8152,5.9127,4.8201,1.6000
 1265.0000,2175.8936,0.2930,2.0007,1.2688,1.3072,1.3600,1.4977,1.7305,1.2688,0.2750,2.4085,0.1425,0.4401,4.0325,22.3142,17.6323,17.6323,15.9002,0.0302,14.6371,17.6323,24.6798,17.6323,788.1437,9.1232,4.0623,2.8921,35.4842,26.1581,10.8783,0.3776,2.2465,1.7818,0.7931,5.9492,4.7185,1.0000
 1265.5000,2209.9138,0.2322,1.7617,1.2378,1.2688,1.3114,1.4265,1.6176,1.2378,0.2745,2.4258,0.1430,0.0295,4.1294,21.8037,17.1453,17.1453,15.4370,0.0196,13.5899,16.6219,23.7558,16.6219,807.9175,9.1144,5.2498,3.7058,38.3731,28.4799,11.8153,0.4086,2.4563,1.9427,0.7909,6.0118,4.7546,2.4000
 1266.0000,2139.8579,0.1933,1.5612,1.1688,1.1913,1.2229,1.3118,1.4595,1.1688,0.2760,2.4473,0.2354,0.0839,4.0224,22.2802,17.5998,17.5998,15.8693,0.0112,12.2834,15.3612,22.6030,15.3612,855.5682,9.1387,7.5741,4.3250,43.9065,33.1643,13.8723,0.4807,2.8574,2.2765,0.7967,5.9448,4.7362,1.6000
 1266.5000,2211.3997,0.1695,1.4296,1.1118,1.1274,1.1505,1.2195,1.3401,1.1118,0.2754,2.4648,0.0891,0.3397,3.6983,23.9896,19.2410,19.2410,17.4262,0.0090,11.2244,14.3393,21.6686,14.3394,899.4027,9.1405,4.2855,1.9827,54.1765,40.2892,17.3524,0.5991,3.4211,2.8576,0.8353,5.7101,4.7695,1.6000
 1267.0000,2211.0195,0.1517,1.5420,1.2333,1.2462,1.2685,1.3384,1.4610,1.2333,0.2756,2.4910,-0.4257,-0.0589,3.4266,25.2548,20.4664,20.4664,18.5843,0.0108,9.6344,12.8051,20.2656,12.8051,810.8558,9.1637,2.7286,1.6761,64.8587,47.4620,21.0925,0.7238,3.9594,3.4948,0.8827,5.4706,4.8287,2.0000
 1267.5000,2218.2522,0.1328,1.8690,1.5393,1.5493,1.5753,1.6581,1.7986,1.5393,0.2741,2.5302,-0.5783,-0.1246,3.3328,24.1313,19.3778,19.3778,17.5556,0.0131,7.2621,10.5161,18.1725,10.5161,649.6552,9.1835,4.0948,2.4033,70.9220,54.4937,24.6652,0.8421,4.5131,4.1070,0.9100,5.3594,4.8772,1.6000
 1268.0000,2252.6987,0.1068,2.2465,1.9251,1.9254,1.9531,2.0441,2.1911,1.9251,0.2760,2.5653,-0.2246,0.1896,3.3231,22.6279,17.9323,17.9323,16.1853,0.0159,5.1332,8.4618,16.2940,8.4618,519.4495,9.2164,4.6828,2.7305,74.2329,58.5595,26.9796,0.9276,4.7981,4.4614,0.9298,5.1723,4.8093,3.2000
 1268.5000,2270.0310,0.0714,2.7148,2.4522,2.4303,2.4567,2.5472,2.6759,2.4522,0.2739,2.5864,0.2442,0.4385,3.3576,20.9207,16.3063,16.3063,14.6377,0.0174,3.8534,7.2270,15.1648,7.2270,407.7900,9.2179,5.1909,3.2004,77.0603,59.4071,27.7904,0.9769,4.8152,4.4940,0.9333,4.9290,4.6002,2.4000
 1269.0000,2268.3845,0.0246,3.4090,3.2941,3.2281,3.2472,3.3230,3.3919,3.2941,0.2761,2.6000,0.4105,0.3157,3.4904,18.9829,14.4807,14.4807,12.8921,0.0126,3.0327,6.4351,14.4406,6.4351,303.5724,9.2388,5.6627,3.9144,76.8765,57.0442,27.4981,0.9892,4.5201,4.3398,0.9601,4.5697,4.3874,5.0000
 1269.5000,2260.7830,-0.0329,4.4696,4.6740,4.5516,4.5464,4.5655,4.4989,4.6740,0.2750,2.6206,0.1836,-0.0248,3.7697,15.7563,11.4888,11.4888,10.0120,0.0092,1.7791,5.2255,13.3345,5.2255,213.9505,9.2154,9.8420,6.7186,70.6222,52.9710,26.5279,0.9617,4.0640,4.1512,1.0215,4.2257,4.3164,0.0000
 1270.0000,2242.5293,-0.0895,5.6037,6.3072,6.0961,6.0591,5.9769,5.7153,6.3072,0.2767,2.6407,-0.1331,-0.0267,3.9878,12.9256,8.9136,8.9136,7.5128,0.0098,0.5639,4.0528,12.2622,4.0528,158.5484,9.2251,10.3448,6.8811,64.1619,48.6512,25.2293,0.9145,3.6332,3.9489,1.0869,3.9730,4.3182,3.2000
 1270.5000,2274.3960,-0.1400,6.3731,7.6322,7.3211,7.2401,7.0365,6.5530,7.6322,0.2768,2.6389,-0.2786,0.1802,4.0316,11.8615,7.9578,7.9578,6.5799,0.0058,0.6742,4.1593,12.3595,4.1593,131.0246,9.2716,11.9505,8.8327,59.4511,45.5824,24.2734,0.8778,3.3327,3.8088,1.1428,3.7966,4.3389,2.0000
 1271.0000,2251.5359,-0.1761,6.8706,8.5839,8.1838,8.0564,7.7398,7.0937,8.5839,0.2754,2.6319,-0.2293,0.2745,4.0918,11.4902,7.6258,7.6258,6.2553,0.0019,1.0996,4.5698,12.7349,4.5698,116.4965,9.2189,16.3638,13.4438,56.5836,45.4294,24.4421,0.8908,3.3008,3.8028,1.1521,3.7056,4.2691,2.4000
 1271.5000,2291.3257,-0.1932,6.7222,8.5639,8.1306,7.9743,7.6060,6.9263,8.5639,0.2764,2.6364,0.0028,0.0723,4.1456,11.8123,7.9137,7.9137,6.5369,0.0044,0.8254,4.3052,12.4930,4.3052,116.7696,9.2275,15.6281,11.4981,62.3070,48.2675,26.0696,0.9699,3.5025,3.9620,1.1312,3.6112,4.0850,1.6000
 1272.0000,2229.7463,-0.2043,5.9426,7.6652,7.2632,7.1047,6.7546,6.0867,7.6652,0.2760,2.6427,0.4313,-0.4162,4.1866,13.7385,9.6484,9.6484,8.2278,0.0094,0.4450,3.9381,12.1573,3.9381,130.4591,9.2641,9.2632,7.6672,72.0158,52.8277,28.4826,1.0826,3.8465,4.2200,1.0971,3.5532,3.8982,0.0000
 1272.5000,2243.9004,-0.2056,5.5504,7.1696,6.7964,6.6391,6.3326,5.6709,7.1696,0.2771,2.6370,0.5577,-0.8122,4.3357,16.3478,12.0328,12.0328,10.5376,0.0194,0.7865,4.2677,12.4587,4.2677,139.4784,9.2681,13.5148,9.1178,76.9720,57.2175,30.9369,1.1902,4.1720,4.5156,1.0824,3.5054,3.7941,6.0000
 1273.0000,2146.8950,-0.1573,5.1352,6.2772,5.9678,5.8309,5.6552,5.2291,6.2772,0.2756,2.5781,0.0881,-0.6536,4.2844,19.8902,15.3328,15.3328,13.7079,0.0477,4.3548,7.7108,15.6072,7.7108,159.3068,9.2788,9.3899,5.8096,79.9706,60.0529,32.8802,1.2726,4.3478,4.7630,1.0955,3.4165,3.7428,2.4000
 1273.5000,2212.9888,-0.0722,3.1903,3.5125,3.3536,3.2816,3.2527,3.1931,3.5125,0.2743,2.4788,-0.2752,-0.0272,3.8584,27.5899,22.7512,22.7512,20.7346,0.0830,10.3788,13.5234,20.9224,13.5234,284.6956,9.3782,2.2508,1.9952,84.3191,62.1947,34.5203,1.3362,4.4674,4.9999,1.1192,3.3433,3.7419,0.8000
 1274.0000,2237.3931,-0.0232,2.7577,2.8464,2.7394,2.6964,2.7096,2.7511,2.8464,0.2758,2.4600,-0.1866,0.3112,3.5476,27.9410,23.0974,23.0974,21.0594,0.0820,11.5174,14.6221,21.9271,14.6221,351.3252,9.4582,1.1350,1.1511,85.9269,62.9231,35.5375,1.3770,4.4526,5.1403,1.1545,3.2334,3.7329,1.0000
 1274.5000,2232.2104,-0.0143,3.5144,3.5842,3.4622,3.4062,3.4402,3.5254,3.5842,0.2764,2.5362,-0.2648,0.1603,3.6027,23.7912,19.0497,19.0497,17.2450,0.0469,6.8983,10.1650,17.8514,10.1650,279.0043,9.4872,3.0245,2.4556,80.6067,59.8485,34.5502,1.3410,4.1462,4.9868,1.2027,3.0917,3.7186,1.0000
 1275.0000,2213.7153,-0.0200,4.3204,4.4401,4.2996,4.2291,4.2654,4.3428,4.4401,0.2757,2.5957,-0.5804,0.0159,3.7609,20.6253,16.0267,16.0267,14.3709,0.0234,3.2904,6.6837,14.6680,6.6838,225.2193,9.4990,4.9150,3.6454,72.9937,54.9144,32.6582,1.2658,3.6733,4.7224,1.2856,2.9020,3.7308,3.2000
 1275.5000,2170.8843,-0.0346,5.0344,5.2761,5.1335,5.0633,5.0574,5.0516,5.2761,0.2754,2.6077,-0.4157,0.2825,3.8510,17.8677,13.4399,13.4399,11.8930,0.0181,2.5631,5.9819,14.0262,5.9819,189.5356,9.5025,6.6235,6.0553,64.6901,49.1059,29.7948,1.1555,3.1991,4.3048,1.3456,2.7685,3.7254,1.6000
 1276.0000,2222.9746,-0.0576,5.6862,6.1433,6.0000,5.9360,5.8478,5.6969,6.1433,0.2758,2.6078,0.1328,0.7543,3.9113,15.5460,11.2959,11.2959,9.8255,0.0162,2.5575,5.9765,14.0213,5.9765,162.7780,9.4204,9.1400,8.0179,56.8415,43.4792,26.7732,1.0367,2.7823,3.8761,1.3931,2.6838,3.7389,1.0000
 1276.5000,2241.2854,-0.0779,6.0598,6.7202,6.5828,6.5318,6.3578,6.0741,6.7202,0.2746,2.6072,0.2583,0.8598,3.9687,14.3373,10.1921,10.1921,8.7560,0.0138,2.5969,6.0145,14.0561,6.0145,148.8044,9.3266,7.7128,8.5710,51.3027,40.1358,24.8665,0.9622,2.5523,3.6033,1.4118,2.6526,3.7449,2.4000
 1277.0000,2271.5403,-0.0766,6.1609,6.8211,6.6951,6.6595,6.4683,6.1791,6.8211,0.2756,2.6072,0.1848,0.1139,3.9869,13.6428,9.5616,9.5616,8.1435,0.0090,2.5924,6.0102,14.0521,6.0102,146.6036,9.1935,12.7329,11.8662,48.0204,39.6462,24.8049,0.9570,2.5026,3.6079,1.4416,2.6152,3.7701,0.8000
 1277.5000,2266.9448,-0.0465,5.5596,5.9197,5.8143,5.7892,5.6389,5.5756,5.9197,0.2763,2.6085,0.3673,-0.7460,3.9272,14.9364,10.7381,10.7381,9.2855,0.0083,2.5155,5.9360,13.9843,5.9360,168.9267,9.1785,10.7656,7.7491,51.7925,45.1537,28.7757,1.1088,2.7968,4.1920,1.4989,2.5225,3.7808,0.0000
 1278.0000,2273.3364,-0.0095,4.5809,4.6405,4.5552,4.5317,4.4240,4.5975,4.6409,0.2756,2.5923,0.2293,-0.3842,3.7344,18.4883,14.0183,14.0183,12.4486,0.0151,3.4964,6.8825,14.8498,6.8825,215.4923,9.2189,6.7664,4.3437,66.1898,54.1875,35.5674,1.3583,3.2269,5.2388,1.6235,2.3756,3.8568,1.6000
 1278.5000,2279.2905,0.0031,3.8646,3.8481,3.7755,3.7447,3.6753,3.8817,3.8484,0.2765,2.5629,-0.2791,0.4442,3.4826,21.7477,17.0920,17.0920,15.3863,0.0241,5.2771,8.6007,16.4209,8.6007,259.8659,9.2566,3.3445,2.4757,83.4537,60.6116,40.9706,1.5318,3.4596,6.1908,1.7895,2.2585,4.0415,1.6000
 1279.0000,2239.6389,-0.0114,3.7116,3.7698,3.6812,3.6273,3.5580,3.7562,3.7700,0.2765,2.5573,-0.2765,0.5124,3.4133,22.0700,17.3991,17.3991,15.6785,0.0269,5.6212,8.9327,16.7246,8.9327,265.2686,9.2567,3.3513,2.3891,86.4202,60.6033,41.8739,1.5176,3.3231,6.5548,1.9725,2.1897,4.3191,0.0000
 1279.5000,2227.8345,-0.0794,3.9841,4.4266,4.2870,4.1728,4.0438,4.2024,4.4270,0.2762,2.5812,0.1669,0.1769,3.6000,19.2816,14.7608,14.7608,13.1605,0.0197,4.1726,7.5349,15.4464,7.5350,225.9048,9.2281,5.6759,4.2643,72.7037,54.8835,38.2782,1.3338,2.9352,6.2461,2.1280,2.2007,4.6831,1.6000
 1280.0000,2183.2649,-0.1496,4.6252,5.6020,5.3879,5.1780,4.9018,4.8888,5.6026,0.2765,2.6018,0.2896,-0.2060,3.8465,16.3118,11.9996,11.9996,10.5056,0.0107,2.9222,6.3284,14.3431,6.3284,178.5064,9.2035,7.6852,5.5002,58.9220,47.5151,33.2248,1.1249,2.5033,5.5770,2.2279,2.2253,4.9577,0.0000
 1280.5000,2199.5837,-0.2105,5.0419,6.5470,6.2580,5.9368,5.4506,5.1832,6.5478,0.2763,2.6098,0.0889,-0.3005,4.0094,15.4727,11.2287,11.2287,9.7605,0.0117,2.4362,5.8595,13.9143,5.8595,152.7408,9.1881,6.7771,5.0469,54.0748,42.9411,30.0666,0.9999,2.2435,5.1325,2.2877,2.2436,5.1328,2.0000
 1281.0000,2201.3923,-0.3873,4.7024,7.2706,6.9194,6.4858,5.7250,5.1351,7.2716,0.2762,2.6126,-0.1212,0.0055,4.0359,15.5561,11.3051,11.3051,9.8344,0.0158,2.2650,5.6943,13.7632,5.6943,137.5393,9.1781,6.0834,5.2942,55.2328,43.4148,30.5559,1.0075,2.2403,5.2574,2.3468,2.2236,5.2183,1.6000
 1281.5000,2212.7593,-0.6515,4.1144,7.6923,7.3120,6.7913,5.7835,4.7805,7.6933,0.2762,2.6027,-0.2227,-0.1772,3.9213,16.4134,12.0932,12.0932,10.5959,0.0148,2.8646,6.2729,14.2923,6.2729,130.0005,9.2080,8.2364,5.4472,59.4020,48.5262,34.4143,1.1324,2.4648,5.9323,2.4069,2.1766,5.2388,3.2000
 1282.0000,2252.1116,-0.9869,3.4189,7.3847,7.0389,6.5048,5.4270,4.1252,7.3856,0.2756,2.5703,-0.4144,-0.7274,3.7043,19.3332,14.8092,14.8092,13.2068,0.0150,4.8304,8.1697,16.0268,8.1697,135.4155,9.2258,7.4320,4.2560,70.7355,58.2243,41.5010,1.3658,2.9220,7.1526,2.4478,2.1394,5.2368,1.0000
 1282.5000,2261.1404,-1.1344,2.7101,6.0877,5.8433,5.4003,4.4920,3.2813,6.0883,0.2760,2.5046,-0.6328,-1.0195,3.4409,26.7624,21.9380,21.9380,19.9706,0.0327,8.8147,12.0142,19.5424,12.0142,164.2655,9.3002,3.8446,2.1504,89.7472,70.2280,50.1484,1.6651,3.4935,8.5731,2.4540,2.0980,5.1486,0.8000
 1283.0000,2298.8340,-0.9518,1.5816,3.3787,3.2747,3.0410,2.5494,1.8761,3.3787,0.2780,2.3740,-0.5091,-0.8476,3.1996,36.7025,31.9532,31.9532,29.2836,0.0732,16.7252,19.6471,26.5222,19.6471,295.9692,9.4953,1.6517,0.9259,106.6855,81.3531,57.8811,1.9329,4.0525,9.8430,2.4289,2.0966,5.0924,0.8000
 1283.5000,2273.4512,-0.7618,0.8767,1.7367,1.6992,1.5884,1.3478,1.0244,1.7367,0.2759,2.1351,-0.1727,-0.4353,2.8695,43.3807,38.9785,38.9785,35.7041,0.1019,31.2050,33.6188,39.2985,33.6188,575.8109,10.1183,0.2909,0.3882,118.9147,91.7167,65.1188,2.1793,4.5581,11.0512,2.4245,2.0915,5.0709,0.0000
 1284.0000,2302.5430,-0.6088,0.6403,1.1672,1.1515,1.0841,0.9345,0.7446,1.1672,0.2760,1.8640,0.2819,0.2144,2.4766,47.1529,43.0391,43.0391,39.4229,0.1100,47.6346,49.4720,53.7953,49.4720,856.7289,11.8978,0.2813,0.3765,125.1021,101.8479,71.9064,2.4016,5.1055,12.2262,2.3947,2.1258,5.0908,2.0000
 1284.5000,2164.6772,-0.5000,0.6476,1.0966,1.0883,1.0309,0.9047,0.7541,1.0966,0.2765,1.8255,0.5066,1.2360,2.4288,38.5720,33.8962,33.8962,31.0679,0.1254,49.9699,51.7253,55.8558,51.7253,911.9119,16.2643,0.3149,0.4354,123.3766,108.9793,76.3253,2.5313,5.5277,13.0626,2.3631,2.1838,5.1605,0.0000
 1285.0000,2093.2156,-0.4462,1.0418,1.6925,1.6838,1.6021,1.4293,1.2170,1.6925,0.2753,2.1350,0.2957,1.3097,2.9598,29.3229,24.4664,24.4664,22.3412,0.1266,31.2148,33.6283,39.3072,33.6283,590.8290,14.2382,1.5400,0.8707,109.2835,89.1463,61.9234,2.0361,4.5775,10.6811,2.3334,2.2482,5.2458,1.6000
 1285.5000,2209.8801,-0.4172,2.4106,3.8243,3.8013,3.6247,3.2614,2.7704,3.8243,0.2765,2.4821,0.2821,0.5155,3.6703,17.4938,13.0925,13.0925,11.5589,0.0850,10.1770,13.3287,20.7444,13.3287,261.4884,9.1325,6.2088,4.9522,82.4509,60.6072,41.7418,1.3645,3.1485,7.2380,2.2989,2.3074,5.3045,1.6000
 1286.0000,2211.8721,-0.3359,6.3261,9.3377,9.2546,8.8345,7.9754,6.6843,9.3377,0.2758,2.6144,0.3373,0.3467,4.0590,12.2680,8.3221,8.3221,6.9359,0.0413,2.1588,5.5918,13.6695,5.5918,107.0923,8.9895,10.4449,8.5999,58.1351,46.2112,31.4445,1.0280,2.4432,5.4521,2.2315,2.3767,5.3038,5.0000
 1286.5000,2213.3464,-0.2770,9.9372,13.8476,13.6631,13.0559,11.8151,9.8357,13.8476,0.2758,2.6294,0.0214,0.3750,4.1090,11.2694,7.4288,7.4288,6.0625,0.0254,1.2490,4.7140,12.8668,4.7140,72.2147,8.8857,9.4732,8.5348,46.0647,37.2131,25.0863,0.8205,1.9976,4.3478,2.1766,2.4345,5.2989,0.8000
 1287.0000,2194.9309,-0.2914,8.0367,11.3627,11.1478,10.6681,9.7075,8.2453,11.3627,0.2758,2.6270,-0.1202,-0.0066,4.0886,12.0758,8.1498,8.1498,6.7675,0.0182,1.3963,4.8561,12.9968,4.8561,88.0075,8.8672,5.3881,5.7666,43.0571,33.9240,22.6869,0.7426,1.8406,3.9291,2.1347,2.4786,5.2909,1.6000
 1287.5000,2233.5005,-0.2520,6.8077,9.2447,9.0153,8.6465,7.9336,7.0639,9.2447,0.2757,2.6208,-0.0767,-0.1537,4.1669,13.3923,9.3350,9.3350,7.9230,0.0134,1.7687,5.2154,13.3254,5.2155,108.1705,8.8798,4.6243,4.8408,43.5103,33.6332,22.2865,0.7301,1.8406,3.8568,2.0954,2.5209,5.2823,0.0000
 1288.0000,2173.8557,-0.1909,6.4764,8.2295,7.9807,7.6762,7.1139,6.7178,8.2295,0.2753,2.6195,-0.3448,0.0645,4.2397,13.6269,9.5473,9.5473,8.1296,0.0112,1.8488,5.2927,13.3960,5.2927,121.5141,8.8821,8.2239,7.2257,44.9878,34.5716,22.6162,0.7404,1.9097,3.9164,2.0508,2.5793,5.2895,0.8000
 1288.5000,2231.8540,-0.1190,6.2756,7.3270,7.0725,6.8242,6.4070,6.4140,7.3270,0.2759,2.6135,-0.4267,-0.0529,4.0811,13.6234,9.5441,9.5441,8.1264,0.0082,2.2114,5.6426,13.7160,5.6426,136.4818,8.9052,12.8397,8.3811,49.7708,37.2859,24.0096,0.7953,2.0806,4.1137,1.9772,2.6161,5.1725,0.0000
 1289.0000,2231.3579,-0.0585,5.9114,6.3944,6.1494,5.9521,5.7035,5.9717,6.3944,0.2765,2.5973,-0.0425,-0.1661,3.7705,15.1684,10.9501,10.9501,9.4909,0.0056,3.1920,6.5888,14.5812,6.5888,156.3878,8.9314,6.4131,4.5950,57.3455,42.6136,26.9985,0.9197,2.4067,4.5054,1.8721,2.6169,4.8989,0.0000
 1289.5000,2200.7241,-0.0299,5.5338,5.7634,5.5347,5.3797,5.2745,5.5881,5.7634,0.2759,2.5916,0.4031,0.0823,3.6845,17.7754,13.3540,13.3540,11.8104,0.0060,3.5373,6.9219,14.8858,6.9219,173.5095,8.9666,4.7740,4.3038,62.5818,47.9397,29.8683,1.0648,2.7743,4.7593,1.7155,2.6053,4.4695,0.0000
 1290.0000,2211.1003,-0.0564,5.2470,5.6595,5.4272,5.2793,5.2828,5.2856,5.6595,0.2766,2.5938,0.6004,0.1221,3.7925,17.6730,13.2589,13.2589,11.7190,0.0108,3.4066,6.7959,14.7706,6.7959,176.6926,9.0145,7.6151,5.1194,66.5164,50.5830,30.9243,1.1659,3.0312,4.6267,1.5264,2.5999,3.9684,4.8000
 1290.5000,2250.2808,-0.0021,5.8839,5.9013,5.6514,5.4970,5.5829,5.9064,5.9013,0.2754,2.5982,0.3982,0.1009,3.8897,15.5390,11.2895,11.2895,9.8193,0.0215,3.1418,6.5403,14.5369,6.5403,169.4556,8.9860,5.5261,4.7713,66.4200,48.2519,28.8047,1.1381,3.0136,4.0624,1.3480,2.6480,3.5695,1.6000
 1291.0000,2281.0754,-0.0180,7.8657,8.0621,7.6501,7.3816,7.5887,7.8835,8.0621,0.2754,2.6205,-0.0075,-0.1902,4.1107,11.5215,7.6538,7.6538,6.2827,0.0251,1.7850,5.2311,13.3397,5.2311,124.0365,8.8976,16.1776,13.5763,57.4481,41.9911,24.4008,0.9897,2.7303,3.3196,1.2158,2.7586,3.3540,1.0000
 1291.5000,2194.8850,-0.0655,12.1255,13.2352,12.4572,11.8782,12.3455,12.1787,13.2352,0.2742,2.6475,-0.2923,-0.4501,4.4086,8.3327,4.8358,4.8358,3.5129,0.0144,0.1542,3.6575,11.9007,3.6575,75.5563,8.8475,23.2650,23.0346,47.2620,34.9738,19.6996,0.8035,2.3643,2.6589,1.1246,2.9425,3.3092,3.0000
 1292.0000,2223.0432,-0.0970,14.1649,16.0943,15.2326,14.6205,14.9902,14.2470,16.0943,0.2760,2.6665,-0.2737,-0.3076,4.5339,7.5345,4.1400,4.1400,2.8249,0.0067,-1.0030,2.5410,10.8797,2.5410,62.1338,8.8260,25.2506,32.0145,38.6015,29.4407,16.2617,0.6571,2.0429,2.2242,1.0887,3.1090,3.3848,0.8000
 1292.5000,2226.9932,-0.0902,12.6145,14.2108,13.4950,13.0206,13.2539,12.6743,14.2108,0.2756,2.6640,-0.2645,-0.4659,4.4766,8.1861,4.7078,4.7078,3.3865,0.0053,-0.8456,2.6928,11.0186,2.6928,70.3690,8.8303,37.3635,34.4117,33.3992,29.0071,15.8814,0.6313,2.0440,2.2216,1.0869,3.2376,3.5189,0.8000
 1293.0000,2229.2964,-0.0492,8.9949,9.6115,9.1663,8.9031,9.0445,9.0136,9.6115,0.2773,2.6384,-0.3052,-0.0314,4.3043,10.8462,7.0520,7.0520,5.6934,0.0076,0.7058,4.1898,12.3875,4.1898,104.0420,8.8677,20.1894,12.4018,39.6061,34.0496,18.7353,0.7286,2.4002,2.6973,1.1238,3.2940,3.7018,4.0000
 1293.5000,2166.8760,-0.0082,6.5484,6.6225,6.3682,6.2488,6.3320,6.5503,6.6225,0.2757,2.6175,0.0946,0.6842,4.0745,14.6725,10.4973,10.4973,9.0521,0.0146,1.9684,5.4081,13.5015,5.4081,150.9994,8.9554,7.6353,5.0738,55.7244,41.3092,23.3025,0.8875,2.8425,3.4440,1.2116,3.2028,3.8806,2.4000
 1294.0000,2177.8057,0.0074,5.6055,5.5485,5.3684,5.2966,5.3580,5.6048,5.5485,0.2747,2.6083,0.3114,0.5305,3.9164,18.0063,13.5688,13.5688,12.0169,0.0171,2.5266,5.9467,13.9941,5.9467,180.2288,9.0366,3.9473,3.6839,67.2979,46.6494,26.9578,1.0021,3.1271,4.1010,1.3115,3.1205,4.0925,2.4000
 1294.5000,2240.0764,0.0032,5.7463,5.7207,5.5381,5.4770,5.5219,5.7470,5.7207,0.2759,2.6043,-0.1218,0.1874,3.8344,17.7025,13.2863,13.2863,11.7453,0.0103,2.7714,6.1829,14.2100,6.1829,174.8039,9.1156,6.1305,5.2071,64.6481,47.1528,28.2717,1.0156,3.0293,4.4684,1.4750,2.9827,4.3996,1.0000
 1295.0000,2278.7957,-0.0332,6.1050,6.3864,6.1778,6.1146,6.1158,6.1167,6.3864,0.2763,2.6060,-0.3328,-0.1287,3.8504,14.6636,10.4892,10.4892,9.0442,0.0039,2.6648,6.0801,14.1160,6.0801,156.5838,9.1200,7.7183,6.2829,54.1917,42.0942,26.1547,0.9187,2.6057,4.2329,1.6245,2.8364,4.6076,1.6000
 1295.5000,2280.1890,-0.0414,7.0699,7.4768,7.2325,7.1510,7.0596,7.1322,7.4768,0.2760,2.6119,-0.1129,-0.2131,4.0810,12.6681,8.6817,8.6817,7.2867,0.0043,2.3112,5.7388,13.8040,5.7389,133.7479,9.1151,9.7206,8.1678,44.7755,36.0169,23.3854,0.8198,2.1126,3.7924,1.7951,2.5770,4.6260,1.6000
 1296.0000,2282.9524,-0.0763,8.0222,8.8789,8.5918,8.4760,8.2527,8.0779,8.8789,0.2753,2.6192,0.0961,0.2001,4.3437,10.2040,6.4822,6.4822,5.1343,0.0053,1.8670,5.3103,13.4121,5.3103,112.6267,9.0516,12.9326,10.4953,38.2616,30.8982,21.0224,0.7458,1.6975,3.3672,1.9836,2.2761,4.5148,0.0000
 1296.5000,2277.2402,-0.1109,8.6117,9.9554,9.6384,9.4769,9.1049,8.6740,9.9554,0.2770,2.6346,0.1961,0.4136,4.4800,9.0010,5.4214,5.4214,4.0907,0.0073,0.9359,4.4118,12.5905,4.4118,100.4481,9.0209,12.4275,10.1558,35.4842,28.5235,20.2295,0.7237,1.4592,3.2114,2.2008,2.0162,4.4372,3.2000
 1297.0000,2264.9182,-0.1461,9.1695,11.0621,10.7250,10.5080,9.9758,9.2352,11.0621,0.2762,2.6596,0.1709,0.0661,4.6346,8.9484,5.3752,5.3752,4.0452,0.0136,-0.5811,2.9480,11.2519,2.9480,90.3984,8.9662,19.4340,20.8555,37.2829,29.7523,21.8311,0.7805,1.4176,3.4683,2.4467,1.8163,4.4439,2.4000
 1297.5000,2258.2039,-0.1754,7.1806,8.9641,8.7159,8.5143,8.0148,7.2792,8.9641,0.2757,2.6679,-0.0530,-0.4838,4.7543,10.9142,7.1125,7.1125,5.7526,0.0274,-1.0837,2.4631,10.8085,2.4631,111.5561,8.9954,27.1168,24.6828,43.7200,35.8680,27.2013,0.9598,1.5831,4.3815,2.7677,1.6493,4.5649,2.4000
 1298.0000,2264.3999,-0.1809,4.8302,6.0682,5.9266,5.7796,5.4220,4.9450,6.0682,0.2758,2.6298,-0.2874,-0.9878,4.6484,15.8670,11.5905,11.5905,10.1103,0.0693,1.2220,4.6878,12.8429,4.6878,164.7937,9.0529,13.8197,6.7435,58.1262,47.8910,37.0381,1.2938,2.0176,6.0280,2.9877,1.5594,4.6590,3.0000
 1298.5000,2150.4885,-0.1688,3.2817,4.0657,3.9945,3.8931,3.6472,3.3822,4.0657,0.2764,2.5596,-0.2136,-0.8307,4.3774,23.4319,18.7038,18.7038,16.9173,0.1467,5.4808,8.7972,16.6007,8.7972,245.9613,9.4374,3.4161,2.1225,80.5639,63.5459,50.0841,1.7421,2.5791,8.1867,3.1743,1.4804,4.6993,0.8000
 1299.0000,2101.7732,-0.1664,2.3328,2.8822,2.8504,2.7788,2.5951,2.4073,2.8822,0.2761,2.4920,-0.0562,-0.2434,4.0399,31.5298,26.6744,26.6744,24.4003,0.1986,9.5740,12.7468,20.2123,12.7468,346.9553,10.1353,0.6205,0.8842,100.1609,78.5861,62.4111,2.1651,3.1858,10.2293,3.2109,1.4715,4.7246,2.4000
 1299.5000,2151.4556,-0.1841,1.9676,2.4809,2.4691,2.4093,2.2410,2.0275,2.4809,0.2757,2.4347,-0.0623,0.3836,3.6340,35.8588,31.0824,31.0824,28.4817,0.1737,13.0501,16.1010,23.2795,16.1010,403.0875,10.5683,0.9645,0.9426,110.5281,88.7958,71.1110,2.4595,3.5756,11.6904,3.2694,1.4538,4.7532,0.0000
 1300.0000,2301.2756,-0.2081,1.8557,2.4035,2.4062,2.3511,2.1835,1.9102,2.4035,0.2762,2.3956,-0.0611,0.2999,3.2830,36.0068,31.2349,31.2349,28.6222,0.1186,15.4164,18.3842,25.3674,18.3843,416.0527,10.5375,1.0164,0.9885,115.7046,91.4784,73.6716,2.5390,3.6565,12.1541,3.3240,1.4401,4.7869,2.4000
 1300.5000,2251.7664,-0.2144,1.6122,2.1029,2.1140,2.0694,1.9274,1.6573,2.1029,0.2764,2.3451,-0.0134,-0.8413,3.0946,38.4476,33.7663,33.7663,30.9488,0.0858,18.4792,21.3395,28.0698,21.3395,475.5443,10.5350,1.1178,0.8696,115.2202,89.3063,72.3400,2.4758,3.5019,12.0167,3.4315,1.4145,4.8537,0.8000
 1301.0000,2165.2993,-0.1968,1.1194,1.4319,1.4439,1.4162,1.3288,1.1491,1.4319,0.2757,2.1642,-0.0103,-1.1423,2.9317,43.9566,39.5954,39.5954,36.2639,0.0881,29.4428,31.9185,37.7436,31.9185,698.3627,10.7227,0.9353,0.7115,109.0997,85.3682,69.6954,2.3915,3.2449,11.5479,3.5587,1.3569,4.8287,0.0000
 1301.5000,2241.9187,-0.1710,0.8013,0.9953,1.0054,0.9877,0.9364,0.8219,0.9953,0.2761,1.8966,-0.0532,0.3342,2.7091,48.9613,44.9894,44.9894,41.2829,0.1201,45.6629,47.5695,52.0555,47.5695,1004.7027,11.7438,0.3723,0.5022,103.0239,82.0483,67.3472,2.3207,3.0488,11.1125,3.6449,1.3137,4.7885,0.8000
 1302.0000,2274.1316,-0.1509,0.8360,1.0144,1.0250,1.0077,0.9650,0.8576,1.0144,0.2757,1.8054,-0.1100,1.9843,2.5756,47.5247,43.4401,43.4401,39.8014,0.1370,51.1859,52.8986,56.9287,52.8986,985.8391,12.9618,0.3741,0.5240,97.4602,80.3021,66.2728,2.3022,2.9278,10.8474,3.7050,1.2717,4.7118,2.4000
 1302.5000,2294.7805,-0.1469,1.4041,1.6955,1.7109,1.6818,1.6169,1.4437,1.6955,0.2770,2.0188,0.0127,1.5400,2.7621,37.3031,32.5754,32.5754,29.8557,0.1120,38.2570,40.4234,45.5208,40.4234,589.8107,13.0066,0.6615,0.7179,90.9749,73.7651,61.1839,2.1398,2.6344,9.9461,3.7755,1.2311,4.6481,1.6000
 1303.0000,2370.6870,-0.1598,2.7478,3.3690,3.3915,3.3313,3.1957,2.8494,3.3690,0.2768,2.3640,0.3338,0.1375,3.3430,29.7107,24.8524,24.8524,22.7019,0.0758,17.3304,20.2310,27.0562,20.2311,296.8224,10.5960,3.3005,1.9751,79.9197,62.8659,52.2376,1.8249,2.2220,8.5016,3.8262,1.2176,4.6587,3.0000
 1303.5000,2328.4780,-0.1803,3.8157,4.7903,4.8047,4.7153,4.4899,4.0038,4.7903,0.2772,2.5734,0.3098,-0.0350,3.8583,23.8237,19.0811,19.0811,17.2747,0.0423,4.6405,7.9864,15.8592,7.9864,208.7533,9.6702,6.7595,4.5700,70.8703,56.5181,46.8327,1.6331,2.0052,7.6360,3.8081,1.2279,4.6759,4.0000
 1304.0000,2263.2942,-0.1985,3.6222,4.6420,4.6324,4.5419,4.2732,3.8129,4.6420,0.2753,2.6035,-0.1341,0.2267,3.8854,21.9972,17.3297,17.3297,15.6125,0.0133,2.8212,6.2310,14.2540,6.2310,215.4232,9.6064,5.5595,3.9224,73.2488,56.5041,46.6977,1.6269,2.0113,7.6210,3.7892,1.2363,4.6844,3.2000
 1304.5000,2215.2234,-0.2321,3.4909,4.6413,4.6056,4.5116,4.1975,3.6721,4.6413,0.2762,2.5855,-0.3649,-0.0946,3.6559,23.7604,19.0200,19.0200,17.2169,0.0051,3.9072,7.2789,15.2122,7.2789,215.4574,9.5911,4.1890,3.0022,78.1621,60.9362,49.8038,1.7475,2.2349,8.0690,3.6104,1.2789,4.6174,1.0000
 1305.0000,2270.2729,-0.2682,3.4396,4.7502,4.6864,4.5875,4.2558,3.5876,4.7502,0.2768,2.5710,-0.2627,-0.7326,3.5264,28.1772,23.3306,23.3306,21.2780,0.0163,4.7852,8.1260,15.9869,8.1260,210.5194,9.6230,3.0834,2.5573,83.5777,64.7189,51.8132,1.8409,2.5228,8.2860,3.2844,1.3704,4.5011,2.4000
 1305.5000,2258.1006,-0.2831,2.7840,3.9032,3.8298,3.7479,3.4862,2.9239,3.9032,0.2755,2.5077,-0.0983,-1.2663,3.4661,32.0736,27.2226,27.2226,24.9099,0.0391,8.6221,11.8283,19.3724,11.8283,256.1970,9.6543,2.9639,1.7227,89.2003,66.1991,51.5525,1.8461,2.7731,8.1759,2.9483,1.5022,4.4288,0.8000
 1306.0000,2281.1912,-0.2901,1.6873,2.3824,2.3274,2.2778,2.1164,1.7813,2.3824,0.2758,2.3417,0.0461,-0.7471,3.2921,35.2974,30.5051,30.5051,27.9492,0.0721,18.6861,21.5392,28.2524,21.5392,419.7445,9.7365,1.0014,0.4303,90.3593,64.9488,48.8886,1.7526,2.9523,7.7444,2.6231,1.6846,4.4189,0.0000
 1306.5000,2380.0498,-0.2640,1.3711,1.8853,1.8340,1.7935,1.6588,1.4473,1.8853,0.2758,2.1937,0.1136,0.8092,3.2282,33.0739,28.2351,28.2351,25.8497,0.1043,27.6534,30.1918,36.1647,30.1918,530.4065,10.5101,0.2240,0.4196,86.1044,60.9839,44.5162,1.5936,2.9391,7.0625,2.4029,1.8444,4.4319,2.4000
 1307.0000,2363.0168,-0.2455,1.9380,2.6137,2.5298,2.4661,2.2704,2.0505,2.6137,0.2757,2.2777,0.1276,1.4012,3.6519,25.9470,21.1405,21.1405,19.2199,0.1105,22.5617,25.2788,31.6721,25.2788,382.6000,10.3356,2.4460,2.0001,71.4778,51.3559,36.6433,1.3168,2.5824,5.7897,2.2420,1.9612,4.3969,0.8000
 1307.5000,2321.5793,-0.2845,4.1652,5.8485,5.6373,5.4728,5.0088,4.4754,5.8485,0.2763,2.5112,0.2061,0.6543,4.3168,13.7676,9.6747,9.6747,8.2535,0.0834,8.4125,11.6260,19.1875,11.6261,170.9837,9.2313,20.0918,20.1677,51.8220,39.5084,27.4342,1.0061,2.0823,4.2383,2.0354,2.0696,4.2126,5.0000
 1308.0000,2385.4629,-0.3805,10.8841,16.7315,16.0878,15.5600,14.1284,12.2004,16.7315,0.2767,2.6597,0.3025,0.0916,4.6732,7.7779,4.3518,4.3518,3.0346,0.0479,-0.5849,2.9444,11.2486,2.9444,59.7675,9.0062,18.4344,16.3920,39.5044,30.1400,20.3874,0.7655,1.6523,3.0653,1.8551,2.1586,4.0044,2.4000
 1308.5000,2300.0205,-0.6086,19.1179,34.8446,33.4779,32.2816,29.0759,24.0059,34.8446,0.2769,2.6976,0.1884,0.0961,4.7276,6.4250,3.1791,3.1791,1.8720,0.0258,-2.8829,0.7270,9.2210,0.7270,28.6989,8.9244,24.0105,30.0607,34.6000,25.8220,17.0957,0.6495,1.4568,2.5343,1.7396,2.2431,3.9020,7.2000
 1309.0000,2296.7847,-0.5960,13.6914,24.7585,23.8310,22.9578,20.5884,16.4339,24.7585,0.2771,2.6986,-0.1233,-0.2663,4.7720,6.4527,3.2030,3.2030,1.8958,0.0185,-2.9442,0.6679,9.1669,0.6679,40.3901,8.9093,39.3846,64.1503,31.3043,28.3028,18.2340,0.6959,1.6476,2.6879,1.6314,2.3675,3.8624,6.4000
 1309.5000,2317.8713,-0.4392,6.3966,10.3338,9.9923,9.6476,8.6880,6.9572,10.3338,0.2762,2.6766,-0.3784,-0.9366,4.8018,9.6819,6.0207,6.0207,4.6807,0.0385,-1.6102,1.9550,10.3439,1.9550,96.7701,8.9710,31.1759,49.8603,40.5126,37.6447,23.6972,0.9039,2.2473,3.4958,1.5556,2.4863,3.8676,4.0000
 1310.0000,2271.6550,-0.3262,2.8308,4.1401,4.0305,3.9089,3.5638,2.9506,4.1401,0.2764,2.5635,-0.5831,-1.0438,4.4936,18.8917,14.3953,14.3953,12.8103,0.0998,5.2396,8.5645,16.3879,8.5645,241.5401,8.9841,16.8583,12.3408,68.1045,52.2987,31.8843,1.2156,3.2430,4.7062,1.4512,2.6678,3.8714,0.8000
 1310.5000,2262.0154,-0.2363,1.3409,1.7909,1.7549,1.7098,1.5862,1.3789,1.7909,0.2758,2.3356,-0.5599,-0.5314,3.8235,32.3025,27.4538,27.4538,25.1247,0.1727,19.0548,21.8950,28.5777,21.8950,558.3764,9.2404,0.8341,0.6763,93.2437,66.6073,39.5041,1.5253,4.2715,5.7401,1.3438,2.8005,3.7633,0.8000
 1311.0000,2294.2856,-0.1629,1.0065,1.2384,1.2210,1.1947,1.1317,1.0324,1.2384,0.2757,2.1680,-0.1316,0.2840,3.3333,37.8030,33.0947,33.0947,30.3327,0.2139,29.2094,31.6933,37.5377,31.6933,807.4722,10.1019,0.2919,0.4518,100.0868,73.2950,42.3207,1.6598,4.8689,6.0268,1.2378,2.9334,3.6310,0.0000
 1311.5000,2262.0852,-0.1237,1.2938,1.5193,1.5046,1.4767,1.4224,1.3290,1.5193,0.2757,2.2317,0.1412,0.8186,3.3583,31.4194,26.5634,26.5634,24.2969,0.2052,25.3505,27.9698,34.1328,27.9698,658.1980,10.1196,0.4799,0.7538,95.3475,67.4383,38.3811,1.5117,4.5716,5.4356,1.1890,3.0242,3.5958,0.0000
 1312.0000,2234.7793,-0.1158,2.2125,2.5731,2.5530,2.5092,2.4339,2.2765,2.5731,0.2771,2.4280,0.0460,0.8789,3.7361,22.0760,17.4049,17.4049,15.6840,0.1442,13.4572,16.4937,23.6387,16.4937,388.6341,9.4264,4.8373,3.1448,81.4507,54.9932,30.7089,1.2131,3.8017,4.3319,1.1395,3.1339,3.5709,1.6000
 1312.5000,2249.9343,-0.1127,3.8457,4.4557,4.4200,4.3460,4.2183,3.9144,4.4557,0.2748,2.5694,-0.0234,0.7254,4.0927,14.2811,10.1409,10.1409,8.7063,0.0696,4.8874,8.2246,16.0771,8.2247,224.4323,9.1953,9.1947,6.7059,63.4089,44.0203,24.2905,0.9526,3.0670,3.4596,1.1280,3.2196,3.6317,0.8000
 1313.0000,2309.1304,-0.1022,5.0385,5.7622,5.7066,5.6120,5.4432,5.0364,5.7622,0.2761,2.6201,0.1295,0.4332,4.1743,12.6837,8.6957,8.6957,7.3003,0.0321,1.8131,5.2582,13.3645,5.2582,173.5461,9.0177,10.9907,8.2852,54.1301,37.8121,20.7856,0.8111,2.6386,2.9795,1.1292,3.2530,3.6732,0.0000
 1313.5000,2245.1318,-0.0940,4.7774,5.4078,5.3419,5.2563,5.1040,4.7844,5.4078,0.2770,2.6240,0.3240,-0.0039,4.0610,12.9830,8.9655,8.9655,7.5632,0.0236,1.5787,5.0320,13.1576,5.0320,184.9168,8.9738,9.1449,6.7640,52.6315,35.8625,19.7017,0.7674,2.5080,2.8310,1.1288,3.2683,3.6893,3.2000
 1314.0000,2209.5337,-0.0720,4.3606,4.7995,4.7273,4.6567,4.5335,4.3772,4.7995,0.2764,2.6093,0.2246,-0.1426,3.9527,14.3595,10.2123,10.2123,8.7756,0.0169,2.4646,5.8869,13.9394,5.8869,208.3532,8.9848,7.1831,4.9367,51.9046,35.8616,19.9744,0.7806,2.4730,2.8579,1.1557,3.1682,3.6613,1.6000
 1314.5000,2279.6943,-0.0468,4.2281,4.5039,4.4233,4.3641,4.2574,4.2444,4.5039,0.2768,2.6018,-0.0004,0.1168,3.9534,15.1664,10.9483,10.9483,9.4891,0.0108,2.9237,6.3299,14.3444,6.3299,222.0296,8.9858,6.9163,4.7351,50.6632,35.6236,20.1023,0.7914,2.4231,2.8485,1.1756,3.0616,3.5992,0.0000
 1315.0000,2299.6750,-0.0275,4.2355,4.3970,4.3065,4.2558,4.1567,4.2451,4.3970,0.2770,2.6053,-0.1566,-0.0584,4.0150,15.5778,11.3250,11.3250,9.8537,0.0079,2.7115,6.1251,14.1572,6.1251,227.4255,9.0114,6.9023,4.8399,50.1545,35.6160,20.4561,0.8157,2.3654,2.8495,1.2047,2.8998,3.4933,2.4000
 1315.5000,2221.8804,-0.0174,4.3254,4.4294,4.3268,4.2818,4.1854,4.3316,4.4294,0.2752,2.6059,-0.2629,-0.3544,3.9611,15.8012,11.5300,11.5300,10.0519,0.0058,2.6710,6.0860,14.1215,6.0860,225.7633,9.0396,7.6664,5.3469,50.9084,36.0810,21.0017,0.8442,2.3456,2.8935,1.2336,2.7785,3.4275,0.0000
 1316.0000,2198.8347,-0.0156,4.3509,4.4451,4.3331,4.2924,4.2012,4.3556,4.4451,0.2761,2.5981,-0.0905,-0.1922,3.7648,15.4336,11.1928,11.1928,9.7258,0.0036,3.1477,6.5460,14.5421,6.5460,224.9691,9.0582,6.7365,4.5108,51.9478,37.0496,21.9171,0.8919,2.3529,2.9678,1.2613,2.6380,3.3274,1.6000
 1316.5000,2288.1011,-0.0215,4.4527,4.5852,4.4619,4.4205,4.3303,4.4548,4.5852,0.2767,2.5881,0.1622,0.2851,3.6911,15.7529,11.4857,11.4857,10.0090,0.0031,3.7540,7.1310,15.0770,7.1310,218.0941,9.0293,7.9000,4.7069,54.6253,37.9084,22.6766,0.9273,2.3806,3.0494,1.2810,2.5672,3.2885,1.0000
 1317.0000,2229.2739,-0.0333,4.7437,4.9628,4.8238,4.7768,4.6776,4.7453,4.9628,0.2768,2.5914,0.1447,0.4049,3.8212,14.0008,9.8863,9.8863,8.4591,0.0048,3.5539,6.9379,14.9005,6.9380,201.4985,9.0347,8.2575,4.7744,57.3456,38.3780,23.1424,0.9437,2.4049,3.1246,1.2993,2.5484,3.3110,0.8000
 1317.5000,2250.7981,-0.0492,5.4437,5.8165,5.6521,5.5938,5.4712,5.4475,5.8165,0.2767,2.6114,-0.0455,-0.0776,3.9801,12.1078,8.1784,8.1784,6.7955,0.0069,2.3418,5.7684,13.8310,5.7684,171.9242,9.0136,10.0248,5.5480,55.8242,37.5761,22.6535,0.9150,2.3821,3.1005,1.3015,2.6036,3.3887,2.4000
 1318.0000,2259.3208,-0.0646,6.8470,7.4653,7.2557,7.1760,7.0074,6.8548,7.4653,0.2749,2.6442,-0.1275,-0.2036,4.1811,9.9607,6.2670,6.2670,4.9229,0.0087,0.3498,3.8463,12.0733,3.8463,133.9540,8.9705,13.2311,9.3716,50.5664,36.0603,21.7688,0.8742,2.3022,3.0032,1.3045,2.6335,3.4354,3.0000
 1318.5000,2313.5413,-0.0601,7.3841,8.0039,7.8053,7.7261,7.5618,7.3939,8.0039,0.2759,2.6732,0.0752,-0.1861,4.4098,9.4361,5.8040,5.8040,4.4676,0.0102,-1.4065,2.1516,10.5236,2.1516,124.9397,8.9346,17.1539,15.3621,45.0761,35.0962,21.2946,0.8572,2.2377,2.9278,1.3084,2.6104,3.4154,1.6000
 1319.0000,2259.5974,-0.0291,5.8703,6.1072,5.9745,5.9191,5.8287,5.8759,6.1072,0.2765,2.6641,0.2633,-0.3695,4.3768,11.4562,7.5955,7.5955,6.2256,0.0111,-0.8562,2.6826,11.0092,2.6826,163.7407,8.9551,16.2219,10.7232,45.5026,36.8538,22.5898,0.9225,2.3288,3.0439,1.3071,2.5245,3.2997,0.0000
 1319.5000,2221.7307,-0.0017,3.6250,3.6335,3.5751,3.5513,3.5342,3.6262,3.6335,0.2761,2.6170,0.2589,-0.2987,4.0017,16.0388,11.7483,11.7483,10.2629,0.0088,1.9981,5.4368,13.5277,5.4368,275.2133,8.9871,5.3933,3.9744,54.7600,41.8525,26.1614,1.0759,2.5816,3.4892,1.3516,2.3995,3.2430,0.0000
 1320.0000,2286.5581,-0.0095,2.6006,2.6346,2.6085,2.5975,2.5993,2.6007,2.6346,0.2760,2.5817,0.1583,-0.0752,3.6177,20.4456,15.8568,15.8568,14.2087,0.0049,4.1402,7.5036,15.4178,7.5037,379.5680,9.0455,3.5944,2.5843,64.4875,47.8541,30.6814,1.2602,2.8551,4.0992,1.4358,2.2655,3.2527,0.0000
 1320.5000,2287.9629,0.0127,2.4133,2.3711,2.3574,2.3512,2.3591,2.4133,2.3711,0.2749,2.5820,-0.0689,-0.0516,3.4770,22.5703,17.8772,17.8772,16.1330,0.0036,4.1228,7.4869,15.4025,7.4869,421.7442,9.0738,3.2265,2.2878,67.9635,50.7019,33.3134,1.3574,2.9247,4.5029,1.5396,2.1546,3.3172,1.6000
 1321.0000,2306.5852,0.0201,2.4162,2.3496,2.3451,2.3423,2.3540,2.4162,2.3496,0.2766,2.5913,-0.2035,-0.1217,3.5182,21.7270,17.0722,17.0722,15.3674,0.0018,3.5551,6.9391,14.9016,6.9392,425.6083,9.0916,3.9755,2.4678,66.5048,51.3380,34.6246,1.3964,2.8461,4.7485,1.6684,2.0381,3.4005,2.0000
 1321.5000,2345.2119,0.0201,2.3757,2.3103,2.3136,2.3140,2.3225,2.3757,2.3103,0.2762,2.5891,0.0618,0.1871,3.5512,21.6893,17.0363,17.0363,15.3333,-0.0016,3.6932,7.0723,15.0234,7.0724,432.8495,9.0964,3.7715,2.3780,63.7898,52.1710,36.1141,1.4426,2.7661,5.0188,1.8144,1.9175,3.4791,0.0000
 1322.0000,2356.4060,0.0260,2.3153,2.2329,2.2416,2.2446,2.2629,2.3153,2.2329,0.2770,2.5727,0.4003,0.3657,3.5068,22.6539,17.9572,17.9572,16.2090,-0.0048,4.6860,8.0303,15.8994,8.0303,447.8384,9.1232,3.3917,2.1836,70.3992,58.0458,41.1370,1.6335,2.9548,5.7630,1.9504,1.8089,3.5280,1.6000
 1322.5000,2286.6379,0.0305,2.2253,2.1324,2.1440,2.1489,2.1704,2.2253,2.1324,0.2765,2.5481,0.3000,0.2580,3.4482,26.1917,21.3795,21.3795,19.4450,-0.0086,6.1748,9.4669,17.2131,9.4669,468.9528,9.1900,2.4155,1.8273,86.7878,64.9076,47.0128,1.8613,3.1800,6.6123,2.0793,1.7085,3.5525,0.0000
 1323.0000,2265.2288,0.0338,2.1649,2.0648,2.0776,2.0840,2.1067,2.1649,2.0648,0.2767,2.5304,0.0857,0.2613,3.4024,27.4639,22.6271,22.6271,20.6181,-0.0094,7.2514,10.5058,18.1630,10.5058,484.3165,9.1879,2.6453,1.9619,96.4520,69.3354,50.9090,2.0176,3.3162,7.1507,2.1563,1.6436,3.5442,3.0000
 1323.5000,2280.7998,0.0349,2.1615,2.0584,2.0715,2.0791,2.1013,2.1615,2.0584,0.2760,2.5290,0.0863,-0.2040,3.3513,27.9953,23.1510,23.1510,21.1096,-0.0054,7.3344,10.5858,18.2362,10.5858,485.8204,9.1706,3.3400,2.0420,92.6299,70.7433,52.5971,2.0804,3.3124,7.4071,2.2362,1.5922,3.5604,1.6000
 1324.0000,2331.4495,0.0331,2.1765,2.0780,2.0900,2.0982,2.1174,2.1765,2.0780,0.2758,2.5347,0.1082,-0.9154,3.2798,27.6368,22.7974,22.7974,20.7780,-0.0014,6.9879,10.2514,17.9305,10.2514,481.2351,9.1676,2.9675,1.9034,88.3028,69.6924,52.2385,2.0610,3.2244,7.3814,2.2893,1.5645,3.5815,4.0000
 1324.5000,2333.3838,0.0277,2.1960,2.1127,2.1220,2.1300,2.1434,2.1960,2.1127,0.2757,2.5432,0.2721,-0.5007,3.2685,27.7713,22.9300,22.9300,20.9023,0.0015,6.4708,9.7525,17.4742,9.7525,473.3334,9.1859,2.8469,1.8644,87.4177,67.1856,50.7007,1.9901,3.0990,7.2127,2.3275,1.5572,3.6243,2.0000
 1325.0000,2231.7954,0.0187,2.2522,2.1944,2.1994,2.2061,2.2121,2.2522,2.1944,0.2753,2.5588,0.5404,0.4299,3.3868,26.7322,21.9084,21.9084,19.9428,0.0042,5.5255,8.8404,16.6402,8.8404,455.7011,9.1951,3.6789,2.1638,85.9090,65.5245,49.9603,1.9404,2.9942,7.2053,2.4064,1.5431,3.7133,2.4000
 1325.5000,2281.1787,0.0081,2.2923,2.2669,2.2652,2.2689,2.2661,2.2928,2.2669,0.2749,2.5658,0.5281,0.5355,3.4949,25.1476,20.3622,20.3622,18.4860,0.0047,5.1005,8.4303,16.2651,8.4303,441.1341,9.2254,3.6614,2.1648,83.7124,62.9106,48.4767,1.8604,2.8284,7.0975,2.5094,1.5203,3.8151,3.2000
 1326.0000,2324.9082,-0.0002,2.3321,2.3327,2.3227,2.3216,2.3102,2.3345,2.3327,0.2760,2.5617,0.2621,0.0005,3.4866,24.5283,19.7617,19.7617,17.9187,0.0031,5.3537,8.6746,16.4886,8.6747,428.6793,9.2640,3.2132,1.9781,80.1187,60.6968,47.4045,1.8001,2.6454,7.0311,2.6578,1.4696,3.9058,2.0000
 1326.5000,2279.7280,-0.0142,2.3707,2.4172,2.3976,2.3903,2.3666,2.3786,2.4172,0.2758,2.5635,0.1002,-0.3043,3.4557,24.9651,20.1849,20.1849,18.3186,0.0022,5.2409,8.5658,16.3891,8.5658,413.7082,9.2820,3.2061,2.1106,76.8979,60.7190,47.9746,1.8058,2.5627,7.1918,2.8064,1.4192,3.9827,0.8000
 1327.0000,2227.9604,-0.0266,2.4059,2.4945,2.4650,2.4502,2.4114,2.4089,2.4945,0.2757,2.5687,0.0336,0.0399,3.4471,24.8654,20.0883,20.0883,18.2273,0.0021,4.9274,8.2633,16.1124,8.2633,400.8833,9.2738,3.3018,2.2974,77.6054,59.4647,47.3649,1.7791,2.4423,7.1181,2.9146,1.3728,4.0010,2.4000
 1327.5000,2241.0549,-0.0431,2.4113,2.5560,2.5172,2.4942,2.4349,2.4155,2.5560,0.2750,2.5700,-0.0935,0.2013,3.4715,24.2161,19.4597,19.4597,17.6331,0.0029,4.8489,8.1875,16.0431,8.1875,391.2362,9.2841,3.2292,2.2997,77.0853,58.9988,47.3704,1.7739,2.3666,7.1447,3.0189,1.3342,4.0278,3.2000
 1328.0000,2322.5813,-0.0682,2.3857,2.6131,2.5662,2.5353,2.4492,2.4022,2.6131,0.2753,2.5643,-0.1421,0.0216,3.5124,23.7982,19.0565,19.0565,17.2514,0.0023,5.1918,8.5184,16.3457,8.5184,382.6928,9.2896,3.7108,2.4341,77.1647,60.5037,49.2394,1.8340,2.3299,7.4733,3.2076,1.2704,4.0749,1.0000
 1328.5000,2202.8542,-0.1027,2.3433,2.6814,2.6280,2.5896,2.4724,2.3669,2.6814,0.2762,2.5582,-0.3186,-0.3601,3.4653,24.5208,19.7544,19.7544,17.9118,0.0028,5.5628,8.8763,16.6730,8.8764,372.9423,9.3209,3.3959,2.2457,80.5559,63.0756,51.9990,1.9233,2.3406,7.9559,3.3991,1.2169,4.1365,0.0000
 1329.0000,2269.1909,-0.1495,2.3097,2.7976,2.7391,2.6937,2.5438,2.3370,2.7976,0.2773,2.5564,-0.3760,-0.5372,3.3657,25.7851,20.9825,20.9825,19.0711,0.0087,5.6715,8.9812,16.7690,8.9813,357.4453,9.3525,3.3354,2.0314,85.1748,67.6089,56.6054,2.0731,2.3776,8.7585,3.6837,1.1469,4.2248,4.8000
 1329.5000,2322.7771,-0.1914,2.1126,2.6858,2.6298,2.5834,2.4238,2.1451,2.6858,0.2772,2.5273,0.0199,-0.4475,3.3597,30.1317,25.2725,25.2725,23.0941,0.0282,7.4378,10.6855,18.3274,10.6856,372.3342,9.4315,3.0416,1.8201,90.7286,69.4592,58.8162,2.1389,2.3400,9.1725,3.9199,1.0940,4.2884,4.0000
 1330.0000,2228.7207,-0.2034,1.6927,2.1811,2.1384,2.1010,1.9699,1.7279,2.1811,0.2755,2.3934,0.0421,-0.7737,3.3452,36.6533,31.9023,31.9023,29.2367,0.0695,15.5519,18.5150,25.4870,18.5150,458.4928,9.5711,2.2313,1.3424,91.2068,68.3594,58.2197,2.1178,2.2322,9.0767,4.0663,1.0540,4.2859,0.0000
 1330.5000,2186.0168,-0.1864,1.3308,1.6823,1.6530,1.6259,1.5302,1.3627,1.6823,0.2761,2.1800,-0.3847,-0.6243,3.1320,41.5577,37.0376,37.0376,33.9387,0.1028,28.4855,30.9948,36.8990,30.9948,594.4382,9.7953,0.6948,0.5942,84.6368,66.2732,56.5313,2.0594,2.1194,8.7994,4.1518,1.0292,4.2729,6.4000
 1331.0000,2125.0247,-0.1564,1.3769,1.6814,1.6566,1.6323,1.5461,1.4074,1.6814,0.2771,2.0859,-0.5115,0.3645,2.9397,40.7029,36.1335,36.1335,33.1142,0.0955,34.1890,36.4982,41.9315,36.4982,594.7353,10.3756,0.6856,0.7166,78.6653,65.0699,55.3568,2.0225,2.0872,8.5885,4.1147,1.0320,4.2465,4.0000
 1331.5000,2206.9548,-0.1262,1.5644,1.8428,1.8209,1.7978,1.7163,1.5939,1.8428,0.2765,2.1481,-0.3164,0.4109,2.9714,41.0034,36.4509,36.4509,33.4037,0.0662,30.4164,32.8579,38.6027,32.8579,542.6563,10.6447,1.0507,0.9274,78.8090,65.3649,55.3180,2.0321,2.1226,8.5303,4.0189,1.0445,4.1978,0.0000
 1332.0000,2297.7520,-0.0941,1.7199,1.9470,1.9295,1.9091,1.8391,1.7426,1.9470,0.2765,2.2205,-0.2227,-0.3093,3.0779,37.9150,33.2112,33.2112,30.4396,0.0582,26.0331,28.6284,34.7351,28.6284,513.6036,10.9688,0.9513,1.1145,82.6507,67.5360,56.7264,2.1042,2.2392,8.6509,3.8633,1.0642,4.1113,0.0000
 1332.5000,2317.5833,-0.0604,1.8081,1.9606,1.9483,1.9321,1.8784,1.8134,1.9606,0.2767,2.2608,-0.2728,-0.0586,3.1640,38.1601,33.4666,33.4666,30.6739,0.0714,23.5858,26.2670,32.5757,26.2670,510.0445,11.2241,0.8540,1.1338,84.2201,69.3488,57.4929,2.1530,2.3896,8.6710,3.6287,1.1099,4.0274,2.0000
 1333.0000,2325.9902,-0.0369,1.8624,1.9580,1.9506,1.9388,1.9001,1.8576,1.9580,0.2769,2.3007,-0.1563,0.4826,3.2665,37.5731,32.8558,32.8558,30.1133,0.0770,21.1683,23.9343,30.4426,23.9343,510.7321,11.0982,0.8725,1.1098,83.4171,70.3068,57.2717,2.1735,2.5467,8.5010,3.3381,1.1717,3.9112,1.6000
 1333.5000,2371.9534,-0.0224,1.8600,1.9177,1.9149,1.9075,1.8817,1.8558,1.9177,0.2766,2.3313,0.0768,0.3258,3.3489,36.5893,31.8361,31.8361,29.1759,0.0772,19.3149,22.1460,28.8073,22.1460,521.4464,10.8071,1.2155,0.9988,84.7635,71.4967,57.2293,2.1789,2.7198,8.4613,3.1110,1.2482,3.8832,0.8000
 1334.0000,2365.7002,-0.0127,1.7937,1.8251,1.8260,1.8229,1.8073,1.7959,1.8251,0.2767,2.3226,0.2230,0.2853,3.3145,37.3058,32.5782,32.5782,29.8583,0.0809,19.8443,22.6568,29.2744,22.6568,547.9115,10.8583,1.0992,0.9787,88.4892,73.6616,58.0696,2.2148,2.9111,8.5673,2.9430,1.3144,3.8682,4.8000
 1334.5000,2334.7437,-0.0042,1.7620,1.7722,1.7758,1.7763,1.7681,1.7633,1.7722,0.2759,2.3228,0.1711,0.4098,3.2537,37.4277,32.7048,32.7048,29.9745,0.0851,19.8279,22.6410,29.2599,22.6410,564.2849,11.1648,0.8239,1.0223,90.4387,75.3329,58.6465,2.2309,3.0552,8.6805,2.8412,1.3695,3.8911,4.0000
 1335.0000,2287.1216,0.0003,1.7778,1.7770,1.7826,1.7859,1.7798,1.7781,1.7770,0.2763,2.3910,-0.0679,-0.1594,3.3255,37.6092,32.8933,32.8933,30.1477,0.0911,15.6948,18.6529,25.6131,18.6529,562.7394,11.2061,0.7250,0.8944,90.6787,77.4094,59.6572,2.2597,3.1912,8.8755,2.7812,1.4122,3.9277,1.6000
 1335.5000,2248.5869,0.0045,1.7561,1.7453,1.7517,1.7565,1.7553,1.7561,1.7453,0.2769,2.4553,-0.3275,-0.3608,3.4262,38.7878,34.1217,34.1217,31.2745,0.0989,11.7974,14.8922,22.1741,14.8922,572.9662,11.0236,0.8250,0.8908,95.1655,79.0058,60.4990,2.2906,3.2738,9.0057,2.7508,1.4293,3.9317,1.6000
 1336.0000,2303.8792,0.0093,1.6381,1.6171,1.6221,1.6263,1.6315,1.6383,1.6171,0.2765,2.4429,-0.4781,0.1052,3.4072,40.8508,36.2896,36.2896,33.2567,0.0986,12.5538,15.6221,22.8416,15.6221,618.3860,10.9707,0.8636,0.9012,103.5262,84.4213,64.4028,2.4319,3.5119,9.6173,2.7385,1.4441,3.9546,2.0000
 1336.5000,2272.5300,0.0135,1.4970,1.4692,1.4715,1.4736,1.4834,1.4954,1.4692,0.2774,2.3955,-0.3476,0.1051,3.3603,39.6723,35.0485,35.0485,32.1228,0.1022,15.4257,18.3932,25.3756,18.3933,680.6409,11.0764,0.8938,0.7992,111.7415,93.6032,71.5798,2.6983,3.8597,10.7111,2.7751,1.4304,3.9695,2.4000
 1337.0000,2250.3145,0.0182,1.4298,1.3940,1.3930,1.3918,1.4026,1.4230,1.3940,0.2760,2.3499,-0.1167,-0.2322,3.3262,38.8294,34.1652,34.1652,31.3144,0.1255,18.1888,21.0594,27.8137,21.0594,717.3500,11.0611,0.8652,0.8080,121.5717,100.7516,77.1553,2.9113,4.1389,11.5322,2.7863,1.4217,3.9612,1.6000
 1337.5000,2261.5208,0.0178,1.4017,1.3674,1.3613,1.3553,1.3646,1.3929,1.3674,0.2771,2.3030,-0.1120,-0.0910,3.1713,39.2374,34.5923,34.5923,31.7055,0.1302,21.0284,23.7993,30.3192,23.7993,731.3414,11.1993,0.8899,0.7404,130.7996,105.0977,80.7837,3.0372,4.2905,12.1269,2.8264,1.4127,3.9928,1.0000
 1338.0000,2190.9001,-0.0166,1.4906,1.5248,1.5100,1.4949,1.4898,1.5158,1.5248,0.2773,2.2964,0.0569,0.2292,3.0433,34.3823,29.5677,29.5677,27.0834,0.1060,21.4327,24.1895,30.6759,24.1895,655.8342,11.4806,0.6620,0.6961,133.2531,102.3627,78.7618,2.9610,4.1763,11.8239,2.8312,1.4104,3.9932,1.6000
 1338.5000,2258.9182,-0.0884,1.7140,1.9265,1.8958,1.8637,1.8098,1.7761,1.9265,0.2776,2.3918,0.4067,-0.0287,3.3335,29.6101,24.7522,24.7522,22.6083,0.0880,15.6503,18.6099,25.5738,18.6099,519.0825,10.5837,2.5047,2.7205,119.6365,87.6646,67.2646,2.5239,3.6119,10.1212,2.8022,1.4311,4.0102,0.8000
 1339.0000,2243.8767,-0.1816,2.5587,3.2172,3.1481,3.0750,2.8899,2.6222,3.2172,0.2787,2.5267,0.2411,-0.4771,3.8862,21.9501,17.2848,17.2848,15.5698,0.0837,7.4721,10.7187,18.3577,10.7187,310.8318,9.5403,32.4889,46.7932,90.0872,70.5800,53.8742,2.0127,2.9520,8.1478,2.7601,1.4667,4.0481,1.0000
 1339.5000,2242.8635,-0.2801,2.8683,4.0097,3.9049,3.7924,3.4728,2.9287,4.0097,0.2775,2.5358,-0.1360,-0.9554,4.0413,20.9794,16.3619,16.3619,14.6907,0.1286,6.9225,10.1884,17.8728,10.1884,249.3980,9.3979,28.0969,23.3604,72.8402,61.2434,46.4816,1.7308,2.6184,7.0571,2.6953,1.5128,4.0774,2.0000
 1340.0000,2296.7039,-0.3528,1.9792,2.9675,2.8813,2.7880,2.5224,2.0747,2.9675,0.2774,2.3620,-0.0810,-1.4657,3.6581,30.5891,25.7301,25.7301,23.5208,0.2062,17.4515,20.3480,27.1631,20.3480,336.9868,9.5055,1.5916,1.1713,79.5281,61.4206,46.4630,1.7208,2.6624,7.0986,2.6662,1.5472,4.1253,0.0000
 1340.5000,2313.4377,-0.3683,1.2833,1.9515,1.8930,1.8293,1.6494,1.3675,1.9515,0.2766,2.1378,0.1647,-1.1806,3.2070,40.9048,36.3467,36.3467,33.3087,0.2165,31.0429,33.4624,39.1555,33.4624,512.4341,10.0641,0.5302,0.7123,89.2039,68.3863,51.8181,1.9162,2.9706,7.9301,2.6695,1.5502,4.1384,0.0000
 1341.0000,2251.8113,-0.3570,1.0564,1.5900,1.5430,1.4915,1.3455,1.1324,1.5900,0.2782,2.0430,0.2000,-0.1049,3.0039,44.9165,40.6271,40.6271,37.1989,0.1580,36.7892,39.0072,44.2258,39.0072,628.9113,11.5597,0.6046,0.7080,90.8527,76.1414,57.8762,2.1396,3.2841,8.8606,2.6980,1.5349,4.1413,0.0000
 1341.5000,2211.2500,-0.3399,1.0340,1.5319,1.4883,1.4403,1.3032,1.1102,1.5319,0.2778,2.0856,-0.1844,0.4209,3.0180,44.3329,39.9993,39.9993,36.6301,0.1029,34.2044,36.5130,41.9450,36.5130,652.8005,12.4483,0.7831,0.8072,90.9312,78.3879,59.5288,2.2098,3.3703,9.0701,2.6912,1.5251,4.1044,2.4000
 1342.0000,2279.7629,-0.3098,1.0568,1.5215,1.4801,1.4344,1.3054,1.1345,1.5215,0.2775,2.1269,-0.4330,0.4362,3.1062,42.5328,38.0737,38.0737,34.8819,0.0948,31.7040,34.1004,39.7388,34.1004,657.2479,13.2290,0.5027,0.7207,89.0995,77.7921,59.2034,2.1856,3.3023,9.0784,2.7491,1.5109,4.1538,3.2000
 1342.5000,2285.9238,-0.2575,1.1143,1.5219,1.4817,1.4377,1.3220,1.1950,1.5219,0.2777,2.0713,0.3002,0.7908,3.1631,40.3613,35.7732,35.7732,32.7852,0.1320,35.0730,37.3512,42.7115,37.3512,657.0772,13.3066,0.5252,0.6691,85.2809,73.2797,55.9630,2.0546,3.0683,8.6355,2.8144,1.4934,4.2031,1.0000
 1343.0000,2297.1064,-0.1956,1.2974,1.6572,1.6134,1.5666,1.4607,1.3804,1.6572,0.2781,2.0604,1.1767,1.0524,3.3193,35.8673,31.0912,31.0912,28.4898,0.1672,35.7323,37.9873,43.2932,37.9874,603.4142,13.2984,0.4787,0.5799,79.7975,66.0532,51.2568,1.8623,2.6646,8.0018,3.0030,1.4308,4.2968,1.0000
 1343.5000,2327.2690,-0.1521,1.7673,2.1470,2.0881,2.0279,1.9132,1.8443,2.1470,0.2758,2.2778,0.9597,0.7600,3.7119,30.3104,25.4511,25.4511,23.2608,0.1557,22.5595,25.2767,31.6701,25.2767,465.7573,11.4561,1.4510,0.9511,71.0951,56.5294,44.9902,1.6141,2.1434,7.1207,3.3221,1.3279,4.4116,2.4000
 1344.0000,2328.3857,-0.1198,3.1915,3.7298,3.6223,3.5173,3.3369,3.1931,3.7298,0.2769,2.5350,0.2383,0.2460,4.0482,23.3121,18.5886,18.5886,16.8081,0.0994,6.9680,10.2322,17.9129,10.2322,268.1117,9.6491,3.3852,1.7364,64.4251,51.6112,42.2921,1.5123,1.7950,6.7174,3.7422,1.1869,4.4417,2.0000
 1344.5000,2331.2188,-0.1082,4.0895,4.7119,4.5700,4.4390,4.2221,4.0191,4.7119,0.2771,2.6170,-0.0507,0.2328,4.0217,22.5329,17.8414,17.8414,16.0989,0.0452,2.0005,5.4391,13.5299,5.4391,212.2276,9.5074,2.2897,1.6302,67.2935,55.1739,46.4046,1.6544,1.7692,7.3943,4.1794,1.0694,4.4695,3.0000
 1345.0000,2341.7109,-0.1042,3.3852,3.8810,3.7613,3.6578,3.4935,3.3855,3.8810,0.2764,2.6071,-0.0271,0.3281,3.8120,24.8788,20.1013,20.1013,18.2396,0.0218,2.5989,6.0165,14.0579,6.0165,257.6666,9.5938,0.9937,1.6954,77.5236,62.8972,53.8902,1.9242,1.8893,8.5732,4.5377,0.9819,4.4555,2.4000
 1345.5000,2328.9617,-0.0925,2.9555,3.3388,3.2368,3.1552,3.0257,2.9761,3.3388,0.2765,2.6044,-0.0270,-0.3436,3.7392,25.9917,21.1842,21.1842,19.2611,0.0190,2.7645,6.1762,14.2040,6.1763,299.5057,9.5793,1.6368,2.1452,87.0750,70.6360,60.8284,2.1854,2.1024,9.6130,4.5724,0.9620,4.3987,0.8000
 1346.0000,2298.8462,-0.0823,2.7222,3.0360,2.9471,2.8819,2.7702,2.7422,3.0360,0.2772,2.6017,-0.1462,-0.7584,3.7855,26.7514,21.9273,21.9273,19.9605,0.0192,2.9283,6.3343,14.3485,6.3343,329.3856,9.5493,3.1527,2.6160,95.1803,75.4805,64.5627,2.3181,2.3468,10.2099,4.3506,1.0124,4.4043,1.0000
 1346.5000,2296.3584,-0.0701,2.4737,2.7161,2.6435,2.5954,2.5022,2.4841,2.7161,0.2769,2.5889,-0.2583,-0.1229,3.8237,28.0640,23.2188,23.2188,21.1732,0.0167,3.7036,7.0824,15.0326,7.0824,368.1785,9.5742,3.4785,2.4059,100.9603,78.4992,66.3236,2.3750,2.5906,10.5183,4.0601,1.0908,4.4287,1.0000
 1347.0000,2304.5811,-0.0546,2.2274,2.3968,2.3413,2.3090,2.2364,2.2320,2.3968,0.2774,2.5832,-0.0272,0.7021,3.8096,29.8230,24.9644,24.9644,22.8065,0.0138,4.0497,7.4164,15.3380,7.4164,417.2210,9.6458,2.8783,1.8688,107.2993,81.8140,68.3645,2.4204,2.8305,10.9737,3.8770,1.1694,4.5339,3.2000
 1347.5000,2301.4600,-0.0359,2.0329,2.1343,2.0939,2.0744,2.0223,2.0341,2.1343,0.2783,2.5768,0.3560,0.6306,3.6770,30.3641,25.5048,25.5048,23.3108,0.0109,4.4352,7.7883,15.6781,7.7883,468.5388,9.7342,1.1180,1.1748,114.1469,84.8254,70.6235,2.4717,2.9670,11.4720,3.8666,1.2003,4.6413,3.2000
 1348.0000,2305.5718,-0.0177,1.9357,1.9832,1.9551,1.9452,1.9095,1.9349,1.9832,0.2775,2.5613,0.2590,0.0815,3.5278,32.2989,27.4501,27.4501,25.1213,0.0083,5.3763,8.6964,16.5085,8.6964,504.2376,9.7371,1.4633,1.2859,116.4576,90.0980,75.1985,2.5942,3.1157,12.3937,3.9778,1.2010,4.7774,0.8000
 1348.5000,2286.5918,-0.0017,1.8872,1.8917,1.8748,1.8730,1.8544,1.8835,1.8917,0.2777,2.5471,-0.2969,0.2255,3.4830,32.9659,28.1256,28.1256,25.7481,0.0045,6.2334,9.5234,17.2647,9.5234,528.6196,9.6975,2.2066,1.4854,119.5943,95.1789,79.4495,2.7178,3.2860,13.2039,4.0182,1.2091,4.8583,1.6000
 1349.0000,2240.3296,0.0132,1.8671,1.8332,1.8266,1.8320,1.8216,1.8538,1.8332,0.2777,2.5341,-0.7501,0.2193,3.4207,32.8696,28.0279,28.0279,25.6575,0.0021,7.0225,10.2849,17.9611,10.2849,545.4858,9.6538,2.8843,1.6185,128.8439,99.4128,82.8129,2.8177,3.4648,13.8348,3.9929,1.2297,4.9099,0.8000
 1349.5000,2270.8835,0.0231,1.9441,1.8825,1.8862,1.8999,1.9042,1.9320,1.8825,0.2782,2.5269,-0.6310,-0.0815,3.2966,32.2544,27.4052,27.4052,25.0796,0.0045,7.4630,10.7099,18.3497,10.7099,531.1946,9.6572,3.0204,1.7109,135.8216,102.9431,85.0368,2.8800,3.7117,14.2696,3.8445,1.2888,4.9547,2.4000
 1350.0000,2319.4841,0.0364,2.0976,1.9933,2.0111,2.0364,2.0661,2.1029,1.9933,0.2781,2.5279,-0.1949,-0.0824,3.2005,32.7223,27.8786,27.8786,25.5190,0.0093,7.4011,10.6502,18.2951,10.6502,501.6856,9.7025,2.9181,1.6795,136.0818,103.8130,85.1023,2.8594,3.8664,14.3891,3.7216,1.3522,5.0323,0.0000
 1350.5000,2266.0576,0.0644,2.1558,1.9675,1.9992,2.0346,2.0993,2.1648,1.9675,0.2781,2.5154,-0.0949,-0.2121,3.0491,29.9812,25.1223,25.1223,22.9539,0.0134,8.1598,11.3822,18.9645,11.3822,508.2545,9.7195,2.8994,2.3414,135.1080,105.7267,85.6993,2.8512,4.0955,14.6242,3.5708,1.4364,5.1292,1.6000
 1351.0000,2284.7844,0.1023,1.9904,1.7174,1.7527,1.7882,1.8723,1.9800,1.7174,0.2772,2.4823,-0.0900,-0.3392,2.8044,26.9961,22.1673,22.1673,20.1862,0.0192,10.1642,13.3163,20.7331,13.3163,582.2904,9.6883,3.6987,2.3168,136.0118,103.4765,82.6013,2.7157,4.2136,14.2494,3.3817,1.5516,5.2471,1.6000
 1351.5000,2278.5303,0.1324,1.6831,1.3870,1.4170,1.4454,1.5239,1.6478,1.3870,0.2787,2.4469,0.0542,-0.2711,2.6043,26.4492,21.6312,21.6312,19.6820,0.0273,12.3113,15.3881,22.6276,15.3881,720.9997,9.5934,3.9156,2.5673,131.5856,97.4288,77.0236,2.5112,4.1020,13.3873,3.2636,1.6335,5.3310,3.0000
 1352.0000,2240.5713,0.1528,1.4856,1.1861,1.2126,1.2368,1.3097,1.4395,1.1861,0.2789,2.4149,-0.0496,0.1559,2.4573,24.9453,20.1658,20.1658,18.3005,0.0273,14.2467,17.2556,24.3353,17.2556,843.0692,9.5023,4.5498,2.6407,117.3275,88.3464,69.1468,2.2371,3.8313,12.1005,3.1583,1.7127,5.4091,2.4000
 1352.5000,2209.8677,0.1625,1.3355,1.0501,1.0736,1.0945,1.1607,1.2858,1.0501,0.2830,2.3918,-0.1950,-0.0161,2.2991,24.0251,19.2753,19.2753,17.4586,0.0208,15.6507,18.6103,25.5742,18.6103,952.2947,9.4503,4.2451,2.2196,107.6276,79.6744,61.8158,1.9836,3.5377,10.8950,3.0797,1.7835,5.4926,1.6000
 1353.0000,2091.8569,0.1642,1.2347,0.9683,0.9898,1.0085,1.0691,1.1851,0.9683,0.2822,2.3747,-0.0782,-0.7419,2.1908,24.8193,20.0436,20.0436,18.1851,0.0178,16.6835,19.6068,26.4854,19.6069,1032.7279,9.4880,2.6499,1.3177,103.5226,74.4805,57.2856,1.8155,3.3718,10.2044,3.0264,1.8572,5.6208,0.0000
 1353.5000,2144.5232,0.1663,1.2731,0.9950,1.0182,1.0383,1.1029,1.2235,0.9950,0.2828,2.3618,0.0698,-0.5256,2.2153,25.5093,20.7139,20.7139,18.8178,0.0155,17.4666,20.3625,27.1764,20.3625,1005.0009,9.5089,2.6119,1.5670,97.3282,74.6770,56.7330,1.7747,3.4671,10.2166,2.9467,1.9537,5.7570,1.0000
 1354.0000,2228.0188,0.1651,1.3958,1.0930,1.1204,1.1443,1.2181,1.3475,1.0930,0.2823,2.3741,0.0193,0.0846,2.3269,25.8003,20.9974,20.9974,19.0851,0.0165,16.7204,19.6425,26.5180,19.6425,914.9105,9.6271,4.7246,3.0000,98.2462,78.3377,58.7248,1.8211,3.7342,10.6504,2.8521,2.0505,5.8482,0.8000
 1354.5000,2199.8953,0.1545,1.4902,1.1867,1.2170,1.2437,1.3219,1.4456,1.1867,0.2812,2.4144,-0.2573,0.1344,2.4110,25.8804,21.0755,21.0755,19.1587,0.0203,14.2801,17.2878,24.3648,17.2878,842.6993,9.6358,4.4177,2.8684,106.4687,83.2918,61.7573,1.9077,4.0530,11.2359,2.7722,2.1246,5.8899,3.2000
 1355.0000,2247.2507,0.1401,1.6049,1.3070,1.3403,1.3704,1.4512,1.5680,1.3070,0.2828,2.4432,-0.4216,-0.1260,2.4641,27.8282,22.9861,22.9861,20.9549,0.0180,12.5359,15.6048,22.8258,15.6048,765.0839,9.6400,4.3128,2.3867,115.1425,89.7682,65.7778,2.0301,4.4790,11.9756,2.6737,2.2062,5.8989,2.0000
 1355.5000,2250.8677,0.1231,1.7172,1.4355,1.4704,1.5036,1.5822,1.6904,1.4355,0.2845,2.4521,-0.2426,-0.1118,2.5674,27.6486,22.8090,22.8090,20.7888,0.0137,11.9959,15.0838,22.3493,15.0838,696.6074,9.6974,3.4069,2.0144,120.5331,93.4491,68.3235,2.0964,4.6861,12.4973,2.6669,2.2353,5.9613,1.6000
 1356.0000,2287.0991,0.1049,1.7987,1.5458,1.5795,1.6142,1.6838,1.7828,1.5458,0.2822,2.4675,-0.0065,0.0951,2.6451,28.5643,23.7136,23.7136,21.6368,0.0135,11.0613,14.1819,21.5246,14.1819,646.9350,9.7947,4.4680,2.5373,123.0108,95.8373,70.4176,2.1587,4.7425,12.8896,2.7179,2.1969,5.9709,2.4000
 1356.5000,2269.2483,0.0884,1.8255,1.6081,1.6374,1.6710,1.7256,1.8159,1.6081,0.2827,2.4737,0.0004,0.2892,2.5926,28.8040,23.9511,23.9511,21.8592,0.0121,10.6852,13.8190,21.1928,13.8190,621.8436,9.9411,5.1103,2.8624,124.5373,95.8951,70.9946,2.1736,4.6489,13.0086,2.7982,2.1388,5.9848,1.0000
 1357.0000,2300.9417,0.0757,1.8019,1.6175,1.6401,1.6703,1.7084,1.7890,1.6175,0.2821,2.4661,0.0109,0.4245,2.5390,28.4743,23.6244,23.6244,21.5533,0.0074,11.1438,14.2615,21.5974,14.2615,618.2436,10.0067,4.7708,2.5359,120.6723,95.8130,71.4682,2.1985,4.5332,13.0459,2.8779,2.0619,5.9339,1.6000
 1357.5000,2358.0986,0.0646,1.7836,1.6274,1.6437,1.6705,1.6958,1.7663,1.6274,0.2826,2.4614,0.3359,0.1864,2.5870,28.8536,24.0003,24.0003,21.9052,0.0048,11.4308,14.5384,21.8507,14.5385,614.4691,10.0559,4.5085,2.3539,116.9903,94.9966,71.1651,2.2066,4.4307,12.9082,2.9133,2.0080,5.8499,0.0000
 1358.0000,2381.5930,0.0511,1.8094,1.6835,1.6944,1.7192,1.7353,1.7970,1.6835,0.2822,2.4594,0.5398,-0.0812,2.6634,28.3479,23.4994,23.4994,21.4362,0.0049,11.5537,14.6571,21.9591,14.6571,593.9954,10.1114,4.4816,2.3911,117.3864,95.8773,71.6160,2.2403,4.4928,12.8962,2.8704,2.0054,5.7564,2.0000
 1358.5000,2392.4189,0.0369,1.8570,1.7632,1.7685,1.7912,1.8006,1.8525,1.7632,0.2837,2.4661,0.4080,-0.2566,2.7034,28.4734,23.6235,23.6235,21.5525,0.0053,11.1427,14.2605,21.5965,14.2605,567.1420,10.0358,4.1992,2.3498,115.6520,95.7970,71.3943,2.2530,4.5182,12.7633,2.8249,2.0054,5.6651,1.0000
 1359.0000,2407.8506,0.0239,1.8697,1.8084,1.8071,1.8258,1.8307,1.8671,1.8084,0.2823,2.4785,0.2731,-0.3251,2.6964,28.5581,23.7074,23.7074,21.6311,0.0071,10.3929,13.5370,20.9349,13.5370,552.9812,10.0525,4.2549,2.4271,112.5936,95.1192,70.7280,2.2474,4.4859,12.5707,2.8023,1.9960,5.5933,2.4000
 1359.5000,2377.4014,0.0115,1.8650,1.8355,1.8273,1.8403,1.8432,1.8632,1.8355,0.2823,2.4810,0.0558,0.1247,2.6672,28.3591,23.5105,23.5105,21.4466,0.0096,10.2413,13.3907,20.8011,13.3907,544.8083,10.0815,4.4340,2.4077,112.4553,96.2967,71.6411,2.2883,4.5058,12.6769,2.8134,1.9691,5.5399,6.4000
 1360.0000,2316.3855,0.0049,1.8880,1.8752,1.8588,1.8644,1.8675,1.8875,1.8752,0.2833,2.4747,-0.2752,0.3472,2.6194,28.6450,23.7935,23.7935,21.7116,0.0105,10.6216,13.7577,21.1367,13.7577,533.2756,10.0875,4.4997,2.4066,113.7257,95.3217,70.8834,2.2741,4.4193,12.4950,2.8274,1.9433,5.4944,3.0000
 1360.5000,2299.6055,-0.0001,1.9254,1.9244,1.8975,1.8932,1.8976,1.9266,1.9256,0.2813,2.4735,-0.1934,0.0976,2.5784,29.0328,24.1781,24.1781,22.0716,0.0107,10.6958,13.8293,21.2022,13.8293,519.6553,10.1048,3.9993,2.2091,115.5360,95.1776,70.6300,2.2777,4.3993,12.3951,2.8175,1.9315,5.4420,2.4000
 1361.0000,2354.8516,-0.0139,1.9487,1.9848,1.9446,1.9268,1.9306,1.9517,1.9862,0.2840,2.4723,0.4202,0.0619,2.6044,29.1356,24.2803,24.2803,22.1671,0.0097,10.7697,13.9006,21.2674,13.9006,503.8382,10.1382,3.9090,2.3203,117.5622,94.0086,69.9802,2.2637,4.2918,12.2481,2.8538,1.8960,5.4107,6.4000
 1361.5000,2337.2776,-0.0351,1.9973,2.0928,2.0342,1.9977,1.9939,2.0125,2.0945,0.2823,2.4714,0.5071,0.1963,2.6578,27.7983,22.9565,22.9565,20.9272,0.0047,10.8236,13.9525,21.3149,13.9526,477.8264,10.1640,3.8822,2.2914,116.7556,93.5926,69.8164,2.2566,4.2421,12.2278,2.8825,1.8799,5.4187,4.8000
 1362.0000,2288.6646,-0.0722,2.0811,2.2891,2.2043,2.1404,2.1116,2.1656,2.2912,0.2832,2.4809,-0.1697,0.1287,2.7056,28.0640,23.2187,23.2187,21.1732,-0.0011,10.2503,13.3994,20.8091,13.3994,436.8549,10.1960,3.7349,2.4534,115.3281,93.0377,69.9569,2.2507,4.1522,12.3018,2.9627,1.8448,5.4657,4.0000
 1362.5000,2289.6331,-0.1683,2.0694,2.5598,2.4408,2.3406,2.2542,2.2612,2.5625,0.2840,2.4860,-0.3472,0.0869,2.7178,28.6380,23.7866,23.7866,21.7052,-0.0045,9.9371,13.0972,20.5327,13.0972,390.6606,10.2103,4.0134,2.5098,113.5794,92.8474,70.2857,2.2524,4.0804,12.4020,3.0394,1.8116,5.5063,4.0000
 1363.0000,2381.1667,-0.3014,2.0968,2.9903,2.8229,2.6705,2.4724,2.3816,2.9940,0.2829,2.4852,0.0629,0.1457,2.6398,27.8465,23.0041,23.0041,20.9719,-0.0045,9.9878,13.1461,20.5775,13.1461,334.4193,10.2163,4.3195,2.7820,111.6121,89.7921,68.2475,2.1958,3.9261,12.0006,3.0566,1.7880,5.4652,2.4000
 1363.5000,2367.7505,-0.4807,2.2612,3.7681,3.5255,3.2904,2.8889,2.5822,3.7740,0.2844,2.4932,0.1977,-0.0336,2.6128,26.2401,21.4268,21.4268,19.4896,-0.0011,9.5053,12.6805,20.1517,12.6805,265.3876,10.1933,3.9839,2.8229,112.2581,87.2984,66.8126,2.1627,3.7659,11.6868,3.1033,1.7414,5.4039,1.6000
 1364.0000,2308.9109,-0.8354,2.6717,5.4552,5.0717,4.6791,3.9177,3.0836,5.4672,0.2833,2.5243,0.1633,-0.5744,2.8758,25.1183,20.3337,20.3337,18.4591,0.0060,7.6158,10.8573,18.4845,10.8573,183.3128,10.2112,4.3541,3.0939,110.6932,83.0724,63.9420,2.0882,3.5312,11.0969,3.1425,1.6910,5.3141,0.0000
 1364.5000,2260.0237,-1.6513,2.8148,6.7721,6.2815,5.7508,4.7109,3.3432,6.7898,0.2815,2.5628,0.0384,-1.6078,3.3919,25.7326,20.9314,20.9314,19.0229,0.0161,5.2841,8.6074,16.4271,8.6074,147.6658,10.1542,5.4295,4.0152,101.8855,76.0418,58.6486,1.9328,3.2122,10.0955,3.1429,1.6619,5.2233,8.0000
 1365.0000,2255.4507,-1.7624,1.7152,4.3122,4.0180,3.6755,3.0108,2.1130,4.3189,0.2827,2.4033,-0.3835,-2.8489,3.4674,31.5410,26.6858,26.6858,24.4108,0.0055,14.9495,17.9337,24.9554,17.9337,231.8981,10.1245,6.9896,4.5841,88.8309,66.9925,51.7420,1.7137,2.8126,8.8662,3.1523,1.6412,5.1737,3.2000
 1365.5000,2174.2358,-1.7624,0.7620,1.8508,1.7386,1.5978,1.3177,0.9537,1.8515,0.2828,1.8867,-0.7274,-2.7311,2.5212,42.8460,38.4075,38.4075,35.1853,-0.0172,46.2593,48.1450,52.5818,48.1450,540.3057,10.1804,2.7420,1.2249,74.6398,57.5232,44.5340,1.4863,2.3900,7.5772,3.1703,1.6080,5.0979,3.2000
 1366.0000,2080.8701,-1.1117,0.5086,1.1366,1.0796,0.9999,0.8346,0.6384,1.1366,0.2831,1.3770,-0.9259,-0.6512,1.3424,59.8413,56.7196,56.7196,53.1083,-0.0006,77.1504,77.9521,79.8386,77.9521,879.7875,11.0947,0.2179,0.3050,66.0194,53.3864,41.5250,1.3926,2.1856,7.0334,3.2181,1.5694,5.0504,4.0000
 1366.5000,2176.3896,-0.8442,0.5273,1.0830,1.0414,0.9739,0.8278,0.6620,1.0830,0.2841,1.2478,-0.8914,1.2619,0.8905,58.5363,55.3128,55.3128,51.6513,0.0382,84.9806,85.5076,86.7476,85.5076,923.3566,13.4432,0.2097,0.3472,63.8603,57.4685,45.1693,1.5221,2.2852,7.6164,3.3329,1.5014,5.0040,2.4000
 1367.0000,2291.3481,-0.6729,0.7105,1.3448,1.3081,1.2350,1.0744,0.8844,1.3448,0.2824,1.3928,-0.2405,2.1426,1.0785,53.6971,50.0957,50.0957,46.3266,0.0621,76.1952,77.0304,78.9958,77.0304,743.6250,19.0879,0.1786,0.4477,65.6548,67.5921,53.7891,1.8155,2.6207,9.0559,3.4555,1.4435,4.9882,2.4000
 1367.5000,2352.5945,-0.4713,1.2072,2.0005,1.9634,1.8695,1.6701,1.4184,2.0005,0.2828,1.6927,0.5330,2.3234,1.6089,45.4583,41.2114,41.2114,37.7287,0.0878,58.0169,59.4900,62.9561,59.4900,499.8817,19.4328,0.3630,0.6351,71.1605,73.4134,59.0867,2.0012,2.7603,9.9148,3.5919,1.3793,4.9544,2.0000
 1368.0000,2327.8101,-0.2626,1.8064,2.4804,2.4506,2.3510,2.1647,1.9231,2.4804,0.2824,2.0497,0.8722,1.5495,2.2637,36.3692,31.6087,31.6087,28.9665,0.1080,36.3819,38.6141,43.8663,38.6141,403.1680,17.5450,0.4599,0.7254,75.9700,73.2772,59.5795,2.0244,2.6743,9.9668,3.7269,1.3210,4.9234,5.6000
 1368.5000,2306.8955,-0.1604,1.9971,2.4501,2.4314,2.3476,2.2271,2.0752,2.4501,0.2845,2.3235,0.8928,0.4461,2.8700,33.3658,28.5316,28.5316,26.1245,0.1021,19.7881,22.6026,29.2248,22.6026,408.1497,16.3887,0.9819,1.0463,74.3810,65.5168,53.6017,1.8311,2.3342,8.9201,3.8215,1.2747,4.8715,0.8000
 1369.0000,2322.2012,-0.0945,2.2096,2.5026,2.4888,2.4160,2.3452,2.2750,2.5026,0.2848,2.5205,0.7400,-0.1015,3.3833,29.4088,24.5519,24.5519,22.4211,0.0896,7.8470,11.0804,18.6885,11.0804,399.5862,10.4490,2.6743,3.0726,64.8355,51.6603,42.5815,1.4641,1.7886,7.0410,3.9365,1.2216,4.8090,2.0000
 1369.5000,2323.0425,-0.0506,2.3148,2.4779,2.4648,2.4033,2.3634,2.3819,2.4779,0.2903,2.6153,0.5359,-0.0409,3.6657,26.3876,21.5710,21.5710,19.6253,0.0719,2.1044,5.5393,13.6215,5.5393,403.5682,10.1517,2.3702,2.3218,55.0589,45.8768,37.9474,1.3128,1.5769,6.2367,3.9549,1.2012,4.7505,0.8000
 1370.0000,2318.3784,-0.0250,2.3223,2.4026,2.3873,2.3375,2.3084,2.3827,2.4026,0.2984,2.6118,0.1457,-0.0365,3.7235,25.7766,20.9742,20.9742,19.0633,0.0449,2.3181,5.7455,13.8101,5.7455,416.2075,10.0920,2.2047,2.0820,54.0998,45.9979,38.1830,1.3338,1.5659,6.2144,3.9687,1.1739,4.6591,2.4000
 1370.5000,2297.1064,-0.0132,2.7196,2.7693,2.7440,2.6926,2.6392,2.7413,2.7693,0.3037,2.6190,-0.2509,-0.2352,3.7591,24.3886,19.6265,19.6265,17.7908,0.0264,1.8808,5.3236,13.4242,5.3236,361.1017,10.0644,2.2327,2.8813,60.2612,50.5461,41.8404,1.4861,1.7354,6.6936,3.8571,1.1678,4.5043,0.0000
 1371.0000,2325.9216,-0.0243,3.4148,3.5300,3.4849,3.4250,3.3082,3.4150,3.5300,0.3062,2.6453,-0.0196,-0.4260,3.8416,23.1207,18.4047,18.4047,16.6337,0.0187,0.2845,3.7833,12.0158,3.7833,283.2857,10.0139,3.6721,3.4463,66.5583,56.0181,46.4199,1.6685,1.9013,7.3321,3.8564,1.1395,4.3943,3.2000
 1371.5000,2350.3135,-0.0409,3.8180,4.0353,3.9700,3.9082,3.7403,3.8180,4.0353,0.3114,2.6434,0.2871,-0.2295,3.8409,21.4021,16.7631,16.7631,15.0731,0.0173,0.3988,3.8936,12.1166,3.8936,247.8106,10.0251,4.2003,3.3681,73.0927,59.3159,49.3124,1.7967,1.9768,7.6743,3.8821,1.1003,4.2714,5.6000
 1372.0000,2359.7227,-0.0476,3.8985,4.1569,4.0768,4.0183,3.8329,3.8996,4.1569,0.3125,2.6080,-0.0277,0.6563,3.6015,20.6468,16.0470,16.0470,14.3903,0.0157,2.5442,5.9637,14.0096,5.9637,240.5658,10.0463,5.0783,3.2559,78.4806,60.9651,50.6349,1.8642,2.0140,7.7884,3.8671,1.0804,4.1779,4.0000
 1372.5000,2358.3179,-0.0444,3.7467,3.9785,3.8917,3.8393,3.6672,3.7477,3.9785,0.3139,2.5631,-0.3458,1.0080,3.2439,20.4524,15.8632,15.8632,14.2148,0.0104,5.2649,8.5890,16.4102,8.5890,251.3537,10.0498,4.3540,3.3535,78.5922,61.2807,50.8304,1.8906,2.0189,7.7275,3.8275,1.0679,4.0874,4.8000
 1373.0000,2343.6802,-0.0342,3.5097,3.6762,3.5896,3.5436,3.4030,3.5103,3.6762,0.3170,2.5425,-0.2204,0.1913,3.0057,20.3454,15.7621,15.7621,14.1182,0.0093,6.5176,9.7977,17.5155,9.7977,272.0164,9.9480,3.5677,3.2012,79.7395,62.0878,51.4447,1.9273,2.0256,7.7552,3.8286,1.0510,4.0239,2.4000
 1373.5000,2409.6018,-0.0190,3.3078,3.3950,3.3119,3.2712,3.1697,3.3079,3.3950,0.3173,2.5423,0.0570,-0.4223,2.9233,20.9856,16.3678,16.3678,14.6964,0.0135,6.5291,9.8088,17.5257,9.8088,294.5512,9.8872,3.4710,2.7408,81.1483,63.8842,52.5585,1.9764,2.1096,7.8878,3.7389,1.0674,3.9909,5.0000
 1374.0000,2318.8733,-0.0033,3.2246,3.2394,3.1607,3.1231,3.0571,3.2248,3.2394,0.3173,2.5450,0.2728,-0.1510,2.9306,21.0825,16.4597,16.4597,14.7840,0.0160,6.3642,9.6497,17.3802,9.6497,308.6979,9.8222,5.9568,3.0700,80.7941,65.0986,53.0210,1.9871,2.2141,7.9892,3.6084,1.1142,4.0206,4.0000
 1374.5000,2301.5410,-0.0044,3.1730,3.1924,3.1167,3.0791,3.0449,3.1731,3.1924,0.3193,2.5490,0.1381,-0.1402,2.9658,20.2624,15.6837,15.6837,14.0434,0.0152,6.1183,9.4124,17.1632,9.4124,313.2462,9.7712,6.5143,2.8038,84.9579,65.9054,53.0937,1.9727,2.3170,8.0815,3.4879,1.1746,4.0967,0.8000
 1375.0000,2217.4919,-0.0260,3.2870,3.4053,3.3259,3.2832,3.2854,3.2870,3.4053,0.3199,2.5560,-0.4539,-0.1629,2.9977,19.5977,15.0577,15.0577,13.4447,0.0093,5.6979,9.0067,16.7923,9.0067,293.6556,9.6898,4.9215,2.7864,86.9395,64.1458,50.9072,1.8490,2.3838,7.9498,3.3349,1.2892,4.2995,4.8000
 1375.5000,2320.3938,-0.0222,4.0029,4.1261,4.0216,3.9615,3.9848,4.0029,4.1261,0.3193,2.5714,-0.3060,0.0460,3.0702,17.8121,13.3881,13.3881,11.8433,0.0057,4.7624,8.1041,15.9668,8.1041,242.3574,9.6391,6.1505,3.8132,81.0278,61.0935,47.7506,1.7228,2.3763,7.5116,3.1611,1.3793,4.3600,2.0000
 1376.0000,2352.6743,-0.0176,4.6326,4.7452,4.6218,4.5449,4.5862,4.6326,4.7452,0.3200,2.5839,-0.2259,0.0264,3.1169,17.4530,13.0546,13.0546,11.5224,0.0033,4.0038,7.3721,15.2975,7.3721,210.7377,9.6110,7.7467,4.8132,76.7230,59.8786,46.1415,1.6620,2.4123,7.2718,3.0144,1.4515,4.3754,4.0000
 1376.5000,2319.2297,-0.0078,4.3811,4.4285,4.3288,4.2609,4.3007,4.3811,4.4285,0.3226,2.5770,-0.1699,0.1342,3.0785,17.1268,12.7523,12.7523,11.2313,-0.0032,4.4255,7.7790,15.6696,7.7790,225.8114,9.6432,7.6031,4.4878,78.3504,61.5408,46.7557,1.6879,2.5534,7.3506,2.8788,1.5128,4.3549,5.6000
 1377.0000,2276.1121,0.0036,3.5778,3.5603,3.4984,3.4523,3.4807,3.5778,3.5603,0.3207,2.5601,0.2260,0.0142,2.9815,17.9543,13.5204,13.5204,11.9704,-0.0049,5.4481,8.7657,16.5718,8.7657,280.8786,9.6938,6.9917,3.9912,85.7226,67.0824,50.0876,1.8213,2.8803,7.8122,2.7123,1.5814,4.2894,1.6000
 1377.5000,2343.3350,0.0078,3.0740,3.0408,2.9978,2.9630,2.9846,3.0740,3.0408,0.3208,2.5401,0.4138,-0.1853,2.8726,19.9957,15.4322,15.4322,13.8030,0.0023,6.6613,9.9364,17.6423,9.9364,328.8581,9.7694,4.8335,3.4539,92.6763,73.9163,54.1721,1.9699,3.2987,8.4488,2.5612,1.6746,4.2889,3.0000
 1378.0000,2354.1487,0.0042,2.9772,2.9598,2.9225,2.8901,2.9077,2.9766,2.9598,0.3234,2.5299,0.2531,-0.0547,2.8136,20.3821,15.7968,15.7968,14.1514,0.0083,7.2803,10.5336,18.1885,10.5336,337.8651,9.8191,4.8429,3.2512,99.0572,79.2421,57.0306,2.0778,3.6760,8.8760,2.4146,1.7692,4.2719,2.4000
 1378.5000,2329.6646,-0.0060,3.0587,3.0842,3.0484,3.0158,3.0274,3.0567,3.0842,0.3213,2.5445,0.1016,0.0528,2.8548,20.3787,15.7936,15.7936,14.1483,0.0123,6.3952,9.6795,17.4075,9.6795,324.2303,9.8496,4.0057,2.5704,107.1458,83.7985,59.2321,2.1552,4.0406,9.2318,2.2848,1.8748,4.2835,1.6000
 1379.0000,2353.0320,-0.0127,3.1915,3.2476,3.2125,3.1802,3.1854,3.1899,3.2476,0.3232,2.5652,-0.1175,0.0243,2.9587,20.7042,16.1013,16.1013,14.4421,0.0153,5.1420,8.4703,16.3018,8.4704,307.9165,9.8791,4.4300,2.9886,112.2483,87.1342,60.7182,2.2032,4.3231,9.4921,2.1957,1.9622,4.3083,3.0000
 1379.5000,2350.1875,-0.0023,3.1863,3.1962,3.1642,3.1361,3.1451,3.1852,3.1962,0.3213,2.5661,-0.5088,-0.1638,3.0176,22.1421,17.4679,17.4679,15.7440,0.0254,5.0845,8.4148,16.2510,8.4148,312.8698,9.9269,4.9969,2.6672,114.1879,90.3537,62.4078,2.2641,4.5518,9.7586,2.1439,2.0105,4.3102,6.4000
 1380.0000,2324.3438,0.0280,3.2777,3.1518,3.1187,3.0931,3.1254,3.2755,3.1518,0.3212,2.5547,-0.5479,-0.2169,3.0456,24.6541,19.8835,19.8835,18.0338,0.0541,5.7764,9.0825,16.8615,9.0825,317.2773,10.0084,2.7816,1.6563,118.8755,93.4868,63.9075,2.3083,4.7924,10.0413,2.0953,2.0761,4.3501,2.4000
 1380.5000,2348.4253,0.0519,2.9987,2.7867,2.7557,2.7359,2.7904,2.9957,2.7867,0.3223,2.5452,-0.0145,0.1387,3.0942,27.5612,22.7229,22.7229,20.7080,0.0808,6.3541,9.6399,17.3713,9.6399,358.8495,10.4105,0.8384,0.7101,123.2615,94.9757,65.1003,2.3280,4.8291,10.3398,2.1411,2.0744,4.4416,1.0000
 1381.0000,2373.7620,0.0604,2.5820,2.3702,2.3419,2.3262,2.3819,2.5779,2.3702,0.3214,2.5254,0.4112,0.5161,3.1360,27.1227,22.2916,22.2916,20.3030,0.0833,7.5506,10.7944,18.4270,10.7944,421.9137,11.8327,0.4462,0.8188,119.7025,93.7770,64.7460,2.2905,4.6844,10.4011,2.2204,2.0451,4.5409,4.8000
 1381.5000,2410.1316,0.0561,2.6112,2.4120,2.3748,2.3537,2.4152,2.6069,2.4120,0.3215,2.5473,0.3486,0.1799,3.2768,24.4250,19.6617,19.6617,17.8242,0.0750,6.2232,9.5136,17.2557,9.5136,414.5868,11.7872,0.6190,0.7955,101.4893,78.0914,54.2940,1.9038,3.8386,8.8024,2.2932,2.0162,4.6236,5.6000
 1382.0000,2359.3313,0.0162,4.1799,4.0870,3.9497,3.8664,4.0007,4.1895,4.0870,0.3216,2.6447,0.0393,-0.3983,3.6561,17.3049,12.9173,12.9173,11.3903,0.0602,0.3207,3.8182,12.0477,3.8182,244.6784,9.5223,9.6453,7.3676,67.5335,53.2379,37.3643,1.3043,2.5771,6.0856,2.3614,1.9758,4.6657,4.0000
 1382.5000,2354.5063,-0.0414,9.0333,9.5529,8.9997,8.6558,8.9788,9.2692,9.5529,0.3226,2.7129,-0.0025,-0.2170,4.1558,10.8268,7.0347,7.0347,5.6765,0.0381,-3.8138,-0.1713,8.3995,-0.1712,104.6807,9.4488,17.6834,13.3934,37.3676,33.6168,23.5527,0.8264,1.6438,3.8160,2.3214,1.9892,4.6176,4.8000
 1383.0000,2357.5352,-0.0972,13.9141,15.8127,14.4706,13.6253,13.7191,13.7900,15.8127,0.3232,2.7061,0.0888,0.1698,4.5241,8.3183,4.8233,4.8233,3.5006,0.0246,-3.4005,0.2276,8.7642,0.2276,63.2403,9.2558,26.3425,28.5702,22.8972,21.6741,15.1913,0.5374,1.0660,2.4407,2.2896,1.9838,4.5422,0.8000
 1383.5000,2360.2410,-0.0614,10.6135,11.5231,10.7646,10.2313,9.8467,10.5085,11.5231,0.3225,2.6831,-0.0762,0.1941,4.5799,8.4415,4.9310,4.9310,3.6069,0.0203,-2.0082,1.5710,9.9927,1.5710,86.7819,9.2942,29.9324,28.0786,21.1654,18.1283,12.7377,0.4524,0.8984,2.0376,2.2680,1.9857,4.5035,2.4000
 1384.0000,2380.7866,-0.0967,6.9032,7.8406,7.5257,7.2797,6.8167,7.1314,7.8406,0.3219,2.6706,-0.0885,-0.0766,4.3864,10.6245,6.8550,6.8550,5.5002,0.0166,-1.2473,2.3052,10.6641,2.3052,127.5406,9.3159,15.2393,10.8606,23.8643,19.3726,13.6794,0.4886,0.9587,2.1752,2.2689,1.9620,4.4515,4.0000
 1384.5000,2348.7131,-0.2437,4.8034,6.4663,6.2226,6.0233,5.5472,5.0215,6.4663,0.3214,2.6698,-0.1081,-0.2697,4.1781,14.3895,10.2395,10.2395,8.8020,0.0099,-1.2006,2.3503,10.7054,2.3503,154.6476,9.4006,11.3362,7.9871,26.1965,24.2243,17.2306,0.6199,1.1935,2.7188,2.2781,1.9252,4.3857,3.2000
 1385.0000,2382.0654,-0.3367,3.3276,4.9155,4.7485,4.6006,4.1875,3.4665,4.9155,0.3237,2.6600,-0.4862,-0.8492,4.0210,18.6379,14.1579,14.1579,12.5826,0.0163,-0.6084,2.9217,11.2279,2.9218,203.4395,9.5518,10.1291,7.1237,34.0005,33.4765,23.9280,0.8716,1.6414,3.7249,2.2694,1.8832,4.2738,1.6000
 1385.5000,2296.8533,-0.3177,2.0800,3.0176,2.9328,2.8504,2.6070,2.1503,3.0176,0.3222,2.5245,-0.7948,-1.3764,3.7993,25.2252,20.4376,20.4376,18.5571,0.0636,7.6072,10.8490,18.4769,10.8490,331.3881,9.5626,9.6425,5.4861,53.9615,48.8269,35.0586,1.2873,2.3954,5.4090,2.2581,1.8608,4.2019,4.0000
 1386.0000,2295.3677,-0.2471,1.4671,1.9820,1.9402,1.8940,1.7554,1.5075,1.9820,0.3231,2.2784,-0.9202,-0.2687,3.4917,32.1845,27.3346,27.3346,25.0140,0.1382,22.5206,25.2392,31.6358,25.2392,504.5381,9.6166,3.0285,1.4050,84.7055,66.5003,48.0243,1.7597,3.2492,7.4267,2.2857,1.8465,4.2205,0.0000
 1386.5000,2275.7319,-0.1684,1.2776,1.5821,1.5597,1.5291,1.4432,1.3068,1.5821,0.3235,2.1685,-0.6229,0.9326,3.2406,38.0195,33.3201,33.3201,30.5395,0.1752,29.1799,31.6648,37.5116,31.6648,632.0912,10.6514,0.4109,0.6171,107.4046,83.3757,60.4760,2.2019,4.0745,9.4191,2.3117,1.8505,4.2778,0.8000
 1387.0000,2338.9702,-0.1097,1.3764,1.5888,1.5760,1.5507,1.4921,1.4050,1.5888,0.3229,2.2246,0.0728,0.6068,3.1017,39.6602,35.0357,35.0357,32.1112,0.1423,25.7833,28.3874,34.5147,28.3874,629.4250,11.4369,0.5668,0.7021,114.4948,92.9990,68.3296,2.4578,4.4596,10.7845,2.4183,1.8144,4.3878,6.0000
 1387.5000,2320.0137,-0.0707,1.6796,1.8456,1.8391,1.8146,1.7755,1.7183,1.8456,0.3211,2.2902,0.3619,0.0531,3.0769,37.5944,32.8778,32.8778,30.1335,0.0961,21.8049,24.5486,31.0043,24.5486,541.8276,11.3336,0.6319,0.7600,117.2936,93.2093,69.0741,2.4688,4.4265,10.9768,2.4798,1.7929,4.4461,8.0000
 1388.0000,2340.4670,-0.0351,1.9721,2.0683,2.0671,2.0437,2.0237,1.9995,2.0683,0.3226,2.3610,0.3536,0.4921,3.1711,35.1258,30.3289,30.3289,27.7867,0.0856,17.5137,20.4079,27.2179,20.4079,483.4977,10.8623,0.7725,0.7759,116.3836,89.8330,67.3076,2.3964,4.1770,10.7404,2.5713,1.7430,4.4820,5.6000
 1388.5000,2436.3318,-0.0100,2.1061,2.1352,2.1375,2.1164,2.1088,2.1097,2.1352,0.3222,2.4455,0.3320,0.7734,3.2806,33.3215,28.4866,28.4866,26.0827,0.0773,12.3963,15.4701,22.7026,15.4701,468.3341,10.4405,1.7433,0.9202,110.6272,86.5642,65.3145,2.3177,3.9771,10.4589,2.6297,1.7160,4.5126,3.2000
 1389.0000,2533.0369,-0.0023,2.1795,2.1865,2.1901,2.1708,2.1674,2.1777,2.1865,0.3226,2.5019,0.2787,0.1282,3.3203,31.6518,26.7973,26.7973,24.5145,0.0493,8.9738,12.1677,19.6827,12.1677,457.3609,10.4091,1.6527,1.3055,107.6026,86.2204,65.5099,2.3237,3.9162,10.4947,2.6798,1.6853,4.5164,2.0000
 1389.5000,2328.8469,-0.0017,2.2623,2.2675,2.2709,2.2538,2.2486,2.2602,2.2675,0.3214,2.5317,0.3401,-0.1610,3.2849,32.2150,27.3654,27.3654,25.0426,0.0288,7.1708,10.4280,18.0919,10.4280,441.0237,10.8400,1.3721,1.4477,110.8627,88.5656,67.8261,2.3959,3.9580,10.9131,2.7572,1.6520,4.5550,0.0000
 1390.0000,2211.1926,-0.0002,2.3032,2.3038,2.3060,2.2918,2.2850,2.3026,2.3038,0.3220,2.5325,0.0772,-0.3344,3.1913,33.5758,28.7452,28.7452,26.3223,0.0222,7.1205,10.3794,18.0475,10.3794,434.0566,10.8884,1.2990,1.4659,114.6875,89.5957,69.1689,2.4360,3.9294,11.1637,2.8411,1.6130,4.5828,2.4000
 1390.5000,2430.6882,0.0057,2.2501,2.2324,2.2325,2.2227,2.2185,2.2501,2.2324,0.3234,2.5003,-0.4787,-0.7847,3.1033,35.5404,30.7548,30.7548,28.1796,0.0243,9.0757,12.2660,19.7726,12.2660,447.9480,10.6699,1.4152,1.2255,114.5680,87.3232,67.7801,2.3757,3.7753,10.9936,2.9120,1.5891,4.6275,2.0000
 1391.0000,2275.3755,0.0006,2.1303,2.1285,2.1264,2.1208,2.1229,2.1303,2.1285,0.3214,2.3810,-0.6666,-0.4218,2.9352,38.7827,34.1164,34.1164,31.2697,0.0269,16.3043,19.2409,26.1508,19.2409,469.8044,11.1240,0.7869,0.8531,109.4629,83.6006,64.4129,2.2616,3.6799,10.4291,2.8341,1.6271,4.6114,1.6000
 1391.5000,2226.1643,0.0209,2.1669,2.1047,2.0995,2.0973,2.1071,2.1669,2.1047,0.3225,2.2021,-0.3110,0.4290,2.6200,40.1024,35.5006,35.5006,32.5362,0.0193,27.1440,29.7003,35.7153,29.7003,475.1266,10.7893,1.3036,0.9818,99.7612,78.0965,59.7031,2.1051,3.5260,9.6244,2.7295,1.6750,4.5720,3.2000
 1392.0000,2187.4104,0.0014,2.0322,2.0282,2.0197,2.0200,2.0248,2.0322,2.0282,0.3231,2.2101,0.0684,0.7803,2.5052,35.4293,30.6406,30.6406,28.0743,0.0151,26.6635,29.2367,35.2913,29.2367,493.0397,10.2912,2.0846,1.2610,92.5005,73.1052,55.2391,1.9521,3.4129,8.8836,2.6030,1.7483,4.5507,3.0000
 1392.5000,2204.6392,0.0317,2.0581,1.9689,1.9567,1.9581,1.9752,2.0581,1.9689,0.3226,2.3926,0.1005,0.3246,2.6560,26.5999,21.7788,21.7788,19.8209,0.0177,15.5992,18.5606,25.5287,18.5607,507.8974,10.2108,1.8397,1.3467,90.0872,72.3620,54.4963,1.9124,3.4142,8.8283,2.5857,1.7853,4.6164,4.0000
 1393.0000,2282.1697,0.0257,2.0138,1.9429,1.9261,1.9273,1.9426,2.0138,1.9429,0.3228,2.4871,0.1895,-0.4032,2.6846,23.0655,18.3517,18.3517,16.5834,0.0164,9.8711,13.0335,20.4745,13.0335,514.7036,10.0258,3.6090,1.7795,88.6552,71.5348,54.2267,1.8852,3.3344,8.8686,2.6597,1.7687,4.7043,4.8000
 1393.5000,2313.5300,-0.0077,1.9988,2.0202,1.9968,1.9964,1.9978,1.9988,2.0202,0.3225,2.5043,0.3866,-0.2602,2.6503,22.5068,17.8164,17.8164,16.0752,0.0152,8.8276,12.0266,19.5537,12.0266,495.0052,10.0204,3.3225,1.9689,89.6794,71.8531,55.2080,1.9045,3.2432,9.0997,2.8058,1.7030,4.7781,3.0000
 1394.0000,2393.3052,0.0166,2.3716,2.3174,2.2812,2.2772,2.2924,2.3716,2.3174,0.3233,2.5398,0.5617,0.3341,2.7994,22.3930,17.7076,17.7076,15.9718,0.0163,6.6799,9.9542,17.6587,9.9543,431.5111,10.0098,4.2816,2.3806,93.4355,72.7014,56.5443,1.9490,3.1874,9.3272,2.9263,1.6354,4.7856,0.0000
 1394.5000,2350.5789,-0.0183,2.6824,2.7503,2.6945,2.6838,2.6830,2.6825,2.7503,0.3224,2.5684,0.6522,0.4945,3.0306,22.4081,17.7221,17.7221,15.9856,0.0182,4.9465,8.2817,16.1292,8.2817,363.6009,10.0171,4.4041,2.3859,95.7427,72.0036,56.8803,1.9612,3.0399,9.3796,3.0855,1.5500,4.7825,3.2000
 1395.0000,2300.3782,-0.0036,3.2421,3.2584,3.1807,3.1593,3.1293,3.2422,3.2584,0.3219,2.5838,0.3611,0.3326,3.3136,22.5234,17.8323,17.8323,16.0903,0.0203,4.0124,7.3803,15.3050,7.3804,306.8981,10.0015,3.5019,2.5249,91.0543,70.7219,56.5501,1.9425,2.8891,9.3602,3.2398,1.4873,4.8187,0.8000
 1395.5000,2375.3398,-0.0188,3.7192,3.8162,3.7172,3.6826,3.6121,3.7192,3.8162,0.3243,2.5949,-0.1166,-0.0005,3.6204,21.5848,16.9369,16.9369,15.2387,0.0182,3.3384,6.7300,14.7103,6.7300,262.0405,10.0065,9.0872,4.6765,82.9898,68.7140,55.4255,1.8942,2.7326,9.2196,3.3739,1.4426,4.8672,3.0000
 1396.0000,2400.5730,-0.0307,3.5355,3.6862,3.5876,3.5515,3.4703,3.5356,3.6862,0.3236,2.5957,-0.3328,-0.1535,3.7569,22.2759,17.5957,17.5957,15.8654,0.0132,3.2880,6.6814,14.6659,6.6814,271.2846,10.0107,5.6062,3.4077,80.8557,67.6231,54.7632,1.8779,2.6394,9.0798,3.4400,1.4056,4.8352,1.0000
 1396.5000,2414.5076,-0.0384,3.1896,3.3597,3.2679,3.2312,3.1557,3.1896,3.3597,0.3236,2.5847,-0.0875,-0.1956,3.7658,24.9838,20.2031,20.2031,18.3358,0.0127,3.9547,7.3247,15.2541,7.3247,297.6448,9.9962,5.7759,2.9274,84.1139,70.0311,56.7897,1.9546,2.6953,9.3814,3.4807,1.3789,4.7997,0.8000
 1397.0000,2388.4219,-0.0384,2.6456,2.7867,2.7133,2.6820,2.6275,2.6456,2.7867,0.3231,2.5605,0.3472,-0.0641,3.7425,28.2744,23.4267,23.4267,21.3681,0.0160,5.4239,8.7423,16.5505,8.7423,358.8529,10.0230,5.4415,2.9711,92.4104,76.3936,61.7851,2.1378,2.9331,10.1533,3.4616,1.3721,4.7495,1.6000
 1397.5000,2436.7581,-0.0323,2.2019,2.3008,2.2450,2.2200,2.1871,2.2019,2.3008,0.3235,2.5424,0.3283,0.1829,3.6736,32.7205,27.8768,27.8768,25.5173,0.0176,6.5212,9.8011,17.5187,9.8011,434.6266,10.0627,3.7961,1.9470,108.0496,84.3851,68.0799,2.3707,3.2442,11.1157,3.4263,1.3684,4.6887,0.0000
 1398.0000,2427.4988,-0.0251,2.0199,2.0902,2.0442,2.0233,2.0047,2.0199,2.0902,0.3232,2.5521,-0.1993,-0.0529,3.5812,33.3671,28.5330,28.5330,26.1257,0.0178,5.9308,9.2314,16.9977,9.2315,478.4156,10.1183,2.9688,1.6984,122.2185,93.3076,75.1221,2.6331,3.5978,12.1841,3.3865,1.3664,4.6272,4.8000
 1398.5000,2357.3967,-0.0181,1.9581,2.0072,1.9688,1.9516,1.9432,1.9581,2.0072,0.3232,2.5566,-0.5564,-0.4458,3.4516,34.7336,29.9270,29.9270,27.4155,0.0160,5.6592,8.9694,16.7581,8.9694,498.2132,10.1592,3.0052,1.6532,128.3095,98.0512,78.6022,2.7755,3.8309,12.6519,3.3026,1.3803,4.5584,2.4000
 1399.0000,2375.5242,-0.0154,1.9009,1.9414,1.9107,1.8981,1.8979,1.9009,1.9414,0.3235,2.5430,-0.3018,-0.2351,3.3221,34.3824,29.5677,29.5677,27.0834,0.0131,6.4850,9.7662,17.4868,9.7662,515.0996,10.1867,2.3536,1.4917,129.4568,99.3516,79.4781,2.8182,3.8979,12.7371,3.2677,1.3831,4.5197,3.0000
 1399.5000,2366.1602,-0.0034,1.8780,1.8867,1.8638,1.8569,1.8623,1.8780,1.8867,0.3242,2.5354,0.2112,0.2970,3.2747,36.2727,31.5091,31.5091,28.8748,0.0116,6.9453,10.2103,17.8929,10.2104,530.0207,10.4214,1.0588,1.3125,129.3632,99.3893,78.9072,2.7977,3.9702,12.6466,3.1854,1.4191,4.5203,6.4000
 1400.0000,2387.3862,-0.0061,1.8610,1.8767,1.8608,1.8607,1.8607,1.8607,1.8767,0.3228,2.5295,0.3421,0.1881,3.2861,36.5865,31.8333,31.8333,29.1732,0.0087,7.3021,10.5546,18.2077,10.5547,532.8611,10.6084,1.3386,1.2946,129.3471,100.0609,79.0779,2.8171,4.0306,12.6109,3.1288,1.4308,4.4766,4.8000
 1400.5000,2334.0642,0.0134,1.8823,1.8476,1.8390,1.8469,1.8573,1.8840,1.8476,0.3222,2.5169,0.0961,-0.5173,3.2923,35.9350,31.1609,31.1609,28.5540,0.0037,8.0672,11.2929,18.8828,11.2929,541.2528,10.6060,1.2218,1.3255,127.7786,98.9338,78.2083,2.7737,3.9941,12.5310,3.1374,1.4400,4.5178,4.0000
 1401.0000,2311.6641,0.0192,1.8821,1.8324,1.8308,1.8478,1.8590,1.8862,1.8324,0.3255,2.4467,-0.1164,-0.5201,3.2725,38.0937,33.3974,33.3974,30.6105,-0.0001,12.3193,15.3958,22.6347,15.3958,545.7426,10.3647,1.4589,1.1905,121.0622,94.9425,75.4971,2.6523,3.8048,12.2164,3.2108,1.4345,4.6060,1.0000
 1401.5000,2355.9458,0.0331,1.9852,1.8953,1.9014,1.9307,1.9454,1.9714,1.8953,0.3233,2.2802,-0.2997,0.4296,3.1123,39.5009,34.8685,34.8685,31.9583,-0.0027,22.4117,25.1341,31.5397,25.1341,527.6185,10.2255,3.2841,1.7306,109.9107,89.2168,71.4658,2.4788,3.5341,11.7153,3.3150,1.4257,4.7262,2.4000
 1402.0000,2286.9495,0.0487,2.0028,1.8700,1.8839,1.9242,1.9487,1.9824,1.8700,0.3258,2.2042,-0.3249,0.7122,2.8560,39.9927,35.3852,35.3852,32.4307,-0.0030,27.0161,29.5769,35.6024,29.5769,534.7693,10.2375,4.6988,2.1700,104.4247,85.6973,68.8625,2.3572,3.3763,11.4370,3.3874,1.4323,4.8519,5.6000
 1402.5000,2299.4907,0.0759,2.0144,1.8078,1.8289,1.8780,1.9202,1.9810,1.8078,0.3259,2.3417,-0.0174,-0.2252,2.8019,33.9689,29.1456,29.1456,26.6930,0.0025,18.6845,21.5377,28.2511,21.5377,553.1583,10.2947,3.1015,1.9708,111.6791,85.9548,69.0869,2.3477,3.3917,11.5558,3.4071,1.4447,4.9222,1.0000
 1403.0000,2323.9985,0.1328,2.2243,1.8320,1.8625,1.9246,1.9996,2.1201,1.8320,0.3245,2.4633,0.1927,-0.8075,2.9242,28.3865,23.5375,23.5375,21.4719,0.0142,11.3181,14.4297,21.7512,14.4297,545.8584,10.3548,4.0751,2.3684,116.8270,86.9347,69.3349,2.3436,3.5065,11.6568,3.3244,1.4962,4.9739,4.0000
 1403.5000,2438.3013,0.1756,2.4130,1.8585,1.8997,1.9753,2.0943,2.3049,1.8585,0.3259,2.4763,0.1777,-0.4370,3.0024,25.5959,20.7982,20.7982,18.8973,0.0374,10.5260,13.6654,21.0523,13.6654,538.0594,10.2062,4.4588,2.6226,110.7057,84.9188,67.0669,2.2498,3.5193,11.3567,3.2269,1.5643,5.0478,2.4000
 1404.0000,2292.5234,0.2170,2.5108,1.8088,1.8575,1.9393,2.0943,2.3876,1.8088,0.3267,2.5056,0.1104,0.1319,3.0015,22.7439,18.0434,18.0434,16.2908,0.0573,8.7502,11.9520,19.4855,11.9520,552.8465,9.9445,6.8028,4.2794,98.6932,79.1041,61.6260,2.0398,3.4039,10.5659,3.1041,1.6687,5.1799,4.0000
 1404.5000,2261.2090,0.2480,2.4586,1.6825,1.7334,1.8117,1.9796,2.3095,1.6825,0.3249,2.5175,0.1253,0.4780,2.9082,20.9939,16.3757,16.3757,14.7039,0.0551,8.0321,11.2590,18.8518,11.2590,594.3361,9.7945,15.0784,4.2267,88.3367,75.0368,57.4127,1.8757,3.3809,9.9606,2.9461,1.8025,5.3104,2.4000
 1405.0000,2204.9968,0.2543,2.1653,1.4663,1.5116,1.5756,1.7235,2.0111,1.4663,0.3246,2.4694,0.3904,0.2890,2.7336,23.7063,18.9679,18.9679,17.1675,0.0460,10.9461,14.0708,21.4230,14.0708,681.9819,9.7579,4.0246,2.4346,88.1136,73.5737,55.2541,1.7847,3.4616,9.6833,2.7973,1.9397,5.4258,4.0000
 1405.5000,2202.0828,0.2552,1.9164,1.2959,1.3364,1.3895,1.5183,1.7619,1.2959,0.3279,2.4325,0.4191,-0.3454,2.6132,24.8712,20.0939,20.0939,18.2326,0.0429,13.1824,16.2286,23.3962,16.2286,771.6793,9.7743,4.4481,2.5542,94.3135,73.1149,53.9585,1.7261,3.5745,9.5357,2.6677,2.0709,5.5245,4.0000
 1406.0000,2280.6614,0.2430,1.5672,1.0815,1.1130,1.1517,1.2492,1.4317,1.0815,0.3259,2.4292,-0.1227,-0.6253,2.6430,24.6507,19.8801,19.8801,18.0306,0.0407,13.3791,16.4184,23.5698,16.4184,924.6299,9.7871,5.3245,3.2763,94.4449,71.4355,51.8991,1.6375,3.6133,9.2794,2.5681,2.2066,5.6668,4.8000
 1406.5000,2342.5635,0.2273,1.2809,0.9073,0.9316,0.9598,1.0335,1.1757,0.9073,0.3245,2.4220,-0.5711,-0.3613,2.7015,24.6771,19.9057,19.9057,18.0548,0.0356,13.8192,16.8431,23.9581,16.8431,1102.1488,9.7320,4.5841,2.4361,88.2665,69.1879,50.0102,1.5490,3.5520,9.0788,2.5559,2.2931,5.8611,2.4000
 1407.0000,2427.0613,0.2208,1.1627,0.8325,0.8543,0.8789,0.9444,1.0764,0.8325,0.3249,2.4014,-0.4865,-0.0536,2.6527,24.6688,19.8977,19.8977,18.0472,0.0323,15.0690,18.0490,25.0609,18.0490,1201.2588,9.7402,3.1987,1.7534,86.7508,69.3693,49.9286,1.5093,3.6295,9.2401,2.5458,2.4047,6.1220,0.0000
 1407.5000,2365.1355,0.2286,1.2001,0.8483,0.8720,0.8983,0.9685,1.1122,0.8483,0.3262,2.3829,-0.1013,0.1829,2.5688,26.3132,21.4983,21.4983,19.5569,0.0312,16.1886,19.1294,26.0488,19.1294,1178.8773,9.7758,2.9186,1.3817,90.6274,72.5748,52.3741,1.5461,3.8152,9.8692,2.5868,2.4677,6.3833,0.0000
 1408.0000,2370.5598,0.2636,1.4425,0.9617,0.9931,1.0278,1.1194,1.3077,0.9617,0.3248,2.3862,0.1991,0.1867,2.5369,27.2093,22.3767,22.3767,20.3830,0.0271,15.9904,18.9381,25.8738,18.9381,1039.8060,9.8441,2.5711,1.2367,96.1577,76.4323,55.1336,1.5948,4.0314,10.5445,2.6156,2.5278,6.6117,0.0000
 1408.5000,2387.3052,0.3069,1.7856,1.1055,1.1471,1.1940,1.3148,1.5606,1.1055,0.3257,2.4118,0.1274,0.0951,2.5388,26.5087,21.6895,21.6895,19.7368,0.0204,14.4343,17.4366,24.5008,17.4366,904.5377,9.8995,4.1336,2.0700,102.4101,79.3062,57.4015,1.6370,4.1507,11.0894,2.6717,2.5356,6.7743,0.0000
 1409.0000,2467.3235,0.3259,1.9880,1.1909,1.2382,1.2930,1.4312,1.7063,1.1909,0.3266,2.4234,-0.1515,0.1988,2.5697,26.8604,22.0341,22.0341,20.0610,0.0132,13.7309,16.7579,23.8802,16.7579,839.6967,9.9839,4.6850,2.6767,103.5244,80.8132,58.7788,1.6487,4.1570,11.4862,2.7631,2.5213,6.9668,2.4000
 1409.5000,2497.9348,0.3229,2.0181,1.2153,1.2627,1.3193,1.4599,1.7368,1.2153,0.3268,2.4087,-0.2596,0.2347,2.6028,27.8166,22.9746,22.9746,20.9442,0.0073,14.6227,17.6184,24.6671,17.6184,822.8751,10.0343,4.7244,2.3023,102.1344,81.6130,59.6413,1.6518,4.1449,11.7548,2.8359,2.5093,7.1163,3.0000
 1410.0000,2395.8740,0.3170,2.0200,1.2289,1.2749,1.3316,1.4717,1.7498,1.2289,0.3259,2.3985,-0.0664,0.0145,2.5984,27.4519,22.6153,22.6153,20.6070,0.0048,15.2409,18.2149,25.2125,18.2149,813.7316,10.1028,4.3531,2.1511,103.9884,81.3385,59.9981,1.6468,4.0539,11.8958,2.9344,2.4617,7.2236,0.8000
 1410.5000,2375.5579,0.3095,2.0087,1.2381,1.2815,1.3371,1.4745,1.7507,1.2381,0.3265,2.3932,0.1453,0.0365,2.5837,27.7795,22.9381,22.9381,20.9099,0.0059,15.5612,18.5239,25.4951,18.5239,807.7065,10.2018,4.3625,2.4244,104.0829,80.0963,59.5412,1.6284,3.9459,11.8328,2.9987,2.4231,7.2663,0.8000
 1411.0000,2372.9207,0.3110,2.0335,1.2501,1.2906,1.3442,1.4778,1.7476,1.2501,0.3263,2.3786,0.0647,0.1173,2.5766,28.2454,23.3981,23.3981,21.3412,0.0111,16.4493,19.3809,26.2788,19.3809,799.9383,10.2958,4.0544,3.5436,100.3652,78.9679,59.3028,1.6326,3.8113,11.7348,3.0789,2.3345,7.1878,3.0000
 1411.5000,2398.2000,0.2871,1.9599,1.2555,1.2920,1.3420,1.4680,1.7208,1.2555,0.3252,2.3787,-0.0862,-0.4252,2.5497,29.0899,24.2348,24.2348,22.1246,0.0210,16.4438,19.3756,26.2739,19.3756,796.4688,10.3748,4.0160,2.9976,97.7047,78.5190,59.8500,1.6717,3.6617,11.7288,3.2031,2.1904,7.0159,3.2000
 1412.0000,2393.4785,0.2410,1.8051,1.2500,1.2813,1.3260,1.4401,1.6664,1.2500,0.3262,2.3950,-0.0362,-0.6251,2.5264,28.1715,23.3250,23.3250,21.2728,0.0294,15.4521,18.4187,25.3989,18.4187,799.9768,10.4293,4.2197,2.7780,99.1045,77.8054,59.9618,1.7028,3.5090,11.6183,3.3110,2.0607,6.8232,4.8000
 1412.5000,2360.5291,0.2180,1.7252,1.2407,1.2665,1.3049,1.4051,1.6030,1.2407,0.3270,2.3971,0.0419,0.0996,2.5424,28.3243,23.4761,23.4761,21.4143,0.0312,15.3263,18.2973,25.2879,18.2973,805.9664,10.4234,3.9459,2.8665,99.4293,77.8239,60.5082,1.7335,3.4097,11.6519,3.4173,1.9669,6.7215,6.0000
 1413.0000,2326.7966,0.2062,1.7379,1.2743,1.2958,1.3301,1.4218,1.6061,1.2743,0.3265,2.3908,0.0548,0.5003,2.5478,28.4307,23.5813,23.5813,21.5129,0.0301,15.7095,18.6670,25.6260,18.6670,784.7408,10.2571,3.6342,2.3210,97.6627,78.2249,61.1407,1.7717,3.3383,11.6787,3.4984,1.8843,6.5919,7.0000
 1413.5000,2281.2136,0.1836,1.7414,1.3243,1.3413,1.3714,1.4542,1.6252,1.3243,0.3257,2.3972,0.2164,0.3051,2.5383,27.4934,22.6561,22.6561,20.6453,0.0238,15.3216,18.2928,25.2838,18.2928,755.1390,10.0483,3.9217,2.4161,100.2563,78.9961,61.9690,1.8118,3.3191,11.7603,3.5432,1.8319,6.4909,2.4000
 1414.0000,2334.2937,0.1542,1.7809,1.4187,1.4312,1.4580,1.5333,1.6915,1.4187,0.3254,2.4109,0.5107,-0.0017,2.5467,26.3528,21.5370,21.5370,19.5933,0.0145,14.4893,17.4896,24.5494,17.4897,704.8699,9.9240,4.3504,2.4121,104.7521,81.8479,64.3516,1.8990,3.4128,12.1292,3.5541,1.7971,6.3871,1.6000
 1414.5000,2282.1809,0.1198,1.8533,1.5572,1.5642,1.5879,1.6539,1.7919,1.5572,0.3261,2.4370,0.6494,-0.3132,2.6032,26.9363,22.1087,22.1087,20.1311,0.0160,12.9061,15.9620,23.1525,15.9621,642.1903,9.8502,4.0480,2.0472,110.8939,87.2550,69.0696,2.0614,3.5735,12.9088,3.6124,1.7335,6.2622,5.0000
 1415.0000,2306.8157,0.0828,1.9417,1.7248,1.7245,1.7441,1.7963,1.9026,1.7248,0.3251,2.4800,0.4801,0.1706,2.7967,28.8634,24.0100,24.0100,21.9143,0.0202,10.3043,13.4515,20.8568,13.4515,579.7648,9.8642,3.9766,2.3118,120.8891,95.0829,75.7265,2.2746,3.8243,14.0840,3.6827,1.6813,6.1919,0.8000
 1415.5000,2320.3130,0.0460,2.0743,1.9442,1.9344,1.9492,1.9837,2.0564,1.9442,0.3244,2.5164,0.2066,0.6979,3.0852,30.3790,25.5198,25.5198,23.3248,0.0170,8.0943,11.3191,18.9067,11.3191,514.3538,9.9002,3.8818,2.2532,132.4350,103.8218,83.0689,2.5232,4.1010,15.3164,3.7348,1.6253,6.0703,2.4000
 1416.0000,2302.6003,0.0147,2.1996,2.1553,2.1353,2.1438,2.1556,2.1968,2.1553,0.3266,2.5369,0.0564,0.0511,3.2915,31.3383,26.4818,26.4818,24.2210,0.0138,6.8562,10.1244,17.8143,10.1244,463.9824,9.9354,3.6769,2.1385,143.5972,109.7679,88.5868,2.7182,4.2222,16.2038,3.8378,1.5533,5.9612,4.0000
 1416.5000,2380.1533,-0.0061,2.2745,2.2935,2.2654,2.2667,2.2572,2.2769,2.2935,0.3269,2.5514,-0.0551,-0.3364,3.3513,31.8021,26.9488,26.9488,24.6554,0.0116,5.9782,9.2772,17.0396,9.2772,436.0120,10.0197,3.3795,2.2645,148.8245,112.4728,91.1399,2.8371,4.2795,16.4780,3.8505,1.5084,5.8080,0.0000
 1417.0000,2358.0759,-0.0182,2.3196,2.3781,2.3427,2.3384,2.3143,2.3227,2.3781,0.3267,2.5559,-0.1501,0.0936,3.3067,32.0354,27.1841,27.1841,24.8741,0.0103,5.7016,9.0103,16.7955,9.0103,420.5032,10.0880,3.5334,2.4602,146.7127,113.7133,92.2461,2.9225,4.3194,16.4365,3.8052,1.4780,5.6242,3.0000
 1417.5000,2382.9055,-0.0237,2.3136,2.3896,2.3492,2.3408,2.3077,2.3146,2.3896,0.3265,2.5449,-0.1139,0.4292,3.2176,31.3597,26.5033,26.5033,24.2410,0.0086,6.3714,9.6566,17.3865,9.6566,418.4794,10.1158,3.4892,2.2561,143.7747,114.8355,92.7370,2.9970,4.4217,16.2444,3.6738,1.4754,5.4203,1.0000
 1418.0000,2394.9753,-0.0259,2.2868,2.3690,2.3259,2.3145,2.2777,2.2869,2.3690,0.3273,2.5340,-0.0998,0.3780,3.1722,31.4442,26.5883,26.5883,24.3201,0.0061,7.0317,10.2938,17.9692,10.2938,422.1173,10.1543,3.5856,2.1352,145.2120,115.5034,92.9844,3.0532,4.4961,16.0588,3.5717,1.4726,5.2597,6.4000
 1418.5000,2365.0896,-0.0265,2.2812,2.3649,2.3201,2.3064,2.2688,2.2812,2.3649,0.3259,2.5320,-0.2094,0.1474,3.1678,32.2633,27.4142,27.4142,25.0879,0.0045,7.1489,10.4069,18.0726,10.4069,422.8452,10.2235,3.7780,2.0794,146.7948,114.7181,92.3061,3.0775,4.4829,15.7205,3.5068,1.4567,5.1082,1.6000
 1419.0000,2398.7295,-0.0260,2.2679,2.3498,2.3047,2.2894,2.2533,2.2679,2.3498,0.3263,2.5314,-0.1459,-0.0158,3.1412,33.3869,28.5531,28.5531,26.1444,0.0025,7.1898,10.4463,18.1087,10.4463,425.5628,10.2789,3.8104,2.0524,144.7106,112.4705,90.5194,3.0468,4.4253,15.2795,3.4527,1.4525,5.0150,2.0000
 1419.5000,2369.3508,-0.0253,2.2545,2.3337,2.2892,2.2727,2.2391,2.2545,2.3337,0.3256,2.5344,0.1375,-0.1771,3.1584,33.6563,28.8271,28.8271,26.3982,0.0009,7.0080,10.2709,17.9483,10.2709,428.5060,10.3137,3.7165,2.1200,142.1839,109.8250,88.6278,3.0156,4.3227,14.8060,3.4251,1.4335,4.9098,1.6000
 1420.0000,2391.7161,-0.0242,2.2395,2.3147,2.2716,2.2542,2.2234,2.2395,2.3147,0.3261,2.5383,0.2895,-0.5647,3.2334,32.7525,27.9093,27.9093,25.5474,0.0004,6.7673,10.0386,17.7358,10.0386,432.0299,10.3421,3.4819,1.8033,140.3237,108.4896,87.8749,3.0218,4.2571,14.5292,3.4130,1.4088,4.8081,2.4000
 1420.5000,2348.4141,-0.0228,2.1957,2.2651,2.2246,2.2070,2.1788,2.1957,2.2651,0.3263,2.5365,0.0900,-0.6554,3.2450,34.0057,29.1832,29.1832,26.7278,0.0014,6.8794,10.1468,17.8348,10.1468,441.4772,10.3548,2.9845,1.8233,139.9499,109.2089,88.8576,3.0903,4.2358,14.5273,3.4297,1.3707,4.7010,1.6000
 1421.0000,2410.5579,-0.0220,2.1460,2.2114,2.1738,2.1563,2.1293,2.1460,2.2114,0.3273,2.5300,-0.2424,-0.1374,3.1943,33.1333,28.2954,28.2954,25.9056,0.0029,7.2755,10.5290,18.1842,10.5290,452.1956,10.3409,3.4192,2.0187,140.7029,111.5630,91.3874,3.1990,4.2432,14.8424,3.4979,1.3264,4.6397,0.0000
 1421.5000,2385.6699,-0.0224,2.1020,2.1672,2.1325,2.1153,2.0875,2.1020,2.1672,0.3272,2.5218,-0.3173,0.1749,3.1848,33.3111,28.4761,28.4761,26.0730,0.0049,7.7667,11.0030,18.6177,11.0030,461.4204,10.3308,3.5028,1.9645,140.3175,112.3318,92.4703,3.2536,4.2068,14.9389,3.5511,1.2930,4.5915,2.4000
 1422.0000,2368.6367,-0.0246,2.0837,2.1548,2.1224,2.1056,2.0750,2.0837,2.1548,0.3265,2.5279,-0.1527,0.3911,3.2505,33.8629,29.0376,29.0376,26.5930,0.0101,7.4011,10.6502,18.2951,10.6502,464.0898,10.3258,3.5321,2.0046,136.6550,113.5341,93.7565,3.3051,4.2209,15.1172,3.5815,1.2771,4.5739,4.0000
 1422.5000,2383.3777,-0.0282,2.0710,2.1519,2.1219,2.1058,2.0717,2.0710,2.1519,0.3271,2.5339,-0.0623,0.5468,3.2973,34.2246,29.4066,29.4066,26.9344,0.0130,7.0356,10.2975,17.9726,10.2975,464.7060,10.3588,3.5259,2.1659,134.8091,111.4150,92.1276,3.2574,4.1683,14.8085,3.5526,1.2797,4.5461,5.0000
 1423.0000,2374.6021,-0.0312,2.0570,2.1462,2.1189,2.1037,2.0674,2.0570,2.1462,0.3271,2.5261,-0.1677,-0.0309,3.2463,35.6475,30.8649,30.8649,28.2812,0.0174,7.5101,10.7554,18.3913,10.7554,465.9351,10.4026,3.5904,2.2553,138.2619,109.1682,90.4824,3.1941,4.0990,14.5684,3.5541,1.2833,4.5611,2.4000
 1423.5000,2365.8723,-0.0315,2.0753,2.1662,2.1413,2.1273,2.0908,2.0753,2.1662,0.3260,2.5264,-0.3134,-0.6758,3.2034,35.7330,30.9529,30.9529,28.3623,0.0407,7.4897,10.7357,18.3733,10.7357,461.6477,10.4500,3.4317,1.7368,138.6687,106.1865,87.7700,3.0916,4.0541,14.1638,3.4937,1.3113,4.5814,4.8000
 1424.0000,2298.0859,-0.0289,2.0173,2.0981,2.0768,2.0647,2.0320,2.0173,2.0981,0.3257,2.5245,-0.3422,-0.2555,3.2556,37.4351,32.7124,32.7124,29.9816,0.0751,7.6038,10.8457,18.4739,10.8457,476.6213,10.6519,1.4632,0.9750,134.5209,103.5283,85.3736,3.0087,3.9848,13.7700,3.4556,1.3244,4.5768,3.0000
 1424.5000,2317.9521,-0.0260,1.9620,2.0328,2.0149,2.0047,1.9767,1.9620,2.0328,0.3256,2.5019,-0.2033,0.2820,3.2869,37.7574,33.0473,33.0473,30.2891,0.0945,8.9783,12.1720,19.6867,12.1720,491.9409,11.0112,0.8503,1.2047,129.7031,104.0182,85.4986,3.0078,4.0318,13.8150,3.4265,1.3405,4.5931,8.0000
 1425.0000,2278.4268,-0.0215,1.9502,2.0083,1.9936,1.9849,1.9621,1.9502,2.0083,0.3270,2.4749,0.0183,0.0284,3.2649,38.2961,33.6083,33.6083,30.8039,0.1097,10.6097,13.7462,21.1262,13.7462,497.9330,11.0867,1.2130,1.3075,127.1380,103.6650,84.9929,2.9998,4.0474,13.6870,3.3817,1.3492,4.5627,3.2000
 1425.5000,2302.2090,-0.0132,1.8685,1.9025,1.8914,1.8847,1.8687,1.8685,1.9025,0.3268,2.4570,0.2120,-0.2021,3.3058,39.1535,34.5044,34.5044,31.6250,0.1340,11.6988,14.7970,22.0871,14.7971,525.6121,11.1629,0.9850,1.0014,127.6680,103.9428,85.2570,3.0145,4.0745,13.7039,3.3633,1.3516,4.5460,3.2000
 1426.0000,2391.0132,-0.0045,1.7966,1.8078,1.8000,1.7951,1.7850,1.7966,1.8078,0.3263,2.4402,0.2803,0.0274,3.3691,38.0972,33.4010,33.4010,30.6137,0.1336,12.7142,15.7769,22.9831,15.7769,553.1655,11.7781,0.8064,0.8554,128.7797,104.4451,85.5801,3.0294,4.1287,13.7395,3.3278,1.3629,4.5355,3.0000
 1426.5000,2327.2341,0.0012,1.7867,1.7838,1.7789,1.7752,1.7693,1.7867,1.7838,0.3269,2.4281,0.0508,0.0629,3.3710,38.3092,33.6220,33.6220,30.8164,0.1099,13.4464,16.4834,23.6292,16.4834,560.5942,12.1284,0.8843,0.8372,128.1667,104.3652,85.4656,3.0273,4.1413,13.7118,3.3110,1.3680,4.5294,3.0000
 1427.0000,2373.5313,0.0038,1.7788,1.7696,1.7673,1.7649,1.7627,1.7788,1.7696,0.3286,2.4220,-0.2156,-0.2149,3.2798,38.7645,34.0974,34.0974,31.2522,0.0952,13.8193,16.8432,23.9582,16.8432,565.1022,12.1754,0.8700,0.8874,125.2751,104.4340,85.5997,3.0266,4.1312,13.7589,3.3305,1.3649,4.5459,5.6000
 1427.5000,2340.3174,0.0064,1.7640,1.7486,1.7488,1.7475,1.7500,1.7640,1.7486,0.3266,2.4053,-0.0703,0.0838,3.1359,39.4922,34.8594,34.8594,31.9500,0.0882,14.8304,17.8188,24.8504,17.8188,571.9008,12.3879,0.7388,0.9715,124.8201,105.5521,87.0518,3.0542,4.0920,14.1049,3.4470,1.3398,4.6181,5.6000
 1428.0000,2336.7241,0.0096,1.7149,1.6923,1.6946,1.6944,1.6978,1.7149,1.6923,0.3267,2.3902,0.0335,0.6201,3.1352,39.4851,34.8519,34.8519,31.9431,0.0889,15.7434,18.6998,25.6559,18.6998,590.9003,12.3774,0.8854,0.8840,127.3076,106.9023,89.0127,3.0958,4.0178,14.5519,3.6218,1.2978,4.7005,3.0000
 1428.5000,2326.1748,0.0168,1.6733,1.6348,1.6385,1.6393,1.6504,1.6733,1.6348,0.3271,2.3894,-0.2776,0.5515,3.2125,41.5308,37.0091,37.0091,33.9127,0.0963,15.7920,18.7466,25.6988,18.7466,611.6823,12.6989,0.8769,0.9579,128.6066,107.4863,90.0204,3.1019,3.9627,14.8540,3.7484,1.2775,4.7887,2.4000
 1429.0000,2352.4099,0.0277,1.6351,1.5730,1.5775,1.5789,1.5948,1.6350,1.5730,0.3264,2.3863,-0.2239,0.2764,3.1669,38.1226,33.4275,33.4275,30.6381,0.0919,15.9798,18.9279,25.8646,18.9279,635.7231,13.0030,0.8527,0.8750,127.3691,105.2366,88.2083,3.0229,3.8842,14.6336,3.7674,1.2849,4.8409,4.0000
 1429.5000,2347.9304,0.0374,1.5666,1.4866,1.4910,1.4926,1.5092,1.5665,1.4866,0.3258,2.4031,0.1977,0.3669,3.1890,34.9777,30.1770,30.1770,27.6464,0.0773,14.9664,17.9500,24.9703,17.9500,672.6713,12.7651,0.7884,0.8014,117.0188,94.2195,78.6646,2.6956,3.5257,13.0512,3.7017,1.3079,4.8416,3.0000
 1430.0000,2365.5618,0.0399,1.5342,1.4506,1.4545,1.4560,1.4701,1.5342,1.4506,0.3257,2.4683,0.1229,0.1864,3.4705,31.1467,26.2893,26.2893,24.0418,0.0559,11.0112,14.1336,21.4805,14.1336,689.3796,11.8110,1.0101,0.9365,92.2561,73.3242,60.7075,2.0811,2.8066,10.0683,3.5874,1.3486,4.8381,3.2000
 1430.5000,2372.8059,0.0207,1.5124,1.4695,1.4725,1.4736,1.4809,1.5123,1.4695,0.3266,2.5338,0.0310,-0.0323,3.8032,27.0077,22.1787,22.1787,20.1969,0.0236,7.0448,10.3064,17.9807,10.3064,680.5024,10.4793,3.2893,1.7501,58.7472,50.7911,41.6188,1.4330,1.9859,6.8726,3.4607,1.3859,4.7960,1.6000
 1431.0000,2409.4060,0.0012,1.4930,1.4905,1.4920,1.4922,1.4924,1.4925,1.4905,0.3272,2.5620,0.2571,0.0501,3.9988,25.2866,20.4972,20.4972,18.6134,0.0063,5.3322,8.6538,16.4695,8.6538,670.8944,10.4185,4.6909,2.4184,34.6527,34.3469,27.6961,0.9580,1.4018,4.5525,3.2476,1.4632,4.7518,1.0000
 1431.5000,2417.8018,0.0218,1.5325,1.4867,1.4857,1.4848,1.4936,1.5321,1.4867,0.3262,2.5645,0.1935,-0.1144,4.0001,24.4559,19.6916,19.6916,17.8524,0.0086,5.1824,8.5093,16.3374,8.5093,672.6342,10.4236,5.5975,3.0342,27.6035,27.5829,21.8227,0.7608,1.1774,3.5591,3.0228,1.5476,4.6782,2.0000
 1432.0000,2370.7095,0.0321,1.5386,1.4710,1.4671,1.4647,1.4770,1.5386,1.4710,0.3264,2.5505,-0.0595,-0.1089,3.8296,25.6145,20.8163,20.8163,18.9144,0.0063,6.0299,9.3271,17.0852,9.3271,679.8018,10.4573,4.2216,2.1310,31.2347,28.6082,22.1215,0.7789,1.2883,3.5713,2.7720,1.6541,4.5851,1.6000
 1432.5000,2335.8953,0.0099,1.7589,1.7351,1.7263,1.7208,1.7111,1.7616,1.7351,0.3266,2.5536,-0.3711,-0.2069,3.7374,23.9267,19.1804,19.1804,17.3687,0.0047,5.8399,9.1438,16.9176,9.1438,576.3377,10.4768,3.4443,1.7862,39.7872,33.0441,25.1161,0.8938,1.5329,4.0100,2.6159,1.7151,4.4866,4.8000
 1433.0000,2335.3767,-0.0467,2.5338,2.6984,2.6772,2.6638,2.5985,2.5503,2.6984,0.3266,2.5847,-0.6441,-0.4700,3.8509,21.3109,16.6765,16.6765,14.9906,0.0096,3.9546,7.3246,15.2540,7.3246,370.5868,10.5056,2.7136,2.1672,45.5829,36.3101,27.1548,0.9785,1.7191,4.2775,2.4882,1.7569,4.3714,4.0000
 1433.5000,2298.2817,-0.1091,3.0560,3.5250,3.4930,3.4722,3.3602,3.0861,3.5250,0.3274,2.5664,-0.5699,-0.5469,3.9748,21.8468,17.1863,17.1863,15.4761,0.0145,5.0671,8.3980,16.2356,8.3980,283.6866,10.5128,4.7771,3.6555,44.8397,39.8262,29.4122,1.0740,1.9274,4.5661,2.3690,1.7946,4.2515,1.6000
 1434.0000,2299.8596,-0.1142,2.7183,3.1552,3.1249,3.1062,3.0050,2.7387,3.1552,0.3271,2.4008,-0.1195,-0.5315,3.7125,25.4104,20.6177,20.6177,18.7271,0.0362,15.1008,18.0797,25.0889,18.0797,316.9336,10.4996,5.5750,5.6572,49.4256,45.5234,33.3291,1.2253,2.2422,5.1348,2.2900,1.8299,4.1906,1.6000
 1434.5000,2302.2888,-0.0701,1.7790,1.9535,1.9359,1.9263,1.8731,1.7806,1.9535,0.3268,2.2271,0.2627,0.1236,3.2214,30.7402,25.8814,25.8814,23.6619,0.0849,25.6288,28.2383,34.3783,28.2383,511.9057,10.6173,2.5399,2.6136,63.8817,50.6836,36.7890,1.3593,2.5357,5.6356,2.2225,1.8654,4.1459,6.0000
 1435.0000,2334.7773,-0.0217,1.5288,1.5747,1.5623,1.5565,1.5305,1.5269,1.5747,0.3268,2.2822,-0.0403,0.8784,3.1282,32.0379,27.1866,27.1866,24.8764,0.1077,22.2938,25.0203,31.4357,25.0203,635.0229,11.1638,0.2767,0.5113,72.4325,51.1857,36.8148,1.3562,2.6108,5.6590,2.1675,1.9252,4.1729,3.2000
 1435.5000,2310.4888,0.0044,1.6856,1.6754,1.6648,1.6604,1.6529,1.6850,1.6754,0.3255,2.4685,-0.4876,0.5562,3.3717,26.8640,22.0377,22.0377,20.0643,0.0687,10.9995,14.1223,21.4701,14.1223,596.8863,10.7695,1.3282,0.8995,61.7985,45.2244,32.4232,1.1856,2.2976,5.0256,2.1873,1.9379,4.2389,7.2000
 1436.0000,2362.2913,0.0220,1.7941,1.7400,1.7298,1.7260,1.7373,1.7947,1.7400,0.3275,2.5798,-0.4192,0.1274,3.5136,23.9938,19.2451,19.2451,17.4300,0.0219,4.2556,7.6151,15.5197,7.6151,574.7238,10.2941,3.2373,1.8217,43.7566,36.6477,26.3331,0.9684,1.8452,4.0557,2.1979,1.9055,4.1881,2.0000
 1436.5000,2373.4963,0.0381,1.8124,1.7180,1.7092,1.7060,1.7281,1.8130,1.7180,0.3280,2.6018,-0.1165,0.4430,3.4723,24.5253,19.7588,19.7588,17.9160,0.0063,2.9218,6.3281,14.3428,6.3281,582.0596,10.2582,3.1197,1.7835,37.6076,32.5873,23.5621,0.8658,1.6184,3.6323,2.2443,1.8694,4.1954,0.8000
 1437.0000,2360.0105,0.0462,1.8556,1.7386,1.7292,1.7256,1.7528,1.8552,1.7386,0.3266,2.5922,0.2528,0.3727,3.3898,24.1301,19.3767,19.3767,17.5546,0.0037,3.5004,6.8864,14.8533,6.8864,575.1760,10.2522,2.6431,1.6093,41.6921,32.8144,24.0847,0.8910,1.5807,3.6843,2.3308,1.7741,4.1350,3.2000
 1437.5000,2360.6785,0.0506,1.9423,1.8084,1.7965,1.7917,1.8239,1.9413,1.8084,0.3268,2.5801,0.5076,-0.0603,3.3818,23.0165,18.3048,18.3048,16.5388,-0.0003,4.2356,7.5957,15.5020,7.5957,552.9706,10.2624,3.1099,2.0583,46.0861,34.1425,25.2786,0.9456,1.6172,3.8175,2.3606,1.7103,4.0373,4.0000
 1438.0000,2326.0601,0.0519,2.1497,1.9978,1.9801,1.9732,2.0113,2.1484,1.9978,0.3260,2.5810,0.4427,0.0863,3.4773,21.3219,16.6869,16.6869,15.0006,-0.0023,4.1812,7.5432,15.4540,7.5433,500.5391,10.2760,3.4845,2.2955,45.1315,33.3527,24.7695,0.9364,1.5671,3.6939,2.3572,1.6736,3.9449,4.0000
 1438.5000,2343.7375,0.0485,2.9093,2.7172,2.6803,2.6656,2.7161,2.9077,2.7172,0.3268,2.6072,0.2253,0.2756,3.6480,17.6413,13.2294,13.2294,11.6906,-0.0012,2.5919,6.0097,14.0516,6.0097,368.0251,10.1962,4.1635,2.9905,39.5990,31.9991,23.7394,0.9034,1.4998,3.5120,2.3417,1.6601,3.8875,3.2000
 1439.0000,2289.6443,0.0151,4.5373,4.4434,4.3473,4.3127,4.3605,4.5375,4.4433,0.3279,2.6458,-0.0217,-0.0558,3.8702,14.1044,9.9804,9.9804,8.5504,0.0032,0.2516,3.7515,11.9867,3.7515,225.0545,10.1156,7.3402,6.9420,36.6922,32.8702,24.3317,0.9353,1.5340,3.5554,2.3178,1.6402,3.8016,3.2000
 1439.5000,2307.8054,-0.0230,5.7082,5.8899,5.7242,5.6693,5.6362,5.7134,5.8898,0.3269,2.6607,-0.2071,-0.4566,3.9583,12.7216,8.7299,8.7299,7.3336,0.0109,-0.6509,2.8807,11.1903,2.8807,169.7822,10.0045,11.1499,13.2719,43.8208,39.4880,29.4744,1.1399,1.7842,4.2738,2.3954,1.5652,3.7494,3.0000
 1440.0000,2330.3325,-0.0017,4.6652,4.6763,4.5722,4.5387,4.4703,4.6674,4.6763,0.3273,2.6355,-0.1126,-0.5566,3.7233,14.8469,10.6564,10.6564,9.2063,0.0204,0.8816,4.3594,12.5426,4.3594,213.8443,9.9703,12.3331,8.7207,63.0011,52.5292,39.6602,1.5412,2.2884,5.7160,2.4978,1.4849,3.7089,1.6000
 1440.5000,2356.0605,-0.0048,3.4722,3.4951,3.4232,3.4049,3.3497,3.4716,3.4951,0.3265,2.6076,0.0752,-0.4543,3.4028,19.4156,14.8865,14.8865,13.2809,0.0293,2.5726,5.9911,14.0346,5.9911,286.1122,10.0477,4.5056,3.1593,85.2024,66.2456,50.3101,1.9611,2.8146,7.2219,2.5659,1.4352,3.6826,3.2000
 1441.0000,2364.7441,-0.0061,2.9815,3.0066,2.9448,2.9318,2.8836,2.9813,3.0065,0.3257,2.5978,0.0298,-0.0962,3.2305,24.0453,19.2948,19.2948,17.4771,0.0285,3.1659,6.5636,14.5581,6.5636,332.6056,10.2390,3.1320,1.9907,98.3827,75.9717,57.5407,2.2419,3.2359,8.2647,2.5540,1.4434,3.6864,6.0000
 1441.5000,2314.0710,-0.0072,2.7662,2.7937,2.7369,2.7263,2.6823,2.7662,2.7937,0.3271,2.5901,0.0578,0.1125,3.1489,25.1059,20.3217,20.3217,18.4477,0.0209,3.6308,7.0122,14.9684,7.0122,357.9500,10.3454,2.2203,1.7816,102.3030,80.2742,60.6653,2.3576,3.4340,8.7423,2.5458,1.4566,3.7081,1.6000
 1442.0000,2305.8484,-0.0100,2.7634,2.8014,2.7453,2.7347,2.6899,2.7634,2.8014,0.3267,2.5910,0.2274,0.2865,3.1541,25.6908,20.8906,20.8906,18.9845,0.0185,3.5756,6.9589,14.9196,6.9589,356.9614,10.3968,2.3857,1.8929,101.7142,79.2569,59.7864,2.3216,3.4081,8.6242,2.5305,1.4680,3.7147,0.8000
 1442.5000,2368.0496,-0.0142,2.8558,2.9118,2.8554,2.8431,2.7947,2.8558,2.9118,0.3267,2.5834,0.0150,0.6800,3.2140,24.0081,19.2589,19.2589,17.4431,0.0188,4.0370,7.4041,15.3268,7.4042,343.4275,10.4482,3.5105,2.2121,98.9404,78.0880,58.9898,2.2934,3.3623,8.4965,2.5269,1.4661,3.7047,4.0000
 1443.0000,2392.0154,-0.0183,2.8475,2.9195,2.8667,2.8527,2.8035,2.8475,2.9195,0.3263,2.5519,-0.2417,0.4420,3.1860,23.8832,19.1384,19.1384,17.3290,0.0170,5.9438,9.2440,17.0093,9.2441,342.5242,10.4265,3.0491,2.5524,97.1087,77.1360,58.2358,2.2728,3.3435,8.3465,2.4963,1.4711,3.6723,3.2000
 1443.5000,2431.5171,-0.0220,2.7253,2.8081,2.7620,2.7468,2.6992,2.7253,2.8081,0.3255,2.5360,-0.0405,0.0850,3.0967,23.7656,19.0251,19.0251,17.2217,0.0149,6.9083,10.1746,17.8602,10.1747,356.1067,10.3836,2.1458,2.6246,98.0348,78.6418,59.4464,2.3328,3.4129,8.4593,2.4786,1.4630,3.6262,5.6000
 1444.0000,2415.8438,-0.0253,2.6477,2.7404,2.7002,2.6836,2.6352,2.6477,2.7404,0.3265,2.5526,0.0437,-0.0399,3.1177,23.7969,19.0553,19.0553,17.2503,0.0150,5.9040,9.2056,16.9741,9.2056,364.9128,10.3651,1.6323,1.9439,100.3714,82.1398,62.7074,2.4748,3.4844,8.8573,2.5420,1.4080,3.5790,4.8000
 1444.5000,2429.1677,-0.0277,2.6262,2.7270,2.6923,2.6743,2.6238,2.6262,2.7270,0.3260,2.5723,-0.2469,0.0383,3.2248,23.8243,19.0816,19.0816,17.2752,0.0167,4.7098,8.0533,15.9204,8.0533,366.7051,10.1659,2.7310,1.5962,102.6956,85.7531,66.3115,2.6278,3.5361,9.3149,2.6343,1.3456,3.5447,3.0000
 1445.0000,2370.6633,-0.0291,2.6294,2.7357,2.7067,2.6881,2.6365,2.6294,2.7357,0.3271,2.5798,-0.3148,0.2044,3.3105,23.0622,18.3486,18.3486,16.5804,0.0156,4.2544,7.6139,15.5186,7.6139,365.5334,10.2767,0.5913,1.2888,106.2010,88.5809,69.1937,2.7464,3.5562,9.6993,2.7275,1.2949,3.5317,4.0000
 1445.5000,2356.8782,-0.0265,2.6442,2.7414,2.7184,2.7002,2.6516,2.6442,2.7414,0.3284,2.5813,0.0401,-0.3878,3.3443,22.1535,17.4788,17.4788,15.7543,0.0129,4.1652,7.5278,15.4398,7.5278,364.7788,10.1102,2.3269,2.0758,111.0429,89.8948,70.8810,2.8215,3.5250,9.8970,2.8077,1.2493,3.5077,0.0000
 1446.0000,2366.6787,-0.0153,2.5141,2.5673,2.5521,2.5370,2.5017,2.5141,2.5673,0.3270,2.5704,0.4171,-0.4214,3.2755,23.0039,18.2926,18.2926,16.5273,0.0111,4.8230,8.1625,16.0202,8.1625,389.5122,10.1577,3.1866,2.5168,118.1697,92.9195,73.8003,2.9409,3.5717,10.2896,2.8809,1.2145,3.4988,4.0000
 1446.5000,2363.6274,0.0001,2.3489,2.3485,2.3403,2.3295,2.3114,2.3489,2.3485,0.3266,2.5495,0.3550,0.1874,3.1354,25.5372,20.7410,20.7410,18.8434,0.0087,6.0892,9.3843,17.1375,9.3843,425.8063,10.2699,2.9724,2.1235,122.9340,96.1525,76.7833,3.0588,3.6439,10.7102,2.9392,1.1913,3.5015,5.6000
 1447.0000,2313.8516,0.0062,2.2413,2.2220,2.2191,2.2119,2.2076,2.2413,2.2220,0.3253,2.5368,-0.1085,-0.1214,3.0286,26.9716,22.1433,22.1433,20.1636,0.0060,6.8626,10.1305,17.8199,10.1305,450.0409,10.3487,3.0245,1.9804,122.9180,97.6494,78.1273,3.1086,3.6896,10.9150,2.9584,1.1869,3.5112,0.8000
 1447.5000,2327.6604,0.0154,2.2332,2.1858,2.1867,2.1828,2.1888,2.2332,2.1858,0.3273,2.5370,-0.1896,-0.1926,3.0226,27.4621,22.6253,22.6253,20.6164,0.0049,6.8487,10.1172,17.8077,10.1172,457.4901,10.3904,3.1813,2.0053,121.2835,96.8247,77.1809,3.0617,3.7037,10.8267,2.9232,1.2097,3.5362,3.0000
 1448.0000,2356.9817,0.0212,2.2579,2.1921,2.1954,2.1950,2.2033,2.2579,2.1921,0.3262,2.5399,0.2440,0.4510,3.0993,29.1389,24.2835,24.2835,22.1702,0.0053,6.6755,9.9500,17.6548,9.9500,456.1776,10.4660,3.0794,2.0773,117.8789,93.8271,74.3328,2.9455,3.6516,10.4425,2.8597,1.2397,3.5452,5.6000
 1448.5000,2303.7634,0.0327,2.3188,2.2152,2.2201,2.2227,2.2401,2.3188,2.2152,0.3260,2.5434,0.2640,0.4969,3.1440,28.2656,23.4180,23.4180,21.3600,0.0075,6.4595,9.7416,17.4643,9.7417,451.4174,10.4730,2.9268,2.1463,114.8570,89.7468,70.5513,2.7943,3.5748,9.9177,2.7743,1.2793,3.5492,0.8000
 1449.0000,2252.2837,0.0344,2.3331,2.2234,2.2282,2.2333,2.2516,2.3331,2.2234,0.3266,2.5513,-0.1017,0.2519,3.1190,28.2261,23.3789,23.3789,21.3233,0.0112,5.9833,9.2821,17.0441,9.2821,449.7695,10.5018,2.8765,2.0779,115.4521,85.6855,66.8755,2.6503,3.5058,9.3936,2.6794,1.3228,3.5444,3.0000
 1449.5000,2175.6868,0.0267,2.3001,2.2160,2.2189,2.2252,2.2386,2.3001,2.2160,0.3268,2.5608,-0.2222,-0.0144,3.1747,28.3207,23.4724,23.4724,21.4109,0.0129,5.4035,8.7227,16.5325,8.7227,451.2696,10.4841,2.7403,2.0723,111.4221,79.8657,62.0564,2.4480,3.3478,8.7703,2.6197,1.3676,3.5826,2.4000
 1450.0000,2260.3228,0.0172,2.5155,2.4560,2.4549,2.4619,2.4716,2.5155,2.4560,0.3261,2.5659,-0.2968,-0.6220,3.3587,29.4540,24.5968,24.5968,22.4631,0.0249,5.0950,8.4250,16.2603,8.4250,407.1650,10.4598,2.8157,2.4623,98.9011,75.4145,58.2295,2.2792,3.2644,8.3141,2.5469,1.4322,3.6478,5.6000
 1450.5000,2272.0002,0.0195,2.7907,2.7161,2.7064,2.7113,2.7241,2.7915,2.7161,0.3270,2.5575,-0.1277,-0.8111,3.4430,28.1628,23.3164,23.3164,21.2647,0.0737,5.6076,8.9196,16.7126,8.9196,368.1750,10.4205,3.1775,1.6814,87.8460,73.1756,56.6601,2.1849,3.1909,8.2460,2.5842,1.4604,3.7741,0.0000
 1451.0000,2311.9746,0.0202,2.5256,2.4556,2.4391,2.4375,2.4510,2.5262,2.4556,0.3265,2.5437,0.1805,-0.1960,3.3631,29.1179,24.2627,24.2627,22.1507,0.1183,6.4413,9.7241,17.4482,9.7241,407.2343,10.8400,0.5197,0.7917,84.9303,72.3262,56.1904,2.1406,3.1517,8.3020,2.6341,1.4724,3.8784,4.0000
 1451.5000,2325.1265,-0.0062,2.3586,2.3790,2.3547,2.3453,2.3512,2.3585,2.3790,0.3278,2.5428,0.1565,0.3295,3.3978,26.3440,21.5284,21.5284,19.5852,0.0962,6.4956,9.7764,17.4961,9.7764,420.3519,11.0265,0.9215,1.0872,84.7046,70.3002,55.0452,2.0845,2.9965,8.1919,2.7338,1.4375,3.9299,2.4000
 1452.0000,2336.2866,-0.0076,2.9218,2.9526,2.9045,2.8766,2.8505,2.9484,2.9526,0.3273,2.5676,0.2979,0.3836,3.6746,20.2237,15.6472,15.6472,14.0085,0.0611,4.9922,8.3258,16.1696,8.3258,338.6864,10.4576,2.1424,1.7792,81.0323,62.5872,49.3180,1.8571,2.6157,7.3894,2.8250,1.4085,3.9790,1.6000
 1452.5000,2314.5320,-0.0242,4.3181,4.4631,4.3598,4.2778,4.1183,4.3724,4.4631,0.3283,2.6232,0.3664,0.5281,4.0816,14.9342,10.7361,10.7361,9.2836,0.0641,1.6239,5.0757,13.1976,5.0757,224.0599,10.1911,5.5891,4.7074,70.5848,52.1484,41.2576,1.5424,2.1469,6.2350,2.9042,1.3920,4.0426,5.0000
 1453.0000,2322.9727,-0.1051,6.1041,7.0060,6.8286,6.6708,6.2860,6.1846,7.0060,0.3278,2.6817,-0.2811,-0.1006,4.4183,11.1333,7.3075,7.3075,5.9437,0.0641,-1.9187,1.6573,10.0717,1.6574,142.7338,10.0022,31.0955,26.7102,53.1790,44.4160,35.3081,1.3024,1.8059,5.4190,3.0008,1.3865,4.1607,7.2000
 1453.5000,2344.2100,-0.1877,4.6840,5.9301,5.7785,5.6362,5.2437,4.7695,5.9301,0.3265,2.6698,-1.0785,-1.3309,4.4403,11.7634,7.8700,7.8700,6.4941,0.0593,-1.1981,2.3527,10.7075,2.3527,168.6322,10.1309,22.3458,17.2902,44.4445,42.1322,33.7552,1.2246,1.6895,5.2781,3.1241,1.3796,4.3100,1.6000
 1454.0000,2435.1453,-0.2197,3.6480,4.7858,4.6680,4.5449,4.2003,3.7199,4.7858,0.3264,2.5180,-1.0898,-1.1822,4.0726,18.6929,14.2093,14.2093,12.6319,0.1040,8.0013,11.2294,18.8247,11.2294,208.9495,10.1345,8.0073,4.7429,54.2184,47.4880,38.1283,1.3616,1.9123,6.0649,3.1716,1.4045,4.4543,7.0000
 1454.5000,2372.0457,-0.1856,2.2663,2.8624,2.8012,2.7293,2.5328,2.3012,2.8624,0.3262,2.2968,-0.4230,-0.3215,3.5492,32.4351,27.5879,27.5879,25.2492,0.1863,21.4076,24.1652,30.6538,24.1652,349.3589,10.2953,2.9594,0.9359,75.3928,57.3291,45.8177,1.6138,2.3575,7.3941,3.1364,1.4609,4.5819,1.6000
 1455.0000,2375.9495,-0.1463,1.5435,1.8625,1.8306,1.7872,1.6727,1.5613,1.8625,0.3272,2.1880,0.0010,0.1076,3.2078,40.8771,36.3174,36.3174,33.2820,0.2201,28.0026,30.5288,36.4728,30.5288,536.9127,11.3457,0.6751,0.7603,92.7155,68.5422,53.9782,1.8856,2.9487,8.7854,2.9794,1.5638,4.6593,0.8000
 1455.5000,2352.3638,-0.1235,1.3858,1.6269,1.6066,1.5726,1.4866,1.3999,1.6269,0.3275,2.2097,-0.0594,0.4529,3.0335,38.4727,33.7925,33.7925,30.9728,0.1758,26.6872,29.2595,35.3122,29.2595,614.6488,12.4676,0.6838,0.7175,97.7386,78.1947,60.7718,2.1168,3.4922,9.9199,2.8406,1.6498,4.6863,0.0000
 1456.0000,2386.0725,-0.1060,1.3691,1.5732,1.5597,1.5306,1.4626,1.3834,1.5732,0.3273,2.2290,-0.1924,0.4757,2.8522,37.2782,32.5496,32.5496,29.8320,0.1049,25.5147,28.1282,34.2777,28.1282,635.6530,13.0603,0.7142,0.7470,95.8311,82.3726,63.6750,2.2177,3.7183,10.3947,2.7955,1.6766,4.6871,0.0000
 1456.5000,2332.1860,-0.0787,1.4134,1.5691,1.5600,1.5342,1.4841,1.4292,1.5691,0.3265,2.2148,-0.1355,0.2563,2.6989,38.2789,33.5904,33.5904,30.7875,0.0526,26.3752,28.9585,35.0370,28.9585,637.3002,13.3611,0.6644,0.6894,93.0626,82.5466,63.7174,2.2261,3.7402,10.3690,2.7723,1.6802,4.6580,1.6000
 1457.0000,2375.6040,-0.0431,1.7198,1.8229,1.8144,1.7872,1.7498,1.7376,1.8229,0.3261,2.2318,0.0845,0.3522,2.7028,34.9705,30.1697,30.1697,27.6397,0.0353,25.3463,27.9657,34.1290,27.9657,548.5840,13.8591,0.4064,0.5743,89.0611,78.7835,61.0571,2.1285,3.5200,9.9582,2.8290,1.6538,4.6785,1.6000
 1457.5000,2374.4873,-0.0188,2.1664,2.2229,2.2119,2.1807,2.1467,2.1815,2.2229,0.3291,2.3461,0.4060,0.5970,3.0045,28.6652,23.8135,23.8135,21.7303,0.0507,18.4164,21.2790,28.0145,21.2790,449.8617,13.3894,0.3851,0.7483,78.9696,67.5097,52.5950,1.8335,2.9727,8.5781,2.8856,1.6214,4.6786,2.0000
 1458.0000,2330.8049,-0.0255,3.7416,3.8741,3.8462,3.7895,3.6930,3.7458,3.8741,0.3275,2.5213,0.7059,0.3904,3.5548,21.3741,16.7365,16.7365,15.0478,0.0630,7.7972,11.0324,18.6446,11.0324,258.1263,11.1821,10.9038,6.1571,60.7278,54.4523,42.8616,1.4915,2.3386,7.0032,2.9946,1.5680,4.6954,0.8000
 1458.5000,2380.9946,-0.0402,7.2984,7.7059,7.6342,7.5213,7.2793,7.2615,7.7059,0.3276,2.6289,0.6007,-0.1645,3.9123,16.3544,12.0388,12.0388,10.5434,0.0477,1.2818,4.7456,12.8957,4.7456,129.7711,10.6444,18.5192,12.1226,49.3694,47.7667,37.8415,1.3190,2.0234,6.1728,3.0507,1.5341,4.6801,0.8000
 1459.0000,2365.0322,-0.0403,7.6507,8.0794,7.9898,7.8819,7.5914,7.6360,8.0794,0.3280,2.6550,0.1146,-0.3792,3.8312,18.0282,13.5892,13.5892,12.0365,0.0325,-0.3042,3.2153,11.4963,3.2153,123.7715,10.6386,7.3011,5.1775,53.9222,49.2472,39.3519,1.3754,2.0381,6.4010,3.1407,1.4818,4.6538,4.0000
 1459.5000,2320.1982,-0.0235,5.3932,5.5690,5.4986,5.4316,5.2384,5.3938,5.5690,0.3271,2.6496,-0.0679,0.0597,3.6454,20.8392,16.2291,16.2291,14.5640,0.0284,0.0213,3.5293,11.7835,3.5294,179.5652,10.6660,4.2352,3.4796,65.8330,56.4034,45.2692,1.5925,2.2921,7.3149,3.1914,1.4393,4.5933,4.0000
 1460.0000,2308.7849,-0.0030,3.9204,3.9367,3.8857,3.8474,3.7488,3.9206,3.9367,0.3265,2.6261,0.1770,0.4439,3.5657,22.5269,17.8357,17.8357,16.0935,0.0218,1.4455,4.9036,13.0402,4.9036,254.0186,10.6808,3.1747,3.2710,77.7544,65.9497,52.8815,1.8674,2.6508,8.5112,3.2108,1.4195,4.5578,6.4000
 1460.5000,2384.6216,0.0112,3.1159,3.0678,3.0314,3.0099,2.9685,3.1159,3.0678,0.3257,2.5895,-0.0037,0.0871,3.4250,24.3252,19.5652,19.5652,17.7329,0.0146,3.6653,7.0455,14.9988,7.0455,325.9644,10.7126,2.8242,2.2885,90.4529,75.9758,60.3154,2.1510,3.0840,9.6076,3.1153,1.4338,4.4665,0.0000
 1461.0000,2396.9673,-0.0153,2.6503,2.7063,2.6749,2.6598,2.6540,2.6503,2.7063,0.3272,2.5524,-0.4750,-0.2941,3.1963,26.8634,22.0371,22.0371,20.0638,0.0096,5.9181,9.2192,16.9866,9.2192,369.5028,10.7815,3.5594,2.4081,103.2255,84.4919,66.1394,2.3909,3.5116,10.3828,2.9567,1.4687,4.3427,0.0000
 1461.5000,2371.3550,0.0139,2.6351,2.5847,2.5543,2.5415,2.5614,2.6351,2.5847,0.3268,2.5373,-0.1827,-0.2840,3.0408,26.4207,21.6034,21.6034,19.6558,0.0067,6.8285,10.0977,17.7899,10.0977,386.8987,10.8224,3.8566,2.3618,109.6645,89.8959,69.5616,2.5358,3.8295,10.8193,2.8253,1.5102,4.2667,1.6000
 1462.0000,2318.4121,0.0356,2.6746,2.5445,2.5145,2.5019,2.5358,2.6745,2.5445,0.3283,2.5315,0.3615,-0.3704,2.9680,26.2357,21.4224,21.4224,19.4855,0.0052,7.1795,10.4364,18.0996,10.4364,392.9993,10.8581,3.5910,2.0492,107.8712,88.2694,67.2594,2.4751,3.9009,10.3510,2.6535,1.5761,4.1820,0.8000
 1462.5000,2340.8359,0.0351,2.8834,2.7452,2.7112,2.6957,2.7333,2.8834,2.7452,0.3271,2.5416,0.2641,-0.3324,3.0247,24.0720,19.3206,19.3206,17.5015,0.0107,6.5706,9.8488,17.5623,9.8488,364.2693,10.8819,3.3865,2.0506,100.1448,78.9337,59.1045,2.1808,3.6491,9.0686,2.4852,1.6733,4.1584,0.0000
 1463.0000,2368.0608,0.0037,4.0240,4.0035,3.9371,3.9046,3.9400,4.0241,4.0035,0.3273,2.5880,-0.1645,0.0320,3.3667,20.7002,16.0976,16.0976,14.4385,0.0165,3.7596,7.1365,15.0820,7.1365,249.7785,10.8659,4.8404,3.1022,83.5911,64.7904,47.7228,1.7678,3.1083,7.2890,2.3450,1.7583,4.1231,0.0000
 1463.5000,2377.1245,-0.0206,6.2340,6.4119,6.2675,6.1939,6.1447,6.2344,6.4119,0.3281,2.6315,-0.3747,0.1608,3.8025,16.9625,12.6002,12.6002,11.0848,0.0052,1.1206,4.5901,12.7535,4.5901,155.9590,10.8649,12.5326,8.4422,60.9875,51.2171,37.1634,1.3916,2.5398,5.6053,2.2070,1.8251,4.0279,0.0000
 1464.0000,2360.7246,-0.0238,6.5978,6.8151,6.7057,6.6494,6.4840,6.5982,6.8151,0.3285,2.6474,-0.0979,0.1524,4.0343,16.1922,11.8895,11.8895,10.3992,-0.0070,0.1596,3.6628,11.9055,3.6628,146.7324,10.8642,15.1684,9.4941,50.4016,45.5220,32.9969,1.2499,2.2647,4.9089,2.1676,1.8119,3.9274,4.0000
 1464.5000,2322.3857,-0.0416,4.7076,4.9800,4.9103,4.8794,4.7554,4.7077,4.9800,0.3269,2.6112,0.1865,0.2659,4.0323,20.4363,15.8480,15.8480,14.2003,0.0029,2.3494,5.7757,13.8377,5.7757,200.8023,10.9071,8.9390,5.5450,57.1109,49.2411,35.9694,1.3719,2.4119,5.3068,2.2002,1.7581,3.8683,0.0000
 1465.0000,2381.9844,-0.0127,3.6963,3.7613,3.7146,3.6992,3.6245,3.6964,3.7613,0.3282,2.5076,-0.0227,0.2609,3.7515,23.6487,18.9124,18.9124,17.1150,0.0356,8.6326,11.8385,19.3817,11.8385,265.8653,10.9605,3.4015,2.3592,72.4334,62.1964,45.9330,1.7614,2.9714,6.7317,2.2655,1.6870,3.8219,4.0000
 1465.5000,2394.3074,0.0131,2.7285,2.6794,2.6549,2.6500,2.6203,2.7285,2.6794,0.3291,2.4476,-0.2463,0.3669,3.3526,25.9227,21.1168,21.1168,19.1976,0.0633,12.2671,15.3454,22.5886,15.3454,373.2225,11.0604,0.8919,0.8153,94.9219,75.7498,56.7827,2.1737,3.4840,8.3396,2.3936,1.6028,3.8366,3.0000
 1466.0000,2385.9116,0.0135,2.6148,2.5665,2.5443,2.5412,2.5200,2.6148,2.5665,0.3280,2.4987,-0.1275,0.5872,3.2393,25.7897,20.9871,20.9871,19.0754,0.0476,9.1707,12.3577,19.8565,12.3577,389.6393,11.0184,2.1392,2.0850,111.4501,82.6067,62.6141,2.3873,3.6965,9.2415,2.5001,1.5484,3.8711,4.8000
 1466.5000,2378.0693,0.0132,2.9996,2.9451,2.9162,2.9101,2.8823,3.0001,2.9451,0.3264,2.5699,0.0218,0.1554,3.3731,23.1855,18.4670,18.4670,16.6927,0.0110,4.8526,8.1911,16.0464,8.1911,339.5523,11.0530,3.1881,2.8436,107.3486,79.9266,60.9985,2.3144,3.5143,9.0566,2.5770,1.5184,3.9131,0.8000
 1467.0000,2348.2295,0.0093,3.3569,3.3140,3.2761,3.2612,3.2215,3.3597,3.3140,0.3279,2.6076,0.1586,-0.3787,3.5701,22.5198,17.8289,17.8289,16.0870,-0.0026,2.5718,5.9903,14.0339,5.9903,301.7462,11.1166,4.2979,2.9995,92.3666,71.2857,54.6210,2.0621,3.1005,8.1590,2.6315,1.5036,3.9567,3.0000
 1467.5000,2369.9617,0.0000,3.6301,3.6299,3.5818,3.5514,3.4924,3.6309,3.6299,0.3286,2.6291,0.3659,-0.2766,3.8356,21.5586,16.9120,16.9120,15.2149,0.0017,1.2672,4.7315,12.8828,4.7315,275.4898,11.1008,5.7381,3.6814,79.7021,63.7943,48.8784,1.8429,2.7581,7.3122,2.6512,1.4966,3.9677,8.8000
 1468.0000,2334.7549,-0.0177,3.6636,3.7532,3.6981,3.6530,3.5659,3.6698,3.7532,0.3273,2.6369,0.1166,-0.4061,3.9916,21.4801,16.8373,16.8373,15.1438,0.0040,0.7932,4.2741,12.4645,4.2741,266.4428,11.1197,4.7754,3.3011,74.3837,60.9133,46.7115,1.7591,2.6110,6.9983,2.6803,1.4843,3.9784,0.0000
 1468.5000,2365.3088,-0.0387,3.5133,3.7022,3.6415,3.5816,3.4627,3.5163,3.7022,0.3293,2.6280,-0.4917,-0.4426,3.9204,22.1649,17.4897,17.4897,15.7646,0.0011,1.3361,4.7979,12.9436,4.7979,270.1097,11.1291,4.3569,3.2157,76.4661,63.5543,48.8617,1.8241,2.6945,7.3959,2.7448,1.4771,4.0545,1.6000
 1469.0000,2358.6057,-0.0691,3.1556,3.4603,3.4000,3.3321,3.1818,3.1842,3.4603,0.3289,2.6008,-0.5778,0.1152,3.7011,22.9996,18.2885,18.2885,16.5235,-0.0056,2.9788,6.3831,14.3931,6.3831,288.9882,11.1411,6.0918,3.2783,83.3092,68.4559,52.6642,1.9485,2.8979,8.0553,2.7797,1.4873,4.1342,5.0000
 1469.5000,2370.3879,-0.1046,2.8185,3.2329,3.1754,3.1033,2.9207,2.8510,3.2329,0.3287,2.5646,-0.2363,0.0773,3.4452,23.4114,18.6841,18.6841,16.8986,-0.0113,5.1752,8.5024,16.3311,8.5024,309.3241,11.1888,4.7849,2.7136,91.1185,74.3554,57.1059,2.0806,3.1832,8.8874,2.7919,1.5300,4.2715,6.4000
 1470.0000,2358.0759,-0.1508,2.7902,3.3847,3.3267,3.2466,3.0187,2.8227,3.3847,0.3276,2.5444,-0.1503,-0.4701,3.3060,26.0007,21.1929,21.1929,19.2693,-0.0033,6.4027,9.6868,17.4141,9.6868,295.4476,11.2683,3.2989,2.1461,96.8830,78.1306,59.8134,2.1531,3.3916,9.4330,2.7813,1.5753,4.3812,3.2000
 1470.5000,2355.6580,-0.1798,2.9263,3.6716,3.6148,3.5289,3.2681,2.9614,3.6716,0.3288,2.5024,-0.2884,-0.5905,3.2083,26.8820,22.0553,22.0553,20.0809,0.0197,8.9483,12.1430,19.6602,12.1431,272.3628,11.2593,4.7009,2.9309,96.7411,79.3677,60.7262,2.1601,3.4778,9.6996,2.7890,1.6101,4.4904,2.0000
 1471.0000,2330.1943,-0.1613,2.1370,2.6246,2.5906,2.5348,2.3582,2.1597,2.6246,0.3283,2.3880,-0.2303,-0.5816,2.9782,30.8417,25.9831,25.9831,23.7567,0.0506,15.8783,18.8299,25.7750,18.8300,381.0058,11.2331,4.7410,1.5062,93.2865,80.1377,61.5256,2.1528,3.5176,9.9966,2.8419,1.6339,4.6435,4.0000
 1471.5000,2276.8027,-0.1221,1.5776,1.8489,1.8294,1.7955,1.6863,1.5924,1.8489,0.3277,2.2900,-0.2101,-0.3367,2.7256,35.7655,30.9863,30.9863,28.3931,0.0692,21.8210,24.5641,31.0185,24.5641,540.8531,12.0297,0.4198,0.6912,95.2101,84.4787,65.5546,2.2515,3.6494,10.8518,2.9736,1.6208,4.8197,2.4000
 1472.0000,2359.7349,-0.0871,1.5601,1.7507,1.7348,1.7082,1.6247,1.5759,1.7507,0.3284,2.2843,-0.2143,-0.0414,2.5965,36.9827,32.2433,32.2433,29.5504,0.0553,22.1633,24.8944,31.3205,24.8944,571.2074,12.7658,0.4948,0.6189,100.6908,88.2489,69.0908,2.3324,3.7873,11.6299,3.0708,1.6238,4.9863,3.0000
 1472.5000,2378.2302,-0.0567,1.8277,1.9722,1.9544,1.9297,1.8628,1.8470,1.9722,0.3285,2.3209,0.0036,0.1424,2.6239,34.6707,29.8626,29.8626,27.3560,0.0351,19.9436,22.7525,29.3619,22.7525,507.0489,12.7886,0.4544,0.5962,102.2459,89.1608,70.7980,2.3715,3.7416,12.0050,3.2085,1.5777,5.0622,3.2000
 1473.0000,2333.8450,-0.0252,2.3748,2.4577,2.4314,2.4047,2.3553,2.3969,2.4577,0.3286,2.3650,0.0544,0.7271,2.8274,34.0502,29.2286,29.2286,26.7698,0.0364,17.2709,20.1736,27.0037,20.1736,406.8893,12.9158,0.4922,0.5963,103.3183,87.1320,70.5137,2.3552,3.5193,11.9892,3.4067,1.4943,5.0906,3.2000
 1473.5000,2342.0337,-0.0064,2.8306,2.8557,2.8158,2.7863,2.7640,2.8498,2.8557,0.3270,2.4285,0.1817,0.6015,3.0903,29.5483,24.6907,24.6907,22.5508,0.0496,13.4234,16.4612,23.6089,16.4612,350.1733,12.8783,0.5916,0.7490,99.5140,81.2920,66.7799,2.2277,3.1628,11.3672,3.5940,1.4197,5.1026,2.0000
 1474.0000,2331.7373,-0.0241,3.6787,3.8016,3.7227,3.6780,3.6857,3.6912,3.8016,0.3267,2.5020,0.6128,0.0758,3.2913,24.4990,19.7333,19.7333,17.8919,0.0597,8.9722,12.1661,19.6813,12.1661,263.0500,12.3794,1.0659,1.1818,85.8180,70.3761,58.2943,1.9357,2.6654,9.9654,3.7388,1.3770,5.1483,0.8000
 1474.5000,2383.2979,-0.0261,6.6321,6.8718,6.6200,6.4996,6.5803,6.6385,6.8718,0.3275,2.5801,0.6789,0.1165,3.4829,18.6782,14.1957,14.1957,12.6188,0.0689,4.2378,7.5979,15.5040,7.5979,145.5217,11.4765,6.6506,5.2071,68.4310,56.4085,46.5916,1.5398,2.1332,7.9992,3.7499,1.3854,5.1950,3.2000
 1475.0000,2314.6929,-0.0402,12.3165,13.0053,12.1805,11.8361,12.1312,12.3500,13.0053,0.3287,2.6729,0.1960,-0.1734,3.7291,13.8740,9.7712,9.7712,8.3473,0.0762,-1.3889,2.1686,10.5392,2.1686,76.8919,10.8788,22.8522,16.8179,51.9728,46.0011,37.6142,1.2452,1.7727,6.4480,3.6374,1.4237,5.1785,0.0000
 1475.5000,2412.9072,-0.0894,23.1081,26.0059,23.2136,22.1198,22.7687,23.2628,26.0059,0.3278,2.7398,-0.1552,-0.4049,4.0563,10.0060,6.3070,6.3070,4.9622,0.0671,-5.4417,-1.7420,6.9632,-1.7420,38.4528,10.6466,28.3749,30.2899,45.4562,42.1800,34.2290,1.1358,1.6561,5.8550,3.5353,1.4582,5.1551,2.0000
 1476.0000,2338.8667,-0.1007,16.4948,18.8275,17.2215,16.5437,16.5561,16.5686,18.8275,0.3280,2.7337,-0.1217,-0.1788,4.3351,9.1605,5.5615,5.5615,4.2288,0.0484,-5.0742,-1.3874,7.2875,-1.3873,53.1137,10.5661,26.1340,27.8116,52.5714,49.3818,39.7677,1.3157,1.9835,6.8207,3.4388,1.5076,5.1843,1.6000
 1476.5000,2322.6624,-0.0593,6.6606,7.2121,6.8649,6.7112,6.6864,6.6693,7.2121,0.3290,2.6654,-0.0049,-0.1277,4.2140,11.5832,7.7089,7.7089,6.3366,0.0337,-0.9341,2.6074,10.9405,2.6074,138.6567,10.6309,23.0145,18.9129,70.8890,63.2113,50.5227,1.6607,2.6025,8.7163,3.3492,1.5671,5.2486,0.8000
 1477.0000,2329.8142,-0.0394,3.2368,3.4142,3.3025,3.2506,3.2429,3.2377,3.4142,0.3284,2.5906,-0.0480,-0.2171,3.6566,17.2847,12.8986,12.8986,11.3722,0.0239,3.6017,6.9841,14.9427,6.9841,292.8911,10.7140,5.8475,3.1604,96.3691,79.5186,62.8489,2.0433,3.3796,10.9497,3.2399,1.6540,5.3588,2.0000
 1477.5000,2369.4780,-0.0343,2.4509,2.5678,2.4898,2.4515,2.4512,2.4509,2.5678,0.3284,2.5528,-0.3004,-0.1189,3.1461,24.1573,19.4029,19.4029,17.5793,0.0173,5.8929,9.1949,16.9643,9.1949,389.4402,10.7593,3.2380,2.1555,115.7599,92.7952,72.6603,2.3452,4.0361,12.7399,3.1565,1.7210,5.4323,0.8000
 1478.0000,2424.6533,-0.0338,2.3086,2.4169,2.3397,2.2995,2.3040,2.3084,2.4169,0.3273,2.5398,-0.3380,0.3190,2.9788,27.2644,22.4309,22.4309,20.4339,0.0113,6.6762,9.9507,17.6555,9.9508,413.7470,10.8644,3.3864,1.9845,123.1053,100.8662,78.2415,2.5193,4.4786,13.7472,3.0695,1.7777,5.4568,1.6000
 1478.5000,2352.9746,-0.0239,2.3266,2.4036,2.3241,2.2803,2.2880,2.3264,2.4036,0.3290,2.5315,-0.1092,0.3314,2.9706,27.6097,22.7707,22.7707,20.7529,0.0060,7.1804,10.4372,18.1003,10.4372,416.0430,10.9263,3.4581,2.1738,125.8265,103.9104,80.3927,2.6039,4.6163,14.0521,3.0440,1.7728,5.3966,2.4000
 1479.0000,2321.1194,-0.0194,2.3518,2.4151,2.3357,2.2895,2.2983,2.3518,2.4151,0.3276,2.5304,-0.1211,-0.2688,2.9335,27.4232,22.5870,22.5870,20.5805,0.0028,7.2477,10.5021,18.1597,10.5021,414.0674,10.9605,3.6647,2.2345,129.6549,106.3267,82.0696,2.6790,4.7371,14.2464,3.0074,1.7682,5.3179,1.6000
 1479.5000,2330.1482,-0.0238,2.3729,2.4511,2.3733,2.3266,2.3334,2.3729,2.4511,0.3274,2.5358,-0.1808,-0.2886,2.8988,26.8844,22.0577,22.0577,20.0832,0.0024,6.9234,10.1892,17.8735,10.1892,407.9828,11.0522,3.7452,2.0481,130.6604,106.5301,81.8194,2.6853,4.7624,14.1341,2.9679,1.7735,5.2636,1.6000
 1480.0000,2320.1982,-0.0369,2.5033,2.6315,2.5507,2.5024,2.5029,2.5033,2.6315,0.3282,2.5450,0.1432,0.2230,2.9910,26.4691,21.6507,21.6507,19.7003,0.0038,6.3664,9.6518,17.3821,9.6518,380.0155,11.0550,3.9515,2.2554,129.3364,102.3536,78.2789,2.5688,4.5865,13.5237,2.9486,1.7855,5.2647,1.0000
 1480.5000,2327.9595,-0.0192,3.0657,3.1470,3.0516,2.9965,2.9801,3.0657,3.1470,0.3291,2.5612,0.5019,0.3783,3.2001,23.9105,19.1647,19.1647,17.3539,0.0060,5.3834,8.7033,16.5148,8.7033,317.7650,11.0055,3.9003,2.3438,120.6420,95.8730,73.2622,2.3952,4.2691,12.6993,2.9747,1.7823,5.3020,1.6000
 1481.0000,2332.6934,-0.0181,4.0578,4.1596,4.0401,3.9741,3.9141,4.0592,4.1596,0.3270,2.5825,0.4455,0.0213,3.2883,21.1678,16.5406,16.5406,14.8611,0.0087,4.0900,7.4552,15.3735,7.4552,240.4094,10.9978,5.0815,3.8005,105.4739,88.3012,67.4119,2.1985,3.9117,11.7111,2.9939,1.7793,5.3269,4.0000
 1481.5000,2380.1882,-0.0267,4.5700,4.7395,4.6296,4.5917,4.4920,4.5890,4.7395,0.3271,2.5920,-0.0057,-0.3372,3.1633,18.4592,13.9911,13.9911,12.4225,0.0103,3.5161,6.9015,14.8671,6.9015,210.9930,10.9822,7.2021,5.5993,94.9995,81.8664,62.2175,2.0262,3.6569,10.8222,2.9594,1.8048,5.3411,3.2000
 1482.0000,2330.4585,-0.0194,3.9245,4.0300,3.9641,3.9630,3.9622,3.9475,4.0300,0.3275,2.5822,-0.4045,-0.2722,3.0488,19.7132,15.1662,15.1662,13.5486,0.0088,4.1113,7.4758,15.3923,7.4758,248.1383,10.9863,6.8259,4.4534,92.6790,81.8278,61.3913,2.0006,3.7493,10.6722,2.8465,1.8741,5.3345,3.0000
 1482.5000,2339.9946,0.0100,3.1456,3.1023,3.0730,3.1036,3.0777,3.1325,3.1023,0.3279,2.5678,-0.4495,-0.1680,3.1237,24.0825,19.3307,19.3307,17.5110,0.0060,4.9828,8.3167,16.1613,8.3167,322.3441,11.0123,4.9898,3.3589,103.0748,86.7094,64.4142,2.0946,4.0410,11.2189,2.7762,1.9292,5.3560,2.0000
 1483.0000,2340.1792,0.0529,2.5532,2.3696,2.3674,2.4118,2.4261,2.4841,2.3696,0.3285,2.5460,-0.3530,-0.3509,3.2952,29.3002,24.4438,24.4438,22.3201,0.0035,6.3042,9.5917,17.3272,9.5917,422.0141,11.0677,4.0665,2.4478,119.5901,93.8492,68.8430,2.2160,4.4743,12.0973,2.7037,2.0191,5.4590,0.8000
 1483.5000,2321.7524,0.0997,2.2214,1.9242,1.9387,1.9854,2.0300,2.1032,1.9242,0.3281,2.4760,-0.2689,-0.1669,3.3805,34.1863,29.3674,29.3674,26.8982,0.0023,10.5444,13.6832,21.0686,13.6832,519.6865,11.1169,4.1019,2.1313,126.8418,98.5686,71.3587,2.2577,4.7965,12.7256,2.6531,2.1245,5.6365,1.6000
 1484.0000,2362.7175,0.1504,2.0749,1.6627,1.6871,1.7356,1.8064,1.9105,1.6627,0.3287,2.3836,-0.0710,0.2098,3.3332,36.0434,31.2726,31.2726,28.6570,0.0122,16.1470,19.0892,26.0121,19.0892,601.4169,11.1668,4.3238,2.1393,120.9373,97.8240,69.9471,2.1689,4.8672,12.6829,2.6058,2.2441,5.8476,1.6000
 1484.5000,2329.6072,0.2054,1.9927,1.4630,1.4930,1.5409,1.6312,1.7718,1.4630,0.3281,2.3900,0.1399,-0.0604,3.1979,34.0373,29.2154,29.2154,26.7576,0.0306,15.7595,18.7153,25.6702,18.7153,683.5181,11.2750,2.2191,1.0962,116.1400,94.2790,66.5080,2.0285,4.8078,12.2198,2.5417,2.3702,6.0242,3.2000
 1485.0000,2313.0801,0.2474,2.0856,1.4287,1.4682,1.5237,1.6465,1.8477,1.4287,0.3277,2.4608,0.1043,-0.2164,3.0173,28.5045,23.6544,23.6544,21.5814,0.0273,11.4692,14.5755,21.8845,14.5755,699.9255,11.3958,2.5442,1.9380,113.1137,89.3764,62.5532,1.8721,4.6347,11.6626,2.5164,2.4756,6.2296,2.4000
 1485.5000,2304.4426,0.2792,2.2423,1.4560,1.5081,1.5756,1.7408,2.0291,1.4560,0.3288,2.4626,0.1098,0.1915,2.8144,26.5288,21.7092,21.7092,19.7554,0.0039,11.3596,14.4698,21.7879,14.4698,686.8212,11.4336,5.8155,3.4583,100.9014,83.4937,57.9764,1.6974,4.3883,10.9882,2.5040,2.5852,6.4734,1.0000
 1486.0000,2318.7698,0.3198,2.3553,1.4259,1.4859,1.5590,1.7494,2.1048,1.4259,0.3288,2.4328,0.2823,0.0606,2.6452,25.3504,20.5593,20.5593,18.6719,-0.0054,13.1645,16.2113,23.3804,16.2113,701.3122,11.4688,6.1112,4.0367,90.5689,78.6113,54.0600,1.5493,4.1955,10.4048,2.4800,2.7080,6.7158,4.0000
 1486.5000,2289.8972,0.3487,2.2777,1.3108,1.3689,1.4361,1.6189,1.9835,1.3108,0.3291,2.4377,0.1412,-0.4241,2.6057,24.2349,19.4779,19.4779,17.6503,0.0022,12.8671,15.9244,23.1180,15.9244,762.8848,11.4931,6.2751,4.6336,88.5356,74.6145,50.5404,1.4239,4.0716,9.8440,2.4177,2.8595,6.9136,4.8000
 1487.0000,2270.3887,0.3533,1.9702,1.1247,1.1717,1.2237,1.3707,1.6782,1.1247,0.3286,2.4408,-0.2156,-0.3702,2.6579,24.3961,19.6337,19.6337,17.7977,0.0138,12.6814,15.7452,22.9542,15.7452,889.1436,11.5107,6.7677,4.5807,85.8368,72.4821,48.9316,1.3562,3.9650,9.6368,2.4305,2.9237,7.1060,2.0000
 1487.5000,2303.8208,0.3382,1.6166,0.9477,0.9831,1.0209,1.1319,1.3716,0.9477,0.3280,2.4092,-0.3336,-0.1261,2.6258,25.3801,20.5882,20.5882,18.6992,0.0269,14.5931,17.5898,24.6410,17.5898,1055.1492,11.4500,4.9400,2.9042,83.6464,70.5131,47.5720,1.3136,3.8489,9.3923,2.4402,2.9301,7.1502,1.0000
 1488.0000,2319.8643,0.3190,1.3823,0.8381,0.8664,0.8961,0.9858,1.1835,0.8381,0.3280,2.3689,-0.2280,0.0628,2.4912,26.1724,21.3606,21.3606,19.4273,0.0377,17.0335,19.9446,26.7942,19.9446,1193.1390,11.4570,3.1247,1.6100,83.1370,69.3204,46.8456,1.2866,3.7766,9.2816,2.4577,2.9353,7.2140,0.8000
 1488.5000,2330.1370,0.3129,1.3300,0.8149,0.8413,0.8689,0.9532,1.1415,0.8149,0.3278,2.3482,-0.0076,0.1196,2.4235,26.5368,21.7170,21.7170,19.7628,0.0412,18.2917,21.1587,27.9045,21.1587,1227.1211,11.4722,3.3806,1.5796,82.5767,69.9181,47.3608,1.3050,3.8084,9.3638,2.4587,2.9184,7.1755,0.8000
 1489.0000,2287.2026,0.3235,1.4738,0.8865,0.9162,0.9475,1.0428,1.2559,0.8865,0.3283,2.3482,0.1992,-0.1142,2.4931,26.7476,21.9235,21.9235,19.9570,0.0366,18.2933,21.1602,27.9059,21.1602,1128.0868,11.5076,2.8903,1.4397,83.8784,73.6013,49.8867,1.3752,4.0238,9.8600,2.4504,2.9259,7.1697,1.6000
 1489.5000,2303.5789,0.3285,1.7412,1.0384,1.0756,1.1159,1.2357,1.5016,1.0384,0.3298,2.3693,0.2270,-0.4229,2.5643,26.4341,21.6165,21.6165,19.6682,0.0307,17.0141,19.9259,26.7771,19.9259,963.0406,11.5469,3.6440,2.2847,87.0412,77.9954,53.1707,1.4738,4.2473,10.4708,2.4653,2.8818,7.1045,2.4000
 1490.0000,2342.7244,0.3115,1.9838,1.2186,1.2632,1.3136,1.4590,1.7727,1.2186,0.3283,2.3977,0.1015,-0.3676,2.5429,25.8744,21.0696,21.0696,19.1532,0.0272,15.2890,18.2613,25.2550,18.2614,820.6443,11.6023,4.7890,3.5121,91.7877,81.3028,56.0756,1.5727,4.3618,10.9559,2.5118,2.7735,6.9664,3.0000
 1490.5000,2338.2097,0.2823,2.1068,1.3606,1.4064,1.4614,1.6141,1.9278,1.3606,0.3304,2.4218,0.0661,0.3132,2.5828,25.6652,20.8657,20.8657,18.9609,0.0241,13.8309,16.8544,23.9685,16.8544,734.9449,11.6170,5.2627,3.3252,97.1560,81.8370,57.2904,1.6394,4.2883,11.0381,2.5740,2.6157,6.7329,4.8000
 1491.0000,2320.3816,0.2483,2.1007,1.4371,1.4763,1.5283,1.6632,1.9312,1.4371,0.3279,2.4481,0.1698,0.6508,2.8060,24.8906,20.1127,20.1127,18.2504,0.0216,12.2375,15.3168,22.5625,15.3169,695.8378,11.6585,5.9466,4.1264,102.4618,82.9248,58.7366,1.7229,4.2682,11.1170,2.6046,2.4773,6.4524,0.8000
 1491.5000,2313.7830,0.2186,2.0821,1.4960,1.5256,1.5720,1.6803,1.9019,1.4960,0.3276,2.4729,-0.0446,-0.1577,3.0018,25.8012,20.9982,20.9982,19.0859,0.0176,10.7337,13.8659,21.2356,13.8659,668.4575,11.6416,6.5927,3.2960,107.3484,86.9553,62.5374,1.8731,4.3440,11.6530,2.6825,2.3192,6.2213,4.0000
 1492.0000,2378.1030,0.1920,2.1261,1.5949,1.6150,1.6573,1.7416,1.9340,1.5949,0.3280,2.4945,-0.5374,-0.6110,2.9803,27.4141,22.5781,22.5781,20.5721,0.0164,9.4264,12.6044,20.0821,12.6044,626.9824,11.6284,5.0627,2.3693,112.4017,92.1800,67.4391,2.0467,4.4240,12.4390,2.8117,2.1615,6.0776,0.8000
 1492.5000,2359.4807,0.1464,2.2130,1.7846,1.7945,1.8357,1.9007,2.0780,1.7846,0.3288,2.5142,-0.4908,0.1214,2.9282,28.8889,24.0353,24.0353,21.9379,0.0151,8.2312,11.4511,19.0275,11.4511,560.3539,11.6133,4.3956,2.2628,115.1907,98.8074,73.5736,2.2641,4.5388,13.4223,2.9572,2.0046,5.9282,1.6000
 1493.0000,2362.6714,0.0890,2.3404,2.0598,2.0565,2.0972,2.1427,2.3021,2.0598,0.3283,2.5280,0.0237,0.6566,3.0347,29.7325,24.8743,24.8743,22.7223,0.0098,7.3923,10.6417,18.2873,10.6417,485.4812,11.6504,4.4242,2.5447,118.4660,103.4739,78.3519,2.4382,4.5582,14.1658,3.1077,1.8695,5.8099,1.6000
 1493.5000,2370.4216,0.0380,2.4565,2.3291,2.3107,2.3471,2.3705,2.4765,2.3291,0.3282,2.5375,0.1516,0.5353,3.2198,30.4085,25.5492,25.5492,23.3523,0.0097,6.8182,10.0877,17.7807,10.0877,429.3526,11.6456,4.4978,2.5743,126.3449,106.4663,81.4322,2.5800,4.5915,14.5049,3.1591,1.7797,5.6222,4.0000
 1494.0000,2381.6851,-0.0025,2.4683,2.4769,2.4461,2.4714,2.4777,2.4862,2.4769,0.3272,2.5466,0.0238,-0.0664,3.3240,31.0495,26.1916,26.1916,23.9509,0.0130,6.2660,9.5549,17.2935,9.5549,403.7228,11.6678,4.6408,2.3313,130.9293,108.4885,83.9157,2.7077,4.5708,14.7146,3.2193,1.6881,5.4344,3.2000
 1494.5000,2325.3110,-0.0115,2.4664,2.5055,2.4665,2.4802,2.4781,2.4766,2.5055,0.3280,2.5588,0.0768,-0.4781,3.3303,30.9861,26.1280,26.1280,23.8916,0.0137,5.5290,8.8437,16.6432,8.8438,399.1257,11.6712,4.5724,2.5146,130.8478,109.8567,86.1300,2.8208,4.4737,14.9050,3.3317,1.5860,5.2839,5.6000
 1495.0000,2336.4014,-0.0125,2.4033,2.4447,2.4024,2.4073,2.4042,2.4024,2.4447,0.3292,2.5647,-0.0277,0.0764,3.3309,31.1134,26.2558,26.2558,24.0107,0.0127,5.1693,8.4967,16.3259,8.4967,409.0470,11.6831,4.4977,2.3521,132.2977,110.9451,88.1569,2.9220,4.3486,15.0907,3.4702,1.4882,5.1645,1.0000
 1495.5000,2401.5862,-0.0132,2.3024,2.3445,2.3029,2.3017,2.3014,2.3013,2.3445,0.3280,2.5594,-0.2546,0.3590,3.3183,30.8184,25.9597,25.9597,23.7349,0.0113,5.4927,8.8087,16.6112,8.8087,426.5230,11.7000,4.5184,2.4540,135.9604,112.1163,90.3283,3.0116,4.2014,15.3787,3.6603,1.3951,5.1065,0.8000
 1496.0000,2344.1987,-0.0095,2.2254,2.2546,2.2156,2.2108,2.2145,2.2254,2.2546,0.3286,2.5490,-0.2373,0.1957,3.2730,30.4779,25.6186,25.6186,23.4170,0.0094,6.1242,9.4181,17.1684,9.4181,443.5319,11.7111,3.9695,2.3372,135.6558,113.3451,92.4006,3.1058,4.0931,15.6122,3.8143,1.3179,5.0267,3.0000
 1496.5000,2340.2253,0.0049,2.2206,2.2055,2.1695,2.1628,2.1704,2.2206,2.2055,0.3279,2.5364,-0.1149,0.1145,3.2729,32.3203,27.4718,27.4718,25.1414,0.0076,6.8838,10.1510,17.8387,10.1511,453.4190,11.7090,3.9416,2.0852,132.9614,114.7936,93.9228,3.1946,4.0854,15.6909,3.8407,1.2788,4.9116,4.8000
 1497.0000,2311.8486,0.0112,2.2019,2.1678,2.1361,2.1286,2.1396,2.2019,2.1678,0.3287,2.5308,-0.0091,-0.0621,3.3249,32.8676,28.0258,28.0258,25.6556,0.0072,7.2249,10.4802,18.1396,10.4802,461.2866,11.7128,3.5389,2.2411,134.2497,115.4744,94.8927,3.2767,4.0415,15.6200,3.8649,1.2334,4.7669,0.8000
 1497.5000,2372.6563,0.0141,2.2056,2.1629,2.1353,2.1280,2.1419,2.2056,2.1629,0.3262,2.5359,0.0940,0.2781,3.3259,32.5645,27.7188,27.7188,25.3707,0.0074,6.9128,10.1790,17.8642,10.1790,462.3524,11.6898,3.3643,2.1401,136.8121,115.8808,94.9292,3.3133,4.0810,15.4587,3.7880,1.2317,4.6657,3.0000
 1498.0000,2356.8894,0.0161,2.2151,2.1660,2.1429,2.1364,2.1526,2.2151,2.1660,0.3285,2.5446,0.2187,0.3078,3.3024,32.5222,27.6760,27.6760,25.3310,0.0081,6.3882,9.6728,17.4013,9.6728,461.6759,11.6967,3.7390,1.8795,137.9112,116.5467,95.2981,3.3404,4.1063,15.4511,3.7628,1.2293,4.6255,4.8000
 1498.5000,2278.9565,0.0182,2.1967,2.1419,2.1233,2.1184,2.1360,2.1967,2.1419,0.3286,2.5504,0.3585,-0.6536,3.3447,32.9359,28.0952,28.0952,25.7199,0.0094,6.0388,9.3357,17.0931,9.3357,466.8851,11.7124,3.7225,1.8300,138.6535,117.8842,96.0680,3.3628,4.1812,15.5978,3.7304,1.2434,4.6384,0.8000
 1499.0000,2408.3230,0.0209,2.1590,2.0972,2.0827,2.0792,2.0975,2.1590,2.0972,0.3281,2.5499,0.4255,-0.8030,3.3629,31.9453,27.0931,27.0931,24.7896,0.0098,6.0693,9.3651,17.1200,9.3651,476.8234,11.7376,3.7138,1.7463,139.0747,118.1081,96.4893,3.3684,4.1347,15.7095,3.7994,1.2275,4.6638,1.6000
 1499.5000,2442.2859,0.0242,2.1338,2.0631,2.0510,2.0488,2.0671,2.1338,2.0631,0.3287,2.5425,0.2800,-0.0224,3.3472,32.1241,27.2736,27.2736,24.9573,0.0101,6.5180,9.7981,17.5159,9.7981,484.7113,11.7500,3.4403,1.6371,140.7636,118.3264,96.8967,3.3909,4.0715,15.7365,3.8651,1.2007,4.6408,1.0000
 1500.0000,2456.5322,0.0269,2.1318,2.0532,2.0418,2.0403,2.0575,2.1318,2.0532,0.3279,2.5377,-0.2196,0.3533,3.3822,32.5300,27.6840,27.6840,25.3384,0.0105,6.8032,10.0732,17.7675,10.0733,487.0351,11.8141,3.4630,1.8327,141.1713,117.8522,96.7180,3.4086,3.9937,15.5938,3.9046,1.1717,4.5748,3.2000
 1500.5000,2425.4597,0.0289,2.1598,2.0742,2.0616,2.0600,2.0776,2.1598,2.0742,0.3292,2.5438,-0.6540,0.3751,3.3368,33.0432,28.2040,28.2040,25.8208,0.0098,6.4386,9.7214,17.4458,9.7214,482.1028,11.8570,3.3495,1.7379,139.8107,117.4584,96.3419,3.4180,3.9552,15.4256,3.9001,1.1572,4.5131,0.8000
 1501.0000,2463.2690,0.0297,2.2003,2.1109,2.0953,2.0929,2.1113,2.2003,2.1109,0.3276,2.5494,-0.4847,0.1443,3.1716,32.1082,27.2575,27.2575,24.9424,0.0103,6.0956,9.3904,17.1431,9.3905,473.7238,11.8696,3.4539,1.6513,137.7703,116.9278,95.8720,3.4157,3.9220,15.2825,3.8966,1.1482,4.4742,1.0000
 1501.5000,2392.2920,0.0197,2.2745,2.2129,2.1925,2.1882,2.2020,2.2745,2.2129,0.3285,2.5439,0.1754,0.3467,3.1260,30.3446,25.4853,25.4853,23.2926,0.0100,6.4296,9.7128,17.4379,9.7128,451.8892,11.8817,3.5711,1.7283,135.9520,111.9962,91.9197,3.2660,3.7489,14.6947,3.9198,1.1479,4.4994,0.8000
 1502.0000,2338.5203,-0.0119,2.5705,2.6127,2.5806,2.5726,2.5714,2.5705,2.6127,0.3299,2.5461,0.6430,0.5333,3.3550,27.8292,22.9870,22.9870,20.9558,0.0126,6.2953,9.5832,17.3194,9.5832,382.7500,11.8249,3.7420,2.2175,126.5840,101.9813,83.6052,2.9580,3.4531,13.4252,3.8879,1.1674,4.5387,5.6000
 1502.5000,2380.0264,0.0032,3.4257,3.4104,3.3550,3.3393,3.2974,3.4257,3.4104,0.3275,2.5758,0.3571,0.0578,3.7473,25.2516,20.4632,20.4632,18.5813,0.0230,4.4964,7.8474,15.7321,7.8474,293.2199,11.7024,4.8308,3.1803,106.0618,90.1347,73.7955,2.5885,3.0956,11.9563,3.8624,1.1959,4.6191,3.0000
 1503.0000,2398.8455,-0.0245,4.3997,4.5491,4.4694,4.4455,4.3390,4.3997,4.5491,0.3288,2.6063,-0.3207,-0.0511,3.9466,24.1278,19.3744,19.3744,17.5524,0.0173,2.6485,6.0643,14.1016,6.0643,219.8213,11.5954,6.0572,5.1314,87.3651,81.1508,66.2471,2.3097,2.8363,10.7995,3.8076,1.2280,4.6756,3.2000
 1503.5000,2398.6721,-0.0329,3.8093,3.9831,3.9113,3.8930,3.7983,3.8093,3.9831,0.3280,2.5875,-0.7726,-0.1782,3.7721,28.0382,23.1933,23.1933,21.1493,0.0015,3.7907,7.1664,15.1094,7.1664,251.0592,11.5772,3.4598,1.4918,85.3059,79.5314,64.5765,2.2441,2.8298,10.5621,3.7325,1.2610,4.7065,2.0000
 1504.0000,2304.1436,-0.0207,3.2238,3.3161,3.2559,3.2443,3.1748,3.2214,3.3161,0.3289,2.5397,-0.6256,-0.3572,3.4752,31.8689,27.0161,27.0161,24.7180,0.0607,6.6840,9.9583,17.6624,9.9583,301.5555,11.7870,0.8198,0.9540,98.0723,84.5424,68.1390,2.3527,3.0492,11.2169,3.6787,1.2960,4.7676,7.0000
 1504.5000,2291.9937,0.0001,2.9224,2.9219,2.8737,2.8690,2.8286,2.9188,2.9219,0.3280,2.5325,0.0042,-0.1633,3.2799,32.4500,27.6029,27.6029,25.2631,0.1862,7.1235,10.3823,18.0502,10.3824,342.2407,12.2189,1.0271,1.2216,112.3205,91.6619,73.3963,2.5157,3.3397,12.1706,3.6442,1.3276,4.8379,5.6000
 1505.0000,2376.4678,0.0104,2.8610,2.8201,2.7797,2.7813,2.7604,2.8579,2.8201,0.3285,2.5488,0.4965,0.0558,3.2710,31.3530,26.4966,26.4966,24.2348,0.2127,6.1346,9.4281,17.1776,9.4281,354.5951,11.9272,1.3487,1.4135,118.6069,97.8089,77.5543,2.6325,3.6571,12.9820,3.5498,1.3892,4.9315,2.4000
 1505.5000,2318.6665,-0.0052,2.8930,2.9138,2.8772,2.8869,2.8845,2.8828,2.9138,0.3293,2.5343,0.4947,0.1341,3.3707,29.4292,24.5722,24.5722,22.4400,0.1172,7.0148,10.2775,17.9543,10.2775,343.1929,11.7612,2.1220,1.7652,118.0686,100.0087,78.5566,2.6405,3.8485,13.2733,3.4490,1.4575,5.0269,6.0000
 1506.0000,2325.1726,0.0490,3.1561,2.9456,2.9176,2.9370,2.9750,3.1056,2.9456,0.3288,2.5236,0.2357,0.1281,3.3842,27.8454,23.0030,23.0030,20.9709,0.0481,7.6586,10.8987,18.5223,10.8987,339.4918,11.4672,3.6404,1.9607,118.5284,100.3509,78.0430,2.5955,3.9983,13.3178,3.3309,1.5404,5.1310,2.4000
 1506.5000,2324.8049,0.1070,3.4886,2.9885,2.9705,3.0020,3.0945,3.3913,2.9885,0.3282,2.5608,0.0933,0.2459,3.3953,24.5987,19.8299,19.8299,17.9831,0.0369,5.4078,8.7268,16.5363,8.7269,334.6117,11.5230,4.7455,2.9403,118.4001,98.7860,76.5399,2.5137,4.0029,13.2123,3.3007,1.5924,5.2561,4.8000
 1507.0000,2350.6250,0.1449,3.7414,3.0243,3.0206,3.0661,3.2229,3.6599,3.0243,0.3284,2.5858,0.1109,0.1629,3.4465,22.0282,17.3592,17.3592,15.6406,0.0247,3.8912,7.2634,15.1981,7.2634,330.6518,11.3578,4.3973,3.2579,111.3720,92.8890,71.5625,2.3310,3.8255,12.4445,3.2530,1.6411,5.3387,1.6000
 1507.5000,2331.3572,0.1713,3.7399,2.9002,2.9129,2.9682,3.1683,3.6678,2.9002,0.3287,2.5644,0.1949,-0.4346,3.3073,21.5289,16.8837,16.8837,15.1880,0.0136,5.1909,8.5175,16.3449,8.5175,344.8094,11.1707,6.7115,4.1354,101.3109,88.8673,68.1717,2.2121,3.7246,11.8951,3.1937,1.6838,5.3774,4.8000
 1508.0000,2322.9268,0.1928,3.5169,2.6350,2.6598,2.7169,2.9237,3.4001,2.6350,0.3280,2.5413,0.2286,-0.5984,3.0274,21.3634,16.7264,16.7264,15.0381,0.0157,6.5875,9.8651,17.5772,9.8652,379.5119,11.0066,16.9973,7.5959,99.4534,86.3670,66.1620,2.1458,3.6530,11.5492,3.1616,1.7024,5.3822,6.4000
 1508.5000,2303.2224,0.2142,3.0955,2.2403,2.2683,2.3174,2.4955,2.9103,2.2403,0.3281,2.5252,0.1704,0.0876,2.9177,22.0295,17.3605,17.3605,15.6418,0.0148,7.5651,10.8085,18.4398,10.8085,446.3726,11.0232,7.1196,5.7140,105.9449,86.1676,65.7889,2.1310,3.6946,11.4971,3.1118,1.7338,5.3952,0.0000
 1509.0000,2299.3298,0.2271,2.8139,1.9937,2.0230,2.0672,2.2268,2.6029,1.9937,0.3290,2.5044,-0.0543,0.4360,2.9254,24.4059,19.6432,19.6432,17.8067,0.0098,8.8269,12.0259,19.5531,12.0260,501.5848,11.0390,5.6736,3.9775,109.1078,88.8278,67.6930,2.1801,3.8330,11.8897,3.1020,1.7582,5.4539,3.2000
 1509.5000,2214.8083,0.2335,2.6460,1.8550,1.8853,1.9270,2.0766,2.4360,1.8550,0.3288,2.4819,-0.0567,0.4759,2.8091,24.9129,20.1344,20.1344,18.2709,0.0100,10.1855,13.3369,20.7519,13.3369,539.0825,11.0197,6.3534,3.3042,107.4804,88.3912,66.7348,2.1334,3.8938,11.7963,3.0295,1.8252,5.5292,2.4000
 1510.0000,2092.3643,0.2370,2.5544,1.7806,1.8116,1.8518,1.9960,2.3543,1.7806,0.3280,2.4715,0.3876,0.5869,2.7474,24.4334,19.6698,19.6698,17.8318,0.0131,10.8186,13.9477,21.3105,13.9477,561.6010,11.0225,5.2687,2.7704,104.7815,85.7937,63.9785,2.0184,3.8799,11.4367,2.9477,1.9223,5.6662,3.0000
 1510.5000,2142.9216,0.2388,2.5193,1.7510,1.7822,1.8214,1.9628,2.3281,1.7510,0.3285,2.4791,0.5110,0.2841,2.9529,24.9592,20.1792,20.1792,18.3132,0.0156,10.3562,13.5016,20.9025,13.5016,571.1075,11.0515,5.8857,3.4321,98.2462,82.7686,61.0603,1.8924,3.8437,11.0763,2.8817,2.0311,5.8532,4.8000
 1511.0000,2225.0701,0.2391,2.5374,1.7626,1.7938,1.8326,1.9734,2.3450,1.7626,0.3283,2.4826,0.3161,-0.0440,3.1286,24.8265,20.0505,20.0505,18.1916,0.0158,10.1460,13.2987,20.7170,13.2987,567.3536,11.0682,5.9244,3.6870,93.2776,82.2161,60.3640,1.8326,3.8783,11.1312,2.8701,2.1163,6.0741,3.2000
 1511.5000,2277.5281,0.2378,2.5522,1.7767,1.8065,1.8439,1.9801,2.3378,1.7767,0.3274,2.4791,0.2802,-0.1938,3.0135,24.1049,19.3523,19.3523,17.5315,0.0131,10.3547,13.5001,20.9012,13.5001,562.8314,11.0790,6.4809,3.5980,99.3766,85.2343,62.3963,1.8658,4.0536,11.6412,2.8718,2.1726,6.2393,0.0000
 1512.0000,2350.8782,0.2182,2.5708,1.8485,1.8774,1.9149,2.0495,2.3945,1.8485,0.3287,2.4892,-0.0424,-0.5428,2.8611,23.8785,19.1338,19.1338,17.3247,0.0111,9.7474,12.9141,20.3653,12.9141,540.9806,11.1238,6.5372,3.4912,110.1721,90.4870,65.7646,1.9620,4.3501,12.2909,2.8255,2.2171,6.2644,2.0000
 1512.5000,2370.9636,0.1875,2.5690,1.9413,1.9684,2.0059,2.1351,2.4578,1.9413,0.3284,2.5049,-0.4861,-0.4796,2.8598,24.9534,20.1736,20.1736,18.3079,0.0104,8.7949,11.9951,19.5249,11.9951,515.1144,11.1844,6.5487,3.6144,115.1559,94.9347,67.9945,2.0493,4.6693,12.6092,2.7004,2.2785,6.1529,0.0000
 1513.0000,2348.5173,0.1516,2.5686,2.0544,2.0787,2.1160,2.2346,2.5254,2.0544,0.3282,2.5078,-0.3167,-0.0510,2.8553,25.5627,20.7658,20.7658,18.8668,0.0060,8.6209,11.8272,19.3714,11.8272,486.7495,11.2201,6.1837,3.3836,116.2524,98.0317,69.2058,2.1161,4.9277,12.6903,2.5753,2.3287,5.9971,6.4000
 1513.5000,2326.2095,0.1192,2.5657,2.1576,2.1774,2.2133,2.3131,2.5610,2.1576,0.3288,2.5140,-0.0551,0.1220,2.8146,26.9051,22.0780,22.0780,20.1023,0.0013,8.2449,11.4643,19.0396,11.4643,463.4843,11.2841,6.0491,3.1631,121.2139,101.4958,70.7397,2.1835,5.2208,12.8739,2.4659,2.3910,5.8959,0.0000
 1514.0000,2402.0125,0.1029,2.5732,2.2182,2.2318,2.2645,2.3390,2.5381,2.2182,0.3291,2.5343,-0.1349,0.3755,2.8347,27.2844,22.4505,22.4505,20.4523,0.0037,7.0146,10.2772,17.9540,10.2772,450.8083,11.2873,5.5199,2.9994,125.5116,104.6775,72.6587,2.2591,5.4123,13.1456,2.4288,2.3958,5.8190,1.6000
 1514.5000,2380.8215,0.0881,2.5620,2.2578,2.2647,2.2935,2.3436,2.4997,2.2578,0.3297,2.5462,-0.0745,0.5636,2.8852,27.7487,22.9077,22.9077,20.8814,0.0070,6.2896,9.5777,17.3143,9.5777,442.9139,11.3378,4.7772,2.9935,128.6815,107.5733,74.5628,2.3314,5.5749,13.4281,2.4087,2.3913,5.7597,2.4000
 1515.0000,2380.2568,0.0657,2.5358,2.3099,2.3106,2.3358,2.3662,2.4869,2.3099,0.3297,2.5455,0.1507,0.2246,2.9320,27.5490,22.7109,22.7109,20.6968,0.0091,6.3335,9.6200,17.3531,9.6200,432.9257,11.3396,4.6319,2.3451,134.9608,109.2233,75.9663,2.4013,5.6168,13.5573,2.4137,2.3391,5.6458,3.0000
 1515.5000,2383.2283,0.0401,2.5435,2.4041,2.3989,2.4214,2.4366,2.5207,2.4041,0.3283,2.5420,0.2724,-0.2606,3.0361,27.9999,23.1555,23.1555,21.1138,0.0141,6.5459,9.8249,17.5405,9.8250,415.9579,11.3433,4.7865,2.4729,139.9231,109.5663,76.5820,2.4533,5.5626,13.5129,2.4292,2.2674,5.5081,2.4000
 1516.0000,2423.5366,0.0088,2.5417,2.5109,2.5002,2.5200,2.5231,2.5295,2.5109,0.3299,2.5384,0.1363,-0.1240,3.1926,28.7595,23.9069,23.9069,21.8179,0.0184,6.7644,10.0358,17.7332,10.0358,398.2653,11.3516,4.9096,2.6412,138.1209,110.6916,77.7544,2.5250,5.5531,13.5578,2.4415,2.1993,5.3695,0.8000
 1516.5000,2443.8403,0.0095,2.6575,2.6229,2.6072,2.6242,2.6182,2.6576,2.6229,0.3287,2.5367,-0.2129,-0.1298,3.2921,29.2235,24.3675,24.3675,22.2487,0.0186,6.8650,10.1329,17.8221,10.1329,381.2559,11.3891,4.9098,2.6652,134.5075,109.9465,77.3459,2.5382,5.4853,13.3611,2.4358,2.1611,5.2641,0.0000
 1517.0000,2386.3840,0.0120,2.6694,2.6252,2.6065,2.6200,2.6087,2.6700,2.6252,0.3278,2.5363,-0.2862,-0.5803,3.2644,29.2551,24.3990,24.3990,22.2782,0.0163,6.8929,10.1598,17.8467,10.1598,380.9189,11.4201,4.7687,2.6435,132.1477,109.2580,76.9734,2.5482,5.4246,13.1910,2.4317,2.1288,5.1766,5.6000
 1517.5000,2414.3008,0.0102,2.6278,2.5910,2.5708,2.5814,2.5683,2.6276,2.5910,0.3283,2.5362,-0.0467,-0.4255,3.1723,29.4313,24.5742,24.5742,22.4420,0.0131,6.8961,10.1629,17.8495,10.1629,385.9479,11.4490,4.6065,2.6364,129.2918,109.1078,77.0950,2.5675,5.3857,13.1393,2.4397,2.0976,5.1175,2.4000
 1518.0000,2383.7354,0.0090,2.6039,2.5717,2.5507,2.5594,2.5459,2.6039,2.5717,0.3286,2.5356,0.0415,0.0292,3.1148,29.5119,24.6545,24.6545,22.5170,0.0090,6.9316,10.1971,17.8808,10.1971,388.8458,11.4600,4.2779,2.4692,127.0015,108.5714,77.3065,2.5888,5.2601,13.1081,2.4920,2.0319,5.0635,7.0000
 1518.5000,2411.6172,0.0086,2.6368,2.6055,2.5836,2.5912,2.5776,2.6368,2.6055,0.3302,2.5375,-0.1243,0.2549,3.0913,29.2323,24.3763,24.3763,22.2569,0.0072,6.8186,10.0882,17.7811,10.0882,383.8051,11.4409,4.3521,2.3366,126.4225,109.7152,78.7647,2.6528,5.2145,13.2832,2.5474,1.9657,5.0072,3.2000
 1519.0000,2402.2195,0.0089,2.6865,2.6536,2.6311,2.6381,2.6248,2.6865,2.6536,0.3299,2.5413,-0.2902,0.1861,3.0651,30.6914,25.8325,25.8325,23.6163,0.0079,6.5885,9.8661,17.5781,9.8661,376.8519,11.4210,5.0183,2.7208,125.2100,108.6230,78.2724,2.6525,5.0956,13.1227,2.5753,1.9210,4.9472,7.2000
 1519.5000,2369.9729,0.0096,2.6850,2.6495,2.6278,2.6343,2.6222,2.6850,2.6495,0.3300,2.5420,-0.2020,0.1470,3.0606,30.3427,25.4834,25.4834,23.2909,0.0069,6.5442,9.8233,17.5390,9.8234,377.4298,11.4150,4.4862,2.5020,124.8442,106.3021,76.9783,2.6122,4.9423,12.8892,2.6079,1.8920,4.9343,7.2000
 1520.0000,2448.9541,0.0100,2.6701,2.6332,2.6127,2.6189,2.6084,2.6701,2.6332,0.3289,2.5437,-0.0309,0.2341,3.0846,29.5649,24.7072,24.7072,22.5662,0.0038,6.4451,9.7278,17.4516,9.7278,379.7624,11.3903,4.3980,2.2615,127.1327,104.2573,75.5819,2.5635,4.8506,12.6615,2.6103,1.8922,4.9391,4.0000
 1520.5000,2372.3335,0.0094,2.6675,2.6329,2.6133,2.6196,2.6106,2.6675,2.6329,0.3281,2.5489,0.1155,-0.1378,3.0716,29.1800,24.3243,24.3243,22.2084,0.0032,6.1280,9.4217,17.1717,9.4217,379.8141,11.4022,4.4348,2.4098,126.0656,103.5397,75.3610,2.5634,4.7790,12.5896,2.6344,1.8643,4.9114,4.0000
 1521.0000,2358.8589,0.0078,2.7023,2.6732,2.6543,2.6607,2.6525,2.7023,2.6732,0.3300,2.5506,0.2304,-0.4314,3.0525,29.9056,25.0468,25.0468,22.8835,0.0042,6.0216,9.3191,17.0779,9.3191,374.0871,11.4100,4.5196,2.3964,125.9148,104.5642,76.6923,2.6291,4.7263,12.7152,2.6903,1.7977,4.8364,6.0000
 1521.5000,2365.0547,0.0065,2.7760,2.7513,2.7327,2.7396,2.7315,2.7760,2.7513,0.3300,2.5439,0.0161,0.2657,3.1009,29.2090,24.3531,24.3531,22.2353,0.0028,6.4311,9.7142,17.4392,9.7142,363.4621,11.4231,4.5299,2.5490,127.0604,105.2873,77.6952,2.6904,4.6811,12.7534,2.7245,1.7399,4.7403,4.8000
 1522.0000,2424.9761,0.0064,2.8604,2.8353,2.8172,2.8246,2.8161,2.8604,2.8353,0.3300,2.5430,-0.3054,0.4532,3.1371,29.4725,24.6152,24.6152,22.4803,0.0018,6.4843,9.7656,17.4862,9.7656,352.6983,11.4559,4.6573,2.5963,129.3596,106.5054,79.0649,2.7591,4.6759,12.8773,2.7539,1.6947,4.6672,2.4000
 1522.5000,2433.7981,0.0064,2.8664,2.8412,2.8246,2.8327,2.8242,2.8664,2.8412,0.3305,2.5525,-0.3126,-0.3201,3.1325,29.5453,24.6877,24.6877,22.5480,0.0016,5.9096,9.2110,16.9791,9.2111,351.9683,11.4537,5.0758,2.7853,130.5337,107.9884,81.1708,2.8378,4.6309,13.1956,2.8495,1.6318,4.6499,7.0000
 1523.0000,2405.7205,0.0050,2.7460,2.7270,2.7134,2.7218,2.7147,2.7460,2.7270,0.3288,2.5550,-0.1683,-0.2919,3.1657,30.2634,25.4041,25.4041,23.2169,0.0016,5.7577,9.0644,16.8450,9.0644,366.7000,11.4435,5.1899,2.5594,131.8756,110.3364,83.9616,2.9292,4.6338,13.6786,2.9519,1.5819,4.6697,1.6000
 1523.5000,2382.4568,0.0035,2.5961,2.5837,2.5731,2.5820,2.5764,2.5961,2.5837,0.3294,2.5536,-0.0920,-0.1364,3.2175,32.2875,27.4387,27.4387,25.1106,0.0045,5.8432,9.1469,16.9205,9.1470,387.0368,11.4682,4.4906,2.1782,134.5798,112.4327,86.9878,3.0286,4.5402,14.2010,3.1278,1.4991,4.6890,3.2000
 1524.0000,2378.7825,0.0041,2.5179,2.5036,2.4954,2.5053,2.5004,2.5179,2.5036,0.3300,2.5590,-0.1280,-0.2055,3.2422,33.7782,28.9513,28.9513,26.5131,0.0087,5.5171,8.8323,16.6327,8.8323,399.4271,11.4986,4.1320,2.0550,133.6466,113.4342,88.7781,3.0844,4.4411,14.5241,3.2704,1.4398,4.7089,4.8000
 1524.5000,2326.0139,0.0072,2.4799,2.4555,2.4496,2.4609,2.4557,2.4799,2.4555,0.3312,2.5674,-0.0403,0.0452,3.2570,33.8360,29.0101,29.0101,26.5676,0.0125,5.0049,8.3381,16.1808,8.3381,407.2533,11.5447,4.0511,2.0752,133.7688,113.2294,89.4770,3.1090,4.3206,14.6369,3.3877,1.3897,4.7079,1.0000
 1525.0000,2249.4282,0.0109,2.4522,2.4155,2.4117,2.4246,2.4190,2.4522,2.4155,0.3296,2.5754,0.2973,0.0777,3.2791,32.7603,27.9172,27.9172,25.5548,0.0165,4.5201,7.8703,15.7531,7.8703,413.9958,11.6114,4.2600,2.0860,134.0204,113.1656,89.9063,3.1285,4.2585,14.6854,3.4485,1.3612,4.6941,4.0000
 1525.5000,2344.5901,0.0132,2.4396,2.3954,2.3935,2.4079,2.4022,2.4396,2.3954,0.3302,2.5753,0.5352,0.1149,3.3082,33.0468,28.2077,28.2077,25.8242,0.0183,4.5263,7.8763,15.7585,7.8763,417.4658,11.6245,4.4540,2.3193,133.0898,112.1761,89.4269,3.1074,4.2133,14.6282,3.4719,1.3559,4.7075,2.4000
 1526.0000,2353.0208,0.0122,2.4318,2.3909,2.3904,2.4063,2.4014,2.4318,2.3909,0.3309,2.5669,0.3830,0.2677,3.3371,32.5700,27.7244,27.7244,25.3759,0.0162,5.0339,8.3660,16.2063,8.3660,418.2476,11.6298,4.1931,2.0464,135.8824,112.7789,89.9657,3.1369,4.2647,14.6653,3.4388,1.3595,4.6752,9.0000
 1526.5000,2272.1274,0.0055,2.3735,2.3555,2.3557,2.3720,2.3695,2.3735,2.3555,0.3300,2.5549,-0.0573,0.3781,3.3612,33.0721,28.2333,28.2333,25.8480,0.0130,5.7664,9.0728,16.8527,9.0728,424.5411,11.5919,4.2767,2.0538,136.7612,112.9688,90.4259,3.1550,4.2444,14.7304,3.4706,1.3453,4.6689,3.2000
 1527.0000,2314.9807,0.0054,2.3460,2.3287,2.3289,2.3446,2.3455,2.3460,2.3287,0.3289,2.5330,-0.2546,0.4941,3.3737,32.1450,27.2947,27.2947,24.9769,0.0096,7.0901,10.3501,18.0207,10.3501,429.4240,11.5725,4.1753,2.0453,133.7554,114.1210,91.8354,3.1997,4.2219,14.9814,3.5485,1.3195,4.6822,0.8000
 1527.5000,2356.2102,0.0127,2.3273,2.2867,2.2859,2.2996,2.3042,2.3273,2.2867,0.3306,2.5165,-0.0280,0.3504,3.3496,32.9530,28.1124,28.1124,25.7359,0.0066,8.0906,11.3155,18.9035,11.3155,437.3126,11.4506,3.8378,1.8443,135.2088,114.3795,92.3513,3.2113,4.1547,15.0956,3.6334,1.2938,4.7007,2.4000
 1528.0000,2373.3704,0.0216,2.3594,2.2893,2.2866,2.2972,2.3057,2.3594,2.2893,0.3297,2.5171,0.2019,-0.1127,3.2976,33.8626,29.0373,29.0373,26.5928,0.0035,8.0529,11.2791,18.8702,11.2791,436.8057,11.4075,3.9155,2.1203,136.7211,113.9801,92.2393,3.1917,4.0834,15.1521,3.7107,1.2794,4.7474,0.0000
 1528.5000,2352.5945,0.0253,2.4057,2.3221,2.3165,2.3226,2.3347,2.4057,2.3221,0.3318,2.5307,0.1746,-0.3979,3.2810,32.9496,28.1090,28.1090,25.7327,0.0022,7.2292,10.4843,18.1434,10.4843,430.6371,11.3453,3.9584,2.0823,136.0109,113.7269,91.8656,3.1748,4.1037,15.1095,3.6819,1.2926,4.7593,4.0000
 1529.0000,2415.6592,0.0040,2.3627,2.3496,2.3404,2.3406,2.3459,2.3627,2.3496,0.3294,2.5477,-0.0547,-0.0337,3.2798,32.3001,27.4514,27.4514,25.1225,0.0034,6.1994,9.4907,17.2348,9.4907,425.5999,11.3025,4.1730,2.0663,133.7982,113.8283,91.9126,3.1745,4.1499,15.1261,3.6450,1.3072,4.7648,1.0000
 1529.5000,2397.5891,0.0180,2.4033,2.3438,2.3312,2.3248,2.3359,2.4033,2.3438,0.3287,2.5505,-0.3555,0.2280,3.2184,32.2858,27.4369,27.4369,25.1090,0.0008,6.0333,9.3304,17.0882,9.3304,426.6563,11.3222,3.9873,2.0527,132.9712,113.2283,91.1203,3.1654,4.1968,14.9092,3.5526,1.3258,4.7101,4.8000
 1530.0000,2375.2825,-0.0040,2.2774,2.2901,2.2754,2.2632,2.2662,2.2774,2.2901,0.3298,2.5477,-0.3967,-0.2099,3.1703,34.4425,29.6292,29.6292,27.1403,-0.0008,6.1999,9.4912,17.2352,9.4912,436.6566,11.3619,3.1837,2.1741,133.8973,114.3591,91.5585,3.1987,4.3208,14.8953,3.4473,1.3508,4.6567,2.4000
 1530.5000,2373.3469,0.0025,2.2844,2.2767,2.2606,2.2437,2.2347,2.2844,2.2767,0.3301,2.5476,0.0031,-0.2688,3.2203,34.3586,29.5434,29.5434,27.0610,0.0101,6.2079,9.4989,17.2423,9.4989,439.2379,11.4925,2.3131,2.0367,134.1596,113.7427,90.7355,3.1779,4.3254,14.7235,3.4039,1.3611,4.6331,2.0000
 1531.0000,2353.4807,-0.0059,2.2859,2.3045,2.2884,2.2682,2.2456,2.2859,2.3045,0.3280,2.5506,0.1643,0.1108,3.2780,37.2860,32.5576,32.5576,29.8394,0.0386,6.0264,9.3237,17.0821,9.3237,433.9386,11.6706,1.3180,1.4239,132.0924,112.3661,89.1945,3.1275,4.3281,14.4565,3.3401,1.3839,4.6224,5.0000
 1531.5000,2346.3862,-0.0142,2.2683,2.3127,2.2990,2.2782,2.2456,2.2683,2.3127,0.3294,2.5480,-0.2272,0.2304,3.2816,38.4231,33.7408,33.7408,30.9254,0.0645,6.1842,9.4759,17.2213,9.4759,432.3929,12.3163,1.1710,1.4511,125.4054,109.8518,86.7599,3.0417,4.3200,14.0638,3.2555,1.4202,4.6236,2.4000
 1532.0000,2308.1057,-0.0198,2.2518,2.3135,2.3038,2.2851,2.2507,2.2518,2.3135,0.3295,2.5224,-0.5702,-0.2785,3.2752,38.5822,33.9069,33.9069,31.0776,0.0661,7.7332,10.9706,18.5881,10.9706,432.2459,12.7177,1.1584,1.0561,122.4130,106.0475,83.5885,2.9269,4.2144,13.5668,3.2191,1.4399,4.6351,2.0000
 1532.5000,2370.9175,-0.0198,2.2303,2.2913,2.2866,2.2722,2.2485,2.2303,2.2913,0.3312,2.4701,-0.4029,-1.0490,3.2233,43.1461,38.7279,38.7279,35.4765,0.0635,10.9033,14.0295,21.3853,14.0295,436.4243,13.3268,0.8891,0.8444,121.5395,104.3095,82.2528,2.8706,4.1588,13.3952,3.2210,1.4487,4.6663,0.0000
 1533.0000,2363.9265,-0.0055,2.0402,2.0557,2.0559,2.0478,2.0493,2.0402,2.0557,0.3295,2.3907,0.3074,-0.9477,3.1469,43.5397,39.1487,39.1487,35.8586,0.0830,15.7179,18.6752,25.6335,18.6752,486.4553,14.1941,0.9430,0.7879,116.2703,104.7083,83.0839,2.8986,4.0974,13.5355,3.3034,1.4136,4.6697,4.0000
 1533.5000,2349.1506,0.0233,1.8278,1.7693,1.7718,1.7690,1.7910,1.8279,1.7693,0.3305,2.3007,0.6236,-0.5404,3.1317,45.3431,41.0871,41.0871,37.6155,0.1198,21.1698,23.9357,30.4439,23.9357,565.1865,15.3483,0.7101,0.7290,112.1091,108.2596,86.0340,3.0053,4.2092,13.9984,3.3257,1.4006,4.6580,6.0000
 1534.0000,2397.0256,0.0010,1.6748,1.6725,1.6756,1.6753,1.6751,1.6750,1.6725,0.3294,2.1980,0.3022,-0.2090,3.0763,40.1357,35.5356,35.5356,32.5682,0.1413,27.3924,29.9400,35.9345,29.9401,597.9012,16.3799,0.4072,0.6891,111.7843,110.8061,87.7929,3.0770,4.3483,14.2355,3.2738,1.4131,4.6264,4.0000
 1534.5000,2403.1641,0.0013,1.5961,1.5932,1.5952,1.5957,1.5960,1.5962,1.5932,0.3318,2.1711,0.3875,0.6633,3.0605,34.7299,29.9232,29.9232,27.4120,0.1435,29.0257,31.5160,37.3756,31.5160,627.6768,16.3124,0.5900,0.6905,112.6970,104.7410,82.4713,2.9097,4.1675,13.2818,3.1870,1.4323,4.5647,0.0000
 1535.0000,2441.5605,-0.0025,1.8660,1.8726,1.8694,1.8676,1.8667,1.8661,1.8726,0.3304,2.3574,0.8260,1.0649,3.5382,27.4488,22.6123,22.6123,20.6042,0.1399,17.7321,20.6187,27.4106,20.6187,534.0215,14.8526,0.7829,0.8190,102.6519,88.5092,69.1517,2.4422,3.6021,11.1252,3.0885,1.4750,4.5555,2.0000
 1535.5000,2379.2671,0.0036,3.8569,3.8375,3.8125,3.7997,3.8320,3.8550,3.8375,0.3294,2.6073,0.7189,0.4761,4.4579,19.7092,15.1624,15.1624,13.5450,0.1091,2.5852,6.0032,14.0457,6.0032,260.5852,11.2108,14.8680,8.6603,78.8616,72.0781,56.1505,1.9910,2.9490,8.9955,3.0504,1.4811,4.5180,2.4000
 1536.0000,2411.0874,0.0661,6.1585,5.6070,5.5363,5.4981,5.6796,6.1521,5.6070,0.3293,2.6906,-0.1754,0.0530,4.9019,18.5396,14.0661,14.0661,12.4945,0.0701,-2.4620,1.1332,9.5924,1.1332,178.3493,10.7031,14.6491,9.2815,71.8856,71.7198,55.2595,1.9647,3.0104,8.8279,2.9325,1.5323,4.4932,2.4000
 1536.5000,2394.3423,0.0264,3.9178,3.7762,3.7355,3.7172,3.7625,3.9161,3.7762,0.3300,2.6381,-0.7557,0.1185,4.4454,23.7645,19.0239,19.0239,17.2206,0.0568,0.7236,4.2069,12.4031,4.2070,264.8193,10.7219,6.0006,3.6346,94.5909,83.9709,64.2288,2.2916,3.5817,10.2229,2.8542,1.5630,4.4611,4.0000
 1537.0000,2401.2522,-0.0091,2.8604,2.8963,2.8651,2.8526,2.8569,2.8599,2.8963,0.3313,2.5766,-0.2852,0.0547,3.7768,28.9662,24.1120,24.1120,22.0098,0.0489,4.4515,7.8041,15.6925,7.8041,345.2717,10.8597,4.5152,2.3169,122.2943,99.0054,74.7719,2.6895,4.3228,11.7978,2.7292,1.6073,4.3867,4.0000
 1537.5000,2417.4553,-0.0099,2.6379,2.6739,2.6421,2.6308,2.6204,2.6379,2.6739,0.3292,2.5529,0.1176,-0.2719,3.4306,31.4850,26.6293,26.6293,24.3583,0.0348,5.8828,9.1851,16.9554,9.1851,373.9873,10.8366,4.3278,2.2677,133.6252,108.3613,81.1766,2.9396,4.8135,12.7146,2.6414,1.6375,4.3253,4.8000
 1538.0000,2385.8081,0.0027,2.6728,2.6630,2.6283,2.6177,2.6002,2.6729,2.6630,0.3301,2.5477,-0.1792,-0.1746,3.3106,31.5968,26.7419,26.7419,24.4630,0.0246,6.2022,9.4933,17.2372,9.4933,375.5151,10.8875,4.4374,2.3398,134.8546,111.0375,83.0509,3.0217,4.9577,12.9408,2.6103,1.6407,4.2827,2.4000
 1538.5000,2371.0547,0.0049,2.7103,2.6919,2.6554,2.6456,2.6265,2.7104,2.6919,0.3299,2.5465,-0.3982,-0.0762,3.2510,32.0214,27.1700,27.1700,24.8610,0.0197,6.2712,9.5599,17.2981,9.5599,371.4908,10.8750,4.5872,2.4882,135.9199,111.0629,83.2102,3.0375,4.9569,12.9178,2.6060,1.6319,4.2527,4.0000
 1539.0000,2395.0901,0.0038,2.7293,2.7150,2.6784,2.6695,2.6528,2.7293,2.7150,0.3298,2.5502,-0.3832,-0.1588,3.2244,31.3869,26.5307,26.5307,24.2665,0.0155,6.0460,9.3426,17.0994,9.3426,368.3233,10.8925,4.6006,2.4838,135.0411,110.6202,83.3971,3.0412,4.8433,12.9619,2.6762,1.5926,4.2622,7.2000
 1539.5000,2396.1846,-0.0001,2.7311,2.7313,2.6957,2.6876,2.6753,2.7311,2.7313,0.3312,2.5541,-0.3163,0.2143,3.2717,32.8892,28.0477,28.0477,25.6759,0.0116,5.8136,9.1184,16.8944,9.1184,366.1213,10.8825,4.5039,2.3394,134.5245,109.9444,83.3167,3.0424,4.7305,12.9295,2.7332,1.5548,4.2497,3.2000
 1540.0000,2366.5640,-0.0075,2.7261,2.7542,2.7200,2.7126,2.7053,2.7261,2.7542,0.3307,2.5580,-0.0196,0.1620,3.3627,31.8356,26.9825,26.9825,24.6868,0.0093,5.5754,8.8885,16.6842,8.8885,363.0771,10.9400,4.7069,2.5283,138.0014,109.4602,83.4626,3.0388,4.6285,12.9947,2.8075,1.5231,4.2762,4.0000
 1540.5000,2408.4502,-0.0115,2.7103,2.7533,2.7216,2.7151,2.7118,2.7103,2.7533,0.3301,2.5623,0.1642,-0.1188,3.4369,31.4231,26.5671,26.5671,24.3004,0.0067,5.3177,8.6398,16.4568,8.6398,363.2043,10.9808,4.7965,2.5951,140.3166,110.7365,85.1792,3.0955,4.5888,13.2894,2.8960,1.4824,4.2931,4.8000
 1541.0000,2411.2021,-0.0097,2.6951,2.7312,2.7029,2.6979,2.6963,2.6951,2.7312,0.3302,2.5594,0.1214,0.1791,3.4796,31.3596,26.5032,26.5032,24.2409,0.0037,5.4886,8.8047,16.6075,8.8047,366.1363,11.0167,4.5782,2.4440,140.2622,111.9459,86.9387,3.1484,4.5398,13.6163,2.9993,1.4419,4.3248,6.0000
 1541.5000,2380.2917,-0.0086,2.6720,2.7037,2.6791,2.6761,2.6734,2.6720,2.7037,0.3300,2.5494,0.3081,0.4500,3.4721,32.0852,27.2343,27.2343,24.9208,0.0011,6.0949,9.3898,17.1426,9.3898,369.8673,11.0286,4.6521,2.5180,138.9953,113.0286,88.3378,3.1988,4.4933,13.8367,3.0794,1.4047,4.3256,5.0000
 1542.0000,2406.9871,-0.0009,2.6714,2.6749,2.6541,2.6535,2.6477,2.6714,2.6749,0.3292,2.5438,0.5996,0.2011,3.4194,32.1715,27.3215,27.3215,25.0018,-0.0005,6.4370,9.7199,17.4444,9.7199,373.8475,11.0331,4.6838,2.3887,137.6338,113.3803,89.3652,3.2197,4.3828,14.0752,3.2115,1.3613,4.3716,6.4000
 1542.5000,2388.1577,0.0100,2.6967,2.6594,2.6423,2.6443,2.6337,2.6967,2.6594,0.3299,2.5446,0.4109,-0.0740,3.3792,32.4454,27.5983,27.5983,25.2589,-0.0022,6.3897,9.6742,17.4026,9.6742,376.0195,11.0155,4.6364,2.7489,136.4382,112.2524,88.4584,3.1855,4.3143,13.9395,3.2310,1.3544,4.3759,0.8000
 1543.0000,2457.7524,0.0130,2.6867,2.6387,2.6252,2.6298,2.6138,2.6867,2.6387,0.3284,2.5497,0.0423,-0.0338,3.4029,31.4925,26.6369,26.6369,24.3654,-0.0034,6.0781,9.3736,17.1277,9.3736,378.9676,10.9815,5.4241,3.4178,134.9917,112.1862,88.0898,3.1600,4.3194,13.9396,3.2272,1.3669,4.4113,4.0000
 1543.5000,2371.1931,0.0115,2.6030,2.5617,2.5519,2.5585,2.5389,2.6030,2.5617,0.3299,2.5594,-0.0068,0.0555,3.4480,32.2782,27.4293,27.4293,25.1019,-0.0014,5.4882,8.8044,16.6073,8.8044,390.3656,10.9212,5.5248,3.0799,136.2767,111.4758,86.7834,3.0980,4.3720,13.8046,3.1575,1.4112,4.4560,4.0000
 1544.0000,2362.0383,0.0097,2.5148,2.4814,2.4749,2.4829,2.4616,2.5148,2.4814,0.3312,2.5702,0.0055,0.2588,3.4635,32.9171,28.0761,28.0761,25.7022,0.0017,4.8344,8.1735,16.0303,8.1735,403.0011,10.9509,4.6938,2.4169,136.5956,111.6155,86.2320,3.0658,4.4419,13.7764,3.1015,1.4489,4.4937,5.6000
 1544.5000,2382.5715,0.0092,2.5339,2.5017,2.4978,2.5074,2.4847,2.5339,2.5017,0.3294,2.5744,-0.0982,0.4121,3.5050,32.2983,27.4496,27.4496,25.1208,0.0038,4.5811,7.9291,15.8068,7.9291,399.7233,10.9527,4.4474,2.2469,135.9984,111.4779,85.8006,3.0177,4.4858,13.8626,3.0903,1.4865,4.5938,1.0000
 1545.0000,2390.1270,0.0102,2.5979,2.5615,2.5602,2.5713,2.5483,2.5979,2.5615,0.3303,2.5721,-0.2844,0.2049,3.5844,32.0404,27.1891,27.1891,24.8788,0.0075,4.7231,8.0662,15.9322,8.0662,390.3904,10.9647,4.3186,2.1461,135.7664,111.6920,86.2013,3.0096,4.4778,14.0330,3.1339,1.4879,4.6628,3.2000
 1545.5000,2382.2498,0.0112,2.5686,2.5289,2.5302,2.5418,2.5216,2.5686,2.5289,0.3307,2.5738,-0.2839,-0.3603,3.6054,31.9958,27.1441,27.1441,24.8370,0.0105,4.6180,7.9647,15.8394,7.9647,395.4211,10.9834,4.3338,2.1944,134.2363,114.2881,88.3507,3.0534,4.5958,14.5310,3.1618,1.5052,4.7590,3.2000
 1546.0000,2348.2869,0.0121,2.4785,2.4374,2.4410,2.4525,2.4368,2.4785,2.4374,0.3290,2.5771,-0.0962,-0.6276,3.5194,33.6709,28.8419,28.8419,26.4119,0.0096,4.4164,7.7702,15.6616,7.7703,410.2729,10.9962,4.6396,2.3395,134.5950,114.4875,88.8461,3.0369,4.5805,14.7720,3.2250,1.5083,4.8642,3.0000
 1546.5000,2418.3079,0.0135,2.3755,2.3315,2.3371,2.3484,2.3380,2.3755,2.3315,0.3285,2.5763,-0.0941,-0.0918,3.3896,33.1889,28.3519,28.3519,25.9579,0.0083,4.4657,7.8177,15.7050,7.8177,428.9142,11.0057,4.7133,2.4068,136.4043,114.9091,89.8029,3.0375,4.5254,15.0832,3.3330,1.4898,4.9656,2.4000
 1547.0000,2379.9924,0.0150,2.2906,2.2433,2.2507,2.2620,2.2572,2.2906,2.2433,0.3300,2.5762,-0.2047,0.6107,3.3616,33.9875,29.1646,29.1646,26.7106,0.0079,4.4741,7.8259,15.7124,7.8259,445.7656,11.0147,3.9865,1.9187,137.8577,113.7069,89.4271,2.9867,4.4340,15.2010,3.4283,1.4846,5.0896,1.0000
 1547.5000,2380.2456,0.0072,2.2001,2.1783,2.1872,2.1988,2.1995,2.2001,2.1783,0.3309,2.5773,-0.1334,0.5399,3.4820,34.0067,29.1842,29.1842,26.7287,0.0069,4.4056,7.7598,15.6520,7.7598,459.0694,11.0284,3.7561,1.7783,140.3853,112.6579,89.1541,2.9513,4.3437,15.2793,3.5176,1.4718,5.1771,5.0000
 1548.0000,2270.9646,0.0221,2.1978,2.1313,2.1414,2.1537,2.1589,2.1978,2.1313,0.3299,2.5879,-0.0105,0.1404,3.6730,34.1538,29.3343,29.3343,26.8676,0.0073,3.7618,7.1386,15.0839,7.1386,469.2054,11.0703,3.8301,1.9003,138.6143,113.3536,89.9671,2.9571,4.3724,15.5188,3.5492,1.4786,5.2480,8.0000
 1548.5000,2272.7146,0.0270,2.2001,2.1186,2.1299,2.1434,2.1522,2.2001,2.1186,0.3308,2.6041,-0.2399,-0.2355,3.8232,33.8111,28.9848,28.9848,26.5442,0.0061,2.7846,6.1957,14.2217,6.1957,472.0022,11.0747,4.2722,2.1456,132.0888,113.9813,90.0832,2.9470,4.4813,15.6048,3.4822,1.5206,5.2952,4.8000
 1549.0000,2383.7354,0.0303,2.2114,2.1198,2.1319,2.1469,2.1578,2.2114,2.1198,0.3310,2.5992,-0.4502,-0.6219,3.7996,34.0696,29.2483,29.2483,26.7880,0.0013,3.0783,6.4790,14.4808,6.4791,471.7353,11.0814,3.2260,1.7707,131.1208,116.1406,91.1339,2.9832,4.6741,15.7781,3.3756,1.5668,5.2890,4.0000
 1549.5000,2403.8660,0.0314,2.2061,2.1114,2.1236,2.1395,2.1505,2.2061,2.1114,0.3304,2.5773,-0.2896,-0.1057,3.6499,35.2623,30.4690,30.4690,27.9160,-0.0012,4.4072,7.7613,15.6534,7.7614,473.6248,11.1008,1.6513,1.5967,137.1038,118.9730,92.8415,3.0374,4.8791,16.0817,3.2961,1.6063,5.2945,4.0000
 1550.0000,2448.0903,0.0296,2.2184,2.1286,2.1405,2.1574,2.1661,2.2184,2.1286,0.3301,2.5577,-0.0995,0.5383,3.5030,34.5546,29.7438,29.7438,27.2462,-0.0008,5.5925,8.9050,16.6993,8.9050,469.8011,11.1323,1.9347,1.5356,142.4025,119.8001,92.8966,3.0369,5.0077,16.1021,3.2155,1.6489,5.3021,6.4000
 1550.5000,2426.6113,0.0224,2.2674,2.1977,2.2092,2.2271,2.2315,2.2674,2.1977,0.3295,2.5500,0.0730,0.1300,3.4198,33.8977,29.0730,29.0730,26.6259,-0.0011,6.0606,9.3567,17.1123,9.3567,455.0113,11.1423,3.5327,1.8358,143.9969,118.4727,91.6742,3.0052,4.9806,15.8512,3.1826,1.6573,5.2746,6.0000
 1551.0000,2429.7559,0.0101,2.3892,2.3561,2.3669,2.3862,2.3848,2.3892,2.3561,0.3302,2.5578,0.2447,-0.2950,3.4355,32.4790,27.6323,27.6323,25.2904,0.0007,5.5899,8.9026,16.6970,8.9026,424.4317,11.1683,4.3601,2.4703,142.1036,116.1736,89.5986,2.9432,4.9162,15.4638,3.1455,1.6704,5.2541,4.0000
 1551.5000,2461.1848,0.0187,2.5998,2.5332,2.5422,2.5615,2.5544,2.5998,2.5332,0.3317,2.5657,0.3603,-0.1429,3.4696,31.8849,27.0322,27.0322,24.7330,0.0044,5.1097,8.4391,16.2732,8.4392,394.7615,11.1847,4.4182,2.5657,137.6641,113.4706,87.1538,2.8699,4.8502,15.0087,3.0945,1.6900,5.2298,4.0000
 1552.0000,2443.0339,0.0162,2.7019,2.6419,2.6474,2.6640,2.6541,2.7019,2.6419,0.3315,2.5658,0.4366,-0.0279,3.4754,32.5712,27.7256,27.7256,25.3771,0.0080,5.1048,8.4344,16.2689,8.4344,378.5165,11.1950,4.8570,2.5915,132.4305,112.3393,85.9528,2.8316,4.8515,14.7958,3.0498,1.7133,5.2253,7.2000
 1552.5000,2458.9153,0.0137,2.6928,2.6420,2.6435,2.6548,2.6466,2.6928,2.6420,0.3313,2.5639,0.1352,0.0026,3.5102,32.2514,27.4022,27.4022,25.0767,0.0114,5.2184,8.5440,16.3692,8.5441,378.5002,11.2029,4.5953,2.4497,132.6821,112.5869,85.6588,2.8094,4.9287,14.8047,3.0038,1.7544,5.2698,3.2000
 1553.0000,2442.2622,0.0081,2.5973,2.5684,2.5661,2.5715,2.5681,2.5973,2.5684,0.3291,2.5580,-0.5045,-0.0568,3.5298,32.2722,27.4232,27.4232,25.0962,0.0113,5.5732,8.8864,16.6822,8.8864,389.3468,11.2025,4.6513,2.4089,138.1646,111.8933,84.8851,2.7708,4.9326,14.7333,2.9870,1.7802,5.3173,7.0000
 1553.5000,2452.9041,-0.0008,2.4475,2.4503,2.4452,2.4451,2.4462,2.4475,2.4503,0.3289,2.5557,-0.6388,-0.2278,3.4874,34.2457,29.4281,29.4281,26.9544,0.0097,5.7133,9.0216,16.8058,9.0216,408.1100,11.2120,4.4786,2.2416,137.8675,111.3126,84.0988,2.7321,4.9668,14.6590,2.9514,1.8179,5.3655,4.0000
 1554.0000,2463.2578,0.0019,2.3364,2.3303,2.3235,2.3190,2.3217,2.3364,2.3303,0.3304,2.5589,-0.2516,-0.1501,3.4274,34.6522,29.8437,29.8437,27.3385,0.0087,5.5196,8.8347,16.6349,8.8347,429.1311,11.2222,4.2015,2.0259,135.7976,111.5857,84.3824,2.7316,4.9900,14.7546,2.9568,1.8268,5.4015,4.8000
 1554.5000,2425.1257,-0.0045,2.2539,2.2678,2.2602,2.2525,2.2534,2.2539,2.2678,0.3303,2.5427,0.0107,0.0601,3.3249,33.7598,28.9325,28.9325,26.4957,0.0020,6.5006,9.7812,17.5005,9.7812,440.9482,11.2336,4.0851,2.1369,138.6036,110.9632,83.7367,2.7082,4.9967,14.6534,2.9326,1.8450,5.4108,4.0000
 1555.0000,2442.5391,-0.0026,2.3079,2.3162,2.3081,2.2981,2.2955,2.3080,2.3162,0.3302,2.5163,0.1214,0.0099,3.2207,34.2801,29.4633,29.4633,26.9869,0.0047,8.1006,11.3251,18.9123,11.3251,431.7360,11.2419,4.1767,2.2715,138.6080,110.5025,83.3329,2.6980,4.9896,14.5692,2.9199,1.8494,5.4000,4.0000
 1555.5000,2398.5339,0.0017,2.4365,2.4308,2.4226,2.4115,2.4080,2.4365,2.4308,0.3290,2.5087,0.0507,-0.0898,3.2344,35.7229,30.9425,30.9425,28.3527,0.0376,8.5613,11.7697,19.3188,11.7697,411.3842,11.2508,2.4000,1.5447,134.0882,108.9883,81.8803,2.6524,4.9326,14.3082,2.9007,1.8596,5.3943,3.2000
 1556.0000,2431.4373,0.0058,2.4942,2.4743,2.4669,2.4568,2.4604,2.4941,2.4743,0.3312,2.4930,-0.3146,-0.3535,3.2553,38.7584,34.0910,34.0910,31.2464,0.0795,9.5122,12.6872,20.1578,12.6872,404.1551,11.4096,1.1668,1.3822,129.2632,107.0360,79.8650,2.5917,4.8706,13.9343,2.8609,1.8793,5.3764,0.8000
 1556.5000,2400.8608,0.0164,2.5720,2.5142,2.5073,2.4996,2.5217,2.5720,2.5142,0.3291,2.4696,-0.6564,-0.6686,3.1545,40.8975,36.3390,36.3390,33.3017,0.1160,10.9333,14.0584,21.4117,14.0584,397.7442,11.9612,1.0826,1.1344,123.9592,105.4337,78.1051,2.5264,4.8349,13.6664,2.8266,1.9138,5.4095,8.0000
 1557.0000,2329.5149,0.0401,2.6561,2.5106,2.5033,2.4984,2.5371,2.6560,2.5106,0.3298,2.4605,-0.5030,-0.4410,3.0223,40.9789,36.4250,36.4250,33.3801,0.1546,11.4822,14.5881,21.8961,14.5881,398.3079,12.5154,0.8057,0.9094,116.3515,103.9976,76.4194,2.4695,4.8104,13.3827,2.7821,1.9479,5.4192,5.6000
 1557.5000,2300.6074,-0.0001,2.2626,2.2628,2.2550,2.2525,2.2584,2.2626,2.2628,0.3300,2.3964,0.1868,0.1003,2.8937,38.3102,33.6230,33.6230,30.8174,0.1862,15.3705,18.3399,25.3269,18.3399,441.9302,13.6775,0.3449,0.7930,109.1809,101.7785,74.4205,2.4053,4.7478,13.0308,2.7446,1.9739,5.4176,2.0000
 1558.0000,2400.7910,-0.0035,1.9708,1.9803,1.9718,1.9700,1.9704,1.9707,1.9803,0.3308,2.3345,0.7067,0.6168,2.8374,32.9140,28.0729,28.0729,25.6992,0.2023,19.1223,21.9601,28.6373,21.9601,504.9731,14.1643,0.3737,0.7688,102.2959,92.3224,67.6636,2.1918,4.2661,11.8244,2.7717,1.9464,5.3949,4.0000
 1558.5000,2408.4502,0.0197,2.7334,2.6594,2.5912,2.5700,2.6633,2.7334,2.6594,0.3306,2.4459,0.6280,0.8106,3.2403,23.1798,18.4615,18.4615,16.6875,0.1863,12.3712,15.4458,22.6804,15.4458,376.0192,13.2960,4.8787,4.3799,84.8732,73.9625,54.6649,1.7652,3.3368,9.5791,2.8708,1.8903,5.4266,4.0000
 1559.0000,2377.0674,0.0166,6.7712,6.6171,6.3917,6.3112,6.5732,6.7711,6.6171,0.3291,2.6198,0.4262,0.5096,4.0909,12.8041,8.8042,8.8042,7.4060,0.1256,1.8303,5.2748,13.3796,5.2748,151.1244,10.7682,20.4506,18.5368,58.7820,51.9672,39.0225,1.2511,2.2521,6.8806,3.0551,1.8001,5.4995,3.0000
 1559.5000,2405.1909,0.0231,19.9297,19.2975,18.1758,17.7082,18.9418,19.9297,19.2975,0.3302,2.6886,0.1585,0.2295,4.6937,9.2262,5.6193,5.6193,4.2857,0.0619,-2.3375,1.2532,9.7022,1.2533,51.8203,10.4203,29.7538,31.8578,42.3193,40.1954,30.5622,0.9703,1.6799,5.4345,3.2350,1.7314,5.6011,1.6000
 1560.0000,2384.6216,0.0151,16.7273,16.3809,15.6851,15.4072,16.1461,16.7273,16.3809,0.3304,2.6885,-0.3133,0.1462,4.6351,10.2282,6.5036,6.5036,5.1553,0.0289,-2.3355,1.2552,9.7039,1.2552,61.0465,10.3033,39.9791,36.0277,45.2025,41.6604,32.0629,1.0091,1.6922,5.7431,3.3939,1.6769,5.6913,0.8000
 1560.5000,2378.8521,-0.0028,5.9842,6.0070,5.8726,5.8178,5.9045,5.9842,6.0070,0.3300,2.6366,-0.4593,-0.0657,3.9890,14.5091,10.3485,10.3485,8.9077,0.0117,0.8123,4.2926,12.4815,4.2926,166.4713,10.3547,20.9016,11.2676,65.5028,53.6698,41.5507,1.3003,2.1531,7.4774,3.4728,1.6558,5.7503,5.0000
 1561.0000,2345.3965,-0.0091,3.4022,3.4447,3.3888,3.3665,3.3852,3.4022,3.4447,0.3301,2.5642,-0.1400,-0.1663,3.2267,20.7726,16.1661,16.1661,14.5039,0.0021,5.1974,8.5238,16.3507,8.5238,290.2975,10.4276,4.3765,2.8112,89.3700,68.5495,53.0927,1.6507,2.7579,9.6060,3.4831,1.6707,5.8193,3.0000
 1561.5000,2377.7117,-0.0117,2.8772,2.9238,2.8798,2.8632,2.8713,2.8772,2.9238,0.3302,2.5352,0.3045,0.0908,2.9089,22.6173,17.9221,17.9221,16.1756,-0.0014,6.9570,10.2217,17.9032,10.2217,342.0157,10.4758,4.9250,2.7389,101.4333,80.4091,62.2177,1.9252,3.2612,11.3007,3.4652,1.6940,5.8699,2.4000
 1562.0000,2393.8586,-0.0123,2.8189,2.8669,2.8264,2.8122,2.8161,2.8189,2.8669,0.3305,2.5329,0.3491,0.2602,2.9400,23.7623,19.0218,19.0218,17.2186,-0.0028,7.0975,10.3572,18.0272,10.3572,348.8103,10.4990,4.2160,2.4266,103.6895,86.2441,66.2207,2.0328,3.5823,12.1047,3.3791,1.7622,5.9546,3.0000
 1562.5000,2319.3457,-0.0119,2.8605,2.9077,2.8717,2.8603,2.8604,2.8605,2.9077,0.3308,2.5313,-0.0110,0.1018,2.9884,24.5923,19.8236,19.8236,17.9772,-0.0031,7.1947,10.4510,18.1129,10.4510,343.9189,10.5256,5.0218,2.6209,105.3362,89.6409,68.7114,2.1183,3.7339,12.5174,3.3524,1.7627,5.9092,6.4000
 1563.0000,2321.9021,-0.0112,2.9357,2.9812,2.9509,2.9426,2.9384,2.9357,2.9812,0.3301,2.5294,-0.1011,-0.0234,3.0033,23.6422,18.9062,18.9062,17.1091,-0.0018,7.3092,10.5615,18.2140,10.5615,335.4410,10.5688,5.2456,2.8453,106.6884,92.6458,71.0795,2.2107,3.8365,12.8565,3.3511,1.7354,5.8155,6.4000
 1563.5000,2377.4014,-0.0006,3.0418,3.0444,3.0205,3.0158,3.0061,3.0418,3.0444,0.3300,2.5333,-0.1427,0.0178,2.9960,24.3508,19.5899,19.5899,17.7563,0.0011,7.0703,10.3310,18.0032,10.3310,328.4751,10.6477,4.4563,2.8426,111.8301,94.5292,73.0670,2.3054,3.8294,13.0600,3.4105,1.6610,5.6649,2.0000
 1564.0000,2421.0723,0.0113,3.2170,3.1669,3.1481,3.1469,3.1312,3.2170,3.1669,0.3306,2.5482,-0.1451,-0.1321,3.0283,25.5646,20.7677,20.7677,18.8686,0.0007,6.1703,9.4626,17.2091,9.4626,315.7626,10.6955,5.3015,3.0650,117.6326,94.5328,73.8377,2.3587,3.7290,13.0604,3.5024,1.5810,5.5371,1.6000
 1564.5000,2360.0229,0.0137,3.2748,3.2132,3.1989,3.2008,3.1783,3.2748,3.2132,0.3309,2.5596,0.1151,-0.2929,3.1339,25.8487,21.0445,21.0445,19.1295,0.0003,5.4786,8.7952,16.5988,8.7952,311.2174,10.7356,6.2968,3.3990,119.0753,95.3477,75.0930,2.4219,3.6952,13.1728,3.5649,1.5257,5.4390,4.0000
 1565.0000,2322.3396,0.0127,3.0616,3.0081,2.9977,3.0008,2.9736,3.0616,3.0081,0.3302,2.5506,0.0088,-0.3821,3.1954,28.4490,23.5994,23.5994,21.5299,0.0019,6.0230,9.3204,17.0791,9.3205,332.4320,10.7666,4.9467,2.5963,123.7691,97.0578,77.0792,2.5101,3.6968,13.4067,3.6266,1.4728,5.3412,6.0000
 1565.5000,2389.2283,0.0101,2.9016,2.8614,2.8511,2.8528,2.8311,2.9024,2.8614,0.3311,2.5348,-0.1326,-0.5864,3.1481,29.5223,24.6648,24.6648,22.5266,0.0011,6.9820,10.2458,17.9253,10.2458,349.4825,10.7971,4.4921,2.5774,128.7484,100.3889,80.2182,2.6248,3.7838,13.8933,3.6718,1.4415,5.2931,3.2000
 1566.0000,2447.5371,0.0043,2.8594,2.8425,2.8282,2.8254,2.7953,2.8637,2.8425,0.3298,2.5341,0.1604,-0.5555,3.0637,28.9547,24.1006,24.1006,21.9991,0.0020,7.0256,10.2879,17.9638,10.2879,351.8002,10.7881,4.9180,2.7111,129.8494,103.4027,83.1185,2.7237,3.8637,14.3767,3.7210,1.4185,5.2784,4.0000
 1566.5000,2421.3828,-0.0069,2.8413,2.8685,2.8462,2.8342,2.7842,2.8538,2.8685,0.3313,2.5406,0.1255,-0.4068,3.0297,28.5424,23.6918,23.6918,21.6164,0.0055,6.6275,9.9037,17.6125,9.9037,348.6115,10.7586,5.1702,2.8414,130.1438,104.0945,84.1142,2.7603,3.8494,14.5302,3.7747,1.3946,5.2640,7.0000
 1567.0000,2327.1655,-0.0248,2.7968,2.8931,2.8594,2.8334,2.7694,2.8244,2.8931,0.3289,2.5477,-0.3744,0.1886,3.0785,29.5476,24.6900,24.6900,22.5501,0.0088,6.1995,9.4907,17.2348,9.4907,345.6537,10.7331,4.8542,2.5230,128.9697,104.7428,85.1496,2.8027,3.8241,14.6688,3.8359,1.3644,5.2337,5.6000
 1567.5000,2428.7764,-0.0395,2.8158,2.9706,2.9216,2.8764,2.7901,2.8233,2.9706,0.3297,2.5526,-0.4459,0.7631,3.1556,30.0739,25.2148,25.2148,23.0402,0.0125,5.9050,9.2065,16.9750,9.2066,336.6366,10.7200,4.6994,2.3287,127.3093,105.7633,86.4041,2.8597,3.8011,14.8106,3.8963,1.3292,5.1790,4.0000
 1568.0000,2432.1279,-0.0852,2.7646,3.0948,3.0271,2.9575,2.8336,2.8358,3.0948,0.3299,2.5451,0.0915,0.3238,3.1556,29.2010,24.3452,24.3452,22.2279,0.0145,6.3579,9.6435,17.3746,9.6435,323.1268,10.7506,4.6402,2.4227,129.6091,107.0113,87.2687,2.9096,3.8549,14.8580,3.8543,1.3249,5.1066,4.0000
 1568.5000,2439.4878,-0.1367,2.7306,3.2571,3.1687,3.0704,2.8882,2.8396,3.2571,0.3309,2.5322,0.4355,-0.1676,3.0921,30.4699,25.6107,25.6107,23.4096,0.0123,7.1376,10.3959,18.0625,10.3959,307.0201,10.7895,4.2910,2.1948,131.0611,107.4283,87.3655,2.9366,3.8968,14.7616,3.7881,1.3270,5.0268,2.4000
 1569.0000,2446.9849,-0.1993,2.7391,3.5135,3.4022,3.2704,3.0039,2.8622,3.5135,0.3281,2.5223,0.2583,0.0147,3.0724,29.4949,24.6375,24.6375,22.5011,0.0125,7.7416,10.9788,18.5956,10.9788,284.6198,10.8190,4.5363,2.4655,129.5130,105.4930,85.8543,2.9097,3.8127,14.3929,3.7750,1.3104,4.9465,1.6000
 1569.5000,2447.8599,-0.2876,2.7625,3.8907,3.7557,3.5858,3.2143,2.9062,3.8907,0.3301,2.5209,-0.0926,0.2356,3.1668,28.9092,24.0555,24.0555,21.9569,0.0224,7.8246,11.0588,18.6687,11.0588,257.0223,10.7690,4.5736,2.5840,121.0350,99.2991,81.0112,2.7582,3.5821,13.5211,3.7746,1.2987,4.9022,3.0000
 1570.0000,2382.6760,-0.3817,2.9298,4.5082,4.3474,4.1316,3.6393,3.0990,4.5082,0.3284,2.5100,-0.3729,-0.0677,3.3686,29.7501,24.8918,24.8918,22.7386,0.0418,8.4844,11.6954,19.2509,11.6955,221.8167,10.6630,5.3062,3.4705,106.7372,90.9465,74.4903,2.5487,3.2506,12.3730,3.8064,1.2754,4.8545,7.2000
 1570.5000,2320.9573,-0.4289,2.5065,4.0154,3.8788,3.6803,3.2217,2.6731,4.0154,0.3289,2.4168,-0.4766,-0.5426,3.4279,30.9350,26.0767,26.0767,23.8439,0.0796,14.1326,17.1455,24.2347,17.1455,249.0409,10.5439,8.4640,2.3760,96.0943,82.9673,68.3469,2.3434,2.9167,11.3296,3.8844,1.2446,4.8347,4.0000
 1571.0000,2418.6306,-0.4096,1.5080,2.3771,2.3051,2.1903,1.9239,1.6160,2.3771,0.3292,2.2925,-0.3137,-0.7733,3.2753,37.9034,33.1992,33.1992,30.4286,0.1407,21.6666,24.4152,30.8823,24.4152,420.6778,10.8155,0.9700,0.6519,95.4242,81.4798,67.5417,2.3218,2.8133,11.1674,3.9694,1.2117,4.8097,3.0000
 1571.5000,2462.2332,-0.3609,1.1403,1.7225,1.6789,1.6005,1.4201,1.2235,1.7225,0.3303,2.2727,-0.0942,-0.4736,3.1818,39.5495,34.9196,34.9196,32.0050,0.1724,22.8661,25.5726,31.9407,25.5726,580.5494,12.0213,0.4343,0.5491,101.6259,85.4166,71.4209,2.4594,2.8643,11.7886,4.1158,1.1646,4.7932,8.0000
 1572.0000,2478.2979,-0.3050,1.0858,1.5559,1.5246,1.4597,1.3152,1.1663,1.5559,0.3295,2.3025,-0.0788,0.0623,3.1089,39.2909,34.6483,34.6483,31.7567,0.1309,21.0634,23.8330,30.3500,23.8331,642.7066,12.6604,0.3297,0.4739,106.0529,90.7275,76.4985,2.6367,2.9626,12.6151,4.2582,1.1236,4.7844,0.8000
 1572.5000,2468.2559,-0.2473,1.2589,1.7011,1.6748,1.6109,1.4779,1.3507,1.7011,0.3301,2.3043,-0.0590,0.1615,3.0133,38.5069,33.8283,33.8283,31.0056,0.0747,20.9519,23.7255,30.2517,23.7255,587.8446,12.7898,0.3488,0.4618,107.3109,91.9372,77.8164,2.6915,2.9770,12.7882,4.2957,1.1061,4.7514,4.0000
 1573.0000,2465.3879,-0.1906,1.7013,2.1610,2.1351,2.0626,1.9248,1.8025,2.1610,0.3288,2.3389,0.0315,0.2663,3.1449,35.3209,30.5292,30.5292,27.9715,0.0665,18.8546,21.7018,28.4011,21.7018,462.7569,12.4088,0.7092,0.6213,106.0520,90.8165,77.1309,2.6738,2.9279,12.6468,4.3194,1.0950,4.7299,2.4000
 1573.5000,2461.4031,-0.1374,2.3178,2.7673,2.7406,2.6576,2.5120,2.3853,2.7673,0.3293,2.4265,0.0511,0.5565,3.4455,32.4529,27.6059,27.6059,25.2659,0.0716,13.5450,16.5785,23.7162,16.5785,361.3620,11.6062,1.5992,1.2397,103.4977,89.7401,76.2729,2.6363,2.9221,12.5428,4.2924,1.1084,4.7576,1.6000
 1574.0000,2458.4441,-0.1021,2.8204,3.2250,3.1977,3.1118,2.9675,2.8425,3.2250,0.3295,2.5041,0.2236,0.5282,3.6388,29.5210,24.6635,24.6635,22.5254,0.0487,8.8435,12.0420,19.5678,12.0420,310.0732,11.1831,3.3704,2.1626,106.8059,91.1277,77.4074,2.6581,2.9965,12.8124,4.2758,1.1273,4.8202,5.0000
 1574.5000,2456.1284,-0.0774,3.0920,3.4272,3.3992,3.3192,3.1876,3.0985,3.4272,0.3297,2.5551,0.4688,-0.0246,3.7370,28.1407,23.2945,23.2945,21.2442,0.0266,5.7506,9.0576,16.8388,9.0576,291.7841,11.0525,3.7020,2.4539,113.4393,94.2110,79.7123,2.7298,3.1513,13.2293,4.1980,1.1544,4.8463,4.0000
 1575.0000,2449.7942,-0.0544,3.1570,3.3963,3.3676,3.2999,3.1872,3.1673,3.3963,0.3303,2.5880,0.3606,-0.2493,3.7729,28.3532,23.5046,23.5046,21.4411,0.0208,3.7580,7.1349,15.0806,7.1349,294.4422,11.0027,2.8613,2.6485,118.1537,95.9146,81.0089,2.7616,3.2211,13.5042,4.1924,1.1664,4.8900,8.0000
 1575.5000,2457.8560,-0.0324,3.2401,3.3858,3.3549,3.2988,3.1983,3.2509,3.3858,0.3298,2.5912,0.1211,0.2595,3.6932,27.1900,22.3577,22.3577,20.3651,0.0112,3.5608,6.9446,14.9065,6.9446,295.3531,10.9960,3.8133,3.3928,119.7213,95.8037,80.8170,2.7523,3.2002,13.4853,4.2139,1.1628,4.8997,0.0000
 1576.0000,2383.0437,-0.0153,3.3500,3.4211,3.3868,3.3411,3.2478,3.3586,3.4211,0.3290,2.5893,0.0678,0.2182,3.6099,26.9458,22.1179,22.1179,20.1397,0.0024,3.6813,7.0609,15.0129,7.0609,292.3017,10.9627,5.1293,3.5085,117.0634,95.2107,80.1679,2.7469,3.1586,13.2975,4.2099,1.1499,4.8409,4.0000
 1576.5000,2250.8103,-0.0046,3.4242,3.4460,3.4081,3.3723,3.2854,3.4297,3.4460,0.3308,2.5982,-0.0567,-0.0845,3.6073,26.6616,21.8392,21.8392,19.8777,0.0025,3.1421,6.5406,14.5371,6.5406,290.1906,10.9359,4.9794,2.8929,115.3754,95.7250,80.7792,2.7856,3.1203,13.3149,4.2671,1.1202,4.7800,1.6000
 1577.0000,2266.8528,0.0007,3.5035,3.5000,3.4584,3.4311,3.3493,3.5055,3.5000,0.3295,2.6025,-0.1812,-0.0331,3.6220,25.6579,20.8586,20.8586,18.9543,0.0029,2.8782,6.2859,14.3042,6.2859,285.7175,10.9620,4.8902,2.9994,113.1342,95.6930,80.8883,2.8113,3.0770,13.2288,4.2993,1.0945,4.7057,6.0000
 1577.5000,2338.1863,0.0021,3.8003,3.7892,3.7392,3.7156,3.6312,3.8003,3.7892,0.3299,2.6037,-0.0866,-0.2666,3.6139,24.2324,19.4755,19.4755,17.6480,0.0015,2.8082,6.2184,14.2425,6.2184,263.9066,10.9777,4.7723,3.2529,108.6162,93.4513,79.2023,2.7624,2.9768,12.9069,4.3359,1.0776,4.6724,4.0000
 1578.0000,2412.0659,0.0040,4.1620,4.1392,4.0783,4.0569,3.9732,4.1620,4.1392,0.3293,2.6097,0.0993,-0.2528,3.6132,23.5007,18.7699,18.7699,16.9800,0.0027,2.4432,5.8662,13.9204,5.8662,241.5922,10.9414,6.6115,4.3019,105.2535,91.9883,78.7450,2.7330,2.8394,12.8961,4.5418,1.0389,4.7187,4.0000
 1578.5000,2371.8611,0.0089,4.0159,3.9666,3.9076,3.8919,3.8335,4.0159,3.9666,0.3303,2.6148,0.2944,-0.0815,3.6547,24.5469,19.7796,19.7796,17.9356,0.0044,2.1363,5.5701,13.6496,5.5701,252.1071,10.9492,5.9906,3.7573,106.7872,90.0490,77.3718,2.6645,2.7613,12.7703,4.6248,1.0363,4.7928,1.0000
 1579.0000,2420.1973,0.0076,3.8315,3.7914,3.7358,3.7235,3.6908,3.8315,3.7914,0.3300,2.6177,0.2150,-0.1493,3.7589,27.9186,23.0753,23.0753,21.0386,0.0044,1.9566,5.3967,13.4911,5.3968,263.7562,10.9437,6.0759,3.5994,111.7014,91.4675,78.3722,2.6933,2.8726,12.9622,4.5123,1.0666,4.8128,3.2000
 1579.5000,2432.5542,-0.0153,3.6481,3.7251,3.6709,3.6603,3.6491,3.6481,3.7251,0.3301,2.6204,-0.0790,0.1273,3.8477,28.7395,23.8872,23.8872,21.7994,0.0047,1.7961,5.2418,13.3495,5.2418,268.4456,10.9178,6.0018,3.5691,115.3228,94.0375,80.2802,2.7622,2.9919,13.2618,4.4325,1.0832,4.8012,4.0000
 1580.0000,2438.1516,-0.0110,3.6637,3.7192,3.6664,3.6569,3.6609,3.6637,3.7192,0.3292,2.6153,-0.1371,0.3150,3.7643,28.2489,23.4015,23.4015,21.3444,0.0043,2.1011,5.5361,13.6186,5.5361,268.8720,10.8772,5.9897,3.4679,115.2362,95.9005,81.3357,2.8013,3.1075,13.4228,4.3195,1.1093,4.7916,3.0000
 1580.5000,2380.9822,-0.0078,3.8131,3.8543,3.8010,3.7919,3.8035,3.8131,3.8543,0.3293,2.6107,-0.0180,-0.1325,3.5260,25.8944,21.0891,21.0891,19.1715,0.0029,2.3834,5.8085,13.8677,5.8085,259.4538,10.8284,5.4770,3.4986,111.7727,96.2492,81.1621,2.7982,3.1565,13.3806,4.2391,1.1280,4.7818,4.0000
 1581.0000,2356.6938,-0.0074,4.1196,4.1619,4.1055,4.0964,4.1091,4.1196,4.1619,0.3293,2.6184,-0.0266,-0.4795,3.3298,24.0556,19.3048,19.3048,17.4865,0.0035,1.9140,5.3556,13.4536,5.3556,240.2734,10.7876,5.8136,3.9555,109.6511,94.7937,79.7780,2.7457,3.1006,13.1754,4.2493,1.1293,4.7986,6.4000
 1581.5000,2459.4688,-0.0079,4.1690,4.2146,4.1629,4.1556,4.1634,4.1690,4.2146,0.3294,2.6163,-0.1183,-0.0985,3.2349,23.5927,18.8585,18.8585,17.0639,0.0042,2.0401,5.4773,13.5648,5.4773,237.2682,10.7580,6.7388,4.5883,111.3302,93.5250,78.6985,2.7012,3.0413,13.0316,4.2848,1.1259,4.8243,3.0000
 1582.0000,2395.8157,-0.0072,3.8541,3.8925,3.8538,3.8498,3.8523,3.8541,3.8925,0.3296,2.6032,-0.0376,0.3440,3.1740,24.2449,19.4875,19.4875,17.6594,0.0043,2.8383,6.2474,14.2690,6.2474,256.9034,10.7377,7.4220,4.0574,115.7091,94.2844,79.3486,2.7185,3.0389,13.1634,4.3317,1.1179,4.8423,0.0000
 1582.5000,2354.0452,-0.0057,3.4193,3.4463,3.4207,3.4202,3.4197,3.4193,3.4463,0.3296,2.5979,0.1517,0.2414,3.1414,25.0568,20.2740,20.2740,18.4027,0.0049,3.1572,6.5552,14.5505,6.5552,290.1642,10.7434,6.1339,3.4302,124.8299,97.8021,82.8832,2.8194,3.0458,13.8454,4.5458,1.0803,4.9108,4.0000
 1583.0000,2382.0654,-0.0044,3.1764,3.1956,3.1786,3.1809,3.1782,3.1764,3.1956,0.3293,2.5857,0.0785,-0.1166,3.1089,26.8669,22.0405,22.0405,20.0670,0.0029,3.8977,7.2697,15.2039,7.2697,312.9289,10.7738,5.2851,3.2650,130.9655,101.3958,85.9200,2.9118,3.1299,14.4045,4.6022,1.0749,4.9470,7.2000
 1583.5000,2398.4766,-0.0003,3.0946,3.0960,3.0855,3.0905,3.0855,3.0946,3.0960,0.3308,2.5696,-0.2362,-0.1429,3.0316,28.3185,23.4703,23.4703,21.4090,0.0008,4.8723,8.2101,16.0638,8.2101,322.9937,10.7903,5.3892,3.2932,128.4897,103.7265,87.9605,2.9805,3.1707,14.7489,4.6516,1.0638,4.9485,3.2000
 1584.0000,2408.6458,0.0085,3.0425,3.0068,3.0024,3.0097,3.0028,3.0425,3.0068,0.3289,2.5604,-0.3135,-0.0618,2.9867,29.5287,24.6712,24.6712,22.5326,0.0011,5.4287,8.7470,16.5548,8.7470,332.5757,10.8208,5.3532,2.7648,125.5267,105.4745,89.4042,3.0395,3.2101,14.9427,4.6549,1.0561,4.9161,3.0000
 1584.5000,2452.8691,0.0140,2.9707,2.9133,2.9140,2.9234,2.9150,2.9707,2.9133,0.3289,2.5541,-0.1091,0.0841,3.0139,29.5859,24.7281,24.7281,22.5858,0.0038,5.8144,9.1191,16.8950,9.1191,343.2517,10.8178,4.8806,2.4890,127.6314,106.4841,90.4972,3.0920,3.1845,15.0528,4.7270,1.0299,4.8683,1.6000
 1585.0000,2478.4014,0.0172,2.9284,2.8592,2.8641,2.8753,2.8653,2.9284,2.8592,0.3284,2.5506,0.2656,0.6575,3.0325,29.7967,24.9382,24.9382,22.7820,0.0070,6.0222,9.3197,17.0784,9.3197,349.7441,10.8359,5.0154,2.7876,130.7853,106.4528,91.0829,3.1158,3.0692,15.1323,4.9305,0.9850,4.8567,0.0000
 1585.5000,2426.5190,0.0192,2.9209,2.8441,2.8523,2.8654,2.8529,2.9209,2.8441,0.3294,2.5484,0.6549,0.6424,3.0670,30.0764,25.2173,25.2173,23.0426,0.0074,6.1564,9.4491,17.1968,9.4491,351.6076,10.8408,4.9108,2.8976,128.5058,106.0409,91.4926,3.1180,2.9550,15.2562,5.1629,0.9477,4.8929,3.2000
 1586.0000,2336.5510,0.0199,2.9543,2.8736,2.8849,2.8998,2.8835,2.9543,2.8736,0.3285,2.5563,0.3836,-0.1820,3.1970,30.2097,25.3504,25.3504,23.1668,0.0075,5.6778,8.9874,16.7746,8.9874,347.9911,10.8213,4.9306,2.7089,127.0042,105.2795,91.0437,3.0933,2.9324,15.2260,5.1923,0.9480,4.9222,4.0000
 1586.5000,2319.2534,0.0199,2.9950,2.9132,2.9270,2.9436,2.9233,2.9950,2.9132,0.3295,2.5670,-0.3620,-0.2900,3.3343,30.2895,25.4303,25.4303,23.2413,0.0071,5.0325,8.3647,16.2051,8.3647,343.2658,10.7881,5.3364,2.6540,124.2911,105.2877,91.1357,3.0899,2.9627,15.2726,5.1549,0.9589,4.9428,0.0000
 1587.0000,2402.2544,0.0199,3.0113,2.9291,2.9447,2.9626,2.9389,3.0113,2.9291,0.3284,2.5618,-0.4440,0.3711,3.3417,31.5151,26.6597,26.6597,24.3865,0.0048,5.3454,8.6666,16.4812,8.6666,341.4072,10.7885,5.3481,2.6318,124.0002,107.1796,92.4337,3.1430,3.0891,15.4469,5.0004,0.9829,4.9147,6.0000
 1587.5000,2407.3672,0.0197,3.0406,2.9583,2.9756,2.9946,2.9680,3.0406,2.9583,0.3294,2.5473,0.0541,0.2983,3.2677,30.7806,25.9219,25.9219,23.6997,0.0023,6.2235,9.5139,17.2560,9.5139,338.0313,10.7923,4.8417,2.5247,127.8375,106.7734,91.7526,3.1376,3.1278,15.2489,4.8754,0.9969,4.8601,5.6000
 1588.0000,2407.0679,0.0196,3.0792,2.9962,3.0151,3.0350,3.0066,3.0792,2.9962,0.3286,2.5411,0.1608,-0.6327,3.2302,29.8265,24.9679,24.9679,22.8098,0.0010,6.6003,9.8774,17.5885,9.8775,333.7526,10.8029,4.8615,2.5993,125.9770,106.3021,91.0583,3.1361,3.1293,15.0280,4.8024,0.9978,4.7920,0.8000
 1588.5000,2478.9436,0.0205,3.0492,2.9635,2.9828,3.0023,2.9757,3.0492,2.9635,0.3295,2.5412,-0.0487,-0.8644,3.2286,29.2746,24.4184,24.4184,22.2963,0.0010,6.5914,9.8689,17.5807,9.8689,337.4410,10.7996,5.0130,2.7923,123.5443,104.9665,89.5168,3.1121,3.1077,14.6356,4.7094,0.9986,4.7029,1.0000
 1589.0000,2415.3477,0.0225,2.9625,2.8711,2.8899,2.9081,2.8862,2.9625,2.8711,0.3300,2.5346,0.0089,0.1653,3.2193,29.8492,24.9906,24.9906,22.8310,0.0024,6.9966,10.2599,17.9382,10.2599,348.2962,10.7642,4.9990,2.6442,124.4971,102.7096,87.3834,3.0544,3.0269,14.2086,4.6941,0.9910,4.6519,4.8000
 1589.5000,2403.4983,0.0242,2.9058,2.8094,2.8278,2.8446,2.8278,2.9058,2.8094,0.3294,2.5268,0.1856,0.4982,3.1923,29.4451,24.5879,24.5879,22.4548,0.0059,7.4690,10.7157,18.3550,10.7157,355.9507,10.6625,5.0443,2.7368,126.0866,102.7234,87.2609,3.0483,3.0187,14.1972,4.7030,0.9903,4.6574,10.4000
 1590.0000,2443.8638,0.0236,2.8881,2.7947,2.8130,2.8288,2.8163,2.8881,2.7947,0.3283,2.5281,0.2082,-0.1698,3.1712,28.2077,23.3608,23.3608,21.3063,0.0089,7.3869,10.6364,18.2825,10.6364,357.8159,10.5419,5.1945,2.9009,126.3092,103.0586,87.5977,3.0465,3.0259,14.3164,4.7313,0.9932,4.6993,6.0000
 1590.5000,2470.6514,0.0202,2.8683,2.7889,2.8068,2.8212,2.8120,2.8683,2.7889,0.3284,2.5357,0.1726,0.0693,3.1640,27.7474,22.9063,22.9063,20.8802,0.0103,6.9276,10.1933,17.8773,10.1933,358.5671,10.3884,5.2604,2.6998,128.7172,104.7393,89.2352,3.0787,3.0828,14.7013,4.7688,1.0013,4.7751,4.8000
 1591.0000,2490.4714,0.0169,2.8480,2.7819,2.7990,2.8120,2.8046,2.8480,2.7819,0.3277,2.5450,-0.0150,0.2919,3.1539,27.8081,22.9663,22.9663,20.9364,0.0123,6.3632,9.6487,17.3793,9.6487,359.4680,10.2883,4.7660,2.4767,132.6955,106.9306,91.2919,3.1334,3.1543,15.1174,4.7927,1.0067,4.8246,4.8000
 1591.5000,2454.1592,0.0158,2.8563,2.7943,2.8104,2.8221,2.8153,2.8563,2.7943,0.3300,2.5554,-0.3667,-0.2612,3.1697,28.8435,23.9903,23.9903,21.8959,0.0135,5.7305,9.0382,16.8210,9.0382,357.8736,10.2732,4.7974,2.5977,134.0936,106.7863,91.0982,3.1307,3.1656,15.0665,4.7595,1.0111,4.8125,6.0000
 1592.0000,2433.5325,0.0147,2.8300,2.7730,2.7870,2.7971,2.7909,2.8300,2.7730,0.3296,2.5626,-0.6009,-0.1103,3.2242,29.0729,24.2179,24.2179,22.1088,0.0112,5.2965,8.6194,16.4381,8.6194,360.6257,10.3195,4.4363,2.3950,131.8301,105.5396,89.9800,3.0979,3.1420,14.8550,4.7279,1.0142,4.7952,1.6000
 1592.5000,2345.4189,0.0103,2.7731,2.7338,2.7449,2.7532,2.7486,2.7731,2.7338,0.3287,2.5648,-0.5358,0.4055,3.2677,29.6827,24.8246,24.8246,22.6759,0.0083,5.1631,8.4906,16.3203,8.4907,365.7873,10.3434,4.4815,2.4395,131.9880,104.5540,88.7838,3.0749,3.1815,14.5713,4.5800,1.0347,4.7388,9.6000
 1593.0000,2423.4443,0.0032,2.7472,2.7353,2.7428,2.7492,2.7480,2.7472,2.7353,0.3294,2.5638,-0.0679,0.1614,3.2535,29.8412,24.9825,24.9825,22.8234,0.0076,5.2223,8.5478,16.3726,8.5478,365.5965,10.3782,5.0036,2.6264,133.3058,103.9234,87.7197,3.0646,3.2669,14.2706,4.3682,1.0660,4.6566,4.0000
 1593.5000,2453.4336,0.0071,2.7930,2.7658,2.7684,2.7724,2.7768,2.7930,2.7658,0.3283,2.5651,0.3820,-0.4360,3.2330,30.3931,25.5338,25.5338,23.3379,0.0100,5.1484,8.4765,16.3074,8.4766,361.5587,10.4131,4.8616,2.6778,128.2711,103.2033,86.7884,3.0549,3.3144,14.0107,4.2273,1.0849,4.5863,2.4000
 1594.0000,2505.4207,0.0155,2.8696,2.8084,2.8043,2.8050,2.8147,2.8696,2.8084,0.3305,2.5661,0.3711,-0.2377,3.2708,30.9066,26.0482,26.0482,23.8174,0.0136,5.0821,8.4125,16.2489,8.4126,356.0734,10.4812,4.8126,2.6819,123.2650,102.2349,86.0616,3.0450,3.2908,13.8191,4.1993,1.0807,4.5383,1.0000
 1594.5000,2442.0330,0.0167,2.9136,2.8470,2.8351,2.8314,2.8449,2.9137,2.8470,0.3291,2.5595,0.2009,0.2494,3.2942,31.5783,26.7233,26.7233,24.4457,0.0148,5.4822,8.7986,16.6020,8.7986,351.2481,10.5237,4.8824,2.5597,127.8197,99.5115,83.9634,2.9857,3.2030,13.4112,4.1871,1.0728,4.4918,4.0000
 1595.0000,2330.9546,-0.0026,2.9774,2.9882,2.9673,2.9583,2.9669,2.9783,2.9882,0.3299,2.5485,-0.0221,0.1310,3.3150,28.1150,23.2692,23.2692,21.2204,0.0187,6.1505,9.4434,17.1916,9.4434,334.6481,10.5331,4.7344,2.5070,129.7870,94.3447,79.5147,2.8320,3.0705,12.6790,4.1293,1.0842,4.4770,2.4000
 1595.5000,2301.9897,-0.0168,3.5282,3.6102,3.5718,3.5528,3.5366,3.5333,3.6102,0.3282,2.5508,-0.3299,0.2062,3.5264,23.9518,19.2046,19.2046,17.3916,0.0285,6.0122,9.3100,17.0695,9.3100,276.9898,10.5055,4.5054,2.9490,115.2005,82.3728,69.0121,2.4669,2.7658,10.9620,3.9635,1.1212,4.4436,4.0000
 1596.0000,2351.5461,0.0099,5.4855,5.4107,5.3162,5.2654,5.1296,5.5035,5.4107,0.3296,2.5947,-0.3887,0.0443,4.0142,18.1067,13.6624,13.6624,12.1068,0.0364,3.3541,6.7452,14.7242,6.7452,184.8174,10.2141,11.9413,12.5883,85.7797,66.4069,55.1666,1.9753,2.3109,8.7470,3.7850,1.1699,4.4282,3.2000
 1596.5000,2425.5754,-0.0009,8.7362,8.7465,8.5537,8.4236,7.9575,8.7907,8.7465,0.3295,2.6505,-0.2261,-0.5406,4.4313,13.6017,9.5245,9.5245,8.1074,0.0405,-0.0291,3.4807,11.7390,3.4807,114.3312,10.0722,43.9471,34.1293,60.2969,55.1091,45.5998,1.6199,1.9463,7.2910,3.7460,1.2015,4.5008,1.6000
 1597.0000,2367.9688,-0.0596,6.3940,6.9258,6.8159,6.7502,6.4533,6.4219,6.9258,0.3283,2.6556,-0.1733,-0.6316,4.2717,13.8410,9.7413,9.7413,8.3182,0.0605,-0.3395,3.1812,11.4651,3.1812,144.3885,10.0547,20.4834,11.2318,61.8591,55.0127,45.3599,1.5928,1.9693,7.3409,3.7276,1.2364,4.6088,1.0000
 1597.5000,2302.2551,-0.1027,4.3163,4.9393,4.8714,4.8319,4.6475,4.3270,4.9393,0.3285,2.5799,-0.3291,-0.7313,3.6485,20.5284,15.9350,15.9350,14.2833,0.0996,4.2507,7.6103,15.5153,7.6103,202.4595,10.2736,4.5223,2.9043,84.1505,64.1382,52.6768,1.8205,2.3142,8.6636,3.7437,1.2712,4.7589,2.4000
 1598.0000,2222.8938,-0.0950,3.7202,4.2160,4.1703,4.1460,4.0219,3.7273,4.2160,0.3285,2.4014,-0.4868,-0.8779,3.0360,30.0361,25.1771,25.1771,23.0050,0.1211,15.0679,18.0479,25.0599,18.0480,237.1933,10.4378,2.9332,1.8522,100.4901,74.7008,61.1340,2.0932,2.7204,10.1476,3.7302,1.2996,4.8479,0.8000
 1598.5000,2281.1338,-0.0443,2.7065,2.8733,2.8532,2.8451,2.7895,2.7092,2.8733,0.3287,2.2237,-0.2211,-0.3130,2.6626,35.8217,31.0442,31.0442,28.4464,0.1076,25.8363,28.4385,34.5614,28.4385,348.0282,10.8383,0.6075,0.5343,103.8876,83.8084,68.4989,2.3254,3.0605,11.4649,3.7461,1.3161,4.9303,4.0000
 1599.0000,2381.4197,0.0042,2.3549,2.3412,2.3348,2.3342,2.3291,2.3558,2.3412,0.3286,2.2325,0.3119,0.5467,2.6716,36.4351,31.6768,31.6768,29.0292,0.0808,25.3006,27.9216,34.0887,27.9216,427.1258,11.8046,0.3788,0.5554,108.0898,91.9735,75.1670,2.5408,3.3591,12.6329,3.7607,1.3221,4.9720,3.2000
 1599.5000,2424.6658,0.0212,2.7043,2.6255,2.6288,2.6339,2.6431,2.7045,2.6255,0.3293,2.4647,0.4839,0.6646,3.0487,31.3959,26.5397,26.5397,24.2750,0.0528,11.2301,14.3448,21.6736,14.3448,380.8752,11.4446,1.5677,1.3639,122.2694,100.8833,82.6826,2.7718,3.6576,14.0053,3.8291,1.3196,5.0527,4.8000
 1600.0000,2442.2285,0.0322,3.1123,2.9750,2.9846,2.9930,3.0149,3.1150,2.9750,0.3287,2.5498,0.1311,0.4153,3.1734,28.6759,23.8241,23.8241,21.7403,0.0279,6.0729,9.3685,17.1231,9.3686,336.1347,11.0856,4.5246,2.5987,128.2096,102.4782,83.8197,2.8248,3.7219,14.1275,3.7958,1.3176,5.0013,6.0000
 1600.5000,2391.1292,0.0352,3.4832,3.3157,3.3327,3.3461,3.3735,3.4823,3.3157,0.3282,2.5863,-0.2236,0.3378,3.2198,27.3571,22.5221,22.5221,20.5195,0.0103,3.8619,7.2351,15.1722,7.2351,301.5937,11.0672,5.2913,3.1065,128.2078,104.4052,84.9541,2.8993,3.8238,14.1467,3.6996,1.3189,4.8794,3.2000
 1601.0000,2452.8928,0.0375,3.6182,3.4328,3.4547,3.4733,3.5004,3.6143,3.4328,0.3286,2.5948,-0.2632,0.7072,3.1989,26.1521,21.3407,21.3407,19.4085,0.0094,3.3484,6.7397,14.7192,6.7397,291.3084,11.0018,6.4071,3.6248,128.4986,106.2692,85.8726,2.9758,3.9598,14.0853,3.5571,1.3307,4.7333,2.4000
 1601.5000,2464.2136,0.0401,3.4218,3.2343,3.2558,3.2774,3.3017,3.4176,3.2343,0.3287,2.5843,0.0190,0.3929,3.1186,27.0587,22.2287,22.2287,20.2439,0.0056,3.9805,7.3496,15.2769,7.3496,309.1830,10.9770,6.0673,3.2963,131.2519,108.6756,87.5138,3.0528,4.0994,14.2589,3.4783,1.3429,4.6708,5.0000
 1602.0000,2455.1499,0.0445,3.2840,3.0845,3.1048,3.1297,3.1551,3.2809,3.0845,0.3296,2.5718,0.3397,0.0160,3.0075,28.2757,23.4280,23.4280,21.3693,-0.0011,4.7396,8.0821,15.9467,8.0821,324.1972,10.9882,5.7188,3.0393,133.6171,110.6098,88.9816,3.1151,4.2073,14.4452,3.4334,1.3506,4.6371,4.8000
 1602.5000,2443.9436,0.0501,3.2130,2.9938,3.0120,3.0402,3.0700,3.2107,2.9938,0.3283,2.5662,0.2881,-0.2671,2.9160,29.3495,24.4928,24.4928,22.3659,-0.0020,5.0790,8.4096,16.2462,8.4096,334.0253,10.9831,5.5583,2.9669,136.8263,111.5046,89.5741,3.1420,4.2675,14.5123,3.4006,1.3582,4.6188,3.2000
 1603.0000,2447.4224,0.0559,3.2350,2.9889,3.0045,3.0360,3.0720,3.2317,2.9889,0.3278,2.5569,-0.0561,-0.4831,2.8600,29.0045,24.1501,24.1501,22.0454,-0.0032,5.6422,8.9530,16.7431,8.9530,334.5739,10.9951,4.1887,2.0330,137.6953,109.8190,88.4392,3.1067,4.1658,14.3071,3.4344,1.3409,4.6052,0.0000
 1603.5000,2460.7014,0.0621,3.5621,3.2616,3.2750,3.3141,3.3606,3.5557,3.2616,0.3287,2.5533,-0.0105,-0.0266,2.9250,26.2784,21.4642,21.4642,19.5248,-0.0020,5.8636,9.1666,16.9385,9.1666,306.5993,11.1089,1.3076,1.1174,130.0412,102.1560,82.3275,2.8938,3.8640,13.3101,3.4446,1.3353,4.5996,2.4000
 1604.0000,2409.0720,0.0702,4.5010,4.0731,4.0833,4.1420,4.2119,4.4887,4.0731,0.3277,2.5841,0.3184,-0.0212,3.2659,22.2198,17.5422,17.5422,15.8145,0.0050,3.9911,7.3598,15.2863,7.3598,245.5159,10.8730,3.7486,2.6831,110.5183,90.0617,72.2575,2.5363,3.4502,11.6988,3.3908,1.3603,4.6126,3.2000
 1604.5000,2441.9631,0.0746,5.4347,4.8867,4.8851,4.9612,5.0562,5.4176,4.8867,0.3287,2.6287,0.1993,-0.3266,3.6986,17.3224,12.9335,12.9335,11.4059,0.0063,1.2883,4.7518,12.9014,4.7518,204.6369,10.7111,13.3462,8.7723,89.4564,75.5753,60.2282,2.1025,2.9387,9.8059,3.3368,1.3977,4.6639,3.0000
 1605.0000,2466.8274,0.0739,5.7881,5.2096,5.1918,5.2660,5.3732,5.7697,5.2096,0.3284,2.6598,-0.2233,-0.0486,3.8845,16.7331,12.3882,12.3882,10.8805,0.0014,-0.5912,2.9383,11.2430,2.9383,191.9543,10.6015,11.0713,7.6556,78.4512,64.2737,50.9276,1.7672,2.5358,8.3420,3.2897,1.4349,4.7204,2.4000
 1605.5000,2448.9890,0.0689,6.3669,5.7730,5.7409,5.8175,5.9455,6.3451,5.7730,0.3274,2.6984,-0.1476,0.1318,3.8984,17.9057,13.4752,13.4752,11.9270,0.0004,-2.9311,0.6805,9.1784,0.6805,173.2207,10.5051,9.7181,6.9352,73.5888,57.9865,45.9359,1.5850,2.2680,7.5673,3.3365,1.4310,4.7745,2.4000
 1606.0000,2456.2207,0.0534,6.8596,6.3617,6.3202,6.3980,6.5342,6.8391,6.3617,0.3276,2.7377,0.3814,0.1687,3.9822,17.5338,13.1296,13.1296,11.5946,0.0034,-5.3122,-1.6171,7.0774,-1.6171,157.1917,10.4555,12.7469,9.3636,69.2500,54.6217,43.5382,1.4996,2.0679,7.1849,3.4745,1.3790,4.7912,3.2000
 1606.5000,2449.5647,0.0396,6.1741,5.8399,5.8065,5.8643,5.9507,6.1587,5.8399,0.3274,2.7448,0.3211,0.0924,4.0831,18.1451,13.6981,13.6981,12.1411,0.0067,-5.7444,-2.0340,6.6961,-2.0340,171.2357,10.4822,11.9092,8.3670,67.5727,56.7691,45.2515,1.5724,2.1171,7.4020,3.4964,1.3464,4.7074,0.8000
 1607.0000,2449.3804,0.0360,4.5513,4.3272,4.3129,4.3465,4.3815,4.5381,4.3272,0.3283,2.7066,-0.2690,-0.3911,3.9931,20.1786,15.6047,15.6047,13.9679,0.0098,-3.4291,0.1999,8.7390,0.2000,231.0985,10.5892,9.3022,6.0965,75.8986,64.3913,51.1601,1.7971,2.3930,8.2765,3.4587,1.3316,4.6055,6.0000
 1607.5000,2388.6526,0.0414,3.6818,3.4737,3.4707,3.4960,3.5274,3.6700,3.4737,0.3287,2.6400,-0.2946,-0.5244,3.7193,25.9270,21.1210,21.1210,19.2016,0.0309,0.6035,4.0911,12.2972,4.0911,287.8784,10.7302,5.5111,3.2594,95.0281,75.4150,59.5404,2.1115,2.8594,9.5375,3.3355,1.3542,4.5170,0.8000
 1608.0000,2440.6968,0.0562,3.2179,2.9721,2.9768,2.9993,3.0459,3.2072,2.9721,0.3292,2.5797,0.0958,0.2221,3.4769,31.3963,26.5401,26.5401,24.2753,0.0796,4.2590,7.6183,15.5226,7.6183,336.4646,10.9528,2.3163,1.4717,110.8315,86.2018,67.5469,2.3984,3.3585,10.8060,3.2175,1.4003,4.5056,0.0000
 1608.5000,2468.0027,0.0697,2.7431,2.4842,2.4924,2.5111,2.5616,2.7330,2.4842,0.3283,2.5339,0.1196,0.7976,3.3704,34.6779,29.8700,29.8700,27.3629,0.1024,7.0351,10.2970,17.9721,10.2970,402.5452,11.5303,0.9191,0.8151,116.6138,94.0341,73.2545,2.5993,3.7626,11.7272,3.1168,1.4475,4.5117,2.0000
 1609.0000,2503.5085,0.0718,2.5556,2.3071,2.3176,2.3358,2.3833,2.5451,2.3071,0.3284,2.5293,-0.2328,0.2495,3.3305,31.1030,26.2454,26.2454,24.0009,0.0731,7.3169,10.5689,18.2208,10.5689,433.4429,11.4556,0.5689,0.7236,115.0961,94.8074,73.7984,2.6107,3.8392,11.8515,3.0870,1.4705,4.5395,6.4000
 1609.5000,2476.4321,0.0706,2.9308,2.6506,2.6674,2.6928,2.7437,2.9214,2.6506,0.3287,2.5605,-0.3981,-0.4741,3.2674,26.5902,21.7693,21.7693,19.8119,0.0321,5.4213,8.7398,16.5482,8.7398,377.2697,11.0713,2.9841,1.7118,111.0956,92.4949,71.8603,2.5603,3.7804,11.4544,3.0300,1.4765,4.4739,4.8000
 1610.0000,2477.5962,0.0624,3.5289,3.2301,3.2571,3.2953,3.3413,3.5277,3.2301,0.3273,2.5755,-0.0024,-0.2431,3.2256,24.2430,19.4858,19.4858,17.6577,0.0067,4.5123,7.8627,15.7461,7.8627,309.5841,10.9940,5.5734,2.8115,106.9959,90.7675,70.6603,2.5335,3.6915,11.1875,3.0306,1.4571,4.4159,2.0000
 1610.5000,2470.8008,0.0404,3.6161,3.4167,3.4472,3.4893,3.5098,3.6171,3.4167,0.3279,2.5794,0.5124,0.3074,3.2892,23.9787,19.2305,19.2305,17.4162,0.0046,4.2782,7.6368,15.5396,7.6368,292.6760,10.8948,5.7138,3.2109,106.8113,91.6963,71.8782,2.5771,3.6393,11.3804,3.1271,1.4121,4.4160,1.6000
 1611.0000,2449.0925,0.0140,3.3245,3.2606,3.2868,3.3229,3.3221,3.3214,3.2606,0.3282,2.5743,0.3946,0.1022,3.3147,25.0073,20.2260,20.2260,18.3573,0.0105,4.5889,7.9366,15.8137,7.9366,306.6914,10.9062,5.0529,2.9072,111.4863,96.1280,75.8411,2.7089,3.7162,12.0567,3.2443,1.3719,4.4508,2.4000
 1611.5000,2456.1172,0.0259,3.2485,3.1332,3.1549,3.1854,3.1736,3.2452,3.1332,0.3285,2.5583,-0.2000,-0.2857,3.1639,24.3984,19.6360,19.6360,17.7998,0.0123,5.5560,8.8699,16.6671,8.8699,319.1590,10.9257,5.0132,2.9295,117.9842,100.8150,80.1521,2.8594,3.7956,12.7585,3.3614,1.3274,4.4619,5.0000
 1612.0000,2434.0747,0.0216,3.0852,2.9938,3.0103,3.0342,3.0200,3.0830,2.9938,0.3300,2.5581,-0.4187,-0.2059,2.9939,25.1542,20.3685,20.3685,18.4919,0.0163,5.5711,8.8844,16.6804,8.8844,334.0250,10.9199,3.5642,2.2267,125.1101,104.1632,82.8869,2.9645,3.9076,13.1580,3.3672,1.3181,4.4385,4.8000
 1612.5000,2431.3337,0.0166,3.1173,3.0463,3.0591,3.0782,3.0683,3.1163,3.0463,0.3272,2.5666,-0.3775,0.1664,2.9628,26.5293,21.7096,21.7096,19.7558,0.0180,5.0550,8.3864,16.2250,8.3864,328.2693,10.9104,5.2273,2.8980,127.1211,104.4440,83.0108,2.9677,3.9401,13.1838,3.3461,1.3277,4.4425,0.0000
 1613.0000,2417.1101,0.0044,2.8989,2.8813,2.8883,2.8991,2.8996,2.8999,2.8813,0.3282,2.5656,-0.4936,0.2507,3.0139,26.0210,21.2127,21.2127,19.2880,0.0158,5.1124,8.4418,16.2756,8.4418,347.0631,10.8967,5.6228,2.1543,124.3972,102.9721,81.5697,2.9098,3.9219,12.9853,3.3110,1.3478,4.4627,4.8000
 1613.5000,2374.6482,0.0011,2.5822,2.5784,2.5801,2.5826,2.5829,2.5831,2.5784,0.3295,2.5649,-0.3958,-0.1483,3.0585,27.9510,23.1072,23.1072,21.0686,0.0139,5.1571,8.4849,16.3151,8.4850,387.8353,11.0434,0.8463,1.0468,125.1324,101.7551,80.1892,2.8484,3.9176,12.8228,3.2732,1.3753,4.5017,7.2000
 1614.0000,2432.3696,0.0120,2.6260,2.5827,2.5800,2.5755,2.5590,2.6307,2.5827,0.3289,2.5687,-0.0936,-0.1281,3.0651,27.2490,22.4157,22.4157,20.4196,0.0093,4.9286,8.2644,16.1134,8.2644,387.1929,11.0838,1.6516,1.7024,125.1886,100.7259,79.1802,2.8060,3.8855,12.6927,3.2667,1.3847,4.5234,4.0000
 1614.5000,2441.4221,-0.0086,2.7012,2.7332,2.7258,2.7141,2.6646,2.7056,2.7332,0.3281,2.5680,0.1326,0.3338,3.0396,27.0502,22.2204,22.2204,20.2361,0.0063,4.9700,8.3043,16.1499,8.3043,365.8748,11.0545,3.5741,2.1731,120.4662,99.6472,78.3979,2.7811,3.8206,12.5541,3.2859,1.3738,4.5141,0.8000
 1615.0000,2476.0530,-0.0436,2.8506,3.0235,3.0119,2.9938,2.9056,2.8565,3.0235,0.3284,2.5612,0.2224,0.3660,3.0220,28.8085,23.9555,23.9555,21.8633,0.0072,5.3819,8.7018,16.5134,8.7018,330.7392,11.1363,2.3777,1.2934,117.4468,98.7557,77.7839,2.7652,3.7641,12.4277,3.3017,1.3612,4.4943,0.8000
 1615.5000,2446.1548,-0.0810,3.1198,3.4739,3.4585,3.4357,3.3174,3.1299,3.4739,0.3291,2.5509,0.0396,-0.5351,3.0481,30.3212,25.4619,25.4619,23.2708,0.0154,6.0083,9.3062,17.0661,9.3062,287.8573,11.2636,1.2580,1.3843,116.0423,96.8237,76.2407,2.7227,3.6893,12.1227,3.2859,1.3550,4.4525,4.0000
 1616.0000,2447.2378,-0.0931,2.8918,3.2697,3.2549,3.2359,3.1321,2.8987,3.2697,0.3281,2.5345,-0.1748,-1.2460,3.1028,33.5041,28.6722,28.6722,26.2547,0.0540,7.0000,10.2631,17.9411,10.2631,305.8388,11.6171,1.6931,1.6679,111.9801,95.4421,74.3001,2.6687,3.7574,11.7413,3.1248,1.4080,4.3996,8.0000
 1616.5000,2444.3474,-0.0704,2.2156,2.4338,2.4231,2.4134,2.3527,2.2183,2.4338,0.3287,2.4656,-0.0301,-0.5192,3.0808,37.1743,32.4418,32.4418,29.7329,0.0993,11.1779,14.2944,21.6275,14.2944,410.8851,11.9316,1.5195,1.0479,105.8099,94.2255,72.5607,2.6163,3.8302,11.4188,2.9812,1.4640,4.3645,1.6000
 1617.0000,2416.4309,-0.0245,1.9133,1.9784,1.9693,1.9657,1.9353,1.9159,1.9784,0.3291,2.3412,0.1115,0.4504,2.9441,39.3297,34.6890,34.6890,31.7940,0.0993,18.7159,21.5679,28.2787,21.5679,505.4688,12.6590,0.7481,0.8032,101.4215,93.3590,71.7224,2.5770,3.8408,11.3300,2.9499,1.4904,4.3966,1.6000
 1617.5000,2365.2390,0.0103,2.1223,2.0921,2.0817,2.0812,2.0712,2.1258,2.0921,0.3284,2.2617,-0.0236,0.7359,2.8248,36.8580,32.1142,32.1142,29.4316,0.0751,23.5337,26.2167,32.5297,26.2167,477.9778,13.0433,0.5543,0.6910,102.3262,90.8664,69.8227,2.5021,3.7464,11.0614,2.9525,1.4973,4.4209,5.0000
 1618.0000,2382.9639,-0.0063,2.3193,2.3394,2.3232,2.3238,2.3235,2.3234,2.3394,0.3294,2.3191,0.0040,0.3912,2.9337,30.0484,25.1893,25.1893,23.0164,0.0754,20.0558,22.8608,29.4610,22.8608,427.4554,12.5893,0.6452,0.7239,97.7288,82.0767,63.5573,2.2735,3.3144,10.0882,3.0438,1.4579,4.4374,4.8000
 1618.5000,2453.0647,-0.0079,3.5273,3.5656,3.5172,3.5152,3.4992,3.5315,3.5656,0.3290,2.4870,0.1164,0.0077,3.4301,20.7984,16.1905,16.1905,14.5272,0.0799,9.8768,13.0390,20.4795,13.0390,280.4574,11.7322,1.2689,1.3041,80.6210,69.4181,53.8326,1.9319,2.7866,8.5149,3.0557,1.4424,4.4076,4.0000
 1619.0000,2434.2703,0.0086,7.5228,7.4339,7.2561,7.2379,7.1208,7.5220,7.4339,0.3283,2.6269,0.0657,0.0983,4.0326,14.1997,10.0670,10.0670,8.6345,0.0596,1.3976,4.8573,12.9979,4.8573,134.5190,11.0210,17.9167,12.6633,64.7507,59.6049,46.3569,1.6664,2.3773,7.3193,3.0789,1.4266,4.3923,0.8000
 1619.5000,2470.3059,0.0054,10.0252,9.9513,9.6968,9.6522,9.4016,10.0252,9.9513,0.3293,2.6641,0.0129,0.1514,4.2423,13.5415,9.4700,9.4700,8.0543,0.0408,-0.8532,2.6855,11.0119,2.6855,100.4895,10.9678,11.2101,8.4296,62.8718,56.9509,44.4274,1.5974,2.2606,7.0126,3.1021,1.4151,4.3899,0.8000
 1620.0000,2498.0955,0.0087,8.3402,8.2405,8.0357,8.0025,7.8095,8.3402,8.2405,0.3273,2.6430,0.0006,-0.0180,4.1026,14.5174,10.3560,10.3560,8.9150,0.0328,0.4263,3.9201,12.1408,3.9201,121.3515,10.9769,7.4231,5.7949,71.9926,60.9923,47.6802,1.7050,2.4241,7.5708,3.1232,1.4218,4.4404,4.0000
 1620.5000,2512.2720,0.0102,6.6200,6.5273,6.3803,6.3601,6.2292,6.6200,6.5273,0.3294,2.6319,0.0026,-0.2751,4.0436,15.5910,11.3372,11.3372,9.8654,0.0265,1.1000,4.5701,12.7353,4.5702,153.2020,10.8924,5.9564,4.7034,83.1010,67.0782,52.3893,1.8683,2.6877,8.3426,3.1039,1.4386,4.4653,3.2000
 1621.0000,2511.7197,0.0100,5.1054,5.0353,4.9394,4.9307,4.8587,5.1052,5.0353,0.3283,2.6400,0.1593,-0.4742,4.1537,16.8854,12.5290,12.5290,11.0162,0.0251,0.6031,4.0907,12.2968,4.0907,198.5972,10.7998,6.2035,5.4940,89.6089,75.2708,58.5588,2.0748,3.0742,9.3889,3.0541,1.4817,4.5252,1.6000
 1621.5000,2436.1699,-0.0099,3.5697,3.6187,3.5689,3.5689,3.5690,3.5690,3.6187,0.3277,2.6236,0.3186,-0.3787,4.0546,20.0331,15.4675,15.4675,13.8367,0.0250,1.5998,5.0524,13.1763,5.0524,276.3394,10.6868,9.6539,6.6231,98.4927,86.3357,66.7468,2.3588,3.5917,10.7310,2.9877,1.5227,4.5494,5.0000
 1622.0000,2399.2131,0.0013,2.5527,2.5481,2.5266,2.5301,2.5351,2.5518,2.5481,0.3286,2.5747,0.1209,0.3143,3.6686,24.7686,19.9944,19.9944,18.1386,0.0213,4.5641,7.9127,15.7918,7.9127,392.4514,10.7861,5.1649,3.5225,116.6779,98.0512,75.4890,2.6513,4.1237,12.2143,2.9620,1.5553,4.6068,4.8000
 1622.5000,2438.8657,0.0323,2.2697,2.1694,2.1598,2.1648,2.1864,2.2687,2.1694,0.3290,2.5403,0.0264,0.4450,3.3678,28.8359,23.9827,23.9827,21.8888,0.0161,6.6496,9.9251,17.6320,9.9251,460.9553,10.8787,3.6485,2.1344,130.2411,108.5174,84.0107,2.9437,4.4903,13.6257,3.0345,1.5254,4.6287,2.4000
 1623.0000,2459.6868,0.0394,2.1515,2.0356,2.0335,2.0397,2.0725,2.1506,2.0356,0.3275,2.5411,0.0697,-0.1538,3.3303,30.4658,25.6066,25.6066,23.4057,0.0131,6.6002,9.8773,17.5884,9.8774,491.2623,10.9364,3.9743,2.1424,131.6409,111.4341,86.5311,3.0320,4.5511,14.0348,3.0838,1.5010,4.6289,1.0000
 1623.5000,2417.8018,0.0437,2.0493,1.9271,1.9305,1.9374,1.9758,2.0485,1.9271,0.3284,2.5539,-0.0876,0.0250,3.4953,31.5035,26.6480,26.6480,24.3757,0.0102,5.8262,9.1306,16.9055,9.1306,518.9121,10.9970,3.0596,1.7639,127.8143,109.8626,85.7360,3.0063,4.4392,13.8958,3.1302,1.4767,4.6223,3.2000
 1624.0000,2404.6948,0.0452,2.0107,1.8869,1.8941,1.9018,1.9432,2.0098,1.8869,0.3291,2.5638,-0.1657,0.2553,3.6019,30.7355,25.8766,25.8766,23.6575,0.0077,5.2236,8.5491,16.3737,8.5491,529.9705,11.0501,2.2523,1.3747,124.4793,107.4968,84.3405,2.9429,4.2798,13.7382,3.2100,1.4543,4.6683,3.2000
 1624.5000,2423.8132,0.0445,2.0539,1.9293,1.9398,1.9487,1.9927,2.0528,1.9293,0.3291,2.5627,-0.1638,0.1625,3.4741,29.3899,24.5331,24.5331,22.4035,0.0064,5.2904,8.6135,16.4327,8.6135,518.3149,11.0895,2.8019,1.8456,122.5825,105.5698,83.1812,2.8800,4.1585,13.6557,3.2838,1.4439,4.7415,9.0000
 1625.0000,2349.8186,0.0425,2.0958,1.9743,1.9872,1.9972,2.0402,2.0949,1.9743,0.3267,2.5551,-0.1170,0.0922,3.3058,29.2553,24.3992,24.3992,22.2783,0.0057,5.7519,9.0589,16.8399,9.0589,506.5004,11.0950,3.3154,2.1847,122.3737,104.5956,82.8221,2.8481,4.0432,13.6890,3.3857,1.4196,4.8063,0.8000
 1625.5000,2276.1470,0.0398,2.1130,1.9981,2.0120,2.0231,2.0603,2.1121,1.9981,0.3292,2.5555,-0.1261,-0.2928,3.2482,29.4827,24.6254,24.6254,22.4898,0.0073,5.7275,9.0353,16.8184,9.0353,500.4716,11.0788,3.7007,2.1258,124.1876,103.6449,82.0869,2.8068,3.9828,13.6435,3.4256,1.4190,4.8608,7.0000
 1626.0000,2336.4363,0.0362,2.1717,2.0642,2.0786,2.0914,2.1201,2.1709,2.0642,0.3286,2.5524,-0.2208,-0.3695,3.2288,29.6082,24.7504,24.7504,22.6066,0.0081,5.9180,9.2191,16.9864,9.2191,484.4488,11.0622,3.6810,2.0074,124.4169,104.5978,82.7881,2.8335,4.0069,13.7472,3.4309,1.4141,4.8517,6.4000
 1626.5000,2428.8921,0.0319,2.3193,2.2181,2.2333,2.2492,2.2676,2.3190,2.2181,0.3284,2.5404,-0.1932,-0.0101,3.1603,29.8349,24.9763,24.9763,22.8176,0.0087,6.6429,9.9186,17.6261,9.9186,450.8383,11.0342,3.9988,2.3260,126.2833,105.8462,84.2905,2.8835,3.9793,14.0033,3.5191,1.3800,4.8563,2.4000
 1627.0000,2463.9607,0.0241,2.4172,2.3373,2.3519,2.3705,2.3759,2.4173,2.3373,0.3280,2.5383,-0.1091,-0.1042,3.1046,29.2391,24.3831,24.3831,22.2633,0.0137,6.7697,10.0409,17.7379,10.0409,427.8483,11.0273,4.4161,2.4378,128.1534,107.9716,86.3481,2.9524,4.0049,14.3525,3.5837,1.3565,4.8613,6.0000
 1627.5000,2478.4937,0.0200,2.4649,2.3973,2.4097,2.4298,2.4236,2.4651,2.3973,0.3281,2.5412,-0.0422,-0.2807,3.0846,28.6047,23.7536,23.7536,21.6743,0.0178,6.5961,9.8734,17.5848,9.8734,417.1401,10.9573,4.3351,2.4720,128.6253,108.4501,87.0985,2.9736,3.9781,14.4982,3.6445,1.3378,4.8756,2.4000
 1628.0000,2492.3484,0.0181,2.4717,2.4102,2.4198,2.4402,2.4262,2.4718,2.4102,0.3282,2.5405,0.0557,0.0830,3.0535,28.9163,24.0625,24.0625,21.9634,0.0183,6.6369,9.9128,17.6208,9.9128,414.8960,10.9596,4.4134,2.5442,128.9679,107.5771,86.5722,2.9415,3.9343,14.4779,3.6799,1.3375,4.9220,2.4000
 1628.5000,2483.1699,0.0151,2.4192,2.3690,2.3757,2.3951,2.3779,2.4192,2.3690,0.3286,2.5367,0.1254,0.2994,3.0524,29.4315,24.5745,24.5745,22.4422,0.0186,6.8665,10.1343,17.8234,10.1343,422.1194,10.9660,4.3293,2.6810,125.1449,106.5284,85.2923,2.8932,3.9808,14.2865,3.5888,1.3759,4.9379,3.2000
 1629.0000,2511.6389,0.0130,2.3527,2.3105,2.3149,2.3327,2.3162,2.3527,2.3105,0.3280,2.5257,0.0075,0.1394,3.0534,29.1813,24.3256,24.3256,22.2095,0.0186,7.5319,10.7764,18.4105,10.7764,432.8035,10.9418,4.6182,2.7353,120.1879,104.9854,83.7231,2.8299,3.9970,14.0716,3.5205,1.4125,4.9726,1.6000
 1629.5000,2409.2441,0.0125,2.3142,2.2744,2.2771,2.2932,2.2800,2.3142,2.2744,0.3271,2.5134,-0.2985,-0.0643,3.0162,29.0552,24.2004,24.2004,22.0924,0.0158,8.2804,11.4986,19.0710,11.4987,439.6821,10.9116,4.3890,2.3898,119.3599,101.2045,79.9847,2.6878,3.9767,13.5178,3.3992,1.4795,5.0293,0.0000
 1630.0000,2450.8425,0.0128,2.2833,2.2432,2.2449,2.2591,2.2506,2.2833,2.2432,0.3267,2.5128,-0.4505,-0.0749,2.9797,29.5450,24.6874,24.6874,22.5478,0.0128,8.3142,11.5312,19.1007,11.5312,445.7948,10.8666,4.0717,2.2878,118.0297,97.9086,76.8489,2.5697,3.9162,13.0481,3.3318,1.5240,5.0776,0.0000
 1630.5000,2440.0862,0.0122,2.2663,2.2285,2.2297,2.2419,2.2386,2.2663,2.2285,0.3286,2.5168,-0.1421,0.1491,2.9438,28.9873,24.1330,24.1330,22.0294,0.0131,8.0744,11.2998,18.8891,11.2998,448.7418,10.8438,3.7330,2.1135,115.0042,94.6357,74.0749,2.4560,3.8087,12.6767,3.3284,1.5508,5.1616,1.6000
 1631.0000,2443.2881,0.0104,2.2420,2.2099,2.2110,2.2215,2.2231,2.2420,2.2099,0.3286,2.5064,0.2732,0.2363,2.9121,27.4695,22.6327,22.6327,20.6233,0.0132,8.7006,11.9041,19.4417,11.9041,452.5161,10.8377,4.4213,2.4570,115.2814,93.5989,73.5412,2.4222,3.7208,12.6617,3.4030,1.5361,5.2274,0.8000
 1631.5000,2443.3105,0.0168,2.2302,2.1789,2.1804,2.1892,2.1952,2.2302,2.1789,0.3280,2.4979,0.3154,-0.1476,2.8903,27.9179,23.0746,23.0746,21.0379,0.0114,9.2176,12.4029,19.8978,12.4029,458.9477,10.8314,4.2987,2.3914,118.4985,95.8060,75.5523,2.4816,3.7587,13.0402,3.4693,1.5146,5.2547,1.6000
 1632.0000,2440.8115,0.0192,2.1877,2.1300,2.1320,2.1395,2.1486,2.1877,2.1300,0.3271,2.4998,0.1311,-0.2154,2.8596,28.2042,23.3573,23.3573,21.3030,0.0094,9.1035,12.2929,19.7972,12.2929,469.4789,10.7028,3.6849,2.0567,119.0707,96.3273,76.3183,2.4971,3.7302,13.2184,3.5436,1.4938,5.2935,1.6000
 1632.5000,2477.3542,0.0206,2.1669,2.1057,2.1084,2.1152,2.1258,2.1669,2.1057,0.3280,2.4984,0.0738,0.1295,2.8314,28.4995,23.6494,23.6494,21.5767,0.0077,9.1863,12.3728,19.8703,12.3728,474.8999,10.6052,3.4898,1.8748,118.6703,96.7832,76.7294,2.5032,3.7328,13.3246,3.5696,1.4912,5.3231,0.0000
 1633.0000,2446.5349,0.0211,2.1702,2.1074,2.1108,2.1175,2.1282,2.1702,2.1074,0.3271,2.4980,0.0873,0.2381,2.8287,27.9792,23.1351,23.1351,21.0947,0.0064,9.2147,12.4002,19.8954,12.4002,474.5207,10.4514,3.6297,1.8994,119.5009,95.3269,75.1583,2.4460,3.7282,13.0799,3.5083,1.5242,5.3475,4.8000
 1633.5000,2506.7556,0.0207,2.1769,2.1151,2.1193,2.1262,2.1355,2.1769,2.1151,0.3287,2.4990,0.0596,0.3974,2.8726,27.4013,22.5656,22.5656,20.5603,0.0057,9.1495,12.3372,19.8378,12.3372,472.7820,10.4158,3.8803,2.0429,120.2307,95.0628,74.6404,2.4250,3.7459,13.0094,3.4730,1.5447,5.3647,3.2000
 1634.0000,2473.0930,0.0192,2.1876,2.1300,2.1347,2.1421,2.1489,2.1876,2.1300,0.3272,2.5001,0.3410,0.2195,2.9367,27.4459,22.6094,22.6094,20.6014,0.0055,9.0843,12.2743,19.7802,12.2743,469.4741,10.4122,4.1374,2.1967,119.0637,95.8652,74.8873,2.4343,3.8020,13.0463,3.4314,1.5618,5.3593,6.0000
 1634.5000,2413.7822,0.0155,2.2149,2.1676,2.1728,2.1809,2.1843,2.2149,2.1676,0.3270,2.5035,0.7624,0.1969,3.0085,27.6343,22.7949,22.7949,20.7756,0.0064,8.8808,12.0779,19.6007,12.0779,461.3401,10.3744,3.8633,2.1610,119.7908,96.8804,75.5028,2.4683,3.8724,13.0874,3.3797,1.5689,5.3023,3.2000
 1635.0000,2355.8413,0.0045,2.2226,2.2089,2.2144,2.2232,2.2229,2.2226,2.2089,0.3280,2.5057,0.6908,0.3752,3.1096,26.6198,21.7983,21.7983,19.8393,0.0085,8.7453,11.9472,19.4812,11.9473,452.7206,10.3329,4.1453,2.2517,122.9769,97.5977,75.8321,2.4870,3.9515,13.1066,3.3169,1.5889,5.2700,1.6000
 1635.5000,2355.5769,0.0135,2.2833,2.2410,2.2467,2.2560,2.2522,2.2833,2.2410,0.3262,2.5090,0.2331,-0.0805,3.1659,27.0599,22.2300,22.2300,20.2451,0.0116,8.5467,11.7556,19.3059,11.7556,446.2221,10.2557,3.8647,2.0945,122.8493,99.1490,77.0946,2.5350,4.0352,13.2934,3.2943,1.5918,5.2439,6.0000
 1636.0000,2400.8259,0.0143,2.3202,2.2747,2.2803,2.2898,2.2833,2.3202,2.2747,0.3278,2.5195,-0.1439,-0.2975,3.1238,27.4093,22.5734,22.5734,20.5677,0.0153,7.9103,11.1415,18.7444,11.1415,439.6156,10.2026,3.8527,2.0730,123.6763,100.5444,78.0900,2.5660,4.1148,13.4732,3.2743,1.6036,5.2506,0.0000
 1636.5000,2396.2417,0.0141,2.3891,2.3429,2.3485,2.3582,2.3497,2.3891,2.3429,0.3265,2.5346,-0.1680,-0.0730,3.0939,28.5723,23.7215,23.7215,21.6442,0.0160,6.9969,10.2602,17.9385,10.2602,426.8134,10.1748,4.1290,2.2389,130.9156,103.1584,79.9704,2.6209,4.2398,13.8305,3.2620,1.6177,5.2770,3.2000
 1637.0000,2433.3257,0.0141,2.4720,2.4240,2.4297,2.4394,2.4304,2.4720,2.4240,0.3270,2.5482,-0.0234,-0.0284,3.1503,30.2218,25.3625,25.3625,23.1781,0.0146,6.1692,9.4615,17.2081,9.4615,412.5355,10.1384,4.2439,2.2233,135.5907,106.4322,82.2489,2.6989,4.3837,14.2086,3.2412,1.6242,5.2645,6.4000
 1637.5000,2439.2449,0.0144,2.5281,2.4780,2.4838,2.4931,2.4857,2.5281,2.4780,0.3285,2.5595,-0.0781,-0.0627,3.2225,30.2097,25.3505,25.3505,23.1668,0.0162,5.4822,8.7986,16.6019,8.7986,403.5563,10.1047,4.4650,2.3249,135.0491,107.5747,82.7451,2.7202,4.4652,14.2709,3.1960,1.6415,5.2463,5.6000
 1638.0000,2424.3081,0.0129,2.5366,2.4917,2.4978,2.5064,2.5025,2.5365,2.4917,0.3263,2.5606,-0.1639,-0.0795,3.2507,29.1734,24.3178,24.3178,22.2023,0.0163,5.4174,8.7361,16.5448,8.7361,401.3389,10.0813,4.5406,2.2325,133.6145,105.5583,80.8713,2.6833,4.3972,13.8304,3.1453,1.6387,5.1543,6.0000
 1638.5000,2458.7544,0.0059,2.4482,2.4285,2.4347,2.4424,2.4435,2.4481,2.4285,0.3269,2.5447,-0.0073,-0.0958,3.2455,26.5626,21.7423,21.7423,19.7865,0.0139,6.3839,9.6686,17.3975,9.6687,411.7774,10.0283,4.9219,2.5002,125.6998,99.0989,75.8384,2.5358,4.1054,12.8771,3.1366,1.6190,5.0781,3.2000
 1639.0000,2432.0930,0.0208,2.3963,2.3278,2.3338,2.3407,2.3481,2.3962,2.3278,0.3275,2.5206,0.2236,0.0538,3.1884,25.4106,20.6178,20.6178,18.7272,0.0131,7.8429,11.0765,18.6849,11.0765,429.5938,9.9701,5.1858,2.5969,112.7479,91.0582,69.6955,2.3353,3.7426,11.8108,3.1558,1.6026,5.0575,5.6000
 1639.5000,2478.4138,0.0277,2.3105,2.2229,2.2285,2.2348,2.2480,2.3108,2.2229,0.3262,2.5063,0.2923,0.2733,3.0629,25.4729,20.6784,20.6784,18.7844,0.0120,8.7116,11.9147,19.4514,11.9147,449.8656,9.9204,4.0370,1.9515,106.1903,88.0862,67.5864,2.2700,3.5705,11.4281,3.2007,1.5729,5.0345,1.0000
 1640.0000,2434.5347,0.0337,2.3190,2.2122,2.2174,2.2239,2.2422,2.3192,2.2122,0.3274,2.5083,0.2184,-0.1589,2.9670,26.8647,22.0384,22.0384,20.0650,0.0110,8.5854,11.7929,19.3401,11.7929,452.0318,9.9456,4.1251,2.3103,109.5378,88.6107,67.9995,2.2904,3.5631,11.4667,3.2182,1.5556,5.0064,2.4000
 1640.5000,2430.3081,0.0382,2.3809,2.2568,2.2609,2.2678,2.2908,2.3805,2.2568,0.3268,2.5148,0.0378,-0.6860,2.9746,26.9607,22.1325,22.1325,20.1535,0.0122,8.1942,11.4155,18.9949,11.4155,443.1006,9.9634,4.1799,2.3806,115.4887,92.7617,70.7736,2.4140,3.7556,11.7915,3.1398,1.5557,4.8847,4.8000
 1641.0000,2436.4702,0.0419,2.4929,2.3503,2.3522,2.3597,2.3877,2.4922,2.3503,0.3290,2.5204,-0.1571,-0.2432,3.0309,27.6886,22.8485,22.8485,20.8259,0.0140,7.8530,11.0862,18.6938,11.0862,425.4799,9.9667,4.2384,2.4739,121.4253,96.4891,72.6237,2.5182,4.0144,11.9050,2.9656,1.5942,4.7276,4.0000
 1641.5000,2418.9995,0.0458,2.6101,2.4472,2.4452,2.4530,2.4859,2.6092,2.4472,0.3287,2.5263,-0.2976,0.1982,3.0387,28.3591,23.5105,23.5105,21.4465,0.0144,7.4945,10.7403,18.3775,10.7403,408.6230,9.9576,4.8606,2.6360,124.9923,98.3212,72.8537,2.5616,4.2440,11.7743,2.7743,1.6568,4.5964,4.8000
 1642.0000,2400.8721,0.0487,2.7690,2.5854,2.5772,2.5849,2.6219,2.7680,2.5854,0.3284,2.5313,-0.4181,0.2508,2.9738,27.5914,22.7527,22.7527,20.7360,0.0167,7.1947,10.4510,18.1130,10.4510,386.7854,9.9517,4.8737,2.5885,123.2311,97.6975,71.7001,2.5426,4.3190,11.4857,2.6593,1.6987,4.5173,0.0000
 1642.5000,2392.1423,0.0472,3.1843,2.9792,2.9595,2.9676,3.0089,3.1829,2.9792,0.3276,2.5411,-0.4122,0.1059,2.9996,25.2098,20.4226,20.4226,18.5429,0.0203,6.5997,9.8769,17.5879,9.8769,335.6559,9.9349,4.3174,2.2805,118.9718,92.0919,67.5890,2.4117,4.0654,10.7563,2.6458,1.6857,4.4600,2.4000
 1643.0000,2434.3052,0.0287,3.5710,3.4306,3.3950,3.4014,3.4308,3.5694,3.4306,0.3264,2.5695,-0.2307,0.0209,3.3154,21.7843,17.1268,17.1268,15.4194,0.0190,4.8765,8.2142,16.0675,8.2142,291.4968,9.8841,4.9484,2.8626,106.9942,82.4613,60.8950,2.1663,3.5925,9.7225,2.7063,1.6584,4.4882,4.8000
 1643.5000,2396.7603,-0.0137,4.8888,4.9814,4.8961,4.8999,4.8919,4.8882,4.9814,0.3277,2.6181,0.1143,0.2288,3.7732,16.9855,12.6215,12.6215,11.1053,0.0161,1.9335,5.3744,13.4707,5.3744,200.7474,9.8325,12.0974,9.5903,88.6091,71.4384,52.9735,1.8774,3.0874,8.4913,2.7503,1.6446,4.5230,4.0000
 1644.0000,2440.2356,-0.0045,6.7673,6.8096,6.6698,6.6637,6.6004,6.7714,6.8096,0.3278,2.6587,0.4386,0.2557,4.0117,14.5479,10.3837,10.3837,8.9419,0.0177,-0.5250,3.0022,11.3015,3.0022,146.8516,9.7360,16.6029,12.0354,78.2879,63.9887,47.6552,1.6765,2.7613,7.6976,2.7877,1.6470,4.5914,3.2000
 1644.5000,2418.5845,-0.0218,6.3723,6.5645,6.4247,6.4132,6.3172,6.3754,6.5645,0.3283,2.6682,0.2965,-0.0133,3.9068,15.3362,11.1037,11.1037,9.6395,0.0196,-1.1042,2.4433,10.7904,2.4433,152.3345,9.7520,13.0977,9.3727,80.2250,63.1652,46.9711,1.6451,2.7496,7.6219,2.7720,1.6714,4.6331,2.4000
 1645.0000,2418.4463,-0.0233,5.1763,5.3432,5.2234,5.2120,5.1247,5.1764,5.3432,0.3276,2.6552,-0.2328,-0.5153,3.6313,17.1294,12.7547,12.7547,11.2337,0.0176,-0.3151,3.2047,11.4866,3.2047,187.1526,9.8152,9.6645,6.2425,87.1157,67.4450,49.9114,1.7549,2.9643,8.0666,2.7213,1.6891,4.5965,3.2000
 1645.5000,2419.6216,-0.0203,4.4822,4.6082,4.5027,4.4920,4.4161,4.4822,4.6082,0.3283,2.6382,-0.4223,-0.4001,3.4267,19.1719,14.6578,14.6578,13.0619,0.0166,0.7144,4.1980,12.3950,4.1981,217.0067,9.8249,7.1162,4.3836,93.3112,72.2560,53.1581,1.8799,3.2078,8.5399,2.6622,1.7063,4.5427,0.0000
 1646.0000,2427.0376,-0.0187,4.3914,4.5053,4.4032,4.3918,4.3171,4.3914,4.5053,0.3278,2.6263,-0.0798,0.3068,3.4201,19.9609,15.3994,15.3994,13.7716,0.0178,1.4346,4.8930,13.0305,4.8930,221.9597,9.8659,6.8110,4.2124,94.0940,73.1003,53.4824,1.9112,3.2872,8.4978,2.5851,1.7199,4.4462,9.0000
 1646.5000,2415.3140,-0.0199,4.6719,4.8007,4.6960,4.6830,4.6015,4.6719,4.8007,0.3275,2.6279,0.2306,0.4189,3.5671,18.9650,14.4640,14.4640,12.8761,0.0182,1.3412,4.8029,12.9481,4.8029,208.3019,9.8842,8.5662,6.4333,88.3244,70.9617,51.6809,1.8750,3.2459,8.0779,2.4887,1.7311,4.3082,2.0000
 1647.0000,2340.0520,-0.0203,4.7048,4.8372,4.7425,4.7299,4.6534,4.7048,4.8372,0.3278,2.6461,-0.0014,0.0047,3.7022,18.3924,13.9287,13.9287,12.3626,0.0209,0.2346,3.7351,11.9717,3.7352,206.7293,9.8503,11.4929,8.7850,83.0263,69.4704,50.7073,1.8562,3.2001,7.8472,2.4522,1.7240,4.2275,7.2000
 1647.5000,2277.6204,-0.0126,4.2212,4.2947,4.2252,4.2162,4.1641,4.2212,4.2947,0.3271,2.6486,-0.5310,-0.1833,3.7271,19.0729,14.5650,14.5650,12.9730,0.0230,0.0855,3.5913,11.8402,3.5913,232.8437,9.8534,17.1199,11.6098,87.1840,72.8767,53.3147,1.9644,3.3738,8.1907,2.4278,1.7175,4.1697,9.0000
 1648.0000,2305.7439,0.0013,3.4658,3.4595,3.4185,3.4144,3.3940,3.4658,3.4595,0.3264,2.6169,-0.5087,-0.0343,3.5221,23.0059,18.2946,18.2946,16.5292,0.0182,2.0077,5.4461,13.5362,5.4461,289.0587,9.8736,7.6660,4.5590,102.8428,80.9242,59.3487,2.1889,3.7559,9.1069,2.4247,1.7158,4.1604,1.6000
 1648.5000,2321.4072,-0.0057,2.9820,3.0056,2.9830,2.9823,2.9802,2.9820,3.0056,0.3274,2.5793,-0.0574,0.2649,3.1724,26.9806,22.1521,22.1521,20.1719,0.0094,4.2838,7.6423,15.5445,7.6423,332.7101,9.9675,4.3050,2.3968,119.6891,90.6493,66.8827,2.4532,4.1853,10.3277,2.4676,1.7061,4.2099,1.6000
 1649.0000,2327.5569,0.0146,2.8690,2.8114,2.8009,2.8031,2.8110,2.8690,2.8114,0.3272,2.5547,-0.1438,-0.1066,2.9976,27.7868,22.9453,22.9453,20.9167,0.0027,5.7742,9.0804,16.8596,9.0804,355.6931,9.9503,4.0589,2.1293,128.0258,97.5545,72.6773,2.6608,4.4144,11.2458,2.5475,1.6591,4.2264,5.6000
 1649.5000,2364.2258,0.0236,2.8198,2.7287,2.7284,2.7329,2.7456,2.8198,2.7287,0.3273,2.5477,-0.4120,-0.5326,2.9985,28.6396,23.7882,23.7882,21.7067,-0.0005,6.2006,9.4918,17.2358,9.4918,366.4781,9.9473,4.2139,2.2385,127.7224,100.8975,76.1278,2.7786,4.4486,11.8203,2.6571,1.6010,4.2541,5.6000
 1650.0000,2375.2363,0.0262,2.8153,2.7141,2.7218,2.7290,2.7423,2.8153,2.7141,0.3277,2.5519,-0.0930,-0.1069,3.0773,29.3886,24.5317,24.5317,22.4023,-0.0020,5.9425,9.2428,17.0081,9.2428,368.4492,10.0615,4.3531,2.3366,124.5614,101.4474,77.7215,2.8176,4.3118,12.1586,2.8198,1.5303,4.3152,3.0000
 1650.5000,2309.1528,0.0262,2.8154,2.7145,2.7293,2.7393,2.7500,2.8154,2.7145,0.3282,2.5556,0.3262,0.0801,3.1726,28.1124,23.2665,23.2665,21.2180,-0.0019,5.7241,9.0320,16.8153,9.0320,368.3982,9.9328,4.4579,2.3795,122.4558,100.1157,77.7332,2.7918,4.1159,12.2846,2.9847,1.4743,4.4002,4.0000
 1651.0000,2338.2324,0.0234,2.7790,2.6898,2.7104,2.7230,2.7293,2.7790,2.6898,0.3264,2.5547,0.5224,0.2129,3.2180,27.5233,22.6857,22.6857,20.6730,-0.0001,5.7770,9.0830,16.8620,9.0830,371.7713,9.9238,4.4927,2.4219,122.9644,98.9519,77.9182,2.7660,3.9166,12.4680,3.1834,1.4160,4.5076,5.0000
 1651.5000,2374.6941,0.0120,2.7064,2.6616,2.6866,2.7019,2.7033,2.7064,2.6616,0.3267,2.5542,0.6964,0.3817,3.2424,27.9936,23.1493,23.1493,21.1080,0.0034,5.8073,9.1123,16.8888,9.1123,375.7112,9.8671,4.7302,2.5128,123.4640,98.0032,78.1082,2.7406,3.7467,12.6508,3.3765,1.3671,4.6160,1.6000
 1652.0000,2419.1030,0.0186,2.7368,2.6668,2.6959,2.7144,2.7113,2.7368,2.6668,0.3280,2.5634,0.6440,0.1851,3.2269,28.8844,24.0308,24.0308,21.9338,0.0089,5.2458,8.5705,16.3933,8.5705,374.9815,9.7994,4.8939,2.5990,121.9842,97.2748,77.8462,2.7156,3.6491,12.6834,3.4757,1.3438,4.6705,3.2000
 1652.5000,2370.5947,0.0253,2.7848,2.6884,2.7213,2.7434,2.7368,2.7848,2.6884,0.3269,2.5747,0.2092,-0.2078,3.1775,29.4136,24.5567,24.5567,22.4256,0.0135,4.5615,7.9102,15.7895,7.9102,371.9744,9.8116,4.6641,2.5269,120.0825,97.0831,77.4185,2.6954,3.6643,12.6391,3.4492,1.3595,4.6892,4.0000
 1653.0000,2326.9001,0.0283,2.7937,2.6853,2.7209,2.7463,2.7374,2.7937,2.6853,0.3269,2.5782,-0.2555,-0.2507,3.1639,28.6161,23.7649,23.7649,21.6848,0.0142,4.3522,7.7082,15.6048,7.7082,372.3973,9.8449,4.4139,2.3742,121.6614,96.7458,76.3933,2.6699,3.7380,12.4231,3.3235,1.4000,4.6530,0.8000
 1653.5000,2379.8081,0.0304,2.7626,2.6477,2.6844,2.7120,2.7015,2.7626,2.6477,0.3263,2.5728,-0.4715,0.2390,3.1944,28.2691,23.4214,23.4214,21.3631,0.0120,4.6768,8.0214,15.8912,8.0214,377.6817,9.8581,4.3062,2.2363,122.5263,96.9006,75.8530,2.6702,3.8330,12.2442,3.1945,1.4355,4.5855,3.2000
 1654.0000,2329.3069,0.0317,2.7404,2.6216,2.6589,2.6882,2.6762,2.7404,2.6216,0.3273,2.5639,-0.3931,0.5231,3.2156,29.0498,24.1950,24.1950,22.0874,0.0093,5.2191,8.5447,16.3698,8.5447,381.4455,9.8746,4.2809,2.2464,120.9998,97.3789,76.0063,2.6905,3.8834,12.1983,3.1411,1.4434,4.5339,2.0000
 1654.5000,2315.4531,0.0322,2.7155,2.5960,2.6331,2.6630,2.6502,2.7155,2.5960,0.3260,2.5568,-0.0322,0.3825,3.2288,28.8294,23.9763,23.9763,21.8828,0.0082,5.6510,8.9614,16.7508,8.9615,385.2136,9.8979,4.5188,2.3444,122.1391,98.4266,76.5776,2.7211,3.9473,12.2408,3.1011,1.4506,4.4985,4.0000
 1655.0000,2361.9922,0.0319,2.6954,2.5779,2.6140,2.6432,2.6307,2.6954,2.5779,0.3258,2.5528,0.1434,-0.0246,3.2968,28.9388,24.0848,24.0848,21.9843,0.0088,5.8887,9.1908,16.9606,9.1909,387.9197,9.9194,4.1573,2.2023,123.0955,100.5722,77.6785,2.7563,4.1176,12.4355,3.0201,1.4939,4.5117,3.2000
 1655.5000,2396.0349,0.0306,2.6984,2.5854,2.6201,2.6472,2.6366,2.6984,2.5854,0.3262,2.5577,-0.1572,-0.2189,3.3736,28.6991,23.8471,23.8471,21.7618,0.0093,5.5957,8.9081,16.7021,8.9081,386.7895,9.9397,4.1765,2.2284,122.4612,101.9265,77.8941,2.7539,4.2960,12.5178,2.9138,1.5600,4.5455,2.4000
 1656.0000,2341.7109,0.0247,2.6848,2.5940,2.6257,2.6484,2.6422,2.6848,2.5940,0.3265,2.5644,-0.3830,-0.1277,3.3487,29.8477,24.9890,24.9890,22.8295,0.0101,5.1875,8.5142,16.3419,8.5142,385.5097,9.9500,4.0193,2.1483,121.5761,101.9179,76.8109,2.7060,4.4581,12.3889,2.7790,1.6475,4.5783,3.2000
 1656.5000,2281.0754,0.0116,2.6296,2.5876,2.6143,2.6301,2.6298,2.6295,2.5876,0.3281,2.5635,-0.2002,0.0593,3.2294,29.4205,24.5635,24.5635,22.4319,0.0111,5.2438,8.5686,16.3916,8.5686,386.4629,9.9563,4.0764,2.0938,122.4906,102.3766,76.5334,2.6679,4.5753,12.4786,2.7274,1.7150,4.6773,3.0000
 1657.0000,2331.4731,0.0156,2.6455,2.5889,2.6094,2.6160,2.6202,2.6432,2.5889,0.3267,2.5586,0.1107,0.1052,3.0968,29.3121,24.4557,24.4557,22.3312,0.0100,5.5422,8.8565,16.6548,8.8565,386.2624,9.9905,4.1775,2.2398,124.7327,102.2462,76.0950,2.6254,4.6096,12.5365,2.7196,1.7558,4.7751,3.2000
 1657.5000,2367.5999,0.0070,2.6400,2.6146,2.6279,2.6231,2.6254,2.6296,2.6146,0.3274,2.5527,0.2725,-0.2090,3.0762,29.7889,24.9305,24.9305,22.7748,0.0087,5.8986,9.2004,16.9694,9.2004,382.4647,10.0455,4.4883,2.4859,127.0693,102.4395,75.8872,2.5876,4.6547,12.6476,2.7172,1.7989,4.8878,4.8000
 1658.0000,2367.7380,0.0100,2.7036,2.6666,2.6715,2.6527,2.6400,2.7083,2.6666,0.3272,2.5485,0.1111,-0.4025,3.1506,31.1124,26.2548,26.2548,24.0097,0.0084,6.1521,9.4450,17.1930,9.4450,375.0099,10.0838,4.1717,2.2844,127.0890,103.3200,76.1460,2.5808,4.7491,12.7645,2.6878,1.8401,4.9459,5.0000
 1658.5000,2379.1748,-0.0200,2.6872,2.7617,2.7564,2.7215,2.6722,2.7426,2.7617,0.3282,2.5491,-0.2214,-0.3441,3.1527,30.0104,25.1514,25.1514,22.9811,0.0061,6.1131,9.4073,17.1586,9.4074,362.0948,10.0978,4.0400,2.1781,126.1798,102.6823,75.0746,2.5436,4.8013,12.5891,2.6220,1.8876,4.9493,5.6000
 1659.0000,2400.3311,-0.0620,2.7020,2.9360,2.9192,2.8659,2.7527,2.7782,2.9360,0.3267,2.5565,-0.4503,-0.2725,3.1754,29.5893,24.7316,24.7316,22.5890,0.0041,5.6639,8.9740,16.7623,8.9740,340.6018,10.1005,3.9550,2.2354,124.8763,102.1661,73.9882,2.5085,4.8684,12.3992,2.5469,1.9408,4.9430,2.4000
 1659.5000,2421.2332,-0.1234,2.8350,3.3278,3.2971,3.2198,3.0114,2.9098,3.3278,0.3275,2.5700,-0.5825,-0.1897,3.3564,27.9944,23.1501,23.1501,21.1088,0.0058,4.8510,8.1895,16.0450,8.1895,300.4954,10.0817,4.7156,2.6685,122.1433,100.3725,71.9249,2.4394,4.8706,12.0490,2.4738,1.9966,4.9393,3.0000
 1660.0000,2451.8220,-0.2177,3.1429,4.1139,4.0634,3.9500,3.6140,3.2053,4.1139,0.3258,2.5839,-0.4712,0.0669,3.5651,27.9561,23.1123,23.1123,21.0733,0.0107,4.0054,7.3736,15.2988,7.3736,243.0796,10.0448,4.4161,2.4231,120.2741,96.9438,68.3478,2.3300,4.8368,11.3936,2.3556,2.0759,4.8901,4.0000
 1660.5000,2417.8940,-0.3192,3.3308,4.8390,4.7679,4.6193,4.1865,3.4327,4.8390,0.3269,2.5706,-0.4318,-0.2291,3.6660,30.0134,25.1544,25.1544,22.9839,0.0350,4.8147,8.1545,16.0129,8.1545,206.6553,10.0385,5.0382,3.2813,117.7049,94.9112,65.4809,2.2460,4.9168,10.8502,2.2067,2.1891,4.8308,1.0000
 1661.0000,2437.6096,-0.3898,2.1288,3.2993,3.2458,3.1401,2.8416,2.2893,3.2993,0.3275,2.4723,-0.8459,-1.4634,3.5600,34.8975,30.0948,30.0948,27.5705,0.1091,10.7669,13.8979,21.2649,13.8979,303.0959,10.0985,4.1703,2.0720,114.9882,92.2587,62.0860,2.1436,5.0005,10.2212,2.0440,2.3328,4.7683,0.8000
 1661.5000,2464.2024,-0.3990,1.2490,1.9512,1.9175,1.8550,1.6773,1.3635,1.9512,0.3279,2.2239,-0.8721,-1.3374,3.1188,41.5499,37.0294,37.0294,33.9312,0.1881,25.8264,28.4290,34.5527,28.4290,512.5171,10.5274,0.9256,0.5437,109.3959,87.3821,57.3521,1.9921,4.9553,9.3850,1.8939,2.4874,4.7110,5.6000
 1662.0000,2428.3850,-0.3705,1.1777,1.7943,1.7597,1.7019,1.5367,1.2885,1.7943,0.3262,1.9552,-0.2193,0.5994,2.6436,38.4266,33.7444,33.7444,30.9288,0.2004,42.1079,44.1392,48.9187,44.1392,557.3074,11.8732,0.2914,0.4762,97.7493,78.8593,50.3846,1.7496,4.6940,8.2474,1.7570,2.6830,4.7140,2.0000
 1662.5000,2455.4490,-0.3543,1.8721,2.8107,2.7453,2.6517,2.3907,2.0524,2.8107,0.3265,2.0286,0.4516,1.5230,2.9117,31.8028,26.9495,26.9495,24.6560,0.1813,37.6602,39.8476,44.9943,39.8476,355.7775,11.2426,1.1940,1.3780,78.9464,61.2319,37.9976,1.3185,3.8242,6.2243,1.6276,2.9005,4.7208,7.2000
 1663.0000,2463.6953,-0.3691,4.0003,6.0873,5.9140,5.6986,5.1281,4.3935,6.0875,0.3270,2.3919,0.8741,0.8051,3.8179,19.8169,15.2638,15.2638,13.6420,0.1431,15.6418,18.6018,25.5663,18.6018,164.2775,9.4691,34.4603,51.5626,54.4438,44.5257,26.7738,0.9204,2.9096,4.4269,1.5215,3.1614,4.8100,5.0000
 1663.5000,2460.2976,-0.3866,8.4333,13.0162,12.5696,12.0747,10.8447,9.1606,13.0334,0.3275,2.6186,0.8912,0.0414,4.3768,12.4483,8.4841,8.4841,7.0939,0.0740,1.9039,5.3458,13.4446,5.3459,76.8275,9.3362,39.8780,68.5469,37.1624,33.3913,19.4680,0.6603,2.2706,3.2615,1.4364,3.4390,4.9397,4.8000
 1664.0000,2461.4729,-0.3967,11.2032,17.4329,16.7144,15.9984,14.3603,11.9455,17.4663,0.3271,2.6581,0.5543,-0.0933,4.5158,10.1327,6.4190,6.4190,5.0723,0.0290,-0.4927,3.0334,11.3300,3.0334,57.3628,9.1583,25.4515,31.8693,29.5472,26.0794,14.5663,0.4851,1.8581,2.4827,1.3362,3.8306,5.1183,1.6000
 1664.5000,2464.6973,-0.3915,14.9015,23.0655,21.9542,20.9393,18.8779,15.6649,23.1273,0.3272,2.6651,0.1704,-0.0361,4.7088,8.1329,4.6613,4.6613,3.3405,0.0182,-0.9168,2.6241,10.9557,2.6241,43.3548,9.1457,23.3359,30.0980,25.5659,21.5676,11.3350,0.3723,1.6339,1.9564,1.1974,4.3886,5.2547,1.0000
 1665.0000,2535.9846,-0.3337,15.3058,22.4843,21.2597,20.2265,18.5298,15.9911,22.5452,0.3259,2.6652,-0.0896,0.2705,4.8978,7.8185,4.3871,4.3871,3.0695,0.0177,-0.9188,2.6221,10.9539,2.6222,44.4754,9.1412,26.7263,29.3794,23.6172,18.7614,9.1747,0.2998,1.5171,1.5909,1.0487,5.0603,5.3066,4.0000
 1665.5000,2466.7588,-0.2389,12.2198,16.3338,15.3636,14.6007,13.7189,12.8220,16.3665,0.3274,2.6512,-0.1532,0.4171,4.9425,8.7807,5.2280,5.2280,3.9000,0.0199,-0.0730,3.4383,11.7003,3.4383,61.2226,9.1454,23.2814,22.8486,22.9641,18.0612,8.3374,0.2724,1.5271,1.4461,0.9469,5.6069,5.3092,5.6000
 1666.0000,2481.2581,-0.1472,9.8890,11.9283,11.1793,10.6227,10.2094,10.1962,11.9457,0.3274,2.6244,-0.1347,-0.2725,4.8352,10.1426,6.4278,6.4278,5.0809,0.0180,1.5529,5.0072,13.1349,5.0072,83.8344,9.1580,23.8280,21.1258,24.2485,18.3105,8.1540,0.2596,1.5874,1.4464,0.9112,6.1144,5.5712,4.0000
 1666.5000,2455.8293,-0.0945,9.0800,10.2711,9.6136,9.1520,8.9300,9.1095,10.2838,0.3266,2.6048,-0.1631,-0.3089,4.6911,10.7072,6.9284,6.9284,5.5722,0.0138,2.7402,6.1528,14.1825,6.1528,97.3606,9.1776,15.1363,12.5987,24.7994,18.3982,7.9113,0.2493,1.6150,1.4155,0.8765,6.4778,5.6775,4.0000
 1667.0000,2446.8813,-0.0997,9.3660,10.6642,9.9730,9.4966,9.3095,9.4513,10.6774,0.3270,2.6071,-0.0038,0.4173,4.6592,10.3420,6.6044,6.6044,5.2543,0.0126,2.6007,6.0182,14.0595,6.0183,93.7713,9.2153,16.4876,13.0718,24.1770,18.8675,7.5283,0.2372,1.7181,1.3471,0.7841,7.2430,5.6791,7.2000
 1667.5000,2456.8201,-0.1121,9.9897,11.5506,10.8129,10.3114,10.1185,10.1405,11.5652,0.3270,2.6223,0.3000,0.2559,4.6695,9.6728,6.0127,6.0127,4.6728,0.0119,1.6798,5.1296,13.2469,5.1296,86.5758,9.2195,15.1966,13.7512,25.7120,19.6368,7.1820,0.2318,1.8579,1.2590,0.6776,8.0149,5.4313,4.0000
 1668.0000,2351.4888,-0.1029,10.0440,11.4836,10.7822,10.3134,10.1389,10.1410,11.4969,0.3271,2.6434,0.2639,-0.1742,4.6622,9.8777,6.1936,6.1936,4.8507,0.0079,0.3977,3.8925,12.1156,3.8925,87.0810,9.2150,23.4028,24.5929,28.6206,22.0909,7.6024,0.2560,2.1354,1.2822,0.6005,8.3409,5.0084,0.8000
 1668.5000,2309.8669,-0.0794,9.3290,10.3659,9.7741,9.3822,9.2496,9.3802,10.3659,0.3268,2.6499,-0.0102,0.2009,4.6439,10.7219,6.9414,6.9414,5.5850,0.0041,0.0086,3.5170,11.7723,3.5170,96.4697,9.2113,26.0976,25.6493,33.5606,26.0486,9.0922,0.3136,2.4881,1.4981,0.6021,7.9329,4.7764,2.0000
 1669.0000,2237.1860,-0.0571,8.2629,8.9216,8.4660,8.1705,8.0655,8.2849,8.9216,0.3269,2.6274,-0.1886,0.6313,4.5632,11.2380,7.4008,7.4008,6.0351,0.0009,1.3723,4.8329,12.9756,4.8329,112.0876,9.1831,19.8579,16.3508,39.8426,29.2808,11.1225,0.3902,2.6628,1.8017,0.6766,6.8243,4.6175,1.6000
 1669.5000,2320.9236,-0.0491,8.0519,8.6028,8.2154,7.9575,7.8307,8.0777,8.6028,0.3277,2.6045,-0.1219,0.1203,4.4971,10.6699,6.8953,6.8953,5.5397,-0.0024,2.7552,6.1673,14.1958,6.1673,116.2416,9.1932,11.4532,7.8450,43.3658,31.5606,13.1559,0.4756,2.7185,2.0644,0.7594,5.7158,4.3404,3.0000
 1670.0000,2408.6345,-0.0559,9.4026,10.1356,9.7200,9.4223,9.1855,9.4511,10.1356,0.3261,2.6061,0.3053,-0.4895,4.5449,9.7967,6.1220,6.1220,4.7804,-0.0034,2.6626,6.0779,14.1140,6.0779,98.6625,9.1876,15.1088,11.9610,43.6567,33.3451,14.7274,0.5473,2.7806,2.2402,0.8056,5.0803,4.0929,4.0000
 1670.5000,2403.9819,-0.0729,10.8977,12.0086,11.5955,11.2703,10.8836,10.9646,12.0086,0.3264,2.6314,0.5139,-0.3676,4.6067,8.5939,5.0644,5.0644,3.7386,-0.0019,1.1293,4.5985,12.7612,4.5985,83.2736,9.1799,15.6604,15.5468,44.5819,33.9991,15.6998,0.5956,2.7726,2.3307,0.8406,4.6553,3.9135,2.4000
 1671.0000,2427.7283,-0.0986,12.1134,13.7912,13.4218,13.0900,12.5730,12.1921,13.7912,0.3263,2.6592,0.2461,-0.2294,4.5953,8.1525,4.6784,4.6784,3.3575,-0.0015,-0.5570,2.9713,11.2732,2.9713,72.5100,9.1010,16.6903,13.6643,46.0311,36.3302,17.4242,0.6689,2.8980,2.5490,0.8796,4.3322,3.8104,2.0000
 1671.5000,2401.4243,-0.1050,10.6789,12.2544,12.0268,11.7689,11.2865,10.7330,12.2544,0.3272,2.6770,0.1215,-0.5834,4.5417,9.0091,5.4285,5.4285,4.0977,0.0017,-1.6370,1.9292,10.3203,1.9292,81.6034,9.0063,26.2269,22.4307,49.5820,42.0667,20.8898,0.8047,3.2750,3.0433,0.9292,4.0701,3.7821,5.6000
 1672.0000,2440.1548,-0.0794,7.2004,8.0009,7.9228,7.7836,7.5054,7.2208,8.0009,0.3270,2.6524,0.2252,-0.7054,4.3480,11.5596,7.6878,7.6878,6.3159,0.0084,-0.1440,3.3698,11.6376,3.3698,124.9861,8.9749,33.4298,29.4324,63.0279,49.6648,25.3466,0.9836,3.7723,3.6580,0.9697,3.8352,3.7190,0.0000
 1672.5000,2452.2708,-0.0403,4.9980,5.2782,5.2731,5.2034,5.0666,5.0031,5.2782,0.3273,2.5571,0.2487,0.0747,3.9946,15.4609,11.2179,11.2179,9.7500,0.0069,5.6330,8.9441,16.7350,8.9442,189.4591,8.9925,21.1034,10.7923,77.6893,55.4276,29.0281,1.1403,4.1056,4.1235,1.0044,3.6003,3.6160,3.0000
 1673.0000,2456.0598,-0.0050,4.1091,4.1373,4.1653,4.1293,4.0671,4.1089,4.1373,0.3260,2.4933,0.0089,0.6145,3.8025,20.0991,15.5297,15.5297,13.8962,-0.0012,9.4940,12.6696,20.1417,12.6696,241.7021,9.0524,6.7626,5.8168,77.1745,59.4844,32.0959,1.2630,4.2811,4.5492,1.0626,3.3896,3.6019,8.0000
 1673.5000,2482.4907,0.0179,3.5105,3.4244,3.4630,3.4491,3.4389,3.5071,3.4244,0.3260,2.5156,-0.2677,-0.0165,3.7061,19.3751,14.8485,14.8485,13.2445,-0.0081,8.1439,11.3669,18.9505,11.3669,292.0252,9.0474,19.2215,14.3918,76.8470,62.6376,34.9772,1.3817,4.3456,4.9324,1.1350,3.1452,3.5698,7.0000
 1674.0000,2443.7019,0.0258,2.6786,2.5840,2.6149,2.6145,2.6239,2.6728,2.5840,0.3269,2.5452,-0.0933,-0.5727,3.4260,21.9268,17.2626,17.2626,15.5487,-0.0057,6.3523,9.6382,17.3697,9.6382,386.9999,9.1347,9.2955,4.4271,89.7517,68.3984,39.4279,1.5546,4.5888,5.5736,1.2146,2.9516,3.5851,0.8000
 1674.5000,2418.1011,0.0531,2.3691,2.1979,2.2254,2.2286,2.2541,2.3634,2.1979,0.3273,2.5540,0.0539,-0.2106,3.1937,26.4654,21.6471,21.6471,19.6969,0.0029,5.8154,9.1201,16.8959,9.1201,454.9702,9.2490,3.1108,2.2013,101.2824,76.1560,45.0371,1.7774,4.9589,6.3589,1.2823,2.7900,3.5776,8.0000
 1675.0000,2418.8726,0.0618,2.3577,2.1600,2.1880,2.1930,2.2260,2.3523,2.1600,0.3279,2.5387,-0.3339,-0.0723,3.0991,26.5930,21.7721,21.7721,19.8145,0.0037,6.7452,10.0173,17.7164,10.0173,462.9605,9.3012,2.9110,2.1792,103.7412,77.0643,46.4740,1.8472,4.8934,6.4999,1.3283,2.6492,3.5189,4.0000
 1675.5000,2459.8489,0.0663,2.6937,2.4514,2.4854,2.4918,2.5332,2.6880,2.4514,0.3271,2.5226,-0.3923,-0.1591,3.1269,25.5150,20.7194,20.7194,18.8230,0.0039,7.7209,10.9587,18.5772,10.9587,407.9337,9.3406,2.7137,2.0791,95.3692,67.9789,41.7143,1.6746,4.2106,5.7554,1.3669,2.5144,3.4369,2.4000
 1676.0000,2448.7236,0.0634,3.4746,3.1758,3.2244,3.2318,3.2815,3.4693,3.1758,0.3264,2.5641,0.1488,0.2747,3.4903,20.5014,15.9095,15.9095,14.2590,0.0103,5.2088,8.5347,16.3607,8.5348,314.8776,9.3007,4.1917,3.2920,73.3577,52.1933,32.5315,1.3192,3.1635,4.4256,1.3990,2.3981,3.3548,0.0000
 1676.5000,2485.9109,0.0419,4.9250,4.6433,4.7186,4.7221,4.7570,4.9220,4.6433,0.3262,2.6322,0.3363,0.4487,4.0358,13.7538,9.6622,9.6622,8.2413,0.0149,1.0783,4.5492,12.7161,4.5492,215.3624,9.2033,11.4356,8.4041,47.3820,35.9108,22.5458,0.9182,2.1593,3.0484,1.4118,2.3516,3.3199,2.4000
 1677.0000,2474.2908,-0.0079,7.0571,7.1337,7.2056,7.1902,7.1251,7.0640,7.1337,0.3263,2.6674,-0.0481,0.3133,4.3874,9.8546,6.1732,6.1732,4.8307,0.0178,-1.0566,2.4892,10.8324,2.4892,140.1800,9.1353,13.9896,14.3765,32.8004,26.6534,16.7754,0.6815,1.6048,2.2764,1.4185,2.3548,3.3403,2.4000
 1677.5000,2508.7485,-0.0576,9.2083,9.9479,9.9685,9.9215,9.6887,9.2404,9.9479,0.3260,2.6774,-0.3326,0.3243,4.4704,8.4897,4.9732,4.9732,3.6486,0.0191,-1.6611,1.9059,10.2990,1.9059,100.5239,9.0587,29.8298,36.7127,30.1954,24.9203,15.7807,0.6370,1.4972,2.1608,1.4432,2.3504,3.3921,3.2000
 1678.0000,2446.5012,-0.0845,9.1532,10.2368,10.1887,10.1188,9.7847,9.1924,10.2368,0.3274,2.6793,-0.0035,0.0652,4.3679,9.2045,5.6002,5.6002,4.2668,0.0136,-1.7780,1.7932,10.1959,1.7932,97.6865,9.0740,25.6819,24.5095,35.1050,29.0198,18.5455,0.7432,1.7323,2.5651,1.4808,2.3309,3.4515,3.2000
 1678.5000,2472.7815,-0.0749,8.3087,9.1789,9.0865,9.0121,8.6766,8.3317,9.1789,0.3284,2.6705,0.3591,-0.2416,4.1519,11.7166,7.8281,7.8281,6.4532,0.0083,-1.2438,2.3086,10.6673,2.3087,108.9454,9.1117,13.5761,9.8768,44.8522,36.3645,23.2504,0.9302,2.1844,3.2229,1.4754,2.3483,3.4647,4.0000
 1679.0000,2500.7903,-0.0423,7.4370,7.8751,7.7653,7.6968,7.4047,7.4495,7.8751,0.3266,2.6467,0.0352,-0.1720,3.8827,14.2408,10.1043,10.1043,8.6707,0.0115,0.1999,3.7016,11.9411,3.7017,126.9832,9.1510,10.9319,6.7324,56.4084,45.9460,29.0315,1.1633,2.8192,4.0159,1.4245,2.4235,3.4523,3.2000
 1679.5000,2455.4490,-0.0229,6.0519,6.2438,6.1435,6.0901,5.8794,6.0577,6.2438,0.3269,2.6081,-0.4191,0.0902,3.6528,15.7007,11.4378,11.4378,9.9627,0.0146,2.5409,5.9605,14.0067,5.9605,160.1591,9.1922,4.6830,2.3961,70.5863,53.5141,32.9851,1.3169,3.4135,4.5855,1.3434,2.5921,3.4821,8.0000
 1680.0000,2498.1765,-0.0390,5.3960,5.6882,5.5937,5.5447,5.3576,5.3997,5.6882,0.3256,2.5932,-0.2616,-0.1309,3.6992,14.2370,10.1009,10.1009,8.6675,0.0183,3.4395,6.8276,14.7995,6.8276,175.8029,9.1558,2.1328,1.8433,78.3798,54.1530,32.6670,1.2871,3.5458,4.6222,1.3036,2.7548,3.5911,3.2000
 1680.5000,2361.8762,-0.0730,6.8319,7.5295,7.4029,7.3349,7.0961,6.8428,7.5295,0.3259,2.6030,0.1086,-0.6773,4.0455,13.0347,9.0120,9.0120,7.6086,0.0243,2.8488,6.2576,14.2783,6.2576,132.8115,9.0993,32.9631,43.4147,69.9468,51.3633,30.4550,1.1715,3.4097,4.4442,1.3034,2.9105,3.7934,4.0000
 1681.0000,2325.1501,-0.0575,11.1875,12.0846,11.9001,11.7955,11.5513,11.2281,12.0846,0.3270,2.4849,0.1290,-0.1934,3.9855,11.9174,8.0078,8.0078,6.6289,0.0280,10.0067,13.1644,20.5942,13.1644,82.7496,8.9560,45.3878,50.1437,60.5610,46.2327,26.8153,1.0113,3.1003,4.0092,1.2932,3.0658,3.9645,2.4000
 1681.5000,2347.3308,-0.0121,5.4610,5.5527,5.4799,5.4374,5.4303,5.4616,5.5527,0.3257,2.2833,0.1794,0.5989,3.3468,13.9056,9.7999,9.7999,8.3751,0.0479,22.2236,24.9525,31.3737,24.9526,180.0916,8.9636,13.8564,8.9073,62.7353,42.6433,23.8083,0.8907,2.9455,3.5934,1.2200,3.3067,4.0342,0.8000
 1682.0000,2374.8101,0.0234,3.8110,3.6885,3.6576,3.6383,3.6698,3.8077,3.6885,0.3273,2.3040,0.2848,0.6522,3.2758,17.1916,12.8123,12.8123,11.2892,0.0620,20.9670,23.7401,30.2650,23.7401,271.1109,8.9915,8.2264,5.6711,59.1951,37.9804,20.4798,0.7618,2.6898,3.1120,1.1570,3.5308,4.0851,2.0000
 1682.5000,2425.6677,0.0339,4.4113,4.2069,4.1735,4.1518,4.2137,4.4093,4.2069,0.3259,2.4942,0.1231,0.4111,3.8642,14.8194,10.6313,10.6313,9.1820,0.0361,9.4438,12.6212,20.0975,12.6212,237.7074,9.0263,17.3534,12.3081,44.9958,32.3508,17.1789,0.6351,2.3138,2.6289,1.1362,3.6431,4.1391,4.0000
 1683.0000,2390.5869,0.0435,4.6102,4.3365,4.3086,4.2887,4.3686,4.6084,4.3365,0.3260,2.5905,-0.1154,0.1345,4.1155,14.4724,10.3150,10.3150,8.8753,0.0100,3.6060,6.9883,14.9465,6.9883,230.6012,9.0633,13.1086,7.1448,35.2781,28.4473,15.1853,0.5589,2.0098,2.3358,1.1622,3.5960,4.1792,6.4000
 1683.5000,2465.3306,0.0521,4.3116,4.0061,3.9867,3.9735,4.0485,4.3090,4.0061,0.3265,2.6071,-0.2894,-0.1475,4.0209,14.7229,10.5433,10.5433,9.0967,0.0083,2.6012,6.0187,14.0599,6.0187,249.6181,9.0972,6.1653,3.0514,33.3709,27.7868,14.9481,0.5474,1.9358,2.3126,1.1946,3.5366,4.2249,2.0000
 1684.0000,2456.2668,0.0508,4.0978,3.8142,3.7980,3.7897,3.8512,4.0951,3.8142,0.3253,2.6272,-0.2819,-0.5842,3.9008,15.3207,11.0895,11.0895,9.6258,0.0104,1.3794,4.8397,12.9818,4.8397,262.1761,9.1509,5.0505,3.2954,35.8476,29.0751,15.8316,0.5768,1.9899,2.4629,1.2377,3.4496,4.2696,3.2000
 1684.5000,2504.6716,0.0429,4.2858,4.0347,4.0152,4.0095,4.0607,4.2828,4.0347,0.3265,2.6601,0.0191,-0.5208,3.8181,14.9189,10.7221,10.7221,9.2700,0.0071,-0.6122,2.9180,11.2245,2.9181,247.8527,9.1719,5.8169,4.5067,39.4910,30.3297,16.9371,0.6154,2.0086,2.6429,1.3158,3.2638,4.2943,4.0000
 1685.0000,2483.3545,0.0328,5.0806,4.8529,4.8220,4.8175,4.8628,5.0783,4.8529,0.3260,2.6977,0.3899,0.1426,3.8500,13.4344,9.3731,9.3731,7.9601,0.0042,-2.8911,0.7191,9.2138,0.7191,206.0624,9.2152,9.1356,6.4059,38.6482,29.5042,17.2113,0.6179,1.8487,2.7214,1.4720,2.9922,4.4046,4.8000
 1685.5000,2457.8794,-0.0066,6.1542,6.2104,6.1610,6.1592,6.1566,6.1549,6.2104,0.3259,2.7164,0.5401,0.4477,4.0060,11.7262,7.8367,7.8367,6.4616,0.0083,-4.0255,-0.3755,8.2128,-0.3755,161.0198,9.2532,9.4400,8.2425,35.5153,28.9768,17.8677,0.6370,1.6843,2.8461,1.6898,2.6441,4.4678,3.0000
 1686.0000,2498.4871,-0.0228,7.9814,8.2331,8.1660,8.1715,8.1056,7.9912,8.2331,0.3263,2.7200,0.4246,0.0047,4.3174,10.1573,6.4408,6.4408,5.0937,0.0195,-4.2443,-0.5867,8.0197,-0.5867,121.4606,9.1930,15.5659,9.5841,35.5944,27.5532,17.8785,0.6292,1.4887,2.8865,1.9390,2.3658,4.5873,5.6000
 1686.5000,2449.8640,-0.0579,10.1289,10.9466,10.8605,10.8830,10.7115,10.1495,10.9466,0.3248,2.7153,-0.0683,-0.6303,4.6190,8.7816,5.2289,5.2289,3.9009,0.0280,-3.9599,-0.3122,8.2707,-0.3122,91.3527,9.1777,13.6838,13.0603,35.0497,27.4136,18.6746,0.6534,1.3749,3.0334,2.2063,2.1043,4.6426,3.0000
 1687.0000,2468.2559,-0.0762,10.3467,11.4505,11.3772,11.4237,11.1482,10.3743,11.4505,0.3264,2.6895,-0.7178,-0.2437,4.6508,8.9106,5.3420,5.3420,4.0124,0.0253,-2.3950,1.1978,9.6515,1.1978,87.3324,9.1525,16.0180,18.4874,34.7169,30.5997,21.5051,0.7557,1.4608,3.4779,2.3809,1.9331,4.6025,2.4000
 1687.5000,2477.4229,-0.0550,8.0080,8.6226,8.5933,8.6507,8.4328,8.0213,8.6226,0.3256,2.6438,-0.7894,0.3663,4.3667,10.1329,6.4193,6.4193,5.0725,0.0314,0.3736,3.8692,12.0943,3.8693,115.9740,9.1317,15.2411,14.0726,42.4531,37.2494,26.8337,0.9523,1.7019,4.2948,2.5235,1.7871,4.5097,0.0000
 1688.0000,2451.7297,-0.0019,5.4643,5.4787,5.4852,5.5358,5.4585,5.4617,5.4787,0.3279,2.6053,-0.3229,0.1201,3.9136,13.1897,9.1519,9.1519,7.7448,0.0569,2.7061,6.1199,14.1525,6.1199,182.5257,9.1375,8.9962,5.7717,59.0407,46.3383,33.9076,1.2126,2.0662,5.3834,2.6055,1.7039,4.4395,1.6000
 1688.5000,2420.1389,0.0212,3.7055,3.5979,3.6169,3.6535,3.6466,3.6972,3.5979,0.3269,2.6017,-0.0574,-0.1412,3.6335,18.1679,13.7194,13.7194,12.1616,0.0620,2.9271,6.3332,14.3475,6.3332,277.9371,9.1883,2.5951,1.8713,72.0488,55.6567,41.4788,1.4915,2.3984,6.5467,2.7296,1.6080,4.3893,0.8000
 1689.0000,2413.8970,0.0452,3.2630,3.0620,3.0884,3.1211,3.1435,3.2542,3.0620,0.3273,2.6149,-0.1355,-0.3377,3.6005,21.1825,16.5546,16.5546,14.8745,0.0427,2.1294,5.5634,13.6435,5.5634,326.5811,9.1803,6.3136,3.1366,79.6227,65.7918,49.5902,1.7916,2.7843,7.7871,2.7968,1.5541,4.3465,3.0000
 1689.5000,2449.3916,0.0594,2.9516,2.7136,2.7441,2.7737,2.8123,2.9427,2.7136,0.3269,2.6089,-0.2945,-0.3254,3.5212,24.1305,19.3770,19.3770,17.5548,0.0352,2.4916,5.9129,13.9632,5.9129,368.5168,9.2209,3.4986,2.2627,96.4958,75.7072,57.6064,2.0947,3.1494,8.9820,2.8520,1.5036,4.2881,0.8000
 1690.0000,2431.1494,0.0668,2.7594,2.5094,2.5429,2.5706,2.6182,2.7507,2.5094,0.3250,2.5936,-0.3200,0.0540,3.3475,25.8637,21.0593,21.0593,19.1434,0.0359,3.4159,6.8048,14.7787,6.8048,398.5086,9.3044,2.7074,2.0966,116.0972,84.9397,65.2293,2.4032,3.4556,10.0218,2.9002,1.4379,4.1702,0.8000
 1690.5000,2407.1951,0.0693,2.6740,2.4230,2.4599,2.4868,2.5392,2.6653,2.4230,0.3246,2.5881,-0.0906,0.1000,3.2061,26.3138,21.4988,21.4988,19.5573,0.0329,3.7536,7.1307,15.0767,7.1307,412.7190,9.2930,3.0512,2.0717,123.2151,91.0245,70.5787,2.6221,3.6085,10.7400,2.9763,1.3762,4.0959,1.6000
 1691.0000,2436.0552,0.0682,2.6378,2.3940,2.4338,2.4602,2.5138,2.6284,2.3940,0.3261,2.5802,0.2393,0.0035,3.1144,26.3724,21.5562,21.5562,19.6114,0.0291,4.2282,7.5886,15.4955,7.5886,417.7089,9.3391,3.5777,2.3114,122.8332,92.0500,72.3911,2.7101,3.5087,10.9181,3.1117,1.2947,4.0287,0.8000
 1691.5000,2385.3706,0.0651,2.6675,2.4320,2.4751,2.5016,2.5544,2.6580,2.4320,0.3271,2.5748,0.2181,0.2286,3.0842,26.6743,21.8517,21.8517,19.8895,0.0256,4.5595,7.9083,15.7878,7.9083,411.1831,9.3424,3.6068,2.0459,120.5564,91.9440,73.3085,2.7509,3.3945,11.0259,3.2481,1.2340,4.0081,2.4000
 1692.0000,2308.4272,0.0605,2.7339,2.5094,2.5554,2.5826,2.6319,2.7255,2.5094,0.3259,2.5788,-0.2450,0.4508,3.1045,25.8144,21.0111,21.0111,19.0981,0.0243,4.3181,7.6753,15.5748,7.6754,398.5081,9.3138,3.7592,2.4449,118.4918,90.7323,73.3461,2.7561,3.2404,11.0133,3.3988,1.1757,3.9959,0.8000
 1692.5000,2308.5544,0.0550,2.7847,2.5765,2.6233,2.6506,2.6930,2.7788,2.5765,0.3263,2.5753,-0.2665,0.3024,3.1499,25.5260,20.7301,20.7301,18.8331,0.0242,4.5247,7.8747,15.7571,7.8747,388.1282,9.4035,4.2832,2.3515,117.0831,90.2680,73.1708,2.7553,3.2179,10.9596,3.4058,1.1679,3.9776,0.8000
 1693.0000,2392.4651,0.0503,2.8115,2.6191,2.6642,2.6910,2.7245,2.8069,2.6191,0.3253,2.5706,0.1391,0.0253,3.1920,25.0831,20.2995,20.2995,18.4268,0.0243,4.8122,8.1521,16.0108,8.1522,381.8130,9.2643,4.0546,1.9868,115.8420,88.5357,71.5604,2.7012,3.1944,10.6875,3.3456,1.1826,3.9566,0.0000
 1693.5000,2446.4775,0.0472,2.8640,2.6798,2.7222,2.7488,2.7745,2.8612,2.6798,0.3257,2.5734,0.0266,-0.1958,3.2368,23.9787,19.2306,19.2306,17.4162,0.0257,4.6431,7.9889,15.8615,7.9889,373.1622,9.2486,4.5587,2.2740,116.1650,86.8070,69.8064,2.6409,3.1952,10.3974,3.2541,1.2099,3.9370,0.8000
 1694.0000,2439.6487,0.0454,2.9108,2.7306,2.7684,2.7945,2.8143,2.9081,2.7306,0.3257,2.5701,-0.3238,-0.0505,3.2988,23.7999,19.0581,19.0581,17.2530,0.0268,4.8431,8.1819,16.0380,8.1819,366.2148,9.2491,5.3089,2.4726,116.8778,84.3232,67.2415,2.5547,3.2157,9.9643,3.0987,1.2587,3.9004,0.8000
 1694.5000,2472.9771,0.0406,2.8802,2.7204,2.7507,2.7746,2.7898,2.8776,2.7204,0.3270,2.5646,-0.2739,0.5075,3.3296,24.5447,19.7775,19.7775,17.9336,0.0252,5.1772,8.5043,16.3328,8.5043,367.5902,9.1306,4.5307,2.5092,116.2310,84.2103,66.7426,2.5501,3.3057,9.8221,2.9713,1.2963,3.8517,3.0000
 1695.0000,2502.7595,0.0309,2.8910,2.7687,2.7918,2.8143,2.8256,2.8892,2.7687,0.3261,2.5717,0.0719,0.7726,3.3456,24.2945,19.5355,19.5355,17.7048,0.0210,4.7460,8.0882,15.9523,8.0882,361.1774,9.0108,5.3564,2.9034,116.5882,84.7721,67.0669,2.5751,3.3767,9.8100,2.9052,1.3113,3.8096,1.6000
 1695.5000,2505.4656,0.0138,2.9362,2.8807,2.8959,2.9169,2.9228,2.9350,2.8807,0.3270,2.5776,0.1351,0.5026,3.3266,24.7259,19.9531,19.9531,18.0996,0.0145,4.3885,7.7433,15.6369,7.7433,347.1366,8.9544,5.0884,2.8364,114.4120,85.0742,66.9345,2.5772,3.4669,9.7564,2.8142,1.3452,3.7856,0.8000
 1696.0000,2493.3618,0.0052,3.0449,3.0230,3.0284,3.0462,3.0411,3.0441,3.0230,0.3265,2.5747,-0.0930,-0.0637,3.2821,23.0827,18.3682,18.3682,16.5991,0.0093,4.5618,7.9105,15.7899,7.9106,330.7993,8.9655,4.4138,2.5065,109.0033,81.4852,63.8125,2.4714,3.3734,9.2332,2.7371,1.3650,3.7360,1.6000
 1696.5000,2513.5508,0.0164,3.4686,3.3903,3.3836,3.3974,3.3686,3.4685,3.3903,0.3250,2.5835,0.0172,-0.0819,3.4307,20.9932,16.3751,16.3751,14.7033,0.0075,4.0316,7.3989,15.3220,7.3990,294.9552,8.9916,3.9815,2.8152,99.6488,71.6088,55.6217,2.1742,3.0297,7.9532,2.6251,1.3935,3.6580,4.8000
 1697.0000,2531.5288,-0.0135,4.0564,4.1321,4.1091,4.1171,4.0568,4.0573,4.1321,0.3246,2.5983,0.0269,0.1309,3.7435,17.3557,12.9643,12.9643,11.4355,0.0036,3.1360,6.5347,14.5318,6.5347,242.0065,9.0015,9.8518,5.5481,83.7517,59.6017,46.1376,1.8202,2.5284,6.5178,2.5779,1.3891,3.5808,2.4000
 1697.5000,2517.9844,-0.0066,4.9287,4.9735,4.9322,4.9315,4.9311,4.9308,4.9735,0.3263,2.6133,-0.4240,-0.1932,3.9170,15.0673,10.8576,10.8576,9.4013,-0.0026,2.2244,5.6551,13.7274,5.6552,201.0673,9.0348,8.5235,6.4905,65.6617,49.1052,38.1538,1.5201,2.0469,5.3192,2.5986,1.3465,3.4991,2.4000
 1698.0000,2465.3765,-0.0523,5.0453,5.4128,5.3584,5.3495,5.2848,5.0476,5.4128,0.3259,2.6377,-0.4162,-0.3695,3.9286,14.1587,10.0297,10.0297,8.5983,-0.0034,0.7433,4.2259,12.4205,4.2259,184.7488,9.0105,15.0314,10.9049,53.6777,43.9312,34.3928,1.3727,1.7848,4.7833,2.6801,1.3001,3.4845,4.0000
 1698.5000,2498.3723,-0.0450,4.5254,4.8086,4.7574,4.7469,4.6644,4.5269,4.8086,0.3265,2.6526,0.1534,-0.2872,3.8650,14.5762,10.4096,10.4096,8.9670,0.0009,-0.1570,3.3573,11.6262,3.3573,207.9624,8.9870,12.6762,8.6601,53.1344,43.8549,34.5262,1.3808,1.7504,4.7890,2.7359,1.2677,3.4683,4.0000
 1699.0000,2497.9922,-0.0192,3.7871,3.8878,3.8483,3.8405,3.7821,3.7877,3.8878,0.3253,2.6374,0.4320,-0.1043,3.7172,17.7881,13.3659,13.3659,11.8218,0.0031,0.7660,4.2479,12.4406,4.2479,257.2160,8.9999,8.2072,4.7269,61.1775,47.7363,37.5388,1.4997,1.9154,5.2142,2.7223,1.2772,3.4767,4.0000
 1699.5000,2532.2305,0.0040,3.3047,3.2864,3.2584,3.2540,3.2262,3.3048,3.2864,0.3263,2.6061,0.2599,0.2669,3.5916,21.1761,16.5485,16.5485,14.8686,0.0034,2.6606,6.0760,14.1123,6.0760,304.2821,9.0343,5.7250,3.1947,71.1629,52.5508,41.1284,1.6399,2.1384,5.7280,2.6786,1.3039,3.4928,2.4000
 1700.0000,2525.0439,0.0018,2.9971,2.9898,2.9694,2.9675,2.9608,2.9970,2.9898,0.3261,2.5840,0.1988,0.4330,3.5693,21.9696,17.3034,17.3034,15.5874,0.0041,4.0016,7.3700,15.2955,7.3700,334.4705,9.0647,4.7815,2.7704,78.4905,57.7665,44.8566,1.7729,2.4154,6.3216,2.6172,1.3624,3.5656,3.0000
 1700.5000,2487.8801,-0.0026,2.8582,2.8685,2.8534,2.8534,2.8559,2.8579,2.8685,0.3256,2.5745,0.1447,-0.2269,3.5497,22.4580,17.7698,17.7698,16.0309,0.0039,4.5749,7.9232,15.8014,7.9232,348.6201,9.1130,4.1358,2.6262,80.3195,59.9325,46.2309,1.8206,2.5633,6.5469,2.5541,1.4080,3.5960,0.8000
 1701.0000,2533.2439,0.0172,2.9647,2.8945,2.8833,2.8848,2.8952,2.9646,2.8945,0.3246,2.5761,-0.2158,-0.5869,3.4885,21.9703,17.3040,17.3040,15.5881,0.0043,4.4779,7.8295,15.7158,7.8295,345.4860,9.1036,5.6778,3.3331,79.8403,60.2153,45.7634,1.8021,2.6982,6.4814,2.4021,1.4973,3.5966,0.0000
 1701.5000,2463.2229,0.0189,3.0337,2.9548,2.9469,2.9495,2.9606,3.0337,2.9548,0.3259,2.5810,-0.3143,-0.1727,3.4664,21.4021,16.7632,16.7632,15.0732,0.0036,4.1799,7.5420,15.4529,7.5420,338.4277,9.1774,5.8180,3.2894,79.5914,59.1564,44.2499,1.7437,2.7743,6.2612,2.2568,1.5911,3.5907,0.0000
 1702.0000,2491.6917,0.0150,3.0624,2.9994,2.9940,2.9973,3.0048,3.0624,2.9994,0.3253,2.5783,-0.2882,-0.0657,3.5059,20.8998,16.2865,16.2865,14.6189,0.0025,4.3445,7.7008,15.5981,7.7008,333.3980,9.1654,4.0777,2.5868,78.3111,57.7895,42.9353,1.7013,2.7593,6.0305,2.1855,1.6219,3.5446,0.0000
 1702.5000,2548.5732,0.0000,3.1299,3.1298,3.1258,3.1299,3.1299,3.1299,3.1298,0.3258,2.5743,-0.3142,0.0347,3.5634,19.6466,15.1036,15.1036,13.4887,0.0032,4.5876,7.9354,15.8125,7.9354,319.5088,9.1636,5.4770,3.0770,76.4125,56.6322,42.2643,1.6781,2.7051,5.9203,2.1886,1.6120,3.5280,0.8000
 1703.0000,2557.3489,0.0087,3.2565,3.2174,3.2142,3.2189,3.2072,3.2565,3.2174,0.3238,2.5844,0.0032,0.0921,3.6414,19.0653,14.5579,14.5579,12.9661,0.0014,3.9738,7.3431,15.2710,7.3431,310.8088,9.1607,5.2871,3.0720,72.5166,54.8722,41.5273,1.6495,2.5621,5.8139,2.2692,1.5533,3.5247,2.4000
 1703.5000,2503.1396,0.0018,3.4863,3.4775,3.4743,3.4804,3.4539,3.4863,3.4775,0.3257,2.6092,0.1811,0.2223,3.7288,17.5204,13.1172,13.1172,11.5827,0.0004,2.4731,5.8951,13.9469,5.8951,287.5607,9.1342,7.8557,4.7007,66.2472,52.3099,40.3088,1.6045,2.3631,5.6271,2.3812,1.4728,3.5070,1.6000
 1704.0000,2531.9202,-0.0001,3.5501,3.5504,3.5475,3.5546,3.5199,3.5501,3.5504,0.3256,2.6221,0.0843,0.5231,3.7710,17.2588,12.8745,12.8745,11.3491,0.0016,1.6900,5.1394,13.2558,5.1394,281.6565,9.0832,7.0403,4.6597,63.7738,50.6908,39.3848,1.5715,2.2532,5.4800,2.4321,1.4337,3.4870,1.6000
 1704.5000,2556.6348,0.0045,3.3898,3.3687,3.3664,3.3746,3.3410,3.3898,3.3687,0.3260,2.6174,0.1812,0.2899,3.7840,18.1464,13.6994,13.6994,12.1424,0.0029,1.9785,5.4179,13.5105,5.4179,296.8482,9.0742,6.4512,4.4184,67.4755,51.6489,40.3090,1.6164,2.2640,5.5708,2.4606,1.4007,3.4465,4.0000
 1705.0000,2518.2385,0.0100,3.2085,3.1643,3.1626,3.1712,3.1432,3.2085,3.1643,0.3263,2.6165,0.2026,-0.4563,3.7831,19.0831,14.5746,14.5746,12.9822,0.0063,2.0324,5.4699,13.5580,5.4699,316.0280,9.0736,5.9580,3.3248,72.8830,53.7593,41.9233,1.6894,2.3627,5.7547,2.4357,1.3985,3.4064,0.0000
 1705.5000,2549.9553,0.0132,3.1080,3.0515,3.0502,3.0592,3.0359,3.1080,3.0515,0.3252,2.6155,-0.0970,-0.4536,3.7494,20.1059,15.5361,15.5361,13.9023,0.0094,2.0903,5.5257,13.6091,5.5258,327.7130,9.0963,5.5969,3.6542,73.4879,56.0769,43.8774,1.7704,2.4339,6.0120,2.4701,1.3748,3.3957,0.0000
 1706.0000,2525.8738,0.0143,3.0766,3.0161,3.0151,3.0243,3.0044,3.0766,3.0161,0.3257,2.6105,-0.2202,0.1308,3.6561,20.5783,15.9822,15.9822,14.3285,0.0103,2.3951,5.8198,13.8780,5.8198,331.5581,9.1085,5.8060,3.5452,73.4228,56.4628,44.3033,1.7939,2.4329,6.0404,2.4828,1.3562,3.3672,4.0000
 1706.5000,2537.7358,0.0143,3.0730,3.0127,3.0118,3.0210,3.0034,3.0730,3.0127,0.3271,2.6152,-0.0102,0.0573,3.5602,20.6214,16.0229,16.0229,14.3673,0.0121,2.1089,5.5437,13.6255,5.5437,331.9322,9.1318,5.5520,3.3968,75.9923,56.1824,43.8812,1.7752,2.4457,5.9905,2.4494,1.3777,3.3745,4.0000
 1707.0000,2564.4546,0.0142,3.0884,3.0281,3.0273,3.0363,3.0202,3.0884,3.0281,0.3258,2.6220,0.1528,0.0553,3.5695,20.2290,15.6522,15.6522,14.0132,0.0136,1.6957,5.1449,13.2609,5.1449,330.2395,9.1538,5.8176,3.3241,74.8777,55.0319,42.6261,1.7280,2.4442,5.8024,2.3739,1.4145,3.3579,0.8000
 1707.5000,2520.0581,0.0141,3.0745,3.0148,3.0140,3.0227,3.0075,3.0745,3.0148,0.3260,2.6278,0.2335,0.1085,3.6413,19.9493,15.3884,15.3884,13.7612,0.0138,1.3467,4.8082,12.9530,4.8082,331.6974,9.1679,4.0556,2.7469,72.0994,53.8004,41.2412,1.6766,2.4614,5.5915,2.2717,1.4681,3.3351,0.0000
 1708.0000,2539.2900,0.0139,3.0787,3.0199,3.0193,3.0280,3.0118,3.0787,3.0199,0.3269,2.6344,0.1613,-0.0516,3.7004,20.1405,15.5687,15.5687,13.9335,0.0144,0.9430,4.4187,12.5967,4.4187,331.1360,9.1204,4.9697,3.2111,70.4947,53.3780,40.6660,1.6662,2.4781,5.4519,2.2000,1.4873,3.2722,2.4000
 1708.5000,2514.4033,0.0132,3.0711,3.0152,3.0151,3.0240,3.0054,3.0711,3.0152,0.3262,2.6362,-0.2029,-0.2660,3.7250,20.2402,15.6628,15.6628,14.0234,0.0166,0.8347,4.3142,12.5012,4.3142,331.6483,9.1221,5.1059,3.1341,71.0121,53.0121,40.2326,1.6671,2.4715,5.3051,2.1465,1.4825,3.1822,1.6000
 1709.0000,2462.9236,0.0114,3.0609,3.0129,3.0137,3.0232,3.0006,3.0609,3.0129,0.3256,2.6372,-0.2875,-0.2977,3.7111,20.3750,15.7900,15.7900,14.1449,0.0178,0.7733,4.2549,12.4470,4.2549,331.9014,9.1292,4.6791,3.0650,73.7833,53.6841,40.7352,1.7104,2.4910,5.2645,2.1135,1.4563,3.0779,1.0000
 1709.5000,2538.8875,0.0080,3.1035,3.0692,3.0714,3.0823,3.0540,3.1035,3.0692,0.3249,2.6384,0.2049,0.0698,3.7036,19.7471,15.1981,15.1981,13.5791,0.0164,0.7053,4.1893,12.3870,4.1893,325.8127,9.2203,5.3028,3.7937,74.0821,54.5015,41.7579,1.7628,2.4637,5.3521,2.1724,1.3976,3.0362,0.8000
 1710.0000,2529.9385,0.0054,3.1402,3.1168,3.1210,3.1339,3.1010,3.1402,3.1168,0.3248,2.6397,0.4343,0.0824,3.7499,19.4346,14.9043,14.9043,13.2980,0.0170,0.6256,4.1124,12.3167,4.1124,320.8393,9.2800,6.0089,3.8261,71.1807,54.0776,42.0130,1.7778,2.3539,5.3647,2.2790,1.3241,3.0177,1.0000
 1710.5000,2592.7852,0.0061,3.0731,3.0473,3.0539,3.0685,3.0363,3.0731,3.0473,0.3259,2.6348,-0.0876,0.0871,3.7840,19.8078,15.2553,15.2553,13.6338,0.0200,0.9209,4.3974,12.5773,4.3974,328.1570,9.3184,5.5268,3.4445,68.6924,54.1091,42.8001,1.8021,2.2428,5.5080,2.4558,1.2446,3.0565,1.6000
 1711.0000,2565.3870,0.0095,2.9620,2.9233,2.9325,2.9485,2.9208,2.9620,2.9233,0.3258,2.6248,-0.4355,-0.0721,3.7303,20.5033,15.9113,15.9113,14.2607,0.0213,1.5278,4.9830,13.1128,4.9830,342.0749,9.3251,5.0707,3.2279,70.8033,54.3963,43.7368,1.8316,2.1552,5.6756,2.6334,1.1767,3.0988,0.0000
 1711.5000,2591.7144,0.0136,2.8651,2.8115,2.8233,2.8405,2.8189,2.8651,2.8115,0.3258,2.6214,0.0261,-0.3676,3.6748,21.0599,16.4382,16.4382,14.7635,0.0222,1.7315,5.1795,13.2925,5.1795,355.6757,9.3398,4.9656,3.2456,73.3452,55.0199,44.7304,1.8684,2.1084,5.8273,2.7639,1.1284,3.1189,0.8000
 1712.0000,2576.7776,0.0176,2.8017,2.7339,2.7482,2.7666,2.7517,2.8017,2.7339,0.3243,2.6230,0.4171,-0.2078,3.6930,21.4762,16.8336,16.8336,15.1403,0.0233,1.6334,5.0848,13.2059,5.0848,365.7770,9.3326,5.3461,3.0271,74.2606,55.7304,45.5858,1.9039,2.0916,5.9399,2.8400,1.0986,3.1199,0.0000
 1712.5000,2598.1296,0.0204,2.7578,2.6805,2.6971,2.7166,2.7089,2.7578,2.6805,0.3264,2.6221,0.2164,0.0600,3.7115,21.9217,17.2577,17.2577,15.5440,0.0218,1.6889,5.1383,13.2549,5.1384,373.0699,9.3136,5.3557,3.0969,75.0555,57.4244,46.7789,1.9517,2.1709,6.1049,2.8122,1.1123,3.1280,0.8000
 1713.0000,2579.2766,0.0103,2.6401,2.6027,2.6209,2.6404,2.6402,2.6401,2.6027,0.3249,2.6192,0.0365,0.1352,3.6526,22.8106,18.1073,18.1073,16.3515,0.0194,1.8647,5.3080,13.4100,5.3081,384.2129,9.3434,4.6635,2.9418,77.6812,59.1825,47.9705,2.0027,2.2468,6.2544,2.7837,1.1219,3.1230,5.0000
 1713.5000,2588.0063,0.0258,2.6226,2.5298,2.5489,2.5678,2.5741,2.6226,2.5298,0.3247,2.6127,-0.0382,-0.1442,3.5707,23.6561,18.9196,18.9196,17.1218,0.0168,2.2609,5.6904,13.7596,5.6904,395.2822,9.3697,3.9945,2.5877,82.1984,62.1152,49.8898,2.0793,2.4069,6.5214,2.7094,1.1576,3.1364,2.4000
 1714.0000,2625.6885,0.0305,2.5964,2.4881,2.5078,2.5260,2.5369,2.5964,2.4881,0.3247,2.6012,-0.1554,-0.1182,3.5619,23.9460,19.1990,19.1990,17.3863,0.0144,2.9549,6.3600,14.3719,6.3600,401.9158,9.3864,4.2288,2.7496,85.8713,62.7690,50.1495,2.0835,2.4631,6.5866,2.6741,1.1822,3.1612,4.8000
 1714.5000,2570.1895,0.0316,2.6078,2.4949,2.5152,2.5332,2.5473,2.6078,2.4949,0.3266,2.5977,-0.1272,-0.0237,3.6298,23.7093,18.9708,18.9708,17.1702,0.0128,3.1677,6.5653,14.5597,6.5653,400.8138,9.3821,4.7629,2.9483,85.8189,62.5904,49.8896,2.0594,2.4772,6.6156,2.6706,1.2029,3.2123,4.0000
 1715.0000,2573.7715,0.0318,2.6286,2.5140,2.5344,2.5519,2.5684,2.6286,2.5140,0.3259,2.6034,-0.1867,-0.2430,3.6665,22.5071,17.8167,17.8167,16.0755,0.0103,2.8225,6.2322,14.2551,6.2322,397.7686,9.3782,4.8310,2.7694,80.9555,62.2977,49.1699,2.0171,2.5318,6.5800,2.5989,1.2552,3.2621,4.0000
 1715.5000,2553.5713,0.0323,2.6136,2.4982,2.5171,2.5335,2.5514,2.6136,2.4982,0.3259,2.6062,-0.2380,-0.2235,3.6085,23.0191,18.3073,18.3073,16.5412,0.0070,2.6546,6.0702,14.1070,6.0702,400.2920,9.3802,4.9103,2.7011,78.9322,62.9906,48.9763,2.0022,2.6543,6.5870,2.4816,1.3257,3.2898,8.0000
 1716.0000,2600.7781,0.0335,2.5845,2.4662,2.4825,2.4974,2.5163,2.5845,2.4662,0.3250,2.5973,-0.1931,0.1190,3.5168,23.2243,18.5042,18.5042,16.7280,0.0038,3.1936,6.5903,14.5825,6.5903,405.4840,9.3762,4.2641,2.5797,82.9585,63.2494,48.3724,1.9809,2.7748,6.4899,2.3389,1.4008,3.2762,4.0000
 1716.5000,2595.3416,0.0346,2.5645,2.4431,2.4560,2.4693,2.4886,2.5645,2.4431,0.3255,2.5825,-0.2968,0.4080,3.4794,23.6101,18.8752,18.8752,17.0797,0.0007,4.0894,7.4547,15.3730,7.4547,409.3184,9.3485,3.8797,2.5673,85.8647,63.4328,47.8788,1.9672,2.8628,6.3928,2.2331,1.4553,3.2497,2.4000
 1717.0000,2592.1284,0.0358,2.6165,2.4886,2.4977,2.5095,2.5298,2.6165,2.4886,0.3256,2.5788,-0.3555,0.1316,3.5177,22.7807,18.0787,18.0787,16.3242,-0.0022,4.3123,7.6697,15.5696,7.6697,401.8271,9.2738,4.6238,2.8856,84.7831,63.2276,47.7879,1.9664,2.8446,6.3668,2.2382,1.4466,3.2378,7.2000
 1717.5000,2602.1829,0.0358,2.6577,2.5278,2.5314,2.5411,2.5615,2.6577,2.5278,0.3252,2.5862,-0.3871,-0.2836,3.5223,22.4742,17.7852,17.7852,16.0456,-0.0032,3.8643,7.2375,15.1744,7.2375,395.5997,9.2284,4.6864,2.9637,84.6007,62.6827,47.6021,1.9535,2.8005,6.3669,2.2735,1.4336,3.2593,3.0000
 1718.0000,2555.7710,0.0324,2.6699,2.5517,2.5482,2.5550,2.5734,2.6699,2.5517,0.3253,2.5857,-0.5042,-0.0241,3.4669,22.5947,17.9005,17.9005,16.1551,-0.0019,3.8958,7.2679,15.2022,7.2679,391.9000,9.1827,4.6578,2.7444,85.9726,63.2947,48.3122,1.9540,2.8201,6.5976,2.3395,1.4432,3.3764,5.6000
 1718.5000,2498.0496,0.0181,2.7157,2.6483,2.6362,2.6394,2.6514,2.7157,2.6483,0.3264,2.5831,-0.2200,0.2790,3.4839,22.4797,17.7905,17.7905,16.0506,0.0008,4.0530,7.4196,15.3409,7.4196,377.6051,9.1517,4.1151,2.2046,84.4115,61.7165,47.0950,1.8677,2.7867,6.6073,2.3710,1.4920,3.5377,4.8000
 1719.0000,2458.2249,-0.0079,3.0378,3.0708,3.0450,3.0428,3.0399,3.0378,3.0708,0.3254,2.5999,0.5441,0.1843,3.6494,19.6853,15.1399,15.1399,13.5235,0.0049,3.0389,6.4410,14.4461,6.4410,325.6499,9.1257,3.9516,2.3325,78.2166,56.3724,43.1350,1.6689,2.5470,6.2498,2.4538,1.5261,3.7448,2.0000
 1719.5000,2579.2183,0.0049,4.2832,4.2543,4.1947,4.1799,4.1321,4.2832,4.2543,0.3250,2.6280,0.8016,0.2590,3.9599,15.2764,11.0489,11.0489,9.5865,0.0089,1.3357,4.7976,12.9432,4.7976,235.0565,9.0623,7.7918,6.5902,66.5815,50.1629,38.4327,1.4609,2.2495,5.6923,2.5304,1.5399,3.8965,2.4000
 1720.0000,2577.8372,-0.0197,5.4061,5.5538,5.4610,5.4301,5.3118,5.4061,5.5538,0.3257,2.6467,0.3553,0.3919,4.2148,11.6209,7.7425,7.7425,6.3695,0.0113,0.1979,3.6997,11.9393,3.6998,180.0557,8.9367,14.9371,12.2344,55.1427,44.2204,33.7942,1.2740,1.9853,5.0556,2.5466,1.5583,3.9684,5.0000
 1720.5000,2546.0505,-0.0317,4.7876,4.9981,4.9050,4.8702,4.7539,4.7876,4.9981,0.3248,2.6454,0.0605,-0.0328,4.1994,11.7344,7.8441,7.8441,6.4688,0.0121,0.2760,3.7751,12.0082,3.7751,200.0766,8.9232,14.1086,9.2399,54.5583,42.6373,32.1467,1.2110,1.9625,4.8131,2.4525,1.6206,3.9745,3.2000
 1721.0000,2512.8254,-0.0292,3.9836,4.1450,4.0608,4.0271,3.9321,3.9836,4.1450,0.3271,2.6358,0.0940,-0.4411,4.0333,14.9335,10.7354,10.7354,9.2829,0.0154,0.8609,4.3395,12.5243,4.3395,241.2549,8.9055,9.1817,5.7548,61.7610,46.1793,34.1782,1.2901,2.2129,5.1051,2.3069,1.7153,3.9571,4.0000
 1721.5000,2571.0879,-0.0212,3.3340,3.4318,3.3593,3.3287,3.2627,3.3340,3.4318,0.3254,2.6238,-0.0372,0.0135,3.8429,17.4306,13.0338,13.0338,11.5024,0.0225,1.5863,5.0394,13.1644,5.0394,291.3960,8.9734,8.7271,4.8645,69.4240,51.4603,37.5832,1.4167,2.5390,5.6229,2.2146,1.7922,3.9690,0.8000
 1722.0000,2571.8481,-0.0151,2.9904,3.0527,2.9878,2.9595,2.9113,2.9904,3.0527,0.3250,2.6041,-0.1983,0.5309,3.6231,20.4155,15.8283,15.8283,14.1815,0.0230,2.7797,6.1909,14.2174,6.1909,327.5771,9.0402,6.8707,3.8078,76.6017,56.8920,41.4692,1.5555,2.8227,6.2407,2.2109,1.8146,4.0119,0.8000
 1722.5000,2550.3691,-0.0147,2.8569,2.9152,2.8535,2.8246,2.7833,2.8585,2.9152,0.3254,2.5907,0.0110,0.4320,3.4784,20.9641,16.3474,16.3474,14.6769,0.0171,3.5914,6.9742,14.9336,6.9742,343.0338,9.0609,4.2329,2.7634,82.0887,59.7999,43.7316,1.6379,2.9613,6.5927,2.2263,1.8080,4.0250,3.2000
 1723.0000,2553.8940,-0.0223,2.9449,3.0361,2.9720,2.9387,2.8907,2.9508,3.0361,0.3245,2.5994,0.1651,0.0222,3.5835,20.7857,16.1784,16.1784,14.5157,0.0126,3.0657,6.4669,14.4697,6.4669,329.3747,9.0928,4.1435,2.6686,82.9844,60.7393,44.3605,1.6509,3.0272,6.7378,2.2257,1.8337,4.0813,0.0000
 1723.5000,2562.2087,-0.0308,3.0886,3.2208,3.1546,3.1177,3.0529,3.0955,3.2208,0.3263,2.6119,0.0148,-0.1700,3.7833,19.3895,14.8620,14.8620,13.2575,0.0072,2.3078,5.7356,13.8010,5.7356,310.4854,9.1835,7.8788,5.4536,80.4881,61.1852,44.4658,1.6520,3.0848,6.7673,2.1937,1.8673,4.0964,0.8000
 1724.0000,2614.9783,-0.0334,2.8544,2.9868,2.9315,2.8986,2.8248,2.8609,2.9868,0.3254,2.5985,-0.1632,-0.2139,3.7243,19.3404,14.8159,14.8159,13.2133,0.0089,3.1206,6.5199,14.5182,6.5199,334.8022,9.0907,7.3864,4.3537,81.7068,59.9336,43.2047,1.5991,3.0568,6.6038,2.1604,1.9115,4.1296,5.6000
 1724.5000,2583.9294,-0.0418,2.5921,2.7428,2.6986,2.6709,2.5841,2.5971,2.7428,0.3265,2.5766,-0.2009,-0.3282,3.6238,22.5165,17.8257,17.8257,16.0840,0.0181,4.4489,7.8016,15.6902,7.8016,364.5928,9.1534,3.6616,2.5998,83.5081,55.5573,39.9488,1.4773,2.8431,6.1123,2.1499,1.9245,4.1374,4.0000
 1725.0000,2493.2932,-0.0771,2.6508,2.9368,2.8962,2.8692,2.7523,2.6570,2.9368,0.3267,2.5856,-0.0156,-0.4900,3.8412,22.3093,17.6276,17.6276,15.8958,0.0158,3.9033,7.2751,15.2088,7.2751,340.5077,9.1534,6.1176,3.7198,71.4368,46.5029,33.6551,1.2477,2.3498,5.1346,2.1851,1.8833,4.1153,0.8000
 1725.5000,2574.7161,-0.1255,2.9033,3.4167,3.3795,3.3531,3.2284,2.9129,3.4167,0.3259,2.6121,0.0178,-0.7812,4.0518,20.0290,15.4636,15.4636,13.8330,0.0052,2.2941,5.7224,13.7889,5.7224,292.6767,9.1309,8.0526,4.7577,49.5121,37.9391,27.7871,1.0264,1.8756,4.2571,2.2697,1.8273,4.1475,0.8000
 1726.0000,2534.4878,-0.0632,3.3961,3.6958,3.6681,3.6468,3.5681,3.4147,3.6958,0.3233,2.5528,-0.4448,-0.9592,3.7903,21.5307,16.8854,16.8854,15.1896,0.0087,5.8925,9.1945,16.9639,9.1945,270.5751,9.2432,8.4787,6.7095,38.6842,35.9772,26.7681,0.9847,1.7298,4.1203,2.3819,1.7567,4.1843,4.0000
 1726.5000,2541.3054,-0.0137,2.4107,2.4565,2.4477,2.4406,2.4265,2.4168,2.4565,0.3255,2.3198,-0.6839,-0.6289,3.1792,27.7219,22.8813,22.8813,20.8566,0.0472,20.0112,22.8178,29.4217,22.8178,407.0882,9.2006,6.6357,3.5489,49.2446,42.9270,32.3036,1.1767,2.0252,5.0273,2.4824,1.7210,4.2722,4.8000
 1727.0000,2570.3389,0.0000,1.6492,1.6491,1.6490,1.6484,1.6480,1.6478,1.6491,0.3259,2.1385,-0.2433,0.2584,2.8885,35.1673,30.3715,30.3715,27.8260,0.1208,31.0007,33.4218,39.1183,33.4218,606.3780,9.3449,0.5472,0.5952,70.9019,53.7842,40.7472,1.4792,2.5100,6.3657,2.5361,1.6969,4.3034,1.0000
 1727.5000,2539.9121,-0.0390,1.6095,1.6968,1.7012,1.7036,1.6851,1.6076,1.6968,0.3254,2.2423,0.3769,0.7624,3.1498,34.1068,29.2863,29.2863,26.8232,0.1740,24.7091,27.3509,33.5668,27.3509,589.3503,10.2059,0.4446,0.6695,84.3248,61.6159,46.4260,1.6768,2.9270,7.2935,2.4918,1.7456,4.3497,2.4000
 1728.0000,2551.7166,-0.0157,1.8396,1.8795,1.8877,1.8921,1.8704,1.8393,1.8795,0.3265,2.4298,0.6868,0.4463,3.4264,30.0297,25.1707,25.1707,22.9991,0.1545,13.3459,16.3864,23.5405,16.3864,532.0502,10.5260,1.0622,1.0955,81.0432,59.5348,44.8564,1.6143,2.8389,7.0742,2.4919,1.7586,4.3821,4.0000
 1728.5000,2544.2769,0.0035,2.0254,2.0156,2.0259,2.0310,2.0229,2.0255,2.0156,0.3246,2.5233,0.2931,0.3796,3.4787,26.8167,21.9913,21.9913,20.0207,0.0949,7.6812,10.9204,18.5422,10.9204,496.1181,9.6944,2.4453,1.6568,64.4367,51.6231,39.0667,1.4115,2.4357,6.1347,2.5186,1.7256,4.3461,2.4000
 1729.0000,2611.7302,0.0113,2.0863,2.0539,2.0652,2.0698,2.0661,2.0863,2.0539,0.3239,2.5588,-0.2110,0.2968,3.4488,26.3173,21.5022,21.5022,19.5606,0.0472,5.5287,8.8435,16.6430,8.8435,486.8768,9.4729,2.8773,2.0389,51.7754,44.8265,33.8246,1.2391,2.1136,5.2312,2.4751,1.7058,4.2219,0.8000
 1729.5000,2594.9165,0.0047,2.1491,2.1352,2.1468,2.1502,2.1389,2.1491,2.1352,0.3252,2.5719,-0.1106,-0.2268,3.4294,26.2224,21.4094,21.4094,19.4732,0.0242,4.7320,8.0747,15.9400,8.0748,468.3361,9.3513,5.7215,2.8242,51.1225,42.6221,32.1281,1.1922,2.0072,4.8961,2.4393,1.6835,4.1066,2.4000
 1730.0000,2580.1978,-0.0148,2.2411,2.2870,2.2983,2.3007,2.2775,2.2410,2.2870,0.3255,2.5598,-0.2018,-0.5749,3.4527,27.3379,22.5032,22.5032,20.5017,0.0285,5.4681,8.7850,16.5895,8.7850,437.2475,9.3916,7.9208,3.1591,54.8468,45.0231,33.6561,1.2623,2.1552,5.0658,2.3505,1.7074,4.0132,0.8000
 1730.5000,2577.2837,-0.0260,2.3307,2.4149,2.4257,2.4276,2.4124,2.3307,2.4149,0.3247,2.4446,-0.7123,-1.1529,3.4454,29.7706,24.9122,24.9122,22.7577,0.0757,12.4472,15.5192,22.7475,15.5192,414.1025,9.3971,2.4400,1.8014,61.3586,48.4189,36.0966,1.3503,2.3375,5.4498,2.3314,1.7311,4.0360,2.0000
 1731.0000,2601.4688,-0.0271,2.1919,2.2744,2.2839,2.2863,2.2704,2.1919,2.2744,0.3256,2.1693,-0.6533,-1.1969,3.1859,34.1236,29.3035,29.3035,26.8391,0.1412,29.1308,31.6174,37.4684,31.6175,439.6709,9.5673,1.1049,1.3260,68.9779,54.1549,40.5569,1.5065,2.6008,6.1737,2.3738,1.7264,4.0981,3.2000
 1731.5000,2583.7910,-0.0409,1.8652,1.9714,1.9792,1.9825,1.9552,1.8653,1.9714,0.3246,1.9289,-0.0127,-0.0121,2.8576,39.1050,34.4536,34.4536,31.5785,0.1759,43.7029,45.6782,50.3261,45.6782,507.2514,9.7974,0.8245,0.9175,75.3089,61.1180,45.8144,1.6896,2.9299,7.0320,2.4000,1.7341,4.1620,1.0000
 1732.0000,2543.1377,-0.0323,1.8068,1.8880,1.8949,1.8996,1.8683,1.8069,1.8880,0.3249,1.9627,0.2988,0.9396,2.8985,38.6773,34.0062,34.0062,31.1687,0.1812,41.6525,43.6998,48.5169,43.6998,529.6722,10.7248,0.6414,0.8215,85.2735,70.1955,52.5086,1.9291,3.3911,8.0944,2.3869,1.7579,4.1960,0.8000
 1732.5000,2629.7769,-0.0206,2.0066,2.0638,2.0705,2.0768,2.0482,2.0066,2.0638,0.3245,2.1643,0.2346,1.1072,3.0491,35.5056,30.7190,30.7190,28.1466,0.1553,29.4356,31.9116,37.7373,31.9116,484.5485,11.0090,0.7511,0.8350,97.1114,78.2019,58.3774,2.1443,3.7831,9.0007,2.3792,1.7642,4.1974,1.6000
 1733.0000,2608.9084,-0.0098,2.2839,2.3148,2.3206,2.3283,2.3074,2.2839,2.3148,0.3263,2.3489,0.2224,1.0499,3.0951,34.1477,29.3280,29.3280,26.8618,0.1113,18.2508,21.1192,27.8684,21.1192,432.0093,10.8705,1.0099,0.9607,104.6568,84.5224,63.1758,2.3213,4.0572,9.7372,2.4000,1.7478,4.1947,2.0000
 1733.5000,2609.8184,0.0007,2.4470,2.4446,2.4484,2.4564,2.4460,2.4471,2.4446,0.3260,2.4603,0.1255,0.7639,3.1859,31.3583,26.5019,26.5019,24.2398,0.0911,11.4972,14.6025,21.9093,14.6025,409.0726,10.9718,0.9836,1.1888,109.1255,88.8420,66.9229,2.4653,4.1716,10.2848,2.4654,1.6921,4.1718,1.6000
 1734.0000,2605.6030,0.0075,2.4789,2.4534,2.4542,2.4613,2.4590,2.4790,2.4534,0.3237,2.4916,0.0828,0.1375,3.2447,30.3531,25.4938,25.4938,23.3006,0.0925,9.5973,12.7693,20.2329,12.7694,407.5973,10.7965,1.2539,1.2612,112.4080,90.8533,69.3600,2.5745,4.1165,10.5672,2.5671,1.5990,4.1046,1.0000
 1734.5000,2618.5132,0.0010,2.5276,2.5242,2.5214,2.5270,2.5273,2.5276,2.5242,0.3258,2.4982,0.3673,0.1737,3.2416,30.2306,25.3714,25.3714,23.1864,0.0850,9.1972,12.3832,19.8799,12.3833,396.1684,10.1930,2.0773,1.7650,116.3345,91.1306,70.5597,2.6343,4.0081,10.6775,2.6640,1.5215,4.0533,2.4000
 1735.0000,2602.0098,0.0013,2.6909,2.6860,2.6790,2.6832,2.6824,2.6909,2.6860,0.3251,2.5183,0.5131,0.5688,3.2126,28.0490,23.2039,23.2039,21.1593,0.0558,7.9842,11.2128,18.8096,11.2128,372.2981,9.8123,2.8227,1.9093,123.0527,90.8884,71.2669,2.6708,3.8732,10.7367,2.7720,1.4502,4.0201,3.2000
 1735.5000,2584.7932,0.0050,2.6914,2.6729,2.6626,2.6652,2.6623,2.6914,2.6729,0.3251,2.5371,0.2332,-0.2747,3.1560,27.1235,22.2924,22.2924,20.3037,0.0250,6.8453,10.1138,17.8046,10.1138,374.1264,9.8840,1.2320,1.1755,124.5444,92.6780,73.1804,2.7484,3.8929,10.9967,2.8248,1.4164,4.0011,2.4000
 1736.0000,2624.0420,0.0064,2.6432,2.6201,2.6076,2.6091,2.6030,2.6432,2.6201,0.3251,2.5503,0.0218,-0.9932,3.1493,26.9211,22.0937,22.0937,20.1170,0.0142,6.0421,9.3389,17.0960,9.3389,381.6636,10.2924,0.5165,0.9268,120.5911,94.2217,74.5549,2.8009,3.9476,11.1990,2.8369,1.4094,3.9983,1.6000
 1736.5000,2601.0662,0.0043,2.6817,2.6657,2.6508,2.6519,2.6407,2.6817,2.6657,0.3244,2.5571,-0.0134,-0.3640,3.1895,27.1107,22.2798,22.2798,20.2919,0.0145,5.6286,8.9398,16.7311,8.9398,375.1383,9.9119,2.0208,1.4327,119.4328,92.6609,73.3296,2.7440,3.8795,11.0666,2.8526,1.4138,4.0330,0.8000
 1737.0000,2627.4509,0.0012,2.7348,2.7302,2.7137,2.7149,2.6987,2.7348,2.7302,0.3245,2.5510,-0.2625,0.3735,3.1574,28.1749,23.3283,23.3283,21.2759,0.0111,6.0021,9.3002,17.0607,9.3003,366.2686,9.5794,3.4189,2.2351,118.0921,91.1273,72.3816,2.6893,3.7766,11.0149,2.9166,1.4043,4.0958,1.6000
 1737.5000,2609.2312,-0.0007,2.7773,2.7799,2.7627,2.7648,2.7420,2.7773,2.7799,0.3261,2.5422,-0.4814,0.5965,3.0727,27.8082,22.9664,22.9664,20.9365,0.0060,6.5313,9.8109,17.5276,9.8109,359.7296,9.5877,1.9818,1.9408,115.2043,88.4793,70.7281,2.6083,3.5961,10.8563,3.0189,1.3787,4.1623,5.0000
 1738.0000,2604.2668,-0.0026,2.8231,2.8330,2.8164,2.8199,2.7885,2.8231,2.8330,0.3245,2.5431,-0.5246,0.1596,3.0295,27.6581,22.8184,22.8184,20.7976,0.0029,6.4799,9.7613,17.4823,9.7613,352.9793,9.6079,3.3393,2.4614,111.8360,86.5770,69.6915,2.5597,3.4317,10.7462,3.1314,1.3407,4.1983,2.4000
 1738.5000,2575.0962,-0.0082,2.7955,2.8271,2.8125,2.8178,2.7779,2.7955,2.8271,0.3245,2.5444,-0.4130,-0.4384,3.0006,28.3065,23.4584,23.4584,21.3978,-0.0017,6.3996,9.6838,17.4114,9.6839,353.7173,9.6468,4.4222,2.8504,110.6058,85.5846,69.0052,2.5467,3.3614,10.5822,3.1481,1.3199,4.1552,0.0000
 1739.0000,2559.1450,-0.0199,2.8194,2.8970,2.8849,2.8923,2.8436,2.8194,2.8970,0.3247,2.5376,0.0423,-0.4968,3.0135,29.4739,24.6166,24.6166,22.4816,-0.0038,6.8119,10.0817,17.7752,10.0817,345.1849,9.6816,4.1704,2.7350,112.2938,84.5253,68.1031,2.5154,3.3318,10.4345,3.1318,1.3246,4.1482,0.0000
 1739.5000,2612.1914,-0.0305,2.9433,3.0680,3.0591,3.0690,3.0145,2.9433,3.0680,0.3247,2.5221,0.1874,-0.4318,3.1024,31.4347,26.5787,26.5787,24.3112,0.0127,7.7537,10.9904,18.6062,10.9904,325.9504,9.7055,3.4665,2.4856,110.5852,84.1421,68.1525,2.5023,3.2871,10.5132,3.1983,1.3136,4.2015,2.4000
 1740.0000,2545.4858,-0.0269,2.9316,3.0409,3.0368,3.0483,3.0049,2.9316,3.0409,0.3260,2.4842,-0.0069,-0.7582,3.1693,33.5506,28.7195,28.7195,26.2986,0.0754,10.0478,13.2040,20.6304,13.2040,328.8486,9.7359,1.9545,1.4545,105.3606,82.5548,67.5591,2.4416,3.1557,10.6059,3.3609,1.2924,4.3438,1.6000
 1740.5000,2554.5496,-0.0096,2.5577,2.5916,2.5920,2.6026,2.5873,2.5577,2.5916,0.3249,2.4166,0.2101,-0.8416,3.1709,36.2407,31.4761,31.4761,28.8444,0.1769,14.1479,17.1603,24.2482,17.1603,385.8679,10.2208,0.7903,0.9767,101.4206,81.8665,67.9070,2.4143,3.0282,10.8500,3.5830,1.2543,4.4941,1.6000
 1741.0000,2458.2598,0.0076,2.2954,2.2715,2.2745,2.2824,2.2866,2.2954,2.2715,0.3268,2.3681,0.4195,0.0760,3.1495,37.0184,32.2802,32.2802,29.5844,0.2351,17.0834,19.9927,26.8383,19.9928,440.2334,10.8546,0.7451,1.0185,102.3622,82.8234,69.3685,2.4438,2.9651,11.1902,3.7740,1.2133,4.5791,0.8000
 1741.5000,2509.7156,0.0183,2.3973,2.3371,2.3422,2.3490,2.3603,2.3973,2.3371,0.3258,2.3870,0.2565,0.5985,3.1443,36.5923,31.8393,31.8393,29.1787,0.1976,15.9414,18.8908,25.8307,18.8908,427.8772,10.9232,1.2042,1.1349,104.7285,83.3118,70.3882,2.4721,2.8819,11.3908,3.9525,1.1658,4.6078,1.6000
 1742.0000,2561.0684,0.0141,2.4568,2.4092,2.4161,2.4209,2.4243,2.4568,2.4092,0.3248,2.4499,0.0904,0.2010,3.1841,34.6630,29.8548,29.8548,27.3488,0.1309,12.1295,15.2127,22.4672,15.2127,415.0722,10.9179,1.1848,1.2427,104.4775,85.6328,72.7105,2.5510,2.8955,11.7790,4.0680,1.1350,4.6174,3.0000
 1742.5000,2497.7964,-0.0011,2.4736,2.4773,2.4861,2.4880,2.4682,2.4736,2.4773,0.3246,2.5183,-0.1378,0.1558,3.2850,33.0668,28.2279,28.2279,25.8430,0.0926,7.9806,11.2093,18.8064,11.2093,403.6572,10.7724,1.3941,1.2775,106.0324,87.6678,74.7044,2.6147,2.9032,12.1320,4.1788,1.1104,4.6400,0.8000
 1743.0000,2487.3044,0.0025,2.8338,2.8241,2.8356,2.8347,2.8342,2.8338,2.8241,0.3260,2.5278,-0.3525,0.1641,3.4067,33.4081,28.5746,28.5746,26.1643,0.0729,7.4091,10.6579,18.3021,10.6579,354.0929,10.1267,3.1777,1.8573,107.3769,86.9451,74.0608,2.5731,2.8975,12.1176,4.1822,1.1260,4.7093,5.0000
 1743.5000,2513.4126,0.0022,3.0780,3.0686,3.0834,3.0812,3.0790,3.0775,3.0686,0.3250,2.4478,-0.1732,-0.0641,3.4440,36.8405,32.0960,32.0960,29.4149,0.0929,12.2550,15.3337,22.5779,15.3337,325.8787,10.0028,3.1385,1.6601,106.4624,84.8519,72.2001,2.4938,2.8600,11.8830,4.1549,1.1468,4.7651,4.0000
 1744.0000,2563.3491,0.0041,2.5958,2.5811,2.5962,2.5954,2.5950,2.5947,2.5811,0.3264,2.3710,0.0814,-0.0542,3.3865,40.0036,35.3966,35.3966,32.4411,0.1409,16.9096,19.8251,26.6850,19.8251,387.4263,10.4037,0.7798,0.8754,102.9632,82.9407,70.1055,2.3893,2.9076,11.6906,4.0206,1.2169,4.8928,4.8000
 1744.5000,2578.8965,0.0054,2.3162,2.2991,2.3145,2.3162,2.3159,2.3157,2.2991,0.3243,2.3468,-0.0910,-0.0789,3.3180,41.4090,36.8800,36.8800,33.7951,0.1460,18.3765,21.2405,27.9793,21.2405,434.9562,11.4591,0.6878,0.8362,98.9368,82.9217,69.3649,2.3232,3.0307,11.7608,3.8806,1.3045,5.0622,0.0000
 1745.0000,2517.3972,-0.0399,2.0184,2.1304,2.1452,2.1493,2.1185,2.0180,2.1304,0.3253,2.3149,-0.4440,-0.2009,3.2248,37.9209,33.2174,33.2174,30.4453,0.1159,20.3076,23.1038,29.6831,23.1038,469.3997,13.2013,0.5582,0.8123,97.6618,85.3752,70.2088,2.3044,3.2853,12.1277,3.6914,1.4257,5.2629,3.2000
 1745.5000,2556.1162,0.0024,2.2206,2.2133,2.2256,2.2307,2.2331,2.2201,2.2133,0.3241,2.2695,-0.3090,0.1082,3.0744,37.4605,32.7388,32.7388,30.0059,0.0947,23.0584,25.7581,32.1104,25.7581,451.8226,14.6884,0.6879,0.8666,98.9421,88.8295,71.8820,2.3148,3.5589,12.6276,3.5482,1.5374,5.4551,1.6000
 1746.0000,2578.5737,0.0495,2.5702,2.3970,2.4077,2.4142,2.4522,2.5691,2.3970,0.3239,2.2868,0.3976,0.3616,3.0828,33.6311,28.8015,28.8015,26.3745,0.0853,22.0136,24.7500,31.1885,24.7500,417.1923,15.4624,0.5849,0.7912,99.5381,87.6687,69.8490,2.2300,3.6325,12.3622,3.4032,1.6289,5.5435,1.6000
 1746.5000,2558.5806,0.0605,2.7565,2.5301,2.5352,2.5406,2.5839,2.7550,2.5301,0.3243,2.4144,0.8754,0.1205,3.4431,27.4742,22.6373,22.6373,20.6277,0.0850,14.2796,17.2874,24.3644,17.2874,395.2340,14.0109,0.5683,0.8573,93.6809,76.9314,60.5879,1.9303,3.2631,10.7424,3.2921,1.6905,5.5652,0.8000
 1747.0000,2544.5647,-0.0001,3.2100,3.2106,3.2024,3.2044,3.2064,3.2078,3.2106,0.3247,2.5706,0.5860,0.3288,3.8311,21.3889,16.7506,16.7506,15.0612,0.0716,4.8129,8.1527,16.0113,8.1527,311.4665,10.5519,5.3883,4.0447,75.6738,58.8395,45.6855,1.4625,2.5710,8.0669,3.1377,1.7579,5.5158,0.0000
 1747.5000,2591.5986,0.0137,4.5444,4.4589,4.4126,4.4033,4.4541,4.5403,4.4589,0.3252,2.6464,-0.0099,0.7404,3.9170,17.2209,12.8395,12.8395,11.3153,0.0410,0.2193,3.7204,11.9582,3.7204,224.2726,9.6728,11.4542,7.7715,53.5237,44.2427,33.6291,1.0844,2.0264,5.9008,2.9119,1.8687,5.4415,5.6000
 1748.0000,2642.4226,0.0628,5.8650,5.3655,5.2706,5.2427,5.3871,5.8593,5.3655,0.3251,2.6561,-0.3022,0.5185,3.8503,15.4426,11.2011,11.2011,9.7338,0.0192,-0.3721,3.1497,11.4364,3.1498,186.3752,9.5516,7.5116,5.6033,43.0592,36.1360,26.9555,0.8737,1.7252,4.7083,2.7292,1.9745,5.3888,3.2000
 1748.5000,2566.6545,0.0550,7.2464,6.7046,6.5373,6.4840,6.6931,7.2404,6.7046,0.3242,2.6652,-0.0256,-0.1872,3.9376,12.9947,8.9760,8.9760,7.5735,0.0115,-0.9237,2.6175,10.9497,2.6175,149.1508,9.4258,10.9591,7.5125,43.3453,33.7959,24.9424,0.8023,1.6497,4.3860,2.6586,2.0562,5.4666,1.6000
 1749.0000,2529.9734,0.0173,8.3502,8.1517,7.9007,7.8339,8.1260,8.3453,8.1517,0.3248,2.6864,0.3662,-0.4572,4.2624,11.5190,7.6516,7.6516,6.2805,0.0140,-2.2073,1.3789,9.8170,1.3789,122.6736,9.3507,15.2461,13.0013,48.7368,37.1985,27.1837,0.8665,1.8528,4.8177,2.6003,2.1382,5.5601,1.0000
 1749.5000,2572.1013,-0.0210,9.0030,9.2650,8.9613,8.9149,8.9641,8.9993,9.2650,0.3245,2.6949,0.2311,0.1050,4.5135,10.2590,6.5309,6.5309,5.1821,0.0173,-2.7193,0.8849,9.3653,0.8849,107.9329,9.3061,20.9209,15.1043,59.3610,43.4337,31.5890,1.0035,2.1779,5.6147,2.5780,2.1703,5.5952,3.2000
 1750.0000,2704.7161,-0.0254,9.7029,10.0446,9.7192,9.7079,9.7019,9.6978,10.0446,0.3246,2.6926,-0.0414,0.0824,4.4463,9.3578,5.7351,5.7351,4.3997,0.0168,-2.5788,1.0204,9.4893,1.0205,99.5564,9.2644,10.1233,7.5221,68.7290,47.3653,33.9491,1.0923,2.4207,5.9686,2.4656,2.2162,5.4643,2.0000
 1750.5000,2552.7422,-0.0371,13.8286,14.5418,13.9021,13.8687,13.8511,13.8388,14.5417,0.3236,2.6876,0.1007,-0.3234,4.3187,8.9771,5.4004,5.4004,4.0700,0.0159,-2.2807,1.3081,9.7523,1.3081,68.7675,9.1793,22.1373,29.2486,63.5061,47.6973,33.5515,1.1005,2.5168,5.7991,2.3042,2.2870,5.2697,2.4000
 1751.0000,2576.2593,-0.0514,16.7171,17.9147,16.9692,16.8458,16.7760,16.7276,17.9147,0.3246,2.6801,0.2355,0.1668,4.3496,7.4168,4.0377,4.0377,2.7237,0.0152,-1.8231,1.7497,10.1561,1.7497,55.8201,9.1184,41.8941,50.7591,54.4432,47.5599,32.9906,1.1043,2.5673,5.5968,2.1800,2.3249,5.0682,0.8000
 1751.5000,2548.5383,-0.0498,15.6549,16.7417,15.9163,15.7895,15.7171,15.6669,16.7417,0.3253,2.6743,-0.0311,0.3408,4.3390,7.0036,3.6792,3.6792,2.3684,0.0135,-1.4737,2.0868,10.4644,2.0868,59.7311,9.1101,25.8888,18.2257,61.7512,48.1972,33.5060,1.1192,2.5943,5.6955,2.1954,2.3181,5.0890,3.0000
 1752.0000,2564.7998,-0.0588,16.5432,17.8998,16.8807,16.6632,16.5996,16.5561,17.8998,0.3242,2.6756,-0.1925,-0.1316,4.2563,7.6826,4.2688,4.2688,2.9524,0.0110,-1.5488,2.0143,10.3981,2.0144,55.8666,9.1225,32.4639,35.9919,74.4310,51.1914,36.0931,1.2024,2.6984,6.1501,2.2791,2.2441,5.1147,1.6000
 1752.5000,2527.4395,-0.0226,17.2419,17.7815,16.7227,16.4975,16.9320,17.2553,17.7815,0.3251,2.6785,-0.0442,-0.1281,4.2805,8.9033,5.3356,5.3356,4.0061,0.0122,-1.7283,1.8411,10.2397,1.8411,56.2381,9.1045,57.3697,64.6384,75.0591,56.4053,40.6780,1.3493,2.8678,6.9592,2.4267,2.1254,5.1575,2.0000
 1753.0000,2511.5928,-0.0037,7.8769,7.9172,7.6908,7.6652,7.7887,7.8782,7.9172,0.3241,2.6643,0.0233,-0.1918,4.2433,10.8928,7.0934,7.0934,5.7339,0.0224,-0.8678,2.6714,10.9990,2.6714,126.3080,9.1649,29.8906,20.4402,78.7849,65.9801,48.5224,1.6144,3.2562,8.2781,2.5423,2.0170,5.1277,0.0000
 1753.5000,2544.6458,0.0094,4.0909,4.0383,3.9804,3.9844,4.0250,4.0907,4.0383,0.3255,2.6343,-0.2054,-0.5848,3.9477,16.6834,12.3423,12.3423,10.8362,0.0383,0.9524,4.4277,12.6050,4.4277,247.6315,9.2154,5.9590,3.9627,100.0743,80.1345,59.5751,1.9898,3.9025,10.1271,2.5950,1.9612,5.0894,1.0000
 1754.0000,2580.5779,0.0430,3.1702,2.9845,2.9634,2.9745,3.0106,3.1700,2.9845,0.3252,2.6091,-0.5796,-0.3678,3.6127,25.5414,20.7451,20.7451,18.8473,0.0434,2.4786,5.9004,13.9517,5.9004,335.0682,9.2979,4.6987,2.5713,125.9800,94.4530,70.4530,2.3725,4.5779,11.8846,2.5961,1.9296,5.0094,0.0000
 1754.5000,2552.0281,0.0384,2.8767,2.7258,2.7229,2.7404,2.7632,2.8765,2.7258,0.3252,2.5928,-0.7406,0.4476,3.4536,30.2287,25.3695,25.3695,23.1846,0.0311,3.4688,6.8559,14.8254,6.8559,366.8629,9.4556,4.6271,2.7822,140.4165,102.6176,76.6517,2.6099,4.9599,12.7941,2.5795,1.9004,4.9021,1.6000
 1755.0000,2379.9802,0.0334,2.7882,2.6610,2.6715,2.6966,2.7097,2.7880,2.6610,0.3257,2.5790,-0.5489,0.4803,3.4010,30.6981,25.8392,25.8392,23.6226,0.0153,4.3014,7.6592,15.5600,7.6592,375.7980,9.6015,4.5287,2.3915,143.1404,104.2811,77.9008,2.6868,5.0260,12.8394,2.5546,1.8706,4.7786,0.8000
 1755.5000,2441.8484,0.0219,2.7453,2.6627,2.6861,2.7198,2.7228,2.7451,2.6627,0.3240,2.5778,-0.1451,0.0124,3.3753,30.4273,25.5681,25.5681,23.3698,0.0074,4.3763,7.7315,15.6262,7.7315,375.5524,9.7026,4.7184,2.8359,139.9874,103.6647,77.7364,2.7229,4.9318,12.6144,2.5578,1.8113,4.6327,1.6000
 1756.0000,2434.7651,0.0275,2.7783,2.6737,2.7086,2.7508,2.7443,2.7782,2.6737,0.3241,2.5813,0.2105,0.0953,3.3742,30.5407,25.6815,25.6815,23.4756,0.0047,4.1665,7.5291,15.4410,7.5291,374.0094,9.7248,4.3692,3.1476,135.9520,103.4496,78.0980,2.7572,4.8463,12.5705,2.5938,1.7577,4.5592,2.0000
 1756.5000,2443.2532,0.0246,2.7468,2.6541,2.6980,2.7470,2.7341,2.7465,2.6541,0.3257,2.5794,0.2699,0.1305,3.3988,30.8607,26.0022,26.0022,23.7745,0.0031,4.2780,7.6366,15.5394,7.6367,376.7807,9.6854,4.3348,2.9333,135.7700,103.8421,79.2774,2.8082,4.7225,12.7159,2.6926,1.6817,4.5281,2.4000
 1757.0000,2474.6011,0.0237,2.6993,2.6117,2.6620,2.7155,2.7010,2.6991,2.6117,0.3247,2.5814,-0.0133,-0.0065,3.4257,30.8953,26.0369,26.0369,23.8067,0.0033,4.1602,7.5229,15.4354,7.5230,382.8887,9.7387,4.1878,3.0077,135.9449,103.9087,80.3634,2.8573,4.5758,12.8397,2.8060,1.6015,4.4937,1.6000
 1757.5000,2544.6919,0.0247,2.6505,2.5607,2.6150,2.6715,2.6601,2.6500,2.5607,0.3242,2.5782,-0.2302,0.1682,3.4301,31.0354,26.1775,26.1775,23.9378,0.0016,4.3543,7.7103,15.6067,7.7103,390.5252,9.7654,4.3739,3.1407,135.4970,104.3879,81.8093,2.9174,4.4515,13.0294,2.9270,1.5259,4.4662,4.8000
 1758.0000,2571.8369,0.0283,2.5977,2.4971,2.5533,2.6108,2.6078,2.5965,2.4971,0.3239,2.5613,-0.0063,0.1745,3.4308,32.2934,27.4447,27.4447,25.1162,-0.0013,5.3734,8.6936,16.5059,8.6936,400.4633,9.8019,4.6824,2.8915,137.5517,106.5544,84.1854,3.0186,4.4562,13.3294,2.9912,1.4762,4.4157,0.0000
 1758.5000,2445.7410,0.0358,2.5200,2.3968,2.4518,2.5073,2.5180,2.5176,2.3968,0.3247,2.5355,0.1477,-0.5833,3.4070,34.7550,29.9489,29.9489,27.4357,0.0003,6.9375,10.2028,17.8860,10.2028,417.2213,9.7684,3.9877,2.1187,140.6101,108.6310,86.3714,3.1219,4.4804,13.5573,3.0259,1.4351,4.3426,2.4000
 1759.0000,2426.3010,0.0462,2.3828,2.2329,2.2828,2.3323,2.3586,2.3779,2.2329,0.3253,2.4895,-0.3048,-0.8537,3.3212,37.2885,32.5602,32.5602,29.8418,0.0022,9.7259,12.8934,20.3464,12.8934,447.8456,9.7789,3.3826,2.0647,142.3704,111.1528,88.4334,3.2184,4.5907,13.7767,3.0010,1.4264,4.2806,4.0000
 1759.5000,2518.3420,0.0559,2.2625,2.0905,2.1350,2.1784,2.2181,2.2552,2.0905,0.3262,2.3662,-0.6423,-0.3124,3.1608,39.6733,35.0496,35.0496,32.1239,0.0000,17.1989,20.1042,26.9402,20.1042,478.3652,9.7550,4.0523,2.2882,141.1499,108.7505,86.8525,3.1727,4.4555,13.4745,3.0243,1.4043,4.2470,4.0000
 1760.0000,2484.3218,0.0636,2.1981,2.0085,2.0495,2.0884,2.1397,2.1894,2.0085,0.3252,2.1413,-0.1952,0.5112,2.8662,41.4644,36.9387,36.9387,33.8486,-0.0023,30.8284,33.2555,38.9663,33.2555,497.8746,9.6871,3.9469,2.0168,133.6394,104.6209,83.5260,3.0538,4.2976,12.9459,3.0123,1.4073,4.2392,0.0000
 1760.5000,2468.9351,0.0706,2.1793,1.9710,2.0094,2.0451,2.1064,2.1703,1.9710,0.3244,2.0207,0.2628,1.3185,2.6047,42.8025,38.3611,38.3611,35.1432,-0.0000,38.1405,40.3110,45.4181,40.3110,507.3514,9.6276,6.6092,2.8496,125.2867,99.1862,79.5835,2.9061,4.0194,12.3520,3.0731,1.3831,4.2505,1.0000
 1761.0000,2513.1021,0.0762,2.0640,1.8515,1.8838,1.9135,1.9757,2.0523,1.8515,0.3257,2.1913,0.2258,0.9134,2.7128,36.8604,32.1166,32.1166,29.4339,0.0042,27.8022,30.3354,36.2960,30.3354,540.1170,9.6162,5.2789,2.1978,122.1926,95.0460,76.2766,2.7932,3.8345,11.8014,3.0777,1.3728,4.2251,7.2000
 1761.5000,2584.5278,0.0787,2.0024,1.7896,1.8176,1.8434,1.9034,1.9904,1.7896,0.3251,2.4384,0.1877,-0.2667,3.0017,31.3869,26.5306,26.5306,24.2665,0.0063,12.8249,15.8836,23.0808,15.8837,558.7862,9.7112,2.7077,1.7939,122.3630,92.9976,74.1531,2.7298,3.8201,11.4044,2.9854,1.3994,4.1777,3.0000
 1762.0000,2556.1050,0.0771,2.0533,1.8393,1.8656,1.8903,1.9475,2.0428,1.8393,0.3242,2.5339,0.0390,-0.8111,3.0838,30.6150,25.7559,25.7559,23.5450,0.0082,7.0359,10.2978,17.9728,10.2978,543.6779,9.7921,2.3848,1.6549,122.6396,92.0871,72.1821,2.6862,3.9538,10.9640,2.7730,1.4719,4.0816,4.8000
 1762.5000,2616.3831,0.0706,2.1824,1.9737,1.9995,2.0250,2.0764,2.1730,1.9737,0.3243,2.5357,-0.2196,-0.1794,3.0451,30.6986,25.8397,25.8397,23.6230,0.0051,6.9256,10.1913,17.8755,10.1913,506.6537,9.9234,2.1835,1.9227,121.7233,92.6100,71.0133,2.6679,4.1979,10.6669,2.5410,1.5735,3.9982,3.2000
 1763.0000,2618.6750,0.0537,2.3675,2.1945,2.2201,2.2483,2.2865,2.3610,2.1945,0.3247,2.5257,-0.0156,0.3705,3.0557,29.5889,24.7311,24.7311,22.5886,-0.0073,7.5335,10.7779,18.4119,10.7779,455.6812,9.9939,2.7089,2.1206,120.4323,92.8561,69.1538,2.6221,4.4772,10.2736,2.2946,1.7075,3.9181,1.0000
 1763.5000,2617.0735,0.0195,2.5405,2.4726,2.4967,2.5286,2.5414,2.5354,2.4726,0.3256,2.5270,0.1053,-0.1197,3.0754,28.7246,23.8723,23.8723,21.7855,-0.0128,7.4569,10.7040,18.3443,10.7040,404.4294,9.9635,1.9978,1.6379,118.2625,89.4596,65.1280,2.4793,4.4707,9.6288,2.1537,1.8032,3.8837,2.4000
 1764.0000,2553.4329,-0.0123,2.8624,2.9110,2.9316,2.9695,2.9513,2.8526,2.9110,0.3261,2.5182,-0.2835,-0.6641,3.1269,31.7115,26.8574,26.8574,24.5705,0.0038,7.9900,11.2184,18.8147,11.2184,343.5266,10.0225,0.9037,1.1949,108.5912,81.7215,58.3858,2.2318,4.1841,8.5884,2.0526,1.8747,3.8482,1.0000
 1764.5000,2487.8115,-0.0159,3.2833,3.3556,3.3686,3.4115,3.3853,3.2556,3.3556,0.3250,2.4203,-0.4740,-0.3588,3.1300,31.0421,26.1842,26.1842,23.9440,0.0461,13.9229,16.9431,24.0496,16.9431,298.0134,9.7696,4.3273,1.4823,91.2381,69.9936,49.2077,1.8734,3.6679,7.2742,1.9832,1.9579,3.8828,1.6000
 1765.0000,2535.8125,-0.0022,2.3856,2.3928,2.3952,2.4240,2.4302,2.3867,2.3928,0.3246,2.3230,-0.1984,0.7419,3.0161,29.6993,24.8411,24.8411,22.6914,0.1016,19.8160,22.6295,29.2494,22.6295,417.9279,9.7263,1.0139,0.5797,77.0969,59.2991,41.0887,1.5584,3.1860,6.1020,1.9153,2.0444,3.9155,1.0000
 1765.5000,2571.7786,0.0243,2.2923,2.2161,2.2132,2.2355,2.2661,2.3002,2.2161,0.3236,2.4041,0.1884,0.9310,3.2091,26.7953,21.9703,21.9703,20.0010,0.1132,14.9023,17.8881,24.9138,17.8882,451.2434,9.7158,1.7176,1.5579,67.7217,48.9927,33.6887,1.2636,2.6754,5.0702,1.8951,2.1173,4.0125,0.0000
 1766.0000,2566.1584,0.0744,3.4892,3.1379,3.1255,3.1671,3.2695,3.4346,3.1379,0.3241,2.5773,0.2792,-0.2278,3.7515,20.6450,16.0453,16.0453,14.3887,0.0687,4.4090,7.7630,15.6550,7.7631,318.6819,9.3668,5.7392,5.4435,54.8911,39.5451,27.0144,1.0047,2.1881,4.1061,1.8765,2.1778,4.0868,0.0000
 1766.5000,2594.4441,0.1590,5.7104,4.5149,4.4794,4.5640,4.8451,5.3949,4.5149,0.3253,2.6865,0.1430,-0.6253,4.1082,16.6395,12.3018,12.3018,10.7971,0.0362,-2.2119,1.3745,9.8130,1.3745,221.4869,9.0835,27.8852,25.6265,41.1371,32.4974,22.0004,0.8132,1.8283,3.3680,1.8421,2.2483,4.1416,3.2000
 1767.0000,2656.9792,0.2204,6.7658,4.8471,4.7994,4.8998,5.2683,6.2135,4.8471,0.3238,2.7117,0.0861,-0.0778,4.2408,15.2437,11.0190,11.0190,9.5575,0.0295,-3.7374,-0.0975,8.4670,-0.0975,206.3097,8.9123,26.0184,22.7100,36.4870,28.8370,19.2159,0.7068,1.6648,2.9584,1.7770,2.3555,4.1858,4.0000
 1767.5000,2653.3748,0.2045,5.4510,4.0080,3.9742,4.0486,4.3271,5.0708,4.0080,0.3249,2.6829,-0.2089,-0.0207,4.3898,16.4282,12.1068,12.1068,10.6090,0.0211,-1.9953,1.5835,10.0042,1.5835,249.5008,8.9571,13.9719,10.3524,39.2136,29.3814,19.1131,0.6967,1.7565,2.9721,1.6921,2.5210,4.2657,0.8000
 1768.0000,2592.6704,0.1872,4.4644,3.3751,3.3525,3.4119,3.6345,4.2142,3.3751,0.3255,2.6430,-0.6362,-0.2616,4.4738,18.0572,13.6163,13.6163,12.0625,0.0125,0.4227,3.9166,12.1377,3.9166,296.2859,9.0365,7.7513,7.0643,41.7572,31.6697,20.1846,0.7173,1.9534,3.2263,1.6516,2.7231,4.4976,2.4000
 1768.5000,2526.1956,0.1848,3.9658,3.0097,2.9946,3.0487,3.2527,3.7893,3.0097,0.3246,2.6170,-0.2522,-0.1297,4.4594,17.6861,13.2710,13.2710,11.7306,0.0083,2.0021,5.4406,13.5313,5.4406,332.2585,9.1749,7.3606,6.2675,42.5316,33.6400,21.0932,0.7203,2.1109,3.5108,1.6632,2.9306,4.8741,5.0000
 1769.0000,2423.3059,0.2061,4.0109,2.9414,2.9312,2.9913,3.2126,3.7979,2.9414,0.3243,2.6116,0.5861,0.0472,4.4890,17.5771,13.1698,13.1698,11.6333,0.0081,2.3301,5.7571,13.8206,5.7571,339.9764,9.2064,8.6558,6.6080,43.0785,33.7762,21.2232,0.6945,2.1027,3.6759,1.7482,3.0277,5.2930,2.4000
 1769.5000,2472.0222,0.2444,4.5491,3.1321,3.1272,3.2075,3.4834,4.1939,3.1321,0.3237,2.6291,0.6483,0.2445,4.5396,16.8040,12.4537,12.4537,10.9436,0.0086,1.2686,4.7329,12.8841,4.7329,319.2707,9.1712,9.8383,8.3465,43.1651,32.1338,20.7197,0.6554,1.9120,3.6959,1.9330,2.9172,5.6389,7.2000
 1770.0000,2500.7791,0.3147,5.8508,3.5738,3.5801,3.7049,4.0882,5.0117,3.5738,0.3232,2.6509,0.1956,0.3671,4.6322,15.9468,11.6638,11.6638,10.1812,0.0097,-0.0520,3.4586,11.7188,3.4586,279.8155,9.1961,16.1268,15.5635,40.2092,29.4416,19.4459,0.6132,1.6853,3.4779,2.0637,2.7484,5.6716,3.2000
 1770.5000,2500.1223,0.3778,7.4821,4.0875,4.1185,4.3165,4.8495,6.0315,4.0875,0.3246,2.6419,0.1008,0.1119,4.8201,15.4839,11.2390,11.2390,9.7705,0.0170,0.4914,3.9829,12.1983,3.9829,244.6469,9.2126,21.0653,19.3901,35.3486,26.6679,17.9676,0.5672,1.4973,3.2106,2.1443,2.6399,5.6606,0.0000
 1771.0000,2494.6169,0.3899,7.8865,4.2159,4.2807,4.5379,5.1519,6.3989,4.2159,0.3257,2.6085,0.1403,-0.1211,4.9845,15.3649,11.1299,11.1299,9.6650,0.0240,2.5131,5.9337,13.9821,5.9337,237.1974,9.2351,16.4231,14.4466,31.5844,25.1584,17.1279,0.5431,1.4125,3.0489,2.1585,2.6007,5.6136,2.0000
 1771.5000,2497.0361,0.3791,7.0226,3.8280,3.9144,4.1704,4.7295,5.7786,3.8280,0.3257,2.5878,-0.0612,-0.0683,5.0321,15.3084,11.0782,11.0782,9.6149,0.0188,3.7716,7.1480,15.0925,7.1480,261.2346,9.3147,15.3190,13.2626,31.8869,25.9293,18.0091,0.5714,1.4252,3.2041,2.2481,2.4941,5.6070,2.4000
 1772.0000,2594.6050,0.3651,5.7692,3.2247,3.3136,3.5284,3.9770,4.7685,3.2247,0.3240,2.6067,-0.2306,0.0867,4.9332,15.4796,11.2350,11.2350,9.7666,0.0106,2.6267,6.0433,14.0823,6.0433,310.1089,9.3321,13.4629,10.3849,37.4943,29.3730,20.8251,0.6656,1.5662,3.6824,2.3511,2.3532,5.5326,0.0000
 1772.5000,2539.6240,0.3538,4.6866,2.6726,2.7548,2.9253,3.2807,3.8782,2.6726,0.3245,2.6556,-0.3500,0.1298,4.6863,16.6529,12.3142,12.3142,10.8091,0.0106,-0.3393,3.1814,11.4653,3.1814,374.1663,9.4278,12.0969,8.2828,48.5361,37.8152,27.3884,0.8771,1.9333,4.8345,2.5007,2.2041,5.5117,0.8000
 1773.0000,2551.9246,0.3413,3.7964,2.2136,2.2849,2.4166,2.6984,3.1578,2.2136,0.3242,2.6876,-0.3781,0.0311,4.3265,19.2230,14.7058,14.7058,13.1078,0.0117,-2.2771,1.3115,9.7555,1.3115,451.7521,9.4446,9.9432,6.5194,63.5034,47.9647,35.4252,1.1200,2.3508,6.3220,2.6893,2.0990,5.6448,0.0000
 1773.5000,2536.5493,0.3324,3.1923,1.8904,1.9527,2.0583,2.2931,2.6726,1.8904,0.3235,2.6656,-0.1064,-0.3903,3.9045,23.2342,18.5138,18.5138,16.7371,0.0128,-0.9426,2.5993,10.9330,2.5993,528.9761,9.5082,6.0802,4.0946,80.1981,58.8343,44.3763,1.3758,2.7551,8.0485,2.9213,2.0026,5.8502,0.8000
 1774.0000,2561.9780,0.3348,2.9463,1.7375,1.7977,1.8939,2.1158,2.4756,1.7375,0.3241,2.5818,-0.0045,-0.7278,3.3545,25.5796,20.7823,20.7823,18.8823,0.0126,4.1345,7.4982,15.4128,7.4982,575.5369,9.5676,6.8306,3.8899,93.5123,68.8188,52.6481,1.5975,3.1159,9.7133,3.1173,1.9505,6.0803,6.4000
 1774.5000,2511.3623,0.3421,2.9019,1.6897,1.7524,1.8482,2.0759,2.4436,1.6897,0.3244,2.4981,-0.1389,-0.5429,2.7300,26.1797,21.3677,21.3677,19.4339,0.0126,9.2064,12.3922,19.8880,12.3922,591.8255,9.6095,7.3650,4.5022,98.8645,74.1550,57.4742,1.7249,3.2481,10.6944,3.2925,1.8831,6.2002,4.8000
 1775.0000,2429.3645,0.3427,2.8544,1.6602,1.7243,1.8193,2.0488,2.4127,1.6602,0.3257,2.4669,0.0951,-0.0297,2.3753,27.5940,22.7552,22.7552,20.7384,0.0163,11.0971,14.2165,21.5563,14.2165,602.3426,9.6570,7.4247,4.5577,98.9600,77.3071,60.3403,1.8049,3.3181,11.2558,3.3922,1.8384,6.2361,1.6000
 1775.5000,2367.1624,0.3387,2.8141,1.6481,1.7130,1.8068,2.0351,2.3900,1.6481,0.3243,2.4581,0.4289,0.4861,2.3496,27.9519,23.1081,23.1081,21.0694,0.0149,11.6312,14.7319,22.0275,14.7319,606.7545,9.6956,6.9684,4.4472,99.0006,77.9003,61.1016,1.8269,3.2923,11.4017,3.4632,1.8021,6.2410,2.0000
 1776.0000,2417.2136,0.3339,2.7998,1.6537,1.7187,1.8113,2.0367,2.3828,1.6537,0.3243,2.4567,0.3195,0.3906,2.4177,27.7267,22.8860,22.8860,20.8610,0.0068,11.7122,14.8100,22.0990,14.8100,604.7070,9.7223,7.3729,4.6341,101.6231,78.7115,61.6883,1.8397,3.3312,11.5336,3.4623,1.8107,6.2693,0.8000
 1776.5000,2556.7383,0.3262,2.8017,1.6773,1.7422,1.8338,2.0550,2.3946,1.6773,0.3238,2.4658,-0.0550,0.0863,2.4667,26.7595,21.9352,21.9352,19.9680,0.0020,11.1650,14.2820,21.6162,14.2820,596.1912,9.7807,7.7175,4.7005,104.8363,80.8214,62.5444,1.8522,3.5333,11.7556,3.3271,1.9076,6.3468,2.4000
 1777.0000,2526.1843,0.3084,2.7878,1.7217,1.7862,1.8774,2.0942,2.4301,1.7217,0.3231,2.4744,-0.3443,-0.1758,2.4529,26.8778,22.0512,22.0512,20.0770,0.0016,10.6450,13.7803,21.1574,13.7803,580.8378,9.8330,7.2650,4.6233,105.0679,82.3145,62.9715,1.8464,3.7044,11.9234,3.2187,2.0063,6.4577,2.4000
 1777.5000,2494.2954,0.3000,2.8146,1.7637,1.8262,1.9149,2.1204,2.4408,1.7637,0.3256,2.4776,-0.4449,-0.4260,2.4138,26.9743,22.1459,22.1459,20.1661,-0.0002,10.4501,13.5922,20.9854,13.5922,566.9883,9.7955,7.5374,4.7751,106.8487,85.1066,64.3646,1.8719,3.9404,12.2600,3.1114,2.1050,6.5495,3.2000
 1778.0000,2533.0256,0.2845,2.8214,1.8154,1.8751,1.9607,2.1515,2.4478,1.8154,0.3244,2.4772,-0.2085,-0.0768,2.4176,27.2176,22.3848,22.3848,20.3906,-0.0030,10.4756,13.6168,21.0079,13.6168,550.8325,9.8344,7.6974,5.0385,112.0056,88.6010,66.6438,1.9290,4.1593,12.7378,3.0625,2.1562,6.6034,1.6000
 1778.5000,2525.4241,0.2562,2.7701,1.8701,1.9258,2.0071,2.1787,2.4398,1.8701,0.3234,2.4793,0.2295,0.3046,2.4391,27.8520,23.0096,23.0096,20.9770,-0.0034,10.3483,13.4940,20.8956,13.4940,534.7410,9.7870,7.8404,4.8077,116.5799,93.1309,69.9627,2.0339,4.3791,13.3300,3.0440,2.1530,6.5539,1.6000
 1779.0000,2562.0354,0.2042,2.5971,1.9105,1.9606,2.0350,2.1820,2.3982,1.9105,0.3246,2.4773,0.2209,0.3363,2.4853,27.4987,22.6614,22.6614,20.6503,-0.0007,10.4684,13.6098,21.0015,13.6098,523.4185,9.7533,8.1503,4.7473,123.3007,98.2177,73.5906,2.1455,4.6530,13.9921,3.0071,2.1687,6.5215,3.2000
 1779.5000,2528.9138,0.1385,2.3609,1.9275,1.9702,2.0355,2.1552,2.3257,1.9275,0.3240,2.4701,-0.1918,0.1183,2.6068,28.7944,23.9415,23.9415,21.8502,0.0017,10.9007,14.0270,21.3830,14.0270,518.8146,9.6972,8.1137,4.4584,130.2661,101.0891,74.9486,2.2042,4.8931,14.1598,2.8938,2.2199,6.4240,4.0000
 1780.0000,2562.5889,0.1211,2.3162,1.9421,1.9814,2.0426,2.1506,2.3034,1.9421,0.3233,2.4762,-0.2056,-0.3342,2.7517,28.8321,23.9789,23.9789,21.8852,0.0022,10.5316,13.6709,21.0573,13.6709,514.9141,9.5881,7.7744,4.0935,134.3193,102.5556,75.0898,2.2105,5.0822,14.1762,2.7894,2.2991,6.4131,5.0000
 1780.5000,2507.9883,0.1077,2.3738,2.0313,2.0622,2.1135,2.1962,2.3173,2.0313,0.3244,2.4934,0.1879,-0.1888,2.8069,29.2060,24.3502,24.3502,22.2326,0.0035,9.4911,12.6669,20.1392,12.6669,492.2899,9.5554,7.6144,3.9954,135.9993,102.0583,74.2596,2.1764,5.0961,14.0655,2.7601,2.3416,6.4629,6.4000
 1781.0000,2488.5369,0.1077,2.3738,2.0313,2.0622,2.1135,2.1962,2.3173,2.0313,0.3244,2.4981,0.1211,0.5952,2.8043,28.5650,23.7142,23.7142,21.6374,0.0039,9.2040,12.3898,19.8859,12.3898,492.2899,9.5490,6.7681,3.5567,133.8268,100.6714,72.7838,2.1338,5.0619,13.7829,2.7229,2.3723,6.4594,2.0000
 1781.5000,2551.6018,0.0788,2.4026,2.1470,2.1663,2.2042,2.2623,2.3672,2.1470,0.3249,2.4902,-0.2268,0.8760,2.8407,27.9038,23.0606,23.0606,21.0249,0.0020,9.6872,12.8560,20.3122,12.8560,465.7698,9.5260,6.5339,3.4334,128.8154,98.0942,70.8320,2.0683,4.9178,13.4525,2.7355,2.3777,6.5042,6.4000
 1782.0000,2519.0674,0.0658,2.4462,2.2278,2.2421,2.2744,2.3229,2.4237,2.2278,0.3241,2.4877,-0.1291,0.4115,2.8929,27.8852,23.0423,23.0423,21.0077,0.0008,9.8340,12.9977,20.4418,12.9977,448.8652,9.5154,6.4910,3.3239,124.9513,95.9056,69.1623,2.0180,4.7975,13.1428,2.7395,2.3774,6.5129,4.0000
 1782.5000,2529.8699,0.0535,2.5146,2.3316,2.3411,2.3688,2.4076,2.5010,2.3316,0.3230,2.4946,0.1111,-0.2441,2.9059,28.2624,23.4148,23.4148,21.3569,0.0012,9.4160,12.5944,20.0729,12.5944,428.8828,9.5196,6.8207,3.4227,124.0082,93.0540,67.2589,1.9538,4.6217,12.8218,2.7742,2.3655,6.5623,4.8000
 1783.0000,2436.2622,0.0407,2.6264,2.4804,2.4855,2.5097,2.5384,2.6194,2.4804,0.3235,2.5106,0.2684,-0.5840,2.9102,28.0068,23.1623,23.1623,21.1202,0.0046,8.4509,11.6631,19.2213,11.6631,403.1645,9.4973,6.9847,3.6480,124.9843,92.3970,67.1249,1.9480,4.5308,12.8054,2.8263,2.3258,6.5735,0.8000
 1783.5000,2531.6782,0.0284,2.7924,2.6838,2.6846,2.7067,2.7248,2.7902,2.6838,0.3234,2.5330,0.5096,-0.4421,2.9830,28.2418,23.3944,23.3944,21.3378,0.0088,7.0891,10.3491,18.0198,10.3491,372.6090,9.4875,7.4185,3.7935,123.7325,92.7565,67.4210,1.9773,4.5248,12.7637,2.8208,2.2884,6.4551,1.6000
 1784.0000,2574.1404,0.0189,2.9174,2.8417,2.8384,2.8583,2.8665,2.9168,2.8417,0.3239,2.5451,0.6231,-0.2608,3.0522,29.1224,24.2671,24.2671,22.1548,0.0118,6.3563,9.6420,17.3732,9.6420,351.9048,9.5069,7.7515,3.7884,119.6267,93.5716,68.3809,2.0381,4.5195,12.7904,2.8300,2.2175,6.2756,4.8000
 1784.5000,2536.3997,0.0095,2.9263,2.8881,2.8821,2.8996,2.9021,2.9255,2.8881,0.3246,2.5395,0.2980,-0.2332,3.0032,29.3070,24.4506,24.4506,22.3264,0.0158,6.6989,9.9726,17.6754,9.9726,346.2543,9.5501,6.1126,3.6368,120.0407,95.9727,70.6965,2.1478,4.5613,13.0306,2.8568,2.1237,6.0670,0.8000
 1785.0000,2531.3904,0.0025,2.8964,2.8865,2.8792,2.8954,2.8957,2.8959,2.8865,0.3244,2.5268,-0.1948,0.0799,2.9287,30.2886,25.4293,25.4293,23.2404,0.0159,7.4674,10.7142,18.3536,10.7142,346.4431,9.5662,5.9763,3.5382,125.4331,95.6543,71.2282,2.1944,4.4573,12.9842,2.9130,2.0312,5.9170,3.2000
 1785.5000,2578.8044,0.0026,2.9480,2.9373,2.9294,2.9461,2.9443,2.9479,2.9373,0.3253,2.5173,-0.1798,0.3996,2.9233,30.2912,25.4319,25.4319,23.2428,0.0112,8.0394,11.2661,18.8583,11.2661,340.4455,9.5754,6.1752,3.4012,124.9733,95.6920,72.1456,2.2429,4.3537,13.0553,2.9987,1.9411,5.8206,4.0000
 1786.0000,2590.0330,0.0116,3.1325,3.0825,3.0744,3.0932,3.0877,3.1325,3.0825,0.3230,2.5241,0.1136,0.2456,2.9958,30.2798,25.4205,25.4205,23.2322,0.0094,7.6308,10.8718,18.4977,10.8718,324.4128,9.5392,6.8391,3.8201,121.8718,96.9029,73.5804,2.3021,4.3453,13.2457,3.0483,1.8875,5.7537,4.0000
 1786.5000,2497.2317,0.0141,3.2721,3.2089,3.2016,3.2232,3.2135,3.2721,3.2089,0.3241,2.5487,0.1469,0.1183,3.1395,30.2677,25.4085,25.4085,23.2209,0.0117,6.1414,9.4347,17.1836,9.4347,311.6296,9.5460,7.3446,3.6083,125.4703,97.6187,74.8838,2.3526,4.2928,13.4345,3.1296,1.8247,5.7106,4.8000
 1787.0000,2554.3540,0.0148,3.2948,3.2279,3.2227,3.2462,3.2342,3.2948,3.2279,0.3248,2.5627,0.1639,-0.0396,3.2506,30.4154,25.5561,25.5561,23.3586,0.0129,5.2883,8.6115,16.4308,8.6115,309.7951,9.5611,6.4102,3.2980,131.3709,100.1154,77.4940,2.4619,4.3160,13.7732,3.1912,1.7531,5.5946,5.6000
 1787.5000,2579.1721,0.0163,3.2319,3.1597,3.1574,3.1818,3.1702,3.2319,3.1597,0.3237,2.5523,-0.0498,-0.4331,3.2276,31.0827,26.2250,26.2250,23.9820,0.0129,5.9230,9.2239,16.9908,9.2239,316.4808,9.6083,5.9384,3.1905,134.4819,100.2089,78.3617,2.5167,4.2442,13.7983,3.2511,1.6864,5.4827,7.0000
 1788.0000,2568.4158,0.0178,3.1827,3.1050,3.1056,3.1310,3.1205,3.1827,3.1050,0.3242,2.5430,-0.6700,-0.8328,3.1252,31.8349,26.9818,26.9818,24.6861,0.0123,6.4851,9.7663,17.4869,9.7663,322.0589,9.6162,5.9493,3.4008,134.5788,100.6773,79.8537,2.5902,4.1270,13.9396,3.3776,1.5933,5.3817,1.6000
 1788.5000,2511.0630,0.0187,3.1688,3.0876,3.0911,3.1175,3.1083,3.1688,3.0876,0.3249,2.5381,-0.7921,-0.6705,3.0612,31.9317,27.0794,27.0794,24.7768,0.0082,6.7835,10.0542,17.7501,10.0543,323.8793,9.6293,6.0405,3.1945,132.9099,101.4030,81.2982,2.6483,4.0622,14.1380,3.4804,1.5339,5.3384,2.4000
 1789.0000,2545.4172,0.0187,3.1712,3.0899,3.0962,3.1232,3.1155,3.1712,3.0899,0.3236,2.5318,-0.2338,0.2881,3.0567,32.4063,27.5588,27.5588,25.2222,0.0043,7.1614,10.4189,18.0836,10.4189,323.6311,9.6402,5.9757,3.2046,129.9873,101.7043,81.7336,2.6733,4.0565,14.1628,3.4914,1.5174,5.2979,1.6000
 1789.5000,2600.8354,0.0170,3.1681,3.0939,3.1024,3.1292,3.1235,3.1681,3.0939,0.3239,2.5385,0.1408,0.5349,3.0708,31.4425,26.5866,26.5866,24.3186,0.0026,6.7602,10.0318,17.7296,10.0318,323.2125,9.6481,6.1231,3.4001,129.4428,102.1074,82.3501,2.7066,4.0210,14.2070,3.5332,1.4856,5.2490,0.8000
 1790.0000,2549.5054,0.0118,3.1547,3.1034,3.1133,3.1393,3.1361,3.1547,3.1034,0.3243,2.5518,0.1842,0.1233,3.1219,31.3922,26.5360,26.5360,24.2714,0.0009,5.9491,9.2491,17.0139,9.2491,322.2311,9.6476,6.1953,3.4508,131.2314,101.6005,81.9468,2.7014,4.0009,14.0995,3.5241,1.4811,5.2194,0.8000
 1790.5000,2542.9531,0.0078,3.1506,3.1169,3.1275,3.1520,3.1512,3.1506,3.1169,0.3246,2.5555,0.2303,0.1593,3.1656,31.0905,26.2328,26.2328,23.9893,0.0011,5.7283,9.0360,16.8190,9.0360,320.8288,9.6386,6.1601,3.4647,131.2368,100.0912,80.9912,2.6815,3.9008,13.8800,3.5583,1.4547,5.1762,0.8000
 1791.0000,2544.9797,0.0079,3.2172,3.1822,3.1929,3.2161,3.2167,3.2172,3.1822,0.3242,2.5485,0.2553,-0.1944,3.1205,30.6649,25.8060,25.8060,23.5916,0.0023,6.1530,9.4458,17.1938,9.4458,314.2479,9.6261,6.1053,3.3838,130.1652,98.6189,80.2084,2.6552,3.7925,13.7475,3.6250,1.4283,5.1776,1.0000
 1791.5000,2571.5715,0.0074,3.3051,3.2716,3.2814,3.3034,3.3044,3.3051,3.2716,0.3235,2.5457,0.1452,-0.3593,3.0785,30.8537,25.9951,25.9951,23.7679,0.0033,6.3202,9.6072,17.3414,9.6073,305.6634,9.6087,6.4895,3.6645,129.0678,97.3503,79.0378,2.6090,3.7769,13.5822,3.5961,1.4476,5.2059,0.0000
 1792.0000,2561.3213,0.0064,3.3628,3.3329,3.3407,3.3609,3.3619,3.3627,3.3329,0.3242,2.5487,0.1163,0.5388,3.1155,30.2006,25.3413,25.3413,23.1583,0.0058,6.1370,9.4304,17.1797,9.4304,300.0351,9.6002,6.7897,3.6501,126.0808,97.0353,78.5104,2.5838,3.8163,13.5284,3.5449,1.4770,5.2358,1.0000
 1792.5000,2549.0107,0.0072,3.3972,3.3634,3.3678,3.3860,3.3884,3.3971,3.3634,0.3229,2.5499,0.2589,0.7288,3.1877,30.4924,25.6332,25.6332,23.4305,0.0076,6.0680,9.3638,17.1188,9.3638,297.3177,9.6111,6.2493,3.5004,126.6393,97.5782,78.6702,2.5991,3.8841,13.5082,3.4778,1.4944,5.1972,1.6000
 1793.0000,2537.5750,0.0132,3.4369,3.3747,3.3744,3.3907,3.3964,3.4368,3.3747,0.3243,2.5540,0.1877,-0.1766,3.2687,30.8190,25.9604,25.9604,23.7355,0.0074,5.8203,9.1248,16.9002,9.1248,296.3263,9.6175,6.1222,3.3558,131.6855,97.9540,78.3256,2.6178,3.9979,13.3064,3.3283,1.5272,5.0830,1.0000
 1793.5000,2507.5620,0.0206,3.5000,3.4010,3.3945,3.4089,3.4209,3.4999,3.4010,0.3251,2.5669,0.0651,-0.4652,3.3631,31.1637,26.3063,26.3063,24.0577,0.0096,5.0374,8.3694,16.2095,8.3694,294.0295,9.6084,6.7672,3.5400,130.9411,95.5238,76.0765,2.5840,3.9480,12.7283,3.2240,1.5279,4.9258,2.4000
 1794.0000,2465.3879,0.0293,3.6154,3.4702,3.4556,3.4679,3.4909,3.6153,3.4702,0.3227,2.5821,0.0897,-0.0566,3.4571,30.9301,26.0718,26.0718,23.8393,0.0136,4.1181,7.4823,15.3983,7.4824,288.1678,9.6130,7.1629,4.2784,124.3491,94.4228,74.5065,2.5677,3.9990,12.2896,3.0731,1.5574,4.7861,3.2000
 1794.5000,2403.0371,0.0384,3.6480,3.4567,3.4334,3.4426,3.4794,3.6479,3.4567,0.3247,2.5813,0.0452,0.0199,3.4847,29.8455,24.9869,24.9869,22.8275,0.0121,4.1610,7.5238,15.4362,7.5238,289.2953,9.5832,7.0660,4.2752,122.9774,93.7453,73.3814,2.5580,4.0357,11.9665,2.9652,1.5777,4.6781,3.2000
 1795.0000,2470.3745,0.0139,3.4546,3.3885,3.3582,3.3632,3.4049,3.4545,3.3885,0.3236,2.5478,0.0297,0.1448,3.4366,28.4924,23.6424,23.6424,21.5701,0.0134,6.1913,9.4828,17.2276,9.4828,295.1124,9.6169,5.0765,2.5964,126.9839,90.1053,70.1952,2.4452,3.9113,11.4547,2.9286,1.5996,4.6845,0.0000
 1795.5000,2485.4160,-0.0032,4.0268,4.0448,3.9536,3.9474,3.9936,4.0268,4.0448,0.3243,2.5349,0.0105,0.6510,3.5672,23.6190,18.8839,18.8839,17.0879,0.0320,6.9748,10.2388,17.9189,10.2388,247.2303,9.4743,5.7621,5.0451,115.9776,78.2434,60.5343,2.1147,3.4261,9.8498,2.8749,1.6201,4.6578,0.0000
 1796.0000,2464.5588,-0.0132,7.9826,8.1287,7.8125,7.7714,7.8950,7.9845,8.1287,0.3228,2.6007,0.0013,0.4915,4.0640,13.4839,9.4178,9.4178,8.0036,0.0482,2.9897,6.3935,14.4026,6.3935,123.0205,9.2796,33.6311,50.8360,79.9974,58.7196,45.6935,1.5951,2.5252,7.4405,2.9465,1.5831,4.6646,1.6000
 1796.5000,2511.5354,-0.0388,26.6344,28.0692,26.1466,25.8259,26.3111,26.6714,28.0692,0.3232,2.6820,0.1351,-0.2359,4.6295,6.6193,3.3469,3.3469,2.0387,0.0408,-1.9396,1.6372,10.0533,1.6372,35.6262,9.1327,55.4006,83.4041,45.9469,38.9639,30.6029,1.0701,1.6321,4.9746,3.0480,1.5252,4.6487,1.6000
 1797.0000,2462.3018,-0.0689,31.4462,34.4728,32.2811,31.8340,31.6331,31.4955,34.4728,0.3256,2.7141,0.1359,-0.4497,4.9521,5.0833,2.0270,2.0270,0.7252,0.0240,-3.8855,-0.2404,8.3363,-0.2404,29.0084,8.9435,55.5107,85.2828,32.9192,28.6863,22.8589,0.7954,1.1530,3.7344,3.2390,1.4495,4.6951,2.4000
 1797.5000,2409.3252,-0.0558,24.8166,26.7462,25.7319,25.5020,24.9900,24.8462,26.7462,0.3250,2.7098,-0.0240,-0.5316,5.0524,6.7276,3.4404,3.4404,2.1315,0.0117,-3.6219,0.0139,8.5689,0.0139,37.3884,9.0041,59.7133,78.0568,33.5919,33.0323,26.6286,0.9207,1.2773,4.3781,3.4275,1.3873,4.7551,3.0000
 1798.0000,2435.4568,-0.0131,7.1203,7.2490,7.1208,7.0968,7.0234,7.1219,7.2490,0.3244,2.6983,-0.0822,-0.6969,4.8477,12.2610,8.3158,8.3158,6.9297,0.0237,-2.9296,0.6820,9.1798,0.6820,137.9495,9.0958,29.1567,23.5754,50.4962,48.2767,39.2047,1.3477,1.8044,6.4832,3.5929,1.3389,4.8107,2.4000
 1798.5000,2527.2898,-0.0044,3.5867,3.6083,3.5745,3.5710,3.5544,3.5868,3.6083,0.3240,2.6688,-0.1138,-0.2770,4.2411,21.4534,16.8119,16.8119,15.1196,0.0601,-1.1422,2.4066,10.7569,2.4066,277.1367,9.1328,5.2419,3.5015,85.6458,69.4692,56.2201,1.9339,2.5983,9.2903,3.5756,1.3435,4.8038,2.0000
 1799.0000,2563.2456,-0.0047,2.7484,2.7662,2.7523,2.7541,2.7507,2.7484,2.7662,0.3235,2.6222,-0.1611,-0.0275,3.6325,29.6986,24.8405,24.8405,22.6907,0.0751,1.6842,5.1338,13.2507,5.1338,361.5066,9.1193,4.4375,2.1950,119.9470,86.6735,70.0925,2.3989,3.2317,11.6409,3.6021,1.3472,4.8527,4.0000
 1799.5000,2552.6389,0.0042,2.5886,2.5736,2.5713,2.5769,2.5810,2.5885,2.5736,0.3239,2.5982,-0.2826,-0.0906,3.3971,31.8328,26.9797,26.9797,24.6841,0.0551,3.1365,6.5352,14.5322,6.5352,388.5677,9.2341,4.4688,2.3554,134.5593,98.2337,79.8302,2.7150,3.6279,13.3397,3.6770,1.3363,4.9134,2.4000
 1800.0000,2565.6748,0.0244,2.6244,2.5365,2.5439,2.5522,2.5617,2.6244,2.5365,0.3246,2.5871,-0.2900,0.3238,3.4182,31.2246,26.3675,26.3675,24.1146,0.0296,3.8126,7.1876,15.1287,7.1876,394.2455,9.3279,4.6895,2.4092,133.3423,101.1194,82.5186,2.7760,3.7055,13.9333,3.7601,1.3349,5.0193,3.0000
 1800.5000,2536.7224,0.0291,2.6259,2.5212,2.5366,2.5474,2.5600,2.6259,2.5212,0.3228,2.5735,0.1276,0.3749,3.5018,31.0679,26.2101,26.2101,23.9681,0.0147,4.6365,7.9826,15.8557,7.9826,396.6293,9.4779,4.3270,2.2441,129.5916,100.1085,81.7841,2.7430,3.6773,13.8484,3.7660,1.3406,5.0486,1.6000
 1801.0000,2586.4746,0.0298,2.6110,2.5045,2.5263,2.5397,2.5535,2.6110,2.5045,0.3230,2.5731,0.4755,0.0195,3.5343,31.7655,26.9118,26.9118,24.6211,0.0110,4.6595,8.0048,15.8760,8.0048,399.2882,9.4867,4.4348,2.3051,130.6452,100.3883,81.7705,2.7577,3.7213,13.7743,3.7015,1.3494,4.9949,0.0000
 1801.5000,2576.2593,0.0300,2.6126,2.5054,2.5325,2.5485,2.5615,2.6126,2.5054,0.3240,2.5719,0.3714,0.3194,3.4619,32.5699,27.7243,27.7243,25.3758,0.0115,4.7311,8.0738,15.9392,8.0739,399.1374,9.4979,4.5501,2.3160,136.1884,100.8547,82.1833,2.7924,3.7314,13.7451,3.6836,1.3363,4.9223,5.6000
 1802.0000,2584.5515,0.0296,2.6456,2.5383,2.5698,2.5889,2.5986,2.6456,2.5383,0.3238,2.5561,0.1030,0.4170,3.3425,31.6897,26.8355,26.8355,24.5501,0.0107,5.6888,8.9979,16.7842,8.9979,393.9608,9.5738,4.7361,2.4446,136.9438,102.8884,84.4749,2.8828,3.7172,14.0688,3.7848,1.2894,4.8802,2.0000
 1802.5000,2625.4929,0.0263,2.6895,2.5927,2.6277,2.6504,2.6542,2.6895,2.5927,0.3229,2.5457,-0.0590,-0.0740,3.2396,31.6949,26.8407,26.8407,24.5549,0.0116,6.3222,9.6092,17.3431,9.6092,385.6997,9.5839,5.0208,2.6353,133.6017,104.3986,86.4206,2.9427,3.6950,14.4240,3.9036,1.2557,4.9016,2.4000
 1803.0000,2590.9316,0.0256,2.7505,2.6541,2.6917,2.7181,2.7139,2.7505,2.6541,0.3239,2.5439,-0.1044,0.0828,3.1731,31.5980,26.7432,26.7432,24.4642,0.0130,6.4314,9.7145,17.4395,9.7145,376.7687,9.6223,5.3144,2.7301,132.0939,103.0316,85.8416,2.8960,3.6142,14.4552,3.9995,1.2480,4.9914,1.6000
 1803.5000,2562.4854,0.0269,2.8003,2.6971,2.7353,2.7648,2.7522,2.8003,2.6971,0.3253,2.5458,-0.0649,0.2779,3.1801,30.4834,25.6241,25.6241,23.4221,0.0141,6.3152,9.6024,17.3369,9.6024,370.7641,9.6839,5.3626,2.7268,131.9469,101.3101,84.8939,2.8512,3.5204,14.3567,4.0782,1.2347,5.0354,4.8000
 1804.0000,2571.5254,0.0246,2.8245,2.7290,2.7663,2.7980,2.7782,2.8245,2.7290,0.3239,2.5604,0.0513,0.1440,3.2420,30.7837,25.9250,25.9250,23.7025,0.0160,5.4307,8.7489,16.5565,8.7489,366.4293,9.7286,5.2088,2.6674,130.9486,99.5397,84.1700,2.8187,3.3770,14.2732,4.2266,1.1981,5.0638,8.0000
 1804.5000,2597.8755,0.0223,2.8491,2.7620,2.7974,2.8306,2.8062,2.8491,2.7620,0.3239,2.5773,0.0331,0.0255,3.2629,31.1951,26.3379,26.3379,24.0871,0.0159,4.4067,7.7609,15.6530,7.7609,362.0626,9.7980,5.2594,2.7197,130.4365,98.9202,84.4051,2.8233,3.2734,14.3283,4.3772,1.1594,5.0750,4.0000
 1805.0000,2530.1814,0.0215,2.8903,2.8051,2.8384,2.8725,2.8469,2.8903,2.8051,0.3235,2.5803,-0.1016,-0.2133,3.2463,30.8070,25.9483,25.9483,23.7243,0.0141,4.2259,7.5864,15.4934,7.5864,356.4878,9.8401,5.2918,2.7396,129.8449,100.1597,85.9246,2.8704,3.2671,14.6038,4.4700,1.1382,5.0876,3.2000
 1805.5000,2430.5500,0.0224,2.9181,2.8284,2.8588,2.8925,2.8698,2.9181,2.8284,0.3223,2.5707,-0.0375,-0.0304,3.2721,30.9007,26.0423,26.0423,23.8118,0.0122,4.8070,8.1471,16.0062,8.1471,353.5535,9.8679,5.3971,2.8155,130.9227,102.3784,87.6058,2.9137,3.4037,14.9506,4.3924,1.1682,5.1311,2.0000
 1806.0000,2417.2598,0.0241,2.8965,2.8009,2.8273,2.8588,2.8424,2.8965,2.8009,0.3240,2.5607,0.0323,0.2278,3.2834,31.8145,26.9612,26.9612,24.6669,0.0108,5.4127,8.7315,16.5406,8.7315,357.0312,9.8781,5.2956,2.7108,133.7340,103.5288,88.0211,2.9147,3.5401,15.0824,4.2604,1.2146,5.1746,2.4000
 1806.5000,2578.5962,0.0246,2.8558,2.7597,2.7822,2.8109,2.8018,2.8558,2.7597,0.3232,2.5577,-0.1340,0.0736,3.2285,31.5067,26.6512,26.6512,24.3787,0.0092,5.5960,8.9084,16.7024,8.9084,362.3624,9.8937,5.0978,2.5713,134.3023,104.6993,87.9815,2.9199,3.7298,15.0447,4.0337,1.2774,5.1525,2.0000
 1807.0000,2604.9585,0.0136,2.7800,2.7281,2.7473,2.7730,2.7708,2.7800,2.7281,0.3231,2.5634,-0.2401,-0.2533,3.2299,32.2349,27.3855,27.3855,25.0613,0.0084,5.2470,8.5717,16.3944,8.5717,366.5578,9.8881,4.8390,2.4328,133.9919,104.9519,87.3960,2.9111,3.8436,14.8944,3.8751,1.3203,5.1164,3.2000
 1807.5000,2501.7688,0.0175,2.7589,2.6924,2.7087,2.7312,2.7346,2.7589,2.6924,0.3237,2.5765,-0.1495,-0.3099,3.3120,33.0476,28.2084,28.2084,25.8249,0.0084,4.4557,7.8081,15.6962,7.8082,371.4118,9.8571,4.8727,2.4396,135.0482,104.9211,86.9130,2.9271,3.8878,14.6595,3.7706,1.3282,5.0082,1.0000
 1808.0000,2567.3911,0.0245,2.7752,2.6819,2.6957,2.7156,2.7226,2.7752,2.6819,0.3229,2.5817,-0.0079,0.0056,3.3584,32.3088,27.4602,27.4602,25.1306,0.0068,4.1407,7.5042,15.4183,7.5042,372.8715,9.8608,4.8370,2.3770,136.2491,104.8144,86.8774,2.9477,3.8904,14.5501,3.7400,1.3198,4.9360,0.8000
 1808.5000,2607.5037,0.0254,2.7920,2.6949,2.7067,2.7245,2.7332,2.7920,2.6949,0.3234,2.5754,-0.0096,0.1631,3.3449,32.6944,27.8503,27.8503,25.4928,0.0051,4.5194,7.8695,15.7524,7.8696,371.0728,9.8817,4.9753,2.5306,137.0378,104.5624,86.8123,2.9481,3.8791,14.5270,3.7449,1.3158,4.9276,2.0000
 1809.0000,2656.8408,0.0245,2.8022,2.7080,2.7179,2.7338,2.7429,2.8022,2.7080,0.3239,2.5703,0.0391,0.0035,3.3267,33.0312,28.1918,28.1918,25.8095,0.0037,4.8308,8.1700,16.0272,8.1701,369.2711,9.8951,4.8956,2.4633,138.0388,104.6262,87.1970,2.9626,3.8477,14.5847,3.7905,1.2988,4.9230,2.4000
 1809.5000,2634.9368,0.0226,2.8016,2.7148,2.7228,2.7371,2.7451,2.8016,2.7148,0.3228,2.5695,0.3050,0.0387,3.3384,32.6197,27.7747,27.7747,25.4226,0.0011,4.8761,8.2138,16.0671,8.2138,368.3547,9.8882,4.7713,2.4381,137.6147,104.4411,87.0403,2.9605,3.8467,14.5429,3.7806,1.2993,4.9122,2.0000
 1810.0000,2640.8672,0.0188,2.8160,2.7433,2.7496,2.7627,2.7685,2.8160,2.7433,0.3243,2.5683,0.1071,0.1242,3.3576,32.9710,28.1307,28.1307,25.7529,-0.0014,4.9488,8.2839,16.1313,8.2839,364.5293,9.8991,5.2503,2.7377,137.4348,104.6251,87.1873,2.9771,3.8521,14.5126,3.7675,1.2939,4.8748,1.6000
 1810.5000,2591.3567,0.0080,2.8265,2.7955,2.8002,2.8127,2.8150,2.8265,2.7955,0.3253,2.5645,-0.4200,-0.1720,3.3705,31.5197,26.6643,26.6643,24.3908,-0.0029,5.1845,8.5114,16.3393,8.5114,357.7120,9.9036,5.2068,2.7854,138.3415,104.8489,87.3574,2.9901,3.8738,14.5066,3.7448,1.2955,4.8515,1.6000
 1811.0000,2548.7339,0.0073,2.8727,2.8438,2.8468,2.8588,2.8561,2.8727,2.8438,0.3239,2.5583,-0.3429,-0.2735,3.3702,31.2877,26.4310,26.4310,24.1737,-0.0038,5.5595,8.8731,16.6701,8.8732,351.6452,9.9196,4.6817,2.5006,135.9135,103.8081,86.4995,2.9495,3.8475,14.4177,3.7473,1.3045,4.8882,3.2000
 1811.5000,2524.9866,0.0147,2.9583,2.8984,2.8997,2.9116,2.9025,2.9583,2.8984,0.3236,2.5540,-0.0579,-0.0398,3.3028,30.8321,25.9735,25.9735,23.7477,-0.0029,5.8183,9.1229,16.8985,9.1229,345.0205,9.9448,4.9378,2.6747,132.9221,103.7464,86.4122,2.9401,3.8631,14.4334,3.7362,1.3139,4.9091,1.6000
 1812.0000,2505.9502,0.0131,3.0130,2.9586,2.9585,2.9704,2.9544,3.0130,2.9586,0.3241,2.5516,-0.1534,-0.0324,3.2077,30.6726,25.8137,25.8137,23.5988,-0.0004,5.9660,9.2654,17.0288,9.2654,337.9974,9.9234,5.4191,2.9186,129.8226,102.2906,85.2263,2.8923,3.7948,14.2710,3.7607,1.3121,4.9342,5.0000
 1812.5000,2593.5105,0.0106,3.0491,3.0048,3.0035,3.0155,2.9937,3.0491,3.0048,0.3223,2.5483,-0.1858,0.0414,3.1702,30.2176,25.3583,25.3583,23.1742,0.0031,6.1618,9.4544,17.2016,9.4544,332.7968,9.9321,5.2967,2.8379,129.4711,100.8444,84.0237,2.8564,3.7029,14.0461,3.7932,1.2964,4.9174,4.8000
 1813.0000,2557.2905,0.0085,3.0580,3.0220,3.0198,3.0321,3.0066,3.0580,3.0220,0.3232,2.5511,-0.1557,0.3179,3.1507,30.4243,25.5650,25.5650,23.3670,0.0068,5.9931,9.2916,17.0527,9.2916,330.9043,9.9585,5.3966,2.7840,130.2705,100.7546,84.1758,2.8676,3.6302,14.0431,3.8684,1.2659,4.8972,4.0000
 1813.5000,2552.9841,0.0075,3.0349,3.0034,3.0009,3.0132,2.9872,3.0349,3.0034,0.3238,2.5600,-0.3319,-0.1118,3.1318,30.9914,26.1333,26.1333,23.8966,0.0103,5.4575,8.7747,16.5801,8.7747,332.9554,9.9738,4.9874,2.9216,125.6847,99.5227,83.4073,2.8332,3.5179,13.9538,3.9665,1.2417,4.9251,5.6000
 1814.0000,2573.6106,0.0080,2.9806,2.9478,2.9454,2.9577,2.9343,2.9806,2.9478,0.3253,2.5660,-0.2218,-0.5326,3.1710,30.4775,25.6183,25.6183,23.4166,0.0136,5.0926,8.4227,16.2582,8.4227,339.2387,9.9888,5.5289,3.0326,126.2113,100.5883,83.9798,2.8318,3.6141,14.1485,3.9148,1.2763,4.9964,8.0000
 1814.5000,2532.7266,0.0099,2.9649,2.9245,2.9226,2.9350,2.9157,2.9649,2.9245,0.3246,2.5675,0.1712,-0.2335,3.2508,30.1967,25.3375,25.3375,23.1547,0.0153,5.0014,8.3347,16.1777,8.3347,341.9427,10.0008,5.5036,2.8734,130.7546,101.6210,84.4684,2.8182,3.7230,14.3736,3.8608,1.3211,5.1003,6.4000
 1815.0000,2541.9512,0.0123,2.9609,2.9110,2.9099,2.9225,2.9081,2.9609,2.9110,0.3238,2.5678,0.1639,-0.2573,3.3304,30.7508,25.8920,25.8920,23.6718,0.0164,4.9809,8.3149,16.1596,8.3149,343.5227,10.0050,5.3267,2.6887,130.6845,101.9349,84.3895,2.7807,3.8169,14.5252,3.8055,1.3726,5.2235,9.6000
 1815.5000,2495.0781,0.0138,2.9817,2.9250,2.9248,2.9377,2.9276,2.9817,2.9250,0.3236,2.5662,-0.2507,-0.1451,3.3385,31.2432,26.3862,26.3862,24.1320,0.0176,5.0813,8.4118,16.2482,8.4118,341.8811,10.0135,5.1503,2.7595,128.9275,102.8840,85.5011,2.8005,3.8251,14.7967,3.8683,1.3659,5.2836,0.8000
 1816.0000,2523.7087,0.0138,3.0188,2.9614,2.9624,2.9757,2.9690,3.0188,2.9614,0.3235,2.5641,-0.4590,0.1981,3.2186,31.1602,26.3028,26.3028,24.0544,0.0167,5.2078,8.5338,16.3598,8.5338,337.6743,10.0089,5.4749,2.8769,130.0296,102.5326,86.0025,2.8142,3.6944,14.8963,4.0321,1.3128,5.2933,3.2000
 1816.5000,2500.6172,0.0096,2.9648,2.9256,2.9277,2.9407,2.9371,2.9648,2.9256,0.3233,2.5668,-0.1040,-0.0336,3.1301,30.9243,26.0660,26.0660,23.8339,0.0153,5.0453,8.3770,16.2164,8.3771,341.8108,9.9235,5.7175,2.8034,134.6860,102.8780,87.2903,2.8588,3.5676,15.1074,4.2346,1.2479,5.2845,4.0000
 1817.0000,2445.0154,0.0039,2.8460,2.8309,2.8339,2.8462,2.8444,2.8460,2.8309,0.3228,2.5686,0.2979,0.1095,3.2167,31.0693,26.2115,26.2115,23.9694,0.0135,4.9314,8.2671,16.1159,8.2671,353.2484,9.8912,5.2149,2.6177,136.5444,103.0436,88.1316,2.8831,3.4663,15.2686,4.4049,1.2023,5.2959,3.2000
 1817.5000,2456.7852,0.0035,2.7616,2.7482,2.7519,2.7635,2.7621,2.7616,2.7482,0.3240,2.5650,0.2571,0.7005,3.3202,31.7167,26.8627,26.8627,24.5753,0.0109,5.1520,8.4800,16.3106,8.4800,363.8805,9.8604,4.9595,2.5334,134.0141,103.3196,88.7088,2.9002,3.4455,15.3772,4.4630,1.1880,5.3021,4.0000
 1818.0000,2554.4922,0.0058,2.7440,2.7222,2.7266,2.7379,2.7353,2.7440,2.7222,0.3243,2.5638,0.2942,0.3412,3.3045,31.9100,27.0575,27.0575,24.7565,0.0078,5.2251,8.5505,16.3750,8.5505,367.3452,9.8088,4.9331,2.6610,132.9715,103.2999,89.1282,2.9129,3.4057,15.4545,4.5379,1.1691,5.3055,4.0000
 1818.5000,2607.6421,0.0123,2.8100,2.7627,2.7676,2.7790,2.7739,2.8100,2.7627,0.3234,2.5664,0.3195,-0.1188,3.2483,30.7213,25.8625,25.8625,23.6443,0.0040,5.0645,8.3955,16.2334,8.3956,361.9712,9.7956,5.1347,2.7058,133.5219,103.3852,89.4911,2.9412,3.3789,15.4395,4.5694,1.1488,5.2493,2.4000
 1819.0000,2526.9446,0.0162,2.8876,2.8233,2.8286,2.8401,2.8320,2.8876,2.8233,0.3238,2.5658,-0.1868,0.0292,3.1944,31.1903,26.3330,26.3330,24.0825,0.0012,5.1007,8.4305,16.2654,8.4305,354.1960,9.7825,5.1560,2.6826,135.0662,103.1952,89.9382,2.9658,3.2982,15.4698,4.6904,1.1121,5.2161,3.2000
 1819.5000,2592.1519,0.0173,2.9520,2.8818,2.8871,2.8989,2.8879,2.9520,2.8818,0.3235,2.5591,-0.4682,0.1063,3.1642,31.3934,26.5372,26.5372,24.2726,-0.0001,5.5081,8.8236,16.6248,8.8236,347.0103,9.7905,5.3889,2.9154,134.6130,103.3209,90.5361,2.9969,3.2238,15.5188,4.8139,1.0757,5.1784,1.6000
 1820.0000,2578.0554,0.0174,2.9337,2.8636,2.8685,2.8799,2.8681,2.9337,2.8636,0.3238,2.5529,-0.0363,0.1349,3.1899,30.5906,25.7315,25.7315,23.5222,-0.0007,5.8838,9.1861,16.9563,9.1861,349.2073,9.7772,5.5539,2.9256,134.3573,102.5916,90.1464,2.9847,3.1600,15.4487,4.8888,1.0588,5.1760,6.0000
 1820.5000,2544.5188,0.0173,2.8579,2.7902,2.7942,2.8050,2.7940,2.8579,2.7902,0.3248,2.5542,0.4202,-0.0499,3.2338,30.8394,25.9808,25.9808,23.7545,-0.0002,5.8051,9.1102,16.8869,9.1102,358.4009,9.7872,5.1820,2.6852,136.1133,101.9748,89.6822,2.9677,3.1435,15.3766,4.8915,1.0592,5.1813,4.0000
 1821.0000,2512.8142,0.0169,2.8106,2.7453,2.7484,2.7586,2.7486,2.8106,2.7453,0.3241,2.5592,0.4365,-0.0009,3.2854,31.0572,26.1993,26.1993,23.9581,0.0011,5.5057,8.8213,16.6227,8.8213,364.2557,9.7839,5.0503,2.6657,135.1125,101.1881,88.9083,2.9627,3.1250,15.1463,4.8468,1.0548,5.1124,0.0000
 1821.5000,2534.1660,0.0168,2.8499,2.7841,2.7862,2.7964,2.7860,2.8499,2.7841,0.3238,2.5603,0.1408,0.0993,3.3367,31.0310,26.1731,26.1731,23.9337,0.0022,5.4338,8.7519,16.5592,8.7519,359.1797,9.7879,5.2081,2.7473,131.9220,100.1561,88.1137,2.9576,3.0943,14.9095,4.8183,1.0462,5.0411,0.0000
 1822.0000,2640.5679,0.0175,2.9767,2.9051,2.9059,2.9165,2.9038,2.9767,2.9051,0.3222,2.5645,-0.1242,-0.0509,3.3430,30.4966,25.6374,25.6374,23.4345,0.0033,5.1821,8.5091,16.3372,8.5091,344.2279,9.7844,5.3559,2.8087,134.5664,99.5905,87.8463,2.9836,3.0628,14.6982,4.7990,1.0265,4.9264,1.0000
 1822.5000,2583.9170,0.0179,3.1147,3.0380,3.0373,3.0483,3.0317,3.1147,3.0380,0.3237,2.5730,-0.0690,0.0903,3.3344,30.2036,25.3443,25.3443,23.1611,0.0037,4.6672,8.0122,15.8828,8.0122,329.1686,9.7910,5.4233,2.8631,136.2072,99.4163,87.6432,3.0046,3.0966,14.5318,4.6928,1.0306,4.8365,0.8000
 1823.0000,2606.9626,0.0173,3.1653,3.0899,3.0878,3.0987,3.0787,3.1653,3.0899,0.3238,2.5752,-0.0239,0.0625,3.3163,29.2325,24.3765,24.3765,22.2571,0.0017,4.5360,7.8856,15.7671,7.8856,323.6310,9.7866,5.8053,3.0693,131.0476,100.0990,88.0374,3.0393,3.1783,14.4966,4.5611,1.0457,4.7697,2.4000
 1823.5000,2588.6396,0.0163,3.0907,3.0216,3.0183,3.0285,3.0072,3.0907,3.0216,0.3234,2.5731,-0.3730,-0.3601,3.2535,29.1749,24.3193,24.3193,22.2036,-0.0010,4.6630,8.0081,15.8791,8.0081,330.9495,9.8113,5.3378,2.8103,128.5575,101.1830,88.3494,3.0874,3.3114,14.3710,4.3398,1.0726,4.6547,5.6000
 1824.0000,2635.6499,0.0145,3.0278,2.9676,2.9630,2.9727,2.9494,3.0278,2.9676,0.3238,2.5697,-0.4193,-0.1215,3.2407,30.2961,25.4369,25.4369,23.2474,-0.0028,4.8642,8.2023,16.0566,8.2023,336.9747,9.8054,5.5540,3.0142,131.2903,102.6219,89.2059,3.1731,3.3952,14.2455,4.1958,1.0700,4.4894,6.4000
 1824.5000,2574.2664,0.0129,3.0186,2.9652,2.9600,2.9696,2.9449,3.0186,2.9652,0.3230,2.5684,0.0836,0.2330,3.2214,30.8331,25.9745,25.9745,23.7486,-0.0021,4.9445,8.2797,16.1275,8.2797,337.2425,9.8039,5.7053,3.0842,133.5743,102.0825,88.7421,3.1986,3.3631,13.9723,4.1546,1.0514,4.3683,4.0000
 1825.0000,2452.7656,0.0111,2.9811,2.9357,2.9302,2.9395,2.9142,2.9811,2.9357,0.3238,2.5600,0.2184,0.1481,3.1610,30.6168,25.7577,25.7577,23.5466,-0.0029,5.4535,8.7709,16.5766,8.7709,340.6314,9.7710,5.4220,3.0184,134.0043,101.9124,88.8277,3.2394,3.3017,13.8067,4.1817,1.0192,4.2621,8.0000
 1825.5000,2423.6062,0.0097,2.9613,2.9219,2.9162,2.9252,2.8996,2.9613,2.9219,0.3226,2.5524,-0.0744,-0.2524,3.1287,29.9898,25.1308,25.1308,22.9619,-0.0022,5.9154,9.2166,16.9842,9.2166,342.2386,9.7676,5.5314,3.0066,132.6791,102.6044,89.1687,3.2928,3.3456,13.6652,4.0845,1.0160,4.1500,6.4000
 1826.0000,2459.2493,0.0088,2.9412,2.9058,2.9000,2.9086,2.8831,2.9412,2.9058,0.3232,2.5587,-0.1742,-0.3381,3.1332,30.2872,25.4279,25.4279,23.2391,0.0015,5.5359,8.8504,16.6493,8.8505,344.1402,9.7360,5.4356,2.9739,134.5099,103.4705,89.8330,3.3567,3.3753,13.5805,4.0235,1.0055,4.0458,4.0000
 1826.5000,2491.7266,0.0083,2.9570,2.9234,2.9176,2.9260,2.9000,2.9570,2.9234,0.3239,2.5677,0.2840,0.1085,3.1652,30.0379,25.1789,25.1789,23.0067,0.0063,4.9850,8.3189,16.1632,8.3189,342.0620,9.7010,5.3916,2.9345,134.5997,104.5778,90.4671,3.4014,3.4559,13.5765,3.9285,1.0160,3.9914,4.0000
 1827.0000,2485.5308,0.0080,2.9386,2.9063,2.9007,2.9087,2.8826,2.9386,2.9063,0.3243,2.5671,0.7433,0.1863,3.2406,29.7699,24.9115,24.9115,22.7571,0.0108,5.0246,8.3571,16.1982,8.3571,344.0819,9.5998,5.8400,3.0025,134.2856,105.5572,91.2791,3.4432,3.5056,13.6452,3.8924,1.0181,3.9630,6.0000
 1827.5000,2522.6145,0.0074,2.9028,2.8731,2.8679,2.8754,2.8493,2.9028,2.8731,0.3233,2.5675,0.5639,0.1302,3.3134,29.0101,24.1556,24.1556,22.0506,0.0155,5.0027,8.3359,16.1788,8.3359,348.0516,9.5940,5.4499,2.7740,136.3088,104.7693,90.6070,3.4175,3.4914,13.5460,3.8798,1.0216,3.9637,5.6000
 1828.0000,2548.8835,0.0066,2.8773,2.8513,2.8467,2.8538,2.8272,2.8773,2.8513,0.3244,2.5719,0.0210,0.0975,3.3106,29.2812,24.4249,24.4249,22.3024,0.0196,4.7317,8.0744,15.9397,8.0744,350.7128,9.4217,5.1850,2.6517,134.1953,103.7784,89.2255,3.3708,3.5312,13.3141,3.7705,1.0476,3.9498,4.0000
 1828.5000,2533.9468,0.0058,2.8258,2.8030,2.7991,2.8058,2.7794,2.8258,2.8030,0.3227,2.5717,-0.2591,0.2445,3.2537,30.4704,25.6112,25.6112,23.4100,0.0191,4.7475,8.0897,15.9537,8.0897,356.7559,9.4033,5.1056,2.7000,132.6527,102.4065,87.3700,3.3005,3.5620,13.0382,3.6604,1.0792,3.9504,3.2000
 1829.0000,2556.2546,0.0055,2.7626,2.7416,2.7385,2.7449,2.7193,2.7626,2.7416,0.3239,2.5685,-0.0620,0.6566,3.2442,30.8623,26.0038,26.0038,23.7759,0.0161,4.9423,8.2777,16.1256,8.2777,364.7460,9.4070,4.7887,2.5411,135.5657,102.4783,86.2721,3.2695,3.7091,12.8244,3.4576,1.1344,3.9224,4.0000
 1829.5000,2520.7026,0.0052,2.7278,2.7082,2.7059,2.7121,2.6870,2.7278,2.7082,0.3226,2.5647,0.2221,0.2167,3.3212,31.1384,26.2809,26.2809,24.0341,0.0139,5.1675,8.4949,16.3242,8.4949,369.2440,9.4111,4.6781,2.4818,138.7597,103.2900,86.2689,3.2760,3.8178,12.7925,3.3507,1.1654,3.9049,4.0000
 1830.0000,2528.5911,0.0048,2.7165,2.6984,2.6968,2.7030,2.6781,2.7165,2.6984,0.3238,2.5611,0.1613,-0.2635,3.3898,31.2701,26.4132,26.4132,24.1572,0.0108,5.3851,8.7049,16.5163,8.7049,370.5914,9.4328,4.7450,2.4794,138.6996,104.2136,86.8805,3.3148,3.8748,12.8093,3.3058,1.1689,3.8643,3.2000
 1830.5000,2530.7449,0.0047,2.7090,2.6916,2.6908,2.6971,2.6725,2.7090,2.6916,0.3228,2.5610,-0.0882,0.1017,3.3943,31.6726,26.8182,26.8182,24.5340,0.0081,5.3967,8.7161,16.5265,8.7161,371.5245,9.4841,4.8264,2.5818,136.3815,104.7797,87.8379,3.3583,3.8230,12.9176,3.3789,1.1384,3.8465,7.0000
 1831.0000,2554.5620,0.0048,2.6875,2.6697,2.6696,2.6761,2.6523,2.6875,2.6697,0.3230,2.5589,-0.2773,0.1153,3.3889,31.6599,26.8055,26.8055,24.5222,0.0065,5.5199,8.8350,16.6352,8.8350,374.5674,9.4772,4.7811,2.5107,138.9189,104.4822,88.4267,3.3734,3.6844,13.0390,3.5390,1.0922,3.8652,5.6000
 1831.5000,2540.0042,0.0051,2.6661,2.6475,2.6481,2.6547,2.6318,2.6661,2.6475,0.3236,2.5597,-0.3559,-0.3095,3.3795,31.6510,26.7965,26.7965,24.5138,0.0051,5.4720,8.7887,16.5929,8.7887,377.7217,9.4887,4.7233,2.5519,140.5700,105.3126,90.0061,3.4047,3.5618,13.4093,3.7648,1.0461,3.9384,3.2000
 1832.0000,2536.7112,0.0054,2.6505,2.6309,2.6322,2.6391,2.6169,2.6505,2.6309,0.3231,2.5661,-0.1679,-0.3681,3.3555,31.3548,26.4984,26.4984,24.2364,0.0040,5.0865,8.4168,16.2528,8.4168,380.0984,9.5194,4.7179,2.5350,138.0548,104.3027,89.8055,3.3469,3.4201,13.6179,3.9817,1.0219,4.0688,4.0000
 1832.5000,2560.3889,0.0057,2.6344,2.6139,2.6157,2.6230,2.6014,2.6344,2.6139,0.3233,2.5641,0.0050,-0.1764,3.3409,31.1583,26.3009,26.3009,24.0526,0.0027,5.2033,8.5295,16.3558,8.5295,382.5738,9.5606,4.6968,2.5168,136.2228,104.9690,91.1523,3.3550,3.3342,14.0216,4.2054,0.9938,4.1793,7.2000
 1833.0000,2560.8726,0.0061,2.6213,2.5993,2.6016,2.6093,2.5884,2.6213,2.5993,0.3226,2.5599,-0.3106,-0.1434,3.3132,31.2772,26.4204,26.4204,24.1639,0.0004,5.4620,8.7791,16.5841,8.7791,384.7216,9.5759,4.7493,2.5196,135.2240,104.1503,90.9895,3.3182,3.2362,14.1432,4.3703,0.9753,4.2623,4.8000
 1833.5000,2561.9094,0.0068,2.5941,2.5697,2.5724,2.5803,2.5608,2.5941,2.5697,0.3236,2.5626,-0.6586,-0.1146,3.2450,32.2251,27.3757,27.3757,25.0521,-0.0006,5.2943,8.6173,16.4362,8.6173,389.1455,9.5710,4.7212,2.5011,137.3920,102.5104,90.2097,3.2626,3.1165,14.1508,4.5406,0.9552,4.3373,2.4000
 1834.0000,2504.0845,0.0077,2.5653,2.5381,2.5409,2.5491,2.5314,2.5653,2.5381,0.3233,2.5662,-0.3444,0.0998,3.2190,32.7783,27.9354,27.9354,25.5717,0.0005,5.0769,8.4075,16.2443,8.4075,393.9917,9.5918,4.6925,2.4499,137.7480,102.0582,90.2421,3.2480,3.0515,14.2305,4.6634,0.9395,4.3813,4.8000
 1834.5000,2520.3113,0.0085,2.5541,2.5242,2.5270,2.5354,2.5197,2.5541,2.5242,0.3229,2.5668,0.2081,0.3243,3.3016,32.3373,27.4891,27.4891,25.1574,0.0020,5.0433,8.3751,16.2147,8.3751,396.1578,9.6190,4.3885,2.2484,137.9451,102.2861,90.9793,3.2616,2.9793,14.4083,4.8362,0.9134,4.4176,4.0000
 1835.0000,2590.2051,0.0086,2.5415,2.5115,2.5140,2.5227,2.5088,2.5415,2.5115,0.3219,2.5692,0.3811,0.0730,3.3942,32.7751,27.9321,27.9321,25.5687,0.0050,4.8948,8.2318,16.0836,8.2318,398.1711,9.6592,4.4148,2.1445,137.4366,103.6977,92.5257,3.3085,2.9789,14.6938,4.9326,0.9004,4.4413,2.0000
 1835.5000,2608.1831,0.0081,2.5370,2.5089,2.5111,2.5201,2.5077,2.5370,2.5089,0.3221,2.5738,0.4245,-0.2499,3.4161,32.8742,28.0326,28.0326,25.6618,0.0095,4.6209,7.9675,15.8420,7.9675,398.5869,9.6435,4.5906,2.2297,134.2220,104.8487,93.6852,3.3455,2.9937,14.8990,4.9767,0.8949,4.4535,3.2000
 1836.0000,2594.1675,0.0080,2.5457,2.5178,2.5197,2.5294,2.5181,2.5457,2.5178,0.3234,2.5709,0.3657,0.0976,3.4146,32.3115,27.4629,27.4629,25.1332,0.0118,4.7963,8.1368,15.9968,8.1368,397.1698,9.6149,4.7929,2.4729,133.3637,106.0527,94.2892,3.3539,3.0933,15.0575,4.8677,0.9223,4.4896,2.4000
 1836.5000,2599.1194,0.0092,2.5433,2.5112,2.5130,2.5237,2.5133,2.5433,2.5112,0.3226,2.5605,0.1304,0.3205,3.4339,34.1861,29.3672,29.3672,26.8980,0.0113,5.4251,8.7435,16.5516,8.7435,398.2150,9.6022,4.7920,2.5930,132.3636,106.6551,94.0716,3.3300,3.2257,15.0993,4.6809,0.9687,4.5343,5.0000
 1837.0000,2663.8318,0.0106,2.5021,2.4656,2.4674,2.4795,2.4691,2.5021,2.4656,0.3234,2.5533,-0.0685,-0.0705,3.4419,33.3474,28.5129,28.5129,26.1071,0.0111,5.8609,9.1640,16.9361,9.1640,405.5853,9.5642,4.7087,2.4871,133.1568,106.9758,93.9282,3.3098,3.2786,15.1482,4.6203,0.9906,4.5768,3.2000
 1837.5000,2607.5723,0.0107,2.4487,2.4127,2.4150,2.4288,2.4169,2.4487,2.4127,0.3234,2.5539,-0.3246,-0.1455,3.4183,33.0529,28.2138,28.2138,25.8299,0.0126,5.8269,9.1312,16.9061,9.1312,414.4659,9.5537,4.4970,2.4301,136.4257,105.7072,92.5984,3.2545,3.2575,14.9738,4.5967,1.0009,4.6010,9.0000
 1838.0000,2591.4377,0.0099,2.4404,2.4073,2.4104,2.4268,2.4122,2.4404,2.4073,0.3230,2.5476,-0.5513,-0.0232,3.4215,34.4472,29.6340,29.6340,27.1447,0.0241,6.2090,9.4999,17.2432,9.4999,415.4046,9.5263,4.5132,2.3819,138.5973,103.9210,91.2108,3.2004,3.1355,14.7745,4.7120,0.9797,4.6164,3.2000
 1838.5000,2587.8220,0.0104,2.4584,2.4234,2.4278,2.4474,2.4314,2.4584,2.4234,0.3226,2.5434,-0.6628,-0.3679,3.4618,35.6524,30.8700,30.8700,28.2858,0.0723,6.4610,9.7430,17.4655,9.7430,412.6448,9.5332,4.4569,2.3139,139.2709,102.9481,90.5487,3.1797,3.0442,14.6555,4.8142,0.9574,4.6091,12.0000
 1839.0000,2613.6995,0.0117,2.4144,2.3756,2.3810,2.4026,2.3889,2.4144,2.3756,0.3228,2.5539,-0.9110,-0.7797,3.5037,37.4362,32.7135,32.7135,29.9826,0.1492,5.8248,9.1292,16.9042,9.1292,420.9435,9.5741,4.2624,2.1193,136.9298,103.3011,91.1981,3.2071,2.9810,14.7385,4.9441,0.9295,4.5955,0.8000
 1839.5000,2573.7603,0.0117,2.3888,2.3503,2.3564,2.3794,2.3702,2.3888,2.3503,0.3229,2.5488,-1.0491,-0.6460,3.5122,37.9794,33.2783,33.2783,30.5012,0.1958,6.1332,9.4267,17.1763,9.4267,425.4791,9.7177,3.7617,1.9217,131.5240,102.8594,91.3035,3.2240,2.8775,14.6932,5.1063,0.8925,4.5575,1.6000
 1840.0000,2597.5762,0.0114,2.3556,2.3187,2.3247,2.3474,2.3451,2.3556,2.3187,0.3234,2.5224,-0.5275,0.2688,3.4181,39.2104,34.5640,34.5640,31.6796,0.1873,7.7354,10.9728,18.5901,10.9728,431.2785,9.9892,2.8198,1.5412,129.9142,102.1541,91.1687,3.2296,2.7783,14.6222,5.2630,0.8602,4.5275,0.0000
 1840.5000,2618.7087,0.0155,2.3381,2.2885,2.2933,2.3135,2.3203,2.3385,2.2885,0.3228,2.5046,0.2938,0.5739,3.3415,39.0237,34.3685,34.3685,31.5005,0.1666,8.8100,12.0097,19.5383,12.0097,436.9736,10.6209,1.0234,1.1152,132.6072,101.6750,90.9263,3.2191,2.7196,14.5922,5.3656,0.8448,4.5329,2.4000
 1841.0000,2568.9116,0.0233,2.2341,2.1627,2.1651,2.1793,2.1932,2.2355,2.1627,0.3221,2.4518,0.7489,0.1281,3.3563,39.4433,34.8081,34.8081,31.9030,0.1650,12.0120,15.0993,22.3635,15.0993,462.3759,11.4394,1.0047,0.9514,130.6743,104.0167,92.6936,3.2740,2.8135,14.9125,5.3003,0.8594,4.5548,1.6000
 1841.5000,2562.8306,0.0214,2.0911,2.0296,2.0288,2.0359,2.0484,2.0994,2.0296,0.3230,2.3704,0.8190,0.2269,3.2494,38.1409,33.4466,33.4466,30.6556,0.1608,16.9427,19.8570,26.7141,19.8570,492.7183,11.8312,0.7532,0.8125,126.4967,105.3020,93.0855,3.2799,2.9436,15.0133,5.1003,0.8975,4.5774,8.0000
 1842.0000,2540.8105,-0.0013,2.1032,2.1069,2.1021,2.1017,2.1027,2.1134,2.1069,0.3238,2.4031,0.5598,0.0032,3.0648,35.5067,30.7202,30.7202,28.1477,0.1474,14.9626,17.9463,24.9670,17.9464,474.6240,10.9488,0.7446,0.8693,123.5287,102.9788,90.1148,3.1900,2.9992,14.4639,4.8225,0.9402,4.5341,6.0000
 1842.5000,2570.2354,-0.0254,2.2679,2.3477,2.3372,2.3263,2.3019,2.2709,2.3477,0.3231,2.5011,0.0317,-0.5775,2.9899,35.1970,30.4021,30.4021,27.8542,0.1318,9.0213,12.2135,19.7247,12.2135,425.9403,9.8474,2.8978,1.6675,124.4037,100.9184,87.5383,3.1195,3.0264,13.9523,4.6101,0.9702,4.4726,2.4000
 1843.0000,2568.5081,-0.0602,2.4310,2.6352,2.6182,2.5945,2.5352,2.4237,2.6352,0.3243,2.5077,-0.3654,-0.2930,2.9377,37.5597,32.8418,32.8418,30.1005,0.1123,8.6218,11.8280,19.3721,11.8280,379.4749,9.8599,3.3793,1.7116,127.5757,99.9212,85.8659,3.0771,3.0847,13.6038,4.4102,1.0024,4.4209,0.8000
 1843.5000,2507.9534,-0.0913,2.2568,2.5459,2.5258,2.4934,2.4100,2.2622,2.5459,0.3240,2.4255,-0.3699,0.2286,2.8517,39.1889,34.5414,34.5414,31.6589,0.0961,13.6081,16.6394,23.7718,16.6394,392.7874,10.1789,0.9895,0.8670,131.1243,99.6103,84.8230,3.0462,3.1534,13.4081,4.2520,1.0352,4.4016,3.2000
 1844.0000,2576.2817,-0.1130,1.8580,2.1533,2.1346,2.1013,2.0134,1.8761,2.1533,0.3237,2.3323,-0.2584,-0.0073,2.8298,41.9884,37.4946,37.4946,34.3549,0.0819,19.2518,22.0850,28.7516,22.0850,464.4126,11.1320,0.6411,0.8806,133.9255,101.3046,85.5447,3.0685,3.2749,13.5394,4.1343,1.0673,4.4124,2.4000
 1844.5000,2526.9097,-0.1279,1.6711,1.9723,1.9547,1.9208,1.8274,1.6892,1.9723,0.3226,2.2908,-0.2134,-0.3500,2.8743,42.2059,37.7258,37.7258,34.5653,0.0680,21.7690,24.5139,30.9726,24.5139,507.0302,11.6302,0.7517,0.8432,130.7636,102.1823,85.2953,3.0481,3.4075,13.5540,3.9777,1.1179,4.4466,3.0000
 1845.0000,2548.9871,-0.1422,1.6266,1.9531,1.9359,1.9008,1.8002,1.6446,1.9531,0.3227,2.2945,-0.1670,-0.2876,2.9014,41.6397,37.1246,37.1246,34.0179,0.0576,21.5462,24.2990,30.7761,24.2990,512.0026,11.5280,0.7211,0.7363,127.1380,101.5280,83.4184,2.9647,3.5464,13.3336,3.7597,1.1962,4.4975,0.8000
 1845.5000,2511.1440,-0.1481,1.4904,1.8022,1.7866,1.7546,1.6611,1.5085,1.8022,0.3225,2.3025,-0.1468,-0.4139,2.9169,43.9704,39.6101,39.6101,36.2773,0.0528,21.0590,23.8288,30.3461,23.8288,554.8696,11.3798,0.8566,0.7112,124.1662,100.9643,81.6959,2.8867,3.6647,13.1376,3.5849,1.2695,4.5511,2.0000
 1846.0000,2523.5007,-0.1329,1.2767,1.5160,1.5028,1.4776,1.4061,1.2929,1.5160,0.3230,2.2801,-0.0536,-0.3795,2.8990,42.2160,37.7365,37.7365,34.5751,0.0518,22.4181,25.1403,31.5454,25.1403,659.6172,11.9707,0.9282,0.7342,123.0331,99.8064,80.0661,2.8100,3.6924,12.9665,3.5116,1.3141,4.6145,1.6000
 1846.5000,2538.0923,-0.0954,1.2079,1.3696,1.3569,1.3363,1.2850,1.2233,1.3696,0.3224,2.2307,0.1978,0.1061,2.8058,38.5178,33.8396,33.8396,31.0160,0.0470,25.4109,28.0281,34.1861,28.0281,730.1187,13.2554,0.6299,0.6636,121.5672,96.9103,77.7982,2.7211,3.5420,12.6432,3.5695,1.3017,4.6464,1.0000
 1847.0000,2544.5647,-0.0507,1.5044,1.6106,1.5936,1.5723,1.5317,1.5227,1.6106,0.3231,2.2372,0.5415,0.6059,2.9427,31.7855,26.9320,26.9320,24.6398,0.0509,25.0185,27.6495,33.8399,27.6495,620.8704,13.8466,0.3603,0.5526,113.9979,86.2679,69.7248,2.4346,3.0598,11.3505,3.7095,1.2568,4.6621,1.6000
 1847.5000,2529.1331,-0.0121,2.3197,2.3585,2.3088,2.2738,2.2130,2.3433,2.3585,0.3221,2.3766,0.7749,0.8441,3.6554,25.0915,20.3077,20.3077,18.4345,0.0677,16.5722,19.4995,26.3872,19.4995,424.0014,12.3037,0.5660,0.7113,93.0002,65.8592,53.1741,1.8550,2.3392,8.6645,3.7040,1.2610,4.6709,6.0000
 1848.0000,2531.2981,-0.0024,5.3374,5.3548,5.2172,5.1262,4.9440,5.3311,5.3548,0.3222,2.5429,0.7857,0.1330,4.5804,18.3349,13.8750,13.8750,12.3111,0.0654,6.4909,9.7719,17.4920,9.7719,186.7466,9.2378,10.6546,14.5195,63.4023,45.1078,36.1220,1.2617,1.6368,5.8783,3.5913,1.2973,4.6589,3.2000
 1848.5000,2559.4329,0.0310,14.7692,14.1435,13.6783,13.4350,12.8255,14.1007,14.1435,0.3227,2.5600,0.6359,-0.4864,5.1647,18.2329,13.7800,13.7800,12.2198,0.0416,5.4528,8.7702,16.5760,8.7702,70.7036,8.9857,11.9959,15.9243,45.4544,33.4614,26.5953,0.9244,1.2479,4.3498,3.4856,1.3500,4.7057,2.4000
 1849.0000,2542.3999,0.0584,31.2115,28.7339,27.1136,26.8633,25.7933,27.8453,28.7339,0.3225,2.4740,0.3175,0.2681,5.4182,21.1905,16.5621,16.5621,14.8816,0.0231,10.6643,13.7989,21.1744,13.7989,34.8021,8.9752,7.9942,11.6399,38.1604,27.3842,21.6198,0.7449,1.0472,3.5669,3.4062,1.4058,4.7883,3.0000
 1849.5000,2553.2595,0.0217,21.1474,20.5184,19.8719,20.1986,20.2860,20.3462,20.5184,0.3217,2.4353,0.0224,1.0003,5.3143,19.8271,15.2734,15.2734,13.6512,0.0142,13.0120,16.0642,23.2459,16.0642,48.7367,8.9411,6.9373,10.2572,31.9861,26.4735,20.6896,0.7053,1.0554,3.4496,3.2685,1.4964,4.8912,4.0000
 1850.0000,2575.9016,0.1193,10.1119,8.5028,8.3722,8.6377,8.9809,9.9901,8.5028,0.3213,2.4726,-0.1421,0.6418,4.8287,17.8364,13.4107,13.4107,11.8650,0.0095,10.7492,13.8808,21.2493,13.8808,117.6088,8.9185,18.2063,30.6369,30.8885,30.3568,23.3089,0.7791,1.2820,3.9596,3.0887,1.6454,5.0823,4.0000
 1850.5000,2549.9666,0.1796,5.4345,4.1593,4.1559,4.2671,4.5113,5.1550,4.1593,0.3243,2.5405,-0.3042,0.0917,4.2596,18.1617,13.7136,13.7136,12.1560,0.0085,6.6380,9.9139,17.6218,9.9139,240.4273,8.8908,25.9124,27.2471,43.3408,39.3565,29.4530,0.9682,1.7924,5.0805,2.8344,1.8513,5.2474,7.2000
 1851.0000,2575.4292,0.2020,3.5371,2.6110,2.6299,2.6922,2.8650,3.2769,2.6110,0.3230,2.5912,-0.4949,-0.2638,3.7444,20.4611,15.8714,15.8714,14.2226,0.0094,3.5636,6.9473,14.9090,6.9473,383.0009,8.8760,4.6371,3.3647,64.8935,47.4236,34.6778,1.1254,2.3003,6.0509,2.6305,2.0440,5.3768,6.0000
 1851.5000,2522.3616,0.2150,2.6881,1.9429,1.9660,2.0096,2.1478,2.4621,1.9429,0.3221,2.5995,-0.5068,-0.5430,3.5181,22.2475,17.5686,17.5686,15.8397,0.0117,3.0588,6.4602,14.4636,6.4602,514.7002,8.9163,4.1124,3.0060,74.4016,48.4636,35.0440,1.1330,2.4229,6.1352,2.5322,2.1385,5.4151,8.0000
 1852.0000,2564.5344,0.2261,2.3055,1.6361,1.6612,1.6974,1.8209,2.0987,1.6361,0.3218,2.5794,-0.1396,-0.4778,3.7940,22.8114,18.1081,18.1081,16.3522,0.0154,4.2810,7.6395,15.5420,7.6395,611.1997,8.9539,5.9924,3.8352,60.1408,41.0500,29.3038,0.9384,2.1255,5.1729,2.4337,2.2651,5.5126,6.0000
 1852.5000,2546.7297,0.2446,2.3269,1.6015,1.6330,1.6714,1.8056,2.1180,1.6015,0.3234,2.5545,0.2195,-0.3745,4.2983,21.2574,16.6257,16.6257,14.9422,0.0211,5.7872,9.0929,16.8710,9.0929,624.4064,8.9445,7.2864,5.2854,37.1571,29.2310,20.5812,0.6493,1.5624,3.6797,2.3551,2.4065,5.6676,10.4000
 1853.0000,2531.6433,0.2618,2.5069,1.6765,1.7175,1.7622,1.9156,2.2915,1.6765,0.3220,2.5291,0.1678,-0.0848,4.7654,20.1928,15.6181,15.6181,13.9807,0.0238,7.3300,10.5815,18.2323,10.5815,596.4772,8.9693,6.5169,5.4216,22.4767,19.6849,13.7803,0.4312,1.0672,2.4803,2.3242,2.4747,5.7518,1.0000
 1853.5000,2522.0276,0.2659,2.5534,1.6958,1.7422,1.7889,1.9468,2.3422,1.6958,0.3227,2.5148,-0.0841,0.3503,5.1634,19.6482,15.1051,15.1051,13.4901,0.0181,8.1924,11.4137,18.9933,11.4137,589.6798,8.9797,6.6012,5.7102,16.6920,14.8609,10.4384,0.3283,0.8001,1.8708,2.3381,2.4370,5.6979,4.8000
 1854.0000,2540.2461,0.2622,2.4806,1.6576,1.7038,1.7476,1.8981,2.2722,1.6576,0.3231,2.5259,-0.0892,0.2424,5.4181,18.4315,13.9652,13.9652,12.3976,0.0108,7.5183,10.7633,18.3985,10.7633,603.2839,8.9750,7.1196,6.2506,15.0574,13.1643,9.3976,0.2992,0.6919,1.6674,2.4099,2.3128,5.5735,6.4000
 1854.5000,2576.6968,0.2568,2.4034,1.6207,1.6643,1.7043,1.8449,2.1820,1.6207,0.3229,2.5330,0.1081,-0.1150,5.4041,17.7826,13.3607,13.3607,11.8169,0.0064,7.0895,10.3495,18.0201,10.3495,617.0300,8.9896,7.1765,6.4277,15.6915,12.7482,9.3126,0.2992,0.6441,1.6393,2.5450,2.1530,5.4794,6.4000
 1855.0000,2530.7336,0.2496,2.4175,1.6501,1.6927,1.7313,1.8677,2.1756,1.6501,0.3227,2.5243,0.1121,-0.2429,5.1791,16.8831,12.5268,12.5268,11.0141,0.0026,7.6189,10.8603,18.4873,10.8603,606.0244,8.9809,7.0821,6.1947,17.0370,12.6517,9.4405,0.3039,0.6169,1.6588,2.6890,2.0296,5.4577,1.6000
 1855.5000,2594.1438,0.2311,2.5820,1.8175,1.8638,1.9064,2.0518,2.3581,1.8175,0.3226,2.5345,0.1188,-0.3045,5.0426,15.7209,11.4563,11.4563,9.9806,0.0021,7.0010,10.2641,17.9420,10.2641,550.1968,8.9504,7.8766,6.7493,17.3247,12.8167,9.7943,0.3193,0.5955,1.7019,2.8580,1.8648,5.3295,5.0000
 1856.0000,2579.4026,0.2031,2.8266,2.0828,2.1340,2.1835,2.3396,2.6425,2.0828,0.3228,2.5615,0.3594,0.0530,5.1363,15.2602,11.0341,11.0341,9.5722,0.0056,5.3646,8.6851,16.4982,8.6851,480.1190,8.9051,9.4972,8.3179,16.6915,13.3429,10.3104,0.3390,0.6077,1.7784,2.9264,1.7929,5.2467,7.2000
 1856.5000,2583.6528,0.1689,2.9586,2.3029,2.3517,2.4032,2.5451,2.7996,2.3029,0.3224,2.5793,0.3975,0.3666,5.1977,14.6328,10.4611,10.4611,9.0170,0.0065,4.2827,7.6412,15.5436,7.6412,434.2388,8.8866,9.9141,8.4417,17.8733,14.2936,11.1051,0.3651,0.6503,1.9156,2.9457,1.7814,5.2473,3.0000
 1857.0000,2547.1797,0.1346,3.1693,2.6029,2.6463,2.7002,2.8214,3.0393,2.6029,0.3216,2.5873,-0.0667,-0.1211,5.0138,13.9910,9.8774,9.8774,8.4504,0.0047,3.7987,7.1741,15.1165,7.1741,384.1890,8.8746,9.0960,7.2477,20.4347,15.3825,11.8412,0.3895,0.7308,2.0411,2.7931,1.8760,5.2397,4.8000
 1857.5000,2513.6655,0.1035,3.5413,3.0497,3.0831,3.1409,3.2416,3.4455,3.0497,0.3226,2.5890,-0.4399,-0.5877,4.8150,14.0445,9.9260,9.9260,8.4976,0.0050,3.6978,7.0768,15.0275,7.0768,327.8975,8.8425,10.2083,7.9713,22.5787,17.3809,13.1291,0.4334,0.8718,2.2561,2.5877,2.0116,5.2055,5.6000
 1858.0000,2570.4087,0.0775,3.9448,3.5318,3.5425,3.5987,3.6751,3.8749,3.5318,0.3221,2.5954,-0.2652,-0.8340,4.7941,13.7233,9.6346,9.6346,8.2144,0.0057,3.3074,6.7001,14.6830,6.7001,283.1450,8.8021,11.7470,8.5004,25.1999,20.7536,15.3807,0.5080,1.1031,2.6416,2.3947,2.1713,5.1997,10.4000
 1858.5000,2503.1509,0.0565,4.2511,3.9249,3.9020,3.9465,4.0013,4.1988,3.9249,0.3237,2.6075,-0.0476,-0.4374,4.7256,13.5644,9.4907,9.4907,8.0745,0.0023,2.5731,5.9916,14.0351,5.9916,254.7867,8.8070,9.3998,6.4867,31.4176,23.9516,17.2811,0.5713,1.3589,2.9657,2.1825,2.3786,5.1912,6.4000
 1859.0000,2548.2739,0.0378,4.5074,4.2745,4.2166,4.2424,4.2843,4.4724,4.2745,0.3228,2.6022,0.0142,0.6371,4.5623,13.7639,9.6714,9.6714,8.2502,-0.0008,2.8948,6.3020,14.3189,6.3020,233.9481,8.7855,7.1983,5.0842,37.5826,25.0358,17.5098,0.5707,1.5098,3.0434,2.0157,2.6454,5.3323,4.8000
 1859.5000,2545.4172,0.0174,4.9599,4.8413,4.7379,4.7406,4.7723,4.9415,4.8413,0.3242,2.5799,0.0149,0.9342,4.5642,13.0223,9.0008,9.0008,7.5977,0.0002,4.2467,7.6065,15.5118,7.6065,206.5547,8.7547,10.9841,8.5895,34.6937,23.6280,16.1147,0.5160,1.4889,2.8449,1.9107,2.8856,5.5136,5.6000
 1860.0000,2522.4988,-0.0023,5.7536,5.7720,5.6004,5.5754,5.6027,5.7490,5.7720,0.3234,2.5749,-0.0192,0.4424,4.6804,11.0703,7.2514,7.2514,5.8887,0.0015,4.5540,7.9030,15.7830,7.9030,173.2498,8.7590,15.7831,14.1627,28.4448,21.8523,14.6022,0.4585,1.4126,2.6209,1.8554,3.0809,5.7162,4.0000
 1860.5000,2554.7803,-0.0288,6.7734,7.0440,6.7831,6.7172,6.7261,6.7778,7.0440,0.3234,2.6029,0.1384,-0.1194,4.6495,9.5961,5.9451,5.9451,4.6063,0.0036,2.8567,6.2652,14.2853,6.2652,141.9638,8.7343,16.2359,12.7521,28.9968,21.5216,14.1717,0.4412,1.4084,2.5616,1.8188,3.1921,5.8059,6.0000
 1861.0000,2540.9028,-0.0534,7.7440,8.3202,7.9626,7.8576,7.8397,7.7530,8.3202,0.3227,2.6296,0.2146,-0.3045,4.5007,9.2814,5.6679,5.6679,4.3335,0.0057,1.2365,4.7019,12.8557,4.7019,120.1892,8.7481,14.0020,9.6204,31.8045,21.9773,14.1293,0.4354,1.4682,2.5752,1.7540,3.3723,5.9149,2.4000
 1861.5000,2539.0146,-0.0675,8.6833,9.5019,9.0421,8.8934,8.8537,8.6951,9.5019,0.3222,2.6366,0.0359,0.3467,4.4338,9.0969,5.5056,5.5056,4.1737,0.0063,0.8151,4.2953,12.4839,4.2953,105.2416,8.7539,14.5645,10.4989,30.6417,21.8407,13.6310,0.4218,1.4912,2.4760,1.6604,3.5353,5.8701,5.6000
 1862.0000,2507.4810,-0.0658,9.0169,9.8461,9.3277,9.1545,9.1159,9.0275,9.8461,0.3230,2.6410,-0.0758,0.5395,4.4694,9.0188,5.4370,5.4370,4.1060,0.0070,0.5481,4.0377,12.2484,4.0377,101.5633,8.7691,17.0186,14.2988,27.3183,20.4231,12.1798,0.3796,1.4549,2.1996,1.5118,3.8330,5.7949,4.0000
 1862.5000,2521.3594,-0.0582,8.4998,9.1896,8.6788,8.5097,8.5083,8.5078,9.1896,0.3236,2.6373,-0.0279,0.1240,4.5467,9.3947,5.7676,5.7676,4.4317,0.0068,0.7705,4.2522,12.4445,4.2522,108.8188,8.7969,17.9178,14.5580,24.4702,19.1449,11.1482,0.3506,1.3900,1.9982,1.4375,3.9645,5.6991,2.4000
 1863.0000,2567.3337,-0.0303,8.0672,8.4064,7.9371,7.7931,7.8342,8.0744,8.4064,0.3233,2.6166,0.0469,0.0786,4.7382,10.0676,6.3614,6.3614,5.0157,0.0027,2.0218,5.4596,13.5486,5.4596,118.9567,8.7970,19.2505,17.4853,23.8418,18.9549,10.7738,0.3418,1.4040,1.9172,1.3655,4.1081,5.6097,2.4000
 1863.5000,2532.3577,-0.0156,7.8095,7.9777,7.5474,7.4223,7.4909,7.8173,7.9777,0.3224,2.6059,-0.0048,0.0160,5.0952,10.5482,6.7872,6.7872,5.4337,-0.0010,2.6747,6.0896,14.1247,6.0896,125.3500,8.8180,19.9974,18.1101,24.5611,20.4054,11.3417,0.3599,1.5449,2.0176,1.3060,4.2921,5.6054,3.2000
 1864.0000,2534.1772,-0.0162,8.9397,9.1398,8.6302,8.4854,8.5710,8.9622,9.1398,0.3213,2.6359,-0.1066,0.3352,5.4314,10.2941,6.5619,6.5619,5.2126,0.0020,0.8564,4.3351,12.5204,4.3351,109.4119,8.8596,15.6887,14.4056,28.2033,23.3974,12.6672,0.4095,1.8077,2.2177,1.2268,4.4142,5.4154,4.0000
 1864.5000,2525.4363,-0.0387,12.5296,13.2036,12.3999,12.1524,12.2108,12.5701,13.2036,0.3218,2.7557,-0.0421,0.3114,5.7034,8.1172,4.6476,4.6476,3.3270,0.0056,-6.4075,-2.6740,6.1110,-2.6739,75.7369,8.8829,18.0589,20.5571,37.0803,24.4185,12.8192,0.4221,1.9343,2.2077,1.1413,4.5820,5.2297,4.0000
 1865.0000,2544.2432,-0.0688,17.5041,19.1882,18.1333,17.8421,17.6334,17.5952,19.1882,0.3240,2.9412,0.1847,-0.1577,5.9383,5.4853,2.3710,2.3710,1.0682,-0.0115,-17.6463,-13.5184,-3.8055,-13.5183,52.1154,8.9171,16.4540,19.1433,37.7646,22.6830,11.7195,0.3934,1.8144,1.9830,1.0929,4.6124,5.0409,4.0000
 1865.5000,2515.5313,-0.0949,17.8653,20.2446,19.2349,18.9944,18.6119,17.9829,20.2446,0.3222,3.0303,0.2286,-0.1049,5.9347,4.3515,1.4033,1.4033,0.1023,-0.0383,-23.0466,-18.7292,-8.5706,-18.7292,49.3958,9.0159,24.5236,39.5988,25.8316,20.1786,10.2893,0.3469,1.6237,1.7336,1.0677,4.6802,4.9971,3.0000
 1866.0000,2534.9487,-0.0968,11.2013,12.7228,12.1464,12.0375,11.7218,11.2490,12.7228,0.3219,3.0140,-0.0448,-0.1214,6.0229,5.7174,2.5701,2.5701,1.2665,-0.0289,-22.0595,-17.7767,-7.6996,-17.7767,78.5991,8.9967,35.6217,37.7684,23.0221,23.1737,11.6259,0.3865,1.8888,1.9848,1.0508,4.8867,5.1349,0.8000
 1866.5000,2545.0608,-0.0926,7.2938,8.2415,7.9104,7.8700,7.6723,7.3118,8.2415,0.3227,2.9704,-0.2852,-0.6385,6.3980,10.9711,7.1631,7.1631,5.8022,-0.0096,-19.4167,-15.2267,-5.3677,-15.2267,121.3370,9.0714,19.6855,12.7703,40.9997,34.9954,17.0908,0.5635,2.9066,2.9399,1.0115,5.1577,5.2169,4.8000
 1867.0000,2465.0076,-0.0648,5.3527,5.8373,5.6336,5.6274,5.5818,5.3609,5.8373,0.3214,2.8253,-0.3787,-1.2663,6.2616,18.5493,14.0752,14.0752,12.5032,-0.0089,-10.6220,-6.7405,2.3924,-6.7405,171.3121,9.0716,13.1430,11.9405,69.2093,50.2493,23.6705,0.7864,4.2756,4.0437,0.9458,5.4369,5.1419,3.2000
 1867.5000,2502.6672,-0.0341,3.8920,4.0764,3.9525,3.9614,3.9204,3.8946,4.0764,0.3216,2.5123,-0.1108,-0.8654,5.0606,23.1001,18.3850,18.3850,16.6149,0.0104,8.3479,11.5637,19.1305,11.5637,245.3151,9.1941,5.8525,4.6291,87.6451,60.7218,27.7728,0.9331,5.2613,4.6953,0.8924,5.6388,5.0322,4.0000
 1868.0000,2562.4280,-0.0077,2.9765,3.0081,2.9387,2.9487,2.9447,2.9761,3.0081,0.3219,2.2534,0.6232,0.2879,3.6461,25.2602,20.4716,20.4716,18.5892,0.0488,24.0340,26.6994,32.9711,26.6994,332.4313,9.1825,1.0516,1.0784,84.0106,60.7773,27.6909,0.9397,5.2347,4.6370,0.8858,5.5707,4.9346,1.6000
 1868.5000,2592.7166,-0.0062,3.3689,3.3979,3.3207,3.3344,3.3292,3.3694,3.3979,0.3231,2.3467,0.9929,0.8544,3.4405,26.0737,21.2642,21.2642,19.3364,0.0657,18.3827,21.2464,27.9847,21.2464,294.3017,9.0201,11.8708,7.9638,69.3613,53.0259,24.5838,0.8484,4.4715,4.0493,0.9056,5.2703,4.7726,2.4000
 1869.0000,2596.4133,-0.0265,5.8115,6.0251,5.8682,5.8941,5.8303,5.8213,6.0251,0.3229,2.5986,0.6767,0.6399,4.1806,17.9203,13.4888,13.4888,11.9400,0.0525,3.1154,6.5148,14.5136,6.5148,165.9715,8.9834,21.3204,16.3747,55.5585,43.9166,21.0244,0.7437,3.5817,3.3772,0.9429,4.8162,4.5412,4.8000
 1869.5000,2546.3384,-0.0635,8.2951,9.0301,8.7858,8.8134,8.6503,8.3113,9.0301,0.3216,2.7060,0.1511,0.3865,4.5481,14.1467,10.0187,10.0187,8.5877,0.0388,-3.3921,0.2357,8.7717,0.2357,110.7406,8.9108,16.8684,13.2379,46.9587,36.3081,17.8979,0.6518,2.8660,2.7860,0.9721,4.3968,4.2740,5.6000
 1870.0000,2499.5239,-0.0519,8.4196,9.0288,8.7696,8.7795,8.7155,8.4332,9.0288,0.3234,2.7074,-0.4221,0.3209,4.4022,12.9680,8.9519,8.9519,7.5500,0.0330,-3.4807,0.1502,8.6935,0.1502,110.7570,9.0084,16.6921,16.4966,41.0729,32.6530,16.4902,0.6188,2.5066,2.4805,0.9896,4.0509,4.0087,0.8000
 1870.5000,2544.3342,-0.0273,7.7359,8.0285,7.7884,7.7813,7.7626,7.7457,8.0285,0.3218,2.6917,-0.7060,-0.0886,4.2185,11.9052,7.9969,7.9969,6.6182,0.0261,-2.5301,1.0674,9.5322,1.0674,124.5557,9.0606,18.2557,16.7806,37.9416,32.3739,16.6261,0.6387,2.4458,2.4305,0.9938,3.8292,3.8053,4.8000
 1871.0000,2521.7969,-0.0642,6.5489,7.1361,6.9198,6.9025,6.7767,6.5546,7.1361,0.3228,2.6733,-0.4204,-0.4906,4.1383,12.1657,8.2303,8.2303,6.8462,0.0172,-1.4094,2.1488,10.5211,2.1488,140.1335,9.0865,16.5063,11.2048,42.7475,35.7375,18.5227,0.7291,2.6787,2.6249,0.9799,3.6742,3.6004,4.8000
 1871.5000,2547.4675,-0.0461,5.9675,6.3504,6.1625,6.1394,6.0338,5.9707,6.3504,0.3220,2.6532,-0.1779,-0.4222,4.2470,12.3717,8.4152,8.4152,7.0267,0.0079,-0.1916,3.3238,11.5956,3.3239,157.4696,9.1639,11.4753,8.1805,51.7207,39.4985,20.6191,0.8253,2.9478,2.8569,0.9692,3.5719,3.4618,0.8000
 1872.0000,2575.7295,-0.0355,5.7007,5.9817,5.8172,5.7903,5.7151,5.7039,5.9817,0.3244,2.6309,-0.2781,-0.0958,4.5436,12.1873,8.2497,8.2497,6.8651,0.0020,1.1595,4.6276,12.7878,4.6276,167.1757,9.2616,10.8095,8.0411,59.0262,41.5805,22.0715,0.8902,3.0605,3.0259,0.9887,3.4379,3.3991,0.8000
 1872.5000,2535.1907,-0.0345,5.9322,6.2169,6.0665,6.0364,5.9734,5.9353,6.2169,0.3223,2.6124,-0.0269,0.0010,4.7507,11.7093,7.8216,7.8216,6.4468,-0.0007,2.2785,5.7073,13.7752,5.7074,160.8529,9.3668,13.5087,10.1600,61.7690,42.7031,23.1763,0.9430,3.0657,3.1381,1.0236,3.2509,3.3277,0.0000
 1873.0000,2518.8254,-0.0369,6.0818,6.3940,6.2741,6.2494,6.1874,6.0856,6.3940,0.3217,2.6124,0.3971,0.1508,4.6900,11.3077,7.4629,7.4629,6.0959,-0.0013,2.2778,5.7067,13.7746,5.7067,156.3976,9.3778,16.9500,11.2915,61.8588,46.6363,25.7011,1.0551,3.2926,3.4358,1.0435,3.1207,3.2564,0.0000
 1873.5000,2504.4983,-0.0335,5.3011,5.5475,5.4853,5.4791,5.4238,5.3027,5.5475,0.3236,2.6267,0.1595,0.2919,4.3988,12.5228,8.5511,8.5511,7.1592,-0.0008,1.4141,4.8732,13.0124,4.8732,180.2609,9.3785,17.7682,9.2815,66.9999,53.7129,29.9913,1.2384,3.7216,3.9751,1.0681,3.0051,3.2098,0.8000
 1874.0000,2610.9700,-0.0238,4.2621,4.4026,4.3952,4.4133,4.3487,4.2617,4.4026,0.3220,2.6378,-0.1254,-0.1041,3.9675,15.1342,10.9188,10.9188,9.4606,0.0014,0.7373,4.2202,12.4153,4.2202,227.1382,9.4675,7.7886,4.9835,80.7723,61.1279,34.2634,1.4185,4.1979,4.5239,1.0776,2.9594,3.1892,3.2000
 1874.5000,2583.5493,-0.0104,3.7033,3.7564,3.7980,3.8418,3.7672,3.7017,3.7564,0.3215,2.6377,0.1125,-0.1192,3.6621,18.4661,13.9975,13.9975,12.4286,0.0043,0.7456,4.2282,12.4226,4.2282,266.2136,9.5385,5.7401,3.9191,91.0369,65.6777,36.6730,1.5122,4.5149,4.8709,1.0789,2.9856,3.2211,1.6000
 1875.0000,2564.5581,0.0010,3.2989,3.2994,3.3803,3.4511,3.3728,3.2941,3.2944,0.3219,2.6245,0.1292,0.0764,3.5716,20.9079,16.2942,16.2942,14.6262,0.0036,1.5479,5.0023,13.1305,5.0023,303.0856,9.6442,5.3131,3.4550,93.2112,67.1998,37.4643,1.5418,4.6157,4.9903,1.0812,2.9937,3.2366,2.4000
 1875.5000,2572.2283,0.0109,2.9255,2.9029,3.0102,3.1037,3.0367,2.9099,2.8815,0.3220,2.6004,-0.0991,-0.4006,3.4830,22.9822,18.2718,18.2718,16.5076,0.0018,3.0051,6.4084,14.4162,6.4084,344.4857,9.6930,4.9056,3.1853,91.7088,65.8565,36.7337,1.5113,4.5267,4.8951,1.0814,2.9952,3.2390,2.0000
 1876.0000,2575.1074,0.0343,2.4615,2.3746,2.4837,2.5831,2.5529,2.4295,2.3461,0.3229,2.5505,-0.1355,-0.9800,3.3864,26.8526,22.0265,22.0265,20.0538,0.0101,6.0282,9.3255,17.0837,9.3255,421.1262,9.7656,3.5625,2.5955,85.3825,63.8777,35.6089,1.4648,4.4031,4.7463,1.0779,3.0059,3.2402,4.0000
 1876.5000,2591.8179,0.0621,1.8776,1.7413,1.8245,1.9061,1.9218,1.8522,1.7192,0.3211,2.3828,-0.1091,-0.5249,3.2061,34.2301,29.4122,29.4122,26.9396,0.0341,16.1947,19.1352,26.0541,19.1352,574.2941,9.7426,3.3776,2.1497,77.0982,62.2568,34.7039,1.4343,4.3112,4.5937,1.0655,3.0058,3.2028,1.0000
 1877.0000,2504.9595,0.0769,1.3227,1.1986,1.2522,1.3044,1.3402,1.3248,1.1852,0.3227,2.1685,-0.0610,0.6156,2.7948,35.2716,30.4785,30.4785,27.9248,0.0749,29.1844,31.6691,37.5156,31.6691,834.3308,9.9117,2.0105,0.8159,76.0459,62.7931,34.9502,1.4483,4.3796,4.6081,1.0522,3.0239,3.1817,1.6000
 1877.5000,2505.4207,0.1275,1.3905,1.1695,1.2307,1.2931,1.3563,1.3960,1.1546,0.3214,2.1874,0.0001,0.6267,2.6563,35.3058,30.5137,30.5137,27.9572,0.0945,28.0354,30.5605,36.5019,30.5605,855.0684,10.2638,0.2944,0.4740,84.6171,63.2969,35.4064,1.4679,4.4096,4.6648,1.0579,3.0039,3.1778,2.4000
 1878.0000,2545.0945,0.2479,2.2678,1.5834,1.7058,1.8388,2.0080,2.1650,1.5524,0.3217,2.3818,0.2130,-0.0484,3.1599,28.9209,24.0670,24.0670,21.9677,0.0643,16.2539,19.1924,26.1064,19.1924,631.5540,10.2585,1.5739,1.3454,83.7452,57.1255,31.9543,1.3265,3.9945,4.2021,1.0520,3.0114,3.1679,1.6000
 1878.5000,2494.7092,0.4550,4.1864,2.0419,2.2811,2.5780,3.0339,3.5042,1.9857,0.3214,2.4757,0.4748,-0.1008,3.7885,21.6857,17.0329,17.0329,15.3301,0.0409,10.5627,13.7008,21.0847,13.7008,489.7441,9.6113,4.1979,3.8273,63.0008,45.8116,25.5055,1.0555,3.2305,3.3697,1.0431,3.0607,3.1926,0.0000
 1879.0000,2470.7549,0.6080,5.8203,2.1217,2.4095,2.7931,3.4555,4.3186,2.0570,0.3235,2.4546,0.5233,0.0780,4.0898,18.2685,13.8131,13.8131,12.2516,0.0501,11.8431,14.9363,22.2145,14.9363,471.3104,9.4871,2.8409,3.0697,42.4638,34.5273,18.9324,0.7791,2.4825,2.5221,1.0160,3.1864,3.2373,0.0000
 1879.5000,2509.9226,0.6912,6.6292,2.0468,2.3368,2.7413,3.4841,4.6096,1.9836,0.3218,2.4251,0.3866,0.0648,4.1872,18.4417,13.9747,13.9747,12.4068,0.0580,13.6293,16.6598,23.7905,16.6598,488.5605,9.3202,2.2220,2.6431,34.1994,27.6418,14.7283,0.6049,2.0474,1.9677,0.9610,3.3848,3.2529,0.0000
 1880.0000,2524.6648,0.7641,7.4199,1.9728,2.2597,2.6755,3.4704,4.8346,1.9124,0.3219,2.4325,0.0608,-0.2079,4.3075,18.0546,13.6138,13.6138,12.0602,0.0599,13.1810,16.2273,23.3950,16.2273,506.8965,9.1305,2.5152,2.6944,32.7710,25.2519,13.1656,0.5357,1.9133,1.7827,0.9317,3.5717,3.3279,0.0000
 1880.5000,2468.6819,0.8308,8.2499,1.9043,2.1851,2.6053,3.4287,4.9810,1.8511,0.3213,2.4680,-0.1213,-0.1991,4.5331,17.2990,12.9118,12.9118,11.3849,0.0622,11.0330,14.1546,21.4997,14.1546,525.1283,9.0910,2.5247,2.7877,33.4696,24.9381,12.6697,0.5115,1.9317,1.7345,0.8979,3.7764,3.3909,0.0000
 1881.0000,2545.2563,0.8573,8.3622,1.8169,2.0817,2.4861,3.2846,4.8683,1.7745,0.3220,2.4843,-0.1488,0.0929,4.7336,16.8465,12.4930,12.4930,10.9815,0.0555,10.0440,13.2003,20.6271,13.2003,550.4003,9.0565,2.5676,2.7842,34.4671,24.3376,12.0279,0.4805,1.9160,1.6708,0.8720,3.9872,3.4769,1.6000
 1881.5000,2567.2415,0.8201,7.4059,1.7334,1.9806,2.3628,3.1171,4.6404,1.6992,0.3230,2.4698,-0.2913,-0.1258,4.7510,17.4335,13.0365,13.0365,11.5050,0.0420,10.9188,14.0445,21.3990,14.0445,576.8921,9.0480,2.3862,2.5051,33.8229,23.6889,11.3445,0.4480,1.8990,1.6007,0.8429,4.2389,3.5730,0.0000
 1882.0000,2560.3203,0.8628,7.9572,1.6992,1.9413,2.3218,3.0771,4.6347,1.6692,0.3223,2.4561,-0.2688,-0.4243,4.7042,18.3264,13.8671,13.8671,12.3034,0.0337,11.7538,14.8502,22.1357,14.8502,588.5140,9.0493,2.4762,2.5880,32.3303,23.5386,10.8084,0.4225,1.9360,1.5454,0.7983,4.5820,3.6577,0.8000
 1882.5000,2539.7512,0.8947,8.3566,1.6654,1.9005,2.2738,3.0164,4.5528,1.6385,0.3213,2.4369,-0.0574,-0.3138,4.5566,18.2581,13.8035,13.8035,12.2424,0.0278,12.9125,15.9682,23.1581,15.9682,600.4493,9.0868,2.5087,2.7517,31.4051,23.5477,10.3422,0.3995,1.9920,1.5017,0.7539,4.9866,3.7593,1.0000
 1883.0000,2529.9272,0.9010,8.4730,1.6651,1.9014,2.2815,3.0439,4.6373,1.6394,0.3227,2.4216,0.0909,0.0821,4.3183,17.9040,13.4737,13.4737,11.9255,0.0234,13.8452,16.8682,23.9811,16.8682,600.5813,9.0754,2.4160,2.8850,31.0572,23.9132,9.6045,0.3594,2.1426,1.4497,0.6766,5.9621,4.0340,0.0000
 1883.5000,2563.2917,0.9317,9.1905,1.6912,1.9354,2.3338,3.1426,4.8587,1.6655,0.3233,2.4545,0.1477,0.4845,4.4527,16.7598,12.4129,12.4129,10.9043,0.0252,11.8480,14.9411,22.2188,14.9411,591.2893,9.0509,2.5050,3.0345,31.1660,24.4752,9.0159,0.3273,2.3027,1.4086,0.6117,7.0359,4.3039,2.4000
 1884.0000,2525.7581,0.9454,9.5427,1.7053,1.9520,2.3580,3.1875,4.9495,1.6797,0.3216,2.5081,0.2613,0.1244,4.9172,15.9737,11.6885,11.6885,10.2051,0.0265,8.6011,11.8080,19.3539,11.8081,586.4024,9.0958,3.3998,4.4184,32.4338,24.5132,8.3919,0.2982,2.3993,1.3416,0.5592,8.0461,4.4990,0.8000
 1884.5000,2562.2549,0.9249,9.0499,1.6883,1.9265,2.3181,3.1152,4.7754,1.6640,0.3227,2.5130,0.3417,-0.1054,4.9907,16.2114,11.9071,11.9071,10.4162,0.0228,8.3052,11.5225,19.0928,11.5226,592.3085,9.0635,4.1366,4.9421,33.0976,24.2639,8.0819,0.2831,2.4175,1.3112,0.5424,8.5382,4.6310,0.0000
 1885.0000,2523.9158,0.9203,9.0004,1.6952,1.9308,2.3191,3.1095,4.7454,1.6714,0.3223,2.4761,0.1545,0.1076,4.5652,16.7757,12.4275,12.4275,10.9184,0.0225,10.5371,13.6762,21.0622,13.6762,589.8912,9.0151,2.6299,3.1628,32.7645,23.6409,8.0597,0.2742,2.3502,1.3465,0.5729,8.5725,4.9114,1.0000
 1885.5000,2589.3076,0.9271,9.3409,1.7326,1.9730,2.3720,3.1882,4.8772,1.7097,0.3229,2.4518,-0.0895,-0.1859,4.2429,16.8035,12.4532,12.4532,10.9431,0.0278,12.0142,15.1014,22.3655,15.1014,577.1689,9.0007,2.2871,3.0036,32.5328,23.8496,8.3026,0.2703,2.3570,1.4445,0.6129,8.7194,5.3439,0.8000
 1886.0000,2593.3496,0.9375,9.8580,1.7864,2.0346,2.4495,3.3038,5.0580,1.7645,0.3238,2.4545,-0.1815,0.1120,4.3297,16.5500,12.2192,12.2192,10.7175,0.0331,11.8472,14.9402,22.2181,14.9402,559.7897,8.9921,2.4898,3.2500,31.9915,23.4443,8.3798,0.2686,2.2920,1.4779,0.6448,8.5324,5.5019,0.8000
 1886.5000,2560.9075,0.9578,10.7494,1.8632,2.1237,2.5629,3.4769,5.3460,1.8423,0.3218,2.4780,0.0156,0.6834,4.7571,16.3157,12.0032,12.0032,10.5090,0.0365,10.4218,13.5649,20.9604,13.5649,536.7215,9.0319,2.9619,3.9621,30.4310,23.6118,8.8273,0.2833,2.2600,1.5554,0.6883,7.9782,5.4910,0.0000
 1887.0000,2579.4263,0.9567,11.0795,1.9224,2.1871,2.6339,3.5710,5.4683,1.9035,0.3222,2.5151,0.3458,0.1876,5.4128,16.0186,11.7297,11.7297,10.2449,0.0348,8.1728,11.3948,18.9760,11.3948,520.1796,9.0708,4.0052,5.5330,29.8044,22.6224,8.8054,0.2842,2.1114,1.5440,0.7313,7.4300,5.4332,0.8000
 1887.5000,2568.2200,0.8869,9.4106,1.8912,2.1315,2.5296,3.3582,4.9576,1.8762,0.3214,2.5281,0.4582,-0.4336,5.9208,16.2860,11.9759,11.9759,10.4826,0.0242,7.3875,10.6371,18.2831,10.6371,528.7701,9.0774,3.6714,4.5499,30.6044,22.1143,8.9017,0.2928,2.0173,1.5346,0.7607,6.8894,5.2409,2.4000
 1888.0000,2633.1968,0.7948,7.4794,1.8196,2.0255,2.3574,3.0415,4.2968,1.8089,0.3213,2.4865,0.3458,-0.3865,5.7532,17.9592,13.5250,13.5250,11.9748,0.0134,9.9102,13.0712,20.5090,13.0712,549.5582,9.0319,2.6233,3.2723,29.6502,22.0074,8.9756,0.2942,1.9796,1.5523,0.7841,6.7292,5.2766,1.6000
 1888.5000,2606.6748,0.7463,6.7950,1.8247,2.0147,2.3160,2.9410,4.0751,1.8169,0.3224,2.4375,0.0453,-0.1905,5.1747,19.2521,14.7330,14.7330,13.1339,0.0144,12.8788,15.9357,23.1283,15.9357,548.0466,9.0421,2.3652,2.8843,29.9794,22.0178,9.1382,0.2952,1.9594,1.6007,0.8170,6.6365,5.4218,0.0000
 1889.0000,2560.4238,0.7186,6.7119,1.9049,2.0928,2.3886,3.0104,4.1404,1.8995,0.3222,2.4409,-0.0654,0.2522,5.0152,19.2642,14.7444,14.7444,13.1448,0.0232,12.6751,15.7391,22.9486,15.7391,524.9658,9.0657,2.3464,2.8781,31.4800,23.1229,9.7591,0.3078,2.0353,1.7452,0.8575,6.6131,5.6706,5.6000
 1889.5000,2562.8418,0.6983,6.8741,2.0302,2.2210,2.5196,3.1552,4.2949,2.0273,0.3232,2.4847,0.0869,0.6816,5.2925,18.8485,14.3549,14.3549,12.7716,0.0265,10.0201,13.1773,20.6060,13.1773,492.5534,9.1229,2.5527,3.2719,32.4218,25.8447,11.2032,0.3423,2.2395,2.0556,0.9179,6.5419,6.0048,1.6000
 1890.0000,2529.5818,0.6923,7.2849,2.1759,2.3680,2.6670,3.3076,4.4063,2.1749,0.3212,2.5341,-0.1506,0.3818,5.2873,17.5232,13.1197,13.1197,11.5851,0.0227,7.0250,10.2872,17.9632,10.2872,459.5823,9.1737,3.7583,4.8026,39.0047,29.7322,13.2804,0.4021,2.5298,2.4545,0.9702,6.2922,6.1049,0.8000
 1890.5000,2616.8779,0.6368,6.9714,2.3270,2.5156,2.8073,3.4317,4.4159,2.3269,0.3213,2.5680,-0.5807,-0.0355,4.8975,17.3147,12.9264,12.9264,11.3990,0.0230,4.9707,8.3050,16.1506,8.3050,429.7469,9.2896,6.5140,7.0288,46.6039,32.9684,15.1317,0.4666,2.7478,2.7565,1.0032,5.8894,5.9081,1.0000
 1891.0000,2531.5747,0.5453,6.2973,2.5159,2.7013,2.9876,3.5981,4.4823,2.5159,0.3216,2.5732,-0.4656,-0.1547,4.6235,17.4174,13.0216,13.0216,11.4907,0.0231,4.6550,8.0005,15.8721,8.0005,397.4733,9.4475,10.8804,10.5036,46.2976,37.0490,17.7967,0.5574,2.9879,3.2008,1.0712,5.3601,5.7420,1.6000
 1891.5000,2568.5193,0.4855,5.6826,2.5451,2.7003,2.9387,3.4377,4.0975,2.5451,0.3224,2.5715,0.0418,-0.2953,4.3760,16.1347,11.8366,11.8366,10.3481,0.0113,4.7569,8.0988,15.9620,8.0988,392.9147,9.5133,11.2791,9.0306,48.2604,39.4525,19.8070,0.6157,3.0881,3.5845,1.1608,5.0155,5.8218,0.0000
 1892.0000,2610.4751,0.4510,5.4028,2.5818,2.7093,2.9072,3.3119,3.8133,2.5818,0.3227,2.5828,0.4807,0.0990,4.0880,16.4738,12.1489,12.1489,10.6496,0.0023,4.0716,7.4375,15.3573,7.4375,387.3337,9.6094,6.6465,4.7682,55.5282,39.5225,20.7074,0.6375,2.9976,3.7770,1.2600,4.7023,5.9249,4.8000
 1892.5000,2638.8752,0.3883,5.3634,2.8754,2.9987,3.1981,3.5951,4.0541,2.8754,0.3226,2.5830,0.5635,0.9708,4.2024,16.6890,12.3474,12.3474,10.8412,0.0065,4.0621,7.4284,15.3489,7.4284,347.7752,9.6750,9.8454,8.5964,52.6401,36.0053,19.2413,0.5874,2.6953,3.5333,1.3109,4.5889,6.0156,1.6000
 1893.0000,2619.5151,0.3144,5.3759,3.2857,3.4067,3.6174,4.0169,4.4240,3.2857,0.3222,2.5735,0.1721,1.0484,4.6425,15.3499,11.1162,11.1162,9.6517,0.0083,4.6374,7.9835,15.8566,7.9835,304.3464,9.6302,12.3112,11.6660,40.1985,29.9198,16.2280,0.4977,2.2127,2.9690,1.3418,4.4459,5.9656,1.6000
 1893.5000,2567.5408,0.2428,5.4684,3.7752,3.8900,4.1143,4.5090,4.8514,3.7752,0.3210,2.5868,-0.2452,0.5273,5.0656,14.7886,10.6032,10.6032,9.1548,0.0065,3.8316,7.2060,15.1456,7.2060,264.8853,9.6343,13.5207,12.4919,32.3190,27.4602,15.4256,0.4808,1.9672,2.7857,1.4160,4.0919,5.7942,2.4000
 1894.0000,2623.5461,0.1851,5.6400,4.2782,4.3789,4.6113,4.9786,5.2485,4.2782,0.3218,2.6216,-0.1234,0.0216,5.3969,15.1004,10.8879,10.8879,9.4306,0.0076,1.7231,5.1714,13.2851,5.1714,233.7405,9.6496,12.0481,10.2319,33.8910,29.5287,17.2232,0.5423,2.0347,3.0841,1.5158,3.7520,5.6871,4.0000
 1894.5000,2558.6851,0.1462,5.9150,4.7716,4.8519,5.0863,5.4045,5.6065,4.7716,0.3216,2.6450,0.2736,-0.2422,5.5136,15.4517,11.2094,11.2094,9.7419,0.0052,0.3033,3.8014,12.0323,3.8015,209.5754,9.6445,8.9071,7.4748,42.7564,34.5691,21.0916,0.6694,2.2606,3.7518,1.6597,3.3770,5.6047,0.0000
 1895.0000,2562.4043,0.1115,6.1816,5.2595,5.3151,5.5471,5.7993,5.9511,5.2595,0.3209,2.6482,0.2185,-0.1947,5.3350,16.2341,11.9280,11.9280,10.4364,0.0027,0.1087,3.6137,11.8606,3.6137,190.1337,9.6768,7.4554,6.8722,51.1065,39.6258,24.8669,0.7925,2.4995,4.4075,1.7633,3.1538,5.5612,0.8000
 1895.5000,2531.2520,0.0805,6.3023,5.6174,5.6456,5.8616,6.0244,6.1540,5.6174,0.3233,2.6502,-0.2504,-0.2257,4.8853,15.7658,11.4975,11.4975,10.0205,0.0050,-0.0128,3.4964,11.7534,3.4965,178.0180,9.6477,7.4572,7.7432,55.1079,42.9347,27.5215,0.8836,2.6250,4.8474,1.8467,2.9707,5.4860,2.4000
 1896.0000,2562.2087,0.0499,6.3456,5.9143,5.9188,6.1131,6.1757,6.2695,5.9143,0.3221,2.6565,-0.4576,-0.0808,4.4493,14.7641,10.5808,10.5808,9.1331,0.0106,-0.3937,3.1288,11.4173,3.1288,169.0831,9.6497,7.3600,6.9328,59.9838,44.3714,29.1179,0.9526,2.6211,5.0446,1.9246,2.7517,5.2959,0.8000
 1896.5000,2571.9629,0.0109,7.7053,7.5895,7.5674,7.7931,7.7405,7.6413,7.5895,0.3211,2.6654,-0.2095,0.0701,4.5535,13.2309,9.1892,9.1892,7.7811,0.0140,-0.9327,2.6088,10.9417,2.6088,131.7612,9.6695,7.7649,6.3961,59.3441,41.6540,28.0980,0.9357,2.3574,4.7897,2.0317,2.5195,5.1190,2.4000
 1897.0000,2600.2136,-0.0354,9.8547,10.3387,10.3068,10.5141,10.3324,9.7960,10.3387,0.3227,2.6741,0.0756,-0.3339,4.9942,10.7310,6.9495,6.9495,5.5929,0.0043,-1.4631,2.0970,10.4737,2.0970,96.7242,9.6563,18.1169,23.9951,46.9774,37.5020,25.8994,0.8848,2.0474,4.3090,2.1046,2.3140,4.8702,1.6000
 1897.5000,2606.5591,-0.0428,8.1500,8.6356,8.6233,8.7396,8.6049,8.1335,8.6356,0.3213,2.6466,0.0101,-0.6835,5.0500,10.8639,7.0677,7.0677,5.7087,-0.0054,0.2089,3.7103,11.9490,3.7103,115.8002,9.6597,33.3654,52.8504,36.4888,36.2856,25.5917,0.8970,1.9165,4.1501,2.1655,2.1366,4.6268,2.4000
 1898.0000,2582.6619,0.0031,5.6416,5.6177,5.6296,5.6760,5.6740,5.6408,5.6177,0.3211,2.5514,-0.2708,-0.4634,4.4223,13.7384,9.6483,9.6483,8.2278,0.0083,5.9738,9.2729,17.0357,9.2729,178.0076,9.6633,24.9885,29.3771,43.6498,39.9302,28.5454,1.0160,2.0649,4.5554,2.2061,2.0323,4.4835,3.0000
 1898.5000,2567.6904,0.0405,3.2232,3.0450,3.0578,3.0692,3.0999,3.2266,3.0450,0.3226,2.4710,-0.2034,-0.0762,3.5775,19.7216,15.1742,15.1742,13.5562,0.0336,10.8462,13.9744,21.3349,13.9744,328.4052,9.7440,4.9208,2.2873,60.4906,44.0217,32.0050,1.1533,2.2147,5.0403,2.2759,1.9202,4.3702,1.6000
 1899.0000,2542.5955,0.0385,2.3933,2.2674,2.2791,2.2819,2.3009,2.3959,2.2674,0.3211,2.4888,0.3220,0.2311,3.2711,24.1190,19.3659,19.3659,17.5444,0.0437,9.7717,12.9376,20.3868,12.9376,441.0390,9.7563,2.9225,2.4521,62.0179,44.6007,32.7439,1.1842,2.2117,5.1366,2.3225,1.8677,4.3376,4.0000
 1899.5000,2638.7134,0.0075,2.3052,2.2813,2.2999,2.2979,2.2917,2.3074,2.2813,0.3222,2.5531,0.6269,0.1817,3.4085,22.4072,17.7212,17.7212,15.9847,0.0392,5.8711,9.1738,16.9450,9.1738,438.3464,9.7246,5.3547,4.2262,50.8488,40.0952,29.7515,1.0781,1.9570,4.6568,2.3795,1.8152,4.3193,4.0000
 1900.0000,2595.9297,-0.0013,2.6206,2.6255,2.6556,2.6459,2.5873,2.6248,2.6255,0.3223,2.6050,0.3610,-0.1790,3.5189,20.0008,15.4370,15.4370,13.8076,0.0331,2.7267,6.1397,14.1706,6.1398,380.8854,9.7187,6.7827,5.2514,45.0173,37.7175,28.0367,1.0132,1.8464,4.4018,2.3840,1.8223,4.3444,2.0000
 1900.5000,2540.0042,-0.0723,3.0120,3.3165,3.3593,3.3392,3.2329,3.0180,3.3165,0.3223,2.6305,-0.0544,-0.5169,3.5630,20.1275,15.5565,15.5565,13.9218,0.0302,1.1839,4.6511,12.8093,4.6511,301.5208,9.6570,7.2508,5.0955,47.8423,39.3784,29.5131,1.0581,1.9007,4.6735,2.4588,1.7963,4.4167,2.4000
 1901.0000,2550.4390,-0.0896,3.2447,3.6527,3.7034,3.6752,3.5641,3.2541,3.6527,0.3218,2.5687,-0.3362,-1.0421,3.5496,25.1024,20.3183,20.3183,18.4445,0.0319,4.9299,8.2657,16.1146,8.2657,273.7727,9.7202,6.5253,4.8880,54.6167,43.8608,32.9500,1.1724,2.1046,5.2602,2.4994,1.7951,4.4867,5.0000
 1901.5000,2502.1265,-0.0522,2.5126,2.6953,2.7352,2.7132,2.6423,2.5214,2.6953,0.3220,2.3031,-0.4898,-1.0873,3.1469,32.4045,27.5569,27.5569,25.2205,0.0397,21.0257,23.7967,30.3168,23.7967,371.0213,9.7782,5.0697,3.3982,62.6544,50.3459,37.9629,1.3488,2.3793,6.0698,2.5511,1.7640,4.5002,1.6000
 1902.0000,2489.9417,-0.0495,1.6147,1.7261,1.7527,1.7394,1.6966,1.6201,1.7261,0.3221,1.9891,-0.4431,0.4094,2.5523,40.5120,35.9321,35.9321,32.9303,0.0857,40.0541,42.1574,47.1065,42.1574,579.3530,9.8898,1.6897,1.0047,72.7580,57.0376,42.8666,1.5262,2.7032,6.8388,2.5299,1.7712,4.4809,5.0000
 1902.5000,2463.7639,-0.0797,1.5405,1.7124,1.7384,1.7259,1.6786,1.5463,1.7124,0.3220,1.9972,-0.0488,1.6155,2.5531,39.4014,34.7642,34.7642,31.8628,0.1620,39.5607,41.6813,46.6712,41.6813,583.9673,9.9995,3.3718,1.6210,82.5754,63.5699,47.3758,1.6962,3.0434,7.5131,2.4686,1.7942,4.4293,4.0000
 1903.0000,2453.1919,-0.0989,2.1017,2.3935,2.4266,2.4090,2.3295,2.1106,2.3935,0.3218,2.2730,0.4431,0.5996,3.0010,32.6912,27.8471,27.8471,25.4898,0.1716,22.8492,25.5563,31.9258,25.5563,417.7964,9.9306,1.8305,0.8600,89.9382,67.4526,50.0921,1.7897,3.2387,7.9622,2.4584,1.8097,4.4490,3.2000
 1903.5000,2474.1748,-0.0894,3.0931,3.4808,3.5199,3.4919,3.3563,3.1057,3.4808,0.3216,2.5154,0.7215,-0.3194,3.4100,26.1716,21.3598,21.3598,19.4265,0.1078,8.1596,11.3821,18.9644,11.3821,287.2938,9.8701,2.9901,2.9524,89.7410,66.0145,48.5690,1.7247,3.2166,7.7699,2.4155,1.8650,4.5050,1.6000
 1904.0000,2473.4270,-0.0783,4.4906,4.9830,5.0186,4.9714,4.7593,4.5080,4.9830,0.3233,2.6377,0.6623,0.3012,3.6958,20.8149,16.2061,16.2061,14.5421,0.0576,0.7465,4.2290,12.4234,4.2291,200.6841,9.8475,14.4834,9.7531,84.1817,64.7822,46.7972,1.6542,3.2549,7.5228,2.3112,1.9677,4.5478,0.0000
 1904.5000,2479.4731,-0.0664,5.3921,5.8920,5.8986,5.8315,5.5798,5.4150,5.8920,0.3214,2.6688,0.1351,0.7729,3.7313,20.1558,15.5832,15.5832,13.9473,0.0384,-1.1384,2.4103,10.7602,2.4103,169.7218,9.8194,7.1308,4.7336,85.8148,63.0591,44.5940,1.5630,3.2957,7.2316,2.1943,2.1086,4.6268,0.0000
 1905.0000,2474.1287,-0.0560,5.7520,6.2011,6.1588,6.0742,5.8230,5.7782,6.2011,0.3223,2.6620,-0.2609,0.4769,3.6887,20.2404,15.6630,15.6630,14.0236,0.0317,-0.7254,2.8088,11.1246,2.8088,161.2610,9.8004,5.8017,4.3553,84.7360,58.7455,40.9971,1.4171,3.1520,6.7425,2.1391,2.2243,4.7581,0.0000
 1905.5000,2507.3088,-0.0571,6.6722,7.2034,7.0913,6.9747,6.6884,6.7017,7.2034,0.3208,2.6601,-0.0265,-0.0738,3.8944,18.1154,13.6704,13.6704,12.1146,0.0313,-0.6125,2.9178,11.2243,2.9178,138.8231,9.6932,9.4789,9.7782,71.6345,51.9402,36.2393,1.2454,2.7958,5.9941,2.1440,2.2448,4.8129,0.0000
 1906.0000,2476.3411,-0.0642,8.5799,9.3488,9.1220,8.9456,8.5559,8.6109,9.3488,0.3211,2.6732,0.3167,-0.5408,4.2684,14.0710,9.9500,9.9500,8.5209,0.0320,-1.4056,2.1524,10.5244,2.1525,106.9655,9.6871,21.0573,18.3907,58.4570,43.2790,30.3225,1.0407,2.3098,5.0222,2.1743,2.2195,4.8258,0.0000
 1906.5000,2544.2893,-0.0684,10.8785,11.9185,11.5333,11.2770,10.7444,10.9186,11.9185,0.3210,2.6855,0.4800,-0.5193,4.5454,11.5833,7.7090,7.7090,6.3367,0.0309,-2.1543,1.4300,9.8638,1.4300,83.9034,9.6525,11.1947,8.7394,51.8640,36.5120,25.4759,0.8766,1.9493,4.2087,2.1590,2.2238,4.8012,1.0000
 1907.0000,2526.0122,-0.0730,13.0527,14.3848,13.8193,13.4771,12.8221,13.1125,14.3848,0.3223,2.6870,0.3961,0.1363,4.7176,9.9542,6.2612,6.2612,4.9172,0.0278,-2.2432,1.3442,9.7854,1.3442,69.5177,9.6169,18.3539,23.6035,45.8809,32.4185,22.4061,0.7684,1.7548,3.7139,2.1164,2.2838,4.8334,0.8000
 1907.5000,2497.5198,-0.0823,18.7977,20.9650,20.0207,19.4624,18.4228,18.9293,20.9650,0.3219,2.6845,-0.2475,0.3789,4.7477,8.0732,4.6092,4.6092,3.2890,0.0241,-2.0889,1.4931,9.9215,1.4931,47.6986,9.5216,32.3613,43.4372,39.4723,30.3945,20.8256,0.7084,1.6640,3.4792,2.0909,2.3488,4.9113,1.0000
 1908.0000,2515.3132,-0.0899,26.0623,29.3482,27.9273,27.0875,25.6201,26.3432,29.3482,0.3218,2.6799,-0.5918,0.1449,4.5976,7.5954,4.1929,4.1929,2.8773,0.0199,-1.8128,1.7596,10.1652,1.7596,34.0736,9.4809,35.9733,44.5538,39.2617,28.9737,19.7987,0.6647,1.5926,3.3494,2.1032,2.3959,5.0390,0.0000
 1908.5000,2493.6958,-0.0990,24.7827,28.2278,26.8573,26.0786,25.0751,25.0403,28.2278,0.3232,2.6725,0.0609,0.2606,4.5668,7.8533,4.4175,4.4175,3.0995,0.0156,-1.3609,2.1956,10.5639,2.1956,35.4261,9.4834,26.8189,31.4598,42.5935,30.0940,20.5595,0.6835,1.6546,3.5101,2.1214,2.4208,5.1354,0.0000
 1909.0000,2529.7202,-0.1096,18.7924,21.6879,20.6778,20.1077,19.5867,18.9266,21.6879,0.3219,2.6616,0.5466,0.1264,4.7009,8.1890,4.7102,4.7102,3.3889,0.0129,-0.7060,2.8275,11.1417,2.8275,46.1086,9.4903,29.8462,40.7303,42.8897,32.1694,21.8715,0.7255,1.7790,3.7416,2.1032,2.4520,5.1569,1.6000
 1909.5000,2527.7510,-0.0946,12.2587,13.8864,13.3002,12.9671,12.7537,12.3036,13.8864,0.3216,2.6523,0.3041,0.0083,4.7717,8.9092,5.3408,5.3408,4.0112,0.0108,-0.1388,3.3749,11.6423,3.3749,72.0130,9.5182,30.4274,30.1216,42.3282,36.3599,24.4846,0.8138,2.0287,4.1813,2.0611,2.4930,5.1383,0.0000
 1910.0000,2539.1067,-0.0524,8.6103,9.2392,8.9098,8.7202,8.6816,8.6258,9.2392,0.3219,2.6443,0.0811,-0.1485,4.6755,10.7175,6.9376,6.9376,5.5812,0.0060,0.3485,3.8450,12.0722,3.8450,108.2343,9.5509,18.2378,21.3351,49.5764,45.4881,30.1432,1.0089,2.5830,5.1142,1.9800,2.5603,5.0692,0.8000
 1910.5000,2514.1616,-0.0031,6.3991,6.4266,6.2562,6.1580,6.2023,6.4022,6.4266,0.3211,2.6386,-0.1832,-0.6050,4.2804,13.8674,9.7652,9.7652,8.3414,0.0028,0.6910,4.1756,12.3744,4.1756,155.6021,9.5915,14.5362,11.4830,72.1431,58.4855,37.8776,1.2796,3.4138,6.3700,1.8660,2.6678,4.9779,0.0000
 1911.0000,2532.3115,0.0262,4.8976,4.7217,4.6447,4.5999,4.6581,4.8933,4.7217,0.3223,2.6401,-0.5537,0.0576,3.7559,18.5248,14.0523,14.0523,12.4813,0.0033,0.6028,4.0904,12.2966,4.0904,211.7863,9.6730,1.5594,1.5538,96.5466,68.3572,42.9393,1.4612,4.1696,7.1712,1.7199,2.8536,4.9078,0.8000
 1911.5000,2541.6169,0.0420,4.5447,4.2843,4.2430,4.2204,4.2856,4.5387,4.2843,0.3220,2.6445,-0.5512,0.9007,3.5623,21.5499,16.9037,16.9037,15.2070,-0.0032,0.3353,3.8323,12.0606,3.8323,233.4102,9.6925,2.7831,2.5773,100.0867,71.0691,42.8819,1.4630,4.5953,7.1439,1.5546,3.1411,4.8831,0.8000
 1912.0000,2595.9409,0.0502,4.6566,4.3381,4.3204,4.3105,4.3783,4.6513,4.3381,0.3218,2.6490,-0.4331,0.4492,3.6334,20.8599,16.2487,16.2487,14.5828,-0.0132,0.0617,3.5683,11.8191,3.5683,230.5144,9.7225,6.1528,4.2990,89.0723,66.7803,38.7546,1.3214,4.5484,6.4597,1.4202,3.4420,4.8884,1.6000
 1912.5000,2574.4856,0.0005,4.4100,4.4071,4.4043,4.4050,4.4055,4.4058,4.4071,0.3220,2.6490,-0.3210,-0.1538,3.5936,20.3745,15.7896,15.7896,14.1445,-0.0134,0.0631,3.5696,11.8204,3.5696,226.9071,9.7426,5.4548,4.1149,80.2320,61.4346,34.7900,1.1861,4.3140,5.7995,1.3443,3.6370,4.8894,3.2000
 1913.0000,2520.8062,0.0597,5.0909,4.6783,4.6832,4.6930,4.7722,5.0861,4.6783,0.3204,2.6272,0.0028,-0.3498,3.4987,19.7248,15.1771,15.1771,13.5590,-0.0078,1.3801,4.8405,12.9825,4.8405,213.7524,9.7962,6.7606,4.5449,78.4842,57.8325,32.2094,1.1059,4.1382,5.3327,1.2887,3.7421,4.8223,1.6000
 1913.5000,2562.8418,0.0630,5.5219,5.0499,5.0560,5.0743,5.1747,5.5156,5.0499,0.3215,2.6107,0.4786,-0.3325,3.5835,17.5889,13.1807,13.1807,11.6438,0.0020,2.3788,5.8041,13.8637,5.8041,198.0238,9.7298,4.5940,4.0276,76.7061,52.4375,29.1210,1.0121,3.7641,4.7633,1.2655,3.7192,4.7064,0.8000
 1914.0000,2521.8318,0.0492,6.5197,6.0829,6.0825,6.1165,6.2325,6.5069,6.0829,0.3222,2.6460,0.5797,0.0760,3.8668,14.2917,10.1506,10.1506,8.7157,0.0139,0.2404,3.7407,11.9768,3.7407,164.3955,9.6008,12.5473,15.4651,62.0287,43.9941,24.2618,0.8506,3.1851,3.9335,1.2350,3.7448,4.6246,2.0000
 1914.5000,2540.9602,0.0400,9.3116,8.8025,8.7737,8.8604,9.0423,9.2628,8.8025,0.3219,2.6974,0.0949,0.4122,4.1140,10.5128,6.7558,6.7558,5.4029,0.0163,-2.8737,0.7359,9.2291,0.7359,113.6042,9.4790,20.9858,22.2070,43.0869,34.9182,19.0251,0.6723,2.5548,3.0594,1.1975,3.8003,4.5509,0.0000
 1915.0000,2538.8413,0.0441,11.9812,11.2608,11.1688,11.3415,11.6050,11.8567,11.2608,0.3193,2.7137,-0.0292,0.1860,4.2044,9.3521,5.7301,5.7301,4.3948,0.0142,-3.8608,-0.2166,8.3581,-0.2165,88.8034,9.3786,19.7742,14.8925,36.7957,30.3052,16.0202,0.5745,2.2743,2.5362,1.1151,3.9587,4.4144,0.0000
 1915.5000,2558.4658,0.0704,14.8226,13.4087,13.2285,13.5285,13.9290,14.5732,13.4087,0.3203,2.7019,0.3174,-0.3314,4.2696,8.9117,5.3430,5.3430,4.0134,0.0168,-3.1437,0.4754,8.9909,0.4754,74.5785,9.3682,17.8527,17.6009,40.7551,33.1730,16.7042,0.6026,2.5983,2.6274,1.0112,4.3116,4.3599,0.8000
 1916.0000,2601.8838,0.1080,17.6509,15.0978,14.8232,15.2759,15.8607,17.2405,15.0978,0.3210,2.6811,0.2922,-0.2884,4.3156,8.8317,5.2728,5.2728,3.9442,0.0196,-1.8826,1.6922,10.1036,1.6922,66.2350,9.3872,20.8531,18.2470,52.7193,38.8029,18.5555,0.6706,3.1657,2.9132,0.9202,4.7211,4.3445,0.0000
 1916.5000,2560.8838,0.1394,19.9695,16.2801,15.9247,16.5344,17.3019,19.4057,16.2801,0.3218,2.6560,0.0299,0.1050,4.3875,10.0350,6.3327,6.3327,4.9874,0.0196,-0.3617,3.1598,11.4456,3.1598,61.4248,9.4047,19.9411,15.6361,62.7870,41.8994,19.4628,0.6905,3.5019,3.1167,0.8900,5.0715,4.5137,1.6000
 1917.0000,2582.4202,0.1837,25.9719,19.7463,19.1927,20.1775,21.4384,24.8908,19.7463,0.3215,2.6273,-0.0122,0.1108,4.6008,10.1362,6.4222,6.4222,5.0753,0.0193,1.3743,4.8348,12.9773,4.8348,50.6425,9.4308,14.4742,13.9360,57.0828,39.4783,18.8371,0.6537,3.2223,3.0858,0.9576,4.9295,4.7207,0.0000
 1917.5000,2560.3428,0.2105,30.8126,22.4356,21.6942,23.0428,24.8720,29.2743,22.4356,0.3204,2.6124,0.0221,0.0041,4.8473,9.0656,5.4782,5.4782,4.1466,0.0187,2.2792,5.7080,13.7757,5.7080,44.5720,9.4072,10.2210,12.3762,43.2206,34.0706,17.0392,0.5863,2.6725,2.8148,1.0533,4.5580,4.8008,0.8000
 1918.0000,2540.0964,0.2154,33.0760,23.8920,23.0295,24.5846,26.8857,31.3237,23.8920,0.3212,2.6175,-0.1104,-0.0008,4.9131,8.0296,4.5711,4.5711,3.2515,0.0172,1.9709,5.4105,13.5037,5.4105,41.8550,9.3657,16.3968,17.0741,36.5159,30.0645,15.7427,0.5432,2.2719,2.5937,1.1416,4.1827,4.7751,0.8000
 1918.5000,2555.8059,0.2033,31.9224,23.5149,22.6798,24.1761,26.4353,30.3755,23.5149,0.3228,2.6280,-0.1119,0.2502,4.7838,7.4044,4.0269,4.0269,2.7130,0.0161,1.3336,4.7956,12.9414,4.7956,42.5263,9.3848,6.3268,7.6298,37.3764,29.9377,16.0745,0.5568,2.2198,2.6381,1.1885,3.9867,4.7380,0.8000
 1919.0000,2550.8191,0.1962,35.1390,26.1845,25.2096,27.0172,29.5173,33.3000,26.1845,0.3207,2.6513,0.0503,-0.0937,4.6871,6.6843,3.4030,3.4030,2.0944,0.0189,-0.0797,3.4319,11.6944,3.4319,38.1905,9.3631,16.4468,11.2775,40.6790,32.7132,17.9032,0.6213,2.3951,2.9329,1.2245,3.8552,4.7208,0.8000
 1919.5000,2561.1953,0.1778,39.8740,30.6017,29.4774,31.9144,34.4051,37.6166,30.6017,0.3216,2.6824,-0.0025,-0.3520,4.6701,5.4992,2.3830,2.3830,1.0801,0.0245,-1.9637,1.6139,10.0320,1.6139,32.6779,9.2765,27.3422,37.2300,48.0159,37.8973,21.4102,0.7481,2.6914,3.4829,1.2940,3.5976,4.6555,1.6000
 1920.0000,2525.4702,0.1179,32.7758,27.6172,26.9588,29.0224,30.0753,31.4088,27.6172,0.3200,2.7076,0.0436,0.2767,4.7432,4.7683,1.7582,1.7582,0.4569,0.0278,-3.4934,0.1379,8.6823,0.1379,36.2094,9.2557,41.2885,73.0474,57.5757,44.9159,26.3022,0.9223,3.0676,4.2632,1.3897,3.3260,4.6221,0.0000
 1920.5000,2589.6528,0.0650,18.2056,16.6015,16.5462,17.2752,17.4531,17.8488,16.6015,0.3205,2.7315,0.1338,0.0456,5.0107,5.2930,2.2064,2.2064,0.9041,0.0280,-4.9424,-1.2602,7.4038,-1.2602,60.2356,9.3117,49.2116,72.5453,67.5466,51.5472,31.3519,1.0937,3.3693,5.1086,1.5162,3.0805,4.6708,0.8000
 1921.0000,2583.4458,0.0504,7.5782,7.0579,7.1133,7.2813,7.3229,7.5201,7.0579,0.3213,2.7395,-0.2331,-0.2680,5.1798,8.0382,4.5787,4.5787,3.2589,0.0335,-5.4239,-1.7248,6.9789,-1.7248,141.6849,9.4892,43.5020,55.7620,75.6007,60.4910,38.1692,1.3316,3.7674,6.2194,1.6508,2.8293,4.6707,2.4000
 1921.5000,2603.4380,0.0590,4.4099,4.0565,4.1034,4.1702,4.2079,4.3852,4.0565,0.3227,2.7125,-0.6716,-0.0621,4.8164,14.4917,10.3326,10.3326,8.8924,0.0538,-3.7884,-0.1467,8.4220,-0.1467,246.5210,9.4850,27.3575,23.4309,87.1559,70.6425,46.2172,1.6005,4.1693,7.5868,1.8197,2.6050,4.7402,5.0000
 1922.0000,2593.6838,0.0644,3.2554,2.9709,3.0124,3.0544,3.0955,3.2372,2.9709,0.3214,2.6652,-0.6584,-0.2650,3.9947,25.3433,20.5524,20.5524,18.6655,0.0807,-0.9188,2.6222,10.9540,2.6222,336.6001,9.4778,4.6494,2.4671,109.3016,83.4520,56.9045,1.9692,4.5977,9.3481,2.0332,2.3349,4.7473,2.4000
 1922.5000,2583.6179,0.0681,2.8241,2.5635,2.6060,2.6416,2.6889,2.8077,2.5635,0.3212,2.6277,-0.2471,-0.3167,3.3238,33.1852,28.3481,28.3481,25.9544,0.0839,1.3542,4.8154,12.9596,4.8154,390.0992,9.7201,2.2901,1.9044,128.1076,94.7984,66.6466,2.2959,4.9571,10.9979,2.2186,2.1592,4.7903,2.0000
 1923.0000,2581.8218,0.0748,2.8000,2.5169,2.5676,2.6056,2.6670,2.7836,2.5169,0.3204,2.6041,0.0471,-0.1726,3.1565,33.3924,28.5586,28.5586,26.1495,0.0542,2.7840,6.1951,14.2212,6.1951,397.3170,9.8864,2.5130,2.4310,133.5912,101.3695,73.3083,2.5121,5.0398,12.1598,2.4127,2.0062,4.8404,0.8000
 1923.5000,2567.4834,0.0815,2.7678,2.4633,2.5190,2.5577,2.6294,2.7518,2.4633,0.3203,2.6003,-0.0889,0.2439,3.2632,33.3780,28.5440,28.5440,26.1360,0.0234,3.0142,6.4172,14.4243,6.4172,405.9612,10.0666,2.1479,1.8650,129.0794,103.0656,76.1084,2.5901,4.9518,12.7095,2.5667,1.9118,4.9069,1.6000
 1924.0000,2603.4155,0.0840,2.6925,2.3875,2.4439,2.4812,2.5548,2.6766,2.3875,0.3217,2.6155,-0.1063,0.9306,3.4200,32.8678,28.0261,28.0261,25.6558,0.0070,2.0887,5.5242,13.6077,5.5242,418.8502,10.2998,1.0193,1.3489,126.5820,102.4271,77.2909,2.6090,4.7426,13.0085,2.7429,1.8178,4.9860,1.6000
 1924.5000,2601.4575,0.0828,2.6751,2.3761,2.4335,2.4700,2.5405,2.6564,2.3761,0.3212,2.6137,0.2355,0.6469,3.5447,30.6535,25.7945,25.7945,23.5809,-0.0050,2.2020,5.6335,13.7076,5.6335,420.8612,10.2615,1.4630,1.5154,129.2160,102.3673,78.9644,2.6552,4.5428,13.3388,2.9362,1.7109,5.0236,0.0000
 1925.0000,2616.5898,0.0791,2.7305,2.4386,2.4982,2.5353,2.6001,2.7129,2.4386,0.3225,2.5969,0.4462,-0.1330,3.5280,29.9499,25.0910,25.0910,22.9247,-0.0118,3.2178,6.6136,14.6039,6.6136,410.0676,10.2421,2.0756,2.2223,131.6151,101.8827,80.2580,2.6964,4.3065,13.5681,3.1506,1.5971,5.0319,2.4000
 1925.5000,2595.8140,0.0732,2.7743,2.4996,2.5591,2.5957,2.6486,2.7587,2.4996,0.3204,2.6022,0.3691,-0.1232,3.3729,30.2096,25.3503,25.3503,23.1667,-0.0098,2.8985,6.3056,14.3222,6.3056,400.0697,10.2520,2.8679,1.9927,132.0888,102.0209,82.3059,2.7676,4.0452,13.9031,3.4369,1.4616,5.0235,0.0000
 1926.0000,2567.6331,0.0650,2.8482,2.5972,2.6564,2.6932,2.7304,2.8362,2.5972,0.3206,2.6342,0.0463,-0.0086,3.3000,29.5595,24.7019,24.7019,22.5612,-0.0045,0.9586,4.4337,12.6105,4.4337,385.0244,10.2950,3.2784,2.4773,129.2085,101.9108,83.8710,2.8299,3.7941,14.1216,3.7220,1.3407,4.9901,2.4000
 1926.5000,2603.6687,0.0531,2.9267,2.7153,2.7731,2.8100,2.8287,2.9191,2.7153,0.3211,2.6675,-0.3492,-0.3301,3.3739,28.4925,23.6425,23.6425,21.5702,0.0010,-1.0590,2.4869,10.8303,2.4869,368.2865,10.3031,4.4267,2.5355,127.2692,101.4958,84.5032,2.8663,3.6527,14.1568,3.8758,1.2744,4.9391,3.2000
 1927.0000,2552.5229,0.0245,2.9574,2.8582,2.9140,2.9513,2.9513,2.9513,2.8582,0.3212,2.6628,-0.4750,-0.6289,3.2891,28.8368,23.9836,23.9836,21.8896,0.0056,-0.7747,2.7613,11.0812,2.7613,349.8716,10.3058,3.9772,2.5622,129.2640,100.8712,83.7649,2.8580,3.6772,13.9535,3.7946,1.2866,4.8823,4.0000
 1927.5000,2602.7363,0.0347,3.1338,2.9852,3.0368,3.0734,3.0590,3.1348,2.9852,0.3215,2.6295,-0.3245,-0.6866,2.9934,28.4381,23.5886,23.5886,21.5197,0.0107,1.2442,4.7093,12.8625,4.7093,334.9861,10.3427,3.9583,2.7220,132.1999,101.3283,83.1519,2.8435,3.8523,13.8209,3.5877,1.3548,4.8605,2.4000
 1928.0000,2601.5845,0.0334,3.1555,3.0115,3.0551,3.0886,3.0685,3.1555,3.0115,0.3219,2.6133,-0.1057,-0.4286,2.7902,28.9515,24.0974,24.0974,21.9961,0.0166,2.2263,5.6570,13.7291,5.6570,332.0643,10.3605,4.7735,3.1278,133.6501,100.8489,82.0437,2.7993,3.9295,13.6665,3.4779,1.4037,4.8821,1.0000
 1928.5000,2621.8186,0.0321,3.0719,2.9369,2.9707,2.9994,2.9809,3.0701,2.9369,0.3219,2.6093,-0.1250,0.0143,2.7721,31.0114,26.1534,26.1534,23.9153,0.0167,2.4670,5.8892,13.9415,5.8892,340.4966,10.3736,5.0400,3.1439,130.1073,100.8372,82.1799,2.8035,3.8918,13.6913,3.5180,1.3882,4.8836,4.0000
 1929.0000,2622.8442,0.0295,3.0734,2.9493,2.9766,3.0023,2.9856,3.0727,2.9493,0.3211,2.6104,-0.3680,0.0365,2.8406,29.4371,24.5800,24.5800,22.4474,0.0137,2.4016,5.8261,13.8837,5.8261,339.0592,10.4319,3.6801,2.1943,126.6006,99.9691,82.1963,2.7976,3.7450,13.7249,3.6649,1.3387,4.9060,3.2000
 1929.5000,2590.6887,0.0268,3.1369,3.0217,3.0440,3.0676,3.0510,3.1369,3.0217,0.3210,2.6200,-0.2936,0.1691,2.8832,28.3559,23.5073,23.5073,21.4436,0.0146,1.8173,5.2623,13.3682,5.2623,330.9353,10.4204,4.5388,2.9673,127.4640,98.1346,81.3445,2.7703,3.5818,13.5744,3.7898,1.2929,4.8999,1.6000
 1930.0000,2589.1694,0.0239,3.2321,3.1262,3.1444,3.1663,3.1495,3.2321,3.1262,0.3211,2.6161,0.0296,0.4734,2.9024,28.3603,23.5117,23.5117,21.4477,0.0178,2.0518,5.4886,13.5751,5.4886,319.8796,10.4424,2.7497,2.4163,127.2906,97.4497,81.0737,2.7588,3.5422,13.5401,3.8225,1.2840,4.9080,2.4000
 1930.5000,2565.3071,0.0219,3.3595,3.2584,3.2737,3.2946,3.2794,3.3595,3.2584,0.3199,2.6013,0.1729,0.4363,2.9653,28.2139,23.3669,23.3669,21.3120,0.0181,2.9523,6.3574,14.3696,6.3574,306.8975,10.4304,2.8045,2.8220,126.9864,96.7451,80.8518,2.7569,3.4736,13.4765,3.8797,1.2600,4.8883,1.6000
 1931.0000,2583.0657,0.0185,3.3086,3.2245,3.2365,3.2552,3.2460,3.3086,3.2245,0.3212,2.5995,0.2372,0.1259,3.0263,29.2725,24.4163,24.4163,22.2943,0.0148,3.0586,6.4600,14.4634,6.4600,310.1296,10.4481,2.8214,2.2440,128.8008,97.6343,81.6716,2.7987,3.4850,13.5471,3.8873,1.2452,4.8404,3.2000
 1931.5000,2568.8994,0.0067,3.1202,3.0915,3.1009,3.1173,3.1140,3.1202,3.0915,0.3203,2.6030,0.2091,-0.1843,3.0823,29.6474,24.7894,24.7894,22.6431,0.0100,2.8487,6.2575,14.2783,6.2575,323.4647,10.5013,1.5877,1.5182,129.2231,99.2570,83.1430,2.8639,3.5075,13.7210,3.9119,1.2247,4.7909,0.0000
 1932.0000,2542.3538,0.0057,3.1171,3.0928,3.1012,3.1172,3.1171,3.1171,3.0928,0.3207,2.5942,0.0532,0.1829,3.0941,30.1709,25.3117,25.3117,23.1307,0.0036,3.3824,6.7724,14.7491,6.7725,323.3358,10.4981,3.7321,2.7796,126.4163,100.1598,83.2988,2.8857,3.6053,13.6688,3.7913,1.2494,4.7367,2.4000
 1932.5000,2516.8674,0.0061,3.1747,3.1481,3.1565,3.1728,3.1739,3.1747,3.1481,0.3201,2.5717,-0.0239,0.2774,2.9556,30.4118,25.5526,25.5526,23.3553,-0.0023,4.7454,8.0877,15.9519,8.0877,317.6507,10.5023,5.4157,3.4181,126.6937,100.1731,82.5355,2.8489,3.7217,13.5927,3.6523,1.3064,4.7711,0.8000
 1933.0000,2509.3591,0.0061,3.2602,3.2328,3.2417,3.2591,3.2598,3.2602,3.2328,0.3207,2.5499,-0.1117,0.0287,2.8058,29.9519,25.0930,25.0930,22.9265,-0.0078,6.0675,9.3634,17.1184,9.3634,309.3310,10.5100,4.7889,3.3416,130.9394,99.0277,81.0246,2.7986,3.7670,13.3351,3.5400,1.3460,4.7649,3.2000
 1933.5000,2538.8188,0.0060,3.3410,3.3133,3.3232,3.3421,3.3415,3.3410,3.3133,0.3217,2.5545,-0.2644,0.0058,2.8808,29.7207,24.8624,24.8624,22.7113,-0.0139,5.7880,9.0937,16.8718,9.0937,301.8114,10.5151,4.7643,3.4882,131.0494,98.4017,79.8358,2.7581,3.8479,13.1371,3.4141,1.3951,4.7631,1.6000
 1934.0000,2521.6699,0.0062,3.3542,3.3257,3.3366,3.3568,3.3548,3.3542,3.3257,0.3210,2.5820,-0.2552,-0.1516,3.0963,30.3428,25.4835,25.4835,23.2909,-0.0137,4.1190,7.4832,15.3991,7.4832,300.6865,10.5125,5.3023,3.4866,128.0043,98.6956,79.7851,2.7593,3.8985,13.1145,3.3640,1.4128,4.7528,5.6000
 1934.5000,2557.8787,0.0071,3.3429,3.3105,3.3227,3.3441,3.3414,3.3429,3.3105,0.3212,2.5967,-0.1990,-0.0782,3.1420,29.5668,24.7091,24.7091,22.5680,-0.0043,3.2290,6.6245,14.6139,6.6245,302.0690,10.5229,5.4972,3.4768,127.0538,101.1966,81.3344,2.8231,4.0603,13.3209,3.2808,1.4383,4.7186,2.0000
 1935.0000,2542.0198,0.0075,3.3088,3.2748,3.2883,3.3109,3.3081,3.3088,3.2748,0.3214,2.5888,-0.1603,0.1027,2.9776,29.5194,24.6620,24.6620,22.5240,0.0061,3.7085,7.0871,15.0369,7.0871,305.3619,10.5478,5.1737,3.2591,130.3669,103.3735,82.8762,2.8827,4.1856,13.5446,3.2360,1.4520,4.6986,0.8000
 1935.5000,2550.9338,0.0078,3.2769,3.2415,3.2564,3.2803,3.2779,3.2769,3.2415,0.3204,2.5807,0.1406,0.1742,2.8168,29.9353,25.0765,25.0765,22.9111,0.0133,4.1996,7.5610,15.4702,7.5610,308.4950,10.5532,5.4953,3.4126,131.7239,105.7140,84.3614,2.9455,4.3486,13.7340,3.1583,1.4763,4.6626,4.0000
 1936.0000,2577.5830,0.0087,3.2725,3.2334,3.2496,3.2749,3.2735,3.2725,3.2334,0.3208,2.5728,0.4744,0.2237,2.7518,31.4737,26.6180,26.6180,24.3477,0.0178,4.6818,8.0262,15.8957,8.0263,309.2717,10.5699,4.1786,2.5875,131.5865,106.8852,85.0255,2.9749,4.4505,13.8130,3.1037,1.4960,4.6432,1.6000
 1936.5000,2568.7847,0.0099,3.2844,3.2397,3.2572,3.2837,3.2841,3.2844,3.2397,0.3210,2.5594,0.2770,0.0128,2.7706,32.0993,27.2486,27.2486,24.9340,0.0168,5.4928,8.8088,16.6113,8.8088,308.6750,10.5873