"""
Defines some default values.

:copyright: 2021 Agile Scientific
:license: Apache 2.0
"""

# This is an expanded version of CRAIN (below),
# with additions by Thomas Martin.
ALIAS = {'CAL': [ 'HHCA',
                  'SA',
                  'HCALX',
                  'DCAL',
                  'CLXC',
                  'CAX',
                  'CAPD',
                  'CANC',
                  'CALZ',
                  'CALX',
                  'CALI',
                  'CAL1',
                  'CAL',
                  'CADF',
                  'CADE',
                  'CA2',
                  'CA1',
                  'C13Z',
                  'C13P',
                  'C13M',
                  'C13L',
                  'C13I',
                  'C13H',
                  'C13-A',
                  'C13A',
                  'C13',
                  'ACAL',
                  'C1',
                  'C2',
                  'C24',
                  'C24A',
                  'C24-A',
                  'C24H',
                  'C24I',
                  'C24L',
                  'C24M',
                  'C24P',
                  'C24Z',
                  'CA',
                  'CAL2',
                  'CAL3',
                  'CALA',
                  'CAL-A',
                  'CALD',
                  'CALE',
                  'CALH',
                  'CALI_SPCS',
                  'CALL',
                  'CALM',
                  'CALN',
                  'CALP',
                  'CALS',
                  'CALT',
                  'CALX-A',
                  'CALXH',
                  'CALXM',
                  'CALX-ML',
                  'CALXQ8',
                  'CALXQH',
                  'CALX-R',
                  'CALY',
                  'CALY-A',
                  'CALYH',
                  'CALYM',
                  'CALY-ML',
                  'CALYQ8',
                  'CALYQH',
                  'CAY',
                  'CLCM',
                  'CLDC',
                  'CLDM',
                  'CLLO',
                  'CLTC',
                  'CLYC',
                  'CQLI',
                  'HCAL',
                  'HCAL2',
                  'HCALI',
                  'HCALY',
                  'HD',
                  'HD_1',
                  'HD1',
                  'HD2',
                  'HD3',
                  'HDAR',
                  'HDIA',
                  'HDMI',
                  'HDMN',
                  'HDMX',
                  'HLCA',
                  'LCAL',
                  'MCAL',
                  'MLTC',
                  'TAC2',
                  'C3',
                  'CLS2',
                  'MBTC',
                  'TACC',
                  'DCAV',
                  'CALCFM',
                  'CALI_WL',
                  'CALI_LWD',
                  'APPC'],
                 'DENS': ['RHOB',
                   'RHO8',
                   'DEN',
                   'DENS',
                   'ZDEN',
                   'ZDNC',
                   'RHOM',       
                   'RHOZ'],
                 'DCOR': ['Z-COR',
                  'HHDR',
                  'ZCORQH',
                  'ZCOR2QH',
                  'ZCOR2',
                  'ZCOR',
                  'RPCL_DCOR',
                  'HHDRA',
                  'HDRH',
                  'HDRA',
                  'HBDC',
                  'DRHO',
                  'DRH',
                  'DECR',
                  'DCOR',
                  'DC',
                  'DENC',        
                  '2DRH'],
                 'DT': ['AC1',
                  'TTC',
                  'DTP',
                  'DTMX',
                  'DTMN',
                  'DTLF',
                  'DTL',
                  'DTCO',
                  'DTCM',
                  'DTC2',
                  'DTC',
                  'DT4P_C',
                  'DT4P',
                  'DT41',
                  'DT',
                  'AC',
                  'ACCO',
                  'ACL',
                  'ACN',
                  'DT24',
                  'DT24-A',
                  'DT24AQI',
                  'DT24QI',
                  'DT24SQA',
                  'DT34',
                  'DT35',
                  'DT5',
                  'DTC1',
                  'DTCA',
                  'DTCR',
                  'DTCX',
                  'DTSC',
                  'MSTT'],
                 'DTS': ['TTS', 'SHSL', 'DTSF', 'DTSD', 'DTS', 'DT4S', 'D4S', 'DTSS'],
                 'GR': ['HEHG',
                  'GRS',
                  'HGR-5A',
                  'HGR-1A',
                  'HGR_STGC',
                  'HGR',
                  'HCGR',
                  'GRQH',
                  'GRNP',
                  'GRNC',
                  'GRN',
                  'GRGM',
                  'GRGC',
                  'GRDI',
                  'GRDE',
                  'GRCO',
                  'GRC',
                  'GR-A',
                  'GR_ARC_FILT',
                  'GGCE',
                  'EHGR',
                  'ECGR',
                  'CGR',
                  'G',
                  'GAB',
                  'GAM',
                  'GAM1',
                  'GAPI',
                  'GR',
                  'GR_AR',
                  'GR_STGC',
                  'GR1',
                  'GR-1A',
                  'GR2',
                  'GR-5A',
                  'GRA',
                  'GRDA',
                  'GRG',
                  'GRGS',
                  'GRH',
                  'GRHD',
                  'GRI',
                  'GR-I',
                  'GRLL',
                  'GRML',
                  'GR-ML',
                  'GRP',
                  'GRPD',
                  'GRR',
                  'GR-R',
                  'GRSD',
                  'GRSL',
                  'GRZ',
                  'GRZD',
                  'HHGR',
                  'HSGR',
                  'MGR',
                  'P01LGR',
                  'P02LGR',
                  'P03LGR',
                  'RGR',
                  'SGR',
                  'SGRD',
                  'GCPS',
                  'GR_WL',
                  'GR_LWD',      
                  'GRM1'],
                 'PE': ['LPE',
                  'PEFL',
                  'PEFL',
                  'PEFI',
                  'PEFI',
                  'HPEF',
                  'HPEF',
                  'SPEF',
                  'PEQH',
                  'PEFZ',
                  'PEFSA',
                  'PEFA',
                  'PEF8',
                  'PEF_SLDT_HR',
                  'PEF_SLDT',
                  'PEF',
                  'PEDN',
                  'PEDF',
                  'PE2QH',
                  'PE2',
                  'PE',
                  'PDPE',
                  'HPEF8',
                  'HPEDN',
                  '2PEF',
                  'PEFS',
                  'PEF_',
                  'DPEFM',
                  'SNPE'],
                 'PHID': ['PHID',
                  '2DPS',
                  'APSC',
                  'APSU',
                  'DDPP',
                  'DEPO',
                  'DNPH',
                  'DPH8',
                  'DPHI',
                  'DPHI_',
                  'DPHI_SAN',
                  'DPHI_SLDT',
                  'DPHI_SLDT_HR',
                  'DPHIS',
                  'DPHS',
                  'DPHZ',
                  'DPHZSS',
                  'DPO',
                  'DPOR',
                  'DPRS',
                  'DPS8',
                  'DPSS',
                  'DPSZ',
                  'HDPH',
                  'HDPH_SAN',
                  'HDPH8',
                  'HDPHI',
                  'HDPO',
                  'HDPSS',
                  'HFSC',
                  'NDPH',
                  'PDS',
                  'POD',
                  'POR',
                  'PORS',
                  'PORZ',
                  'PORZ2QH',
                  'PORZQH',
                  'PORZS2',
                  'PORZS2QH',
                  'PORZSS',
                  'PORZSS2',
                  'PORZSSQH',
                  'PXND',
                  'PZCSS',
                  'PZCSSQH',
                  'PZCSSS',
                  'PZSS',
                  'PZSS2',
                  'PZSS2QH',
                  'PZSSQH',
                  'PZSSS',
                  'RPSS',
                  'SSD',
                  'DPH',
                  'DPS1'],
                 'PHIN': ['PHIN',
                  'NEUT',        
                  'NPHI_S',
                  'HNPH',
                  'TNPH_SAN1',
                  'TNPH_SAN',
                  'POS',
                  'NPSS_C',
                  'NPSS',
                  'NPRS',
                  'NPORSS',
                  'NPOR_SAN',
                  'NPHS',
                  'NPHIS',
                  'NPHI_SAN',
                  'HTNP_SAN',
                  'HNPSS',
                  'HNPS',
                  'HNPO_SAN',
                  'HASC',
                  'CNSS',
                  'CNCSSQH',
                  'CNCSS',
                  'CNCSGS',
                  'CNCS',
                  'CN',
                  'CNC',
                  'FNPS',
                  'FPSC',
                  'HHNPO',
                  'HNPHI',
                  'HNPO',
                  'HTNP',
                  'NCN',
                  'NCNL',
                  'NPHI',
                  'NPOR',
                  'NPOR_',
                  'NPOR_1',
                  'PRON',
                  'QNP-1A',
                  'QNP-5A',
                  'RPOR',
                  'SNP',
                  'TNPH',
                  'ENPH',
                  'SPLE'],
                 'PHIS': ['ACPD', 'ACPL', 'ACPS', 'PORA', 'RPHI', 'SPHI', 'PHIS', 'SPSS', 'TPHI'],
                 'POTA': ['KCPS', 'HPOT', 'POTA', 'K'],
                 'RESD': ['RESD',
                  'RDEP',        
                  'RT_H',
                  'RLLD',
                  'HATR',
                  'HAT9',
                  'ASTR',
                  'AST9',
                  'AS90',
                  'AIT9',
                  'AHTR',
                  'AHT9',
                  'ID40',
                  'VRSD',
                  'VP65',
                  'RT_HRLT',
                  'RT',
                  'RLA3',
                  'M4RX',
                  'M1RX',
                  'M0RX',
                  'ILD2',
                  'IDVR',
                  'IDPH',
                  'HRLD',
                  'FE2',
                  'DVR2',
                  'DIPH',
                  'ATRT',
                  'AT90',
                  'AST90',
                  'AIT90',
                  'AIT120',
                  'AHTRT',
                  'A22H',
                  'A22H_',
                  'A22H_UNC',
                  'A28H',
                  'A28H_',
                  'A28H_UNC',
                  'A34H',
                  'A34H_',
                  'A34H_UNC',
                  'AF60',
                  'AF90',
                  'AFRT',
                  'AHF60',
                  'AHF90',
                  'AHO60',
                  'AHO90',
                  'AHT60',
                  'AHT90',
                  'AILD',
                  'AIT',
                  'AIT60',
                  'AO12',
                  'AO60',
                  'AO90',
                  'AORT',
                  'ASF60',
                  'ASF90',
                  'ASO60',
                  'ASO90',
                  'AST60',
                  'AT60',
                  'DVR1',
                  'DVR4',
                  'GRD',
                  'HILD',
                  'HLLD',
                  'HRL4',
                  'HRL5',
                  'IDER',
                  'IL',
                  'ILD',
                  'ILD4',
                  'LL',
                  'LL3',
                  'LL7',
                  'LLD',
                  'LN',
                  'M0R6',
                  'M0R9',
                  'M1R6',
                  'M1R9',
                  'M2R6',
                  'M2R9',
                  'M2RX',
                  'M4R6',
                  'M4R9',
                  'P10H',
                  'P10H_',
                  'P10H_UNC',
                  'P16H',
                  'P16H_',
                  'P16H_UNC',
                  'P22H',
                  'P22H_',
                  'P22H_UNC',
                  'P28H',
                  'P28H_',
                  'P28H_UNC',
                  'P34H',
                  'P34H_',
                  'P34H_UNC',
                  'P40H',       
                  'RFOC',
                  'RILD',
                  'RIPD',
                  'RLA1',
                  'RLA2',
                  'RLA4',
                  'RLA5',
                  'RLL3',
                  'RLL4',
                  'RLL5',
                  'VILD',
                  'AIT6',
                  'DDLL',
                  'EIRD',
                  'ID10',
                  'ID20',
                  'ID25',
                  'ILD1',
                  'LLG',
                  'REID',
                  'RLL',
                  'AHF6',
                  'AHF9',
                  'AHO6',
                  'AHO9',
                  'AHOR',
                  'AHT6',
                  'AS60',
                  'ASF6',
                  'ASF9',
                  'ASFR',
                  'ASRT',
                  'AST6',
                  'RLA5',        
                  'HAT6'],
                 'RESM': ['RESM',
                  'RMED',        
                  'SEWP',
                  'RLLS',
                  'HAT3',
                  'AST3',
                  'AS30',
                  'AHT3',
                  'VP25',
                  'RIPM',
                  'RILM',
                  'MVR2',
                  'M4R3',
                  'M2R3',
                  'M1R3',
                  'M0R3',
                  'IMVR',
                  'IMPH',
                  'IMER',
                  'IM',
                  'ILM2',
                  'ILM',
                  'HRL3',
                  'HLLS',
                  'HILM',
                  'AT30',
                  'AST30',
                  'AIT30',
                  'AHT30',
                  'AF30',
                  'AHF30',
                  'AHO30',
                  'AO30',
                  'ASF30',
                  'ASO30',
                  'ILM4',
                  'LLS',
                  'MVR1',
                  'MVR4',
                  'VILM',
                  'AE60',
                  'ILD25',
                  'ILM1',
                  'ILM25',
                  'IM10',
                  'IM20',
                  'IM25',
                  'IM40',
                  'PIRM',
                  'REIM',
                  'DSLL',
                  'AIT3',
                  'AHF3',
                  'AHO3',
                  'ASF3',
                  'RLA4',
                  'RLA3',
                  'RLA2',        
                  'RMLL'],
                 'RESS': ['RESS',
                  'RSHAL',
                  'RXOH',
                  'MSFF',
                  'HSFL',
                  'HAT1',
                  'AST1',
                  'AS10',
                  'AHT1',
                  'RXOZ',
                  'RXOI',
                  'RXO8',
                  'RXO1D',
                  'RXO_HRLT',
                  'RXO',
                  'RLL1',
                  'RESS',
                  'HRL1',
                  'ATRX',
                  'AHTRX',
                  'AF10',
                  'AF20',
                  'AFRX',
                  'AHF10',
                  'AHF20',
                  'AHO10',
                  'AHO20',
                  'AHSFI',
                  'AHT10',
                  'AHT20',
                  'AIT10',
                  'AIT20',
                  'AO10',
                  'AO20',
                  'AORX',
                  'ASF10',
                  'ASF20',
                  'ASFI',
                  'ASFL',
                  'ASN',
                  'ASO10',
                  'ASO20',
                  'AST10',
                  'AST20',
                  'AT10',
                  'AT12',
                  'AT20',
                  'FE1',
                  'FEFE',
                  'FR',
                  'FRA',
                  'HRL2',
                  'HRLS',
                  'HSFLU',
                  'ILS',
                  'LL8',
                  'LLA',
                  'M0R1',
                  'M0R2',
                  'M1R1',
                  'M1R2',
                  'M2R1',
                  'M2R2',
                  'M4R1',
                  'M4R2',
                  'MFR',
                  'MLL',
                  'MSFL',
                  'PSHG',
                  'RES',
                  'RILS',
                  'RLL2',
                  'RS',
                  'RSFE',
                  'RSFL',
                  'RSG',
                  'SFBC',
                  'SFL',
                  'SFL4',
                  'SFLA',
                  'SFLR',
                  'SFLU',
                  'SN',
                  'AE20',
                  'AE30',
                  'AHF1',
                  'AHF2',
                  'AHO1',
                  'AHO2',
                  'AHT2',
                  'AS20',
                  'ASF1',
                  'ASF2',
                  'ASRX',
                  'AST2',
                  'HAT2'],
                 'SP': ['SP_S',
                  'AHSF',
                  'SPSB',
                  'SPH',
                  'SPDH',
                  'SP',
                  'HSP',
                  'PCH1',
                  'SPBR',
                  'SPC',
                  'SPCG',
                  'SPD',
                  'SPDF',
                  'SPP',
                  'SSPK',
                  'SPS',
                  'AHSC',
                  'SPA_'],
                 'THOR': ['TCPS', 'THOR', 'HTHO', 'TH'],
                 'URAN': ['UZ', 'UCPS', 'URAN', 'U', 'HURA'],
        }

# Originally from E Ross Crain's website:
# https://www.spec2000.net/05-logaliastable.htm
CRAIN = {'CAL': [ 'HHCA',
                  'SA',
                  'HCALX',
                  'DCAL',
                  'CLXC',
                  'CAX',
                  'CAPD',
                  'CANC',
                  'CALZ',
                  'CALX',
                  'CALI',
                  'CAL1',
                  'CAL',
                  'CADF',
                  'CADE',
                  'CA2',
                  'CA1',
                  'C13Z',
                  'C13P',
                  'C13M',
                  'C13L',
                  'C13I',
                  'C13H',
                  'C13-A',
                  'C13A',
                  'C13',
                  'ACAL',
                  'C1',
                  'C2',
                  'C24',
                  'C24A',
                  'C24-A',
                  'C24H',
                  'C24I',
                  'C24L',
                  'C24M',
                  'C24P',
                  'C24Z',
                  'CA',
                  'CAL2',
                  'CAL3',
                  'CALA',
                  'CAL-A',
                  'CALD',
                  'CALE',
                  'CALH',
                  'CALI_SPCS',
                  'CALL',
                  'CALM',
                  'CALN',
                  'CALP',
                  'CALS',
                  'CALT',
                  'CALX-A',
                  'CALXH',
                  'CALXM',
                  'CALX-ML',
                  'CALXQ8',
                  'CALXQH',
                  'CALX-R',
                  'CALY',
                  'CALY-A',
                  'CALYH',
                  'CALYM',
                  'CALY-ML',
                  'CALYQ8',
                  'CALYQH',
                  'CAY',
                  'CLCM',
                  'CLDC',
                  'CLDM',
                  'CLLO',
                  'CLTC',
                  'CLYC',
                  'CQLI',
                  'HCAL',
                  'HCAL2',
                  'HCALI',
                  'HCALY',
                  'HD',
                  'HD_1',
                  'HD1',
                  'HD2',
                  'HD3',
                  'HDAR',
                  'HDIA',
                  'HDMI',
                  'HDMN',
                  'HDMX',
                  'HLCA',
                  'LCAL',
                  'MCAL',
                  'MLTC',
                  'TAC2',
                  'C3',
                  'CLS2',
                  'MBTC',
                  'TACC',
                  'DCAV',
                  'APPC'],
                 'DENS': ['RHOB',
                   'RHO8',
                   'DEN',
                   'DENS',
                   'ZDEN',
                   'RHOZ'],
                 'DCOR': ['Z-COR',
                  'HHDR',
                  'ZCORQH',
                  'ZCOR2QH',
                  'ZCOR2',
                  'ZCOR',
                  'RPCL_DCOR',
                  'HHDRA',
                  'HDRH',
                  'HDRA',
                  'HBDC',
                  'DRHO',
                  'DRH',
                  'DECR',
                  'DCOR',
                  'DC',
                  '2DRH'],
                 'DT': ['AC1',
                  'TTC',
                  'DTP',
                  'DTMX',
                  'DTMN',
                  'DTLF',
                  'DTL',
                  'DTCO',
                  'DTCM',
                  'DTC2',
                  'DTC',
                  'DT4P_C',
                  'DT4P',
                  'DT41',
                  'DT',
                  'AC',
                  'ACCO',
                  'ACL',
                  'ACN',
                  'DT24',
                  'DT24-A',
                  'DT24AQI',
                  'DT24QI',
                  'DT24SQA',
                  'DT34',
                  'DT35',
                  'DT5',
                  'DTC1',
                  'DTCA',
                  'DTCR',
                  'DTCX',
                  'DTSC',
                  'MSTT'],
                 'DTS': ['TTS', 'SHSL', 'DTSF', 'DTSD', 'DTS', 'DT4S', 'D4S', 'DTSS'],
                 'GR': ['HEHG',
                  'GRS',
                  'HGR-5A',
                  'HGR-1A',
                  'HGR_STGC',
                  'HGR',
                  'HCGR',
                  'GRQH',
                  'GRNP',
                  'GRNC',
                  'GRN',
                  'GRGM',
                  'GRGC',
                  'GRDI',
                  'GRDE',
                  'GRCO',
                  'GRC',
                  'GR-A',
                  'GR_ARC_FILT',
                  'GGCE',
                  'EHGR',
                  'ECGR',
                  'CGR',
                  'G',
                  'GAB',
                  'GAM',
                  'GAM1',
                  'GAPI',
                  'GR',
                  'GR_AR',
                  'GR_STGC',
                  'GR1',
                  'GR-1A',
                  'GR2',
                  'GR-5A',
                  'GRA',
                  'GRDA',
                  'GRG',
                  'GRGS',
                  'GRH',
                  'GRHD',
                  'GRI',
                  'GR-I',
                  'GRLL',
                  'GRML',
                  'GR-ML',
                  'GRP',
                  'GRPD',
                  'GRR',
                  'GR-R',
                  'GRSD',
                  'GRSL',
                  'GRZ',
                  'GRZD',
                  'HHGR',
                  'HSGR',
                  'MGR',
                  'P01LGR',
                  'P02LGR',
                  'P03LGR',
                  'RGR',
                  'SGR',
                  'SGRD',
                  'GCPS',
                  'GRM1'],
                 'PE': ['LPE',
                  'PEFL',
                  'PEFL',
                  'PEFI',
                  'PEFI',
                  'HPEF',
                  'HPEF',
                  'SPEF',
                  'PEQH',
                  'PEFZ',
                  'PEFSA',
                  'PEFA',
                  'PEF8',
                  'PEF_SLDT_HR',
                  'PEF_SLDT',
                  'PEF',
                  'PEDN',
                  'PEDF',
                  'PE2QH',
                  'PE2',
                  'PE',
                  'PDPE',
                  'HPEF8',
                  'HPEDN',
                  '2PEF',
                  'PEFS',
                  'PEF_',
                  'SNPE'],
                 'PHID': ['PHID',
                  '2DPS',
                  'APSC',
                  'APSU',
                  'DDPP',
                  'DEPO',
                  'DNPH',
                  'DPH8',
                  'DPHI',
                  'DPHI_',
                  'DPHI_SAN',
                  'DPHI_SLDT',
                  'DPHI_SLDT_HR',
                  'DPHIS',
                  'DPHS',
                  'DPHZ',
                  'DPHZSS',
                  'DPO',
                  'DPOR',
                  'DPRS',
                  'DPS8',
                  'DPSS',
                  'DPSZ',
                  'HDPH',
                  'HDPH_SAN',
                  'HDPH8',
                  'HDPHI',
                  'HDPO',
                  'HDPSS',
                  'HFSC',
                  'NDPH',
                  'PDS',
                  'POD',
                  'POR',
                  'PORS',
                  'PORZ',
                  'PORZ2QH',
                  'PORZQH',
                  'PORZS2',
                  'PORZS2QH',
                  'PORZSS',
                  'PORZSS2',
                  'PORZSSQH',
                  'PXND',
                  'PZCSS',
                  'PZCSSQH',
                  'PZCSSS',
                  'PZSS',
                  'PZSS2',
                  'PZSS2QH',
                  'PZSSQH',
                  'PZSSS',
                  'RPSS',
                  'SSD',
                  'DPH',
                  'DPS1'],
                 'PHIN': ['PHIN',
                  'NPHI_S',
                  'HNPH',
                  'TNPH_SAN1',
                  'TNPH_SAN',
                  'POS',
                  'NPSS_C',
                  'NPSS',
                  'NPRS',
                  'NPORSS',
                  'NPOR_SAN',
                  'NPHS',
                  'NPHIS',
                  'NPHI_SAN',
                  'HTNP_SAN',
                  'HNPSS',
                  'HNPS',
                  'HNPO_SAN',
                  'HASC',
                  'CNSS',
                  'CNCSSQH',
                  'CNCSS',
                  'CNCSGS',
                  'CNCS',
                  'CN',
                  'CNC',
                  'FNPS',
                  'FPSC',
                  'HHNPO',
                  'HNPHI',
                  'HNPO',
                  'HTNP',
                  'NCN',
                  'NCNL',
                  'NPHI',
                  'NPOR',
                  'NPOR_',
                  'NPOR_1',
                  'PRON',
                  'QNP-1A',
                  'QNP-5A',
                  'RPOR',
                  'SNP',
                  'TNPH',
                  'ENPH',
                  'SPLE'],
                 'PHIS': ['ACPD', 'ACPL', 'ACPS', 'PORA', 'RPHI', 'SPHI', 'SPSS', 'TPHI'],
                 'POTA': ['KCPS', 'HPOT', 'POTA', 'K'],
                 'RESD': ['RESD',
                  'RT_H',
                  'RLLD',
                  'HATR',
                  'HAT9',
                  'ASTR',
                  'AST9',
                  'AS90',
                  'AIT9',
                  'AHTR',
                  'AHT9',
                  'ID40',
                  'VRSD',
                  'VP65',
                  'RT_HRLT',
                  'RT',
                  'RLA3',
                  'M4RX',
                  'M1RX',
                  'M0RX',
                  'ILD2',
                  'IDVR',
                  'IDPH',
                  'HRLD',
                  'FE2',
                  'DVR2',
                  'DIPH',
                  'ATRT',
                  'AT90',
                  'AST90',
                  'AIT90',
                  'AIT120',
                  'AHTRT',
                  'A22H',
                  'A22H_',
                  'A22H_UNC',
                  'A28H',
                  'A28H_',
                  'A28H_UNC',
                  'A34H',
                  'A34H_',
                  'A34H_UNC',
                  'AF60',
                  'AF90',
                  'AFRT',
                  'AHF60',
                  'AHF90',
                  'AHO60',
                  'AHO90',
                  'AHT60',
                  'AHT90',
                  'AILD',
                  'AIT',
                  'AIT60',
                  'AO12',
                  'AO60',
                  'AO90',
                  'AORT',
                  'ASF60',
                  'ASF90',
                  'ASO60',
                  'ASO90',
                  'AST60',
                  'AT60',
                  'DVR1',
                  'DVR4',
                  'GRD',
                  'HILD',
                  'HLLD',
                  'HRL4',
                  'HRL5',
                  'IDER',
                  'IL',
                  'ILD',
                  'ILD4',
                  'LL',
                  'LL3',
                  'LL7',
                  'LLD',
                  'LN',
                  'M0R6',
                  'M0R9',
                  'M1R6',
                  'M1R9',
                  'M2R6',
                  'M2R9',
                  'M2RX',
                  'M4R6',
                  'M4R9',
                  'P10H',
                  'P10H_',
                  'P10H_UNC',
                  'P16H',
                  'P16H_',
                  'P16H_UNC',
                  'P22H',
                  'P22H_',
                  'P22H_UNC',
                  'P28H',
                  'P28H_',
                  'P28H_UNC',
                  'P34H',
                  'P34H_',
                  'P34H_UNC',
                  'RFOC',
                  'RILD',
                  'RIPD',
                  'RLA1',
                  'RLA2',
                  'RLA4',
                  'RLA5',
                  'RLL3',
                  'RLL4',
                  'RLL5',
                  'VILD',
                  'AIT6',
                  'DDLL',
                  'EIRD',
                  'ID10',
                  'ID20',
                  'ID25',
                  'ILD1',
                  'LLG',
                  'REID',
                  'RLL',
                  'AHF6',
                  'AHF9',
                  'AHO6',
                  'AHO9',
                  'AHOR',
                  'AHT6',
                  'AS60',
                  'ASF6',
                  'ASF9',
                  'ASFR',
                  'ASRT',
                  'AST6',
                  'HAT6'],
                 'RESM': ['RESM',
                  'RLLS',
                  'HAT3',
                  'AST3',
                  'AS30',
                  'AHT3',
                  'VP25',
                  'RIPM',
                  'RILM',
                  'MVR2',
                  'M4R3',
                  'M2R3',
                  'M1R3',
                  'M0R3',
                  'IMVR',
                  'IMPH',
                  'IMER',
                  'IM',
                  'ILM2',
                  'ILM',
                  'HRL3',
                  'HLLS',
                  'HILM',
                  'AT30',
                  'AST30',
                  'AIT30',
                  'AHT30',
                  'AF30',
                  'AHF30',
                  'AHO30',
                  'AO30',
                  'ASF30',
                  'ASO30',
                  'ILM4',
                  'LLS',
                  'MVR1',
                  'MVR4',
                  'VILM',
                  'AE60',
                  'ILD25',
                  'ILM1',
                  'ILM25',
                  'IM10',
                  'IM20',
                  'IM25',
                  'IM40',
                  'PIRM',
                  'REIM',
                  'DSLL',
                  'AIT3',
                  'AHF3',
                  'AHO3',
                  'ASF3',
                  'RMLL'],
                 'RESS': ['RESS',
                  'RXOH',
                  'MSFF',
                  'HSFL',
                  'HAT1',
                  'AST1',
                  'AS10',
                  'AHT1',
                  'RXOZ',
                  'RXOI',
                  'RXO8',
                  'RXO1D',
                  'RXO_HRLT',
                  'RXO',
                  'RLL1',
                  'RESS',
                  'HRL1',
                  'ATRX',
                  'AHTRX',
                  'AF10',
                  'AF20',
                  'AFRX',
                  'AHF10',
                  'AHF20',
                  'AHO10',
                  'AHO20',
                  'AHSFI',
                  'AHT10',
                  'AHT20',
                  'AIT10',
                  'AIT20',
                  'AO10',
                  'AO20',
                  'AORX',
                  'ASF10',
                  'ASF20',
                  'ASFI',
                  'ASFL',
                  'ASN',
                  'ASO10',
                  'ASO20',
                  'AST10',
                  'AST20',
                  'AT10',
                  'AT12',
                  'AT20',
                  'FE1',
                  'FEFE',
                  'FR',
                  'FRA',
                  'HRL2',
                  'HRLS',
                  'HSFLU',
                  'ILS',
                  'LL8',
                  'LLA',
                  'M0R1',
                  'M0R2',
                  'M1R1',
                  'M1R2',
                  'M2R1',
                  'M2R2',
                  'M4R1',
                  'M4R2',
                  'MFR',
                  'MLL',
                  'MSFL',
                  'PSHG',
                  'RES',
                  'RILS',
                  'RLL2',
                  'RS',
                  'RSFE',
                  'RSFL',
                  'RSG',
                  'SFBC',
                  'SFL',
                  'SFL4',
                  'SFLA',
                  'SFLR',
                  'SFLU',
                  'SN',
                  'AE20',
                  'AE30',
                  'AHF1',
                  'AHF2',
                  'AHO1',
                  'AHO2',
                  'AHT2',
                  'AS20',
                  'ASF1',
                  'ASF2',
                  'ASRX',
                  'AST2',
                  'HAT2'],
                 'SP': ['SP_S',
                  'AHSF',
                  'SPSB',
                  'SPH',
                  'SPDH',
                  'SP',
                  'HSP',
                  'PCH1',
                  'SPBR',
                  'SPC',
                  'SPCG',
                  'SPD',
                  'SPDF',
                  'SPP',
                  'SSPK',
                  'SPS',
                  'AHSC',
                  'SPA_'],
                 'THOR': ['TCPS', 'THOR', 'HTHO', 'TH'],
                 'URAN': ['UZ', 'UCPS', 'URAN', 'U', 'HURA'],
        }
