import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type AWSQS::CheckPoint::CloudGuardQS::MODULE.
 *
 * @schema CfnModuleProps
 */
export interface CfnModuleProps {
    /**
     * @schema CfnModuleProps#Parameters
     */
    readonly parameters?: CfnModulePropsParameters;
    /**
     * @schema CfnModuleProps#Resources
     */
    readonly resources?: CfnModulePropsResources;
}
/**
 * Converts an object of type 'CfnModuleProps' to JSON representation.
 */
export declare function toJson_CfnModuleProps(obj: CfnModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsParameters
 */
export interface CfnModulePropsParameters {
    /**
     * List of Availability Zones (AZs) to use for the subnets in the VPC.
     *
     * Select at least two
     *
     * @schema CfnModulePropsParameters#AvailabilityZones
     */
    readonly availabilityZones?: CfnModulePropsParametersAvailabilityZones;
    /**
     * Number of Availability Zones to use in the VPC.
     *
     * This must match your selections in the list of Availability Zones parameter.  Default: 2
     *
     * @schema CfnModulePropsParameters#NumberOfAZs
     */
    readonly numberOfAZs?: CfnModulePropsParametersNumberOfAZs;
    /**
     * CIDR block for the VPC.
     *
     * Default: 10.0.0.0/16
     *
     * @schema CfnModulePropsParameters#VPCCIDR
     */
    readonly vpccidr?: CfnModulePropsParametersVpccidr;
    /**
     * CIDR block for public subnet 1 located in the 1st Availability Zone.
     *
     * If you choose to deploy a Security Management Server it will be deployed in this subnet. Default: 10.0.10.0/24
     *
     * @schema CfnModulePropsParameters#PublicSubnet1CIDR
     */
    readonly publicSubnet1Cidr?: CfnModulePropsParametersPublicSubnet1Cidr;
    /**
     * CIDR block for public subnet 2 located in the 2nd Availability Zone.
     *
     * Default: 10.0.20.0/24
     *
     * @schema CfnModulePropsParameters#PublicSubnet2CIDR
     */
    readonly publicSubnet2Cidr?: CfnModulePropsParametersPublicSubnet2Cidr;
    /**
     * CIDR block for public subnet 3 located in the 3rd Availability Zone.
     *
     * Default: 10.0.30.0/24
     *
     * @schema CfnModulePropsParameters#PublicSubnet3CIDR
     */
    readonly publicSubnet3Cidr?: CfnModulePropsParametersPublicSubnet3Cidr;
    /**
     * CIDR block for public subnet 4 located in the 4th Availability Zone.
     *
     * Default: 10.0.40.0/24
     *
     * @schema CfnModulePropsParameters#PublicSubnet4CIDR
     */
    readonly publicSubnet4Cidr?: CfnModulePropsParametersPublicSubnet4Cidr;
    /**
     * CIDR block for private subnet 1 located in the 1st Availability Zone.
     *
     * Default: 10.0.11.0/24
     *
     * @schema CfnModulePropsParameters#PrivateSubnet1CIDR
     */
    readonly privateSubnet1Cidr?: CfnModulePropsParametersPrivateSubnet1Cidr;
    /**
     * CIDR block for private subnet 2 located in the 2nd Availability Zone.
     *
     * Default: 10.0.21.0/24
     *
     * @schema CfnModulePropsParameters#PrivateSubnet2CIDR
     */
    readonly privateSubnet2Cidr?: CfnModulePropsParametersPrivateSubnet2Cidr;
    /**
     * CIDR block for private subnet 3 located in the 3rd Availability Zone.
     *
     * Default: 10.0.31.0/24
     *
     * @schema CfnModulePropsParameters#PrivateSubnet3CIDR
     */
    readonly privateSubnet3Cidr?: CfnModulePropsParametersPrivateSubnet3Cidr;
    /**
     * CIDR block for private subnet 4 located in the 4th Availability Zone.
     *
     * Default: 10.0.41.0/24
     *
     * @schema CfnModulePropsParameters#PrivateSubnet4CIDR
     */
    readonly privateSubnet4Cidr?: CfnModulePropsParametersPrivateSubnet4Cidr;
    /**
     * The EC2 Key Pair to allow SSH access to the instances.
     *
     * For more detail visit: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
     *
     * @schema CfnModulePropsParameters#KeyName
     */
    readonly keyName?: CfnModulePropsParametersKeyName;
    /**
     * Encrypt Environment instances volume with default AWS KMS key.
     *
     * Default: true
     *
     * @schema CfnModulePropsParameters#EnableVolumeEncryption
     */
    readonly enableVolumeEncryption?: CfnModulePropsParametersEnableVolumeEncryption;
    /**
     * Enable SSH connection over AWS web console.
     *
     * Default: false
     *
     * @schema CfnModulePropsParameters#EnableInstanceConnect
     */
    readonly enableInstanceConnect?: CfnModulePropsParametersEnableInstanceConnect;
    /**
     * Automatically download Blade Contracts and other important data.
     *
     * Improve product experience by sending data to Check Point. Default: true
     *
     * @schema CfnModulePropsParameters#AllowUploadDownload
     */
    readonly allowUploadDownload?: CfnModulePropsParametersAllowUploadDownload;
    /**
     * The tag is used by the Security Management Server to automatically provision the Security Gateways.
     *
     * Must be up to 12 alphanumeric characters and unique for each Quick Start deployment. Default: quickstart
     *
     * @schema CfnModulePropsParameters#ProvisionTag
     */
    readonly provisionTag?: CfnModulePropsParametersProvisionTag;
    /**
     * Use Network Load Balancer if you wish to preserve the source IP address and Application Load Balancer if you wish to perform SSL Offloading.
     *
     * Default: Network Load Balancer. Allowed values: Network Load Balancer, Application Load Balancer
     *
     * @schema CfnModulePropsParameters#LoadBalancersType
     */
    readonly loadBalancersType?: CfnModulePropsParametersLoadBalancersType;
    /**
     * The protocol to use on the Application Load Balancer.
     *
     * If Network Load Balancer was selected this section will be ignored. Default: HTTP. Allowed values: HTTP, HTTPS
     *
     * @schema CfnModulePropsParameters#ALBProtocol
     */
    readonly albProtocol?: CfnModulePropsParametersAlbProtocol;
    /**
     * The protocol to use on the Network Load Balancer.
     *
     * If Application Load Balancer was selected this section will be ignored. Default: TCP. Allowed values: TCP, TLS, UDP, TCP_UDP
     *
     * @schema CfnModulePropsParameters#NLBProtocol
     */
    readonly nlbProtocol?: CfnModulePropsParametersNlbProtocol;
    /**
     * Amazon Resource Name (ARN) of an HTTPS Certificate, ignored if the selected protocol is HTTP (for the ALBProtocol parameter).
     *
     * @schema CfnModulePropsParameters#Certificate
     */
    readonly certificate?: CfnModulePropsParametersCertificate;
    /**
     * The external Load Balancer listens to this port.
     *
     * Leave this field blank to use default ports: 80 for HTTP and 443 for HTTPS
     *
     * @schema CfnModulePropsParameters#ServicePort
     */
    readonly servicePort?: CfnModulePropsParametersServicePort;
    /**
     * Notifications about scaling events will be sent to this email address (optional).
     *
     * @schema CfnModulePropsParameters#AdminEmail
     */
    readonly adminEmail?: CfnModulePropsParametersAdminEmail;
    /**
     * The EC2 instance type for the Security Gateways.
     *
     * Default: c5.xlarge. Allowed values: c5.xlarge, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.18xlarge, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge
     *
     * @schema CfnModulePropsParameters#GatewayInstanceType
     */
    readonly gatewayInstanceType?: CfnModulePropsParametersGatewayInstanceType;
    /**
     * The minimal number of Security Gateways.
     *
     * @schema CfnModulePropsParameters#GatewaysMinSize
     */
    readonly gatewaysMinSize?: CfnModulePropsParametersGatewaysMinSize;
    /**
     * The maximal number of Security Gateways.
     *
     * @schema CfnModulePropsParameters#GatewaysMaxSize
     */
    readonly gatewaysMaxSize?: CfnModulePropsParametersGatewaysMaxSize;
    /**
     * The version and license to install on the Security Gateways.
     *
     * Default: R80.40-PAYG-NGTP-GW. Allowed values: R80.40-BYOL-GW, R80.40-PAYG-NGTP-GW, R80.40-PAYG-NGTX-GW, R81-BYOL-GW, R81-PAYG-NGTP-GW, R81-PAYG-NGTX-GW
     *
     * @schema CfnModulePropsParameters#GatewayVersion
     */
    readonly gatewayVersion?: CfnModulePropsParametersGatewayVersion;
    /**
     * Admin user's password hash (use command "openssl passwd -1 PASSWORD" to get the PASSWORD's hash) (optional).
     *
     * @schema CfnModulePropsParameters#GatewayPasswordHash
     */
    readonly gatewayPasswordHash?: CfnModulePropsParametersGatewayPasswordHash;
    /**
     * The Secure Internal Communication key creates trusted connections between Check Point components.
     *
     * Choose a random string consisting of at least 8 alphanumeric characters.
     *
     * @schema CfnModulePropsParameters#GatewaySICKey
     */
    readonly gatewaySicKey?: CfnModulePropsParametersGatewaySicKey;
    /**
     * Report Check Point specific CloudWatch metrics.
     *
     * Default: false
     *
     * @schema CfnModulePropsParameters#CloudWatch
     */
    readonly cloudWatch?: CfnModulePropsParametersCloudWatch;
    /**
     * Select false to use an existing Security Management Server or to deploy one later and to ignore the other parameters of this section.
     *
     * Default: true
     *
     * @schema CfnModulePropsParameters#ManagementDeploy
     */
    readonly managementDeploy?: CfnModulePropsParametersManagementDeploy;
    /**
     * The EC2 instance type of the Security Management Server.
     *
     * Default: m5.xlarge. Allowed values: m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.12xlarge, m5.24xlarge
     *
     * @schema CfnModulePropsParameters#ManagementInstanceType
     */
    readonly managementInstanceType?: CfnModulePropsParametersManagementInstanceType;
    /**
     * The version and license to install on the Security Management Server.
     *
     * Default: R80.40-PAYG-MGMT. Allowed values: R80.40-BYOL-MGMT, R80.40-PAYG-MGMT, R81-BYOL-MGMT, R81-PAYG-MGMT
     *
     * @schema CfnModulePropsParameters#ManagementVersion
     */
    readonly managementVersion?: CfnModulePropsParametersManagementVersion;
    /**
     * Admin user's password hash (use command "openssl passwd -1 PASSWORD" to get the PASSWORD's hash) (optional).
     *
     * @schema CfnModulePropsParameters#ManagementPasswordHash
     */
    readonly managementPasswordHash?: CfnModulePropsParametersManagementPasswordHash;
    /**
     * The name of the Security Policy package to be installed on the gateways in the Security Gateways Auto Scaling group.
     *
     * Default: Standard
     *
     * @schema CfnModulePropsParameters#GatewaysPolicy
     */
    readonly gatewaysPolicy?: CfnModulePropsParametersGatewaysPolicy;
    /**
     * Turn on the Intrusion Prevention System, Application Control, Anti-Virus and Anti-Bot Blades (these and additional Blades can be manually turned on or off later).
     *
     * Default: true
     *
     * @schema CfnModulePropsParameters#GatewaysBlades
     */
    readonly gatewaysBlades?: CfnModulePropsParametersGatewaysBlades;
    /**
     * Allow web, SSH, and graphical clients only from this network to communicate with the Security Management Server.
     *
     * @schema CfnModulePropsParameters#AdminCIDR
     */
    readonly adminCidr?: CfnModulePropsParametersAdminCidr;
    /**
     * Allow gateways only from this network to communicate with the Security Management Server.
     *
     * @schema CfnModulePropsParameters#GatewaysAddresses
     */
    readonly gatewaysAddresses?: CfnModulePropsParametersGatewaysAddresses;
    /**
     * Select true to deploy web servers and an internal Application Load Balancer.
     *
     * If you select false the other parameters of this section will be ignored. Default: false
     *
     * @schema CfnModulePropsParameters#ServersDeploy
     */
    readonly serversDeploy?: CfnModulePropsParametersServersDeploy;
    /**
     * The EC2 instance type for the web servers.
     *
     * Default: t3.micro. Allowed values: t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge
     *
     * @schema CfnModulePropsParameters#ServerInstanceType
     */
    readonly serverInstanceType?: CfnModulePropsParametersServerInstanceType;
    /**
     * The Amazon Machine Image ID of a preconfigured web server (e.g. ami-0dc7dc63).
     *
     * @schema CfnModulePropsParameters#ServerAMI
     */
    readonly serverAmi?: CfnModulePropsParametersServerAmi;
    /**
     * Set to false to create only public subnets.
     *
     * If false, the CIDR parameters for ALL private subnets will be ignored. Default: true
     *
     * @schema CfnModulePropsParameters#CreatePrivateSubnets
     */
    readonly createPrivateSubnets?: CfnModulePropsParametersCreatePrivateSubnets;
    /**
     * Set true for creating designated subnets for VPC TGW attachments.
     *
     * If false, the CIDR parameters for the TGW subnets will be ignored. Default: false
     *
     * @schema CfnModulePropsParameters#CreateTgwSubnets
     */
    readonly createTgwSubnets?: CfnModulePropsParametersCreateTgwSubnets;
    /**
     * CIDR block for TGW subnet 1 located in Availability Zone 1.
     *
     * Default: 10.0.12.0/24
     *
     * @schema CfnModulePropsParameters#TgwSubnet1CIDR
     */
    readonly tgwSubnet1Cidr?: CfnModulePropsParametersTgwSubnet1Cidr;
    /**
     * CIDR block for TGW subnet 2 located in Availability Zone 2.
     *
     * Default: 10.0.22.0/24
     *
     * @schema CfnModulePropsParameters#TgwSubnet2CIDR
     */
    readonly tgwSubnet2Cidr?: CfnModulePropsParametersTgwSubnet2Cidr;
    /**
     * CIDR block for TGW subnet 3 located in Availability Zone 3.
     *
     * Default: 10.0.32.0/24
     *
     * @schema CfnModulePropsParameters#TgwSubnet3CIDR
     */
    readonly tgwSubnet3Cidr?: CfnModulePropsParametersTgwSubnet3Cidr;
    /**
     * CIDR block for TGW subnet 4 located in Availability Zone 4.
     *
     * Default: 10.0.42.0/24
     *
     * @schema CfnModulePropsParameters#TgwSubnet4CIDR
     */
    readonly tgwSubnet4Cidr?: CfnModulePropsParametersTgwSubnet4Cidr;
    /**
     * Port for the ELB.
     *
     * Default: 8080
     *
     * @schema CfnModulePropsParameters#ELBPort
     */
    readonly elbPort?: CfnModulePropsParametersElbPort;
    /**
     * Allocate an elastic IP for the Management.
     *
     * Default: true
     *
     * @schema CfnModulePropsParameters#AllocatePublicAddress
     */
    readonly allocatePublicAddress?: CfnModulePropsParametersAllocatePublicAddress;
    /**
     * IAM role to attach to the instance profile of the Management Server.
     *
     * Default: Create with read permissions. Allowed values: None (configure later), Use existing (specify an existing IAM role name), Create with assume role permissions (specify an STS role ARN), Create with read permissions, Create with read-write permissions
     *
     * @schema CfnModulePropsParameters#ManagementPermissions
     */
    readonly managementPermissions?: CfnModulePropsParametersManagementPermissions;
    /**
     * Select 'Over the internet' if any of the gateways you wish to manage are not directly accessed via their private IP address.
     *
     * Default: 'Locally managed'. Allowed values: Locally managed, Over the internet
     *
     * @schema CfnModulePropsParameters#GatewayManagement
     */
    readonly gatewayManagement?: CfnModulePropsParametersGatewayManagement;
    /**
     * Mandatory only if deploying a secondary Management Server, the Secure Internal Communication key creates trusted connections between Check Point components.
     *
     * Choose a random string consisting of at least 8 alphanumeric characters
     *
     * @schema CfnModulePropsParameters#ManagementSICKey
     */
    readonly managementSicKey?: CfnModulePropsParametersManagementSicKey;
    /**
     * A predefined IAM role to attach to the instance profile.
     *
     * Ignored if IAM role is not set to 'Use existing'
     *
     * @schema CfnModulePropsParameters#ManagementPredefinedRole
     */
    readonly managementPredefinedRole?: CfnModulePropsParametersManagementPredefinedRole;
    /**
     * (optional).
     *
     * Default: 169.254.169.123
     *
     * @schema CfnModulePropsParameters#NTPPrimary
     */
    readonly ntpPrimary?: CfnModulePropsParametersNtpPrimary;
    /**
     * (optional).
     *
     * Default: 0.pool.ntp.org
     *
     * @schema CfnModulePropsParameters#NTPSecondary
     */
    readonly ntpSecondary?: CfnModulePropsParametersNtpSecondary;
    /**
     * (optional).
     *
     * Default: mgmt-aws
     *
     * @schema CfnModulePropsParameters#ManagementHostname
     */
    readonly managementHostname?: CfnModulePropsParametersManagementHostname;
    /**
     * Determines if this is the primary Management Server or not.
     *
     * Default: true
     *
     * @schema CfnModulePropsParameters#PrimaryManagement
     */
    readonly primaryManagement?: CfnModulePropsParametersPrimaryManagement;
    /**
     * EBS Volume size of the management server.
     *
     * @schema CfnModulePropsParameters#ManagementStackVolumeSize
     */
    readonly managementStackVolumeSize?: CfnModulePropsParametersManagementStackVolumeSize;
    /**
     * Change the admin shell to enable advanced command line configuration.
     *
     * Default: /etc/cli.sh. Allowed values: /etc/cli.sh, /bin/bash, /bin/csh, /bin/tcsh
     *
     * @schema CfnModulePropsParameters#ShellManagementStack
     */
    readonly shellManagementStack?: CfnModulePropsParametersShellManagementStack;
    /**
     * The Elasitc Load Balancer Type.
     *
     * Default: none. Allowed values: none, internal, internet-facing
     *
     * @schema CfnModulePropsParameters#ELBType
     */
    readonly elbType?: CfnModulePropsParametersElbType;
    /**
     * A list of Target Groups to associate with the Auto Scaling group (comma separated list of ARNs, without spaces) (optional).
     *
     * @schema CfnModulePropsParameters#GatewaysTargetGroups
     */
    readonly gatewaysTargetGroups?: CfnModulePropsParametersGatewaysTargetGroups;
    /**
     * Determines if the gateways are provisioned using their private or public address.
     *
     * Default: private. Allowed values: private, public
     *
     * @schema CfnModulePropsParameters#ControlGatewayOverPrivateOrPublicAddress
     */
    readonly controlGatewayOverPrivateOrPublicAddress?: CfnModulePropsParametersControlGatewayOverPrivateOrPublicAddress;
    /**
     * EBS Volume size of the security gateway server.
     *
     * @schema CfnModulePropsParameters#SecurityGatewayVolumeSize
     */
    readonly securityGatewayVolumeSize?: CfnModulePropsParametersSecurityGatewayVolumeSize;
    /**
     * Allow clients only from this network to communicate with the Web Servers.
     *
     * Default: 0.0.0.0/0
     *
     * @schema CfnModulePropsParameters#ELBClients
     */
    readonly elbClients?: CfnModulePropsParametersElbClients;
    /**
     * Change the admin shell to enable advanced command line configuration.
     *
     * Default: /etc/cli.sh. Allowed Values: /etc/cli.sh /bin/bash /bin/csh /bin/tcsh
     *
     * @schema CfnModulePropsParameters#ShellSecurityGatewayStack
     */
    readonly shellSecurityGatewayStack?: CfnModulePropsParametersShellSecurityGatewayStack;
    /**
     * IAM Permissions for the management server.
     *
     * Default: Create with read permissions. Allowed values: Create with read permissions Create with read-write permissions Create with assume role permissions (specify an STS role ARN)
     *
     * @schema CfnModulePropsParameters#Permissions
     */
    readonly permissions?: CfnModulePropsParametersPermissions;
    /**
     * The IAM role will be able to assume these STS Roles (comma separated list of ARNs, without spaces).
     *
     * @schema CfnModulePropsParameters#STSRoles
     */
    readonly stsRoles?: CfnModulePropsParametersStsRoles;
    /**
     * A 12 digits number that represents the ID of a trusted account.
     *
     * IAM users in this account will be able assume the IAM role and receive the permissions attached to it.
     *
     * @schema CfnModulePropsParameters#TrustedAccount
     */
    readonly trustedAccount?: CfnModulePropsParametersTrustedAccount;
    /**
     * An optional list of Target Groups to associate with the Auto Scaling group (comma separated list of ARNs, without spaces).
     *
     * @schema CfnModulePropsParameters#ServersTargetGroups
     */
    readonly serversTargetGroups?: CfnModulePropsParametersServersTargetGroups;
    /**
     * The ID of Security Group from which access will be allowed to the instances in this Auto Scaling group.
     *
     * @schema CfnModulePropsParameters#SourceSecurityGroup
     */
    readonly sourceSecurityGroup?: CfnModulePropsParametersSourceSecurityGroup;
    /**
     * The minimal number of servers in the Auto Scaling group.
     *
     * Default: 2
     *
     * @schema CfnModulePropsParameters#ServersMinSize
     */
    readonly serversMinSize?: CfnModulePropsParametersServersMinSize;
    /**
     * The maximal number of servers in the Auto Scaling group.
     *
     * Default: 10
     *
     * @schema CfnModulePropsParameters#ServersMaxSize
     */
    readonly serversMaxSize?: CfnModulePropsParametersServersMaxSize;
    /**
     * The servers name tag.
     *
     * Default: Server
     *
     * @schema CfnModulePropsParameters#ServerName
     */
    readonly serverName?: CfnModulePropsParametersServerName;
}
/**
 * Converts an object of type 'CfnModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnModulePropsParameters(obj: CfnModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResources
 */
export interface CfnModulePropsResources {
    /**
     * @schema CfnModulePropsResources#VPC
     */
    readonly vpc?: CfnModulePropsResourcesVpc;
    /**
     * @schema CfnModulePropsResources#InternetGateway
     */
    readonly internetGateway?: CfnModulePropsResourcesInternetGateway;
    /**
     * @schema CfnModulePropsResources#VPCGatewayAttachment
     */
    readonly vpcGatewayAttachment?: CfnModulePropsResourcesVpcGatewayAttachment;
    /**
     * @schema CfnModulePropsResources#PublicSubnet1
     */
    readonly publicSubnet1?: CfnModulePropsResourcesPublicSubnet1;
    /**
     * @schema CfnModulePropsResources#PublicSubnet2
     */
    readonly publicSubnet2?: CfnModulePropsResourcesPublicSubnet2;
    /**
     * @schema CfnModulePropsResources#PublicSubnet3
     */
    readonly publicSubnet3?: CfnModulePropsResourcesPublicSubnet3;
    /**
     * @schema CfnModulePropsResources#PublicSubnet4
     */
    readonly publicSubnet4?: CfnModulePropsResourcesPublicSubnet4;
    /**
     * @schema CfnModulePropsResources#PublicSubnetRouteTable
     */
    readonly publicSubnetRouteTable?: CfnModulePropsResourcesPublicSubnetRouteTable;
    /**
     * @schema CfnModulePropsResources#PublicSubnetRoute
     */
    readonly publicSubnetRoute?: CfnModulePropsResourcesPublicSubnetRoute;
    /**
     * @schema CfnModulePropsResources#PublicSubnet1RouteTableAssociation
     */
    readonly publicSubnet1RouteTableAssociation?: CfnModulePropsResourcesPublicSubnet1RouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PublicSubnet2RouteTableAssociation
     */
    readonly publicSubnet2RouteTableAssociation?: CfnModulePropsResourcesPublicSubnet2RouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PublicSubnet3RouteTableAssociation
     */
    readonly publicSubnet3RouteTableAssociation?: CfnModulePropsResourcesPublicSubnet3RouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PublicSubnet4RouteTableAssociation
     */
    readonly publicSubnet4RouteTableAssociation?: CfnModulePropsResourcesPublicSubnet4RouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1
     */
    readonly privateSubnet1?: CfnModulePropsResourcesPrivateSubnet1;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2
     */
    readonly privateSubnet2?: CfnModulePropsResourcesPrivateSubnet2;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet3
     */
    readonly privateSubnet3?: CfnModulePropsResourcesPrivateSubnet3;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet4
     */
    readonly privateSubnet4?: CfnModulePropsResourcesPrivateSubnet4;
    /**
     * @schema CfnModulePropsResources#TgwSubnet1
     */
    readonly tgwSubnet1?: CfnModulePropsResourcesTgwSubnet1;
    /**
     * @schema CfnModulePropsResources#TgwSubnet2
     */
    readonly tgwSubnet2?: CfnModulePropsResourcesTgwSubnet2;
    /**
     * @schema CfnModulePropsResources#TgwSubnet3
     */
    readonly tgwSubnet3?: CfnModulePropsResourcesTgwSubnet3;
    /**
     * @schema CfnModulePropsResources#TgwSubnet4
     */
    readonly tgwSubnet4?: CfnModulePropsResourcesTgwSubnet4;
    /**
     * @schema CfnModulePropsResources#ExternalALBSecurityGroup
     */
    readonly externalAlbSecurityGroup?: CfnModulePropsResourcesExternalAlbSecurityGroup;
    /**
     * @schema CfnModulePropsResources#ExternalLoadBalancer
     */
    readonly externalLoadBalancer?: CfnModulePropsResourcesExternalLoadBalancer;
    /**
     * @schema CfnModulePropsResources#ExternalLBTargetGroup
     */
    readonly externalLbTargetGroup?: CfnModulePropsResourcesExternalLbTargetGroup;
    /**
     * @schema CfnModulePropsResources#ExternalLBListener
     */
    readonly externalLbListener?: CfnModulePropsResourcesExternalLbListener;
    /**
     * @schema CfnModulePropsResources#ChkpGatewayRole
     */
    readonly chkpGatewayRole?: CfnModulePropsResourcesChkpGatewayRole;
    /**
     * @schema CfnModulePropsResources#InstanceProfileSecurityGatewayStack
     */
    readonly instanceProfileSecurityGatewayStack?: CfnModulePropsResourcesInstanceProfileSecurityGatewayStack;
    /**
     * @schema CfnModulePropsResources#NotificationTopicSecurityGatewayStack
     */
    readonly notificationTopicSecurityGatewayStack?: CfnModulePropsResourcesNotificationTopicSecurityGatewayStack;
    /**
     * @schema CfnModulePropsResources#ElasticLoadBalancer
     */
    readonly elasticLoadBalancer?: CfnModulePropsResourcesElasticLoadBalancer;
    /**
     * @schema CfnModulePropsResources#PermissiveSecurityGroup
     */
    readonly permissiveSecurityGroup?: CfnModulePropsResourcesPermissiveSecurityGroup;
    /**
     * @schema CfnModulePropsResources#GatewayGroup
     */
    readonly gatewayGroup?: CfnModulePropsResourcesGatewayGroup;
    /**
     * @schema CfnModulePropsResources#GatewayLaunchConfig
     */
    readonly gatewayLaunchConfig?: CfnModulePropsResourcesGatewayLaunchConfig;
    /**
     * @schema CfnModulePropsResources#GatewayScaleUpPolicy
     */
    readonly gatewayScaleUpPolicy?: CfnModulePropsResourcesGatewayScaleUpPolicy;
    /**
     * @schema CfnModulePropsResources#GatewayScaleDownPolicy
     */
    readonly gatewayScaleDownPolicy?: CfnModulePropsResourcesGatewayScaleDownPolicy;
    /**
     * @schema CfnModulePropsResources#CPUAlarmHighSecurityGatewayStack
     */
    readonly cpuAlarmHighSecurityGatewayStack?: CfnModulePropsResourcesCpuAlarmHighSecurityGatewayStack;
    /**
     * @schema CfnModulePropsResources#CPUAlarmLowSecurityGatewayStack
     */
    readonly cpuAlarmLowSecurityGatewayStack?: CfnModulePropsResourcesCpuAlarmLowSecurityGatewayStack;
    /**
     * @schema CfnModulePropsResources#ELBSecurityGroup
     */
    readonly elbSecurityGroup?: CfnModulePropsResourcesElbSecurityGroup;
    /**
     * @schema CfnModulePropsResources#ManagementReadyHandle
     */
    readonly managementReadyHandle?: CfnModulePropsResourcesManagementReadyHandle;
    /**
     * @schema CfnModulePropsResources#ManagementReadyCondition
     */
    readonly managementReadyCondition?: CfnModulePropsResourcesManagementReadyCondition;
    /**
     * @schema CfnModulePropsResources#ManagementSecurityGroup
     */
    readonly managementSecurityGroup?: CfnModulePropsResourcesManagementSecurityGroup;
    /**
     * @schema CfnModulePropsResources#CMEIAMRole
     */
    readonly cmeiamRole?: CfnModulePropsResourcesCmeiamRole;
    /**
     * @schema CfnModulePropsResources#InstanceProfile
     */
    readonly instanceProfile?: CfnModulePropsResourcesInstanceProfile;
    /**
     * @schema CfnModulePropsResources#ManagementInstance
     */
    readonly managementInstance?: CfnModulePropsResourcesManagementInstance;
    /**
     * @schema CfnModulePropsResources#PublicAddress
     */
    readonly publicAddress?: CfnModulePropsResourcesPublicAddress;
    /**
     * @schema CfnModulePropsResources#AddressAssoc
     */
    readonly addressAssoc?: CfnModulePropsResourcesAddressAssoc;
    /**
     * @schema CfnModulePropsResources#InternalSecurityGroup
     */
    readonly internalSecurityGroup?: CfnModulePropsResourcesInternalSecurityGroup;
    /**
     * @schema CfnModulePropsResources#InternalLBTargetGroup
     */
    readonly internalLbTargetGroup?: CfnModulePropsResourcesInternalLbTargetGroup;
    /**
     * @schema CfnModulePropsResources#InternalLoadBalancer
     */
    readonly internalLoadBalancer?: CfnModulePropsResourcesInternalLoadBalancer;
    /**
     * @schema CfnModulePropsResources#InternalLBListener
     */
    readonly internalLbListener?: CfnModulePropsResourcesInternalLbListener;
    /**
     * @schema CfnModulePropsResources#NotificationTopic
     */
    readonly notificationTopic?: CfnModulePropsResourcesNotificationTopic;
    /**
     * @schema CfnModulePropsResources#ServersSecurityGroup
     */
    readonly serversSecurityGroup?: CfnModulePropsResourcesServersSecurityGroup;
    /**
     * @schema CfnModulePropsResources#ServersLaunchConfiguration
     */
    readonly serversLaunchConfiguration?: CfnModulePropsResourcesServersLaunchConfiguration;
    /**
     * @schema CfnModulePropsResources#ServersGroup
     */
    readonly serversGroup?: CfnModulePropsResourcesServersGroup;
    /**
     * @schema CfnModulePropsResources#ScaleUpPolicy
     */
    readonly scaleUpPolicy?: CfnModulePropsResourcesScaleUpPolicy;
    /**
     * @schema CfnModulePropsResources#ScaleDownPolicy
     */
    readonly scaleDownPolicy?: CfnModulePropsResourcesScaleDownPolicy;
    /**
     * @schema CfnModulePropsResources#CPUAlarmHigh
     */
    readonly cpuAlarmHigh?: CfnModulePropsResourcesCpuAlarmHigh;
    /**
     * @schema CfnModulePropsResources#CPUAlarmLow
     */
    readonly cpuAlarmLow?: CfnModulePropsResourcesCpuAlarmLow;
}
/**
 * Converts an object of type 'CfnModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnModulePropsResources(obj: CfnModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * List of Availability Zones (AZs) to use for the subnets in the VPC.
 *
 * Select at least two
 *
 * @schema CfnModulePropsParametersAvailabilityZones
 */
export interface CfnModulePropsParametersAvailabilityZones {
    /**
     * @schema CfnModulePropsParametersAvailabilityZones#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersAvailabilityZones#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersAvailabilityZones' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersAvailabilityZones(obj: CfnModulePropsParametersAvailabilityZones | undefined): Record<string, any> | undefined;
/**
 * Number of Availability Zones to use in the VPC.
 *
 * This must match your selections in the list of Availability Zones parameter.  Default: 2
 *
 * @schema CfnModulePropsParametersNumberOfAZs
 */
export interface CfnModulePropsParametersNumberOfAZs {
    /**
     * @schema CfnModulePropsParametersNumberOfAZs#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersNumberOfAZs#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersNumberOfAZs' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersNumberOfAZs(obj: CfnModulePropsParametersNumberOfAZs | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the VPC.
 *
 * Default: 10.0.0.0/16
 *
 * @schema CfnModulePropsParametersVpccidr
 */
export interface CfnModulePropsParametersVpccidr {
    /**
     * @schema CfnModulePropsParametersVpccidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpccidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpccidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpccidr(obj: CfnModulePropsParametersVpccidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for public subnet 1 located in the 1st Availability Zone.
 *
 * If you choose to deploy a Security Management Server it will be deployed in this subnet. Default: 10.0.10.0/24
 *
 * @schema CfnModulePropsParametersPublicSubnet1Cidr
 */
export interface CfnModulePropsParametersPublicSubnet1Cidr {
    /**
     * @schema CfnModulePropsParametersPublicSubnet1Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet1Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet1Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet1Cidr(obj: CfnModulePropsParametersPublicSubnet1Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for public subnet 2 located in the 2nd Availability Zone.
 *
 * Default: 10.0.20.0/24
 *
 * @schema CfnModulePropsParametersPublicSubnet2Cidr
 */
export interface CfnModulePropsParametersPublicSubnet2Cidr {
    /**
     * @schema CfnModulePropsParametersPublicSubnet2Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet2Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet2Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet2Cidr(obj: CfnModulePropsParametersPublicSubnet2Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for public subnet 3 located in the 3rd Availability Zone.
 *
 * Default: 10.0.30.0/24
 *
 * @schema CfnModulePropsParametersPublicSubnet3Cidr
 */
export interface CfnModulePropsParametersPublicSubnet3Cidr {
    /**
     * @schema CfnModulePropsParametersPublicSubnet3Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet3Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet3Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet3Cidr(obj: CfnModulePropsParametersPublicSubnet3Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for public subnet 4 located in the 4th Availability Zone.
 *
 * Default: 10.0.40.0/24
 *
 * @schema CfnModulePropsParametersPublicSubnet4Cidr
 */
export interface CfnModulePropsParametersPublicSubnet4Cidr {
    /**
     * @schema CfnModulePropsParametersPublicSubnet4Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet4Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet4Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet4Cidr(obj: CfnModulePropsParametersPublicSubnet4Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 1 located in the 1st Availability Zone.
 *
 * Default: 10.0.11.0/24
 *
 * @schema CfnModulePropsParametersPrivateSubnet1Cidr
 */
export interface CfnModulePropsParametersPrivateSubnet1Cidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet1Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet1Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet1Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet1Cidr(obj: CfnModulePropsParametersPrivateSubnet1Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 2 located in the 2nd Availability Zone.
 *
 * Default: 10.0.21.0/24
 *
 * @schema CfnModulePropsParametersPrivateSubnet2Cidr
 */
export interface CfnModulePropsParametersPrivateSubnet2Cidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet2Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet2Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet2Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet2Cidr(obj: CfnModulePropsParametersPrivateSubnet2Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 3 located in the 3rd Availability Zone.
 *
 * Default: 10.0.31.0/24
 *
 * @schema CfnModulePropsParametersPrivateSubnet3Cidr
 */
export interface CfnModulePropsParametersPrivateSubnet3Cidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet3Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet3Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet3Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet3Cidr(obj: CfnModulePropsParametersPrivateSubnet3Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 4 located in the 4th Availability Zone.
 *
 * Default: 10.0.41.0/24
 *
 * @schema CfnModulePropsParametersPrivateSubnet4Cidr
 */
export interface CfnModulePropsParametersPrivateSubnet4Cidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet4Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet4Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet4Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet4Cidr(obj: CfnModulePropsParametersPrivateSubnet4Cidr | undefined): Record<string, any> | undefined;
/**
 * The EC2 Key Pair to allow SSH access to the instances.
 *
 * For more detail visit: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
 *
 * @schema CfnModulePropsParametersKeyName
 */
export interface CfnModulePropsParametersKeyName {
    /**
     * @schema CfnModulePropsParametersKeyName#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersKeyName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersKeyName' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersKeyName(obj: CfnModulePropsParametersKeyName | undefined): Record<string, any> | undefined;
/**
 * Encrypt Environment instances volume with default AWS KMS key.
 *
 * Default: true
 *
 * @schema CfnModulePropsParametersEnableVolumeEncryption
 */
export interface CfnModulePropsParametersEnableVolumeEncryption {
    /**
     * @schema CfnModulePropsParametersEnableVolumeEncryption#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersEnableVolumeEncryption#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersEnableVolumeEncryption' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersEnableVolumeEncryption(obj: CfnModulePropsParametersEnableVolumeEncryption | undefined): Record<string, any> | undefined;
/**
 * Enable SSH connection over AWS web console.
 *
 * Default: false
 *
 * @schema CfnModulePropsParametersEnableInstanceConnect
 */
export interface CfnModulePropsParametersEnableInstanceConnect {
    /**
     * @schema CfnModulePropsParametersEnableInstanceConnect#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersEnableInstanceConnect#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersEnableInstanceConnect' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersEnableInstanceConnect(obj: CfnModulePropsParametersEnableInstanceConnect | undefined): Record<string, any> | undefined;
/**
 * Automatically download Blade Contracts and other important data.
 *
 * Improve product experience by sending data to Check Point. Default: true
 *
 * @schema CfnModulePropsParametersAllowUploadDownload
 */
export interface CfnModulePropsParametersAllowUploadDownload {
    /**
     * @schema CfnModulePropsParametersAllowUploadDownload#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersAllowUploadDownload#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersAllowUploadDownload' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersAllowUploadDownload(obj: CfnModulePropsParametersAllowUploadDownload | undefined): Record<string, any> | undefined;
/**
 * The tag is used by the Security Management Server to automatically provision the Security Gateways.
 *
 * Must be up to 12 alphanumeric characters and unique for each Quick Start deployment. Default: quickstart
 *
 * @schema CfnModulePropsParametersProvisionTag
 */
export interface CfnModulePropsParametersProvisionTag {
    /**
     * @schema CfnModulePropsParametersProvisionTag#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersProvisionTag#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersProvisionTag' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersProvisionTag(obj: CfnModulePropsParametersProvisionTag | undefined): Record<string, any> | undefined;
/**
 * Use Network Load Balancer if you wish to preserve the source IP address and Application Load Balancer if you wish to perform SSL Offloading.
 *
 * Default: Network Load Balancer. Allowed values: Network Load Balancer, Application Load Balancer
 *
 * @schema CfnModulePropsParametersLoadBalancersType
 */
export interface CfnModulePropsParametersLoadBalancersType {
    /**
     * @schema CfnModulePropsParametersLoadBalancersType#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLoadBalancersType#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLoadBalancersType' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLoadBalancersType(obj: CfnModulePropsParametersLoadBalancersType | undefined): Record<string, any> | undefined;
/**
 * The protocol to use on the Application Load Balancer.
 *
 * If Network Load Balancer was selected this section will be ignored. Default: HTTP. Allowed values: HTTP, HTTPS
 *
 * @schema CfnModulePropsParametersAlbProtocol
 */
export interface CfnModulePropsParametersAlbProtocol {
    /**
     * @schema CfnModulePropsParametersAlbProtocol#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersAlbProtocol#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersAlbProtocol' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersAlbProtocol(obj: CfnModulePropsParametersAlbProtocol | undefined): Record<string, any> | undefined;
/**
 * The protocol to use on the Network Load Balancer.
 *
 * If Application Load Balancer was selected this section will be ignored. Default: TCP. Allowed values: TCP, TLS, UDP, TCP_UDP
 *
 * @schema CfnModulePropsParametersNlbProtocol
 */
export interface CfnModulePropsParametersNlbProtocol {
    /**
     * @schema CfnModulePropsParametersNlbProtocol#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersNlbProtocol#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersNlbProtocol' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersNlbProtocol(obj: CfnModulePropsParametersNlbProtocol | undefined): Record<string, any> | undefined;
/**
 * Amazon Resource Name (ARN) of an HTTPS Certificate, ignored if the selected protocol is HTTP (for the ALBProtocol parameter).
 *
 * @schema CfnModulePropsParametersCertificate
 */
export interface CfnModulePropsParametersCertificate {
    /**
     * @schema CfnModulePropsParametersCertificate#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCertificate#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCertificate' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCertificate(obj: CfnModulePropsParametersCertificate | undefined): Record<string, any> | undefined;
/**
 * The external Load Balancer listens to this port.
 *
 * Leave this field blank to use default ports: 80 for HTTP and 443 for HTTPS
 *
 * @schema CfnModulePropsParametersServicePort
 */
export interface CfnModulePropsParametersServicePort {
    /**
     * @schema CfnModulePropsParametersServicePort#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersServicePort#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersServicePort' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersServicePort(obj: CfnModulePropsParametersServicePort | undefined): Record<string, any> | undefined;
/**
 * Notifications about scaling events will be sent to this email address (optional).
 *
 * @schema CfnModulePropsParametersAdminEmail
 */
export interface CfnModulePropsParametersAdminEmail {
    /**
     * @schema CfnModulePropsParametersAdminEmail#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersAdminEmail#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersAdminEmail' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersAdminEmail(obj: CfnModulePropsParametersAdminEmail | undefined): Record<string, any> | undefined;
/**
 * The EC2 instance type for the Security Gateways.
 *
 * Default: c5.xlarge. Allowed values: c5.xlarge, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.18xlarge, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge
 *
 * @schema CfnModulePropsParametersGatewayInstanceType
 */
export interface CfnModulePropsParametersGatewayInstanceType {
    /**
     * @schema CfnModulePropsParametersGatewayInstanceType#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersGatewayInstanceType#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersGatewayInstanceType' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersGatewayInstanceType(obj: CfnModulePropsParametersGatewayInstanceType | undefined): Record<string, any> | undefined;
/**
 * The minimal number of Security Gateways.
 *
 * @schema CfnModulePropsParametersGatewaysMinSize
 */
export interface CfnModulePropsParametersGatewaysMinSize {
    /**
     * @schema CfnModulePropsParametersGatewaysMinSize#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersGatewaysMinSize#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersGatewaysMinSize' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersGatewaysMinSize(obj: CfnModulePropsParametersGatewaysMinSize | undefined): Record<string, any> | undefined;
/**
 * The maximal number of Security Gateways.
 *
 * @schema CfnModulePropsParametersGatewaysMaxSize
 */
export interface CfnModulePropsParametersGatewaysMaxSize {
    /**
     * @schema CfnModulePropsParametersGatewaysMaxSize#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersGatewaysMaxSize#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersGatewaysMaxSize' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersGatewaysMaxSize(obj: CfnModulePropsParametersGatewaysMaxSize | undefined): Record<string, any> | undefined;
/**
 * The version and license to install on the Security Gateways.
 *
 * Default: R80.40-PAYG-NGTP-GW. Allowed values: R80.40-BYOL-GW, R80.40-PAYG-NGTP-GW, R80.40-PAYG-NGTX-GW, R81-BYOL-GW, R81-PAYG-NGTP-GW, R81-PAYG-NGTX-GW
 *
 * @schema CfnModulePropsParametersGatewayVersion
 */
export interface CfnModulePropsParametersGatewayVersion {
    /**
     * @schema CfnModulePropsParametersGatewayVersion#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersGatewayVersion#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersGatewayVersion' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersGatewayVersion(obj: CfnModulePropsParametersGatewayVersion | undefined): Record<string, any> | undefined;
/**
 * Admin user's password hash (use command "openssl passwd -1 PASSWORD" to get the PASSWORD's hash) (optional).
 *
 * @schema CfnModulePropsParametersGatewayPasswordHash
 */
export interface CfnModulePropsParametersGatewayPasswordHash {
    /**
     * @schema CfnModulePropsParametersGatewayPasswordHash#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersGatewayPasswordHash#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersGatewayPasswordHash' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersGatewayPasswordHash(obj: CfnModulePropsParametersGatewayPasswordHash | undefined): Record<string, any> | undefined;
/**
 * The Secure Internal Communication key creates trusted connections between Check Point components.
 *
 * Choose a random string consisting of at least 8 alphanumeric characters.
 *
 * @schema CfnModulePropsParametersGatewaySicKey
 */
export interface CfnModulePropsParametersGatewaySicKey {
    /**
     * @schema CfnModulePropsParametersGatewaySicKey#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersGatewaySicKey#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersGatewaySicKey' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersGatewaySicKey(obj: CfnModulePropsParametersGatewaySicKey | undefined): Record<string, any> | undefined;
/**
 * Report Check Point specific CloudWatch metrics.
 *
 * Default: false
 *
 * @schema CfnModulePropsParametersCloudWatch
 */
export interface CfnModulePropsParametersCloudWatch {
    /**
     * @schema CfnModulePropsParametersCloudWatch#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCloudWatch#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCloudWatch' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCloudWatch(obj: CfnModulePropsParametersCloudWatch | undefined): Record<string, any> | undefined;
/**
 * Select false to use an existing Security Management Server or to deploy one later and to ignore the other parameters of this section.
 *
 * Default: true
 *
 * @schema CfnModulePropsParametersManagementDeploy
 */
export interface CfnModulePropsParametersManagementDeploy {
    /**
     * @schema CfnModulePropsParametersManagementDeploy#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersManagementDeploy#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersManagementDeploy' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersManagementDeploy(obj: CfnModulePropsParametersManagementDeploy | undefined): Record<string, any> | undefined;
/**
 * The EC2 instance type of the Security Management Server.
 *
 * Default: m5.xlarge. Allowed values: m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.12xlarge, m5.24xlarge
 *
 * @schema CfnModulePropsParametersManagementInstanceType
 */
export interface CfnModulePropsParametersManagementInstanceType {
    /**
     * @schema CfnModulePropsParametersManagementInstanceType#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersManagementInstanceType#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersManagementInstanceType' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersManagementInstanceType(obj: CfnModulePropsParametersManagementInstanceType | undefined): Record<string, any> | undefined;
/**
 * The version and license to install on the Security Management Server.
 *
 * Default: R80.40-PAYG-MGMT. Allowed values: R80.40-BYOL-MGMT, R80.40-PAYG-MGMT, R81-BYOL-MGMT, R81-PAYG-MGMT
 *
 * @schema CfnModulePropsParametersManagementVersion
 */
export interface CfnModulePropsParametersManagementVersion {
    /**
     * @schema CfnModulePropsParametersManagementVersion#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersManagementVersion#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersManagementVersion' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersManagementVersion(obj: CfnModulePropsParametersManagementVersion | undefined): Record<string, any> | undefined;
/**
 * Admin user's password hash (use command "openssl passwd -1 PASSWORD" to get the PASSWORD's hash) (optional).
 *
 * @schema CfnModulePropsParametersManagementPasswordHash
 */
export interface CfnModulePropsParametersManagementPasswordHash {
    /**
     * @schema CfnModulePropsParametersManagementPasswordHash#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersManagementPasswordHash#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersManagementPasswordHash' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersManagementPasswordHash(obj: CfnModulePropsParametersManagementPasswordHash | undefined): Record<string, any> | undefined;
/**
 * The name of the Security Policy package to be installed on the gateways in the Security Gateways Auto Scaling group.
 *
 * Default: Standard
 *
 * @schema CfnModulePropsParametersGatewaysPolicy
 */
export interface CfnModulePropsParametersGatewaysPolicy {
    /**
     * @schema CfnModulePropsParametersGatewaysPolicy#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersGatewaysPolicy#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersGatewaysPolicy' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersGatewaysPolicy(obj: CfnModulePropsParametersGatewaysPolicy | undefined): Record<string, any> | undefined;
/**
 * Turn on the Intrusion Prevention System, Application Control, Anti-Virus and Anti-Bot Blades (these and additional Blades can be manually turned on or off later).
 *
 * Default: true
 *
 * @schema CfnModulePropsParametersGatewaysBlades
 */
export interface CfnModulePropsParametersGatewaysBlades {
    /**
     * @schema CfnModulePropsParametersGatewaysBlades#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersGatewaysBlades#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersGatewaysBlades' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersGatewaysBlades(obj: CfnModulePropsParametersGatewaysBlades | undefined): Record<string, any> | undefined;
/**
 * Allow web, SSH, and graphical clients only from this network to communicate with the Security Management Server.
 *
 * @schema CfnModulePropsParametersAdminCidr
 */
export interface CfnModulePropsParametersAdminCidr {
    /**
     * @schema CfnModulePropsParametersAdminCidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersAdminCidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersAdminCidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersAdminCidr(obj: CfnModulePropsParametersAdminCidr | undefined): Record<string, any> | undefined;
/**
 * Allow gateways only from this network to communicate with the Security Management Server.
 *
 * @schema CfnModulePropsParametersGatewaysAddresses
 */
export interface CfnModulePropsParametersGatewaysAddresses {
    /**
     * @schema CfnModulePropsParametersGatewaysAddresses#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersGatewaysAddresses#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersGatewaysAddresses' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersGatewaysAddresses(obj: CfnModulePropsParametersGatewaysAddresses | undefined): Record<string, any> | undefined;
/**
 * Select true to deploy web servers and an internal Application Load Balancer.
 *
 * If you select false the other parameters of this section will be ignored. Default: false
 *
 * @schema CfnModulePropsParametersServersDeploy
 */
export interface CfnModulePropsParametersServersDeploy {
    /**
     * @schema CfnModulePropsParametersServersDeploy#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersServersDeploy#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersServersDeploy' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersServersDeploy(obj: CfnModulePropsParametersServersDeploy | undefined): Record<string, any> | undefined;
/**
 * The EC2 instance type for the web servers.
 *
 * Default: t3.micro. Allowed values: t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge
 *
 * @schema CfnModulePropsParametersServerInstanceType
 */
export interface CfnModulePropsParametersServerInstanceType {
    /**
     * @schema CfnModulePropsParametersServerInstanceType#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersServerInstanceType#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersServerInstanceType' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersServerInstanceType(obj: CfnModulePropsParametersServerInstanceType | undefined): Record<string, any> | undefined;
/**
 * The Amazon Machine Image ID of a preconfigured web server (e.g. ami-0dc7dc63).
 *
 * @schema CfnModulePropsParametersServerAmi
 */
export interface CfnModulePropsParametersServerAmi {
    /**
     * @schema CfnModulePropsParametersServerAmi#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersServerAmi#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersServerAmi' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersServerAmi(obj: CfnModulePropsParametersServerAmi | undefined): Record<string, any> | undefined;
/**
 * Set to false to create only public subnets.
 *
 * If false, the CIDR parameters for ALL private subnets will be ignored. Default: true
 *
 * @schema CfnModulePropsParametersCreatePrivateSubnets
 */
export interface CfnModulePropsParametersCreatePrivateSubnets {
    /**
     * @schema CfnModulePropsParametersCreatePrivateSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCreatePrivateSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCreatePrivateSubnets' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCreatePrivateSubnets(obj: CfnModulePropsParametersCreatePrivateSubnets | undefined): Record<string, any> | undefined;
/**
 * Set true for creating designated subnets for VPC TGW attachments.
 *
 * If false, the CIDR parameters for the TGW subnets will be ignored. Default: false
 *
 * @schema CfnModulePropsParametersCreateTgwSubnets
 */
export interface CfnModulePropsParametersCreateTgwSubnets {
    /**
     * @schema CfnModulePropsParametersCreateTgwSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCreateTgwSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCreateTgwSubnets' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCreateTgwSubnets(obj: CfnModulePropsParametersCreateTgwSubnets | undefined): Record<string, any> | undefined;
/**
 * CIDR block for TGW subnet 1 located in Availability Zone 1.
 *
 * Default: 10.0.12.0/24
 *
 * @schema CfnModulePropsParametersTgwSubnet1Cidr
 */
export interface CfnModulePropsParametersTgwSubnet1Cidr {
    /**
     * @schema CfnModulePropsParametersTgwSubnet1Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersTgwSubnet1Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersTgwSubnet1Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersTgwSubnet1Cidr(obj: CfnModulePropsParametersTgwSubnet1Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for TGW subnet 2 located in Availability Zone 2.
 *
 * Default: 10.0.22.0/24
 *
 * @schema CfnModulePropsParametersTgwSubnet2Cidr
 */
export interface CfnModulePropsParametersTgwSubnet2Cidr {
    /**
     * @schema CfnModulePropsParametersTgwSubnet2Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersTgwSubnet2Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersTgwSubnet2Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersTgwSubnet2Cidr(obj: CfnModulePropsParametersTgwSubnet2Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for TGW subnet 3 located in Availability Zone 3.
 *
 * Default: 10.0.32.0/24
 *
 * @schema CfnModulePropsParametersTgwSubnet3Cidr
 */
export interface CfnModulePropsParametersTgwSubnet3Cidr {
    /**
     * @schema CfnModulePropsParametersTgwSubnet3Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersTgwSubnet3Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersTgwSubnet3Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersTgwSubnet3Cidr(obj: CfnModulePropsParametersTgwSubnet3Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for TGW subnet 4 located in Availability Zone 4.
 *
 * Default: 10.0.42.0/24
 *
 * @schema CfnModulePropsParametersTgwSubnet4Cidr
 */
export interface CfnModulePropsParametersTgwSubnet4Cidr {
    /**
     * @schema CfnModulePropsParametersTgwSubnet4Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersTgwSubnet4Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersTgwSubnet4Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersTgwSubnet4Cidr(obj: CfnModulePropsParametersTgwSubnet4Cidr | undefined): Record<string, any> | undefined;
/**
 * Port for the ELB.
 *
 * Default: 8080
 *
 * @schema CfnModulePropsParametersElbPort
 */
export interface CfnModulePropsParametersElbPort {
    /**
     * @schema CfnModulePropsParametersElbPort#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersElbPort#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersElbPort' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersElbPort(obj: CfnModulePropsParametersElbPort | undefined): Record<string, any> | undefined;
/**
 * Allocate an elastic IP for the Management.
 *
 * Default: true
 *
 * @schema CfnModulePropsParametersAllocatePublicAddress
 */
export interface CfnModulePropsParametersAllocatePublicAddress {
    /**
     * @schema CfnModulePropsParametersAllocatePublicAddress#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersAllocatePublicAddress#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersAllocatePublicAddress' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersAllocatePublicAddress(obj: CfnModulePropsParametersAllocatePublicAddress | undefined): Record<string, any> | undefined;
/**
 * IAM role to attach to the instance profile of the Management Server.
 *
 * Default: Create with read permissions. Allowed values: None (configure later), Use existing (specify an existing IAM role name), Create with assume role permissions (specify an STS role ARN), Create with read permissions, Create with read-write permissions
 *
 * @schema CfnModulePropsParametersManagementPermissions
 */
export interface CfnModulePropsParametersManagementPermissions {
    /**
     * @schema CfnModulePropsParametersManagementPermissions#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersManagementPermissions#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersManagementPermissions' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersManagementPermissions(obj: CfnModulePropsParametersManagementPermissions | undefined): Record<string, any> | undefined;
/**
 * Select 'Over the internet' if any of the gateways you wish to manage are not directly accessed via their private IP address.
 *
 * Default: 'Locally managed'. Allowed values: Locally managed, Over the internet
 *
 * @schema CfnModulePropsParametersGatewayManagement
 */
export interface CfnModulePropsParametersGatewayManagement {
    /**
     * @schema CfnModulePropsParametersGatewayManagement#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersGatewayManagement#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersGatewayManagement' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersGatewayManagement(obj: CfnModulePropsParametersGatewayManagement | undefined): Record<string, any> | undefined;
/**
 * Mandatory only if deploying a secondary Management Server, the Secure Internal Communication key creates trusted connections between Check Point components.
 *
 * Choose a random string consisting of at least 8 alphanumeric characters
 *
 * @schema CfnModulePropsParametersManagementSicKey
 */
export interface CfnModulePropsParametersManagementSicKey {
    /**
     * @schema CfnModulePropsParametersManagementSicKey#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersManagementSicKey#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersManagementSicKey' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersManagementSicKey(obj: CfnModulePropsParametersManagementSicKey | undefined): Record<string, any> | undefined;
/**
 * A predefined IAM role to attach to the instance profile.
 *
 * Ignored if IAM role is not set to 'Use existing'
 *
 * @schema CfnModulePropsParametersManagementPredefinedRole
 */
export interface CfnModulePropsParametersManagementPredefinedRole {
    /**
     * @schema CfnModulePropsParametersManagementPredefinedRole#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersManagementPredefinedRole#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersManagementPredefinedRole' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersManagementPredefinedRole(obj: CfnModulePropsParametersManagementPredefinedRole | undefined): Record<string, any> | undefined;
/**
 * (optional).
 *
 * Default: 169.254.169.123
 *
 * @schema CfnModulePropsParametersNtpPrimary
 */
export interface CfnModulePropsParametersNtpPrimary {
    /**
     * @schema CfnModulePropsParametersNtpPrimary#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersNtpPrimary#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersNtpPrimary' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersNtpPrimary(obj: CfnModulePropsParametersNtpPrimary | undefined): Record<string, any> | undefined;
/**
 * (optional).
 *
 * Default: 0.pool.ntp.org
 *
 * @schema CfnModulePropsParametersNtpSecondary
 */
export interface CfnModulePropsParametersNtpSecondary {
    /**
     * @schema CfnModulePropsParametersNtpSecondary#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersNtpSecondary#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersNtpSecondary' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersNtpSecondary(obj: CfnModulePropsParametersNtpSecondary | undefined): Record<string, any> | undefined;
/**
 * (optional).
 *
 * Default: mgmt-aws
 *
 * @schema CfnModulePropsParametersManagementHostname
 */
export interface CfnModulePropsParametersManagementHostname {
    /**
     * @schema CfnModulePropsParametersManagementHostname#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersManagementHostname#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersManagementHostname' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersManagementHostname(obj: CfnModulePropsParametersManagementHostname | undefined): Record<string, any> | undefined;
/**
 * Determines if this is the primary Management Server or not.
 *
 * Default: true
 *
 * @schema CfnModulePropsParametersPrimaryManagement
 */
export interface CfnModulePropsParametersPrimaryManagement {
    /**
     * @schema CfnModulePropsParametersPrimaryManagement#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrimaryManagement#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrimaryManagement' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrimaryManagement(obj: CfnModulePropsParametersPrimaryManagement | undefined): Record<string, any> | undefined;
/**
 * EBS Volume size of the management server.
 *
 * @schema CfnModulePropsParametersManagementStackVolumeSize
 */
export interface CfnModulePropsParametersManagementStackVolumeSize {
    /**
     * @schema CfnModulePropsParametersManagementStackVolumeSize#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersManagementStackVolumeSize#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersManagementStackVolumeSize' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersManagementStackVolumeSize(obj: CfnModulePropsParametersManagementStackVolumeSize | undefined): Record<string, any> | undefined;
/**
 * Change the admin shell to enable advanced command line configuration.
 *
 * Default: /etc/cli.sh. Allowed values: /etc/cli.sh, /bin/bash, /bin/csh, /bin/tcsh
 *
 * @schema CfnModulePropsParametersShellManagementStack
 */
export interface CfnModulePropsParametersShellManagementStack {
    /**
     * @schema CfnModulePropsParametersShellManagementStack#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersShellManagementStack#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersShellManagementStack' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersShellManagementStack(obj: CfnModulePropsParametersShellManagementStack | undefined): Record<string, any> | undefined;
/**
 * The Elasitc Load Balancer Type.
 *
 * Default: none. Allowed values: none, internal, internet-facing
 *
 * @schema CfnModulePropsParametersElbType
 */
export interface CfnModulePropsParametersElbType {
    /**
     * @schema CfnModulePropsParametersElbType#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersElbType#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersElbType' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersElbType(obj: CfnModulePropsParametersElbType | undefined): Record<string, any> | undefined;
/**
 * A list of Target Groups to associate with the Auto Scaling group (comma separated list of ARNs, without spaces) (optional).
 *
 * @schema CfnModulePropsParametersGatewaysTargetGroups
 */
export interface CfnModulePropsParametersGatewaysTargetGroups {
    /**
     * @schema CfnModulePropsParametersGatewaysTargetGroups#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersGatewaysTargetGroups#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersGatewaysTargetGroups' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersGatewaysTargetGroups(obj: CfnModulePropsParametersGatewaysTargetGroups | undefined): Record<string, any> | undefined;
/**
 * Determines if the gateways are provisioned using their private or public address.
 *
 * Default: private. Allowed values: private, public
 *
 * @schema CfnModulePropsParametersControlGatewayOverPrivateOrPublicAddress
 */
export interface CfnModulePropsParametersControlGatewayOverPrivateOrPublicAddress {
    /**
     * @schema CfnModulePropsParametersControlGatewayOverPrivateOrPublicAddress#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersControlGatewayOverPrivateOrPublicAddress#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersControlGatewayOverPrivateOrPublicAddress' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersControlGatewayOverPrivateOrPublicAddress(obj: CfnModulePropsParametersControlGatewayOverPrivateOrPublicAddress | undefined): Record<string, any> | undefined;
/**
 * EBS Volume size of the security gateway server.
 *
 * @schema CfnModulePropsParametersSecurityGatewayVolumeSize
 */
export interface CfnModulePropsParametersSecurityGatewayVolumeSize {
    /**
     * @schema CfnModulePropsParametersSecurityGatewayVolumeSize#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersSecurityGatewayVolumeSize#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersSecurityGatewayVolumeSize' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersSecurityGatewayVolumeSize(obj: CfnModulePropsParametersSecurityGatewayVolumeSize | undefined): Record<string, any> | undefined;
/**
 * Allow clients only from this network to communicate with the Web Servers.
 *
 * Default: 0.0.0.0/0
 *
 * @schema CfnModulePropsParametersElbClients
 */
export interface CfnModulePropsParametersElbClients {
    /**
     * @schema CfnModulePropsParametersElbClients#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersElbClients#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersElbClients' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersElbClients(obj: CfnModulePropsParametersElbClients | undefined): Record<string, any> | undefined;
/**
 * Change the admin shell to enable advanced command line configuration.
 *
 * Default: /etc/cli.sh. Allowed Values: /etc/cli.sh /bin/bash /bin/csh /bin/tcsh
 *
 * @schema CfnModulePropsParametersShellSecurityGatewayStack
 */
export interface CfnModulePropsParametersShellSecurityGatewayStack {
    /**
     * @schema CfnModulePropsParametersShellSecurityGatewayStack#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersShellSecurityGatewayStack#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersShellSecurityGatewayStack' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersShellSecurityGatewayStack(obj: CfnModulePropsParametersShellSecurityGatewayStack | undefined): Record<string, any> | undefined;
/**
 * IAM Permissions for the management server.
 *
 * Default: Create with read permissions. Allowed values: Create with read permissions Create with read-write permissions Create with assume role permissions (specify an STS role ARN)
 *
 * @schema CfnModulePropsParametersPermissions
 */
export interface CfnModulePropsParametersPermissions {
    /**
     * @schema CfnModulePropsParametersPermissions#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPermissions#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPermissions' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPermissions(obj: CfnModulePropsParametersPermissions | undefined): Record<string, any> | undefined;
/**
 * The IAM role will be able to assume these STS Roles (comma separated list of ARNs, without spaces).
 *
 * @schema CfnModulePropsParametersStsRoles
 */
export interface CfnModulePropsParametersStsRoles {
    /**
     * @schema CfnModulePropsParametersStsRoles#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersStsRoles#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersStsRoles' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersStsRoles(obj: CfnModulePropsParametersStsRoles | undefined): Record<string, any> | undefined;
/**
 * A 12 digits number that represents the ID of a trusted account.
 *
 * IAM users in this account will be able assume the IAM role and receive the permissions attached to it.
 *
 * @schema CfnModulePropsParametersTrustedAccount
 */
export interface CfnModulePropsParametersTrustedAccount {
    /**
     * @schema CfnModulePropsParametersTrustedAccount#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersTrustedAccount#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersTrustedAccount' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersTrustedAccount(obj: CfnModulePropsParametersTrustedAccount | undefined): Record<string, any> | undefined;
/**
 * An optional list of Target Groups to associate with the Auto Scaling group (comma separated list of ARNs, without spaces).
 *
 * @schema CfnModulePropsParametersServersTargetGroups
 */
export interface CfnModulePropsParametersServersTargetGroups {
    /**
     * @schema CfnModulePropsParametersServersTargetGroups#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersServersTargetGroups#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersServersTargetGroups' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersServersTargetGroups(obj: CfnModulePropsParametersServersTargetGroups | undefined): Record<string, any> | undefined;
/**
 * The ID of Security Group from which access will be allowed to the instances in this Auto Scaling group.
 *
 * @schema CfnModulePropsParametersSourceSecurityGroup
 */
export interface CfnModulePropsParametersSourceSecurityGroup {
    /**
     * @schema CfnModulePropsParametersSourceSecurityGroup#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersSourceSecurityGroup#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersSourceSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersSourceSecurityGroup(obj: CfnModulePropsParametersSourceSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * The minimal number of servers in the Auto Scaling group.
 *
 * Default: 2
 *
 * @schema CfnModulePropsParametersServersMinSize
 */
export interface CfnModulePropsParametersServersMinSize {
    /**
     * @schema CfnModulePropsParametersServersMinSize#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersServersMinSize#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersServersMinSize' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersServersMinSize(obj: CfnModulePropsParametersServersMinSize | undefined): Record<string, any> | undefined;
/**
 * The maximal number of servers in the Auto Scaling group.
 *
 * Default: 10
 *
 * @schema CfnModulePropsParametersServersMaxSize
 */
export interface CfnModulePropsParametersServersMaxSize {
    /**
     * @schema CfnModulePropsParametersServersMaxSize#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersServersMaxSize#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersServersMaxSize' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersServersMaxSize(obj: CfnModulePropsParametersServersMaxSize | undefined): Record<string, any> | undefined;
/**
 * The servers name tag.
 *
 * Default: Server
 *
 * @schema CfnModulePropsParametersServerName
 */
export interface CfnModulePropsParametersServerName {
    /**
     * @schema CfnModulePropsParametersServerName#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersServerName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersServerName' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersServerName(obj: CfnModulePropsParametersServerName | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesVpc
 */
export interface CfnModulePropsResourcesVpc {
    /**
     * @schema CfnModulePropsResourcesVpc#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesVpc#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesVpc' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesVpc(obj: CfnModulePropsResourcesVpc | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesInternetGateway
 */
export interface CfnModulePropsResourcesInternetGateway {
    /**
     * @schema CfnModulePropsResourcesInternetGateway#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesInternetGateway#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesInternetGateway' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesInternetGateway(obj: CfnModulePropsResourcesInternetGateway | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesVpcGatewayAttachment
 */
export interface CfnModulePropsResourcesVpcGatewayAttachment {
    /**
     * @schema CfnModulePropsResourcesVpcGatewayAttachment#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesVpcGatewayAttachment#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesVpcGatewayAttachment' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesVpcGatewayAttachment(obj: CfnModulePropsResourcesVpcGatewayAttachment | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet1
 */
export interface CfnModulePropsResourcesPublicSubnet1 {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet1' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet1(obj: CfnModulePropsResourcesPublicSubnet1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet2
 */
export interface CfnModulePropsResourcesPublicSubnet2 {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet2' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet2(obj: CfnModulePropsResourcesPublicSubnet2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet3
 */
export interface CfnModulePropsResourcesPublicSubnet3 {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet3#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet3#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet3' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet3(obj: CfnModulePropsResourcesPublicSubnet3 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet4
 */
export interface CfnModulePropsResourcesPublicSubnet4 {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet4#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet4#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet4' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet4(obj: CfnModulePropsResourcesPublicSubnet4 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnetRouteTable
 */
export interface CfnModulePropsResourcesPublicSubnetRouteTable {
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnetRouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnetRouteTable(obj: CfnModulePropsResourcesPublicSubnetRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnetRoute
 */
export interface CfnModulePropsResourcesPublicSubnetRoute {
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnetRoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnetRoute(obj: CfnModulePropsResourcesPublicSubnetRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet1RouteTableAssociation
 */
export interface CfnModulePropsResourcesPublicSubnet1RouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet1RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet1RouteTableAssociation(obj: CfnModulePropsResourcesPublicSubnet1RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet2RouteTableAssociation
 */
export interface CfnModulePropsResourcesPublicSubnet2RouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet2RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet2RouteTableAssociation(obj: CfnModulePropsResourcesPublicSubnet2RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet3RouteTableAssociation
 */
export interface CfnModulePropsResourcesPublicSubnet3RouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet3RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet3RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet3RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet3RouteTableAssociation(obj: CfnModulePropsResourcesPublicSubnet3RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet4RouteTableAssociation
 */
export interface CfnModulePropsResourcesPublicSubnet4RouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet4RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet4RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet4RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet4RouteTableAssociation(obj: CfnModulePropsResourcesPublicSubnet4RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1
 */
export interface CfnModulePropsResourcesPrivateSubnet1 {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1(obj: CfnModulePropsResourcesPrivateSubnet1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2
 */
export interface CfnModulePropsResourcesPrivateSubnet2 {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2(obj: CfnModulePropsResourcesPrivateSubnet2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet3
 */
export interface CfnModulePropsResourcesPrivateSubnet3 {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet3#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet3' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet3(obj: CfnModulePropsResourcesPrivateSubnet3 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet4
 */
export interface CfnModulePropsResourcesPrivateSubnet4 {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet4#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet4' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet4(obj: CfnModulePropsResourcesPrivateSubnet4 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesTgwSubnet1
 */
export interface CfnModulePropsResourcesTgwSubnet1 {
    /**
     * @schema CfnModulePropsResourcesTgwSubnet1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesTgwSubnet1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesTgwSubnet1' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesTgwSubnet1(obj: CfnModulePropsResourcesTgwSubnet1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesTgwSubnet2
 */
export interface CfnModulePropsResourcesTgwSubnet2 {
    /**
     * @schema CfnModulePropsResourcesTgwSubnet2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesTgwSubnet2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesTgwSubnet2' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesTgwSubnet2(obj: CfnModulePropsResourcesTgwSubnet2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesTgwSubnet3
 */
export interface CfnModulePropsResourcesTgwSubnet3 {
    /**
     * @schema CfnModulePropsResourcesTgwSubnet3#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesTgwSubnet3#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesTgwSubnet3' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesTgwSubnet3(obj: CfnModulePropsResourcesTgwSubnet3 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesTgwSubnet4
 */
export interface CfnModulePropsResourcesTgwSubnet4 {
    /**
     * @schema CfnModulePropsResourcesTgwSubnet4#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesTgwSubnet4#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesTgwSubnet4' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesTgwSubnet4(obj: CfnModulePropsResourcesTgwSubnet4 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesExternalAlbSecurityGroup
 */
export interface CfnModulePropsResourcesExternalAlbSecurityGroup {
    /**
     * @schema CfnModulePropsResourcesExternalAlbSecurityGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesExternalAlbSecurityGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesExternalAlbSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesExternalAlbSecurityGroup(obj: CfnModulePropsResourcesExternalAlbSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesExternalLoadBalancer
 */
export interface CfnModulePropsResourcesExternalLoadBalancer {
    /**
     * @schema CfnModulePropsResourcesExternalLoadBalancer#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesExternalLoadBalancer#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesExternalLoadBalancer' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesExternalLoadBalancer(obj: CfnModulePropsResourcesExternalLoadBalancer | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesExternalLbTargetGroup
 */
export interface CfnModulePropsResourcesExternalLbTargetGroup {
    /**
     * @schema CfnModulePropsResourcesExternalLbTargetGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesExternalLbTargetGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesExternalLbTargetGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesExternalLbTargetGroup(obj: CfnModulePropsResourcesExternalLbTargetGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesExternalLbListener
 */
export interface CfnModulePropsResourcesExternalLbListener {
    /**
     * @schema CfnModulePropsResourcesExternalLbListener#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesExternalLbListener#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesExternalLbListener' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesExternalLbListener(obj: CfnModulePropsResourcesExternalLbListener | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesChkpGatewayRole
 */
export interface CfnModulePropsResourcesChkpGatewayRole {
    /**
     * @schema CfnModulePropsResourcesChkpGatewayRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesChkpGatewayRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesChkpGatewayRole' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesChkpGatewayRole(obj: CfnModulePropsResourcesChkpGatewayRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesInstanceProfileSecurityGatewayStack
 */
export interface CfnModulePropsResourcesInstanceProfileSecurityGatewayStack {
    /**
     * @schema CfnModulePropsResourcesInstanceProfileSecurityGatewayStack#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesInstanceProfileSecurityGatewayStack#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesInstanceProfileSecurityGatewayStack' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesInstanceProfileSecurityGatewayStack(obj: CfnModulePropsResourcesInstanceProfileSecurityGatewayStack | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNotificationTopicSecurityGatewayStack
 */
export interface CfnModulePropsResourcesNotificationTopicSecurityGatewayStack {
    /**
     * @schema CfnModulePropsResourcesNotificationTopicSecurityGatewayStack#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNotificationTopicSecurityGatewayStack#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNotificationTopicSecurityGatewayStack' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNotificationTopicSecurityGatewayStack(obj: CfnModulePropsResourcesNotificationTopicSecurityGatewayStack | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesElasticLoadBalancer
 */
export interface CfnModulePropsResourcesElasticLoadBalancer {
    /**
     * @schema CfnModulePropsResourcesElasticLoadBalancer#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesElasticLoadBalancer#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesElasticLoadBalancer' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesElasticLoadBalancer(obj: CfnModulePropsResourcesElasticLoadBalancer | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPermissiveSecurityGroup
 */
export interface CfnModulePropsResourcesPermissiveSecurityGroup {
    /**
     * @schema CfnModulePropsResourcesPermissiveSecurityGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPermissiveSecurityGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPermissiveSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPermissiveSecurityGroup(obj: CfnModulePropsResourcesPermissiveSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesGatewayGroup
 */
export interface CfnModulePropsResourcesGatewayGroup {
    /**
     * @schema CfnModulePropsResourcesGatewayGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesGatewayGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesGatewayGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesGatewayGroup(obj: CfnModulePropsResourcesGatewayGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesGatewayLaunchConfig
 */
export interface CfnModulePropsResourcesGatewayLaunchConfig {
    /**
     * @schema CfnModulePropsResourcesGatewayLaunchConfig#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesGatewayLaunchConfig#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesGatewayLaunchConfig' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesGatewayLaunchConfig(obj: CfnModulePropsResourcesGatewayLaunchConfig | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesGatewayScaleUpPolicy
 */
export interface CfnModulePropsResourcesGatewayScaleUpPolicy {
    /**
     * @schema CfnModulePropsResourcesGatewayScaleUpPolicy#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesGatewayScaleUpPolicy#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesGatewayScaleUpPolicy' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesGatewayScaleUpPolicy(obj: CfnModulePropsResourcesGatewayScaleUpPolicy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesGatewayScaleDownPolicy
 */
export interface CfnModulePropsResourcesGatewayScaleDownPolicy {
    /**
     * @schema CfnModulePropsResourcesGatewayScaleDownPolicy#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesGatewayScaleDownPolicy#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesGatewayScaleDownPolicy' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesGatewayScaleDownPolicy(obj: CfnModulePropsResourcesGatewayScaleDownPolicy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesCpuAlarmHighSecurityGatewayStack
 */
export interface CfnModulePropsResourcesCpuAlarmHighSecurityGatewayStack {
    /**
     * @schema CfnModulePropsResourcesCpuAlarmHighSecurityGatewayStack#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesCpuAlarmHighSecurityGatewayStack#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesCpuAlarmHighSecurityGatewayStack' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesCpuAlarmHighSecurityGatewayStack(obj: CfnModulePropsResourcesCpuAlarmHighSecurityGatewayStack | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesCpuAlarmLowSecurityGatewayStack
 */
export interface CfnModulePropsResourcesCpuAlarmLowSecurityGatewayStack {
    /**
     * @schema CfnModulePropsResourcesCpuAlarmLowSecurityGatewayStack#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesCpuAlarmLowSecurityGatewayStack#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesCpuAlarmLowSecurityGatewayStack' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesCpuAlarmLowSecurityGatewayStack(obj: CfnModulePropsResourcesCpuAlarmLowSecurityGatewayStack | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesElbSecurityGroup
 */
export interface CfnModulePropsResourcesElbSecurityGroup {
    /**
     * @schema CfnModulePropsResourcesElbSecurityGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesElbSecurityGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesElbSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesElbSecurityGroup(obj: CfnModulePropsResourcesElbSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesManagementReadyHandle
 */
export interface CfnModulePropsResourcesManagementReadyHandle {
    /**
     * @schema CfnModulePropsResourcesManagementReadyHandle#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesManagementReadyHandle#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesManagementReadyHandle' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesManagementReadyHandle(obj: CfnModulePropsResourcesManagementReadyHandle | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesManagementReadyCondition
 */
export interface CfnModulePropsResourcesManagementReadyCondition {
    /**
     * @schema CfnModulePropsResourcesManagementReadyCondition#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesManagementReadyCondition#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesManagementReadyCondition' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesManagementReadyCondition(obj: CfnModulePropsResourcesManagementReadyCondition | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesManagementSecurityGroup
 */
export interface CfnModulePropsResourcesManagementSecurityGroup {
    /**
     * @schema CfnModulePropsResourcesManagementSecurityGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesManagementSecurityGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesManagementSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesManagementSecurityGroup(obj: CfnModulePropsResourcesManagementSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesCmeiamRole
 */
export interface CfnModulePropsResourcesCmeiamRole {
    /**
     * @schema CfnModulePropsResourcesCmeiamRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesCmeiamRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesCmeiamRole' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesCmeiamRole(obj: CfnModulePropsResourcesCmeiamRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesInstanceProfile
 */
export interface CfnModulePropsResourcesInstanceProfile {
    /**
     * @schema CfnModulePropsResourcesInstanceProfile#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesInstanceProfile#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesInstanceProfile' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesInstanceProfile(obj: CfnModulePropsResourcesInstanceProfile | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesManagementInstance
 */
export interface CfnModulePropsResourcesManagementInstance {
    /**
     * @schema CfnModulePropsResourcesManagementInstance#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesManagementInstance#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesManagementInstance' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesManagementInstance(obj: CfnModulePropsResourcesManagementInstance | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicAddress
 */
export interface CfnModulePropsResourcesPublicAddress {
    /**
     * @schema CfnModulePropsResourcesPublicAddress#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicAddress#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicAddress' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicAddress(obj: CfnModulePropsResourcesPublicAddress | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesAddressAssoc
 */
export interface CfnModulePropsResourcesAddressAssoc {
    /**
     * @schema CfnModulePropsResourcesAddressAssoc#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesAddressAssoc#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesAddressAssoc' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesAddressAssoc(obj: CfnModulePropsResourcesAddressAssoc | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesInternalSecurityGroup
 */
export interface CfnModulePropsResourcesInternalSecurityGroup {
    /**
     * @schema CfnModulePropsResourcesInternalSecurityGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesInternalSecurityGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesInternalSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesInternalSecurityGroup(obj: CfnModulePropsResourcesInternalSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesInternalLbTargetGroup
 */
export interface CfnModulePropsResourcesInternalLbTargetGroup {
    /**
     * @schema CfnModulePropsResourcesInternalLbTargetGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesInternalLbTargetGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesInternalLbTargetGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesInternalLbTargetGroup(obj: CfnModulePropsResourcesInternalLbTargetGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesInternalLoadBalancer
 */
export interface CfnModulePropsResourcesInternalLoadBalancer {
    /**
     * @schema CfnModulePropsResourcesInternalLoadBalancer#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesInternalLoadBalancer#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesInternalLoadBalancer' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesInternalLoadBalancer(obj: CfnModulePropsResourcesInternalLoadBalancer | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesInternalLbListener
 */
export interface CfnModulePropsResourcesInternalLbListener {
    /**
     * @schema CfnModulePropsResourcesInternalLbListener#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesInternalLbListener#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesInternalLbListener' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesInternalLbListener(obj: CfnModulePropsResourcesInternalLbListener | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNotificationTopic
 */
export interface CfnModulePropsResourcesNotificationTopic {
    /**
     * @schema CfnModulePropsResourcesNotificationTopic#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNotificationTopic#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNotificationTopic' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNotificationTopic(obj: CfnModulePropsResourcesNotificationTopic | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesServersSecurityGroup
 */
export interface CfnModulePropsResourcesServersSecurityGroup {
    /**
     * @schema CfnModulePropsResourcesServersSecurityGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesServersSecurityGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesServersSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesServersSecurityGroup(obj: CfnModulePropsResourcesServersSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesServersLaunchConfiguration
 */
export interface CfnModulePropsResourcesServersLaunchConfiguration {
    /**
     * @schema CfnModulePropsResourcesServersLaunchConfiguration#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesServersLaunchConfiguration#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesServersLaunchConfiguration' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesServersLaunchConfiguration(obj: CfnModulePropsResourcesServersLaunchConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesServersGroup
 */
export interface CfnModulePropsResourcesServersGroup {
    /**
     * @schema CfnModulePropsResourcesServersGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesServersGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesServersGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesServersGroup(obj: CfnModulePropsResourcesServersGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesScaleUpPolicy
 */
export interface CfnModulePropsResourcesScaleUpPolicy {
    /**
     * @schema CfnModulePropsResourcesScaleUpPolicy#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesScaleUpPolicy#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesScaleUpPolicy' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesScaleUpPolicy(obj: CfnModulePropsResourcesScaleUpPolicy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesScaleDownPolicy
 */
export interface CfnModulePropsResourcesScaleDownPolicy {
    /**
     * @schema CfnModulePropsResourcesScaleDownPolicy#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesScaleDownPolicy#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesScaleDownPolicy' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesScaleDownPolicy(obj: CfnModulePropsResourcesScaleDownPolicy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesCpuAlarmHigh
 */
export interface CfnModulePropsResourcesCpuAlarmHigh {
    /**
     * @schema CfnModulePropsResourcesCpuAlarmHigh#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesCpuAlarmHigh#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesCpuAlarmHigh' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesCpuAlarmHigh(obj: CfnModulePropsResourcesCpuAlarmHigh | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesCpuAlarmLow
 */
export interface CfnModulePropsResourcesCpuAlarmLow {
    /**
     * @schema CfnModulePropsResourcesCpuAlarmLow#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesCpuAlarmLow#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesCpuAlarmLow' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesCpuAlarmLow(obj: CfnModulePropsResourcesCpuAlarmLow | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AWSQS::CheckPoint::CloudGuardQS::MODULE`.
 *
 * @external
 * @cloudformationResource AWSQS::CheckPoint::CloudGuardQS::MODULE
 * @link http://unknown-url
 */
export declare class CfnModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWSQS::CheckPoint::CloudGuardQS::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnModuleProps;
    /**
     * Create a new `AWSQS::CheckPoint::CloudGuardQS::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModuleProps);
}
